package io.quarkus.arc.test.interceptors;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;
import static org.junit.jupiter.api.Assertions.assertThrows;

import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InterceptorBinding;
import javax.interceptor.InvocationContext;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

import io.quarkus.arc.Arc;
import io.quarkus.arc.test.ArcTestContainer;

public class KotlinInterceptorTest {

    @RegisterExtension
    public ArcTestContainer container = new ArcTestContainer(Converter.class, ToUpperCaseConverter.class,
            FailingInterceptor.class, AlwaysFail.class);

    @Test
    public void testInterceptionThrowsUnwrapped() {
        ToUpperCaseConverter converter = Arc.container().instance(ToUpperCaseConverter.class).get();
        assertThrows(IOException.class, () -> converter.convert("holA!"));
    }

    interface Converter<T> {

        T convert(T value);

    }

    @AlwaysFail
    @ApplicationScoped
    @kotlin.Metadata
    static class ToUpperCaseConverter implements Converter<String> {

        @Override
        public String convert(String value) {
            return value.toUpperCase();
        }
    }

    @Target({ TYPE, METHOD })
    @Retention(RUNTIME)
    @Documented
    @InterceptorBinding
    public @interface AlwaysFail {
    }

    @AlwaysFail
    @Priority(1)
    @Interceptor
    static class FailingInterceptor {

        @AroundInvoke
        Object fail(InvocationContext ctx) throws Exception {
            throw new IOException();
        }

    }

}
