package org.jboss.resteasy.reactive.server.vertx.test.simple;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;

import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
@Produces(MediaType.TEXT_PLAIN)
public class TestWriter implements MessageBodyWriter<TestClass> {

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    @Override
    public void writeTo(TestClass t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType,
            MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream)
            throws IOException, WebApplicationException {
        if (genericType.getTypeName().equals(TestClass.class.getName())) {
            entityStream.write("WRITER".getBytes(StandardCharsets.UTF_8));
        } else {
            entityStream.write("INCORRECT GENERIC TYPE".getBytes(StandardCharsets.UTF_8));
        }
    }

}
