package io.quarkus.elasticsearch.javaclient.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.elasticsearch.javaclient.runtime.ElasticsearchJavaClientProducer;

class ElasticsearchJavaClientProcessor {

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.ELASTICSEARCH_JAVA_CLIENT);
    }

    @BuildStep
    AdditionalBeanBuildItem build() {
        return AdditionalBeanBuildItem.unremovableOf(ElasticsearchJavaClientProducer.class);
    }

    @BuildStep
    RuntimeInitializedClassBuildItem runtimeInitializedClass() {
        return new RuntimeInitializedClassBuildItem("org.elasticsearch.client.RequestOptions");
    }

    @BuildStep
    ServiceProviderBuildItem serviceProvider() {
        return new ServiceProviderBuildItem("jakarta.json.spi.JsonProvider",
                "co.elastic.clients.json.jackson.JacksonJsonProvider");
    }

    @BuildStep
    ReflectiveClassBuildItem reflectiveClass() {
        return ReflectiveClassBuildItem.builder("org.eclipse.parsson.JsonProviderImpl").build();
    }

}
