package io.quarkus.arc.test.producer.illegal;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;
import static org.junit.jupiter.api.Assertions.assertNotNull;
import static org.junit.jupiter.api.Assertions.assertTrue;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import jakarta.annotation.Priority;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.DefinitionException;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InterceptorBinding;
import jakarta.interceptor.InvocationContext;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

import io.quarkus.arc.test.ArcTestContainer;

public class ProducerFieldInInterceptorTest {

    @RegisterExtension
    public ArcTestContainer container = ArcTestContainer.builder()
            .beanClasses(BadInterceptor.class, FooBean.class, MyBinding.class).shouldFail()
            .build();

    @Test
    public void testFailure() {
        Throwable error = container.getFailure();
        assertNotNull(error);
        assertTrue(error instanceof DefinitionException);
    }

    @Interceptor
    @MyBinding
    @Priority(1)
    static class BadInterceptor {

        @AroundInvoke
        public Object aroundInvoke(InvocationContext ic) throws Exception {
            return ic.proceed();
        }

        // declaring a producer inside an interceptor should raise DefinitionException
        @Produces
        String val = "42";
    }

    @Dependent
    @MyBinding
    static class FooBean {

        public String ping() {
            return ProducerMethodInInterceptorTest.FooBean.class.getSimpleName();
        }

    }

    @Target({ TYPE, METHOD })
    @Retention(RUNTIME)
    @Documented
    @InterceptorBinding
    @interface MyBinding {

    }
}
