///usr/bin/env jbang "$0" "$@" ; exit $?

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;

public class PropertiesToRecipe {
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage: ./PropertiesToRecipe.java <properties-file>");
            System.exit(1);
        }

        Properties props = new Properties();
        try (InputStream in = new FileInputStream(args[0])) {
            props.load(in);
        }

        System.out.println("");
        System.out.println("#####");
        System.out.println("# Generated by PropertiesToRecipe.java from " + args[0]);
        System.out.println("#####");
        generateRecipe("io.quarkus.updates.core.quarkus30.JavaxToJakartaDocumentation", "**/*.adoc", props);
        generateRecipe("io.quarkus.updates.core.quarkus30.JavaxToJakartaDocumentation", "**/*.md", props);
        generateRecipe("io.quarkus.updates.core.quarkus30.JavaxToJakartaCodestarts", "**/src/main/codestarts/**/*.java", props);
        generateRecipe("io.quarkus.updates.core.quarkus30.JavaxToJakartaCodestartsTests", "**/src/test/resources/__snapshots__/**/*.java", props);
    }

    private static void generateRecipe(String name, String filesGlob, Properties props) {
        System.out.println("---");
        System.out.println("type: specs.openrewrite.org/v1beta/recipe");
        System.out.println("name: " + name);
        System.out.println("applicability:");
        System.out.println("  singleSource:");
        System.out.println("    - org.openrewrite.FindSourceFiles:");
        System.out.println("        filePattern: \"" + filesGlob + "\"");
        System.out.println("recipeList:");
        props.forEach((key, value) -> {
            System.out.println("  - org.openrewrite.text.FindAndReplace:");
            System.out.println("      find: " + key + ".");
            System.out.println("      replace: " + value + ".");
        });
    }
}
