---
layout: wide_page
title: Documentation
nav_bar_name: docs
show_comments: false
---
<div class="row">
  <div class="span4">
    <h2>High level</h2>
  </div>
  <div class="span8" markdown="1">
### [What's wrong with xUnit](/dbfit/docs/whats-wrong-with-xunit.html) <small>Why you should use DbFit.</small>

### [DbFit features](/dbfit/docs/dbfit-features.html)

### [Writing tests](/dbfit/docs/writing-tests.html) <small>What different test types look like in DbFit.</small>

  </div>
</div>

----

<div class="row">
  <div class="span4">
    <h2>The details</h2>
  </div>
  <div class="span8" markdown="1">
### [Getting started](/dbfit/docs/getting-started.html) <small>Installation and setup of DbFit.</small>

### [Command reference](/dbfit/docs/reference.html) <small>The test building blocks.</small>

### [Datatbase-specific information](/dbfit/docs/database-specific-information.html) <small>Information on adapter-specific features and peculiarities.</small>

### [FAQ and troubleshooting](/dbfit/docs/faq.html)

</div>
</div>

----

<div class="row">
  <div class="span4">
    <h2>The project</h2>
  </div>
  <div class="span8" markdown="1">

### [What's new](https://github.com/benilovj/dbfit/releases) <small>The changes in each release.</small>

### [The team behind DbFit](/dbfit/docs/the-team-behind-dbfit.html) <small>Which part of DbFit is maintained by whom.</small>

### [Contributing](https://github.com/benilovj/dbfit/blob/master/CONTRIBUTING.md) <small>Contributing code or documentation improvements to DbFit.</small>

### [DbFit: past and present](http://quickpeople.wordpress.com/2013/03/21/dbfit-the-past-and-present/) <small>A brief history of the project and its variants.</small>

</div>
</div>

----

<div class="row">
  <div class="span4">
    <h2>Useful resources</h2>
  </div>
  <div class="span8">

    <h3><a href="https://github.com/benilovj/dbfit/releases/v1.1/2429/dbfit-20080822.pdf" onclick="recordOutboundLink(this, 'Documentation', 'Manual', 'Docs');return false;">DbFit 1.1 manual</a> <small>A PDF version of the original manual.</small></h3>

    <h3><a href="http://gojko.net/FitNesse/book/" onclick="recordOutboundLink(this, 'Outbound links', 'Gojko Fitnesse Book', 'Docs');return false;">Test Driven .NET Development with FitNesse</a> <small>Gojko's free book about using FitNesse.</small></h3>

    <h3><a href="http://skillsmatter.com/podcast/agile-scrum/test-driven-data-warehouse-development" onclick="recordOutboundLink(this, 'Outbound links', 'Andy Barker talk', 'Docs');return false;">Test Driven Data Warehouse Development <small>A video of Andy Barker's talk about testing SSIS packages using FitNesse/DbFit.</small></a></h3>

    <h3><a href="http://blogs.perficient.com/businessintelligence/2012/06/07/bi-tools-testing-with-dbfit/" onclick="recordOutboundLink(this, 'Outbound links', 'Perficient blog', 'Docs');return false;">Testing with DBFit</a> <small>Short, sharp DbFit overview, plus how to integrate with SSIS.</small></h3>
  </div>

</div>
