# Rook Adopters

Below is a list of adopters of Rook in **production environments** that have publicly shared the details of their usage as well as the benefits provided by Rook that their business relies on.  There are additional adopters of Rook, especially those with on-premises deployments, that are not ready to share the details of their usage publicly at this time.

* [Pacific Research Platform (UCSD)](https://prp.ucsd.edu/) is funded by the National Science Foundation (NSF) and is described as *"the future of big data collaboration"*. Rook provides block storage on baremetal clusters with dedicated NVMEs/SSDs for fast data access by applications such as machine learning, network monitoring, image processing, and physical simulations.
* [Centre of Excellence in Next Generation Networks (CENGN)](https://www.cengn.ca) uses Rook to deploy and manage Ceph to provide block storage and shared filesystems from heterogeneous mix of nodes with high disk density, and more compute-focused nodes.
* [Informatik Computer Cloud (ICC)](https://icc.informatik.haw-hamburg.de/) at the Hamburg Univeristy of Applied Sciences to provide a seamless, fast, flexible and reliable storage service to its staff and students.
* [Gini](https://gini.net/en/) uses Ceph with Rook to provide a redundant and stable S3-compatible storage infrastructure for their services in order to provide the world's most advanced digital everyday assistant to their users.
* [Cloudways](https://www.cloudways.com/en/) utilizes the flexibility of Rook's orchestration of Ceph for their users, taking advantage of the fast I/O with block storage as well as multiple readers and writers of shared filesystem storage.
* [Crowdfox](https://www.crowdfox.com/crowdfox.html) believes in strong community projects and are therefore putting their bets on Rook.  They were able to seamlessly migrate VMs between host nodes with zero downtime thanks to Rook.
* [Radio Sound](https://radiosound.com/) uses Rook to power their website and GitLab for their CI/CD pipeline, because of the truly cloud-native experience, like *"a little drop of the Google magic in our own server rack"*.
* [CyCore Systems](https://www.cycoresys.com/)
* [Datacom](http://datacom.co.nz/Home.aspx)

There are many additional adopters of Rook in the evaluating phase that will be added to this list as they transition to production deployments.
