/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	clientset "github.com/rook/rook/pkg/client/clientset/versioned"
	cassandrav1alpha1 "github.com/rook/rook/pkg/client/clientset/versioned/typed/cassandra.rook.io/v1alpha1"
	fakecassandrav1alpha1 "github.com/rook/rook/pkg/client/clientset/versioned/typed/cassandra.rook.io/v1alpha1/fake"
	cephv1 "github.com/rook/rook/pkg/client/clientset/versioned/typed/ceph.rook.io/v1"
	fakecephv1 "github.com/rook/rook/pkg/client/clientset/versioned/typed/ceph.rook.io/v1/fake"
	cephv1beta1 "github.com/rook/rook/pkg/client/clientset/versioned/typed/ceph.rook.io/v1beta1"
	fakecephv1beta1 "github.com/rook/rook/pkg/client/clientset/versioned/typed/ceph.rook.io/v1beta1/fake"
	cockroachdbv1alpha1 "github.com/rook/rook/pkg/client/clientset/versioned/typed/cockroachdb.rook.io/v1alpha1"
	fakecockroachdbv1alpha1 "github.com/rook/rook/pkg/client/clientset/versioned/typed/cockroachdb.rook.io/v1alpha1/fake"
	edgefsv1alpha1 "github.com/rook/rook/pkg/client/clientset/versioned/typed/edgefs.rook.io/v1alpha1"
	fakeedgefsv1alpha1 "github.com/rook/rook/pkg/client/clientset/versioned/typed/edgefs.rook.io/v1alpha1/fake"
	miniov1alpha1 "github.com/rook/rook/pkg/client/clientset/versioned/typed/minio.rook.io/v1alpha1"
	fakeminiov1alpha1 "github.com/rook/rook/pkg/client/clientset/versioned/typed/minio.rook.io/v1alpha1/fake"
	nfsv1alpha1 "github.com/rook/rook/pkg/client/clientset/versioned/typed/nfs.rook.io/v1alpha1"
	fakenfsv1alpha1 "github.com/rook/rook/pkg/client/clientset/versioned/typed/nfs.rook.io/v1alpha1/fake"
	rookv1alpha2 "github.com/rook/rook/pkg/client/clientset/versioned/typed/rook.io/v1alpha2"
	fakerookv1alpha2 "github.com/rook/rook/pkg/client/clientset/versioned/typed/rook.io/v1alpha2/fake"
	"k8s.io/apimachinery/pkg/runtime"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/discovery"
	fakediscovery "k8s.io/client-go/discovery/fake"
	"k8s.io/client-go/testing"
)

// NewSimpleClientset returns a clientset that will respond with the provided objects.
// It's backed by a very simple object tracker that processes creates, updates and deletions as-is,
// without applying any validations and/or defaults. It shouldn't be considered a replacement
// for a real clientset and is mostly useful in simple unit tests.
func NewSimpleClientset(objects ...runtime.Object) *Clientset {
	o := testing.NewObjectTracker(scheme, codecs.UniversalDecoder())
	for _, obj := range objects {
		if err := o.Add(obj); err != nil {
			panic(err)
		}
	}

	cs := &Clientset{}
	cs.discovery = &fakediscovery.FakeDiscovery{Fake: &cs.Fake}
	cs.AddReactor("*", "*", testing.ObjectReaction(o))
	cs.AddWatchReactor("*", func(action testing.Action) (handled bool, ret watch.Interface, err error) {
		gvr := action.GetResource()
		ns := action.GetNamespace()
		watch, err := o.Watch(gvr, ns)
		if err != nil {
			return false, nil, err
		}
		return true, watch, nil
	})

	return cs
}

// Clientset implements clientset.Interface. Meant to be embedded into a
// struct to get a default implementation. This makes faking out just the method
// you want to test easier.
type Clientset struct {
	testing.Fake
	discovery *fakediscovery.FakeDiscovery
}

func (c *Clientset) Discovery() discovery.DiscoveryInterface {
	return c.discovery
}

var _ clientset.Interface = &Clientset{}

// CassandraV1alpha1 retrieves the CassandraV1alpha1Client
func (c *Clientset) CassandraV1alpha1() cassandrav1alpha1.CassandraV1alpha1Interface {
	return &fakecassandrav1alpha1.FakeCassandraV1alpha1{Fake: &c.Fake}
}

// Cassandra retrieves the CassandraV1alpha1Client
func (c *Clientset) Cassandra() cassandrav1alpha1.CassandraV1alpha1Interface {
	return &fakecassandrav1alpha1.FakeCassandraV1alpha1{Fake: &c.Fake}
}

// CephV1beta1 retrieves the CephV1beta1Client
func (c *Clientset) CephV1beta1() cephv1beta1.CephV1beta1Interface {
	return &fakecephv1beta1.FakeCephV1beta1{Fake: &c.Fake}
}

// CephV1 retrieves the CephV1Client
func (c *Clientset) CephV1() cephv1.CephV1Interface {
	return &fakecephv1.FakeCephV1{Fake: &c.Fake}
}

// Ceph retrieves the CephV1Client
func (c *Clientset) Ceph() cephv1.CephV1Interface {
	return &fakecephv1.FakeCephV1{Fake: &c.Fake}
}

// CockroachdbV1alpha1 retrieves the CockroachdbV1alpha1Client
func (c *Clientset) CockroachdbV1alpha1() cockroachdbv1alpha1.CockroachdbV1alpha1Interface {
	return &fakecockroachdbv1alpha1.FakeCockroachdbV1alpha1{Fake: &c.Fake}
}

// Cockroachdb retrieves the CockroachdbV1alpha1Client
func (c *Clientset) Cockroachdb() cockroachdbv1alpha1.CockroachdbV1alpha1Interface {
	return &fakecockroachdbv1alpha1.FakeCockroachdbV1alpha1{Fake: &c.Fake}
}

// EdgefsV1alpha1 retrieves the EdgefsV1alpha1Client
func (c *Clientset) EdgefsV1alpha1() edgefsv1alpha1.EdgefsV1alpha1Interface {
	return &fakeedgefsv1alpha1.FakeEdgefsV1alpha1{Fake: &c.Fake}
}

// Edgefs retrieves the EdgefsV1alpha1Client
func (c *Clientset) Edgefs() edgefsv1alpha1.EdgefsV1alpha1Interface {
	return &fakeedgefsv1alpha1.FakeEdgefsV1alpha1{Fake: &c.Fake}
}

// MinioV1alpha1 retrieves the MinioV1alpha1Client
func (c *Clientset) MinioV1alpha1() miniov1alpha1.MinioV1alpha1Interface {
	return &fakeminiov1alpha1.FakeMinioV1alpha1{Fake: &c.Fake}
}

// Minio retrieves the MinioV1alpha1Client
func (c *Clientset) Minio() miniov1alpha1.MinioV1alpha1Interface {
	return &fakeminiov1alpha1.FakeMinioV1alpha1{Fake: &c.Fake}
}

// NfsV1alpha1 retrieves the NfsV1alpha1Client
func (c *Clientset) NfsV1alpha1() nfsv1alpha1.NfsV1alpha1Interface {
	return &fakenfsv1alpha1.FakeNfsV1alpha1{Fake: &c.Fake}
}

// Nfs retrieves the NfsV1alpha1Client
func (c *Clientset) Nfs() nfsv1alpha1.NfsV1alpha1Interface {
	return &fakenfsv1alpha1.FakeNfsV1alpha1{Fake: &c.Fake}
}

// RookV1alpha2 retrieves the RookV1alpha2Client
func (c *Clientset) RookV1alpha2() rookv1alpha2.RookV1alpha2Interface {
	return &fakerookv1alpha2.FakeRookV1alpha2{Fake: &c.Fake}
}

// Rook retrieves the RookV1alpha2Client
func (c *Clientset) Rook() rookv1alpha2.RookV1alpha2Interface {
	return &fakerookv1alpha2.FakeRookV1alpha2{Fake: &c.Fake}
}
