/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1alpha1 "github.com/rook/rook/pkg/apis/edgefs.rook.io/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeS3Xs implements S3XInterface
type FakeS3Xs struct {
	Fake *FakeEdgefsV1alpha1
	ns   string
}

var s3xsResource = schema.GroupVersionResource{Group: "edgefs.rook.io", Version: "v1alpha1", Resource: "s3xs"}

var s3xsKind = schema.GroupVersionKind{Group: "edgefs.rook.io", Version: "v1alpha1", Kind: "S3X"}

// Get takes name of the s3X, and returns the corresponding s3X object, and an error if there is any.
func (c *FakeS3Xs) Get(name string, options v1.GetOptions) (result *v1alpha1.S3X, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(s3xsResource, c.ns, name), &v1alpha1.S3X{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.S3X), err
}

// List takes label and field selectors, and returns the list of S3Xs that match those selectors.
func (c *FakeS3Xs) List(opts v1.ListOptions) (result *v1alpha1.S3XList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(s3xsResource, s3xsKind, c.ns, opts), &v1alpha1.S3XList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.S3XList{ListMeta: obj.(*v1alpha1.S3XList).ListMeta}
	for _, item := range obj.(*v1alpha1.S3XList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested s3Xs.
func (c *FakeS3Xs) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(s3xsResource, c.ns, opts))

}

// Create takes the representation of a s3X and creates it.  Returns the server's representation of the s3X, and an error, if there is any.
func (c *FakeS3Xs) Create(s3X *v1alpha1.S3X) (result *v1alpha1.S3X, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(s3xsResource, c.ns, s3X), &v1alpha1.S3X{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.S3X), err
}

// Update takes the representation of a s3X and updates it. Returns the server's representation of the s3X, and an error, if there is any.
func (c *FakeS3Xs) Update(s3X *v1alpha1.S3X) (result *v1alpha1.S3X, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(s3xsResource, c.ns, s3X), &v1alpha1.S3X{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.S3X), err
}

// Delete takes name of the s3X and deletes it. Returns an error if one occurs.
func (c *FakeS3Xs) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(s3xsResource, c.ns, name), &v1alpha1.S3X{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeS3Xs) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(s3xsResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &v1alpha1.S3XList{})
	return err
}

// Patch applies the patch and returns the patched s3X.
func (c *FakeS3Xs) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.S3X, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(s3xsResource, c.ns, name, data, subresources...), &v1alpha1.S3X{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.S3X), err
}
