# Rook Adopters

Below is a list of adopters of Rook in **production environments** that have publicly shared the
details of their usage as well as the benefits provided by Rook that their business relies on. There
are additional adopters of Rook, especially those with on-premises deployments, that are not ready
to share the details of their usage publicly at this time.

* [Calit2 (California Institute for Telecommunications and Information
  Technology)](http://www.calit2.net/) is one of 4 institutes formed by a joint partnership of
  University of California and the state of California with the goal of *"inventing the university
  research environment of the future"*.  They operate one of the largest known Rook clusters in
  production and they are using Rook to provide cheap, reliable, and fast storage to scientific
  users.
* [NAV (Norwegian Labour and Welfare Administration)](https://www.nav.no/) is the current Norwegian
  public welfare agency, responsible for 1/3 of the state budget of Norway. They find a massive
  simplification of management and maintenance for their Ceph clusters by adopting Rook.
* [Replicated](https://www.replicated.com/) delivers *"SaaS On-Prem"* and are the creators of
  open-source [kURL](https://kurl.sh/): a custom Kubernetes distro creator that software vendors use
  to package and distribute production-grade Kubernetes infrastructure. Rook is a default add-on in
  kURL, so all installations include Rook to manage highly available storage that the software
  vendor can depend on.
* [Discogs](https://www.discogs.com/) is building the largest and most comprehensive music database
  and marketplace in the world and services millions of users all across the globe. Rook enables
  them to save both time and money in the long term and allows their IT operations team to function
  with fewer dedicated staff.
* [Finleap Connect](https://connect.finleap.com/) offers a full range of leading fintech solutions
  to financial institutions across Europe. Rook has been running flawlessly for them across many
  versions and upgrades, and delivers the performance and resilience they require for their most
  critical business applications.
* [Centre of Excellence in Next Generation Networks (CENGN)](https://www.cengn.ca) is on a mission
  to accelerate the growth of the Canadian Information and Communications Technology (ICT) sector.
  The Rook Ceph operator is key to the Kubernetes clusters frequently set up for projects by
  small-medium enterprises in the CENGN labs.
* [Avisi](https://www.avisi.nl/) develops and operates software for organizations like the Dutch
  Notary Association. They have survived multiple disaster scenarios already with Rook and it has
  made their cloud native journey in the private cloud so much easier by providing a powerful tool
  that lets them take advantage of a mature storage product with ease and peace of mind.
* [Geodata](https://geodata.no/) Provides geospatial services and Geographical Information Systems
  (GIS).  The latest versions of Rook have amazed them, especially compared to many of the other
  storage options they have attempted in the cloud native ecosystem.
* [Informatik Computer Cloud (ICC)](https://icc.informatik.haw-hamburg.de/) at the Hamburg
  University of Applied Sciences to provide a seamless, fast, flexible and reliable storage service
  to its staff and students.
* [Gini](https://gini.net/en/) uses Ceph with Rook to provide a redundant and stable S3-compatible
  storage infrastructure for their services in order to provide the world's most advanced digital
  everyday assistant to their users.
* [Cloudways](https://www.cloudways.com/en/) utilizes the flexibility of Rook's orchestration of
  Ceph for their users, taking advantage of the fast I/O with block storage as well as multiple
  readers and writers of shared filesystem storage.
* [Crowdfox](https://www.crowdfox.com/crowdfox.html) believes in strong community projects and are
  therefore putting their bets on Rook.  They were able to seamlessly migrate VMs between host nodes
  with zero downtime thanks to Rook.
* [Radio Sound](https://radiosound.com/) uses Rook to power their website and GitLab for their CI/CD
  pipeline, because of the truly cloud-native experience, like *"a little drop of the Google magic
  in our own server rack"*.
* [CyCore Systems](https://www.cycoresys.com/)
* [Datacom](http://datacom.co.nz/Home.aspx)
* [Turtle Network (BLACK TURTLE BVBA)](https://www.turtlenetwork.eu/#home)
* [LeanNet Ltd.](https://leannet.eu/)
* [FHE3 GmbH](https://www.fhe3.com/)
* [infraBuilder](https://infrabuilder.com/)
* [GreenCom Networks](http://www.greencom-networks.com/en)

There are many additional adopters of Rook in the evaluating phase that will be added to this list
as they transition to production deployments.
