# 欢迎使用店滴 AI

店滴AI，人脸数据的维护与挖掘，可以快速搭建基于人脸数据,软硬件交互场景业务的免费开源框架。封装了常用的表单组件、权限控制、集团化SAAS模式， 实现了模块化开发，人脸库维护、人脸智能识别、百度壁虎硬件智能控制、大数据采集的AI开源框架。

## 官方地址

##### 官方网址：[http://www.wayfirer.com/](http://www.wayfirer.com/ "http://www.wayfirer.com/")

##### 接口地址：[http://www.wayfirer.com//index.php?r=doc](http://www.wayfirer.com//index.php?r=doc "http://www.wayfirer.com//index.php?r=doc")

##### 后台代码 GIT：[https://gitee.com/wayfiretech_admin/diandi](https://gitee.com/wayfiretech_admin/diandi "https://gitee.com/wayfiretech_admin/diandi")

##### 前台uniapp框架 (https://gitee.com/wayfiretech_admin/diandi_vue)

#### 官方媒介   
- 点击链接加入群聊【店滴AI应用开源系统】：https://jq.qq.com/?_wv=1027&k=4d2Rl2lc

| qq群 ![enter image description here](https://images.gitee.com/uploads/images/2021/0324/215601_1a43562c_866769.png "qq_code.png")  | 微信公众号 ![enter image description here](https://images.gitee.com/uploads/images/2021/0324/215919_0429f2fb_866769.jpeg "wechat_code.jpg") |
|---|---|
|抖音 ![enter image description here](https://images.gitee.com/uploads/images/2021/0324/220613_f34d5210_866769.jpeg "dou_code.jpg")  | 企业微信![enter image description here](https://images.gitee.com/uploads/images/2021/0324/220531_f42a8098_866769.jpeg "qiye_code.jpg")  |

# 特性
- 使用稳定的 YII 框架，优化处理开发过程，开发体验如 tp 一样顺滑。
- 支持多层权限管控，路由权限，数据权限，菜单权限，集团权限，商户权限，扩展功能权限随意搭配调度
- 基于 swoole 协程化，定时任务调度，im 聊天环境支持，系统接口支持协程,应对高并发
- 开源百度 ai 接口对接，完成人脸库维护，人脸库创建，人脸库在线识别，人脸会员建立
- 多模块可安装，便于迅速扩展业务，支持横向纵向双向扩展业务需求
- 后台支持多种开发模式，php 混合开发，element-ui 的 vue 开发模式，纯 html 的传统开发都支持
- 表单多样，除 yii 自身的表单组件，系统还对表单做了丰富，支持一句话配置万能表单




# 环境准备：

    php>=7.2
    redis
    git 工具下载：https://git-scm.com/downloads
    composer https://www.phpcomposer.com/
    composer建议使用阿里镜像 https://developer.aliyun.com/composer

# 第一步：git 下载代码

```
git clone https://gitee.com/wayfiretech_admin/diandi.git

```

# 第二步：更新 composer 扩展

```
cd 你的文件路径
composer update

```

# 第三步：建立数据库并完成配置

```
cd common\config

vim common\config\main-local.php

```

```
<?php

/**
 * @Author: Wang Chunsheng 2192138785@qq.com
 * @Date:   2020-03-12 20:12:31
 * @Last Modified by:   Wang chunsheng  email:2192138785@qq.com
 * @Last Modified time: 2021-04-09 18:25:50
 */

return [
    'components' => [
        'db' => [
            'class' => 'yii\db\Connection',
            'dsn' => 'mysql:host=localhost;dbname=netos',
            'username' => 'root',
            'password' => 'root',
            'charset' => 'utf8',
            'attributes'  => [
                PDO::ATTR_STRINGIFY_FETCHES => false,
                PDO::ATTR_EMULATE_PREPARES  => false,
            ],
        ],
        'mailer' => [
            'class' => 'yii\swiftmailer\Mailer',
            'viewPath' => '@common/mail',
            // send all mails to a file by default. You have to set
            // 'useFileTransport' to false and configure a transport
            // for the mailer to send real emails.
            'useFileTransport' => true,
        ],
    ],
    'language' => 'zh-CN',

];


```

# Nginx 部署配置

首先解析网站到 frontend\web，然后配置 nginx 如下：

```
server {
        listen        80;
        server_name  www.ai.com;
        root   "D:/www/firetech/frontend/web";
			add_header Access-Control-Allow-Origin *;
			add_header Access-Control-Allow-Methods GET,POST,OPTIONS;
			add_header Access-Control-Allow-Headers X-Requested-With;
        location / {
            index index.php index.html error/index.html;
            error_page 400 /error/400.html;
            error_page 403 /error/403.html;
            error_page 404 /error/404.html;
            error_page 500 /error/500.html;
            error_page 501 /error/501.html;
            error_page 502 /error/502.html;
            error_page 503 /error/503.html;
            error_page 504 /error/504.html;
            error_page 505 /error/505.html;
            error_page 506 /error/506.html;
            error_page 507 /error/507.html;
            error_page 509 /error/509.html;
            error_page 510 /error/510.html;
            include D:/www/firetech/frontend/web/nginx.htaccess;
            autoindex  off;
        }
        location ~ \.php(.*)$ {
            fastcgi_pass   127.0.0.1:9001;
            fastcgi_index  index.php;
            fastcgi_split_path_info  ^((?U).+\.php)(/?.+)$;
            fastcgi_param  SCRIPT_FILENAME  $document_root$fastcgi_script_name;
            fastcgi_param  PATH_INFO  $fastcgi_path_info;
            fastcgi_param  PATH_TRANSLATED  $document_root$fastcgi_path_info;
            include        fastcgi_params;
        }
		       location /backend {
            index index.php index.html;
            if (!-e $request_filename)
            {
                rewrite ^/backend/(.*)$ /backend/index.php last;
            }
        }
        location /api {
            index index.php index.html;
            if (!-e $request_filename)
            {
                rewrite ^/api/(.*)$ /api/index.php last;
            }
            if (!-f $request_filename){
                set $rule_0 1$rule_0;
            }
        }
}


```
# 特别鸣谢

感谢以下的项目，排名不分先后

- Yii：http://www.yiiframework.com

- EasyWechat：https://www.easywechat.com

- AdminLTE：https://adminlte.io

- Vue: https://vuejs.org/

- vue-ele-form: https://github.com/dream2023/vue-ele-form

- element-ui: https://element.eleme.cn/

- 百度ai:https://ai.baidu.com/