<?php

use yii\db\Migration;

class m220613_063635_auth_item extends Migration
{
    public function up()
    {
        /* 取消外键约束 */
        $this->execute('SET foreign_key_checks = 0');
        
        /* 创建表 */
        $this->createTable('{{%auth_item}}', [
            'id' => "int(11) NOT NULL AUTO_INCREMENT",
            'name' => "varchar(64) NOT NULL",
            'is_sys' => "smallint(6) NULL DEFAULT '0' COMMENT '0否1是'",
            'permission_type' => "smallint(6) NOT NULL DEFAULT '0' COMMENT '权限属性：0route1permission2role'",
            'description' => "text NULL",
            'rule_name' => "int(11) NULL DEFAULT '0'",
            'parent_id' => "int(11) NULL",
            'permission_level' => "int(11) NULL DEFAULT '0' COMMENT '权限级别:0: 目录1: 页面 2: 按钮 3: 接口'",
            'data' => "blob NULL",
            'module_name' => "varchar(50) NULL",
            'created_at' => "int(11) NULL",
            'updated_at' => "int(11) NULL",
            'PRIMARY KEY (`id`)'
        ], "ENGINE=InnoDB  DEFAULT CHARSET=utf8");
        
        /* 索引设置 */
        $this->createIndex('rule_name','{{%auth_item}}','rule_name',0);
        $this->createIndex('type','{{%auth_item}}','permission_type',0);
        $this->createIndex('name','{{%auth_item}}','name',0);
        
        
        /* 表数据 */
        $this->insert('{{%auth_item}}',['id'=>'2','name'=>'人脸识别','is_sys'=>'1','permission_type'=>'1','description'=>NULL,'rule_name'=>NULL,'parent_id'=>'1','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1582139583','updated_at'=>'1582141300']);
        $this->insert('{{%auth_item}}',['id'=>'6','name'=>'开发示例','is_sys'=>'1','permission_type'=>'1','description'=>NULL,'rule_name'=>NULL,'parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1585611530','updated_at'=>'1585611530']);
        $this->insert('{{%auth_item}}',['id'=>'7','name'=>'扩展功能','is_sys'=>'1','permission_type'=>'1','description'=>NULL,'rule_name'=>NULL,'parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1582139605','updated_at'=>'1582139605']);
        $this->insert('{{%auth_item}}',['id'=>'8','name'=>'权限控制','is_sys'=>'1','permission_type'=>'1','description'=>NULL,'rule_name'=>NULL,'parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1582139364','updated_at'=>'1582139364']);
        $this->insert('{{%auth_item}}',['id'=>'9','name'=>'模块生成','is_sys'=>'1','permission_type'=>'1','description'=>NULL,'rule_name'=>NULL,'parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1585473562','updated_at'=>'1585473562']);
        $this->insert('{{%auth_item}}',['id'=>'10','name'=>'模块统一入口','is_sys'=>'1','permission_type'=>'1','description'=>NULL,'rule_name'=>NULL,'parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588808930','updated_at'=>'1588808930']);
        $this->insert('{{%auth_item}}',['id'=>'12','name'=>'测试实施','is_sys'=>'1','permission_type'=>'1','description'=>NULL,'rule_name'=>NULL,'parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588573267','updated_at'=>'1588573267']);
        $this->insert('{{%auth_item}}',['id'=>'13','name'=>'站点管理','is_sys'=>'1','permission_type'=>'1','description'=>NULL,'rule_name'=>NULL,'parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1582139575','updated_at'=>'1582139575']);
        $this->insert('{{%auth_item}}',['id'=>'14','name'=>'管理员管理','is_sys'=>'1','permission_type'=>'1','description'=>NULL,'rule_name'=>NULL,'parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588779477','updated_at'=>'1588779477']);
        $this->insert('{{%auth_item}}',['id'=>'15','name'=>'系统设置','is_sys'=>'1','permission_type'=>'1','description'=>NULL,'rule_name'=>NULL,'parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1582139568','updated_at'=>'1582139568']);
        $this->insert('{{%auth_item}}',['id'=>'19','name'=>'资源上传','is_sys'=>'1','permission_type'=>'1','description'=>NULL,'rule_name'=>NULL,'parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1585451956','updated_at'=>'1585451956']);
        $this->insert('{{%auth_item}}',['id'=>'29','name'=>'数据库','is_sys'=>'1','permission_type'=>'1','description'=>NULL,'rule_name'=>NULL,'parent_id'=>'15','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1592915692','updated_at'=>'1592915723']);
        $this->insert('{{%auth_item}}',['id'=>'45','name'=>'商户选择','is_sys'=>'1','permission_type'=>'1','description'=>NULL,'rule_name'=>NULL,'parent_id'=>'15','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1614077853','updated_at'=>'1614077853']);
        $this->insert('{{%auth_item}}',['id'=>'54','name'=>'站点设置','is_sys'=>'1','permission_type'=>'1','description'=>NULL,'rule_name'=>NULL,'parent_id'=>'15','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1635403574','updated_at'=>'1635403574']);
        $this->insert('{{%auth_item}}',['id'=>'4465','name'=>'settings-default-update','is_sys'=>'0','permission_type'=>'0','description'=>'描述1','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4466','name'=>'settings-default-index','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4467','name'=>'settings-default-create','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4468','name'=>'settings-default-delete','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4469','name'=>'admin-assignment-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4470','name'=>'admin-assignment-index','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4471','name'=>'admin-assignment-view','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4472','name'=>'admin-assignment-assign','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4473','name'=>'admin-assignment-revoke','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4474','name'=>'admin-assignment','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4475','name'=>'admin-default-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4476','name'=>'admin-default-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4477','name'=>'admin-default','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4478','name'=>'admin-group-error','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4479','name'=>'admin-group-index','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4480','name'=>'admin-group-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4481','name'=>'admin-group-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4482','name'=>'admin-group-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4483','name'=>'admin-group-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4484','name'=>'admin-group','is_sys'=>'0','permission_type'=>'0','description'=>'描述','rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4485','name'=>'admin-menu-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4486','name'=>'admin-menu-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4487','name'=>'admin-menu-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4488','name'=>'admin-menu-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4489','name'=>'admin-menu-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4490','name'=>'admin-menu-update-files','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4491','name'=>'admin-menu-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4492','name'=>'admin-menu','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4493','name'=>'admin-menu-top-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4494','name'=>'admin-menu-top-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4495','name'=>'admin-menu-top-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4496','name'=>'admin-menu-top-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4497','name'=>'admin-menu-top-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4498','name'=>'admin-menu-top','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4499','name'=>'admin-permission-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4500','name'=>'admin-permission-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4501','name'=>'admin-permission-create','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4502','name'=>'admin-permission-update','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4503','name'=>'admin-permission-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4504','name'=>'admin-permission-assign','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4505','name'=>'admin-permission-remove','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4506','name'=>'admin-permission','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4507','name'=>'admin-role-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4508','name'=>'admin-role-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4509','name'=>'admin-role-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4510','name'=>'admin-role-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4511','name'=>'admin-role-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4512','name'=>'admin-role-assign','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4513','name'=>'admin-role-remove','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4514','name'=>'admin-role','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4515','name'=>'admin-route-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4516','name'=>'admin-route-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4517','name'=>'admin-route-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4518','name'=>'admin-route-assign','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4519','name'=>'admin-route-remove','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4520','name'=>'admin-route-refresh','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4521','name'=>'admin-route','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4522','name'=>'admin-rule-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4523','name'=>'admin-rule-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4524','name'=>'admin-rule-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4525','name'=>'admin-rule-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4526','name'=>'admin-rule-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4527','name'=>'admin-rule-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4528','name'=>'admin-rule','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4529','name'=>'admin-user-bloc','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4530','name'=>'admin-user-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4531','name'=>'admin-user-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4532','name'=>'admin-user-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4533','name'=>'admin-user-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4534','name'=>'admin-user-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4535','name'=>'admin-user-login','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4536','name'=>'admin-user-logout','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4537','name'=>'admin-user-signup','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4538','name'=>'admin-user-request-password-reset','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4539','name'=>'admin-user-reset-password','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4540','name'=>'admin-user-change-password','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4541','name'=>'admin-user-activate','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4542','name'=>'admin-user','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4543','name'=>'admin','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4544','name'=>'modal-modal-website','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4545','name'=>'modal-modal-icons','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4546','name'=>'modal-modal','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4547','name'=>'modal','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4548','name'=>'addons-addons-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4549','name'=>'addons-addons-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4550','name'=>'addons-addons-uninstalled','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4551','name'=>'addons-addons-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4552','name'=>'addons-addons-logo','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4553','name'=>'addons-addons-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4554','name'=>'addons-addons-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4555','name'=>'addons-addons-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4556','name'=>'addons-addons','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4557','name'=>'addons-manage-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4558','name'=>'addons-manage-install','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4559','name'=>'addons-manage-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4560','name'=>'addons-manage-uninstall','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4561','name'=>'addons-manage-auth','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4562','name'=>'addons-manage','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4563','name'=>'addons-menu-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4564','name'=>'addons-menu-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4565','name'=>'addons-menu-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4566','name'=>'addons-menu-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4567','name'=>'addons-menu-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4568','name'=>'addons-menu-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4569','name'=>'addons-menu','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4570','name'=>'addons','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4571','name'=>'gii-default-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4572','name'=>'gii-default-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4573','name'=>'gii-default-preview','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4574','name'=>'gii-default-diff','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4575','name'=>'gii-default-action','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4576','name'=>'gii-default','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4577','name'=>'gii','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4604','name'=>'base-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4605','name'=>'base','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4606','name'=>'module-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4607','name'=>'module-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4608','name'=>'module','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4609','name'=>'site-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4610','name'=>'site-index','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4611','name'=>'site-login','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4612','name'=>'site-logout','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4613','name'=>'site-signup','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4614','name'=>'site-request-password-reset','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4615','name'=>'site-reset-password','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4616','name'=>'site-verify-email','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4617','name'=>'site-resend-verification-email','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4618','name'=>'site','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4619','name'=>'article-dd-article-category-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4620','name'=>'article-dd-article-category-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4621','name'=>'article-dd-article-category-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4622','name'=>'article-dd-article-category-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4623','name'=>'article-dd-article-category-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4624','name'=>'article-dd-article-category-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4625','name'=>'article-dd-article-category-childcate','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4626','name'=>'article-dd-article-category','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4627','name'=>'article-dd-article-upload','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4628','name'=>'article-dd-article-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4629','name'=>'article-dd-article-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4630','name'=>'article-dd-article-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4631','name'=>'article-dd-article-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4632','name'=>'article-dd-article-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4633','name'=>'article-dd-article','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4634','name'=>'article-record-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4635','name'=>'article-record-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4636','name'=>'article-record-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4637','name'=>'article-record-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4638','name'=>'article-record-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4639','name'=>'article-record','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4640','name'=>'demo-form-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4641','name'=>'demo-form-get-region','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4642','name'=>'demo-form-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4643','name'=>'demo-form-maile','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4644','name'=>'demo-form','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4645','name'=>'member-dd-member-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4646','name'=>'member-dd-member-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4647','name'=>'member-dd-member-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4648','name'=>'member-dd-member-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4649','name'=>'member-dd-member-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4650','name'=>'member-dd-member-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4651','name'=>'member-dd-member','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4652','name'=>'member-dd-member-group-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4653','name'=>'member-dd-member-group-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4654','name'=>'member-dd-member-group-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4655','name'=>'member-dd-member-group-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4656','name'=>'member-dd-member-group-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4657','name'=>'member-dd-member-group-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4658','name'=>'member-dd-member-group','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4659','name'=>'system-index-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4660','name'=>'system-index-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4661','name'=>'system-index-childcate','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4662','name'=>'system-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4663','name'=>'system-settings-baidu','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4664','name'=>'system-settings-wxapp','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4665','name'=>'system-settings-wechatpay','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4666','name'=>'system-settings-sms','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4667','name'=>'system-settings-email','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4668','name'=>'system-settings-clear-cache','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4669','name'=>'system-settings','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4670','name'=>'system-welcome-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4671','name'=>'system-welcome-index','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4672','name'=>'system-welcome-sysai','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4673','name'=>'system-welcome-member','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4674','name'=>'system-welcome-aimember','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4675','name'=>'system-welcome-goods','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4676','name'=>'system-welcome-marketing','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4677','name'=>'system-welcome-order','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4678','name'=>'system-welcome-wxapp','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4679','name'=>'system-welcome-plugins','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4680','name'=>'system-welcome-system','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4681','name'=>'system-welcome','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4682','name'=>'upload-upload-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4683','name'=>'upload-upload-uploadimg','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4684','name'=>'upload-upload-uploadfile','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4685','name'=>'upload-upload','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4686','name'=>'user-dd-user-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4687','name'=>'user-dd-user-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4688','name'=>'user-dd-user-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4689','name'=>'user-dd-user-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4690','name'=>'user-dd-user-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4691','name'=>'user-dd-user-profile','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4692','name'=>'user-dd-user-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4693','name'=>'user-dd-user','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4694','name'=>'website-dd-website-contact-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4695','name'=>'website-dd-website-contact-index','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4696','name'=>'website-dd-website-contact-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4697','name'=>'website-dd-website-contact-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4698','name'=>'website-dd-website-contact-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4699','name'=>'website-dd-website-contact-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4700','name'=>'website-dd-website-contact','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4701','name'=>'website-dd-website-slide-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4702','name'=>'website-dd-website-slide-index','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4703','name'=>'website-dd-website-slide-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4704','name'=>'website-dd-website-slide-create','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4705','name'=>'website-dd-website-slide-update','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4706','name'=>'website-dd-website-slide-delete','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4707','name'=>'website-dd-website-slide','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4708','name'=>'website-setting-website','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4709','name'=>'website-setting','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4710','name'=>'*','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4711','name'=>'admin-group-assign','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4712','name'=>'admin-group-remove','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4720','name'=>'system-settings-map','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4721','name'=>'system-settings-set-cache','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4722','name'=>'settings-default','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4723','name'=>'diandi-gathergoods-ceshi-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4724','name'=>'diandi-gathergoods-ceshi-py','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4725','name'=>'diandi-gathergoods-ceshi','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4726','name'=>'diandi-gathergoods-jingd','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4727','name'=>'diandi-gathergoods-ceshi-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4728','name'=>'diandi-gathergoods-tao','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4729','name'=>'gii-addons','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4730','name'=>'diandi-aggregate-default-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4731','name'=>'diandi-aggregate-default-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4732','name'=>'diandi-aggregate-default','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4733','name'=>'diandi-aggregate','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4734','name'=>'diandi-aggregate-set-config-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4735','name'=>'diandi-aggregate-set-config-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4736','name'=>'diandi-aggregate-set-config-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4737','name'=>'diandi-aggregate-set-config-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4738','name'=>'diandi-aggregate-set-config-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4739','name'=>'diandi-aggregate-set-config','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4740','name'=>'diandi-aggregate-set-config-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4741','name'=>'diandi-distribution-conf-price-conf-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4742','name'=>'diandi-distribution-goods-gift-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4743','name'=>'diandi-distribution-goods-goods-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4744','name'=>'diandi-distribution-goods-goods-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4745','name'=>'diandi-distribution-goods-goods-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4746','name'=>'diandi-distribution-goods-goods-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4747','name'=>'diandi-distribution-goods-goods-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4748','name'=>'diandi-distribution-goods-goods-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4749','name'=>'diandi-pro-default-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4750','name'=>'diandi-pro-default-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4751','name'=>'diandi-pro-default','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4752','name'=>'diandi-pro-goods-category-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4753','name'=>'diandi-pro-goods-category-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4754','name'=>'diandi-pro-goods-category-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4755','name'=>'diandi-pro-goods-category-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4756','name'=>'diandi-pro-goods-category-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4757','name'=>'diandi-pro-goods-category-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4758','name'=>'diandi-pro-goods-category','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4759','name'=>'diandi-pro-goods-goods-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4760','name'=>'diandi-pro-goods-goods-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4761','name'=>'diandi-pro-goods-goods-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4762','name'=>'diandi-pro-goods-goods-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4763','name'=>'diandi-pro-goods-goods-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4764','name'=>'diandi-pro-goods-goods-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4765','name'=>'diandi-pro-goods-goods','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4766','name'=>'diandi-pro-goods-param-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4767','name'=>'diandi-pro-goods-param-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4768','name'=>'diandi-pro-goods-param-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4769','name'=>'diandi-pro-goods-param-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4770','name'=>'diandi-pro-goods-param-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4771','name'=>'diandi-pro-goods-param-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4772','name'=>'diandi-pro-goods-param','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4773','name'=>'diandi-pro-goods-specrel-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4774','name'=>'diandi-pro-goods-specrel-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4775','name'=>'diandi-pro-goods-specrel-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4776','name'=>'diandi-pro-goods-specrel-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4777','name'=>'diandi-pro-goods-specrel-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4778','name'=>'diandi-pro-goods-specrel-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4779','name'=>'diandi-pro-goods-specrel','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4780','name'=>'diandi-pro-template-param-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4781','name'=>'diandi-pro-template-param-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4782','name'=>'diandi-pro-template-param-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4783','name'=>'diandi-pro-template-param-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4784','name'=>'diandi-pro-template-param-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4785','name'=>'diandi-pro-template-param-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4786','name'=>'diandi-pro-template-param','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4787','name'=>'diandi-pro-template-pro-template-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4788','name'=>'diandi-pro-template-pro-template-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4789','name'=>'diandi-pro-template-pro-template-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4790','name'=>'diandi-pro-template-pro-template-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4791','name'=>'diandi-pro-template-pro-template-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4792','name'=>'diandi-pro-template-pro-template-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4793','name'=>'diandi-pro-template-pro-template','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4794','name'=>'diandi-pro','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4795','name'=>'diandi-pro-goods-category-getlist','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4796','name'=>'diandi-pro-template-specrel-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4797','name'=>'diandi-pro-template-specrel-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4798','name'=>'diandi-pro-template-specrel-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4799','name'=>'diandi-pro-template-specrel-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4800','name'=>'diandi-pro-template-specrel-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4801','name'=>'diandi-pro-template-specrel-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4802','name'=>'diandi-pro-template-specrel','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4803','name'=>'diandi-pro-template-template-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4804','name'=>'diandi-pro-template-template-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4805','name'=>'diandi-pro-template-template-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4806','name'=>'diandi-pro-template-template-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4807','name'=>'diandi-pro-template-template-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4808','name'=>'diandi-pro-template-template-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4809','name'=>'diandi-pro-template-template','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4810','name'=>'diandi-pro-goods-goods-getlist','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4811','name'=>'system-database','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4812','name'=>'system-database-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4813','name'=>'system-database-backups','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4814','name'=>'system-database-export','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4815','name'=>'system-database-export-start','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4816','name'=>'system-database-optimize','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4817','name'=>'system-database-repair','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4818','name'=>'system-database-restore','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4819','name'=>'system-database-restore-init','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4820','name'=>'system-database-restore-start','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4821','name'=>'system-database-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4822','name'=>'system-database-data-dictionary','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4823','name'=>'system-database-backlist','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4824','name'=>'diandi-distribution-goods-location-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4825','name'=>'diandi-distribution-goods-location-goods-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4826','name'=>'diandi-distribution-conf-slide-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4827','name'=>'ds','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4828','name'=>'debug-default-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4829','name'=>'debug','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4830','name'=>'settings-default-edit-setting','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4831','name'=>'debug-default-db-explain','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4832','name'=>'debug-default-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4833','name'=>'debug-default-toolbar','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4834','name'=>'debug-default-download-mail','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4835','name'=>'debug-default','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4836','name'=>'debug-user-set-identity','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4837','name'=>'debug-user-reset-identity','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4838','name'=>'debug-user','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4839','name'=>'diandi-operator-default-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4840','name'=>'diandi-operator-default-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4841','name'=>'diandi-operator-default','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4842','name'=>'diandi-operator','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4843','name'=>'diandi-video-category-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4844','name'=>'diandi-video-category-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4845','name'=>'diandi-video-category-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4846','name'=>'diandi-video-category-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4847','name'=>'diandi-video-category-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4848','name'=>'diandi-video-category-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4849','name'=>'diandi-video-category','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4850','name'=>'diandi-video-default-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4851','name'=>'diandi-video-default-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4852','name'=>'diandi-video-default','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4853','name'=>'diandi-video-list-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4854','name'=>'diandi-video-list-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4855','name'=>'diandi-video-list-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4856','name'=>'diandi-video-list-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4857','name'=>'diandi-video-list-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4858','name'=>'diandi-video-list-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4859','name'=>'diandi-video-list','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4860','name'=>'diandi-video-slide-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4861','name'=>'diandi-video-slide-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4862','name'=>'diandi-video-slide-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4863','name'=>'diandi-video-slide-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4864','name'=>'diandi-video-slide-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4865','name'=>'diandi-video-slide-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4866','name'=>'diandi-video-slide','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4867','name'=>'diandi-video-store-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4868','name'=>'diandi-video-store-get-region','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4869','name'=>'diandi-video-store-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4870','name'=>'diandi-video-store-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4871','name'=>'diandi-video-store-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4872','name'=>'diandi-video-store-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4873','name'=>'diandi-video-store-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4874','name'=>'diandi-video-store','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4875','name'=>'diandi-video','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4876','name'=>'site-setpassword','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4877','name'=>'admin-user-assign','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4878','name'=>'admin-user-remove','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4879','name'=>'diandi-shop-wxapp-dd-wxapp-page-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4880','name'=>'diandi-shop-wxapp-dd-wxapp-page-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4881','name'=>'diandi-shop-wxapp-dd-wxapp-page-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4882','name'=>'diandi-shop-wxapp-dd-wxapp-page-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4883','name'=>'diandi-shop-wxapp-dd-wxapp-page-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4884','name'=>'diandi-distribution-goods-goods-attribute','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4885','name'=>'diandi-distribution-goods-goods-postdata','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4886','name'=>'diandi-distribution-goods-goods-detail','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4887','name'=>'diandi-distribution-goods-goods-gethtml','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4888','name'=>'diandi-distribution-goods-goods-goodslist','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4889','name'=>'diandi-distribution-goods-goods-spechtml','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4890','name'=>'diandi-video-list-upload','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4891','name'=>'diandi-video-list-list','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4892','name'=>'diandi-video-list-config','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4893','name'=>'diandi-video-list-videolist','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4894','name'=>'diandi-video-slide-videolist','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4895','name'=>'diandi-video-store-upload','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4896','name'=>'diandi-operator-ceshi-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4897','name'=>'diandi-operator-ceshi-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4898','name'=>'diandi-operator-ceshi','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4899','name'=>'diandi-store-record-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4900','name'=>'diandi-store-record-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4901','name'=>'diandi-store-record-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4902','name'=>'diandi-store-record-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4903','name'=>'diandi-store-record-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4904','name'=>'diandi-store-record-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4905','name'=>'diandi-store-record','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4906','name'=>'diandi-store-store-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4907','name'=>'diandi-store-store-get-region','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4908','name'=>'diandi-store-store-setting','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4909','name'=>'diandi-store-store-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4910','name'=>'diandi-store-store-adds','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4911','name'=>'diandi-store-store-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4912','name'=>'diandi-store-store-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4913','name'=>'diandi-store-store-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4914','name'=>'diandi-store-store-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4915','name'=>'diandi-store-store','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4916','name'=>'diandi-store-store-seat-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4917','name'=>'diandi-store-store-seat-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4918','name'=>'diandi-store-store-seat-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4919','name'=>'diandi-store-store-seat-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4920','name'=>'diandi-store-store-seat-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4921','name'=>'diandi-store-store-seat-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4922','name'=>'diandi-store-store-seat','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4923','name'=>'diandi-store-store-service-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4924','name'=>'diandi-store-store-service-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4925','name'=>'diandi-store-store-service-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4926','name'=>'diandi-store-store-service-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4927','name'=>'diandi-store-store-service-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4928','name'=>'diandi-store-store-service-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4929','name'=>'diandi-store-store-service','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4930','name'=>'diandi-store-store-share-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4931','name'=>'diandi-store-store-share-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4932','name'=>'diandi-store-store-share-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4933','name'=>'diandi-store-store-share-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4934','name'=>'diandi-store-store-share-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4935','name'=>'diandi-store-store-share-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4936','name'=>'diandi-store-store-share','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4937','name'=>'diandi-store-store-slide-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4938','name'=>'diandi-store-store-slide-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4939','name'=>'diandi-store-store-slide-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4940','name'=>'diandi-store-store-slide-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4941','name'=>'diandi-store-store-slide-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4942','name'=>'diandi-store-store-slide-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4943','name'=>'diandi-store-store-slide','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4944','name'=>'diandi-operator-bloc-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4945','name'=>'diandi-operator-bloc-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4946','name'=>'diandi-operator-bloc-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4947','name'=>'diandi-operator-bloc-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4948','name'=>'diandi-operator-bloc-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4949','name'=>'diandi-operator-bloc-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4950','name'=>'diandi-operator-bloc','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4951','name'=>'diandi-operator-cardlist-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4952','name'=>'diandi-operator-cardlist-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4953','name'=>'diandi-operator-cardlist-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4954','name'=>'diandi-operator-cardlist-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4955','name'=>'diandi-operator-cardlist-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4956','name'=>'diandi-operator-cardlist-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4957','name'=>'diandi-operator-cardlist','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4958','name'=>'diandi-operator-cardlistcancel-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4959','name'=>'diandi-operator-cardlistcancel-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4960','name'=>'diandi-operator-cardlistcancel-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4961','name'=>'diandi-operator-cardlistcancel-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4962','name'=>'diandi-operator-cardlistcancel-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4963','name'=>'diandi-operator-cardlistcancel-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4964','name'=>'diandi-operator-cardlistcancel','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4965','name'=>'diandi-operator-cardloseefficacy-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4966','name'=>'diandi-operator-cardloseefficacy-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4967','name'=>'diandi-operator-cardloseefficacy-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4968','name'=>'diandi-operator-cardloseefficacy-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4969','name'=>'diandi-operator-cardloseefficacy-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4970','name'=>'diandi-operator-cardloseefficacy-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4971','name'=>'diandi-operator-cardloseefficacy','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4972','name'=>'diandi-operator-change-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4973','name'=>'diandi-operator-change-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4974','name'=>'diandi-operator-change-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4975','name'=>'diandi-operator-change-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4976','name'=>'diandi-operator-change-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4977','name'=>'diandi-operator-change-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4978','name'=>'diandi-operator-change','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4979','name'=>'diandi-operator-operator-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4980','name'=>'diandi-operator-operator-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4981','name'=>'diandi-operator-operator-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4982','name'=>'diandi-operator-operator-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4983','name'=>'diandi-operator-operator-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4984','name'=>'diandi-operator-operator-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4985','name'=>'diandi-operator-operator','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4986','name'=>'diandi-operator-order-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4987','name'=>'diandi-operator-order-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4988','name'=>'diandi-operator-order-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4989','name'=>'diandi-operator-order-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4990','name'=>'diandi-operator-order-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4991','name'=>'diandi-operator-order-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4992','name'=>'diandi-operator-order','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4993','name'=>'diandi-operator-transfer-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4994','name'=>'diandi-operator-transfer-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4995','name'=>'diandi-operator-transfer-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4996','name'=>'diandi-operator-transfer-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4997','name'=>'diandi-operator-transfer-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4998','name'=>'diandi-operator-transfer-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'4999','name'=>'diandi-operator-transfer','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5000','name'=>'diandi-operator-withdraw-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5001','name'=>'diandi-operator-withdraw-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5002','name'=>'diandi-operator-withdraw-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5003','name'=>'diandi-operator-withdraw-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5004','name'=>'diandi-operator-withdraw-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5005','name'=>'diandi-operator-withdraw-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5006','name'=>'diandi-operator-withdraw','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5007','name'=>'diandi-operator-bloc-detail','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5008','name'=>'diandi-operator-bloc-blocs','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5009','name'=>'diandi-operator-cardreal-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5010','name'=>'diandi-operator-cardreal-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5011','name'=>'diandi-operator-cardreal-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5012','name'=>'diandi-operator-cardreal-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5013','name'=>'diandi-operator-cardreal-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5014','name'=>'diandi-operator-cardreal-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5015','name'=>'diandi-operator-cardreal','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5016','name'=>'diandi-operator-clientreal-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5017','name'=>'diandi-operator-clientreal-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5018','name'=>'diandi-operator-clientreal-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5019','name'=>'diandi-operator-clientreal-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5020','name'=>'diandi-operator-clientreal-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5021','name'=>'diandi-operator-clientreal-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5022','name'=>'diandi-operator-clientreal','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5023','name'=>'diandi-operator-channel-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5024','name'=>'diandi-operator-channel-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5025','name'=>'diandi-operator-channel-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5026','name'=>'diandi-operator-channel-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5027','name'=>'diandi-operator-channel-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5028','name'=>'diandi-operator-channel-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5029','name'=>'diandi-operator-channel','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5030','name'=>'diandi-operator-meallist-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5031','name'=>'diandi-operator-meallist-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5032','name'=>'diandi-operator-meallist-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5033','name'=>'diandi-operator-meallist-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5034','name'=>'diandi-operator-meallist-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5035','name'=>'diandi-operator-meallist-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5036','name'=>'diandi-operator-meallist','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5037','name'=>'diandi-operator-setmeal-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5038','name'=>'diandi-operator-setmeal-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5039','name'=>'diandi-operator-setmeal-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5040','name'=>'diandi-operator-setmeal-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5041','name'=>'diandi-operator-setmeal-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5042','name'=>'diandi-operator-setmeal-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5043','name'=>'diandi-operator-setmeal','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5044','name'=>'diandi-operator-pretreatment-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5045','name'=>'diandi-operator-pretreatment-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5046','name'=>'diandi-operator-pretreatment-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5047','name'=>'diandi-operator-pretreatment-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5048','name'=>'diandi-operator-pretreatment-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5049','name'=>'diandi-operator-pretreatment-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5050','name'=>'diandi-operator-pretreatment','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5051','name'=>'diandi-operator-user-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5052','name'=>'diandi-operator-user-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5053','name'=>'diandi-operator-user-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5054','name'=>'diandi-operator-user-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5055','name'=>'diandi-operator-user-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5056','name'=>'diandi-operator-user-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5057','name'=>'diandi-operator-user','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5058','name'=>'diandi-operator-pond-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5059','name'=>'diandi-operator-pond-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5060','name'=>'diandi-operator-pond-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5061','name'=>'diandi-operator-pond-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5062','name'=>'diandi-operator-pond-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5063','name'=>'diandi-operator-pond-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5064','name'=>'diandi-operator-pond','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5065','name'=>'diandi-operator-pondwarning-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5066','name'=>'diandi-operator-pondwarning-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5067','name'=>'diandi-operator-pondwarning-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5068','name'=>'diandi-operator-pondwarning-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5069','name'=>'diandi-operator-pondwarning-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5070','name'=>'diandi-operator-pondwarning-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5071','name'=>'diandi-operator-pondwarning','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5072','name'=>'diandi-operator-allocation-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5073','name'=>'diandi-operator-allocation-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5074','name'=>'diandi-operator-allocation-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5075','name'=>'diandi-operator-allocation-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5076','name'=>'diandi-operator-allocation-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5077','name'=>'diandi-operator-allocation-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5078','name'=>'diandi-operator-allocation','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5079','name'=>'diandi-operator-statistics-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5080','name'=>'diandi-operator-statistics-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5081','name'=>'diandi-operator-statistics-activate','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5082','name'=>'diandi-operator-statistics-flux','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5083','name'=>'diandi-operator-statistics-trade','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5084','name'=>'diandi-operator-statistics','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5085','name'=>'diandi-operator-statistics-client','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5086','name'=>'diandi-operator-config-chinamobile','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5087','name'=>'diandi-operator-config-onelink','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5088','name'=>'diandi-operator-config-telecom','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5089','name'=>'diandi-operator-config-clear-cache','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5090','name'=>'diandi-operator-config-set-cache','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5091','name'=>'diandi-operator-config','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5172','name'=>'member-dd-member-cac-vs','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5173','name'=>'system-settings-wechat','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5196','name'=>'admin-category-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5197','name'=>'admin-category-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5198','name'=>'admin-category-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5199','name'=>'admin-category-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5200','name'=>'admin-category-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5201','name'=>'admin-category-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5202','name'=>'admin-category','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5203','name'=>'admin-store-childcate','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5216','name'=>'addons-menu-update-files','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5217','name'=>'member-account-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5218','name'=>'member-account-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5219','name'=>'member-account-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5220','name'=>'member-account-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5221','name'=>'member-account-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5222','name'=>'member-account-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5223','name'=>'member-account','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5224','name'=>'member-dd-member-repassword','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5225','name'=>'addons-baidu-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5226','name'=>'addons-baidu-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5227','name'=>'addons-baidu-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5228','name'=>'addons-baidu-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5229','name'=>'addons-baidu-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5230','name'=>'addons-baidu-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5231','name'=>'addons-baidu','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5232','name'=>'addons-bloc-change-username','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5233','name'=>'addons-bloc-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5234','name'=>'addons-bloc-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5235','name'=>'addons-bloc-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5236','name'=>'addons-bloc-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5237','name'=>'addons-bloc-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5238','name'=>'addons-bloc','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5239','name'=>'addons-category-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5240','name'=>'addons-category-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5241','name'=>'addons-category-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5242','name'=>'addons-category-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5243','name'=>'addons-category-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5244','name'=>'addons-category-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5245','name'=>'addons-category','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5246','name'=>'addons-email-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5247','name'=>'addons-email-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5248','name'=>'addons-email-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5249','name'=>'addons-email-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5250','name'=>'addons-email-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5251','name'=>'addons-email-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5252','name'=>'addons-email','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5253','name'=>'addons-setting','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5254','name'=>'addons-sms-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5255','name'=>'addons-sms-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5256','name'=>'addons-sms-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5257','name'=>'addons-sms-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5258','name'=>'addons-sms-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5259','name'=>'addons-sms-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5260','name'=>'addons-sms','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5261','name'=>'addons-user-bloc','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5262','name'=>'addons-store-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5263','name'=>'addons-store-get-region','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5264','name'=>'addons-store-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5265','name'=>'addons-store-childcate','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5266','name'=>'addons-store-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5267','name'=>'addons-store-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5268','name'=>'addons-store-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5269','name'=>'addons-store-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5270','name'=>'addons-store','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5271','name'=>'addons-storelabel-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5272','name'=>'addons-storelabel-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5273','name'=>'addons-storelabel-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5274','name'=>'addons-storelabel-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5275','name'=>'addons-storelabel-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5276','name'=>'addons-storelabel-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5277','name'=>'addons-storelabel','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5278','name'=>'addons-storelabellink-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5279','name'=>'addons-storelabellink-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5280','name'=>'addons-storelabellink-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5281','name'=>'addons-storelabellink-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5282','name'=>'addons-storelabellink-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5283','name'=>'addons-storelabellink-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5284','name'=>'addons-storelabellink','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5285','name'=>'addons-wechatpay-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5286','name'=>'addons-wechatpay-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5287','name'=>'addons-wechatpay-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5288','name'=>'addons-wechatpay-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5289','name'=>'addons-wechatpay-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5290','name'=>'addons-wechatpay-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5291','name'=>'addons-wechatpay','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5292','name'=>'addons-wxapp-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5293','name'=>'addons-wxapp-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5294','name'=>'addons-wxapp-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5295','name'=>'addons-wxapp-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5296','name'=>'addons-wxapp-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5297','name'=>'addons-wxapp-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5298','name'=>'addons-wxapp','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5387','name'=>'member-dd-member-groups','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5388','name'=>'system-settings-store','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5389','name'=>'settings','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5394','name'=>'system-index-info','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'5395','name'=>'system-settings-them','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6500','name'=>'addons-bloclevel-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6501','name'=>'addons-bloclevel-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6502','name'=>'addons-bloclevel-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6503','name'=>'addons-bloclevel-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6504','name'=>'addons-bloclevel-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6505','name'=>'addons-bloclevel-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6506','name'=>'addons-bloclevel','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6665','name'=>'addons-addonsstore-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6666','name'=>'addons-addonsstore-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6667','name'=>'addons-addonsstore-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6668','name'=>'addons-addonsstore-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6669','name'=>'addons-addonsstore-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6670','name'=>'addons-addonsstore-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6671','name'=>'addons-addonsstore','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6680','name'=>'addons-bloc-bloc-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6681','name'=>'addons-bloc-list','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6682','name'=>'addons-bloc-bloclevel-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6683','name'=>'addons-bloc-list-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6684','name'=>'addons-bloc-blocset-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6685','name'=>'addons-store-list-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6686','name'=>'addons-store-category-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6687','name'=>'addons-store-storelabel-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6688','name'=>'dashboard','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6689','name'=>'documentation-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6690','name'=>'admin-route-init','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6877','name'=>'ceshi-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6878','name'=>'ceshi-swgdoc','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6879','name'=>'ceshi-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6880','name'=>'ceshi-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6881','name'=>'ceshi-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6882','name'=>'ceshi-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6883','name'=>'ceshi-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6884','name'=>'ceshi','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6885','name'=>'map-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6886','name'=>'map-distance','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6887','name'=>'map-citylist','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6888','name'=>'map-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6889','name'=>'map-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6890','name'=>'map-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6891','name'=>'map-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6892','name'=>'map-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6893','name'=>'map','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6894','name'=>'site-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6895','name'=>'site-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6896','name'=>'site-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6897','name'=>'site-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6898','name'=>'site-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6899','name'=>'store-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6900','name'=>'store-info','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6901','name'=>'store-detailinfo','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6902','name'=>'store-cate','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6903','name'=>'store-list','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6904','name'=>'store-blocs','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6905','name'=>'store-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6906','name'=>'store-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6907','name'=>'store-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6908','name'=>'store-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6909','name'=>'store-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6910','name'=>'store','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6911','name'=>'upload-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6912','name'=>'upload-images','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6913','name'=>'upload-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6914','name'=>'upload-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6915','name'=>'upload-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6916','name'=>'upload-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6917','name'=>'upload-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6918','name'=>'upload','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6919','name'=>'user-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6920','name'=>'user-signup','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6921','name'=>'user-login','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6922','name'=>'user-repassword','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6923','name'=>'user-userinfo','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6924','name'=>'user-bindmobile','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6925','name'=>'user-edituserinfo','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6926','name'=>'user-forgetpass','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6927','name'=>'user-sendcode','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6928','name'=>'user-refresh','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6929','name'=>'user-feedback','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6930','name'=>'user-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6931','name'=>'user-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6932','name'=>'user-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6933','name'=>'user-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6934','name'=>'user-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6935','name'=>'user','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6936','name'=>'addons-addons-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6937','name'=>'addons-addons-list','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6938','name'=>'article-dd-article-ceshi','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6939','name'=>'auth-assignment-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6940','name'=>'auth-assignment-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6941','name'=>'auth-assignment-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6942','name'=>'auth-assignment-assign','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6943','name'=>'auth-assignment-revoke','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6944','name'=>'auth-assignment-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6945','name'=>'auth-assignment-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6946','name'=>'auth-assignment-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6947','name'=>'auth-assignment','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6948','name'=>'auth-category-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6949','name'=>'auth-category-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6950','name'=>'auth-category-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6951','name'=>'auth-category-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6952','name'=>'auth-category-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6953','name'=>'auth-category-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6954','name'=>'auth-category','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6955','name'=>'auth-default-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6956','name'=>'auth-default-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6957','name'=>'auth-default','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6958','name'=>'auth-group','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6959','name'=>'auth-menu-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6960','name'=>'auth-menu-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6961','name'=>'auth-menu-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6962','name'=>'auth-menu-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6963','name'=>'auth-menu-levels','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6964','name'=>'auth-menu-route','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6965','name'=>'auth-menu-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6966','name'=>'auth-menu-update-files','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6967','name'=>'auth-menu-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6968','name'=>'auth-menu','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6969','name'=>'auth-menu-top-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6970','name'=>'auth-menu-top-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6971','name'=>'auth-menu-top-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6972','name'=>'auth-menu-top-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6973','name'=>'auth-menu-top-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6974','name'=>'auth-menu-top-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6975','name'=>'auth-menu-top','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6976','name'=>'auth-permission','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6977','name'=>'auth-role-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6978','name'=>'auth-role-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6979','name'=>'auth-role-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6980','name'=>'auth-role-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6981','name'=>'auth-role-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6982','name'=>'auth-role-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6983','name'=>'auth-role','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6984','name'=>'auth-route-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6985','name'=>'auth-route-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6986','name'=>'auth-route-available','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6987','name'=>'auth-route-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6988','name'=>'auth-route-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6989','name'=>'auth-route-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6990','name'=>'auth-route-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6991','name'=>'auth-route-assign','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6992','name'=>'auth-route-remove','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6993','name'=>'auth-route-refresh','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6994','name'=>'auth-route','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6995','name'=>'auth-rule-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6996','name'=>'auth-rule-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6997','name'=>'auth-rule-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6998','name'=>'auth-rule-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'6999','name'=>'auth-rule-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7000','name'=>'auth-rule-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7001','name'=>'auth-rule','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7002','name'=>'auth-user','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7003','name'=>'website-dd-website-slide-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7004','name'=>'website-dd-website-slide-updateitem','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7005','name'=>'website-dd-website-slide-deleteitem','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7028','name'=>'example-index','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7029','name'=>'example-base-page-edit','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7036','name'=>'dd-article-add','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7037','name'=>'bloc-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7038','name'=>'dd-article','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7039','name'=>'dd-article-edit','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7040','name'=>'main-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7049','name'=>'member-organization','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7067','name'=>'system-settings-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7099','name'=>'settings-default-update','is_sys'=>'0','permission_type'=>'0','description'=>'描述1','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7100','name'=>'settings-default-index','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7101','name'=>'settings-default-create','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7102','name'=>'settings-default-delete','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7103','name'=>'admin-assignment-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7104','name'=>'admin-assignment-index','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7105','name'=>'admin-assignment-view','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7106','name'=>'admin-assignment-assign','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7107','name'=>'admin-assignment-revoke','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7108','name'=>'admin-assignment','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7109','name'=>'admin-default-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7110','name'=>'admin-default-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7111','name'=>'admin-default','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7112','name'=>'admin-group-error','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7113','name'=>'admin-group-index','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7114','name'=>'admin-group-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7115','name'=>'admin-group-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7116','name'=>'admin-group-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7117','name'=>'admin-group-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7118','name'=>'admin-group','is_sys'=>'0','permission_type'=>'0','description'=>'描述','rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7119','name'=>'admin-menu-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7120','name'=>'admin-menu-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7121','name'=>'admin-menu-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7122','name'=>'admin-menu-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7123','name'=>'admin-menu-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7124','name'=>'admin-menu-update-files','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7125','name'=>'admin-menu-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7126','name'=>'admin-menu','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7127','name'=>'admin-menu-top-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7128','name'=>'admin-menu-top-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7129','name'=>'admin-menu-top-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7130','name'=>'admin-menu-top-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7131','name'=>'admin-menu-top-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7132','name'=>'admin-menu-top','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7133','name'=>'admin-permission-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7134','name'=>'admin-permission-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7135','name'=>'admin-permission-create','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7136','name'=>'admin-permission-update','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7137','name'=>'admin-permission-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7138','name'=>'admin-permission-assign','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7139','name'=>'admin-permission-remove','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7140','name'=>'admin-permission','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7141','name'=>'admin-role-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7142','name'=>'admin-role-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7143','name'=>'admin-role-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7144','name'=>'admin-role-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7145','name'=>'admin-role-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7146','name'=>'admin-role-assign','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7147','name'=>'admin-role-remove','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7148','name'=>'admin-role','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7149','name'=>'admin-route-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7150','name'=>'admin-route-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7151','name'=>'admin-route-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7152','name'=>'admin-route-assign','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7153','name'=>'admin-route-remove','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7154','name'=>'admin-route-refresh','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7155','name'=>'admin-route','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7156','name'=>'admin-rule-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7157','name'=>'admin-rule-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7158','name'=>'admin-rule-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7159','name'=>'admin-rule-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7160','name'=>'admin-rule-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7161','name'=>'admin-rule-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7162','name'=>'admin-rule','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7163','name'=>'admin-user-bloc','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7164','name'=>'admin-user-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7165','name'=>'admin-user-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7166','name'=>'admin-user-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7167','name'=>'admin-user-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7168','name'=>'admin-user-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7169','name'=>'admin-user-login','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7170','name'=>'admin-user-logout','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7171','name'=>'admin-user-signup','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7172','name'=>'admin-user-request-password-reset','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7173','name'=>'admin-user-reset-password','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7174','name'=>'admin-user-change-password','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7175','name'=>'admin-user-activate','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7176','name'=>'admin-user','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7177','name'=>'admin','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7178','name'=>'modal-modal-website','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7179','name'=>'modal-modal-icons','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7180','name'=>'modal-modal','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7181','name'=>'modal','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7182','name'=>'addons-addons-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7183','name'=>'addons-addons-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7184','name'=>'addons-addons-uninstalled','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7185','name'=>'addons-addons-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7186','name'=>'addons-addons-logo','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7187','name'=>'addons-addons-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7188','name'=>'addons-addons-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7189','name'=>'addons-addons-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7190','name'=>'addons-addons','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7191','name'=>'addons-manage-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7192','name'=>'addons-manage-install','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7193','name'=>'addons-manage-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7194','name'=>'addons-manage-uninstall','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7195','name'=>'addons-manage-auth','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7196','name'=>'addons-manage','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7197','name'=>'addons-menu-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7198','name'=>'addons-menu-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7199','name'=>'addons-menu-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7200','name'=>'addons-menu-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7201','name'=>'addons-menu-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7202','name'=>'addons-menu-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7203','name'=>'addons-menu','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7204','name'=>'addons','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7205','name'=>'gii-default-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7206','name'=>'gii-default-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7207','name'=>'gii-default-preview','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7208','name'=>'gii-default-diff','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7209','name'=>'gii-default-action','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7210','name'=>'gii-default','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7211','name'=>'gii','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7238','name'=>'base-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7239','name'=>'base','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7240','name'=>'module-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7241','name'=>'module-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7242','name'=>'module','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7243','name'=>'site-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7244','name'=>'site-index','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7245','name'=>'site-login','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7246','name'=>'site-logout','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7247','name'=>'site-signup','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7248','name'=>'site-request-password-reset','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7249','name'=>'site-reset-password','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7250','name'=>'site-verify-email','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7251','name'=>'site-resend-verification-email','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7252','name'=>'site','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7253','name'=>'article-dd-article-category-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7254','name'=>'article-dd-article-category-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7255','name'=>'article-dd-article-category-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7256','name'=>'article-dd-article-category-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7257','name'=>'article-dd-article-category-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7258','name'=>'article-dd-article-category-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7259','name'=>'article-dd-article-category-childcate','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7260','name'=>'article-dd-article-category','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7261','name'=>'article-dd-article-upload','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7262','name'=>'article-dd-article-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7263','name'=>'article-dd-article-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7264','name'=>'article-dd-article-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7265','name'=>'article-dd-article-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7266','name'=>'article-dd-article-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7267','name'=>'article-dd-article','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7268','name'=>'article-record-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7269','name'=>'article-record-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7270','name'=>'article-record-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7271','name'=>'article-record-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7272','name'=>'article-record-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7273','name'=>'article-record','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7274','name'=>'demo-form-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7275','name'=>'demo-form-get-region','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7276','name'=>'demo-form-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7277','name'=>'demo-form-maile','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7278','name'=>'demo-form','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7279','name'=>'member-dd-member-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7280','name'=>'member-dd-member-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7281','name'=>'member-dd-member-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7282','name'=>'member-dd-member-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7283','name'=>'member-dd-member-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7284','name'=>'member-dd-member-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7285','name'=>'member-dd-member','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7286','name'=>'member-dd-member-group-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7287','name'=>'member-dd-member-group-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7288','name'=>'member-dd-member-group-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7289','name'=>'member-dd-member-group-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7290','name'=>'member-dd-member-group-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7291','name'=>'member-dd-member-group-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7292','name'=>'member-dd-member-group','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7293','name'=>'system-index-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7294','name'=>'system-index-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7295','name'=>'system-index-childcate','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7296','name'=>'system-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7297','name'=>'system-settings-baidu','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7298','name'=>'system-settings-wxapp','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7299','name'=>'system-settings-wechatpay','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7300','name'=>'system-settings-sms','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7301','name'=>'system-settings-email','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7302','name'=>'system-settings-clear-cache','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7303','name'=>'system-settings','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7304','name'=>'system-welcome-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7305','name'=>'system-welcome-index','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7306','name'=>'system-welcome-sysai','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7307','name'=>'system-welcome-member','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7308','name'=>'system-welcome-aimember','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7309','name'=>'system-welcome-goods','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7310','name'=>'system-welcome-marketing','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7311','name'=>'system-welcome-order','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7312','name'=>'system-welcome-wxapp','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7313','name'=>'system-welcome-plugins','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7314','name'=>'system-welcome-system','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7315','name'=>'system-welcome','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7316','name'=>'upload-upload-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7317','name'=>'upload-upload-uploadimg','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7318','name'=>'upload-upload-uploadfile','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7319','name'=>'upload-upload','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7320','name'=>'user-dd-user-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7321','name'=>'user-dd-user-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7322','name'=>'user-dd-user-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7323','name'=>'user-dd-user-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7324','name'=>'user-dd-user-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7325','name'=>'user-dd-user-profile','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7326','name'=>'user-dd-user-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7327','name'=>'user-dd-user','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7328','name'=>'website-dd-website-contact-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7329','name'=>'website-dd-website-contact-index','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7330','name'=>'website-dd-website-contact-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7331','name'=>'website-dd-website-contact-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7332','name'=>'website-dd-website-contact-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7333','name'=>'website-dd-website-contact-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7334','name'=>'website-dd-website-contact','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7335','name'=>'website-dd-website-slide-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7336','name'=>'website-dd-website-slide-index','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7337','name'=>'website-dd-website-slide-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7338','name'=>'website-dd-website-slide-create','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7339','name'=>'website-dd-website-slide-update','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7340','name'=>'website-dd-website-slide-delete','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7341','name'=>'website-dd-website-slide','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7342','name'=>'website-setting-website','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7343','name'=>'website-setting','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7344','name'=>'*','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7345','name'=>'admin-group-assign','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7346','name'=>'admin-group-remove','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7354','name'=>'system-settings-map','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7355','name'=>'system-settings-set-cache','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7356','name'=>'settings-default','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7357','name'=>'diandi-gathergoods-ceshi-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7358','name'=>'diandi-gathergoods-ceshi-py','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7359','name'=>'diandi-gathergoods-ceshi','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7360','name'=>'diandi-gathergoods-jingd','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7361','name'=>'diandi-gathergoods-ceshi-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7362','name'=>'diandi-gathergoods-tao','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7363','name'=>'gii-addons','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7364','name'=>'diandi-aggregate-default-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7365','name'=>'diandi-aggregate-default-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7366','name'=>'diandi-aggregate-default','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7367','name'=>'diandi-aggregate','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7368','name'=>'diandi-aggregate-set-config-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7369','name'=>'diandi-aggregate-set-config-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7370','name'=>'diandi-aggregate-set-config-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7371','name'=>'diandi-aggregate-set-config-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7372','name'=>'diandi-aggregate-set-config-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7373','name'=>'diandi-aggregate-set-config','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7374','name'=>'diandi-aggregate-set-config-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7375','name'=>'diandi-distribution-conf-price-conf-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7376','name'=>'diandi-distribution-goods-gift-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7377','name'=>'diandi-distribution-goods-goods-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7378','name'=>'diandi-distribution-goods-goods-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7379','name'=>'diandi-distribution-goods-goods-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7380','name'=>'diandi-distribution-goods-goods-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7381','name'=>'diandi-distribution-goods-goods-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7382','name'=>'diandi-distribution-goods-goods-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7383','name'=>'diandi-pro-default-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7384','name'=>'diandi-pro-default-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7385','name'=>'diandi-pro-default','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7386','name'=>'diandi-pro-goods-category-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7387','name'=>'diandi-pro-goods-category-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7388','name'=>'diandi-pro-goods-category-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7389','name'=>'diandi-pro-goods-category-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7390','name'=>'diandi-pro-goods-category-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7391','name'=>'diandi-pro-goods-category-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7392','name'=>'diandi-pro-goods-category','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7393','name'=>'diandi-pro-goods-goods-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7394','name'=>'diandi-pro-goods-goods-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7395','name'=>'diandi-pro-goods-goods-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7396','name'=>'diandi-pro-goods-goods-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7397','name'=>'diandi-pro-goods-goods-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7398','name'=>'diandi-pro-goods-goods-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7399','name'=>'diandi-pro-goods-goods','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7400','name'=>'diandi-pro-goods-param-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7401','name'=>'diandi-pro-goods-param-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7402','name'=>'diandi-pro-goods-param-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7403','name'=>'diandi-pro-goods-param-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7404','name'=>'diandi-pro-goods-param-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7405','name'=>'diandi-pro-goods-param-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7406','name'=>'diandi-pro-goods-param','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7407','name'=>'diandi-pro-goods-specrel-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7408','name'=>'diandi-pro-goods-specrel-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7409','name'=>'diandi-pro-goods-specrel-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7410','name'=>'diandi-pro-goods-specrel-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7411','name'=>'diandi-pro-goods-specrel-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7412','name'=>'diandi-pro-goods-specrel-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7413','name'=>'diandi-pro-goods-specrel','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7414','name'=>'diandi-pro-template-param-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7415','name'=>'diandi-pro-template-param-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7416','name'=>'diandi-pro-template-param-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7417','name'=>'diandi-pro-template-param-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7418','name'=>'diandi-pro-template-param-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7419','name'=>'diandi-pro-template-param-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7420','name'=>'diandi-pro-template-param','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7421','name'=>'diandi-pro-template-pro-template-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7422','name'=>'diandi-pro-template-pro-template-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7423','name'=>'diandi-pro-template-pro-template-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7424','name'=>'diandi-pro-template-pro-template-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7425','name'=>'diandi-pro-template-pro-template-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7426','name'=>'diandi-pro-template-pro-template-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7427','name'=>'diandi-pro-template-pro-template','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7428','name'=>'diandi-pro','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7429','name'=>'diandi-pro-goods-category-getlist','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7430','name'=>'diandi-pro-template-specrel-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7431','name'=>'diandi-pro-template-specrel-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7432','name'=>'diandi-pro-template-specrel-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7433','name'=>'diandi-pro-template-specrel-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7434','name'=>'diandi-pro-template-specrel-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7435','name'=>'diandi-pro-template-specrel-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7436','name'=>'diandi-pro-template-specrel','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7437','name'=>'diandi-pro-template-template-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7438','name'=>'diandi-pro-template-template-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7439','name'=>'diandi-pro-template-template-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7440','name'=>'diandi-pro-template-template-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7441','name'=>'diandi-pro-template-template-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7442','name'=>'diandi-pro-template-template-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7443','name'=>'diandi-pro-template-template','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7444','name'=>'diandi-pro-goods-goods-getlist','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7445','name'=>'system-database','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7446','name'=>'system-database-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7447','name'=>'system-database-backups','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7448','name'=>'system-database-export','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7449','name'=>'system-database-export-start','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7450','name'=>'system-database-optimize','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7451','name'=>'system-database-repair','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7452','name'=>'system-database-restore','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7453','name'=>'system-database-restore-init','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7454','name'=>'system-database-restore-start','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7455','name'=>'system-database-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7456','name'=>'system-database-data-dictionary','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7457','name'=>'system-database-backlist','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7458','name'=>'diandi-distribution-goods-location-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7459','name'=>'diandi-distribution-goods-location-goods-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7460','name'=>'diandi-distribution-conf-slide-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7461','name'=>'ds','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7462','name'=>'debug-default-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7463','name'=>'debug','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7464','name'=>'settings-default-edit-setting','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7465','name'=>'debug-default-db-explain','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7466','name'=>'debug-default-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7467','name'=>'debug-default-toolbar','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7468','name'=>'debug-default-download-mail','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7469','name'=>'debug-default','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7470','name'=>'debug-user-set-identity','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7471','name'=>'debug-user-reset-identity','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7472','name'=>'debug-user','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7473','name'=>'diandi-operator-default-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7474','name'=>'diandi-operator-default-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7475','name'=>'diandi-operator-default','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7476','name'=>'diandi-operator','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7477','name'=>'diandi-video-category-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7478','name'=>'diandi-video-category-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7479','name'=>'diandi-video-category-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7480','name'=>'diandi-video-category-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7481','name'=>'diandi-video-category-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7482','name'=>'diandi-video-category-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7483','name'=>'diandi-video-category','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7484','name'=>'diandi-video-default-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7485','name'=>'diandi-video-default-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7486','name'=>'diandi-video-default','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7487','name'=>'diandi-video-list-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7488','name'=>'diandi-video-list-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7489','name'=>'diandi-video-list-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7490','name'=>'diandi-video-list-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7491','name'=>'diandi-video-list-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7492','name'=>'diandi-video-list-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7493','name'=>'diandi-video-list','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7494','name'=>'diandi-video-slide-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7495','name'=>'diandi-video-slide-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7496','name'=>'diandi-video-slide-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7497','name'=>'diandi-video-slide-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7498','name'=>'diandi-video-slide-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7499','name'=>'diandi-video-slide-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7500','name'=>'diandi-video-slide','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7501','name'=>'diandi-video-store-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7502','name'=>'diandi-video-store-get-region','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7503','name'=>'diandi-video-store-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7504','name'=>'diandi-video-store-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7505','name'=>'diandi-video-store-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7506','name'=>'diandi-video-store-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7507','name'=>'diandi-video-store-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7508','name'=>'diandi-video-store','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7509','name'=>'diandi-video','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7510','name'=>'site-setpassword','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7511','name'=>'admin-user-assign','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7512','name'=>'admin-user-remove','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7513','name'=>'diandi-shop-wxapp-dd-wxapp-page-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7514','name'=>'diandi-shop-wxapp-dd-wxapp-page-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7515','name'=>'diandi-shop-wxapp-dd-wxapp-page-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7516','name'=>'diandi-shop-wxapp-dd-wxapp-page-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7517','name'=>'diandi-shop-wxapp-dd-wxapp-page-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7518','name'=>'diandi-distribution-goods-goods-attribute','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7519','name'=>'diandi-distribution-goods-goods-postdata','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7520','name'=>'diandi-distribution-goods-goods-detail','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7521','name'=>'diandi-distribution-goods-goods-gethtml','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7522','name'=>'diandi-distribution-goods-goods-goodslist','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7523','name'=>'diandi-distribution-goods-goods-spechtml','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7524','name'=>'diandi-video-list-upload','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7525','name'=>'diandi-video-list-list','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7526','name'=>'diandi-video-list-config','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7527','name'=>'diandi-video-list-videolist','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7528','name'=>'diandi-video-slide-videolist','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7529','name'=>'diandi-video-store-upload','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7530','name'=>'diandi-operator-ceshi-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7531','name'=>'diandi-operator-ceshi-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7532','name'=>'diandi-operator-ceshi','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7533','name'=>'diandi-store-record-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7534','name'=>'diandi-store-record-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7535','name'=>'diandi-store-record-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7536','name'=>'diandi-store-record-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7537','name'=>'diandi-store-record-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7538','name'=>'diandi-store-record-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7539','name'=>'diandi-store-record','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7540','name'=>'diandi-store-store-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7541','name'=>'diandi-store-store-get-region','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7542','name'=>'diandi-store-store-setting','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7543','name'=>'diandi-store-store-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7544','name'=>'diandi-store-store-adds','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7545','name'=>'diandi-store-store-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7546','name'=>'diandi-store-store-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7547','name'=>'diandi-store-store-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7548','name'=>'diandi-store-store-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7549','name'=>'diandi-store-store','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7550','name'=>'diandi-store-store-seat-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7551','name'=>'diandi-store-store-seat-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7552','name'=>'diandi-store-store-seat-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7553','name'=>'diandi-store-store-seat-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7554','name'=>'diandi-store-store-seat-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7555','name'=>'diandi-store-store-seat-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7556','name'=>'diandi-store-store-seat','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7557','name'=>'diandi-store-store-service-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7558','name'=>'diandi-store-store-service-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7559','name'=>'diandi-store-store-service-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7560','name'=>'diandi-store-store-service-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7561','name'=>'diandi-store-store-service-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7562','name'=>'diandi-store-store-service-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7563','name'=>'diandi-store-store-service','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7564','name'=>'diandi-store-store-share-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7565','name'=>'diandi-store-store-share-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7566','name'=>'diandi-store-store-share-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7567','name'=>'diandi-store-store-share-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7568','name'=>'diandi-store-store-share-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7569','name'=>'diandi-store-store-share-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7570','name'=>'diandi-store-store-share','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7571','name'=>'diandi-store-store-slide-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7572','name'=>'diandi-store-store-slide-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7573','name'=>'diandi-store-store-slide-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7574','name'=>'diandi-store-store-slide-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7575','name'=>'diandi-store-store-slide-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7576','name'=>'diandi-store-store-slide-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7577','name'=>'diandi-store-store-slide','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7578','name'=>'diandi-operator-bloc-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7579','name'=>'diandi-operator-bloc-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7580','name'=>'diandi-operator-bloc-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7581','name'=>'diandi-operator-bloc-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7582','name'=>'diandi-operator-bloc-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7583','name'=>'diandi-operator-bloc-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7584','name'=>'diandi-operator-bloc','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7585','name'=>'diandi-operator-cardlist-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7586','name'=>'diandi-operator-cardlist-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7587','name'=>'diandi-operator-cardlist-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7588','name'=>'diandi-operator-cardlist-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7589','name'=>'diandi-operator-cardlist-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7590','name'=>'diandi-operator-cardlist-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7591','name'=>'diandi-operator-cardlist','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7592','name'=>'diandi-operator-cardlistcancel-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7593','name'=>'diandi-operator-cardlistcancel-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7594','name'=>'diandi-operator-cardlistcancel-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7595','name'=>'diandi-operator-cardlistcancel-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7596','name'=>'diandi-operator-cardlistcancel-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7597','name'=>'diandi-operator-cardlistcancel-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7598','name'=>'diandi-operator-cardlistcancel','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7599','name'=>'diandi-operator-cardloseefficacy-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7600','name'=>'diandi-operator-cardloseefficacy-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7601','name'=>'diandi-operator-cardloseefficacy-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7602','name'=>'diandi-operator-cardloseefficacy-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7603','name'=>'diandi-operator-cardloseefficacy-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7604','name'=>'diandi-operator-cardloseefficacy-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7605','name'=>'diandi-operator-cardloseefficacy','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7606','name'=>'diandi-operator-change-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7607','name'=>'diandi-operator-change-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7608','name'=>'diandi-operator-change-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7609','name'=>'diandi-operator-change-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7610','name'=>'diandi-operator-change-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7611','name'=>'diandi-operator-change-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7612','name'=>'diandi-operator-change','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7613','name'=>'diandi-operator-operator-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7614','name'=>'diandi-operator-operator-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7615','name'=>'diandi-operator-operator-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7616','name'=>'diandi-operator-operator-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7617','name'=>'diandi-operator-operator-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7618','name'=>'diandi-operator-operator-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7619','name'=>'diandi-operator-operator','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7620','name'=>'diandi-operator-order-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7621','name'=>'diandi-operator-order-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7622','name'=>'diandi-operator-order-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7623','name'=>'diandi-operator-order-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7624','name'=>'diandi-operator-order-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7625','name'=>'diandi-operator-order-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7626','name'=>'diandi-operator-order','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7627','name'=>'diandi-operator-transfer-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7628','name'=>'diandi-operator-transfer-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7629','name'=>'diandi-operator-transfer-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7630','name'=>'diandi-operator-transfer-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7631','name'=>'diandi-operator-transfer-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7632','name'=>'diandi-operator-transfer-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7633','name'=>'diandi-operator-transfer','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7634','name'=>'diandi-operator-withdraw-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7635','name'=>'diandi-operator-withdraw-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7636','name'=>'diandi-operator-withdraw-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7637','name'=>'diandi-operator-withdraw-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7638','name'=>'diandi-operator-withdraw-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7639','name'=>'diandi-operator-withdraw-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7640','name'=>'diandi-operator-withdraw','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7641','name'=>'diandi-operator-bloc-detail','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7642','name'=>'diandi-operator-bloc-blocs','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7643','name'=>'diandi-operator-cardreal-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7644','name'=>'diandi-operator-cardreal-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7645','name'=>'diandi-operator-cardreal-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7646','name'=>'diandi-operator-cardreal-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7647','name'=>'diandi-operator-cardreal-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7648','name'=>'diandi-operator-cardreal-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7649','name'=>'diandi-operator-cardreal','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7650','name'=>'diandi-operator-clientreal-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7651','name'=>'diandi-operator-clientreal-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7652','name'=>'diandi-operator-clientreal-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7653','name'=>'diandi-operator-clientreal-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7654','name'=>'diandi-operator-clientreal-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7655','name'=>'diandi-operator-clientreal-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7656','name'=>'diandi-operator-clientreal','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7657','name'=>'diandi-operator-channel-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7658','name'=>'diandi-operator-channel-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7659','name'=>'diandi-operator-channel-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7660','name'=>'diandi-operator-channel-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7661','name'=>'diandi-operator-channel-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7662','name'=>'diandi-operator-channel-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7663','name'=>'diandi-operator-channel','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7664','name'=>'diandi-operator-meallist-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7665','name'=>'diandi-operator-meallist-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7666','name'=>'diandi-operator-meallist-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7667','name'=>'diandi-operator-meallist-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7668','name'=>'diandi-operator-meallist-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7669','name'=>'diandi-operator-meallist-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7670','name'=>'diandi-operator-meallist','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7671','name'=>'diandi-operator-setmeal-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7672','name'=>'diandi-operator-setmeal-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7673','name'=>'diandi-operator-setmeal-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7674','name'=>'diandi-operator-setmeal-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7675','name'=>'diandi-operator-setmeal-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7676','name'=>'diandi-operator-setmeal-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7677','name'=>'diandi-operator-setmeal','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7678','name'=>'diandi-operator-pretreatment-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7679','name'=>'diandi-operator-pretreatment-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7680','name'=>'diandi-operator-pretreatment-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7681','name'=>'diandi-operator-pretreatment-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7682','name'=>'diandi-operator-pretreatment-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7683','name'=>'diandi-operator-pretreatment-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7684','name'=>'diandi-operator-pretreatment','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7685','name'=>'diandi-operator-user-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7686','name'=>'diandi-operator-user-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7687','name'=>'diandi-operator-user-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7688','name'=>'diandi-operator-user-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7689','name'=>'diandi-operator-user-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7690','name'=>'diandi-operator-user-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7691','name'=>'diandi-operator-user','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7692','name'=>'diandi-operator-pond-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7693','name'=>'diandi-operator-pond-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7694','name'=>'diandi-operator-pond-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7695','name'=>'diandi-operator-pond-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7696','name'=>'diandi-operator-pond-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7697','name'=>'diandi-operator-pond-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7698','name'=>'diandi-operator-pond','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7699','name'=>'diandi-operator-pondwarning-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7700','name'=>'diandi-operator-pondwarning-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7701','name'=>'diandi-operator-pondwarning-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7702','name'=>'diandi-operator-pondwarning-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7703','name'=>'diandi-operator-pondwarning-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7704','name'=>'diandi-operator-pondwarning-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7705','name'=>'diandi-operator-pondwarning','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7706','name'=>'diandi-operator-allocation-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7707','name'=>'diandi-operator-allocation-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7708','name'=>'diandi-operator-allocation-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7709','name'=>'diandi-operator-allocation-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7710','name'=>'diandi-operator-allocation-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7711','name'=>'diandi-operator-allocation-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7712','name'=>'diandi-operator-allocation','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7713','name'=>'diandi-operator-statistics-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7714','name'=>'diandi-operator-statistics-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7715','name'=>'diandi-operator-statistics-activate','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7716','name'=>'diandi-operator-statistics-flux','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7717','name'=>'diandi-operator-statistics-trade','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7718','name'=>'diandi-operator-statistics','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7719','name'=>'diandi-operator-statistics-client','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7720','name'=>'diandi-operator-config-chinamobile','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7721','name'=>'diandi-operator-config-onelink','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7722','name'=>'diandi-operator-config-telecom','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7723','name'=>'diandi-operator-config-clear-cache','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7724','name'=>'diandi-operator-config-set-cache','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7725','name'=>'diandi-operator-config','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7806','name'=>'member-dd-member-cac-vs','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7807','name'=>'system-settings-wechat','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7830','name'=>'admin-category-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7831','name'=>'admin-category-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7832','name'=>'admin-category-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7833','name'=>'admin-category-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7834','name'=>'admin-category-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7835','name'=>'admin-category-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7836','name'=>'admin-category','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7837','name'=>'admin-store-childcate','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7850','name'=>'addons-menu-update-files','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7851','name'=>'member-account-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7852','name'=>'member-account-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7853','name'=>'member-account-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7854','name'=>'member-account-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7855','name'=>'member-account-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7856','name'=>'member-account-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7857','name'=>'member-account','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7858','name'=>'member-dd-member-repassword','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7859','name'=>'addons-baidu-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7860','name'=>'addons-baidu-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7861','name'=>'addons-baidu-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7862','name'=>'addons-baidu-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7863','name'=>'addons-baidu-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7864','name'=>'addons-baidu-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7865','name'=>'addons-baidu','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7866','name'=>'addons-bloc-change-username','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7867','name'=>'addons-bloc-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7868','name'=>'addons-bloc-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7869','name'=>'addons-bloc-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7870','name'=>'addons-bloc-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7871','name'=>'addons-bloc-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7872','name'=>'addons-bloc','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7873','name'=>'addons-category-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7874','name'=>'addons-category-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7875','name'=>'addons-category-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7876','name'=>'addons-category-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7877','name'=>'addons-category-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7878','name'=>'addons-category-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7879','name'=>'addons-category','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7880','name'=>'addons-email-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7881','name'=>'addons-email-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7882','name'=>'addons-email-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7883','name'=>'addons-email-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7884','name'=>'addons-email-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7885','name'=>'addons-email-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7886','name'=>'addons-email','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7887','name'=>'addons-setting','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7888','name'=>'addons-sms-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7889','name'=>'addons-sms-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7890','name'=>'addons-sms-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7891','name'=>'addons-sms-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7892','name'=>'addons-sms-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7893','name'=>'addons-sms-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7894','name'=>'addons-sms','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7895','name'=>'addons-user-bloc','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7896','name'=>'addons-store-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7897','name'=>'addons-store-get-region','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7898','name'=>'addons-store-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7899','name'=>'addons-store-childcate','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7900','name'=>'addons-store-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7901','name'=>'addons-store-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7902','name'=>'addons-store-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7903','name'=>'addons-store-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7904','name'=>'addons-store','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7905','name'=>'addons-storelabel-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7906','name'=>'addons-storelabel-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7907','name'=>'addons-storelabel-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7908','name'=>'addons-storelabel-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7909','name'=>'addons-storelabel-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7910','name'=>'addons-storelabel-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7911','name'=>'addons-storelabel','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7912','name'=>'addons-storelabellink-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7913','name'=>'addons-storelabellink-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7914','name'=>'addons-storelabellink-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7915','name'=>'addons-storelabellink-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7916','name'=>'addons-storelabellink-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7917','name'=>'addons-storelabellink-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7918','name'=>'addons-storelabellink','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7919','name'=>'addons-wechatpay-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7920','name'=>'addons-wechatpay-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7921','name'=>'addons-wechatpay-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7922','name'=>'addons-wechatpay-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7923','name'=>'addons-wechatpay-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7924','name'=>'addons-wechatpay-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7925','name'=>'addons-wechatpay','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7926','name'=>'addons-wxapp-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7927','name'=>'addons-wxapp-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7928','name'=>'addons-wxapp-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7929','name'=>'addons-wxapp-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7930','name'=>'addons-wxapp-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7931','name'=>'addons-wxapp-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'7932','name'=>'addons-wxapp','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'8021','name'=>'member-dd-member-groups','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'8022','name'=>'system-settings-store','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'8023','name'=>'settings','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'8028','name'=>'system-index-info','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'8029','name'=>'system-settings-them','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9134','name'=>'addons-bloclevel-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9135','name'=>'addons-bloclevel-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9136','name'=>'addons-bloclevel-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9137','name'=>'addons-bloclevel-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9138','name'=>'addons-bloclevel-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9139','name'=>'addons-bloclevel-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9140','name'=>'addons-bloclevel','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9299','name'=>'addons-addonsstore-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9300','name'=>'addons-addonsstore-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9301','name'=>'addons-addonsstore-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9302','name'=>'addons-addonsstore-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9303','name'=>'addons-addonsstore-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9304','name'=>'addons-addonsstore-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9305','name'=>'addons-addonsstore','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9314','name'=>'addons-bloc-bloc-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9315','name'=>'addons-bloc-list','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9316','name'=>'addons-bloc-bloclevel-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9317','name'=>'addons-bloc-list-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9318','name'=>'addons-bloc-blocset-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9319','name'=>'addons-store-list-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9320','name'=>'addons-store-category-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9321','name'=>'addons-store-storelabel-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9322','name'=>'dashboard','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9323','name'=>'documentation-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9324','name'=>'admin-route-init','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9511','name'=>'ceshi-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9512','name'=>'ceshi-swgdoc','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9513','name'=>'ceshi-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9514','name'=>'ceshi-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9515','name'=>'ceshi-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9516','name'=>'ceshi-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9517','name'=>'ceshi-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9518','name'=>'ceshi','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9519','name'=>'map-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9520','name'=>'map-distance','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9521','name'=>'map-citylist','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9522','name'=>'map-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9523','name'=>'map-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9524','name'=>'map-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9525','name'=>'map-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9526','name'=>'map-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9527','name'=>'map','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9528','name'=>'site-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9529','name'=>'site-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9530','name'=>'site-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9531','name'=>'site-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9532','name'=>'site-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9533','name'=>'store-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9534','name'=>'store-info','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9535','name'=>'store-detailinfo','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9536','name'=>'store-cate','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9537','name'=>'store-list','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9538','name'=>'store-blocs','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9539','name'=>'store-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9540','name'=>'store-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9541','name'=>'store-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9542','name'=>'store-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9543','name'=>'store-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9544','name'=>'store','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9545','name'=>'upload-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9546','name'=>'upload-images','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9547','name'=>'upload-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9548','name'=>'upload-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9549','name'=>'upload-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9550','name'=>'upload-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9551','name'=>'upload-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9552','name'=>'upload','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9553','name'=>'user-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9554','name'=>'user-signup','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9555','name'=>'user-login','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9556','name'=>'user-repassword','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9557','name'=>'user-userinfo','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9558','name'=>'user-bindmobile','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9559','name'=>'user-edituserinfo','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9560','name'=>'user-forgetpass','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9561','name'=>'user-sendcode','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9562','name'=>'user-refresh','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9563','name'=>'user-feedback','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9564','name'=>'user-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9565','name'=>'user-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9566','name'=>'user-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9567','name'=>'user-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9568','name'=>'user-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9569','name'=>'user','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9570','name'=>'addons-addons-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9571','name'=>'addons-addons-list','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9572','name'=>'article-dd-article-ceshi','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9573','name'=>'auth-assignment-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9574','name'=>'auth-assignment-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9575','name'=>'auth-assignment-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9576','name'=>'auth-assignment-assign','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9577','name'=>'auth-assignment-revoke','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9578','name'=>'auth-assignment-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9579','name'=>'auth-assignment-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9580','name'=>'auth-assignment-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9581','name'=>'auth-assignment','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9582','name'=>'auth-category-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9583','name'=>'auth-category-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9584','name'=>'auth-category-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9585','name'=>'auth-category-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9586','name'=>'auth-category-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9587','name'=>'auth-category-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9588','name'=>'auth-category','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9589','name'=>'auth-default-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9590','name'=>'auth-default-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9591','name'=>'auth-default','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9592','name'=>'auth-group','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9593','name'=>'auth-menu-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9594','name'=>'auth-menu-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9595','name'=>'auth-menu-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9596','name'=>'auth-menu-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9597','name'=>'auth-menu-levels','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9598','name'=>'auth-menu-route','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9599','name'=>'auth-menu-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9600','name'=>'auth-menu-update-files','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9601','name'=>'auth-menu-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9602','name'=>'auth-menu','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9603','name'=>'auth-menu-top-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9604','name'=>'auth-menu-top-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9605','name'=>'auth-menu-top-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9606','name'=>'auth-menu-top-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9607','name'=>'auth-menu-top-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9608','name'=>'auth-menu-top-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9609','name'=>'auth-menu-top','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9610','name'=>'auth-permission','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9611','name'=>'auth-role-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9612','name'=>'auth-role-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9613','name'=>'auth-role-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9614','name'=>'auth-role-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9615','name'=>'auth-role-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9616','name'=>'auth-role-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9617','name'=>'auth-role','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9618','name'=>'auth-route-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9619','name'=>'auth-route-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9620','name'=>'auth-route-available','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9621','name'=>'auth-route-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9622','name'=>'auth-route-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9623','name'=>'auth-route-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9624','name'=>'auth-route-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9625','name'=>'auth-route-assign','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9626','name'=>'auth-route-remove','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9627','name'=>'auth-route-refresh','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9628','name'=>'auth-route','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9629','name'=>'auth-rule-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9630','name'=>'auth-rule-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9631','name'=>'auth-rule-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9632','name'=>'auth-rule-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9633','name'=>'auth-rule-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9634','name'=>'auth-rule-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9635','name'=>'auth-rule','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9636','name'=>'auth-user','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9637','name'=>'website-dd-website-slide-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9638','name'=>'website-dd-website-slide-updateitem','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9639','name'=>'website-dd-website-slide-deleteitem','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9662','name'=>'example-index','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9663','name'=>'example-base-page-edit','is_sys'=>'0','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9670','name'=>'dd-article-add','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9671','name'=>'bloc-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9672','name'=>'dd-article','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9673','name'=>'dd-article-edit','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9674','name'=>'main-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9683','name'=>'member-organization','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9701','name'=>'system-settings-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9733','name'=>'总管理员1','is_sys'=>'0','permission_type'=>'2','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9734','name'=>'/addons/store/welcome/index.vue','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9737','name'=>'settings-default-update','is_sys'=>'1','permission_type'=>'0','description'=>'描述1','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9738','name'=>'settings-default-index','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9739','name'=>'settings-default-create','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9740','name'=>'settings-default-delete','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9741','name'=>'admin-assignment-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9742','name'=>'admin-assignment-index','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9743','name'=>'admin-assignment-view','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9744','name'=>'admin-assignment-assign','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9745','name'=>'admin-assignment-revoke','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9746','name'=>'admin-assignment','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9747','name'=>'admin-default-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9748','name'=>'admin-default-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9749','name'=>'admin-default','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9750','name'=>'admin-group-error','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9751','name'=>'admin-group-index','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9752','name'=>'admin-group-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9753','name'=>'admin-group-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9754','name'=>'admin-group-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9755','name'=>'admin-group-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9756','name'=>'admin-group','is_sys'=>'1','permission_type'=>'0','description'=>'描述','rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9757','name'=>'admin-menu-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9758','name'=>'admin-menu-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9759','name'=>'admin-menu-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9760','name'=>'admin-menu-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9761','name'=>'admin-menu-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9762','name'=>'admin-menu-update-files','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9763','name'=>'admin-menu-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9764','name'=>'admin-menu','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9765','name'=>'admin-menu-top-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9766','name'=>'admin-menu-top-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9767','name'=>'admin-menu-top-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9768','name'=>'admin-menu-top-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9769','name'=>'admin-menu-top-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9770','name'=>'admin-menu-top','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9771','name'=>'admin-permission-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9772','name'=>'admin-permission-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9773','name'=>'admin-permission-create','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9774','name'=>'admin-permission-update','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9775','name'=>'admin-permission-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9776','name'=>'admin-permission-assign','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9777','name'=>'admin-permission-remove','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9778','name'=>'admin-permission','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9779','name'=>'admin-role-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9780','name'=>'admin-role-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9781','name'=>'admin-role-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9782','name'=>'admin-role-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9783','name'=>'admin-role-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9784','name'=>'admin-role-assign','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9785','name'=>'admin-role-remove','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9786','name'=>'admin-role','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9787','name'=>'admin-route-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9788','name'=>'admin-route-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9789','name'=>'admin-route-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9790','name'=>'admin-route-assign','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9791','name'=>'admin-route-remove','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9792','name'=>'admin-route-refresh','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9793','name'=>'admin-route','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9794','name'=>'admin-rule-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9795','name'=>'admin-rule-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9796','name'=>'admin-rule-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9797','name'=>'admin-rule-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9798','name'=>'admin-rule-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9799','name'=>'admin-rule-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9800','name'=>'admin-rule','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9801','name'=>'admin-user-bloc','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9802','name'=>'admin-user-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9803','name'=>'admin-user-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9804','name'=>'admin-user-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9805','name'=>'admin-user-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9806','name'=>'admin-user-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9807','name'=>'admin-user-login','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9808','name'=>'admin-user-logout','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9809','name'=>'admin-user-signup','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9810','name'=>'admin-user-request-password-reset','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9811','name'=>'admin-user-reset-password','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9812','name'=>'admin-user-change-password','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9813','name'=>'admin-user-activate','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9814','name'=>'admin-user','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9815','name'=>'admin','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9816','name'=>'modal-modal-website','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9817','name'=>'modal-modal-icons','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9818','name'=>'modal-modal','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9819','name'=>'modal','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9820','name'=>'addons-addons-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9821','name'=>'addons-addons-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9822','name'=>'addons-addons-uninstalled','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9823','name'=>'addons-addons-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9824','name'=>'addons-addons-logo','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9825','name'=>'addons-addons-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9826','name'=>'addons-addons-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9827','name'=>'addons-addons-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9828','name'=>'addons-addons','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9829','name'=>'addons-manage-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9830','name'=>'addons-manage-install','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9831','name'=>'addons-manage-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9832','name'=>'addons-manage-uninstall','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9833','name'=>'addons-manage-auth','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9834','name'=>'addons-manage','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9835','name'=>'addons-menu-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9836','name'=>'addons-menu-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9837','name'=>'addons-menu-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9838','name'=>'addons-menu-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9839','name'=>'addons-menu-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9840','name'=>'addons-menu-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9841','name'=>'addons-menu','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9842','name'=>'addons','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9843','name'=>'gii-default-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9844','name'=>'gii-default-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9845','name'=>'gii-default-preview','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9846','name'=>'gii-default-diff','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9847','name'=>'gii-default-action','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9848','name'=>'gii-default','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9849','name'=>'gii','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9851','name'=>'base-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9852','name'=>'base','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9853','name'=>'module-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9854','name'=>'module-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9855','name'=>'module','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9856','name'=>'site-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9857','name'=>'site-index','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9858','name'=>'site-login','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9859','name'=>'site-logout','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9860','name'=>'site-signup','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9861','name'=>'site-request-password-reset','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9862','name'=>'site-reset-password','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9863','name'=>'site-verify-email','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9864','name'=>'site-resend-verification-email','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9865','name'=>'site','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9866','name'=>'article-dd-article-category-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9867','name'=>'article-dd-article-category-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9868','name'=>'article-dd-article-category-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9869','name'=>'article-dd-article-category-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9870','name'=>'article-dd-article-category-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9871','name'=>'article-dd-article-category-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9872','name'=>'article-dd-article-category-childcate','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9873','name'=>'article-dd-article-category','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9874','name'=>'article-dd-article-upload','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9875','name'=>'article-dd-article-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9876','name'=>'article-dd-article-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9877','name'=>'article-dd-article-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9878','name'=>'article-dd-article-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9879','name'=>'article-dd-article-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9880','name'=>'article-dd-article','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9881','name'=>'article-record-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9882','name'=>'article-record-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9883','name'=>'article-record-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9884','name'=>'article-record-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9885','name'=>'article-record-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9886','name'=>'article-record','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9887','name'=>'demo-form-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9888','name'=>'demo-form-get-region','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9889','name'=>'demo-form-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9890','name'=>'demo-form-maile','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9891','name'=>'demo-form','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9892','name'=>'member-dd-member-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9893','name'=>'member-dd-member-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9894','name'=>'member-dd-member-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9895','name'=>'member-dd-member-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9896','name'=>'member-dd-member-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9897','name'=>'member-dd-member-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9898','name'=>'member-dd-member','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9899','name'=>'member-dd-member-group-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9900','name'=>'member-dd-member-group-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9901','name'=>'member-dd-member-group-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9902','name'=>'member-dd-member-group-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9903','name'=>'member-dd-member-group-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9904','name'=>'member-dd-member-group-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9905','name'=>'member-dd-member-group','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9906','name'=>'system-index-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9907','name'=>'system-index-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9908','name'=>'system-index-childcate','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9909','name'=>'system-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9910','name'=>'system-settings-baidu','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9911','name'=>'system-settings-wxapp','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9912','name'=>'system-settings-wechatpay','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9913','name'=>'system-settings-sms','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9914','name'=>'system-settings-email','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9915','name'=>'system-settings-clear-cache','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9916','name'=>'system-settings','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9917','name'=>'system-welcome-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9918','name'=>'system-welcome-index','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9919','name'=>'system-welcome-sysai','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9920','name'=>'system-welcome-member','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9921','name'=>'system-welcome-aimember','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9922','name'=>'system-welcome-goods','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9923','name'=>'system-welcome-marketing','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9924','name'=>'system-welcome-order','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9925','name'=>'system-welcome-wxapp','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9926','name'=>'system-welcome-plugins','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9927','name'=>'system-welcome-system','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9928','name'=>'system-welcome','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9929','name'=>'upload-upload-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9930','name'=>'upload-upload-uploadimg','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9931','name'=>'upload-upload-uploadfile','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9932','name'=>'upload-upload','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9933','name'=>'user-dd-user-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9934','name'=>'user-dd-user-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9935','name'=>'user-dd-user-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9936','name'=>'user-dd-user-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9937','name'=>'user-dd-user-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9938','name'=>'user-dd-user-profile','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9939','name'=>'user-dd-user-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9940','name'=>'user-dd-user','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9941','name'=>'website-dd-website-contact-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9942','name'=>'website-dd-website-contact-index','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9943','name'=>'website-dd-website-contact-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9944','name'=>'website-dd-website-contact-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9945','name'=>'website-dd-website-contact-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9946','name'=>'website-dd-website-contact-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9947','name'=>'website-dd-website-contact','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9948','name'=>'website-dd-website-slide-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9949','name'=>'website-dd-website-slide-index','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9950','name'=>'website-dd-website-slide-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9951','name'=>'website-dd-website-slide-create','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9952','name'=>'website-dd-website-slide-update','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9953','name'=>'website-dd-website-slide-delete','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9954','name'=>'website-dd-website-slide','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9955','name'=>'website-setting-website','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9956','name'=>'website-setting','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9957','name'=>'*','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9958','name'=>'admin-group-assign','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9959','name'=>'admin-group-remove','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9960','name'=>'system-settings-map','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9961','name'=>'system-settings-set-cache','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9962','name'=>'settings-default','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'9963','name'=>'gii-addons','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10034','name'=>'system-database','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10035','name'=>'system-database-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10036','name'=>'system-database-backups','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10037','name'=>'system-database-export','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10038','name'=>'system-database-export-start','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10039','name'=>'system-database-optimize','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10040','name'=>'system-database-repair','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10041','name'=>'system-database-restore','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10042','name'=>'system-database-restore-init','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10043','name'=>'system-database-restore-start','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10044','name'=>'system-database-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10045','name'=>'system-database-data-dictionary','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10046','name'=>'system-database-backlist','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10050','name'=>'ds','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10051','name'=>'debug-default-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10052','name'=>'debug','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10053','name'=>'settings-default-edit-setting','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10054','name'=>'debug-default-db-explain','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10055','name'=>'debug-default-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10056','name'=>'debug-default-toolbar','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10057','name'=>'debug-default-download-mail','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10058','name'=>'debug-default','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10059','name'=>'debug-user-set-identity','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10060','name'=>'debug-user-reset-identity','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10061','name'=>'debug-user','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10095','name'=>'site-setpassword','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10096','name'=>'admin-user-assign','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10097','name'=>'admin-user-remove','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10098','name'=>'diandi-shop-wxapp-dd-wxapp-page-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10099','name'=>'diandi-shop-wxapp-dd-wxapp-page-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10100','name'=>'diandi-shop-wxapp-dd-wxapp-page-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10101','name'=>'diandi-shop-wxapp-dd-wxapp-page-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10102','name'=>'diandi-shop-wxapp-dd-wxapp-page-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10115','name'=>'diandi-store-record-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10116','name'=>'diandi-store-record-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10117','name'=>'diandi-store-record-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10118','name'=>'diandi-store-record-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10119','name'=>'diandi-store-record-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10120','name'=>'diandi-store-record-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10121','name'=>'diandi-store-record','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10122','name'=>'diandi-store-store-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10123','name'=>'diandi-store-store-get-region','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10124','name'=>'diandi-store-store-setting','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10125','name'=>'diandi-store-store-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10126','name'=>'diandi-store-store-adds','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10127','name'=>'diandi-store-store-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10128','name'=>'diandi-store-store-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10129','name'=>'diandi-store-store-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10130','name'=>'diandi-store-store-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10131','name'=>'diandi-store-store','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10132','name'=>'diandi-store-store-seat-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10133','name'=>'diandi-store-store-seat-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10134','name'=>'diandi-store-store-seat-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10135','name'=>'diandi-store-store-seat-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10136','name'=>'diandi-store-store-seat-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10137','name'=>'diandi-store-store-seat-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10138','name'=>'diandi-store-store-seat','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10139','name'=>'diandi-store-store-service-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10140','name'=>'diandi-store-store-service-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10141','name'=>'diandi-store-store-service-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10142','name'=>'diandi-store-store-service-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10143','name'=>'diandi-store-store-service-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10144','name'=>'diandi-store-store-service-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10145','name'=>'diandi-store-store-service','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10146','name'=>'diandi-store-store-share-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10147','name'=>'diandi-store-store-share-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10148','name'=>'diandi-store-store-share-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10149','name'=>'diandi-store-store-share-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10150','name'=>'diandi-store-store-share-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10151','name'=>'diandi-store-store-share-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10152','name'=>'diandi-store-store-share','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10153','name'=>'diandi-store-store-slide-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10154','name'=>'diandi-store-store-slide-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10155','name'=>'diandi-store-store-slide-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10156','name'=>'diandi-store-store-slide-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10157','name'=>'diandi-store-store-slide-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10158','name'=>'diandi-store-store-slide-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10159','name'=>'diandi-store-store-slide','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10225','name'=>'member-dd-member-cac-vs','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10226','name'=>'system-settings-wechat','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10249','name'=>'admin-category-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10250','name'=>'admin-category-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10251','name'=>'admin-category-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10252','name'=>'admin-category-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10253','name'=>'admin-category-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10254','name'=>'admin-category-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10255','name'=>'admin-category','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10256','name'=>'admin-store-childcate','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10269','name'=>'addons-menu-update-files','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10270','name'=>'member-account-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10271','name'=>'member-account-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10272','name'=>'member-account-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10273','name'=>'member-account-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10274','name'=>'member-account-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10275','name'=>'member-account-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10276','name'=>'member-account','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10277','name'=>'member-dd-member-repassword','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10278','name'=>'addons-baidu-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10279','name'=>'addons-baidu-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10280','name'=>'addons-baidu-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10281','name'=>'addons-baidu-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10282','name'=>'addons-baidu-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10283','name'=>'addons-baidu-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10284','name'=>'addons-baidu','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10285','name'=>'addons-bloc-change-username','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10286','name'=>'addons-bloc-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10287','name'=>'addons-bloc-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10288','name'=>'addons-bloc-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10289','name'=>'addons-bloc-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10290','name'=>'addons-bloc-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10291','name'=>'addons-bloc','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10292','name'=>'addons-category-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10293','name'=>'addons-category-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10294','name'=>'addons-category-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10295','name'=>'addons-category-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10296','name'=>'addons-category-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10297','name'=>'addons-category-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10298','name'=>'addons-category','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10299','name'=>'addons-email-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10300','name'=>'addons-email-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10301','name'=>'addons-email-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10302','name'=>'addons-email-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10303','name'=>'addons-email-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10304','name'=>'addons-email-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10305','name'=>'addons-email','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10306','name'=>'addons-setting','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10307','name'=>'addons-sms-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10308','name'=>'addons-sms-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10309','name'=>'addons-sms-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10310','name'=>'addons-sms-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10311','name'=>'addons-sms-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10312','name'=>'addons-sms-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10313','name'=>'addons-sms','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10314','name'=>'addons-user-bloc','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10315','name'=>'addons-store-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10316','name'=>'addons-store-get-region','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10317','name'=>'addons-store-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10318','name'=>'addons-store-childcate','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10319','name'=>'addons-store-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10320','name'=>'addons-store-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10321','name'=>'addons-store-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10322','name'=>'addons-store-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10323','name'=>'addons-store','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10324','name'=>'addons-storelabel-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10325','name'=>'addons-storelabel-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10326','name'=>'addons-storelabel-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10327','name'=>'addons-storelabel-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10328','name'=>'addons-storelabel-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10329','name'=>'addons-storelabel-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10330','name'=>'addons-storelabel','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10331','name'=>'addons-storelabellink-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10332','name'=>'addons-storelabellink-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10333','name'=>'addons-storelabellink-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10334','name'=>'addons-storelabellink-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10335','name'=>'addons-storelabellink-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10336','name'=>'addons-storelabellink-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10337','name'=>'addons-storelabellink','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10338','name'=>'addons-wechatpay-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10339','name'=>'addons-wechatpay-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10340','name'=>'addons-wechatpay-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10341','name'=>'addons-wechatpay-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10342','name'=>'addons-wechatpay-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10343','name'=>'addons-wechatpay-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10344','name'=>'addons-wechatpay','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10345','name'=>'addons-wxapp-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10346','name'=>'addons-wxapp-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10347','name'=>'addons-wxapp-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10348','name'=>'addons-wxapp-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10349','name'=>'addons-wxapp-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10350','name'=>'addons-wxapp-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10351','name'=>'addons-wxapp','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10440','name'=>'member-dd-member-groups','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10441','name'=>'system-settings-store','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10442','name'=>'settings','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10447','name'=>'system-index-info','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'10448','name'=>'system-settings-them','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11165','name'=>'addons-bloclevel-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11166','name'=>'addons-bloclevel-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11167','name'=>'addons-bloclevel-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11168','name'=>'addons-bloclevel-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11169','name'=>'addons-bloclevel-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11170','name'=>'addons-bloclevel-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11171','name'=>'addons-bloclevel','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11324','name'=>'addons-addonsstore-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11325','name'=>'addons-addonsstore-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11326','name'=>'addons-addonsstore-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11327','name'=>'addons-addonsstore-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11328','name'=>'addons-addonsstore-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11329','name'=>'addons-addonsstore-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11330','name'=>'addons-addonsstore','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11339','name'=>'addons-bloc-bloc-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11340','name'=>'addons-bloc-list','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11341','name'=>'addons-bloc-bloclevel-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11342','name'=>'addons-bloc-list-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11343','name'=>'addons-bloc-blocset-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11344','name'=>'addons-store-list-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11345','name'=>'addons-store-category-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11346','name'=>'addons-store-storelabel-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11347','name'=>'dashboard','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11348','name'=>'documentation-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11349','name'=>'admin-route-init','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11428','name'=>'ceshi-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11429','name'=>'ceshi-swgdoc','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11430','name'=>'ceshi-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11431','name'=>'ceshi-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11432','name'=>'ceshi-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11433','name'=>'ceshi-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11434','name'=>'ceshi-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11435','name'=>'ceshi','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11436','name'=>'map-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11437','name'=>'map-distance','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11438','name'=>'map-citylist','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11439','name'=>'map-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11440','name'=>'map-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11441','name'=>'map-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11442','name'=>'map-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11443','name'=>'map-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11444','name'=>'map','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11445','name'=>'site-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11446','name'=>'site-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11447','name'=>'site-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11448','name'=>'site-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11449','name'=>'site-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11450','name'=>'store-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11451','name'=>'store-info','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11452','name'=>'store-detailinfo','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11453','name'=>'store-cate','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11454','name'=>'store-list','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11455','name'=>'store-blocs','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11456','name'=>'store-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11457','name'=>'store-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11458','name'=>'store-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11459','name'=>'store-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11460','name'=>'store-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11461','name'=>'store','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11462','name'=>'upload-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11463','name'=>'upload-images','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11464','name'=>'upload-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11465','name'=>'upload-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11466','name'=>'upload-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11467','name'=>'upload-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11468','name'=>'upload-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11469','name'=>'upload','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11470','name'=>'user-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11471','name'=>'user-signup','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11472','name'=>'user-login','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11473','name'=>'user-repassword','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11474','name'=>'user-userinfo','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11475','name'=>'user-bindmobile','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11476','name'=>'user-edituserinfo','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11477','name'=>'user-forgetpass','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11478','name'=>'user-sendcode','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11479','name'=>'user-refresh','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11480','name'=>'user-feedback','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11481','name'=>'user-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11482','name'=>'user-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11483','name'=>'user-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11484','name'=>'user-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11485','name'=>'user-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11486','name'=>'user','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11487','name'=>'addons-addons-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11488','name'=>'addons-addons-list','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11489','name'=>'article-dd-article-ceshi','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11490','name'=>'auth-assignment-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11491','name'=>'auth-assignment-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11492','name'=>'auth-assignment-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11493','name'=>'auth-assignment-assign','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11494','name'=>'auth-assignment-revoke','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11495','name'=>'auth-assignment-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11496','name'=>'auth-assignment-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11497','name'=>'auth-assignment-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11498','name'=>'auth-assignment','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11499','name'=>'auth-category-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11500','name'=>'auth-category-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11501','name'=>'auth-category-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11502','name'=>'auth-category-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11503','name'=>'auth-category-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11504','name'=>'auth-category-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11505','name'=>'auth-category','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11506','name'=>'auth-default-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11507','name'=>'auth-default-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11508','name'=>'auth-default','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11509','name'=>'auth-group','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11510','name'=>'auth-menu-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11511','name'=>'auth-menu-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11512','name'=>'auth-menu-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11513','name'=>'auth-menu-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11514','name'=>'auth-menu-levels','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11515','name'=>'auth-menu-route','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11516','name'=>'auth-menu-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11517','name'=>'auth-menu-update-files','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11518','name'=>'auth-menu-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11519','name'=>'auth-menu','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11520','name'=>'auth-menu-top-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11521','name'=>'auth-menu-top-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11522','name'=>'auth-menu-top-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11523','name'=>'auth-menu-top-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11524','name'=>'auth-menu-top-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11525','name'=>'auth-menu-top-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11526','name'=>'auth-menu-top','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11527','name'=>'auth-permission','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11528','name'=>'auth-role-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11529','name'=>'auth-role-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11530','name'=>'auth-role-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11531','name'=>'auth-role-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11532','name'=>'auth-role-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11533','name'=>'auth-role-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11534','name'=>'auth-role','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11535','name'=>'auth-route-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11536','name'=>'auth-route-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11537','name'=>'auth-route-available','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11538','name'=>'auth-route-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11539','name'=>'auth-route-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11540','name'=>'auth-route-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11541','name'=>'auth-route-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11542','name'=>'auth-route-assign','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11543','name'=>'auth-route-remove','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11544','name'=>'auth-route-refresh','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11545','name'=>'auth-route','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11546','name'=>'auth-rule-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11547','name'=>'auth-rule-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11548','name'=>'auth-rule-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11549','name'=>'auth-rule-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11550','name'=>'auth-rule-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11551','name'=>'auth-rule-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11552','name'=>'auth-rule','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11553','name'=>'auth-user','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11554','name'=>'website-dd-website-slide-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11555','name'=>'website-dd-website-slide-updateitem','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11556','name'=>'website-dd-website-slide-deleteitem','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11579','name'=>'example-index','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11580','name'=>'example-base-page-edit','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11587','name'=>'dd-article-add','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11588','name'=>'bloc-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11589','name'=>'dd-article','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11590','name'=>'dd-article-edit','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11591','name'=>'main-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11600','name'=>'member-organization','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11618','name'=>'system-settings-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11649','name'=>'store-welcome','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11652','name'=>'settings-default-update','is_sys'=>'1','permission_type'=>'0','description'=>'描述1','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11653','name'=>'settings-default-index','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11654','name'=>'settings-default-create','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11655','name'=>'settings-default-delete','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11656','name'=>'admin-assignment-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11657','name'=>'admin-assignment-index','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11658','name'=>'admin-assignment-view','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11659','name'=>'admin-assignment-assign','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11660','name'=>'admin-assignment-revoke','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11661','name'=>'admin-assignment','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11662','name'=>'admin-default-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11663','name'=>'admin-default-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11664','name'=>'admin-default','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11665','name'=>'admin-group-error','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11666','name'=>'admin-group-index','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11667','name'=>'admin-group-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11668','name'=>'admin-group-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11669','name'=>'admin-group-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11670','name'=>'admin-group-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11671','name'=>'admin-group','is_sys'=>'1','permission_type'=>'0','description'=>'描述','rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11672','name'=>'admin-menu-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11673','name'=>'admin-menu-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11674','name'=>'admin-menu-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11675','name'=>'admin-menu-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11676','name'=>'admin-menu-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11677','name'=>'admin-menu-update-files','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11678','name'=>'admin-menu-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11679','name'=>'admin-menu','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11680','name'=>'admin-menu-top-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11681','name'=>'admin-menu-top-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11682','name'=>'admin-menu-top-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11683','name'=>'admin-menu-top-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11684','name'=>'admin-menu-top-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11685','name'=>'admin-menu-top','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11686','name'=>'admin-permission-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11687','name'=>'admin-permission-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11688','name'=>'admin-permission-create','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11689','name'=>'admin-permission-update','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11690','name'=>'admin-permission-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11691','name'=>'admin-permission-assign','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11692','name'=>'admin-permission-remove','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11693','name'=>'admin-permission','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11694','name'=>'admin-role-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11695','name'=>'admin-role-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11696','name'=>'admin-role-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11697','name'=>'admin-role-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11698','name'=>'admin-role-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11699','name'=>'admin-role-assign','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11700','name'=>'admin-role-remove','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11701','name'=>'admin-role','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11702','name'=>'admin-route-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11703','name'=>'admin-route-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11704','name'=>'admin-route-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11705','name'=>'admin-route-assign','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11706','name'=>'admin-route-remove','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11707','name'=>'admin-route-refresh','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11708','name'=>'admin-route','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11709','name'=>'admin-rule-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11710','name'=>'admin-rule-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11711','name'=>'admin-rule-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11712','name'=>'admin-rule-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11713','name'=>'admin-rule-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11714','name'=>'admin-rule-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11715','name'=>'admin-rule','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11716','name'=>'admin-user-bloc','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11717','name'=>'admin-user-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11718','name'=>'admin-user-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11719','name'=>'admin-user-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11720','name'=>'admin-user-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11721','name'=>'admin-user-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11722','name'=>'admin-user-login','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11723','name'=>'admin-user-logout','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11724','name'=>'admin-user-signup','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11725','name'=>'admin-user-request-password-reset','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11726','name'=>'admin-user-reset-password','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11727','name'=>'admin-user-change-password','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11728','name'=>'admin-user-activate','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11729','name'=>'admin-user','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11730','name'=>'admin','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11731','name'=>'modal-modal-website','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11732','name'=>'modal-modal-icons','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11733','name'=>'modal-modal','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11734','name'=>'modal','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11735','name'=>'addons-addons-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11736','name'=>'addons-addons-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11737','name'=>'addons-addons-uninstalled','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11738','name'=>'addons-addons-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11739','name'=>'addons-addons-logo','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11740','name'=>'addons-addons-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11741','name'=>'addons-addons-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11742','name'=>'addons-addons-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11743','name'=>'addons-addons','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11744','name'=>'addons-manage-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11745','name'=>'addons-manage-install','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11746','name'=>'addons-manage-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11747','name'=>'addons-manage-uninstall','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11748','name'=>'addons-manage-auth','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11749','name'=>'addons-manage','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11750','name'=>'addons-menu-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11751','name'=>'addons-menu-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11752','name'=>'addons-menu-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11753','name'=>'addons-menu-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11754','name'=>'addons-menu-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11755','name'=>'addons-menu-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11756','name'=>'addons-menu','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11757','name'=>'addons','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11758','name'=>'gii-default-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11759','name'=>'gii-default-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11760','name'=>'gii-default-preview','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11761','name'=>'gii-default-diff','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11762','name'=>'gii-default-action','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11763','name'=>'gii-default','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11764','name'=>'gii','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11766','name'=>'base-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11767','name'=>'base','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11768','name'=>'module-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11769','name'=>'module-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11770','name'=>'module','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11771','name'=>'site-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11772','name'=>'site-index','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11773','name'=>'site-login','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11774','name'=>'site-logout','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11775','name'=>'site-signup','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11776','name'=>'site-request-password-reset','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11777','name'=>'site-reset-password','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11778','name'=>'site-verify-email','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11779','name'=>'site-resend-verification-email','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11780','name'=>'site','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11781','name'=>'article-dd-article-category-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11782','name'=>'article-dd-article-category-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11783','name'=>'article-dd-article-category-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11784','name'=>'article-dd-article-category-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11785','name'=>'article-dd-article-category-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11786','name'=>'article-dd-article-category-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11787','name'=>'article-dd-article-category-childcate','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11788','name'=>'article-dd-article-category','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11789','name'=>'article-dd-article-upload','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11790','name'=>'article-dd-article-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11791','name'=>'article-dd-article-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11792','name'=>'article-dd-article-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11793','name'=>'article-dd-article-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11794','name'=>'article-dd-article-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11795','name'=>'article-dd-article','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11796','name'=>'article-record-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11797','name'=>'article-record-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11798','name'=>'article-record-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11799','name'=>'article-record-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11800','name'=>'article-record-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11801','name'=>'article-record','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11802','name'=>'demo-form-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11803','name'=>'demo-form-get-region','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11804','name'=>'demo-form-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11805','name'=>'demo-form-maile','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11806','name'=>'demo-form','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11807','name'=>'member-dd-member-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11808','name'=>'member-dd-member-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11809','name'=>'member-dd-member-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11810','name'=>'member-dd-member-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11811','name'=>'member-dd-member-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11812','name'=>'member-dd-member-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11813','name'=>'member-dd-member','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11814','name'=>'member-dd-member-group-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11815','name'=>'member-dd-member-group-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11816','name'=>'member-dd-member-group-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11817','name'=>'member-dd-member-group-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11818','name'=>'member-dd-member-group-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11819','name'=>'member-dd-member-group-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11820','name'=>'member-dd-member-group','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11821','name'=>'system-index-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11822','name'=>'system-index-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11823','name'=>'system-index-childcate','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11824','name'=>'system-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11825','name'=>'system-settings-baidu','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11826','name'=>'system-settings-wxapp','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11827','name'=>'system-settings-wechatpay','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11828','name'=>'system-settings-sms','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11829','name'=>'system-settings-email','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11830','name'=>'system-settings-clear-cache','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11831','name'=>'system-settings','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11832','name'=>'system-welcome-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11833','name'=>'system-welcome-index','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11834','name'=>'system-welcome-sysai','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11835','name'=>'system-welcome-member','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11836','name'=>'system-welcome-aimember','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11837','name'=>'system-welcome-goods','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11838','name'=>'system-welcome-marketing','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11839','name'=>'system-welcome-order','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11840','name'=>'system-welcome-wxapp','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11841','name'=>'system-welcome-plugins','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11842','name'=>'system-welcome-system','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11843','name'=>'system-welcome','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11844','name'=>'upload-upload-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11845','name'=>'upload-upload-uploadimg','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11846','name'=>'upload-upload-uploadfile','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11847','name'=>'upload-upload','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11848','name'=>'user-dd-user-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11849','name'=>'user-dd-user-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11850','name'=>'user-dd-user-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11851','name'=>'user-dd-user-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11852','name'=>'user-dd-user-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11853','name'=>'user-dd-user-profile','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11854','name'=>'user-dd-user-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11855','name'=>'user-dd-user','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11856','name'=>'website-dd-website-contact-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11857','name'=>'website-dd-website-contact-index','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11858','name'=>'website-dd-website-contact-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11859','name'=>'website-dd-website-contact-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11860','name'=>'website-dd-website-contact-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11861','name'=>'website-dd-website-contact-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11862','name'=>'website-dd-website-contact','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11863','name'=>'website-dd-website-slide-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11864','name'=>'website-dd-website-slide-index','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11865','name'=>'website-dd-website-slide-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11866','name'=>'website-dd-website-slide-create','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11867','name'=>'website-dd-website-slide-update','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11868','name'=>'website-dd-website-slide-delete','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11869','name'=>'website-dd-website-slide','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11870','name'=>'website-setting-website','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11871','name'=>'website-setting','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11872','name'=>'*','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11873','name'=>'admin-group-assign','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11874','name'=>'admin-group-remove','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11875','name'=>'system-settings-map','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11876','name'=>'system-settings-set-cache','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11877','name'=>'settings-default','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11878','name'=>'gii-addons','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11949','name'=>'system-database','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11950','name'=>'system-database-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11951','name'=>'system-database-backups','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11952','name'=>'system-database-export','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11953','name'=>'system-database-export-start','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11954','name'=>'system-database-optimize','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11955','name'=>'system-database-repair','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11956','name'=>'system-database-restore','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11957','name'=>'system-database-restore-init','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11958','name'=>'system-database-restore-start','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11959','name'=>'system-database-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11960','name'=>'system-database-data-dictionary','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11961','name'=>'system-database-backlist','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11965','name'=>'ds','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11966','name'=>'debug-default-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11967','name'=>'debug','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11968','name'=>'settings-default-edit-setting','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11969','name'=>'debug-default-db-explain','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11970','name'=>'debug-default-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11971','name'=>'debug-default-toolbar','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11972','name'=>'debug-default-download-mail','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11973','name'=>'debug-default','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11974','name'=>'debug-user-set-identity','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11975','name'=>'debug-user-reset-identity','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'11976','name'=>'debug-user','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12010','name'=>'site-setpassword','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12011','name'=>'admin-user-assign','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12012','name'=>'admin-user-remove','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12013','name'=>'diandi-shop-wxapp-dd-wxapp-page-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12014','name'=>'diandi-shop-wxapp-dd-wxapp-page-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12015','name'=>'diandi-shop-wxapp-dd-wxapp-page-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12016','name'=>'diandi-shop-wxapp-dd-wxapp-page-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12017','name'=>'diandi-shop-wxapp-dd-wxapp-page-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12030','name'=>'diandi-store-record-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12031','name'=>'diandi-store-record-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12032','name'=>'diandi-store-record-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12033','name'=>'diandi-store-record-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12034','name'=>'diandi-store-record-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12035','name'=>'diandi-store-record-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12036','name'=>'diandi-store-record','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12037','name'=>'diandi-store-store-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12038','name'=>'diandi-store-store-get-region','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12039','name'=>'diandi-store-store-setting','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12040','name'=>'diandi-store-store-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12041','name'=>'diandi-store-store-adds','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12042','name'=>'diandi-store-store-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12043','name'=>'diandi-store-store-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12044','name'=>'diandi-store-store-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12045','name'=>'diandi-store-store-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12046','name'=>'diandi-store-store','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12047','name'=>'diandi-store-store-seat-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12048','name'=>'diandi-store-store-seat-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12049','name'=>'diandi-store-store-seat-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12050','name'=>'diandi-store-store-seat-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12051','name'=>'diandi-store-store-seat-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12052','name'=>'diandi-store-store-seat-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12053','name'=>'diandi-store-store-seat','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12054','name'=>'diandi-store-store-service-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12055','name'=>'diandi-store-store-service-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12056','name'=>'diandi-store-store-service-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12057','name'=>'diandi-store-store-service-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12058','name'=>'diandi-store-store-service-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12059','name'=>'diandi-store-store-service-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12060','name'=>'diandi-store-store-service','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12061','name'=>'diandi-store-store-share-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12062','name'=>'diandi-store-store-share-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12063','name'=>'diandi-store-store-share-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12064','name'=>'diandi-store-store-share-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12065','name'=>'diandi-store-store-share-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12066','name'=>'diandi-store-store-share-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12067','name'=>'diandi-store-store-share','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12068','name'=>'diandi-store-store-slide-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12069','name'=>'diandi-store-store-slide-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12070','name'=>'diandi-store-store-slide-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12071','name'=>'diandi-store-store-slide-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12072','name'=>'diandi-store-store-slide-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12073','name'=>'diandi-store-store-slide-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12074','name'=>'diandi-store-store-slide','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12140','name'=>'member-dd-member-cac-vs','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12141','name'=>'system-settings-wechat','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12164','name'=>'admin-category-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12165','name'=>'admin-category-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12166','name'=>'admin-category-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12167','name'=>'admin-category-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12168','name'=>'admin-category-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12169','name'=>'admin-category-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12170','name'=>'admin-category','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12171','name'=>'admin-store-childcate','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12184','name'=>'addons-menu-update-files','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12185','name'=>'member-account-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12186','name'=>'member-account-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12187','name'=>'member-account-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12188','name'=>'member-account-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12189','name'=>'member-account-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12190','name'=>'member-account-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12191','name'=>'member-account','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12192','name'=>'member-dd-member-repassword','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12193','name'=>'addons-baidu-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12194','name'=>'addons-baidu-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12195','name'=>'addons-baidu-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12196','name'=>'addons-baidu-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12197','name'=>'addons-baidu-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12198','name'=>'addons-baidu-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12199','name'=>'addons-baidu','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12200','name'=>'addons-bloc-change-username','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12201','name'=>'addons-bloc-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12202','name'=>'addons-bloc-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12203','name'=>'addons-bloc-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12204','name'=>'addons-bloc-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12205','name'=>'addons-bloc-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12206','name'=>'addons-bloc','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12207','name'=>'addons-category-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12208','name'=>'addons-category-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12209','name'=>'addons-category-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12210','name'=>'addons-category-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12211','name'=>'addons-category-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12212','name'=>'addons-category-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12213','name'=>'addons-category','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12214','name'=>'addons-email-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12215','name'=>'addons-email-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12216','name'=>'addons-email-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12217','name'=>'addons-email-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12218','name'=>'addons-email-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12219','name'=>'addons-email-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12220','name'=>'addons-email','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12221','name'=>'addons-setting','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12222','name'=>'addons-sms-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12223','name'=>'addons-sms-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12224','name'=>'addons-sms-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12225','name'=>'addons-sms-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12226','name'=>'addons-sms-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12227','name'=>'addons-sms-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12228','name'=>'addons-sms','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12229','name'=>'addons-user-bloc','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12230','name'=>'addons-store-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12231','name'=>'addons-store-get-region','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12232','name'=>'addons-store-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12233','name'=>'addons-store-childcate','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12234','name'=>'addons-store-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12235','name'=>'addons-store-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12236','name'=>'addons-store-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12237','name'=>'addons-store-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12238','name'=>'addons-store','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12239','name'=>'addons-storelabel-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12240','name'=>'addons-storelabel-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12241','name'=>'addons-storelabel-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12242','name'=>'addons-storelabel-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12243','name'=>'addons-storelabel-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12244','name'=>'addons-storelabel-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12245','name'=>'addons-storelabel','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12246','name'=>'addons-storelabellink-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12247','name'=>'addons-storelabellink-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12248','name'=>'addons-storelabellink-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12249','name'=>'addons-storelabellink-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12250','name'=>'addons-storelabellink-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12251','name'=>'addons-storelabellink-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12252','name'=>'addons-storelabellink','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12253','name'=>'addons-wechatpay-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12254','name'=>'addons-wechatpay-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12255','name'=>'addons-wechatpay-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12256','name'=>'addons-wechatpay-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12257','name'=>'addons-wechatpay-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12258','name'=>'addons-wechatpay-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12259','name'=>'addons-wechatpay','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12260','name'=>'addons-wxapp-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12261','name'=>'addons-wxapp-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12262','name'=>'addons-wxapp-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12263','name'=>'addons-wxapp-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12264','name'=>'addons-wxapp-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12265','name'=>'addons-wxapp-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12266','name'=>'addons-wxapp','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12355','name'=>'member-dd-member-groups','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12356','name'=>'system-settings-store','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12357','name'=>'settings','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12362','name'=>'system-index-info','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'12363','name'=>'system-settings-them','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'3','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13080','name'=>'addons-bloclevel-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13081','name'=>'addons-bloclevel-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13082','name'=>'addons-bloclevel-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13083','name'=>'addons-bloclevel-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13084','name'=>'addons-bloclevel-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13085','name'=>'addons-bloclevel-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13086','name'=>'addons-bloclevel','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13239','name'=>'addons-addonsstore-error','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13240','name'=>'addons-addonsstore-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13241','name'=>'addons-addonsstore-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13242','name'=>'addons-addonsstore-create','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13243','name'=>'addons-addonsstore-update','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13244','name'=>'addons-addonsstore-delete','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13245','name'=>'addons-addonsstore','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13254','name'=>'addons-bloc-bloc-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13255','name'=>'addons-bloc-list','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13256','name'=>'addons-bloc-bloclevel-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13257','name'=>'addons-bloc-list-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13258','name'=>'addons-bloc-blocset-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13259','name'=>'addons-store-list-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13260','name'=>'addons-store-category-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13261','name'=>'addons-store-storelabel-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13262','name'=>'/dashboard','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13263','name'=>'documentation-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13264','name'=>'admin-route-init','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13343','name'=>'ceshi-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13344','name'=>'ceshi-swgdoc','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13345','name'=>'ceshi-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13346','name'=>'ceshi-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13347','name'=>'ceshi-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13348','name'=>'ceshi-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13349','name'=>'ceshi-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13350','name'=>'ceshi','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13351','name'=>'map-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13352','name'=>'map-distance','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13353','name'=>'map-citylist','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13354','name'=>'map-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13355','name'=>'map-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13356','name'=>'map-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13357','name'=>'map-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13358','name'=>'map-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13359','name'=>'map','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13360','name'=>'site-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13361','name'=>'site-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13362','name'=>'site-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13363','name'=>'site-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13364','name'=>'site-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13365','name'=>'store-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13366','name'=>'store-info','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13367','name'=>'store-detailinfo','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13368','name'=>'store-cate','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13369','name'=>'store-list','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13370','name'=>'store-blocs','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13371','name'=>'store-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13372','name'=>'store-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13373','name'=>'store-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13374','name'=>'store-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13375','name'=>'store-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13376','name'=>'store','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13377','name'=>'upload-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13378','name'=>'upload-images','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13379','name'=>'upload-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13380','name'=>'upload-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13381','name'=>'upload-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13382','name'=>'upload-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13383','name'=>'upload-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13384','name'=>'upload','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13385','name'=>'user-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13386','name'=>'user-signup','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13387','name'=>'user-login','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13388','name'=>'user-repassword','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13389','name'=>'user-userinfo','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13390','name'=>'user-bindmobile','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13391','name'=>'user-edituserinfo','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13392','name'=>'user-forgetpass','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13393','name'=>'user-sendcode','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13394','name'=>'user-refresh','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13395','name'=>'user-feedback','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13396','name'=>'user-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13397','name'=>'user-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13398','name'=>'user-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13399','name'=>'user-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13400','name'=>'user-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13401','name'=>'user','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13402','name'=>'addons-addons-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13403','name'=>'addons-addons-list','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13404','name'=>'article-dd-article-ceshi','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13405','name'=>'auth-assignment-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13406','name'=>'auth-assignment-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13407','name'=>'auth-assignment-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13408','name'=>'auth-assignment-assign','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13409','name'=>'auth-assignment-revoke','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13410','name'=>'auth-assignment-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13411','name'=>'auth-assignment-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13412','name'=>'auth-assignment-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13413','name'=>'auth-assignment','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13414','name'=>'auth-category-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13415','name'=>'auth-category-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13416','name'=>'auth-category-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13417','name'=>'auth-category-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13418','name'=>'auth-category-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13419','name'=>'auth-category-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13420','name'=>'auth-category','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13421','name'=>'auth-default-error','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13422','name'=>'auth-default-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13423','name'=>'auth-default','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13424','name'=>'auth-group','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13425','name'=>'auth-menu-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13426','name'=>'auth-menu-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13427','name'=>'auth-menu-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13428','name'=>'auth-menu-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13429','name'=>'auth-menu-levels','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13430','name'=>'auth-menu-route','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13431','name'=>'auth-menu-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13432','name'=>'auth-menu-update-files','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13433','name'=>'auth-menu-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13434','name'=>'auth-menu','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13435','name'=>'auth-menu-top-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13436','name'=>'auth-menu-top-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13437','name'=>'auth-menu-top-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13438','name'=>'auth-menu-top-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13439','name'=>'auth-menu-top-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13440','name'=>'auth-menu-top-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13441','name'=>'auth-menu-top','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13442','name'=>'auth-permission','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13443','name'=>'auth-role-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13444','name'=>'auth-role-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13445','name'=>'auth-role-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13446','name'=>'auth-role-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13447','name'=>'auth-role-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13448','name'=>'auth-role-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13449','name'=>'auth-role','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13450','name'=>'auth-route-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13451','name'=>'auth-route-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13452','name'=>'auth-route-available','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13453','name'=>'auth-route-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13454','name'=>'auth-route-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13455','name'=>'auth-route-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13456','name'=>'auth-route-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13457','name'=>'auth-route-assign','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13458','name'=>'auth-route-remove','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13459','name'=>'auth-route-refresh','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13460','name'=>'auth-route','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13461','name'=>'auth-rule-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13462','name'=>'auth-rule-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13463','name'=>'auth-rule-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13464','name'=>'auth-rule-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13465','name'=>'auth-rule-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13466','name'=>'auth-rule-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13467','name'=>'auth-rule','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13468','name'=>'auth-user','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13469','name'=>'website-dd-website-slide-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13470','name'=>'website-dd-website-slide-updateitem','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13471','name'=>'website-dd-website-slide-deleteitem','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13494','name'=>'/example/index.vue','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13495','name'=>'example-base-page-edit','is_sys'=>'1','permission_type'=>'0','description'=>'','rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13502','name'=>'dd-article-add','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13503','name'=>'bloc-view','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13504','name'=>'dd-article','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13505','name'=>'dd-article-edit','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'2','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13506','name'=>'/main/index.vue','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13515','name'=>'member-organization','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13533','name'=>'system-settings-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'1','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13564','name'=>'addons-store-welcome-index','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13834','name'=>'a-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13835','name'=>'a-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13836','name'=>'a-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13837','name'=>'a-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13838','name'=>'a-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13839','name'=>'a-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13840','name'=>'a-*','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13841','name'=>'module-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13842','name'=>'module-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13843','name'=>'module-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13844','name'=>'module-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13845','name'=>'module-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13846','name'=>'store-detail','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13847','name'=>'user-userlist','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13848','name'=>'user-addons','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13849','name'=>'addons-baidu-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13850','name'=>'addons-bloc-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13851','name'=>'addons-bloc-store-group','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13852','name'=>'addons-bloc-parentbloc','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13853','name'=>'addons-bloc-childbloc','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13854','name'=>'addons-bloc-stores','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13855','name'=>'addons-bloc-reglevel','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13856','name'=>'addons-bloc-blocstatus','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13857','name'=>'addons-bloc-levels','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13858','name'=>'addons-bloclevel-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13859','name'=>'addons-bloclevel-levels','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13860','name'=>'addons-category-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13861','name'=>'addons-category-category','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13862','name'=>'addons-email-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13863','name'=>'addons-manage-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13864','name'=>'addons-manage-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13865','name'=>'addons-manage-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13866','name'=>'addons-manage-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13867','name'=>'addons-manage-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13868','name'=>'addons-setting-baidu','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13869','name'=>'addons-setting-wechatpay','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13870','name'=>'addons-setting-sms','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13871','name'=>'addons-setting-email','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13872','name'=>'addons-setting-wxapp','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13873','name'=>'addons-setting-wechat','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13874','name'=>'addons-setting-microapp','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13875','name'=>'addons-setting-app','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13876','name'=>'addons-setting-map','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13877','name'=>'addons-setting-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13878','name'=>'addons-setting-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13879','name'=>'addons-setting-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13880','name'=>'addons-setting-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13881','name'=>'addons-setting-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13882','name'=>'addons-sms-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13883','name'=>'addons-store-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13884','name'=>'addons-store-category','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13885','name'=>'addons-store-blocs','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13886','name'=>'addons-store-storestatus','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13887','name'=>'addons-storelabel-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13888','name'=>'addons-storelabellink-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13889','name'=>'addons-user-bloc-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13890','name'=>'addons-user-bloc-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13891','name'=>'addons-user-bloc-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13892','name'=>'addons-user-bloc-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13893','name'=>'addons-user-bloc-getstore','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13894','name'=>'addons-user-bloc-getuser','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13895','name'=>'addons-user-bloc-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13896','name'=>'addons-wechatpay-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13897','name'=>'addons-wxapp-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13898','name'=>'article-dd-article-category-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13899','name'=>'auth-admin-user-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13900','name'=>'auth-admin-user-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13901','name'=>'auth-admin-user-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13902','name'=>'auth-admin-user-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13903','name'=>'auth-admin-user-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13904','name'=>'auth-admin-user-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13905','name'=>'auth-admin-user-*','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13906','name'=>'auth-assignment-change','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13907','name'=>'auth-group-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13908','name'=>'auth-group-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13909','name'=>'auth-group-change','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13910','name'=>'auth-group-assign','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13911','name'=>'auth-group-remove','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13912','name'=>'auth-group-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13913','name'=>'auth-group-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13914','name'=>'auth-group-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13915','name'=>'auth-permission-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13916','name'=>'auth-permission-addons','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13917','name'=>'auth-permission-levels','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13918','name'=>'auth-permission-rule','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13919','name'=>'auth-permission-route','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13920','name'=>'auth-permission-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13921','name'=>'auth-permission-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13922','name'=>'auth-permission-updateitem','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13923','name'=>'auth-permission-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13924','name'=>'auth-permission-change','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13925','name'=>'auth-permission-assign','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13926','name'=>'auth-permission-remove','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13927','name'=>'auth-permission-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13928','name'=>'auth-user-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13929','name'=>'auth-user-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13930','name'=>'auth-user-change-pass','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13931','name'=>'auth-user-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13932','name'=>'auth-user-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13933','name'=>'auth-user-assign','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13934','name'=>'auth-user-remove','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13935','name'=>'auth-user-login','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13936','name'=>'auth-user-logout','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13937','name'=>'auth-user-signup','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13938','name'=>'auth-user-request-password-reset','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13939','name'=>'auth-user-reset-password','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13940','name'=>'auth-user-change-password','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13941','name'=>'auth-user-activate','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13942','name'=>'auth-user-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13943','name'=>'demo-form-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13944','name'=>'demo-form-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13945','name'=>'demo-form-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13946','name'=>'demo-form-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13947','name'=>'demo-form-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13948','name'=>'file-upload-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13949','name'=>'file-upload-images','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13950','name'=>'file-upload-file','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13951','name'=>'file-upload-merge','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13952','name'=>'file-upload-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13953','name'=>'file-upload-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13954','name'=>'file-upload-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13955','name'=>'file-upload-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13956','name'=>'file-upload-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13957','name'=>'file-upload-*','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13958','name'=>'member-account-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13959','name'=>'member-dd-member-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13960','name'=>'member-dd-member-group-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13961','name'=>'member-organization-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13962','name'=>'member-organization-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13963','name'=>'member-organization-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13964','name'=>'member-organization-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13965','name'=>'member-organization-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13966','name'=>'member-organization-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13967','name'=>'member-organization-*','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13968','name'=>'system-config-weburl','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13969','name'=>'system-config-baidu','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13970','name'=>'system-config-wechatpay','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13971','name'=>'system-config-sms','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13972','name'=>'system-config-email','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13973','name'=>'system-config-wxapp','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13974','name'=>'system-config-wechat','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13975','name'=>'system-config-microapp','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13976','name'=>'system-config-app','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13977','name'=>'system-config-map','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13978','name'=>'system-config-oss','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13979','name'=>'system-config-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13980','name'=>'system-config-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13981','name'=>'system-config-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13982','name'=>'system-config-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13983','name'=>'system-config-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13984','name'=>'system-config-*','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13985','name'=>'system-database-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13986','name'=>'system-database-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13987','name'=>'system-database-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13988','name'=>'system-database-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13989','name'=>'system-database-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13990','name'=>'system-index-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13991','name'=>'system-index-menus','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13992','name'=>'system-index-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13993','name'=>'system-index-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13994','name'=>'system-index-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13995','name'=>'system-index-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13996','name'=>'system-settings-ueditor','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13997','name'=>'system-settings-weburl','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13998','name'=>'system-settings-conf','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'13999','name'=>'system-settings-index1','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'14000','name'=>'system-settings-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'14001','name'=>'system-settings-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'14002','name'=>'system-settings-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'14003','name'=>'system-settings-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'14004','name'=>'system-welcome-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'14005','name'=>'system-welcome-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'14006','name'=>'system-welcome-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'14007','name'=>'system-welcome-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'14008','name'=>'system-welcome-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'14009','name'=>'user-dd-user-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'14010','name'=>'website-dd-website-contact-options','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'14011','name'=>'website-setting-index','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'14012','name'=>'website-setting-create','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'14013','name'=>'website-setting-update','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'14014','name'=>'website-setting-delete','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'14015','name'=>'website-setting-view','is_sys'=>'0','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'14016','name'=>'diandi_ceshi','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'14017','name'=>'/diandi_ceshi/default/index.vue','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'14020','name'=>'/diandi_party/zailai','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_item}}',['id'=>'14190','name'=>'/addons/addons/install.vue','is_sys'=>'1','permission_type'=>'0','description'=>NULL,'rule_name'=>'0','parent_id'=>'0','permission_level'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        
        /* 设置外键约束 */
        $this->execute('SET foreign_key_checks = 1;');
    }

    public function down()
    {
        $this->execute('SET foreign_key_checks = 0');
        /* 删除表 */
        $this->dropTable('{{%auth_item}}');
        $this->execute('SET foreign_key_checks = 1;');
    }
}

