<?php

use yii\db\Migration;

class m220613_063635_auth_item_child extends Migration
{
    public function up()
    {
        /* 取消外键约束 */
        $this->execute('SET foreign_key_checks = 0');
        
        /* 创建表 */
        $this->createTable('{{%auth_item_child}}', [
            'id' => "int(11) NOT NULL AUTO_INCREMENT",
            'is_sys' => "smallint(6) NULL COMMENT '0系统1模块'",
            'item_id' => "int(11) NULL",
            'parent_id' => "int(11) NOT NULL",
            'parent' => "varchar(64) NOT NULL",
            'child' => "varchar(64) NOT NULL",
            'module_name' => "varchar(50) NULL",
            'child_type' => "smallint(6) NULL COMMENT '0:route,1:permission,2:role'",
            'parent_type' => "smallint(6) NULL DEFAULT '0' COMMENT '0:路由1：规则2：用户组;3权限'",
            'PRIMARY KEY (`id`)'
        ], "ENGINE=InnoDB  DEFAULT CHARSET=utf8");
        
        /* 索引设置 */
        $this->createIndex('item_id','{{%auth_item_child}}','item_id, parent_id',1);
        $this->createIndex('child','{{%auth_item_child}}','child',0);
        $this->createIndex('parent','{{%auth_item_child}}','parent',0);
        
        
        /* 表数据 */
        $this->insert('{{%auth_item_child}}',['id'=>'36','is_sys'=>'1','item_id'=>'379','parent_id'=>'3','parent'=>'会员管理','child'=>'/member/dd-member-group/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'37','is_sys'=>'1','item_id'=>'376','parent_id'=>'3','parent'=>'会员管理','child'=>'/member/dd-member-group/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'38','is_sys'=>'1','item_id'=>'378','parent_id'=>'3','parent'=>'会员管理','child'=>'/member/dd-member-group/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'39','is_sys'=>'1','item_id'=>'373','parent_id'=>'3','parent'=>'会员管理','child'=>'/member/dd-member-group/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'40','is_sys'=>'1','item_id'=>'374','parent_id'=>'3','parent'=>'会员管理','child'=>'/member/dd-member-group/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'41','is_sys'=>'1','item_id'=>'377','parent_id'=>'3','parent'=>'会员管理','child'=>'/member/dd-member-group/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'42','is_sys'=>'1','item_id'=>'375','parent_id'=>'3','parent'=>'会员管理','child'=>'/member/dd-member-group/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'43','is_sys'=>'1','item_id'=>'372','parent_id'=>'3','parent'=>'会员管理','child'=>'/member/dd-member/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'44','is_sys'=>'1','item_id'=>'369','parent_id'=>'3','parent'=>'会员管理','child'=>'/member/dd-member/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'45','is_sys'=>'1','item_id'=>'371','parent_id'=>'3','parent'=>'会员管理','child'=>'/member/dd-member/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'46','is_sys'=>'1','item_id'=>'366','parent_id'=>'3','parent'=>'会员管理','child'=>'/member/dd-member/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'47','is_sys'=>'1','item_id'=>'367','parent_id'=>'3','parent'=>'会员管理','child'=>'/member/dd-member/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'48','is_sys'=>'1','item_id'=>'370','parent_id'=>'3','parent'=>'会员管理','child'=>'/member/dd-member/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'49','is_sys'=>'1','item_id'=>'368','parent_id'=>'3','parent'=>'会员管理','child'=>'/member/dd-member/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'51','is_sys'=>'1','item_id'=>'336','parent_id'=>'6','parent'=>'开发示例','child'=>'/demo/form/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'52','is_sys'=>'1','item_id'=>'332','parent_id'=>'6','parent'=>'开发示例','child'=>'/demo/form/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'53','is_sys'=>'1','item_id'=>'334','parent_id'=>'6','parent'=>'开发示例','child'=>'/demo/form/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'54','is_sys'=>'1','item_id'=>'2884','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'55','is_sys'=>'1','item_id'=>'2748','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/default/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'56','is_sys'=>'1','item_id'=>'2746','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/default/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'57','is_sys'=>'1','item_id'=>'2747','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/default/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'58','is_sys'=>'1','item_id'=>'2757','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/goods/dd-category/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'59','is_sys'=>'1','item_id'=>'2756','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/goods/dd-category/childcate','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'60','is_sys'=>'1','item_id'=>'2752','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/goods/dd-category/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'61','is_sys'=>'1','item_id'=>'2755','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/goods/dd-category/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'62','is_sys'=>'1','item_id'=>'2749','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/goods/dd-category/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'63','is_sys'=>'1','item_id'=>'2750','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/goods/dd-category/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'64','is_sys'=>'1','item_id'=>'2753','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/goods/dd-category/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'65','is_sys'=>'1','item_id'=>'2751','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/goods/dd-category/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'66','is_sys'=>'1','item_id'=>'2769','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/goods/dd-goods/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'68','is_sys'=>'1','item_id'=>'2763','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/goods/dd-goods/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'69','is_sys'=>'1','item_id'=>'2765','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/goods/dd-goods/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'70','is_sys'=>'1','item_id'=>'2760','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/goods/dd-goods/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'71','is_sys'=>'1','item_id'=>'2767','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/goods/dd-goods/param','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'72','is_sys'=>'1','item_id'=>'2768','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/goods/dd-goods/spec','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'73','is_sys'=>'1','item_id'=>'2766','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/goods/dd-goods/specitem','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'74','is_sys'=>'1','item_id'=>'2764','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/goods/dd-goods/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'75','is_sys'=>'1','item_id'=>'2758','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/goods/dd-goods/upload','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'76','is_sys'=>'1','item_id'=>'2762','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/goods/dd-goods/validate','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'77','is_sys'=>'1','item_id'=>'2761','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/goods/dd-goods/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'98','is_sys'=>'1','item_id'=>'2793','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/order/dd-delivery-rule/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'99','is_sys'=>'1','item_id'=>'2790','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/order/dd-delivery-rule/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'100','is_sys'=>'1','item_id'=>'2792','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/order/dd-delivery-rule/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'101','is_sys'=>'1','item_id'=>'2787','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/order/dd-delivery-rule/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'102','is_sys'=>'1','item_id'=>'2788','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/order/dd-delivery-rule/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'103','is_sys'=>'1','item_id'=>'2791','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/order/dd-delivery-rule/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'104','is_sys'=>'1','item_id'=>'2789','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/order/dd-delivery-rule/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'105','is_sys'=>'1','item_id'=>'2786','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/order/dd-delivery/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'106','is_sys'=>'1','item_id'=>'2783','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/order/dd-delivery/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'107','is_sys'=>'1','item_id'=>'2785','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/order/dd-delivery/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'108','is_sys'=>'1','item_id'=>'2779','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/order/dd-delivery/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'109','is_sys'=>'1','item_id'=>'2780','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/order/dd-delivery/get-region','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'110','is_sys'=>'1','item_id'=>'2781','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/order/dd-delivery/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'111','is_sys'=>'1','item_id'=>'2784','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/order/dd-delivery/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'112','is_sys'=>'1','item_id'=>'2782','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/order/dd-delivery/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'113','is_sys'=>'1','item_id'=>'2809','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/order/dd-order/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'114','is_sys'=>'1','item_id'=>'2802','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/order/dd-order/confirm','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'115','is_sys'=>'1','item_id'=>'2799','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/order/dd-order/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'116','is_sys'=>'1','item_id'=>'2801','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/order/dd-order/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'117','is_sys'=>'1','item_id'=>'2808','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/order/dd-order/deletes','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'118','is_sys'=>'1','item_id'=>'2794','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/order/dd-order/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'119','is_sys'=>'1','item_id'=>'2804','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/order/dd-order/exportdata','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'120','is_sys'=>'1','item_id'=>'2796','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/order/dd-order/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'121','is_sys'=>'1','item_id'=>'2798','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/order/dd-order/upaddress','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'122','is_sys'=>'1','item_id'=>'2800','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/order/dd-order/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'123','is_sys'=>'1','item_id'=>'2797','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/order/dd-order/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'124','is_sys'=>'1','item_id'=>'2838','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/setting/area/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'125','is_sys'=>'1','item_id'=>'2834','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/setting/area/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'126','is_sys'=>'1','item_id'=>'2837','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/setting/area/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'127','is_sys'=>'1','item_id'=>'2831','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/setting/area/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'128','is_sys'=>'1','item_id'=>'2832','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/setting/area/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'129','is_sys'=>'1','item_id'=>'2835','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/setting/area/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'130','is_sys'=>'1','item_id'=>'2833','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/setting/area/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'131','is_sys'=>'1','item_id'=>'2845','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/setting/comment/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'132','is_sys'=>'1','item_id'=>'2842','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/setting/comment/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'133','is_sys'=>'1','item_id'=>'2844','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/setting/comment/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'135','is_sys'=>'1','item_id'=>'2840','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/setting/comment/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'136','is_sys'=>'1','item_id'=>'2843','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/setting/comment/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'137','is_sys'=>'1','item_id'=>'2841','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/setting/comment/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'138','is_sys'=>'1','item_id'=>'2854','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/setting/store/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'139','is_sys'=>'1','item_id'=>'2851','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/setting/store/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'140','is_sys'=>'1','item_id'=>'2853','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/setting/store/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'141','is_sys'=>'1','item_id'=>'2846','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/setting/store/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'142','is_sys'=>'1','item_id'=>'2848','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/setting/store/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'143','is_sys'=>'1','item_id'=>'234','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/setting/store/setting','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'144','is_sys'=>'1','item_id'=>'2852','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/setting/store/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'145','is_sys'=>'1','item_id'=>'2850','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/setting/store/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'153','is_sys'=>'1','item_id'=>'2868','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/wxapp/dd-wxapp-help/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'154','is_sys'=>'1','item_id'=>'2865','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/wxapp/dd-wxapp-help/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'155','is_sys'=>'1','item_id'=>'2867','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/wxapp/dd-wxapp-help/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'156','is_sys'=>'1','item_id'=>'2862','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/wxapp/dd-wxapp-help/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'157','is_sys'=>'1','item_id'=>'2863','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/wxapp/dd-wxapp-help/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'158','is_sys'=>'1','item_id'=>'2866','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/wxapp/dd-wxapp-help/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'159','is_sys'=>'1','item_id'=>'2864','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/wxapp/dd-wxapp-help/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'160','is_sys'=>'1','item_id'=>'2875','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/wxapp/dd-wxapp-navbar/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'161','is_sys'=>'1','item_id'=>'2872','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/wxapp/dd-wxapp-navbar/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'162','is_sys'=>'1','item_id'=>'2874','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/wxapp/dd-wxapp-navbar/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'163','is_sys'=>'1','item_id'=>'2869','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/wxapp/dd-wxapp-navbar/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'164','is_sys'=>'1','item_id'=>'2870','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/wxapp/dd-wxapp-navbar/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'165','is_sys'=>'1','item_id'=>'2873','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/wxapp/dd-wxapp-navbar/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'166','is_sys'=>'1','item_id'=>'2871','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/wxapp/dd-wxapp-navbar/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'167','is_sys'=>'1','item_id'=>'2876','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/wxapp/dd-wxapp-page/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'168','is_sys'=>'1','item_id'=>'2883','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/wxapp/dd-wxapp-slide/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'169','is_sys'=>'1','item_id'=>'2880','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/wxapp/dd-wxapp-slide/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'170','is_sys'=>'1','item_id'=>'2882','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/wxapp/dd-wxapp-slide/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'171','is_sys'=>'1','item_id'=>'2877','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/wxapp/dd-wxapp-slide/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'172','is_sys'=>'1','item_id'=>'2878','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/wxapp/dd-wxapp-slide/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'173','is_sys'=>'1','item_id'=>'2881','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/wxapp/dd-wxapp-slide/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'174','is_sys'=>'1','item_id'=>'2879','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/wxapp/dd-wxapp-slide/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'175','is_sys'=>'1','item_id'=>'2861','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/wxapp/dd-wxapp/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'176','is_sys'=>'1','item_id'=>'2858','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/wxapp/dd-wxapp/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'177','is_sys'=>'1','item_id'=>'2860','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/wxapp/dd-wxapp/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'178','is_sys'=>'1','item_id'=>'2855','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/wxapp/dd-wxapp/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'179','is_sys'=>'1','item_id'=>'2856','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/wxapp/dd-wxapp/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'180','is_sys'=>'1','item_id'=>'2859','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/wxapp/dd-wxapp/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'181','is_sys'=>'1','item_id'=>'2857','parent_id'=>'7','parent'=>'扩展功能','child'=>'/diandi_shop/wxapp/dd-wxapp/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'182','is_sys'=>'1','item_id'=>'401','parent_id'=>'7','parent'=>'扩展功能','child'=>'/system/welcome/plugins','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'187','is_sys'=>'1','item_id'=>'125','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'188','is_sys'=>'1','item_id'=>'14','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/assignment/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'189','is_sys'=>'1','item_id'=>'12','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/assignment/assign','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'190','is_sys'=>'1','item_id'=>'9','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/assignment/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'191','is_sys'=>'1','item_id'=>'10','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/assignment/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'192','is_sys'=>'1','item_id'=>'13','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/assignment/revoke','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'193','is_sys'=>'1','item_id'=>'11','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/assignment/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'194','is_sys'=>'1','item_id'=>'30','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/default/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'195','is_sys'=>'1','item_id'=>'28','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/default/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'196','is_sys'=>'1','item_id'=>'29','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/default/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'197','is_sys'=>'1','item_id'=>'52','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/menu/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'198','is_sys'=>'1','item_id'=>'48','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/menu/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'199','is_sys'=>'1','item_id'=>'51','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/menu/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'200','is_sys'=>'1','item_id'=>'45','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/menu/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'201','is_sys'=>'1','item_id'=>'46','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/menu/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'202','is_sys'=>'1','item_id'=>'49','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/menu/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'203','is_sys'=>'1','item_id'=>'47','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/menu/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'204','is_sys'=>'1','item_id'=>'66','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/permission/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'205','is_sys'=>'1','item_id'=>'64','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/permission/assign','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'206','is_sys'=>'1','item_id'=>'61','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/permission/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'207','is_sys'=>'1','item_id'=>'63','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/permission/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'208','is_sys'=>'1','item_id'=>'59','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/permission/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'209','is_sys'=>'1','item_id'=>'65','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/permission/remove','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'210','is_sys'=>'1','item_id'=>'62','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/permission/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'211','is_sys'=>'1','item_id'=>'60','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/permission/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'212','is_sys'=>'1','item_id'=>'74','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/role/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'213','is_sys'=>'1','item_id'=>'72','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/role/assign','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'214','is_sys'=>'1','item_id'=>'69','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/role/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'215','is_sys'=>'1','item_id'=>'71','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/role/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'216','is_sys'=>'1','item_id'=>'67','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/role/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'217','is_sys'=>'1','item_id'=>'73','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/role/remove','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'218','is_sys'=>'1','item_id'=>'70','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/role/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'219','is_sys'=>'1','item_id'=>'68','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/role/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'220','is_sys'=>'1','item_id'=>'81','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/route/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'221','is_sys'=>'1','item_id'=>'78','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/route/assign','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'222','is_sys'=>'1','item_id'=>'77','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/route/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'223','is_sys'=>'1','item_id'=>'75','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/route/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'224','is_sys'=>'1','item_id'=>'76','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/route/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'225','is_sys'=>'1','item_id'=>'80','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/route/refresh','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'226','is_sys'=>'1','item_id'=>'79','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/route/remove','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'227','is_sys'=>'1','item_id'=>'88','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/rule/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'228','is_sys'=>'1','item_id'=>'85','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/rule/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'229','is_sys'=>'1','item_id'=>'87','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/rule/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'230','is_sys'=>'1','item_id'=>'82','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/rule/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'231','is_sys'=>'1','item_id'=>'83','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/rule/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'232','is_sys'=>'1','item_id'=>'86','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/rule/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'233','is_sys'=>'1','item_id'=>'84','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/rule/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'234','is_sys'=>'1','item_id'=>'110','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/user/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'235','is_sys'=>'1','item_id'=>'109','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/user/activate','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'236','is_sys'=>'1','item_id'=>'108','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/user/change-password','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'238','is_sys'=>'1','item_id'=>'102','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/user/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'239','is_sys'=>'1','item_id'=>'98','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/user/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'240','is_sys'=>'1','item_id'=>'99','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/user/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'241','is_sys'=>'1','item_id'=>'103','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/user/login','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'242','is_sys'=>'1','item_id'=>'104','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/user/logout','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'243','is_sys'=>'1','item_id'=>'106','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/user/request-password-reset','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'244','is_sys'=>'1','item_id'=>'107','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/user/reset-password','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'245','is_sys'=>'1','item_id'=>'105','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/user/signup','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'246','is_sys'=>'1','item_id'=>'100','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/user/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'247','is_sys'=>'1','item_id'=>'101','parent_id'=>'8','parent'=>'权限控制','child'=>'/admin/user/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'248','is_sys'=>'1','item_id'=>'159','parent_id'=>'9','parent'=>'模块生成','child'=>'/gii/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'249','is_sys'=>'1','item_id'=>'158','parent_id'=>'9','parent'=>'模块生成','child'=>'/gii/default/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'250','is_sys'=>'1','item_id'=>'157','parent_id'=>'9','parent'=>'模块生成','child'=>'/gii/default/action','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'251','is_sys'=>'1','item_id'=>'156','parent_id'=>'9','parent'=>'模块生成','child'=>'/gii/default/diff','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'252','is_sys'=>'1','item_id'=>'153','parent_id'=>'9','parent'=>'模块生成','child'=>'/gii/default/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'253','is_sys'=>'1','item_id'=>'155','parent_id'=>'9','parent'=>'模块生成','child'=>'/gii/default/preview','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'254','is_sys'=>'1','item_id'=>'154','parent_id'=>'9','parent'=>'模块生成','child'=>'/gii/default/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'258','is_sys'=>'1','item_id'=>'126','parent_id'=>'13','parent'=>'站点管理','child'=>'/modal/modal/website','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'260','is_sys'=>'1','item_id'=>'422','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/dd-website-contact/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'261','is_sys'=>'1','item_id'=>'419','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/dd-website-contact/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'262','is_sys'=>'1','item_id'=>'421','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/dd-website-contact/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'263','is_sys'=>'1','item_id'=>'416','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/dd-website-contact/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'264','is_sys'=>'1','item_id'=>'417','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/dd-website-contact/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'265','is_sys'=>'1','item_id'=>'420','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/dd-website-contact/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'266','is_sys'=>'1','item_id'=>'418','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/dd-website-contact/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'267','is_sys'=>'1','item_id'=>'429','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/dd-website-slide/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'268','is_sys'=>'1','item_id'=>'426','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/dd-website-slide/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'269','is_sys'=>'1','item_id'=>'428','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/dd-website-slide/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'270','is_sys'=>'1','item_id'=>'423','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/dd-website-slide/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'271','is_sys'=>'1','item_id'=>'424','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/dd-website-slide/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'272','is_sys'=>'1','item_id'=>'427','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/dd-website-slide/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'273','is_sys'=>'1','item_id'=>'425','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/dd-website-slide/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'274','is_sys'=>'1','item_id'=>'430','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/setting/website','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'275','is_sys'=>'1','item_id'=>'152','parent_id'=>'15','parent'=>'系统设置','child'=>'/addons/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'276','is_sys'=>'1','item_id'=>'138','parent_id'=>'15','parent'=>'系统设置','child'=>'/addons/addons/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'277','is_sys'=>'1','item_id'=>'135','parent_id'=>'15','parent'=>'系统设置','child'=>'/addons/addons/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'278','is_sys'=>'1','item_id'=>'137','parent_id'=>'15','parent'=>'系统设置','child'=>'/addons/addons/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'279','is_sys'=>'1','item_id'=>'130','parent_id'=>'15','parent'=>'系统设置','child'=>'/addons/addons/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'280','is_sys'=>'1','item_id'=>'131','parent_id'=>'15','parent'=>'系统设置','child'=>'/addons/addons/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'281','is_sys'=>'1','item_id'=>'134','parent_id'=>'15','parent'=>'系统设置','child'=>'/addons/addons/logo','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'282','is_sys'=>'1','item_id'=>'132','parent_id'=>'15','parent'=>'系统设置','child'=>'/addons/addons/uninstalled','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'283','is_sys'=>'1','item_id'=>'136','parent_id'=>'15','parent'=>'系统设置','child'=>'/addons/addons/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'284','is_sys'=>'1','item_id'=>'133','parent_id'=>'15','parent'=>'系统设置','child'=>'/addons/addons/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'285','is_sys'=>'1','item_id'=>'144','parent_id'=>'15','parent'=>'系统设置','child'=>'/addons/manage/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'286','is_sys'=>'1','item_id'=>'139','parent_id'=>'15','parent'=>'系统设置','child'=>'/addons/manage/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'287','is_sys'=>'1','item_id'=>'140','parent_id'=>'15','parent'=>'系统设置','child'=>'/addons/manage/install','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'288','is_sys'=>'1','item_id'=>'142','parent_id'=>'15','parent'=>'系统设置','child'=>'/addons/manage/uninstall','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'289','is_sys'=>'1','item_id'=>'141','parent_id'=>'15','parent'=>'系统设置','child'=>'/addons/manage/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'299','is_sys'=>'1','item_id'=>'391','parent_id'=>'15','parent'=>'系统设置','child'=>'/system/settings/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'300','is_sys'=>'1','item_id'=>'384','parent_id'=>'15','parent'=>'系统设置','child'=>'/system/settings/baidu','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'302','is_sys'=>'1','item_id'=>'388','parent_id'=>'15','parent'=>'系统设置','child'=>'/system/settings/sms','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'304','is_sys'=>'1','item_id'=>'387','parent_id'=>'15','parent'=>'系统设置','child'=>'/system/settings/weburl','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'305','is_sys'=>'1','item_id'=>'386','parent_id'=>'15','parent'=>'系统设置','child'=>'/system/settings/wechatpay','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'365','is_sys'=>'1','item_id'=>'127','parent_id'=>'19','parent'=>'资源上传','child'=>'/modal/modal/icons','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'366','is_sys'=>'1','item_id'=>'407','parent_id'=>'19','parent'=>'资源上传','child'=>'/upload/upload/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'367','is_sys'=>'1','item_id'=>'404','parent_id'=>'19','parent'=>'资源上传','child'=>'/upload/upload/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'910','is_sys'=>'1','item_id'=>'461','parent_id'=>'552','parent'=>'总管理员','child'=>'/settings/default/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'916','is_sys'=>'1','item_id'=>'6','parent_id'=>'552','parent'=>'总管理员','child'=>'/settings/default/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'917','is_sys'=>'1','item_id'=>'9','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/assignment/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'918','is_sys'=>'1','item_id'=>'3','parent_id'=>'552','parent'=>'总管理员','child'=>'/settings/default/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'921','is_sys'=>'1','item_id'=>'12','parent_id'=>'552','parent'=>'总管理员','child'=>'测试实施','module_name'=>'sys','child_type'=>'1','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'922','is_sys'=>'1','item_id'=>'13','parent_id'=>'552','parent'=>'总管理员','child'=>'站点管理','module_name'=>'sys','child_type'=>'1','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'923','is_sys'=>'1','item_id'=>'15','parent_id'=>'552','parent'=>'总管理员','child'=>'系统设置','module_name'=>'sys','child_type'=>'1','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'924','is_sys'=>'1','item_id'=>'19','parent_id'=>'552','parent'=>'总管理员','child'=>'资源上传','module_name'=>'sys','child_type'=>'1','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'925','is_sys'=>'1','item_id'=>'2','parent_id'=>'552','parent'=>'总管理员','child'=>'人脸识别','module_name'=>'sys','child_type'=>'1','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'927','is_sys'=>'1','item_id'=>'7','parent_id'=>'552','parent'=>'总管理员','child'=>'扩展功能','module_name'=>'sys','child_type'=>'1','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'928','is_sys'=>'1','item_id'=>'8','parent_id'=>'552','parent'=>'总管理员','child'=>'权限控制','module_name'=>'sys','child_type'=>'1','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'930','is_sys'=>'1','item_id'=>'704','parent_id'=>'552','parent'=>'总管理员','child'=>'/settings/default/edit-setting','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'931','is_sys'=>'1','item_id'=>'5','parent_id'=>'552','parent'=>'总管理员','child'=>'/settings/default/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'933','is_sys'=>'1','item_id'=>'1712','parent_id'=>'552','parent'=>'总管理员','child'=>'/settings/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'934','is_sys'=>'1','item_id'=>'10','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/assignment/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'935','is_sys'=>'1','item_id'=>'11','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/assignment/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'938','is_sys'=>'1','item_id'=>'14','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/assignment/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'952','is_sys'=>'1','item_id'=>'28','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/default/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'953','is_sys'=>'1','item_id'=>'29','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/default/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'954','is_sys'=>'1','item_id'=>'30','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/default/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'962','is_sys'=>'1','item_id'=>'38','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/group/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'963','is_sys'=>'1','item_id'=>'39','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/group/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'964','is_sys'=>'1','item_id'=>'40','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/group/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'965','is_sys'=>'1','item_id'=>'41','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/group/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'966','is_sys'=>'1','item_id'=>'42','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/group/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'967','is_sys'=>'1','item_id'=>'43','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/group/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'968','is_sys'=>'1','item_id'=>'44','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/group/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'969','is_sys'=>'1','item_id'=>'45','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/menu/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'970','is_sys'=>'1','item_id'=>'46','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/menu/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'971','is_sys'=>'1','item_id'=>'47','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/menu/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'972','is_sys'=>'1','item_id'=>'48','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/menu/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'973','is_sys'=>'1','item_id'=>'49','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/menu/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'974','is_sys'=>'1','item_id'=>'50','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/menu/update-files','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'975','is_sys'=>'1','item_id'=>'51','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/menu/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'976','is_sys'=>'1','item_id'=>'52','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/menu/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'977','is_sys'=>'1','item_id'=>'53','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/menu-top/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'978','is_sys'=>'1','item_id'=>'54','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/menu-top/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'979','is_sys'=>'1','item_id'=>'55','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/menu-top/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'980','is_sys'=>'1','item_id'=>'56','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/menu-top/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'981','is_sys'=>'1','item_id'=>'57','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/menu-top/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'982','is_sys'=>'1','item_id'=>'58','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/menu-top/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'983','is_sys'=>'1','item_id'=>'59','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/permission/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'984','is_sys'=>'1','item_id'=>'60','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/permission/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'985','is_sys'=>'1','item_id'=>'61','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/permission/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'986','is_sys'=>'1','item_id'=>'62','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/permission/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'987','is_sys'=>'1','item_id'=>'63','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/permission/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'988','is_sys'=>'1','item_id'=>'64','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/permission/assign','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'989','is_sys'=>'1','item_id'=>'65','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/permission/remove','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'990','is_sys'=>'1','item_id'=>'66','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/permission/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'991','is_sys'=>'1','item_id'=>'67','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/role/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'992','is_sys'=>'1','item_id'=>'68','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/role/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'993','is_sys'=>'1','item_id'=>'69','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/role/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'994','is_sys'=>'1','item_id'=>'70','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/role/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'995','is_sys'=>'1','item_id'=>'71','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/role/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'996','is_sys'=>'1','item_id'=>'72','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/role/assign','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'997','is_sys'=>'1','item_id'=>'73','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/role/remove','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'998','is_sys'=>'1','item_id'=>'74','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/role/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'999','is_sys'=>'1','item_id'=>'75','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/route/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1000','is_sys'=>'1','item_id'=>'76','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/route/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1001','is_sys'=>'1','item_id'=>'77','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/route/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1002','is_sys'=>'1','item_id'=>'78','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/route/assign','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1003','is_sys'=>'1','item_id'=>'79','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/route/remove','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1004','is_sys'=>'1','item_id'=>'80','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/route/refresh','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1005','is_sys'=>'1','item_id'=>'81','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/route/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1006','is_sys'=>'1','item_id'=>'82','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/rule/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1007','is_sys'=>'1','item_id'=>'83','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/rule/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1008','is_sys'=>'1','item_id'=>'84','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/rule/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1009','is_sys'=>'1','item_id'=>'85','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/rule/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1010','is_sys'=>'1','item_id'=>'86','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/rule/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1011','is_sys'=>'1','item_id'=>'87','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/rule/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1012','is_sys'=>'1','item_id'=>'88','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/rule/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1021','is_sys'=>'1','item_id'=>'97','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/user-bloc/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1022','is_sys'=>'1','item_id'=>'98','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/user/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1023','is_sys'=>'1','item_id'=>'99','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/user/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1024','is_sys'=>'1','item_id'=>'100','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/user/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1025','is_sys'=>'1','item_id'=>'101','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/user/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1026','is_sys'=>'1','item_id'=>'102','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/user/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1027','is_sys'=>'1','item_id'=>'103','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/user/login','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1028','is_sys'=>'1','item_id'=>'104','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/user/logout','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1029','is_sys'=>'1','item_id'=>'105','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/user/signup','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1030','is_sys'=>'1','item_id'=>'106','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/user/request-password-reset','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1031','is_sys'=>'1','item_id'=>'107','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/user/reset-password','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1032','is_sys'=>'1','item_id'=>'108','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/user/change-password','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1033','is_sys'=>'1','item_id'=>'109','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/user/activate','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1034','is_sys'=>'1','item_id'=>'110','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/user/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1049','is_sys'=>'1','item_id'=>'125','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1050','is_sys'=>'1','item_id'=>'126','parent_id'=>'552','parent'=>'总管理员','child'=>'/modal/modal/website','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1051','is_sys'=>'1','item_id'=>'127','parent_id'=>'552','parent'=>'总管理员','child'=>'/modal/modal/icons','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1052','is_sys'=>'1','item_id'=>'128','parent_id'=>'552','parent'=>'总管理员','child'=>'/modal/modal/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1053','is_sys'=>'1','item_id'=>'129','parent_id'=>'552','parent'=>'总管理员','child'=>'/modal/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1054','is_sys'=>'1','item_id'=>'130','parent_id'=>'552','parent'=>'总管理员','child'=>'/addons/addons/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1055','is_sys'=>'1','item_id'=>'131','parent_id'=>'552','parent'=>'总管理员','child'=>'/addons/addons/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1056','is_sys'=>'1','item_id'=>'132','parent_id'=>'552','parent'=>'总管理员','child'=>'/addons/addons/uninstalled','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1057','is_sys'=>'1','item_id'=>'133','parent_id'=>'552','parent'=>'总管理员','child'=>'/addons/addons/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1058','is_sys'=>'1','item_id'=>'134','parent_id'=>'552','parent'=>'总管理员','child'=>'/addons/addons/logo','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1059','is_sys'=>'1','item_id'=>'135','parent_id'=>'552','parent'=>'总管理员','child'=>'/addons/addons/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1060','is_sys'=>'1','item_id'=>'136','parent_id'=>'552','parent'=>'总管理员','child'=>'/addons/addons/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1061','is_sys'=>'1','item_id'=>'137','parent_id'=>'552','parent'=>'总管理员','child'=>'/addons/addons/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1062','is_sys'=>'1','item_id'=>'138','parent_id'=>'552','parent'=>'总管理员','child'=>'/addons/addons/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1063','is_sys'=>'1','item_id'=>'139','parent_id'=>'552','parent'=>'总管理员','child'=>'/addons/manage/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1064','is_sys'=>'1','item_id'=>'140','parent_id'=>'552','parent'=>'总管理员','child'=>'/addons/manage/install','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1065','is_sys'=>'1','item_id'=>'141','parent_id'=>'552','parent'=>'总管理员','child'=>'/addons/manage/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1066','is_sys'=>'1','item_id'=>'142','parent_id'=>'552','parent'=>'总管理员','child'=>'/addons/manage/uninstall','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1067','is_sys'=>'1','item_id'=>'143','parent_id'=>'552','parent'=>'总管理员','child'=>'/addons/manage/auth','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1068','is_sys'=>'1','item_id'=>'144','parent_id'=>'552','parent'=>'总管理员','child'=>'/addons/manage/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1069','is_sys'=>'1','item_id'=>'145','parent_id'=>'552','parent'=>'总管理员','child'=>'/addons/menu/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1070','is_sys'=>'1','item_id'=>'146','parent_id'=>'552','parent'=>'总管理员','child'=>'/addons/menu/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1071','is_sys'=>'1','item_id'=>'147','parent_id'=>'552','parent'=>'总管理员','child'=>'/addons/menu/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1072','is_sys'=>'1','item_id'=>'148','parent_id'=>'552','parent'=>'总管理员','child'=>'/addons/menu/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1073','is_sys'=>'1','item_id'=>'149','parent_id'=>'552','parent'=>'总管理员','child'=>'/addons/menu/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1074','is_sys'=>'1','item_id'=>'150','parent_id'=>'552','parent'=>'总管理员','child'=>'/addons/menu/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1075','is_sys'=>'1','item_id'=>'151','parent_id'=>'552','parent'=>'总管理员','child'=>'/addons/menu/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1076','is_sys'=>'1','item_id'=>'152','parent_id'=>'552','parent'=>'总管理员','child'=>'/addons/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1077','is_sys'=>'1','item_id'=>'153','parent_id'=>'552','parent'=>'总管理员','child'=>'/gii/default/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1078','is_sys'=>'1','item_id'=>'154','parent_id'=>'552','parent'=>'总管理员','child'=>'/gii/default/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1079','is_sys'=>'1','item_id'=>'155','parent_id'=>'552','parent'=>'总管理员','child'=>'/gii/default/preview','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1080','is_sys'=>'1','item_id'=>'156','parent_id'=>'552','parent'=>'总管理员','child'=>'/gii/default/diff','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1081','is_sys'=>'1','item_id'=>'157','parent_id'=>'552','parent'=>'总管理员','child'=>'/gii/default/action','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1082','is_sys'=>'1','item_id'=>'158','parent_id'=>'552','parent'=>'总管理员','child'=>'/gii/default/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1083','is_sys'=>'1','item_id'=>'159','parent_id'=>'552','parent'=>'总管理员','child'=>'/gii/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1220','is_sys'=>'1','item_id'=>'296','parent_id'=>'552','parent'=>'总管理员','child'=>'/base/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1221','is_sys'=>'1','item_id'=>'297','parent_id'=>'552','parent'=>'总管理员','child'=>'/base/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1222','is_sys'=>'1','item_id'=>'298','parent_id'=>'552','parent'=>'总管理员','child'=>'/module/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1223','is_sys'=>'1','item_id'=>'299','parent_id'=>'552','parent'=>'总管理员','child'=>'/module/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1224','is_sys'=>'1','item_id'=>'300','parent_id'=>'552','parent'=>'总管理员','child'=>'/module/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1225','is_sys'=>'1','item_id'=>'301','parent_id'=>'552','parent'=>'总管理员','child'=>'/site/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1226','is_sys'=>'1','item_id'=>'302','parent_id'=>'552','parent'=>'总管理员','child'=>'/site/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1227','is_sys'=>'1','item_id'=>'303','parent_id'=>'552','parent'=>'总管理员','child'=>'/site/login','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1228','is_sys'=>'1','item_id'=>'304','parent_id'=>'552','parent'=>'总管理员','child'=>'/site/logout','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1229','is_sys'=>'1','item_id'=>'305','parent_id'=>'552','parent'=>'总管理员','child'=>'/site/signup','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1230','is_sys'=>'1','item_id'=>'306','parent_id'=>'552','parent'=>'总管理员','child'=>'/site/request-password-reset','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1231','is_sys'=>'1','item_id'=>'307','parent_id'=>'552','parent'=>'总管理员','child'=>'/site/reset-password','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1232','is_sys'=>'1','item_id'=>'308','parent_id'=>'552','parent'=>'总管理员','child'=>'/site/verify-email','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1233','is_sys'=>'1','item_id'=>'309','parent_id'=>'552','parent'=>'总管理员','child'=>'/site/resend-verification-email','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1234','is_sys'=>'1','item_id'=>'310','parent_id'=>'552','parent'=>'总管理员','child'=>'/site/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1235','is_sys'=>'1','item_id'=>'311','parent_id'=>'552','parent'=>'总管理员','child'=>'/article/dd-article-category/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1236','is_sys'=>'1','item_id'=>'312','parent_id'=>'552','parent'=>'总管理员','child'=>'/article/dd-article-category/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1237','is_sys'=>'1','item_id'=>'313','parent_id'=>'552','parent'=>'总管理员','child'=>'/article/dd-article-category/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1238','is_sys'=>'1','item_id'=>'314','parent_id'=>'552','parent'=>'总管理员','child'=>'/article/dd-article-category/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1239','is_sys'=>'1','item_id'=>'315','parent_id'=>'552','parent'=>'总管理员','child'=>'/article/dd-article-category/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1240','is_sys'=>'1','item_id'=>'316','parent_id'=>'552','parent'=>'总管理员','child'=>'/article/dd-article-category/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1241','is_sys'=>'1','item_id'=>'317','parent_id'=>'552','parent'=>'总管理员','child'=>'/article/dd-article-category/childcate','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1242','is_sys'=>'1','item_id'=>'318','parent_id'=>'552','parent'=>'总管理员','child'=>'/article/dd-article-category/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1243','is_sys'=>'1','item_id'=>'319','parent_id'=>'552','parent'=>'总管理员','child'=>'/article/dd-article/upload','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1244','is_sys'=>'1','item_id'=>'320','parent_id'=>'552','parent'=>'总管理员','child'=>'/article/dd-article/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1245','is_sys'=>'1','item_id'=>'321','parent_id'=>'552','parent'=>'总管理员','child'=>'/article/dd-article/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1246','is_sys'=>'1','item_id'=>'322','parent_id'=>'552','parent'=>'总管理员','child'=>'/article/dd-article/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1247','is_sys'=>'1','item_id'=>'323','parent_id'=>'552','parent'=>'总管理员','child'=>'/article/dd-article/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1248','is_sys'=>'1','item_id'=>'324','parent_id'=>'552','parent'=>'总管理员','child'=>'/article/dd-article/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1249','is_sys'=>'1','item_id'=>'325','parent_id'=>'552','parent'=>'总管理员','child'=>'/article/dd-article/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1250','is_sys'=>'1','item_id'=>'326','parent_id'=>'552','parent'=>'总管理员','child'=>'/article/record/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1251','is_sys'=>'1','item_id'=>'327','parent_id'=>'552','parent'=>'总管理员','child'=>'/article/record/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1252','is_sys'=>'1','item_id'=>'328','parent_id'=>'552','parent'=>'总管理员','child'=>'/article/record/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1253','is_sys'=>'1','item_id'=>'329','parent_id'=>'552','parent'=>'总管理员','child'=>'/article/record/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1254','is_sys'=>'1','item_id'=>'330','parent_id'=>'552','parent'=>'总管理员','child'=>'/article/record/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1255','is_sys'=>'1','item_id'=>'331','parent_id'=>'552','parent'=>'总管理员','child'=>'/article/record/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1256','is_sys'=>'1','item_id'=>'332','parent_id'=>'552','parent'=>'总管理员','child'=>'/demo/form/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1257','is_sys'=>'1','item_id'=>'333','parent_id'=>'552','parent'=>'总管理员','child'=>'/demo/form/get-region','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1258','is_sys'=>'1','item_id'=>'334','parent_id'=>'552','parent'=>'总管理员','child'=>'/demo/form/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1259','is_sys'=>'1','item_id'=>'335','parent_id'=>'552','parent'=>'总管理员','child'=>'/demo/form/maile','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1260','is_sys'=>'1','item_id'=>'336','parent_id'=>'552','parent'=>'总管理员','child'=>'/demo/form/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1261','is_sys'=>'1','item_id'=>'337','parent_id'=>'552','parent'=>'总管理员','child'=>'/diandiai/dd-ai-applications/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1262','is_sys'=>'1','item_id'=>'338','parent_id'=>'552','parent'=>'总管理员','child'=>'/diandiai/dd-ai-applications/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1263','is_sys'=>'1','item_id'=>'339','parent_id'=>'552','parent'=>'总管理员','child'=>'/diandiai/dd-ai-applications/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1264','is_sys'=>'1','item_id'=>'340','parent_id'=>'552','parent'=>'总管理员','child'=>'/diandiai/dd-ai-applications/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1265','is_sys'=>'1','item_id'=>'341','parent_id'=>'552','parent'=>'总管理员','child'=>'/diandiai/dd-ai-applications/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1266','is_sys'=>'1','item_id'=>'342','parent_id'=>'552','parent'=>'总管理员','child'=>'/diandiai/dd-ai-applications/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1267','is_sys'=>'1','item_id'=>'343','parent_id'=>'552','parent'=>'总管理员','child'=>'/diandiai/dd-ai-applications/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1268','is_sys'=>'1','item_id'=>'344','parent_id'=>'552','parent'=>'总管理员','child'=>'/diandiai/dd-ai-faces/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1269','is_sys'=>'1','item_id'=>'345','parent_id'=>'552','parent'=>'总管理员','child'=>'/diandiai/dd-ai-faces/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1270','is_sys'=>'1','item_id'=>'346','parent_id'=>'552','parent'=>'总管理员','child'=>'/diandiai/dd-ai-faces/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1271','is_sys'=>'1','item_id'=>'347','parent_id'=>'552','parent'=>'总管理员','child'=>'/diandiai/dd-ai-faces/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1272','is_sys'=>'1','item_id'=>'348','parent_id'=>'552','parent'=>'总管理员','child'=>'/diandiai/dd-ai-faces/users','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1273','is_sys'=>'1','item_id'=>'349','parent_id'=>'552','parent'=>'总管理员','child'=>'/diandiai/dd-ai-faces/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1274','is_sys'=>'1','item_id'=>'350','parent_id'=>'552','parent'=>'总管理员','child'=>'/diandiai/dd-ai-faces/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1275','is_sys'=>'1','item_id'=>'351','parent_id'=>'552','parent'=>'总管理员','child'=>'/diandiai/dd-ai-faces/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1276','is_sys'=>'1','item_id'=>'352','parent_id'=>'552','parent'=>'总管理员','child'=>'/diandiai/dd-ai-groups/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1277','is_sys'=>'1','item_id'=>'353','parent_id'=>'552','parent'=>'总管理员','child'=>'/diandiai/dd-ai-groups/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1278','is_sys'=>'1','item_id'=>'354','parent_id'=>'552','parent'=>'总管理员','child'=>'/diandiai/dd-ai-groups/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1279','is_sys'=>'1','item_id'=>'355','parent_id'=>'552','parent'=>'总管理员','child'=>'/diandiai/dd-ai-groups/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1280','is_sys'=>'1','item_id'=>'356','parent_id'=>'552','parent'=>'总管理员','child'=>'/diandiai/dd-ai-groups/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1281','is_sys'=>'1','item_id'=>'357','parent_id'=>'552','parent'=>'总管理员','child'=>'/diandiai/dd-ai-groups/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1282','is_sys'=>'1','item_id'=>'358','parent_id'=>'552','parent'=>'总管理员','child'=>'/diandiai/dd-ai-groups/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1283','is_sys'=>'1','item_id'=>'359','parent_id'=>'552','parent'=>'总管理员','child'=>'/diandiai/dd-ai-member/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1284','is_sys'=>'1','item_id'=>'360','parent_id'=>'552','parent'=>'总管理员','child'=>'/diandiai/dd-ai-member/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1285','is_sys'=>'1','item_id'=>'361','parent_id'=>'552','parent'=>'总管理员','child'=>'/diandiai/dd-ai-member/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1286','is_sys'=>'1','item_id'=>'362','parent_id'=>'552','parent'=>'总管理员','child'=>'/diandiai/dd-ai-member/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1287','is_sys'=>'1','item_id'=>'363','parent_id'=>'552','parent'=>'总管理员','child'=>'/diandiai/dd-ai-member/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1288','is_sys'=>'1','item_id'=>'364','parent_id'=>'552','parent'=>'总管理员','child'=>'/diandiai/dd-ai-member/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1289','is_sys'=>'1','item_id'=>'365','parent_id'=>'552','parent'=>'总管理员','child'=>'/diandiai/dd-ai-member/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1290','is_sys'=>'1','item_id'=>'366','parent_id'=>'552','parent'=>'总管理员','child'=>'/member/dd-member/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1291','is_sys'=>'1','item_id'=>'367','parent_id'=>'552','parent'=>'总管理员','child'=>'/member/dd-member/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1292','is_sys'=>'1','item_id'=>'368','parent_id'=>'552','parent'=>'总管理员','child'=>'/member/dd-member/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1293','is_sys'=>'1','item_id'=>'369','parent_id'=>'552','parent'=>'总管理员','child'=>'/member/dd-member/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1294','is_sys'=>'1','item_id'=>'370','parent_id'=>'552','parent'=>'总管理员','child'=>'/member/dd-member/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1295','is_sys'=>'1','item_id'=>'371','parent_id'=>'552','parent'=>'总管理员','child'=>'/member/dd-member/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1296','is_sys'=>'1','item_id'=>'372','parent_id'=>'552','parent'=>'总管理员','child'=>'/member/dd-member/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1297','is_sys'=>'1','item_id'=>'373','parent_id'=>'552','parent'=>'总管理员','child'=>'/member/dd-member-group/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1298','is_sys'=>'1','item_id'=>'374','parent_id'=>'552','parent'=>'总管理员','child'=>'/member/dd-member-group/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1299','is_sys'=>'1','item_id'=>'375','parent_id'=>'552','parent'=>'总管理员','child'=>'/member/dd-member-group/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1300','is_sys'=>'1','item_id'=>'376','parent_id'=>'552','parent'=>'总管理员','child'=>'/member/dd-member-group/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1301','is_sys'=>'1','item_id'=>'377','parent_id'=>'552','parent'=>'总管理员','child'=>'/member/dd-member-group/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1302','is_sys'=>'1','item_id'=>'378','parent_id'=>'552','parent'=>'总管理员','child'=>'/member/dd-member-group/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1303','is_sys'=>'1','item_id'=>'379','parent_id'=>'552','parent'=>'总管理员','child'=>'/member/dd-member-group/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1304','is_sys'=>'1','item_id'=>'380','parent_id'=>'552','parent'=>'总管理员','child'=>'/system/index/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1305','is_sys'=>'1','item_id'=>'381','parent_id'=>'552','parent'=>'总管理员','child'=>'/system/index/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1306','is_sys'=>'1','item_id'=>'382','parent_id'=>'552','parent'=>'总管理员','child'=>'/system/index/childcate','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1307','is_sys'=>'1','item_id'=>'383','parent_id'=>'552','parent'=>'总管理员','child'=>'/system/index/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1308','is_sys'=>'1','item_id'=>'384','parent_id'=>'552','parent'=>'总管理员','child'=>'/system/settings/baidu','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1309','is_sys'=>'1','item_id'=>'385','parent_id'=>'552','parent'=>'总管理员','child'=>'/system/settings/wxapp','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1310','is_sys'=>'1','item_id'=>'386','parent_id'=>'552','parent'=>'总管理员','child'=>'/system/settings/wechatpay','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1311','is_sys'=>'1','item_id'=>'387','parent_id'=>'552','parent'=>'总管理员','child'=>'/system/settings/weburl','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1312','is_sys'=>'1','item_id'=>'388','parent_id'=>'552','parent'=>'总管理员','child'=>'/system/settings/sms','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1313','is_sys'=>'1','item_id'=>'389','parent_id'=>'552','parent'=>'总管理员','child'=>'/system/settings/email','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1314','is_sys'=>'1','item_id'=>'390','parent_id'=>'552','parent'=>'总管理员','child'=>'/system/settings/clear-cache','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1315','is_sys'=>'1','item_id'=>'391','parent_id'=>'552','parent'=>'总管理员','child'=>'/system/settings/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1316','is_sys'=>'1','item_id'=>'392','parent_id'=>'552','parent'=>'总管理员','child'=>'/system/welcome/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1317','is_sys'=>'1','item_id'=>'393','parent_id'=>'552','parent'=>'总管理员','child'=>'/system/welcome/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1318','is_sys'=>'1','item_id'=>'394','parent_id'=>'552','parent'=>'总管理员','child'=>'/system/welcome/sysai','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1319','is_sys'=>'1','item_id'=>'395','parent_id'=>'552','parent'=>'总管理员','child'=>'/system/welcome/member','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1320','is_sys'=>'1','item_id'=>'396','parent_id'=>'552','parent'=>'总管理员','child'=>'/system/welcome/aimember','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1321','is_sys'=>'1','item_id'=>'397','parent_id'=>'552','parent'=>'总管理员','child'=>'/system/welcome/goods','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1322','is_sys'=>'1','item_id'=>'398','parent_id'=>'552','parent'=>'总管理员','child'=>'/system/welcome/marketing','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1323','is_sys'=>'1','item_id'=>'399','parent_id'=>'552','parent'=>'总管理员','child'=>'/system/welcome/order','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1324','is_sys'=>'1','item_id'=>'400','parent_id'=>'552','parent'=>'总管理员','child'=>'/system/welcome/wxapp','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1325','is_sys'=>'1','item_id'=>'401','parent_id'=>'552','parent'=>'总管理员','child'=>'/system/welcome/plugins','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1326','is_sys'=>'1','item_id'=>'402','parent_id'=>'552','parent'=>'总管理员','child'=>'/system/welcome/system','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1327','is_sys'=>'1','item_id'=>'403','parent_id'=>'552','parent'=>'总管理员','child'=>'/system/welcome/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1328','is_sys'=>'1','item_id'=>'404','parent_id'=>'552','parent'=>'总管理员','child'=>'/upload/upload/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1329','is_sys'=>'1','item_id'=>'405','parent_id'=>'552','parent'=>'总管理员','child'=>'/upload/upload/uploadimg','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1330','is_sys'=>'1','item_id'=>'406','parent_id'=>'552','parent'=>'总管理员','child'=>'/upload/upload/uploadfile','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1331','is_sys'=>'1','item_id'=>'407','parent_id'=>'552','parent'=>'总管理员','child'=>'/upload/upload/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1332','is_sys'=>'1','item_id'=>'408','parent_id'=>'552','parent'=>'总管理员','child'=>'/user/dd-user/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1333','is_sys'=>'1','item_id'=>'409','parent_id'=>'552','parent'=>'总管理员','child'=>'/user/dd-user/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1334','is_sys'=>'1','item_id'=>'410','parent_id'=>'552','parent'=>'总管理员','child'=>'/user/dd-user/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1335','is_sys'=>'1','item_id'=>'411','parent_id'=>'552','parent'=>'总管理员','child'=>'/user/dd-user/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1336','is_sys'=>'1','item_id'=>'412','parent_id'=>'552','parent'=>'总管理员','child'=>'/user/dd-user/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1337','is_sys'=>'1','item_id'=>'413','parent_id'=>'552','parent'=>'总管理员','child'=>'/user/dd-user/profile','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1338','is_sys'=>'1','item_id'=>'414','parent_id'=>'552','parent'=>'总管理员','child'=>'/user/dd-user/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1339','is_sys'=>'1','item_id'=>'415','parent_id'=>'552','parent'=>'总管理员','child'=>'/user/dd-user/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1340','is_sys'=>'1','item_id'=>'416','parent_id'=>'552','parent'=>'总管理员','child'=>'/website/dd-website-contact/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1341','is_sys'=>'1','item_id'=>'417','parent_id'=>'552','parent'=>'总管理员','child'=>'/website/dd-website-contact/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1342','is_sys'=>'1','item_id'=>'418','parent_id'=>'552','parent'=>'总管理员','child'=>'/website/dd-website-contact/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1343','is_sys'=>'1','item_id'=>'419','parent_id'=>'552','parent'=>'总管理员','child'=>'/website/dd-website-contact/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1344','is_sys'=>'1','item_id'=>'420','parent_id'=>'552','parent'=>'总管理员','child'=>'/website/dd-website-contact/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1345','is_sys'=>'1','item_id'=>'421','parent_id'=>'552','parent'=>'总管理员','child'=>'/website/dd-website-contact/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1346','is_sys'=>'1','item_id'=>'422','parent_id'=>'552','parent'=>'总管理员','child'=>'/website/dd-website-contact/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1347','is_sys'=>'1','item_id'=>'423','parent_id'=>'552','parent'=>'总管理员','child'=>'/website/dd-website-slide/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1348','is_sys'=>'1','item_id'=>'424','parent_id'=>'552','parent'=>'总管理员','child'=>'/website/dd-website-slide/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1349','is_sys'=>'1','item_id'=>'425','parent_id'=>'552','parent'=>'总管理员','child'=>'/website/dd-website-slide/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1350','is_sys'=>'1','item_id'=>'426','parent_id'=>'552','parent'=>'总管理员','child'=>'/website/dd-website-slide/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1351','is_sys'=>'1','item_id'=>'427','parent_id'=>'552','parent'=>'总管理员','child'=>'/website/dd-website-slide/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1352','is_sys'=>'1','item_id'=>'428','parent_id'=>'552','parent'=>'总管理员','child'=>'/website/dd-website-slide/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1353','is_sys'=>'1','item_id'=>'429','parent_id'=>'552','parent'=>'总管理员','child'=>'/website/dd-website-slide/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1354','is_sys'=>'1','item_id'=>'430','parent_id'=>'552','parent'=>'总管理员','child'=>'/website/setting/website','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1355','is_sys'=>'1','item_id'=>'431','parent_id'=>'552','parent'=>'总管理员','child'=>'/website/setting/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1356','is_sys'=>'1','item_id'=>'432','parent_id'=>'552','parent'=>'总管理员','child'=>'/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1357','is_sys'=>'1','item_id'=>'433','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/group/assign','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1358','is_sys'=>'1','item_id'=>'434','parent_id'=>'552','parent'=>'总管理员','child'=>'/admin/group/remove','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1408','is_sys'=>'1','item_id'=>'98','parent_id'=>'14','parent'=>'管理员管理','child'=>'/admin/user/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1409','is_sys'=>'1','item_id'=>'99','parent_id'=>'14','parent'=>'管理员管理','child'=>'/admin/user/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1410','is_sys'=>'1','item_id'=>'100','parent_id'=>'14','parent'=>'管理员管理','child'=>'/admin/user/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1411','is_sys'=>'1','item_id'=>'101','parent_id'=>'14','parent'=>'管理员管理','child'=>'/admin/user/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1412','is_sys'=>'1','item_id'=>'102','parent_id'=>'14','parent'=>'管理员管理','child'=>'/admin/user/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1413','is_sys'=>'1','item_id'=>'298','parent_id'=>'10','parent'=>'模块统一入口','child'=>'/module/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1414','is_sys'=>'1','item_id'=>'299','parent_id'=>'10','parent'=>'模块统一入口','child'=>'/module/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1415','is_sys'=>'1','item_id'=>'300','parent_id'=>'10','parent'=>'模块统一入口','child'=>'/module/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1418','is_sys'=>'1','item_id'=>NULL,'parent_id'=>'552','parent'=>'总管理员','child'=>'基础权限组','module_name'=>'sys','child_type'=>'2','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1458','is_sys'=>'1','item_id'=>'131','parent_id'=>'4','parent'=>'基础权限组','child'=>'/addons/addons/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1461','is_sys'=>'1','item_id'=>'130','parent_id'=>'4','parent'=>'基础权限组','child'=>'/addons/addons/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1462','is_sys'=>'1','item_id'=>'133','parent_id'=>'4','parent'=>'基础权限组','child'=>'/addons/addons/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1463','is_sys'=>'1','item_id'=>'134','parent_id'=>'4','parent'=>'基础权限组','child'=>'/addons/addons/logo','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1498','is_sys'=>NULL,'item_id'=>'456','parent_id'=>'4','parent'=>'基础权限组','child'=>'/system/settings/set-cache','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1500','is_sys'=>NULL,'item_id'=>'1844','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/default/error','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1501','is_sys'=>NULL,'item_id'=>'1845','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/default/index','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1502','is_sys'=>NULL,'item_id'=>'1847','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/default/*','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1503','is_sys'=>NULL,'item_id'=>'506','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/conf/price-conf/error','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1504','is_sys'=>NULL,'item_id'=>'1889','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/conf/price-conf/index','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1505','is_sys'=>NULL,'item_id'=>'1890','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/conf/price-conf/view','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1506','is_sys'=>NULL,'item_id'=>'1891','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/conf/price-conf/create','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1507','is_sys'=>NULL,'item_id'=>'1892','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/conf/price-conf/update','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1508','is_sys'=>NULL,'item_id'=>'1893','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/conf/price-conf/delete','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1509','is_sys'=>NULL,'item_id'=>'1894','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/conf/price-conf/*','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1510','is_sys'=>NULL,'item_id'=>'1987','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/level/level/error','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1511','is_sys'=>NULL,'item_id'=>'1988','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/level/level/index','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1512','is_sys'=>NULL,'item_id'=>'1989','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/level/level/view','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1513','is_sys'=>NULL,'item_id'=>'1991','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/level/level/create','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1514','is_sys'=>NULL,'item_id'=>'1992','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/level/level/update','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1515','is_sys'=>NULL,'item_id'=>'1993','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/level/level/delete','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1516','is_sys'=>NULL,'item_id'=>'1994','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/level/level/*','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1524','is_sys'=>NULL,'item_id'=>'2181','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/*','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1525','is_sys'=>NULL,'item_id'=>'1888','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/conf/price-conf/change-use','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1526','is_sys'=>NULL,'item_id'=>'1995','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/level/price-conf/error','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1527','is_sys'=>NULL,'item_id'=>'1996','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/level/price-conf/index','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1528','is_sys'=>NULL,'item_id'=>'1997','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/level/price-conf/view','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1529','is_sys'=>NULL,'item_id'=>'1998','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/level/price-conf/create','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1530','is_sys'=>NULL,'item_id'=>'1999','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/level/price-conf/update','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1531','is_sys'=>NULL,'item_id'=>'2000','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/level/price-conf/delete','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1532','is_sys'=>NULL,'item_id'=>'2001','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/level/price-conf/*','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1533','is_sys'=>NULL,'item_id'=>'691','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/conf/slide/error','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1534','is_sys'=>NULL,'item_id'=>'1896','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/conf/slide/index','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1535','is_sys'=>NULL,'item_id'=>'1897','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/conf/slide/view','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1536','is_sys'=>NULL,'item_id'=>'1898','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/conf/slide/create','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1537','is_sys'=>NULL,'item_id'=>'1899','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/conf/slide/update','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1538','is_sys'=>NULL,'item_id'=>'1900','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/conf/slide/delete','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1539','is_sys'=>NULL,'item_id'=>'1901','parent_id'=>'30','parent'=>'配置权限','child'=>'/diandi_distribution/conf/slide/*','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1540','is_sys'=>NULL,'item_id'=>'513','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/gift/error','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1541','is_sys'=>NULL,'item_id'=>'1952','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/gift/index','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1542','is_sys'=>NULL,'item_id'=>'1953','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/gift/view','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1543','is_sys'=>NULL,'item_id'=>'1955','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/gift/create','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1544','is_sys'=>NULL,'item_id'=>'1956','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/gift/update','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1545','is_sys'=>NULL,'item_id'=>'1957','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/gift/delete','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1546','is_sys'=>NULL,'item_id'=>'1958','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/gift/*','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1547','is_sys'=>NULL,'item_id'=>'520','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/goods/error','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1548','is_sys'=>NULL,'item_id'=>'521','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/goods/index','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1549','is_sys'=>NULL,'item_id'=>'522','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/goods/view','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1550','is_sys'=>NULL,'item_id'=>'523','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/goods/create','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1551','is_sys'=>NULL,'item_id'=>'524','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/goods/update','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1552','is_sys'=>NULL,'item_id'=>'525','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/goods/delete','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1553','is_sys'=>NULL,'item_id'=>'1959','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/goods/*','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1554','is_sys'=>NULL,'item_id'=>'677','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/location/error','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1555','is_sys'=>NULL,'item_id'=>'1969','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/location/index','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1556','is_sys'=>NULL,'item_id'=>'1970','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/location/view','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1557','is_sys'=>NULL,'item_id'=>'1971','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/location/create','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1558','is_sys'=>NULL,'item_id'=>'1972','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/location/update','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1559','is_sys'=>NULL,'item_id'=>'1973','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/location/delete','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1560','is_sys'=>NULL,'item_id'=>'1974','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/location/*','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1561','is_sys'=>NULL,'item_id'=>'684','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/location-goods/error','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1562','is_sys'=>NULL,'item_id'=>'1976','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/location-goods/index','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1563','is_sys'=>NULL,'item_id'=>'1978','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/location-goods/view','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1564','is_sys'=>NULL,'item_id'=>'1981','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/location-goods/create','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1565','is_sys'=>NULL,'item_id'=>'1982','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/location-goods/update','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1566','is_sys'=>NULL,'item_id'=>'1983','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/location-goods/delete','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1567','is_sys'=>NULL,'item_id'=>'1985','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/location-goods/*','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1568','is_sys'=>NULL,'item_id'=>'1977','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/location-goods/goodslocation','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1569','is_sys'=>NULL,'item_id'=>'1979','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/location-goods/goodslist','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1570','is_sys'=>NULL,'item_id'=>'1980','parent_id'=>'32','parent'=>'分销商品管理','child'=>'/diandi_distribution/goods/location-goods/advlist','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1592','is_sys'=>NULL,'item_id'=>'2773','parent_id'=>'35','parent'=>'商品标签管理','child'=>'/diandi_shop/goods/label/getlist','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1593','is_sys'=>NULL,'item_id'=>'2778','parent_id'=>'35','parent'=>'商品标签管理','child'=>'/diandi_shop/goods/label/*','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1657','is_sys'=>'1','item_id'=>'390','parent_id'=>'4','parent'=>'基础权限组','child'=>'/system/settings/clear-cache','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1731','is_sys'=>NULL,'item_id'=>'1844','parent_id'=>'43','parent'=>'分销默认入口','child'=>'/diandi_distribution/default/error','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1732','is_sys'=>NULL,'item_id'=>'1845','parent_id'=>'43','parent'=>'分销默认入口','child'=>'/diandi_distribution/default/index','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1733','is_sys'=>NULL,'item_id'=>'1847','parent_id'=>'43','parent'=>'分销默认入口','child'=>'/diandi_distribution/default/*','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1741','is_sys'=>NULL,'item_id'=>'520','parent_id'=>'37','parent'=>'库存管理','child'=>'/diandi_distribution/goods/goods/error','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1742','is_sys'=>NULL,'item_id'=>'521','parent_id'=>'37','parent'=>'库存管理','child'=>'/diandi_distribution/goods/goods/index','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1743','is_sys'=>NULL,'item_id'=>'522','parent_id'=>'37','parent'=>'库存管理','child'=>'/diandi_distribution/goods/goods/view','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1744','is_sys'=>NULL,'item_id'=>'523','parent_id'=>'37','parent'=>'库存管理','child'=>'/diandi_distribution/goods/goods/create','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1745','is_sys'=>NULL,'item_id'=>'524','parent_id'=>'37','parent'=>'库存管理','child'=>'/diandi_distribution/goods/goods/update','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1746','is_sys'=>NULL,'item_id'=>'525','parent_id'=>'37','parent'=>'库存管理','child'=>'/diandi_distribution/goods/goods/delete','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1747','is_sys'=>NULL,'item_id'=>'1959','parent_id'=>'37','parent'=>'库存管理','child'=>'/diandi_distribution/goods/goods/*','module_name'=>NULL,'child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1756','is_sys'=>'1','item_id'=>'1707','parent_id'=>'45','parent'=>'商户选择','child'=>'/system/settings/store','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1757','is_sys'=>'1','item_id'=>'1707','parent_id'=>'552','parent'=>'总管理员','child'=>'/system/settings/store','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1758','is_sys'=>'1','item_id'=>'1707','parent_id'=>'4','parent'=>'基础权限组','child'=>'/system/settings/store','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1799','is_sys'=>'1','item_id'=>'3','parent_id'=>'29','parent'=>'数据库','child'=>'/settings/default/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1800','is_sys'=>'1','item_id'=>'303','parent_id'=>'15','parent'=>'系统设置','child'=>'/site/login','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1801','is_sys'=>'1','item_id'=>'304','parent_id'=>'15','parent'=>'系统设置','child'=>'/site/logout','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1802','is_sys'=>'1','item_id'=>'305','parent_id'=>'15','parent'=>'系统设置','child'=>'/site/signup','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1806','is_sys'=>'1','item_id'=>'3','parent_id'=>'15','parent'=>'系统设置','child'=>'/settings/default/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1829','is_sys'=>'1','item_id'=>'3','parent_id'=>'567','parent'=>'财务管理','child'=>'/settings/default/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1867','is_sys'=>'1','item_id'=>'2','parent_id'=>'551','parent'=>'基础权限组','child'=>'人脸识别','module_name'=>'sys','child_type'=>'1','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1869','is_sys'=>'1','item_id'=>'3','parent_id'=>'551','parent'=>'基础权限组','child'=>'会员管理','module_name'=>'sys','child_type'=>'1','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1870','is_sys'=>'1','item_id'=>'6','parent_id'=>'551','parent'=>'基础权限组','child'=>'开发示例','module_name'=>'sys','child_type'=>'1','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1871','is_sys'=>'1','item_id'=>'19','parent_id'=>'551','parent'=>'基础权限组','child'=>'资源上传','module_name'=>'sys','child_type'=>'1','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1875','is_sys'=>'1','item_id'=>'29','parent_id'=>'551','parent'=>'基础权限组','child'=>'数据库','module_name'=>'sys','child_type'=>'1','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1882','is_sys'=>'1','item_id'=>'5','parent_id'=>'551','parent'=>'基础权限组','child'=>'/settings/default/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1884','is_sys'=>'1','item_id'=>'15','parent_id'=>'551','parent'=>'基础权限组','child'=>'系统设置','module_name'=>'sys','child_type'=>'1','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1885','is_sys'=>'1','item_id'=>'45','parent_id'=>'3','parent'=>'会员管理','child'=>'商户选择','module_name'=>'sys','child_type'=>'1','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1890','is_sys'=>'1','item_id'=>'19','parent_id'=>'3','parent'=>'会员管理','child'=>'资源上传','module_name'=>'sys','child_type'=>'1','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1896','is_sys'=>'1','item_id'=>'59','parent_id'=>'551','parent'=>'基础权限组','child'=>'/admin/permission/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'1908','is_sys'=>'1','item_id'=>'15','parent_id'=>'3','parent'=>'会员管理','child'=>'系统设置','module_name'=>'sys','child_type'=>'1','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1909','is_sys'=>'1','item_id'=>'5','parent_id'=>'3','parent'=>'会员管理','child'=>'/settings/default/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'1']);
        $this->insert('{{%auth_item_child}}',['id'=>'1910','is_sys'=>'1','item_id'=>'10','parent_id'=>'3','parent'=>'会员管理','child'=>'模块统一入口','module_name'=>'sys','child_type'=>'1','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1913','is_sys'=>'1','item_id'=>'51','parent_id'=>'3','parent'=>'会员管理','child'=>'目录测试18','module_name'=>'sys','child_type'=>'1','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1914','is_sys'=>'1','item_id'=>'3440','parent_id'=>'6','parent'=>'开发示例','child'=>'/example','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1915','is_sys'=>'1','item_id'=>'3441','parent_id'=>'6','parent'=>'开发示例','child'=>'/example/edit.vue','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1929','is_sys'=>'1','item_id'=>'3449','parent_id'=>'54','parent'=>'站点设置','child'=>'/article/dd-article/dd-article-add.vue','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'1930','is_sys'=>'1','item_id'=>'3450','parent_id'=>'45','parent'=>'商户选择','child'=>'/addons/bloc/list/bloc-view.vue','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'2113','is_sys'=>'1','item_id'=>'7328','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/dd-website-contact/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'2114','is_sys'=>'1','item_id'=>'7330','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/dd-website-contact/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'2115','is_sys'=>'1','item_id'=>'7332','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/dd-website-contact/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'2116','is_sys'=>'1','item_id'=>'7334','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/dd-website-contact/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'2117','is_sys'=>'1','item_id'=>'7336','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/dd-website-slide/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'2118','is_sys'=>'1','item_id'=>'7338','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/dd-website-slide/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'2119','is_sys'=>'1','item_id'=>'7340','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/dd-website-slide/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'2120','is_sys'=>'1','item_id'=>'7342','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/setting/website','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'2121','is_sys'=>'1','item_id'=>'7343','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/setting/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'2122','is_sys'=>'1','item_id'=>'7341','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/dd-website-slide/*','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'2123','is_sys'=>'1','item_id'=>'7339','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/dd-website-slide/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'2124','is_sys'=>'1','item_id'=>'7337','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/dd-website-slide/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'2125','is_sys'=>'1','item_id'=>'7335','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/dd-website-slide/error','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'2126','is_sys'=>'1','item_id'=>'7333','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/dd-website-contact/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'2127','is_sys'=>'1','item_id'=>'7331','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/dd-website-contact/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'2128','is_sys'=>'1','item_id'=>'7329','parent_id'=>'13','parent'=>'站点管理','child'=>'/website/dd-website-contact/index','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'2136','is_sys'=>'1','item_id'=>'6','parent_id'=>'554','parent'=>'总管理员1','child'=>'开发示例','module_name'=>'sys','child_type'=>'1','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'2137','is_sys'=>'1','item_id'=>'7','parent_id'=>'554','parent'=>'总管理员1','child'=>'扩展功能','module_name'=>'sys','child_type'=>'1','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'2138','is_sys'=>'1','item_id'=>'8','parent_id'=>'554','parent'=>'总管理员1','child'=>'权限控制','module_name'=>'sys','child_type'=>'1','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'2139','is_sys'=>'0','item_id'=>'17','parent_id'=>'554','parent'=>'总管理员1','child'=>'订单管理','module_name'=>'sys','child_type'=>'1','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'2140','is_sys'=>'0','item_id'=>'20','parent_id'=>'554','parent'=>'总管理员1','child'=>'订单操作','module_name'=>'sys','child_type'=>'1','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'2159','is_sys'=>'1','item_id'=>'54','parent_id'=>'554','parent'=>'总管理员1','child'=>'站点设置','module_name'=>'sys','child_type'=>'1','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'2160','is_sys'=>'1','item_id'=>'59','parent_id'=>'9733','parent'=>'总管理员1','child'=>'基础权限组','module_name'=>'sys','child_type'=>'2','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'2174','is_sys'=>'1','item_id'=>'59','parent_id'=>'554','parent'=>'总管理员1','child'=>'基础权限组','module_name'=>'sys','child_type'=>'2','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'2177','is_sys'=>'1','item_id'=>'19','parent_id'=>'554','parent'=>'总管理员1','child'=>'资源上传','module_name'=>'sys','child_type'=>'1','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'2178','is_sys'=>'1','item_id'=>'60','parent_id'=>'554','parent'=>'总管理员1','child'=>'总管理员','module_name'=>'sys','child_type'=>'2','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'2179','is_sys'=>'1','item_id'=>'7099','parent_id'=>'554','parent'=>'总管理员1','child'=>'/settings/default/update','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'2181','is_sys'=>'1','item_id'=>'7101','parent_id'=>'554','parent'=>'总管理员1','child'=>'/settings/default/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'2182','is_sys'=>'1','item_id'=>'7102','parent_id'=>'554','parent'=>'总管理员1','child'=>'/settings/default/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'2189','is_sys'=>'1','item_id'=>'7169','parent_id'=>'54','parent'=>'站点设置','child'=>'/admin/user/login','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'2191','is_sys'=>'1','item_id'=>'7101','parent_id'=>'45','parent'=>'商户选择','child'=>'/settings/default/create','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'2192','is_sys'=>'1','item_id'=>'7102','parent_id'=>'45','parent'=>'商户选择','child'=>'/settings/default/delete','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'2193','is_sys'=>'1','item_id'=>'7105','parent_id'=>'45','parent'=>'商户选择','child'=>'/admin/assignment/view','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'2194','is_sys'=>'1','item_id'=>'2','parent_id'=>'45','parent'=>'商户选择','child'=>'人脸识别','module_name'=>'sys','child_type'=>'1','parent_type'=>'1']);
        $this->insert('{{%auth_item_child}}',['id'=>'2197','is_sys'=>'1','item_id'=>'6','parent_id'=>'45','parent'=>'商户选择','child'=>'开发示例','module_name'=>'sys','child_type'=>'1','parent_type'=>'1']);
        $this->insert('{{%auth_item_child}}',['id'=>'2321','is_sys'=>'1','item_id'=>'14016','parent_id'=>'551','parent'=>'基础权限组','child'=>'diandi_ceshi','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'2322','is_sys'=>'1','item_id'=>'14017','parent_id'=>'551','parent'=>'基础权限组','child'=>'/diandi_ceshi/default/index.vue','module_name'=>'sys','child_type'=>'0','parent_type'=>'2']);
        $this->insert('{{%auth_item_child}}',['id'=>'2323','is_sys'=>'1','item_id'=>'14017','parent_id'=>'6','parent'=>'开发示例','child'=>'/diandi_ceshi/default/index.vue','module_name'=>'sys','child_type'=>'0','parent_type'=>'3']);
        $this->insert('{{%auth_item_child}}',['id'=>'2510','is_sys'=>'1','item_id'=>'2','parent_id'=>'14','parent'=>'管理员管理','child'=>'人脸识别','module_name'=>'sys','child_type'=>'1','parent_type'=>'1']);
        $this->insert('{{%auth_item_child}}',['id'=>'2511','is_sys'=>'1','item_id'=>'6','parent_id'=>'14','parent'=>'管理员管理','child'=>'开发示例','module_name'=>'sys','child_type'=>'1','parent_type'=>'1']);
        $this->insert('{{%auth_item_child}}',['id'=>'2512','is_sys'=>'1','item_id'=>'7','parent_id'=>'14','parent'=>'管理员管理','child'=>'扩展功能','module_name'=>'sys','child_type'=>'1','parent_type'=>'1']);
        
        /* 设置外键约束 */
        $this->execute('SET foreign_key_checks = 1;');
    }

    public function down()
    {
        $this->execute('SET foreign_key_checks = 0');
        /* 删除表 */
        $this->dropTable('{{%auth_item_child}}');
        $this->execute('SET foreign_key_checks = 1;');
    }
}

