<?php

use yii\db\Migration;

class m220613_063635_auth_route extends Migration
{
    public function up()
    {
        /* 取消外键约束 */
        $this->execute('SET foreign_key_checks = 0');
        
        /* 创建表 */
        $this->createTable('{{%auth_route}}', [
            'id' => "int(11) NOT NULL AUTO_INCREMENT",
            'name' => "varchar(255) NOT NULL",
            'item_id' => "int(11) NULL",
            'route_name' => "varchar(255) NULL",
            'is_sys' => "smallint(6) NOT NULL",
            'route_type' => "smallint(6) NOT NULL DEFAULT '0'",
            'description' => "text NULL",
            'title' => "varchar(64) NULL",
            'pid' => "int(11) NULL DEFAULT '0'",
            'data' => "blob NULL",
            'module_name' => "varchar(50) NULL",
            'created_at' => "int(11) NULL",
            'updated_at' => "int(11) NULL",
            'PRIMARY KEY (`id`,`name`)'
        ], "ENGINE=InnoDB  DEFAULT CHARSET=utf8");
        
        /* 索引设置 */
        $this->createIndex('name','{{%auth_route}}','name',1);
        $this->createIndex('route_name','{{%auth_route}}','route_name',1);
        $this->createIndex('rule_name','{{%auth_route}}','title',0);
        $this->createIndex('type','{{%auth_route}}','is_sys',0);
        
        
        /* 表数据 */
        $this->insert('{{%auth_route}}',['id'=>'3','name'=>'/settings/default/update','item_id'=>'11652','route_name'=>'settings-default-update','is_sys'=>'1','route_type'=>'2','description'=>'描述1','title'=>'权限名称','pid'=>'461','data'=>'','module_name'=>'sys','created_at'=>'1588634163','updated_at'=>'1588634163']);
        $this->insert('{{%auth_route}}',['id'=>'5','name'=>'/settings/default/index','item_id'=>'11653','route_name'=>'settings-default-index','is_sys'=>'1','route_type'=>'1','description'=>'','title'=>'设置首页','pid'=>'461','data'=>'','module_name'=>'sys','created_at'=>'1588634166','updated_at'=>'1588634166']);
        $this->insert('{{%auth_route}}',['id'=>'6','name'=>'/settings/default/create','item_id'=>'11654','route_name'=>'settings-default-create','is_sys'=>'1','route_type'=>'2','description'=>'','title'=>'','pid'=>'461','data'=>'','module_name'=>'sys','created_at'=>'1588634166','updated_at'=>'1588634166']);
        $this->insert('{{%auth_route}}',['id'=>'7','name'=>'/settings/default/delete','item_id'=>'11655','route_name'=>'settings-default-delete','is_sys'=>'1','route_type'=>'2','description'=>'','title'=>'','pid'=>'704','data'=>'','module_name'=>'sys','created_at'=>'1588634166','updated_at'=>'1588634166']);
        $this->insert('{{%auth_route}}',['id'=>'9','name'=>'/admin/assignment/error','item_id'=>'11656','route_name'=>'admin-assignment-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634166','updated_at'=>'1588634166']);
        $this->insert('{{%auth_route}}',['id'=>'10','name'=>'/admin/assignment/index','item_id'=>'11657','route_name'=>'admin-assignment-index','is_sys'=>'1','route_type'=>'1','description'=>'','title'=>'权限分配','pid'=>'14','data'=>'','module_name'=>'sys','created_at'=>'1588634166','updated_at'=>'1588634166']);
        $this->insert('{{%auth_route}}',['id'=>'11','name'=>'/admin/assignment/view','item_id'=>'11658','route_name'=>'admin-assignment-view','is_sys'=>'1','route_type'=>'2','description'=>'','title'=>'','pid'=>'14','data'=>'','module_name'=>'sys','created_at'=>'1588634166','updated_at'=>'1588634166']);
        $this->insert('{{%auth_route}}',['id'=>'12','name'=>'/admin/assignment/assign','item_id'=>'11659','route_name'=>'admin-assignment-assign','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634166','updated_at'=>'1588634166']);
        $this->insert('{{%auth_route}}',['id'=>'13','name'=>'/admin/assignment/revoke','item_id'=>'11660','route_name'=>'admin-assignment-revoke','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634166','updated_at'=>'1588634166']);
        $this->insert('{{%auth_route}}',['id'=>'14','name'=>'/admin/assignment/*','item_id'=>'11661','route_name'=>'admin-assignment','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634166','updated_at'=>'1588634166']);
        $this->insert('{{%auth_route}}',['id'=>'28','name'=>'/admin/default/error','item_id'=>'11662','route_name'=>'admin-default-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634167','updated_at'=>'1588634167']);
        $this->insert('{{%auth_route}}',['id'=>'29','name'=>'/admin/default/index','item_id'=>'11663','route_name'=>'admin-default-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634167','updated_at'=>'1588634167']);
        $this->insert('{{%auth_route}}',['id'=>'30','name'=>'/admin/default/*','item_id'=>'11664','route_name'=>'admin-default','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634167','updated_at'=>'1588634167']);
        $this->insert('{{%auth_route}}',['id'=>'38','name'=>'/admin/group/error','item_id'=>'11665','route_name'=>'admin-group-error','is_sys'=>'1','route_type'=>'3','description'=>'','title'=>'管理角色错误输出','pid'=>'44','data'=>'','module_name'=>'sys','created_at'=>'1588634167','updated_at'=>'1588634167']);
        $this->insert('{{%auth_route}}',['id'=>'39','name'=>'/admin/group/index','item_id'=>'11666','route_name'=>'admin-group-index','is_sys'=>'1','route_type'=>'1','description'=>'','title'=>'用户角色','pid'=>'0','data'=>'','module_name'=>'sys','created_at'=>'1588634167','updated_at'=>'1588634167']);
        $this->insert('{{%auth_route}}',['id'=>'40','name'=>'/admin/group/view','item_id'=>'11667','route_name'=>'admin-group-view','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634167','updated_at'=>'1588634167']);
        $this->insert('{{%auth_route}}',['id'=>'41','name'=>'/admin/group/create','item_id'=>'11668','route_name'=>'admin-group-create','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634167','updated_at'=>'1588634167']);
        $this->insert('{{%auth_route}}',['id'=>'42','name'=>'/admin/group/update','item_id'=>'11669','route_name'=>'admin-group-update','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634167','updated_at'=>'1588634167']);
        $this->insert('{{%auth_route}}',['id'=>'43','name'=>'/admin/group/delete','item_id'=>'11670','route_name'=>'admin-group-delete','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'44','name'=>'/admin/group/*','item_id'=>'11671','route_name'=>'admin-group','is_sys'=>'1','route_type'=>'0','description'=>'描述','title'=>'角色','pid'=>'0','data'=>'','module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'45','name'=>'/admin/menu/error','item_id'=>'11672','route_name'=>'admin-menu-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'46','name'=>'/admin/menu/index','item_id'=>'11673','route_name'=>'admin-menu-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'47','name'=>'/admin/menu/view','item_id'=>'11674','route_name'=>'admin-menu-view','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'48','name'=>'/admin/menu/create','item_id'=>'11675','route_name'=>'admin-menu-create','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'49','name'=>'/admin/menu/update','item_id'=>'11676','route_name'=>'admin-menu-update','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'50','name'=>'/admin/menu/update-files','item_id'=>'11677','route_name'=>'admin-menu-update-files','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'51','name'=>'/admin/menu/delete','item_id'=>'11678','route_name'=>'admin-menu-delete','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'52','name'=>'/admin/menu/*','item_id'=>'11679','route_name'=>'admin-menu','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'53','name'=>'/admin/menu-top/index','item_id'=>'11680','route_name'=>'admin-menu-top-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'54','name'=>'/admin/menu-top/view','item_id'=>'11681','route_name'=>'admin-menu-top-view','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'55','name'=>'/admin/menu-top/create','item_id'=>'11682','route_name'=>'admin-menu-top-create','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'56','name'=>'/admin/menu-top/update','item_id'=>'11683','route_name'=>'admin-menu-top-update','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'57','name'=>'/admin/menu-top/delete','item_id'=>'11684','route_name'=>'admin-menu-top-delete','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'58','name'=>'/admin/menu-top/*','item_id'=>'11685','route_name'=>'admin-menu-top','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'59','name'=>'/admin/permission/index','item_id'=>'11686','route_name'=>'admin-permission-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'60','name'=>'/admin/permission/view','item_id'=>'11687','route_name'=>'admin-permission-view','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'61','name'=>'/admin/permission/create','item_id'=>'11688','route_name'=>'admin-permission-create','is_sys'=>'1','route_type'=>'2','description'=>'','title'=>'','pid'=>'59','data'=>'','module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'62','name'=>'/admin/permission/update','item_id'=>'11689','route_name'=>'admin-permission-update','is_sys'=>'1','route_type'=>'2','description'=>'','title'=>'','pid'=>'59','data'=>'','module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'63','name'=>'/admin/permission/delete','item_id'=>'11690','route_name'=>'admin-permission-delete','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'64','name'=>'/admin/permission/assign','item_id'=>'11691','route_name'=>'admin-permission-assign','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'65','name'=>'/admin/permission/remove','item_id'=>'11692','route_name'=>'admin-permission-remove','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'66','name'=>'/admin/permission/*','item_id'=>'11693','route_name'=>'admin-permission','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'67','name'=>'/admin/role/index','item_id'=>'11694','route_name'=>'admin-role-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'68','name'=>'/admin/role/view','item_id'=>'11695','route_name'=>'admin-role-view','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'69','name'=>'/admin/role/create','item_id'=>'11696','route_name'=>'admin-role-create','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'70','name'=>'/admin/role/update','item_id'=>'11697','route_name'=>'admin-role-update','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'71','name'=>'/admin/role/delete','item_id'=>'11698','route_name'=>'admin-role-delete','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'72','name'=>'/admin/role/assign','item_id'=>'11699','route_name'=>'admin-role-assign','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'73','name'=>'/admin/role/remove','item_id'=>'11700','route_name'=>'admin-role-remove','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'74','name'=>'/admin/role/*','item_id'=>'11701','route_name'=>'admin-role','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'75','name'=>'/admin/route/error','item_id'=>'11702','route_name'=>'admin-route-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'76','name'=>'/admin/route/index','item_id'=>'11703','route_name'=>'admin-route-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'77','name'=>'/admin/route/create','item_id'=>'11704','route_name'=>'admin-route-create','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'78','name'=>'/admin/route/assign','item_id'=>'11705','route_name'=>'admin-route-assign','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'79','name'=>'/admin/route/remove','item_id'=>'11706','route_name'=>'admin-route-remove','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'80','name'=>'/admin/route/refresh','item_id'=>'11707','route_name'=>'admin-route-refresh','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'81','name'=>'/admin/route/*','item_id'=>'11708','route_name'=>'admin-route','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'82','name'=>'/admin/rule/error','item_id'=>'11709','route_name'=>'admin-rule-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'83','name'=>'/admin/rule/index','item_id'=>'11710','route_name'=>'admin-rule-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'84','name'=>'/admin/rule/view','item_id'=>'11711','route_name'=>'admin-rule-view','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'85','name'=>'/admin/rule/create','item_id'=>'11712','route_name'=>'admin-rule-create','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'86','name'=>'/admin/rule/update','item_id'=>'11713','route_name'=>'admin-rule-update','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'87','name'=>'/admin/rule/delete','item_id'=>'11714','route_name'=>'admin-rule-delete','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'88','name'=>'/admin/rule/*','item_id'=>'11715','route_name'=>'admin-rule','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'97','name'=>'/admin/user-bloc/*','item_id'=>'11716','route_name'=>'admin-user-bloc','is_sys'=>'1','route_type'=>'0','description'=>'','title'=>'用户商户管理','pid'=>'0','data'=>'','module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'98','name'=>'/admin/user/error','item_id'=>'11717','route_name'=>'admin-user-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634170','updated_at'=>'1588634170']);
        $this->insert('{{%auth_route}}',['id'=>'99','name'=>'/admin/user/index','item_id'=>'11718','route_name'=>'admin-user-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634170','updated_at'=>'1588634170']);
        $this->insert('{{%auth_route}}',['id'=>'100','name'=>'/admin/user/update','item_id'=>'11719','route_name'=>'admin-user-update','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634170','updated_at'=>'1588634170']);
        $this->insert('{{%auth_route}}',['id'=>'101','name'=>'/admin/user/view','item_id'=>'11720','route_name'=>'admin-user-view','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634170','updated_at'=>'1588634170']);
        $this->insert('{{%auth_route}}',['id'=>'102','name'=>'/admin/user/delete','item_id'=>'11721','route_name'=>'admin-user-delete','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634170','updated_at'=>'1588634170']);
        $this->insert('{{%auth_route}}',['id'=>'103','name'=>'/admin/user/login','item_id'=>'11722','route_name'=>'admin-user-login','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634170','updated_at'=>'1588634170']);
        $this->insert('{{%auth_route}}',['id'=>'104','name'=>'/admin/user/logout','item_id'=>'11723','route_name'=>'admin-user-logout','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634170','updated_at'=>'1588634170']);
        $this->insert('{{%auth_route}}',['id'=>'105','name'=>'/admin/user/signup','item_id'=>'11724','route_name'=>'admin-user-signup','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634170','updated_at'=>'1588634170']);
        $this->insert('{{%auth_route}}',['id'=>'106','name'=>'/admin/user/request-password-reset','item_id'=>'11725','route_name'=>'admin-user-request-password-reset','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634170','updated_at'=>'1588634170']);
        $this->insert('{{%auth_route}}',['id'=>'107','name'=>'/admin/user/reset-password','item_id'=>'11726','route_name'=>'admin-user-reset-password','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634170','updated_at'=>'1588634170']);
        $this->insert('{{%auth_route}}',['id'=>'108','name'=>'/admin/user/change-password','item_id'=>'11727','route_name'=>'admin-user-change-password','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634170','updated_at'=>'1588634170']);
        $this->insert('{{%auth_route}}',['id'=>'109','name'=>'/admin/user/activate','item_id'=>'11728','route_name'=>'admin-user-activate','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634170','updated_at'=>'1588634170']);
        $this->insert('{{%auth_route}}',['id'=>'110','name'=>'/admin/user/*','item_id'=>'11729','route_name'=>'admin-user','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634170','updated_at'=>'1588634170']);
        $this->insert('{{%auth_route}}',['id'=>'125','name'=>'/admin/*','item_id'=>'11730','route_name'=>'admin','is_sys'=>'1','route_type'=>'0','description'=>'','title'=>'权限管理','pid'=>'0','data'=>'','module_name'=>'sys','created_at'=>'1588634170','updated_at'=>'1588634170']);
        $this->insert('{{%auth_route}}',['id'=>'126','name'=>'/modal/modal/website','item_id'=>'11731','route_name'=>'modal-modal-website','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634170','updated_at'=>'1588634170']);
        $this->insert('{{%auth_route}}',['id'=>'127','name'=>'/modal/modal/icons','item_id'=>'11732','route_name'=>'modal-modal-icons','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'128','name'=>'/modal/modal/*','item_id'=>'11733','route_name'=>'modal-modal','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'129','name'=>'/modal/*','item_id'=>'11734','route_name'=>'modal','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'130','name'=>'/addons/addons/error','item_id'=>'11735','route_name'=>'addons-addons-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'131','name'=>'/addons/addons/index','item_id'=>'11736','route_name'=>'addons-addons-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'132','name'=>'/addons/addons/uninstalled','item_id'=>'11737','route_name'=>'addons-addons-uninstalled','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'133','name'=>'/addons/addons/view','item_id'=>'11738','route_name'=>'addons-addons-view','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'134','name'=>'/addons/addons/logo','item_id'=>'11739','route_name'=>'addons-addons-logo','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'135','name'=>'/addons/addons/create','item_id'=>'11740','route_name'=>'addons-addons-create','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'136','name'=>'/addons/addons/update','item_id'=>'11741','route_name'=>'addons-addons-update','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'137','name'=>'/addons/addons/delete','item_id'=>'11742','route_name'=>'addons-addons-delete','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'138','name'=>'/addons/addons/*','item_id'=>'11743','route_name'=>'addons-addons','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'139','name'=>'/addons/manage/error','item_id'=>'11744','route_name'=>'addons-manage-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'140','name'=>'/addons/manage/install','item_id'=>'11745','route_name'=>'addons-manage-install','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'141','name'=>'/addons/manage/update','item_id'=>'11746','route_name'=>'addons-manage-update','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'142','name'=>'/addons/manage/uninstall','item_id'=>'11747','route_name'=>'addons-manage-uninstall','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'143','name'=>'/addons/manage/auth','item_id'=>'11748','route_name'=>'addons-manage-auth','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'144','name'=>'/addons/manage/*','item_id'=>'11749','route_name'=>'addons-manage','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'145','name'=>'/addons/menu/error','item_id'=>'11750','route_name'=>'addons-menu-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'146','name'=>'/addons/menu/index','item_id'=>'11751','route_name'=>'addons-menu-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'147','name'=>'/addons/menu/view','item_id'=>'11752','route_name'=>'addons-menu-view','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'148','name'=>'/addons/menu/create','item_id'=>'11753','route_name'=>'addons-menu-create','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'149','name'=>'/addons/menu/update','item_id'=>'11754','route_name'=>'addons-menu-update','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'150','name'=>'/addons/menu/delete','item_id'=>'11755','route_name'=>'addons-menu-delete','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'151','name'=>'/addons/menu/*','item_id'=>'11756','route_name'=>'addons-menu','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'152','name'=>'/addons/*','item_id'=>'11757','route_name'=>'addons','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'153','name'=>'/gii/default/index','item_id'=>'11758','route_name'=>'gii-default-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634172','updated_at'=>'1588634172']);
        $this->insert('{{%auth_route}}',['id'=>'154','name'=>'/gii/default/view','item_id'=>'11759','route_name'=>'gii-default-view','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634172','updated_at'=>'1588634172']);
        $this->insert('{{%auth_route}}',['id'=>'155','name'=>'/gii/default/preview','item_id'=>'11760','route_name'=>'gii-default-preview','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634172','updated_at'=>'1588634172']);
        $this->insert('{{%auth_route}}',['id'=>'156','name'=>'/gii/default/diff','item_id'=>'11761','route_name'=>'gii-default-diff','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634172','updated_at'=>'1588634172']);
        $this->insert('{{%auth_route}}',['id'=>'157','name'=>'/gii/default/action','item_id'=>'11762','route_name'=>'gii-default-action','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634172','updated_at'=>'1588634172']);
        $this->insert('{{%auth_route}}',['id'=>'158','name'=>'/gii/default/*','item_id'=>'11763','route_name'=>'gii-default','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634172','updated_at'=>'1588634172']);
        $this->insert('{{%auth_route}}',['id'=>'159','name'=>'/gii/*','item_id'=>'11764','route_name'=>'gii','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634172','updated_at'=>'1588634172']);
        $this->insert('{{%auth_route}}',['id'=>'296','name'=>'/base/error','item_id'=>'11766','route_name'=>'base-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634177','updated_at'=>'1588634177']);
        $this->insert('{{%auth_route}}',['id'=>'297','name'=>'/base/*','item_id'=>'11767','route_name'=>'base','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634177','updated_at'=>'1588634177']);
        $this->insert('{{%auth_route}}',['id'=>'298','name'=>'/module/error','item_id'=>'11768','route_name'=>'module-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634177','updated_at'=>'1588634177']);
        $this->insert('{{%auth_route}}',['id'=>'299','name'=>'/module/index','item_id'=>'11769','route_name'=>'module-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634177','updated_at'=>'1588634177']);
        $this->insert('{{%auth_route}}',['id'=>'300','name'=>'/module/*','item_id'=>'11770','route_name'=>'module','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634177','updated_at'=>'1588634177']);
        $this->insert('{{%auth_route}}',['id'=>'301','name'=>'/site/error','item_id'=>'11771','route_name'=>'site-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634177','updated_at'=>'1588634177']);
        $this->insert('{{%auth_route}}',['id'=>'302','name'=>'/site/index','item_id'=>'11772','route_name'=>'site-index','is_sys'=>'1','route_type'=>'1','description'=>'','title'=>'站点首页','pid'=>'310','data'=>'','module_name'=>'sys','created_at'=>'1588634177','updated_at'=>'1588634177']);
        $this->insert('{{%auth_route}}',['id'=>'303','name'=>'/site/login','item_id'=>'11773','route_name'=>'site-login','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634177','updated_at'=>'1588634177']);
        $this->insert('{{%auth_route}}',['id'=>'304','name'=>'/site/logout','item_id'=>'11774','route_name'=>'site-logout','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634177','updated_at'=>'1588634177']);
        $this->insert('{{%auth_route}}',['id'=>'305','name'=>'/site/signup','item_id'=>'11775','route_name'=>'site-signup','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634177','updated_at'=>'1588634177']);
        $this->insert('{{%auth_route}}',['id'=>'306','name'=>'/site/request-password-reset','item_id'=>'11776','route_name'=>'site-request-password-reset','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634177','updated_at'=>'1588634177']);
        $this->insert('{{%auth_route}}',['id'=>'307','name'=>'/site/reset-password','item_id'=>'11777','route_name'=>'site-reset-password','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634177','updated_at'=>'1588634177']);
        $this->insert('{{%auth_route}}',['id'=>'308','name'=>'/site/verify-email','item_id'=>'11778','route_name'=>'site-verify-email','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634177','updated_at'=>'1588634177']);
        $this->insert('{{%auth_route}}',['id'=>'309','name'=>'/site/resend-verification-email','item_id'=>'11779','route_name'=>'site-resend-verification-email','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'310','name'=>'/site/*','item_id'=>'11780','route_name'=>'site','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'311','name'=>'/article/dd-article-category/error','item_id'=>'11781','route_name'=>'article-dd-article-category-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'312','name'=>'/article/dd-article-category/index','item_id'=>'11782','route_name'=>'article-dd-article-category-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'313','name'=>'/article/dd-article-category/view','item_id'=>'11783','route_name'=>'article-dd-article-category-view','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'314','name'=>'/article/dd-article-category/create','item_id'=>'11784','route_name'=>'article-dd-article-category-create','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'315','name'=>'/article/dd-article-category/update','item_id'=>'11785','route_name'=>'article-dd-article-category-update','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'316','name'=>'/article/dd-article-category/delete','item_id'=>'11786','route_name'=>'article-dd-article-category-delete','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'317','name'=>'/article/dd-article-category/childcate','item_id'=>'11787','route_name'=>'article-dd-article-category-childcate','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'318','name'=>'/article/dd-article-category/*','item_id'=>'11788','route_name'=>'article-dd-article-category','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'319','name'=>'/article/dd-article/upload','item_id'=>'11789','route_name'=>'article-dd-article-upload','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'320','name'=>'/article/dd-article/index','item_id'=>'11790','route_name'=>'article-dd-article-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'321','name'=>'/article/dd-article/view','item_id'=>'11791','route_name'=>'article-dd-article-view','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'322','name'=>'/article/dd-article/create','item_id'=>'11792','route_name'=>'article-dd-article-create','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'323','name'=>'/article/dd-article/update','item_id'=>'11793','route_name'=>'article-dd-article-update','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'324','name'=>'/article/dd-article/delete','item_id'=>'11794','route_name'=>'article-dd-article-delete','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'325','name'=>'/article/dd-article/*','item_id'=>'11795','route_name'=>'article-dd-article','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'326','name'=>'/article/record/index','item_id'=>'11796','route_name'=>'article-record-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'327','name'=>'/article/record/view','item_id'=>'11797','route_name'=>'article-record-view','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'328','name'=>'/article/record/create','item_id'=>'11798','route_name'=>'article-record-create','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'329','name'=>'/article/record/update','item_id'=>'11799','route_name'=>'article-record-update','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'330','name'=>'/article/record/delete','item_id'=>'11800','route_name'=>'article-record-delete','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'331','name'=>'/article/record/*','item_id'=>'11801','route_name'=>'article-record','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'332','name'=>'/demo/form/error','item_id'=>'11802','route_name'=>'demo-form-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'333','name'=>'/demo/form/get-region','item_id'=>'11803','route_name'=>'demo-form-get-region','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'334','name'=>'/demo/form/index','item_id'=>'11804','route_name'=>'demo-form-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'335','name'=>'/demo/form/maile','item_id'=>'11805','route_name'=>'demo-form-maile','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'336','name'=>'/demo/form/*','item_id'=>'11806','route_name'=>'demo-form','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634179','updated_at'=>'1588634179']);
        $this->insert('{{%auth_route}}',['id'=>'366','name'=>'/member/dd-member/error','item_id'=>'11807','route_name'=>'member-dd-member-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'367','name'=>'/member/dd-member/index','item_id'=>'11808','route_name'=>'member-dd-member-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'368','name'=>'/member/dd-member/view','item_id'=>'11809','route_name'=>'member-dd-member-view','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'369','name'=>'/member/dd-member/create','item_id'=>'11810','route_name'=>'member-dd-member-create','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'370','name'=>'/member/dd-member/update','item_id'=>'11811','route_name'=>'member-dd-member-update','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'371','name'=>'/member/dd-member/delete','item_id'=>'11812','route_name'=>'member-dd-member-delete','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'372','name'=>'/member/dd-member/*','item_id'=>'11813','route_name'=>'member-dd-member','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'373','name'=>'/member/dd-member-group/error','item_id'=>'11814','route_name'=>'member-dd-member-group-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'374','name'=>'/member/dd-member-group/index','item_id'=>'11815','route_name'=>'member-dd-member-group-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'375','name'=>'/member/dd-member-group/view','item_id'=>'11816','route_name'=>'member-dd-member-group-view','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'376','name'=>'/member/dd-member-group/create','item_id'=>'11817','route_name'=>'member-dd-member-group-create','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'377','name'=>'/member/dd-member-group/update','item_id'=>'11818','route_name'=>'member-dd-member-group-update','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'378','name'=>'/member/dd-member-group/delete','item_id'=>'11819','route_name'=>'member-dd-member-group-delete','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'379','name'=>'/member/dd-member-group/*','item_id'=>'11820','route_name'=>'member-dd-member-group','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'380','name'=>'/system/index/error','item_id'=>'11821','route_name'=>'system-index-error','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'381','name'=>'/system/index/index','item_id'=>'11822','route_name'=>'system-index-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'382','name'=>'/system/index/childcate','item_id'=>'11823','route_name'=>'system-index-childcate','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'383','name'=>'/system/index/*','item_id'=>'11824','route_name'=>'system-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'384','name'=>'/system/settings/baidu','item_id'=>'11825','route_name'=>'system-settings-baidu','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'385','name'=>'/system/settings/wxapp','item_id'=>'11826','route_name'=>'system-settings-wxapp','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'386','name'=>'/system/settings/wechatpay','item_id'=>'11827','route_name'=>'system-settings-wechatpay','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'388','name'=>'/system/settings/sms','item_id'=>'11828','route_name'=>'system-settings-sms','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'389','name'=>'/system/settings/email','item_id'=>'11829','route_name'=>'system-settings-email','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'390','name'=>'/system/settings/clear-cache','item_id'=>'11830','route_name'=>'system-settings-clear-cache','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'391','name'=>'/system/settings/*','item_id'=>'11831','route_name'=>'system-settings','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'392','name'=>'/system/welcome/error','item_id'=>'11832','route_name'=>'system-welcome-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'393','name'=>'/system/welcome/index','item_id'=>'11833','route_name'=>'system-welcome-index','is_sys'=>'1','route_type'=>'1','description'=>'','title'=>'系统欢迎页','pid'=>'0','data'=>'','module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'394','name'=>'/system/welcome/sysai','item_id'=>'11834','route_name'=>'system-welcome-sysai','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'395','name'=>'/system/welcome/member','item_id'=>'11835','route_name'=>'system-welcome-member','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'396','name'=>'/system/welcome/aimember','item_id'=>'11836','route_name'=>'system-welcome-aimember','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'397','name'=>'/system/welcome/goods','item_id'=>'11837','route_name'=>'system-welcome-goods','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'398','name'=>'/system/welcome/marketing','item_id'=>'11838','route_name'=>'system-welcome-marketing','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'399','name'=>'/system/welcome/order','item_id'=>'11839','route_name'=>'system-welcome-order','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'400','name'=>'/system/welcome/wxapp','item_id'=>'11840','route_name'=>'system-welcome-wxapp','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'401','name'=>'/system/welcome/plugins','item_id'=>'11841','route_name'=>'system-welcome-plugins','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'402','name'=>'/system/welcome/system','item_id'=>'11842','route_name'=>'system-welcome-system','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'403','name'=>'/system/welcome/*','item_id'=>'11843','route_name'=>'system-welcome','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'404','name'=>'/upload/upload/error','item_id'=>'11844','route_name'=>'upload-upload-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'405','name'=>'/upload/upload/uploadimg','item_id'=>'11845','route_name'=>'upload-upload-uploadimg','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'406','name'=>'/upload/upload/uploadfile','item_id'=>'11846','route_name'=>'upload-upload-uploadfile','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'407','name'=>'/upload/upload/*','item_id'=>'11847','route_name'=>'upload-upload','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'408','name'=>'/user/dd-user/error','item_id'=>'11848','route_name'=>'user-dd-user-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'409','name'=>'/user/dd-user/index','item_id'=>'11849','route_name'=>'user-dd-user-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'410','name'=>'/user/dd-user/view','item_id'=>'11850','route_name'=>'user-dd-user-view','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'411','name'=>'/user/dd-user/create','item_id'=>'11851','route_name'=>'user-dd-user-create','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'412','name'=>'/user/dd-user/update','item_id'=>'11852','route_name'=>'user-dd-user-update','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'413','name'=>'/user/dd-user/profile','item_id'=>'11853','route_name'=>'user-dd-user-profile','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'414','name'=>'/user/dd-user/delete','item_id'=>'11854','route_name'=>'user-dd-user-delete','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'415','name'=>'/user/dd-user/*','item_id'=>'11855','route_name'=>'user-dd-user','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'416','name'=>'/website/dd-website-contact/error','item_id'=>'11856','route_name'=>'website-dd-website-contact-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'417','name'=>'/website/dd-website-contact/index','item_id'=>'11857','route_name'=>'website-dd-website-contact-index','is_sys'=>'1','route_type'=>'1','description'=>'','title'=>'联系我们','pid'=>'422','data'=>'','module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'418','name'=>'/website/dd-website-contact/view','item_id'=>'11858','route_name'=>'website-dd-website-contact-view','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'419','name'=>'/website/dd-website-contact/create','item_id'=>'11859','route_name'=>'website-dd-website-contact-create','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'420','name'=>'/website/dd-website-contact/update','item_id'=>'11860','route_name'=>'website-dd-website-contact-update','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'421','name'=>'/website/dd-website-contact/delete','item_id'=>'11861','route_name'=>'website-dd-website-contact-delete','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'422','name'=>'/website/dd-website-contact/*','item_id'=>'11862','route_name'=>'website-dd-website-contact','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'423','name'=>'/website/dd-website-slide/error','item_id'=>'11863','route_name'=>'website-dd-website-slide-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'424','name'=>'/website/dd-website-slide/index','item_id'=>'11864','route_name'=>'website-dd-website-slide-index','is_sys'=>'1','route_type'=>'1','description'=>'','title'=>'站点幻灯片','pid'=>'429','data'=>'','module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'425','name'=>'/website/dd-website-slide/view','item_id'=>'11865','route_name'=>'website-dd-website-slide-view','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'426','name'=>'/website/dd-website-slide/create','item_id'=>'11866','route_name'=>'website-dd-website-slide-create','is_sys'=>'1','route_type'=>'2','description'=>'','title'=>'幻灯片-创建','pid'=>'429','data'=>'','module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'427','name'=>'/website/dd-website-slide/update','item_id'=>'11867','route_name'=>'website-dd-website-slide-update','is_sys'=>'1','route_type'=>'2','description'=>'','title'=>'幻灯片-编辑','pid'=>'429','data'=>'','module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'428','name'=>'/website/dd-website-slide/delete','item_id'=>'11868','route_name'=>'website-dd-website-slide-delete','is_sys'=>'1','route_type'=>'2','description'=>'','title'=>'幻灯片-删除','pid'=>'429','data'=>'','module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'429','name'=>'/website/dd-website-slide/*','item_id'=>'11869','route_name'=>'website-dd-website-slide','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'430','name'=>'/website/setting/website','item_id'=>'11870','route_name'=>'website-setting-website','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'431','name'=>'/website/setting/*','item_id'=>'11871','route_name'=>'website-setting','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'432','name'=>'/*','item_id'=>'11872','route_name'=>'*','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'433','name'=>'/admin/group/assign','item_id'=>'11873','route_name'=>'admin-group-assign','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588749311','updated_at'=>'1588749311']);
        $this->insert('{{%auth_route}}',['id'=>'434','name'=>'/admin/group/remove','item_id'=>'11874','route_name'=>'admin-group-remove','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588749311','updated_at'=>'1588749311']);
        $this->insert('{{%auth_route}}',['id'=>'455','name'=>'/system/settings/map','item_id'=>'11875','route_name'=>'system-settings-map','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1590020676','updated_at'=>'1590020676']);
        $this->insert('{{%auth_route}}',['id'=>'456','name'=>'/system/settings/set-cache','item_id'=>'11876','route_name'=>'system-settings-set-cache','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1590020676','updated_at'=>'1590020676']);
        $this->insert('{{%auth_route}}',['id'=>'461','name'=>'/settings/default/*','item_id'=>'11877','route_name'=>'settings-default','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1590024401','updated_at'=>'1590024401']);
        $this->insert('{{%auth_route}}',['id'=>'477','name'=>'/gii/addons','item_id'=>'11878','route_name'=>'gii-addons','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1590915881','updated_at'=>'1590915881']);
        $this->insert('{{%auth_route}}',['id'=>'616','name'=>'/system/database/*','item_id'=>'11949','route_name'=>'system-database','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1592915329','updated_at'=>'1592915329']);
        $this->insert('{{%auth_route}}',['id'=>'617','name'=>'/system/database/error','item_id'=>'11950','route_name'=>'system-database-error','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1592917793','updated_at'=>'1592917793']);
        $this->insert('{{%auth_route}}',['id'=>'618','name'=>'/system/database/backups','item_id'=>'11951','route_name'=>'system-database-backups','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1592917793','updated_at'=>'1592917793']);
        $this->insert('{{%auth_route}}',['id'=>'619','name'=>'/system/database/export','item_id'=>'11952','route_name'=>'system-database-export','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1592917793','updated_at'=>'1592917793']);
        $this->insert('{{%auth_route}}',['id'=>'620','name'=>'/system/database/export-start','item_id'=>'11953','route_name'=>'system-database-export-start','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1592917793','updated_at'=>'1592917793']);
        $this->insert('{{%auth_route}}',['id'=>'621','name'=>'/system/database/optimize','item_id'=>'11954','route_name'=>'system-database-optimize','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1592917793','updated_at'=>'1592917793']);
        $this->insert('{{%auth_route}}',['id'=>'622','name'=>'/system/database/repair','item_id'=>'11955','route_name'=>'system-database-repair','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1592917793','updated_at'=>'1592917793']);
        $this->insert('{{%auth_route}}',['id'=>'623','name'=>'/system/database/restore','item_id'=>'11956','route_name'=>'system-database-restore','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1592917793','updated_at'=>'1592917793']);
        $this->insert('{{%auth_route}}',['id'=>'624','name'=>'/system/database/restore-init','item_id'=>'11957','route_name'=>'system-database-restore-init','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1592917793','updated_at'=>'1592917793']);
        $this->insert('{{%auth_route}}',['id'=>'625','name'=>'/system/database/restore-start','item_id'=>'11958','route_name'=>'system-database-restore-start','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1592917793','updated_at'=>'1592917793']);
        $this->insert('{{%auth_route}}',['id'=>'626','name'=>'/system/database/delete','item_id'=>'11959','route_name'=>'system-database-delete','is_sys'=>'0','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1592917793','updated_at'=>'1592917793']);
        $this->insert('{{%auth_route}}',['id'=>'627','name'=>'/system/database/data-dictionary','item_id'=>'11960','route_name'=>'system-database-data-dictionary','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1592917793','updated_at'=>'1592917793']);
        $this->insert('{{%auth_route}}',['id'=>'668','name'=>'/system/database/backlist','item_id'=>'11961','route_name'=>'system-database-backlist','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1593007222','updated_at'=>'1593007222']);
        $this->insert('{{%auth_route}}',['id'=>'701','name'=>'/ds','item_id'=>'11965','route_name'=>'ds','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1593682380','updated_at'=>'1593682380']);
        $this->insert('{{%auth_route}}',['id'=>'702','name'=>'/debug/default/view','item_id'=>'11966','route_name'=>'debug-default-view','is_sys'=>'0','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1594610576','updated_at'=>'1594610576']);
        $this->insert('{{%auth_route}}',['id'=>'703','name'=>'/debug/*','item_id'=>'11967','route_name'=>'debug','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1594610578','updated_at'=>'1594610578']);
        $this->insert('{{%auth_route}}',['id'=>'704','name'=>'/settings/default/edit-setting','item_id'=>'11968','route_name'=>'settings-default-edit-setting','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1595516153','updated_at'=>'1595516153']);
        $this->insert('{{%auth_route}}',['id'=>'705','name'=>'/debug/default/db-explain','item_id'=>'11969','route_name'=>'debug-default-db-explain','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1595516153','updated_at'=>'1595516153']);
        $this->insert('{{%auth_route}}',['id'=>'706','name'=>'/debug/default/index','item_id'=>'11970','route_name'=>'debug-default-index','is_sys'=>'0','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1595516153','updated_at'=>'1595516153']);
        $this->insert('{{%auth_route}}',['id'=>'707','name'=>'/debug/default/toolbar','item_id'=>'11971','route_name'=>'debug-default-toolbar','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1595516153','updated_at'=>'1595516153']);
        $this->insert('{{%auth_route}}',['id'=>'708','name'=>'/debug/default/download-mail','item_id'=>'11972','route_name'=>'debug-default-download-mail','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1595516153','updated_at'=>'1595516153']);
        $this->insert('{{%auth_route}}',['id'=>'709','name'=>'/debug/default/*','item_id'=>'11973','route_name'=>'debug-default','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1595516154','updated_at'=>'1595516154']);
        $this->insert('{{%auth_route}}',['id'=>'710','name'=>'/debug/user/set-identity','item_id'=>'11974','route_name'=>'debug-user-set-identity','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1595516154','updated_at'=>'1595516154']);
        $this->insert('{{%auth_route}}',['id'=>'711','name'=>'/debug/user/reset-identity','item_id'=>'11975','route_name'=>'debug-user-reset-identity','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1595516154','updated_at'=>'1595516154']);
        $this->insert('{{%auth_route}}',['id'=>'712','name'=>'/debug/user/*','item_id'=>'11976','route_name'=>'debug-user','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1595516154','updated_at'=>'1595516154']);
        $this->insert('{{%auth_route}}',['id'=>'759','name'=>'/site/setpassword','item_id'=>'12010','route_name'=>'site-setpassword','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1595516155','updated_at'=>'1595516155']);
        $this->insert('{{%auth_route}}',['id'=>'766','name'=>'/admin/user/assign','item_id'=>'12011','route_name'=>'admin-user-assign','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1596778177','updated_at'=>'1596778177']);
        $this->insert('{{%auth_route}}',['id'=>'767','name'=>'/admin/user/remove','item_id'=>'12012','route_name'=>'admin-user-remove','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1596778177','updated_at'=>'1596778177']);
        $this->insert('{{%auth_route}}',['id'=>'768','name'=>'/diandi_shop/wxapp/dd-wxapp-page/index','item_id'=>'12013','route_name'=>'diandi-shop-wxapp-dd-wxapp-page-index','is_sys'=>'0','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1596778177','updated_at'=>'1596778177']);
        $this->insert('{{%auth_route}}',['id'=>'769','name'=>'/diandi_shop/wxapp/dd-wxapp-page/view','item_id'=>'12014','route_name'=>'diandi-shop-wxapp-dd-wxapp-page-view','is_sys'=>'0','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1596778177','updated_at'=>'1596778177']);
        $this->insert('{{%auth_route}}',['id'=>'770','name'=>'/diandi_shop/wxapp/dd-wxapp-page/create','item_id'=>'12015','route_name'=>'diandi-shop-wxapp-dd-wxapp-page-create','is_sys'=>'0','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1596778177','updated_at'=>'1596778177']);
        $this->insert('{{%auth_route}}',['id'=>'771','name'=>'/diandi_shop/wxapp/dd-wxapp-page/update','item_id'=>'12016','route_name'=>'diandi-shop-wxapp-dd-wxapp-page-update','is_sys'=>'0','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1596778177','updated_at'=>'1596778177']);
        $this->insert('{{%auth_route}}',['id'=>'772','name'=>'/diandi_shop/wxapp/dd-wxapp-page/delete','item_id'=>'12017','route_name'=>'diandi-shop-wxapp-dd-wxapp-page-delete','is_sys'=>'0','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1596778177','updated_at'=>'1596778177']);
        $this->insert('{{%auth_route}}',['id'=>'788','name'=>'/diandi_store/record/error','item_id'=>'12030','route_name'=>'diandi-store-record-error','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142583','updated_at'=>'1597142583']);
        $this->insert('{{%auth_route}}',['id'=>'789','name'=>'/diandi_store/record/index','item_id'=>'12031','route_name'=>'diandi-store-record-index','is_sys'=>'0','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142583','updated_at'=>'1597142583']);
        $this->insert('{{%auth_route}}',['id'=>'790','name'=>'/diandi_store/record/view','item_id'=>'12032','route_name'=>'diandi-store-record-view','is_sys'=>'0','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142583','updated_at'=>'1597142583']);
        $this->insert('{{%auth_route}}',['id'=>'791','name'=>'/diandi_store/record/create','item_id'=>'12033','route_name'=>'diandi-store-record-create','is_sys'=>'0','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142583','updated_at'=>'1597142583']);
        $this->insert('{{%auth_route}}',['id'=>'792','name'=>'/diandi_store/record/update','item_id'=>'12034','route_name'=>'diandi-store-record-update','is_sys'=>'0','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142583','updated_at'=>'1597142583']);
        $this->insert('{{%auth_route}}',['id'=>'793','name'=>'/diandi_store/record/delete','item_id'=>'12035','route_name'=>'diandi-store-record-delete','is_sys'=>'0','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142583','updated_at'=>'1597142583']);
        $this->insert('{{%auth_route}}',['id'=>'794','name'=>'/diandi_store/record/*','item_id'=>'12036','route_name'=>'diandi-store-record','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142583','updated_at'=>'1597142583']);
        $this->insert('{{%auth_route}}',['id'=>'795','name'=>'/diandi_store/store/error','item_id'=>'12037','route_name'=>'diandi-store-store-error','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142583','updated_at'=>'1597142583']);
        $this->insert('{{%auth_route}}',['id'=>'796','name'=>'/diandi_store/store/get-region','item_id'=>'12038','route_name'=>'diandi-store-store-get-region','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142583','updated_at'=>'1597142583']);
        $this->insert('{{%auth_route}}',['id'=>'797','name'=>'/diandi_store/store/setting','item_id'=>'12039','route_name'=>'diandi-store-store-setting','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142583','updated_at'=>'1597142583']);
        $this->insert('{{%auth_route}}',['id'=>'798','name'=>'/diandi_store/store/index','item_id'=>'12040','route_name'=>'diandi-store-store-index','is_sys'=>'0','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142583','updated_at'=>'1597142583']);
        $this->insert('{{%auth_route}}',['id'=>'799','name'=>'/diandi_store/store/adds','item_id'=>'12041','route_name'=>'diandi-store-store-adds','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142583','updated_at'=>'1597142583']);
        $this->insert('{{%auth_route}}',['id'=>'800','name'=>'/diandi_store/store/view','item_id'=>'12042','route_name'=>'diandi-store-store-view','is_sys'=>'0','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142583','updated_at'=>'1597142583']);
        $this->insert('{{%auth_route}}',['id'=>'801','name'=>'/diandi_store/store/create','item_id'=>'12043','route_name'=>'diandi-store-store-create','is_sys'=>'0','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142584','updated_at'=>'1597142584']);
        $this->insert('{{%auth_route}}',['id'=>'802','name'=>'/diandi_store/store/update','item_id'=>'12044','route_name'=>'diandi-store-store-update','is_sys'=>'0','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142584','updated_at'=>'1597142584']);
        $this->insert('{{%auth_route}}',['id'=>'803','name'=>'/diandi_store/store/delete','item_id'=>'12045','route_name'=>'diandi-store-store-delete','is_sys'=>'0','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142584','updated_at'=>'1597142584']);
        $this->insert('{{%auth_route}}',['id'=>'804','name'=>'/diandi_store/store/*','item_id'=>'12046','route_name'=>'diandi-store-store','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142584','updated_at'=>'1597142584']);
        $this->insert('{{%auth_route}}',['id'=>'805','name'=>'/diandi_store/store-seat/error','item_id'=>'12047','route_name'=>'diandi-store-store-seat-error','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142584','updated_at'=>'1597142584']);
        $this->insert('{{%auth_route}}',['id'=>'806','name'=>'/diandi_store/store-seat/index','item_id'=>'12048','route_name'=>'diandi-store-store-seat-index','is_sys'=>'0','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142584','updated_at'=>'1597142584']);
        $this->insert('{{%auth_route}}',['id'=>'807','name'=>'/diandi_store/store-seat/view','item_id'=>'12049','route_name'=>'diandi-store-store-seat-view','is_sys'=>'0','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142584','updated_at'=>'1597142584']);
        $this->insert('{{%auth_route}}',['id'=>'808','name'=>'/diandi_store/store-seat/create','item_id'=>'12050','route_name'=>'diandi-store-store-seat-create','is_sys'=>'0','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142584','updated_at'=>'1597142584']);
        $this->insert('{{%auth_route}}',['id'=>'809','name'=>'/diandi_store/store-seat/update','item_id'=>'12051','route_name'=>'diandi-store-store-seat-update','is_sys'=>'0','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142584','updated_at'=>'1597142584']);
        $this->insert('{{%auth_route}}',['id'=>'810','name'=>'/diandi_store/store-seat/delete','item_id'=>'12052','route_name'=>'diandi-store-store-seat-delete','is_sys'=>'0','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142584','updated_at'=>'1597142584']);
        $this->insert('{{%auth_route}}',['id'=>'811','name'=>'/diandi_store/store-seat/*','item_id'=>'12053','route_name'=>'diandi-store-store-seat','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142584','updated_at'=>'1597142584']);
        $this->insert('{{%auth_route}}',['id'=>'812','name'=>'/diandi_store/store-service/error','item_id'=>'12054','route_name'=>'diandi-store-store-service-error','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142584','updated_at'=>'1597142584']);
        $this->insert('{{%auth_route}}',['id'=>'813','name'=>'/diandi_store/store-service/index','item_id'=>'12055','route_name'=>'diandi-store-store-service-index','is_sys'=>'0','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142584','updated_at'=>'1597142584']);
        $this->insert('{{%auth_route}}',['id'=>'814','name'=>'/diandi_store/store-service/view','item_id'=>'12056','route_name'=>'diandi-store-store-service-view','is_sys'=>'0','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142584','updated_at'=>'1597142584']);
        $this->insert('{{%auth_route}}',['id'=>'815','name'=>'/diandi_store/store-service/create','item_id'=>'12057','route_name'=>'diandi-store-store-service-create','is_sys'=>'0','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142584','updated_at'=>'1597142584']);
        $this->insert('{{%auth_route}}',['id'=>'816','name'=>'/diandi_store/store-service/update','item_id'=>'12058','route_name'=>'diandi-store-store-service-update','is_sys'=>'0','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142584','updated_at'=>'1597142584']);
        $this->insert('{{%auth_route}}',['id'=>'817','name'=>'/diandi_store/store-service/delete','item_id'=>'12059','route_name'=>'diandi-store-store-service-delete','is_sys'=>'0','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142584','updated_at'=>'1597142584']);
        $this->insert('{{%auth_route}}',['id'=>'818','name'=>'/diandi_store/store-service/*','item_id'=>'12060','route_name'=>'diandi-store-store-service','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142584','updated_at'=>'1597142584']);
        $this->insert('{{%auth_route}}',['id'=>'819','name'=>'/diandi_store/store-share/error','item_id'=>'12061','route_name'=>'diandi-store-store-share-error','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142584','updated_at'=>'1597142584']);
        $this->insert('{{%auth_route}}',['id'=>'820','name'=>'/diandi_store/store-share/index','item_id'=>'12062','route_name'=>'diandi-store-store-share-index','is_sys'=>'0','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142584','updated_at'=>'1597142584']);
        $this->insert('{{%auth_route}}',['id'=>'821','name'=>'/diandi_store/store-share/view','item_id'=>'12063','route_name'=>'diandi-store-store-share-view','is_sys'=>'0','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142584','updated_at'=>'1597142584']);
        $this->insert('{{%auth_route}}',['id'=>'822','name'=>'/diandi_store/store-share/create','item_id'=>'12064','route_name'=>'diandi-store-store-share-create','is_sys'=>'0','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142584','updated_at'=>'1597142584']);
        $this->insert('{{%auth_route}}',['id'=>'823','name'=>'/diandi_store/store-share/update','item_id'=>'12065','route_name'=>'diandi-store-store-share-update','is_sys'=>'0','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142584','updated_at'=>'1597142584']);
        $this->insert('{{%auth_route}}',['id'=>'824','name'=>'/diandi_store/store-share/delete','item_id'=>'12066','route_name'=>'diandi-store-store-share-delete','is_sys'=>'0','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142585','updated_at'=>'1597142585']);
        $this->insert('{{%auth_route}}',['id'=>'825','name'=>'/diandi_store/store-share/*','item_id'=>'12067','route_name'=>'diandi-store-store-share','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142585','updated_at'=>'1597142585']);
        $this->insert('{{%auth_route}}',['id'=>'826','name'=>'/diandi_store/store-slide/error','item_id'=>'12068','route_name'=>'diandi-store-store-slide-error','is_sys'=>'0','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142585','updated_at'=>'1597142585']);
        $this->insert('{{%auth_route}}',['id'=>'827','name'=>'/diandi_store/store-slide/index','item_id'=>'12069','route_name'=>'diandi-store-store-slide-index','is_sys'=>'0','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142585','updated_at'=>'1597142585']);
        $this->insert('{{%auth_route}}',['id'=>'828','name'=>'/diandi_store/store-slide/view','item_id'=>'12070','route_name'=>'diandi-store-store-slide-view','is_sys'=>'0','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142585','updated_at'=>'1597142585']);
        $this->insert('{{%auth_route}}',['id'=>'829','name'=>'/diandi_store/store-slide/create','item_id'=>'12071','route_name'=>'diandi-store-store-slide-create','is_sys'=>'0','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142585','updated_at'=>'1597142585']);
        $this->insert('{{%auth_route}}',['id'=>'830','name'=>'/diandi_store/store-slide/update','item_id'=>'12072','route_name'=>'diandi-store-store-slide-update','is_sys'=>'0','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142585','updated_at'=>'1597142585']);
        $this->insert('{{%auth_route}}',['id'=>'831','name'=>'/diandi_store/store-slide/delete','item_id'=>'12073','route_name'=>'diandi-store-store-slide-delete','is_sys'=>'0','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142585','updated_at'=>'1597142585']);
        $this->insert('{{%auth_route}}',['id'=>'832','name'=>'/diandi_store/store-slide/*','item_id'=>'12074','route_name'=>'diandi-store-store-slide','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1597142585','updated_at'=>'1597142585']);
        $this->insert('{{%auth_route}}',['id'=>'1068','name'=>'/member/dd-member/cac-vs','item_id'=>'12140','route_name'=>'member-dd-member-cac-vs','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1600478586','updated_at'=>'1600478586']);
        $this->insert('{{%auth_route}}',['id'=>'1069','name'=>'/system/settings/wechat','item_id'=>'12141','route_name'=>'system-settings-wechat','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1600478587','updated_at'=>'1600478587']);
        $this->insert('{{%auth_route}}',['id'=>'1210','name'=>'/admin/category/error','item_id'=>'12164','route_name'=>'admin-category-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1605723025','updated_at'=>'1605723025']);
        $this->insert('{{%auth_route}}',['id'=>'1211','name'=>'/admin/category/index','item_id'=>'12165','route_name'=>'admin-category-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1605723025','updated_at'=>'1605723025']);
        $this->insert('{{%auth_route}}',['id'=>'1212','name'=>'/admin/category/view','item_id'=>'12166','route_name'=>'admin-category-view','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1605723025','updated_at'=>'1605723025']);
        $this->insert('{{%auth_route}}',['id'=>'1213','name'=>'/admin/category/create','item_id'=>'12167','route_name'=>'admin-category-create','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1605723025','updated_at'=>'1605723025']);
        $this->insert('{{%auth_route}}',['id'=>'1214','name'=>'/admin/category/update','item_id'=>'12168','route_name'=>'admin-category-update','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1605723025','updated_at'=>'1605723025']);
        $this->insert('{{%auth_route}}',['id'=>'1215','name'=>'/admin/category/delete','item_id'=>'12169','route_name'=>'admin-category-delete','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1605723025','updated_at'=>'1605723025']);
        $this->insert('{{%auth_route}}',['id'=>'1216','name'=>'/admin/category/*','item_id'=>'12170','route_name'=>'admin-category','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1605723025','updated_at'=>'1605723025']);
        $this->insert('{{%auth_route}}',['id'=>'1217','name'=>'/admin/store/childcate','item_id'=>'12171','route_name'=>'admin-store-childcate','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1605723025','updated_at'=>'1605723025']);
        $this->insert('{{%auth_route}}',['id'=>'1366','name'=>'/addons/menu/update-files','item_id'=>'12184','route_name'=>'addons-menu-update-files','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610731582','updated_at'=>'1610731582']);
        $this->insert('{{%auth_route}}',['id'=>'1477','name'=>'/member/account/error','item_id'=>'12185','route_name'=>'member-account-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610731583','updated_at'=>'1610731583']);
        $this->insert('{{%auth_route}}',['id'=>'1478','name'=>'/member/account/index','item_id'=>'12186','route_name'=>'member-account-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610731583','updated_at'=>'1610731583']);
        $this->insert('{{%auth_route}}',['id'=>'1479','name'=>'/member/account/view','item_id'=>'12187','route_name'=>'member-account-view','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610731583','updated_at'=>'1610731583']);
        $this->insert('{{%auth_route}}',['id'=>'1480','name'=>'/member/account/create','item_id'=>'12188','route_name'=>'member-account-create','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610731583','updated_at'=>'1610731583']);
        $this->insert('{{%auth_route}}',['id'=>'1481','name'=>'/member/account/update','item_id'=>'12189','route_name'=>'member-account-update','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610731583','updated_at'=>'1610731583']);
        $this->insert('{{%auth_route}}',['id'=>'1482','name'=>'/member/account/delete','item_id'=>'12190','route_name'=>'member-account-delete','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610731583','updated_at'=>'1610731583']);
        $this->insert('{{%auth_route}}',['id'=>'1483','name'=>'/member/account/*','item_id'=>'12191','route_name'=>'member-account','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610731583','updated_at'=>'1610731583']);
        $this->insert('{{%auth_route}}',['id'=>'1484','name'=>'/member/dd-member/repassword','item_id'=>'12192','route_name'=>'member-dd-member-repassword','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610731583','updated_at'=>'1610731583']);
        $this->insert('{{%auth_route}}',['id'=>'1510','name'=>'/addons/baidu/error','item_id'=>'12193','route_name'=>'addons-baidu-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812024','updated_at'=>'1610812024']);
        $this->insert('{{%auth_route}}',['id'=>'1511','name'=>'/addons/baidu/index','item_id'=>'12194','route_name'=>'addons-baidu-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812024','updated_at'=>'1610812024']);
        $this->insert('{{%auth_route}}',['id'=>'1512','name'=>'/addons/baidu/view','item_id'=>'12195','route_name'=>'addons-baidu-view','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1513','name'=>'/addons/baidu/create','item_id'=>'12196','route_name'=>'addons-baidu-create','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1514','name'=>'/addons/baidu/update','item_id'=>'12197','route_name'=>'addons-baidu-update','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1515','name'=>'/addons/baidu/delete','item_id'=>'12198','route_name'=>'addons-baidu-delete','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1516','name'=>'/addons/baidu/*','item_id'=>'12199','route_name'=>'addons-baidu','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1517','name'=>'/addons/bloc/change-username','item_id'=>'12200','route_name'=>'addons-bloc-change-username','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1518','name'=>'/addons/bloc/index','item_id'=>'12201','route_name'=>'addons-bloc-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>'公司管理','pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1519','name'=>'/addons/bloc/view','item_id'=>'12202','route_name'=>'addons-bloc-view','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1520','name'=>'/addons/bloc/create','item_id'=>'12203','route_name'=>'addons-bloc-create','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1521','name'=>'/addons/bloc/update','item_id'=>'12204','route_name'=>'addons-bloc-update','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1522','name'=>'/addons/bloc/delete','item_id'=>'12205','route_name'=>'addons-bloc-delete','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1523','name'=>'/addons/bloc/*','item_id'=>'12206','route_name'=>'addons-bloc','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1524','name'=>'/addons/category/error','item_id'=>'12207','route_name'=>'addons-category-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1525','name'=>'/addons/category/index','item_id'=>'12208','route_name'=>'addons-category-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1526','name'=>'/addons/category/view','item_id'=>'12209','route_name'=>'addons-category-view','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1527','name'=>'/addons/category/create','item_id'=>'12210','route_name'=>'addons-category-create','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1528','name'=>'/addons/category/update','item_id'=>'12211','route_name'=>'addons-category-update','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1529','name'=>'/addons/category/delete','item_id'=>'12212','route_name'=>'addons-category-delete','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1530','name'=>'/addons/category/*','item_id'=>'12213','route_name'=>'addons-category','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1531','name'=>'/addons/email/error','item_id'=>'12214','route_name'=>'addons-email-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1532','name'=>'/addons/email/index','item_id'=>'12215','route_name'=>'addons-email-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1533','name'=>'/addons/email/view','item_id'=>'12216','route_name'=>'addons-email-view','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1534','name'=>'/addons/email/create','item_id'=>'12217','route_name'=>'addons-email-create','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1535','name'=>'/addons/email/update','item_id'=>'12218','route_name'=>'addons-email-update','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1536','name'=>'/addons/email/delete','item_id'=>'12219','route_name'=>'addons-email-delete','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1537','name'=>'/addons/email/*','item_id'=>'12220','route_name'=>'addons-email','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1538','name'=>'/addons/setting/*','item_id'=>'12221','route_name'=>'addons-setting','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1539','name'=>'/addons/sms/error','item_id'=>'12222','route_name'=>'addons-sms-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1540','name'=>'/addons/sms/index','item_id'=>'12223','route_name'=>'addons-sms-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1541','name'=>'/addons/sms/view','item_id'=>'12224','route_name'=>'addons-sms-view','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1542','name'=>'/addons/sms/create','item_id'=>'12225','route_name'=>'addons-sms-create','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1543','name'=>'/addons/sms/update','item_id'=>'12226','route_name'=>'addons-sms-update','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1544','name'=>'/addons/sms/delete','item_id'=>'12227','route_name'=>'addons-sms-delete','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1545','name'=>'/addons/sms/*','item_id'=>'12228','route_name'=>'addons-sms','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1546','name'=>'/addons/user-bloc/*','item_id'=>'12229','route_name'=>'addons-user-bloc','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1547','name'=>'/addons/store/error','item_id'=>'12230','route_name'=>'addons-store-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1548','name'=>'/addons/store/get-region','item_id'=>'12231','route_name'=>'addons-store-get-region','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1549','name'=>'/addons/store/index','item_id'=>'12232','route_name'=>'addons-store-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>'商户','pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1550','name'=>'/addons/store/childcate','item_id'=>'12233','route_name'=>'addons-store-childcate','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1551','name'=>'/addons/store/view','item_id'=>'12234','route_name'=>'addons-store-view','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1552','name'=>'/addons/store/create','item_id'=>'12235','route_name'=>'addons-store-create','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1553','name'=>'/addons/store/update','item_id'=>'12236','route_name'=>'addons-store-update','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1554','name'=>'/addons/store/delete','item_id'=>'12237','route_name'=>'addons-store-delete','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1555','name'=>'/addons/store/*','item_id'=>'12238','route_name'=>'addons-store','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1556','name'=>'/addons/storelabel/error','item_id'=>'12239','route_name'=>'addons-storelabel-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1557','name'=>'/addons/storelabel/index','item_id'=>'12240','route_name'=>'addons-storelabel-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1558','name'=>'/addons/storelabel/view','item_id'=>'12241','route_name'=>'addons-storelabel-view','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1559','name'=>'/addons/storelabel/create','item_id'=>'12242','route_name'=>'addons-storelabel-create','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1560','name'=>'/addons/storelabel/update','item_id'=>'12243','route_name'=>'addons-storelabel-update','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1561','name'=>'/addons/storelabel/delete','item_id'=>'12244','route_name'=>'addons-storelabel-delete','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1562','name'=>'/addons/storelabel/*','item_id'=>'12245','route_name'=>'addons-storelabel','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1563','name'=>'/addons/storelabellink/error','item_id'=>'12246','route_name'=>'addons-storelabellink-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1564','name'=>'/addons/storelabellink/index','item_id'=>'12247','route_name'=>'addons-storelabellink-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1565','name'=>'/addons/storelabellink/view','item_id'=>'12248','route_name'=>'addons-storelabellink-view','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1566','name'=>'/addons/storelabellink/create','item_id'=>'12249','route_name'=>'addons-storelabellink-create','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1567','name'=>'/addons/storelabellink/update','item_id'=>'12250','route_name'=>'addons-storelabellink-update','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1568','name'=>'/addons/storelabellink/delete','item_id'=>'12251','route_name'=>'addons-storelabellink-delete','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1569','name'=>'/addons/storelabellink/*','item_id'=>'12252','route_name'=>'addons-storelabellink','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1570','name'=>'/addons/wechatpay/error','item_id'=>'12253','route_name'=>'addons-wechatpay-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1571','name'=>'/addons/wechatpay/index','item_id'=>'12254','route_name'=>'addons-wechatpay-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1572','name'=>'/addons/wechatpay/view','item_id'=>'12255','route_name'=>'addons-wechatpay-view','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1573','name'=>'/addons/wechatpay/create','item_id'=>'12256','route_name'=>'addons-wechatpay-create','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1574','name'=>'/addons/wechatpay/update','item_id'=>'12257','route_name'=>'addons-wechatpay-update','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1575','name'=>'/addons/wechatpay/delete','item_id'=>'12258','route_name'=>'addons-wechatpay-delete','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1576','name'=>'/addons/wechatpay/*','item_id'=>'12259','route_name'=>'addons-wechatpay','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1577','name'=>'/addons/wxapp/error','item_id'=>'12260','route_name'=>'addons-wxapp-error','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1578','name'=>'/addons/wxapp/index','item_id'=>'12261','route_name'=>'addons-wxapp-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1579','name'=>'/addons/wxapp/view','item_id'=>'12262','route_name'=>'addons-wxapp-view','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1580','name'=>'/addons/wxapp/create','item_id'=>'12263','route_name'=>'addons-wxapp-create','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1581','name'=>'/addons/wxapp/update','item_id'=>'12264','route_name'=>'addons-wxapp-update','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1582','name'=>'/addons/wxapp/delete','item_id'=>'12265','route_name'=>'addons-wxapp-delete','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1583','name'=>'/addons/wxapp/*','item_id'=>'12266','route_name'=>'addons-wxapp','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1706','name'=>'/member/dd-member/groups','item_id'=>'12355','route_name'=>'member-dd-member-groups','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1614044208','updated_at'=>'1614044208']);
        $this->insert('{{%auth_route}}',['id'=>'1707','name'=>'/system/settings/store','item_id'=>'12356','route_name'=>'system-settings-store','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1614044208','updated_at'=>'1614044208']);
        $this->insert('{{%auth_route}}',['id'=>'1712','name'=>'/settings/*','item_id'=>'12357','route_name'=>'settings','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1614422647','updated_at'=>'1614422647']);
        $this->insert('{{%auth_route}}',['id'=>'1717','name'=>'/system/index/info','item_id'=>'12362','route_name'=>'system-index-info','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1614572261','updated_at'=>'1614572261']);
        $this->insert('{{%auth_route}}',['id'=>'1718','name'=>'/system/settings/them','item_id'=>'12363','route_name'=>'system-settings-them','is_sys'=>'1','route_type'=>'3','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1614572261','updated_at'=>'1614572261']);
        $this->insert('{{%auth_route}}',['id'=>'2890','name'=>'/addons/bloclevel/error','item_id'=>'13080','route_name'=>'addons-bloclevel-error','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1622713570','updated_at'=>'1622713570']);
        $this->insert('{{%auth_route}}',['id'=>'2891','name'=>'/addons/bloclevel/index','item_id'=>'13081','route_name'=>'addons-bloclevel-index','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1622713570','updated_at'=>'1622713570']);
        $this->insert('{{%auth_route}}',['id'=>'2892','name'=>'/addons/bloclevel/view','item_id'=>'13082','route_name'=>'addons-bloclevel-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1622713570','updated_at'=>'1622713570']);
        $this->insert('{{%auth_route}}',['id'=>'2893','name'=>'/addons/bloclevel/create','item_id'=>'13083','route_name'=>'addons-bloclevel-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1622713570','updated_at'=>'1622713570']);
        $this->insert('{{%auth_route}}',['id'=>'2894','name'=>'/addons/bloclevel/update','item_id'=>'13084','route_name'=>'addons-bloclevel-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1622713570','updated_at'=>'1622713570']);
        $this->insert('{{%auth_route}}',['id'=>'2895','name'=>'/addons/bloclevel/delete','item_id'=>'13085','route_name'=>'addons-bloclevel-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1622713570','updated_at'=>'1622713570']);
        $this->insert('{{%auth_route}}',['id'=>'2896','name'=>'/addons/bloclevel/*','item_id'=>'13086','route_name'=>'addons-bloclevel','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1622713570','updated_at'=>'1622713570']);
        $this->insert('{{%auth_route}}',['id'=>'3073','name'=>'/addons/addonsstore/error','item_id'=>'13239','route_name'=>'addons-addonsstore-error','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1631240717','updated_at'=>'1631240717']);
        $this->insert('{{%auth_route}}',['id'=>'3074','name'=>'/addons/addonsstore/index','item_id'=>'13240','route_name'=>'addons-addonsstore-index','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1631240717','updated_at'=>'1631240717']);
        $this->insert('{{%auth_route}}',['id'=>'3075','name'=>'/addons/addonsstore/view','item_id'=>'13241','route_name'=>'addons-addonsstore-view','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1631240717','updated_at'=>'1631240717']);
        $this->insert('{{%auth_route}}',['id'=>'3076','name'=>'/addons/addonsstore/create','item_id'=>'13242','route_name'=>'addons-addonsstore-create','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1631240717','updated_at'=>'1631240717']);
        $this->insert('{{%auth_route}}',['id'=>'3077','name'=>'/addons/addonsstore/update','item_id'=>'13243','route_name'=>'addons-addonsstore-update','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1631240717','updated_at'=>'1631240717']);
        $this->insert('{{%auth_route}}',['id'=>'3078','name'=>'/addons/addonsstore/delete','item_id'=>'13244','route_name'=>'addons-addonsstore-delete','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1631240717','updated_at'=>'1631240717']);
        $this->insert('{{%auth_route}}',['id'=>'3079','name'=>'/addons/addonsstore/*','item_id'=>'13245','route_name'=>'addons-addonsstore','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1631240717','updated_at'=>'1631240717']);
        $this->insert('{{%auth_route}}',['id'=>'3089','name'=>'/addons/bloc/bloc/index','item_id'=>'13254','route_name'=>'addons-bloc-bloc-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>'公司管理','pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_route}}',['id'=>'3091','name'=>'/addons/bloc/list','item_id'=>'13255','route_name'=>'addons-bloc-list','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>'公司管理list','pid'=>'1523','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_route}}',['id'=>'3092','name'=>'/addons/bloc/bloclevel/index','item_id'=>'13256','route_name'=>'addons-bloc-bloclevel-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>'公司等级','pid'=>'1523','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_route}}',['id'=>'3093','name'=>'/addons/bloc/list/index','item_id'=>'13257','route_name'=>'addons-bloc-list-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>'公司管理','pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_route}}',['id'=>'3094','name'=>'/addons/bloc/blocset/index','item_id'=>'13258','route_name'=>'addons-bloc-blocset-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>'公司配置','pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_route}}',['id'=>'3095','name'=>'/addons/store/list/index','item_id'=>'13259','route_name'=>'addons-store-list-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>'商户管理','pid'=>'1555','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_route}}',['id'=>'3096','name'=>'/addons/store/category/index','item_id'=>'13260','route_name'=>'addons-store-category-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>'商户分类','pid'=>'1555','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_route}}',['id'=>'3097','name'=>'/addons/store/storelabel/index','item_id'=>'13261','route_name'=>'addons-store-storelabel-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>'商户标签','pid'=>'1555','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_route}}',['id'=>'3098','name'=>'/dashboard','item_id'=>'13262','route_name'=>'dashboard','is_sys'=>'1','route_type'=>'0','description'=>'','title'=>'工作台','pid'=>'138','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_route}}',['id'=>'3099','name'=>'/documentation/index','item_id'=>'13263','route_name'=>'documentation-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>'开发文档','pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_route}}',['id'=>'3100','name'=>'/admin/route/init','item_id'=>'13264','route_name'=>'admin-route-init','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>'系统路由','pid'=>'81','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_route}}',['id'=>'3289','name'=>'/ceshi/options','item_id'=>'13343','route_name'=>'ceshi-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3290','name'=>'/ceshi/swgdoc','item_id'=>'13344','route_name'=>'ceshi-swgdoc','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3291','name'=>'/ceshi/index','item_id'=>'13345','route_name'=>'ceshi-index','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3292','name'=>'/ceshi/create','item_id'=>'13346','route_name'=>'ceshi-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3293','name'=>'/ceshi/update','item_id'=>'13347','route_name'=>'ceshi-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3294','name'=>'/ceshi/delete','item_id'=>'13348','route_name'=>'ceshi-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3295','name'=>'/ceshi/view','item_id'=>'13349','route_name'=>'ceshi-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3296','name'=>'/ceshi/*','item_id'=>'13350','route_name'=>'ceshi','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3297','name'=>'/map/options','item_id'=>'13351','route_name'=>'map-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3298','name'=>'/map/distance','item_id'=>'13352','route_name'=>'map-distance','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3299','name'=>'/map/citylist','item_id'=>'13353','route_name'=>'map-citylist','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3300','name'=>'/map/index','item_id'=>'13354','route_name'=>'map-index','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3301','name'=>'/map/create','item_id'=>'13355','route_name'=>'map-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3302','name'=>'/map/update','item_id'=>'13356','route_name'=>'map-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3303','name'=>'/map/delete','item_id'=>'13357','route_name'=>'map-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3304','name'=>'/map/view','item_id'=>'13358','route_name'=>'map-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3305','name'=>'/map/*','item_id'=>'13359','route_name'=>'map','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3306','name'=>'/site/options','item_id'=>'13360','route_name'=>'site-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3307','name'=>'/site/create','item_id'=>'13361','route_name'=>'site-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3308','name'=>'/site/update','item_id'=>'13362','route_name'=>'site-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3309','name'=>'/site/delete','item_id'=>'13363','route_name'=>'site-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3310','name'=>'/site/view','item_id'=>'13364','route_name'=>'site-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3311','name'=>'/store/options','item_id'=>'13365','route_name'=>'store-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3312','name'=>'/store/info','item_id'=>'13366','route_name'=>'store-info','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3313','name'=>'/store/detailinfo','item_id'=>'13367','route_name'=>'store-detailinfo','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3314','name'=>'/store/cate','item_id'=>'13368','route_name'=>'store-cate','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3315','name'=>'/store/list','item_id'=>'13369','route_name'=>'store-list','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3316','name'=>'/store/blocs','item_id'=>'13370','route_name'=>'store-blocs','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3317','name'=>'/store/index','item_id'=>'13371','route_name'=>'store-index','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3318','name'=>'/store/create','item_id'=>'13372','route_name'=>'store-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3319','name'=>'/store/update','item_id'=>'13373','route_name'=>'store-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3320','name'=>'/store/delete','item_id'=>'13374','route_name'=>'store-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3321','name'=>'/store/view','item_id'=>'13375','route_name'=>'store-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3322','name'=>'/store/*','item_id'=>'13376','route_name'=>'store','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3323','name'=>'/upload/options','item_id'=>'13377','route_name'=>'upload-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3324','name'=>'/upload/images','item_id'=>'13378','route_name'=>'upload-images','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3325','name'=>'/upload/index','item_id'=>'13379','route_name'=>'upload-index','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3326','name'=>'/upload/create','item_id'=>'13380','route_name'=>'upload-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3327','name'=>'/upload/update','item_id'=>'13381','route_name'=>'upload-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3328','name'=>'/upload/delete','item_id'=>'13382','route_name'=>'upload-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3329','name'=>'/upload/view','item_id'=>'13383','route_name'=>'upload-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3330','name'=>'/upload/*','item_id'=>'13384','route_name'=>'upload','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3331','name'=>'/user/options','item_id'=>'13385','route_name'=>'user-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3332','name'=>'/user/signup','item_id'=>'13386','route_name'=>'user-signup','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3333','name'=>'/user/login','item_id'=>'13387','route_name'=>'user-login','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3334','name'=>'/user/repassword','item_id'=>'13388','route_name'=>'user-repassword','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3335','name'=>'/user/userinfo','item_id'=>'13389','route_name'=>'user-userinfo','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3336','name'=>'/user/bindmobile','item_id'=>'13390','route_name'=>'user-bindmobile','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3337','name'=>'/user/edituserinfo','item_id'=>'13391','route_name'=>'user-edituserinfo','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3338','name'=>'/user/forgetpass','item_id'=>'13392','route_name'=>'user-forgetpass','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3339','name'=>'/user/sendcode','item_id'=>'13393','route_name'=>'user-sendcode','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3340','name'=>'/user/refresh','item_id'=>'13394','route_name'=>'user-refresh','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3341','name'=>'/user/feedback','item_id'=>'13395','route_name'=>'user-feedback','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3342','name'=>'/user/index','item_id'=>'13396','route_name'=>'user-index','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3343','name'=>'/user/create','item_id'=>'13397','route_name'=>'user-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3344','name'=>'/user/update','item_id'=>'13398','route_name'=>'user-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3345','name'=>'/user/delete','item_id'=>'13399','route_name'=>'user-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3346','name'=>'/user/view','item_id'=>'13400','route_name'=>'user-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3347','name'=>'/user/*','item_id'=>'13401','route_name'=>'user','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3348','name'=>'/addons/addons/options','item_id'=>'13402','route_name'=>'addons-addons-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3349','name'=>'/addons/addons/list','item_id'=>'13403','route_name'=>'addons-addons-list','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3350','name'=>'/article/dd-article/ceshi','item_id'=>'13404','route_name'=>'article-dd-article-ceshi','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3351','name'=>'/auth/assignment/options','item_id'=>'13405','route_name'=>'auth-assignment-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3352','name'=>'/auth/assignment/index','item_id'=>'13406','route_name'=>'auth-assignment-index','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3353','name'=>'/auth/assignment/view','item_id'=>'13407','route_name'=>'auth-assignment-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3354','name'=>'/auth/assignment/assign','item_id'=>'13408','route_name'=>'auth-assignment-assign','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3355','name'=>'/auth/assignment/revoke','item_id'=>'13409','route_name'=>'auth-assignment-revoke','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3356','name'=>'/auth/assignment/create','item_id'=>'13410','route_name'=>'auth-assignment-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3357','name'=>'/auth/assignment/update','item_id'=>'13411','route_name'=>'auth-assignment-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3358','name'=>'/auth/assignment/delete','item_id'=>'13412','route_name'=>'auth-assignment-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3359','name'=>'/auth/assignment/*','item_id'=>'13413','route_name'=>'auth-assignment','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3360','name'=>'/auth/category/options','item_id'=>'13414','route_name'=>'auth-category-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3361','name'=>'/auth/category/index','item_id'=>'13415','route_name'=>'auth-category-index','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3362','name'=>'/auth/category/view','item_id'=>'13416','route_name'=>'auth-category-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3363','name'=>'/auth/category/create','item_id'=>'13417','route_name'=>'auth-category-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3364','name'=>'/auth/category/update','item_id'=>'13418','route_name'=>'auth-category-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3365','name'=>'/auth/category/delete','item_id'=>'13419','route_name'=>'auth-category-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3366','name'=>'/auth/category/*','item_id'=>'13420','route_name'=>'auth-category','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3367','name'=>'/auth/default/error','item_id'=>'13421','route_name'=>'auth-default-error','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3368','name'=>'/auth/default/index','item_id'=>'13422','route_name'=>'auth-default-index','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3369','name'=>'/auth/default/*','item_id'=>'13423','route_name'=>'auth-default','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3370','name'=>'/auth/group/*','item_id'=>'13424','route_name'=>'auth-group','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3371','name'=>'/auth/menu/options','item_id'=>'13425','route_name'=>'auth-menu-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3372','name'=>'/auth/menu/index','item_id'=>'13426','route_name'=>'auth-menu-index','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3373','name'=>'/auth/menu/view','item_id'=>'13427','route_name'=>'auth-menu-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3374','name'=>'/auth/menu/create','item_id'=>'13428','route_name'=>'auth-menu-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3375','name'=>'/auth/menu/levels','item_id'=>'13429','route_name'=>'auth-menu-levels','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3376','name'=>'/auth/menu/route','item_id'=>'13430','route_name'=>'auth-menu-route','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3377','name'=>'/auth/menu/update','item_id'=>'13431','route_name'=>'auth-menu-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3378','name'=>'/auth/menu/update-files','item_id'=>'13432','route_name'=>'auth-menu-update-files','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302790','updated_at'=>'1632302790']);
        $this->insert('{{%auth_route}}',['id'=>'3379','name'=>'/auth/menu/delete','item_id'=>'13433','route_name'=>'auth-menu-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3380','name'=>'/auth/menu/*','item_id'=>'13434','route_name'=>'auth-menu','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3381','name'=>'/auth/menu-top/options','item_id'=>'13435','route_name'=>'auth-menu-top-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3382','name'=>'/auth/menu-top/index','item_id'=>'13436','route_name'=>'auth-menu-top-index','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3383','name'=>'/auth/menu-top/view','item_id'=>'13437','route_name'=>'auth-menu-top-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3384','name'=>'/auth/menu-top/create','item_id'=>'13438','route_name'=>'auth-menu-top-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3385','name'=>'/auth/menu-top/update','item_id'=>'13439','route_name'=>'auth-menu-top-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3386','name'=>'/auth/menu-top/delete','item_id'=>'13440','route_name'=>'auth-menu-top-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3387','name'=>'/auth/menu-top/*','item_id'=>'13441','route_name'=>'auth-menu-top','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3388','name'=>'/auth/permission/*','item_id'=>'13442','route_name'=>'auth-permission','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3389','name'=>'/auth/role/options','item_id'=>'13443','route_name'=>'auth-role-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3390','name'=>'/auth/role/index','item_id'=>'13444','route_name'=>'auth-role-index','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3391','name'=>'/auth/role/create','item_id'=>'13445','route_name'=>'auth-role-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3392','name'=>'/auth/role/update','item_id'=>'13446','route_name'=>'auth-role-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3393','name'=>'/auth/role/delete','item_id'=>'13447','route_name'=>'auth-role-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3394','name'=>'/auth/role/view','item_id'=>'13448','route_name'=>'auth-role-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3395','name'=>'/auth/role/*','item_id'=>'13449','route_name'=>'auth-role','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3396','name'=>'/auth/route/options','item_id'=>'13450','route_name'=>'auth-route-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3397','name'=>'/auth/route/index','item_id'=>'13451','route_name'=>'auth-route-index','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3398','name'=>'/auth/route/available','item_id'=>'13452','route_name'=>'auth-route-available','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3399','name'=>'/auth/route/view','item_id'=>'13453','route_name'=>'auth-route-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3400','name'=>'/auth/route/create','item_id'=>'13454','route_name'=>'auth-route-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3401','name'=>'/auth/route/update','item_id'=>'13455','route_name'=>'auth-route-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3402','name'=>'/auth/route/delete','item_id'=>'13456','route_name'=>'auth-route-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3403','name'=>'/auth/route/assign','item_id'=>'13457','route_name'=>'auth-route-assign','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3404','name'=>'/auth/route/remove','item_id'=>'13458','route_name'=>'auth-route-remove','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3405','name'=>'/auth/route/refresh','item_id'=>'13459','route_name'=>'auth-route-refresh','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3406','name'=>'/auth/route/*','item_id'=>'13460','route_name'=>'auth-route','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3407','name'=>'/auth/rule/options','item_id'=>'13461','route_name'=>'auth-rule-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3408','name'=>'/auth/rule/index','item_id'=>'13462','route_name'=>'auth-rule-index','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3409','name'=>'/auth/rule/view','item_id'=>'13463','route_name'=>'auth-rule-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3410','name'=>'/auth/rule/create','item_id'=>'13464','route_name'=>'auth-rule-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3411','name'=>'/auth/rule/update','item_id'=>'13465','route_name'=>'auth-rule-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3412','name'=>'/auth/rule/delete','item_id'=>'13466','route_name'=>'auth-rule-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3413','name'=>'/auth/rule/*','item_id'=>'13467','route_name'=>'auth-rule','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3414','name'=>'/auth/user/*','item_id'=>'13468','route_name'=>'auth-user','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3415','name'=>'/website/dd-website-slide/options','item_id'=>'13469','route_name'=>'website-dd-website-slide-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3416','name'=>'/website/dd-website-slide/updateitem','item_id'=>'13470','route_name'=>'website-dd-website-slide-updateitem','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3417','name'=>'/website/dd-website-slide/deleteitem','item_id'=>'13471','route_name'=>'website-dd-website-slide-deleteitem','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1632302791','updated_at'=>'1632302791']);
        $this->insert('{{%auth_route}}',['id'=>'3440','name'=>'/example/index.vue','item_id'=>'13494','route_name'=>'example-index','is_sys'=>'1','route_type'=>'1','description'=>'','title'=>'开发示例','pid'=>'0','data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_route}}',['id'=>'3441','name'=>'/example/base-page/edit.vue','item_id'=>'13495','route_name'=>'example-base-page-edit','is_sys'=>'1','route_type'=>'2','description'=>'','title'=>'编辑示例','pid'=>NULL,'data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_route}}',['id'=>'3449','name'=>'/article/dd-article/dd-article-add.vue','item_id'=>'13502','route_name'=>'dd-article-add','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>'系统文章新增','pid'=>NULL,'data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_route}}',['id'=>'3450','name'=>'/addons/bloc/list/bloc-view.vue','item_id'=>'13503','route_name'=>'bloc-view','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>'公司详情','pid'=>NULL,'data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_route}}',['id'=>'3451','name'=>'/article/dd-article','item_id'=>'13504','route_name'=>'dd-article','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>'文章管理','pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_route}}',['id'=>'3452','name'=>'/article/dd-article/article-edit.vue','item_id'=>'13505','route_name'=>'dd-article-edit','is_sys'=>'1','route_type'=>'2','description'=>NULL,'title'=>'文章编辑','pid'=>NULL,'data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_route}}',['id'=>'3453','name'=>'/main/index.vue','item_id'=>'13506','route_name'=>'main-index','is_sys'=>'1','route_type'=>'0','description'=>'','title'=>'main入口','pid'=>NULL,'data'=>'','module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_route}}',['id'=>'3462','name'=>'/member/dd-member/member-organization.vue','item_id'=>'13515','route_name'=>'member-organization','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>'组织架构','pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_route}}',['id'=>'3481','name'=>'/system/settings/index.vue','item_id'=>'13533','route_name'=>'system-settings-index','is_sys'=>'1','route_type'=>'1','description'=>NULL,'title'=>'系统配置','pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_route}}',['id'=>'3517','name'=>'/addons/store/welcome/index.vue','item_id'=>'13564','route_name'=>'addons-store-welcome-index','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>'初始商户','pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_route}}',['id'=>'3787','name'=>'/a/options','item_id'=>'13834','route_name'=>'a-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378346','updated_at'=>'1644378346']);
        $this->insert('{{%auth_route}}',['id'=>'3788','name'=>'/a/index','item_id'=>'13835','route_name'=>'a-index','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378346','updated_at'=>'1644378346']);
        $this->insert('{{%auth_route}}',['id'=>'3789','name'=>'/a/create','item_id'=>'13836','route_name'=>'a-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378346','updated_at'=>'1644378346']);
        $this->insert('{{%auth_route}}',['id'=>'3790','name'=>'/a/update','item_id'=>'13837','route_name'=>'a-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378346','updated_at'=>'1644378346']);
        $this->insert('{{%auth_route}}',['id'=>'3791','name'=>'/a/delete','item_id'=>'13838','route_name'=>'a-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378346','updated_at'=>'1644378346']);
        $this->insert('{{%auth_route}}',['id'=>'3792','name'=>'/a/view','item_id'=>'13839','route_name'=>'a-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378346','updated_at'=>'1644378346']);
        $this->insert('{{%auth_route}}',['id'=>'3793','name'=>'/a/*','item_id'=>'13840','route_name'=>'a-*','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378346','updated_at'=>'1644378346']);
        $this->insert('{{%auth_route}}',['id'=>'3794','name'=>'/module/options','item_id'=>'13841','route_name'=>'module-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378346','updated_at'=>'1644378346']);
        $this->insert('{{%auth_route}}',['id'=>'3795','name'=>'/module/create','item_id'=>'13842','route_name'=>'module-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378346','updated_at'=>'1644378346']);
        $this->insert('{{%auth_route}}',['id'=>'3796','name'=>'/module/update','item_id'=>'13843','route_name'=>'module-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378346','updated_at'=>'1644378346']);
        $this->insert('{{%auth_route}}',['id'=>'3797','name'=>'/module/delete','item_id'=>'13844','route_name'=>'module-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378346','updated_at'=>'1644378346']);
        $this->insert('{{%auth_route}}',['id'=>'3798','name'=>'/module/view','item_id'=>'13845','route_name'=>'module-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3799','name'=>'/store/detail','item_id'=>'13846','route_name'=>'store-detail','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3800','name'=>'/user/userlist','item_id'=>'13847','route_name'=>'user-userlist','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3801','name'=>'/user/addons','item_id'=>'13848','route_name'=>'user-addons','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3802','name'=>'/addons/baidu/options','item_id'=>'13849','route_name'=>'addons-baidu-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3803','name'=>'/addons/bloc/options','item_id'=>'13850','route_name'=>'addons-bloc-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3804','name'=>'/addons/bloc/store-group','item_id'=>'13851','route_name'=>'addons-bloc-store-group','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3805','name'=>'/addons/bloc/parentbloc','item_id'=>'13852','route_name'=>'addons-bloc-parentbloc','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3806','name'=>'/addons/bloc/childbloc','item_id'=>'13853','route_name'=>'addons-bloc-childbloc','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3807','name'=>'/addons/bloc/stores','item_id'=>'13854','route_name'=>'addons-bloc-stores','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3808','name'=>'/addons/bloc/reglevel','item_id'=>'13855','route_name'=>'addons-bloc-reglevel','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3809','name'=>'/addons/bloc/blocstatus','item_id'=>'13856','route_name'=>'addons-bloc-blocstatus','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3810','name'=>'/addons/bloc/levels','item_id'=>'13857','route_name'=>'addons-bloc-levels','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3811','name'=>'/addons/bloclevel/options','item_id'=>'13858','route_name'=>'addons-bloclevel-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3812','name'=>'/addons/bloclevel/levels','item_id'=>'13859','route_name'=>'addons-bloclevel-levels','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3813','name'=>'/addons/category/options','item_id'=>'13860','route_name'=>'addons-category-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3814','name'=>'/addons/category/category','item_id'=>'13861','route_name'=>'addons-category-category','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3815','name'=>'/addons/email/options','item_id'=>'13862','route_name'=>'addons-email-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3816','name'=>'/addons/manage/options','item_id'=>'13863','route_name'=>'addons-manage-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3817','name'=>'/addons/manage/index','item_id'=>'13864','route_name'=>'addons-manage-index','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3818','name'=>'/addons/manage/create','item_id'=>'13865','route_name'=>'addons-manage-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3819','name'=>'/addons/manage/delete','item_id'=>'13866','route_name'=>'addons-manage-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3820','name'=>'/addons/manage/view','item_id'=>'13867','route_name'=>'addons-manage-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3821','name'=>'/addons/setting/baidu','item_id'=>'13868','route_name'=>'addons-setting-baidu','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3822','name'=>'/addons/setting/wechatpay','item_id'=>'13869','route_name'=>'addons-setting-wechatpay','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3823','name'=>'/addons/setting/sms','item_id'=>'13870','route_name'=>'addons-setting-sms','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3824','name'=>'/addons/setting/email','item_id'=>'13871','route_name'=>'addons-setting-email','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3825','name'=>'/addons/setting/wxapp','item_id'=>'13872','route_name'=>'addons-setting-wxapp','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3826','name'=>'/addons/setting/wechat','item_id'=>'13873','route_name'=>'addons-setting-wechat','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3827','name'=>'/addons/setting/microapp','item_id'=>'13874','route_name'=>'addons-setting-microapp','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3828','name'=>'/addons/setting/app','item_id'=>'13875','route_name'=>'addons-setting-app','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3829','name'=>'/addons/setting/map','item_id'=>'13876','route_name'=>'addons-setting-map','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3830','name'=>'/addons/setting/index','item_id'=>'13877','route_name'=>'addons-setting-index','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3831','name'=>'/addons/setting/create','item_id'=>'13878','route_name'=>'addons-setting-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3832','name'=>'/addons/setting/update','item_id'=>'13879','route_name'=>'addons-setting-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3833','name'=>'/addons/setting/delete','item_id'=>'13880','route_name'=>'addons-setting-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3834','name'=>'/addons/setting/view','item_id'=>'13881','route_name'=>'addons-setting-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3835','name'=>'/addons/sms/options','item_id'=>'13882','route_name'=>'addons-sms-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3836','name'=>'/addons/store/options','item_id'=>'13883','route_name'=>'addons-store-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3837','name'=>'/addons/store/category','item_id'=>'13884','route_name'=>'addons-store-category','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3838','name'=>'/addons/store/blocs','item_id'=>'13885','route_name'=>'addons-store-blocs','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3839','name'=>'/addons/store/storestatus','item_id'=>'13886','route_name'=>'addons-store-storestatus','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3840','name'=>'/addons/storelabel/options','item_id'=>'13887','route_name'=>'addons-storelabel-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3841','name'=>'/addons/storelabellink/options','item_id'=>'13888','route_name'=>'addons-storelabellink-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3842','name'=>'/addons/user-bloc/index','item_id'=>'13889','route_name'=>'addons-user-bloc-index','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3843','name'=>'/addons/user-bloc/view','item_id'=>'13890','route_name'=>'addons-user-bloc-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3844','name'=>'/addons/user-bloc/create','item_id'=>'13891','route_name'=>'addons-user-bloc-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3845','name'=>'/addons/user-bloc/update','item_id'=>'13892','route_name'=>'addons-user-bloc-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3846','name'=>'/addons/user-bloc/getstore','item_id'=>'13893','route_name'=>'addons-user-bloc-getstore','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3847','name'=>'/addons/user-bloc/getuser','item_id'=>'13894','route_name'=>'addons-user-bloc-getuser','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3848','name'=>'/addons/user-bloc/delete','item_id'=>'13895','route_name'=>'addons-user-bloc-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3849','name'=>'/addons/wechatpay/options','item_id'=>'13896','route_name'=>'addons-wechatpay-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3850','name'=>'/addons/wxapp/options','item_id'=>'13897','route_name'=>'addons-wxapp-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3851','name'=>'/article/dd-article-category/options','item_id'=>'13898','route_name'=>'article-dd-article-category-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3852','name'=>'/auth/admin-user/options','item_id'=>'13899','route_name'=>'auth-admin-user-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3853','name'=>'/auth/admin-user/index','item_id'=>'13900','route_name'=>'auth-admin-user-index','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3854','name'=>'/auth/admin-user/view','item_id'=>'13901','route_name'=>'auth-admin-user-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3855','name'=>'/auth/admin-user/create','item_id'=>'13902','route_name'=>'auth-admin-user-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3856','name'=>'/auth/admin-user/update','item_id'=>'13903','route_name'=>'auth-admin-user-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3857','name'=>'/auth/admin-user/delete','item_id'=>'13904','route_name'=>'auth-admin-user-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3858','name'=>'/auth/admin-user/*','item_id'=>'13905','route_name'=>'auth-admin-user-*','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3859','name'=>'/auth/assignment/change','item_id'=>'13906','route_name'=>'auth-assignment-change','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3860','name'=>'/auth/group/index','item_id'=>'13907','route_name'=>'auth-group-index','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3861','name'=>'/auth/group/view','item_id'=>'13908','route_name'=>'auth-group-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3862','name'=>'/auth/group/change','item_id'=>'13909','route_name'=>'auth-group-change','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3863','name'=>'/auth/group/assign','item_id'=>'13910','route_name'=>'auth-group-assign','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3864','name'=>'/auth/group/remove','item_id'=>'13911','route_name'=>'auth-group-remove','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3865','name'=>'/auth/group/create','item_id'=>'13912','route_name'=>'auth-group-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3866','name'=>'/auth/group/update','item_id'=>'13913','route_name'=>'auth-group-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3867','name'=>'/auth/group/delete','item_id'=>'13914','route_name'=>'auth-group-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3868','name'=>'/auth/permission/index','item_id'=>'13915','route_name'=>'auth-permission-index','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3869','name'=>'/auth/permission/addons','item_id'=>'13916','route_name'=>'auth-permission-addons','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3870','name'=>'/auth/permission/levels','item_id'=>'13917','route_name'=>'auth-permission-levels','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3871','name'=>'/auth/permission/rule','item_id'=>'13918','route_name'=>'auth-permission-rule','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3872','name'=>'/auth/permission/route','item_id'=>'13919','route_name'=>'auth-permission-route','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3873','name'=>'/auth/permission/view','item_id'=>'13920','route_name'=>'auth-permission-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3874','name'=>'/auth/permission/create','item_id'=>'13921','route_name'=>'auth-permission-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3875','name'=>'/auth/permission/updateitem','item_id'=>'13922','route_name'=>'auth-permission-updateitem','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3876','name'=>'/auth/permission/delete','item_id'=>'13923','route_name'=>'auth-permission-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3877','name'=>'/auth/permission/change','item_id'=>'13924','route_name'=>'auth-permission-change','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3878','name'=>'/auth/permission/assign','item_id'=>'13925','route_name'=>'auth-permission-assign','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3879','name'=>'/auth/permission/remove','item_id'=>'13926','route_name'=>'auth-permission-remove','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3880','name'=>'/auth/permission/update','item_id'=>'13927','route_name'=>'auth-permission-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3881','name'=>'/auth/user/index','item_id'=>'13928','route_name'=>'auth-user-index','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3882','name'=>'/auth/user/update','item_id'=>'13929','route_name'=>'auth-user-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3883','name'=>'/auth/user/change-pass','item_id'=>'13930','route_name'=>'auth-user-change-pass','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3884','name'=>'/auth/user/view','item_id'=>'13931','route_name'=>'auth-user-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3885','name'=>'/auth/user/delete','item_id'=>'13932','route_name'=>'auth-user-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3886','name'=>'/auth/user/assign','item_id'=>'13933','route_name'=>'auth-user-assign','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3887','name'=>'/auth/user/remove','item_id'=>'13934','route_name'=>'auth-user-remove','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3888','name'=>'/auth/user/login','item_id'=>'13935','route_name'=>'auth-user-login','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3889','name'=>'/auth/user/logout','item_id'=>'13936','route_name'=>'auth-user-logout','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3890','name'=>'/auth/user/signup','item_id'=>'13937','route_name'=>'auth-user-signup','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3891','name'=>'/auth/user/request-password-reset','item_id'=>'13938','route_name'=>'auth-user-request-password-reset','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3892','name'=>'/auth/user/reset-password','item_id'=>'13939','route_name'=>'auth-user-reset-password','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3893','name'=>'/auth/user/change-password','item_id'=>'13940','route_name'=>'auth-user-change-password','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3894','name'=>'/auth/user/activate','item_id'=>'13941','route_name'=>'auth-user-activate','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3895','name'=>'/auth/user/create','item_id'=>'13942','route_name'=>'auth-user-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3896','name'=>'/demo/form/options','item_id'=>'13943','route_name'=>'demo-form-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3897','name'=>'/demo/form/create','item_id'=>'13944','route_name'=>'demo-form-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3898','name'=>'/demo/form/update','item_id'=>'13945','route_name'=>'demo-form-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3899','name'=>'/demo/form/delete','item_id'=>'13946','route_name'=>'demo-form-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3900','name'=>'/demo/form/view','item_id'=>'13947','route_name'=>'demo-form-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3901','name'=>'/file/upload/options','item_id'=>'13948','route_name'=>'file-upload-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3902','name'=>'/file/upload/images','item_id'=>'13949','route_name'=>'file-upload-images','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3903','name'=>'/file/upload/file','item_id'=>'13950','route_name'=>'file-upload-file','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3904','name'=>'/file/upload/merge','item_id'=>'13951','route_name'=>'file-upload-merge','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3905','name'=>'/file/upload/index','item_id'=>'13952','route_name'=>'file-upload-index','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3906','name'=>'/file/upload/create','item_id'=>'13953','route_name'=>'file-upload-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3907','name'=>'/file/upload/update','item_id'=>'13954','route_name'=>'file-upload-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3908','name'=>'/file/upload/delete','item_id'=>'13955','route_name'=>'file-upload-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3909','name'=>'/file/upload/view','item_id'=>'13956','route_name'=>'file-upload-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3910','name'=>'/file/upload/*','item_id'=>'13957','route_name'=>'file-upload-*','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3911','name'=>'/member/account/options','item_id'=>'13958','route_name'=>'member-account-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3912','name'=>'/member/dd-member/options','item_id'=>'13959','route_name'=>'member-dd-member-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3913','name'=>'/member/dd-member-group/options','item_id'=>'13960','route_name'=>'member-dd-member-group-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3914','name'=>'/member/organization/options','item_id'=>'13961','route_name'=>'member-organization-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3915','name'=>'/member/organization/index','item_id'=>'13962','route_name'=>'member-organization-index','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3916','name'=>'/member/organization/view','item_id'=>'13963','route_name'=>'member-organization-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3917','name'=>'/member/organization/create','item_id'=>'13964','route_name'=>'member-organization-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3918','name'=>'/member/organization/update','item_id'=>'13965','route_name'=>'member-organization-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3919','name'=>'/member/organization/delete','item_id'=>'13966','route_name'=>'member-organization-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3920','name'=>'/member/organization/*','item_id'=>'13967','route_name'=>'member-organization-*','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3921','name'=>'/system/config/weburl','item_id'=>'13968','route_name'=>'system-config-weburl','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3922','name'=>'/system/config/baidu','item_id'=>'13969','route_name'=>'system-config-baidu','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3923','name'=>'/system/config/wechatpay','item_id'=>'13970','route_name'=>'system-config-wechatpay','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3924','name'=>'/system/config/sms','item_id'=>'13971','route_name'=>'system-config-sms','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3925','name'=>'/system/config/email','item_id'=>'13972','route_name'=>'system-config-email','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3926','name'=>'/system/config/wxapp','item_id'=>'13973','route_name'=>'system-config-wxapp','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3927','name'=>'/system/config/wechat','item_id'=>'13974','route_name'=>'system-config-wechat','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3928','name'=>'/system/config/microapp','item_id'=>'13975','route_name'=>'system-config-microapp','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3929','name'=>'/system/config/app','item_id'=>'13976','route_name'=>'system-config-app','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3930','name'=>'/system/config/map','item_id'=>'13977','route_name'=>'system-config-map','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3931','name'=>'/system/config/oss','item_id'=>'13978','route_name'=>'system-config-oss','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3932','name'=>'/system/config/index','item_id'=>'13979','route_name'=>'system-config-index','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3933','name'=>'/system/config/create','item_id'=>'13980','route_name'=>'system-config-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3934','name'=>'/system/config/update','item_id'=>'13981','route_name'=>'system-config-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3935','name'=>'/system/config/delete','item_id'=>'13982','route_name'=>'system-config-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3936','name'=>'/system/config/view','item_id'=>'13983','route_name'=>'system-config-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3937','name'=>'/system/config/*','item_id'=>'13984','route_name'=>'system-config-*','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3938','name'=>'/system/database/options','item_id'=>'13985','route_name'=>'system-database-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3939','name'=>'/system/database/index','item_id'=>'13986','route_name'=>'system-database-index','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3940','name'=>'/system/database/create','item_id'=>'13987','route_name'=>'system-database-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3941','name'=>'/system/database/update','item_id'=>'13988','route_name'=>'system-database-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3942','name'=>'/system/database/view','item_id'=>'13989','route_name'=>'system-database-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3943','name'=>'/system/index/options','item_id'=>'13990','route_name'=>'system-index-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3944','name'=>'/system/index/menus','item_id'=>'13991','route_name'=>'system-index-menus','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3945','name'=>'/system/index/create','item_id'=>'13992','route_name'=>'system-index-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3946','name'=>'/system/index/update','item_id'=>'13993','route_name'=>'system-index-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3947','name'=>'/system/index/delete','item_id'=>'13994','route_name'=>'system-index-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3948','name'=>'/system/index/view','item_id'=>'13995','route_name'=>'system-index-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3949','name'=>'/system/settings/ueditor','item_id'=>'13996','route_name'=>'system-settings-ueditor','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3950','name'=>'/system/settings/weburl','item_id'=>'13997','route_name'=>'system-settings-weburl','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3951','name'=>'/system/settings/conf','item_id'=>'13998','route_name'=>'system-settings-conf','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3952','name'=>'/system/settings/index','item_id'=>'13999','route_name'=>'system-settings-index1','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3953','name'=>'/system/settings/create','item_id'=>'14000','route_name'=>'system-settings-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3954','name'=>'/system/settings/update','item_id'=>'14001','route_name'=>'system-settings-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3955','name'=>'/system/settings/delete','item_id'=>'14002','route_name'=>'system-settings-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3956','name'=>'/system/settings/view','item_id'=>'14003','route_name'=>'system-settings-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3957','name'=>'/system/welcome/options','item_id'=>'14004','route_name'=>'system-welcome-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3958','name'=>'/system/welcome/create','item_id'=>'14005','route_name'=>'system-welcome-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3959','name'=>'/system/welcome/update','item_id'=>'14006','route_name'=>'system-welcome-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3960','name'=>'/system/welcome/delete','item_id'=>'14007','route_name'=>'system-welcome-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3961','name'=>'/system/welcome/view','item_id'=>'14008','route_name'=>'system-welcome-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3962','name'=>'/user/dd-user/options','item_id'=>'14009','route_name'=>'user-dd-user-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3963','name'=>'/website/dd-website-contact/options','item_id'=>'14010','route_name'=>'website-dd-website-contact-options','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3964','name'=>'/website/setting/index','item_id'=>'14011','route_name'=>'website-setting-index','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3965','name'=>'/website/setting/create','item_id'=>'14012','route_name'=>'website-setting-create','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3966','name'=>'/website/setting/update','item_id'=>'14013','route_name'=>'website-setting-update','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3967','name'=>'/website/setting/delete','item_id'=>'14014','route_name'=>'website-setting-delete','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3968','name'=>'/website/setting/view','item_id'=>'14015','route_name'=>'website-setting-view','is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644378347','updated_at'=>'1644378347']);
        $this->insert('{{%auth_route}}',['id'=>'3976','name'=>'/site/xiufu','item_id'=>NULL,'route_name'=>NULL,'is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644639573','updated_at'=>'1644639573']);
        $this->insert('{{%auth_route}}',['id'=>'3977','name'=>'/addons/addons/info','item_id'=>NULL,'route_name'=>NULL,'is_sys'=>'0','route_type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1644639573','updated_at'=>'1644639573']);
        $this->insert('{{%auth_route}}',['id'=>'3982','name'=>'/diandi_party/zailai','item_id'=>'14020','route_name'=>'diandi-party-zailai1','is_sys'=>'1','route_type'=>'0','description'=>NULL,'title'=>'再来目录','pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        $this->insert('{{%auth_route}}',['id'=>'4153','name'=>'/addons/addons/install.vue','item_id'=>'14190','route_name'=>'addons-install','is_sys'=>'1','route_type'=>'1','description'=>'','title'=>'更多业务','pid'=>NULL,'data'=>NULL,'module_name'=>'sys','created_at'=>NULL,'updated_at'=>NULL]);
        
        /* 设置外键约束 */
        $this->execute('SET foreign_key_checks = 1;');
    }

    public function down()
    {
        $this->execute('SET foreign_key_checks = 0');
        /* 删除表 */
        $this->dropTable('{{%auth_route}}');
        $this->execute('SET foreign_key_checks = 1;');
    }
}

