<?php

use yii\db\Migration;

class m220613_063636_region extends Migration
{
    public function up()
    {
        /* 取消外键约束 */
        $this->execute('SET foreign_key_checks = 0');
        
        /* 创建表 */
        $this->createTable('{{%region}}', [
            'id' => "int(11) NOT NULL AUTO_INCREMENT",
            'pid' => "int(11) NULL",
            'shortname' => "varchar(100) NULL",
            'name' => "varchar(100) NULL",
            'merger_name' => "varchar(255) NULL",
            'level' => "tinyint(4) unsigned NULL DEFAULT '0'",
            'pinyin' => "varchar(100) NULL",
            'code' => "varchar(100) NULL",
            'zip_code' => "varchar(100) NULL",
            'first' => "varchar(50) NULL",
            'lng' => "varchar(100) NULL",
            'lat' => "varchar(100) NULL",
            'PRIMARY KEY (`id`)'
        ], "ENGINE=InnoDB  DEFAULT CHARSET=utf8");
        
        /* 索引设置 */
        $this->createIndex('name,level','{{%region}}','name, pid',0);
        
        
        /* 表数据 */
        $this->insert('{{%region}}',['id'=>'1','pid'=>'0','shortname'=>'北京','name'=>'北京市','merger_name'=>'中国,北京','level'=>'1','pinyin'=>'beijing','code'=>'','zip_code'=>'','first'=>'B','lng'=>'116.405285','lat'=>'39.904989']);
        $this->insert('{{%region}}',['id'=>'2','pid'=>'1','shortname'=>'北京','name'=>'北京市','merger_name'=>'中国,北京,北京市','level'=>'2','pinyin'=>'beijing','code'=>'010','zip_code'=>'100000','first'=>'B','lng'=>'116.405285','lat'=>'39.904989']);
        $this->insert('{{%region}}',['id'=>'3','pid'=>'2','shortname'=>'东城','name'=>'东城区','merger_name'=>'中国,北京,北京市,东城区','level'=>'3','pinyin'=>'dongcheng','code'=>'010','zip_code'=>'100010','first'=>'D','lng'=>'116.41005','lat'=>'39.93157']);
        $this->insert('{{%region}}',['id'=>'4','pid'=>'2','shortname'=>'西城','name'=>'西城区','merger_name'=>'中国,北京,北京市,西城区','level'=>'3','pinyin'=>'xicheng','code'=>'010','zip_code'=>'100032','first'=>'X','lng'=>'116.36003','lat'=>'39.9305']);
        $this->insert('{{%region}}',['id'=>'5','pid'=>'2','shortname'=>'朝阳','name'=>'朝阳区','merger_name'=>'中国,北京,北京市,朝阳区','level'=>'3','pinyin'=>'chaoyang','code'=>'010','zip_code'=>'100020','first'=>'C','lng'=>'116.48548','lat'=>'39.9484']);
        $this->insert('{{%region}}',['id'=>'6','pid'=>'2','shortname'=>'丰台','name'=>'丰台区','merger_name'=>'中国,北京,北京市,丰台区','level'=>'3','pinyin'=>'fengtai','code'=>'010','zip_code'=>'100071','first'=>'F','lng'=>'116.28625','lat'=>'39.8585']);
        $this->insert('{{%region}}',['id'=>'7','pid'=>'2','shortname'=>'石景山','name'=>'石景山区','merger_name'=>'中国,北京,北京市,石景山区','level'=>'3','pinyin'=>'shijingshan','code'=>'010','zip_code'=>'100043','first'=>'S','lng'=>'116.2229','lat'=>'39.90564']);
        $this->insert('{{%region}}',['id'=>'8','pid'=>'2','shortname'=>'海淀','name'=>'海淀区','merger_name'=>'中国,北京,北京市,海淀区','level'=>'3','pinyin'=>'haidian','code'=>'010','zip_code'=>'100089','first'=>'H','lng'=>'116.29812','lat'=>'39.95931']);
        $this->insert('{{%region}}',['id'=>'9','pid'=>'2','shortname'=>'门头沟','name'=>'门头沟区','merger_name'=>'中国,北京,北京市,门头沟区','level'=>'3','pinyin'=>'mentougou','code'=>'010','zip_code'=>'102300','first'=>'M','lng'=>'116.10137','lat'=>'39.94043']);
        $this->insert('{{%region}}',['id'=>'10','pid'=>'2','shortname'=>'房山','name'=>'房山区','merger_name'=>'中国,北京,北京市,房山区','level'=>'3','pinyin'=>'fangshan','code'=>'010','zip_code'=>'102488','first'=>'F','lng'=>'116.14257','lat'=>'39.74786']);
        $this->insert('{{%region}}',['id'=>'11','pid'=>'2','shortname'=>'通州','name'=>'通州区','merger_name'=>'中国,北京,北京市,通州区','level'=>'3','pinyin'=>'tongzhou','code'=>'010','zip_code'=>'101149','first'=>'T','lng'=>'116.65716','lat'=>'39.90966']);
        $this->insert('{{%region}}',['id'=>'12','pid'=>'2','shortname'=>'顺义','name'=>'顺义区','merger_name'=>'中国,北京,北京市,顺义区','level'=>'3','pinyin'=>'shunyi','code'=>'010','zip_code'=>'101300','first'=>'S','lng'=>'116.65417','lat'=>'40.1302']);
        $this->insert('{{%region}}',['id'=>'13','pid'=>'2','shortname'=>'昌平','name'=>'昌平区','merger_name'=>'中国,北京,北京市,昌平区','level'=>'3','pinyin'=>'changping','code'=>'010','zip_code'=>'102200','first'=>'C','lng'=>'116.2312','lat'=>'40.22072']);
        $this->insert('{{%region}}',['id'=>'14','pid'=>'2','shortname'=>'大兴','name'=>'大兴区','merger_name'=>'中国,北京,北京市,大兴区','level'=>'3','pinyin'=>'daxing','code'=>'010','zip_code'=>'102600','first'=>'D','lng'=>'116.34149','lat'=>'39.72668']);
        $this->insert('{{%region}}',['id'=>'15','pid'=>'2','shortname'=>'怀柔','name'=>'怀柔区','merger_name'=>'中国,北京,北京市,怀柔区','level'=>'3','pinyin'=>'huairou','code'=>'010','zip_code'=>'101400','first'=>'H','lng'=>'116.63168','lat'=>'40.31602']);
        $this->insert('{{%region}}',['id'=>'16','pid'=>'2','shortname'=>'平谷','name'=>'平谷区','merger_name'=>'中国,北京,北京市,平谷区','level'=>'3','pinyin'=>'pinggu','code'=>'010','zip_code'=>'101200','first'=>'P','lng'=>'117.12133','lat'=>'40.14056']);
        $this->insert('{{%region}}',['id'=>'17','pid'=>'2','shortname'=>'密云','name'=>'密云县','merger_name'=>'中国,北京,北京市,密云县','level'=>'3','pinyin'=>'miyun','code'=>'010','zip_code'=>'101500','first'=>'M','lng'=>'116.84295','lat'=>'40.37618']);
        $this->insert('{{%region}}',['id'=>'18','pid'=>'2','shortname'=>'延庆','name'=>'延庆县','merger_name'=>'中国,北京,北京市,延庆县','level'=>'3','pinyin'=>'yanqing','code'=>'010','zip_code'=>'102100','first'=>'Y','lng'=>'115.97494','lat'=>'40.45672']);
        $this->insert('{{%region}}',['id'=>'19','pid'=>'0','shortname'=>'天津','name'=>'天津市','merger_name'=>'中国,天津','level'=>'1','pinyin'=>'tianjin','code'=>'','zip_code'=>'','first'=>'T','lng'=>'117.190182','lat'=>'39.125596']);
        $this->insert('{{%region}}',['id'=>'20','pid'=>'19','shortname'=>'天津','name'=>'天津市','merger_name'=>'中国,天津,天津市','level'=>'2','pinyin'=>'tianjin','code'=>'022','zip_code'=>'300000','first'=>'T','lng'=>'117.190182','lat'=>'39.125596']);
        $this->insert('{{%region}}',['id'=>'21','pid'=>'20','shortname'=>'和平','name'=>'和平区','merger_name'=>'中国,天津,天津市,和平区','level'=>'3','pinyin'=>'heping','code'=>'022','zip_code'=>'300041','first'=>'H','lng'=>'117.21456','lat'=>'39.11718']);
        $this->insert('{{%region}}',['id'=>'22','pid'=>'20','shortname'=>'河东','name'=>'河东区','merger_name'=>'中国,天津,天津市,河东区','level'=>'3','pinyin'=>'hedong','code'=>'022','zip_code'=>'300171','first'=>'H','lng'=>'117.22562','lat'=>'39.12318']);
        $this->insert('{{%region}}',['id'=>'23','pid'=>'20','shortname'=>'河西','name'=>'河西区','merger_name'=>'中国,天津,天津市,河西区','level'=>'3','pinyin'=>'hexi','code'=>'022','zip_code'=>'300202','first'=>'H','lng'=>'117.22327','lat'=>'39.10959']);
        $this->insert('{{%region}}',['id'=>'24','pid'=>'20','shortname'=>'南开','name'=>'南开区','merger_name'=>'中国,天津,天津市,南开区','level'=>'3','pinyin'=>'nankai','code'=>'022','zip_code'=>'300110','first'=>'N','lng'=>'117.15074','lat'=>'39.13821']);
        $this->insert('{{%region}}',['id'=>'25','pid'=>'20','shortname'=>'河北','name'=>'河北区','merger_name'=>'中国,天津,天津市,河北区','level'=>'3','pinyin'=>'hebei','code'=>'022','zip_code'=>'300143','first'=>'H','lng'=>'117.19697','lat'=>'39.14816']);
        $this->insert('{{%region}}',['id'=>'26','pid'=>'20','shortname'=>'红桥','name'=>'红桥区','merger_name'=>'中国,天津,天津市,红桥区','level'=>'3','pinyin'=>'hongqiao','code'=>'022','zip_code'=>'300131','first'=>'H','lng'=>'117.15145','lat'=>'39.16715']);
        $this->insert('{{%region}}',['id'=>'27','pid'=>'20','shortname'=>'东丽','name'=>'东丽区','merger_name'=>'中国,天津,天津市,东丽区','level'=>'3','pinyin'=>'dongli','code'=>'022','zip_code'=>'300300','first'=>'D','lng'=>'117.31436','lat'=>'39.0863']);
        $this->insert('{{%region}}',['id'=>'28','pid'=>'20','shortname'=>'西青','name'=>'西青区','merger_name'=>'中国,天津,天津市,西青区','level'=>'3','pinyin'=>'xiqing','code'=>'022','zip_code'=>'300380','first'=>'X','lng'=>'117.00927','lat'=>'39.14123']);
        $this->insert('{{%region}}',['id'=>'29','pid'=>'20','shortname'=>'津南','name'=>'津南区','merger_name'=>'中国,天津,天津市,津南区','level'=>'3','pinyin'=>'jinnan','code'=>'022','zip_code'=>'300350','first'=>'J','lng'=>'117.38537','lat'=>'38.99139']);
        $this->insert('{{%region}}',['id'=>'30','pid'=>'20','shortname'=>'北辰','name'=>'北辰区','merger_name'=>'中国,天津,天津市,北辰区','level'=>'3','pinyin'=>'beichen','code'=>'022','zip_code'=>'300400','first'=>'B','lng'=>'117.13217','lat'=>'39.22131']);
        $this->insert('{{%region}}',['id'=>'31','pid'=>'20','shortname'=>'武清','name'=>'武清区','merger_name'=>'中国,天津,天津市,武清区','level'=>'3','pinyin'=>'wuqing','code'=>'022','zip_code'=>'301700','first'=>'W','lng'=>'117.04443','lat'=>'39.38415']);
        $this->insert('{{%region}}',['id'=>'32','pid'=>'20','shortname'=>'宝坻','name'=>'宝坻区','merger_name'=>'中国,天津,天津市,宝坻区','level'=>'3','pinyin'=>'baodi','code'=>'022','zip_code'=>'301800','first'=>'B','lng'=>'117.3103','lat'=>'39.71761']);
        $this->insert('{{%region}}',['id'=>'33','pid'=>'20','shortname'=>'滨海新区','name'=>'滨海新区','merger_name'=>'中国,天津,天津市,滨海新区','level'=>'3','pinyin'=>'binhaixinqu','code'=>'022','zip_code'=>'300451','first'=>'B','lng'=>'117.70162','lat'=>'39.02668']);
        $this->insert('{{%region}}',['id'=>'34','pid'=>'20','shortname'=>'宁河','name'=>'宁河县','merger_name'=>'中国,天津,天津市,宁河县','level'=>'3','pinyin'=>'ninghe','code'=>'022','zip_code'=>'301500','first'=>'N','lng'=>'117.8255','lat'=>'39.33048']);
        $this->insert('{{%region}}',['id'=>'35','pid'=>'20','shortname'=>'静海','name'=>'静海县','merger_name'=>'中国,天津,天津市,静海县','level'=>'3','pinyin'=>'jinghai','code'=>'022','zip_code'=>'301600','first'=>'J','lng'=>'116.97436','lat'=>'38.94582']);
        $this->insert('{{%region}}',['id'=>'36','pid'=>'20','shortname'=>'蓟县','name'=>'蓟县','merger_name'=>'中国,天津,天津市,蓟县','level'=>'3','pinyin'=>'jixian','code'=>'022','zip_code'=>'301900','first'=>'J','lng'=>'117.40799','lat'=>'40.04567']);
        $this->insert('{{%region}}',['id'=>'37','pid'=>'0','shortname'=>'河北','name'=>'河北省','merger_name'=>'中国,河北省','level'=>'1','pinyin'=>'hebei','code'=>'','zip_code'=>'','first'=>'H','lng'=>'114.502461','lat'=>'38.045474']);
        $this->insert('{{%region}}',['id'=>'38','pid'=>'37','shortname'=>'石家庄','name'=>'石家庄市','merger_name'=>'中国,河北省,石家庄市','level'=>'2','pinyin'=>'shijiazhuang','code'=>'0311','zip_code'=>'050011','first'=>'S','lng'=>'114.502461','lat'=>'38.045474']);
        $this->insert('{{%region}}',['id'=>'39','pid'=>'38','shortname'=>'长安','name'=>'长安区','merger_name'=>'中国,河北省,石家庄市,长安区','level'=>'3','pinyin'=>'chang\'an','code'=>'0311','zip_code'=>'050011','first'=>'C','lng'=>'114.53906','lat'=>'38.03665']);
        $this->insert('{{%region}}',['id'=>'40','pid'=>'38','shortname'=>'桥西','name'=>'桥西区','merger_name'=>'中国,河北省,石家庄市,桥西区','level'=>'3','pinyin'=>'qiaoxi','code'=>'0311','zip_code'=>'050091','first'=>'Q','lng'=>'114.46977','lat'=>'38.03221']);
        $this->insert('{{%region}}',['id'=>'41','pid'=>'38','shortname'=>'新华','name'=>'新华区','merger_name'=>'中国,河北省,石家庄市,新华区','level'=>'3','pinyin'=>'xinhua','code'=>'0311','zip_code'=>'050051','first'=>'X','lng'=>'114.46326','lat'=>'38.05088']);
        $this->insert('{{%region}}',['id'=>'42','pid'=>'38','shortname'=>'井陉矿区','name'=>'井陉矿区','merger_name'=>'中国,河北省,石家庄市,井陉矿区','level'=>'3','pinyin'=>'jingxingkuangqu','code'=>'0311','zip_code'=>'050100','first'=>'J','lng'=>'114.06518','lat'=>'38.06705']);
        $this->insert('{{%region}}',['id'=>'43','pid'=>'38','shortname'=>'裕华','name'=>'裕华区','merger_name'=>'中国,河北省,石家庄市,裕华区','level'=>'3','pinyin'=>'yuhua','code'=>'0311','zip_code'=>'050031','first'=>'Y','lng'=>'114.53115','lat'=>'38.00604']);
        $this->insert('{{%region}}',['id'=>'44','pid'=>'38','shortname'=>'藁城','name'=>'藁城区','merger_name'=>'中国,河北省,石家庄市,藁城区','level'=>'3','pinyin'=>'gaocheng','code'=>'0311','zip_code'=>'052160','first'=>NULL,'lng'=>'114.84671','lat'=>'38.02162']);
        $this->insert('{{%region}}',['id'=>'45','pid'=>'38','shortname'=>'鹿泉','name'=>'鹿泉区','merger_name'=>'中国,河北省,石家庄市,鹿泉区','level'=>'3','pinyin'=>'luquan','code'=>'0311','zip_code'=>'050200','first'=>'L','lng'=>'114.31347','lat'=>'38.08782']);
        $this->insert('{{%region}}',['id'=>'46','pid'=>'38','shortname'=>'栾城','name'=>'栾城区','merger_name'=>'中国,河北省,石家庄市,栾城区','level'=>'3','pinyin'=>'luancheng','code'=>'0311','zip_code'=>'051430','first'=>NULL,'lng'=>'114.64834','lat'=>'37.90022']);
        $this->insert('{{%region}}',['id'=>'47','pid'=>'38','shortname'=>'井陉','name'=>'井陉县','merger_name'=>'中国,河北省,石家庄市,井陉县','level'=>'3','pinyin'=>'jingxing','code'=>'0311','zip_code'=>'050300','first'=>'J','lng'=>'114.14257','lat'=>'38.03688']);
        $this->insert('{{%region}}',['id'=>'48','pid'=>'38','shortname'=>'正定','name'=>'正定县','merger_name'=>'中国,河北省,石家庄市,正定县','level'=>'3','pinyin'=>'zhengding','code'=>'0311','zip_code'=>'050800','first'=>'Z','lng'=>'114.57296','lat'=>'38.14445']);
        $this->insert('{{%region}}',['id'=>'49','pid'=>'38','shortname'=>'行唐','name'=>'行唐县','merger_name'=>'中国,河北省,石家庄市,行唐县','level'=>'3','pinyin'=>'xingtang','code'=>'0311','zip_code'=>'050600','first'=>'X','lng'=>'114.55316','lat'=>'38.43654']);
        $this->insert('{{%region}}',['id'=>'50','pid'=>'38','shortname'=>'灵寿','name'=>'灵寿县','merger_name'=>'中国,河北省,石家庄市,灵寿县','level'=>'3','pinyin'=>'lingshou','code'=>'0311','zip_code'=>'050500','first'=>'L','lng'=>'114.38259','lat'=>'38.30845']);
        $this->insert('{{%region}}',['id'=>'51','pid'=>'38','shortname'=>'高邑','name'=>'高邑县','merger_name'=>'中国,河北省,石家庄市,高邑县','level'=>'3','pinyin'=>'gaoyi','code'=>'0311','zip_code'=>'051330','first'=>'G','lng'=>'114.61142','lat'=>'37.61556']);
        $this->insert('{{%region}}',['id'=>'52','pid'=>'38','shortname'=>'深泽','name'=>'深泽县','merger_name'=>'中国,河北省,石家庄市,深泽县','level'=>'3','pinyin'=>'shenze','code'=>'0311','zip_code'=>'052560','first'=>'S','lng'=>'115.20358','lat'=>'38.18353']);
        $this->insert('{{%region}}',['id'=>'53','pid'=>'38','shortname'=>'赞皇','name'=>'赞皇县','merger_name'=>'中国,河北省,石家庄市,赞皇县','level'=>'3','pinyin'=>'zanhuang','code'=>'0311','zip_code'=>'051230','first'=>'Z','lng'=>'114.38775','lat'=>'37.66135']);
        $this->insert('{{%region}}',['id'=>'54','pid'=>'38','shortname'=>'无极','name'=>'无极县','merger_name'=>'中国,河北省,石家庄市,无极县','level'=>'3','pinyin'=>'wuji','code'=>'0311','zip_code'=>'052460','first'=>'W','lng'=>'114.97509','lat'=>'38.17653']);
        $this->insert('{{%region}}',['id'=>'55','pid'=>'38','shortname'=>'平山','name'=>'平山县','merger_name'=>'中国,河北省,石家庄市,平山县','level'=>'3','pinyin'=>'pingshan','code'=>'0311','zip_code'=>'050400','first'=>'P','lng'=>'114.186','lat'=>'38.25994']);
        $this->insert('{{%region}}',['id'=>'56','pid'=>'38','shortname'=>'元氏','name'=>'元氏县','merger_name'=>'中国,河北省,石家庄市,元氏县','level'=>'3','pinyin'=>'yuanshi','code'=>'0311','zip_code'=>'051130','first'=>'Y','lng'=>'114.52539','lat'=>'37.76668']);
        $this->insert('{{%region}}',['id'=>'57','pid'=>'38','shortname'=>'赵县','name'=>'赵县','merger_name'=>'中国,河北省,石家庄市,赵县','level'=>'3','pinyin'=>'zhaoxian','code'=>'0311','zip_code'=>'051530','first'=>'Z','lng'=>'114.77612','lat'=>'37.75628']);
        $this->insert('{{%region}}',['id'=>'58','pid'=>'38','shortname'=>'辛集','name'=>'辛集市','merger_name'=>'中国,河北省,石家庄市,辛集市','level'=>'3','pinyin'=>'xinji','code'=>'0311','zip_code'=>'052360','first'=>'X','lng'=>'115.20626','lat'=>'37.94079']);
        $this->insert('{{%region}}',['id'=>'59','pid'=>'38','shortname'=>'晋州','name'=>'晋州市','merger_name'=>'中国,河北省,石家庄市,晋州市','level'=>'3','pinyin'=>'jinzhou','code'=>'0311','zip_code'=>'052260','first'=>'J','lng'=>'115.04348','lat'=>'38.03135']);
        $this->insert('{{%region}}',['id'=>'60','pid'=>'38','shortname'=>'新乐','name'=>'新乐市','merger_name'=>'中国,河北省,石家庄市,新乐市','level'=>'3','pinyin'=>'xinle','code'=>'0311','zip_code'=>'050700','first'=>'X','lng'=>'114.68985','lat'=>'38.34417']);
        $this->insert('{{%region}}',['id'=>'61','pid'=>'37','shortname'=>'唐山','name'=>'唐山市','merger_name'=>'中国,河北省,唐山市','level'=>'2','pinyin'=>'tangshan','code'=>'0315','zip_code'=>'063000','first'=>'T','lng'=>'118.175393','lat'=>'39.635113']);
        $this->insert('{{%region}}',['id'=>'62','pid'=>'61','shortname'=>'路南','name'=>'路南区','merger_name'=>'中国,河北省,唐山市,路南区','level'=>'3','pinyin'=>'lunan','code'=>'0315','zip_code'=>'063000','first'=>'L','lng'=>'118.15431','lat'=>'39.62505']);
        $this->insert('{{%region}}',['id'=>'63','pid'=>'61','shortname'=>'路北','name'=>'路北区','merger_name'=>'中国,河北省,唐山市,路北区','level'=>'3','pinyin'=>'lubei','code'=>'0315','zip_code'=>'063000','first'=>'L','lng'=>'118.20079','lat'=>'39.62436']);
        $this->insert('{{%region}}',['id'=>'64','pid'=>'61','shortname'=>'古冶','name'=>'古冶区','merger_name'=>'中国,河北省,唐山市,古冶区','level'=>'3','pinyin'=>'guye','code'=>'0315','zip_code'=>'063100','first'=>'G','lng'=>'118.45803','lat'=>'39.71993']);
        $this->insert('{{%region}}',['id'=>'65','pid'=>'61','shortname'=>'开平','name'=>'开平区','merger_name'=>'中国,河北省,唐山市,开平区','level'=>'3','pinyin'=>'kaiping','code'=>'0315','zip_code'=>'063021','first'=>'K','lng'=>'118.26171','lat'=>'39.67128']);
        $this->insert('{{%region}}',['id'=>'66','pid'=>'61','shortname'=>'丰南','name'=>'丰南区','merger_name'=>'中国,河北省,唐山市,丰南区','level'=>'3','pinyin'=>'fengnan','code'=>'0315','zip_code'=>'063300','first'=>'F','lng'=>'118.11282','lat'=>'39.56483']);
        $this->insert('{{%region}}',['id'=>'67','pid'=>'61','shortname'=>'丰润','name'=>'丰润区','merger_name'=>'中国,河北省,唐山市,丰润区','level'=>'3','pinyin'=>'fengrun','code'=>'0315','zip_code'=>'064000','first'=>'F','lng'=>'118.12976','lat'=>'39.8244']);
        $this->insert('{{%region}}',['id'=>'68','pid'=>'61','shortname'=>'曹妃甸','name'=>'曹妃甸区','merger_name'=>'中国,河北省,唐山市,曹妃甸区','level'=>'3','pinyin'=>'caofeidian','code'=>'0315','zip_code'=>'063200','first'=>'C','lng'=>'118.460379','lat'=>'39.273070']);
        $this->insert('{{%region}}',['id'=>'69','pid'=>'61','shortname'=>'滦县','name'=>'滦县','merger_name'=>'中国,河北省,唐山市,滦县','level'=>'3','pinyin'=>'luanxian','code'=>'0315','zip_code'=>'063700','first'=>'L','lng'=>'118.70346','lat'=>'39.74056']);
        $this->insert('{{%region}}',['id'=>'70','pid'=>'61','shortname'=>'滦南','name'=>'滦南县','merger_name'=>'中国,河北省,唐山市,滦南县','level'=>'3','pinyin'=>'luannan','code'=>'0315','zip_code'=>'063500','first'=>'L','lng'=>'118.6741','lat'=>'39.5039']);
        $this->insert('{{%region}}',['id'=>'71','pid'=>'61','shortname'=>'乐亭','name'=>'乐亭县','merger_name'=>'中国,河北省,唐山市,乐亭县','level'=>'3','pinyin'=>'laoting','code'=>'0315','zip_code'=>'063600','first'=>'L','lng'=>'118.9125','lat'=>'39.42561']);
        $this->insert('{{%region}}',['id'=>'72','pid'=>'61','shortname'=>'迁西','name'=>'迁西县','merger_name'=>'中国,河北省,唐山市,迁西县','level'=>'3','pinyin'=>'qianxi','code'=>'0315','zip_code'=>'064300','first'=>'Q','lng'=>'118.31616','lat'=>'40.14587']);
        $this->insert('{{%region}}',['id'=>'73','pid'=>'61','shortname'=>'玉田','name'=>'玉田县','merger_name'=>'中国,河北省,唐山市,玉田县','level'=>'3','pinyin'=>'yutian','code'=>'0315','zip_code'=>'064100','first'=>'Y','lng'=>'117.7388','lat'=>'39.90049']);
        $this->insert('{{%region}}',['id'=>'74','pid'=>'61','shortname'=>'遵化','name'=>'遵化市','merger_name'=>'中国,河北省,唐山市,遵化市','level'=>'3','pinyin'=>'zunhua','code'=>'0315','zip_code'=>'064200','first'=>'Z','lng'=>'117.96444','lat'=>'40.18741']);
        $this->insert('{{%region}}',['id'=>'75','pid'=>'61','shortname'=>'迁安','name'=>'迁安市','merger_name'=>'中国,河北省,唐山市,迁安市','level'=>'3','pinyin'=>'qian\'an','code'=>'0315','zip_code'=>'064400','first'=>'Q','lng'=>'118.70068','lat'=>'39.99833']);
        $this->insert('{{%region}}',['id'=>'76','pid'=>'37','shortname'=>'秦皇岛','name'=>'秦皇岛市','merger_name'=>'中国,河北省,秦皇岛市','level'=>'2','pinyin'=>'qinhuangdao','code'=>'0335','zip_code'=>'066000','first'=>'Q','lng'=>'119.586579','lat'=>'39.942531']);
        $this->insert('{{%region}}',['id'=>'77','pid'=>'76','shortname'=>'海港','name'=>'海港区','merger_name'=>'中国,河北省,秦皇岛市,海港区','level'=>'3','pinyin'=>'haigang','code'=>'0335','zip_code'=>'066000','first'=>'H','lng'=>'119.61046','lat'=>'39.9345']);
        $this->insert('{{%region}}',['id'=>'78','pid'=>'76','shortname'=>'山海关','name'=>'山海关区','merger_name'=>'中国,河北省,秦皇岛市,山海关区','level'=>'3','pinyin'=>'shanhaiguan','code'=>'0335','zip_code'=>'066200','first'=>'S','lng'=>'119.77563','lat'=>'39.97869']);
        $this->insert('{{%region}}',['id'=>'79','pid'=>'76','shortname'=>'北戴河','name'=>'北戴河区','merger_name'=>'中国,河北省,秦皇岛市,北戴河区','level'=>'3','pinyin'=>'beidaihe','code'=>'0335','zip_code'=>'066100','first'=>'B','lng'=>'119.48388','lat'=>'39.83408']);
        $this->insert('{{%region}}',['id'=>'80','pid'=>'76','shortname'=>'青龙','name'=>'青龙满族自治县','merger_name'=>'中国,河北省,秦皇岛市,青龙满族自治县','level'=>'3','pinyin'=>'qinglong','code'=>'0335','zip_code'=>'066500','first'=>'Q','lng'=>'118.95242','lat'=>'40.40743']);
        $this->insert('{{%region}}',['id'=>'81','pid'=>'76','shortname'=>'昌黎','name'=>'昌黎县','merger_name'=>'中国,河北省,秦皇岛市,昌黎县','level'=>'3','pinyin'=>'changli','code'=>'0335','zip_code'=>'066600','first'=>'C','lng'=>'119.16595','lat'=>'39.70884']);
        $this->insert('{{%region}}',['id'=>'82','pid'=>'76','shortname'=>'抚宁','name'=>'抚宁县','merger_name'=>'中国,河北省,秦皇岛市,抚宁县','level'=>'3','pinyin'=>'funing','code'=>'0335','zip_code'=>'066300','first'=>'F','lng'=>'119.24487','lat'=>'39.87538']);
        $this->insert('{{%region}}',['id'=>'83','pid'=>'76','shortname'=>'卢龙','name'=>'卢龙县','merger_name'=>'中国,河北省,秦皇岛市,卢龙县','level'=>'3','pinyin'=>'lulong','code'=>'0335','zip_code'=>'066400','first'=>'L','lng'=>'118.89288','lat'=>'39.89176']);
        $this->insert('{{%region}}',['id'=>'84','pid'=>'37','shortname'=>'邯郸','name'=>'邯郸市','merger_name'=>'中国,河北省,邯郸市','level'=>'2','pinyin'=>'handan','code'=>'0310','zip_code'=>'056002','first'=>'H','lng'=>'114.490686','lat'=>'36.612273']);
        $this->insert('{{%region}}',['id'=>'85','pid'=>'84','shortname'=>'邯山','name'=>'邯山区','merger_name'=>'中国,河北省,邯郸市,邯山区','level'=>'3','pinyin'=>'hanshan','code'=>'0310','zip_code'=>'056001','first'=>'H','lng'=>'114.48375','lat'=>'36.60006']);
        $this->insert('{{%region}}',['id'=>'86','pid'=>'84','shortname'=>'丛台','name'=>'丛台区','merger_name'=>'中国,河北省,邯郸市,丛台区','level'=>'3','pinyin'=>'congtai','code'=>'0310','zip_code'=>'056002','first'=>'C','lng'=>'114.49343','lat'=>'36.61847']);
        $this->insert('{{%region}}',['id'=>'87','pid'=>'84','shortname'=>'复兴','name'=>'复兴区','merger_name'=>'中国,河北省,邯郸市,复兴区','level'=>'3','pinyin'=>'fuxing','code'=>'0310','zip_code'=>'056003','first'=>'F','lng'=>'114.45928','lat'=>'36.61134']);
        $this->insert('{{%region}}',['id'=>'88','pid'=>'84','shortname'=>'峰峰矿区','name'=>'峰峰矿区','merger_name'=>'中国,河北省,邯郸市,峰峰矿区','level'=>'3','pinyin'=>'fengfengkuangqu','code'=>'0310','zip_code'=>'056200','first'=>'F','lng'=>'114.21148','lat'=>'36.41937']);
        $this->insert('{{%region}}',['id'=>'89','pid'=>'84','shortname'=>'邯郸','name'=>'邯郸县','merger_name'=>'中国,河北省,邯郸市,邯郸县','level'=>'3','pinyin'=>'handan','code'=>'0310','zip_code'=>'056101','first'=>'H','lng'=>'114.53103','lat'=>'36.59385']);
        $this->insert('{{%region}}',['id'=>'90','pid'=>'84','shortname'=>'临漳','name'=>'临漳县','merger_name'=>'中国,河北省,邯郸市,临漳县','level'=>'3','pinyin'=>'linzhang','code'=>'0310','zip_code'=>'056600','first'=>'L','lng'=>'114.6195','lat'=>'36.33461']);
        $this->insert('{{%region}}',['id'=>'91','pid'=>'84','shortname'=>'成安','name'=>'成安县','merger_name'=>'中国,河北省,邯郸市,成安县','level'=>'3','pinyin'=>'cheng\'an','code'=>'0310','zip_code'=>'056700','first'=>'C','lng'=>'114.66995','lat'=>'36.44411']);
        $this->insert('{{%region}}',['id'=>'92','pid'=>'84','shortname'=>'大名','name'=>'大名县','merger_name'=>'中国,河北省,邯郸市,大名县','level'=>'3','pinyin'=>'daming','code'=>'0310','zip_code'=>'056900','first'=>'D','lng'=>'115.15362','lat'=>'36.27994']);
        $this->insert('{{%region}}',['id'=>'93','pid'=>'84','shortname'=>'涉县','name'=>'涉县','merger_name'=>'中国,河北省,邯郸市,涉县','level'=>'3','pinyin'=>'shexian','code'=>'0310','zip_code'=>'056400','first'=>'S','lng'=>'113.69183','lat'=>'36.58072']);
        $this->insert('{{%region}}',['id'=>'94','pid'=>'84','shortname'=>'磁县','name'=>'磁县','merger_name'=>'中国,河北省,邯郸市,磁县','level'=>'3','pinyin'=>'cixian','code'=>'0310','zip_code'=>'056500','first'=>'C','lng'=>'114.37387','lat'=>'36.37392']);
        $this->insert('{{%region}}',['id'=>'95','pid'=>'84','shortname'=>'肥乡','name'=>'肥乡县','merger_name'=>'中国,河北省,邯郸市,肥乡县','level'=>'3','pinyin'=>'feixiang','code'=>'0310','zip_code'=>'057550','first'=>'F','lng'=>'114.79998','lat'=>'36.54807']);
        $this->insert('{{%region}}',['id'=>'96','pid'=>'84','shortname'=>'永年','name'=>'永年县','merger_name'=>'中国,河北省,邯郸市,永年县','level'=>'3','pinyin'=>'yongnian','code'=>'0310','zip_code'=>'057150','first'=>'Y','lng'=>'114.48925','lat'=>'36.78356']);
        $this->insert('{{%region}}',['id'=>'97','pid'=>'84','shortname'=>'邱县','name'=>'邱县','merger_name'=>'中国,河北省,邯郸市,邱县','level'=>'3','pinyin'=>'qiuxian','code'=>'0310','zip_code'=>'057450','first'=>'Q','lng'=>'115.17407','lat'=>'36.82082']);
        $this->insert('{{%region}}',['id'=>'98','pid'=>'84','shortname'=>'鸡泽','name'=>'鸡泽县','merger_name'=>'中国,河北省,邯郸市,鸡泽县','level'=>'3','pinyin'=>'jize','code'=>'0310','zip_code'=>'057350','first'=>'J','lng'=>'114.8742','lat'=>'36.92374']);
        $this->insert('{{%region}}',['id'=>'99','pid'=>'84','shortname'=>'广平','name'=>'广平县','merger_name'=>'中国,河北省,邯郸市,广平县','level'=>'3','pinyin'=>'guangping','code'=>'0310','zip_code'=>'057650','first'=>'G','lng'=>'114.94653','lat'=>'36.48046']);
        $this->insert('{{%region}}',['id'=>'100','pid'=>'84','shortname'=>'馆陶','name'=>'馆陶县','merger_name'=>'中国,河北省,邯郸市,馆陶县','level'=>'3','pinyin'=>'guantao','code'=>'0310','zip_code'=>'057750','first'=>'G','lng'=>'115.29913','lat'=>'36.53719']);
        $this->insert('{{%region}}',['id'=>'101','pid'=>'84','shortname'=>'魏县','name'=>'魏县','merger_name'=>'中国,河北省,邯郸市,魏县','level'=>'3','pinyin'=>'weixian','code'=>'0310','zip_code'=>'056800','first'=>'W','lng'=>'114.93518','lat'=>'36.36171']);
        $this->insert('{{%region}}',['id'=>'102','pid'=>'84','shortname'=>'曲周','name'=>'曲周县','merger_name'=>'中国,河北省,邯郸市,曲周县','level'=>'3','pinyin'=>'quzhou','code'=>'0310','zip_code'=>'057250','first'=>'Q','lng'=>'114.95196','lat'=>'36.77671']);
        $this->insert('{{%region}}',['id'=>'103','pid'=>'84','shortname'=>'武安','name'=>'武安市','merger_name'=>'中国,河北省,邯郸市,武安市','level'=>'3','pinyin'=>'wu\'an','code'=>'0310','zip_code'=>'056300','first'=>'W','lng'=>'114.20153','lat'=>'36.69281']);
        $this->insert('{{%region}}',['id'=>'104','pid'=>'37','shortname'=>'邢台','name'=>'邢台市','merger_name'=>'中国,河北省,邢台市','level'=>'2','pinyin'=>'xingtai','code'=>'0319','zip_code'=>'054001','first'=>'X','lng'=>'114.508851','lat'=>'37.0682']);
        $this->insert('{{%region}}',['id'=>'105','pid'=>'104','shortname'=>'桥东','name'=>'桥东区','merger_name'=>'中国,河北省,邢台市,桥东区','level'=>'3','pinyin'=>'qiaodong','code'=>'0319','zip_code'=>'054001','first'=>'Q','lng'=>'114.50725','lat'=>'37.06801']);
        $this->insert('{{%region}}',['id'=>'106','pid'=>'104','shortname'=>'桥西','name'=>'桥西区','merger_name'=>'中国,河北省,邢台市,桥西区','level'=>'3','pinyin'=>'qiaoxi','code'=>'0319','zip_code'=>'054000','first'=>'Q','lng'=>'114.46803','lat'=>'37.05984']);
        $this->insert('{{%region}}',['id'=>'107','pid'=>'104','shortname'=>'邢台','name'=>'邢台县','merger_name'=>'中国,河北省,邢台市,邢台县','level'=>'3','pinyin'=>'xingtai','code'=>'0319','zip_code'=>'054001','first'=>'X','lng'=>'114.56575','lat'=>'37.0456']);
        $this->insert('{{%region}}',['id'=>'108','pid'=>'104','shortname'=>'临城','name'=>'临城县','merger_name'=>'中国,河北省,邢台市,临城县','level'=>'3','pinyin'=>'lincheng','code'=>'0319','zip_code'=>'054300','first'=>'L','lng'=>'114.50387','lat'=>'37.43977']);
        $this->insert('{{%region}}',['id'=>'109','pid'=>'104','shortname'=>'内丘','name'=>'内丘县','merger_name'=>'中国,河北省,邢台市,内丘县','level'=>'3','pinyin'=>'neiqiu','code'=>'0319','zip_code'=>'054200','first'=>'N','lng'=>'114.51212','lat'=>'37.28671']);
        $this->insert('{{%region}}',['id'=>'110','pid'=>'104','shortname'=>'柏乡','name'=>'柏乡县','merger_name'=>'中国,河北省,邢台市,柏乡县','level'=>'3','pinyin'=>'baixiang','code'=>'0319','zip_code'=>'055450','first'=>'B','lng'=>'114.69332','lat'=>'37.48242']);
        $this->insert('{{%region}}',['id'=>'111','pid'=>'104','shortname'=>'隆尧','name'=>'隆尧县','merger_name'=>'中国,河北省,邢台市,隆尧县','level'=>'3','pinyin'=>'longyao','code'=>'0319','zip_code'=>'055350','first'=>'L','lng'=>'114.77615','lat'=>'37.35351']);
        $this->insert('{{%region}}',['id'=>'112','pid'=>'104','shortname'=>'任县','name'=>'任县','merger_name'=>'中国,河北省,邢台市,任县','level'=>'3','pinyin'=>'renxian','code'=>'0319','zip_code'=>'055150','first'=>'R','lng'=>'114.6842','lat'=>'37.12575']);
        $this->insert('{{%region}}',['id'=>'113','pid'=>'104','shortname'=>'南和','name'=>'南和县','merger_name'=>'中国,河北省,邢台市,南和县','level'=>'3','pinyin'=>'nanhe','code'=>'0319','zip_code'=>'054400','first'=>'N','lng'=>'114.68371','lat'=>'37.00488']);
        $this->insert('{{%region}}',['id'=>'114','pid'=>'104','shortname'=>'宁晋','name'=>'宁晋县','merger_name'=>'中国,河北省,邢台市,宁晋县','level'=>'3','pinyin'=>'ningjin','code'=>'0319','zip_code'=>'055550','first'=>'N','lng'=>'114.92117','lat'=>'37.61696']);
        $this->insert('{{%region}}',['id'=>'115','pid'=>'104','shortname'=>'巨鹿','name'=>'巨鹿县','merger_name'=>'中国,河北省,邢台市,巨鹿县','level'=>'3','pinyin'=>'julu','code'=>'0319','zip_code'=>'055250','first'=>'J','lng'=>'115.03524','lat'=>'37.21801']);
        $this->insert('{{%region}}',['id'=>'116','pid'=>'104','shortname'=>'新河','name'=>'新河县','merger_name'=>'中国,河北省,邢台市,新河县','level'=>'3','pinyin'=>'xinhe','code'=>'0319','zip_code'=>'055650','first'=>'X','lng'=>'115.24987','lat'=>'37.52718']);
        $this->insert('{{%region}}',['id'=>'117','pid'=>'104','shortname'=>'广宗','name'=>'广宗县','merger_name'=>'中国,河北省,邢台市,广宗县','level'=>'3','pinyin'=>'guangzong','code'=>'0319','zip_code'=>'054600','first'=>'G','lng'=>'115.14254','lat'=>'37.0746']);
        $this->insert('{{%region}}',['id'=>'118','pid'=>'104','shortname'=>'平乡','name'=>'平乡县','merger_name'=>'中国,河北省,邢台市,平乡县','level'=>'3','pinyin'=>'pingxiang','code'=>'0319','zip_code'=>'054500','first'=>'P','lng'=>'115.03002','lat'=>'37.06317']);
        $this->insert('{{%region}}',['id'=>'119','pid'=>'104','shortname'=>'威县','name'=>'威县','merger_name'=>'中国,河北省,邢台市,威县','level'=>'3','pinyin'=>'weixian','code'=>'0319','zip_code'=>'054700','first'=>'W','lng'=>'115.2637','lat'=>'36.9768']);
        $this->insert('{{%region}}',['id'=>'120','pid'=>'104','shortname'=>'清河','name'=>'清河县','merger_name'=>'中国,河北省,邢台市,清河县','level'=>'3','pinyin'=>'qinghe','code'=>'0319','zip_code'=>'054800','first'=>'Q','lng'=>'115.66479','lat'=>'37.07122']);
        $this->insert('{{%region}}',['id'=>'121','pid'=>'104','shortname'=>'临西','name'=>'临西县','merger_name'=>'中国,河北省,邢台市,临西县','level'=>'3','pinyin'=>'linxi','code'=>'0319','zip_code'=>'054900','first'=>'L','lng'=>'115.50097','lat'=>'36.87078']);
        $this->insert('{{%region}}',['id'=>'122','pid'=>'104','shortname'=>'南宫','name'=>'南宫市','merger_name'=>'中国,河北省,邢台市,南宫市','level'=>'3','pinyin'=>'nangong','code'=>'0319','zip_code'=>'055750','first'=>'N','lng'=>'115.39068','lat'=>'37.35799']);
        $this->insert('{{%region}}',['id'=>'123','pid'=>'104','shortname'=>'沙河','name'=>'沙河市','merger_name'=>'中国,河北省,邢台市,沙河市','level'=>'3','pinyin'=>'shahe','code'=>'0319','zip_code'=>'054100','first'=>'S','lng'=>'114.4981','lat'=>'36.8577']);
        $this->insert('{{%region}}',['id'=>'124','pid'=>'37','shortname'=>'保定','name'=>'保定市','merger_name'=>'中国,河北省,保定市','level'=>'2','pinyin'=>'baoding','code'=>'0312','zip_code'=>'071052','first'=>'B','lng'=>'115.482331','lat'=>'38.867657']);
        $this->insert('{{%region}}',['id'=>'125','pid'=>'124','shortname'=>'新市','name'=>'新市区','merger_name'=>'中国,河北省,保定市,新市区','level'=>'3','pinyin'=>'xinshi','code'=>'0312','zip_code'=>'071051','first'=>'X','lng'=>'115.4587','lat'=>'38.87751']);
        $this->insert('{{%region}}',['id'=>'126','pid'=>'124','shortname'=>'北市','name'=>'北市区','merger_name'=>'中国,河北省,保定市,北市区','level'=>'3','pinyin'=>'beishi','code'=>'0312','zip_code'=>'071000','first'=>'B','lng'=>'115.49715','lat'=>'38.88322']);
        $this->insert('{{%region}}',['id'=>'127','pid'=>'124','shortname'=>'南市','name'=>'南市区','merger_name'=>'中国,河北省,保定市,南市区','level'=>'3','pinyin'=>'nanshi','code'=>'0312','zip_code'=>'071001','first'=>'N','lng'=>'115.52859','lat'=>'38.85455']);
        $this->insert('{{%region}}',['id'=>'128','pid'=>'124','shortname'=>'满城','name'=>'满城县','merger_name'=>'中国,河北省,保定市,满城县','level'=>'3','pinyin'=>'mancheng','code'=>'0312','zip_code'=>'072150','first'=>'M','lng'=>'115.32296','lat'=>'38.94972']);
        $this->insert('{{%region}}',['id'=>'129','pid'=>'124','shortname'=>'清苑','name'=>'清苑县','merger_name'=>'中国,河北省,保定市,清苑县','level'=>'3','pinyin'=>'qingyuan','code'=>'0312','zip_code'=>'071100','first'=>'Q','lng'=>'115.49267','lat'=>'38.76709']);
        $this->insert('{{%region}}',['id'=>'130','pid'=>'124','shortname'=>'涞水','name'=>'涞水县','merger_name'=>'中国,河北省,保定市,涞水县','level'=>'3','pinyin'=>'laishui','code'=>'0312','zip_code'=>'074100','first'=>NULL,'lng'=>'115.71517','lat'=>'39.39404']);
        $this->insert('{{%region}}',['id'=>'131','pid'=>'124','shortname'=>'阜平','name'=>'阜平县','merger_name'=>'中国,河北省,保定市,阜平县','level'=>'3','pinyin'=>'fuping','code'=>'0312','zip_code'=>'073200','first'=>'F','lng'=>'114.19683','lat'=>'38.84763']);
        $this->insert('{{%region}}',['id'=>'132','pid'=>'124','shortname'=>'徐水','name'=>'徐水县','merger_name'=>'中国,河北省,保定市,徐水县','level'=>'3','pinyin'=>'xushui','code'=>'0312','zip_code'=>'072550','first'=>'X','lng'=>'115.65829','lat'=>'39.02099']);
        $this->insert('{{%region}}',['id'=>'133','pid'=>'124','shortname'=>'定兴','name'=>'定兴县','merger_name'=>'中国,河北省,保定市,定兴县','level'=>'3','pinyin'=>'dingxing','code'=>'0312','zip_code'=>'072650','first'=>'D','lng'=>'115.80786','lat'=>'39.26312']);
        $this->insert('{{%region}}',['id'=>'134','pid'=>'124','shortname'=>'唐县','name'=>'唐县','merger_name'=>'中国,河北省,保定市,唐县','level'=>'3','pinyin'=>'tangxian','code'=>'0312','zip_code'=>'072350','first'=>'T','lng'=>'114.98516','lat'=>'38.74513']);
        $this->insert('{{%region}}',['id'=>'135','pid'=>'124','shortname'=>'高阳','name'=>'高阳县','merger_name'=>'中国,河北省,保定市,高阳县','level'=>'3','pinyin'=>'gaoyang','code'=>'0312','zip_code'=>'071500','first'=>'G','lng'=>'115.7788','lat'=>'38.70003']);
        $this->insert('{{%region}}',['id'=>'136','pid'=>'124','shortname'=>'容城','name'=>'容城县','merger_name'=>'中国,河北省,保定市,容城县','level'=>'3','pinyin'=>'rongcheng','code'=>'0312','zip_code'=>'071700','first'=>'R','lng'=>'115.87158','lat'=>'39.0535']);
        $this->insert('{{%region}}',['id'=>'137','pid'=>'124','shortname'=>'涞源','name'=>'涞源县','merger_name'=>'中国,河北省,保定市,涞源县','level'=>'3','pinyin'=>'laiyuan','code'=>'0312','zip_code'=>'074300','first'=>NULL,'lng'=>'114.69128','lat'=>'39.35388']);
        $this->insert('{{%region}}',['id'=>'138','pid'=>'124','shortname'=>'望都','name'=>'望都县','merger_name'=>'中国,河北省,保定市,望都县','level'=>'3','pinyin'=>'wangdu','code'=>'0312','zip_code'=>'072450','first'=>'W','lng'=>'115.1567','lat'=>'38.70996']);
        $this->insert('{{%region}}',['id'=>'139','pid'=>'124','shortname'=>'安新','name'=>'安新县','merger_name'=>'中国,河北省,保定市,安新县','level'=>'3','pinyin'=>'anxin','code'=>'0312','zip_code'=>'071600','first'=>'A','lng'=>'115.93557','lat'=>'38.93532']);
        $this->insert('{{%region}}',['id'=>'140','pid'=>'124','shortname'=>'易县','name'=>'易县','merger_name'=>'中国,河北省,保定市,易县','level'=>'3','pinyin'=>'yixian','code'=>'0312','zip_code'=>'074200','first'=>'Y','lng'=>'115.4981','lat'=>'39.34885']);
        $this->insert('{{%region}}',['id'=>'141','pid'=>'124','shortname'=>'曲阳','name'=>'曲阳县','merger_name'=>'中国,河北省,保定市,曲阳县','level'=>'3','pinyin'=>'quyang','code'=>'0312','zip_code'=>'073100','first'=>'Q','lng'=>'114.70123','lat'=>'38.62154']);
        $this->insert('{{%region}}',['id'=>'142','pid'=>'124','shortname'=>'蠡县','name'=>'蠡县','merger_name'=>'中国,河北省,保定市,蠡县','level'=>'3','pinyin'=>'lixian','code'=>'0312','zip_code'=>'071400','first'=>NULL,'lng'=>'115.57717','lat'=>'38.48974']);
        $this->insert('{{%region}}',['id'=>'143','pid'=>'124','shortname'=>'顺平','name'=>'顺平县','merger_name'=>'中国,河北省,保定市,顺平县','level'=>'3','pinyin'=>'shunping','code'=>'0312','zip_code'=>'072250','first'=>'S','lng'=>'115.1347','lat'=>'38.83854']);
        $this->insert('{{%region}}',['id'=>'144','pid'=>'124','shortname'=>'博野','name'=>'博野县','merger_name'=>'中国,河北省,保定市,博野县','level'=>'3','pinyin'=>'boye','code'=>'0312','zip_code'=>'071300','first'=>'B','lng'=>'115.47033','lat'=>'38.4564']);
        $this->insert('{{%region}}',['id'=>'145','pid'=>'124','shortname'=>'雄县','name'=>'雄县','merger_name'=>'中国,河北省,保定市,雄县','level'=>'3','pinyin'=>'xiongxian','code'=>'0312','zip_code'=>'071800','first'=>'X','lng'=>'116.10873','lat'=>'38.99442']);
        $this->insert('{{%region}}',['id'=>'146','pid'=>'124','shortname'=>'涿州','name'=>'涿州市','merger_name'=>'中国,河北省,保定市,涿州市','level'=>'3','pinyin'=>'zhuozhou','code'=>'0312','zip_code'=>'072750','first'=>NULL,'lng'=>'115.98062','lat'=>'39.48622']);
        $this->insert('{{%region}}',['id'=>'147','pid'=>'124','shortname'=>'定州','name'=>'定州市','merger_name'=>'中国,河北省,保定市,定州市','level'=>'3','pinyin'=>'dingzhou','code'=>'0312','zip_code'=>'073000','first'=>'D','lng'=>'114.9902','lat'=>'38.51623']);
        $this->insert('{{%region}}',['id'=>'148','pid'=>'124','shortname'=>'安国','name'=>'安国市','merger_name'=>'中国,河北省,保定市,安国市','level'=>'3','pinyin'=>'anguo','code'=>'0312','zip_code'=>'071200','first'=>'A','lng'=>'115.32321','lat'=>'38.41391']);
        $this->insert('{{%region}}',['id'=>'149','pid'=>'124','shortname'=>'高碑店','name'=>'高碑店市','merger_name'=>'中国,河北省,保定市,高碑店市','level'=>'3','pinyin'=>'gaobeidian','code'=>'0312','zip_code'=>'074000','first'=>'G','lng'=>'115.87368','lat'=>'39.32655']);
        $this->insert('{{%region}}',['id'=>'150','pid'=>'37','shortname'=>'张家口','name'=>'张家口市','merger_name'=>'中国,河北省,张家口市','level'=>'2','pinyin'=>'zhangjiakou','code'=>'0313','zip_code'=>'075000','first'=>'Z','lng'=>'114.884091','lat'=>'40.811901']);
        $this->insert('{{%region}}',['id'=>'151','pid'=>'150','shortname'=>'桥东','name'=>'桥东区','merger_name'=>'中国,河北省,张家口市,桥东区','level'=>'3','pinyin'=>'qiaodong','code'=>'0313','zip_code'=>'075000','first'=>'Q','lng'=>'114.8943','lat'=>'40.78844']);
        $this->insert('{{%region}}',['id'=>'152','pid'=>'150','shortname'=>'桥西','name'=>'桥西区','merger_name'=>'中国,河北省,张家口市,桥西区','level'=>'3','pinyin'=>'qiaoxi','code'=>'0313','zip_code'=>'075061','first'=>'Q','lng'=>'114.86962','lat'=>'40.81945']);
        $this->insert('{{%region}}',['id'=>'153','pid'=>'150','shortname'=>'宣化','name'=>'宣化区','merger_name'=>'中国,河北省,张家口市,宣化区','level'=>'3','pinyin'=>'xuanhua','code'=>'0313','zip_code'=>'075100','first'=>'X','lng'=>'115.06543','lat'=>'40.60957']);
        $this->insert('{{%region}}',['id'=>'154','pid'=>'150','shortname'=>'下花园','name'=>'下花园区','merger_name'=>'中国,河北省,张家口市,下花园区','level'=>'3','pinyin'=>'xiahuayuan','code'=>'0313','zip_code'=>'075300','first'=>'X','lng'=>'115.28744','lat'=>'40.50236']);
        $this->insert('{{%region}}',['id'=>'155','pid'=>'150','shortname'=>'宣化','name'=>'宣化县','merger_name'=>'中国,河北省,张家口市,宣化县','level'=>'3','pinyin'=>'xuanhua','code'=>'0313','zip_code'=>'075100','first'=>'X','lng'=>'115.15497','lat'=>'40.56618']);
        $this->insert('{{%region}}',['id'=>'156','pid'=>'150','shortname'=>'张北','name'=>'张北县','merger_name'=>'中国,河北省,张家口市,张北县','level'=>'3','pinyin'=>'zhangbei','code'=>'0313','zip_code'=>'076450','first'=>'Z','lng'=>'114.71432','lat'=>'41.15977']);
        $this->insert('{{%region}}',['id'=>'157','pid'=>'150','shortname'=>'康保','name'=>'康保县','merger_name'=>'中国,河北省,张家口市,康保县','level'=>'3','pinyin'=>'kangbao','code'=>'0313','zip_code'=>'076650','first'=>'K','lng'=>'114.60031','lat'=>'41.85225']);
        $this->insert('{{%region}}',['id'=>'158','pid'=>'150','shortname'=>'沽源','name'=>'沽源县','merger_name'=>'中国,河北省,张家口市,沽源县','level'=>'3','pinyin'=>'guyuan','code'=>'0313','zip_code'=>'076550','first'=>'G','lng'=>'115.68859','lat'=>'41.66959']);
        $this->insert('{{%region}}',['id'=>'159','pid'=>'150','shortname'=>'尚义','name'=>'尚义县','merger_name'=>'中国,河北省,张家口市,尚义县','level'=>'3','pinyin'=>'shangyi','code'=>'0313','zip_code'=>'076750','first'=>'S','lng'=>'113.97134','lat'=>'41.07782']);
        $this->insert('{{%region}}',['id'=>'160','pid'=>'150','shortname'=>'蔚县','name'=>'蔚县','merger_name'=>'中国,河北省,张家口市,蔚县','level'=>'3','pinyin'=>'yuxian','code'=>'0313','zip_code'=>'075700','first'=>'W','lng'=>'114.58892','lat'=>'39.84067']);
        $this->insert('{{%region}}',['id'=>'161','pid'=>'150','shortname'=>'阳原','name'=>'阳原县','merger_name'=>'中国,河北省,张家口市,阳原县','level'=>'3','pinyin'=>'yangyuan','code'=>'0313','zip_code'=>'075800','first'=>'Y','lng'=>'114.15051','lat'=>'40.10361']);
        $this->insert('{{%region}}',['id'=>'162','pid'=>'150','shortname'=>'怀安','name'=>'怀安县','merger_name'=>'中国,河北省,张家口市,怀安县','level'=>'3','pinyin'=>'huai\'an','code'=>'0313','zip_code'=>'076150','first'=>'H','lng'=>'114.38559','lat'=>'40.67425']);
        $this->insert('{{%region}}',['id'=>'163','pid'=>'150','shortname'=>'万全','name'=>'万全县','merger_name'=>'中国,河北省,张家口市,万全县','level'=>'3','pinyin'=>'wanquan','code'=>'0313','zip_code'=>'076250','first'=>'W','lng'=>'114.7405','lat'=>'40.76694']);
        $this->insert('{{%region}}',['id'=>'164','pid'=>'150','shortname'=>'怀来','name'=>'怀来县','merger_name'=>'中国,河北省,张家口市,怀来县','level'=>'3','pinyin'=>'huailai','code'=>'0313','zip_code'=>'075400','first'=>'H','lng'=>'115.51773','lat'=>'40.41536']);
        $this->insert('{{%region}}',['id'=>'165','pid'=>'150','shortname'=>'涿鹿','name'=>'涿鹿县','merger_name'=>'中国,河北省,张家口市,涿鹿县','level'=>'3','pinyin'=>'zhuolu','code'=>'0313','zip_code'=>'075600','first'=>NULL,'lng'=>'115.22403','lat'=>'40.37636']);
        $this->insert('{{%region}}',['id'=>'166','pid'=>'150','shortname'=>'赤城','name'=>'赤城县','merger_name'=>'中国,河北省,张家口市,赤城县','level'=>'3','pinyin'=>'chicheng','code'=>'0313','zip_code'=>'075500','first'=>'C','lng'=>'115.83187','lat'=>'40.91438']);
        $this->insert('{{%region}}',['id'=>'167','pid'=>'150','shortname'=>'崇礼','name'=>'崇礼县','merger_name'=>'中国,河北省,张家口市,崇礼县','level'=>'3','pinyin'=>'chongli','code'=>'0313','zip_code'=>'076350','first'=>'C','lng'=>'115.27993','lat'=>'40.97519']);
        $this->insert('{{%region}}',['id'=>'168','pid'=>'37','shortname'=>'承德','name'=>'承德市','merger_name'=>'中国,河北省,承德市','level'=>'2','pinyin'=>'chengde','code'=>'0314','zip_code'=>'067000','first'=>'C','lng'=>'117.939152','lat'=>'40.976204']);
        $this->insert('{{%region}}',['id'=>'169','pid'=>'168','shortname'=>'双桥','name'=>'双桥区','merger_name'=>'中国,河北省,承德市,双桥区','level'=>'3','pinyin'=>'shuangqiao','code'=>'0314','zip_code'=>'067000','first'=>'S','lng'=>'117.9432','lat'=>'40.97466']);
        $this->insert('{{%region}}',['id'=>'170','pid'=>'168','shortname'=>'双滦','name'=>'双滦区','merger_name'=>'中国,河北省,承德市,双滦区','level'=>'3','pinyin'=>'shuangluan','code'=>'0314','zip_code'=>'067001','first'=>'S','lng'=>'117.74487','lat'=>'40.95375']);
        $this->insert('{{%region}}',['id'=>'171','pid'=>'168','shortname'=>'鹰手营子矿区','name'=>'鹰手营子矿区','merger_name'=>'中国,河北省,承德市,鹰手营子矿区','level'=>'3','pinyin'=>'yingshouyingzikuangqu','code'=>'0314','zip_code'=>'067200','first'=>'Y','lng'=>'117.65985','lat'=>'40.54744']);
        $this->insert('{{%region}}',['id'=>'172','pid'=>'168','shortname'=>'承德','name'=>'承德县','merger_name'=>'中国,河北省,承德市,承德县','level'=>'3','pinyin'=>'chengde','code'=>'0314','zip_code'=>'067400','first'=>'C','lng'=>'118.17639','lat'=>'40.76985']);
        $this->insert('{{%region}}',['id'=>'173','pid'=>'168','shortname'=>'兴隆','name'=>'兴隆县','merger_name'=>'中国,河北省,承德市,兴隆县','level'=>'3','pinyin'=>'xinglong','code'=>'0314','zip_code'=>'067300','first'=>'X','lng'=>'117.50073','lat'=>'40.41709']);
        $this->insert('{{%region}}',['id'=>'174','pid'=>'168','shortname'=>'平泉','name'=>'平泉县','merger_name'=>'中国,河北省,承德市,平泉县','level'=>'3','pinyin'=>'pingquan','code'=>'0314','zip_code'=>'067500','first'=>'P','lng'=>'118.70196','lat'=>'41.01839']);
        $this->insert('{{%region}}',['id'=>'175','pid'=>'168','shortname'=>'滦平','name'=>'滦平县','merger_name'=>'中国,河北省,承德市,滦平县','level'=>'3','pinyin'=>'luanping','code'=>'0314','zip_code'=>'068250','first'=>'L','lng'=>'117.33276','lat'=>'40.94148']);
        $this->insert('{{%region}}',['id'=>'176','pid'=>'168','shortname'=>'隆化','name'=>'隆化县','merger_name'=>'中国,河北省,承德市,隆化县','level'=>'3','pinyin'=>'longhua','code'=>'0314','zip_code'=>'068150','first'=>'L','lng'=>'117.7297','lat'=>'41.31412']);
        $this->insert('{{%region}}',['id'=>'177','pid'=>'168','shortname'=>'丰宁','name'=>'丰宁满族自治县','merger_name'=>'中国,河北省,承德市,丰宁满族自治县','level'=>'3','pinyin'=>'fengning','code'=>'0314','zip_code'=>'068350','first'=>'F','lng'=>'116.6492','lat'=>'41.20481']);
        $this->insert('{{%region}}',['id'=>'178','pid'=>'168','shortname'=>'宽城','name'=>'宽城满族自治县','merger_name'=>'中国,河北省,承德市,宽城满族自治县','level'=>'3','pinyin'=>'kuancheng','code'=>'0314','zip_code'=>'067600','first'=>'K','lng'=>'118.49176','lat'=>'40.60829']);
        $this->insert('{{%region}}',['id'=>'179','pid'=>'168','shortname'=>'围场','name'=>'围场满族蒙古族自治县','merger_name'=>'中国,河北省,承德市,围场满族蒙古族自治县','level'=>'3','pinyin'=>'weichang','code'=>'0314','zip_code'=>'068450','first'=>'W','lng'=>'117.7601','lat'=>'41.94368']);
        $this->insert('{{%region}}',['id'=>'180','pid'=>'37','shortname'=>'沧州','name'=>'沧州市','merger_name'=>'中国,河北省,沧州市','level'=>'2','pinyin'=>'cangzhou','code'=>'0317','zip_code'=>'061001','first'=>'C','lng'=>'116.857461','lat'=>'38.310582']);
        $this->insert('{{%region}}',['id'=>'181','pid'=>'180','shortname'=>'新华','name'=>'新华区','merger_name'=>'中国,河北省,沧州市,新华区','level'=>'3','pinyin'=>'xinhua','code'=>'0317','zip_code'=>'061000','first'=>'X','lng'=>'116.86643','lat'=>'38.31438']);
        $this->insert('{{%region}}',['id'=>'182','pid'=>'180','shortname'=>'运河','name'=>'运河区','merger_name'=>'中国,河北省,沧州市,运河区','level'=>'3','pinyin'=>'yunhe','code'=>'0317','zip_code'=>'061001','first'=>'Y','lng'=>'116.85706','lat'=>'38.31352']);
        $this->insert('{{%region}}',['id'=>'183','pid'=>'180','shortname'=>'沧县','name'=>'沧县','merger_name'=>'中国,河北省,沧州市,沧县','level'=>'3','pinyin'=>'cangxian','code'=>'0317','zip_code'=>'061000','first'=>'C','lng'=>'116.87817','lat'=>'38.29361']);
        $this->insert('{{%region}}',['id'=>'184','pid'=>'180','shortname'=>'青县','name'=>'青县','merger_name'=>'中国,河北省,沧州市,青县','level'=>'3','pinyin'=>'qingxian','code'=>'0317','zip_code'=>'062650','first'=>'Q','lng'=>'116.80316','lat'=>'38.58345']);
        $this->insert('{{%region}}',['id'=>'185','pid'=>'180','shortname'=>'东光','name'=>'东光县','merger_name'=>'中国,河北省,沧州市,东光县','level'=>'3','pinyin'=>'dongguang','code'=>'0317','zip_code'=>'061600','first'=>'D','lng'=>'116.53668','lat'=>'37.8857']);
        $this->insert('{{%region}}',['id'=>'186','pid'=>'180','shortname'=>'海兴','name'=>'海兴县','merger_name'=>'中国,河北省,沧州市,海兴县','level'=>'3','pinyin'=>'haixing','code'=>'0317','zip_code'=>'061200','first'=>'H','lng'=>'117.49758','lat'=>'38.13958']);
        $this->insert('{{%region}}',['id'=>'187','pid'=>'180','shortname'=>'盐山','name'=>'盐山县','merger_name'=>'中国,河北省,沧州市,盐山县','level'=>'3','pinyin'=>'yanshan','code'=>'0317','zip_code'=>'061300','first'=>'Y','lng'=>'117.23092','lat'=>'38.05647']);
        $this->insert('{{%region}}',['id'=>'188','pid'=>'180','shortname'=>'肃宁','name'=>'肃宁县','merger_name'=>'中国,河北省,沧州市,肃宁县','level'=>'3','pinyin'=>'suning','code'=>'0317','zip_code'=>'062350','first'=>'S','lng'=>'115.82971','lat'=>'38.42272']);
        $this->insert('{{%region}}',['id'=>'189','pid'=>'180','shortname'=>'南皮','name'=>'南皮县','merger_name'=>'中国,河北省,沧州市,南皮县','level'=>'3','pinyin'=>'nanpi','code'=>'0317','zip_code'=>'061500','first'=>'N','lng'=>'116.70224','lat'=>'38.04109']);
        $this->insert('{{%region}}',['id'=>'190','pid'=>'180','shortname'=>'吴桥','name'=>'吴桥县','merger_name'=>'中国,河北省,沧州市,吴桥县','level'=>'3','pinyin'=>'wuqiao','code'=>'0317','zip_code'=>'061800','first'=>'W','lng'=>'116.3847','lat'=>'37.62546']);
        $this->insert('{{%region}}',['id'=>'191','pid'=>'180','shortname'=>'献县','name'=>'献县','merger_name'=>'中国,河北省,沧州市,献县','level'=>'3','pinyin'=>'xianxian','code'=>'0317','zip_code'=>'062250','first'=>'X','lng'=>'116.12695','lat'=>'38.19228']);
        $this->insert('{{%region}}',['id'=>'192','pid'=>'180','shortname'=>'孟村','name'=>'孟村回族自治县','merger_name'=>'中国,河北省,沧州市,孟村回族自治县','level'=>'3','pinyin'=>'mengcun','code'=>'0317','zip_code'=>'061400','first'=>'M','lng'=>'117.10412','lat'=>'38.05338']);
        $this->insert('{{%region}}',['id'=>'193','pid'=>'180','shortname'=>'泊头','name'=>'泊头市','merger_name'=>'中国,河北省,沧州市,泊头市','level'=>'3','pinyin'=>'botou','code'=>'0317','zip_code'=>'062150','first'=>'B','lng'=>'116.57824','lat'=>'38.08359']);
        $this->insert('{{%region}}',['id'=>'194','pid'=>'180','shortname'=>'任丘','name'=>'任丘市','merger_name'=>'中国,河北省,沧州市,任丘市','level'=>'3','pinyin'=>'renqiu','code'=>'0317','zip_code'=>'062550','first'=>'R','lng'=>'116.1033','lat'=>'38.71124']);
        $this->insert('{{%region}}',['id'=>'195','pid'=>'180','shortname'=>'黄骅','name'=>'黄骅市','merger_name'=>'中国,河北省,沧州市,黄骅市','level'=>'3','pinyin'=>'huanghua','code'=>'0317','zip_code'=>'061100','first'=>'H','lng'=>'117.33883','lat'=>'38.3706']);
        $this->insert('{{%region}}',['id'=>'196','pid'=>'180','shortname'=>'河间','name'=>'河间市','merger_name'=>'中国,河北省,沧州市,河间市','level'=>'3','pinyin'=>'hejian','code'=>'0317','zip_code'=>'062450','first'=>'H','lng'=>'116.0993','lat'=>'38.44549']);
        $this->insert('{{%region}}',['id'=>'197','pid'=>'37','shortname'=>'廊坊','name'=>'廊坊市','merger_name'=>'中国,河北省,廊坊市','level'=>'2','pinyin'=>'langfang','code'=>'0316','zip_code'=>'065000','first'=>'L','lng'=>'116.713873','lat'=>'39.529244']);
        $this->insert('{{%region}}',['id'=>'198','pid'=>'197','shortname'=>'安次','name'=>'安次区','merger_name'=>'中国,河北省,廊坊市,安次区','level'=>'3','pinyin'=>'anci','code'=>'0316','zip_code'=>'065000','first'=>'A','lng'=>'116.70308','lat'=>'39.52057']);
        $this->insert('{{%region}}',['id'=>'199','pid'=>'197','shortname'=>'广阳','name'=>'广阳区','merger_name'=>'中国,河北省,廊坊市,广阳区','level'=>'3','pinyin'=>'guangyang','code'=>'0316','zip_code'=>'065000','first'=>'G','lng'=>'116.71069','lat'=>'39.52278']);
        $this->insert('{{%region}}',['id'=>'200','pid'=>'197','shortname'=>'固安','name'=>'固安县','merger_name'=>'中国,河北省,廊坊市,固安县','level'=>'3','pinyin'=>'gu\'an','code'=>'0316','zip_code'=>'065500','first'=>'G','lng'=>'116.29916','lat'=>'39.43833']);
        $this->insert('{{%region}}',['id'=>'201','pid'=>'197','shortname'=>'永清','name'=>'永清县','merger_name'=>'中国,河北省,廊坊市,永清县','level'=>'3','pinyin'=>'yongqing','code'=>'0316','zip_code'=>'065600','first'=>'Y','lng'=>'116.50091','lat'=>'39.32069']);
        $this->insert('{{%region}}',['id'=>'202','pid'=>'197','shortname'=>'香河','name'=>'香河县','merger_name'=>'中国,河北省,廊坊市,香河县','level'=>'3','pinyin'=>'xianghe','code'=>'0316','zip_code'=>'065400','first'=>'X','lng'=>'117.00634','lat'=>'39.76133']);
        $this->insert('{{%region}}',['id'=>'203','pid'=>'197','shortname'=>'大城','name'=>'大城县','merger_name'=>'中国,河北省,廊坊市,大城县','level'=>'3','pinyin'=>'daicheng','code'=>'0316','zip_code'=>'065900','first'=>'D','lng'=>'116.65353','lat'=>'38.70534']);
        $this->insert('{{%region}}',['id'=>'204','pid'=>'197','shortname'=>'文安','name'=>'文安县','merger_name'=>'中国,河北省,廊坊市,文安县','level'=>'3','pinyin'=>'wen\'an','code'=>'0316','zip_code'=>'065800','first'=>'W','lng'=>'116.45846','lat'=>'38.87325']);
        $this->insert('{{%region}}',['id'=>'205','pid'=>'197','shortname'=>'大厂','name'=>'大厂回族自治县','merger_name'=>'中国,河北省,廊坊市,大厂回族自治县','level'=>'3','pinyin'=>'dachang','code'=>'0316','zip_code'=>'065300','first'=>'D','lng'=>'116.98916','lat'=>'39.88649']);
        $this->insert('{{%region}}',['id'=>'206','pid'=>'197','shortname'=>'霸州','name'=>'霸州市','merger_name'=>'中国,河北省,廊坊市,霸州市','level'=>'3','pinyin'=>'bazhou','code'=>'0316','zip_code'=>'065700','first'=>'B','lng'=>'116.39154','lat'=>'39.12569']);
        $this->insert('{{%region}}',['id'=>'207','pid'=>'197','shortname'=>'三河','name'=>'三河市','merger_name'=>'中国,河北省,廊坊市,三河市','level'=>'3','pinyin'=>'sanhe','code'=>'0316','zip_code'=>'065200','first'=>'S','lng'=>'117.07229','lat'=>'39.98358']);
        $this->insert('{{%region}}',['id'=>'208','pid'=>'37','shortname'=>'衡水','name'=>'衡水市','merger_name'=>'中国,河北省,衡水市','level'=>'2','pinyin'=>'hengshui','code'=>'0318','zip_code'=>'053000','first'=>'H','lng'=>'115.665993','lat'=>'37.735097']);
        $this->insert('{{%region}}',['id'=>'209','pid'=>'208','shortname'=>'桃城','name'=>'桃城区','merger_name'=>'中国,河北省,衡水市,桃城区','level'=>'3','pinyin'=>'taocheng','code'=>'0318','zip_code'=>'053000','first'=>'T','lng'=>'115.67529','lat'=>'37.73499']);
        $this->insert('{{%region}}',['id'=>'210','pid'=>'208','shortname'=>'枣强','name'=>'枣强县','merger_name'=>'中国,河北省,衡水市,枣强县','level'=>'3','pinyin'=>'zaoqiang','code'=>'0318','zip_code'=>'053100','first'=>'Z','lng'=>'115.72576','lat'=>'37.51027']);
        $this->insert('{{%region}}',['id'=>'211','pid'=>'208','shortname'=>'武邑','name'=>'武邑县','merger_name'=>'中国,河北省,衡水市,武邑县','level'=>'3','pinyin'=>'wuyi','code'=>'0318','zip_code'=>'053400','first'=>'W','lng'=>'115.88748','lat'=>'37.80181']);
        $this->insert('{{%region}}',['id'=>'212','pid'=>'208','shortname'=>'武强','name'=>'武强县','merger_name'=>'中国,河北省,衡水市,武强县','level'=>'3','pinyin'=>'wuqiang','code'=>'0318','zip_code'=>'053300','first'=>'W','lng'=>'115.98226','lat'=>'38.04138']);
        $this->insert('{{%region}}',['id'=>'213','pid'=>'208','shortname'=>'饶阳','name'=>'饶阳县','merger_name'=>'中国,河北省,衡水市,饶阳县','level'=>'3','pinyin'=>'raoyang','code'=>'0318','zip_code'=>'053900','first'=>'R','lng'=>'115.72558','lat'=>'38.23529']);
        $this->insert('{{%region}}',['id'=>'214','pid'=>'208','shortname'=>'安平','name'=>'安平县','merger_name'=>'中国,河北省,衡水市,安平县','level'=>'3','pinyin'=>'anping','code'=>'0318','zip_code'=>'053600','first'=>'A','lng'=>'115.51876','lat'=>'38.23388']);
        $this->insert('{{%region}}',['id'=>'215','pid'=>'208','shortname'=>'故城','name'=>'故城县','merger_name'=>'中国,河北省,衡水市,故城县','level'=>'3','pinyin'=>'gucheng','code'=>'0318','zip_code'=>'053800','first'=>'G','lng'=>'115.97076','lat'=>'37.34773']);
        $this->insert('{{%region}}',['id'=>'216','pid'=>'208','shortname'=>'景县','name'=>'景县','merger_name'=>'中国,河北省,衡水市,景县','level'=>'3','pinyin'=>'jingxian','code'=>'0318','zip_code'=>'053500','first'=>'J','lng'=>'116.26904','lat'=>'37.6926']);
        $this->insert('{{%region}}',['id'=>'217','pid'=>'208','shortname'=>'阜城','name'=>'阜城县','merger_name'=>'中国,河北省,衡水市,阜城县','level'=>'3','pinyin'=>'fucheng','code'=>'0318','zip_code'=>'053700','first'=>'F','lng'=>'116.14431','lat'=>'37.86881']);
        $this->insert('{{%region}}',['id'=>'218','pid'=>'208','shortname'=>'冀州','name'=>'冀州市','merger_name'=>'中国,河北省,衡水市,冀州市','level'=>'3','pinyin'=>'jizhou','code'=>'0318','zip_code'=>'053200','first'=>'J','lng'=>'115.57934','lat'=>'37.55082']);
        $this->insert('{{%region}}',['id'=>'219','pid'=>'208','shortname'=>'深州','name'=>'深州市','merger_name'=>'中国,河北省,衡水市,深州市','level'=>'3','pinyin'=>'shenzhou','code'=>'0318','zip_code'=>'053800','first'=>'S','lng'=>'115.55993','lat'=>'38.00109']);
        $this->insert('{{%region}}',['id'=>'220','pid'=>'0','shortname'=>'山西','name'=>'山西省','merger_name'=>'中国,山西省','level'=>'1','pinyin'=>'shanxi','code'=>'','zip_code'=>'','first'=>'S','lng'=>'112.549248','lat'=>'37.857014']);
        $this->insert('{{%region}}',['id'=>'221','pid'=>'220','shortname'=>'太原','name'=>'太原市','merger_name'=>'中国,山西省,太原市','level'=>'2','pinyin'=>'taiyuan','code'=>'0351','zip_code'=>'030082','first'=>'T','lng'=>'112.549248','lat'=>'37.857014']);
        $this->insert('{{%region}}',['id'=>'222','pid'=>'221','shortname'=>'小店','name'=>'小店区','merger_name'=>'中国,山西省,太原市,小店区','level'=>'3','pinyin'=>'xiaodian','code'=>'0351','zip_code'=>'030032','first'=>'X','lng'=>'112.56878','lat'=>'37.73565']);
        $this->insert('{{%region}}',['id'=>'223','pid'=>'221','shortname'=>'迎泽','name'=>'迎泽区','merger_name'=>'中国,山西省,太原市,迎泽区','level'=>'3','pinyin'=>'yingze','code'=>'0351','zip_code'=>'030002','first'=>'Y','lng'=>'112.56338','lat'=>'37.86326']);
        $this->insert('{{%region}}',['id'=>'224','pid'=>'221','shortname'=>'杏花岭','name'=>'杏花岭区','merger_name'=>'中国,山西省,太原市,杏花岭区','level'=>'3','pinyin'=>'xinghualing','code'=>'0351','zip_code'=>'030009','first'=>'X','lng'=>'112.56237','lat'=>'37.88429']);
        $this->insert('{{%region}}',['id'=>'225','pid'=>'221','shortname'=>'尖草坪','name'=>'尖草坪区','merger_name'=>'中国,山西省,太原市,尖草坪区','level'=>'3','pinyin'=>'jiancaoping','code'=>'0351','zip_code'=>'030023','first'=>'J','lng'=>'112.48709','lat'=>'37.94193']);
        $this->insert('{{%region}}',['id'=>'226','pid'=>'221','shortname'=>'万柏林','name'=>'万柏林区','merger_name'=>'中国,山西省,太原市,万柏林区','level'=>'3','pinyin'=>'wanbailin','code'=>'0351','zip_code'=>'030024','first'=>'W','lng'=>'112.51553','lat'=>'37.85923']);
        $this->insert('{{%region}}',['id'=>'227','pid'=>'221','shortname'=>'晋源','name'=>'晋源区','merger_name'=>'中国,山西省,太原市,晋源区','level'=>'3','pinyin'=>'jinyuan','code'=>'0351','zip_code'=>'030025','first'=>'J','lng'=>'112.47985','lat'=>'37.72479']);
        $this->insert('{{%region}}',['id'=>'228','pid'=>'221','shortname'=>'清徐','name'=>'清徐县','merger_name'=>'中国,山西省,太原市,清徐县','level'=>'3','pinyin'=>'qingxu','code'=>'0351','zip_code'=>'030400','first'=>'Q','lng'=>'112.35888','lat'=>'37.60758']);
        $this->insert('{{%region}}',['id'=>'229','pid'=>'221','shortname'=>'阳曲','name'=>'阳曲县','merger_name'=>'中国,山西省,太原市,阳曲县','level'=>'3','pinyin'=>'yangqu','code'=>'0351','zip_code'=>'030100','first'=>'Y','lng'=>'112.67861','lat'=>'38.05989']);
        $this->insert('{{%region}}',['id'=>'230','pid'=>'221','shortname'=>'娄烦','name'=>'娄烦县','merger_name'=>'中国,山西省,太原市,娄烦县','level'=>'3','pinyin'=>'loufan','code'=>'0351','zip_code'=>'030300','first'=>'L','lng'=>'111.79473','lat'=>'38.06689']);
        $this->insert('{{%region}}',['id'=>'231','pid'=>'221','shortname'=>'古交','name'=>'古交市','merger_name'=>'中国,山西省,太原市,古交市','level'=>'3','pinyin'=>'gujiao','code'=>'0351','zip_code'=>'030200','first'=>'G','lng'=>'112.16918','lat'=>'37.90983']);
        $this->insert('{{%region}}',['id'=>'232','pid'=>'220','shortname'=>'大同','name'=>'大同市','merger_name'=>'中国,山西省,大同市','level'=>'2','pinyin'=>'datong','code'=>'0352','zip_code'=>'037008','first'=>'D','lng'=>'113.295259','lat'=>'40.09031']);
        $this->insert('{{%region}}',['id'=>'233','pid'=>'232','shortname'=>'城区','name'=>'城区','merger_name'=>'中国,山西省,大同市,城区','level'=>'3','pinyin'=>'chengqu','code'=>'0352','zip_code'=>'037008','first'=>'C','lng'=>'113.298','lat'=>'40.07566']);
        $this->insert('{{%region}}',['id'=>'234','pid'=>'232','shortname'=>'矿区','name'=>'矿区','merger_name'=>'中国,山西省,大同市,矿区','level'=>'3','pinyin'=>'kuangqu','code'=>'0352','zip_code'=>'037003','first'=>'K','lng'=>'113.1772','lat'=>'40.03685']);
        $this->insert('{{%region}}',['id'=>'235','pid'=>'232','shortname'=>'南郊','name'=>'南郊区','merger_name'=>'中国,山西省,大同市,南郊区','level'=>'3','pinyin'=>'nanjiao','code'=>'0352','zip_code'=>'037001','first'=>'N','lng'=>'113.14947','lat'=>'40.00539']);
        $this->insert('{{%region}}',['id'=>'236','pid'=>'232','shortname'=>'新荣','name'=>'新荣区','merger_name'=>'中国,山西省,大同市,新荣区','level'=>'3','pinyin'=>'xinrong','code'=>'0352','zip_code'=>'037002','first'=>'X','lng'=>'113.13504','lat'=>'40.25618']);
        $this->insert('{{%region}}',['id'=>'237','pid'=>'232','shortname'=>'阳高','name'=>'阳高县','merger_name'=>'中国,山西省,大同市,阳高县','level'=>'3','pinyin'=>'yanggao','code'=>'0352','zip_code'=>'038100','first'=>'Y','lng'=>'113.75012','lat'=>'40.36256']);
        $this->insert('{{%region}}',['id'=>'238','pid'=>'232','shortname'=>'天镇','name'=>'天镇县','merger_name'=>'中国,山西省,大同市,天镇县','level'=>'3','pinyin'=>'tianzhen','code'=>'0352','zip_code'=>'038200','first'=>'T','lng'=>'114.0931','lat'=>'40.42299']);
        $this->insert('{{%region}}',['id'=>'239','pid'=>'232','shortname'=>'广灵','name'=>'广灵县','merger_name'=>'中国,山西省,大同市,广灵县','level'=>'3','pinyin'=>'guangling','code'=>'0352','zip_code'=>'037500','first'=>'G','lng'=>'114.28204','lat'=>'39.76082']);
        $this->insert('{{%region}}',['id'=>'240','pid'=>'232','shortname'=>'灵丘','name'=>'灵丘县','merger_name'=>'中国,山西省,大同市,灵丘县','level'=>'3','pinyin'=>'lingqiu','code'=>'0352','zip_code'=>'034400','first'=>'L','lng'=>'114.23672','lat'=>'39.44043']);
        $this->insert('{{%region}}',['id'=>'241','pid'=>'232','shortname'=>'浑源','name'=>'浑源县','merger_name'=>'中国,山西省,大同市,浑源县','level'=>'3','pinyin'=>'hunyuan','code'=>'0352','zip_code'=>'037400','first'=>'H','lng'=>'113.69552','lat'=>'39.69962']);
        $this->insert('{{%region}}',['id'=>'242','pid'=>'232','shortname'=>'左云','name'=>'左云县','merger_name'=>'中国,山西省,大同市,左云县','level'=>'3','pinyin'=>'zuoyun','code'=>'0352','zip_code'=>'037100','first'=>'Z','lng'=>'112.70266','lat'=>'40.01336']);
        $this->insert('{{%region}}',['id'=>'243','pid'=>'232','shortname'=>'大同','name'=>'大同县','merger_name'=>'中国,山西省,大同市,大同县','level'=>'3','pinyin'=>'datong','code'=>'0352','zip_code'=>'037300','first'=>'D','lng'=>'113.61212','lat'=>'40.04012']);
        $this->insert('{{%region}}',['id'=>'244','pid'=>'220','shortname'=>'阳泉','name'=>'阳泉市','merger_name'=>'中国,山西省,阳泉市','level'=>'2','pinyin'=>'yangquan','code'=>'0353','zip_code'=>'045000','first'=>'Y','lng'=>'113.583285','lat'=>'37.861188']);
        $this->insert('{{%region}}',['id'=>'245','pid'=>'244','shortname'=>'城区','name'=>'城区','merger_name'=>'中国,山西省,阳泉市,城区','level'=>'3','pinyin'=>'chengqu','code'=>'0353','zip_code'=>'045000','first'=>'C','lng'=>'113.60069','lat'=>'37.8474']);
        $this->insert('{{%region}}',['id'=>'246','pid'=>'244','shortname'=>'矿区','name'=>'矿区','merger_name'=>'中国,山西省,阳泉市,矿区','level'=>'3','pinyin'=>'kuangqu','code'=>'0353','zip_code'=>'045000','first'=>'K','lng'=>'113.55677','lat'=>'37.86895']);
        $this->insert('{{%region}}',['id'=>'247','pid'=>'244','shortname'=>'郊区','name'=>'郊区','merger_name'=>'中国,山西省,阳泉市,郊区','level'=>'3','pinyin'=>'jiaoqu','code'=>'0353','zip_code'=>'045011','first'=>'J','lng'=>'113.58539','lat'=>'37.94139']);
        $this->insert('{{%region}}',['id'=>'248','pid'=>'244','shortname'=>'平定','name'=>'平定县','merger_name'=>'中国,山西省,阳泉市,平定县','level'=>'3','pinyin'=>'pingding','code'=>'0353','zip_code'=>'045200','first'=>'P','lng'=>'113.65789','lat'=>'37.78601']);
        $this->insert('{{%region}}',['id'=>'249','pid'=>'244','shortname'=>'盂县','name'=>'盂县','merger_name'=>'中国,山西省,阳泉市,盂县','level'=>'3','pinyin'=>'yuxian','code'=>'0353','zip_code'=>'045100','first'=>'Y','lng'=>'113.41235','lat'=>'38.08579']);
        $this->insert('{{%region}}',['id'=>'250','pid'=>'220','shortname'=>'长治','name'=>'长治市','merger_name'=>'中国,山西省,长治市','level'=>'2','pinyin'=>'changzhi','code'=>'0355','zip_code'=>'046000','first'=>'C','lng'=>'113.113556','lat'=>'36.191112']);
        $this->insert('{{%region}}',['id'=>'251','pid'=>'250','shortname'=>'城区','name'=>'城区','merger_name'=>'中国,山西省,长治市,城区','level'=>'3','pinyin'=>'chengqu','code'=>'0355','zip_code'=>'046011','first'=>'C','lng'=>'113.12308','lat'=>'36.20351']);
        $this->insert('{{%region}}',['id'=>'252','pid'=>'250','shortname'=>'郊区','name'=>'郊区','merger_name'=>'中国,山西省,长治市,郊区','level'=>'3','pinyin'=>'jiaoqu','code'=>'0355','zip_code'=>'046011','first'=>'J','lng'=>'113.12653','lat'=>'36.19918']);
        $this->insert('{{%region}}',['id'=>'253','pid'=>'250','shortname'=>'长治','name'=>'长治县','merger_name'=>'中国,山西省,长治市,长治县','level'=>'3','pinyin'=>'changzhi','code'=>'0355','zip_code'=>'047100','first'=>'C','lng'=>'113.04791','lat'=>'36.04722']);
        $this->insert('{{%region}}',['id'=>'254','pid'=>'250','shortname'=>'襄垣','name'=>'襄垣县','merger_name'=>'中国,山西省,长治市,襄垣县','level'=>'3','pinyin'=>'xiangyuan','code'=>'0355','zip_code'=>'046200','first'=>'X','lng'=>'113.05157','lat'=>'36.53527']);
        $this->insert('{{%region}}',['id'=>'255','pid'=>'250','shortname'=>'屯留','name'=>'屯留县','merger_name'=>'中国,山西省,长治市,屯留县','level'=>'3','pinyin'=>'tunliu','code'=>'0355','zip_code'=>'046100','first'=>'T','lng'=>'112.89196','lat'=>'36.31579']);
        $this->insert('{{%region}}',['id'=>'256','pid'=>'250','shortname'=>'平顺','name'=>'平顺县','merger_name'=>'中国,山西省,长治市,平顺县','level'=>'3','pinyin'=>'pingshun','code'=>'0355','zip_code'=>'047400','first'=>'P','lng'=>'113.43603','lat'=>'36.20005']);
        $this->insert('{{%region}}',['id'=>'257','pid'=>'250','shortname'=>'黎城','name'=>'黎城县','merger_name'=>'中国,山西省,长治市,黎城县','level'=>'3','pinyin'=>'licheng','code'=>'0355','zip_code'=>'047600','first'=>'L','lng'=>'113.38766','lat'=>'36.50301']);
        $this->insert('{{%region}}',['id'=>'258','pid'=>'250','shortname'=>'壶关','name'=>'壶关县','merger_name'=>'中国,山西省,长治市,壶关县','level'=>'3','pinyin'=>'huguan','code'=>'0355','zip_code'=>'047300','first'=>'H','lng'=>'113.207','lat'=>'36.11301']);
        $this->insert('{{%region}}',['id'=>'259','pid'=>'250','shortname'=>'长子','name'=>'长子县','merger_name'=>'中国,山西省,长治市,长子县','level'=>'3','pinyin'=>'zhangzi','code'=>'0355','zip_code'=>'046600','first'=>'C','lng'=>'112.87731','lat'=>'36.12125']);
        $this->insert('{{%region}}',['id'=>'260','pid'=>'250','shortname'=>'武乡','name'=>'武乡县','merger_name'=>'中国,山西省,长治市,武乡县','level'=>'3','pinyin'=>'wuxiang','code'=>'0355','zip_code'=>'046300','first'=>'W','lng'=>'112.86343','lat'=>'36.83687']);
        $this->insert('{{%region}}',['id'=>'261','pid'=>'250','shortname'=>'沁县','name'=>'沁县','merger_name'=>'中国,山西省,长治市,沁县','level'=>'3','pinyin'=>'qinxian','code'=>'0355','zip_code'=>'046400','first'=>'Q','lng'=>'112.69863','lat'=>'36.75628']);
        $this->insert('{{%region}}',['id'=>'262','pid'=>'250','shortname'=>'沁源','name'=>'沁源县','merger_name'=>'中国,山西省,长治市,沁源县','level'=>'3','pinyin'=>'qinyuan','code'=>'0355','zip_code'=>'046500','first'=>'Q','lng'=>'112.33758','lat'=>'36.50008']);
        $this->insert('{{%region}}',['id'=>'263','pid'=>'250','shortname'=>'潞城','name'=>'潞城市','merger_name'=>'中国,山西省,长治市,潞城市','level'=>'3','pinyin'=>'lucheng','code'=>'0355','zip_code'=>'047500','first'=>'L','lng'=>'113.22888','lat'=>'36.33414']);
        $this->insert('{{%region}}',['id'=>'264','pid'=>'220','shortname'=>'晋城','name'=>'晋城市','merger_name'=>'中国,山西省,晋城市','level'=>'2','pinyin'=>'jincheng','code'=>'0356','zip_code'=>'048000','first'=>'J','lng'=>'112.851274','lat'=>'35.497553']);
        $this->insert('{{%region}}',['id'=>'265','pid'=>'264','shortname'=>'城区','name'=>'城区','merger_name'=>'中国,山西省,晋城市,城区','level'=>'3','pinyin'=>'chengqu','code'=>'0356','zip_code'=>'048000','first'=>'C','lng'=>'112.85319','lat'=>'35.50175']);
        $this->insert('{{%region}}',['id'=>'266','pid'=>'264','shortname'=>'沁水','name'=>'沁水县','merger_name'=>'中国,山西省,晋城市,沁水县','level'=>'3','pinyin'=>'qinshui','code'=>'0356','zip_code'=>'048200','first'=>'Q','lng'=>'112.1871','lat'=>'35.69102']);
        $this->insert('{{%region}}',['id'=>'267','pid'=>'264','shortname'=>'阳城','name'=>'阳城县','merger_name'=>'中国,山西省,晋城市,阳城县','level'=>'3','pinyin'=>'yangcheng','code'=>'0356','zip_code'=>'048100','first'=>'Y','lng'=>'112.41485','lat'=>'35.48614']);
        $this->insert('{{%region}}',['id'=>'268','pid'=>'264','shortname'=>'陵川','name'=>'陵川县','merger_name'=>'中国,山西省,晋城市,陵川县','level'=>'3','pinyin'=>'lingchuan','code'=>'0356','zip_code'=>'048300','first'=>'L','lng'=>'113.2806','lat'=>'35.77532']);
        $this->insert('{{%region}}',['id'=>'269','pid'=>'264','shortname'=>'泽州','name'=>'泽州县','merger_name'=>'中国,山西省,晋城市,泽州县','level'=>'3','pinyin'=>'zezhou','code'=>'0356','zip_code'=>'048012','first'=>'Z','lng'=>'112.83947','lat'=>'35.50789']);
        $this->insert('{{%region}}',['id'=>'270','pid'=>'264','shortname'=>'高平','name'=>'高平市','merger_name'=>'中国,山西省,晋城市,高平市','level'=>'3','pinyin'=>'gaoping','code'=>'0356','zip_code'=>'048400','first'=>'G','lng'=>'112.92288','lat'=>'35.79705']);
        $this->insert('{{%region}}',['id'=>'271','pid'=>'220','shortname'=>'朔州','name'=>'朔州市','merger_name'=>'中国,山西省,朔州市','level'=>'2','pinyin'=>'shuozhou','code'=>'0349','zip_code'=>'038500','first'=>'S','lng'=>'112.433387','lat'=>'39.331261']);
        $this->insert('{{%region}}',['id'=>'272','pid'=>'271','shortname'=>'朔城','name'=>'朔城区','merger_name'=>'中国,山西省,朔州市,朔城区','level'=>'3','pinyin'=>'shuocheng','code'=>'0349','zip_code'=>'036000','first'=>'S','lng'=>'112.43189','lat'=>'39.31982']);
        $this->insert('{{%region}}',['id'=>'273','pid'=>'271','shortname'=>'平鲁','name'=>'平鲁区','merger_name'=>'中国,山西省,朔州市,平鲁区','level'=>'3','pinyin'=>'pinglu','code'=>'0349','zip_code'=>'038600','first'=>'P','lng'=>'112.28833','lat'=>'39.51155']);
        $this->insert('{{%region}}',['id'=>'274','pid'=>'271','shortname'=>'山阴','name'=>'山阴县','merger_name'=>'中国,山西省,朔州市,山阴县','level'=>'3','pinyin'=>'shanyin','code'=>'0349','zip_code'=>'036900','first'=>'S','lng'=>'112.81662','lat'=>'39.52697']);
        $this->insert('{{%region}}',['id'=>'275','pid'=>'271','shortname'=>'应县','name'=>'应县','merger_name'=>'中国,山西省,朔州市,应县','level'=>'3','pinyin'=>'yingxian','code'=>'0349','zip_code'=>'037600','first'=>'Y','lng'=>'113.19052','lat'=>'39.55279']);
        $this->insert('{{%region}}',['id'=>'276','pid'=>'271','shortname'=>'右玉','name'=>'右玉县','merger_name'=>'中国,山西省,朔州市,右玉县','level'=>'3','pinyin'=>'youyu','code'=>'0349','zip_code'=>'037200','first'=>'Y','lng'=>'112.46902','lat'=>'39.99011']);
        $this->insert('{{%region}}',['id'=>'277','pid'=>'271','shortname'=>'怀仁','name'=>'怀仁县','merger_name'=>'中国,山西省,朔州市,怀仁县','level'=>'3','pinyin'=>'huairen','code'=>'0349','zip_code'=>'038300','first'=>'H','lng'=>'113.10009','lat'=>'39.82806']);
        $this->insert('{{%region}}',['id'=>'278','pid'=>'220','shortname'=>'晋中','name'=>'晋中市','merger_name'=>'中国,山西省,晋中市','level'=>'2','pinyin'=>'jinzhong','code'=>'0354','zip_code'=>'030600','first'=>'J','lng'=>'112.736465','lat'=>'37.696495']);
        $this->insert('{{%region}}',['id'=>'279','pid'=>'278','shortname'=>'榆次','name'=>'榆次区','merger_name'=>'中国,山西省,晋中市,榆次区','level'=>'3','pinyin'=>'yuci','code'=>'0354','zip_code'=>'030600','first'=>'Y','lng'=>'112.70788','lat'=>'37.6978']);
        $this->insert('{{%region}}',['id'=>'280','pid'=>'278','shortname'=>'榆社','name'=>'榆社县','merger_name'=>'中国,山西省,晋中市,榆社县','level'=>'3','pinyin'=>'yushe','code'=>'0354','zip_code'=>'031800','first'=>'Y','lng'=>'112.97558','lat'=>'37.0721']);
        $this->insert('{{%region}}',['id'=>'281','pid'=>'278','shortname'=>'左权','name'=>'左权县','merger_name'=>'中国,山西省,晋中市,左权县','level'=>'3','pinyin'=>'zuoquan','code'=>'0354','zip_code'=>'032600','first'=>'Z','lng'=>'113.37918','lat'=>'37.08235']);
        $this->insert('{{%region}}',['id'=>'282','pid'=>'278','shortname'=>'和顺','name'=>'和顺县','merger_name'=>'中国,山西省,晋中市,和顺县','level'=>'3','pinyin'=>'heshun','code'=>'0354','zip_code'=>'032700','first'=>'H','lng'=>'113.56988','lat'=>'37.32963']);
        $this->insert('{{%region}}',['id'=>'283','pid'=>'278','shortname'=>'昔阳','name'=>'昔阳县','merger_name'=>'中国,山西省,晋中市,昔阳县','level'=>'3','pinyin'=>'xiyang','code'=>'0354','zip_code'=>'045300','first'=>'X','lng'=>'113.70517','lat'=>'37.61863']);
        $this->insert('{{%region}}',['id'=>'284','pid'=>'278','shortname'=>'寿阳','name'=>'寿阳县','merger_name'=>'中国,山西省,晋中市,寿阳县','level'=>'3','pinyin'=>'shouyang','code'=>'0354','zip_code'=>'045400','first'=>'S','lng'=>'113.17495','lat'=>'37.88899']);
        $this->insert('{{%region}}',['id'=>'285','pid'=>'278','shortname'=>'太谷','name'=>'太谷县','merger_name'=>'中国,山西省,晋中市,太谷县','level'=>'3','pinyin'=>'taigu','code'=>'0354','zip_code'=>'030800','first'=>'T','lng'=>'112.55246','lat'=>'37.42161']);
        $this->insert('{{%region}}',['id'=>'286','pid'=>'278','shortname'=>'祁县','name'=>'祁县','merger_name'=>'中国,山西省,晋中市,祁县','level'=>'3','pinyin'=>'qixian','code'=>'0354','zip_code'=>'030900','first'=>'Q','lng'=>'112.33358','lat'=>'37.3579']);
        $this->insert('{{%region}}',['id'=>'287','pid'=>'278','shortname'=>'平遥','name'=>'平遥县','merger_name'=>'中国,山西省,晋中市,平遥县','level'=>'3','pinyin'=>'pingyao','code'=>'0354','zip_code'=>'031100','first'=>'P','lng'=>'112.17553','lat'=>'37.1892']);
        $this->insert('{{%region}}',['id'=>'288','pid'=>'278','shortname'=>'灵石','name'=>'灵石县','merger_name'=>'中国,山西省,晋中市,灵石县','level'=>'3','pinyin'=>'lingshi','code'=>'0354','zip_code'=>'031300','first'=>'L','lng'=>'111.7774','lat'=>'36.84814']);
        $this->insert('{{%region}}',['id'=>'289','pid'=>'278','shortname'=>'介休','name'=>'介休市','merger_name'=>'中国,山西省,晋中市,介休市','level'=>'3','pinyin'=>'jiexiu','code'=>'0354','zip_code'=>'032000','first'=>'J','lng'=>'111.91824','lat'=>'37.02771']);
        $this->insert('{{%region}}',['id'=>'290','pid'=>'220','shortname'=>'运城','name'=>'运城市','merger_name'=>'中国,山西省,运城市','level'=>'2','pinyin'=>'yuncheng','code'=>'0359','zip_code'=>'044000','first'=>'Y','lng'=>'111.003957','lat'=>'35.022778']);
        $this->insert('{{%region}}',['id'=>'291','pid'=>'290','shortname'=>'盐湖','name'=>'盐湖区','merger_name'=>'中国,山西省,运城市,盐湖区','level'=>'3','pinyin'=>'yanhu','code'=>'0359','zip_code'=>'044000','first'=>'Y','lng'=>'110.99827','lat'=>'35.0151']);
        $this->insert('{{%region}}',['id'=>'292','pid'=>'290','shortname'=>'临猗','name'=>'临猗县','merger_name'=>'中国,山西省,运城市,临猗县','level'=>'3','pinyin'=>'linyi','code'=>'0359','zip_code'=>'044100','first'=>'L','lng'=>'110.77432','lat'=>'35.14455']);
        $this->insert('{{%region}}',['id'=>'293','pid'=>'290','shortname'=>'万荣','name'=>'万荣县','merger_name'=>'中国,山西省,运城市,万荣县','level'=>'3','pinyin'=>'wanrong','code'=>'0359','zip_code'=>'044200','first'=>'W','lng'=>'110.83657','lat'=>'35.41556']);
        $this->insert('{{%region}}',['id'=>'294','pid'=>'290','shortname'=>'闻喜','name'=>'闻喜县','merger_name'=>'中国,山西省,运城市,闻喜县','level'=>'3','pinyin'=>'wenxi','code'=>'0359','zip_code'=>'043800','first'=>'W','lng'=>'111.22265','lat'=>'35.35553']);
        $this->insert('{{%region}}',['id'=>'295','pid'=>'290','shortname'=>'稷山','name'=>'稷山县','merger_name'=>'中国,山西省,运城市,稷山县','level'=>'3','pinyin'=>'jishan','code'=>'0359','zip_code'=>'043200','first'=>NULL,'lng'=>'110.97924','lat'=>'35.59993']);
        $this->insert('{{%region}}',['id'=>'296','pid'=>'290','shortname'=>'新绛','name'=>'新绛县','merger_name'=>'中国,山西省,运城市,新绛县','level'=>'3','pinyin'=>'xinjiang','code'=>'0359','zip_code'=>'043100','first'=>'X','lng'=>'111.22509','lat'=>'35.61566']);
        $this->insert('{{%region}}',['id'=>'297','pid'=>'290','shortname'=>'绛县','name'=>'绛县','merger_name'=>'中国,山西省,运城市,绛县','level'=>'3','pinyin'=>'jiangxian','code'=>'0359','zip_code'=>'043600','first'=>NULL,'lng'=>'111.56668','lat'=>'35.49096']);
        $this->insert('{{%region}}',['id'=>'298','pid'=>'290','shortname'=>'垣曲','name'=>'垣曲县','merger_name'=>'中国,山西省,运城市,垣曲县','level'=>'3','pinyin'=>'yuanqu','code'=>'0359','zip_code'=>'043700','first'=>'Y','lng'=>'111.67166','lat'=>'35.29923']);
        $this->insert('{{%region}}',['id'=>'299','pid'=>'290','shortname'=>'夏县','name'=>'夏县','merger_name'=>'中国,山西省,运城市,夏县','level'=>'3','pinyin'=>'xiaxian','code'=>'0359','zip_code'=>'044400','first'=>'X','lng'=>'111.21966','lat'=>'35.14121']);
        $this->insert('{{%region}}',['id'=>'300','pid'=>'290','shortname'=>'平陆','name'=>'平陆县','merger_name'=>'中国,山西省,运城市,平陆县','level'=>'3','pinyin'=>'pinglu','code'=>'0359','zip_code'=>'044300','first'=>'P','lng'=>'111.21704','lat'=>'34.83772']);
        $this->insert('{{%region}}',['id'=>'301','pid'=>'290','shortname'=>'芮城','name'=>'芮城县','merger_name'=>'中国,山西省,运城市,芮城县','level'=>'3','pinyin'=>'ruicheng','code'=>'0359','zip_code'=>'044600','first'=>NULL,'lng'=>'110.69455','lat'=>'34.69384']);
        $this->insert('{{%region}}',['id'=>'302','pid'=>'290','shortname'=>'永济','name'=>'永济市','merger_name'=>'中国,山西省,运城市,永济市','level'=>'3','pinyin'=>'yongji','code'=>'0359','zip_code'=>'044500','first'=>'Y','lng'=>'110.44537','lat'=>'34.86556']);
        $this->insert('{{%region}}',['id'=>'303','pid'=>'290','shortname'=>'河津','name'=>'河津市','merger_name'=>'中国,山西省,运城市,河津市','level'=>'3','pinyin'=>'hejin','code'=>'0359','zip_code'=>'043300','first'=>'H','lng'=>'110.7116','lat'=>'35.59478']);
        $this->insert('{{%region}}',['id'=>'304','pid'=>'220','shortname'=>'忻州','name'=>'忻州市','merger_name'=>'中国,山西省,忻州市','level'=>'2','pinyin'=>'xinzhou','code'=>'0350','zip_code'=>'034000','first'=>'X','lng'=>'112.733538','lat'=>'38.41769']);
        $this->insert('{{%region}}',['id'=>'305','pid'=>'304','shortname'=>'忻府','name'=>'忻府区','merger_name'=>'中国,山西省,忻州市,忻府区','level'=>'3','pinyin'=>'xinfu','code'=>'0350','zip_code'=>'034000','first'=>'X','lng'=>'112.74603','lat'=>'38.40414']);
        $this->insert('{{%region}}',['id'=>'306','pid'=>'304','shortname'=>'定襄','name'=>'定襄县','merger_name'=>'中国,山西省,忻州市,定襄县','level'=>'3','pinyin'=>'dingxiang','code'=>'0350','zip_code'=>'035400','first'=>'D','lng'=>'112.95733','lat'=>'38.47387']);
        $this->insert('{{%region}}',['id'=>'307','pid'=>'304','shortname'=>'五台','name'=>'五台县','merger_name'=>'中国,山西省,忻州市,五台县','level'=>'3','pinyin'=>'wutai','code'=>'0350','zip_code'=>'035500','first'=>'W','lng'=>'113.25256','lat'=>'38.72774']);
        $this->insert('{{%region}}',['id'=>'308','pid'=>'304','shortname'=>'代县','name'=>'代县','merger_name'=>'中国,山西省,忻州市,代县','level'=>'3','pinyin'=>'daixian','code'=>'0350','zip_code'=>'034200','first'=>'D','lng'=>'112.95913','lat'=>'39.06717']);
        $this->insert('{{%region}}',['id'=>'309','pid'=>'304','shortname'=>'繁峙','name'=>'繁峙县','merger_name'=>'中国,山西省,忻州市,繁峙县','level'=>'3','pinyin'=>'fanshi','code'=>'0350','zip_code'=>'034300','first'=>'F','lng'=>'113.26303','lat'=>'39.18886']);
        $this->insert('{{%region}}',['id'=>'310','pid'=>'304','shortname'=>'宁武','name'=>'宁武县','merger_name'=>'中国,山西省,忻州市,宁武县','level'=>'3','pinyin'=>'ningwu','code'=>'0350','zip_code'=>'036700','first'=>'N','lng'=>'112.30423','lat'=>'39.00211']);
        $this->insert('{{%region}}',['id'=>'311','pid'=>'304','shortname'=>'静乐','name'=>'静乐县','merger_name'=>'中国,山西省,忻州市,静乐县','level'=>'3','pinyin'=>'jingle','code'=>'0350','zip_code'=>'035100','first'=>'J','lng'=>'111.94158','lat'=>'38.3602']);
        $this->insert('{{%region}}',['id'=>'312','pid'=>'304','shortname'=>'神池','name'=>'神池县','merger_name'=>'中国,山西省,忻州市,神池县','level'=>'3','pinyin'=>'shenchi','code'=>'0350','zip_code'=>'036100','first'=>'S','lng'=>'112.20541','lat'=>'39.09']);
        $this->insert('{{%region}}',['id'=>'313','pid'=>'304','shortname'=>'五寨','name'=>'五寨县','merger_name'=>'中国,山西省,忻州市,五寨县','level'=>'3','pinyin'=>'wuzhai','code'=>'0350','zip_code'=>'036200','first'=>'W','lng'=>'111.8489','lat'=>'38.90757']);
        $this->insert('{{%region}}',['id'=>'314','pid'=>'304','shortname'=>'岢岚','name'=>'岢岚县','merger_name'=>'中国,山西省,忻州市,岢岚县','level'=>'3','pinyin'=>'kelan','code'=>'0350','zip_code'=>'036300','first'=>NULL,'lng'=>'111.57388','lat'=>'38.70452']);
        $this->insert('{{%region}}',['id'=>'315','pid'=>'304','shortname'=>'河曲','name'=>'河曲县','merger_name'=>'中国,山西省,忻州市,河曲县','level'=>'3','pinyin'=>'hequ','code'=>'0350','zip_code'=>'036500','first'=>'H','lng'=>'111.13821','lat'=>'39.38439']);
        $this->insert('{{%region}}',['id'=>'316','pid'=>'304','shortname'=>'保德','name'=>'保德县','merger_name'=>'中国,山西省,忻州市,保德县','level'=>'3','pinyin'=>'baode','code'=>'0350','zip_code'=>'036600','first'=>'B','lng'=>'111.08656','lat'=>'39.02248']);
        $this->insert('{{%region}}',['id'=>'317','pid'=>'304','shortname'=>'偏关','name'=>'偏关县','merger_name'=>'中国,山西省,忻州市,偏关县','level'=>'3','pinyin'=>'pianguan','code'=>'0350','zip_code'=>'036400','first'=>'P','lng'=>'111.50863','lat'=>'39.43609']);
        $this->insert('{{%region}}',['id'=>'318','pid'=>'304','shortname'=>'原平','name'=>'原平市','merger_name'=>'中国,山西省,忻州市,原平市','level'=>'3','pinyin'=>'yuanping','code'=>'0350','zip_code'=>'034100','first'=>'Y','lng'=>'112.70584','lat'=>'38.73181']);
        $this->insert('{{%region}}',['id'=>'319','pid'=>'220','shortname'=>'临汾','name'=>'临汾市','merger_name'=>'中国,山西省,临汾市','level'=>'2','pinyin'=>'linfen','code'=>'0357','zip_code'=>'041000','first'=>'L','lng'=>'111.517973','lat'=>'36.08415']);
        $this->insert('{{%region}}',['id'=>'320','pid'=>'319','shortname'=>'尧都','name'=>'尧都区','merger_name'=>'中国,山西省,临汾市,尧都区','level'=>'3','pinyin'=>'yaodu','code'=>'0357','zip_code'=>'041000','first'=>'Y','lng'=>'111.5787','lat'=>'36.08298']);
        $this->insert('{{%region}}',['id'=>'321','pid'=>'319','shortname'=>'曲沃','name'=>'曲沃县','merger_name'=>'中国,山西省,临汾市,曲沃县','level'=>'3','pinyin'=>'quwo','code'=>'0357','zip_code'=>'043400','first'=>'Q','lng'=>'111.47525','lat'=>'35.64119']);
        $this->insert('{{%region}}',['id'=>'322','pid'=>'319','shortname'=>'翼城','name'=>'翼城县','merger_name'=>'中国,山西省,临汾市,翼城县','level'=>'3','pinyin'=>'yicheng','code'=>'0357','zip_code'=>'043500','first'=>'Y','lng'=>'111.7181','lat'=>'35.73881']);
        $this->insert('{{%region}}',['id'=>'323','pid'=>'319','shortname'=>'襄汾','name'=>'襄汾县','merger_name'=>'中国,山西省,临汾市,襄汾县','level'=>'3','pinyin'=>'xiangfen','code'=>'0357','zip_code'=>'041500','first'=>'X','lng'=>'111.44204','lat'=>'35.87711']);
        $this->insert('{{%region}}',['id'=>'324','pid'=>'319','shortname'=>'洪洞','name'=>'洪洞县','merger_name'=>'中国,山西省,临汾市,洪洞县','level'=>'3','pinyin'=>'hongtong','code'=>'0357','zip_code'=>'041600','first'=>'H','lng'=>'111.67501','lat'=>'36.25425']);
        $this->insert('{{%region}}',['id'=>'325','pid'=>'319','shortname'=>'古县','name'=>'古县','merger_name'=>'中国,山西省,临汾市,古县','level'=>'3','pinyin'=>'guxian','code'=>'0357','zip_code'=>'042400','first'=>'G','lng'=>'111.92041','lat'=>'36.26688']);
        $this->insert('{{%region}}',['id'=>'326','pid'=>'319','shortname'=>'安泽','name'=>'安泽县','merger_name'=>'中国,山西省,临汾市,安泽县','level'=>'3','pinyin'=>'anze','code'=>'0357','zip_code'=>'042500','first'=>'A','lng'=>'112.24981','lat'=>'36.14803']);
        $this->insert('{{%region}}',['id'=>'327','pid'=>'319','shortname'=>'浮山','name'=>'浮山县','merger_name'=>'中国,山西省,临汾市,浮山县','level'=>'3','pinyin'=>'fushan','code'=>'0357','zip_code'=>'042600','first'=>'F','lng'=>'111.84744','lat'=>'35.96854']);
        $this->insert('{{%region}}',['id'=>'328','pid'=>'319','shortname'=>'吉县','name'=>'吉县','merger_name'=>'中国,山西省,临汾市,吉县','level'=>'3','pinyin'=>'jixian','code'=>'0357','zip_code'=>'042200','first'=>'J','lng'=>'110.68148','lat'=>'36.09873']);
        $this->insert('{{%region}}',['id'=>'329','pid'=>'319','shortname'=>'乡宁','name'=>'乡宁县','merger_name'=>'中国,山西省,临汾市,乡宁县','level'=>'3','pinyin'=>'xiangning','code'=>'0357','zip_code'=>'042100','first'=>'X','lng'=>'110.84652','lat'=>'35.97072']);
        $this->insert('{{%region}}',['id'=>'330','pid'=>'319','shortname'=>'大宁','name'=>'大宁县','merger_name'=>'中国,山西省,临汾市,大宁县','level'=>'3','pinyin'=>'daning','code'=>'0357','zip_code'=>'042300','first'=>'D','lng'=>'110.75216','lat'=>'36.46624']);
        $this->insert('{{%region}}',['id'=>'331','pid'=>'319','shortname'=>'隰县','name'=>'隰县','merger_name'=>'中国,山西省,临汾市,隰县','level'=>'3','pinyin'=>'xixian','code'=>'0357','zip_code'=>'041300','first'=>NULL,'lng'=>'110.93881','lat'=>'36.69258']);
        $this->insert('{{%region}}',['id'=>'332','pid'=>'319','shortname'=>'永和','name'=>'永和县','merger_name'=>'中国,山西省,临汾市,永和县','level'=>'3','pinyin'=>'yonghe','code'=>'0357','zip_code'=>'041400','first'=>'Y','lng'=>'110.63168','lat'=>'36.7584']);
        $this->insert('{{%region}}',['id'=>'333','pid'=>'319','shortname'=>'蒲县','name'=>'蒲县','merger_name'=>'中国,山西省,临汾市,蒲县','level'=>'3','pinyin'=>'puxian','code'=>'0357','zip_code'=>'041200','first'=>'P','lng'=>'111.09674','lat'=>'36.41243']);
        $this->insert('{{%region}}',['id'=>'334','pid'=>'319','shortname'=>'汾西','name'=>'汾西县','merger_name'=>'中国,山西省,临汾市,汾西县','level'=>'3','pinyin'=>'fenxi','code'=>'0357','zip_code'=>'031500','first'=>'F','lng'=>'111.56811','lat'=>'36.65063']);
        $this->insert('{{%region}}',['id'=>'335','pid'=>'319','shortname'=>'侯马','name'=>'侯马市','merger_name'=>'中国,山西省,临汾市,侯马市','level'=>'3','pinyin'=>'houma','code'=>'0357','zip_code'=>'043000','first'=>'H','lng'=>'111.37207','lat'=>'35.61903']);
        $this->insert('{{%region}}',['id'=>'336','pid'=>'319','shortname'=>'霍州','name'=>'霍州市','merger_name'=>'中国,山西省,临汾市,霍州市','level'=>'3','pinyin'=>'huozhou','code'=>'0357','zip_code'=>'031400','first'=>'H','lng'=>'111.755','lat'=>'36.5638']);
        $this->insert('{{%region}}',['id'=>'337','pid'=>'220','shortname'=>'吕梁','name'=>'吕梁市','merger_name'=>'中国,山西省,吕梁市','level'=>'2','pinyin'=>'lvliang','code'=>'0358','zip_code'=>'033000','first'=>'L','lng'=>'111.134335','lat'=>'37.524366']);
        $this->insert('{{%region}}',['id'=>'338','pid'=>'337','shortname'=>'离石','name'=>'离石区','merger_name'=>'中国,山西省,吕梁市,离石区','level'=>'3','pinyin'=>'lishi','code'=>'0358','zip_code'=>'033000','first'=>'L','lng'=>'111.15059','lat'=>'37.5177']);
        $this->insert('{{%region}}',['id'=>'339','pid'=>'337','shortname'=>'文水','name'=>'文水县','merger_name'=>'中国,山西省,吕梁市,文水县','level'=>'3','pinyin'=>'wenshui','code'=>'0358','zip_code'=>'032100','first'=>'W','lng'=>'112.02829','lat'=>'37.43841']);
        $this->insert('{{%region}}',['id'=>'340','pid'=>'337','shortname'=>'交城','name'=>'交城县','merger_name'=>'中国,山西省,吕梁市,交城县','level'=>'3','pinyin'=>'jiaocheng','code'=>'0358','zip_code'=>'030500','first'=>'J','lng'=>'112.1585','lat'=>'37.5512']);
        $this->insert('{{%region}}',['id'=>'341','pid'=>'337','shortname'=>'兴县','name'=>'兴县','merger_name'=>'中国,山西省,吕梁市,兴县','level'=>'3','pinyin'=>'xingxian','code'=>'0358','zip_code'=>'033600','first'=>'X','lng'=>'111.12692','lat'=>'38.46321']);
        $this->insert('{{%region}}',['id'=>'342','pid'=>'337','shortname'=>'临县','name'=>'临县','merger_name'=>'中国,山西省,吕梁市,临县','level'=>'3','pinyin'=>'linxian','code'=>'0358','zip_code'=>'033200','first'=>'L','lng'=>'110.99282','lat'=>'37.95271']);
        $this->insert('{{%region}}',['id'=>'343','pid'=>'337','shortname'=>'柳林','name'=>'柳林县','merger_name'=>'中国,山西省,吕梁市,柳林县','level'=>'3','pinyin'=>'liulin','code'=>'0358','zip_code'=>'033300','first'=>'L','lng'=>'110.88922','lat'=>'37.42932']);
        $this->insert('{{%region}}',['id'=>'344','pid'=>'337','shortname'=>'石楼','name'=>'石楼县','merger_name'=>'中国,山西省,吕梁市,石楼县','level'=>'3','pinyin'=>'shilou','code'=>'0358','zip_code'=>'032500','first'=>'S','lng'=>'110.8352','lat'=>'36.99731']);
        $this->insert('{{%region}}',['id'=>'345','pid'=>'337','shortname'=>'岚县','name'=>'岚县','merger_name'=>'中国,山西省,吕梁市,岚县','level'=>'3','pinyin'=>'lanxian','code'=>'0358','zip_code'=>'033500','first'=>NULL,'lng'=>'111.67627','lat'=>'38.27874']);
        $this->insert('{{%region}}',['id'=>'346','pid'=>'337','shortname'=>'方山','name'=>'方山县','merger_name'=>'中国,山西省,吕梁市,方山县','level'=>'3','pinyin'=>'fangshan','code'=>'0358','zip_code'=>'033100','first'=>'F','lng'=>'111.24011','lat'=>'37.88979']);
        $this->insert('{{%region}}',['id'=>'347','pid'=>'337','shortname'=>'中阳','name'=>'中阳县','merger_name'=>'中国,山西省,吕梁市,中阳县','level'=>'3','pinyin'=>'zhongyang','code'=>'0358','zip_code'=>'033400','first'=>'Z','lng'=>'111.1795','lat'=>'37.35715']);
        $this->insert('{{%region}}',['id'=>'348','pid'=>'337','shortname'=>'交口','name'=>'交口县','merger_name'=>'中国,山西省,吕梁市,交口县','level'=>'3','pinyin'=>'jiaokou','code'=>'0358','zip_code'=>'032400','first'=>'J','lng'=>'111.18103','lat'=>'36.98213']);
        $this->insert('{{%region}}',['id'=>'349','pid'=>'337','shortname'=>'孝义','name'=>'孝义市','merger_name'=>'中国,山西省,吕梁市,孝义市','level'=>'3','pinyin'=>'xiaoyi','code'=>'0358','zip_code'=>'032300','first'=>'X','lng'=>'111.77362','lat'=>'37.14414']);
        $this->insert('{{%region}}',['id'=>'350','pid'=>'337','shortname'=>'汾阳','name'=>'汾阳市','merger_name'=>'中国,山西省,吕梁市,汾阳市','level'=>'3','pinyin'=>'fenyang','code'=>'0358','zip_code'=>'032200','first'=>'F','lng'=>'111.7882','lat'=>'37.26605']);
        $this->insert('{{%region}}',['id'=>'351','pid'=>'0','shortname'=>'内蒙古','name'=>'内蒙古自治区','merger_name'=>'中国,内蒙古自治区','level'=>'1','pinyin'=>'innermongolia','code'=>'','zip_code'=>'','first'=>'N','lng'=>'111.670801','lat'=>'40.818311']);
        $this->insert('{{%region}}',['id'=>'352','pid'=>'351','shortname'=>'呼和浩特','name'=>'呼和浩特市','merger_name'=>'中国,内蒙古自治区,呼和浩特市','level'=>'2','pinyin'=>'hohhot','code'=>'0471','zip_code'=>'010000','first'=>'H','lng'=>'111.670801','lat'=>'40.818311']);
        $this->insert('{{%region}}',['id'=>'353','pid'=>'352','shortname'=>'新城','name'=>'新城区','merger_name'=>'中国,内蒙古自治区,呼和浩特市,新城区','level'=>'3','pinyin'=>'xincheng','code'=>'0471','zip_code'=>'010050','first'=>'X','lng'=>'111.66554','lat'=>'40.85828']);
        $this->insert('{{%region}}',['id'=>'354','pid'=>'352','shortname'=>'回民','name'=>'回民区','merger_name'=>'中国,内蒙古自治区,呼和浩特市,回民区','level'=>'3','pinyin'=>'huimin','code'=>'0471','zip_code'=>'010030','first'=>'H','lng'=>'111.62402','lat'=>'40.80827']);
        $this->insert('{{%region}}',['id'=>'355','pid'=>'352','shortname'=>'玉泉','name'=>'玉泉区','merger_name'=>'中国,内蒙古自治区,呼和浩特市,玉泉区','level'=>'3','pinyin'=>'yuquan','code'=>'0471','zip_code'=>'010020','first'=>'Y','lng'=>'111.67456','lat'=>'40.75227']);
        $this->insert('{{%region}}',['id'=>'356','pid'=>'352','shortname'=>'赛罕','name'=>'赛罕区','merger_name'=>'中国,内蒙古自治区,呼和浩特市,赛罕区','level'=>'3','pinyin'=>'saihan','code'=>'0471','zip_code'=>'010020','first'=>'S','lng'=>'111.70224','lat'=>'40.79207']);
        $this->insert('{{%region}}',['id'=>'357','pid'=>'352','shortname'=>'土默特左旗','name'=>'土默特左旗','merger_name'=>'中国,内蒙古自治区,呼和浩特市,土默特左旗','level'=>'3','pinyin'=>'tumotezuoqi','code'=>'0471','zip_code'=>'010100','first'=>'T','lng'=>'111.14898','lat'=>'40.72229']);
        $this->insert('{{%region}}',['id'=>'358','pid'=>'352','shortname'=>'托克托','name'=>'托克托县','merger_name'=>'中国,内蒙古自治区,呼和浩特市,托克托县','level'=>'3','pinyin'=>'tuoketuo','code'=>'0471','zip_code'=>'010200','first'=>'T','lng'=>'111.19101','lat'=>'40.27492']);
        $this->insert('{{%region}}',['id'=>'359','pid'=>'352','shortname'=>'和林格尔','name'=>'和林格尔县','merger_name'=>'中国,内蒙古自治区,呼和浩特市,和林格尔县','level'=>'3','pinyin'=>'helingeer','code'=>'0471','zip_code'=>'011500','first'=>'H','lng'=>'111.82205','lat'=>'40.37892']);
        $this->insert('{{%region}}',['id'=>'360','pid'=>'352','shortname'=>'清水河','name'=>'清水河县','merger_name'=>'中国,内蒙古自治区,呼和浩特市,清水河县','level'=>'3','pinyin'=>'qingshuihe','code'=>'0471','zip_code'=>'011600','first'=>'Q','lng'=>'111.68316','lat'=>'39.9097']);
        $this->insert('{{%region}}',['id'=>'361','pid'=>'352','shortname'=>'武川','name'=>'武川县','merger_name'=>'中国,内蒙古自治区,呼和浩特市,武川县','level'=>'3','pinyin'=>'wuchuan','code'=>'0471','zip_code'=>'011700','first'=>'W','lng'=>'111.45785','lat'=>'41.09289']);
        $this->insert('{{%region}}',['id'=>'362','pid'=>'351','shortname'=>'包头','name'=>'包头市','merger_name'=>'中国,内蒙古自治区,包头市','level'=>'2','pinyin'=>'baotou','code'=>'0472','zip_code'=>'014025','first'=>'B','lng'=>'109.840405','lat'=>'40.658168']);
        $this->insert('{{%region}}',['id'=>'363','pid'=>'362','shortname'=>'东河','name'=>'东河区','merger_name'=>'中国,内蒙古自治区,包头市,东河区','level'=>'3','pinyin'=>'donghe','code'=>'0472','zip_code'=>'014040','first'=>'D','lng'=>'110.0462','lat'=>'40.58237']);
        $this->insert('{{%region}}',['id'=>'364','pid'=>'362','shortname'=>'昆都仑','name'=>'昆都仑区','merger_name'=>'中国,内蒙古自治区,包头市,昆都仑区','level'=>'3','pinyin'=>'kundulun','code'=>'0472','zip_code'=>'014010','first'=>'K','lng'=>'109.83862','lat'=>'40.64175']);
        $this->insert('{{%region}}',['id'=>'365','pid'=>'362','shortname'=>'青山','name'=>'青山区','merger_name'=>'中国,内蒙古自治区,包头市,青山区','level'=>'3','pinyin'=>'qingshan','code'=>'0472','zip_code'=>'014030','first'=>'Q','lng'=>'109.90131','lat'=>'40.64329']);
        $this->insert('{{%region}}',['id'=>'366','pid'=>'362','shortname'=>'石拐','name'=>'石拐区','merger_name'=>'中国,内蒙古自治区,包头市,石拐区','level'=>'3','pinyin'=>'shiguai','code'=>'0472','zip_code'=>'014070','first'=>'S','lng'=>'110.27322','lat'=>'40.67297']);
        $this->insert('{{%region}}',['id'=>'367','pid'=>'362','shortname'=>'白云鄂博矿区','name'=>'白云鄂博矿区','merger_name'=>'中国,内蒙古自治区,包头市,白云鄂博矿区','level'=>'3','pinyin'=>'baiyunebokuangqu','code'=>'0472','zip_code'=>'014080','first'=>'B','lng'=>'109.97367','lat'=>'41.76968']);
        $this->insert('{{%region}}',['id'=>'368','pid'=>'362','shortname'=>'九原','name'=>'九原区','merger_name'=>'中国,内蒙古自治区,包头市,九原区','level'=>'3','pinyin'=>'jiuyuan','code'=>'0472','zip_code'=>'014060','first'=>'J','lng'=>'109.96496','lat'=>'40.60554']);
        $this->insert('{{%region}}',['id'=>'369','pid'=>'362','shortname'=>'土默特右旗','name'=>'土默特右旗','merger_name'=>'中国,内蒙古自治区,包头市,土默特右旗','level'=>'3','pinyin'=>'tumoteyouqi','code'=>'0472','zip_code'=>'014100','first'=>'T','lng'=>'110.52417','lat'=>'40.5688']);
        $this->insert('{{%region}}',['id'=>'370','pid'=>'362','shortname'=>'固阳','name'=>'固阳县','merger_name'=>'中国,内蒙古自治区,包头市,固阳县','level'=>'3','pinyin'=>'guyang','code'=>'0472','zip_code'=>'014200','first'=>'G','lng'=>'110.06372','lat'=>'41.01851']);
        $this->insert('{{%region}}',['id'=>'371','pid'=>'362','shortname'=>'达茂旗','name'=>'达尔罕茂明安联合旗','merger_name'=>'中国,内蒙古自治区,包头市,达尔罕茂明安联合旗','level'=>'3','pinyin'=>'damaoqi','code'=>'0472','zip_code'=>'014500','first'=>'D','lng'=>'110.43258','lat'=>'41.69875']);
        $this->insert('{{%region}}',['id'=>'372','pid'=>'351','shortname'=>'乌海','name'=>'乌海市','merger_name'=>'中国,内蒙古自治区,乌海市','level'=>'2','pinyin'=>'wuhai','code'=>'0473','zip_code'=>'016000','first'=>'W','lng'=>'106.825563','lat'=>'39.673734']);
        $this->insert('{{%region}}',['id'=>'373','pid'=>'372','shortname'=>'海勃湾','name'=>'海勃湾区','merger_name'=>'中国,内蒙古自治区,乌海市,海勃湾区','level'=>'3','pinyin'=>'haibowan','code'=>'0473','zip_code'=>'016000','first'=>'H','lng'=>'106.8222','lat'=>'39.66955']);
        $this->insert('{{%region}}',['id'=>'374','pid'=>'372','shortname'=>'海南','name'=>'海南区','merger_name'=>'中国,内蒙古自治区,乌海市,海南区','level'=>'3','pinyin'=>'hainan','code'=>'0473','zip_code'=>'016030','first'=>'H','lng'=>'106.88656','lat'=>'39.44128']);
        $this->insert('{{%region}}',['id'=>'375','pid'=>'372','shortname'=>'乌达','name'=>'乌达区','merger_name'=>'中国,内蒙古自治区,乌海市,乌达区','level'=>'3','pinyin'=>'wuda','code'=>'0473','zip_code'=>'016040','first'=>'W','lng'=>'106.72723','lat'=>'39.505']);
        $this->insert('{{%region}}',['id'=>'376','pid'=>'351','shortname'=>'赤峰','name'=>'赤峰市','merger_name'=>'中国,内蒙古自治区,赤峰市','level'=>'2','pinyin'=>'chifeng','code'=>'0476','zip_code'=>'024000','first'=>'C','lng'=>'118.956806','lat'=>'42.275317']);
        $this->insert('{{%region}}',['id'=>'377','pid'=>'376','shortname'=>'红山','name'=>'红山区','merger_name'=>'中国,内蒙古自治区,赤峰市,红山区','level'=>'3','pinyin'=>'hongshan','code'=>'0476','zip_code'=>'024020','first'=>'H','lng'=>'118.95755','lat'=>'42.24312']);
        $this->insert('{{%region}}',['id'=>'378','pid'=>'376','shortname'=>'元宝山','name'=>'元宝山区','merger_name'=>'中国,内蒙古自治区,赤峰市,元宝山区','level'=>'3','pinyin'=>'yuanbaoshan','code'=>'0476','zip_code'=>'024076','first'=>'Y','lng'=>'119.28921','lat'=>'42.04005']);
        $this->insert('{{%region}}',['id'=>'379','pid'=>'376','shortname'=>'松山','name'=>'松山区','merger_name'=>'中国,内蒙古自治区,赤峰市,松山区','level'=>'3','pinyin'=>'songshan','code'=>'0476','zip_code'=>'024005','first'=>'S','lng'=>'118.9328','lat'=>'42.28613']);
        $this->insert('{{%region}}',['id'=>'380','pid'=>'376','shortname'=>'阿鲁科尔沁旗','name'=>'阿鲁科尔沁旗','merger_name'=>'中国,内蒙古自治区,赤峰市,阿鲁科尔沁旗','level'=>'3','pinyin'=>'alukeerqinqi','code'=>'0476','zip_code'=>'025550','first'=>'A','lng'=>'120.06527','lat'=>'43.87988']);
        $this->insert('{{%region}}',['id'=>'381','pid'=>'376','shortname'=>'巴林左旗','name'=>'巴林左旗','merger_name'=>'中国,内蒙古自治区,赤峰市,巴林左旗','level'=>'3','pinyin'=>'balinzuoqi','code'=>'0476','zip_code'=>'025450','first'=>'B','lng'=>'119.38012','lat'=>'43.97031']);
        $this->insert('{{%region}}',['id'=>'382','pid'=>'376','shortname'=>'巴林右旗','name'=>'巴林右旗','merger_name'=>'中国,内蒙古自治区,赤峰市,巴林右旗','level'=>'3','pinyin'=>'balinyouqi','code'=>'0476','zip_code'=>'025150','first'=>'B','lng'=>'118.66461','lat'=>'43.53387']);
        $this->insert('{{%region}}',['id'=>'383','pid'=>'376','shortname'=>'林西','name'=>'林西县','merger_name'=>'中国,内蒙古自治区,赤峰市,林西县','level'=>'3','pinyin'=>'linxi','code'=>'0476','zip_code'=>'025250','first'=>'L','lng'=>'118.04733','lat'=>'43.61165']);
        $this->insert('{{%region}}',['id'=>'384','pid'=>'376','shortname'=>'克什克腾旗','name'=>'克什克腾旗','merger_name'=>'中国,内蒙古自治区,赤峰市,克什克腾旗','level'=>'3','pinyin'=>'keshiketengqi','code'=>'0476','zip_code'=>'025350','first'=>'K','lng'=>'117.54562','lat'=>'43.26501']);
        $this->insert('{{%region}}',['id'=>'385','pid'=>'376','shortname'=>'翁牛特旗','name'=>'翁牛特旗','merger_name'=>'中国,内蒙古自治区,赤峰市,翁牛特旗','level'=>'3','pinyin'=>'wengniuteqi','code'=>'0476','zip_code'=>'024500','first'=>'W','lng'=>'119.03042','lat'=>'42.93147']);
        $this->insert('{{%region}}',['id'=>'386','pid'=>'376','shortname'=>'喀喇沁旗','name'=>'喀喇沁旗','merger_name'=>'中国,内蒙古自治区,赤峰市,喀喇沁旗','level'=>'3','pinyin'=>'kalaqinqi','code'=>'0476','zip_code'=>'024400','first'=>'K','lng'=>'118.70144','lat'=>'41.92917']);
        $this->insert('{{%region}}',['id'=>'387','pid'=>'376','shortname'=>'宁城','name'=>'宁城县','merger_name'=>'中国,内蒙古自治区,赤峰市,宁城县','level'=>'3','pinyin'=>'ningcheng','code'=>'0476','zip_code'=>'024200','first'=>'N','lng'=>'119.34375','lat'=>'41.59661']);
        $this->insert('{{%region}}',['id'=>'388','pid'=>'376','shortname'=>'敖汉旗','name'=>'敖汉旗','merger_name'=>'中国,内蒙古自治区,赤峰市,敖汉旗','level'=>'3','pinyin'=>'aohanqi','code'=>'0476','zip_code'=>'024300','first'=>'A','lng'=>'119.92163','lat'=>'42.29071']);
        $this->insert('{{%region}}',['id'=>'389','pid'=>'351','shortname'=>'通辽','name'=>'通辽市','merger_name'=>'中国,内蒙古自治区,通辽市','level'=>'2','pinyin'=>'tongliao','code'=>'0475','zip_code'=>'028000','first'=>'T','lng'=>'122.263119','lat'=>'43.617429']);
        $this->insert('{{%region}}',['id'=>'390','pid'=>'389','shortname'=>'科尔沁','name'=>'科尔沁区','merger_name'=>'中国,内蒙古自治区,通辽市,科尔沁区','level'=>'3','pinyin'=>'keerqin','code'=>'0475','zip_code'=>'028000','first'=>'K','lng'=>'122.25573','lat'=>'43.62257']);
        $this->insert('{{%region}}',['id'=>'391','pid'=>'389','shortname'=>'科尔沁左翼中旗','name'=>'科尔沁左翼中旗','merger_name'=>'中国,内蒙古自治区,通辽市,科尔沁左翼中旗','level'=>'3','pinyin'=>'keerqinzuoyizhongqi','code'=>'0475','zip_code'=>'029300','first'=>'K','lng'=>'123.31912','lat'=>'44.13014']);
        $this->insert('{{%region}}',['id'=>'392','pid'=>'389','shortname'=>'科尔沁左翼后旗','name'=>'科尔沁左翼后旗','merger_name'=>'中国,内蒙古自治区,通辽市,科尔沁左翼后旗','level'=>'3','pinyin'=>'keerqinzuoyihouqi','code'=>'0475','zip_code'=>'028100','first'=>'K','lng'=>'122.35745','lat'=>'42.94897']);
        $this->insert('{{%region}}',['id'=>'393','pid'=>'389','shortname'=>'开鲁','name'=>'开鲁县','merger_name'=>'中国,内蒙古自治区,通辽市,开鲁县','level'=>'3','pinyin'=>'kailu','code'=>'0475','zip_code'=>'028400','first'=>'K','lng'=>'121.31884','lat'=>'43.60003']);
        $this->insert('{{%region}}',['id'=>'394','pid'=>'389','shortname'=>'库伦旗','name'=>'库伦旗','merger_name'=>'中国,内蒙古自治区,通辽市,库伦旗','level'=>'3','pinyin'=>'kulunqi','code'=>'0475','zip_code'=>'028200','first'=>'K','lng'=>'121.776','lat'=>'42.72998']);
        $this->insert('{{%region}}',['id'=>'395','pid'=>'389','shortname'=>'奈曼旗','name'=>'奈曼旗','merger_name'=>'中国,内蒙古自治区,通辽市,奈曼旗','level'=>'3','pinyin'=>'naimanqi','code'=>'0475','zip_code'=>'028300','first'=>'N','lng'=>'120.66348','lat'=>'42.84527']);
        $this->insert('{{%region}}',['id'=>'396','pid'=>'389','shortname'=>'扎鲁特旗','name'=>'扎鲁特旗','merger_name'=>'中国,内蒙古自治区,通辽市,扎鲁特旗','level'=>'3','pinyin'=>'zhaluteqi','code'=>'0475','zip_code'=>'029100','first'=>'Z','lng'=>'120.91507','lat'=>'44.55592']);
        $this->insert('{{%region}}',['id'=>'397','pid'=>'389','shortname'=>'霍林郭勒','name'=>'霍林郭勒市','merger_name'=>'中国,内蒙古自治区,通辽市,霍林郭勒市','level'=>'3','pinyin'=>'huolinguole','code'=>'0475','zip_code'=>'029200','first'=>'H','lng'=>'119.65429','lat'=>'45.53454']);
        $this->insert('{{%region}}',['id'=>'398','pid'=>'351','shortname'=>'鄂尔多斯','name'=>'鄂尔多斯市','merger_name'=>'中国,内蒙古自治区,鄂尔多斯市','level'=>'2','pinyin'=>'ordos','code'=>'0477','zip_code'=>'017004','first'=>'E','lng'=>'109.99029','lat'=>'39.817179']);
        $this->insert('{{%region}}',['id'=>'399','pid'=>'398','shortname'=>'东胜','name'=>'东胜区','merger_name'=>'中国,内蒙古自治区,鄂尔多斯市,东胜区','level'=>'3','pinyin'=>'dongsheng','code'=>'0477','zip_code'=>'017000','first'=>'D','lng'=>'109.96289','lat'=>'39.82236']);
        $this->insert('{{%region}}',['id'=>'400','pid'=>'398','shortname'=>'达拉特旗','name'=>'达拉特旗','merger_name'=>'中国,内蒙古自治区,鄂尔多斯市,达拉特旗','level'=>'3','pinyin'=>'dalateqi','code'=>'0477','zip_code'=>'014300','first'=>'D','lng'=>'110.03317','lat'=>'40.4001']);
        $this->insert('{{%region}}',['id'=>'401','pid'=>'398','shortname'=>'准格尔旗','name'=>'准格尔旗','merger_name'=>'中国,内蒙古自治区,鄂尔多斯市,准格尔旗','level'=>'3','pinyin'=>'zhungeerqi','code'=>'0477','zip_code'=>'017100','first'=>'Z','lng'=>'111.23645','lat'=>'39.86783']);
        $this->insert('{{%region}}',['id'=>'402','pid'=>'398','shortname'=>'鄂托克前旗','name'=>'鄂托克前旗','merger_name'=>'中国,内蒙古自治区,鄂尔多斯市,鄂托克前旗','level'=>'3','pinyin'=>'etuokeqianqi','code'=>'0477','zip_code'=>'016200','first'=>'E','lng'=>'107.48403','lat'=>'38.18396']);
        $this->insert('{{%region}}',['id'=>'403','pid'=>'398','shortname'=>'鄂托克旗','name'=>'鄂托克旗','merger_name'=>'中国,内蒙古自治区,鄂尔多斯市,鄂托克旗','level'=>'3','pinyin'=>'etuokeqi','code'=>'0477','zip_code'=>'016100','first'=>'E','lng'=>'107.98226','lat'=>'39.09456']);
        $this->insert('{{%region}}',['id'=>'404','pid'=>'398','shortname'=>'杭锦旗','name'=>'杭锦旗','merger_name'=>'中国,内蒙古自治区,鄂尔多斯市,杭锦旗','level'=>'3','pinyin'=>'hangjinqi','code'=>'0477','zip_code'=>'017400','first'=>'H','lng'=>'108.72934','lat'=>'39.84023']);
        $this->insert('{{%region}}',['id'=>'405','pid'=>'398','shortname'=>'乌审旗','name'=>'乌审旗','merger_name'=>'中国,内蒙古自治区,鄂尔多斯市,乌审旗','level'=>'3','pinyin'=>'wushenqi','code'=>'0477','zip_code'=>'017300','first'=>'W','lng'=>'108.8461','lat'=>'38.59092']);
        $this->insert('{{%region}}',['id'=>'406','pid'=>'398','shortname'=>'伊金霍洛旗','name'=>'伊金霍洛旗','merger_name'=>'中国,内蒙古自治区,鄂尔多斯市,伊金霍洛旗','level'=>'3','pinyin'=>'yijinhuoluoqi','code'=>'0477','zip_code'=>'017200','first'=>'Y','lng'=>'109.74908','lat'=>'39.57393']);
        $this->insert('{{%region}}',['id'=>'407','pid'=>'351','shortname'=>'呼伦贝尔','name'=>'呼伦贝尔市','merger_name'=>'中国,内蒙古自治区,呼伦贝尔市','level'=>'2','pinyin'=>'hulunber','code'=>'0470','zip_code'=>'021008','first'=>'H','lng'=>'119.758168','lat'=>'49.215333']);
        $this->insert('{{%region}}',['id'=>'408','pid'=>'407','shortname'=>'海拉尔','name'=>'海拉尔区','merger_name'=>'中国,内蒙古自治区,呼伦贝尔市,海拉尔区','level'=>'3','pinyin'=>'hailaer','code'=>'0470','zip_code'=>'021000','first'=>'H','lng'=>'119.7364','lat'=>'49.2122']);
        $this->insert('{{%region}}',['id'=>'409','pid'=>'407','shortname'=>'扎赉诺尔','name'=>'扎赉诺尔区','merger_name'=>'中国,内蒙古自治区,呼伦贝尔市,扎赉诺尔区','level'=>'3','pinyin'=>'zhalainuoer','code'=>'0470','zip_code'=>'021410','first'=>'Z','lng'=>'117.792702','lat'=>'49.486943']);
        $this->insert('{{%region}}',['id'=>'410','pid'=>'407','shortname'=>'阿荣旗','name'=>'阿荣旗','merger_name'=>'中国,内蒙古自治区,呼伦贝尔市,阿荣旗','level'=>'3','pinyin'=>'arongqi','code'=>'0470','zip_code'=>'162750','first'=>'A','lng'=>'123.45941','lat'=>'48.12581']);
        $this->insert('{{%region}}',['id'=>'411','pid'=>'407','shortname'=>'莫旗','name'=>'莫力达瓦达斡尔族自治旗','merger_name'=>'中国,内蒙古自治区,呼伦贝尔市,莫力达瓦达斡尔族自治旗','level'=>'3','pinyin'=>'moqi','code'=>'0470','zip_code'=>'162850','first'=>'M','lng'=>'124.51498','lat'=>'48.48055']);
        $this->insert('{{%region}}',['id'=>'412','pid'=>'407','shortname'=>'鄂伦春','name'=>'鄂伦春自治旗','merger_name'=>'中国,内蒙古自治区,呼伦贝尔市,鄂伦春自治旗','level'=>'3','pinyin'=>'elunchun','code'=>'0470','zip_code'=>'165450','first'=>'E','lng'=>'123.72604','lat'=>'50.59777']);
        $this->insert('{{%region}}',['id'=>'413','pid'=>'407','shortname'=>'鄂温','name'=>'鄂温克族自治旗','merger_name'=>'中国,内蒙古自治区,呼伦贝尔市,鄂温克族自治旗','level'=>'3','pinyin'=>'ewen','code'=>'0470','zip_code'=>'021100','first'=>'E','lng'=>'119.7565','lat'=>'49.14284']);
        $this->insert('{{%region}}',['id'=>'414','pid'=>'407','shortname'=>'陈巴尔虎旗','name'=>'陈巴尔虎旗','merger_name'=>'中国,内蒙古自治区,呼伦贝尔市,陈巴尔虎旗','level'=>'3','pinyin'=>'chenbaerhuqi','code'=>'0470','zip_code'=>'021500','first'=>'C','lng'=>'119.42434','lat'=>'49.32684']);
        $this->insert('{{%region}}',['id'=>'415','pid'=>'407','shortname'=>'新巴尔虎左旗','name'=>'新巴尔虎左旗','merger_name'=>'中国,内蒙古自治区,呼伦贝尔市,新巴尔虎左旗','level'=>'3','pinyin'=>'xinbaerhuzuoqi','code'=>'0470','zip_code'=>'021200','first'=>'X','lng'=>'118.26989','lat'=>'48.21842']);
        $this->insert('{{%region}}',['id'=>'416','pid'=>'407','shortname'=>'新巴尔虎右旗','name'=>'新巴尔虎右旗','merger_name'=>'中国,内蒙古自治区,呼伦贝尔市,新巴尔虎右旗','level'=>'3','pinyin'=>'xinbaerhuyouqi','code'=>'0470','zip_code'=>'021300','first'=>'X','lng'=>'116.82366','lat'=>'48.66473']);
        $this->insert('{{%region}}',['id'=>'417','pid'=>'407','shortname'=>'满洲里','name'=>'满洲里市','merger_name'=>'中国,内蒙古自治区,呼伦贝尔市,满洲里市','level'=>'3','pinyin'=>'manzhouli','code'=>'0470','zip_code'=>'021400','first'=>'M','lng'=>'117.47946','lat'=>'49.58272']);
        $this->insert('{{%region}}',['id'=>'418','pid'=>'407','shortname'=>'牙克石','name'=>'牙克石市','merger_name'=>'中国,内蒙古自治区,呼伦贝尔市,牙克石市','level'=>'3','pinyin'=>'yakeshi','code'=>'0470','zip_code'=>'022150','first'=>'Y','lng'=>'120.7117','lat'=>'49.2856']);
        $this->insert('{{%region}}',['id'=>'419','pid'=>'407','shortname'=>'扎兰屯','name'=>'扎兰屯市','merger_name'=>'中国,内蒙古自治区,呼伦贝尔市,扎兰屯市','level'=>'3','pinyin'=>'zhalantun','code'=>'0470','zip_code'=>'162650','first'=>'Z','lng'=>'122.73757','lat'=>'48.01363']);
        $this->insert('{{%region}}',['id'=>'420','pid'=>'407','shortname'=>'额尔古纳','name'=>'额尔古纳市','merger_name'=>'中国,内蒙古自治区,呼伦贝尔市,额尔古纳市','level'=>'3','pinyin'=>'eerguna','code'=>'0470','zip_code'=>'022250','first'=>'E','lng'=>'120.19094','lat'=>'50.24249']);
        $this->insert('{{%region}}',['id'=>'421','pid'=>'407','shortname'=>'根河','name'=>'根河市','merger_name'=>'中国,内蒙古自治区,呼伦贝尔市,根河市','level'=>'3','pinyin'=>'genhe','code'=>'0470','zip_code'=>'022350','first'=>'G','lng'=>'121.52197','lat'=>'50.77996']);
        $this->insert('{{%region}}',['id'=>'422','pid'=>'351','shortname'=>'巴彦淖尔','name'=>'巴彦淖尔市','merger_name'=>'中国,内蒙古自治区,巴彦淖尔市','level'=>'2','pinyin'=>'bayannur','code'=>'0478','zip_code'=>'015001','first'=>'B','lng'=>'107.416959','lat'=>'40.757402']);
        $this->insert('{{%region}}',['id'=>'423','pid'=>'422','shortname'=>'临河','name'=>'临河区','merger_name'=>'中国,内蒙古自治区,巴彦淖尔市,临河区','level'=>'3','pinyin'=>'linhe','code'=>'0478','zip_code'=>'015001','first'=>'L','lng'=>'107.42668','lat'=>'40.75827']);
        $this->insert('{{%region}}',['id'=>'424','pid'=>'422','shortname'=>'五原','name'=>'五原县','merger_name'=>'中国,内蒙古自治区,巴彦淖尔市,五原县','level'=>'3','pinyin'=>'wuyuan','code'=>'0478','zip_code'=>'015100','first'=>'W','lng'=>'108.26916','lat'=>'41.09631']);
        $this->insert('{{%region}}',['id'=>'425','pid'=>'422','shortname'=>'磴口','name'=>'磴口县','merger_name'=>'中国,内蒙古自治区,巴彦淖尔市,磴口县','level'=>'3','pinyin'=>'dengkou','code'=>'0478','zip_code'=>'015200','first'=>NULL,'lng'=>'107.00936','lat'=>'40.33062']);
        $this->insert('{{%region}}',['id'=>'426','pid'=>'422','shortname'=>'乌拉特前旗','name'=>'乌拉特前旗','merger_name'=>'中国,内蒙古自治区,巴彦淖尔市,乌拉特前旗','level'=>'3','pinyin'=>'wulateqianqi','code'=>'0478','zip_code'=>'014400','first'=>'W','lng'=>'108.65219','lat'=>'40.73649']);
        $this->insert('{{%region}}',['id'=>'427','pid'=>'422','shortname'=>'乌拉特中旗','name'=>'乌拉特中旗','merger_name'=>'中国,内蒙古自治区,巴彦淖尔市,乌拉特中旗','level'=>'3','pinyin'=>'wulatezhongqi','code'=>'0478','zip_code'=>'015300','first'=>'W','lng'=>'108.52587','lat'=>'41.56789']);
        $this->insert('{{%region}}',['id'=>'428','pid'=>'422','shortname'=>'乌拉特后旗','name'=>'乌拉特后旗','merger_name'=>'中国,内蒙古自治区,巴彦淖尔市,乌拉特后旗','level'=>'3','pinyin'=>'wulatehouqi','code'=>'0478','zip_code'=>'015500','first'=>'W','lng'=>'106.98971','lat'=>'41.43151']);
        $this->insert('{{%region}}',['id'=>'429','pid'=>'422','shortname'=>'杭锦后旗','name'=>'杭锦后旗','merger_name'=>'中国,内蒙古自治区,巴彦淖尔市,杭锦后旗','level'=>'3','pinyin'=>'hangjinhouqi','code'=>'0478','zip_code'=>'015400','first'=>'H','lng'=>'107.15133','lat'=>'40.88627']);
        $this->insert('{{%region}}',['id'=>'430','pid'=>'351','shortname'=>'乌兰察布','name'=>'乌兰察布市','merger_name'=>'中国,内蒙古自治区,乌兰察布市','level'=>'2','pinyin'=>'ulanqab','code'=>'0474','zip_code'=>'012000','first'=>'W','lng'=>'113.114543','lat'=>'41.034126']);
        $this->insert('{{%region}}',['id'=>'431','pid'=>'430','shortname'=>'集宁','name'=>'集宁区','merger_name'=>'中国,内蒙古自治区,乌兰察布市,集宁区','level'=>'3','pinyin'=>'jining','code'=>'0474','zip_code'=>'012000','first'=>'J','lng'=>'113.11452','lat'=>'41.0353']);
        $this->insert('{{%region}}',['id'=>'432','pid'=>'430','shortname'=>'卓资','name'=>'卓资县','merger_name'=>'中国,内蒙古自治区,乌兰察布市,卓资县','level'=>'3','pinyin'=>'zhuozi','code'=>'0474','zip_code'=>'012300','first'=>'Z','lng'=>'112.57757','lat'=>'40.89414']);
        $this->insert('{{%region}}',['id'=>'433','pid'=>'430','shortname'=>'化德','name'=>'化德县','merger_name'=>'中国,内蒙古自治区,乌兰察布市,化德县','level'=>'3','pinyin'=>'huade','code'=>'0474','zip_code'=>'013350','first'=>'H','lng'=>'114.01071','lat'=>'41.90433']);
        $this->insert('{{%region}}',['id'=>'434','pid'=>'430','shortname'=>'商都','name'=>'商都县','merger_name'=>'中国,内蒙古自治区,乌兰察布市,商都县','level'=>'3','pinyin'=>'shangdu','code'=>'0474','zip_code'=>'013450','first'=>'S','lng'=>'113.57772','lat'=>'41.56213']);
        $this->insert('{{%region}}',['id'=>'435','pid'=>'430','shortname'=>'兴和','name'=>'兴和县','merger_name'=>'中国,内蒙古自治区,乌兰察布市,兴和县','level'=>'3','pinyin'=>'xinghe','code'=>'0474','zip_code'=>'013650','first'=>'X','lng'=>'113.83395','lat'=>'40.87186']);
        $this->insert('{{%region}}',['id'=>'436','pid'=>'430','shortname'=>'凉城','name'=>'凉城县','merger_name'=>'中国,内蒙古自治区,乌兰察布市,凉城县','level'=>'3','pinyin'=>'liangcheng','code'=>'0474','zip_code'=>'013750','first'=>'L','lng'=>'112.49569','lat'=>'40.53346']);
        $this->insert('{{%region}}',['id'=>'437','pid'=>'430','shortname'=>'察右前旗','name'=>'察哈尔右翼前旗','merger_name'=>'中国,内蒙古自治区,乌兰察布市,察哈尔右翼前旗','level'=>'3','pinyin'=>'chayouqianqi','code'=>'0474','zip_code'=>'012200','first'=>'C','lng'=>'113.22131','lat'=>'40.7788']);
        $this->insert('{{%region}}',['id'=>'438','pid'=>'430','shortname'=>'察右中旗','name'=>'察哈尔右翼中旗','merger_name'=>'中国,内蒙古自治区,乌兰察布市,察哈尔右翼中旗','level'=>'3','pinyin'=>'chayouzhongqi','code'=>'0474','zip_code'=>'013550','first'=>'C','lng'=>'112.63537','lat'=>'41.27742']);
        $this->insert('{{%region}}',['id'=>'439','pid'=>'430','shortname'=>'察右后旗','name'=>'察哈尔右翼后旗','merger_name'=>'中国,内蒙古自治区,乌兰察布市,察哈尔右翼后旗','level'=>'3','pinyin'=>'chayouhouqi','code'=>'0474','zip_code'=>'012400','first'=>'C','lng'=>'113.19216','lat'=>'41.43554']);
        $this->insert('{{%region}}',['id'=>'440','pid'=>'430','shortname'=>'四子王旗','name'=>'四子王旗','merger_name'=>'中国,内蒙古自治区,乌兰察布市,四子王旗','level'=>'3','pinyin'=>'siziwangqi','code'=>'0474','zip_code'=>'011800','first'=>'S','lng'=>'111.70654','lat'=>'41.53312']);
        $this->insert('{{%region}}',['id'=>'441','pid'=>'430','shortname'=>'丰镇','name'=>'丰镇市','merger_name'=>'中国,内蒙古自治区,乌兰察布市,丰镇市','level'=>'3','pinyin'=>'fengzhen','code'=>'0474','zip_code'=>'012100','first'=>'F','lng'=>'113.10983','lat'=>'40.4369']);
        $this->insert('{{%region}}',['id'=>'442','pid'=>'351','shortname'=>'兴安盟','name'=>'兴安盟','merger_name'=>'中国,内蒙古自治区,兴安盟','level'=>'2','pinyin'=>'hinggan','code'=>'0482','zip_code'=>'137401','first'=>'X','lng'=>'122.070317','lat'=>'46.076268']);
        $this->insert('{{%region}}',['id'=>'443','pid'=>'442','shortname'=>'乌兰浩特','name'=>'乌兰浩特市','merger_name'=>'中国,内蒙古自治区,兴安盟,乌兰浩特市','level'=>'3','pinyin'=>'wulanhaote','code'=>'0482','zip_code'=>'137401','first'=>'W','lng'=>'122.06378','lat'=>'46.06235']);
        $this->insert('{{%region}}',['id'=>'444','pid'=>'442','shortname'=>'阿尔山','name'=>'阿尔山市','merger_name'=>'中国,内蒙古自治区,兴安盟,阿尔山市','level'=>'3','pinyin'=>'aershan','code'=>'0482','zip_code'=>'137800','first'=>'A','lng'=>'119.94317','lat'=>'47.17716']);
        $this->insert('{{%region}}',['id'=>'445','pid'=>'442','shortname'=>'科右前旗','name'=>'科尔沁右翼前旗','merger_name'=>'中国,内蒙古自治区,兴安盟,科尔沁右翼前旗','level'=>'3','pinyin'=>'keyouqianqi','code'=>'0482','zip_code'=>'137423','first'=>'K','lng'=>'121.95269','lat'=>'46.0795']);
        $this->insert('{{%region}}',['id'=>'446','pid'=>'442','shortname'=>'科右中旗','name'=>'科尔沁右翼中旗','merger_name'=>'中国,内蒙古自治区,兴安盟,科尔沁右翼中旗','level'=>'3','pinyin'=>'keyouzhongqi','code'=>'0482','zip_code'=>'029400','first'=>'K','lng'=>'121.46807','lat'=>'45.05605']);
        $this->insert('{{%region}}',['id'=>'447','pid'=>'442','shortname'=>'扎赉特旗','name'=>'扎赉特旗','merger_name'=>'中国,内蒙古自治区,兴安盟,扎赉特旗','level'=>'3','pinyin'=>'zhalaiteqi','code'=>'0482','zip_code'=>'137600','first'=>'Z','lng'=>'122.91229','lat'=>'46.7267']);
        $this->insert('{{%region}}',['id'=>'448','pid'=>'442','shortname'=>'突泉','name'=>'突泉县','merger_name'=>'中国,内蒙古自治区,兴安盟,突泉县','level'=>'3','pinyin'=>'tuquan','code'=>'0482','zip_code'=>'137500','first'=>'T','lng'=>'121.59396','lat'=>'45.38187']);
        $this->insert('{{%region}}',['id'=>'449','pid'=>'351','shortname'=>'锡林郭勒盟','name'=>'锡林郭勒盟','merger_name'=>'中国,内蒙古自治区,锡林郭勒盟','level'=>'2','pinyin'=>'xilingol','code'=>'0479','zip_code'=>'026000','first'=>'X','lng'=>'116.090996','lat'=>'43.944018']);
        $this->insert('{{%region}}',['id'=>'450','pid'=>'449','shortname'=>'二连浩特','name'=>'二连浩特市','merger_name'=>'中国,内蒙古自治区,锡林郭勒盟,二连浩特市','level'=>'3','pinyin'=>'erlianhaote','code'=>'0479','zip_code'=>'011100','first'=>'E','lng'=>'111.98297','lat'=>'43.65303']);
        $this->insert('{{%region}}',['id'=>'451','pid'=>'449','shortname'=>'锡林浩特','name'=>'锡林浩特市','merger_name'=>'中国,内蒙古自治区,锡林郭勒盟,锡林浩特市','level'=>'3','pinyin'=>'xilinhaote','code'=>'0479','zip_code'=>'026021','first'=>'X','lng'=>'116.08603','lat'=>'43.93341']);
        $this->insert('{{%region}}',['id'=>'452','pid'=>'449','shortname'=>'阿巴嘎旗','name'=>'阿巴嘎旗','merger_name'=>'中国,内蒙古自治区,锡林郭勒盟,阿巴嘎旗','level'=>'3','pinyin'=>'abagaqi','code'=>'0479','zip_code'=>'011400','first'=>'A','lng'=>'114.96826','lat'=>'44.02174']);
        $this->insert('{{%region}}',['id'=>'453','pid'=>'449','shortname'=>'苏尼特左旗','name'=>'苏尼特左旗','merger_name'=>'中国,内蒙古自治区,锡林郭勒盟,苏尼特左旗','level'=>'3','pinyin'=>'sunitezuoqi','code'=>'0479','zip_code'=>'011300','first'=>'S','lng'=>'113.6506','lat'=>'43.85687']);
        $this->insert('{{%region}}',['id'=>'454','pid'=>'449','shortname'=>'苏尼特右旗','name'=>'苏尼特右旗','merger_name'=>'中国,内蒙古自治区,锡林郭勒盟,苏尼特右旗','level'=>'3','pinyin'=>'suniteyouqi','code'=>'0479','zip_code'=>'011200','first'=>'S','lng'=>'112.65741','lat'=>'42.7469']);
        $this->insert('{{%region}}',['id'=>'455','pid'=>'449','shortname'=>'东乌旗','name'=>'东乌珠穆沁旗','merger_name'=>'中国,内蒙古自治区,锡林郭勒盟,东乌珠穆沁旗','level'=>'3','pinyin'=>'dongwuqi','code'=>'0479','zip_code'=>'026300','first'=>'D','lng'=>'116.97293','lat'=>'45.51108']);
        $this->insert('{{%region}}',['id'=>'456','pid'=>'449','shortname'=>'西乌旗','name'=>'西乌珠穆沁旗','merger_name'=>'中国,内蒙古自治区,锡林郭勒盟,西乌珠穆沁旗','level'=>'3','pinyin'=>'xiwuqi','code'=>'0479','zip_code'=>'026200','first'=>'X','lng'=>'117.60983','lat'=>'44.59623']);
        $this->insert('{{%region}}',['id'=>'457','pid'=>'449','shortname'=>'太仆寺旗','name'=>'太仆寺旗','merger_name'=>'中国,内蒙古自治区,锡林郭勒盟,太仆寺旗','level'=>'3','pinyin'=>'taipusiqi','code'=>'0479','zip_code'=>'027000','first'=>'T','lng'=>'115.28302','lat'=>'41.87727']);
        $this->insert('{{%region}}',['id'=>'458','pid'=>'449','shortname'=>'镶黄旗','name'=>'镶黄旗','merger_name'=>'中国,内蒙古自治区,锡林郭勒盟,镶黄旗','level'=>'3','pinyin'=>'xianghuangqi','code'=>'0479','zip_code'=>'013250','first'=>'X','lng'=>'113.84472','lat'=>'42.23927']);
        $this->insert('{{%region}}',['id'=>'459','pid'=>'449','shortname'=>'正镶白旗','name'=>'正镶白旗','merger_name'=>'中国,内蒙古自治区,锡林郭勒盟,正镶白旗','level'=>'3','pinyin'=>'zhengxiangbaiqi','code'=>'0479','zip_code'=>'013800','first'=>'Z','lng'=>'115.00067','lat'=>'42.30712']);
        $this->insert('{{%region}}',['id'=>'460','pid'=>'449','shortname'=>'正蓝旗','name'=>'正蓝旗','merger_name'=>'中国,内蒙古自治区,锡林郭勒盟,正蓝旗','level'=>'3','pinyin'=>'zhenglanqi','code'=>'0479','zip_code'=>'027200','first'=>'Z','lng'=>'116.00363','lat'=>'42.25229']);
        $this->insert('{{%region}}',['id'=>'461','pid'=>'449','shortname'=>'多伦','name'=>'多伦县','merger_name'=>'中国,内蒙古自治区,锡林郭勒盟,多伦县','level'=>'3','pinyin'=>'duolun','code'=>'0479','zip_code'=>'027300','first'=>'D','lng'=>'116.48565','lat'=>'42.203']);
        $this->insert('{{%region}}',['id'=>'462','pid'=>'351','shortname'=>'阿拉善盟','name'=>'阿拉善盟','merger_name'=>'中国,内蒙古自治区,阿拉善盟','level'=>'2','pinyin'=>'alxa','code'=>'0483','zip_code'=>'750306','first'=>'A','lng'=>'105.706422','lat'=>'38.844814']);
        $this->insert('{{%region}}',['id'=>'463','pid'=>'462','shortname'=>'阿拉善左旗','name'=>'阿拉善左旗','merger_name'=>'中国,内蒙古自治区,阿拉善盟,阿拉善左旗','level'=>'3','pinyin'=>'alashanzuoqi','code'=>'0483','zip_code'=>'750306','first'=>'A','lng'=>'105.67532','lat'=>'38.8293']);
        $this->insert('{{%region}}',['id'=>'464','pid'=>'462','shortname'=>'阿拉善右旗','name'=>'阿拉善右旗','merger_name'=>'中国,内蒙古自治区,阿拉善盟,阿拉善右旗','level'=>'3','pinyin'=>'alashanyouqi','code'=>'0483','zip_code'=>'737300','first'=>'A','lng'=>'101.66705','lat'=>'39.21533']);
        $this->insert('{{%region}}',['id'=>'465','pid'=>'462','shortname'=>'额济纳旗','name'=>'额济纳旗','merger_name'=>'中国,内蒙古自治区,阿拉善盟,额济纳旗','level'=>'3','pinyin'=>'ejinaqi','code'=>'0483','zip_code'=>'735400','first'=>'E','lng'=>'101.06887','lat'=>'41.96755']);
        $this->insert('{{%region}}',['id'=>'466','pid'=>'0','shortname'=>'辽宁','name'=>'辽宁省','merger_name'=>'中国,辽宁省','level'=>'1','pinyin'=>'liaoning','code'=>'','zip_code'=>'','first'=>'L','lng'=>'123.429096','lat'=>'41.796767']);
        $this->insert('{{%region}}',['id'=>'467','pid'=>'466','shortname'=>'沈阳','name'=>'沈阳市','merger_name'=>'中国,辽宁省,沈阳市','level'=>'2','pinyin'=>'shenyang','code'=>'024','zip_code'=>'110013','first'=>'S','lng'=>'123.429096','lat'=>'41.796767']);
        $this->insert('{{%region}}',['id'=>'468','pid'=>'467','shortname'=>'和平','name'=>'和平区','merger_name'=>'中国,辽宁省,沈阳市,和平区','level'=>'3','pinyin'=>'heping','code'=>'024','zip_code'=>'110001','first'=>'H','lng'=>'123.4204','lat'=>'41.78997']);
        $this->insert('{{%region}}',['id'=>'469','pid'=>'467','shortname'=>'沈河','name'=>'沈河区','merger_name'=>'中国,辽宁省,沈阳市,沈河区','level'=>'3','pinyin'=>'shenhe','code'=>'024','zip_code'=>'110011','first'=>'S','lng'=>'123.45871','lat'=>'41.79625']);
        $this->insert('{{%region}}',['id'=>'470','pid'=>'467','shortname'=>'大东','name'=>'大东区','merger_name'=>'中国,辽宁省,沈阳市,大东区','level'=>'3','pinyin'=>'dadong','code'=>'024','zip_code'=>'110041','first'=>'D','lng'=>'123.46997','lat'=>'41.80539']);
        $this->insert('{{%region}}',['id'=>'471','pid'=>'467','shortname'=>'皇姑','name'=>'皇姑区','merger_name'=>'中国,辽宁省,沈阳市,皇姑区','level'=>'3','pinyin'=>'huanggu','code'=>'024','zip_code'=>'110031','first'=>'H','lng'=>'123.42527','lat'=>'41.82035']);
        $this->insert('{{%region}}',['id'=>'472','pid'=>'467','shortname'=>'铁西','name'=>'铁西区','merger_name'=>'中国,辽宁省,沈阳市,铁西区','level'=>'3','pinyin'=>'tiexi','code'=>'024','zip_code'=>'110021','first'=>'T','lng'=>'123.37675','lat'=>'41.80269']);
        $this->insert('{{%region}}',['id'=>'473','pid'=>'467','shortname'=>'苏家屯','name'=>'苏家屯区','merger_name'=>'中国,辽宁省,沈阳市,苏家屯区','level'=>'3','pinyin'=>'sujiatun','code'=>'024','zip_code'=>'110101','first'=>'S','lng'=>'123.34405','lat'=>'41.66475']);
        $this->insert('{{%region}}',['id'=>'474','pid'=>'467','shortname'=>'浑南','name'=>'浑南区','merger_name'=>'中国,辽宁省,沈阳市,浑南区','level'=>'3','pinyin'=>'hunnan','code'=>'024','zip_code'=>'110015','first'=>'H','lng'=>'123.457707','lat'=>'41.719450']);
        $this->insert('{{%region}}',['id'=>'475','pid'=>'467','shortname'=>'沈北新区','name'=>'沈北新区','merger_name'=>'中国,辽宁省,沈阳市,沈北新区','level'=>'3','pinyin'=>'shenbeixinqu','code'=>'024','zip_code'=>'110121','first'=>'S','lng'=>'123.52658','lat'=>'42.05297']);
        $this->insert('{{%region}}',['id'=>'476','pid'=>'467','shortname'=>'于洪','name'=>'于洪区','merger_name'=>'中国,辽宁省,沈阳市,于洪区','level'=>'3','pinyin'=>'yuhong','code'=>'024','zip_code'=>'110141','first'=>'Y','lng'=>'123.30807','lat'=>'41.794']);
        $this->insert('{{%region}}',['id'=>'477','pid'=>'467','shortname'=>'辽中','name'=>'辽中县','merger_name'=>'中国,辽宁省,沈阳市,辽中县','level'=>'3','pinyin'=>'liaozhong','code'=>'024','zip_code'=>'110200','first'=>'L','lng'=>'122.72659','lat'=>'41.51302']);
        $this->insert('{{%region}}',['id'=>'478','pid'=>'467','shortname'=>'康平','name'=>'康平县','merger_name'=>'中国,辽宁省,沈阳市,康平县','level'=>'3','pinyin'=>'kangping','code'=>'024','zip_code'=>'110500','first'=>'K','lng'=>'123.35446','lat'=>'42.75081']);
        $this->insert('{{%region}}',['id'=>'479','pid'=>'467','shortname'=>'法库','name'=>'法库县','merger_name'=>'中国,辽宁省,沈阳市,法库县','level'=>'3','pinyin'=>'faku','code'=>'024','zip_code'=>'110400','first'=>'F','lng'=>'123.41214','lat'=>'42.50608']);
        $this->insert('{{%region}}',['id'=>'480','pid'=>'467','shortname'=>'新民','name'=>'新民市','merger_name'=>'中国,辽宁省,沈阳市,新民市','level'=>'3','pinyin'=>'xinmin','code'=>'024','zip_code'=>'110300','first'=>'X','lng'=>'122.82867','lat'=>'41.99847']);
        $this->insert('{{%region}}',['id'=>'481','pid'=>'466','shortname'=>'大连','name'=>'大连市','merger_name'=>'中国,辽宁省,大连市','level'=>'2','pinyin'=>'dalian','code'=>'0411','zip_code'=>'116011','first'=>'D','lng'=>'121.618622','lat'=>'38.91459']);
        $this->insert('{{%region}}',['id'=>'482','pid'=>'481','shortname'=>'中山','name'=>'中山区','merger_name'=>'中国,辽宁省,大连市,中山区','level'=>'3','pinyin'=>'zhongshan','code'=>'0411','zip_code'=>'116001','first'=>'Z','lng'=>'121.64465','lat'=>'38.91859']);
        $this->insert('{{%region}}',['id'=>'483','pid'=>'481','shortname'=>'西岗','name'=>'西岗区','merger_name'=>'中国,辽宁省,大连市,西岗区','level'=>'3','pinyin'=>'xigang','code'=>'0411','zip_code'=>'116011','first'=>'X','lng'=>'121.61238','lat'=>'38.91469']);
        $this->insert('{{%region}}',['id'=>'484','pid'=>'481','shortname'=>'沙河口','name'=>'沙河口区','merger_name'=>'中国,辽宁省,大连市,沙河口区','level'=>'3','pinyin'=>'shahekou','code'=>'0411','zip_code'=>'116021','first'=>'S','lng'=>'121.58017','lat'=>'38.90536']);
        $this->insert('{{%region}}',['id'=>'485','pid'=>'481','shortname'=>'甘井子','name'=>'甘井子区','merger_name'=>'中国,辽宁省,大连市,甘井子区','level'=>'3','pinyin'=>'ganjingzi','code'=>'0411','zip_code'=>'116033','first'=>'G','lng'=>'121.56567','lat'=>'38.95017']);
        $this->insert('{{%region}}',['id'=>'486','pid'=>'481','shortname'=>'旅顺口','name'=>'旅顺口区','merger_name'=>'中国,辽宁省,大连市,旅顺口区','level'=>'3','pinyin'=>'lvshunkou','code'=>'0411','zip_code'=>'116041','first'=>'L','lng'=>'121.26202','lat'=>'38.85125']);
        $this->insert('{{%region}}',['id'=>'487','pid'=>'481','shortname'=>'金州','name'=>'金州区','merger_name'=>'中国,辽宁省,大连市,金州区','level'=>'3','pinyin'=>'jinzhou','code'=>'0411','zip_code'=>'116100','first'=>'J','lng'=>'121.71893','lat'=>'39.1004']);
        $this->insert('{{%region}}',['id'=>'488','pid'=>'481','shortname'=>'长海','name'=>'长海县','merger_name'=>'中国,辽宁省,大连市,长海县','level'=>'3','pinyin'=>'changhai','code'=>'0411','zip_code'=>'116500','first'=>'C','lng'=>'122.58859','lat'=>'39.27274']);
        $this->insert('{{%region}}',['id'=>'489','pid'=>'481','shortname'=>'瓦房店','name'=>'瓦房店市','merger_name'=>'中国,辽宁省,大连市,瓦房店市','level'=>'3','pinyin'=>'wafangdian','code'=>'0411','zip_code'=>'116300','first'=>'W','lng'=>'121.98104','lat'=>'39.62843']);
        $this->insert('{{%region}}',['id'=>'490','pid'=>'481','shortname'=>'普兰店','name'=>'普兰店市','merger_name'=>'中国,辽宁省,大连市,普兰店市','level'=>'3','pinyin'=>'pulandian','code'=>'0411','zip_code'=>'116200','first'=>'P','lng'=>'121.96316','lat'=>'39.39465']);
        $this->insert('{{%region}}',['id'=>'491','pid'=>'481','shortname'=>'庄河','name'=>'庄河市','merger_name'=>'中国,辽宁省,大连市,庄河市','level'=>'3','pinyin'=>'zhuanghe','code'=>'0411','zip_code'=>'116400','first'=>'Z','lng'=>'122.96725','lat'=>'39.68815']);
        $this->insert('{{%region}}',['id'=>'492','pid'=>'466','shortname'=>'鞍山','name'=>'鞍山市','merger_name'=>'中国,辽宁省,鞍山市','level'=>'2','pinyin'=>'anshan','code'=>'0412','zip_code'=>'114001','first'=>'A','lng'=>'122.995632','lat'=>'41.110626']);
        $this->insert('{{%region}}',['id'=>'493','pid'=>'492','shortname'=>'铁东','name'=>'铁东区','merger_name'=>'中国,辽宁省,鞍山市,铁东区','level'=>'3','pinyin'=>'tiedong','code'=>'0412','zip_code'=>'114001','first'=>'T','lng'=>'122.99085','lat'=>'41.08975']);
        $this->insert('{{%region}}',['id'=>'494','pid'=>'492','shortname'=>'铁西','name'=>'铁西区','merger_name'=>'中国,辽宁省,鞍山市,铁西区','level'=>'3','pinyin'=>'tiexi','code'=>'0413','zip_code'=>'114013','first'=>'T','lng'=>'122.96967','lat'=>'41.11977']);
        $this->insert('{{%region}}',['id'=>'495','pid'=>'492','shortname'=>'立山','name'=>'立山区','merger_name'=>'中国,辽宁省,鞍山市,立山区','level'=>'3','pinyin'=>'lishan','code'=>'0414','zip_code'=>'114031','first'=>'L','lng'=>'123.02948','lat'=>'41.15008']);
        $this->insert('{{%region}}',['id'=>'496','pid'=>'492','shortname'=>'千山','name'=>'千山区','merger_name'=>'中国,辽宁省,鞍山市,千山区','level'=>'3','pinyin'=>'qianshan','code'=>'0415','zip_code'=>'114041','first'=>'Q','lng'=>'122.96048','lat'=>'41.07507']);
        $this->insert('{{%region}}',['id'=>'497','pid'=>'492','shortname'=>'台安','name'=>'台安县','merger_name'=>'中国,辽宁省,鞍山市,台安县','level'=>'3','pinyin'=>'tai\'an','code'=>'0417','zip_code'=>'114100','first'=>'T','lng'=>'122.43585','lat'=>'41.41265']);
        $this->insert('{{%region}}',['id'=>'498','pid'=>'492','shortname'=>'岫岩','name'=>'岫岩满族自治县','merger_name'=>'中国,辽宁省,鞍山市,岫岩满族自治县','level'=>'3','pinyin'=>'xiuyan','code'=>'0418','zip_code'=>'114300','first'=>NULL,'lng'=>'123.28875','lat'=>'40.27996']);
        $this->insert('{{%region}}',['id'=>'499','pid'=>'492','shortname'=>'海城','name'=>'海城市','merger_name'=>'中国,辽宁省,鞍山市,海城市','level'=>'3','pinyin'=>'haicheng','code'=>'0416','zip_code'=>'114200','first'=>'H','lng'=>'122.68457','lat'=>'40.88142']);
        $this->insert('{{%region}}',['id'=>'500','pid'=>'466','shortname'=>'抚顺','name'=>'抚顺市','merger_name'=>'中国,辽宁省,抚顺市','level'=>'2','pinyin'=>'fushun','code'=>'024','zip_code'=>'113008','first'=>'F','lng'=>'123.921109','lat'=>'41.875956']);
        $this->insert('{{%region}}',['id'=>'501','pid'=>'500','shortname'=>'新抚','name'=>'新抚区','merger_name'=>'中国,辽宁省,抚顺市,新抚区','level'=>'3','pinyin'=>'xinfu','code'=>'024','zip_code'=>'113008','first'=>'X','lng'=>'123.91264','lat'=>'41.86205']);
        $this->insert('{{%region}}',['id'=>'502','pid'=>'500','shortname'=>'东洲','name'=>'东洲区','merger_name'=>'中国,辽宁省,抚顺市,东洲区','level'=>'3','pinyin'=>'dongzhou','code'=>'024','zip_code'=>'113003','first'=>'D','lng'=>'124.03759','lat'=>'41.8519']);
        $this->insert('{{%region}}',['id'=>'503','pid'=>'500','shortname'=>'望花','name'=>'望花区','merger_name'=>'中国,辽宁省,抚顺市,望花区','level'=>'3','pinyin'=>'wanghua','code'=>'024','zip_code'=>'113001','first'=>'W','lng'=>'123.78283','lat'=>'41.85532']);
        $this->insert('{{%region}}',['id'=>'504','pid'=>'500','shortname'=>'顺城','name'=>'顺城区','merger_name'=>'中国,辽宁省,抚顺市,顺城区','level'=>'3','pinyin'=>'shuncheng','code'=>'024','zip_code'=>'113006','first'=>'S','lng'=>'123.94506','lat'=>'41.88321']);
        $this->insert('{{%region}}',['id'=>'505','pid'=>'500','shortname'=>'抚顺','name'=>'抚顺县','merger_name'=>'中国,辽宁省,抚顺市,抚顺县','level'=>'3','pinyin'=>'fushun','code'=>'024','zip_code'=>'113006','first'=>'F','lng'=>'124.17755','lat'=>'41.71217']);
        $this->insert('{{%region}}',['id'=>'506','pid'=>'500','shortname'=>'新宾','name'=>'新宾满族自治县','merger_name'=>'中国,辽宁省,抚顺市,新宾满族自治县','level'=>'3','pinyin'=>'xinbin','code'=>'024','zip_code'=>'113200','first'=>'X','lng'=>'125.04049','lat'=>'41.73409']);
        $this->insert('{{%region}}',['id'=>'507','pid'=>'500','shortname'=>'清原','name'=>'清原满族自治县','merger_name'=>'中国,辽宁省,抚顺市,清原满族自治县','level'=>'3','pinyin'=>'qingyuan','code'=>'024','zip_code'=>'113300','first'=>'Q','lng'=>'124.92807','lat'=>'42.10221']);
        $this->insert('{{%region}}',['id'=>'508','pid'=>'466','shortname'=>'本溪','name'=>'本溪市','merger_name'=>'中国,辽宁省,本溪市','level'=>'2','pinyin'=>'benxi','code'=>'0414','zip_code'=>'117000','first'=>'B','lng'=>'123.770519','lat'=>'41.297909']);
        $this->insert('{{%region}}',['id'=>'509','pid'=>'508','shortname'=>'平山','name'=>'平山区','merger_name'=>'中国,辽宁省,本溪市,平山区','level'=>'3','pinyin'=>'pingshan','code'=>'0414','zip_code'=>'117000','first'=>'P','lng'=>'123.76892','lat'=>'41.2997']);
        $this->insert('{{%region}}',['id'=>'510','pid'=>'508','shortname'=>'溪湖','name'=>'溪湖区','merger_name'=>'中国,辽宁省,本溪市,溪湖区','level'=>'3','pinyin'=>'xihu','code'=>'0414','zip_code'=>'117002','first'=>'X','lng'=>'123.76764','lat'=>'41.32921']);
        $this->insert('{{%region}}',['id'=>'511','pid'=>'508','shortname'=>'明山','name'=>'明山区','merger_name'=>'中国,辽宁省,本溪市,明山区','level'=>'3','pinyin'=>'mingshan','code'=>'0414','zip_code'=>'117021','first'=>'M','lng'=>'123.81746','lat'=>'41.30827']);
        $this->insert('{{%region}}',['id'=>'512','pid'=>'508','shortname'=>'南芬','name'=>'南芬区','merger_name'=>'中国,辽宁省,本溪市,南芬区','level'=>'3','pinyin'=>'nanfen','code'=>'0414','zip_code'=>'117014','first'=>'N','lng'=>'123.74523','lat'=>'41.1006']);
        $this->insert('{{%region}}',['id'=>'513','pid'=>'508','shortname'=>'本溪','name'=>'本溪满族自治县','merger_name'=>'中国,辽宁省,本溪市,本溪满族自治县','level'=>'3','pinyin'=>'benxi','code'=>'0414','zip_code'=>'117100','first'=>'B','lng'=>'124.12741','lat'=>'41.30059']);
        $this->insert('{{%region}}',['id'=>'514','pid'=>'508','shortname'=>'桓仁','name'=>'桓仁满族自治县','merger_name'=>'中国,辽宁省,本溪市,桓仁满族自治县','level'=>'3','pinyin'=>'huanren','code'=>'0414','zip_code'=>'117200','first'=>'H','lng'=>'125.36062','lat'=>'41.26798']);
        $this->insert('{{%region}}',['id'=>'515','pid'=>'466','shortname'=>'丹东','name'=>'丹东市','merger_name'=>'中国,辽宁省,丹东市','level'=>'2','pinyin'=>'dandong','code'=>'0415','zip_code'=>'118000','first'=>'D','lng'=>'124.383044','lat'=>'40.124296']);
        $this->insert('{{%region}}',['id'=>'516','pid'=>'515','shortname'=>'元宝','name'=>'元宝区','merger_name'=>'中国,辽宁省,丹东市,元宝区','level'=>'3','pinyin'=>'yuanbao','code'=>'0415','zip_code'=>'118000','first'=>'Y','lng'=>'124.39575','lat'=>'40.13651']);
        $this->insert('{{%region}}',['id'=>'517','pid'=>'515','shortname'=>'振兴','name'=>'振兴区','merger_name'=>'中国,辽宁省,丹东市,振兴区','level'=>'3','pinyin'=>'zhenxing','code'=>'0415','zip_code'=>'118002','first'=>'Z','lng'=>'124.36035','lat'=>'40.10489']);
        $this->insert('{{%region}}',['id'=>'518','pid'=>'515','shortname'=>'振安','name'=>'振安区','merger_name'=>'中国,辽宁省,丹东市,振安区','level'=>'3','pinyin'=>'zhen\'an','code'=>'0415','zip_code'=>'118001','first'=>'Z','lng'=>'124.42816','lat'=>'40.15826']);
        $this->insert('{{%region}}',['id'=>'519','pid'=>'515','shortname'=>'宽甸','name'=>'宽甸满族自治县','merger_name'=>'中国,辽宁省,丹东市,宽甸满族自治县','level'=>'3','pinyin'=>'kuandian','code'=>'0415','zip_code'=>'118200','first'=>'K','lng'=>'124.78247','lat'=>'40.73187']);
        $this->insert('{{%region}}',['id'=>'520','pid'=>'515','shortname'=>'东港','name'=>'东港市','merger_name'=>'中国,辽宁省,丹东市,东港市','level'=>'3','pinyin'=>'donggang','code'=>'0415','zip_code'=>'118300','first'=>'D','lng'=>'124.16287','lat'=>'39.86256']);
        $this->insert('{{%region}}',['id'=>'521','pid'=>'515','shortname'=>'凤城','name'=>'凤城市','merger_name'=>'中国,辽宁省,丹东市,凤城市','level'=>'3','pinyin'=>'fengcheng','code'=>'0415','zip_code'=>'118100','first'=>'F','lng'=>'124.06671','lat'=>'40.45302']);
        $this->insert('{{%region}}',['id'=>'522','pid'=>'466','shortname'=>'锦州','name'=>'锦州市','merger_name'=>'中国,辽宁省,锦州市','level'=>'2','pinyin'=>'jinzhou','code'=>'0416','zip_code'=>'121000','first'=>'J','lng'=>'121.135742','lat'=>'41.119269']);
        $this->insert('{{%region}}',['id'=>'523','pid'=>'522','shortname'=>'古塔','name'=>'古塔区','merger_name'=>'中国,辽宁省,锦州市,古塔区','level'=>'3','pinyin'=>'guta','code'=>'0416','zip_code'=>'121001','first'=>'G','lng'=>'121.12832','lat'=>'41.11725']);
        $this->insert('{{%region}}',['id'=>'524','pid'=>'522','shortname'=>'凌河','name'=>'凌河区','merger_name'=>'中国,辽宁省,锦州市,凌河区','level'=>'3','pinyin'=>'linghe','code'=>'0416','zip_code'=>'121000','first'=>'L','lng'=>'121.15089','lat'=>'41.11496']);
        $this->insert('{{%region}}',['id'=>'525','pid'=>'522','shortname'=>'太和','name'=>'太和区','merger_name'=>'中国,辽宁省,锦州市,太和区','level'=>'3','pinyin'=>'taihe','code'=>'0416','zip_code'=>'121011','first'=>'T','lng'=>'121.10354','lat'=>'41.10929']);
        $this->insert('{{%region}}',['id'=>'526','pid'=>'522','shortname'=>'黑山','name'=>'黑山县','merger_name'=>'中国,辽宁省,锦州市,黑山县','level'=>'3','pinyin'=>'heishan','code'=>'0416','zip_code'=>'121400','first'=>'H','lng'=>'122.12081','lat'=>'41.69417']);
        $this->insert('{{%region}}',['id'=>'527','pid'=>'522','shortname'=>'义县','name'=>'义县','merger_name'=>'中国,辽宁省,锦州市,义县','level'=>'3','pinyin'=>'yixian','code'=>'0416','zip_code'=>'121100','first'=>'Y','lng'=>'121.24035','lat'=>'41.53458']);
        $this->insert('{{%region}}',['id'=>'528','pid'=>'522','shortname'=>'凌海','name'=>'凌海市','merger_name'=>'中国,辽宁省,锦州市,凌海市','level'=>'3','pinyin'=>'linghai','code'=>'0416','zip_code'=>'121200','first'=>'L','lng'=>'121.35705','lat'=>'41.1737']);
        $this->insert('{{%region}}',['id'=>'529','pid'=>'522','shortname'=>'北镇','name'=>'北镇市','merger_name'=>'中国,辽宁省,锦州市,北镇市','level'=>'3','pinyin'=>'beizhen','code'=>'0416','zip_code'=>'121300','first'=>'B','lng'=>'121.79858','lat'=>'41.59537']);
        $this->insert('{{%region}}',['id'=>'530','pid'=>'466','shortname'=>'营口','name'=>'营口市','merger_name'=>'中国,辽宁省,营口市','level'=>'2','pinyin'=>'yingkou','code'=>'0417','zip_code'=>'115003','first'=>'Y','lng'=>'122.235151','lat'=>'40.667432']);
        $this->insert('{{%region}}',['id'=>'531','pid'=>'530','shortname'=>'站前','name'=>'站前区','merger_name'=>'中国,辽宁省,营口市,站前区','level'=>'3','pinyin'=>'zhanqian','code'=>'0417','zip_code'=>'115002','first'=>'Z','lng'=>'122.25896','lat'=>'40.67266']);
        $this->insert('{{%region}}',['id'=>'532','pid'=>'530','shortname'=>'西市','name'=>'西市区','merger_name'=>'中国,辽宁省,营口市,西市区','level'=>'3','pinyin'=>'xishi','code'=>'0417','zip_code'=>'115004','first'=>'X','lng'=>'122.20641','lat'=>'40.6664']);
        $this->insert('{{%region}}',['id'=>'533','pid'=>'530','shortname'=>'鲅鱼圈','name'=>'鲅鱼圈区','merger_name'=>'中国,辽宁省,营口市,鲅鱼圈区','level'=>'3','pinyin'=>'bayuquan','code'=>'0417','zip_code'=>'115007','first'=>NULL,'lng'=>'122.13266','lat'=>'40.26865']);
        $this->insert('{{%region}}',['id'=>'534','pid'=>'530','shortname'=>'老边','name'=>'老边区','merger_name'=>'中国,辽宁省,营口市,老边区','level'=>'3','pinyin'=>'laobian','code'=>'0417','zip_code'=>'115005','first'=>'L','lng'=>'122.37996','lat'=>'40.6803']);
        $this->insert('{{%region}}',['id'=>'535','pid'=>'530','shortname'=>'盖州','name'=>'盖州市','merger_name'=>'中国,辽宁省,营口市,盖州市','level'=>'3','pinyin'=>'gaizhou','code'=>'0417','zip_code'=>'115200','first'=>'G','lng'=>'122.35464','lat'=>'40.40446']);
        $this->insert('{{%region}}',['id'=>'536','pid'=>'530','shortname'=>'大石桥','name'=>'大石桥市','merger_name'=>'中国,辽宁省,营口市,大石桥市','level'=>'3','pinyin'=>'dashiqiao','code'=>'0417','zip_code'=>'115100','first'=>'D','lng'=>'122.50927','lat'=>'40.64567']);
        $this->insert('{{%region}}',['id'=>'537','pid'=>'466','shortname'=>'阜新','name'=>'阜新市','merger_name'=>'中国,辽宁省,阜新市','level'=>'2','pinyin'=>'fuxin','code'=>'0418','zip_code'=>'123000','first'=>'F','lng'=>'121.648962','lat'=>'42.011796']);
        $this->insert('{{%region}}',['id'=>'538','pid'=>'537','shortname'=>'海州','name'=>'海州区','merger_name'=>'中国,辽宁省,阜新市,海州区','level'=>'3','pinyin'=>'haizhou','code'=>'0418','zip_code'=>'123000','first'=>'H','lng'=>'121.65626','lat'=>'42.01336']);
        $this->insert('{{%region}}',['id'=>'539','pid'=>'537','shortname'=>'新邱','name'=>'新邱区','merger_name'=>'中国,辽宁省,阜新市,新邱区','level'=>'3','pinyin'=>'xinqiu','code'=>'0418','zip_code'=>'123005','first'=>'X','lng'=>'121.79251','lat'=>'42.09181']);
        $this->insert('{{%region}}',['id'=>'540','pid'=>'537','shortname'=>'太平','name'=>'太平区','merger_name'=>'中国,辽宁省,阜新市,太平区','level'=>'3','pinyin'=>'taiping','code'=>'0418','zip_code'=>'123003','first'=>'T','lng'=>'121.67865','lat'=>'42.01065']);
        $this->insert('{{%region}}',['id'=>'541','pid'=>'537','shortname'=>'清河门','name'=>'清河门区','merger_name'=>'中国,辽宁省,阜新市,清河门区','level'=>'3','pinyin'=>'qinghemen','code'=>'0418','zip_code'=>'123006','first'=>'Q','lng'=>'121.4161','lat'=>'41.78309']);
        $this->insert('{{%region}}',['id'=>'542','pid'=>'537','shortname'=>'细河','name'=>'细河区','merger_name'=>'中国,辽宁省,阜新市,细河区','level'=>'3','pinyin'=>'xihe','code'=>'0418','zip_code'=>'123000','first'=>'X','lng'=>'121.68013','lat'=>'42.02533']);
        $this->insert('{{%region}}',['id'=>'543','pid'=>'537','shortname'=>'阜新','name'=>'阜新蒙古族自治县','merger_name'=>'中国,辽宁省,阜新市,阜新蒙古族自治县','level'=>'3','pinyin'=>'fuxin','code'=>'0418','zip_code'=>'123100','first'=>'F','lng'=>'121.75787','lat'=>'42.0651']);
        $this->insert('{{%region}}',['id'=>'544','pid'=>'537','shortname'=>'彰武','name'=>'彰武县','merger_name'=>'中国,辽宁省,阜新市,彰武县','level'=>'3','pinyin'=>'zhangwu','code'=>'0418','zip_code'=>'123200','first'=>'Z','lng'=>'122.54022','lat'=>'42.38625']);
        $this->insert('{{%region}}',['id'=>'545','pid'=>'466','shortname'=>'辽阳','name'=>'辽阳市','merger_name'=>'中国,辽宁省,辽阳市','level'=>'2','pinyin'=>'liaoyang','code'=>'0419','zip_code'=>'111000','first'=>'L','lng'=>'123.18152','lat'=>'41.269402']);
        $this->insert('{{%region}}',['id'=>'546','pid'=>'545','shortname'=>'白塔','name'=>'白塔区','merger_name'=>'中国,辽宁省,辽阳市,白塔区','level'=>'3','pinyin'=>'baita','code'=>'0419','zip_code'=>'111000','first'=>'B','lng'=>'123.1747','lat'=>'41.27025']);
        $this->insert('{{%region}}',['id'=>'547','pid'=>'545','shortname'=>'文圣','name'=>'文圣区','merger_name'=>'中国,辽宁省,辽阳市,文圣区','level'=>'3','pinyin'=>'wensheng','code'=>'0419','zip_code'=>'111000','first'=>'W','lng'=>'123.18521','lat'=>'41.26267']);
        $this->insert('{{%region}}',['id'=>'548','pid'=>'545','shortname'=>'宏伟','name'=>'宏伟区','merger_name'=>'中国,辽宁省,辽阳市,宏伟区','level'=>'3','pinyin'=>'hongwei','code'=>'0419','zip_code'=>'111003','first'=>'H','lng'=>'123.1929','lat'=>'41.21852']);
        $this->insert('{{%region}}',['id'=>'549','pid'=>'545','shortname'=>'弓长岭','name'=>'弓长岭区','merger_name'=>'中国,辽宁省,辽阳市,弓长岭区','level'=>'3','pinyin'=>'gongchangling','code'=>'0419','zip_code'=>'111008','first'=>'G','lng'=>'123.41963','lat'=>'41.15181']);
        $this->insert('{{%region}}',['id'=>'550','pid'=>'545','shortname'=>'太子河','name'=>'太子河区','merger_name'=>'中国,辽宁省,辽阳市,太子河区','level'=>'3','pinyin'=>'taizihe','code'=>'0419','zip_code'=>'111000','first'=>'T','lng'=>'123.18182','lat'=>'41.25337']);
        $this->insert('{{%region}}',['id'=>'551','pid'=>'545','shortname'=>'辽阳','name'=>'辽阳县','merger_name'=>'中国,辽宁省,辽阳市,辽阳县','level'=>'3','pinyin'=>'liaoyang','code'=>'0419','zip_code'=>'111200','first'=>'L','lng'=>'123.10574','lat'=>'41.20542']);
        $this->insert('{{%region}}',['id'=>'552','pid'=>'545','shortname'=>'灯塔','name'=>'灯塔市','merger_name'=>'中国,辽宁省,辽阳市,灯塔市','level'=>'3','pinyin'=>'dengta','code'=>'0419','zip_code'=>'111300','first'=>'D','lng'=>'123.33926','lat'=>'41.42612']);
        $this->insert('{{%region}}',['id'=>'553','pid'=>'466','shortname'=>'盘锦','name'=>'盘锦市','merger_name'=>'中国,辽宁省,盘锦市','level'=>'2','pinyin'=>'panjin','code'=>'0427','zip_code'=>'124010','first'=>'P','lng'=>'122.06957','lat'=>'41.124484']);
        $this->insert('{{%region}}',['id'=>'554','pid'=>'553','shortname'=>'双台子','name'=>'双台子区','merger_name'=>'中国,辽宁省,盘锦市,双台子区','level'=>'3','pinyin'=>'shuangtaizi','code'=>'0427','zip_code'=>'124000','first'=>'S','lng'=>'122.06011','lat'=>'41.1906']);
        $this->insert('{{%region}}',['id'=>'555','pid'=>'553','shortname'=>'兴隆台','name'=>'兴隆台区','merger_name'=>'中国,辽宁省,盘锦市,兴隆台区','level'=>'3','pinyin'=>'xinglongtai','code'=>'0427','zip_code'=>'124010','first'=>'X','lng'=>'122.07529','lat'=>'41.12402']);
        $this->insert('{{%region}}',['id'=>'556','pid'=>'553','shortname'=>'大洼','name'=>'大洼县','merger_name'=>'中国,辽宁省,盘锦市,大洼县','level'=>'3','pinyin'=>'dawa','code'=>'0427','zip_code'=>'124200','first'=>'D','lng'=>'122.08239','lat'=>'41.00244']);
        $this->insert('{{%region}}',['id'=>'557','pid'=>'553','shortname'=>'盘山','name'=>'盘山县','merger_name'=>'中国,辽宁省,盘锦市,盘山县','level'=>'3','pinyin'=>'panshan','code'=>'0427','zip_code'=>'124000','first'=>'P','lng'=>'121.99777','lat'=>'41.23805']);
        $this->insert('{{%region}}',['id'=>'558','pid'=>'466','shortname'=>'铁岭','name'=>'铁岭市','merger_name'=>'中国,辽宁省,铁岭市','level'=>'2','pinyin'=>'tieling','code'=>'024','zip_code'=>'112000','first'=>'T','lng'=>'123.844279','lat'=>'42.290585']);
        $this->insert('{{%region}}',['id'=>'559','pid'=>'558','shortname'=>'银州','name'=>'银州区','merger_name'=>'中国,辽宁省,铁岭市,银州区','level'=>'3','pinyin'=>'yinzhou','code'=>'024','zip_code'=>'112000','first'=>'Y','lng'=>'123.8573','lat'=>'42.29507']);
        $this->insert('{{%region}}',['id'=>'560','pid'=>'558','shortname'=>'清河','name'=>'清河区','merger_name'=>'中国,辽宁省,铁岭市,清河区','level'=>'3','pinyin'=>'qinghe','code'=>'024','zip_code'=>'112003','first'=>'Q','lng'=>'124.15911','lat'=>'42.54679']);
        $this->insert('{{%region}}',['id'=>'561','pid'=>'558','shortname'=>'铁岭','name'=>'铁岭县','merger_name'=>'中国,辽宁省,铁岭市,铁岭县','level'=>'3','pinyin'=>'tieling','code'=>'024','zip_code'=>'112000','first'=>'T','lng'=>'123.77325','lat'=>'42.22498']);
        $this->insert('{{%region}}',['id'=>'562','pid'=>'558','shortname'=>'西丰','name'=>'西丰县','merger_name'=>'中国,辽宁省,铁岭市,西丰县','level'=>'3','pinyin'=>'xifeng','code'=>'024','zip_code'=>'112400','first'=>'X','lng'=>'124.7304','lat'=>'42.73756']);
        $this->insert('{{%region}}',['id'=>'563','pid'=>'558','shortname'=>'昌图','name'=>'昌图县','merger_name'=>'中国,辽宁省,铁岭市,昌图县','level'=>'3','pinyin'=>'changtu','code'=>'024','zip_code'=>'112500','first'=>'C','lng'=>'124.11206','lat'=>'42.78428']);
        $this->insert('{{%region}}',['id'=>'564','pid'=>'558','shortname'=>'调兵山','name'=>'调兵山市','merger_name'=>'中国,辽宁省,铁岭市,调兵山市','level'=>'3','pinyin'=>'diaobingshan','code'=>'024','zip_code'=>'112700','first'=>'D','lng'=>'123.56689','lat'=>'42.4675']);
        $this->insert('{{%region}}',['id'=>'565','pid'=>'558','shortname'=>'开原','name'=>'开原市','merger_name'=>'中国,辽宁省,铁岭市,开原市','level'=>'3','pinyin'=>'kaiyuan','code'=>'024','zip_code'=>'112300','first'=>'K','lng'=>'124.03945','lat'=>'42.54585']);
        $this->insert('{{%region}}',['id'=>'566','pid'=>'466','shortname'=>'朝阳','name'=>'朝阳市','merger_name'=>'中国,辽宁省,朝阳市','level'=>'2','pinyin'=>'chaoyang','code'=>'0421','zip_code'=>'122000','first'=>'C','lng'=>'120.451176','lat'=>'41.576758']);
        $this->insert('{{%region}}',['id'=>'567','pid'=>'566','shortname'=>'双塔','name'=>'双塔区','merger_name'=>'中国,辽宁省,朝阳市,双塔区','level'=>'3','pinyin'=>'shuangta','code'=>'0421','zip_code'=>'122000','first'=>'S','lng'=>'120.45385','lat'=>'41.566']);
        $this->insert('{{%region}}',['id'=>'568','pid'=>'566','shortname'=>'龙城','name'=>'龙城区','merger_name'=>'中国,辽宁省,朝阳市,龙城区','level'=>'3','pinyin'=>'longcheng','code'=>'0421','zip_code'=>'122000','first'=>'L','lng'=>'120.43719','lat'=>'41.59264']);
        $this->insert('{{%region}}',['id'=>'569','pid'=>'566','shortname'=>'朝阳','name'=>'朝阳县','merger_name'=>'中国,辽宁省,朝阳市,朝阳县','level'=>'3','pinyin'=>'chaoyang','code'=>'0421','zip_code'=>'122000','first'=>'C','lng'=>'120.17401','lat'=>'41.4324']);
        $this->insert('{{%region}}',['id'=>'570','pid'=>'566','shortname'=>'建平','name'=>'建平县','merger_name'=>'中国,辽宁省,朝阳市,建平县','level'=>'3','pinyin'=>'jianping','code'=>'0421','zip_code'=>'122400','first'=>'J','lng'=>'119.64392','lat'=>'41.40315']);
        $this->insert('{{%region}}',['id'=>'571','pid'=>'566','shortname'=>'喀喇沁左翼','name'=>'喀喇沁左翼蒙古族自治县','merger_name'=>'中国,辽宁省,朝阳市,喀喇沁左翼蒙古族自治县','level'=>'3','pinyin'=>'kalaqinzuoyi','code'=>'0421','zip_code'=>'122300','first'=>'K','lng'=>'119.74185','lat'=>'41.12801']);
        $this->insert('{{%region}}',['id'=>'572','pid'=>'566','shortname'=>'北票','name'=>'北票市','merger_name'=>'中国,辽宁省,朝阳市,北票市','level'=>'3','pinyin'=>'beipiao','code'=>'0421','zip_code'=>'122100','first'=>'B','lng'=>'120.76977','lat'=>'41.80196']);
        $this->insert('{{%region}}',['id'=>'573','pid'=>'566','shortname'=>'凌源','name'=>'凌源市','merger_name'=>'中国,辽宁省,朝阳市,凌源市','level'=>'3','pinyin'=>'lingyuan','code'=>'0421','zip_code'=>'122500','first'=>'L','lng'=>'119.40148','lat'=>'41.24558']);
        $this->insert('{{%region}}',['id'=>'574','pid'=>'466','shortname'=>'葫芦岛','name'=>'葫芦岛市','merger_name'=>'中国,辽宁省,葫芦岛市','level'=>'2','pinyin'=>'huludao','code'=>'0429','zip_code'=>'125000','first'=>'H','lng'=>'120.856394','lat'=>'40.755572']);
        $this->insert('{{%region}}',['id'=>'575','pid'=>'574','shortname'=>'连山','name'=>'连山区','merger_name'=>'中国,辽宁省,葫芦岛市,连山区','level'=>'3','pinyin'=>'lianshan','code'=>'0429','zip_code'=>'125001','first'=>'L','lng'=>'120.86393','lat'=>'40.75554']);
        $this->insert('{{%region}}',['id'=>'576','pid'=>'574','shortname'=>'龙港','name'=>'龙港区','merger_name'=>'中国,辽宁省,葫芦岛市,龙港区','level'=>'3','pinyin'=>'longgang','code'=>'0429','zip_code'=>'125003','first'=>'L','lng'=>'120.94866','lat'=>'40.71919']);
        $this->insert('{{%region}}',['id'=>'577','pid'=>'574','shortname'=>'南票','name'=>'南票区','merger_name'=>'中国,辽宁省,葫芦岛市,南票区','level'=>'3','pinyin'=>'nanpiao','code'=>'0429','zip_code'=>'125027','first'=>'N','lng'=>'120.74978','lat'=>'41.10707']);
        $this->insert('{{%region}}',['id'=>'578','pid'=>'574','shortname'=>'绥中','name'=>'绥中县','merger_name'=>'中国,辽宁省,葫芦岛市,绥中县','level'=>'3','pinyin'=>'suizhong','code'=>'0429','zip_code'=>'125200','first'=>'S','lng'=>'120.34451','lat'=>'40.32552']);
        $this->insert('{{%region}}',['id'=>'579','pid'=>'574','shortname'=>'建昌','name'=>'建昌县','merger_name'=>'中国,辽宁省,葫芦岛市,建昌县','level'=>'3','pinyin'=>'jianchang','code'=>'0429','zip_code'=>'125300','first'=>'J','lng'=>'119.8377','lat'=>'40.82448']);
        $this->insert('{{%region}}',['id'=>'580','pid'=>'574','shortname'=>'兴城','name'=>'兴城市','merger_name'=>'中国,辽宁省,葫芦岛市,兴城市','level'=>'3','pinyin'=>'xingcheng','code'=>'0429','zip_code'=>'125100','first'=>'X','lng'=>'120.72537','lat'=>'40.61492']);
        $this->insert('{{%region}}',['id'=>'581','pid'=>'466','shortname'=>'金普新区','name'=>'金普新区','merger_name'=>'中国,辽宁省,金普新区','level'=>'2','pinyin'=>'jinpuxinqu','code'=>'0411','zip_code'=>'116100','first'=>'J','lng'=>'121.789627','lat'=>'39.055451']);
        $this->insert('{{%region}}',['id'=>'582','pid'=>'581','shortname'=>'金州新区','name'=>'金州新区','merger_name'=>'中国,辽宁省,金普新区,金州新区','level'=>'3','pinyin'=>'jinzhouxinqu','code'=>'0411','zip_code'=>'116100','first'=>'J','lng'=>'121.784821','lat'=>'39.052252']);
        $this->insert('{{%region}}',['id'=>'583','pid'=>'581','shortname'=>'普湾新区','name'=>'普湾新区','merger_name'=>'中国,辽宁省,金普新区,普湾新区','level'=>'3','pinyin'=>'puwanxinqu','code'=>'0411','zip_code'=>'116200','first'=>'P','lng'=>'121.812812','lat'=>'39.330093']);
        $this->insert('{{%region}}',['id'=>'584','pid'=>'581','shortname'=>'保税区','name'=>'保税区','merger_name'=>'中国,辽宁省,金普新区,保税区','level'=>'3','pinyin'=>'baoshuiqu','code'=>'0411','zip_code'=>'116100','first'=>'B','lng'=>'121.94289','lat'=>'39.224614']);
        $this->insert('{{%region}}',['id'=>'585','pid'=>'0','shortname'=>'吉林','name'=>'吉林省','merger_name'=>'中国,吉林省','level'=>'1','pinyin'=>'jilin','code'=>'','zip_code'=>'','first'=>'J','lng'=>'125.3245','lat'=>'43.886841']);
        $this->insert('{{%region}}',['id'=>'586','pid'=>'585','shortname'=>'长春','name'=>'长春市','merger_name'=>'中国,吉林省,长春市','level'=>'2','pinyin'=>'changchun','code'=>'0431','zip_code'=>'130022','first'=>'C','lng'=>'125.3245','lat'=>'43.886841']);
        $this->insert('{{%region}}',['id'=>'587','pid'=>'586','shortname'=>'南关','name'=>'南关区','merger_name'=>'中国,吉林省,长春市,南关区','level'=>'3','pinyin'=>'nanguan','code'=>'0431','zip_code'=>'130022','first'=>'N','lng'=>'125.35035','lat'=>'43.86401']);
        $this->insert('{{%region}}',['id'=>'588','pid'=>'586','shortname'=>'宽城','name'=>'宽城区','merger_name'=>'中国,吉林省,长春市,宽城区','level'=>'3','pinyin'=>'kuancheng','code'=>'0431','zip_code'=>'130051','first'=>'K','lng'=>'125.32635','lat'=>'43.90182']);
        $this->insert('{{%region}}',['id'=>'589','pid'=>'586','shortname'=>'朝阳','name'=>'朝阳区','merger_name'=>'中国,吉林省,长春市,朝阳区','level'=>'3','pinyin'=>'chaoyang','code'=>'0431','zip_code'=>'130012','first'=>'C','lng'=>'125.2883','lat'=>'43.83339']);
        $this->insert('{{%region}}',['id'=>'590','pid'=>'586','shortname'=>'二道','name'=>'二道区','merger_name'=>'中国,吉林省,长春市,二道区','level'=>'3','pinyin'=>'erdao','code'=>'0431','zip_code'=>'130031','first'=>'E','lng'=>'125.37429','lat'=>'43.86501']);
        $this->insert('{{%region}}',['id'=>'591','pid'=>'586','shortname'=>'绿园','name'=>'绿园区','merger_name'=>'中国,吉林省,长春市,绿园区','level'=>'3','pinyin'=>'lvyuan','code'=>'0431','zip_code'=>'130062','first'=>'L','lng'=>'125.25582','lat'=>'43.88045']);
        $this->insert('{{%region}}',['id'=>'592','pid'=>'586','shortname'=>'双阳','name'=>'双阳区','merger_name'=>'中国,吉林省,长春市,双阳区','level'=>'3','pinyin'=>'shuangyang','code'=>'0431','zip_code'=>'130600','first'=>'S','lng'=>'125.65631','lat'=>'43.52803']);
        $this->insert('{{%region}}',['id'=>'593','pid'=>'586','shortname'=>'九台','name'=>'九台区','merger_name'=>'中国,吉林省,长春市,九台区','level'=>'3','pinyin'=>'jiutai','code'=>'0431','zip_code'=>'130500','first'=>'J','lng'=>'125.8395','lat'=>'44.15163']);
        $this->insert('{{%region}}',['id'=>'594','pid'=>'586','shortname'=>'农安','name'=>'农安县','merger_name'=>'中国,吉林省,长春市,农安县','level'=>'3','pinyin'=>'nong\'an','code'=>'0431','zip_code'=>'130200','first'=>'N','lng'=>'125.18481','lat'=>'44.43265']);
        $this->insert('{{%region}}',['id'=>'595','pid'=>'586','shortname'=>'榆树','name'=>'榆树市','merger_name'=>'中国,吉林省,长春市,榆树市','level'=>'3','pinyin'=>'yushu','code'=>'0431','zip_code'=>'130400','first'=>'Y','lng'=>'126.55688','lat'=>'44.82523']);
        $this->insert('{{%region}}',['id'=>'596','pid'=>'586','shortname'=>'德惠','name'=>'德惠市','merger_name'=>'中国,吉林省,长春市,德惠市','level'=>'3','pinyin'=>'dehui','code'=>'0431','zip_code'=>'130300','first'=>'D','lng'=>'125.70538','lat'=>'44.53719']);
        $this->insert('{{%region}}',['id'=>'597','pid'=>'585','shortname'=>'吉林','name'=>'吉林市','merger_name'=>'中国,吉林省,吉林市','level'=>'2','pinyin'=>'jilin','code'=>'0432','zip_code'=>'132011','first'=>'J','lng'=>'126.55302','lat'=>'43.843577']);
        $this->insert('{{%region}}',['id'=>'598','pid'=>'597','shortname'=>'昌邑','name'=>'昌邑区','merger_name'=>'中国,吉林省,吉林市,昌邑区','level'=>'3','pinyin'=>'changyi','code'=>'0432','zip_code'=>'132002','first'=>'C','lng'=>'126.57424','lat'=>'43.88183']);
        $this->insert('{{%region}}',['id'=>'599','pid'=>'597','shortname'=>'龙潭','name'=>'龙潭区','merger_name'=>'中国,吉林省,吉林市,龙潭区','level'=>'3','pinyin'=>'longtan','code'=>'0432','zip_code'=>'132021','first'=>'L','lng'=>'126.56213','lat'=>'43.91054']);
        $this->insert('{{%region}}',['id'=>'600','pid'=>'597','shortname'=>'船营','name'=>'船营区','merger_name'=>'中国,吉林省,吉林市,船营区','level'=>'3','pinyin'=>'chuanying','code'=>'0432','zip_code'=>'132011','first'=>'C','lng'=>'126.54096','lat'=>'43.83344']);
        $this->insert('{{%region}}',['id'=>'601','pid'=>'597','shortname'=>'丰满','name'=>'丰满区','merger_name'=>'中国,吉林省,吉林市,丰满区','level'=>'3','pinyin'=>'fengman','code'=>'0432','zip_code'=>'132013','first'=>'F','lng'=>'126.56237','lat'=>'43.82236']);
        $this->insert('{{%region}}',['id'=>'602','pid'=>'597','shortname'=>'永吉','name'=>'永吉县','merger_name'=>'中国,吉林省,吉林市,永吉县','level'=>'3','pinyin'=>'yongji','code'=>'0432','zip_code'=>'132200','first'=>'Y','lng'=>'126.4963','lat'=>'43.67197']);
        $this->insert('{{%region}}',['id'=>'603','pid'=>'597','shortname'=>'蛟河','name'=>'蛟河市','merger_name'=>'中国,吉林省,吉林市,蛟河市','level'=>'3','pinyin'=>'jiaohe','code'=>'0432','zip_code'=>'132500','first'=>NULL,'lng'=>'127.34426','lat'=>'43.72696']);
        $this->insert('{{%region}}',['id'=>'604','pid'=>'597','shortname'=>'桦甸','name'=>'桦甸市','merger_name'=>'中国,吉林省,吉林市,桦甸市','level'=>'3','pinyin'=>'huadian','code'=>'0432','zip_code'=>'132400','first'=>NULL,'lng'=>'126.74624','lat'=>'42.97206']);
        $this->insert('{{%region}}',['id'=>'605','pid'=>'597','shortname'=>'舒兰','name'=>'舒兰市','merger_name'=>'中国,吉林省,吉林市,舒兰市','level'=>'3','pinyin'=>'shulan','code'=>'0432','zip_code'=>'132600','first'=>'S','lng'=>'126.9653','lat'=>'44.40582']);
        $this->insert('{{%region}}',['id'=>'606','pid'=>'597','shortname'=>'磐石','name'=>'磐石市','merger_name'=>'中国,吉林省,吉林市,磐石市','level'=>'3','pinyin'=>'panshi','code'=>'0432','zip_code'=>'132300','first'=>'P','lng'=>'126.0625','lat'=>'42.94628']);
        $this->insert('{{%region}}',['id'=>'607','pid'=>'585','shortname'=>'四平','name'=>'四平市','merger_name'=>'中国,吉林省,四平市','level'=>'2','pinyin'=>'siping','code'=>'0434','zip_code'=>'136000','first'=>'S','lng'=>'124.370785','lat'=>'43.170344']);
        $this->insert('{{%region}}',['id'=>'608','pid'=>'607','shortname'=>'铁西','name'=>'铁西区','merger_name'=>'中国,吉林省,四平市,铁西区','level'=>'3','pinyin'=>'tiexi','code'=>'0434','zip_code'=>'136000','first'=>'T','lng'=>'124.37369','lat'=>'43.17456']);
        $this->insert('{{%region}}',['id'=>'609','pid'=>'607','shortname'=>'铁东','name'=>'铁东区','merger_name'=>'中国,吉林省,四平市,铁东区','level'=>'3','pinyin'=>'tiedong','code'=>'0434','zip_code'=>'136001','first'=>'T','lng'=>'124.40976','lat'=>'43.16241']);
        $this->insert('{{%region}}',['id'=>'610','pid'=>'607','shortname'=>'梨树','name'=>'梨树县','merger_name'=>'中国,吉林省,四平市,梨树县','level'=>'3','pinyin'=>'lishu','code'=>'0434','zip_code'=>'136500','first'=>'L','lng'=>'124.33563','lat'=>'43.30717']);
        $this->insert('{{%region}}',['id'=>'611','pid'=>'607','shortname'=>'伊通','name'=>'伊通满族自治县','merger_name'=>'中国,吉林省,四平市,伊通满族自治县','level'=>'3','pinyin'=>'yitong','code'=>'0434','zip_code'=>'130700','first'=>'Y','lng'=>'125.30596','lat'=>'43.34434']);
        $this->insert('{{%region}}',['id'=>'612','pid'=>'607','shortname'=>'公主岭','name'=>'公主岭市','merger_name'=>'中国,吉林省,四平市,公主岭市','level'=>'3','pinyin'=>'gongzhuling','code'=>'0434','zip_code'=>'136100','first'=>'G','lng'=>'124.82266','lat'=>'43.50453']);
        $this->insert('{{%region}}',['id'=>'613','pid'=>'607','shortname'=>'双辽','name'=>'双辽市','merger_name'=>'中国,吉林省,四平市,双辽市','level'=>'3','pinyin'=>'shuangliao','code'=>'0434','zip_code'=>'136400','first'=>'S','lng'=>'123.50106','lat'=>'43.52099']);
        $this->insert('{{%region}}',['id'=>'614','pid'=>'585','shortname'=>'辽源','name'=>'辽源市','merger_name'=>'中国,吉林省,辽源市','level'=>'2','pinyin'=>'liaoyuan','code'=>'0437','zip_code'=>'136200','first'=>'L','lng'=>'125.145349','lat'=>'42.902692']);
        $this->insert('{{%region}}',['id'=>'615','pid'=>'614','shortname'=>'龙山','name'=>'龙山区','merger_name'=>'中国,吉林省,辽源市,龙山区','level'=>'3','pinyin'=>'longshan','code'=>'0437','zip_code'=>'136200','first'=>'L','lng'=>'125.13641','lat'=>'42.89714']);
        $this->insert('{{%region}}',['id'=>'616','pid'=>'614','shortname'=>'西安','name'=>'西安区','merger_name'=>'中国,吉林省,辽源市,西安区','level'=>'3','pinyin'=>'xi\'an','code'=>'0437','zip_code'=>'136201','first'=>'X','lng'=>'125.14904','lat'=>'42.927']);
        $this->insert('{{%region}}',['id'=>'617','pid'=>'614','shortname'=>'东丰','name'=>'东丰县','merger_name'=>'中国,吉林省,辽源市,东丰县','level'=>'3','pinyin'=>'dongfeng','code'=>'0437','zip_code'=>'136300','first'=>'D','lng'=>'125.53244','lat'=>'42.6783']);
        $this->insert('{{%region}}',['id'=>'618','pid'=>'614','shortname'=>'东辽','name'=>'东辽县','merger_name'=>'中国,吉林省,辽源市,东辽县','level'=>'3','pinyin'=>'dongliao','code'=>'0437','zip_code'=>'136600','first'=>'D','lng'=>'124.98596','lat'=>'42.92492']);
        $this->insert('{{%region}}',['id'=>'619','pid'=>'585','shortname'=>'通化','name'=>'通化市','merger_name'=>'中国,吉林省,通化市','level'=>'2','pinyin'=>'tonghua','code'=>'0435','zip_code'=>'134001','first'=>'T','lng'=>'125.936501','lat'=>'41.721177']);
        $this->insert('{{%region}}',['id'=>'620','pid'=>'619','shortname'=>'东昌','name'=>'东昌区','merger_name'=>'中国,吉林省,通化市,东昌区','level'=>'3','pinyin'=>'dongchang','code'=>'0435','zip_code'=>'134001','first'=>'D','lng'=>'125.9551','lat'=>'41.72849']);
        $this->insert('{{%region}}',['id'=>'621','pid'=>'619','shortname'=>'二道江','name'=>'二道江区','merger_name'=>'中国,吉林省,通化市,二道江区','level'=>'3','pinyin'=>'erdaojiang','code'=>'0435','zip_code'=>'134003','first'=>'E','lng'=>'126.04257','lat'=>'41.7741']);
        $this->insert('{{%region}}',['id'=>'622','pid'=>'619','shortname'=>'通化','name'=>'通化县','merger_name'=>'中国,吉林省,通化市,通化县','level'=>'3','pinyin'=>'tonghua','code'=>'0435','zip_code'=>'134100','first'=>'T','lng'=>'125.75936','lat'=>'41.67928']);
        $this->insert('{{%region}}',['id'=>'623','pid'=>'619','shortname'=>'辉南','name'=>'辉南县','merger_name'=>'中国,吉林省,通化市,辉南县','level'=>'3','pinyin'=>'huinan','code'=>'0435','zip_code'=>'135100','first'=>'H','lng'=>'126.04684','lat'=>'42.68497']);
        $this->insert('{{%region}}',['id'=>'624','pid'=>'619','shortname'=>'柳河','name'=>'柳河县','merger_name'=>'中国,吉林省,通化市,柳河县','level'=>'3','pinyin'=>'liuhe','code'=>'0435','zip_code'=>'135300','first'=>'L','lng'=>'125.74475','lat'=>'42.28468']);
        $this->insert('{{%region}}',['id'=>'625','pid'=>'619','shortname'=>'梅河口','name'=>'梅河口市','merger_name'=>'中国,吉林省,通化市,梅河口市','level'=>'3','pinyin'=>'meihekou','code'=>'0435','zip_code'=>'135000','first'=>'M','lng'=>'125.71041','lat'=>'42.53828']);
        $this->insert('{{%region}}',['id'=>'626','pid'=>'619','shortname'=>'集安','name'=>'集安市','merger_name'=>'中国,吉林省,通化市,集安市','level'=>'3','pinyin'=>'ji\'an','code'=>'0435','zip_code'=>'134200','first'=>'J','lng'=>'126.18829','lat'=>'41.12268']);
        $this->insert('{{%region}}',['id'=>'627','pid'=>'585','shortname'=>'白山','name'=>'白山市','merger_name'=>'中国,吉林省,白山市','level'=>'2','pinyin'=>'baishan','code'=>'0439','zip_code'=>'134300','first'=>'B','lng'=>'126.427839','lat'=>'41.942505']);
        $this->insert('{{%region}}',['id'=>'628','pid'=>'627','shortname'=>'浑江','name'=>'浑江区','merger_name'=>'中国,吉林省,白山市,浑江区','level'=>'3','pinyin'=>'hunjiang','code'=>'0439','zip_code'=>'134300','first'=>'H','lng'=>'126.422342','lat'=>'41.945656']);
        $this->insert('{{%region}}',['id'=>'629','pid'=>'627','shortname'=>'江源','name'=>'江源区','merger_name'=>'中国,吉林省,白山市,江源区','level'=>'3','pinyin'=>'jiangyuan','code'=>'0439','zip_code'=>'134700','first'=>'J','lng'=>'126.59079','lat'=>'42.05664']);
        $this->insert('{{%region}}',['id'=>'630','pid'=>'627','shortname'=>'抚松','name'=>'抚松县','merger_name'=>'中国,吉林省,白山市,抚松县','level'=>'3','pinyin'=>'fusong','code'=>'0439','zip_code'=>'134500','first'=>'F','lng'=>'127.2803','lat'=>'42.34198']);
        $this->insert('{{%region}}',['id'=>'631','pid'=>'627','shortname'=>'靖宇','name'=>'靖宇县','merger_name'=>'中国,吉林省,白山市,靖宇县','level'=>'3','pinyin'=>'jingyu','code'=>'0439','zip_code'=>'135200','first'=>'J','lng'=>'126.81308','lat'=>'42.38863']);
        $this->insert('{{%region}}',['id'=>'632','pid'=>'627','shortname'=>'长白','name'=>'长白朝鲜族自治县','merger_name'=>'中国,吉林省,白山市,长白朝鲜族自治县','level'=>'3','pinyin'=>'changbai','code'=>'0439','zip_code'=>'134400','first'=>'C','lng'=>'128.20047','lat'=>'41.41996']);
        $this->insert('{{%region}}',['id'=>'633','pid'=>'627','shortname'=>'临江','name'=>'临江市','merger_name'=>'中国,吉林省,白山市,临江市','level'=>'3','pinyin'=>'linjiang','code'=>'0439','zip_code'=>'134600','first'=>'L','lng'=>'126.91751','lat'=>'41.81142']);
        $this->insert('{{%region}}',['id'=>'634','pid'=>'585','shortname'=>'松原','name'=>'松原市','merger_name'=>'中国,吉林省,松原市','level'=>'2','pinyin'=>'songyuan','code'=>'0438','zip_code'=>'138000','first'=>'S','lng'=>'124.823608','lat'=>'45.118243']);
        $this->insert('{{%region}}',['id'=>'635','pid'=>'634','shortname'=>'宁江','name'=>'宁江区','merger_name'=>'中国,吉林省,松原市,宁江区','level'=>'3','pinyin'=>'ningjiang','code'=>'0438','zip_code'=>'138000','first'=>'N','lng'=>'124.81689','lat'=>'45.17175']);
        $this->insert('{{%region}}',['id'=>'636','pid'=>'634','shortname'=>'前郭尔罗斯','name'=>'前郭尔罗斯蒙古族自治县','merger_name'=>'中国,吉林省,松原市,前郭尔罗斯蒙古族自治县','level'=>'3','pinyin'=>'qianguoerluosi','code'=>'0438','zip_code'=>'138000','first'=>'Q','lng'=>'124.82351','lat'=>'45.11726']);
        $this->insert('{{%region}}',['id'=>'637','pid'=>'634','shortname'=>'长岭','name'=>'长岭县','merger_name'=>'中国,吉林省,松原市,长岭县','level'=>'3','pinyin'=>'changling','code'=>'0438','zip_code'=>'131500','first'=>'C','lng'=>'123.96725','lat'=>'44.27581']);
        $this->insert('{{%region}}',['id'=>'638','pid'=>'634','shortname'=>'乾安','name'=>'乾安县','merger_name'=>'中国,吉林省,松原市,乾安县','level'=>'3','pinyin'=>'qian\'an','code'=>'0438','zip_code'=>'131400','first'=>'Q','lng'=>'124.02737','lat'=>'45.01068']);
        $this->insert('{{%region}}',['id'=>'639','pid'=>'634','shortname'=>'扶余','name'=>'扶余市','merger_name'=>'中国,吉林省,松原市,扶余市','level'=>'3','pinyin'=>'fuyu','code'=>'0438','zip_code'=>'131200','first'=>'F','lng'=>'126.042758','lat'=>'44.986199']);
        $this->insert('{{%region}}',['id'=>'640','pid'=>'585','shortname'=>'白城','name'=>'白城市','merger_name'=>'中国,吉林省,白城市','level'=>'2','pinyin'=>'baicheng','code'=>'0436','zip_code'=>'137000','first'=>'B','lng'=>'122.841114','lat'=>'45.619026']);
        $this->insert('{{%region}}',['id'=>'641','pid'=>'640','shortname'=>'洮北','name'=>'洮北区','merger_name'=>'中国,吉林省,白城市,洮北区','level'=>'3','pinyin'=>'taobei','code'=>'0436','zip_code'=>'137000','first'=>NULL,'lng'=>'122.85104','lat'=>'45.62167']);
        $this->insert('{{%region}}',['id'=>'642','pid'=>'640','shortname'=>'镇赉','name'=>'镇赉县','merger_name'=>'中国,吉林省,白城市,镇赉县','level'=>'3','pinyin'=>'zhenlai','code'=>'0436','zip_code'=>'137300','first'=>'Z','lng'=>'123.19924','lat'=>'45.84779']);
        $this->insert('{{%region}}',['id'=>'643','pid'=>'640','shortname'=>'通榆','name'=>'通榆县','merger_name'=>'中国,吉林省,白城市,通榆县','level'=>'3','pinyin'=>'tongyu','code'=>'0436','zip_code'=>'137200','first'=>'T','lng'=>'123.08761','lat'=>'44.81388']);
        $this->insert('{{%region}}',['id'=>'644','pid'=>'640','shortname'=>'洮南','name'=>'洮南市','merger_name'=>'中国,吉林省,白城市,洮南市','level'=>'3','pinyin'=>'taonan','code'=>'0436','zip_code'=>'137100','first'=>NULL,'lng'=>'122.78772','lat'=>'45.33502']);
        $this->insert('{{%region}}',['id'=>'645','pid'=>'640','shortname'=>'大安','name'=>'大安市','merger_name'=>'中国,吉林省,白城市,大安市','level'=>'3','pinyin'=>'da\'an','code'=>'0436','zip_code'=>'131300','first'=>'D','lng'=>'124.29519','lat'=>'45.50846']);
        $this->insert('{{%region}}',['id'=>'646','pid'=>'585','shortname'=>'延边','name'=>'延边朝鲜族自治州','merger_name'=>'中国,吉林省,延边朝鲜族自治州','level'=>'2','pinyin'=>'yanbian','code'=>'0433','zip_code'=>'133000','first'=>'Y','lng'=>'129.513228','lat'=>'42.904823']);
        $this->insert('{{%region}}',['id'=>'647','pid'=>'646','shortname'=>'延吉','name'=>'延吉市','merger_name'=>'中国,吉林省,延边朝鲜族自治州,延吉市','level'=>'3','pinyin'=>'yanji','code'=>'0433','zip_code'=>'133000','first'=>'Y','lng'=>'129.51357','lat'=>'42.90682']);
        $this->insert('{{%region}}',['id'=>'648','pid'=>'646','shortname'=>'图们','name'=>'图们市','merger_name'=>'中国,吉林省,延边朝鲜族自治州,图们市','level'=>'3','pinyin'=>'tumen','code'=>'0433','zip_code'=>'133100','first'=>'T','lng'=>'129.84381','lat'=>'42.96801']);
        $this->insert('{{%region}}',['id'=>'649','pid'=>'646','shortname'=>'敦化','name'=>'敦化市','merger_name'=>'中国,吉林省,延边朝鲜族自治州,敦化市','level'=>'3','pinyin'=>'dunhua','code'=>'0433','zip_code'=>'133700','first'=>'D','lng'=>'128.23242','lat'=>'43.37304']);
        $this->insert('{{%region}}',['id'=>'650','pid'=>'646','shortname'=>'珲春','name'=>'珲春市','merger_name'=>'中国,吉林省,延边朝鲜族自治州,珲春市','level'=>'3','pinyin'=>'hunchun','code'=>'0433','zip_code'=>'133300','first'=>NULL,'lng'=>'130.36572','lat'=>'42.86242']);
        $this->insert('{{%region}}',['id'=>'651','pid'=>'646','shortname'=>'龙井','name'=>'龙井市','merger_name'=>'中国,吉林省,延边朝鲜族自治州,龙井市','level'=>'3','pinyin'=>'longjing','code'=>'0433','zip_code'=>'133400','first'=>'L','lng'=>'129.42584','lat'=>'42.76804']);
        $this->insert('{{%region}}',['id'=>'652','pid'=>'646','shortname'=>'和龙','name'=>'和龙市','merger_name'=>'中国,吉林省,延边朝鲜族自治州,和龙市','level'=>'3','pinyin'=>'helong','code'=>'0433','zip_code'=>'133500','first'=>'H','lng'=>'129.01077','lat'=>'42.5464']);
        $this->insert('{{%region}}',['id'=>'653','pid'=>'646','shortname'=>'汪清','name'=>'汪清县','merger_name'=>'中国,吉林省,延边朝鲜族自治州,汪清县','level'=>'3','pinyin'=>'wangqing','code'=>'0433','zip_code'=>'133200','first'=>'W','lng'=>'129.77121','lat'=>'43.31278']);
        $this->insert('{{%region}}',['id'=>'654','pid'=>'646','shortname'=>'安图','name'=>'安图县','merger_name'=>'中国,吉林省,延边朝鲜族自治州,安图县','level'=>'3','pinyin'=>'antu','code'=>'0433','zip_code'=>'133600','first'=>'A','lng'=>'128.90625','lat'=>'43.11533']);
        $this->insert('{{%region}}',['id'=>'655','pid'=>'0','shortname'=>'黑龙江','name'=>'黑龙江省','merger_name'=>'中国,黑龙江省','level'=>'1','pinyin'=>'heilongjiang','code'=>'','zip_code'=>'','first'=>'H','lng'=>'126.642464','lat'=>'45.756967']);
        $this->insert('{{%region}}',['id'=>'656','pid'=>'655','shortname'=>'哈尔滨','name'=>'哈尔滨市','merger_name'=>'中国,黑龙江省,哈尔滨市','level'=>'2','pinyin'=>'harbin','code'=>'0451','zip_code'=>'150010','first'=>'H','lng'=>'126.642464','lat'=>'45.756967']);
        $this->insert('{{%region}}',['id'=>'657','pid'=>'656','shortname'=>'道里','name'=>'道里区','merger_name'=>'中国,黑龙江省,哈尔滨市,道里区','level'=>'3','pinyin'=>'daoli','code'=>'0451','zip_code'=>'150010','first'=>'D','lng'=>'126.61705','lat'=>'45.75586']);
        $this->insert('{{%region}}',['id'=>'658','pid'=>'656','shortname'=>'南岗','name'=>'南岗区','merger_name'=>'中国,黑龙江省,哈尔滨市,南岗区','level'=>'3','pinyin'=>'nangang','code'=>'0451','zip_code'=>'150006','first'=>'N','lng'=>'126.66854','lat'=>'45.75996']);
        $this->insert('{{%region}}',['id'=>'659','pid'=>'656','shortname'=>'道外','name'=>'道外区','merger_name'=>'中国,黑龙江省,哈尔滨市,道外区','level'=>'3','pinyin'=>'daowai','code'=>'0451','zip_code'=>'150020','first'=>'D','lng'=>'126.64938','lat'=>'45.79187']);
        $this->insert('{{%region}}',['id'=>'660','pid'=>'656','shortname'=>'平房','name'=>'平房区','merger_name'=>'中国,黑龙江省,哈尔滨市,平房区','level'=>'3','pinyin'=>'pingfang','code'=>'0451','zip_code'=>'150060','first'=>'P','lng'=>'126.63729','lat'=>'45.59777']);
        $this->insert('{{%region}}',['id'=>'661','pid'=>'656','shortname'=>'松北','name'=>'松北区','merger_name'=>'中国,黑龙江省,哈尔滨市,松北区','level'=>'3','pinyin'=>'songbei','code'=>'0451','zip_code'=>'150028','first'=>'S','lng'=>'126.56276','lat'=>'45.80831']);
        $this->insert('{{%region}}',['id'=>'662','pid'=>'656','shortname'=>'香坊','name'=>'香坊区','merger_name'=>'中国,黑龙江省,哈尔滨市,香坊区','level'=>'3','pinyin'=>'xiangfang','code'=>'0451','zip_code'=>'150036','first'=>'X','lng'=>'126.67968','lat'=>'45.72383']);
        $this->insert('{{%region}}',['id'=>'663','pid'=>'656','shortname'=>'呼兰','name'=>'呼兰区','merger_name'=>'中国,黑龙江省,哈尔滨市,呼兰区','level'=>'3','pinyin'=>'hulan','code'=>'0451','zip_code'=>'150500','first'=>'H','lng'=>'126.58792','lat'=>'45.88895']);
        $this->insert('{{%region}}',['id'=>'664','pid'=>'656','shortname'=>'阿城','name'=>'阿城区','merger_name'=>'中国,黑龙江省,哈尔滨市,阿城区','level'=>'3','pinyin'=>'a\'cheng','code'=>'0451','zip_code'=>'150300','first'=>'A','lng'=>'126.97525','lat'=>'45.54144']);
        $this->insert('{{%region}}',['id'=>'665','pid'=>'656','shortname'=>'双城','name'=>'双城区','merger_name'=>'中国,黑龙江省,哈尔滨市,双城区','level'=>'3','pinyin'=>'shuangcheng','code'=>'0451','zip_code'=>'150100','first'=>'S','lng'=>'126.308784','lat'=>'45.377942']);
        $this->insert('{{%region}}',['id'=>'666','pid'=>'656','shortname'=>'依兰','name'=>'依兰县','merger_name'=>'中国,黑龙江省,哈尔滨市,依兰县','level'=>'3','pinyin'=>'yilan','code'=>'0451','zip_code'=>'154800','first'=>'Y','lng'=>'129.56817','lat'=>'46.3247']);
        $this->insert('{{%region}}',['id'=>'667','pid'=>'656','shortname'=>'方正','name'=>'方正县','merger_name'=>'中国,黑龙江省,哈尔滨市,方正县','level'=>'3','pinyin'=>'fangzheng','code'=>'0451','zip_code'=>'150800','first'=>'F','lng'=>'128.82952','lat'=>'45.85162']);
        $this->insert('{{%region}}',['id'=>'668','pid'=>'656','shortname'=>'宾县','name'=>'宾县','merger_name'=>'中国,黑龙江省,哈尔滨市,宾县','level'=>'3','pinyin'=>'binxian','code'=>'0451','zip_code'=>'150400','first'=>'B','lng'=>'127.48675','lat'=>'45.75504']);
        $this->insert('{{%region}}',['id'=>'669','pid'=>'656','shortname'=>'巴彦','name'=>'巴彦县','merger_name'=>'中国,黑龙江省,哈尔滨市,巴彦县','level'=>'3','pinyin'=>'bayan','code'=>'0451','zip_code'=>'151800','first'=>'B','lng'=>'127.40799','lat'=>'46.08148']);
        $this->insert('{{%region}}',['id'=>'670','pid'=>'656','shortname'=>'木兰','name'=>'木兰县','merger_name'=>'中国,黑龙江省,哈尔滨市,木兰县','level'=>'3','pinyin'=>'mulan','code'=>'0451','zip_code'=>'151900','first'=>'M','lng'=>'128.0448','lat'=>'45.94944']);
        $this->insert('{{%region}}',['id'=>'671','pid'=>'656','shortname'=>'通河','name'=>'通河县','merger_name'=>'中国,黑龙江省,哈尔滨市,通河县','level'=>'3','pinyin'=>'tonghe','code'=>'0451','zip_code'=>'150900','first'=>'T','lng'=>'128.74603','lat'=>'45.99007']);
        $this->insert('{{%region}}',['id'=>'672','pid'=>'656','shortname'=>'延寿','name'=>'延寿县','merger_name'=>'中国,黑龙江省,哈尔滨市,延寿县','level'=>'3','pinyin'=>'yanshou','code'=>'0451','zip_code'=>'150700','first'=>'Y','lng'=>'128.33419','lat'=>'45.4554']);
        $this->insert('{{%region}}',['id'=>'673','pid'=>'656','shortname'=>'尚志','name'=>'尚志市','merger_name'=>'中国,黑龙江省,哈尔滨市,尚志市','level'=>'3','pinyin'=>'shangzhi','code'=>'0451','zip_code'=>'150600','first'=>'S','lng'=>'127.96191','lat'=>'45.21736']);
        $this->insert('{{%region}}',['id'=>'674','pid'=>'656','shortname'=>'五常','name'=>'五常市','merger_name'=>'中国,黑龙江省,哈尔滨市,五常市','level'=>'3','pinyin'=>'wuchang','code'=>'0451','zip_code'=>'150200','first'=>'W','lng'=>'127.16751','lat'=>'44.93184']);
        $this->insert('{{%region}}',['id'=>'675','pid'=>'655','shortname'=>'齐齐哈尔','name'=>'齐齐哈尔市','merger_name'=>'中国,黑龙江省,齐齐哈尔市','level'=>'2','pinyin'=>'qiqihar','code'=>'0452','zip_code'=>'161005','first'=>'Q','lng'=>'123.953486','lat'=>'47.348079']);
        $this->insert('{{%region}}',['id'=>'676','pid'=>'675','shortname'=>'龙沙','name'=>'龙沙区','merger_name'=>'中国,黑龙江省,齐齐哈尔市,龙沙区','level'=>'3','pinyin'=>'longsha','code'=>'0452','zip_code'=>'161000','first'=>'L','lng'=>'123.95752','lat'=>'47.31776']);
        $this->insert('{{%region}}',['id'=>'677','pid'=>'675','shortname'=>'建华','name'=>'建华区','merger_name'=>'中国,黑龙江省,齐齐哈尔市,建华区','level'=>'3','pinyin'=>'jianhua','code'=>'0452','zip_code'=>'161006','first'=>'J','lng'=>'124.0133','lat'=>'47.36718']);
        $this->insert('{{%region}}',['id'=>'678','pid'=>'675','shortname'=>'铁锋','name'=>'铁锋区','merger_name'=>'中国,黑龙江省,齐齐哈尔市,铁锋区','level'=>'3','pinyin'=>'tiefeng','code'=>'0452','zip_code'=>'161000','first'=>'T','lng'=>'123.97821','lat'=>'47.34075']);
        $this->insert('{{%region}}',['id'=>'679','pid'=>'675','shortname'=>'昂昂溪','name'=>'昂昂溪区','merger_name'=>'中国,黑龙江省,齐齐哈尔市,昂昂溪区','level'=>'3','pinyin'=>'angangxi','code'=>'0452','zip_code'=>'161031','first'=>'A','lng'=>'123.82229','lat'=>'47.15513']);
        $this->insert('{{%region}}',['id'=>'680','pid'=>'675','shortname'=>'富拉尔基','name'=>'富拉尔基区','merger_name'=>'中国,黑龙江省,齐齐哈尔市,富拉尔基区','level'=>'3','pinyin'=>'fulaerji','code'=>'0452','zip_code'=>'161041','first'=>'F','lng'=>'123.62918','lat'=>'47.20884']);
        $this->insert('{{%region}}',['id'=>'681','pid'=>'675','shortname'=>'碾子山','name'=>'碾子山区','merger_name'=>'中国,黑龙江省,齐齐哈尔市,碾子山区','level'=>'3','pinyin'=>'nianzishan','code'=>'0452','zip_code'=>'161046','first'=>'N','lng'=>'122.88183','lat'=>'47.51662']);
        $this->insert('{{%region}}',['id'=>'682','pid'=>'675','shortname'=>'梅里斯','name'=>'梅里斯达斡尔族区','merger_name'=>'中国,黑龙江省,齐齐哈尔市,梅里斯达斡尔族区','level'=>'3','pinyin'=>'meilisi','code'=>'0452','zip_code'=>'161021','first'=>'M','lng'=>'123.75274','lat'=>'47.30946']);
        $this->insert('{{%region}}',['id'=>'683','pid'=>'675','shortname'=>'龙江','name'=>'龙江县','merger_name'=>'中国,黑龙江省,齐齐哈尔市,龙江县','level'=>'3','pinyin'=>'longjiang','code'=>'0452','zip_code'=>'161100','first'=>'L','lng'=>'123.20532','lat'=>'47.33868']);
        $this->insert('{{%region}}',['id'=>'684','pid'=>'675','shortname'=>'依安','name'=>'依安县','merger_name'=>'中国,黑龙江省,齐齐哈尔市,依安县','level'=>'3','pinyin'=>'yi\'an','code'=>'0452','zip_code'=>'161500','first'=>'Y','lng'=>'125.30896','lat'=>'47.8931']);
        $this->insert('{{%region}}',['id'=>'685','pid'=>'675','shortname'=>'泰来','name'=>'泰来县','merger_name'=>'中国,黑龙江省,齐齐哈尔市,泰来县','level'=>'3','pinyin'=>'tailai','code'=>'0452','zip_code'=>'162400','first'=>'T','lng'=>'123.42285','lat'=>'46.39386']);
        $this->insert('{{%region}}',['id'=>'686','pid'=>'675','shortname'=>'甘南','name'=>'甘南县','merger_name'=>'中国,黑龙江省,齐齐哈尔市,甘南县','level'=>'3','pinyin'=>'gannan','code'=>'0452','zip_code'=>'162100','first'=>'G','lng'=>'123.50317','lat'=>'47.92437']);
        $this->insert('{{%region}}',['id'=>'687','pid'=>'675','shortname'=>'富裕','name'=>'富裕县','merger_name'=>'中国,黑龙江省,齐齐哈尔市,富裕县','level'=>'3','pinyin'=>'fuyu','code'=>'0452','zip_code'=>'161200','first'=>'F','lng'=>'124.47457','lat'=>'47.77431']);
        $this->insert('{{%region}}',['id'=>'688','pid'=>'675','shortname'=>'克山','name'=>'克山县','merger_name'=>'中国,黑龙江省,齐齐哈尔市,克山县','level'=>'3','pinyin'=>'keshan','code'=>'0452','zip_code'=>'161600','first'=>'K','lng'=>'125.87396','lat'=>'48.03265']);
        $this->insert('{{%region}}',['id'=>'689','pid'=>'675','shortname'=>'克东','name'=>'克东县','merger_name'=>'中国,黑龙江省,齐齐哈尔市,克东县','level'=>'3','pinyin'=>'kedong','code'=>'0452','zip_code'=>'164800','first'=>'K','lng'=>'126.24917','lat'=>'48.03828']);
        $this->insert('{{%region}}',['id'=>'690','pid'=>'675','shortname'=>'拜泉','name'=>'拜泉县','merger_name'=>'中国,黑龙江省,齐齐哈尔市,拜泉县','level'=>'3','pinyin'=>'baiquan','code'=>'0452','zip_code'=>'164700','first'=>'B','lng'=>'126.09167','lat'=>'47.60817']);
        $this->insert('{{%region}}',['id'=>'691','pid'=>'675','shortname'=>'讷河','name'=>'讷河市','merger_name'=>'中国,黑龙江省,齐齐哈尔市,讷河市','level'=>'3','pinyin'=>'nehe','code'=>'0452','zip_code'=>'161300','first'=>NULL,'lng'=>'124.87713','lat'=>'48.48388']);
        $this->insert('{{%region}}',['id'=>'692','pid'=>'655','shortname'=>'鸡西','name'=>'鸡西市','merger_name'=>'中国,黑龙江省,鸡西市','level'=>'2','pinyin'=>'jixi','code'=>'0467','zip_code'=>'158100','first'=>'J','lng'=>'130.975966','lat'=>'45.300046']);
        $this->insert('{{%region}}',['id'=>'693','pid'=>'692','shortname'=>'鸡冠','name'=>'鸡冠区','merger_name'=>'中国,黑龙江省,鸡西市,鸡冠区','level'=>'3','pinyin'=>'jiguan','code'=>'0467','zip_code'=>'158100','first'=>'J','lng'=>'130.98139','lat'=>'45.30396']);
        $this->insert('{{%region}}',['id'=>'694','pid'=>'692','shortname'=>'恒山','name'=>'恒山区','merger_name'=>'中国,黑龙江省,鸡西市,恒山区','level'=>'3','pinyin'=>'hengshan','code'=>'0467','zip_code'=>'158130','first'=>'H','lng'=>'130.90493','lat'=>'45.21071']);
        $this->insert('{{%region}}',['id'=>'695','pid'=>'692','shortname'=>'滴道','name'=>'滴道区','merger_name'=>'中国,黑龙江省,鸡西市,滴道区','level'=>'3','pinyin'=>'didao','code'=>'0467','zip_code'=>'158150','first'=>'D','lng'=>'130.84841','lat'=>'45.35109']);
        $this->insert('{{%region}}',['id'=>'696','pid'=>'692','shortname'=>'梨树','name'=>'梨树区','merger_name'=>'中国,黑龙江省,鸡西市,梨树区','level'=>'3','pinyin'=>'lishu','code'=>'0467','zip_code'=>'158160','first'=>'L','lng'=>'130.69848','lat'=>'45.09037']);
        $this->insert('{{%region}}',['id'=>'697','pid'=>'692','shortname'=>'城子河','name'=>'城子河区','merger_name'=>'中国,黑龙江省,鸡西市,城子河区','level'=>'3','pinyin'=>'chengzihe','code'=>'0467','zip_code'=>'158170','first'=>'C','lng'=>'131.01132','lat'=>'45.33689']);
        $this->insert('{{%region}}',['id'=>'698','pid'=>'692','shortname'=>'麻山','name'=>'麻山区','merger_name'=>'中国,黑龙江省,鸡西市,麻山区','level'=>'3','pinyin'=>'mashan','code'=>'0467','zip_code'=>'158180','first'=>'M','lng'=>'130.47811','lat'=>'45.21209']);
        $this->insert('{{%region}}',['id'=>'699','pid'=>'692','shortname'=>'鸡东','name'=>'鸡东县','merger_name'=>'中国,黑龙江省,鸡西市,鸡东县','level'=>'3','pinyin'=>'jidong','code'=>'0467','zip_code'=>'158200','first'=>'J','lng'=>'131.12423','lat'=>'45.26025']);
        $this->insert('{{%region}}',['id'=>'700','pid'=>'692','shortname'=>'虎林','name'=>'虎林市','merger_name'=>'中国,黑龙江省,鸡西市,虎林市','level'=>'3','pinyin'=>'hulin','code'=>'0467','zip_code'=>'158400','first'=>'H','lng'=>'132.93679','lat'=>'45.76291']);
        $this->insert('{{%region}}',['id'=>'701','pid'=>'692','shortname'=>'密山','name'=>'密山市','merger_name'=>'中国,黑龙江省,鸡西市,密山市','level'=>'3','pinyin'=>'mishan','code'=>'0467','zip_code'=>'158300','first'=>'M','lng'=>'131.84625','lat'=>'45.5297']);
        $this->insert('{{%region}}',['id'=>'702','pid'=>'655','shortname'=>'鹤岗','name'=>'鹤岗市','merger_name'=>'中国,黑龙江省,鹤岗市','level'=>'2','pinyin'=>'hegang','code'=>'0468','zip_code'=>'154100','first'=>'H','lng'=>'130.277487','lat'=>'47.332085']);
        $this->insert('{{%region}}',['id'=>'703','pid'=>'702','shortname'=>'向阳','name'=>'向阳区','merger_name'=>'中国,黑龙江省,鹤岗市,向阳区','level'=>'3','pinyin'=>'xiangyang','code'=>'0468','zip_code'=>'154100','first'=>'X','lng'=>'130.2943','lat'=>'47.34247']);
        $this->insert('{{%region}}',['id'=>'704','pid'=>'702','shortname'=>'工农','name'=>'工农区','merger_name'=>'中国,黑龙江省,鹤岗市,工农区','level'=>'3','pinyin'=>'gongnong','code'=>'0468','zip_code'=>'154101','first'=>'G','lng'=>'130.27468','lat'=>'47.31869']);
        $this->insert('{{%region}}',['id'=>'705','pid'=>'702','shortname'=>'南山','name'=>'南山区','merger_name'=>'中国,黑龙江省,鹤岗市,南山区','level'=>'3','pinyin'=>'nanshan','code'=>'0468','zip_code'=>'154104','first'=>'N','lng'=>'130.27676','lat'=>'47.31404']);
        $this->insert('{{%region}}',['id'=>'706','pid'=>'702','shortname'=>'兴安','name'=>'兴安区','merger_name'=>'中国,黑龙江省,鹤岗市,兴安区','level'=>'3','pinyin'=>'xing\'an','code'=>'0468','zip_code'=>'154102','first'=>'X','lng'=>'130.23965','lat'=>'47.2526']);
        $this->insert('{{%region}}',['id'=>'707','pid'=>'702','shortname'=>'东山','name'=>'东山区','merger_name'=>'中国,黑龙江省,鹤岗市,东山区','level'=>'3','pinyin'=>'dongshan','code'=>'0468','zip_code'=>'154106','first'=>'D','lng'=>'130.31706','lat'=>'47.33853']);
        $this->insert('{{%region}}',['id'=>'708','pid'=>'702','shortname'=>'兴山','name'=>'兴山区','merger_name'=>'中国,黑龙江省,鹤岗市,兴山区','level'=>'3','pinyin'=>'xingshan','code'=>'0468','zip_code'=>'154105','first'=>'X','lng'=>'130.29271','lat'=>'47.35776']);
        $this->insert('{{%region}}',['id'=>'709','pid'=>'702','shortname'=>'萝北','name'=>'萝北县','merger_name'=>'中国,黑龙江省,鹤岗市,萝北县','level'=>'3','pinyin'=>'luobei','code'=>'0468','zip_code'=>'154200','first'=>'L','lng'=>'130.83346','lat'=>'47.57959']);
        $this->insert('{{%region}}',['id'=>'710','pid'=>'702','shortname'=>'绥滨','name'=>'绥滨县','merger_name'=>'中国,黑龙江省,鹤岗市,绥滨县','level'=>'3','pinyin'=>'suibin','code'=>'0468','zip_code'=>'156200','first'=>'S','lng'=>'131.86029','lat'=>'47.2903']);
        $this->insert('{{%region}}',['id'=>'711','pid'=>'655','shortname'=>'双鸭山','name'=>'双鸭山市','merger_name'=>'中国,黑龙江省,双鸭山市','level'=>'2','pinyin'=>'shuangyashan','code'=>'0469','zip_code'=>'155100','first'=>'S','lng'=>'131.157304','lat'=>'46.643442']);
        $this->insert('{{%region}}',['id'=>'712','pid'=>'711','shortname'=>'尖山','name'=>'尖山区','merger_name'=>'中国,黑龙江省,双鸭山市,尖山区','level'=>'3','pinyin'=>'jianshan','code'=>'0469','zip_code'=>'155100','first'=>'J','lng'=>'131.15841','lat'=>'46.64635']);
        $this->insert('{{%region}}',['id'=>'713','pid'=>'711','shortname'=>'岭东','name'=>'岭东区','merger_name'=>'中国,黑龙江省,双鸭山市,岭东区','level'=>'3','pinyin'=>'lingdong','code'=>'0469','zip_code'=>'155120','first'=>'L','lng'=>'131.16473','lat'=>'46.59043']);
        $this->insert('{{%region}}',['id'=>'714','pid'=>'711','shortname'=>'四方台','name'=>'四方台区','merger_name'=>'中国,黑龙江省,双鸭山市,四方台区','level'=>'3','pinyin'=>'sifangtai','code'=>'0469','zip_code'=>'155130','first'=>'S','lng'=>'131.33593','lat'=>'46.59499']);
        $this->insert('{{%region}}',['id'=>'715','pid'=>'711','shortname'=>'宝山','name'=>'宝山区','merger_name'=>'中国,黑龙江省,双鸭山市,宝山区','level'=>'3','pinyin'=>'baoshan','code'=>'0469','zip_code'=>'155131','first'=>'B','lng'=>'131.4016','lat'=>'46.57718']);
        $this->insert('{{%region}}',['id'=>'716','pid'=>'711','shortname'=>'集贤','name'=>'集贤县','merger_name'=>'中国,黑龙江省,双鸭山市,集贤县','level'=>'3','pinyin'=>'jixian','code'=>'0469','zip_code'=>'155900','first'=>'J','lng'=>'131.14053','lat'=>'46.72678']);
        $this->insert('{{%region}}',['id'=>'717','pid'=>'711','shortname'=>'友谊','name'=>'友谊县','merger_name'=>'中国,黑龙江省,双鸭山市,友谊县','level'=>'3','pinyin'=>'youyi','code'=>'0469','zip_code'=>'155800','first'=>'Y','lng'=>'131.80789','lat'=>'46.76739']);
        $this->insert('{{%region}}',['id'=>'718','pid'=>'711','shortname'=>'宝清','name'=>'宝清县','merger_name'=>'中国,黑龙江省,双鸭山市,宝清县','level'=>'3','pinyin'=>'baoqing','code'=>'0469','zip_code'=>'155600','first'=>'B','lng'=>'132.19695','lat'=>'46.32716']);
        $this->insert('{{%region}}',['id'=>'719','pid'=>'711','shortname'=>'饶河','name'=>'饶河县','merger_name'=>'中国,黑龙江省,双鸭山市,饶河县','level'=>'3','pinyin'=>'raohe','code'=>'0469','zip_code'=>'155700','first'=>'R','lng'=>'134.01986','lat'=>'46.79899']);
        $this->insert('{{%region}}',['id'=>'720','pid'=>'655','shortname'=>'大庆','name'=>'大庆市','merger_name'=>'中国,黑龙江省,大庆市','level'=>'2','pinyin'=>'daqing','code'=>'0459','zip_code'=>'163000','first'=>'D','lng'=>'125.11272','lat'=>'46.590734']);
        $this->insert('{{%region}}',['id'=>'721','pid'=>'720','shortname'=>'萨尔图','name'=>'萨尔图区','merger_name'=>'中国,黑龙江省,大庆市,萨尔图区','level'=>'3','pinyin'=>'saertu','code'=>'0459','zip_code'=>'163001','first'=>'S','lng'=>'125.08792','lat'=>'46.59359']);
        $this->insert('{{%region}}',['id'=>'722','pid'=>'720','shortname'=>'龙凤','name'=>'龙凤区','merger_name'=>'中国,黑龙江省,大庆市,龙凤区','level'=>'3','pinyin'=>'longfeng','code'=>'0459','zip_code'=>'163711','first'=>'L','lng'=>'125.11657','lat'=>'46.53273']);
        $this->insert('{{%region}}',['id'=>'723','pid'=>'720','shortname'=>'让胡路','name'=>'让胡路区','merger_name'=>'中国,黑龙江省,大庆市,让胡路区','level'=>'3','pinyin'=>'ranghulu','code'=>'0459','zip_code'=>'163712','first'=>'R','lng'=>'124.87075','lat'=>'46.6522']);
        $this->insert('{{%region}}',['id'=>'724','pid'=>'720','shortname'=>'红岗','name'=>'红岗区','merger_name'=>'中国,黑龙江省,大庆市,红岗区','level'=>'3','pinyin'=>'honggang','code'=>'0459','zip_code'=>'163511','first'=>'H','lng'=>'124.89248','lat'=>'46.40128']);
        $this->insert('{{%region}}',['id'=>'725','pid'=>'720','shortname'=>'大同','name'=>'大同区','merger_name'=>'中国,黑龙江省,大庆市,大同区','level'=>'3','pinyin'=>'datong','code'=>'0459','zip_code'=>'163515','first'=>'D','lng'=>'124.81591','lat'=>'46.03295']);
        $this->insert('{{%region}}',['id'=>'726','pid'=>'720','shortname'=>'肇州','name'=>'肇州县','merger_name'=>'中国,黑龙江省,大庆市,肇州县','level'=>'3','pinyin'=>'zhaozhou','code'=>'0459','zip_code'=>'166400','first'=>'Z','lng'=>'125.27059','lat'=>'45.70414']);
        $this->insert('{{%region}}',['id'=>'727','pid'=>'720','shortname'=>'肇源','name'=>'肇源县','merger_name'=>'中国,黑龙江省,大庆市,肇源县','level'=>'3','pinyin'=>'zhaoyuan','code'=>'0459','zip_code'=>'166500','first'=>'Z','lng'=>'125.08456','lat'=>'45.52032']);
        $this->insert('{{%region}}',['id'=>'728','pid'=>'720','shortname'=>'林甸','name'=>'林甸县','merger_name'=>'中国,黑龙江省,大庆市,林甸县','level'=>'3','pinyin'=>'lindian','code'=>'0459','zip_code'=>'166300','first'=>'L','lng'=>'124.87564','lat'=>'47.18601']);
        $this->insert('{{%region}}',['id'=>'729','pid'=>'720','shortname'=>'杜尔伯特','name'=>'杜尔伯特蒙古族自治县','merger_name'=>'中国,黑龙江省,大庆市,杜尔伯特蒙古族自治县','level'=>'3','pinyin'=>'duerbote','code'=>'0459','zip_code'=>'166200','first'=>'D','lng'=>'124.44937','lat'=>'46.86507']);
        $this->insert('{{%region}}',['id'=>'730','pid'=>'655','shortname'=>'伊春','name'=>'伊春市','merger_name'=>'中国,黑龙江省,伊春市','level'=>'2','pinyin'=>'yichun','code'=>'0458','zip_code'=>'153000','first'=>'Y','lng'=>'128.899396','lat'=>'47.724775']);
        $this->insert('{{%region}}',['id'=>'731','pid'=>'730','shortname'=>'伊春','name'=>'伊春区','merger_name'=>'中国,黑龙江省,伊春市,伊春区','level'=>'3','pinyin'=>'yichun','code'=>'0458','zip_code'=>'153000','first'=>'Y','lng'=>'128.90752','lat'=>'47.728']);
        $this->insert('{{%region}}',['id'=>'732','pid'=>'730','shortname'=>'南岔','name'=>'南岔区','merger_name'=>'中国,黑龙江省,伊春市,南岔区','level'=>'3','pinyin'=>'nancha','code'=>'0458','zip_code'=>'153100','first'=>'N','lng'=>'129.28362','lat'=>'47.13897']);
        $this->insert('{{%region}}',['id'=>'733','pid'=>'730','shortname'=>'友好','name'=>'友好区','merger_name'=>'中国,黑龙江省,伊春市,友好区','level'=>'3','pinyin'=>'youhao','code'=>'0458','zip_code'=>'153031','first'=>'Y','lng'=>'128.84039','lat'=>'47.85371']);
        $this->insert('{{%region}}',['id'=>'734','pid'=>'730','shortname'=>'西林','name'=>'西林区','merger_name'=>'中国,黑龙江省,伊春市,西林区','level'=>'3','pinyin'=>'xilin','code'=>'0458','zip_code'=>'153025','first'=>'X','lng'=>'129.31201','lat'=>'47.48103']);
        $this->insert('{{%region}}',['id'=>'735','pid'=>'730','shortname'=>'翠峦','name'=>'翠峦区','merger_name'=>'中国,黑龙江省,伊春市,翠峦区','level'=>'3','pinyin'=>'cuiluan','code'=>'0458','zip_code'=>'153013','first'=>'C','lng'=>'128.66729','lat'=>'47.72503']);
        $this->insert('{{%region}}',['id'=>'736','pid'=>'730','shortname'=>'新青','name'=>'新青区','merger_name'=>'中国,黑龙江省,伊春市,新青区','level'=>'3','pinyin'=>'xinqing','code'=>'0458','zip_code'=>'153036','first'=>'X','lng'=>'129.53653','lat'=>'48.29067']);
        $this->insert('{{%region}}',['id'=>'737','pid'=>'730','shortname'=>'美溪','name'=>'美溪区','merger_name'=>'中国,黑龙江省,伊春市,美溪区','level'=>'3','pinyin'=>'meixi','code'=>'0458','zip_code'=>'153021','first'=>'M','lng'=>'129.13708','lat'=>'47.63513']);
        $this->insert('{{%region}}',['id'=>'738','pid'=>'730','shortname'=>'金山屯','name'=>'金山屯区','merger_name'=>'中国,黑龙江省,伊春市,金山屯区','level'=>'3','pinyin'=>'jinshantun','code'=>'0458','zip_code'=>'153026','first'=>'J','lng'=>'129.43768','lat'=>'47.41349']);
        $this->insert('{{%region}}',['id'=>'739','pid'=>'730','shortname'=>'五营','name'=>'五营区','merger_name'=>'中国,黑龙江省,伊春市,五营区','level'=>'3','pinyin'=>'wuying','code'=>'0458','zip_code'=>'153033','first'=>'W','lng'=>'129.24545','lat'=>'48.10791']);
        $this->insert('{{%region}}',['id'=>'740','pid'=>'730','shortname'=>'乌马河','name'=>'乌马河区','merger_name'=>'中国,黑龙江省,伊春市,乌马河区','level'=>'3','pinyin'=>'wumahe','code'=>'0458','zip_code'=>'153011','first'=>'W','lng'=>'128.79672','lat'=>'47.728']);
        $this->insert('{{%region}}',['id'=>'741','pid'=>'730','shortname'=>'汤旺河','name'=>'汤旺河区','merger_name'=>'中国,黑龙江省,伊春市,汤旺河区','level'=>'3','pinyin'=>'tangwanghe','code'=>'0458','zip_code'=>'153037','first'=>'T','lng'=>'129.57226','lat'=>'48.45182']);
        $this->insert('{{%region}}',['id'=>'742','pid'=>'730','shortname'=>'带岭','name'=>'带岭区','merger_name'=>'中国,黑龙江省,伊春市,带岭区','level'=>'3','pinyin'=>'dailing','code'=>'0458','zip_code'=>'153106','first'=>'D','lng'=>'129.02352','lat'=>'47.02553']);
        $this->insert('{{%region}}',['id'=>'743','pid'=>'730','shortname'=>'乌伊岭','name'=>'乌伊岭区','merger_name'=>'中国,黑龙江省,伊春市,乌伊岭区','level'=>'3','pinyin'=>'wuyiling','code'=>'0458','zip_code'=>'153038','first'=>'W','lng'=>'129.43981','lat'=>'48.59602']);
        $this->insert('{{%region}}',['id'=>'744','pid'=>'730','shortname'=>'红星','name'=>'红星区','merger_name'=>'中国,黑龙江省,伊春市,红星区','level'=>'3','pinyin'=>'hongxing','code'=>'0458','zip_code'=>'153035','first'=>'H','lng'=>'129.3887','lat'=>'48.23944']);
        $this->insert('{{%region}}',['id'=>'745','pid'=>'730','shortname'=>'上甘岭','name'=>'上甘岭区','merger_name'=>'中国,黑龙江省,伊春市,上甘岭区','level'=>'3','pinyin'=>'shangganling','code'=>'0458','zip_code'=>'153032','first'=>'S','lng'=>'129.02447','lat'=>'47.97522']);
        $this->insert('{{%region}}',['id'=>'746','pid'=>'730','shortname'=>'嘉荫','name'=>'嘉荫县','merger_name'=>'中国,黑龙江省,伊春市,嘉荫县','level'=>'3','pinyin'=>'jiayin','code'=>'0458','zip_code'=>'153200','first'=>'J','lng'=>'130.39825','lat'=>'48.8917']);
        $this->insert('{{%region}}',['id'=>'747','pid'=>'730','shortname'=>'铁力','name'=>'铁力市','merger_name'=>'中国,黑龙江省,伊春市,铁力市','level'=>'3','pinyin'=>'tieli','code'=>'0458','zip_code'=>'152500','first'=>'T','lng'=>'128.0317','lat'=>'46.98571']);
        $this->insert('{{%region}}',['id'=>'748','pid'=>'655','shortname'=>'佳木斯','name'=>'佳木斯市','merger_name'=>'中国,黑龙江省,佳木斯市','level'=>'2','pinyin'=>'jiamusi','code'=>'0454','zip_code'=>'154002','first'=>'J','lng'=>'130.361634','lat'=>'46.809606']);
        $this->insert('{{%region}}',['id'=>'749','pid'=>'748','shortname'=>'向阳','name'=>'向阳区','merger_name'=>'中国,黑龙江省,佳木斯市,向阳区','level'=>'3','pinyin'=>'xiangyang','code'=>'0454','zip_code'=>'154002','first'=>'X','lng'=>'130.36519','lat'=>'46.80778']);
        $this->insert('{{%region}}',['id'=>'750','pid'=>'748','shortname'=>'前进','name'=>'前进区','merger_name'=>'中国,黑龙江省,佳木斯市,前进区','level'=>'3','pinyin'=>'qianjin','code'=>'0454','zip_code'=>'154002','first'=>'Q','lng'=>'130.37497','lat'=>'46.81401']);
        $this->insert('{{%region}}',['id'=>'751','pid'=>'748','shortname'=>'东风','name'=>'东风区','merger_name'=>'中国,黑龙江省,佳木斯市,东风区','level'=>'3','pinyin'=>'dongfeng','code'=>'0454','zip_code'=>'154005','first'=>'D','lng'=>'130.40366','lat'=>'46.82257']);
        $this->insert('{{%region}}',['id'=>'752','pid'=>'748','shortname'=>'郊区','name'=>'郊区','merger_name'=>'中国,黑龙江省,佳木斯市,郊区','level'=>'3','pinyin'=>'jiaoqu','code'=>'0454','zip_code'=>'154004','first'=>'J','lng'=>'130.32731','lat'=>'46.80958']);
        $this->insert('{{%region}}',['id'=>'753','pid'=>'748','shortname'=>'桦南','name'=>'桦南县','merger_name'=>'中国,黑龙江省,佳木斯市,桦南县','level'=>'3','pinyin'=>'huanan','code'=>'0454','zip_code'=>'154400','first'=>NULL,'lng'=>'130.55361','lat'=>'46.23921']);
        $this->insert('{{%region}}',['id'=>'754','pid'=>'748','shortname'=>'桦川','name'=>'桦川县','merger_name'=>'中国,黑龙江省,佳木斯市,桦川县','level'=>'3','pinyin'=>'huachuan','code'=>'0454','zip_code'=>'154300','first'=>NULL,'lng'=>'130.71893','lat'=>'47.02297']);
        $this->insert('{{%region}}',['id'=>'755','pid'=>'748','shortname'=>'汤原','name'=>'汤原县','merger_name'=>'中国,黑龙江省,佳木斯市,汤原县','level'=>'3','pinyin'=>'tangyuan','code'=>'0454','zip_code'=>'154700','first'=>'T','lng'=>'129.90966','lat'=>'46.72755']);
        $this->insert('{{%region}}',['id'=>'756','pid'=>'748','shortname'=>'抚远','name'=>'抚远县','merger_name'=>'中国,黑龙江省,佳木斯市,抚远县','level'=>'3','pinyin'=>'fuyuan','code'=>'0454','zip_code'=>'156500','first'=>'F','lng'=>'134.29595','lat'=>'48.36794']);
        $this->insert('{{%region}}',['id'=>'757','pid'=>'748','shortname'=>'同江','name'=>'同江市','merger_name'=>'中国,黑龙江省,佳木斯市,同江市','level'=>'3','pinyin'=>'tongjiang','code'=>'0454','zip_code'=>'156400','first'=>'T','lng'=>'132.51095','lat'=>'47.64211']);
        $this->insert('{{%region}}',['id'=>'758','pid'=>'748','shortname'=>'富锦','name'=>'富锦市','merger_name'=>'中国,黑龙江省,佳木斯市,富锦市','level'=>'3','pinyin'=>'fujin','code'=>'0454','zip_code'=>'156100','first'=>'F','lng'=>'132.03707','lat'=>'47.25132']);
        $this->insert('{{%region}}',['id'=>'759','pid'=>'655','shortname'=>'七台河','name'=>'七台河市','merger_name'=>'中国,黑龙江省,七台河市','level'=>'2','pinyin'=>'qitaihe','code'=>'0464','zip_code'=>'154600','first'=>'Q','lng'=>'131.015584','lat'=>'45.771266']);
        $this->insert('{{%region}}',['id'=>'760','pid'=>'759','shortname'=>'新兴','name'=>'新兴区','merger_name'=>'中国,黑龙江省,七台河市,新兴区','level'=>'3','pinyin'=>'xinxing','code'=>'0464','zip_code'=>'154604','first'=>'X','lng'=>'130.93212','lat'=>'45.81624']);
        $this->insert('{{%region}}',['id'=>'761','pid'=>'759','shortname'=>'桃山','name'=>'桃山区','merger_name'=>'中国,黑龙江省,七台河市,桃山区','level'=>'3','pinyin'=>'taoshan','code'=>'0464','zip_code'=>'154600','first'=>'T','lng'=>'131.01786','lat'=>'45.76782']);
        $this->insert('{{%region}}',['id'=>'762','pid'=>'759','shortname'=>'茄子河','name'=>'茄子河区','merger_name'=>'中国,黑龙江省,七台河市,茄子河区','level'=>'3','pinyin'=>'qiezihe','code'=>'0464','zip_code'=>'154622','first'=>'Q','lng'=>'131.06807','lat'=>'45.78519']);
        $this->insert('{{%region}}',['id'=>'763','pid'=>'759','shortname'=>'勃利','name'=>'勃利县','merger_name'=>'中国,黑龙江省,七台河市,勃利县','level'=>'3','pinyin'=>'boli','code'=>'0464','zip_code'=>'154500','first'=>'B','lng'=>'130.59179','lat'=>'45.755']);
        $this->insert('{{%region}}',['id'=>'764','pid'=>'655','shortname'=>'牡丹江','name'=>'牡丹江市','merger_name'=>'中国,黑龙江省,牡丹江市','level'=>'2','pinyin'=>'mudanjiang','code'=>'0453','zip_code'=>'157000','first'=>'M','lng'=>'129.618602','lat'=>'44.582962']);
        $this->insert('{{%region}}',['id'=>'765','pid'=>'764','shortname'=>'东安','name'=>'东安区','merger_name'=>'中国,黑龙江省,牡丹江市,东安区','level'=>'3','pinyin'=>'dong\'an','code'=>'0453','zip_code'=>'157000','first'=>'D','lng'=>'129.62665','lat'=>'44.58133']);
        $this->insert('{{%region}}',['id'=>'766','pid'=>'764','shortname'=>'阳明','name'=>'阳明区','merger_name'=>'中国,黑龙江省,牡丹江市,阳明区','level'=>'3','pinyin'=>'yangming','code'=>'0453','zip_code'=>'157013','first'=>'Y','lng'=>'129.63547','lat'=>'44.59603']);
        $this->insert('{{%region}}',['id'=>'767','pid'=>'764','shortname'=>'爱民','name'=>'爱民区','merger_name'=>'中国,黑龙江省,牡丹江市,爱民区','level'=>'3','pinyin'=>'aimin','code'=>'0453','zip_code'=>'157009','first'=>'A','lng'=>'129.59077','lat'=>'44.59648']);
        $this->insert('{{%region}}',['id'=>'768','pid'=>'764','shortname'=>'西安','name'=>'西安区','merger_name'=>'中国,黑龙江省,牡丹江市,西安区','level'=>'3','pinyin'=>'xi\'an','code'=>'0453','zip_code'=>'157000','first'=>'X','lng'=>'129.61616','lat'=>'44.57766']);
        $this->insert('{{%region}}',['id'=>'769','pid'=>'764','shortname'=>'东宁','name'=>'东宁县','merger_name'=>'中国,黑龙江省,牡丹江市,东宁县','level'=>'3','pinyin'=>'dongning','code'=>'0453','zip_code'=>'157200','first'=>'D','lng'=>'131.12793','lat'=>'44.0661']);
        $this->insert('{{%region}}',['id'=>'770','pid'=>'764','shortname'=>'林口','name'=>'林口县','merger_name'=>'中国,黑龙江省,牡丹江市,林口县','level'=>'3','pinyin'=>'linkou','code'=>'0453','zip_code'=>'157600','first'=>'L','lng'=>'130.28393','lat'=>'45.27809']);
        $this->insert('{{%region}}',['id'=>'771','pid'=>'764','shortname'=>'绥芬河','name'=>'绥芬河市','merger_name'=>'中国,黑龙江省,牡丹江市,绥芬河市','level'=>'3','pinyin'=>'suifenhe','code'=>'0453','zip_code'=>'157300','first'=>'S','lng'=>'131.15139','lat'=>'44.41249']);
        $this->insert('{{%region}}',['id'=>'772','pid'=>'764','shortname'=>'海林','name'=>'海林市','merger_name'=>'中国,黑龙江省,牡丹江市,海林市','level'=>'3','pinyin'=>'hailin','code'=>'0453','zip_code'=>'157100','first'=>'H','lng'=>'129.38156','lat'=>'44.59']);
        $this->insert('{{%region}}',['id'=>'773','pid'=>'764','shortname'=>'宁安','name'=>'宁安市','merger_name'=>'中国,黑龙江省,牡丹江市,宁安市','level'=>'3','pinyin'=>'ning\'an','code'=>'0453','zip_code'=>'157400','first'=>'N','lng'=>'129.48303','lat'=>'44.34016']);
        $this->insert('{{%region}}',['id'=>'774','pid'=>'764','shortname'=>'穆棱','name'=>'穆棱市','merger_name'=>'中国,黑龙江省,牡丹江市,穆棱市','level'=>'3','pinyin'=>'muling','code'=>'0453','zip_code'=>'157500','first'=>'M','lng'=>'130.52465','lat'=>'44.919']);
        $this->insert('{{%region}}',['id'=>'775','pid'=>'655','shortname'=>'黑河','name'=>'黑河市','merger_name'=>'中国,黑龙江省,黑河市','level'=>'2','pinyin'=>'heihe','code'=>'0456','zip_code'=>'164300','first'=>'H','lng'=>'127.499023','lat'=>'50.249585']);
        $this->insert('{{%region}}',['id'=>'776','pid'=>'775','shortname'=>'爱辉','name'=>'爱辉区','merger_name'=>'中国,黑龙江省,黑河市,爱辉区','level'=>'3','pinyin'=>'aihui','code'=>'0456','zip_code'=>'164300','first'=>'A','lng'=>'127.50074','lat'=>'50.25202']);
        $this->insert('{{%region}}',['id'=>'777','pid'=>'775','shortname'=>'嫩江','name'=>'嫩江县','merger_name'=>'中国,黑龙江省,黑河市,嫩江县','level'=>'3','pinyin'=>'nenjiang','code'=>'0456','zip_code'=>'161400','first'=>'N','lng'=>'125.22607','lat'=>'49.17844']);
        $this->insert('{{%region}}',['id'=>'778','pid'=>'775','shortname'=>'逊克','name'=>'逊克县','merger_name'=>'中国,黑龙江省,黑河市,逊克县','level'=>'3','pinyin'=>'xunke','code'=>'0456','zip_code'=>'164400','first'=>'X','lng'=>'128.47882','lat'=>'49.57983']);
        $this->insert('{{%region}}',['id'=>'779','pid'=>'775','shortname'=>'孙吴','name'=>'孙吴县','merger_name'=>'中国,黑龙江省,黑河市,孙吴县','level'=>'3','pinyin'=>'sunwu','code'=>'0456','zip_code'=>'164200','first'=>'S','lng'=>'127.33599','lat'=>'49.42539']);
        $this->insert('{{%region}}',['id'=>'780','pid'=>'775','shortname'=>'北安','name'=>'北安市','merger_name'=>'中国,黑龙江省,黑河市,北安市','level'=>'3','pinyin'=>'bei\'an','code'=>'0456','zip_code'=>'164000','first'=>'B','lng'=>'126.48193','lat'=>'48.23872']);
        $this->insert('{{%region}}',['id'=>'781','pid'=>'775','shortname'=>'五大连池','name'=>'五大连池市','merger_name'=>'中国,黑龙江省,黑河市,五大连池市','level'=>'3','pinyin'=>'wudalianchi','code'=>'0456','zip_code'=>'164100','first'=>'W','lng'=>'126.20294','lat'=>'48.51507']);
        $this->insert('{{%region}}',['id'=>'782','pid'=>'655','shortname'=>'绥化','name'=>'绥化市','merger_name'=>'中国,黑龙江省,绥化市','level'=>'2','pinyin'=>'suihua','code'=>'0455','zip_code'=>'152000','first'=>'S','lng'=>'126.99293','lat'=>'46.637393']);
        $this->insert('{{%region}}',['id'=>'783','pid'=>'782','shortname'=>'北林','name'=>'北林区','merger_name'=>'中国,黑龙江省,绥化市,北林区','level'=>'3','pinyin'=>'beilin','code'=>'0455','zip_code'=>'152000','first'=>'B','lng'=>'126.98564','lat'=>'46.63735']);
        $this->insert('{{%region}}',['id'=>'784','pid'=>'782','shortname'=>'望奎','name'=>'望奎县','merger_name'=>'中国,黑龙江省,绥化市,望奎县','level'=>'3','pinyin'=>'wangkui','code'=>'0455','zip_code'=>'152100','first'=>'W','lng'=>'126.48187','lat'=>'46.83079']);
        $this->insert('{{%region}}',['id'=>'785','pid'=>'782','shortname'=>'兰西','name'=>'兰西县','merger_name'=>'中国,黑龙江省,绥化市,兰西县','level'=>'3','pinyin'=>'lanxi','code'=>'0455','zip_code'=>'151500','first'=>'L','lng'=>'126.28994','lat'=>'46.2525']);
        $this->insert('{{%region}}',['id'=>'786','pid'=>'782','shortname'=>'青冈','name'=>'青冈县','merger_name'=>'中国,黑龙江省,绥化市,青冈县','level'=>'3','pinyin'=>'qinggang','code'=>'0455','zip_code'=>'151600','first'=>'Q','lng'=>'126.11325','lat'=>'46.68534']);
        $this->insert('{{%region}}',['id'=>'787','pid'=>'782','shortname'=>'庆安','name'=>'庆安县','merger_name'=>'中国,黑龙江省,绥化市,庆安县','level'=>'3','pinyin'=>'qing\'an','code'=>'0455','zip_code'=>'152400','first'=>'Q','lng'=>'127.50753','lat'=>'46.88016']);
        $this->insert('{{%region}}',['id'=>'788','pid'=>'782','shortname'=>'明水','name'=>'明水县','merger_name'=>'中国,黑龙江省,绥化市,明水县','level'=>'3','pinyin'=>'mingshui','code'=>'0455','zip_code'=>'151700','first'=>'M','lng'=>'125.90594','lat'=>'47.17327']);
        $this->insert('{{%region}}',['id'=>'789','pid'=>'782','shortname'=>'绥棱','name'=>'绥棱县','merger_name'=>'中国,黑龙江省,绥化市,绥棱县','level'=>'3','pinyin'=>'suileng','code'=>'0455','zip_code'=>'152200','first'=>'S','lng'=>'127.11584','lat'=>'47.24267']);
        $this->insert('{{%region}}',['id'=>'790','pid'=>'782','shortname'=>'安达','name'=>'安达市','merger_name'=>'中国,黑龙江省,绥化市,安达市','level'=>'3','pinyin'=>'anda','code'=>'0455','zip_code'=>'151400','first'=>'A','lng'=>'125.34375','lat'=>'46.4177']);
        $this->insert('{{%region}}',['id'=>'791','pid'=>'782','shortname'=>'肇东','name'=>'肇东市','merger_name'=>'中国,黑龙江省,绥化市,肇东市','level'=>'3','pinyin'=>'zhaodong','code'=>'0455','zip_code'=>'151100','first'=>'Z','lng'=>'125.96243','lat'=>'46.05131']);
        $this->insert('{{%region}}',['id'=>'792','pid'=>'782','shortname'=>'海伦','name'=>'海伦市','merger_name'=>'中国,黑龙江省,绥化市,海伦市','level'=>'3','pinyin'=>'hailun','code'=>'0455','zip_code'=>'152300','first'=>'H','lng'=>'126.9682','lat'=>'47.46093']);
        $this->insert('{{%region}}',['id'=>'793','pid'=>'655','shortname'=>'大兴安岭','name'=>'大兴安岭地区','merger_name'=>'中国,黑龙江省,大兴安岭地区','level'=>'2','pinyin'=>'daxinganling','code'=>'0457','zip_code'=>'165000','first'=>'D','lng'=>'124.711526','lat'=>'52.335262']);
        $this->insert('{{%region}}',['id'=>'794','pid'=>'793','shortname'=>'加格达奇','name'=>'加格达奇区','merger_name'=>'中国,黑龙江省,大兴安岭地区,加格达奇区','level'=>'3','pinyin'=>'jiagedaqi','code'=>'0457','zip_code'=>'165000','first'=>'J','lng'=>'124.30954','lat'=>'51.98144']);
        $this->insert('{{%region}}',['id'=>'795','pid'=>'793','shortname'=>'新林','name'=>'新林区','merger_name'=>'中国,黑龙江省,大兴安岭地区,新林区','level'=>'3','pinyin'=>'xinlin','code'=>'0457','zip_code'=>'165000','first'=>'X','lng'=>'124.397983','lat'=>'51.67341']);
        $this->insert('{{%region}}',['id'=>'796','pid'=>'793','shortname'=>'松岭','name'=>'松岭区','merger_name'=>'中国,黑龙江省,大兴安岭地区,松岭区','level'=>'3','pinyin'=>'songling','code'=>'0457','zip_code'=>'165000','first'=>'S','lng'=>'124.189713','lat'=>'51.985453']);
        $this->insert('{{%region}}',['id'=>'797','pid'=>'793','shortname'=>'呼中','name'=>'呼中区','merger_name'=>'中国,黑龙江省,大兴安岭地区,呼中区','level'=>'3','pinyin'=>'huzhong','code'=>'0457','zip_code'=>'165000','first'=>'H','lng'=>'123.60009','lat'=>'52.03346']);
        $this->insert('{{%region}}',['id'=>'798','pid'=>'793','shortname'=>'呼玛','name'=>'呼玛县','merger_name'=>'中国,黑龙江省,大兴安岭地区,呼玛县','level'=>'3','pinyin'=>'huma','code'=>'0457','zip_code'=>'165100','first'=>'H','lng'=>'126.66174','lat'=>'51.73112']);
        $this->insert('{{%region}}',['id'=>'799','pid'=>'793','shortname'=>'塔河','name'=>'塔河县','merger_name'=>'中国,黑龙江省,大兴安岭地区,塔河县','level'=>'3','pinyin'=>'tahe','code'=>'0457','zip_code'=>'165200','first'=>'T','lng'=>'124.70999','lat'=>'52.33431']);
        $this->insert('{{%region}}',['id'=>'800','pid'=>'793','shortname'=>'漠河','name'=>'漠河县','merger_name'=>'中国,黑龙江省,大兴安岭地区,漠河县','level'=>'3','pinyin'=>'mohe','code'=>'0457','zip_code'=>'165300','first'=>'M','lng'=>'122.53759','lat'=>'52.97003']);
        $this->insert('{{%region}}',['id'=>'801','pid'=>'0','shortname'=>'上海','name'=>'上海市','merger_name'=>'中国,上海','level'=>'1','pinyin'=>'shanghai','code'=>'','zip_code'=>'','first'=>'S','lng'=>'121.472644','lat'=>'31.231706']);
        $this->insert('{{%region}}',['id'=>'802','pid'=>'801','shortname'=>'上海','name'=>'上海市','merger_name'=>'中国,上海,上海市','level'=>'2','pinyin'=>'shanghai','code'=>'021','zip_code'=>'200000','first'=>'S','lng'=>'121.472644','lat'=>'31.231706']);
        $this->insert('{{%region}}',['id'=>'803','pid'=>'802','shortname'=>'黄浦','name'=>'黄浦区','merger_name'=>'中国,上海,上海市,黄浦区','level'=>'3','pinyin'=>'huangpu','code'=>'021','zip_code'=>'200001','first'=>'H','lng'=>'121.49295','lat'=>'31.22337']);
        $this->insert('{{%region}}',['id'=>'804','pid'=>'802','shortname'=>'徐汇','name'=>'徐汇区','merger_name'=>'中国,上海,上海市,徐汇区','level'=>'3','pinyin'=>'xuhui','code'=>'021','zip_code'=>'200030','first'=>'X','lng'=>'121.43676','lat'=>'31.18831']);
        $this->insert('{{%region}}',['id'=>'805','pid'=>'802','shortname'=>'长宁','name'=>'长宁区','merger_name'=>'中国,上海,上海市,长宁区','level'=>'3','pinyin'=>'changning','code'=>'021','zip_code'=>'200050','first'=>'C','lng'=>'121.42462','lat'=>'31.22036']);
        $this->insert('{{%region}}',['id'=>'806','pid'=>'802','shortname'=>'静安','name'=>'静安区','merger_name'=>'中国,上海,上海市,静安区','level'=>'3','pinyin'=>'jing\'an','code'=>'021','zip_code'=>'200040','first'=>'J','lng'=>'121.4444','lat'=>'31.22884']);
        $this->insert('{{%region}}',['id'=>'807','pid'=>'802','shortname'=>'普陀','name'=>'普陀区','merger_name'=>'中国,上海,上海市,普陀区','level'=>'3','pinyin'=>'putuo','code'=>'021','zip_code'=>'200333','first'=>'P','lng'=>'121.39703','lat'=>'31.24951']);
        $this->insert('{{%region}}',['id'=>'808','pid'=>'802','shortname'=>'闸北','name'=>'闸北区','merger_name'=>'中国,上海,上海市,闸北区','level'=>'3','pinyin'=>'zhabei','code'=>'021','zip_code'=>'200070','first'=>'Z','lng'=>'121.44636','lat'=>'31.28075']);
        $this->insert('{{%region}}',['id'=>'809','pid'=>'802','shortname'=>'虹口','name'=>'虹口区','merger_name'=>'中国,上海,上海市,虹口区','level'=>'3','pinyin'=>'hongkou','code'=>'021','zip_code'=>'200086','first'=>'H','lng'=>'121.48162','lat'=>'31.27788']);
        $this->insert('{{%region}}',['id'=>'810','pid'=>'802','shortname'=>'杨浦','name'=>'杨浦区','merger_name'=>'中国,上海,上海市,杨浦区','level'=>'3','pinyin'=>'yangpu','code'=>'021','zip_code'=>'200082','first'=>'Y','lng'=>'121.526','lat'=>'31.2595']);
        $this->insert('{{%region}}',['id'=>'811','pid'=>'802','shortname'=>'闵行','name'=>'闵行区','merger_name'=>'中国,上海,上海市,闵行区','level'=>'3','pinyin'=>'minhang','code'=>'021','zip_code'=>'201100','first'=>NULL,'lng'=>'121.38162','lat'=>'31.11246']);
        $this->insert('{{%region}}',['id'=>'812','pid'=>'802','shortname'=>'宝山','name'=>'宝山区','merger_name'=>'中国,上海,上海市,宝山区','level'=>'3','pinyin'=>'baoshan','code'=>'021','zip_code'=>'201900','first'=>'B','lng'=>'121.4891','lat'=>'31.4045']);
        $this->insert('{{%region}}',['id'=>'813','pid'=>'802','shortname'=>'嘉定','name'=>'嘉定区','merger_name'=>'中国,上海,上海市,嘉定区','level'=>'3','pinyin'=>'jiading','code'=>'021','zip_code'=>'201800','first'=>'J','lng'=>'121.2655','lat'=>'31.37473']);
        $this->insert('{{%region}}',['id'=>'814','pid'=>'802','shortname'=>'浦东','name'=>'浦东新区','merger_name'=>'中国,上海,上海市,浦东新区','level'=>'3','pinyin'=>'pudong','code'=>'021','zip_code'=>'200135','first'=>'P','lng'=>'121.5447','lat'=>'31.22249']);
        $this->insert('{{%region}}',['id'=>'815','pid'=>'802','shortname'=>'金山','name'=>'金山区','merger_name'=>'中国,上海,上海市,金山区','level'=>'3','pinyin'=>'jinshan','code'=>'021','zip_code'=>'200540','first'=>'J','lng'=>'121.34164','lat'=>'30.74163']);
        $this->insert('{{%region}}',['id'=>'816','pid'=>'802','shortname'=>'松江','name'=>'松江区','merger_name'=>'中国,上海,上海市,松江区','level'=>'3','pinyin'=>'songjiang','code'=>'021','zip_code'=>'201600','first'=>'S','lng'=>'121.22879','lat'=>'31.03222']);
        $this->insert('{{%region}}',['id'=>'817','pid'=>'802','shortname'=>'青浦','name'=>'青浦区','merger_name'=>'中国,上海,上海市,青浦区','level'=>'3','pinyin'=>'qingpu','code'=>'021','zip_code'=>'201700','first'=>'Q','lng'=>'121.12417','lat'=>'31.14974']);
        $this->insert('{{%region}}',['id'=>'818','pid'=>'802','shortname'=>'奉贤','name'=>'奉贤区','merger_name'=>'中国,上海,上海市,奉贤区','level'=>'3','pinyin'=>'fengxian','code'=>'021','zip_code'=>'201400','first'=>'F','lng'=>'121.47412','lat'=>'30.9179']);
        $this->insert('{{%region}}',['id'=>'819','pid'=>'802','shortname'=>'崇明','name'=>'崇明县','merger_name'=>'中国,上海,上海市,崇明县','level'=>'3','pinyin'=>'chongming','code'=>'021','zip_code'=>'202150','first'=>'C','lng'=>'121.39758','lat'=>'31.62278']);
        $this->insert('{{%region}}',['id'=>'820','pid'=>'0','shortname'=>'江苏','name'=>'江苏省','merger_name'=>'中国,江苏省','level'=>'1','pinyin'=>'jiangsu','code'=>'','zip_code'=>'','first'=>'J','lng'=>'118.767413','lat'=>'32.041544']);
        $this->insert('{{%region}}',['id'=>'821','pid'=>'820','shortname'=>'南京','name'=>'南京市','merger_name'=>'中国,江苏省,南京市','level'=>'2','pinyin'=>'nanjing','code'=>'025','zip_code'=>'210008','first'=>'N','lng'=>'118.767413','lat'=>'32.041544']);
        $this->insert('{{%region}}',['id'=>'822','pid'=>'821','shortname'=>'玄武','name'=>'玄武区','merger_name'=>'中国,江苏省,南京市,玄武区','level'=>'3','pinyin'=>'xuanwu','code'=>'025','zip_code'=>'210018','first'=>'X','lng'=>'118.79772','lat'=>'32.04856']);
        $this->insert('{{%region}}',['id'=>'823','pid'=>'821','shortname'=>'秦淮','name'=>'秦淮区','merger_name'=>'中国,江苏省,南京市,秦淮区','level'=>'3','pinyin'=>'qinhuai','code'=>'025','zip_code'=>'210001','first'=>'Q','lng'=>'118.79815','lat'=>'32.01112']);
        $this->insert('{{%region}}',['id'=>'824','pid'=>'821','shortname'=>'建邺','name'=>'建邺区','merger_name'=>'中国,江苏省,南京市,建邺区','level'=>'3','pinyin'=>'jianye','code'=>'025','zip_code'=>'210004','first'=>'J','lng'=>'118.76641','lat'=>'32.03096']);
        $this->insert('{{%region}}',['id'=>'825','pid'=>'821','shortname'=>'鼓楼','name'=>'鼓楼区','merger_name'=>'中国,江苏省,南京市,鼓楼区','level'=>'3','pinyin'=>'gulou','code'=>'025','zip_code'=>'210009','first'=>'G','lng'=>'118.76974','lat'=>'32.06632']);
        $this->insert('{{%region}}',['id'=>'826','pid'=>'821','shortname'=>'浦口','name'=>'浦口区','merger_name'=>'中国,江苏省,南京市,浦口区','level'=>'3','pinyin'=>'pukou','code'=>'025','zip_code'=>'211800','first'=>'P','lng'=>'118.62802','lat'=>'32.05881']);
        $this->insert('{{%region}}',['id'=>'827','pid'=>'821','shortname'=>'栖霞','name'=>'栖霞区','merger_name'=>'中国,江苏省,南京市,栖霞区','level'=>'3','pinyin'=>'qixia','code'=>'025','zip_code'=>'210046','first'=>'Q','lng'=>'118.88064','lat'=>'32.11352']);
        $this->insert('{{%region}}',['id'=>'828','pid'=>'821','shortname'=>'雨花台','name'=>'雨花台区','merger_name'=>'中国,江苏省,南京市,雨花台区','level'=>'3','pinyin'=>'yuhuatai','code'=>'025','zip_code'=>'210012','first'=>'Y','lng'=>'118.7799','lat'=>'31.99202']);
        $this->insert('{{%region}}',['id'=>'829','pid'=>'821','shortname'=>'江宁','name'=>'江宁区','merger_name'=>'中国,江苏省,南京市,江宁区','level'=>'3','pinyin'=>'jiangning','code'=>'025','zip_code'=>'211100','first'=>'J','lng'=>'118.8399','lat'=>'31.95263']);
        $this->insert('{{%region}}',['id'=>'830','pid'=>'821','shortname'=>'六合','name'=>'六合区','merger_name'=>'中国,江苏省,南京市,六合区','level'=>'3','pinyin'=>'luhe','code'=>'025','zip_code'=>'211500','first'=>'L','lng'=>'118.8413','lat'=>'32.34222']);
        $this->insert('{{%region}}',['id'=>'831','pid'=>'821','shortname'=>'溧水','name'=>'溧水区','merger_name'=>'中国,江苏省,南京市,溧水区','level'=>'3','pinyin'=>'lishui','code'=>'025','zip_code'=>'211200','first'=>NULL,'lng'=>'119.028732','lat'=>'31.653061']);
        $this->insert('{{%region}}',['id'=>'832','pid'=>'821','shortname'=>'高淳','name'=>'高淳区','merger_name'=>'中国,江苏省,南京市,高淳区','level'=>'3','pinyin'=>'gaochun','code'=>'025','zip_code'=>'211300','first'=>'G','lng'=>'118.87589','lat'=>'31.327132']);
        $this->insert('{{%region}}',['id'=>'833','pid'=>'820','shortname'=>'无锡','name'=>'无锡市','merger_name'=>'中国,江苏省,无锡市','level'=>'2','pinyin'=>'wuxi','code'=>'0510','zip_code'=>'214000','first'=>'W','lng'=>'120.301663','lat'=>'31.574729']);
        $this->insert('{{%region}}',['id'=>'834','pid'=>'833','shortname'=>'崇安','name'=>'崇安区','merger_name'=>'中国,江苏省,无锡市,崇安区','level'=>'3','pinyin'=>'chong\'an','code'=>'0510','zip_code'=>'214001','first'=>'C','lng'=>'120.29975','lat'=>'31.58002']);
        $this->insert('{{%region}}',['id'=>'835','pid'=>'833','shortname'=>'南长','name'=>'南长区','merger_name'=>'中国,江苏省,无锡市,南长区','level'=>'3','pinyin'=>'nanchang','code'=>'0510','zip_code'=>'214021','first'=>'N','lng'=>'120.30873','lat'=>'31.56359']);
        $this->insert('{{%region}}',['id'=>'836','pid'=>'833','shortname'=>'北塘','name'=>'北塘区','merger_name'=>'中国,江苏省,无锡市,北塘区','level'=>'3','pinyin'=>'beitang','code'=>'0510','zip_code'=>'214044','first'=>'B','lng'=>'120.29405','lat'=>'31.60592']);
        $this->insert('{{%region}}',['id'=>'837','pid'=>'833','shortname'=>'锡山','name'=>'锡山区','merger_name'=>'中国,江苏省,无锡市,锡山区','level'=>'3','pinyin'=>'xishan','code'=>'0510','zip_code'=>'214101','first'=>'X','lng'=>'120.35699','lat'=>'31.5886']);
        $this->insert('{{%region}}',['id'=>'838','pid'=>'833','shortname'=>'惠山','name'=>'惠山区','merger_name'=>'中国,江苏省,无锡市,惠山区','level'=>'3','pinyin'=>'huishan','code'=>'0510','zip_code'=>'214174','first'=>'H','lng'=>'120.29849','lat'=>'31.68088']);
        $this->insert('{{%region}}',['id'=>'839','pid'=>'833','shortname'=>'滨湖','name'=>'滨湖区','merger_name'=>'中国,江苏省,无锡市,滨湖区','level'=>'3','pinyin'=>'binhu','code'=>'0510','zip_code'=>'214123','first'=>'B','lng'=>'120.29461','lat'=>'31.52162']);
        $this->insert('{{%region}}',['id'=>'840','pid'=>'833','shortname'=>'江阴','name'=>'江阴市','merger_name'=>'中国,江苏省,无锡市,江阴市','level'=>'3','pinyin'=>'jiangyin','code'=>'0510','zip_code'=>'214431','first'=>'J','lng'=>'120.2853','lat'=>'31.91996']);
        $this->insert('{{%region}}',['id'=>'841','pid'=>'833','shortname'=>'宜兴','name'=>'宜兴市','merger_name'=>'中国,江苏省,无锡市,宜兴市','level'=>'3','pinyin'=>'yixing','code'=>'0510','zip_code'=>'214200','first'=>'Y','lng'=>'119.82357','lat'=>'31.33978']);
        $this->insert('{{%region}}',['id'=>'842','pid'=>'820','shortname'=>'徐州','name'=>'徐州市','merger_name'=>'中国,江苏省,徐州市','level'=>'2','pinyin'=>'xuzhou','code'=>'0516','zip_code'=>'221003','first'=>'X','lng'=>'117.184811','lat'=>'34.261792']);
        $this->insert('{{%region}}',['id'=>'843','pid'=>'842','shortname'=>'鼓楼','name'=>'鼓楼区','merger_name'=>'中国,江苏省,徐州市,鼓楼区','level'=>'3','pinyin'=>'gulou','code'=>'0516','zip_code'=>'221005','first'=>'G','lng'=>'117.18559','lat'=>'34.28851']);
        $this->insert('{{%region}}',['id'=>'844','pid'=>'842','shortname'=>'云龙','name'=>'云龙区','merger_name'=>'中国,江苏省,徐州市,云龙区','level'=>'3','pinyin'=>'yunlong','code'=>'0516','zip_code'=>'221007','first'=>'Y','lng'=>'117.23053','lat'=>'34.24895']);
        $this->insert('{{%region}}',['id'=>'845','pid'=>'842','shortname'=>'贾汪','name'=>'贾汪区','merger_name'=>'中国,江苏省,徐州市,贾汪区','level'=>'3','pinyin'=>'jiawang','code'=>'0516','zip_code'=>'221003','first'=>'J','lng'=>'117.45346','lat'=>'34.44264']);
        $this->insert('{{%region}}',['id'=>'846','pid'=>'842','shortname'=>'泉山','name'=>'泉山区','merger_name'=>'中国,江苏省,徐州市,泉山区','level'=>'3','pinyin'=>'quanshan','code'=>'0516','zip_code'=>'221006','first'=>'Q','lng'=>'117.19378','lat'=>'34.24418']);
        $this->insert('{{%region}}',['id'=>'847','pid'=>'842','shortname'=>'铜山','name'=>'铜山区','merger_name'=>'中国,江苏省,徐州市,铜山区','level'=>'3','pinyin'=>'tongshan','code'=>'0516','zip_code'=>'221106','first'=>'T','lng'=>'117.183894','lat'=>'34.19288']);
        $this->insert('{{%region}}',['id'=>'848','pid'=>'842','shortname'=>'丰县','name'=>'丰县','merger_name'=>'中国,江苏省,徐州市,丰县','level'=>'3','pinyin'=>'fengxian','code'=>'0516','zip_code'=>'221700','first'=>'F','lng'=>'116.59957','lat'=>'34.69972']);
        $this->insert('{{%region}}',['id'=>'849','pid'=>'842','shortname'=>'沛县','name'=>'沛县','merger_name'=>'中国,江苏省,徐州市,沛县','level'=>'3','pinyin'=>'peixian','code'=>'0516','zip_code'=>'221600','first'=>'P','lng'=>'116.93743','lat'=>'34.72163']);
        $this->insert('{{%region}}',['id'=>'850','pid'=>'842','shortname'=>'睢宁','name'=>'睢宁县','merger_name'=>'中国,江苏省,徐州市,睢宁县','level'=>'3','pinyin'=>'suining','code'=>'0516','zip_code'=>'221200','first'=>NULL,'lng'=>'117.94104','lat'=>'33.91269']);
        $this->insert('{{%region}}',['id'=>'851','pid'=>'842','shortname'=>'新沂','name'=>'新沂市','merger_name'=>'中国,江苏省,徐州市,新沂市','level'=>'3','pinyin'=>'xinyi','code'=>'0516','zip_code'=>'221400','first'=>'X','lng'=>'118.35452','lat'=>'34.36942']);
        $this->insert('{{%region}}',['id'=>'852','pid'=>'842','shortname'=>'邳州','name'=>'邳州市','merger_name'=>'中国,江苏省,徐州市,邳州市','level'=>'3','pinyin'=>'pizhou','code'=>'0516','zip_code'=>'221300','first'=>NULL,'lng'=>'117.95858','lat'=>'34.33329']);
        $this->insert('{{%region}}',['id'=>'853','pid'=>'820','shortname'=>'常州','name'=>'常州市','merger_name'=>'中国,江苏省,常州市','level'=>'2','pinyin'=>'changzhou','code'=>'0519','zip_code'=>'213000','first'=>'C','lng'=>'119.946973','lat'=>'31.772752']);
        $this->insert('{{%region}}',['id'=>'854','pid'=>'853','shortname'=>'天宁','name'=>'天宁区','merger_name'=>'中国,江苏省,常州市,天宁区','level'=>'3','pinyin'=>'tianning','code'=>'0519','zip_code'=>'213000','first'=>'T','lng'=>'119.95132','lat'=>'31.75211']);
        $this->insert('{{%region}}',['id'=>'855','pid'=>'853','shortname'=>'钟楼','name'=>'钟楼区','merger_name'=>'中国,江苏省,常州市,钟楼区','level'=>'3','pinyin'=>'zhonglou','code'=>'0519','zip_code'=>'213023','first'=>'Z','lng'=>'119.90178','lat'=>'31.80221']);
        $this->insert('{{%region}}',['id'=>'856','pid'=>'853','shortname'=>'戚墅堰','name'=>'戚墅堰区','merger_name'=>'中国,江苏省,常州市,戚墅堰区','level'=>'3','pinyin'=>'qishuyan','code'=>'0519','zip_code'=>'213025','first'=>'Q','lng'=>'120.06106','lat'=>'31.71956']);
        $this->insert('{{%region}}',['id'=>'857','pid'=>'853','shortname'=>'新北','name'=>'新北区','merger_name'=>'中国,江苏省,常州市,新北区','level'=>'3','pinyin'=>'xinbei','code'=>'0519','zip_code'=>'213022','first'=>'X','lng'=>'119.97131','lat'=>'31.83046']);
        $this->insert('{{%region}}',['id'=>'858','pid'=>'853','shortname'=>'武进','name'=>'武进区','merger_name'=>'中国,江苏省,常州市,武进区','level'=>'3','pinyin'=>'wujin','code'=>'0519','zip_code'=>'213100','first'=>'W','lng'=>'119.94244','lat'=>'31.70086']);
        $this->insert('{{%region}}',['id'=>'859','pid'=>'853','shortname'=>'溧阳','name'=>'溧阳市','merger_name'=>'中国,江苏省,常州市,溧阳市','level'=>'3','pinyin'=>'liyang','code'=>'0519','zip_code'=>'213300','first'=>NULL,'lng'=>'119.4837','lat'=>'31.41538']);
        $this->insert('{{%region}}',['id'=>'860','pid'=>'853','shortname'=>'金坛','name'=>'金坛市','merger_name'=>'中国,江苏省,常州市,金坛市','level'=>'3','pinyin'=>'jintan','code'=>'0519','zip_code'=>'213200','first'=>'J','lng'=>'119.57757','lat'=>'31.74043']);
        $this->insert('{{%region}}',['id'=>'861','pid'=>'820','shortname'=>'苏州','name'=>'苏州市','merger_name'=>'中国,江苏省,苏州市','level'=>'2','pinyin'=>'suzhou','code'=>'0512','zip_code'=>'215002','first'=>'S','lng'=>'120.619585','lat'=>'31.299379']);
        $this->insert('{{%region}}',['id'=>'862','pid'=>'861','shortname'=>'虎丘','name'=>'虎丘区','merger_name'=>'中国,江苏省,苏州市,虎丘区','level'=>'3','pinyin'=>'huqiu','code'=>'0512','zip_code'=>'215004','first'=>'H','lng'=>'120.57345','lat'=>'31.2953']);
        $this->insert('{{%region}}',['id'=>'863','pid'=>'861','shortname'=>'吴中','name'=>'吴中区','merger_name'=>'中国,江苏省,苏州市,吴中区','level'=>'3','pinyin'=>'wuzhong','code'=>'0512','zip_code'=>'215128','first'=>'W','lng'=>'120.63211','lat'=>'31.26226']);
        $this->insert('{{%region}}',['id'=>'864','pid'=>'861','shortname'=>'相城','name'=>'相城区','merger_name'=>'中国,江苏省,苏州市,相城区','level'=>'3','pinyin'=>'xiangcheng','code'=>'0512','zip_code'=>'215131','first'=>'X','lng'=>'120.64239','lat'=>'31.36889']);
        $this->insert('{{%region}}',['id'=>'865','pid'=>'861','shortname'=>'姑苏','name'=>'姑苏区','merger_name'=>'中国,江苏省,苏州市,姑苏区','level'=>'3','pinyin'=>'gusu','code'=>'0512','zip_code'=>'215031','first'=>'G','lng'=>'120.619585','lat'=>'31.299379']);
        $this->insert('{{%region}}',['id'=>'866','pid'=>'861','shortname'=>'吴江','name'=>'吴江区','merger_name'=>'中国,江苏省,苏州市,吴江区','level'=>'3','pinyin'=>'wujiang','code'=>'0512','zip_code'=>'215200','first'=>'W','lng'=>'120.638317','lat'=>'31.159815']);
        $this->insert('{{%region}}',['id'=>'867','pid'=>'861','shortname'=>'常熟','name'=>'常熟市','merger_name'=>'中国,江苏省,苏州市,常熟市','level'=>'3','pinyin'=>'changshu','code'=>'0512','zip_code'=>'215500','first'=>'C','lng'=>'120.75225','lat'=>'31.65374']);
        $this->insert('{{%region}}',['id'=>'868','pid'=>'861','shortname'=>'张家港','name'=>'张家港市','merger_name'=>'中国,江苏省,苏州市,张家港市','level'=>'3','pinyin'=>'zhangjiagang','code'=>'0512','zip_code'=>'215600','first'=>'Z','lng'=>'120.55538','lat'=>'31.87532']);
        $this->insert('{{%region}}',['id'=>'869','pid'=>'861','shortname'=>'昆山','name'=>'昆山市','merger_name'=>'中国,江苏省,苏州市,昆山市','level'=>'3','pinyin'=>'kunshan','code'=>'0512','zip_code'=>'215300','first'=>'K','lng'=>'120.98074','lat'=>'31.38464']);
        $this->insert('{{%region}}',['id'=>'870','pid'=>'861','shortname'=>'太仓','name'=>'太仓市','merger_name'=>'中国,江苏省,苏州市,太仓市','level'=>'3','pinyin'=>'taicang','code'=>'0512','zip_code'=>'215400','first'=>'T','lng'=>'121.10891','lat'=>'31.4497']);
        $this->insert('{{%region}}',['id'=>'871','pid'=>'820','shortname'=>'南通','name'=>'南通市','merger_name'=>'中国,江苏省,南通市','level'=>'2','pinyin'=>'nantong','code'=>'0513','zip_code'=>'226001','first'=>'N','lng'=>'120.864608','lat'=>'32.016212']);
        $this->insert('{{%region}}',['id'=>'872','pid'=>'871','shortname'=>'崇川','name'=>'崇川区','merger_name'=>'中国,江苏省,南通市,崇川区','level'=>'3','pinyin'=>'chongchuan','code'=>'0513','zip_code'=>'226001','first'=>'C','lng'=>'120.8573','lat'=>'32.0098']);
        $this->insert('{{%region}}',['id'=>'873','pid'=>'871','shortname'=>'港闸','name'=>'港闸区','merger_name'=>'中国,江苏省,南通市,港闸区','level'=>'3','pinyin'=>'gangzha','code'=>'0513','zip_code'=>'226001','first'=>'G','lng'=>'120.81778','lat'=>'32.03163']);
        $this->insert('{{%region}}',['id'=>'874','pid'=>'871','shortname'=>'通州','name'=>'通州区','merger_name'=>'中国,江苏省,南通市,通州区','level'=>'3','pinyin'=>'tongzhou','code'=>'0513','zip_code'=>'226300','first'=>'T','lng'=>'121.07293','lat'=>'32.0676']);
        $this->insert('{{%region}}',['id'=>'875','pid'=>'871','shortname'=>'海安','name'=>'海安县','merger_name'=>'中国,江苏省,南通市,海安县','level'=>'3','pinyin'=>'hai\'an','code'=>'0513','zip_code'=>'226600','first'=>'H','lng'=>'120.45852','lat'=>'32.54514']);
        $this->insert('{{%region}}',['id'=>'876','pid'=>'871','shortname'=>'如东','name'=>'如东县','merger_name'=>'中国,江苏省,南通市,如东县','level'=>'3','pinyin'=>'rudong','code'=>'0513','zip_code'=>'226400','first'=>'R','lng'=>'121.18942','lat'=>'32.31439']);
        $this->insert('{{%region}}',['id'=>'877','pid'=>'871','shortname'=>'启东','name'=>'启东市','merger_name'=>'中国,江苏省,南通市,启东市','level'=>'3','pinyin'=>'qidong','code'=>'0513','zip_code'=>'226200','first'=>'Q','lng'=>'121.65985','lat'=>'31.81083']);
        $this->insert('{{%region}}',['id'=>'878','pid'=>'871','shortname'=>'如皋','name'=>'如皋市','merger_name'=>'中国,江苏省,南通市,如皋市','level'=>'3','pinyin'=>'rugao','code'=>'0513','zip_code'=>'226500','first'=>'R','lng'=>'120.55969','lat'=>'32.37597']);
        $this->insert('{{%region}}',['id'=>'879','pid'=>'871','shortname'=>'海门','name'=>'海门市','merger_name'=>'中国,江苏省,南通市,海门市','level'=>'3','pinyin'=>'haimen','code'=>'0513','zip_code'=>'226100','first'=>'H','lng'=>'121.16995','lat'=>'31.89422']);
        $this->insert('{{%region}}',['id'=>'880','pid'=>'820','shortname'=>'连云港','name'=>'连云港市','merger_name'=>'中国,江苏省,连云港市','level'=>'2','pinyin'=>'lianyungang','code'=>'0518','zip_code'=>'222002','first'=>'L','lng'=>'119.178821','lat'=>'34.600018']);
        $this->insert('{{%region}}',['id'=>'881','pid'=>'880','shortname'=>'连云','name'=>'连云区','merger_name'=>'中国,江苏省,连云港市,连云区','level'=>'3','pinyin'=>'lianyun','code'=>'0518','zip_code'=>'222042','first'=>'L','lng'=>'119.37304','lat'=>'34.75293']);
        $this->insert('{{%region}}',['id'=>'882','pid'=>'880','shortname'=>'海州','name'=>'海州区','merger_name'=>'中国,江苏省,连云港市,海州区','level'=>'3','pinyin'=>'haizhou','code'=>'0518','zip_code'=>'222003','first'=>'H','lng'=>'119.13128','lat'=>'34.56986']);
        $this->insert('{{%region}}',['id'=>'883','pid'=>'880','shortname'=>'赣榆','name'=>'赣榆区','merger_name'=>'中国,江苏省,连云港市,赣榆区','level'=>'3','pinyin'=>'ganyu','code'=>'0518','zip_code'=>'222100','first'=>'G','lng'=>'119.128774','lat'=>'34.839154']);
        $this->insert('{{%region}}',['id'=>'884','pid'=>'880','shortname'=>'东海','name'=>'东海县','merger_name'=>'中国,江苏省,连云港市,东海县','level'=>'3','pinyin'=>'donghai','code'=>'0518','zip_code'=>'222300','first'=>'D','lng'=>'118.77145','lat'=>'34.54215']);
        $this->insert('{{%region}}',['id'=>'885','pid'=>'880','shortname'=>'灌云','name'=>'灌云县','merger_name'=>'中国,江苏省,连云港市,灌云县','level'=>'3','pinyin'=>'guanyun','code'=>'0518','zip_code'=>'222200','first'=>'G','lng'=>'119.23925','lat'=>'34.28391']);
        $this->insert('{{%region}}',['id'=>'886','pid'=>'880','shortname'=>'灌南','name'=>'灌南县','merger_name'=>'中国,江苏省,连云港市,灌南县','level'=>'3','pinyin'=>'guannan','code'=>'0518','zip_code'=>'222500','first'=>'G','lng'=>'119.35632','lat'=>'34.09']);
        $this->insert('{{%region}}',['id'=>'887','pid'=>'820','shortname'=>'淮安','name'=>'淮安市','merger_name'=>'中国,江苏省,淮安市','level'=>'2','pinyin'=>'huai\'an','code'=>'0517','zip_code'=>'223001','first'=>'H','lng'=>'119.021265','lat'=>'33.597506']);
        $this->insert('{{%region}}',['id'=>'888','pid'=>'887','shortname'=>'清河','name'=>'清河区','merger_name'=>'中国,江苏省,淮安市,清河区','level'=>'3','pinyin'=>'qinghe','code'=>'0517','zip_code'=>'223001','first'=>'Q','lng'=>'119.00778','lat'=>'33.59949']);
        $this->insert('{{%region}}',['id'=>'889','pid'=>'887','shortname'=>'淮安','name'=>'淮安区','merger_name'=>'中国,江苏省,淮安市,淮安区','level'=>'3','pinyin'=>'huai\'an','code'=>'0517','zip_code'=>'223200','first'=>'H','lng'=>'119.021265','lat'=>'33.597506']);
        $this->insert('{{%region}}',['id'=>'890','pid'=>'887','shortname'=>'淮阴','name'=>'淮阴区','merger_name'=>'中国,江苏省,淮安市,淮阴区','level'=>'3','pinyin'=>'huaiyin','code'=>'0517','zip_code'=>'223300','first'=>'H','lng'=>'119.03485','lat'=>'33.63171']);
        $this->insert('{{%region}}',['id'=>'891','pid'=>'887','shortname'=>'清浦','name'=>'清浦区','merger_name'=>'中国,江苏省,淮安市,清浦区','level'=>'3','pinyin'=>'qingpu','code'=>'0517','zip_code'=>'223002','first'=>'Q','lng'=>'119.02648','lat'=>'33.55232']);
        $this->insert('{{%region}}',['id'=>'892','pid'=>'887','shortname'=>'涟水','name'=>'涟水县','merger_name'=>'中国,江苏省,淮安市,涟水县','level'=>'3','pinyin'=>'lianshui','code'=>'0517','zip_code'=>'223400','first'=>'L','lng'=>'119.26083','lat'=>'33.78094']);
        $this->insert('{{%region}}',['id'=>'893','pid'=>'887','shortname'=>'洪泽','name'=>'洪泽县','merger_name'=>'中国,江苏省,淮安市,洪泽县','level'=>'3','pinyin'=>'hongze','code'=>'0517','zip_code'=>'223100','first'=>'H','lng'=>'118.87344','lat'=>'33.29429']);
        $this->insert('{{%region}}',['id'=>'894','pid'=>'887','shortname'=>'盱眙','name'=>'盱眙县','merger_name'=>'中国,江苏省,淮安市,盱眙县','level'=>'3','pinyin'=>'xuyi','code'=>'0517','zip_code'=>'211700','first'=>NULL,'lng'=>'118.54495','lat'=>'33.01086']);
        $this->insert('{{%region}}',['id'=>'895','pid'=>'887','shortname'=>'金湖','name'=>'金湖县','merger_name'=>'中国,江苏省,淮安市,金湖县','level'=>'3','pinyin'=>'jinhu','code'=>'0517','zip_code'=>'211600','first'=>'J','lng'=>'119.02307','lat'=>'33.02219']);
        $this->insert('{{%region}}',['id'=>'896','pid'=>'820','shortname'=>'盐城','name'=>'盐城市','merger_name'=>'中国,江苏省,盐城市','level'=>'2','pinyin'=>'yancheng','code'=>'0515','zip_code'=>'224005','first'=>'Y','lng'=>'120.139998','lat'=>'33.377631']);
        $this->insert('{{%region}}',['id'=>'897','pid'=>'896','shortname'=>'亭湖','name'=>'亭湖区','merger_name'=>'中国,江苏省,盐城市,亭湖区','level'=>'3','pinyin'=>'tinghu','code'=>'0515','zip_code'=>'224005','first'=>'T','lng'=>'120.16583','lat'=>'33.37825']);
        $this->insert('{{%region}}',['id'=>'898','pid'=>'896','shortname'=>'盐都','name'=>'盐都区','merger_name'=>'中国,江苏省,盐城市,盐都区','level'=>'3','pinyin'=>'yandu','code'=>'0515','zip_code'=>'224055','first'=>'Y','lng'=>'120.15441','lat'=>'33.3373']);
        $this->insert('{{%region}}',['id'=>'899','pid'=>'896','shortname'=>'响水','name'=>'响水县','merger_name'=>'中国,江苏省,盐城市,响水县','level'=>'3','pinyin'=>'xiangshui','code'=>'0515','zip_code'=>'224600','first'=>'X','lng'=>'119.56985','lat'=>'34.20513']);
        $this->insert('{{%region}}',['id'=>'900','pid'=>'896','shortname'=>'滨海','name'=>'滨海县','merger_name'=>'中国,江苏省,盐城市,滨海县','level'=>'3','pinyin'=>'binhai','code'=>'0515','zip_code'=>'224500','first'=>'B','lng'=>'119.82058','lat'=>'33.98972']);
        $this->insert('{{%region}}',['id'=>'901','pid'=>'896','shortname'=>'阜宁','name'=>'阜宁县','merger_name'=>'中国,江苏省,盐城市,阜宁县','level'=>'3','pinyin'=>'funing','code'=>'0515','zip_code'=>'224400','first'=>'F','lng'=>'119.80175','lat'=>'33.78228']);
        $this->insert('{{%region}}',['id'=>'902','pid'=>'896','shortname'=>'射阳','name'=>'射阳县','merger_name'=>'中国,江苏省,盐城市,射阳县','level'=>'3','pinyin'=>'sheyang','code'=>'0515','zip_code'=>'224300','first'=>'S','lng'=>'120.26043','lat'=>'33.77636']);
        $this->insert('{{%region}}',['id'=>'903','pid'=>'896','shortname'=>'建湖','name'=>'建湖县','merger_name'=>'中国,江苏省,盐城市,建湖县','level'=>'3','pinyin'=>'jianhu','code'=>'0515','zip_code'=>'224700','first'=>'J','lng'=>'119.79852','lat'=>'33.47241']);
        $this->insert('{{%region}}',['id'=>'904','pid'=>'896','shortname'=>'东台','name'=>'东台市','merger_name'=>'中国,江苏省,盐城市,东台市','level'=>'3','pinyin'=>'dongtai','code'=>'0515','zip_code'=>'224200','first'=>'D','lng'=>'120.32376','lat'=>'32.85078']);
        $this->insert('{{%region}}',['id'=>'905','pid'=>'896','shortname'=>'大丰','name'=>'大丰市','merger_name'=>'中国,江苏省,盐城市,大丰市','level'=>'3','pinyin'=>'dafeng','code'=>'0515','zip_code'=>'224100','first'=>'D','lng'=>'120.46594','lat'=>'33.19893']);
        $this->insert('{{%region}}',['id'=>'906','pid'=>'820','shortname'=>'扬州','name'=>'扬州市','merger_name'=>'中国,江苏省,扬州市','level'=>'2','pinyin'=>'yangzhou','code'=>'0514','zip_code'=>'225002','first'=>'Y','lng'=>'119.421003','lat'=>'32.393159']);
        $this->insert('{{%region}}',['id'=>'907','pid'=>'906','shortname'=>'广陵','name'=>'广陵区','merger_name'=>'中国,江苏省,扬州市,广陵区','level'=>'3','pinyin'=>'guangling','code'=>'0514','zip_code'=>'225002','first'=>'G','lng'=>'119.43186','lat'=>'32.39472']);
        $this->insert('{{%region}}',['id'=>'908','pid'=>'906','shortname'=>'邗江','name'=>'邗江区','merger_name'=>'中国,江苏省,扬州市,邗江区','level'=>'3','pinyin'=>'hanjiang','code'=>'0514','zip_code'=>'225002','first'=>NULL,'lng'=>'119.39816','lat'=>'32.3765']);
        $this->insert('{{%region}}',['id'=>'909','pid'=>'906','shortname'=>'江都','name'=>'江都区','merger_name'=>'中国,江苏省,扬州市,江都区','level'=>'3','pinyin'=>'jiangdu','code'=>'0514','zip_code'=>'225200','first'=>'J','lng'=>'119.567481','lat'=>'32.426564']);
        $this->insert('{{%region}}',['id'=>'910','pid'=>'906','shortname'=>'宝应','name'=>'宝应县','merger_name'=>'中国,江苏省,扬州市,宝应县','level'=>'3','pinyin'=>'baoying','code'=>'0514','zip_code'=>'225800','first'=>'B','lng'=>'119.31213','lat'=>'33.23549']);
        $this->insert('{{%region}}',['id'=>'911','pid'=>'906','shortname'=>'仪征','name'=>'仪征市','merger_name'=>'中国,江苏省,扬州市,仪征市','level'=>'3','pinyin'=>'yizheng','code'=>'0514','zip_code'=>'211400','first'=>'Y','lng'=>'119.18432','lat'=>'32.27197']);
        $this->insert('{{%region}}',['id'=>'912','pid'=>'906','shortname'=>'高邮','name'=>'高邮市','merger_name'=>'中国,江苏省,扬州市,高邮市','level'=>'3','pinyin'=>'gaoyou','code'=>'0514','zip_code'=>'225600','first'=>'G','lng'=>'119.45965','lat'=>'32.78135']);
        $this->insert('{{%region}}',['id'=>'913','pid'=>'820','shortname'=>'镇江','name'=>'镇江市','merger_name'=>'中国,江苏省,镇江市','level'=>'2','pinyin'=>'zhenjiang','code'=>'0511','zip_code'=>'212004','first'=>'Z','lng'=>'119.452753','lat'=>'32.204402']);
        $this->insert('{{%region}}',['id'=>'914','pid'=>'913','shortname'=>'京口','name'=>'京口区','merger_name'=>'中国,江苏省,镇江市,京口区','level'=>'3','pinyin'=>'jingkou','code'=>'0511','zip_code'=>'212003','first'=>'J','lng'=>'119.46947','lat'=>'32.19809']);
        $this->insert('{{%region}}',['id'=>'915','pid'=>'913','shortname'=>'润州','name'=>'润州区','merger_name'=>'中国,江苏省,镇江市,润州区','level'=>'3','pinyin'=>'runzhou','code'=>'0511','zip_code'=>'212005','first'=>'R','lng'=>'119.41134','lat'=>'32.19523']);
        $this->insert('{{%region}}',['id'=>'916','pid'=>'913','shortname'=>'丹徒','name'=>'丹徒区','merger_name'=>'中国,江苏省,镇江市,丹徒区','level'=>'3','pinyin'=>'dantu','code'=>'0511','zip_code'=>'212028','first'=>'D','lng'=>'119.43383','lat'=>'32.13183']);
        $this->insert('{{%region}}',['id'=>'917','pid'=>'913','shortname'=>'丹阳','name'=>'丹阳市','merger_name'=>'中国,江苏省,镇江市,丹阳市','level'=>'3','pinyin'=>'danyang','code'=>'0511','zip_code'=>'212300','first'=>'D','lng'=>'119.57525','lat'=>'31.99121']);
        $this->insert('{{%region}}',['id'=>'918','pid'=>'913','shortname'=>'扬中','name'=>'扬中市','merger_name'=>'中国,江苏省,镇江市,扬中市','level'=>'3','pinyin'=>'yangzhong','code'=>'0511','zip_code'=>'212200','first'=>'Y','lng'=>'119.79718','lat'=>'32.2363']);
        $this->insert('{{%region}}',['id'=>'919','pid'=>'913','shortname'=>'句容','name'=>'句容市','merger_name'=>'中国,江苏省,镇江市,句容市','level'=>'3','pinyin'=>'jurong','code'=>'0511','zip_code'=>'212400','first'=>'J','lng'=>'119.16482','lat'=>'31.95591']);
        $this->insert('{{%region}}',['id'=>'920','pid'=>'820','shortname'=>'泰州','name'=>'泰州市','merger_name'=>'中国,江苏省,泰州市','level'=>'2','pinyin'=>'taizhou','code'=>'0523','zip_code'=>'225300','first'=>'T','lng'=>'119.915176','lat'=>'32.484882']);
        $this->insert('{{%region}}',['id'=>'921','pid'=>'920','shortname'=>'海陵','name'=>'海陵区','merger_name'=>'中国,江苏省,泰州市,海陵区','level'=>'3','pinyin'=>'hailing','code'=>'0523','zip_code'=>'225300','first'=>'H','lng'=>'119.91942','lat'=>'32.49101']);
        $this->insert('{{%region}}',['id'=>'922','pid'=>'920','shortname'=>'高港','name'=>'高港区','merger_name'=>'中国,江苏省,泰州市,高港区','level'=>'3','pinyin'=>'gaogang','code'=>'0523','zip_code'=>'225321','first'=>'G','lng'=>'119.88089','lat'=>'32.31833']);
        $this->insert('{{%region}}',['id'=>'923','pid'=>'920','shortname'=>'姜堰','name'=>'姜堰区','merger_name'=>'中国,江苏省,泰州市,姜堰区','level'=>'3','pinyin'=>'jiangyan','code'=>'0523','zip_code'=>'225500','first'=>'J','lng'=>'120.148208','lat'=>'32.508483']);
        $this->insert('{{%region}}',['id'=>'924','pid'=>'920','shortname'=>'兴化','name'=>'兴化市','merger_name'=>'中国,江苏省,泰州市,兴化市','level'=>'3','pinyin'=>'xinghua','code'=>'0523','zip_code'=>'225700','first'=>'X','lng'=>'119.85238','lat'=>'32.90944']);
        $this->insert('{{%region}}',['id'=>'925','pid'=>'920','shortname'=>'靖江','name'=>'靖江市','merger_name'=>'中国,江苏省,泰州市,靖江市','level'=>'3','pinyin'=>'jingjiang','code'=>'0523','zip_code'=>'214500','first'=>'J','lng'=>'120.27291','lat'=>'32.01595']);
        $this->insert('{{%region}}',['id'=>'926','pid'=>'920','shortname'=>'泰兴','name'=>'泰兴市','merger_name'=>'中国,江苏省,泰州市,泰兴市','level'=>'3','pinyin'=>'taixing','code'=>'0523','zip_code'=>'225400','first'=>'T','lng'=>'120.05194','lat'=>'32.17187']);
        $this->insert('{{%region}}',['id'=>'927','pid'=>'820','shortname'=>'宿迁','name'=>'宿迁市','merger_name'=>'中国,江苏省,宿迁市','level'=>'2','pinyin'=>'suqian','code'=>'0527','zip_code'=>'223800','first'=>'S','lng'=>'118.293328','lat'=>'33.945154']);
        $this->insert('{{%region}}',['id'=>'928','pid'=>'927','shortname'=>'宿城','name'=>'宿城区','merger_name'=>'中国,江苏省,宿迁市,宿城区','level'=>'3','pinyin'=>'sucheng','code'=>'0527','zip_code'=>'223800','first'=>'S','lng'=>'118.29141','lat'=>'33.94219']);
        $this->insert('{{%region}}',['id'=>'929','pid'=>'927','shortname'=>'宿豫','name'=>'宿豫区','merger_name'=>'中国,江苏省,宿迁市,宿豫区','level'=>'3','pinyin'=>'suyu','code'=>'0527','zip_code'=>'223800','first'=>'S','lng'=>'118.32922','lat'=>'33.94673']);
        $this->insert('{{%region}}',['id'=>'930','pid'=>'927','shortname'=>'沭阳','name'=>'沭阳县','merger_name'=>'中国,江苏省,宿迁市,沭阳县','level'=>'3','pinyin'=>'shuyang','code'=>'0527','zip_code'=>'223600','first'=>NULL,'lng'=>'118.76873','lat'=>'34.11446']);
        $this->insert('{{%region}}',['id'=>'931','pid'=>'927','shortname'=>'泗阳','name'=>'泗阳县','merger_name'=>'中国,江苏省,宿迁市,泗阳县','level'=>'3','pinyin'=>'siyang','code'=>'0527','zip_code'=>'223700','first'=>NULL,'lng'=>'118.7033','lat'=>'33.72096']);
        $this->insert('{{%region}}',['id'=>'932','pid'=>'927','shortname'=>'泗洪','name'=>'泗洪县','merger_name'=>'中国,江苏省,宿迁市,泗洪县','level'=>'3','pinyin'=>'sihong','code'=>'0527','zip_code'=>'223900','first'=>NULL,'lng'=>'118.21716','lat'=>'33.45996']);
        $this->insert('{{%region}}',['id'=>'933','pid'=>'0','shortname'=>'浙江','name'=>'浙江省','merger_name'=>'中国,浙江省','level'=>'1','pinyin'=>'zhejiang','code'=>'','zip_code'=>'','first'=>'Z','lng'=>'120.153576','lat'=>'30.287459']);
        $this->insert('{{%region}}',['id'=>'934','pid'=>'933','shortname'=>'杭州','name'=>'杭州市','merger_name'=>'中国,浙江省,杭州市','level'=>'2','pinyin'=>'hangzhou','code'=>'0571','zip_code'=>'310026','first'=>'H','lng'=>'120.153576','lat'=>'30.287459']);
        $this->insert('{{%region}}',['id'=>'935','pid'=>'934','shortname'=>'上城','name'=>'上城区','merger_name'=>'中国,浙江省,杭州市,上城区','level'=>'3','pinyin'=>'shangcheng','code'=>'0571','zip_code'=>'310002','first'=>'S','lng'=>'120.16922','lat'=>'30.24255']);
        $this->insert('{{%region}}',['id'=>'936','pid'=>'934','shortname'=>'下城','name'=>'下城区','merger_name'=>'中国,浙江省,杭州市,下城区','level'=>'3','pinyin'=>'xiacheng','code'=>'0571','zip_code'=>'310006','first'=>'X','lng'=>'120.18096','lat'=>'30.28153']);
        $this->insert('{{%region}}',['id'=>'937','pid'=>'934','shortname'=>'江干','name'=>'江干区','merger_name'=>'中国,浙江省,杭州市,江干区','level'=>'3','pinyin'=>'jianggan','code'=>'0571','zip_code'=>'310016','first'=>'J','lng'=>'120.20517','lat'=>'30.2572']);
        $this->insert('{{%region}}',['id'=>'938','pid'=>'934','shortname'=>'拱墅','name'=>'拱墅区','merger_name'=>'中国,浙江省,杭州市,拱墅区','level'=>'3','pinyin'=>'gongshu','code'=>'0571','zip_code'=>'310011','first'=>'G','lng'=>'120.14209','lat'=>'30.31968']);
        $this->insert('{{%region}}',['id'=>'939','pid'=>'934','shortname'=>'西湖','name'=>'西湖区','merger_name'=>'中国,浙江省,杭州市,西湖区','level'=>'3','pinyin'=>'xihu','code'=>'0571','zip_code'=>'310013','first'=>'X','lng'=>'120.12979','lat'=>'30.25949']);
        $this->insert('{{%region}}',['id'=>'940','pid'=>'934','shortname'=>'滨江','name'=>'滨江区','merger_name'=>'中国,浙江省,杭州市,滨江区','level'=>'3','pinyin'=>'binjiang','code'=>'0571','zip_code'=>'310051','first'=>'B','lng'=>'120.21194','lat'=>'30.20835']);
        $this->insert('{{%region}}',['id'=>'941','pid'=>'934','shortname'=>'萧山','name'=>'萧山区','merger_name'=>'中国,浙江省,杭州市,萧山区','level'=>'3','pinyin'=>'xiaoshan','code'=>'0571','zip_code'=>'311200','first'=>'X','lng'=>'120.26452','lat'=>'30.18505']);
        $this->insert('{{%region}}',['id'=>'942','pid'=>'934','shortname'=>'余杭','name'=>'余杭区','merger_name'=>'中国,浙江省,杭州市,余杭区','level'=>'3','pinyin'=>'yuhang','code'=>'0571','zip_code'=>'311100','first'=>'Y','lng'=>'120.29986','lat'=>'30.41829']);
        $this->insert('{{%region}}',['id'=>'943','pid'=>'934','shortname'=>'桐庐','name'=>'桐庐县','merger_name'=>'中国,浙江省,杭州市,桐庐县','level'=>'3','pinyin'=>'tonglu','code'=>'0571','zip_code'=>'311500','first'=>'T','lng'=>'119.68853','lat'=>'29.79779']);
        $this->insert('{{%region}}',['id'=>'944','pid'=>'934','shortname'=>'淳安','name'=>'淳安县','merger_name'=>'中国,浙江省,杭州市,淳安县','level'=>'3','pinyin'=>'chun\'an','code'=>'0571','zip_code'=>'311700','first'=>'C','lng'=>'119.04257','lat'=>'29.60988']);
        $this->insert('{{%region}}',['id'=>'945','pid'=>'934','shortname'=>'建德','name'=>'建德市','merger_name'=>'中国,浙江省,杭州市,建德市','level'=>'3','pinyin'=>'jiande','code'=>'0571','zip_code'=>'311600','first'=>'J','lng'=>'119.28158','lat'=>'29.47603']);
        $this->insert('{{%region}}',['id'=>'946','pid'=>'934','shortname'=>'富阳','name'=>'富阳区','merger_name'=>'中国,浙江省,杭州市,富阳区','level'=>'3','pinyin'=>'fuyang','code'=>'0571','zip_code'=>'311400','first'=>'F','lng'=>'119.96041','lat'=>'30.04878']);
        $this->insert('{{%region}}',['id'=>'947','pid'=>'934','shortname'=>'临安','name'=>'临安市','merger_name'=>'中国,浙江省,杭州市,临安市','level'=>'3','pinyin'=>'lin\'an','code'=>'0571','zip_code'=>'311300','first'=>'L','lng'=>'119.72473','lat'=>'30.23447']);
        $this->insert('{{%region}}',['id'=>'948','pid'=>'933','shortname'=>'宁波','name'=>'宁波市','merger_name'=>'中国,浙江省,宁波市','level'=>'2','pinyin'=>'ningbo','code'=>'0574','zip_code'=>'315000','first'=>'N','lng'=>'121.549792','lat'=>'29.868388']);
        $this->insert('{{%region}}',['id'=>'949','pid'=>'948','shortname'=>'海曙','name'=>'海曙区','merger_name'=>'中国,浙江省,宁波市,海曙区','level'=>'3','pinyin'=>'haishu','code'=>'0574','zip_code'=>'315000','first'=>'H','lng'=>'121.55106','lat'=>'29.85977']);
        $this->insert('{{%region}}',['id'=>'950','pid'=>'948','shortname'=>'江东','name'=>'江东区','merger_name'=>'中国,浙江省,宁波市,江东区','level'=>'3','pinyin'=>'jiangdong','code'=>'0574','zip_code'=>'315040','first'=>'J','lng'=>'121.57028','lat'=>'29.86701']);
        $this->insert('{{%region}}',['id'=>'951','pid'=>'948','shortname'=>'江北','name'=>'江北区','merger_name'=>'中国,浙江省,宁波市,江北区','level'=>'3','pinyin'=>'jiangbei','code'=>'0574','zip_code'=>'315020','first'=>'J','lng'=>'121.55681','lat'=>'29.88776']);
        $this->insert('{{%region}}',['id'=>'952','pid'=>'948','shortname'=>'北仑','name'=>'北仑区','merger_name'=>'中国,浙江省,宁波市,北仑区','level'=>'3','pinyin'=>'beilun','code'=>'0574','zip_code'=>'315800','first'=>'B','lng'=>'121.84408','lat'=>'29.90069']);
        $this->insert('{{%region}}',['id'=>'953','pid'=>'948','shortname'=>'镇海','name'=>'镇海区','merger_name'=>'中国,浙江省,宁波市,镇海区','level'=>'3','pinyin'=>'zhenhai','code'=>'0574','zip_code'=>'315200','first'=>'Z','lng'=>'121.71615','lat'=>'29.94893']);
        $this->insert('{{%region}}',['id'=>'954','pid'=>'948','shortname'=>'鄞州','name'=>'鄞州区','merger_name'=>'中国,浙江省,宁波市,鄞州区','level'=>'3','pinyin'=>'yinzhou','code'=>'0574','zip_code'=>'315100','first'=>NULL,'lng'=>'121.54754','lat'=>'29.81614']);
        $this->insert('{{%region}}',['id'=>'955','pid'=>'948','shortname'=>'象山','name'=>'象山县','merger_name'=>'中国,浙江省,宁波市,象山县','level'=>'3','pinyin'=>'xiangshan','code'=>'0574','zip_code'=>'315700','first'=>'X','lng'=>'121.86917','lat'=>'29.47758']);
        $this->insert('{{%region}}',['id'=>'956','pid'=>'948','shortname'=>'宁海','name'=>'宁海县','merger_name'=>'中国,浙江省,宁波市,宁海县','level'=>'3','pinyin'=>'ninghai','code'=>'0574','zip_code'=>'315600','first'=>'N','lng'=>'121.43072','lat'=>'29.2889']);
        $this->insert('{{%region}}',['id'=>'957','pid'=>'948','shortname'=>'余姚','name'=>'余姚市','merger_name'=>'中国,浙江省,宁波市,余姚市','level'=>'3','pinyin'=>'yuyao','code'=>'0574','zip_code'=>'315400','first'=>'Y','lng'=>'121.15341','lat'=>'30.03867']);
        $this->insert('{{%region}}',['id'=>'958','pid'=>'948','shortname'=>'慈溪','name'=>'慈溪市','merger_name'=>'中国,浙江省,宁波市,慈溪市','level'=>'3','pinyin'=>'cixi','code'=>'0574','zip_code'=>'315300','first'=>'C','lng'=>'121.26641','lat'=>'30.16959']);
        $this->insert('{{%region}}',['id'=>'959','pid'=>'948','shortname'=>'奉化','name'=>'奉化市','merger_name'=>'中国,浙江省,宁波市,奉化市','level'=>'3','pinyin'=>'fenghua','code'=>'0574','zip_code'=>'315500','first'=>'F','lng'=>'121.41003','lat'=>'29.65537']);
        $this->insert('{{%region}}',['id'=>'960','pid'=>'933','shortname'=>'温州','name'=>'温州市','merger_name'=>'中国,浙江省,温州市','level'=>'2','pinyin'=>'wenzhou','code'=>'0577','zip_code'=>'325000','first'=>'W','lng'=>'120.672111','lat'=>'28.000575']);
        $this->insert('{{%region}}',['id'=>'961','pid'=>'960','shortname'=>'鹿城','name'=>'鹿城区','merger_name'=>'中国,浙江省,温州市,鹿城区','level'=>'3','pinyin'=>'lucheng','code'=>'0577','zip_code'=>'325000','first'=>'L','lng'=>'120.65505','lat'=>'28.01489']);
        $this->insert('{{%region}}',['id'=>'962','pid'=>'960','shortname'=>'龙湾','name'=>'龙湾区','merger_name'=>'中国,浙江省,温州市,龙湾区','level'=>'3','pinyin'=>'longwan','code'=>'0577','zip_code'=>'325013','first'=>'L','lng'=>'120.83053','lat'=>'27.91284']);
        $this->insert('{{%region}}',['id'=>'963','pid'=>'960','shortname'=>'瓯海','name'=>'瓯海区','merger_name'=>'中国,浙江省,温州市,瓯海区','level'=>'3','pinyin'=>'ouhai','code'=>'0577','zip_code'=>'325005','first'=>NULL,'lng'=>'120.63751','lat'=>'28.00714']);
        $this->insert('{{%region}}',['id'=>'964','pid'=>'960','shortname'=>'洞头','name'=>'洞头县','merger_name'=>'中国,浙江省,温州市,洞头县','level'=>'3','pinyin'=>'dongtou','code'=>'0577','zip_code'=>'325700','first'=>'D','lng'=>'121.15606','lat'=>'27.83634']);
        $this->insert('{{%region}}',['id'=>'965','pid'=>'960','shortname'=>'永嘉','name'=>'永嘉县','merger_name'=>'中国,浙江省,温州市,永嘉县','level'=>'3','pinyin'=>'yongjia','code'=>'0577','zip_code'=>'325100','first'=>'Y','lng'=>'120.69317','lat'=>'28.15456']);
        $this->insert('{{%region}}',['id'=>'966','pid'=>'960','shortname'=>'平阳','name'=>'平阳县','merger_name'=>'中国,浙江省,温州市,平阳县','level'=>'3','pinyin'=>'pingyang','code'=>'0577','zip_code'=>'325400','first'=>'P','lng'=>'120.56506','lat'=>'27.66245']);
        $this->insert('{{%region}}',['id'=>'967','pid'=>'960','shortname'=>'苍南','name'=>'苍南县','merger_name'=>'中国,浙江省,温州市,苍南县','level'=>'3','pinyin'=>'cangnan','code'=>'0577','zip_code'=>'325800','first'=>'C','lng'=>'120.42608','lat'=>'27.51739']);
        $this->insert('{{%region}}',['id'=>'968','pid'=>'960','shortname'=>'文成','name'=>'文成县','merger_name'=>'中国,浙江省,温州市,文成县','level'=>'3','pinyin'=>'wencheng','code'=>'0577','zip_code'=>'325300','first'=>'W','lng'=>'120.09063','lat'=>'27.78678']);
        $this->insert('{{%region}}',['id'=>'969','pid'=>'960','shortname'=>'泰顺','name'=>'泰顺县','merger_name'=>'中国,浙江省,温州市,泰顺县','level'=>'3','pinyin'=>'taishun','code'=>'0577','zip_code'=>'325500','first'=>'T','lng'=>'119.7182','lat'=>'27.55694']);
        $this->insert('{{%region}}',['id'=>'970','pid'=>'960','shortname'=>'瑞安','name'=>'瑞安市','merger_name'=>'中国,浙江省,温州市,瑞安市','level'=>'3','pinyin'=>'rui\'an','code'=>'0577','zip_code'=>'325200','first'=>'R','lng'=>'120.65466','lat'=>'27.78041']);
        $this->insert('{{%region}}',['id'=>'971','pid'=>'960','shortname'=>'乐清','name'=>'乐清市','merger_name'=>'中国,浙江省,温州市,乐清市','level'=>'3','pinyin'=>'yueqing','code'=>'0577','zip_code'=>'325600','first'=>'L','lng'=>'120.9617','lat'=>'28.12404']);
        $this->insert('{{%region}}',['id'=>'972','pid'=>'933','shortname'=>'嘉兴','name'=>'嘉兴市','merger_name'=>'中国,浙江省,嘉兴市','level'=>'2','pinyin'=>'jiaxing','code'=>'0573','zip_code'=>'314000','first'=>'J','lng'=>'120.750865','lat'=>'30.762653']);
        $this->insert('{{%region}}',['id'=>'973','pid'=>'972','shortname'=>'南湖','name'=>'南湖区','merger_name'=>'中国,浙江省,嘉兴市,南湖区','level'=>'3','pinyin'=>'nanhu','code'=>'0573','zip_code'=>'314051','first'=>'N','lng'=>'120.78524','lat'=>'30.74865']);
        $this->insert('{{%region}}',['id'=>'974','pid'=>'972','shortname'=>'秀洲','name'=>'秀洲区','merger_name'=>'中国,浙江省,嘉兴市,秀洲区','level'=>'3','pinyin'=>'xiuzhou','code'=>'0573','zip_code'=>'314031','first'=>'X','lng'=>'120.70867','lat'=>'30.76454']);
        $this->insert('{{%region}}',['id'=>'975','pid'=>'972','shortname'=>'嘉善','name'=>'嘉善县','merger_name'=>'中国,浙江省,嘉兴市,嘉善县','level'=>'3','pinyin'=>'jiashan','code'=>'0573','zip_code'=>'314100','first'=>'J','lng'=>'120.92559','lat'=>'30.82993']);
        $this->insert('{{%region}}',['id'=>'976','pid'=>'972','shortname'=>'海盐','name'=>'海盐县','merger_name'=>'中国,浙江省,嘉兴市,海盐县','level'=>'3','pinyin'=>'haiyan','code'=>'0573','zip_code'=>'314300','first'=>'H','lng'=>'120.9457','lat'=>'30.52547']);
        $this->insert('{{%region}}',['id'=>'977','pid'=>'972','shortname'=>'海宁','name'=>'海宁市','merger_name'=>'中国,浙江省,嘉兴市,海宁市','level'=>'3','pinyin'=>'haining','code'=>'0573','zip_code'=>'314400','first'=>'H','lng'=>'120.6813','lat'=>'30.5097']);
        $this->insert('{{%region}}',['id'=>'978','pid'=>'972','shortname'=>'平湖','name'=>'平湖市','merger_name'=>'中国,浙江省,嘉兴市,平湖市','level'=>'3','pinyin'=>'pinghu','code'=>'0573','zip_code'=>'314200','first'=>'P','lng'=>'121.02166','lat'=>'30.69618']);
        $this->insert('{{%region}}',['id'=>'979','pid'=>'972','shortname'=>'桐乡','name'=>'桐乡市','merger_name'=>'中国,浙江省,嘉兴市,桐乡市','level'=>'3','pinyin'=>'tongxiang','code'=>'0573','zip_code'=>'314500','first'=>'T','lng'=>'120.56485','lat'=>'30.6302']);
        $this->insert('{{%region}}',['id'=>'980','pid'=>'933','shortname'=>'湖州','name'=>'湖州市','merger_name'=>'中国,浙江省,湖州市','level'=>'2','pinyin'=>'huzhou','code'=>'0572','zip_code'=>'313000','first'=>'H','lng'=>'120.102398','lat'=>'30.867198']);
        $this->insert('{{%region}}',['id'=>'981','pid'=>'980','shortname'=>'吴兴','name'=>'吴兴区','merger_name'=>'中国,浙江省,湖州市,吴兴区','level'=>'3','pinyin'=>'wuxing','code'=>'0572','zip_code'=>'313000','first'=>'W','lng'=>'120.12548','lat'=>'30.85752']);
        $this->insert('{{%region}}',['id'=>'982','pid'=>'980','shortname'=>'南浔','name'=>'南浔区','merger_name'=>'中国,浙江省,湖州市,南浔区','level'=>'3','pinyin'=>'nanxun','code'=>'0572','zip_code'=>'313009','first'=>'N','lng'=>'120.42038','lat'=>'30.86686']);
        $this->insert('{{%region}}',['id'=>'983','pid'=>'980','shortname'=>'德清','name'=>'德清县','merger_name'=>'中国,浙江省,湖州市,德清县','level'=>'3','pinyin'=>'deqing','code'=>'0572','zip_code'=>'313200','first'=>'D','lng'=>'119.97836','lat'=>'30.53369']);
        $this->insert('{{%region}}',['id'=>'984','pid'=>'980','shortname'=>'长兴','name'=>'长兴县','merger_name'=>'中国,浙江省,湖州市,长兴县','level'=>'3','pinyin'=>'changxing','code'=>'0572','zip_code'=>'313100','first'=>'C','lng'=>'119.90783','lat'=>'31.00606']);
        $this->insert('{{%region}}',['id'=>'985','pid'=>'980','shortname'=>'安吉','name'=>'安吉县','merger_name'=>'中国,浙江省,湖州市,安吉县','level'=>'3','pinyin'=>'anji','code'=>'0572','zip_code'=>'313300','first'=>'A','lng'=>'119.68158','lat'=>'30.63798']);
        $this->insert('{{%region}}',['id'=>'986','pid'=>'933','shortname'=>'绍兴','name'=>'绍兴市','merger_name'=>'中国,浙江省,绍兴市','level'=>'2','pinyin'=>'shaoxing','code'=>'0575','zip_code'=>'312000','first'=>'S','lng'=>'120.582112','lat'=>'29.997117']);
        $this->insert('{{%region}}',['id'=>'987','pid'=>'986','shortname'=>'越城','name'=>'越城区','merger_name'=>'中国,浙江省,绍兴市,越城区','level'=>'3','pinyin'=>'yuecheng','code'=>'0575','zip_code'=>'312000','first'=>'Y','lng'=>'120.5819','lat'=>'29.98895']);
        $this->insert('{{%region}}',['id'=>'988','pid'=>'986','shortname'=>'柯桥','name'=>'柯桥区','merger_name'=>'中国,浙江省,绍兴市,柯桥区','level'=>'3','pinyin'=>'keqiao','code'=>'0575','zip_code'=>'312030','first'=>'K','lng'=>'120.492736','lat'=>'30.08763']);
        $this->insert('{{%region}}',['id'=>'989','pid'=>'986','shortname'=>'上虞','name'=>'上虞区','merger_name'=>'中国,浙江省,绍兴市,上虞区','level'=>'3','pinyin'=>'shangyu','code'=>'0575','zip_code'=>'312300','first'=>'S','lng'=>'120.476075','lat'=>'30.078038']);
        $this->insert('{{%region}}',['id'=>'990','pid'=>'986','shortname'=>'新昌','name'=>'新昌县','merger_name'=>'中国,浙江省,绍兴市,新昌县','level'=>'3','pinyin'=>'xinchang','code'=>'0575','zip_code'=>'312500','first'=>'X','lng'=>'120.90435','lat'=>'29.49991']);
        $this->insert('{{%region}}',['id'=>'991','pid'=>'986','shortname'=>'诸暨','name'=>'诸暨市','merger_name'=>'中国,浙江省,绍兴市,诸暨市','level'=>'3','pinyin'=>'zhuji','code'=>'0575','zip_code'=>'311800','first'=>'Z','lng'=>'120.23629','lat'=>'29.71358']);
        $this->insert('{{%region}}',['id'=>'992','pid'=>'986','shortname'=>'嵊州','name'=>'嵊州市','merger_name'=>'中国,浙江省,绍兴市,嵊州市','level'=>'3','pinyin'=>'shengzhou','code'=>'0575','zip_code'=>'312400','first'=>NULL,'lng'=>'120.82174','lat'=>'29.58854']);
        $this->insert('{{%region}}',['id'=>'993','pid'=>'933','shortname'=>'金华','name'=>'金华市','merger_name'=>'中国,浙江省,金华市','level'=>'2','pinyin'=>'jinhua','code'=>'0579','zip_code'=>'321000','first'=>'J','lng'=>'119.649506','lat'=>'29.089524']);
        $this->insert('{{%region}}',['id'=>'994','pid'=>'993','shortname'=>'婺城','name'=>'婺城区','merger_name'=>'中国,浙江省,金华市,婺城区','level'=>'3','pinyin'=>'wucheng','code'=>'0579','zip_code'=>'321000','first'=>NULL,'lng'=>'119.57135','lat'=>'29.09521']);
        $this->insert('{{%region}}',['id'=>'995','pid'=>'993','shortname'=>'金东','name'=>'金东区','merger_name'=>'中国,浙江省,金华市,金东区','level'=>'3','pinyin'=>'jindong','code'=>'0579','zip_code'=>'321000','first'=>'J','lng'=>'119.69302','lat'=>'29.0991']);
        $this->insert('{{%region}}',['id'=>'996','pid'=>'993','shortname'=>'武义','name'=>'武义县','merger_name'=>'中国,浙江省,金华市,武义县','level'=>'3','pinyin'=>'wuyi','code'=>'0579','zip_code'=>'321200','first'=>'W','lng'=>'119.8164','lat'=>'28.89331']);
        $this->insert('{{%region}}',['id'=>'997','pid'=>'993','shortname'=>'浦江','name'=>'浦江县','merger_name'=>'中国,浙江省,金华市,浦江县','level'=>'3','pinyin'=>'pujiang','code'=>'0579','zip_code'=>'322200','first'=>'P','lng'=>'119.89181','lat'=>'29.45353']);
        $this->insert('{{%region}}',['id'=>'998','pid'=>'993','shortname'=>'磐安','name'=>'磐安县','merger_name'=>'中国,浙江省,金华市,磐安县','level'=>'3','pinyin'=>'pan\'an','code'=>'0579','zip_code'=>'322300','first'=>'P','lng'=>'120.45022','lat'=>'29.05733']);
        $this->insert('{{%region}}',['id'=>'999','pid'=>'993','shortname'=>'兰溪','name'=>'兰溪市','merger_name'=>'中国,浙江省,金华市,兰溪市','level'=>'3','pinyin'=>'lanxi','code'=>'0579','zip_code'=>'321100','first'=>'L','lng'=>'119.45965','lat'=>'29.20841']);
        $this->insert('{{%region}}',['id'=>'1000','pid'=>'993','shortname'=>'义乌','name'=>'义乌市','merger_name'=>'中国,浙江省,金华市,义乌市','level'=>'3','pinyin'=>'yiwu','code'=>'0579','zip_code'=>'322000','first'=>'Y','lng'=>'120.0744','lat'=>'29.30558']);
        $this->insert('{{%region}}',['id'=>'1001','pid'=>'993','shortname'=>'东阳','name'=>'东阳市','merger_name'=>'中国,浙江省,金华市,东阳市','level'=>'3','pinyin'=>'dongyang','code'=>'0579','zip_code'=>'322100','first'=>'D','lng'=>'120.24185','lat'=>'29.28942']);
        $this->insert('{{%region}}',['id'=>'1002','pid'=>'993','shortname'=>'永康','name'=>'永康市','merger_name'=>'中国,浙江省,金华市,永康市','level'=>'3','pinyin'=>'yongkang','code'=>'0579','zip_code'=>'321300','first'=>'Y','lng'=>'120.04727','lat'=>'28.88844']);
        $this->insert('{{%region}}',['id'=>'1003','pid'=>'933','shortname'=>'衢州','name'=>'衢州市','merger_name'=>'中国,浙江省,衢州市','level'=>'2','pinyin'=>'quzhou','code'=>'0570','zip_code'=>'324002','first'=>NULL,'lng'=>'118.87263','lat'=>'28.941708']);
        $this->insert('{{%region}}',['id'=>'1004','pid'=>'1003','shortname'=>'柯城','name'=>'柯城区','merger_name'=>'中国,浙江省,衢州市,柯城区','level'=>'3','pinyin'=>'kecheng','code'=>'0570','zip_code'=>'324100','first'=>'K','lng'=>'118.87109','lat'=>'28.96858']);
        $this->insert('{{%region}}',['id'=>'1005','pid'=>'1003','shortname'=>'衢江','name'=>'衢江区','merger_name'=>'中国,浙江省,衢州市,衢江区','level'=>'3','pinyin'=>'qujiang','code'=>'0570','zip_code'=>'324022','first'=>NULL,'lng'=>'118.9598','lat'=>'28.97977']);
        $this->insert('{{%region}}',['id'=>'1006','pid'=>'1003','shortname'=>'常山','name'=>'常山县','merger_name'=>'中国,浙江省,衢州市,常山县','level'=>'3','pinyin'=>'changshan','code'=>'0570','zip_code'=>'324200','first'=>'C','lng'=>'118.51025','lat'=>'28.90191']);
        $this->insert('{{%region}}',['id'=>'1007','pid'=>'1003','shortname'=>'开化','name'=>'开化县','merger_name'=>'中国,浙江省,衢州市,开化县','level'=>'3','pinyin'=>'kaihua','code'=>'0570','zip_code'=>'324300','first'=>'K','lng'=>'118.41616','lat'=>'29.13785']);
        $this->insert('{{%region}}',['id'=>'1008','pid'=>'1003','shortname'=>'龙游','name'=>'龙游县','merger_name'=>'中国,浙江省,衢州市,龙游县','level'=>'3','pinyin'=>'longyou','code'=>'0570','zip_code'=>'324400','first'=>'L','lng'=>'119.17221','lat'=>'29.02823']);
        $this->insert('{{%region}}',['id'=>'1009','pid'=>'1003','shortname'=>'江山','name'=>'江山市','merger_name'=>'中国,浙江省,衢州市,江山市','level'=>'3','pinyin'=>'jiangshan','code'=>'0570','zip_code'=>'324100','first'=>'J','lng'=>'118.62674','lat'=>'28.7386']);
        $this->insert('{{%region}}',['id'=>'1010','pid'=>'933','shortname'=>'舟山','name'=>'舟山市','merger_name'=>'中国,浙江省,舟山市','level'=>'2','pinyin'=>'zhoushan','code'=>'0580','zip_code'=>'316000','first'=>'Z','lng'=>'122.106863','lat'=>'30.016028']);
        $this->insert('{{%region}}',['id'=>'1011','pid'=>'1010','shortname'=>'定海','name'=>'定海区','merger_name'=>'中国,浙江省,舟山市,定海区','level'=>'3','pinyin'=>'dinghai','code'=>'0580','zip_code'=>'316000','first'=>'D','lng'=>'122.10677','lat'=>'30.01985']);
        $this->insert('{{%region}}',['id'=>'1012','pid'=>'1010','shortname'=>'普陀','name'=>'普陀区','merger_name'=>'中国,浙江省,舟山市,普陀区','level'=>'3','pinyin'=>'putuo','code'=>'0580','zip_code'=>'316100','first'=>'P','lng'=>'122.30278','lat'=>'29.94908']);
        $this->insert('{{%region}}',['id'=>'1013','pid'=>'1010','shortname'=>'岱山','name'=>'岱山县','merger_name'=>'中国,浙江省,舟山市,岱山县','level'=>'3','pinyin'=>'daishan','code'=>'0580','zip_code'=>'316200','first'=>NULL,'lng'=>'122.20486','lat'=>'30.24385']);
        $this->insert('{{%region}}',['id'=>'1014','pid'=>'1010','shortname'=>'嵊泗','name'=>'嵊泗县','merger_name'=>'中国,浙江省,舟山市,嵊泗县','level'=>'3','pinyin'=>'shengsi','code'=>'0580','zip_code'=>'202450','first'=>NULL,'lng'=>'122.45129','lat'=>'30.72678']);
        $this->insert('{{%region}}',['id'=>'1015','pid'=>'933','shortname'=>'台州','name'=>'台州市','merger_name'=>'中国,浙江省,台州市','level'=>'2','pinyin'=>'taizhou','code'=>'0576','zip_code'=>'318000','first'=>'T','lng'=>'121.428599','lat'=>'28.661378']);
        $this->insert('{{%region}}',['id'=>'1016','pid'=>'1015','shortname'=>'椒江','name'=>'椒江区','merger_name'=>'中国,浙江省,台州市,椒江区','level'=>'3','pinyin'=>'jiaojiang','code'=>'0576','zip_code'=>'318000','first'=>'J','lng'=>'121.44287','lat'=>'28.67301']);
        $this->insert('{{%region}}',['id'=>'1017','pid'=>'1015','shortname'=>'黄岩','name'=>'黄岩区','merger_name'=>'中国,浙江省,台州市,黄岩区','level'=>'3','pinyin'=>'huangyan','code'=>'0576','zip_code'=>'318020','first'=>'H','lng'=>'121.25891','lat'=>'28.65077']);
        $this->insert('{{%region}}',['id'=>'1018','pid'=>'1015','shortname'=>'路桥','name'=>'路桥区','merger_name'=>'中国,浙江省,台州市,路桥区','level'=>'3','pinyin'=>'luqiao','code'=>'0576','zip_code'=>'318050','first'=>'L','lng'=>'121.37381','lat'=>'28.58016']);
        $this->insert('{{%region}}',['id'=>'1019','pid'=>'1015','shortname'=>'玉环','name'=>'玉环县','merger_name'=>'中国,浙江省,台州市,玉环县','level'=>'3','pinyin'=>'yuhuan','code'=>'0576','zip_code'=>'317600','first'=>'Y','lng'=>'121.23242','lat'=>'28.13637']);
        $this->insert('{{%region}}',['id'=>'1020','pid'=>'1015','shortname'=>'三门','name'=>'三门县','merger_name'=>'中国,浙江省,台州市,三门县','level'=>'3','pinyin'=>'sanmen','code'=>'0576','zip_code'=>'317100','first'=>'S','lng'=>'121.3937','lat'=>'29.1051']);
        $this->insert('{{%region}}',['id'=>'1021','pid'=>'1015','shortname'=>'天台','name'=>'天台县','merger_name'=>'中国,浙江省,台州市,天台县','level'=>'3','pinyin'=>'tiantai','code'=>'0576','zip_code'=>'317200','first'=>'T','lng'=>'121.00848','lat'=>'29.1429']);
        $this->insert('{{%region}}',['id'=>'1022','pid'=>'1015','shortname'=>'仙居','name'=>'仙居县','merger_name'=>'中国,浙江省,台州市,仙居县','level'=>'3','pinyin'=>'xianju','code'=>'0576','zip_code'=>'317300','first'=>'X','lng'=>'120.72872','lat'=>'28.84672']);
        $this->insert('{{%region}}',['id'=>'1023','pid'=>'1015','shortname'=>'温岭','name'=>'温岭市','merger_name'=>'中国,浙江省,台州市,温岭市','level'=>'3','pinyin'=>'wenling','code'=>'0576','zip_code'=>'317500','first'=>'W','lng'=>'121.38595','lat'=>'28.37176']);
        $this->insert('{{%region}}',['id'=>'1024','pid'=>'1015','shortname'=>'临海','name'=>'临海市','merger_name'=>'中国,浙江省,台州市,临海市','level'=>'3','pinyin'=>'linhai','code'=>'0576','zip_code'=>'317000','first'=>'L','lng'=>'121.13885','lat'=>'28.85603']);
        $this->insert('{{%region}}',['id'=>'1025','pid'=>'933','shortname'=>'丽水','name'=>'丽水市','merger_name'=>'中国,浙江省,丽水市','level'=>'2','pinyin'=>'lishui','code'=>'0578','zip_code'=>'323000','first'=>'L','lng'=>'119.921786','lat'=>'28.451993']);
        $this->insert('{{%region}}',['id'=>'1026','pid'=>'1025','shortname'=>'莲都','name'=>'莲都区','merger_name'=>'中国,浙江省,丽水市,莲都区','level'=>'3','pinyin'=>'liandu','code'=>'0578','zip_code'=>'323000','first'=>'L','lng'=>'119.9127','lat'=>'28.44583']);
        $this->insert('{{%region}}',['id'=>'1027','pid'=>'1025','shortname'=>'青田','name'=>'青田县','merger_name'=>'中国,浙江省,丽水市,青田县','level'=>'3','pinyin'=>'qingtian','code'=>'0578','zip_code'=>'323900','first'=>'Q','lng'=>'120.29028','lat'=>'28.13897']);
        $this->insert('{{%region}}',['id'=>'1028','pid'=>'1025','shortname'=>'缙云','name'=>'缙云县','merger_name'=>'中国,浙江省,丽水市,缙云县','level'=>'3','pinyin'=>'jinyun','code'=>'0578','zip_code'=>'321400','first'=>NULL,'lng'=>'120.09036','lat'=>'28.65944']);
        $this->insert('{{%region}}',['id'=>'1029','pid'=>'1025','shortname'=>'遂昌','name'=>'遂昌县','merger_name'=>'中国,浙江省,丽水市,遂昌县','level'=>'3','pinyin'=>'suichang','code'=>'0578','zip_code'=>'323300','first'=>'S','lng'=>'119.27606','lat'=>'28.59291']);
        $this->insert('{{%region}}',['id'=>'1030','pid'=>'1025','shortname'=>'松阳','name'=>'松阳县','merger_name'=>'中国,浙江省,丽水市,松阳县','level'=>'3','pinyin'=>'songyang','code'=>'0578','zip_code'=>'323400','first'=>'S','lng'=>'119.48199','lat'=>'28.4494']);
        $this->insert('{{%region}}',['id'=>'1031','pid'=>'1025','shortname'=>'云和','name'=>'云和县','merger_name'=>'中国,浙江省,丽水市,云和县','level'=>'3','pinyin'=>'yunhe','code'=>'0578','zip_code'=>'323600','first'=>'Y','lng'=>'119.57287','lat'=>'28.11643']);
        $this->insert('{{%region}}',['id'=>'1032','pid'=>'1025','shortname'=>'庆元','name'=>'庆元县','merger_name'=>'中国,浙江省,丽水市,庆元县','level'=>'3','pinyin'=>'qingyuan','code'=>'0578','zip_code'=>'323800','first'=>'Q','lng'=>'119.06256','lat'=>'27.61842']);
        $this->insert('{{%region}}',['id'=>'1033','pid'=>'1025','shortname'=>'景宁','name'=>'景宁畲族自治县','merger_name'=>'中国,浙江省,丽水市,景宁畲族自治县','level'=>'3','pinyin'=>'jingning','code'=>'0578','zip_code'=>'323500','first'=>'J','lng'=>'119.63839','lat'=>'27.97393']);
        $this->insert('{{%region}}',['id'=>'1034','pid'=>'1025','shortname'=>'龙泉','name'=>'龙泉市','merger_name'=>'中国,浙江省,丽水市,龙泉市','level'=>'3','pinyin'=>'longquan','code'=>'0578','zip_code'=>'323700','first'=>'L','lng'=>'119.14163','lat'=>'28.0743']);
        $this->insert('{{%region}}',['id'=>'1035','pid'=>'933','shortname'=>'舟山新区','name'=>'舟山群岛新区','merger_name'=>'中国,浙江省,舟山群岛新区','level'=>'2','pinyin'=>'zhoushan','code'=>'0580','zip_code'=>'316000','first'=>'Z','lng'=>'122.317657','lat'=>'29.813242']);
        $this->insert('{{%region}}',['id'=>'1036','pid'=>'1035','shortname'=>'金塘','name'=>'金塘岛','merger_name'=>'中国,浙江省,舟山群岛新区,金塘岛','level'=>'3','pinyin'=>'jintang','code'=>'0580','zip_code'=>'316000','first'=>'J','lng'=>'121.893373','lat'=>'30.040641']);
        $this->insert('{{%region}}',['id'=>'1037','pid'=>'1035','shortname'=>'六横','name'=>'六横岛','merger_name'=>'中国,浙江省,舟山群岛新区,六横岛','level'=>'3','pinyin'=>'liuheng','code'=>'0580','zip_code'=>'316000','first'=>'L','lng'=>'122.14265','lat'=>'29.662938']);
        $this->insert('{{%region}}',['id'=>'1038','pid'=>'1035','shortname'=>'衢山','name'=>'衢山岛','merger_name'=>'中国,浙江省,舟山群岛新区,衢山岛','level'=>'3','pinyin'=>'qushan','code'=>'0580','zip_code'=>'316000','first'=>NULL,'lng'=>'122.358425','lat'=>'30.442642']);
        $this->insert('{{%region}}',['id'=>'1039','pid'=>'1035','shortname'=>'舟山','name'=>'舟山本岛西北部','merger_name'=>'中国,浙江省,舟山群岛新区,舟山本岛西北部','level'=>'3','pinyin'=>'zhoushan','code'=>'0580','zip_code'=>'316000','first'=>'Z','lng'=>'122.03064','lat'=>'30.140377']);
        $this->insert('{{%region}}',['id'=>'1040','pid'=>'1035','shortname'=>'岱山','name'=>'岱山岛西南部','merger_name'=>'中国,浙江省,舟山群岛新区,岱山岛西南部','level'=>'3','pinyin'=>'daishan','code'=>'0580','zip_code'=>'316000','first'=>NULL,'lng'=>'122.180123','lat'=>'30.277269']);
        $this->insert('{{%region}}',['id'=>'1041','pid'=>'1035','shortname'=>'泗礁','name'=>'泗礁岛','merger_name'=>'中国,浙江省,舟山群岛新区,泗礁岛','level'=>'3','pinyin'=>'sijiao','code'=>'0580','zip_code'=>'316000','first'=>NULL,'lng'=>'122.45803','lat'=>'30.725112']);
        $this->insert('{{%region}}',['id'=>'1042','pid'=>'1035','shortname'=>'朱家尖','name'=>'朱家尖岛','merger_name'=>'中国,浙江省,舟山群岛新区,朱家尖岛','level'=>'3','pinyin'=>'zhujiajian','code'=>'0580','zip_code'=>'316000','first'=>'Z','lng'=>'122.390636','lat'=>'29.916303']);
        $this->insert('{{%region}}',['id'=>'1043','pid'=>'1035','shortname'=>'洋山','name'=>'洋山岛','merger_name'=>'中国,浙江省,舟山群岛新区,洋山岛','level'=>'3','pinyin'=>'yangshan','code'=>'0580','zip_code'=>'316000','first'=>'Y','lng'=>'121.995891','lat'=>'30.094637']);
        $this->insert('{{%region}}',['id'=>'1044','pid'=>'1035','shortname'=>'长涂','name'=>'长涂岛','merger_name'=>'中国,浙江省,舟山群岛新区,长涂岛','level'=>'3','pinyin'=>'changtu','code'=>'0580','zip_code'=>'316000','first'=>'C','lng'=>'122.284681','lat'=>'30.24888']);
        $this->insert('{{%region}}',['id'=>'1045','pid'=>'1035','shortname'=>'虾峙','name'=>'虾峙岛','merger_name'=>'中国,浙江省,舟山群岛新区,虾峙岛','level'=>'3','pinyin'=>'xiazhi','code'=>'0580','zip_code'=>'316000','first'=>'X','lng'=>'122.244686','lat'=>'29.752941']);
        $this->insert('{{%region}}',['id'=>'1046','pid'=>'0','shortname'=>'安徽','name'=>'安徽省','merger_name'=>'中国,安徽省','level'=>'1','pinyin'=>'anhui','code'=>'','zip_code'=>'','first'=>'A','lng'=>'117.283042','lat'=>'31.86119']);
        $this->insert('{{%region}}',['id'=>'1047','pid'=>'1046','shortname'=>'合肥','name'=>'合肥市','merger_name'=>'中国,安徽省,合肥市','level'=>'2','pinyin'=>'hefei','code'=>'0551','zip_code'=>'230001','first'=>'H','lng'=>'117.283042','lat'=>'31.86119']);
        $this->insert('{{%region}}',['id'=>'1048','pid'=>'1047','shortname'=>'瑶海','name'=>'瑶海区','merger_name'=>'中国,安徽省,合肥市,瑶海区','level'=>'3','pinyin'=>'yaohai','code'=>'0551','zip_code'=>'230011','first'=>'Y','lng'=>'117.30947','lat'=>'31.85809']);
        $this->insert('{{%region}}',['id'=>'1049','pid'=>'1047','shortname'=>'庐阳','name'=>'庐阳区','merger_name'=>'中国,安徽省,合肥市,庐阳区','level'=>'3','pinyin'=>'luyang','code'=>'0551','zip_code'=>'230001','first'=>'L','lng'=>'117.26452','lat'=>'31.87874']);
        $this->insert('{{%region}}',['id'=>'1050','pid'=>'1047','shortname'=>'蜀山','name'=>'蜀山区','merger_name'=>'中国,安徽省,合肥市,蜀山区','level'=>'3','pinyin'=>'shushan','code'=>'0551','zip_code'=>'230031','first'=>'S','lng'=>'117.26104','lat'=>'31.85117']);
        $this->insert('{{%region}}',['id'=>'1051','pid'=>'1047','shortname'=>'包河','name'=>'包河区','merger_name'=>'中国,安徽省,合肥市,包河区','level'=>'3','pinyin'=>'baohe','code'=>'0551','zip_code'=>'230041','first'=>'B','lng'=>'117.30984','lat'=>'31.79502']);
        $this->insert('{{%region}}',['id'=>'1052','pid'=>'1047','shortname'=>'长丰','name'=>'长丰县','merger_name'=>'中国,安徽省,合肥市,长丰县','level'=>'3','pinyin'=>'changfeng','code'=>'0551','zip_code'=>'231100','first'=>'C','lng'=>'117.16549','lat'=>'32.47959']);
        $this->insert('{{%region}}',['id'=>'1053','pid'=>'1047','shortname'=>'肥东','name'=>'肥东县','merger_name'=>'中国,安徽省,合肥市,肥东县','level'=>'3','pinyin'=>'feidong','code'=>'0551','zip_code'=>'231600','first'=>'F','lng'=>'117.47128','lat'=>'31.88525']);
        $this->insert('{{%region}}',['id'=>'1054','pid'=>'1047','shortname'=>'肥西','name'=>'肥西县','merger_name'=>'中国,安徽省,合肥市,肥西县','level'=>'3','pinyin'=>'feixi','code'=>'0551','zip_code'=>'231200','first'=>'F','lng'=>'117.16845','lat'=>'31.72143']);
        $this->insert('{{%region}}',['id'=>'1055','pid'=>'1047','shortname'=>'庐江','name'=>'庐江县','merger_name'=>'中国,安徽省,合肥市,庐江县','level'=>'3','pinyin'=>'lujiang','code'=>'0565','zip_code'=>'231500','first'=>'L','lng'=>'117.289844','lat'=>'31.251488']);
        $this->insert('{{%region}}',['id'=>'1056','pid'=>'1047','shortname'=>'巢湖','name'=>'巢湖市','merger_name'=>'中国,安徽省,合肥市,巢湖市','level'=>'3','pinyin'=>'chaohu','code'=>'0565','zip_code'=>'238000','first'=>'C','lng'=>'117.874155','lat'=>'31.600518']);
        $this->insert('{{%region}}',['id'=>'1057','pid'=>'1046','shortname'=>'芜湖','name'=>'芜湖市','merger_name'=>'中国,安徽省,芜湖市','level'=>'2','pinyin'=>'wuhu','code'=>'0551','zip_code'=>'241000','first'=>'W','lng'=>'118.376451','lat'=>'31.326319']);
        $this->insert('{{%region}}',['id'=>'1058','pid'=>'1057','shortname'=>'镜湖','name'=>'镜湖区','merger_name'=>'中国,安徽省,芜湖市,镜湖区','level'=>'3','pinyin'=>'jinghu','code'=>'0553','zip_code'=>'241000','first'=>'J','lng'=>'118.38525','lat'=>'31.34038']);
        $this->insert('{{%region}}',['id'=>'1059','pid'=>'1057','shortname'=>'弋江','name'=>'弋江区','merger_name'=>'中国,安徽省,芜湖市,弋江区','level'=>'3','pinyin'=>'yijiang','code'=>'0553','zip_code'=>'241000','first'=>NULL,'lng'=>'118.37265','lat'=>'31.31178']);
        $this->insert('{{%region}}',['id'=>'1060','pid'=>'1057','shortname'=>'鸠江','name'=>'鸠江区','merger_name'=>'中国,安徽省,芜湖市,鸠江区','level'=>'3','pinyin'=>'jiujiang','code'=>'0553','zip_code'=>'241000','first'=>NULL,'lng'=>'118.39215','lat'=>'31.36928']);
        $this->insert('{{%region}}',['id'=>'1061','pid'=>'1057','shortname'=>'三山','name'=>'三山区','merger_name'=>'中国,安徽省,芜湖市,三山区','level'=>'3','pinyin'=>'sanshan','code'=>'0553','zip_code'=>'241000','first'=>'S','lng'=>'118.22509','lat'=>'31.20703']);
        $this->insert('{{%region}}',['id'=>'1062','pid'=>'1057','shortname'=>'芜湖','name'=>'芜湖县','merger_name'=>'中国,安徽省,芜湖市,芜湖县','level'=>'3','pinyin'=>'wuhu','code'=>'0553','zip_code'=>'241100','first'=>'W','lng'=>'118.57525','lat'=>'31.13476']);
        $this->insert('{{%region}}',['id'=>'1063','pid'=>'1057','shortname'=>'繁昌','name'=>'繁昌县','merger_name'=>'中国,安徽省,芜湖市,繁昌县','level'=>'3','pinyin'=>'fanchang','code'=>'0553','zip_code'=>'241200','first'=>'F','lng'=>'118.19982','lat'=>'31.08319']);
        $this->insert('{{%region}}',['id'=>'1064','pid'=>'1057','shortname'=>'南陵','name'=>'南陵县','merger_name'=>'中国,安徽省,芜湖市,南陵县','level'=>'3','pinyin'=>'nanling','code'=>'0553','zip_code'=>'242400','first'=>'N','lng'=>'118.33688','lat'=>'30.91969']);
        $this->insert('{{%region}}',['id'=>'1065','pid'=>'1057','shortname'=>'无为','name'=>'无为县','merger_name'=>'中国,安徽省,芜湖市,无为县','level'=>'3','pinyin'=>'wuwei','code'=>'0565','zip_code'=>'238300','first'=>'W','lng'=>'117.911432','lat'=>'31.303075']);
        $this->insert('{{%region}}',['id'=>'1066','pid'=>'1046','shortname'=>'蚌埠','name'=>'蚌埠市','merger_name'=>'中国,安徽省,蚌埠市','level'=>'2','pinyin'=>'bengbu','code'=>'0552','zip_code'=>'233000','first'=>'B','lng'=>'117.36237','lat'=>'32.934037']);
        $this->insert('{{%region}}',['id'=>'1067','pid'=>'1066','shortname'=>'龙子湖','name'=>'龙子湖区','merger_name'=>'中国,安徽省,蚌埠市,龙子湖区','level'=>'3','pinyin'=>'longzihu','code'=>'0552','zip_code'=>'233000','first'=>'L','lng'=>'117.39379','lat'=>'32.94301']);
        $this->insert('{{%region}}',['id'=>'1068','pid'=>'1066','shortname'=>'蚌山','name'=>'蚌山区','merger_name'=>'中国,安徽省,蚌埠市,蚌山区','level'=>'3','pinyin'=>'bengshan','code'=>'0552','zip_code'=>'233000','first'=>'B','lng'=>'117.36767','lat'=>'32.94411']);
        $this->insert('{{%region}}',['id'=>'1069','pid'=>'1066','shortname'=>'禹会','name'=>'禹会区','merger_name'=>'中国,安徽省,蚌埠市,禹会区','level'=>'3','pinyin'=>'yuhui','code'=>'0552','zip_code'=>'233010','first'=>'Y','lng'=>'117.35315','lat'=>'32.93336']);
        $this->insert('{{%region}}',['id'=>'1070','pid'=>'1066','shortname'=>'淮上','name'=>'淮上区','merger_name'=>'中国,安徽省,蚌埠市,淮上区','level'=>'3','pinyin'=>'huaishang','code'=>'0552','zip_code'=>'233002','first'=>'H','lng'=>'117.35983','lat'=>'32.96423']);
        $this->insert('{{%region}}',['id'=>'1071','pid'=>'1066','shortname'=>'怀远','name'=>'怀远县','merger_name'=>'中国,安徽省,蚌埠市,怀远县','level'=>'3','pinyin'=>'huaiyuan','code'=>'0552','zip_code'=>'233400','first'=>'H','lng'=>'117.20507','lat'=>'32.97007']);
        $this->insert('{{%region}}',['id'=>'1072','pid'=>'1066','shortname'=>'五河','name'=>'五河县','merger_name'=>'中国,安徽省,蚌埠市,五河县','level'=>'3','pinyin'=>'wuhe','code'=>'0552','zip_code'=>'233300','first'=>'W','lng'=>'117.89144','lat'=>'33.14457']);
        $this->insert('{{%region}}',['id'=>'1073','pid'=>'1066','shortname'=>'固镇','name'=>'固镇县','merger_name'=>'中国,安徽省,蚌埠市,固镇县','level'=>'3','pinyin'=>'guzhen','code'=>'0552','zip_code'=>'233700','first'=>'G','lng'=>'117.31558','lat'=>'33.31803']);
        $this->insert('{{%region}}',['id'=>'1074','pid'=>'1046','shortname'=>'淮南','name'=>'淮南市','merger_name'=>'中国,安徽省,淮南市','level'=>'2','pinyin'=>'huainan','code'=>'0554','zip_code'=>'232001','first'=>'H','lng'=>'117.025449','lat'=>'32.645947']);
        $this->insert('{{%region}}',['id'=>'1075','pid'=>'1074','shortname'=>'大通','name'=>'大通区','merger_name'=>'中国,安徽省,淮南市,大通区','level'=>'3','pinyin'=>'datong','code'=>'0554','zip_code'=>'232033','first'=>'D','lng'=>'117.05255','lat'=>'32.63265']);
        $this->insert('{{%region}}',['id'=>'1076','pid'=>'1074','shortname'=>'田家庵','name'=>'田家庵区','merger_name'=>'中国,安徽省,淮南市,田家庵区','level'=>'3','pinyin'=>'tianjiaan','code'=>'0554','zip_code'=>'232000','first'=>'T','lng'=>'117.01739','lat'=>'32.64697']);
        $this->insert('{{%region}}',['id'=>'1077','pid'=>'1074','shortname'=>'谢家集','name'=>'谢家集区','merger_name'=>'中国,安徽省,淮南市,谢家集区','level'=>'3','pinyin'=>'xiejiaji','code'=>'0554','zip_code'=>'232052','first'=>'X','lng'=>'116.86377','lat'=>'32.59818']);
        $this->insert('{{%region}}',['id'=>'1078','pid'=>'1074','shortname'=>'八公山','name'=>'八公山区','merger_name'=>'中国,安徽省,淮南市,八公山区','level'=>'3','pinyin'=>'bagongshan','code'=>'0554','zip_code'=>'232072','first'=>'B','lng'=>'116.83694','lat'=>'32.62941']);
        $this->insert('{{%region}}',['id'=>'1079','pid'=>'1074','shortname'=>'潘集','name'=>'潘集区','merger_name'=>'中国,安徽省,淮南市,潘集区','level'=>'3','pinyin'=>'panji','code'=>'0554','zip_code'=>'232082','first'=>'P','lng'=>'116.81622','lat'=>'32.78287']);
        $this->insert('{{%region}}',['id'=>'1080','pid'=>'1074','shortname'=>'凤台','name'=>'凤台县','merger_name'=>'中国,安徽省,淮南市,凤台县','level'=>'3','pinyin'=>'fengtai','code'=>'0554','zip_code'=>'232100','first'=>'F','lng'=>'116.71569','lat'=>'32.70752']);
        $this->insert('{{%region}}',['id'=>'1081','pid'=>'1046','shortname'=>'马鞍山','name'=>'马鞍山市','merger_name'=>'中国,安徽省,马鞍山市','level'=>'2','pinyin'=>'ma\'anshan','code'=>'0555','zip_code'=>'243001','first'=>'M','lng'=>'118.507906','lat'=>'31.689362']);
        $this->insert('{{%region}}',['id'=>'1082','pid'=>'1081','shortname'=>'花山','name'=>'花山区','merger_name'=>'中国,安徽省,马鞍山市,花山区','level'=>'3','pinyin'=>'huashan','code'=>'0555','zip_code'=>'243000','first'=>'H','lng'=>'118.51231','lat'=>'31.7001']);
        $this->insert('{{%region}}',['id'=>'1083','pid'=>'1081','shortname'=>'雨山','name'=>'雨山区','merger_name'=>'中国,安徽省,马鞍山市,雨山区','level'=>'3','pinyin'=>'yushan','code'=>'0555','zip_code'=>'243071','first'=>'Y','lng'=>'118.49869','lat'=>'31.68219']);
        $this->insert('{{%region}}',['id'=>'1084','pid'=>'1081','shortname'=>'博望','name'=>'博望区','merger_name'=>'中国,安徽省,马鞍山市,博望区','level'=>'3','pinyin'=>'bowang','code'=>'0555','zip_code'=>'243131','first'=>'B','lng'=>'118.844387','lat'=>'31.561871']);
        $this->insert('{{%region}}',['id'=>'1085','pid'=>'1081','shortname'=>'当涂','name'=>'当涂县','merger_name'=>'中国,安徽省,马鞍山市,当涂县','level'=>'3','pinyin'=>'dangtu','code'=>'0555','zip_code'=>'243100','first'=>'D','lng'=>'118.49786','lat'=>'31.57098']);
        $this->insert('{{%region}}',['id'=>'1086','pid'=>'1081','shortname'=>'含山','name'=>'含山县','merger_name'=>'中国,安徽省,马鞍山市,含山县','level'=>'3','pinyin'=>'hanshan','code'=>'0555','zip_code'=>'238100','first'=>'H','lng'=>'118.105545','lat'=>'31.727758']);
        $this->insert('{{%region}}',['id'=>'1087','pid'=>'1081','shortname'=>'和县','name'=>'和县','merger_name'=>'中国,安徽省,马鞍山市,和县','level'=>'3','pinyin'=>'hexian','code'=>'0555','zip_code'=>'238200','first'=>'H','lng'=>'118.351405','lat'=>'31.741794']);
        $this->insert('{{%region}}',['id'=>'1088','pid'=>'1046','shortname'=>'淮北','name'=>'淮北市','merger_name'=>'中国,安徽省,淮北市','level'=>'2','pinyin'=>'huaibei','code'=>'0561','zip_code'=>'235000','first'=>'H','lng'=>'116.794664','lat'=>'33.971707']);
        $this->insert('{{%region}}',['id'=>'1089','pid'=>'1088','shortname'=>'杜集','name'=>'杜集区','merger_name'=>'中国,安徽省,淮北市,杜集区','level'=>'3','pinyin'=>'duji','code'=>'0561','zip_code'=>'235000','first'=>'D','lng'=>'116.82998','lat'=>'33.99363']);
        $this->insert('{{%region}}',['id'=>'1090','pid'=>'1088','shortname'=>'相山','name'=>'相山区','merger_name'=>'中国,安徽省,淮北市,相山区','level'=>'3','pinyin'=>'xiangshan','code'=>'0561','zip_code'=>'235000','first'=>'X','lng'=>'116.79464','lat'=>'33.95979']);
        $this->insert('{{%region}}',['id'=>'1091','pid'=>'1088','shortname'=>'烈山','name'=>'烈山区','merger_name'=>'中国,安徽省,淮北市,烈山区','level'=>'3','pinyin'=>'lieshan','code'=>'0561','zip_code'=>'235000','first'=>'L','lng'=>'116.81448','lat'=>'33.89355']);
        $this->insert('{{%region}}',['id'=>'1092','pid'=>'1088','shortname'=>'濉溪','name'=>'濉溪县','merger_name'=>'中国,安徽省,淮北市,濉溪县','level'=>'3','pinyin'=>'suixi','code'=>'0561','zip_code'=>'235100','first'=>NULL,'lng'=>'116.76785','lat'=>'33.91455']);
        $this->insert('{{%region}}',['id'=>'1093','pid'=>'1046','shortname'=>'铜陵','name'=>'铜陵市','merger_name'=>'中国,安徽省,铜陵市','level'=>'2','pinyin'=>'tongling','code'=>'0562','zip_code'=>'244000','first'=>'T','lng'=>'117.816576','lat'=>'30.929935']);
        $this->insert('{{%region}}',['id'=>'1094','pid'=>'1093','shortname'=>'铜官山','name'=>'铜官山区','merger_name'=>'中国,安徽省,铜陵市,铜官山区','level'=>'3','pinyin'=>'tongguanshan','code'=>'0562','zip_code'=>'244000','first'=>'T','lng'=>'117.81525','lat'=>'30.93423']);
        $this->insert('{{%region}}',['id'=>'1095','pid'=>'1093','shortname'=>'狮子山','name'=>'狮子山区','merger_name'=>'中国,安徽省,铜陵市,狮子山区','level'=>'3','pinyin'=>'shizishan','code'=>'0562','zip_code'=>'244000','first'=>'S','lng'=>'117.89178','lat'=>'30.92631']);
        $this->insert('{{%region}}',['id'=>'1096','pid'=>'1093','shortname'=>'郊区','name'=>'郊区','merger_name'=>'中国,安徽省,铜陵市,郊区','level'=>'3','pinyin'=>'jiaoqu','code'=>'0562','zip_code'=>'244000','first'=>'J','lng'=>'117.80868','lat'=>'30.91976']);
        $this->insert('{{%region}}',['id'=>'1097','pid'=>'1093','shortname'=>'铜陵','name'=>'铜陵县','merger_name'=>'中国,安徽省,铜陵市,铜陵县','level'=>'3','pinyin'=>'tongling','code'=>'0562','zip_code'=>'244100','first'=>'T','lng'=>'117.79113','lat'=>'30.95365']);
        $this->insert('{{%region}}',['id'=>'1098','pid'=>'1046','shortname'=>'安庆','name'=>'安庆市','merger_name'=>'中国,安徽省,安庆市','level'=>'2','pinyin'=>'anqing','code'=>'0556','zip_code'=>'246001','first'=>'A','lng'=>'117.053571','lat'=>'30.524816']);
        $this->insert('{{%region}}',['id'=>'1099','pid'=>'1098','shortname'=>'迎江','name'=>'迎江区','merger_name'=>'中国,安徽省,安庆市,迎江区','level'=>'3','pinyin'=>'yingjiang','code'=>'0556','zip_code'=>'246001','first'=>'Y','lng'=>'117.0493','lat'=>'30.50421']);
        $this->insert('{{%region}}',['id'=>'1100','pid'=>'1098','shortname'=>'大观','name'=>'大观区','merger_name'=>'中国,安徽省,安庆市,大观区','level'=>'3','pinyin'=>'daguan','code'=>'0556','zip_code'=>'246002','first'=>'D','lng'=>'117.03426','lat'=>'30.51216']);
        $this->insert('{{%region}}',['id'=>'1101','pid'=>'1098','shortname'=>'宜秀','name'=>'宜秀区','merger_name'=>'中国,安徽省,安庆市,宜秀区','level'=>'3','pinyin'=>'yixiu','code'=>'0556','zip_code'=>'246003','first'=>'Y','lng'=>'117.06127','lat'=>'30.50783']);
        $this->insert('{{%region}}',['id'=>'1102','pid'=>'1098','shortname'=>'怀宁','name'=>'怀宁县','merger_name'=>'中国,安徽省,安庆市,怀宁县','level'=>'3','pinyin'=>'huaining','code'=>'0556','zip_code'=>'246100','first'=>'H','lng'=>'116.82968','lat'=>'30.73376']);
        $this->insert('{{%region}}',['id'=>'1103','pid'=>'1098','shortname'=>'枞阳','name'=>'枞阳县','merger_name'=>'中国,安徽省,安庆市,枞阳县','level'=>'3','pinyin'=>'zongyang','code'=>'0556','zip_code'=>'246700','first'=>NULL,'lng'=>'117.22015','lat'=>'30.69956']);
        $this->insert('{{%region}}',['id'=>'1104','pid'=>'1098','shortname'=>'潜山','name'=>'潜山县','merger_name'=>'中国,安徽省,安庆市,潜山县','level'=>'3','pinyin'=>'qianshan','code'=>'0556','zip_code'=>'246300','first'=>'Q','lng'=>'116.57574','lat'=>'30.63037']);
        $this->insert('{{%region}}',['id'=>'1105','pid'=>'1098','shortname'=>'太湖','name'=>'太湖县','merger_name'=>'中国,安徽省,安庆市,太湖县','level'=>'3','pinyin'=>'taihu','code'=>'0556','zip_code'=>'246400','first'=>'T','lng'=>'116.3088','lat'=>'30.4541']);
        $this->insert('{{%region}}',['id'=>'1106','pid'=>'1098','shortname'=>'宿松','name'=>'宿松县','merger_name'=>'中国,安徽省,安庆市,宿松县','level'=>'3','pinyin'=>'susong','code'=>'0556','zip_code'=>'246500','first'=>'S','lng'=>'116.12915','lat'=>'30.1536']);
        $this->insert('{{%region}}',['id'=>'1107','pid'=>'1098','shortname'=>'望江','name'=>'望江县','merger_name'=>'中国,安徽省,安庆市,望江县','level'=>'3','pinyin'=>'wangjiang','code'=>'0556','zip_code'=>'246200','first'=>'W','lng'=>'116.68814','lat'=>'30.12585']);
        $this->insert('{{%region}}',['id'=>'1108','pid'=>'1098','shortname'=>'岳西','name'=>'岳西县','merger_name'=>'中国,安徽省,安庆市,岳西县','level'=>'3','pinyin'=>'yuexi','code'=>'0556','zip_code'=>'246600','first'=>'Y','lng'=>'116.35995','lat'=>'30.84983']);
        $this->insert('{{%region}}',['id'=>'1109','pid'=>'1098','shortname'=>'桐城','name'=>'桐城市','merger_name'=>'中国,安徽省,安庆市,桐城市','level'=>'3','pinyin'=>'tongcheng','code'=>'0556','zip_code'=>'231400','first'=>'T','lng'=>'116.95071','lat'=>'31.05216']);
        $this->insert('{{%region}}',['id'=>'1110','pid'=>'1046','shortname'=>'黄山','name'=>'黄山市','merger_name'=>'中国,安徽省,黄山市','level'=>'2','pinyin'=>'huangshan','code'=>'0559','zip_code'=>'245000','first'=>'H','lng'=>'118.317325','lat'=>'29.709239']);
        $this->insert('{{%region}}',['id'=>'1111','pid'=>'1110','shortname'=>'屯溪','name'=>'屯溪区','merger_name'=>'中国,安徽省,黄山市,屯溪区','level'=>'3','pinyin'=>'tunxi','code'=>'0559','zip_code'=>'245000','first'=>'T','lng'=>'118.33368','lat'=>'29.71138']);
        $this->insert('{{%region}}',['id'=>'1112','pid'=>'1110','shortname'=>'黄山','name'=>'黄山区','merger_name'=>'中国,安徽省,黄山市,黄山区','level'=>'3','pinyin'=>'huangshan','code'=>'0559','zip_code'=>'242700','first'=>'H','lng'=>'118.1416','lat'=>'30.2729']);
        $this->insert('{{%region}}',['id'=>'1113','pid'=>'1110','shortname'=>'徽州','name'=>'徽州区','merger_name'=>'中国,安徽省,黄山市,徽州区','level'=>'3','pinyin'=>'huizhou','code'=>'0559','zip_code'=>'245061','first'=>'H','lng'=>'118.33654','lat'=>'29.82784']);
        $this->insert('{{%region}}',['id'=>'1114','pid'=>'1110','shortname'=>'歙县','name'=>'歙县','merger_name'=>'中国,安徽省,黄山市,歙县','level'=>'3','pinyin'=>'shexian','code'=>'0559','zip_code'=>'245200','first'=>NULL,'lng'=>'118.43676','lat'=>'29.86745']);
        $this->insert('{{%region}}',['id'=>'1115','pid'=>'1110','shortname'=>'休宁','name'=>'休宁县','merger_name'=>'中国,安徽省,黄山市,休宁县','level'=>'3','pinyin'=>'xiuning','code'=>'0559','zip_code'=>'245400','first'=>'X','lng'=>'118.18136','lat'=>'29.78607']);
        $this->insert('{{%region}}',['id'=>'1116','pid'=>'1110','shortname'=>'黟县','name'=>'黟县','merger_name'=>'中国,安徽省,黄山市,黟县','level'=>'3','pinyin'=>'yixian','code'=>'0559','zip_code'=>'245500','first'=>NULL,'lng'=>'117.94137','lat'=>'29.92588']);
        $this->insert('{{%region}}',['id'=>'1117','pid'=>'1110','shortname'=>'祁门','name'=>'祁门县','merger_name'=>'中国,安徽省,黄山市,祁门县','level'=>'3','pinyin'=>'qimen','code'=>'0559','zip_code'=>'245600','first'=>'Q','lng'=>'117.71847','lat'=>'29.85723']);
        $this->insert('{{%region}}',['id'=>'1118','pid'=>'1046','shortname'=>'滁州','name'=>'滁州市','merger_name'=>'中国,安徽省,滁州市','level'=>'2','pinyin'=>'chuzhou','code'=>'0550','zip_code'=>'239000','first'=>'C','lng'=>'118.316264','lat'=>'32.303627']);
        $this->insert('{{%region}}',['id'=>'1119','pid'=>'1118','shortname'=>'琅琊','name'=>'琅琊区','merger_name'=>'中国,安徽省,滁州市,琅琊区','level'=>'3','pinyin'=>'langya','code'=>'0550','zip_code'=>'239000','first'=>'L','lng'=>'118.30538','lat'=>'32.29521']);
        $this->insert('{{%region}}',['id'=>'1120','pid'=>'1118','shortname'=>'南谯','name'=>'南谯区','merger_name'=>'中国,安徽省,滁州市,南谯区','level'=>'3','pinyin'=>'nanqiao','code'=>'0550','zip_code'=>'239000','first'=>'N','lng'=>'118.31222','lat'=>'32.31861']);
        $this->insert('{{%region}}',['id'=>'1121','pid'=>'1118','shortname'=>'来安','name'=>'来安县','merger_name'=>'中国,安徽省,滁州市,来安县','level'=>'3','pinyin'=>'lai\'an','code'=>'0550','zip_code'=>'239200','first'=>'L','lng'=>'118.43438','lat'=>'32.45176']);
        $this->insert('{{%region}}',['id'=>'1122','pid'=>'1118','shortname'=>'全椒','name'=>'全椒县','merger_name'=>'中国,安徽省,滁州市,全椒县','level'=>'3','pinyin'=>'quanjiao','code'=>'0550','zip_code'=>'239500','first'=>'Q','lng'=>'118.27291','lat'=>'32.08524']);
        $this->insert('{{%region}}',['id'=>'1123','pid'=>'1118','shortname'=>'定远','name'=>'定远县','merger_name'=>'中国,安徽省,滁州市,定远县','level'=>'3','pinyin'=>'dingyuan','code'=>'0550','zip_code'=>'233200','first'=>'D','lng'=>'117.68035','lat'=>'32.52488']);
        $this->insert('{{%region}}',['id'=>'1124','pid'=>'1118','shortname'=>'凤阳','name'=>'凤阳县','merger_name'=>'中国,安徽省,滁州市,凤阳县','level'=>'3','pinyin'=>'fengyang','code'=>'0550','zip_code'=>'233100','first'=>'F','lng'=>'117.56454','lat'=>'32.86507']);
        $this->insert('{{%region}}',['id'=>'1125','pid'=>'1118','shortname'=>'天长','name'=>'天长市','merger_name'=>'中国,安徽省,滁州市,天长市','level'=>'3','pinyin'=>'tianchang','code'=>'0550','zip_code'=>'239300','first'=>'T','lng'=>'118.99868','lat'=>'32.69124']);
        $this->insert('{{%region}}',['id'=>'1126','pid'=>'1118','shortname'=>'明光','name'=>'明光市','merger_name'=>'中国,安徽省,滁州市,明光市','level'=>'3','pinyin'=>'mingguang','code'=>'0550','zip_code'=>'239400','first'=>'M','lng'=>'117.99093','lat'=>'32.77819']);
        $this->insert('{{%region}}',['id'=>'1127','pid'=>'1046','shortname'=>'阜阳','name'=>'阜阳市','merger_name'=>'中国,安徽省,阜阳市','level'=>'2','pinyin'=>'fuyang','code'=>'0558','zip_code'=>'236033','first'=>'F','lng'=>'115.819729','lat'=>'32.896969']);
        $this->insert('{{%region}}',['id'=>'1128','pid'=>'1127','shortname'=>'颍州','name'=>'颍州区','merger_name'=>'中国,安徽省,阜阳市,颍州区','level'=>'3','pinyin'=>'yingzhou','code'=>'0558','zip_code'=>'236001','first'=>NULL,'lng'=>'115.80694','lat'=>'32.88346']);
        $this->insert('{{%region}}',['id'=>'1129','pid'=>'1127','shortname'=>'颍东','name'=>'颍东区','merger_name'=>'中国,安徽省,阜阳市,颍东区','level'=>'3','pinyin'=>'yingdong','code'=>'0558','zip_code'=>'236058','first'=>NULL,'lng'=>'115.85659','lat'=>'32.91296']);
        $this->insert('{{%region}}',['id'=>'1130','pid'=>'1127','shortname'=>'颍泉','name'=>'颍泉区','merger_name'=>'中国,安徽省,阜阳市,颍泉区','level'=>'3','pinyin'=>'yingquan','code'=>'0558','zip_code'=>'236045','first'=>NULL,'lng'=>'115.80712','lat'=>'32.9249']);
        $this->insert('{{%region}}',['id'=>'1131','pid'=>'1127','shortname'=>'临泉','name'=>'临泉县','merger_name'=>'中国,安徽省,阜阳市,临泉县','level'=>'3','pinyin'=>'linquan','code'=>'0558','zip_code'=>'236400','first'=>'L','lng'=>'115.26232','lat'=>'33.06758']);
        $this->insert('{{%region}}',['id'=>'1132','pid'=>'1127','shortname'=>'太和','name'=>'太和县','merger_name'=>'中国,安徽省,阜阳市,太和县','level'=>'3','pinyin'=>'taihe','code'=>'0558','zip_code'=>'236600','first'=>'T','lng'=>'115.62191','lat'=>'33.16025']);
        $this->insert('{{%region}}',['id'=>'1133','pid'=>'1127','shortname'=>'阜南','name'=>'阜南县','merger_name'=>'中国,安徽省,阜阳市,阜南县','level'=>'3','pinyin'=>'funan','code'=>'0558','zip_code'=>'236300','first'=>'F','lng'=>'115.58563','lat'=>'32.63551']);
        $this->insert('{{%region}}',['id'=>'1134','pid'=>'1127','shortname'=>'颍上','name'=>'颍上县','merger_name'=>'中国,安徽省,阜阳市,颍上县','level'=>'3','pinyin'=>'yingshang','code'=>'0558','zip_code'=>'236200','first'=>NULL,'lng'=>'116.26458','lat'=>'32.62998']);
        $this->insert('{{%region}}',['id'=>'1135','pid'=>'1127','shortname'=>'界首','name'=>'界首市','merger_name'=>'中国,安徽省,阜阳市,界首市','level'=>'3','pinyin'=>'jieshou','code'=>'0558','zip_code'=>'236500','first'=>'J','lng'=>'115.37445','lat'=>'33.25714']);
        $this->insert('{{%region}}',['id'=>'1136','pid'=>'1046','shortname'=>'宿州','name'=>'宿州市','merger_name'=>'中国,安徽省,宿州市','level'=>'2','pinyin'=>'suzhou','code'=>'0557','zip_code'=>'234000','first'=>'S','lng'=>'116.984084','lat'=>'33.633891']);
        $this->insert('{{%region}}',['id'=>'1137','pid'=>'1136','shortname'=>'埇桥','name'=>'埇桥区','merger_name'=>'中国,安徽省,宿州市,埇桥区','level'=>'3','pinyin'=>'yongqiao','code'=>'0557','zip_code'=>'234000','first'=>NULL,'lng'=>'116.97731','lat'=>'33.64058']);
        $this->insert('{{%region}}',['id'=>'1138','pid'=>'1136','shortname'=>'砀山','name'=>'砀山县','merger_name'=>'中国,安徽省,宿州市,砀山县','level'=>'3','pinyin'=>'dangshan','code'=>'0557','zip_code'=>'235300','first'=>NULL,'lng'=>'116.35363','lat'=>'34.42356']);
        $this->insert('{{%region}}',['id'=>'1139','pid'=>'1136','shortname'=>'萧县','name'=>'萧县','merger_name'=>'中国,安徽省,宿州市,萧县','level'=>'3','pinyin'=>'xiaoxian','code'=>'0557','zip_code'=>'235200','first'=>'X','lng'=>'116.94546','lat'=>'34.1879']);
        $this->insert('{{%region}}',['id'=>'1140','pid'=>'1136','shortname'=>'灵璧','name'=>'灵璧县','merger_name'=>'中国,安徽省,宿州市,灵璧县','level'=>'3','pinyin'=>'lingbi','code'=>'0557','zip_code'=>'234200','first'=>'L','lng'=>'117.55813','lat'=>'33.54339']);
        $this->insert('{{%region}}',['id'=>'1141','pid'=>'1136','shortname'=>'泗县','name'=>'泗县','merger_name'=>'中国,安徽省,宿州市,泗县','level'=>'3','pinyin'=>'sixian','code'=>'0557','zip_code'=>'234300','first'=>NULL,'lng'=>'117.91033','lat'=>'33.48295']);
        $this->insert('{{%region}}',['id'=>'1142','pid'=>'1046','shortname'=>'六安','name'=>'六安市','merger_name'=>'中国,安徽省,六安市','level'=>'2','pinyin'=>'lu\'an','code'=>'0564','zip_code'=>'237000','first'=>'L','lng'=>'116.507676','lat'=>'31.752889']);
        $this->insert('{{%region}}',['id'=>'1143','pid'=>'1142','shortname'=>'金安','name'=>'金安区','merger_name'=>'中国,安徽省,六安市,金安区','level'=>'3','pinyin'=>'jin\'an','code'=>'0564','zip_code'=>'237005','first'=>'J','lng'=>'116.50912','lat'=>'31.75573']);
        $this->insert('{{%region}}',['id'=>'1144','pid'=>'1142','shortname'=>'裕安','name'=>'裕安区','merger_name'=>'中国,安徽省,六安市,裕安区','level'=>'3','pinyin'=>'yu\'an','code'=>'0564','zip_code'=>'237010','first'=>'Y','lng'=>'116.47985','lat'=>'31.73787']);
        $this->insert('{{%region}}',['id'=>'1145','pid'=>'1142','shortname'=>'寿县','name'=>'寿县','merger_name'=>'中国,安徽省,六安市,寿县','level'=>'3','pinyin'=>'shouxian','code'=>'0564','zip_code'=>'232200','first'=>'S','lng'=>'116.78466','lat'=>'32.57653']);
        $this->insert('{{%region}}',['id'=>'1146','pid'=>'1142','shortname'=>'霍邱','name'=>'霍邱县','merger_name'=>'中国,安徽省,六安市,霍邱县','level'=>'3','pinyin'=>'huoqiu','code'=>'0564','zip_code'=>'237400','first'=>'H','lng'=>'116.27795','lat'=>'32.353']);
        $this->insert('{{%region}}',['id'=>'1147','pid'=>'1142','shortname'=>'舒城','name'=>'舒城县','merger_name'=>'中国,安徽省,六安市,舒城县','level'=>'3','pinyin'=>'shucheng','code'=>'0564','zip_code'=>'231300','first'=>'S','lng'=>'116.94491','lat'=>'31.46413']);
        $this->insert('{{%region}}',['id'=>'1148','pid'=>'1142','shortname'=>'金寨','name'=>'金寨县','merger_name'=>'中国,安徽省,六安市,金寨县','level'=>'3','pinyin'=>'jinzhai','code'=>'0564','zip_code'=>'237300','first'=>'J','lng'=>'115.93463','lat'=>'31.7351']);
        $this->insert('{{%region}}',['id'=>'1149','pid'=>'1142','shortname'=>'霍山','name'=>'霍山县','merger_name'=>'中国,安徽省,六安市,霍山县','level'=>'3','pinyin'=>'huoshan','code'=>'0564','zip_code'=>'237200','first'=>'H','lng'=>'116.33291','lat'=>'31.3929']);
        $this->insert('{{%region}}',['id'=>'1150','pid'=>'1046','shortname'=>'亳州','name'=>'亳州市','merger_name'=>'中国,安徽省,亳州市','level'=>'2','pinyin'=>'bozhou','code'=>'0558','zip_code'=>'236802','first'=>NULL,'lng'=>'115.782939','lat'=>'33.869338']);
        $this->insert('{{%region}}',['id'=>'1151','pid'=>'1150','shortname'=>'谯城','name'=>'谯城区','merger_name'=>'中国,安徽省,亳州市,谯城区','level'=>'3','pinyin'=>'qiaocheng','code'=>'0558','zip_code'=>'236800','first'=>NULL,'lng'=>'115.77941','lat'=>'33.87532']);
        $this->insert('{{%region}}',['id'=>'1152','pid'=>'1150','shortname'=>'涡阳','name'=>'涡阳县','merger_name'=>'中国,安徽省,亳州市,涡阳县','level'=>'3','pinyin'=>'guoyang','code'=>'0558','zip_code'=>'233600','first'=>'W','lng'=>'116.21682','lat'=>'33.50911']);
        $this->insert('{{%region}}',['id'=>'1153','pid'=>'1150','shortname'=>'蒙城','name'=>'蒙城县','merger_name'=>'中国,安徽省,亳州市,蒙城县','level'=>'3','pinyin'=>'mengcheng','code'=>'0558','zip_code'=>'233500','first'=>'M','lng'=>'116.5646','lat'=>'33.26477']);
        $this->insert('{{%region}}',['id'=>'1154','pid'=>'1150','shortname'=>'利辛','name'=>'利辛县','merger_name'=>'中国,安徽省,亳州市,利辛县','level'=>'3','pinyin'=>'lixin','code'=>'0558','zip_code'=>'236700','first'=>'L','lng'=>'116.208','lat'=>'33.14198']);
        $this->insert('{{%region}}',['id'=>'1155','pid'=>'1046','shortname'=>'池州','name'=>'池州市','merger_name'=>'中国,安徽省,池州市','level'=>'2','pinyin'=>'chizhou','code'=>'0566','zip_code'=>'247100','first'=>'C','lng'=>'117.489157','lat'=>'30.656037']);
        $this->insert('{{%region}}',['id'=>'1156','pid'=>'1155','shortname'=>'贵池','name'=>'贵池区','merger_name'=>'中国,安徽省,池州市,贵池区','level'=>'3','pinyin'=>'guichi','code'=>'0566','zip_code'=>'247100','first'=>'G','lng'=>'117.48722','lat'=>'30.65283']);
        $this->insert('{{%region}}',['id'=>'1157','pid'=>'1155','shortname'=>'东至','name'=>'东至县','merger_name'=>'中国,安徽省,池州市,东至县','level'=>'3','pinyin'=>'dongzhi','code'=>'0566','zip_code'=>'247200','first'=>'D','lng'=>'117.02719','lat'=>'30.0969']);
        $this->insert('{{%region}}',['id'=>'1158','pid'=>'1155','shortname'=>'石台','name'=>'石台县','merger_name'=>'中国,安徽省,池州市,石台县','level'=>'3','pinyin'=>'shitai','code'=>'0566','zip_code'=>'245100','first'=>'S','lng'=>'117.48666','lat'=>'30.21042']);
        $this->insert('{{%region}}',['id'=>'1159','pid'=>'1155','shortname'=>'青阳','name'=>'青阳县','merger_name'=>'中国,安徽省,池州市,青阳县','level'=>'3','pinyin'=>'qingyang','code'=>'0566','zip_code'=>'242800','first'=>'Q','lng'=>'117.84744','lat'=>'30.63932']);
        $this->insert('{{%region}}',['id'=>'1160','pid'=>'1046','shortname'=>'宣城','name'=>'宣城市','merger_name'=>'中国,安徽省,宣城市','level'=>'2','pinyin'=>'xuancheng','code'=>'0563','zip_code'=>'242000','first'=>'X','lng'=>'118.757995','lat'=>'30.945667']);
        $this->insert('{{%region}}',['id'=>'1161','pid'=>'1160','shortname'=>'宣州','name'=>'宣州区','merger_name'=>'中国,安徽省,宣城市,宣州区','level'=>'3','pinyin'=>'xuanzhou','code'=>'0563','zip_code'=>'242000','first'=>'X','lng'=>'118.75462','lat'=>'30.94439']);
        $this->insert('{{%region}}',['id'=>'1162','pid'=>'1160','shortname'=>'郎溪','name'=>'郎溪县','merger_name'=>'中国,安徽省,宣城市,郎溪县','level'=>'3','pinyin'=>'langxi','code'=>'0563','zip_code'=>'242100','first'=>'L','lng'=>'119.17923','lat'=>'31.12599']);
        $this->insert('{{%region}}',['id'=>'1163','pid'=>'1160','shortname'=>'广德','name'=>'广德县','merger_name'=>'中国,安徽省,宣城市,广德县','level'=>'3','pinyin'=>'guangde','code'=>'0563','zip_code'=>'242200','first'=>'G','lng'=>'119.41769','lat'=>'30.89371']);
        $this->insert('{{%region}}',['id'=>'1164','pid'=>'1160','shortname'=>'泾县','name'=>'泾县','merger_name'=>'中国,安徽省,宣城市,泾县','level'=>'3','pinyin'=>'jingxian','code'=>'0563','zip_code'=>'242500','first'=>NULL,'lng'=>'118.41964','lat'=>'30.69498']);
        $this->insert('{{%region}}',['id'=>'1165','pid'=>'1160','shortname'=>'绩溪','name'=>'绩溪县','merger_name'=>'中国,安徽省,宣城市,绩溪县','level'=>'3','pinyin'=>'jixi','code'=>'0563','zip_code'=>'245300','first'=>'J','lng'=>'118.59765','lat'=>'30.07069']);
        $this->insert('{{%region}}',['id'=>'1166','pid'=>'1160','shortname'=>'旌德','name'=>'旌德县','merger_name'=>'中国,安徽省,宣城市,旌德县','level'=>'3','pinyin'=>'jingde','code'=>'0563','zip_code'=>'242600','first'=>NULL,'lng'=>'118.54299','lat'=>'30.28898']);
        $this->insert('{{%region}}',['id'=>'1167','pid'=>'1160','shortname'=>'宁国','name'=>'宁国市','merger_name'=>'中国,安徽省,宣城市,宁国市','level'=>'3','pinyin'=>'ningguo','code'=>'0563','zip_code'=>'242300','first'=>'N','lng'=>'118.98349','lat'=>'30.6238']);
        $this->insert('{{%region}}',['id'=>'1168','pid'=>'0','shortname'=>'福建','name'=>'福建省','merger_name'=>'中国,福建省','level'=>'1','pinyin'=>'fujian','code'=>'','zip_code'=>'','first'=>'F','lng'=>'119.306239','lat'=>'26.075302']);
        $this->insert('{{%region}}',['id'=>'1169','pid'=>'1168','shortname'=>'福州','name'=>'福州市','merger_name'=>'中国,福建省,福州市','level'=>'2','pinyin'=>'fuzhou','code'=>'0591','zip_code'=>'350001','first'=>'F','lng'=>'119.306239','lat'=>'26.075302']);
        $this->insert('{{%region}}',['id'=>'1170','pid'=>'1169','shortname'=>'鼓楼','name'=>'鼓楼区','merger_name'=>'中国,福建省,福州市,鼓楼区','level'=>'3','pinyin'=>'gulou','code'=>'0591','zip_code'=>'350001','first'=>'G','lng'=>'119.30384','lat'=>'26.08225']);
        $this->insert('{{%region}}',['id'=>'1171','pid'=>'1169','shortname'=>'台江','name'=>'台江区','merger_name'=>'中国,福建省,福州市,台江区','level'=>'3','pinyin'=>'taijiang','code'=>'0591','zip_code'=>'350004','first'=>'T','lng'=>'119.30899','lat'=>'26.06204']);
        $this->insert('{{%region}}',['id'=>'1172','pid'=>'1169','shortname'=>'仓山','name'=>'仓山区','merger_name'=>'中国,福建省,福州市,仓山区','level'=>'3','pinyin'=>'cangshan','code'=>'0591','zip_code'=>'350007','first'=>'C','lng'=>'119.31543','lat'=>'26.04335']);
        $this->insert('{{%region}}',['id'=>'1173','pid'=>'1169','shortname'=>'马尾','name'=>'马尾区','merger_name'=>'中国,福建省,福州市,马尾区','level'=>'3','pinyin'=>'mawei','code'=>'0591','zip_code'=>'350015','first'=>'M','lng'=>'119.4555','lat'=>'25.98942']);
        $this->insert('{{%region}}',['id'=>'1174','pid'=>'1169','shortname'=>'晋安','name'=>'晋安区','merger_name'=>'中国,福建省,福州市,晋安区','level'=>'3','pinyin'=>'jin\'an','code'=>'0591','zip_code'=>'350011','first'=>'J','lng'=>'119.32828','lat'=>'26.0818']);
        $this->insert('{{%region}}',['id'=>'1175','pid'=>'1169','shortname'=>'闽侯','name'=>'闽侯县','merger_name'=>'中国,福建省,福州市,闽侯县','level'=>'3','pinyin'=>'minhou','code'=>'0591','zip_code'=>'350100','first'=>'M','lng'=>'119.13388','lat'=>'26.15014']);
        $this->insert('{{%region}}',['id'=>'1176','pid'=>'1169','shortname'=>'连江','name'=>'连江县','merger_name'=>'中国,福建省,福州市,连江县','level'=>'3','pinyin'=>'lianjiang','code'=>'0591','zip_code'=>'350500','first'=>'L','lng'=>'119.53433','lat'=>'26.19466']);
        $this->insert('{{%region}}',['id'=>'1177','pid'=>'1169','shortname'=>'罗源','name'=>'罗源县','merger_name'=>'中国,福建省,福州市,罗源县','level'=>'3','pinyin'=>'luoyuan','code'=>'0591','zip_code'=>'350600','first'=>'L','lng'=>'119.5509','lat'=>'26.48752']);
        $this->insert('{{%region}}',['id'=>'1178','pid'=>'1169','shortname'=>'闽清','name'=>'闽清县','merger_name'=>'中国,福建省,福州市,闽清县','level'=>'3','pinyin'=>'minqing','code'=>'0591','zip_code'=>'350800','first'=>'M','lng'=>'118.8623','lat'=>'26.21901']);
        $this->insert('{{%region}}',['id'=>'1179','pid'=>'1169','shortname'=>'永泰','name'=>'永泰县','merger_name'=>'中国,福建省,福州市,永泰县','level'=>'3','pinyin'=>'yongtai','code'=>'0591','zip_code'=>'350700','first'=>'Y','lng'=>'118.936','lat'=>'25.86816']);
        $this->insert('{{%region}}',['id'=>'1180','pid'=>'1169','shortname'=>'平潭','name'=>'平潭县','merger_name'=>'中国,福建省,福州市,平潭县','level'=>'3','pinyin'=>'pingtan','code'=>'0591','zip_code'=>'350400','first'=>'P','lng'=>'119.791197','lat'=>'25.503672']);
        $this->insert('{{%region}}',['id'=>'1181','pid'=>'1169','shortname'=>'福清','name'=>'福清市','merger_name'=>'中国,福建省,福州市,福清市','level'=>'3','pinyin'=>'fuqing','code'=>'0591','zip_code'=>'350300','first'=>'F','lng'=>'119.38507','lat'=>'25.72086']);
        $this->insert('{{%region}}',['id'=>'1182','pid'=>'1169','shortname'=>'长乐','name'=>'长乐市','merger_name'=>'中国,福建省,福州市,长乐市','level'=>'3','pinyin'=>'changle','code'=>'0591','zip_code'=>'350200','first'=>'C','lng'=>'119.52313','lat'=>'25.96276']);
        $this->insert('{{%region}}',['id'=>'1183','pid'=>'1168','shortname'=>'厦门','name'=>'厦门市','merger_name'=>'中国,福建省,厦门市','level'=>'2','pinyin'=>'xiamen','code'=>'0592','zip_code'=>'361003','first'=>'X','lng'=>'118.11022','lat'=>'24.490474']);
        $this->insert('{{%region}}',['id'=>'1184','pid'=>'1183','shortname'=>'思明','name'=>'思明区','merger_name'=>'中国,福建省,厦门市,思明区','level'=>'3','pinyin'=>'siming','code'=>'0592','zip_code'=>'361001','first'=>'S','lng'=>'118.08233','lat'=>'24.44543']);
        $this->insert('{{%region}}',['id'=>'1185','pid'=>'1183','shortname'=>'海沧','name'=>'海沧区','merger_name'=>'中国,福建省,厦门市,海沧区','level'=>'3','pinyin'=>'haicang','code'=>'0592','zip_code'=>'361026','first'=>'H','lng'=>'118.03289','lat'=>'24.48461']);
        $this->insert('{{%region}}',['id'=>'1186','pid'=>'1183','shortname'=>'湖里','name'=>'湖里区','merger_name'=>'中国,福建省,厦门市,湖里区','level'=>'3','pinyin'=>'huli','code'=>'0592','zip_code'=>'361006','first'=>'H','lng'=>'118.14621','lat'=>'24.51253']);
        $this->insert('{{%region}}',['id'=>'1187','pid'=>'1183','shortname'=>'集美','name'=>'集美区','merger_name'=>'中国,福建省,厦门市,集美区','level'=>'3','pinyin'=>'jimei','code'=>'0592','zip_code'=>'361021','first'=>'J','lng'=>'118.09719','lat'=>'24.57584']);
        $this->insert('{{%region}}',['id'=>'1188','pid'=>'1183','shortname'=>'同安','name'=>'同安区','merger_name'=>'中国,福建省,厦门市,同安区','level'=>'3','pinyin'=>'tong\'an','code'=>'0592','zip_code'=>'361100','first'=>'T','lng'=>'118.15197','lat'=>'24.72308']);
        $this->insert('{{%region}}',['id'=>'1189','pid'=>'1183','shortname'=>'翔安','name'=>'翔安区','merger_name'=>'中国,福建省,厦门市,翔安区','level'=>'3','pinyin'=>'xiang\'an','code'=>'0592','zip_code'=>'361101','first'=>'X','lng'=>'118.24783','lat'=>'24.61863']);
        $this->insert('{{%region}}',['id'=>'1190','pid'=>'1168','shortname'=>'莆田','name'=>'莆田市','merger_name'=>'中国,福建省,莆田市','level'=>'2','pinyin'=>'putian','code'=>'0594','zip_code'=>'351100','first'=>'P','lng'=>'119.007558','lat'=>'25.431011']);
        $this->insert('{{%region}}',['id'=>'1191','pid'=>'1190','shortname'=>'城厢','name'=>'城厢区','merger_name'=>'中国,福建省,莆田市,城厢区','level'=>'3','pinyin'=>'chengxiang','code'=>'0594','zip_code'=>'351100','first'=>'C','lng'=>'118.99462','lat'=>'25.41872']);
        $this->insert('{{%region}}',['id'=>'1192','pid'=>'1190','shortname'=>'涵江','name'=>'涵江区','merger_name'=>'中国,福建省,莆田市,涵江区','level'=>'3','pinyin'=>'hanjiang','code'=>'0594','zip_code'=>'351111','first'=>'H','lng'=>'119.11621','lat'=>'25.45876']);
        $this->insert('{{%region}}',['id'=>'1193','pid'=>'1190','shortname'=>'荔城','name'=>'荔城区','merger_name'=>'中国,福建省,莆田市,荔城区','level'=>'3','pinyin'=>'licheng','code'=>'0594','zip_code'=>'351100','first'=>'L','lng'=>'119.01339','lat'=>'25.43369']);
        $this->insert('{{%region}}',['id'=>'1194','pid'=>'1190','shortname'=>'秀屿','name'=>'秀屿区','merger_name'=>'中国,福建省,莆田市,秀屿区','level'=>'3','pinyin'=>'xiuyu','code'=>'0594','zip_code'=>'351152','first'=>'X','lng'=>'119.10553','lat'=>'25.31831']);
        $this->insert('{{%region}}',['id'=>'1195','pid'=>'1190','shortname'=>'仙游','name'=>'仙游县','merger_name'=>'中国,福建省,莆田市,仙游县','level'=>'3','pinyin'=>'xianyou','code'=>'0594','zip_code'=>'351200','first'=>'X','lng'=>'118.69177','lat'=>'25.36214']);
        $this->insert('{{%region}}',['id'=>'1196','pid'=>'1168','shortname'=>'三明','name'=>'三明市','merger_name'=>'中国,福建省,三明市','level'=>'2','pinyin'=>'sanming','code'=>'0598','zip_code'=>'365000','first'=>'S','lng'=>'117.635001','lat'=>'26.265444']);
        $this->insert('{{%region}}',['id'=>'1197','pid'=>'1196','shortname'=>'梅列','name'=>'梅列区','merger_name'=>'中国,福建省,三明市,梅列区','level'=>'3','pinyin'=>'meilie','code'=>'0598','zip_code'=>'365000','first'=>'M','lng'=>'117.64585','lat'=>'26.27171']);
        $this->insert('{{%region}}',['id'=>'1198','pid'=>'1196','shortname'=>'三元','name'=>'三元区','merger_name'=>'中国,福建省,三明市,三元区','level'=>'3','pinyin'=>'sanyuan','code'=>'0598','zip_code'=>'365001','first'=>'S','lng'=>'117.60788','lat'=>'26.23372']);
        $this->insert('{{%region}}',['id'=>'1199','pid'=>'1196','shortname'=>'明溪','name'=>'明溪县','merger_name'=>'中国,福建省,三明市,明溪县','level'=>'3','pinyin'=>'mingxi','code'=>'0598','zip_code'=>'365200','first'=>'M','lng'=>'117.20498','lat'=>'26.35294']);
        $this->insert('{{%region}}',['id'=>'1200','pid'=>'1196','shortname'=>'清流','name'=>'清流县','merger_name'=>'中国,福建省,三明市,清流县','level'=>'3','pinyin'=>'qingliu','code'=>'0598','zip_code'=>'365300','first'=>'Q','lng'=>'116.8146','lat'=>'26.17144']);
        $this->insert('{{%region}}',['id'=>'1201','pid'=>'1196','shortname'=>'宁化','name'=>'宁化县','merger_name'=>'中国,福建省,三明市,宁化县','level'=>'3','pinyin'=>'ninghua','code'=>'0598','zip_code'=>'365400','first'=>'N','lng'=>'116.66101','lat'=>'26.25874']);
        $this->insert('{{%region}}',['id'=>'1202','pid'=>'1196','shortname'=>'大田','name'=>'大田县','merger_name'=>'中国,福建省,三明市,大田县','level'=>'3','pinyin'=>'datian','code'=>'0598','zip_code'=>'366100','first'=>'D','lng'=>'117.8471','lat'=>'25.6926']);
        $this->insert('{{%region}}',['id'=>'1203','pid'=>'1196','shortname'=>'尤溪','name'=>'尤溪县','merger_name'=>'中国,福建省,三明市,尤溪县','level'=>'3','pinyin'=>'youxi','code'=>'0598','zip_code'=>'365100','first'=>'Y','lng'=>'118.19049','lat'=>'26.17002']);
        $this->insert('{{%region}}',['id'=>'1204','pid'=>'1196','shortname'=>'沙县','name'=>'沙县','merger_name'=>'中国,福建省,三明市,沙县','level'=>'3','pinyin'=>'shaxian','code'=>'0598','zip_code'=>'365500','first'=>'S','lng'=>'117.79266','lat'=>'26.39615']);
        $this->insert('{{%region}}',['id'=>'1205','pid'=>'1196','shortname'=>'将乐','name'=>'将乐县','merger_name'=>'中国,福建省,三明市,将乐县','level'=>'3','pinyin'=>'jiangle','code'=>'0598','zip_code'=>'353300','first'=>'J','lng'=>'117.47317','lat'=>'26.72837']);
        $this->insert('{{%region}}',['id'=>'1206','pid'=>'1196','shortname'=>'泰宁','name'=>'泰宁县','merger_name'=>'中国,福建省,三明市,泰宁县','level'=>'3','pinyin'=>'taining','code'=>'0598','zip_code'=>'354400','first'=>'T','lng'=>'117.17578','lat'=>'26.9001']);
        $this->insert('{{%region}}',['id'=>'1207','pid'=>'1196','shortname'=>'建宁','name'=>'建宁县','merger_name'=>'中国,福建省,三明市,建宁县','level'=>'3','pinyin'=>'jianning','code'=>'0598','zip_code'=>'354500','first'=>'J','lng'=>'116.84603','lat'=>'26.83091']);
        $this->insert('{{%region}}',['id'=>'1208','pid'=>'1196','shortname'=>'永安','name'=>'永安市','merger_name'=>'中国,福建省,三明市,永安市','level'=>'3','pinyin'=>'yong\'an','code'=>'0598','zip_code'=>'366000','first'=>'Y','lng'=>'117.36517','lat'=>'25.94136']);
        $this->insert('{{%region}}',['id'=>'1209','pid'=>'1168','shortname'=>'泉州','name'=>'泉州市','merger_name'=>'中国,福建省,泉州市','level'=>'2','pinyin'=>'quanzhou','code'=>'0595','zip_code'=>'362000','first'=>'Q','lng'=>'118.589421','lat'=>'24.908853']);
        $this->insert('{{%region}}',['id'=>'1210','pid'=>'1209','shortname'=>'鲤城','name'=>'鲤城区','merger_name'=>'中国,福建省,泉州市,鲤城区','level'=>'3','pinyin'=>'licheng','code'=>'0595','zip_code'=>'362000','first'=>'L','lng'=>'118.56591','lat'=>'24.88741']);
        $this->insert('{{%region}}',['id'=>'1211','pid'=>'1209','shortname'=>'丰泽','name'=>'丰泽区','merger_name'=>'中国,福建省,泉州市,丰泽区','level'=>'3','pinyin'=>'fengze','code'=>'0595','zip_code'=>'362000','first'=>'F','lng'=>'118.61328','lat'=>'24.89119']);
        $this->insert('{{%region}}',['id'=>'1212','pid'=>'1209','shortname'=>'洛江','name'=>'洛江区','merger_name'=>'中国,福建省,泉州市,洛江区','level'=>'3','pinyin'=>'luojiang','code'=>'0595','zip_code'=>'362011','first'=>'L','lng'=>'118.67111','lat'=>'24.93984']);
        $this->insert('{{%region}}',['id'=>'1213','pid'=>'1209','shortname'=>'泉港','name'=>'泉港区','merger_name'=>'中国,福建省,泉州市,泉港区','level'=>'3','pinyin'=>'quangang','code'=>'0595','zip_code'=>'362114','first'=>'Q','lng'=>'118.91586','lat'=>'25.12005']);
        $this->insert('{{%region}}',['id'=>'1214','pid'=>'1209','shortname'=>'惠安','name'=>'惠安县','merger_name'=>'中国,福建省,泉州市,惠安县','level'=>'3','pinyin'=>'hui\'an','code'=>'0595','zip_code'=>'362100','first'=>'H','lng'=>'118.79687','lat'=>'25.03059']);
        $this->insert('{{%region}}',['id'=>'1215','pid'=>'1209','shortname'=>'安溪','name'=>'安溪县','merger_name'=>'中国,福建省,泉州市,安溪县','level'=>'3','pinyin'=>'anxi','code'=>'0595','zip_code'=>'362400','first'=>'A','lng'=>'118.18719','lat'=>'25.05627']);
        $this->insert('{{%region}}',['id'=>'1216','pid'=>'1209','shortname'=>'永春','name'=>'永春县','merger_name'=>'中国,福建省,泉州市,永春县','level'=>'3','pinyin'=>'yongchun','code'=>'0595','zip_code'=>'362600','first'=>'Y','lng'=>'118.29437','lat'=>'25.32183']);
        $this->insert('{{%region}}',['id'=>'1217','pid'=>'1209','shortname'=>'德化','name'=>'德化县','merger_name'=>'中国,福建省,泉州市,德化县','level'=>'3','pinyin'=>'dehua','code'=>'0595','zip_code'=>'362500','first'=>'D','lng'=>'118.24176','lat'=>'25.49224']);
        $this->insert('{{%region}}',['id'=>'1218','pid'=>'1209','shortname'=>'金门','name'=>'金门县','merger_name'=>'中国,福建省,泉州市,金门县','level'=>'3','pinyin'=>'jinmen','code'=>'','zip_code'=>'','first'=>'J','lng'=>'118.32263','lat'=>'24.42922']);
        $this->insert('{{%region}}',['id'=>'1219','pid'=>'1209','shortname'=>'石狮','name'=>'石狮市','merger_name'=>'中国,福建省,泉州市,石狮市','level'=>'3','pinyin'=>'shishi','code'=>'0595','zip_code'=>'362700','first'=>'S','lng'=>'118.64779','lat'=>'24.73242']);
        $this->insert('{{%region}}',['id'=>'1220','pid'=>'1209','shortname'=>'晋江','name'=>'晋江市','merger_name'=>'中国,福建省,泉州市,晋江市','level'=>'3','pinyin'=>'jinjiang','code'=>'0595','zip_code'=>'362200','first'=>'J','lng'=>'118.55194','lat'=>'24.78141']);
        $this->insert('{{%region}}',['id'=>'1221','pid'=>'1209','shortname'=>'南安','name'=>'南安市','merger_name'=>'中国,福建省,泉州市,南安市','level'=>'3','pinyin'=>'nan\'an','code'=>'0595','zip_code'=>'362300','first'=>'N','lng'=>'118.38589','lat'=>'24.96055']);
        $this->insert('{{%region}}',['id'=>'1222','pid'=>'1168','shortname'=>'漳州','name'=>'漳州市','merger_name'=>'中国,福建省,漳州市','level'=>'2','pinyin'=>'zhangzhou','code'=>'0596','zip_code'=>'363005','first'=>'Z','lng'=>'117.661801','lat'=>'24.510897']);
        $this->insert('{{%region}}',['id'=>'1223','pid'=>'1222','shortname'=>'芗城','name'=>'芗城区','merger_name'=>'中国,福建省,漳州市,芗城区','level'=>'3','pinyin'=>'xiangcheng','code'=>'0596','zip_code'=>'363000','first'=>NULL,'lng'=>'117.65402','lat'=>'24.51081']);
        $this->insert('{{%region}}',['id'=>'1224','pid'=>'1222','shortname'=>'龙文','name'=>'龙文区','merger_name'=>'中国,福建省,漳州市,龙文区','level'=>'3','pinyin'=>'longwen','code'=>'0596','zip_code'=>'363005','first'=>'L','lng'=>'117.70971','lat'=>'24.50323']);
        $this->insert('{{%region}}',['id'=>'1225','pid'=>'1222','shortname'=>'云霄','name'=>'云霄县','merger_name'=>'中国,福建省,漳州市,云霄县','level'=>'3','pinyin'=>'yunxiao','code'=>'0596','zip_code'=>'363300','first'=>'Y','lng'=>'117.34051','lat'=>'23.95534']);
        $this->insert('{{%region}}',['id'=>'1226','pid'=>'1222','shortname'=>'漳浦','name'=>'漳浦县','merger_name'=>'中国,福建省,漳州市,漳浦县','level'=>'3','pinyin'=>'zhangpu','code'=>'0596','zip_code'=>'363200','first'=>'Z','lng'=>'117.61367','lat'=>'24.11706']);
        $this->insert('{{%region}}',['id'=>'1227','pid'=>'1222','shortname'=>'诏安','name'=>'诏安县','merger_name'=>'中国,福建省,漳州市,诏安县','level'=>'3','pinyin'=>'zhao\'an','code'=>'0596','zip_code'=>'363500','first'=>NULL,'lng'=>'117.17501','lat'=>'23.71148']);
        $this->insert('{{%region}}',['id'=>'1228','pid'=>'1222','shortname'=>'长泰','name'=>'长泰县','merger_name'=>'中国,福建省,漳州市,长泰县','level'=>'3','pinyin'=>'changtai','code'=>'0596','zip_code'=>'363900','first'=>'C','lng'=>'117.75924','lat'=>'24.62526']);
        $this->insert('{{%region}}',['id'=>'1229','pid'=>'1222','shortname'=>'东山','name'=>'东山县','merger_name'=>'中国,福建省,漳州市,东山县','level'=>'3','pinyin'=>'dongshan','code'=>'0596','zip_code'=>'363400','first'=>'D','lng'=>'117.42822','lat'=>'23.70109']);
        $this->insert('{{%region}}',['id'=>'1230','pid'=>'1222','shortname'=>'南靖','name'=>'南靖县','merger_name'=>'中国,福建省,漳州市,南靖县','level'=>'3','pinyin'=>'nanjing','code'=>'0596','zip_code'=>'363600','first'=>'N','lng'=>'117.35736','lat'=>'24.51448']);
        $this->insert('{{%region}}',['id'=>'1231','pid'=>'1222','shortname'=>'平和','name'=>'平和县','merger_name'=>'中国,福建省,漳州市,平和县','level'=>'3','pinyin'=>'pinghe','code'=>'0596','zip_code'=>'363700','first'=>'P','lng'=>'117.3124','lat'=>'24.36395']);
        $this->insert('{{%region}}',['id'=>'1232','pid'=>'1222','shortname'=>'华安','name'=>'华安县','merger_name'=>'中国,福建省,漳州市,华安县','level'=>'3','pinyin'=>'hua\'an','code'=>'0596','zip_code'=>'363800','first'=>'H','lng'=>'117.54077','lat'=>'25.00563']);
        $this->insert('{{%region}}',['id'=>'1233','pid'=>'1222','shortname'=>'龙海','name'=>'龙海市','merger_name'=>'中国,福建省,漳州市,龙海市','level'=>'3','pinyin'=>'longhai','code'=>'0596','zip_code'=>'363100','first'=>'L','lng'=>'117.81802','lat'=>'24.44655']);
        $this->insert('{{%region}}',['id'=>'1234','pid'=>'1168','shortname'=>'南平','name'=>'南平市','merger_name'=>'中国,福建省,南平市','level'=>'2','pinyin'=>'nanping','code'=>'0599','zip_code'=>'353000','first'=>'N','lng'=>'118.178459','lat'=>'26.635627']);
        $this->insert('{{%region}}',['id'=>'1235','pid'=>'1234','shortname'=>'延平','name'=>'延平区','merger_name'=>'中国,福建省,南平市,延平区','level'=>'3','pinyin'=>'yanping','code'=>'0600','zip_code'=>'353000','first'=>'Y','lng'=>'118.18189','lat'=>'26.63745']);
        $this->insert('{{%region}}',['id'=>'1236','pid'=>'1234','shortname'=>'建阳','name'=>'建阳区','merger_name'=>'中国,福建省,南平市,建阳区','level'=>'3','pinyin'=>'jianyang','code'=>'0599','zip_code'=>'354200','first'=>'J','lng'=>'118.12267','lat'=>'27.332067']);
        $this->insert('{{%region}}',['id'=>'1237','pid'=>'1234','shortname'=>'顺昌','name'=>'顺昌县','merger_name'=>'中国,福建省,南平市,顺昌县','level'=>'3','pinyin'=>'shunchang','code'=>'0605','zip_code'=>'353200','first'=>'S','lng'=>'117.8103','lat'=>'26.79298']);
        $this->insert('{{%region}}',['id'=>'1238','pid'=>'1234','shortname'=>'浦城','name'=>'浦城县','merger_name'=>'中国,福建省,南平市,浦城县','level'=>'3','pinyin'=>'pucheng','code'=>'0606','zip_code'=>'353400','first'=>'P','lng'=>'118.54007','lat'=>'27.91888']);
        $this->insert('{{%region}}',['id'=>'1239','pid'=>'1234','shortname'=>'光泽','name'=>'光泽县','merger_name'=>'中国,福建省,南平市,光泽县','level'=>'3','pinyin'=>'guangze','code'=>'0607','zip_code'=>'354100','first'=>'G','lng'=>'117.33346','lat'=>'27.54231']);
        $this->insert('{{%region}}',['id'=>'1240','pid'=>'1234','shortname'=>'松溪','name'=>'松溪县','merger_name'=>'中国,福建省,南平市,松溪县','level'=>'3','pinyin'=>'songxi','code'=>'0608','zip_code'=>'353500','first'=>'S','lng'=>'118.78533','lat'=>'27.52624']);
        $this->insert('{{%region}}',['id'=>'1241','pid'=>'1234','shortname'=>'政和','name'=>'政和县','merger_name'=>'中国,福建省,南平市,政和县','level'=>'3','pinyin'=>'zhenghe','code'=>'0609','zip_code'=>'353600','first'=>'Z','lng'=>'118.85571','lat'=>'27.36769']);
        $this->insert('{{%region}}',['id'=>'1242','pid'=>'1234','shortname'=>'邵武','name'=>'邵武市','merger_name'=>'中国,福建省,南平市,邵武市','level'=>'3','pinyin'=>'shaowu','code'=>'0601','zip_code'=>'354000','first'=>'S','lng'=>'117.4924','lat'=>'27.34033']);
        $this->insert('{{%region}}',['id'=>'1243','pid'=>'1234','shortname'=>'武夷山','name'=>'武夷山市','merger_name'=>'中国,福建省,南平市,武夷山市','level'=>'3','pinyin'=>'wuyishan','code'=>'0602','zip_code'=>'354300','first'=>'W','lng'=>'118.03665','lat'=>'27.75543']);
        $this->insert('{{%region}}',['id'=>'1244','pid'=>'1234','shortname'=>'建瓯','name'=>'建瓯市','merger_name'=>'中国,福建省,南平市,建瓯市','level'=>'3','pinyin'=>'jianou','code'=>'0603','zip_code'=>'353100','first'=>'J','lng'=>'118.29766','lat'=>'27.02301']);
        $this->insert('{{%region}}',['id'=>'1245','pid'=>'1168','shortname'=>'龙岩','name'=>'龙岩市','merger_name'=>'中国,福建省,龙岩市','level'=>'2','pinyin'=>'longyan','code'=>'0597','zip_code'=>'364000','first'=>'L','lng'=>'117.02978','lat'=>'25.091603']);
        $this->insert('{{%region}}',['id'=>'1246','pid'=>'1245','shortname'=>'新罗','name'=>'新罗区','merger_name'=>'中国,福建省,龙岩市,新罗区','level'=>'3','pinyin'=>'xinluo','code'=>'0597','zip_code'=>'364000','first'=>'X','lng'=>'117.03693','lat'=>'25.09834']);
        $this->insert('{{%region}}',['id'=>'1247','pid'=>'1245','shortname'=>'长汀','name'=>'长汀县','merger_name'=>'中国,福建省,龙岩市,长汀县','level'=>'3','pinyin'=>'changting','code'=>'0597','zip_code'=>'366300','first'=>'C','lng'=>'116.35888','lat'=>'25.82773']);
        $this->insert('{{%region}}',['id'=>'1248','pid'=>'1245','shortname'=>'永定','name'=>'永定区','merger_name'=>'中国,福建省,龙岩市,永定区','level'=>'3','pinyin'=>'yongding','code'=>'0597','zip_code'=>'364100','first'=>'Y','lng'=>'116.73199','lat'=>'24.72302']);
        $this->insert('{{%region}}',['id'=>'1249','pid'=>'1245','shortname'=>'上杭','name'=>'上杭县','merger_name'=>'中国,福建省,龙岩市,上杭县','level'=>'3','pinyin'=>'shanghang','code'=>'0597','zip_code'=>'364200','first'=>'S','lng'=>'116.42022','lat'=>'25.04943']);
        $this->insert('{{%region}}',['id'=>'1250','pid'=>'1245','shortname'=>'武平','name'=>'武平县','merger_name'=>'中国,福建省,龙岩市,武平县','level'=>'3','pinyin'=>'wuping','code'=>'0597','zip_code'=>'364300','first'=>'W','lng'=>'116.10229','lat'=>'25.09244']);
        $this->insert('{{%region}}',['id'=>'1251','pid'=>'1245','shortname'=>'连城','name'=>'连城县','merger_name'=>'中国,福建省,龙岩市,连城县','level'=>'3','pinyin'=>'liancheng','code'=>'0597','zip_code'=>'366200','first'=>'L','lng'=>'116.75454','lat'=>'25.7103']);
        $this->insert('{{%region}}',['id'=>'1252','pid'=>'1245','shortname'=>'漳平','name'=>'漳平市','merger_name'=>'中国,福建省,龙岩市,漳平市','level'=>'3','pinyin'=>'zhangping','code'=>'0597','zip_code'=>'364400','first'=>'Z','lng'=>'117.41992','lat'=>'25.29109']);
        $this->insert('{{%region}}',['id'=>'1253','pid'=>'1168','shortname'=>'宁德','name'=>'宁德市','merger_name'=>'中国,福建省,宁德市','level'=>'2','pinyin'=>'ningde','code'=>'0593','zip_code'=>'352100','first'=>'N','lng'=>'119.527082','lat'=>'26.65924']);
        $this->insert('{{%region}}',['id'=>'1254','pid'=>'1253','shortname'=>'蕉城','name'=>'蕉城区','merger_name'=>'中国,福建省,宁德市,蕉城区','level'=>'3','pinyin'=>'jiaocheng','code'=>'0593','zip_code'=>'352100','first'=>'J','lng'=>'119.52643','lat'=>'26.66048']);
        $this->insert('{{%region}}',['id'=>'1255','pid'=>'1253','shortname'=>'霞浦','name'=>'霞浦县','merger_name'=>'中国,福建省,宁德市,霞浦县','level'=>'3','pinyin'=>'xiapu','code'=>'0593','zip_code'=>'355100','first'=>'X','lng'=>'119.99893','lat'=>'26.88578']);
        $this->insert('{{%region}}',['id'=>'1256','pid'=>'1253','shortname'=>'古田','name'=>'古田县','merger_name'=>'中国,福建省,宁德市,古田县','level'=>'3','pinyin'=>'gutian','code'=>'0593','zip_code'=>'352200','first'=>'G','lng'=>'118.74688','lat'=>'26.57682']);
        $this->insert('{{%region}}',['id'=>'1257','pid'=>'1253','shortname'=>'屏南','name'=>'屏南县','merger_name'=>'中国,福建省,宁德市,屏南县','level'=>'3','pinyin'=>'pingnan','code'=>'0593','zip_code'=>'352300','first'=>'P','lng'=>'118.98861','lat'=>'26.91099']);
        $this->insert('{{%region}}',['id'=>'1258','pid'=>'1253','shortname'=>'寿宁','name'=>'寿宁县','merger_name'=>'中国,福建省,宁德市,寿宁县','level'=>'3','pinyin'=>'shouning','code'=>'0593','zip_code'=>'355500','first'=>'S','lng'=>'119.5039','lat'=>'27.45996']);
        $this->insert('{{%region}}',['id'=>'1259','pid'=>'1253','shortname'=>'周宁','name'=>'周宁县','merger_name'=>'中国,福建省,宁德市,周宁县','level'=>'3','pinyin'=>'zhouning','code'=>'0593','zip_code'=>'355400','first'=>'Z','lng'=>'119.33837','lat'=>'27.10664']);
        $this->insert('{{%region}}',['id'=>'1260','pid'=>'1253','shortname'=>'柘荣','name'=>'柘荣县','merger_name'=>'中国,福建省,宁德市,柘荣县','level'=>'3','pinyin'=>'zherong','code'=>'0593','zip_code'=>'355300','first'=>NULL,'lng'=>'119.89971','lat'=>'27.23543']);
        $this->insert('{{%region}}',['id'=>'1261','pid'=>'1253','shortname'=>'福安','name'=>'福安市','merger_name'=>'中国,福建省,宁德市,福安市','level'=>'3','pinyin'=>'fu\'an','code'=>'0593','zip_code'=>'355000','first'=>'F','lng'=>'119.6495','lat'=>'27.08673']);
        $this->insert('{{%region}}',['id'=>'1262','pid'=>'1253','shortname'=>'福鼎','name'=>'福鼎市','merger_name'=>'中国,福建省,宁德市,福鼎市','level'=>'3','pinyin'=>'fuding','code'=>'0593','zip_code'=>'355200','first'=>'F','lng'=>'120.21664','lat'=>'27.3243']);
        $this->insert('{{%region}}',['id'=>'1263','pid'=>'0','shortname'=>'江西','name'=>'江西省','merger_name'=>'中国,江西省','level'=>'1','pinyin'=>'jiangxi','code'=>'','zip_code'=>'','first'=>'J','lng'=>'115.892151','lat'=>'28.676493']);
        $this->insert('{{%region}}',['id'=>'1264','pid'=>'1263','shortname'=>'南昌','name'=>'南昌市','merger_name'=>'中国,江西省,南昌市','level'=>'2','pinyin'=>'nanchang','code'=>'0791','zip_code'=>'330008','first'=>'N','lng'=>'115.892151','lat'=>'28.676493']);
        $this->insert('{{%region}}',['id'=>'1265','pid'=>'1264','shortname'=>'东湖','name'=>'东湖区','merger_name'=>'中国,江西省,南昌市,东湖区','level'=>'3','pinyin'=>'donghu','code'=>'0791','zip_code'=>'330006','first'=>'D','lng'=>'115.8988','lat'=>'28.68505']);
        $this->insert('{{%region}}',['id'=>'1266','pid'=>'1264','shortname'=>'西湖','name'=>'西湖区','merger_name'=>'中国,江西省,南昌市,西湖区','level'=>'3','pinyin'=>'xihu','code'=>'0791','zip_code'=>'330009','first'=>'X','lng'=>'115.87728','lat'=>'28.65688']);
        $this->insert('{{%region}}',['id'=>'1267','pid'=>'1264','shortname'=>'青云谱','name'=>'青云谱区','merger_name'=>'中国,江西省,南昌市,青云谱区','level'=>'3','pinyin'=>'qingyunpu','code'=>'0791','zip_code'=>'330001','first'=>'Q','lng'=>'115.915','lat'=>'28.63199']);
        $this->insert('{{%region}}',['id'=>'1268','pid'=>'1264','shortname'=>'湾里','name'=>'湾里区','merger_name'=>'中国,江西省,南昌市,湾里区','level'=>'3','pinyin'=>'wanli','code'=>'0791','zip_code'=>'330004','first'=>'W','lng'=>'115.73104','lat'=>'28.71529']);
        $this->insert('{{%region}}',['id'=>'1269','pid'=>'1264','shortname'=>'青山湖','name'=>'青山湖区','merger_name'=>'中国,江西省,南昌市,青山湖区','level'=>'3','pinyin'=>'qingshanhu','code'=>'0791','zip_code'=>'330029','first'=>'Q','lng'=>'115.9617','lat'=>'28.68206']);
        $this->insert('{{%region}}',['id'=>'1270','pid'=>'1264','shortname'=>'南昌','name'=>'南昌县','merger_name'=>'中国,江西省,南昌市,南昌县','level'=>'3','pinyin'=>'nanchang','code'=>'0791','zip_code'=>'330200','first'=>'N','lng'=>'115.94393','lat'=>'28.54559']);
        $this->insert('{{%region}}',['id'=>'1271','pid'=>'1264','shortname'=>'新建','name'=>'新建县','merger_name'=>'中国,江西省,南昌市,新建县','level'=>'3','pinyin'=>'xinjian','code'=>'0791','zip_code'=>'330100','first'=>'X','lng'=>'115.81546','lat'=>'28.69248']);
        $this->insert('{{%region}}',['id'=>'1272','pid'=>'1264','shortname'=>'安义','name'=>'安义县','merger_name'=>'中国,江西省,南昌市,安义县','level'=>'3','pinyin'=>'anyi','code'=>'0791','zip_code'=>'330500','first'=>'A','lng'=>'115.54879','lat'=>'28.84602']);
        $this->insert('{{%region}}',['id'=>'1273','pid'=>'1264','shortname'=>'进贤','name'=>'进贤县','merger_name'=>'中国,江西省,南昌市,进贤县','level'=>'3','pinyin'=>'jinxian','code'=>'0791','zip_code'=>'331700','first'=>'J','lng'=>'116.24087','lat'=>'28.37679']);
        $this->insert('{{%region}}',['id'=>'1274','pid'=>'1263','shortname'=>'景德镇','name'=>'景德镇市','merger_name'=>'中国,江西省,景德镇市','level'=>'2','pinyin'=>'jingdezhen','code'=>'0798','zip_code'=>'333000','first'=>'J','lng'=>'117.214664','lat'=>'29.29256']);
        $this->insert('{{%region}}',['id'=>'1275','pid'=>'1274','shortname'=>'昌江','name'=>'昌江区','merger_name'=>'中国,江西省,景德镇市,昌江区','level'=>'3','pinyin'=>'changjiang','code'=>'0799','zip_code'=>'333000','first'=>'C','lng'=>'117.18359','lat'=>'29.27321']);
        $this->insert('{{%region}}',['id'=>'1276','pid'=>'1274','shortname'=>'珠山','name'=>'珠山区','merger_name'=>'中国,江西省,景德镇市,珠山区','level'=>'3','pinyin'=>'zhushan','code'=>'0800','zip_code'=>'333000','first'=>'Z','lng'=>'117.20233','lat'=>'29.30127']);
        $this->insert('{{%region}}',['id'=>'1277','pid'=>'1274','shortname'=>'浮梁','name'=>'浮梁县','merger_name'=>'中国,江西省,景德镇市,浮梁县','level'=>'3','pinyin'=>'fuliang','code'=>'0802','zip_code'=>'333400','first'=>'F','lng'=>'117.21517','lat'=>'29.35156']);
        $this->insert('{{%region}}',['id'=>'1278','pid'=>'1274','shortname'=>'乐平','name'=>'乐平市','merger_name'=>'中国,江西省,景德镇市,乐平市','level'=>'3','pinyin'=>'leping','code'=>'0801','zip_code'=>'333300','first'=>'L','lng'=>'117.12887','lat'=>'28.96295']);
        $this->insert('{{%region}}',['id'=>'1279','pid'=>'1263','shortname'=>'萍乡','name'=>'萍乡市','merger_name'=>'中国,江西省,萍乡市','level'=>'2','pinyin'=>'pingxiang','code'=>'0799','zip_code'=>'337000','first'=>'P','lng'=>'113.852186','lat'=>'27.622946']);
        $this->insert('{{%region}}',['id'=>'1280','pid'=>'1279','shortname'=>'安源','name'=>'安源区','merger_name'=>'中国,江西省,萍乡市,安源区','level'=>'3','pinyin'=>'anyuan','code'=>'0800','zip_code'=>'337000','first'=>'A','lng'=>'113.89135','lat'=>'27.61653']);
        $this->insert('{{%region}}',['id'=>'1281','pid'=>'1279','shortname'=>'湘东','name'=>'湘东区','merger_name'=>'中国,江西省,萍乡市,湘东区','level'=>'3','pinyin'=>'xiangdong','code'=>'0801','zip_code'=>'337016','first'=>'X','lng'=>'113.73294','lat'=>'27.64007']);
        $this->insert('{{%region}}',['id'=>'1282','pid'=>'1279','shortname'=>'莲花','name'=>'莲花县','merger_name'=>'中国,江西省,萍乡市,莲花县','level'=>'3','pinyin'=>'lianhua','code'=>'0802','zip_code'=>'337100','first'=>'L','lng'=>'113.96142','lat'=>'27.12866']);
        $this->insert('{{%region}}',['id'=>'1283','pid'=>'1279','shortname'=>'上栗','name'=>'上栗县','merger_name'=>'中国,江西省,萍乡市,上栗县','level'=>'3','pinyin'=>'shangli','code'=>'0803','zip_code'=>'337009','first'=>'S','lng'=>'113.79403','lat'=>'27.87467']);
        $this->insert('{{%region}}',['id'=>'1284','pid'=>'1279','shortname'=>'芦溪','name'=>'芦溪县','merger_name'=>'中国,江西省,萍乡市,芦溪县','level'=>'3','pinyin'=>'luxi','code'=>'0804','zip_code'=>'337053','first'=>'L','lng'=>'114.02951','lat'=>'27.63063']);
        $this->insert('{{%region}}',['id'=>'1285','pid'=>'1263','shortname'=>'九江','name'=>'九江市','merger_name'=>'中国,江西省,九江市','level'=>'2','pinyin'=>'jiujiang','code'=>'0792','zip_code'=>'332000','first'=>'J','lng'=>'115.992811','lat'=>'29.712034']);
        $this->insert('{{%region}}',['id'=>'1286','pid'=>'1285','shortname'=>'庐山','name'=>'庐山区','merger_name'=>'中国,江西省,九江市,庐山区','level'=>'3','pinyin'=>'lushan','code'=>'0792','zip_code'=>'332005','first'=>'L','lng'=>'115.98904','lat'=>'29.67177']);
        $this->insert('{{%region}}',['id'=>'1287','pid'=>'1285','shortname'=>'浔阳','name'=>'浔阳区','merger_name'=>'中国,江西省,九江市,浔阳区','level'=>'3','pinyin'=>'xunyang','code'=>'0792','zip_code'=>'332000','first'=>NULL,'lng'=>'115.98986','lat'=>'29.72786']);
        $this->insert('{{%region}}',['id'=>'1288','pid'=>'1285','shortname'=>'九江','name'=>'九江县','merger_name'=>'中国,江西省,九江市,九江县','level'=>'3','pinyin'=>'jiujiang','code'=>'0792','zip_code'=>'332100','first'=>'J','lng'=>'115.91128','lat'=>'29.60852']);
        $this->insert('{{%region}}',['id'=>'1289','pid'=>'1285','shortname'=>'武宁','name'=>'武宁县','merger_name'=>'中国,江西省,九江市,武宁县','level'=>'3','pinyin'=>'wuning','code'=>'0792','zip_code'=>'332300','first'=>'W','lng'=>'115.10061','lat'=>'29.2584']);
        $this->insert('{{%region}}',['id'=>'1290','pid'=>'1285','shortname'=>'修水','name'=>'修水县','merger_name'=>'中国,江西省,九江市,修水县','level'=>'3','pinyin'=>'xiushui','code'=>'0792','zip_code'=>'332400','first'=>'X','lng'=>'114.54684','lat'=>'29.02539']);
        $this->insert('{{%region}}',['id'=>'1291','pid'=>'1285','shortname'=>'永修','name'=>'永修县','merger_name'=>'中国,江西省,九江市,永修县','level'=>'3','pinyin'=>'yongxiu','code'=>'0792','zip_code'=>'330300','first'=>'Y','lng'=>'115.80911','lat'=>'29.02093']);
        $this->insert('{{%region}}',['id'=>'1292','pid'=>'1285','shortname'=>'德安','name'=>'德安县','merger_name'=>'中国,江西省,九江市,德安县','level'=>'3','pinyin'=>'de\'an','code'=>'0792','zip_code'=>'330400','first'=>'D','lng'=>'115.75601','lat'=>'29.31341']);
        $this->insert('{{%region}}',['id'=>'1293','pid'=>'1285','shortname'=>'星子','name'=>'星子县','merger_name'=>'中国,江西省,九江市,星子县','level'=>'3','pinyin'=>'xingzi','code'=>'0792','zip_code'=>'332800','first'=>'X','lng'=>'116.04492','lat'=>'29.44608']);
        $this->insert('{{%region}}',['id'=>'1294','pid'=>'1285','shortname'=>'都昌','name'=>'都昌县','merger_name'=>'中国,江西省,九江市,都昌县','level'=>'3','pinyin'=>'duchang','code'=>'0792','zip_code'=>'332600','first'=>'D','lng'=>'116.20401','lat'=>'29.27327']);
        $this->insert('{{%region}}',['id'=>'1295','pid'=>'1285','shortname'=>'湖口','name'=>'湖口县','merger_name'=>'中国,江西省,九江市,湖口县','level'=>'3','pinyin'=>'hukou','code'=>'0792','zip_code'=>'332500','first'=>'H','lng'=>'116.21853','lat'=>'29.73818']);
        $this->insert('{{%region}}',['id'=>'1296','pid'=>'1285','shortname'=>'彭泽','name'=>'彭泽县','merger_name'=>'中国,江西省,九江市,彭泽县','level'=>'3','pinyin'=>'pengze','code'=>'0792','zip_code'=>'332700','first'=>'P','lng'=>'116.55011','lat'=>'29.89589']);
        $this->insert('{{%region}}',['id'=>'1297','pid'=>'1285','shortname'=>'瑞昌','name'=>'瑞昌市','merger_name'=>'中国,江西省,九江市,瑞昌市','level'=>'3','pinyin'=>'ruichang','code'=>'0792','zip_code'=>'332200','first'=>'R','lng'=>'115.66705','lat'=>'29.67183']);
        $this->insert('{{%region}}',['id'=>'1298','pid'=>'1285','shortname'=>'共青城','name'=>'共青城市','merger_name'=>'中国,江西省,九江市,共青城市','level'=>'3','pinyin'=>'gongqingcheng','code'=>'0792','zip_code'=>'332020','first'=>'G','lng'=>'115.801939','lat'=>'29.238785']);
        $this->insert('{{%region}}',['id'=>'1299','pid'=>'1263','shortname'=>'新余','name'=>'新余市','merger_name'=>'中国,江西省,新余市','level'=>'2','pinyin'=>'xinyu','code'=>'0790','zip_code'=>'338025','first'=>'X','lng'=>'114.930835','lat'=>'27.810834']);
        $this->insert('{{%region}}',['id'=>'1300','pid'=>'1299','shortname'=>'渝水','name'=>'渝水区','merger_name'=>'中国,江西省,新余市,渝水区','level'=>'3','pinyin'=>'yushui','code'=>'0790','zip_code'=>'338025','first'=>'Y','lng'=>'114.944','lat'=>'27.80098']);
        $this->insert('{{%region}}',['id'=>'1301','pid'=>'1299','shortname'=>'分宜','name'=>'分宜县','merger_name'=>'中国,江西省,新余市,分宜县','level'=>'3','pinyin'=>'fenyi','code'=>'0790','zip_code'=>'336600','first'=>'F','lng'=>'114.69189','lat'=>'27.81475']);
        $this->insert('{{%region}}',['id'=>'1302','pid'=>'1263','shortname'=>'鹰潭','name'=>'鹰潭市','merger_name'=>'中国,江西省,鹰潭市','level'=>'2','pinyin'=>'yingtan','code'=>'0701','zip_code'=>'335000','first'=>'Y','lng'=>'117.033838','lat'=>'28.238638']);
        $this->insert('{{%region}}',['id'=>'1303','pid'=>'1302','shortname'=>'月湖','name'=>'月湖区','merger_name'=>'中国,江西省,鹰潭市,月湖区','level'=>'3','pinyin'=>'yuehu','code'=>'0701','zip_code'=>'335000','first'=>'Y','lng'=>'117.03732','lat'=>'28.23913']);
        $this->insert('{{%region}}',['id'=>'1304','pid'=>'1302','shortname'=>'余江','name'=>'余江县','merger_name'=>'中国,江西省,鹰潭市,余江县','level'=>'3','pinyin'=>'yujiang','code'=>'0701','zip_code'=>'335200','first'=>'Y','lng'=>'116.81851','lat'=>'28.21034']);
        $this->insert('{{%region}}',['id'=>'1305','pid'=>'1302','shortname'=>'贵溪','name'=>'贵溪市','merger_name'=>'中国,江西省,鹰潭市,贵溪市','level'=>'3','pinyin'=>'guixi','code'=>'0701','zip_code'=>'335400','first'=>'G','lng'=>'117.24246','lat'=>'28.2926']);
        $this->insert('{{%region}}',['id'=>'1306','pid'=>'1263','shortname'=>'赣州','name'=>'赣州市','merger_name'=>'中国,江西省,赣州市','level'=>'2','pinyin'=>'ganzhou','code'=>'0797','zip_code'=>'341000','first'=>'G','lng'=>'114.940278','lat'=>'25.85097']);
        $this->insert('{{%region}}',['id'=>'1307','pid'=>'1306','shortname'=>'章贡','name'=>'章贡区','merger_name'=>'中国,江西省,赣州市,章贡区','level'=>'3','pinyin'=>'zhanggong','code'=>'0797','zip_code'=>'341000','first'=>'Z','lng'=>'114.94284','lat'=>'25.8624']);
        $this->insert('{{%region}}',['id'=>'1308','pid'=>'1306','shortname'=>'南康','name'=>'南康区','merger_name'=>'中国,江西省,赣州市,南康区','level'=>'3','pinyin'=>'nankang','code'=>'0797','zip_code'=>'341400','first'=>'N','lng'=>'114.756933','lat'=>'25.661721']);
        $this->insert('{{%region}}',['id'=>'1309','pid'=>'1306','shortname'=>'赣县','name'=>'赣县','merger_name'=>'中国,江西省,赣州市,赣县','level'=>'3','pinyin'=>'ganxian','code'=>'0797','zip_code'=>'341100','first'=>'G','lng'=>'115.01171','lat'=>'25.86149']);
        $this->insert('{{%region}}',['id'=>'1310','pid'=>'1306','shortname'=>'信丰','name'=>'信丰县','merger_name'=>'中国,江西省,赣州市,信丰县','level'=>'3','pinyin'=>'xinfeng','code'=>'0797','zip_code'=>'341600','first'=>'X','lng'=>'114.92279','lat'=>'25.38612']);
        $this->insert('{{%region}}',['id'=>'1311','pid'=>'1306','shortname'=>'大余','name'=>'大余县','merger_name'=>'中国,江西省,赣州市,大余县','level'=>'3','pinyin'=>'dayu','code'=>'0797','zip_code'=>'341500','first'=>'D','lng'=>'114.35757','lat'=>'25.39561']);
        $this->insert('{{%region}}',['id'=>'1312','pid'=>'1306','shortname'=>'上犹','name'=>'上犹县','merger_name'=>'中国,江西省,赣州市,上犹县','level'=>'3','pinyin'=>'shangyou','code'=>'0797','zip_code'=>'341200','first'=>'S','lng'=>'114.54138','lat'=>'25.79567']);
        $this->insert('{{%region}}',['id'=>'1313','pid'=>'1306','shortname'=>'崇义','name'=>'崇义县','merger_name'=>'中国,江西省,赣州市,崇义县','level'=>'3','pinyin'=>'chongyi','code'=>'0797','zip_code'=>'341300','first'=>'C','lng'=>'114.30835','lat'=>'25.68186']);
        $this->insert('{{%region}}',['id'=>'1314','pid'=>'1306','shortname'=>'安远','name'=>'安远县','merger_name'=>'中国,江西省,赣州市,安远县','level'=>'3','pinyin'=>'anyuan','code'=>'0797','zip_code'=>'342100','first'=>'A','lng'=>'115.39483','lat'=>'25.1371']);
        $this->insert('{{%region}}',['id'=>'1315','pid'=>'1306','shortname'=>'龙南','name'=>'龙南县','merger_name'=>'中国,江西省,赣州市,龙南县','level'=>'3','pinyin'=>'longnan','code'=>'0797','zip_code'=>'341700','first'=>'L','lng'=>'114.78994','lat'=>'24.91086']);
        $this->insert('{{%region}}',['id'=>'1316','pid'=>'1306','shortname'=>'定南','name'=>'定南县','merger_name'=>'中国,江西省,赣州市,定南县','level'=>'3','pinyin'=>'dingnan','code'=>'0797','zip_code'=>'341900','first'=>'D','lng'=>'115.02713','lat'=>'24.78395']);
        $this->insert('{{%region}}',['id'=>'1317','pid'=>'1306','shortname'=>'全南','name'=>'全南县','merger_name'=>'中国,江西省,赣州市,全南县','level'=>'3','pinyin'=>'quannan','code'=>'0797','zip_code'=>'341800','first'=>'Q','lng'=>'114.5292','lat'=>'24.74324']);
        $this->insert('{{%region}}',['id'=>'1318','pid'=>'1306','shortname'=>'宁都','name'=>'宁都县','merger_name'=>'中国,江西省,赣州市,宁都县','level'=>'3','pinyin'=>'ningdu','code'=>'0797','zip_code'=>'342800','first'=>'N','lng'=>'116.01565','lat'=>'26.47227']);
        $this->insert('{{%region}}',['id'=>'1319','pid'=>'1306','shortname'=>'于都','name'=>'于都县','merger_name'=>'中国,江西省,赣州市,于都县','level'=>'3','pinyin'=>'yudu','code'=>'0797','zip_code'=>'342300','first'=>'Y','lng'=>'115.41415','lat'=>'25.95257']);
        $this->insert('{{%region}}',['id'=>'1320','pid'=>'1306','shortname'=>'兴国','name'=>'兴国县','merger_name'=>'中国,江西省,赣州市,兴国县','level'=>'3','pinyin'=>'xingguo','code'=>'0797','zip_code'=>'342400','first'=>'X','lng'=>'115.36309','lat'=>'26.33776']);
        $this->insert('{{%region}}',['id'=>'1321','pid'=>'1306','shortname'=>'会昌','name'=>'会昌县','merger_name'=>'中国,江西省,赣州市,会昌县','level'=>'3','pinyin'=>'huichang','code'=>'0797','zip_code'=>'342600','first'=>'H','lng'=>'115.78555','lat'=>'25.60068']);
        $this->insert('{{%region}}',['id'=>'1322','pid'=>'1306','shortname'=>'寻乌','name'=>'寻乌县','merger_name'=>'中国,江西省,赣州市,寻乌县','level'=>'3','pinyin'=>'xunwu','code'=>'0797','zip_code'=>'342200','first'=>'X','lng'=>'115.64852','lat'=>'24.95513']);
        $this->insert('{{%region}}',['id'=>'1323','pid'=>'1306','shortname'=>'石城','name'=>'石城县','merger_name'=>'中国,江西省,赣州市,石城县','level'=>'3','pinyin'=>'shicheng','code'=>'0797','zip_code'=>'342700','first'=>'S','lng'=>'116.3442','lat'=>'26.32617']);
        $this->insert('{{%region}}',['id'=>'1324','pid'=>'1306','shortname'=>'瑞金','name'=>'瑞金市','merger_name'=>'中国,江西省,赣州市,瑞金市','level'=>'3','pinyin'=>'ruijin','code'=>'0797','zip_code'=>'342500','first'=>'R','lng'=>'116.02703','lat'=>'25.88557']);
        $this->insert('{{%region}}',['id'=>'1325','pid'=>'1263','shortname'=>'吉安','name'=>'吉安市','merger_name'=>'中国,江西省,吉安市','level'=>'2','pinyin'=>'ji\'an','code'=>'0796','zip_code'=>'343000','first'=>'J','lng'=>'114.986373','lat'=>'27.111699']);
        $this->insert('{{%region}}',['id'=>'1326','pid'=>'1325','shortname'=>'吉州','name'=>'吉州区','merger_name'=>'中国,江西省,吉安市,吉州区','level'=>'3','pinyin'=>'jizhou','code'=>'0796','zip_code'=>'343000','first'=>'J','lng'=>'114.97598','lat'=>'27.10669']);
        $this->insert('{{%region}}',['id'=>'1327','pid'=>'1325','shortname'=>'青原','name'=>'青原区','merger_name'=>'中国,江西省,吉安市,青原区','level'=>'3','pinyin'=>'qingyuan','code'=>'0796','zip_code'=>'343009','first'=>'Q','lng'=>'115.01747','lat'=>'27.10577']);
        $this->insert('{{%region}}',['id'=>'1328','pid'=>'1325','shortname'=>'吉安','name'=>'吉安县','merger_name'=>'中国,江西省,吉安市,吉安县','level'=>'3','pinyin'=>'ji\'an','code'=>'0796','zip_code'=>'343100','first'=>'J','lng'=>'114.90695','lat'=>'27.04048']);
        $this->insert('{{%region}}',['id'=>'1329','pid'=>'1325','shortname'=>'吉水','name'=>'吉水县','merger_name'=>'中国,江西省,吉安市,吉水县','level'=>'3','pinyin'=>'jishui','code'=>'0796','zip_code'=>'331600','first'=>'J','lng'=>'115.1343','lat'=>'27.21071']);
        $this->insert('{{%region}}',['id'=>'1330','pid'=>'1325','shortname'=>'峡江','name'=>'峡江县','merger_name'=>'中国,江西省,吉安市,峡江县','level'=>'3','pinyin'=>'xiajiang','code'=>'0796','zip_code'=>'331409','first'=>'X','lng'=>'115.31723','lat'=>'27.576']);
        $this->insert('{{%region}}',['id'=>'1331','pid'=>'1325','shortname'=>'新干','name'=>'新干县','merger_name'=>'中国,江西省,吉安市,新干县','level'=>'3','pinyin'=>'xingan','code'=>'0796','zip_code'=>'331300','first'=>'X','lng'=>'115.39306','lat'=>'27.74092']);
        $this->insert('{{%region}}',['id'=>'1332','pid'=>'1325','shortname'=>'永丰','name'=>'永丰县','merger_name'=>'中国,江西省,吉安市,永丰县','level'=>'3','pinyin'=>'yongfeng','code'=>'0796','zip_code'=>'331500','first'=>'Y','lng'=>'115.44238','lat'=>'27.31785']);
        $this->insert('{{%region}}',['id'=>'1333','pid'=>'1325','shortname'=>'泰和','name'=>'泰和县','merger_name'=>'中国,江西省,吉安市,泰和县','level'=>'3','pinyin'=>'taihe','code'=>'0796','zip_code'=>'343700','first'=>'T','lng'=>'114.90789','lat'=>'26.79113']);
        $this->insert('{{%region}}',['id'=>'1334','pid'=>'1325','shortname'=>'遂川','name'=>'遂川县','merger_name'=>'中国,江西省,吉安市,遂川县','level'=>'3','pinyin'=>'suichuan','code'=>'0796','zip_code'=>'343900','first'=>'S','lng'=>'114.51629','lat'=>'26.32598']);
        $this->insert('{{%region}}',['id'=>'1335','pid'=>'1325','shortname'=>'万安','name'=>'万安县','merger_name'=>'中国,江西省,吉安市,万安县','level'=>'3','pinyin'=>'wan\'an','code'=>'0796','zip_code'=>'343800','first'=>'W','lng'=>'114.78659','lat'=>'26.45931']);
        $this->insert('{{%region}}',['id'=>'1336','pid'=>'1325','shortname'=>'安福','name'=>'安福县','merger_name'=>'中国,江西省,吉安市,安福县','level'=>'3','pinyin'=>'anfu','code'=>'0796','zip_code'=>'343200','first'=>'A','lng'=>'114.61956','lat'=>'27.39276']);
        $this->insert('{{%region}}',['id'=>'1337','pid'=>'1325','shortname'=>'永新','name'=>'永新县','merger_name'=>'中国,江西省,吉安市,永新县','level'=>'3','pinyin'=>'yongxin','code'=>'0796','zip_code'=>'343400','first'=>'Y','lng'=>'114.24246','lat'=>'26.94488']);
        $this->insert('{{%region}}',['id'=>'1338','pid'=>'1325','shortname'=>'井冈山','name'=>'井冈山市','merger_name'=>'中国,江西省,吉安市,井冈山市','level'=>'3','pinyin'=>'jinggangshan','code'=>'0796','zip_code'=>'343600','first'=>'J','lng'=>'114.28949','lat'=>'26.74804']);
        $this->insert('{{%region}}',['id'=>'1339','pid'=>'1263','shortname'=>'宜春','name'=>'宜春市','merger_name'=>'中国,江西省,宜春市','level'=>'2','pinyin'=>'yichun','code'=>'0795','zip_code'=>'336000','first'=>'Y','lng'=>'114.391136','lat'=>'27.8043']);
        $this->insert('{{%region}}',['id'=>'1340','pid'=>'1339','shortname'=>'袁州','name'=>'袁州区','merger_name'=>'中国,江西省,宜春市,袁州区','level'=>'3','pinyin'=>'yuanzhou','code'=>'0795','zip_code'=>'336000','first'=>'Y','lng'=>'114.38246','lat'=>'27.79649']);
        $this->insert('{{%region}}',['id'=>'1341','pid'=>'1339','shortname'=>'奉新','name'=>'奉新县','merger_name'=>'中国,江西省,宜春市,奉新县','level'=>'3','pinyin'=>'fengxin','code'=>'0795','zip_code'=>'330700','first'=>'F','lng'=>'115.40036','lat'=>'28.6879']);
        $this->insert('{{%region}}',['id'=>'1342','pid'=>'1339','shortname'=>'万载','name'=>'万载县','merger_name'=>'中国,江西省,宜春市,万载县','level'=>'3','pinyin'=>'wanzai','code'=>'0795','zip_code'=>'336100','first'=>'W','lng'=>'114.4458','lat'=>'28.10656']);
        $this->insert('{{%region}}',['id'=>'1343','pid'=>'1339','shortname'=>'上高','name'=>'上高县','merger_name'=>'中国,江西省,宜春市,上高县','level'=>'3','pinyin'=>'shanggao','code'=>'0795','zip_code'=>'336400','first'=>'S','lng'=>'114.92459','lat'=>'28.23423']);
        $this->insert('{{%region}}',['id'=>'1344','pid'=>'1339','shortname'=>'宜丰','name'=>'宜丰县','merger_name'=>'中国,江西省,宜春市,宜丰县','level'=>'3','pinyin'=>'yifeng','code'=>'0795','zip_code'=>'336300','first'=>'Y','lng'=>'114.7803','lat'=>'28.38555']);
        $this->insert('{{%region}}',['id'=>'1345','pid'=>'1339','shortname'=>'靖安','name'=>'靖安县','merger_name'=>'中国,江西省,宜春市,靖安县','level'=>'3','pinyin'=>'jing\'an','code'=>'0795','zip_code'=>'330600','first'=>'J','lng'=>'115.36279','lat'=>'28.86167']);
        $this->insert('{{%region}}',['id'=>'1346','pid'=>'1339','shortname'=>'铜鼓','name'=>'铜鼓县','merger_name'=>'中国,江西省,宜春市,铜鼓县','level'=>'3','pinyin'=>'tonggu','code'=>'0795','zip_code'=>'336200','first'=>'T','lng'=>'114.37036','lat'=>'28.52311']);
        $this->insert('{{%region}}',['id'=>'1347','pid'=>'1339','shortname'=>'丰城','name'=>'丰城市','merger_name'=>'中国,江西省,宜春市,丰城市','level'=>'3','pinyin'=>'fengcheng','code'=>'0795','zip_code'=>'331100','first'=>'F','lng'=>'115.77114','lat'=>'28.15918']);
        $this->insert('{{%region}}',['id'=>'1348','pid'=>'1339','shortname'=>'樟树','name'=>'樟树市','merger_name'=>'中国,江西省,宜春市,樟树市','level'=>'3','pinyin'=>'zhangshu','code'=>'0795','zip_code'=>'331200','first'=>'Z','lng'=>'115.5465','lat'=>'28.05332']);
        $this->insert('{{%region}}',['id'=>'1349','pid'=>'1339','shortname'=>'高安','name'=>'高安市','merger_name'=>'中国,江西省,宜春市,高安市','level'=>'3','pinyin'=>'gao\'an','code'=>'0795','zip_code'=>'330800','first'=>'G','lng'=>'115.3753','lat'=>'28.4178']);
        $this->insert('{{%region}}',['id'=>'1350','pid'=>'1263','shortname'=>'抚州','name'=>'抚州市','merger_name'=>'中国,江西省,抚州市','level'=>'2','pinyin'=>'fuzhou','code'=>'0794','zip_code'=>'344000','first'=>'F','lng'=>'116.358351','lat'=>'27.98385']);
        $this->insert('{{%region}}',['id'=>'1351','pid'=>'1350','shortname'=>'临川','name'=>'临川区','merger_name'=>'中国,江西省,抚州市,临川区','level'=>'3','pinyin'=>'linchuan','code'=>'0794','zip_code'=>'344000','first'=>'L','lng'=>'116.35919','lat'=>'27.97721']);
        $this->insert('{{%region}}',['id'=>'1352','pid'=>'1350','shortname'=>'南城','name'=>'南城县','merger_name'=>'中国,江西省,抚州市,南城县','level'=>'3','pinyin'=>'nancheng','code'=>'0794','zip_code'=>'344700','first'=>'N','lng'=>'116.64419','lat'=>'27.55381']);
        $this->insert('{{%region}}',['id'=>'1353','pid'=>'1350','shortname'=>'黎川','name'=>'黎川县','merger_name'=>'中国,江西省,抚州市,黎川县','level'=>'3','pinyin'=>'lichuan','code'=>'0794','zip_code'=>'344600','first'=>'L','lng'=>'116.90771','lat'=>'27.28232']);
        $this->insert('{{%region}}',['id'=>'1354','pid'=>'1350','shortname'=>'南丰','name'=>'南丰县','merger_name'=>'中国,江西省,抚州市,南丰县','level'=>'3','pinyin'=>'nanfeng','code'=>'0794','zip_code'=>'344500','first'=>'N','lng'=>'116.5256','lat'=>'27.21842']);
        $this->insert('{{%region}}',['id'=>'1355','pid'=>'1350','shortname'=>'崇仁','name'=>'崇仁县','merger_name'=>'中国,江西省,抚州市,崇仁县','level'=>'3','pinyin'=>'chongren','code'=>'0794','zip_code'=>'344200','first'=>'C','lng'=>'116.06021','lat'=>'27.75962']);
        $this->insert('{{%region}}',['id'=>'1356','pid'=>'1350','shortname'=>'乐安','name'=>'乐安县','merger_name'=>'中国,江西省,抚州市,乐安县','level'=>'3','pinyin'=>'le\'an','code'=>'0794','zip_code'=>'344300','first'=>'L','lng'=>'115.83108','lat'=>'27.42812']);
        $this->insert('{{%region}}',['id'=>'1357','pid'=>'1350','shortname'=>'宜黄','name'=>'宜黄县','merger_name'=>'中国,江西省,抚州市,宜黄县','level'=>'3','pinyin'=>'yihuang','code'=>'0794','zip_code'=>'344400','first'=>'Y','lng'=>'116.23626','lat'=>'27.55487']);
        $this->insert('{{%region}}',['id'=>'1358','pid'=>'1350','shortname'=>'金溪','name'=>'金溪县','merger_name'=>'中国,江西省,抚州市,金溪县','level'=>'3','pinyin'=>'jinxi','code'=>'0794','zip_code'=>'344800','first'=>'J','lng'=>'116.77392','lat'=>'27.90753']);
        $this->insert('{{%region}}',['id'=>'1359','pid'=>'1350','shortname'=>'资溪','name'=>'资溪县','merger_name'=>'中国,江西省,抚州市,资溪县','level'=>'3','pinyin'=>'zixi','code'=>'0794','zip_code'=>'335300','first'=>'Z','lng'=>'117.06939','lat'=>'27.70493']);
        $this->insert('{{%region}}',['id'=>'1360','pid'=>'1350','shortname'=>'东乡','name'=>'东乡县','merger_name'=>'中国,江西省,抚州市,东乡县','level'=>'3','pinyin'=>'dongxiang','code'=>'0794','zip_code'=>'331800','first'=>'D','lng'=>'116.59039','lat'=>'28.23614']);
        $this->insert('{{%region}}',['id'=>'1361','pid'=>'1350','shortname'=>'广昌','name'=>'广昌县','merger_name'=>'中国,江西省,抚州市,广昌县','level'=>'3','pinyin'=>'guangchang','code'=>'0794','zip_code'=>'344900','first'=>'G','lng'=>'116.32547','lat'=>'26.8341']);
        $this->insert('{{%region}}',['id'=>'1362','pid'=>'1263','shortname'=>'上饶','name'=>'上饶市','merger_name'=>'中国,江西省,上饶市','level'=>'2','pinyin'=>'shangrao','code'=>'0793','zip_code'=>'334000','first'=>'S','lng'=>'117.971185','lat'=>'28.44442']);
        $this->insert('{{%region}}',['id'=>'1363','pid'=>'1362','shortname'=>'信州','name'=>'信州区','merger_name'=>'中国,江西省,上饶市,信州区','level'=>'3','pinyin'=>'xinzhou','code'=>'0793','zip_code'=>'334000','first'=>'X','lng'=>'117.96682','lat'=>'28.43121']);
        $this->insert('{{%region}}',['id'=>'1364','pid'=>'1362','shortname'=>'上饶','name'=>'上饶县','merger_name'=>'中国,江西省,上饶市,上饶县','level'=>'3','pinyin'=>'shangrao','code'=>'0793','zip_code'=>'334100','first'=>'S','lng'=>'117.90884','lat'=>'28.44856']);
        $this->insert('{{%region}}',['id'=>'1365','pid'=>'1362','shortname'=>'广丰','name'=>'广丰县','merger_name'=>'中国,江西省,上饶市,广丰县','level'=>'3','pinyin'=>'guangfeng','code'=>'0793','zip_code'=>'334600','first'=>'G','lng'=>'118.19158','lat'=>'28.43766']);
        $this->insert('{{%region}}',['id'=>'1366','pid'=>'1362','shortname'=>'玉山','name'=>'玉山县','merger_name'=>'中国,江西省,上饶市,玉山县','level'=>'3','pinyin'=>'yushan','code'=>'0793','zip_code'=>'334700','first'=>'Y','lng'=>'118.24462','lat'=>'28.6818']);
        $this->insert('{{%region}}',['id'=>'1367','pid'=>'1362','shortname'=>'铅山','name'=>'铅山县','merger_name'=>'中国,江西省,上饶市,铅山县','level'=>'3','pinyin'=>'yanshan','code'=>'0793','zip_code'=>'334500','first'=>'Q','lng'=>'117.70996','lat'=>'28.31549']);
        $this->insert('{{%region}}',['id'=>'1368','pid'=>'1362','shortname'=>'横峰','name'=>'横峰县','merger_name'=>'中国,江西省,上饶市,横峰县','level'=>'3','pinyin'=>'hengfeng','code'=>'0793','zip_code'=>'334300','first'=>'H','lng'=>'117.5964','lat'=>'28.40716']);
        $this->insert('{{%region}}',['id'=>'1369','pid'=>'1362','shortname'=>'弋阳','name'=>'弋阳县','merger_name'=>'中国,江西省,上饶市,弋阳县','level'=>'3','pinyin'=>'yiyang','code'=>'0793','zip_code'=>'334400','first'=>NULL,'lng'=>'117.45929','lat'=>'28.37451']);
        $this->insert('{{%region}}',['id'=>'1370','pid'=>'1362','shortname'=>'余干','name'=>'余干县','merger_name'=>'中国,江西省,上饶市,余干县','level'=>'3','pinyin'=>'yugan','code'=>'0793','zip_code'=>'335100','first'=>'Y','lng'=>'116.69555','lat'=>'28.70206']);
        $this->insert('{{%region}}',['id'=>'1371','pid'=>'1362','shortname'=>'鄱阳','name'=>'鄱阳县','merger_name'=>'中国,江西省,上饶市,鄱阳县','level'=>'3','pinyin'=>'poyang','code'=>'0793','zip_code'=>'333100','first'=>NULL,'lng'=>'116.69967','lat'=>'29.0118']);
        $this->insert('{{%region}}',['id'=>'1372','pid'=>'1362','shortname'=>'万年','name'=>'万年县','merger_name'=>'中国,江西省,上饶市,万年县','level'=>'3','pinyin'=>'wannian','code'=>'0793','zip_code'=>'335500','first'=>'W','lng'=>'117.06884','lat'=>'28.69537']);
        $this->insert('{{%region}}',['id'=>'1373','pid'=>'1362','shortname'=>'婺源','name'=>'婺源县','merger_name'=>'中国,江西省,上饶市,婺源县','level'=>'3','pinyin'=>'wuyuan','code'=>'0793','zip_code'=>'333200','first'=>NULL,'lng'=>'117.86105','lat'=>'29.24841']);
        $this->insert('{{%region}}',['id'=>'1374','pid'=>'1362','shortname'=>'德兴','name'=>'德兴市','merger_name'=>'中国,江西省,上饶市,德兴市','level'=>'3','pinyin'=>'dexing','code'=>'0793','zip_code'=>'334200','first'=>'D','lng'=>'117.57919','lat'=>'28.94736']);
        $this->insert('{{%region}}',['id'=>'1375','pid'=>'0','shortname'=>'山东','name'=>'山东省','merger_name'=>'中国,山东省','level'=>'1','pinyin'=>'shandong','code'=>'','zip_code'=>'','first'=>'S','lng'=>'117.000923','lat'=>'36.675807']);
        $this->insert('{{%region}}',['id'=>'1376','pid'=>'1375','shortname'=>'济南','name'=>'济南市','merger_name'=>'中国,山东省,济南市','level'=>'2','pinyin'=>'jinan','code'=>'0531','zip_code'=>'250001','first'=>'J','lng'=>'117.000923','lat'=>'36.675807']);
        $this->insert('{{%region}}',['id'=>'1377','pid'=>'1376','shortname'=>'历下','name'=>'历下区','merger_name'=>'中国,山东省,济南市,历下区','level'=>'3','pinyin'=>'lixia','code'=>'0531','zip_code'=>'250014','first'=>'L','lng'=>'117.0768','lat'=>'36.66661']);
        $this->insert('{{%region}}',['id'=>'1378','pid'=>'1376','shortname'=>'市中区','name'=>'市中区','merger_name'=>'中国,山东省,济南市,市中区','level'=>'3','pinyin'=>'shizhongqu','code'=>'0531','zip_code'=>'250001','first'=>'S','lng'=>'116.99741','lat'=>'36.65101']);
        $this->insert('{{%region}}',['id'=>'1379','pid'=>'1376','shortname'=>'槐荫','name'=>'槐荫区','merger_name'=>'中国,山东省,济南市,槐荫区','level'=>'3','pinyin'=>'huaiyin','code'=>'0531','zip_code'=>'250117','first'=>'H','lng'=>'116.90075','lat'=>'36.65136']);
        $this->insert('{{%region}}',['id'=>'1380','pid'=>'1376','shortname'=>'天桥','name'=>'天桥区','merger_name'=>'中国,山东省,济南市,天桥区','level'=>'3','pinyin'=>'tianqiao','code'=>'0531','zip_code'=>'250031','first'=>'T','lng'=>'116.98749','lat'=>'36.67801']);
        $this->insert('{{%region}}',['id'=>'1381','pid'=>'1376','shortname'=>'历城','name'=>'历城区','merger_name'=>'中国,山东省,济南市,历城区','level'=>'3','pinyin'=>'licheng','code'=>'0531','zip_code'=>'250100','first'=>'L','lng'=>'117.06509','lat'=>'36.67995']);
        $this->insert('{{%region}}',['id'=>'1382','pid'=>'1376','shortname'=>'长清','name'=>'长清区','merger_name'=>'中国,山东省,济南市,长清区','level'=>'3','pinyin'=>'changqing','code'=>'0531','zip_code'=>'250300','first'=>'C','lng'=>'116.75192','lat'=>'36.55352']);
        $this->insert('{{%region}}',['id'=>'1383','pid'=>'1376','shortname'=>'平阴','name'=>'平阴县','merger_name'=>'中国,山东省,济南市,平阴县','level'=>'3','pinyin'=>'pingyin','code'=>'0531','zip_code'=>'250400','first'=>'P','lng'=>'116.45587','lat'=>'36.28955']);
        $this->insert('{{%region}}',['id'=>'1384','pid'=>'1376','shortname'=>'济阳','name'=>'济阳县','merger_name'=>'中国,山东省,济南市,济阳县','level'=>'3','pinyin'=>'jiyang','code'=>'0531','zip_code'=>'251400','first'=>'J','lng'=>'117.17327','lat'=>'36.97845']);
        $this->insert('{{%region}}',['id'=>'1385','pid'=>'1376','shortname'=>'商河','name'=>'商河县','merger_name'=>'中国,山东省,济南市,商河县','level'=>'3','pinyin'=>'shanghe','code'=>'0531','zip_code'=>'251600','first'=>'S','lng'=>'117.15722','lat'=>'37.31119']);
        $this->insert('{{%region}}',['id'=>'1386','pid'=>'1376','shortname'=>'章丘','name'=>'章丘市','merger_name'=>'中国,山东省,济南市,章丘市','level'=>'3','pinyin'=>'zhangqiu','code'=>'0531','zip_code'=>'250200','first'=>'Z','lng'=>'117.53677','lat'=>'36.71392']);
        $this->insert('{{%region}}',['id'=>'1387','pid'=>'1375','shortname'=>'青岛','name'=>'青岛市','merger_name'=>'中国,山东省,青岛市','level'=>'2','pinyin'=>'qingdao','code'=>'0532','zip_code'=>'266001','first'=>'Q','lng'=>'120.369557','lat'=>'36.094406']);
        $this->insert('{{%region}}',['id'=>'1388','pid'=>'1387','shortname'=>'市南','name'=>'市南区','merger_name'=>'中国,山东省,青岛市,市南区','level'=>'3','pinyin'=>'shinan','code'=>'0532','zip_code'=>'266001','first'=>'S','lng'=>'120.38773','lat'=>'36.06671']);
        $this->insert('{{%region}}',['id'=>'1389','pid'=>'1387','shortname'=>'市北','name'=>'市北区','merger_name'=>'中国,山东省,青岛市,市北区','level'=>'3','pinyin'=>'shibei','code'=>'0532','zip_code'=>'266011','first'=>'S','lng'=>'120.37469','lat'=>'36.08734']);
        $this->insert('{{%region}}',['id'=>'1390','pid'=>'1387','shortname'=>'黄岛','name'=>'黄岛区','merger_name'=>'中国,山东省,青岛市,黄岛区','level'=>'3','pinyin'=>'huangdao','code'=>'0532','zip_code'=>'266500','first'=>'H','lng'=>'120.19775','lat'=>'35.96065']);
        $this->insert('{{%region}}',['id'=>'1391','pid'=>'1387','shortname'=>'崂山','name'=>'崂山区','merger_name'=>'中国,山东省,青岛市,崂山区','level'=>'3','pinyin'=>'laoshan','code'=>'0532','zip_code'=>'266100','first'=>NULL,'lng'=>'120.46923','lat'=>'36.10717']);
        $this->insert('{{%region}}',['id'=>'1392','pid'=>'1387','shortname'=>'李沧','name'=>'李沧区','merger_name'=>'中国,山东省,青岛市,李沧区','level'=>'3','pinyin'=>'licang','code'=>'0532','zip_code'=>'266021','first'=>'L','lng'=>'120.43286','lat'=>'36.14502']);
        $this->insert('{{%region}}',['id'=>'1393','pid'=>'1387','shortname'=>'城阳','name'=>'城阳区','merger_name'=>'中国,山东省,青岛市,城阳区','level'=>'3','pinyin'=>'chengyang','code'=>'0532','zip_code'=>'266041','first'=>'C','lng'=>'120.39621','lat'=>'36.30735']);
        $this->insert('{{%region}}',['id'=>'1394','pid'=>'1387','shortname'=>'胶州','name'=>'胶州市','merger_name'=>'中国,山东省,青岛市,胶州市','level'=>'3','pinyin'=>'jiaozhou','code'=>'0532','zip_code'=>'266300','first'=>'J','lng'=>'120.0335','lat'=>'36.26442']);
        $this->insert('{{%region}}',['id'=>'1395','pid'=>'1387','shortname'=>'即墨','name'=>'即墨市','merger_name'=>'中国,山东省,青岛市,即墨市','level'=>'3','pinyin'=>'jimo','code'=>'0532','zip_code'=>'266200','first'=>'J','lng'=>'120.44699','lat'=>'36.38907']);
        $this->insert('{{%region}}',['id'=>'1396','pid'=>'1387','shortname'=>'平度','name'=>'平度市','merger_name'=>'中国,山东省,青岛市,平度市','level'=>'3','pinyin'=>'pingdu','code'=>'0532','zip_code'=>'266700','first'=>'P','lng'=>'119.95996','lat'=>'36.78688']);
        $this->insert('{{%region}}',['id'=>'1397','pid'=>'1387','shortname'=>'莱西','name'=>'莱西市','merger_name'=>'中国,山东省,青岛市,莱西市','level'=>'3','pinyin'=>'laixi','code'=>'0532','zip_code'=>'266600','first'=>'L','lng'=>'120.51773','lat'=>'36.88804']);
        $this->insert('{{%region}}',['id'=>'1398','pid'=>'1387','shortname'=>'西海岸','name'=>'西海岸新区','merger_name'=>'中国,山东省,青岛市,西海岸新区','level'=>'3','pinyin'=>'xihai\'an','code'=>'0532','zip_code'=>'266500','first'=>'X','lng'=>'120.19775','lat'=>'35.96065']);
        $this->insert('{{%region}}',['id'=>'1399','pid'=>'1375','shortname'=>'淄博','name'=>'淄博市','merger_name'=>'中国,山东省,淄博市','level'=>'2','pinyin'=>'zibo','code'=>'0533','zip_code'=>'255039','first'=>'Z','lng'=>'118.047648','lat'=>'36.814939']);
        $this->insert('{{%region}}',['id'=>'1400','pid'=>'1399','shortname'=>'淄川','name'=>'淄川区','merger_name'=>'中国,山东省,淄博市,淄川区','level'=>'3','pinyin'=>'zichuan','code'=>'0533','zip_code'=>'255100','first'=>'Z','lng'=>'117.96655','lat'=>'36.64339']);
        $this->insert('{{%region}}',['id'=>'1401','pid'=>'1399','shortname'=>'张店','name'=>'张店区','merger_name'=>'中国,山东省,淄博市,张店区','level'=>'3','pinyin'=>'zhangdian','code'=>'0533','zip_code'=>'255022','first'=>'Z','lng'=>'118.01788','lat'=>'36.80676']);
        $this->insert('{{%region}}',['id'=>'1402','pid'=>'1399','shortname'=>'博山','name'=>'博山区','merger_name'=>'中国,山东省,淄博市,博山区','level'=>'3','pinyin'=>'boshan','code'=>'0533','zip_code'=>'255200','first'=>'B','lng'=>'117.86166','lat'=>'36.49469']);
        $this->insert('{{%region}}',['id'=>'1403','pid'=>'1399','shortname'=>'临淄','name'=>'临淄区','merger_name'=>'中国,山东省,淄博市,临淄区','level'=>'3','pinyin'=>'linzi','code'=>'0533','zip_code'=>'255400','first'=>'L','lng'=>'118.30966','lat'=>'36.8259']);
        $this->insert('{{%region}}',['id'=>'1404','pid'=>'1399','shortname'=>'周村','name'=>'周村区','merger_name'=>'中国,山东省,淄博市,周村区','level'=>'3','pinyin'=>'zhoucun','code'=>'0533','zip_code'=>'255300','first'=>'Z','lng'=>'117.86969','lat'=>'36.80322']);
        $this->insert('{{%region}}',['id'=>'1405','pid'=>'1399','shortname'=>'桓台','name'=>'桓台县','merger_name'=>'中国,山东省,淄博市,桓台县','level'=>'3','pinyin'=>'huantai','code'=>'0533','zip_code'=>'256400','first'=>'H','lng'=>'118.09698','lat'=>'36.96036']);
        $this->insert('{{%region}}',['id'=>'1406','pid'=>'1399','shortname'=>'高青','name'=>'高青县','merger_name'=>'中国,山东省,淄博市,高青县','level'=>'3','pinyin'=>'gaoqing','code'=>'0533','zip_code'=>'256300','first'=>'G','lng'=>'117.82708','lat'=>'37.17197']);
        $this->insert('{{%region}}',['id'=>'1407','pid'=>'1399','shortname'=>'沂源','name'=>'沂源县','merger_name'=>'中国,山东省,淄博市,沂源县','level'=>'3','pinyin'=>'yiyuan','code'=>'0533','zip_code'=>'256100','first'=>'Y','lng'=>'118.17105','lat'=>'36.18536']);
        $this->insert('{{%region}}',['id'=>'1408','pid'=>'1375','shortname'=>'枣庄','name'=>'枣庄市','merger_name'=>'中国,山东省,枣庄市','level'=>'2','pinyin'=>'zaozhuang','code'=>'0632','zip_code'=>'277101','first'=>'Z','lng'=>'117.557964','lat'=>'34.856424']);
        $this->insert('{{%region}}',['id'=>'1409','pid'=>'1408','shortname'=>'市中区','name'=>'市中区','merger_name'=>'中国,山东省,枣庄市,市中区','level'=>'3','pinyin'=>'shizhongqu','code'=>'0632','zip_code'=>'277101','first'=>'S','lng'=>'117.55603','lat'=>'34.86391']);
        $this->insert('{{%region}}',['id'=>'1410','pid'=>'1408','shortname'=>'薛城','name'=>'薛城区','merger_name'=>'中国,山东省,枣庄市,薛城区','level'=>'3','pinyin'=>'xuecheng','code'=>'0632','zip_code'=>'277000','first'=>'X','lng'=>'117.26318','lat'=>'34.79498']);
        $this->insert('{{%region}}',['id'=>'1411','pid'=>'1408','shortname'=>'峄城','name'=>'峄城区','merger_name'=>'中国,山东省,枣庄市,峄城区','level'=>'3','pinyin'=>'yicheng','code'=>'0632','zip_code'=>'277300','first'=>NULL,'lng'=>'117.59057','lat'=>'34.77225']);
        $this->insert('{{%region}}',['id'=>'1412','pid'=>'1408','shortname'=>'台儿庄','name'=>'台儿庄区','merger_name'=>'中国,山东省,枣庄市,台儿庄区','level'=>'3','pinyin'=>'taierzhuang','code'=>'0632','zip_code'=>'277400','first'=>'T','lng'=>'117.73452','lat'=>'34.56363']);
        $this->insert('{{%region}}',['id'=>'1413','pid'=>'1408','shortname'=>'山亭','name'=>'山亭区','merger_name'=>'中国,山东省,枣庄市,山亭区','level'=>'3','pinyin'=>'shanting','code'=>'0632','zip_code'=>'277200','first'=>'S','lng'=>'117.4663','lat'=>'35.09541']);
        $this->insert('{{%region}}',['id'=>'1414','pid'=>'1408','shortname'=>'滕州','name'=>'滕州市','merger_name'=>'中国,山东省,枣庄市,滕州市','level'=>'3','pinyin'=>'tengzhou','code'=>'0632','zip_code'=>'277500','first'=>NULL,'lng'=>'117.165','lat'=>'35.10534']);
        $this->insert('{{%region}}',['id'=>'1415','pid'=>'1375','shortname'=>'东营','name'=>'东营市','merger_name'=>'中国,山东省,东营市','level'=>'2','pinyin'=>'dongying','code'=>'0546','zip_code'=>'257093','first'=>'D','lng'=>'118.4963','lat'=>'37.461266']);
        $this->insert('{{%region}}',['id'=>'1416','pid'=>'1415','shortname'=>'东营','name'=>'东营区','merger_name'=>'中国,山东省,东营市,东营区','level'=>'3','pinyin'=>'dongying','code'=>'0546','zip_code'=>'257029','first'=>'D','lng'=>'118.5816','lat'=>'37.44875']);
        $this->insert('{{%region}}',['id'=>'1417','pid'=>'1415','shortname'=>'河口','name'=>'河口区','merger_name'=>'中国,山东省,东营市,河口区','level'=>'3','pinyin'=>'hekou','code'=>'0546','zip_code'=>'257200','first'=>'H','lng'=>'118.5249','lat'=>'37.88541']);
        $this->insert('{{%region}}',['id'=>'1418','pid'=>'1415','shortname'=>'垦利','name'=>'垦利县','merger_name'=>'中国,山东省,东营市,垦利县','level'=>'3','pinyin'=>'kenli','code'=>'0546','zip_code'=>'257500','first'=>'K','lng'=>'118.54815','lat'=>'37.58825']);
        $this->insert('{{%region}}',['id'=>'1419','pid'=>'1415','shortname'=>'利津','name'=>'利津县','merger_name'=>'中国,山东省,东营市,利津县','level'=>'3','pinyin'=>'lijin','code'=>'0546','zip_code'=>'257400','first'=>'L','lng'=>'118.25637','lat'=>'37.49157']);
        $this->insert('{{%region}}',['id'=>'1420','pid'=>'1415','shortname'=>'广饶','name'=>'广饶县','merger_name'=>'中国,山东省,东营市,广饶县','level'=>'3','pinyin'=>'guangrao','code'=>'0546','zip_code'=>'257300','first'=>'G','lng'=>'118.40704','lat'=>'37.05381']);
        $this->insert('{{%region}}',['id'=>'1421','pid'=>'1375','shortname'=>'烟台','name'=>'烟台市','merger_name'=>'中国,山东省,烟台市','level'=>'2','pinyin'=>'yantai','code'=>'0635','zip_code'=>'264010','first'=>'Y','lng'=>'121.391382','lat'=>'37.539297']);
        $this->insert('{{%region}}',['id'=>'1422','pid'=>'1421','shortname'=>'芝罘','name'=>'芝罘区','merger_name'=>'中国,山东省,烟台市,芝罘区','level'=>'3','pinyin'=>'zhifu','code'=>'0635','zip_code'=>'264001','first'=>'Z','lng'=>'121.40023','lat'=>'37.54064']);
        $this->insert('{{%region}}',['id'=>'1423','pid'=>'1421','shortname'=>'福山','name'=>'福山区','merger_name'=>'中国,山东省,烟台市,福山区','level'=>'3','pinyin'=>'fushan','code'=>'0635','zip_code'=>'265500','first'=>'F','lng'=>'121.26812','lat'=>'37.49841']);
        $this->insert('{{%region}}',['id'=>'1424','pid'=>'1421','shortname'=>'牟平','name'=>'牟平区','merger_name'=>'中国,山东省,烟台市,牟平区','level'=>'3','pinyin'=>'muping','code'=>'0635','zip_code'=>'264100','first'=>'M','lng'=>'121.60067','lat'=>'37.38846']);
        $this->insert('{{%region}}',['id'=>'1425','pid'=>'1421','shortname'=>'莱山','name'=>'莱山区','merger_name'=>'中国,山东省,烟台市,莱山区','level'=>'3','pinyin'=>'laishan','code'=>'0635','zip_code'=>'264600','first'=>'L','lng'=>'121.44512','lat'=>'37.51165']);
        $this->insert('{{%region}}',['id'=>'1426','pid'=>'1421','shortname'=>'长岛','name'=>'长岛县','merger_name'=>'中国,山东省,烟台市,长岛县','level'=>'3','pinyin'=>'changdao','code'=>'0635','zip_code'=>'265800','first'=>'C','lng'=>'120.738','lat'=>'37.91754']);
        $this->insert('{{%region}}',['id'=>'1427','pid'=>'1421','shortname'=>'龙口','name'=>'龙口市','merger_name'=>'中国,山东省,烟台市,龙口市','level'=>'3','pinyin'=>'longkou','code'=>'0635','zip_code'=>'265700','first'=>'L','lng'=>'120.50634','lat'=>'37.64064']);
        $this->insert('{{%region}}',['id'=>'1428','pid'=>'1421','shortname'=>'莱阳','name'=>'莱阳市','merger_name'=>'中国,山东省,烟台市,莱阳市','level'=>'3','pinyin'=>'laiyang','code'=>'0635','zip_code'=>'265200','first'=>'L','lng'=>'120.71066','lat'=>'36.98012']);
        $this->insert('{{%region}}',['id'=>'1429','pid'=>'1421','shortname'=>'莱州','name'=>'莱州市','merger_name'=>'中国,山东省,烟台市,莱州市','level'=>'3','pinyin'=>'laizhou','code'=>'0635','zip_code'=>'261400','first'=>'L','lng'=>'119.94137','lat'=>'37.17806']);
        $this->insert('{{%region}}',['id'=>'1430','pid'=>'1421','shortname'=>'蓬莱','name'=>'蓬莱市','merger_name'=>'中国,山东省,烟台市,蓬莱市','level'=>'3','pinyin'=>'penglai','code'=>'0635','zip_code'=>'265600','first'=>'P','lng'=>'120.75988','lat'=>'37.81119']);
        $this->insert('{{%region}}',['id'=>'1431','pid'=>'1421','shortname'=>'招远','name'=>'招远市','merger_name'=>'中国,山东省,烟台市,招远市','level'=>'3','pinyin'=>'zhaoyuan','code'=>'0635','zip_code'=>'265400','first'=>'Z','lng'=>'120.40481','lat'=>'37.36269']);
        $this->insert('{{%region}}',['id'=>'1432','pid'=>'1421','shortname'=>'栖霞','name'=>'栖霞市','merger_name'=>'中国,山东省,烟台市,栖霞市','level'=>'3','pinyin'=>'qixia','code'=>'0635','zip_code'=>'265300','first'=>'Q','lng'=>'120.85025','lat'=>'37.33571']);
        $this->insert('{{%region}}',['id'=>'1433','pid'=>'1421','shortname'=>'海阳','name'=>'海阳市','merger_name'=>'中国,山东省,烟台市,海阳市','level'=>'3','pinyin'=>'haiyang','code'=>'0635','zip_code'=>'265100','first'=>'H','lng'=>'121.15976','lat'=>'36.77622']);
        $this->insert('{{%region}}',['id'=>'1434','pid'=>'1375','shortname'=>'潍坊','name'=>'潍坊市','merger_name'=>'中国,山东省,潍坊市','level'=>'2','pinyin'=>'weifang','code'=>'0536','zip_code'=>'261041','first'=>'W','lng'=>'119.107078','lat'=>'36.70925']);
        $this->insert('{{%region}}',['id'=>'1435','pid'=>'1434','shortname'=>'潍城','name'=>'潍城区','merger_name'=>'中国,山东省,潍坊市,潍城区','level'=>'3','pinyin'=>'weicheng','code'=>'0536','zip_code'=>'261021','first'=>'W','lng'=>'119.10582','lat'=>'36.7139']);
        $this->insert('{{%region}}',['id'=>'1436','pid'=>'1434','shortname'=>'寒亭','name'=>'寒亭区','merger_name'=>'中国,山东省,潍坊市,寒亭区','level'=>'3','pinyin'=>'hanting','code'=>'0536','zip_code'=>'261100','first'=>'H','lng'=>'119.21832','lat'=>'36.77504']);
        $this->insert('{{%region}}',['id'=>'1437','pid'=>'1434','shortname'=>'坊子','name'=>'坊子区','merger_name'=>'中国,山东省,潍坊市,坊子区','level'=>'3','pinyin'=>'fangzi','code'=>'0536','zip_code'=>'261200','first'=>'F','lng'=>'119.16476','lat'=>'36.65218']);
        $this->insert('{{%region}}',['id'=>'1438','pid'=>'1434','shortname'=>'奎文','name'=>'奎文区','merger_name'=>'中国,山东省,潍坊市,奎文区','level'=>'3','pinyin'=>'kuiwen','code'=>'0536','zip_code'=>'261031','first'=>'K','lng'=>'119.12532','lat'=>'36.70723']);
        $this->insert('{{%region}}',['id'=>'1439','pid'=>'1434','shortname'=>'临朐','name'=>'临朐县','merger_name'=>'中国,山东省,潍坊市,临朐县','level'=>'3','pinyin'=>'linqu','code'=>'0536','zip_code'=>'262600','first'=>'L','lng'=>'118.544','lat'=>'36.51216']);
        $this->insert('{{%region}}',['id'=>'1440','pid'=>'1434','shortname'=>'昌乐','name'=>'昌乐县','merger_name'=>'中国,山东省,潍坊市,昌乐县','level'=>'3','pinyin'=>'changle','code'=>'0536','zip_code'=>'262400','first'=>'C','lng'=>'118.83017','lat'=>'36.7078']);
        $this->insert('{{%region}}',['id'=>'1441','pid'=>'1434','shortname'=>'青州','name'=>'青州市','merger_name'=>'中国,山东省,潍坊市,青州市','level'=>'3','pinyin'=>'qingzhou','code'=>'0536','zip_code'=>'262500','first'=>'Q','lng'=>'118.47915','lat'=>'36.68505']);
        $this->insert('{{%region}}',['id'=>'1442','pid'=>'1434','shortname'=>'诸城','name'=>'诸城市','merger_name'=>'中国,山东省,潍坊市,诸城市','level'=>'3','pinyin'=>'zhucheng','code'=>'0536','zip_code'=>'262200','first'=>'Z','lng'=>'119.40988','lat'=>'35.99662']);
        $this->insert('{{%region}}',['id'=>'1443','pid'=>'1434','shortname'=>'寿光','name'=>'寿光市','merger_name'=>'中国,山东省,潍坊市,寿光市','level'=>'3','pinyin'=>'shouguang','code'=>'0536','zip_code'=>'262700','first'=>'S','lng'=>'118.74047','lat'=>'36.88128']);
        $this->insert('{{%region}}',['id'=>'1444','pid'=>'1434','shortname'=>'安丘','name'=>'安丘市','merger_name'=>'中国,山东省,潍坊市,安丘市','level'=>'3','pinyin'=>'anqiu','code'=>'0536','zip_code'=>'262100','first'=>'A','lng'=>'119.2189','lat'=>'36.47847']);
        $this->insert('{{%region}}',['id'=>'1445','pid'=>'1434','shortname'=>'高密','name'=>'高密市','merger_name'=>'中国,山东省,潍坊市,高密市','level'=>'3','pinyin'=>'gaomi','code'=>'0536','zip_code'=>'261500','first'=>'G','lng'=>'119.75701','lat'=>'36.38397']);
        $this->insert('{{%region}}',['id'=>'1446','pid'=>'1434','shortname'=>'昌邑','name'=>'昌邑市','merger_name'=>'中国,山东省,潍坊市,昌邑市','level'=>'3','pinyin'=>'changyi','code'=>'0536','zip_code'=>'261300','first'=>'C','lng'=>'119.39767','lat'=>'36.86008']);
        $this->insert('{{%region}}',['id'=>'1447','pid'=>'1375','shortname'=>'济宁','name'=>'济宁市','merger_name'=>'中国,山东省,济宁市','level'=>'2','pinyin'=>'jining','code'=>'0537','zip_code'=>'272119','first'=>'J','lng'=>'116.587245','lat'=>'35.415393']);
        $this->insert('{{%region}}',['id'=>'1448','pid'=>'1447','shortname'=>'任城','name'=>'任城区','merger_name'=>'中国,山东省,济宁市,任城区','level'=>'3','pinyin'=>'rencheng','code'=>'0537','zip_code'=>'272113','first'=>'R','lng'=>'116.59504','lat'=>'35.40659']);
        $this->insert('{{%region}}',['id'=>'1449','pid'=>'1447','shortname'=>'兖州','name'=>'兖州区','merger_name'=>'中国,山东省,济宁市,兖州区','level'=>'3','pinyin'=>'yanzhou','code'=>'0537','zip_code'=>'272000','first'=>NULL,'lng'=>'116.826546','lat'=>'35.552305']);
        $this->insert('{{%region}}',['id'=>'1450','pid'=>'1447','shortname'=>'微山','name'=>'微山县','merger_name'=>'中国,山东省,济宁市,微山县','level'=>'3','pinyin'=>'weishan','code'=>'0537','zip_code'=>'277600','first'=>'W','lng'=>'117.12875','lat'=>'34.80712']);
        $this->insert('{{%region}}',['id'=>'1451','pid'=>'1447','shortname'=>'鱼台','name'=>'鱼台县','merger_name'=>'中国,山东省,济宁市,鱼台县','level'=>'3','pinyin'=>'yutai','code'=>'0537','zip_code'=>'272300','first'=>'Y','lng'=>'116.64761','lat'=>'34.99674']);
        $this->insert('{{%region}}',['id'=>'1452','pid'=>'1447','shortname'=>'金乡','name'=>'金乡县','merger_name'=>'中国,山东省,济宁市,金乡县','level'=>'3','pinyin'=>'jinxiang','code'=>'0537','zip_code'=>'272200','first'=>'J','lng'=>'116.31146','lat'=>'35.065']);
        $this->insert('{{%region}}',['id'=>'1453','pid'=>'1447','shortname'=>'嘉祥','name'=>'嘉祥县','merger_name'=>'中国,山东省,济宁市,嘉祥县','level'=>'3','pinyin'=>'jiaxiang','code'=>'0537','zip_code'=>'272400','first'=>'J','lng'=>'116.34249','lat'=>'35.40836']);
        $this->insert('{{%region}}',['id'=>'1454','pid'=>'1447','shortname'=>'汶上','name'=>'汶上县','merger_name'=>'中国,山东省,济宁市,汶上县','level'=>'3','pinyin'=>'wenshang','code'=>'0537','zip_code'=>'272501','first'=>NULL,'lng'=>'116.48742','lat'=>'35.73295']);
        $this->insert('{{%region}}',['id'=>'1455','pid'=>'1447','shortname'=>'泗水','name'=>'泗水县','merger_name'=>'中国,山东省,济宁市,泗水县','level'=>'3','pinyin'=>'sishui','code'=>'0537','zip_code'=>'273200','first'=>NULL,'lng'=>'117.27948','lat'=>'35.66113']);
        $this->insert('{{%region}}',['id'=>'1456','pid'=>'1447','shortname'=>'梁山','name'=>'梁山县','merger_name'=>'中国,山东省,济宁市,梁山县','level'=>'3','pinyin'=>'liangshan','code'=>'0537','zip_code'=>'272600','first'=>'L','lng'=>'116.09683','lat'=>'35.80322']);
        $this->insert('{{%region}}',['id'=>'1457','pid'=>'1447','shortname'=>'曲阜','name'=>'曲阜市','merger_name'=>'中国,山东省,济宁市,曲阜市','level'=>'3','pinyin'=>'qufu','code'=>'0537','zip_code'=>'273100','first'=>'Q','lng'=>'116.98645','lat'=>'35.58091']);
        $this->insert('{{%region}}',['id'=>'1458','pid'=>'1447','shortname'=>'邹城','name'=>'邹城市','merger_name'=>'中国,山东省,济宁市,邹城市','level'=>'3','pinyin'=>'zoucheng','code'=>'0537','zip_code'=>'273500','first'=>'Z','lng'=>'116.97335','lat'=>'35.40531']);
        $this->insert('{{%region}}',['id'=>'1459','pid'=>'1375','shortname'=>'泰安','name'=>'泰安市','merger_name'=>'中国,山东省,泰安市','level'=>'2','pinyin'=>'tai\'an','code'=>'0538','zip_code'=>'271000','first'=>'T','lng'=>'117.129063','lat'=>'36.194968']);
        $this->insert('{{%region}}',['id'=>'1460','pid'=>'1459','shortname'=>'泰山','name'=>'泰山区','merger_name'=>'中国,山东省,泰安市,泰山区','level'=>'3','pinyin'=>'taishan','code'=>'0538','zip_code'=>'271000','first'=>'T','lng'=>'117.13446','lat'=>'36.19411']);
        $this->insert('{{%region}}',['id'=>'1461','pid'=>'1459','shortname'=>'岱岳','name'=>'岱岳区','merger_name'=>'中国,山东省,泰安市,岱岳区','level'=>'3','pinyin'=>'daiyue','code'=>'0538','zip_code'=>'271000','first'=>NULL,'lng'=>'117.04174','lat'=>'36.1875']);
        $this->insert('{{%region}}',['id'=>'1462','pid'=>'1459','shortname'=>'宁阳','name'=>'宁阳县','merger_name'=>'中国,山东省,泰安市,宁阳县','level'=>'3','pinyin'=>'ningyang','code'=>'0538','zip_code'=>'271400','first'=>'N','lng'=>'116.80542','lat'=>'35.7599']);
        $this->insert('{{%region}}',['id'=>'1463','pid'=>'1459','shortname'=>'东平','name'=>'东平县','merger_name'=>'中国,山东省,泰安市,东平县','level'=>'3','pinyin'=>'dongping','code'=>'0538','zip_code'=>'271500','first'=>'D','lng'=>'116.47113','lat'=>'35.93792']);
        $this->insert('{{%region}}',['id'=>'1464','pid'=>'1459','shortname'=>'新泰','name'=>'新泰市','merger_name'=>'中国,山东省,泰安市,新泰市','level'=>'3','pinyin'=>'xintai','code'=>'0538','zip_code'=>'271200','first'=>'X','lng'=>'117.76959','lat'=>'35.90887']);
        $this->insert('{{%region}}',['id'=>'1465','pid'=>'1459','shortname'=>'肥城','name'=>'肥城市','merger_name'=>'中国,山东省,泰安市,肥城市','level'=>'3','pinyin'=>'feicheng','code'=>'0538','zip_code'=>'271600','first'=>'F','lng'=>'116.76815','lat'=>'36.18247']);
        $this->insert('{{%region}}',['id'=>'1466','pid'=>'1375','shortname'=>'威海','name'=>'威海市','merger_name'=>'中国,山东省,威海市','level'=>'2','pinyin'=>'weihai','code'=>'0631','zip_code'=>'264200','first'=>'W','lng'=>'122.116394','lat'=>'37.509691']);
        $this->insert('{{%region}}',['id'=>'1467','pid'=>'1466','shortname'=>'环翠','name'=>'环翠区','merger_name'=>'中国,山东省,威海市,环翠区','level'=>'3','pinyin'=>'huancui','code'=>'0631','zip_code'=>'264200','first'=>'H','lng'=>'122.12344','lat'=>'37.50199']);
        $this->insert('{{%region}}',['id'=>'1468','pid'=>'1466','shortname'=>'文登','name'=>'文登区','merger_name'=>'中国,山东省,威海市,文登区','level'=>'3','pinyin'=>'wendeng','code'=>'0631','zip_code'=>'266440','first'=>'W','lng'=>'122.057139','lat'=>'37.196211']);
        $this->insert('{{%region}}',['id'=>'1469','pid'=>'1466','shortname'=>'荣成','name'=>'荣成市','merger_name'=>'中国,山东省,威海市,荣成市','level'=>'3','pinyin'=>'rongcheng','code'=>'0631','zip_code'=>'264300','first'=>'R','lng'=>'122.48773','lat'=>'37.1652']);
        $this->insert('{{%region}}',['id'=>'1470','pid'=>'1466','shortname'=>'乳山','name'=>'乳山市','merger_name'=>'中国,山东省,威海市,乳山市','level'=>'3','pinyin'=>'rushan','code'=>'0631','zip_code'=>'264500','first'=>'R','lng'=>'121.53814','lat'=>'36.91918']);
        $this->insert('{{%region}}',['id'=>'1471','pid'=>'1375','shortname'=>'日照','name'=>'日照市','merger_name'=>'中国,山东省,日照市','level'=>'2','pinyin'=>'rizhao','code'=>'0633','zip_code'=>'276800','first'=>'R','lng'=>'119.461208','lat'=>'35.428588']);
        $this->insert('{{%region}}',['id'=>'1472','pid'=>'1471','shortname'=>'东港','name'=>'东港区','merger_name'=>'中国,山东省,日照市,东港区','level'=>'3','pinyin'=>'donggang','code'=>'0633','zip_code'=>'276800','first'=>'D','lng'=>'119.46237','lat'=>'35.42541']);
        $this->insert('{{%region}}',['id'=>'1473','pid'=>'1471','shortname'=>'岚山','name'=>'岚山区','merger_name'=>'中国,山东省,日照市,岚山区','level'=>'3','pinyin'=>'lanshan','code'=>'0633','zip_code'=>'276808','first'=>NULL,'lng'=>'119.31884','lat'=>'35.12203']);
        $this->insert('{{%region}}',['id'=>'1474','pid'=>'1471','shortname'=>'五莲','name'=>'五莲县','merger_name'=>'中国,山东省,日照市,五莲县','level'=>'3','pinyin'=>'wulian','code'=>'0633','zip_code'=>'262300','first'=>'W','lng'=>'119.207','lat'=>'35.75004']);
        $this->insert('{{%region}}',['id'=>'1475','pid'=>'1471','shortname'=>'莒县','name'=>'莒县','merger_name'=>'中国,山东省,日照市,莒县','level'=>'3','pinyin'=>'juxian','code'=>'0633','zip_code'=>'276500','first'=>NULL,'lng'=>'118.83789','lat'=>'35.58054']);
        $this->insert('{{%region}}',['id'=>'1476','pid'=>'1375','shortname'=>'莱芜','name'=>'莱芜市','merger_name'=>'中国,山东省,莱芜市','level'=>'2','pinyin'=>'laiwu','code'=>'0634','zip_code'=>'271100','first'=>'L','lng'=>'117.677736','lat'=>'36.214397']);
        $this->insert('{{%region}}',['id'=>'1477','pid'=>'1476','shortname'=>'莱城','name'=>'莱城区','merger_name'=>'中国,山东省,莱芜市,莱城区','level'=>'3','pinyin'=>'laicheng','code'=>'0634','zip_code'=>'271199','first'=>'L','lng'=>'117.65986','lat'=>'36.2032']);
        $this->insert('{{%region}}',['id'=>'1478','pid'=>'1476','shortname'=>'钢城','name'=>'钢城区','merger_name'=>'中国,山东省,莱芜市,钢城区','level'=>'3','pinyin'=>'gangcheng','code'=>'0634','zip_code'=>'271100','first'=>'G','lng'=>'117.8049','lat'=>'36.06319']);
        $this->insert('{{%region}}',['id'=>'1479','pid'=>'1375','shortname'=>'临沂','name'=>'临沂市','merger_name'=>'中国,山东省,临沂市','level'=>'2','pinyin'=>'linyi','code'=>'0539','zip_code'=>'253000','first'=>'L','lng'=>'118.326443','lat'=>'35.065282']);
        $this->insert('{{%region}}',['id'=>'1480','pid'=>'1479','shortname'=>'兰山','name'=>'兰山区','merger_name'=>'中国,山东省,临沂市,兰山区','level'=>'3','pinyin'=>'lanshan','code'=>'0539','zip_code'=>'276002','first'=>'L','lng'=>'118.34817','lat'=>'35.06872']);
        $this->insert('{{%region}}',['id'=>'1481','pid'=>'1479','shortname'=>'罗庄','name'=>'罗庄区','merger_name'=>'中国,山东省,临沂市,罗庄区','level'=>'3','pinyin'=>'luozhuang','code'=>'0539','zip_code'=>'276022','first'=>'L','lng'=>'118.28466','lat'=>'34.99627']);
        $this->insert('{{%region}}',['id'=>'1482','pid'=>'1479','shortname'=>'河东','name'=>'河东区','merger_name'=>'中国,山东省,临沂市,河东区','level'=>'3','pinyin'=>'hedong','code'=>'0539','zip_code'=>'276034','first'=>'H','lng'=>'118.41055','lat'=>'35.08803']);
        $this->insert('{{%region}}',['id'=>'1483','pid'=>'1479','shortname'=>'沂南','name'=>'沂南县','merger_name'=>'中国,山东省,临沂市,沂南县','level'=>'3','pinyin'=>'yinan','code'=>'0539','zip_code'=>'276300','first'=>'Y','lng'=>'118.47061','lat'=>'35.55131']);
        $this->insert('{{%region}}',['id'=>'1484','pid'=>'1479','shortname'=>'郯城','name'=>'郯城县','merger_name'=>'中国,山东省,临沂市,郯城县','level'=>'3','pinyin'=>'tancheng','code'=>'0539','zip_code'=>'276100','first'=>NULL,'lng'=>'118.36712','lat'=>'34.61354']);
        $this->insert('{{%region}}',['id'=>'1485','pid'=>'1479','shortname'=>'沂水','name'=>'沂水县','merger_name'=>'中国,山东省,临沂市,沂水县','level'=>'3','pinyin'=>'yishui','code'=>'0539','zip_code'=>'276400','first'=>'Y','lng'=>'118.63009','lat'=>'35.78731']);
        $this->insert('{{%region}}',['id'=>'1486','pid'=>'1479','shortname'=>'兰陵','name'=>'兰陵县','merger_name'=>'中国,山东省,临沂市,兰陵县','level'=>'3','pinyin'=>'lanling','code'=>'0539','zip_code'=>'277700','first'=>'L','lng'=>'117.856592','lat'=>'34.738315']);
        $this->insert('{{%region}}',['id'=>'1487','pid'=>'1479','shortname'=>'费县','name'=>'费县','merger_name'=>'中国,山东省,临沂市,费县','level'=>'3','pinyin'=>'feixian','code'=>'0539','zip_code'=>'273400','first'=>'F','lng'=>'117.97836','lat'=>'35.26562']);
        $this->insert('{{%region}}',['id'=>'1488','pid'=>'1479','shortname'=>'平邑','name'=>'平邑县','merger_name'=>'中国,山东省,临沂市,平邑县','level'=>'3','pinyin'=>'pingyi','code'=>'0539','zip_code'=>'273300','first'=>'P','lng'=>'117.63867','lat'=>'35.50573']);
        $this->insert('{{%region}}',['id'=>'1489','pid'=>'1479','shortname'=>'莒南','name'=>'莒南县','merger_name'=>'中国,山东省,临沂市,莒南县','level'=>'3','pinyin'=>'junan','code'=>'0539','zip_code'=>'276600','first'=>NULL,'lng'=>'118.83227','lat'=>'35.17539']);
        $this->insert('{{%region}}',['id'=>'1490','pid'=>'1479','shortname'=>'蒙阴','name'=>'蒙阴县','merger_name'=>'中国,山东省,临沂市,蒙阴县','level'=>'3','pinyin'=>'mengyin','code'=>'0539','zip_code'=>'276200','first'=>'M','lng'=>'117.94592','lat'=>'35.70996']);
        $this->insert('{{%region}}',['id'=>'1491','pid'=>'1479','shortname'=>'临沭','name'=>'临沭县','merger_name'=>'中国,山东省,临沂市,临沭县','level'=>'3','pinyin'=>'linshu','code'=>'0539','zip_code'=>'276700','first'=>'L','lng'=>'118.65267','lat'=>'34.92091']);
        $this->insert('{{%region}}',['id'=>'1492','pid'=>'1375','shortname'=>'德州','name'=>'德州市','merger_name'=>'中国,山东省,德州市','level'=>'2','pinyin'=>'dezhou','code'=>'0534','zip_code'=>'253000','first'=>'D','lng'=>'116.307428','lat'=>'37.453968']);
        $this->insert('{{%region}}',['id'=>'1493','pid'=>'1492','shortname'=>'德城','name'=>'德城区','merger_name'=>'中国,山东省,德州市,德城区','level'=>'3','pinyin'=>'decheng','code'=>'0534','zip_code'=>'253012','first'=>'D','lng'=>'116.29943','lat'=>'37.45126']);
        $this->insert('{{%region}}',['id'=>'1494','pid'=>'1492','shortname'=>'陵城','name'=>'陵城区','merger_name'=>'中国,山东省,德州市,陵城区','level'=>'3','pinyin'=>'lingcheng','code'=>'0534','zip_code'=>'253500','first'=>'L','lng'=>'116.57601','lat'=>'37.33571']);
        $this->insert('{{%region}}',['id'=>'1495','pid'=>'1492','shortname'=>'宁津','name'=>'宁津县','merger_name'=>'中国,山东省,德州市,宁津县','level'=>'3','pinyin'=>'ningjin','code'=>'0534','zip_code'=>'253400','first'=>'N','lng'=>'116.79702','lat'=>'37.65301']);
        $this->insert('{{%region}}',['id'=>'1496','pid'=>'1492','shortname'=>'庆云','name'=>'庆云县','merger_name'=>'中国,山东省,德州市,庆云县','level'=>'3','pinyin'=>'qingyun','code'=>'0534','zip_code'=>'253700','first'=>'Q','lng'=>'117.38635','lat'=>'37.77616']);
        $this->insert('{{%region}}',['id'=>'1497','pid'=>'1492','shortname'=>'临邑','name'=>'临邑县','merger_name'=>'中国,山东省,德州市,临邑县','level'=>'3','pinyin'=>'linyi','code'=>'0534','zip_code'=>'251500','first'=>'L','lng'=>'116.86547','lat'=>'37.19053']);
        $this->insert('{{%region}}',['id'=>'1498','pid'=>'1492','shortname'=>'齐河','name'=>'齐河县','merger_name'=>'中国,山东省,德州市,齐河县','level'=>'3','pinyin'=>'qihe','code'=>'0534','zip_code'=>'251100','first'=>'Q','lng'=>'116.75515','lat'=>'36.79532']);
        $this->insert('{{%region}}',['id'=>'1499','pid'=>'1492','shortname'=>'平原','name'=>'平原县','merger_name'=>'中国,山东省,德州市,平原县','level'=>'3','pinyin'=>'pingyuan','code'=>'0534','zip_code'=>'253100','first'=>'P','lng'=>'116.43432','lat'=>'37.16632']);
        $this->insert('{{%region}}',['id'=>'1500','pid'=>'1492','shortname'=>'夏津','name'=>'夏津县','merger_name'=>'中国,山东省,德州市,夏津县','level'=>'3','pinyin'=>'xiajin','code'=>'0534','zip_code'=>'253200','first'=>'X','lng'=>'116.0017','lat'=>'36.94852']);
        $this->insert('{{%region}}',['id'=>'1501','pid'=>'1492','shortname'=>'武城','name'=>'武城县','merger_name'=>'中国,山东省,德州市,武城县','level'=>'3','pinyin'=>'wucheng','code'=>'0534','zip_code'=>'253300','first'=>'W','lng'=>'116.07009','lat'=>'37.21403']);
        $this->insert('{{%region}}',['id'=>'1502','pid'=>'1492','shortname'=>'乐陵','name'=>'乐陵市','merger_name'=>'中国,山东省,德州市,乐陵市','level'=>'3','pinyin'=>'leling','code'=>'0534','zip_code'=>'253600','first'=>'L','lng'=>'117.23141','lat'=>'37.73164']);
        $this->insert('{{%region}}',['id'=>'1503','pid'=>'1492','shortname'=>'禹城','name'=>'禹城市','merger_name'=>'中国,山东省,德州市,禹城市','level'=>'3','pinyin'=>'yucheng','code'=>'0534','zip_code'=>'251200','first'=>'Y','lng'=>'116.64309','lat'=>'36.93444']);
        $this->insert('{{%region}}',['id'=>'1504','pid'=>'1375','shortname'=>'聊城','name'=>'聊城市','merger_name'=>'中国,山东省,聊城市','level'=>'2','pinyin'=>'liaocheng','code'=>'0635','zip_code'=>'252052','first'=>'L','lng'=>'115.980367','lat'=>'36.456013']);
        $this->insert('{{%region}}',['id'=>'1505','pid'=>'1504','shortname'=>'东昌府','name'=>'东昌府区','merger_name'=>'中国,山东省,聊城市,东昌府区','level'=>'3','pinyin'=>'dongchangfu','code'=>'0635','zip_code'=>'252000','first'=>'D','lng'=>'115.97383','lat'=>'36.44458']);
        $this->insert('{{%region}}',['id'=>'1506','pid'=>'1504','shortname'=>'阳谷','name'=>'阳谷县','merger_name'=>'中国,山东省,聊城市,阳谷县','level'=>'3','pinyin'=>'yanggu','code'=>'0635','zip_code'=>'252300','first'=>'Y','lng'=>'115.79126','lat'=>'36.11444']);
        $this->insert('{{%region}}',['id'=>'1507','pid'=>'1504','shortname'=>'莘县','name'=>'莘县','merger_name'=>'中国,山东省,聊城市,莘县','level'=>'3','pinyin'=>'shenxian','code'=>'0635','zip_code'=>'252400','first'=>NULL,'lng'=>'115.6697','lat'=>'36.23423']);
        $this->insert('{{%region}}',['id'=>'1508','pid'=>'1504','shortname'=>'茌平','name'=>'茌平县','merger_name'=>'中国,山东省,聊城市,茌平县','level'=>'3','pinyin'=>'chiping','code'=>'0635','zip_code'=>'252100','first'=>NULL,'lng'=>'116.25491','lat'=>'36.57969']);
        $this->insert('{{%region}}',['id'=>'1509','pid'=>'1504','shortname'=>'东阿','name'=>'东阿县','merger_name'=>'中国,山东省,聊城市,东阿县','level'=>'3','pinyin'=>'dong\'e','code'=>'0635','zip_code'=>'252200','first'=>'D','lng'=>'116.25012','lat'=>'36.33209']);
        $this->insert('{{%region}}',['id'=>'1510','pid'=>'1504','shortname'=>'冠县','name'=>'冠县','merger_name'=>'中国,山东省,聊城市,冠县','level'=>'3','pinyin'=>'guanxian','code'=>'0635','zip_code'=>'252500','first'=>'G','lng'=>'115.44195','lat'=>'36.48429']);
        $this->insert('{{%region}}',['id'=>'1511','pid'=>'1504','shortname'=>'高唐','name'=>'高唐县','merger_name'=>'中国,山东省,聊城市,高唐县','level'=>'3','pinyin'=>'gaotang','code'=>'0635','zip_code'=>'252800','first'=>'G','lng'=>'116.23172','lat'=>'36.86535']);
        $this->insert('{{%region}}',['id'=>'1512','pid'=>'1504','shortname'=>'临清','name'=>'临清市','merger_name'=>'中国,山东省,聊城市,临清市','level'=>'3','pinyin'=>'linqing','code'=>'0635','zip_code'=>'252600','first'=>'L','lng'=>'115.70629','lat'=>'36.83945']);
        $this->insert('{{%region}}',['id'=>'1513','pid'=>'1375','shortname'=>'滨州','name'=>'滨州市','merger_name'=>'中国,山东省,滨州市','level'=>'2','pinyin'=>'binzhou','code'=>'0543','zip_code'=>'256619','first'=>'B','lng'=>'118.016974','lat'=>'37.383542']);
        $this->insert('{{%region}}',['id'=>'1514','pid'=>'1513','shortname'=>'滨城','name'=>'滨城区','merger_name'=>'中国,山东省,滨州市,滨城区','level'=>'3','pinyin'=>'bincheng','code'=>'0543','zip_code'=>'256613','first'=>'B','lng'=>'118.02026','lat'=>'37.38524']);
        $this->insert('{{%region}}',['id'=>'1515','pid'=>'1513','shortname'=>'沾化','name'=>'沾化区','merger_name'=>'中国,山东省,滨州市,沾化区','level'=>'3','pinyin'=>'zhanhua','code'=>'0543','zip_code'=>'256800','first'=>'Z','lng'=>'118.13214','lat'=>'37.69832']);
        $this->insert('{{%region}}',['id'=>'1516','pid'=>'1513','shortname'=>'惠民','name'=>'惠民县','merger_name'=>'中国,山东省,滨州市,惠民县','level'=>'3','pinyin'=>'huimin','code'=>'0543','zip_code'=>'251700','first'=>'H','lng'=>'117.51113','lat'=>'37.49013']);
        $this->insert('{{%region}}',['id'=>'1517','pid'=>'1513','shortname'=>'阳信','name'=>'阳信县','merger_name'=>'中国,山东省,滨州市,阳信县','level'=>'3','pinyin'=>'yangxin','code'=>'0543','zip_code'=>'251800','first'=>'Y','lng'=>'117.58139','lat'=>'37.64198']);
        $this->insert('{{%region}}',['id'=>'1518','pid'=>'1513','shortname'=>'无棣','name'=>'无棣县','merger_name'=>'中国,山东省,滨州市,无棣县','level'=>'3','pinyin'=>'wudi','code'=>'0543','zip_code'=>'251900','first'=>'W','lng'=>'117.61395','lat'=>'37.74009']);
        $this->insert('{{%region}}',['id'=>'1519','pid'=>'1513','shortname'=>'博兴','name'=>'博兴县','merger_name'=>'中国,山东省,滨州市,博兴县','level'=>'3','pinyin'=>'boxing','code'=>'0543','zip_code'=>'256500','first'=>'B','lng'=>'118.1336','lat'=>'37.14316']);
        $this->insert('{{%region}}',['id'=>'1520','pid'=>'1513','shortname'=>'邹平','name'=>'邹平县','merger_name'=>'中国,山东省,滨州市,邹平县','level'=>'3','pinyin'=>'zouping','code'=>'0543','zip_code'=>'256200','first'=>'Z','lng'=>'117.74307','lat'=>'36.86295']);
        $this->insert('{{%region}}',['id'=>'1521','pid'=>'1513','shortname'=>'北海新区','name'=>'北海新区','merger_name'=>'中国,山东省,滨州市,北海新区','level'=>'3','pinyin'=>'beihaixinqu','code'=>'0543','zip_code'=>'256200','first'=>'B','lng'=>'118.016974','lat'=>'37.383542']);
        $this->insert('{{%region}}',['id'=>'1522','pid'=>'1375','shortname'=>'菏泽','name'=>'菏泽市','merger_name'=>'中国,山东省,菏泽市','level'=>'2','pinyin'=>'heze','code'=>'0530','zip_code'=>'274020','first'=>'H','lng'=>'115.469381','lat'=>'35.246531']);
        $this->insert('{{%region}}',['id'=>'1523','pid'=>'1522','shortname'=>'牡丹','name'=>'牡丹区','merger_name'=>'中国,山东省,菏泽市,牡丹区','level'=>'3','pinyin'=>'mudan','code'=>'0530','zip_code'=>'274009','first'=>'M','lng'=>'115.41662','lat'=>'35.25091']);
        $this->insert('{{%region}}',['id'=>'1524','pid'=>'1522','shortname'=>'曹县','name'=>'曹县','merger_name'=>'中国,山东省,菏泽市,曹县','level'=>'3','pinyin'=>'caoxian','code'=>'0530','zip_code'=>'274400','first'=>'C','lng'=>'115.54226','lat'=>'34.82659']);
        $this->insert('{{%region}}',['id'=>'1525','pid'=>'1522','shortname'=>'单县','name'=>'单县','merger_name'=>'中国,山东省,菏泽市,单县','level'=>'3','pinyin'=>'shanxian','code'=>'0530','zip_code'=>'273700','first'=>'D','lng'=>'116.08703','lat'=>'34.79514']);
        $this->insert('{{%region}}',['id'=>'1526','pid'=>'1522','shortname'=>'成武','name'=>'成武县','merger_name'=>'中国,山东省,菏泽市,成武县','level'=>'3','pinyin'=>'chengwu','code'=>'0530','zip_code'=>'274200','first'=>'C','lng'=>'115.8897','lat'=>'34.95332']);
        $this->insert('{{%region}}',['id'=>'1527','pid'=>'1522','shortname'=>'巨野','name'=>'巨野县','merger_name'=>'中国,山东省,菏泽市,巨野县','level'=>'3','pinyin'=>'juye','code'=>'0530','zip_code'=>'274900','first'=>'J','lng'=>'116.09497','lat'=>'35.39788']);
        $this->insert('{{%region}}',['id'=>'1528','pid'=>'1522','shortname'=>'郓城','name'=>'郓城县','merger_name'=>'中国,山东省,菏泽市,郓城县','level'=>'3','pinyin'=>'yuncheng','code'=>'0530','zip_code'=>'274700','first'=>NULL,'lng'=>'115.94439','lat'=>'35.60044']);
        $this->insert('{{%region}}',['id'=>'1529','pid'=>'1522','shortname'=>'鄄城','name'=>'鄄城县','merger_name'=>'中国,山东省,菏泽市,鄄城县','level'=>'3','pinyin'=>'juancheng','code'=>'0530','zip_code'=>'274600','first'=>NULL,'lng'=>'115.50997','lat'=>'35.56412']);
        $this->insert('{{%region}}',['id'=>'1530','pid'=>'1522','shortname'=>'定陶','name'=>'定陶县','merger_name'=>'中国,山东省,菏泽市,定陶县','level'=>'3','pinyin'=>'dingtao','code'=>'0530','zip_code'=>'274100','first'=>'D','lng'=>'115.57287','lat'=>'35.07118']);
        $this->insert('{{%region}}',['id'=>'1531','pid'=>'1522','shortname'=>'东明','name'=>'东明县','merger_name'=>'中国,山东省,菏泽市,东明县','level'=>'3','pinyin'=>'dongming','code'=>'0530','zip_code'=>'274500','first'=>'D','lng'=>'115.09079','lat'=>'35.28906']);
        $this->insert('{{%region}}',['id'=>'1532','pid'=>'0','shortname'=>'河南','name'=>'河南省','merger_name'=>'中国,河南省','level'=>'1','pinyin'=>'henan','code'=>'','zip_code'=>'','first'=>'H','lng'=>'113.665412','lat'=>'34.757975']);
        $this->insert('{{%region}}',['id'=>'1533','pid'=>'1532','shortname'=>'郑州','name'=>'郑州市','merger_name'=>'中国,河南省,郑州市','level'=>'2','pinyin'=>'zhengzhou','code'=>'0371','zip_code'=>'450000','first'=>'Z','lng'=>'113.665412','lat'=>'34.757975']);
        $this->insert('{{%region}}',['id'=>'1534','pid'=>'1533','shortname'=>'中原','name'=>'中原区','merger_name'=>'中国,河南省,郑州市,中原区','level'=>'3','pinyin'=>'zhongyuan','code'=>'0371','zip_code'=>'450007','first'=>'Z','lng'=>'113.61333','lat'=>'34.74827']);
        $this->insert('{{%region}}',['id'=>'1535','pid'=>'1533','shortname'=>'二七','name'=>'二七区','merger_name'=>'中国,河南省,郑州市,二七区','level'=>'3','pinyin'=>'erqi','code'=>'0371','zip_code'=>'450052','first'=>'E','lng'=>'113.63931','lat'=>'34.72336']);
        $this->insert('{{%region}}',['id'=>'1536','pid'=>'1533','shortname'=>'管城','name'=>'管城回族区','merger_name'=>'中国,河南省,郑州市,管城回族区','level'=>'3','pinyin'=>'guancheng','code'=>'0371','zip_code'=>'450000','first'=>'G','lng'=>'113.67734','lat'=>'34.75383']);
        $this->insert('{{%region}}',['id'=>'1537','pid'=>'1533','shortname'=>'金水','name'=>'金水区','merger_name'=>'中国,河南省,郑州市,金水区','level'=>'3','pinyin'=>'jinshui','code'=>'0371','zip_code'=>'450003','first'=>'J','lng'=>'113.66057','lat'=>'34.80028']);
        $this->insert('{{%region}}',['id'=>'1538','pid'=>'1533','shortname'=>'上街','name'=>'上街区','merger_name'=>'中国,河南省,郑州市,上街区','level'=>'3','pinyin'=>'shangjie','code'=>'0371','zip_code'=>'450041','first'=>'S','lng'=>'113.30897','lat'=>'34.80276']);
        $this->insert('{{%region}}',['id'=>'1539','pid'=>'1533','shortname'=>'惠济','name'=>'惠济区','merger_name'=>'中国,河南省,郑州市,惠济区','level'=>'3','pinyin'=>'huiji','code'=>'0371','zip_code'=>'450053','first'=>'H','lng'=>'113.61688','lat'=>'34.86735']);
        $this->insert('{{%region}}',['id'=>'1540','pid'=>'1533','shortname'=>'中牟','name'=>'中牟县','merger_name'=>'中国,河南省,郑州市,中牟县','level'=>'3','pinyin'=>'zhongmu','code'=>'0371','zip_code'=>'451450','first'=>'Z','lng'=>'113.97619','lat'=>'34.71899']);
        $this->insert('{{%region}}',['id'=>'1541','pid'=>'1533','shortname'=>'巩义','name'=>'巩义市','merger_name'=>'中国,河南省,郑州市,巩义市','level'=>'3','pinyin'=>'gongyi','code'=>'0371','zip_code'=>'451200','first'=>'G','lng'=>'113.022','lat'=>'34.74794']);
        $this->insert('{{%region}}',['id'=>'1542','pid'=>'1533','shortname'=>'荥阳','name'=>'荥阳市','merger_name'=>'中国,河南省,郑州市,荥阳市','level'=>'3','pinyin'=>'xingyang','code'=>'0371','zip_code'=>'450100','first'=>NULL,'lng'=>'113.38345','lat'=>'34.78759']);
        $this->insert('{{%region}}',['id'=>'1543','pid'=>'1533','shortname'=>'新密','name'=>'新密市','merger_name'=>'中国,河南省,郑州市,新密市','level'=>'3','pinyin'=>'xinmi','code'=>'0371','zip_code'=>'452300','first'=>'X','lng'=>'113.3869','lat'=>'34.53704']);
        $this->insert('{{%region}}',['id'=>'1544','pid'=>'1533','shortname'=>'新郑','name'=>'新郑市','merger_name'=>'中国,河南省,郑州市,新郑市','level'=>'3','pinyin'=>'xinzheng','code'=>'0371','zip_code'=>'451100','first'=>'X','lng'=>'113.73645','lat'=>'34.3955']);
        $this->insert('{{%region}}',['id'=>'1545','pid'=>'1533','shortname'=>'登封','name'=>'登封市','merger_name'=>'中国,河南省,郑州市,登封市','level'=>'3','pinyin'=>'dengfeng','code'=>'0371','zip_code'=>'452470','first'=>'D','lng'=>'113.05023','lat'=>'34.45345']);
        $this->insert('{{%region}}',['id'=>'1546','pid'=>'1532','shortname'=>'开封','name'=>'开封市','merger_name'=>'中国,河南省,开封市','level'=>'2','pinyin'=>'kaifeng','code'=>'0378','zip_code'=>'475001','first'=>'K','lng'=>'114.341447','lat'=>'34.797049']);
        $this->insert('{{%region}}',['id'=>'1547','pid'=>'1546','shortname'=>'龙亭','name'=>'龙亭区','merger_name'=>'中国,河南省,开封市,龙亭区','level'=>'3','pinyin'=>'longting','code'=>'0378','zip_code'=>'475100','first'=>'L','lng'=>'114.35484','lat'=>'34.79995']);
        $this->insert('{{%region}}',['id'=>'1548','pid'=>'1546','shortname'=>'顺河','name'=>'顺河回族区','merger_name'=>'中国,河南省,开封市,顺河回族区','level'=>'3','pinyin'=>'shunhe','code'=>'0378','zip_code'=>'475000','first'=>'S','lng'=>'114.36123','lat'=>'34.79586']);
        $this->insert('{{%region}}',['id'=>'1549','pid'=>'1546','shortname'=>'鼓楼','name'=>'鼓楼区','merger_name'=>'中国,河南省,开封市,鼓楼区','level'=>'3','pinyin'=>'gulou','code'=>'0378','zip_code'=>'475000','first'=>'G','lng'=>'114.35559','lat'=>'34.79517']);
        $this->insert('{{%region}}',['id'=>'1550','pid'=>'1546','shortname'=>'禹王台','name'=>'禹王台区','merger_name'=>'中国,河南省,开封市,禹王台区','level'=>'3','pinyin'=>'yuwangtai','code'=>'0378','zip_code'=>'475003','first'=>'Y','lng'=>'114.34787','lat'=>'34.77693']);
        $this->insert('{{%region}}',['id'=>'1551','pid'=>'1546','shortname'=>'祥符','name'=>'祥符区','merger_name'=>'中国,河南省,开封市,祥符区','level'=>'3','pinyin'=>'xiangfu','code'=>'0378','zip_code'=>'475100','first'=>'X','lng'=>'114.43859','lat'=>'34.75874']);
        $this->insert('{{%region}}',['id'=>'1552','pid'=>'1546','shortname'=>'杞县','name'=>'杞县','merger_name'=>'中国,河南省,开封市,杞县','level'=>'3','pinyin'=>'qixian','code'=>'0378','zip_code'=>'475200','first'=>NULL,'lng'=>'114.7828','lat'=>'34.55033']);
        $this->insert('{{%region}}',['id'=>'1553','pid'=>'1546','shortname'=>'通许','name'=>'通许县','merger_name'=>'中国,河南省,开封市,通许县','level'=>'3','pinyin'=>'tongxu','code'=>'0378','zip_code'=>'475400','first'=>'T','lng'=>'114.46716','lat'=>'34.47522']);
        $this->insert('{{%region}}',['id'=>'1554','pid'=>'1546','shortname'=>'尉氏','name'=>'尉氏县','merger_name'=>'中国,河南省,开封市,尉氏县','level'=>'3','pinyin'=>'weishi','code'=>'0378','zip_code'=>'475500','first'=>'W','lng'=>'114.19284','lat'=>'34.41223']);
        $this->insert('{{%region}}',['id'=>'1555','pid'=>'1546','shortname'=>'兰考','name'=>'兰考县','merger_name'=>'中国,河南省,开封市,兰考县','level'=>'3','pinyin'=>'lankao','code'=>'0378','zip_code'=>'475300','first'=>'L','lng'=>'114.81961','lat'=>'34.8235']);
        $this->insert('{{%region}}',['id'=>'1556','pid'=>'1532','shortname'=>'洛阳','name'=>'洛阳市','merger_name'=>'中国,河南省,洛阳市','level'=>'2','pinyin'=>'luoyang','code'=>'0379','zip_code'=>'471000','first'=>'L','lng'=>'112.434468','lat'=>'34.663041']);
        $this->insert('{{%region}}',['id'=>'1557','pid'=>'1556','shortname'=>'老城','name'=>'老城区','merger_name'=>'中国,河南省,洛阳市,老城区','level'=>'3','pinyin'=>'laocheng','code'=>'0379','zip_code'=>'471002','first'=>'L','lng'=>'112.46902','lat'=>'34.68364']);
        $this->insert('{{%region}}',['id'=>'1558','pid'=>'1556','shortname'=>'西工','name'=>'西工区','merger_name'=>'中国,河南省,洛阳市,西工区','level'=>'3','pinyin'=>'xigong','code'=>'0379','zip_code'=>'471000','first'=>'X','lng'=>'112.4371','lat'=>'34.67']);
        $this->insert('{{%region}}',['id'=>'1559','pid'=>'1556','shortname'=>'瀍河','name'=>'瀍河回族区','merger_name'=>'中国,河南省,洛阳市,瀍河回族区','level'=>'3','pinyin'=>'chanhe','code'=>'0379','zip_code'=>'471002','first'=>NULL,'lng'=>'112.50018','lat'=>'34.67985']);
        $this->insert('{{%region}}',['id'=>'1560','pid'=>'1556','shortname'=>'涧西','name'=>'涧西区','merger_name'=>'中国,河南省,洛阳市,涧西区','level'=>'3','pinyin'=>'jianxi','code'=>'0379','zip_code'=>'471003','first'=>'J','lng'=>'112.39588','lat'=>'34.65823']);
        $this->insert('{{%region}}',['id'=>'1561','pid'=>'1556','shortname'=>'吉利','name'=>'吉利区','merger_name'=>'中国,河南省,洛阳市,吉利区','level'=>'3','pinyin'=>'jili','code'=>'0379','zip_code'=>'471012','first'=>'J','lng'=>'112.58905','lat'=>'34.90088']);
        $this->insert('{{%region}}',['id'=>'1562','pid'=>'1556','shortname'=>'洛龙','name'=>'洛龙区','merger_name'=>'中国,河南省,洛阳市,洛龙区','level'=>'3','pinyin'=>'luolong','code'=>'0379','zip_code'=>'471000','first'=>'L','lng'=>'112.46412','lat'=>'34.61866']);
        $this->insert('{{%region}}',['id'=>'1563','pid'=>'1556','shortname'=>'孟津','name'=>'孟津县','merger_name'=>'中国,河南省,洛阳市,孟津县','level'=>'3','pinyin'=>'mengjin','code'=>'0379','zip_code'=>'471100','first'=>'M','lng'=>'112.44351','lat'=>'34.826']);
        $this->insert('{{%region}}',['id'=>'1564','pid'=>'1556','shortname'=>'新安','name'=>'新安县','merger_name'=>'中国,河南省,洛阳市,新安县','level'=>'3','pinyin'=>'xin\'an','code'=>'0379','zip_code'=>'471800','first'=>'X','lng'=>'112.13238','lat'=>'34.72814']);
        $this->insert('{{%region}}',['id'=>'1565','pid'=>'1556','shortname'=>'栾川','name'=>'栾川县','merger_name'=>'中国,河南省,洛阳市,栾川县','level'=>'3','pinyin'=>'luanchuan','code'=>'0379','zip_code'=>'471500','first'=>NULL,'lng'=>'111.61779','lat'=>'33.78576']);
        $this->insert('{{%region}}',['id'=>'1566','pid'=>'1556','shortname'=>'嵩县','name'=>'嵩县','merger_name'=>'中国,河南省,洛阳市,嵩县','level'=>'3','pinyin'=>'songxian','code'=>'0379','zip_code'=>'471400','first'=>NULL,'lng'=>'112.08526','lat'=>'34.13466']);
        $this->insert('{{%region}}',['id'=>'1567','pid'=>'1556','shortname'=>'汝阳','name'=>'汝阳县','merger_name'=>'中国,河南省,洛阳市,汝阳县','level'=>'3','pinyin'=>'ruyang','code'=>'0379','zip_code'=>'471200','first'=>'R','lng'=>'112.47314','lat'=>'34.15387']);
        $this->insert('{{%region}}',['id'=>'1568','pid'=>'1556','shortname'=>'宜阳','name'=>'宜阳县','merger_name'=>'中国,河南省,洛阳市,宜阳县','level'=>'3','pinyin'=>'yiyang','code'=>'0379','zip_code'=>'471600','first'=>'Y','lng'=>'112.17907','lat'=>'34.51523']);
        $this->insert('{{%region}}',['id'=>'1569','pid'=>'1556','shortname'=>'洛宁','name'=>'洛宁县','merger_name'=>'中国,河南省,洛阳市,洛宁县','level'=>'3','pinyin'=>'luoning','code'=>'0379','zip_code'=>'471700','first'=>'L','lng'=>'111.65087','lat'=>'34.38913']);
        $this->insert('{{%region}}',['id'=>'1570','pid'=>'1556','shortname'=>'伊川','name'=>'伊川县','merger_name'=>'中国,河南省,洛阳市,伊川县','level'=>'3','pinyin'=>'yichuan','code'=>'0379','zip_code'=>'471300','first'=>'Y','lng'=>'112.42947','lat'=>'34.42205']);
        $this->insert('{{%region}}',['id'=>'1571','pid'=>'1556','shortname'=>'偃师','name'=>'偃师市','merger_name'=>'中国,河南省,洛阳市,偃师市','level'=>'3','pinyin'=>'yanshi','code'=>'0379','zip_code'=>'471900','first'=>NULL,'lng'=>'112.7922','lat'=>'34.7281']);
        $this->insert('{{%region}}',['id'=>'1572','pid'=>'1532','shortname'=>'平顶山','name'=>'平顶山市','merger_name'=>'中国,河南省,平顶山市','level'=>'2','pinyin'=>'pingdingshan','code'=>'0375','zip_code'=>'467000','first'=>'P','lng'=>'113.307718','lat'=>'33.735241']);
        $this->insert('{{%region}}',['id'=>'1573','pid'=>'1572','shortname'=>'新华','name'=>'新华区','merger_name'=>'中国,河南省,平顶山市,新华区','level'=>'3','pinyin'=>'xinhua','code'=>'0375','zip_code'=>'467002','first'=>'X','lng'=>'113.29402','lat'=>'33.7373']);
        $this->insert('{{%region}}',['id'=>'1574','pid'=>'1572','shortname'=>'卫东','name'=>'卫东区','merger_name'=>'中国,河南省,平顶山市,卫东区','level'=>'3','pinyin'=>'weidong','code'=>'0375','zip_code'=>'467021','first'=>'W','lng'=>'113.33511','lat'=>'33.73472']);
        $this->insert('{{%region}}',['id'=>'1575','pid'=>'1572','shortname'=>'石龙','name'=>'石龙区','merger_name'=>'中国,河南省,平顶山市,石龙区','level'=>'3','pinyin'=>'shilong','code'=>'0375','zip_code'=>'467045','first'=>'S','lng'=>'112.89879','lat'=>'33.89878']);
        $this->insert('{{%region}}',['id'=>'1576','pid'=>'1572','shortname'=>'湛河','name'=>'湛河区','merger_name'=>'中国,河南省,平顶山市,湛河区','level'=>'3','pinyin'=>'zhanhe','code'=>'0375','zip_code'=>'467000','first'=>'Z','lng'=>'113.29252','lat'=>'33.7362']);
        $this->insert('{{%region}}',['id'=>'1577','pid'=>'1572','shortname'=>'宝丰','name'=>'宝丰县','merger_name'=>'中国,河南省,平顶山市,宝丰县','level'=>'3','pinyin'=>'baofeng','code'=>'0375','zip_code'=>'467400','first'=>'B','lng'=>'113.05493','lat'=>'33.86916']);
        $this->insert('{{%region}}',['id'=>'1578','pid'=>'1572','shortname'=>'叶县','name'=>'叶县','merger_name'=>'中国,河南省,平顶山市,叶县','level'=>'3','pinyin'=>'yexian','code'=>'0375','zip_code'=>'467200','first'=>'Y','lng'=>'113.35104','lat'=>'33.62225']);
        $this->insert('{{%region}}',['id'=>'1579','pid'=>'1572','shortname'=>'鲁山','name'=>'鲁山县','merger_name'=>'中国,河南省,平顶山市,鲁山县','level'=>'3','pinyin'=>'lushan','code'=>'0375','zip_code'=>'467300','first'=>'L','lng'=>'112.9057','lat'=>'33.73879']);
        $this->insert('{{%region}}',['id'=>'1580','pid'=>'1572','shortname'=>'郏县','name'=>'郏县','merger_name'=>'中国,河南省,平顶山市,郏县','level'=>'3','pinyin'=>'jiaxian','code'=>'0375','zip_code'=>'467100','first'=>NULL,'lng'=>'113.21588','lat'=>'33.97072']);
        $this->insert('{{%region}}',['id'=>'1581','pid'=>'1572','shortname'=>'舞钢','name'=>'舞钢市','merger_name'=>'中国,河南省,平顶山市,舞钢市','level'=>'3','pinyin'=>'wugang','code'=>'0375','zip_code'=>'462500','first'=>'W','lng'=>'113.52417','lat'=>'33.2938']);
        $this->insert('{{%region}}',['id'=>'1582','pid'=>'1572','shortname'=>'汝州','name'=>'汝州市','merger_name'=>'中国,河南省,平顶山市,汝州市','level'=>'3','pinyin'=>'ruzhou','code'=>'0375','zip_code'=>'467500','first'=>'R','lng'=>'112.84301','lat'=>'34.16135']);
        $this->insert('{{%region}}',['id'=>'1583','pid'=>'1532','shortname'=>'安阳','name'=>'安阳市','merger_name'=>'中国,河南省,安阳市','level'=>'2','pinyin'=>'anyang','code'=>'0372','zip_code'=>'455000','first'=>'A','lng'=>'114.352482','lat'=>'36.103442']);
        $this->insert('{{%region}}',['id'=>'1584','pid'=>'1583','shortname'=>'文峰','name'=>'文峰区','merger_name'=>'中国,河南省,安阳市,文峰区','level'=>'3','pinyin'=>'wenfeng','code'=>'0372','zip_code'=>'455000','first'=>'W','lng'=>'114.35708','lat'=>'36.09046']);
        $this->insert('{{%region}}',['id'=>'1585','pid'=>'1583','shortname'=>'北关','name'=>'北关区','merger_name'=>'中国,河南省,安阳市,北关区','level'=>'3','pinyin'=>'beiguan','code'=>'0372','zip_code'=>'455001','first'=>'B','lng'=>'114.35735','lat'=>'36.11872']);
        $this->insert('{{%region}}',['id'=>'1586','pid'=>'1583','shortname'=>'殷都','name'=>'殷都区','merger_name'=>'中国,河南省,安阳市,殷都区','level'=>'3','pinyin'=>'yindu','code'=>'0372','zip_code'=>'455004','first'=>'Y','lng'=>'114.3034','lat'=>'36.1099']);
        $this->insert('{{%region}}',['id'=>'1587','pid'=>'1583','shortname'=>'龙安','name'=>'龙安区','merger_name'=>'中国,河南省,安阳市,龙安区','level'=>'3','pinyin'=>'long\'an','code'=>'0372','zip_code'=>'455001','first'=>'L','lng'=>'114.34814','lat'=>'36.11904']);
        $this->insert('{{%region}}',['id'=>'1588','pid'=>'1583','shortname'=>'安阳','name'=>'安阳县','merger_name'=>'中国,河南省,安阳市,安阳县','level'=>'3','pinyin'=>'anyang','code'=>'0372','zip_code'=>'455000','first'=>'A','lng'=>'114.36605','lat'=>'36.06695']);
        $this->insert('{{%region}}',['id'=>'1589','pid'=>'1583','shortname'=>'汤阴','name'=>'汤阴县','merger_name'=>'中国,河南省,安阳市,汤阴县','level'=>'3','pinyin'=>'tangyin','code'=>'0372','zip_code'=>'456150','first'=>'T','lng'=>'114.35839','lat'=>'35.92152']);
        $this->insert('{{%region}}',['id'=>'1590','pid'=>'1583','shortname'=>'滑县','name'=>'滑县','merger_name'=>'中国,河南省,安阳市,滑县','level'=>'3','pinyin'=>'huaxian','code'=>'0372','zip_code'=>'456400','first'=>'H','lng'=>'114.52066','lat'=>'35.5807']);
        $this->insert('{{%region}}',['id'=>'1591','pid'=>'1583','shortname'=>'内黄','name'=>'内黄县','merger_name'=>'中国,河南省,安阳市,内黄县','level'=>'3','pinyin'=>'neihuang','code'=>'0372','zip_code'=>'456350','first'=>'N','lng'=>'114.90673','lat'=>'35.95269']);
        $this->insert('{{%region}}',['id'=>'1592','pid'=>'1583','shortname'=>'林州','name'=>'林州市','merger_name'=>'中国,河南省,安阳市,林州市','level'=>'3','pinyin'=>'linzhou','code'=>'0372','zip_code'=>'456550','first'=>'L','lng'=>'113.81558','lat'=>'36.07804']);
        $this->insert('{{%region}}',['id'=>'1593','pid'=>'1532','shortname'=>'鹤壁','name'=>'鹤壁市','merger_name'=>'中国,河南省,鹤壁市','level'=>'2','pinyin'=>'hebi','code'=>'0392','zip_code'=>'458030','first'=>'H','lng'=>'114.295444','lat'=>'35.748236']);
        $this->insert('{{%region}}',['id'=>'1594','pid'=>'1593','shortname'=>'鹤山','name'=>'鹤山区','merger_name'=>'中国,河南省,鹤壁市,鹤山区','level'=>'3','pinyin'=>'heshan','code'=>'0392','zip_code'=>'458010','first'=>'H','lng'=>'114.16336','lat'=>'35.95458']);
        $this->insert('{{%region}}',['id'=>'1595','pid'=>'1593','shortname'=>'山城','name'=>'山城区','merger_name'=>'中国,河南省,鹤壁市,山城区','level'=>'3','pinyin'=>'shancheng','code'=>'0392','zip_code'=>'458000','first'=>'S','lng'=>'114.18443','lat'=>'35.89773']);
        $this->insert('{{%region}}',['id'=>'1596','pid'=>'1593','shortname'=>'淇滨','name'=>'淇滨区','merger_name'=>'中国,河南省,鹤壁市,淇滨区','level'=>'3','pinyin'=>'qibin','code'=>'0392','zip_code'=>'458000','first'=>NULL,'lng'=>'114.29867','lat'=>'35.74127']);
        $this->insert('{{%region}}',['id'=>'1597','pid'=>'1593','shortname'=>'浚县','name'=>'浚县','merger_name'=>'中国,河南省,鹤壁市,浚县','level'=>'3','pinyin'=>'xunxian','code'=>'0392','zip_code'=>'456250','first'=>'J','lng'=>'114.54879','lat'=>'35.67085']);
        $this->insert('{{%region}}',['id'=>'1598','pid'=>'1593','shortname'=>'淇县','name'=>'淇县','merger_name'=>'中国,河南省,鹤壁市,淇县','level'=>'3','pinyin'=>'qixian','code'=>'0392','zip_code'=>'456750','first'=>NULL,'lng'=>'114.1976','lat'=>'35.60782']);
        $this->insert('{{%region}}',['id'=>'1599','pid'=>'1532','shortname'=>'新乡','name'=>'新乡市','merger_name'=>'中国,河南省,新乡市','level'=>'2','pinyin'=>'xinxiang','code'=>'0373','zip_code'=>'453000','first'=>'X','lng'=>'113.883991','lat'=>'35.302616']);
        $this->insert('{{%region}}',['id'=>'1600','pid'=>'1599','shortname'=>'红旗','name'=>'红旗区','merger_name'=>'中国,河南省,新乡市,红旗区','level'=>'3','pinyin'=>'hongqi','code'=>'0373','zip_code'=>'453000','first'=>'H','lng'=>'113.87523','lat'=>'35.30367']);
        $this->insert('{{%region}}',['id'=>'1601','pid'=>'1599','shortname'=>'卫滨','name'=>'卫滨区','merger_name'=>'中国,河南省,新乡市,卫滨区','level'=>'3','pinyin'=>'weibin','code'=>'0373','zip_code'=>'453000','first'=>'W','lng'=>'113.86578','lat'=>'35.30211']);
        $this->insert('{{%region}}',['id'=>'1602','pid'=>'1599','shortname'=>'凤泉','name'=>'凤泉区','merger_name'=>'中国,河南省,新乡市,凤泉区','level'=>'3','pinyin'=>'fengquan','code'=>'0373','zip_code'=>'453011','first'=>'F','lng'=>'113.91507','lat'=>'35.38399']);
        $this->insert('{{%region}}',['id'=>'1603','pid'=>'1599','shortname'=>'牧野','name'=>'牧野区','merger_name'=>'中国,河南省,新乡市,牧野区','level'=>'3','pinyin'=>'muye','code'=>'0373','zip_code'=>'453002','first'=>'M','lng'=>'113.9086','lat'=>'35.3149']);
        $this->insert('{{%region}}',['id'=>'1604','pid'=>'1599','shortname'=>'新乡','name'=>'新乡县','merger_name'=>'中国,河南省,新乡市,新乡县','level'=>'3','pinyin'=>'xinxiang','code'=>'0373','zip_code'=>'453700','first'=>'X','lng'=>'113.80511','lat'=>'35.19075']);
        $this->insert('{{%region}}',['id'=>'1605','pid'=>'1599','shortname'=>'获嘉','name'=>'获嘉县','merger_name'=>'中国,河南省,新乡市,获嘉县','level'=>'3','pinyin'=>'huojia','code'=>'0373','zip_code'=>'453800','first'=>'H','lng'=>'113.66159','lat'=>'35.26521']);
        $this->insert('{{%region}}',['id'=>'1606','pid'=>'1599','shortname'=>'原阳','name'=>'原阳县','merger_name'=>'中国,河南省,新乡市,原阳县','level'=>'3','pinyin'=>'yuanyang','code'=>'0373','zip_code'=>'453500','first'=>'Y','lng'=>'113.93994','lat'=>'35.06565']);
        $this->insert('{{%region}}',['id'=>'1607','pid'=>'1599','shortname'=>'延津','name'=>'延津县','merger_name'=>'中国,河南省,新乡市,延津县','level'=>'3','pinyin'=>'yanjin','code'=>'0373','zip_code'=>'453200','first'=>'Y','lng'=>'114.20266','lat'=>'35.14327']);
        $this->insert('{{%region}}',['id'=>'1608','pid'=>'1599','shortname'=>'封丘','name'=>'封丘县','merger_name'=>'中国,河南省,新乡市,封丘县','level'=>'3','pinyin'=>'fengqiu','code'=>'0373','zip_code'=>'453300','first'=>'F','lng'=>'114.41915','lat'=>'35.04166']);
        $this->insert('{{%region}}',['id'=>'1609','pid'=>'1599','shortname'=>'长垣','name'=>'长垣县','merger_name'=>'中国,河南省,新乡市,长垣县','level'=>'3','pinyin'=>'changyuan','code'=>'0373','zip_code'=>'453400','first'=>'C','lng'=>'114.66882','lat'=>'35.20046']);
        $this->insert('{{%region}}',['id'=>'1610','pid'=>'1599','shortname'=>'卫辉','name'=>'卫辉市','merger_name'=>'中国,河南省,新乡市,卫辉市','level'=>'3','pinyin'=>'weihui','code'=>'0373','zip_code'=>'453100','first'=>'W','lng'=>'114.06454','lat'=>'35.39843']);
        $this->insert('{{%region}}',['id'=>'1611','pid'=>'1599','shortname'=>'辉县','name'=>'辉县市','merger_name'=>'中国,河南省,新乡市,辉县市','level'=>'3','pinyin'=>'huixian','code'=>'0373','zip_code'=>'453600','first'=>'H','lng'=>'113.8067','lat'=>'35.46307']);
        $this->insert('{{%region}}',['id'=>'1612','pid'=>'1532','shortname'=>'焦作','name'=>'焦作市','merger_name'=>'中国,河南省,焦作市','level'=>'2','pinyin'=>'jiaozuo','code'=>'0391','zip_code'=>'454002','first'=>'J','lng'=>'113.238266','lat'=>'35.23904']);
        $this->insert('{{%region}}',['id'=>'1613','pid'=>'1612','shortname'=>'解放','name'=>'解放区','merger_name'=>'中国,河南省,焦作市,解放区','level'=>'3','pinyin'=>'jiefang','code'=>'0391','zip_code'=>'454000','first'=>'J','lng'=>'113.22933','lat'=>'35.24023']);
        $this->insert('{{%region}}',['id'=>'1614','pid'=>'1612','shortname'=>'中站','name'=>'中站区','merger_name'=>'中国,河南省,焦作市,中站区','level'=>'3','pinyin'=>'zhongzhan','code'=>'0391','zip_code'=>'454191','first'=>'Z','lng'=>'113.18315','lat'=>'35.23665']);
        $this->insert('{{%region}}',['id'=>'1615','pid'=>'1612','shortname'=>'马村','name'=>'马村区','merger_name'=>'中国,河南省,焦作市,马村区','level'=>'3','pinyin'=>'macun','code'=>'0391','zip_code'=>'454171','first'=>'M','lng'=>'113.3187','lat'=>'35.26908']);
        $this->insert('{{%region}}',['id'=>'1616','pid'=>'1612','shortname'=>'山阳','name'=>'山阳区','merger_name'=>'中国,河南省,焦作市,山阳区','level'=>'3','pinyin'=>'shanyang','code'=>'0391','zip_code'=>'454002','first'=>'S','lng'=>'113.25464','lat'=>'35.21436']);
        $this->insert('{{%region}}',['id'=>'1617','pid'=>'1612','shortname'=>'修武','name'=>'修武县','merger_name'=>'中国,河南省,焦作市,修武县','level'=>'3','pinyin'=>'xiuwu','code'=>'0391','zip_code'=>'454350','first'=>'X','lng'=>'113.44775','lat'=>'35.22357']);
        $this->insert('{{%region}}',['id'=>'1618','pid'=>'1612','shortname'=>'博爱','name'=>'博爱县','merger_name'=>'中国,河南省,焦作市,博爱县','level'=>'3','pinyin'=>'boai','code'=>'0391','zip_code'=>'454450','first'=>'B','lng'=>'113.06698','lat'=>'35.16943']);
        $this->insert('{{%region}}',['id'=>'1619','pid'=>'1612','shortname'=>'武陟','name'=>'武陟县','merger_name'=>'中国,河南省,焦作市,武陟县','level'=>'3','pinyin'=>'wuzhi','code'=>'0391','zip_code'=>'454950','first'=>'W','lng'=>'113.39718','lat'=>'35.09505']);
        $this->insert('{{%region}}',['id'=>'1620','pid'=>'1612','shortname'=>'温县','name'=>'温县','merger_name'=>'中国,河南省,焦作市,温县','level'=>'3','pinyin'=>'wenxian','code'=>'0391','zip_code'=>'454850','first'=>'W','lng'=>'113.08065','lat'=>'34.94022']);
        $this->insert('{{%region}}',['id'=>'1621','pid'=>'1612','shortname'=>'沁阳','name'=>'沁阳市','merger_name'=>'中国,河南省,焦作市,沁阳市','level'=>'3','pinyin'=>'qinyang','code'=>'0391','zip_code'=>'454550','first'=>'Q','lng'=>'112.94494','lat'=>'35.08935']);
        $this->insert('{{%region}}',['id'=>'1622','pid'=>'1612','shortname'=>'孟州','name'=>'孟州市','merger_name'=>'中国,河南省,焦作市,孟州市','level'=>'3','pinyin'=>'mengzhou','code'=>'0391','zip_code'=>'454750','first'=>'M','lng'=>'112.79138','lat'=>'34.9071']);
        $this->insert('{{%region}}',['id'=>'1623','pid'=>'1532','shortname'=>'濮阳','name'=>'濮阳市','merger_name'=>'中国,河南省,濮阳市','level'=>'2','pinyin'=>'puyang','code'=>'0393','zip_code'=>'457000','first'=>NULL,'lng'=>'115.041299','lat'=>'35.768234']);
        $this->insert('{{%region}}',['id'=>'1624','pid'=>'1623','shortname'=>'华龙','name'=>'华龙区','merger_name'=>'中国,河南省,濮阳市,华龙区','level'=>'3','pinyin'=>'hualong','code'=>'0393','zip_code'=>'457001','first'=>'H','lng'=>'115.07446','lat'=>'35.77736']);
        $this->insert('{{%region}}',['id'=>'1625','pid'=>'1623','shortname'=>'清丰','name'=>'清丰县','merger_name'=>'中国,河南省,濮阳市,清丰县','level'=>'3','pinyin'=>'qingfeng','code'=>'0393','zip_code'=>'457300','first'=>'Q','lng'=>'115.10415','lat'=>'35.88507']);
        $this->insert('{{%region}}',['id'=>'1626','pid'=>'1623','shortname'=>'南乐','name'=>'南乐县','merger_name'=>'中国,河南省,濮阳市,南乐县','level'=>'3','pinyin'=>'nanle','code'=>'0393','zip_code'=>'457400','first'=>'N','lng'=>'115.20639','lat'=>'36.07686']);
        $this->insert('{{%region}}',['id'=>'1627','pid'=>'1623','shortname'=>'范县','name'=>'范县','merger_name'=>'中国,河南省,濮阳市,范县','level'=>'3','pinyin'=>'fanxian','code'=>'0393','zip_code'=>'457500','first'=>'F','lng'=>'115.50405','lat'=>'35.85178']);
        $this->insert('{{%region}}',['id'=>'1628','pid'=>'1623','shortname'=>'台前','name'=>'台前县','merger_name'=>'中国,河南省,濮阳市,台前县','level'=>'3','pinyin'=>'taiqian','code'=>'0393','zip_code'=>'457600','first'=>'T','lng'=>'115.87158','lat'=>'35.96923']);
        $this->insert('{{%region}}',['id'=>'1629','pid'=>'1623','shortname'=>'濮阳','name'=>'濮阳县','merger_name'=>'中国,河南省,濮阳市,濮阳县','level'=>'3','pinyin'=>'puyang','code'=>'0393','zip_code'=>'457100','first'=>NULL,'lng'=>'115.03057','lat'=>'35.70745']);
        $this->insert('{{%region}}',['id'=>'1630','pid'=>'1532','shortname'=>'许昌','name'=>'许昌市','merger_name'=>'中国,河南省,许昌市','level'=>'2','pinyin'=>'xuchang','code'=>'0374','zip_code'=>'461000','first'=>'X','lng'=>'113.826063','lat'=>'34.022956']);
        $this->insert('{{%region}}',['id'=>'1631','pid'=>'1630','shortname'=>'魏都','name'=>'魏都区','merger_name'=>'中国,河南省,许昌市,魏都区','level'=>'3','pinyin'=>'weidu','code'=>'0374','zip_code'=>'461000','first'=>'W','lng'=>'113.8227','lat'=>'34.02544']);
        $this->insert('{{%region}}',['id'=>'1632','pid'=>'1630','shortname'=>'许昌','name'=>'许昌县','merger_name'=>'中国,河南省,许昌市,许昌县','level'=>'3','pinyin'=>'xuchang','code'=>'0374','zip_code'=>'461100','first'=>'X','lng'=>'113.84707','lat'=>'34.00406']);
        $this->insert('{{%region}}',['id'=>'1633','pid'=>'1630','shortname'=>'鄢陵','name'=>'鄢陵县','merger_name'=>'中国,河南省,许昌市,鄢陵县','level'=>'3','pinyin'=>'yanling','code'=>'0374','zip_code'=>'461200','first'=>NULL,'lng'=>'114.18795','lat'=>'34.10317']);
        $this->insert('{{%region}}',['id'=>'1634','pid'=>'1630','shortname'=>'襄城','name'=>'襄城县','merger_name'=>'中国,河南省,许昌市,襄城县','level'=>'3','pinyin'=>'xiangcheng','code'=>'0374','zip_code'=>'461700','first'=>'X','lng'=>'113.48196','lat'=>'33.84928']);
        $this->insert('{{%region}}',['id'=>'1635','pid'=>'1630','shortname'=>'禹州','name'=>'禹州市','merger_name'=>'中国,河南省,许昌市,禹州市','level'=>'3','pinyin'=>'yuzhou','code'=>'0374','zip_code'=>'461670','first'=>'Y','lng'=>'113.48803','lat'=>'34.14054']);
        $this->insert('{{%region}}',['id'=>'1636','pid'=>'1630','shortname'=>'长葛','name'=>'长葛市','merger_name'=>'中国,河南省,许昌市,长葛市','level'=>'3','pinyin'=>'changge','code'=>'0374','zip_code'=>'461500','first'=>'C','lng'=>'113.77328','lat'=>'34.21846']);
        $this->insert('{{%region}}',['id'=>'1637','pid'=>'1532','shortname'=>'漯河','name'=>'漯河市','merger_name'=>'中国,河南省,漯河市','level'=>'2','pinyin'=>'luohe','code'=>'0395','zip_code'=>'462000','first'=>NULL,'lng'=>'114.026405','lat'=>'33.575855']);
        $this->insert('{{%region}}',['id'=>'1638','pid'=>'1637','shortname'=>'源汇','name'=>'源汇区','merger_name'=>'中国,河南省,漯河市,源汇区','level'=>'3','pinyin'=>'yuanhui','code'=>'0395','zip_code'=>'462000','first'=>'Y','lng'=>'114.00647','lat'=>'33.55627']);
        $this->insert('{{%region}}',['id'=>'1639','pid'=>'1637','shortname'=>'郾城','name'=>'郾城区','merger_name'=>'中国,河南省,漯河市,郾城区','level'=>'3','pinyin'=>'yancheng','code'=>'0395','zip_code'=>'462300','first'=>NULL,'lng'=>'114.00694','lat'=>'33.58723']);
        $this->insert('{{%region}}',['id'=>'1640','pid'=>'1637','shortname'=>'召陵','name'=>'召陵区','merger_name'=>'中国,河南省,漯河市,召陵区','level'=>'3','pinyin'=>'zhaoling','code'=>'0395','zip_code'=>'462300','first'=>'Z','lng'=>'114.09399','lat'=>'33.58601']);
        $this->insert('{{%region}}',['id'=>'1641','pid'=>'1637','shortname'=>'舞阳','name'=>'舞阳县','merger_name'=>'中国,河南省,漯河市,舞阳县','level'=>'3','pinyin'=>'wuyang','code'=>'0395','zip_code'=>'462400','first'=>'W','lng'=>'113.59848','lat'=>'33.43243']);
        $this->insert('{{%region}}',['id'=>'1642','pid'=>'1637','shortname'=>'临颍','name'=>'临颍县','merger_name'=>'中国,河南省,漯河市,临颍县','level'=>'3','pinyin'=>'linying','code'=>'0395','zip_code'=>'462600','first'=>'L','lng'=>'113.93661','lat'=>'33.81123']);
        $this->insert('{{%region}}',['id'=>'1643','pid'=>'1532','shortname'=>'三门峡','name'=>'三门峡市','merger_name'=>'中国,河南省,三门峡市','level'=>'2','pinyin'=>'sanmenxia','code'=>'0398','zip_code'=>'472000','first'=>'S','lng'=>'111.194099','lat'=>'34.777338']);
        $this->insert('{{%region}}',['id'=>'1644','pid'=>'1643','shortname'=>'湖滨','name'=>'湖滨区','merger_name'=>'中国,河南省,三门峡市,湖滨区','level'=>'3','pinyin'=>'hubin','code'=>'0398','zip_code'=>'472000','first'=>'H','lng'=>'111.20006','lat'=>'34.77872']);
        $this->insert('{{%region}}',['id'=>'1645','pid'=>'1643','shortname'=>'渑池','name'=>'渑池县','merger_name'=>'中国,河南省,三门峡市,渑池县','level'=>'3','pinyin'=>'mianchi','code'=>'0398','zip_code'=>'472400','first'=>NULL,'lng'=>'111.76184','lat'=>'34.76725']);
        $this->insert('{{%region}}',['id'=>'1646','pid'=>'1643','shortname'=>'陕县','name'=>'陕县','merger_name'=>'中国,河南省,三门峡市,陕县','level'=>'3','pinyin'=>'shanxian','code'=>'0398','zip_code'=>'472100','first'=>'S','lng'=>'111.10333','lat'=>'34.72052']);
        $this->insert('{{%region}}',['id'=>'1647','pid'=>'1643','shortname'=>'卢氏','name'=>'卢氏县','merger_name'=>'中国,河南省,三门峡市,卢氏县','level'=>'3','pinyin'=>'lushi','code'=>'0398','zip_code'=>'472200','first'=>'L','lng'=>'111.04782','lat'=>'34.05436']);
        $this->insert('{{%region}}',['id'=>'1648','pid'=>'1643','shortname'=>'义马','name'=>'义马市','merger_name'=>'中国,河南省,三门峡市,义马市','level'=>'3','pinyin'=>'yima','code'=>'0398','zip_code'=>'472300','first'=>'Y','lng'=>'111.87445','lat'=>'34.74721']);
        $this->insert('{{%region}}',['id'=>'1649','pid'=>'1643','shortname'=>'灵宝','name'=>'灵宝市','merger_name'=>'中国,河南省,三门峡市,灵宝市','level'=>'3','pinyin'=>'lingbao','code'=>'0398','zip_code'=>'472500','first'=>'L','lng'=>'110.8945','lat'=>'34.51682']);
        $this->insert('{{%region}}',['id'=>'1650','pid'=>'1532','shortname'=>'南阳','name'=>'南阳市','merger_name'=>'中国,河南省,南阳市','level'=>'2','pinyin'=>'nanyang','code'=>'0377','zip_code'=>'473002','first'=>'N','lng'=>'112.540918','lat'=>'32.999082']);
        $this->insert('{{%region}}',['id'=>'1651','pid'=>'1650','shortname'=>'宛城','name'=>'宛城区','merger_name'=>'中国,河南省,南阳市,宛城区','level'=>'3','pinyin'=>'wancheng','code'=>'0377','zip_code'=>'473001','first'=>'W','lng'=>'112.53955','lat'=>'33.00378']);
        $this->insert('{{%region}}',['id'=>'1652','pid'=>'1650','shortname'=>'卧龙','name'=>'卧龙区','merger_name'=>'中国,河南省,南阳市,卧龙区','level'=>'3','pinyin'=>'wolong','code'=>'0377','zip_code'=>'473003','first'=>'W','lng'=>'112.53479','lat'=>'32.98615']);
        $this->insert('{{%region}}',['id'=>'1653','pid'=>'1650','shortname'=>'南召','name'=>'南召县','merger_name'=>'中国,河南省,南阳市,南召县','level'=>'3','pinyin'=>'nanzhao','code'=>'0377','zip_code'=>'474650','first'=>'N','lng'=>'112.43194','lat'=>'33.49098']);
        $this->insert('{{%region}}',['id'=>'1654','pid'=>'1650','shortname'=>'方城','name'=>'方城县','merger_name'=>'中国,河南省,南阳市,方城县','level'=>'3','pinyin'=>'fangcheng','code'=>'0377','zip_code'=>'473200','first'=>'F','lng'=>'113.01269','lat'=>'33.25453']);
        $this->insert('{{%region}}',['id'=>'1655','pid'=>'1650','shortname'=>'西峡','name'=>'西峡县','merger_name'=>'中国,河南省,南阳市,西峡县','level'=>'3','pinyin'=>'xixia','code'=>'0377','zip_code'=>'474550','first'=>'X','lng'=>'111.48187','lat'=>'33.29772']);
        $this->insert('{{%region}}',['id'=>'1656','pid'=>'1650','shortname'=>'镇平','name'=>'镇平县','merger_name'=>'中国,河南省,南阳市,镇平县','level'=>'3','pinyin'=>'zhenping','code'=>'0377','zip_code'=>'474250','first'=>'Z','lng'=>'112.2398','lat'=>'33.03629']);
        $this->insert('{{%region}}',['id'=>'1657','pid'=>'1650','shortname'=>'内乡','name'=>'内乡县','merger_name'=>'中国,河南省,南阳市,内乡县','level'=>'3','pinyin'=>'neixiang','code'=>'0377','zip_code'=>'474350','first'=>'N','lng'=>'111.84957','lat'=>'33.04671']);
        $this->insert('{{%region}}',['id'=>'1658','pid'=>'1650','shortname'=>'淅川','name'=>'淅川县','merger_name'=>'中国,河南省,南阳市,淅川县','level'=>'3','pinyin'=>'xichuan','code'=>'0377','zip_code'=>'474450','first'=>NULL,'lng'=>'111.48663','lat'=>'33.13708']);
        $this->insert('{{%region}}',['id'=>'1659','pid'=>'1650','shortname'=>'社旗','name'=>'社旗县','merger_name'=>'中国,河南省,南阳市,社旗县','level'=>'3','pinyin'=>'sheqi','code'=>'0377','zip_code'=>'473300','first'=>'S','lng'=>'112.94656','lat'=>'33.05503']);
        $this->insert('{{%region}}',['id'=>'1660','pid'=>'1650','shortname'=>'唐河','name'=>'唐河县','merger_name'=>'中国,河南省,南阳市,唐河县','level'=>'3','pinyin'=>'tanghe','code'=>'0377','zip_code'=>'473400','first'=>'T','lng'=>'112.83609','lat'=>'32.69453']);
        $this->insert('{{%region}}',['id'=>'1661','pid'=>'1650','shortname'=>'新野','name'=>'新野县','merger_name'=>'中国,河南省,南阳市,新野县','level'=>'3','pinyin'=>'xinye','code'=>'0377','zip_code'=>'473500','first'=>'X','lng'=>'112.36151','lat'=>'32.51698']);
        $this->insert('{{%region}}',['id'=>'1662','pid'=>'1650','shortname'=>'桐柏','name'=>'桐柏县','merger_name'=>'中国,河南省,南阳市,桐柏县','level'=>'3','pinyin'=>'tongbai','code'=>'0377','zip_code'=>'474750','first'=>'T','lng'=>'113.42886','lat'=>'32.37917']);
        $this->insert('{{%region}}',['id'=>'1663','pid'=>'1650','shortname'=>'邓州','name'=>'邓州市','merger_name'=>'中国,河南省,南阳市,邓州市','level'=>'3','pinyin'=>'dengzhou','code'=>'0377','zip_code'=>'474150','first'=>'D','lng'=>'112.0896','lat'=>'32.68577']);
        $this->insert('{{%region}}',['id'=>'1664','pid'=>'1532','shortname'=>'商丘','name'=>'商丘市','merger_name'=>'中国,河南省,商丘市','level'=>'2','pinyin'=>'shangqiu','code'=>'0370','zip_code'=>'476000','first'=>'S','lng'=>'115.650497','lat'=>'34.437054']);
        $this->insert('{{%region}}',['id'=>'1665','pid'=>'1664','shortname'=>'梁园','name'=>'梁园区','merger_name'=>'中国,河南省,商丘市,梁园区','level'=>'3','pinyin'=>'liangyuan','code'=>'0370','zip_code'=>'476000','first'=>'L','lng'=>'115.64487','lat'=>'34.44341']);
        $this->insert('{{%region}}',['id'=>'1666','pid'=>'1664','shortname'=>'睢阳','name'=>'睢阳区','merger_name'=>'中国,河南省,商丘市,睢阳区','level'=>'3','pinyin'=>'suiyang','code'=>'0370','zip_code'=>'476100','first'=>NULL,'lng'=>'115.65338','lat'=>'34.38804']);
        $this->insert('{{%region}}',['id'=>'1667','pid'=>'1664','shortname'=>'民权','name'=>'民权县','merger_name'=>'中国,河南省,商丘市,民权县','level'=>'3','pinyin'=>'minquan','code'=>'0370','zip_code'=>'476800','first'=>'M','lng'=>'115.14621','lat'=>'34.64931']);
        $this->insert('{{%region}}',['id'=>'1668','pid'=>'1664','shortname'=>'睢县','name'=>'睢县','merger_name'=>'中国,河南省,商丘市,睢县','level'=>'3','pinyin'=>'suixian','code'=>'0370','zip_code'=>'476900','first'=>NULL,'lng'=>'115.07168','lat'=>'34.44539']);
        $this->insert('{{%region}}',['id'=>'1669','pid'=>'1664','shortname'=>'宁陵','name'=>'宁陵县','merger_name'=>'中国,河南省,商丘市,宁陵县','level'=>'3','pinyin'=>'ningling','code'=>'0370','zip_code'=>'476700','first'=>'N','lng'=>'115.30511','lat'=>'34.45463']);
        $this->insert('{{%region}}',['id'=>'1670','pid'=>'1664','shortname'=>'柘城','name'=>'柘城县','merger_name'=>'中国,河南省,商丘市,柘城县','level'=>'3','pinyin'=>'zhecheng','code'=>'0370','zip_code'=>'476200','first'=>NULL,'lng'=>'115.30538','lat'=>'34.0911']);
        $this->insert('{{%region}}',['id'=>'1671','pid'=>'1664','shortname'=>'虞城','name'=>'虞城县','merger_name'=>'中国,河南省,商丘市,虞城县','level'=>'3','pinyin'=>'yucheng','code'=>'0370','zip_code'=>'476300','first'=>'Y','lng'=>'115.86337','lat'=>'34.40189']);
        $this->insert('{{%region}}',['id'=>'1672','pid'=>'1664','shortname'=>'夏邑','name'=>'夏邑县','merger_name'=>'中国,河南省,商丘市,夏邑县','level'=>'3','pinyin'=>'xiayi','code'=>'0370','zip_code'=>'476400','first'=>'X','lng'=>'116.13348','lat'=>'34.23242']);
        $this->insert('{{%region}}',['id'=>'1673','pid'=>'1664','shortname'=>'永城','name'=>'永城市','merger_name'=>'中国,河南省,商丘市,永城市','level'=>'3','pinyin'=>'yongcheng','code'=>'0370','zip_code'=>'476600','first'=>'Y','lng'=>'116.44943','lat'=>'33.92911']);
        $this->insert('{{%region}}',['id'=>'1674','pid'=>'1532','shortname'=>'信阳','name'=>'信阳市','merger_name'=>'中国,河南省,信阳市','level'=>'2','pinyin'=>'xinyang','code'=>'0376','zip_code'=>'464000','first'=>'X','lng'=>'114.075031','lat'=>'32.123274']);
        $this->insert('{{%region}}',['id'=>'1675','pid'=>'1674','shortname'=>'浉河','name'=>'浉河区','merger_name'=>'中国,河南省,信阳市,浉河区','level'=>'3','pinyin'=>'shihe','code'=>'0376','zip_code'=>'464000','first'=>NULL,'lng'=>'114.05871','lat'=>'32.1168']);
        $this->insert('{{%region}}',['id'=>'1676','pid'=>'1674','shortname'=>'平桥','name'=>'平桥区','merger_name'=>'中国,河南省,信阳市,平桥区','level'=>'3','pinyin'=>'pingqiao','code'=>'0376','zip_code'=>'464100','first'=>'P','lng'=>'114.12435','lat'=>'32.10095']);
        $this->insert('{{%region}}',['id'=>'1677','pid'=>'1674','shortname'=>'罗山','name'=>'罗山县','merger_name'=>'中国,河南省,信阳市,罗山县','level'=>'3','pinyin'=>'luoshan','code'=>'0376','zip_code'=>'464200','first'=>'L','lng'=>'114.5314','lat'=>'32.20277']);
        $this->insert('{{%region}}',['id'=>'1678','pid'=>'1674','shortname'=>'光山','name'=>'光山县','merger_name'=>'中国,河南省,信阳市,光山县','level'=>'3','pinyin'=>'guangshan','code'=>'0376','zip_code'=>'465450','first'=>'G','lng'=>'114.91873','lat'=>'32.00992']);
        $this->insert('{{%region}}',['id'=>'1679','pid'=>'1674','shortname'=>'新县','name'=>'新县','merger_name'=>'中国,河南省,信阳市,新县','level'=>'3','pinyin'=>'xinxian','code'=>'0376','zip_code'=>'465550','first'=>'X','lng'=>'114.87924','lat'=>'31.64386']);
        $this->insert('{{%region}}',['id'=>'1680','pid'=>'1674','shortname'=>'商城','name'=>'商城县','merger_name'=>'中国,河南省,信阳市,商城县','level'=>'3','pinyin'=>'shangcheng','code'=>'0376','zip_code'=>'465350','first'=>'S','lng'=>'115.40856','lat'=>'31.79986']);
        $this->insert('{{%region}}',['id'=>'1681','pid'=>'1674','shortname'=>'固始','name'=>'固始县','merger_name'=>'中国,河南省,信阳市,固始县','level'=>'3','pinyin'=>'gushi','code'=>'0376','zip_code'=>'465250','first'=>'G','lng'=>'115.68298','lat'=>'32.18011']);
        $this->insert('{{%region}}',['id'=>'1682','pid'=>'1674','shortname'=>'潢川','name'=>'潢川县','merger_name'=>'中国,河南省,信阳市,潢川县','level'=>'3','pinyin'=>'huangchuan','code'=>'0376','zip_code'=>'465150','first'=>NULL,'lng'=>'115.04696','lat'=>'32.13763']);
        $this->insert('{{%region}}',['id'=>'1683','pid'=>'1674','shortname'=>'淮滨','name'=>'淮滨县','merger_name'=>'中国,河南省,信阳市,淮滨县','level'=>'3','pinyin'=>'huaibin','code'=>'0376','zip_code'=>'464400','first'=>'H','lng'=>'115.4205','lat'=>'32.46614']);
        $this->insert('{{%region}}',['id'=>'1684','pid'=>'1674','shortname'=>'息县','name'=>'息县','merger_name'=>'中国,河南省,信阳市,息县','level'=>'3','pinyin'=>'xixian','code'=>'0376','zip_code'=>'464300','first'=>'X','lng'=>'114.7402','lat'=>'32.34279']);
        $this->insert('{{%region}}',['id'=>'1685','pid'=>'1532','shortname'=>'周口','name'=>'周口市','merger_name'=>'中国,河南省,周口市','level'=>'2','pinyin'=>'zhoukou','code'=>'0394','zip_code'=>'466000','first'=>'Z','lng'=>'114.649653','lat'=>'33.620357']);
        $this->insert('{{%region}}',['id'=>'1686','pid'=>'1685','shortname'=>'川汇','name'=>'川汇区','merger_name'=>'中国,河南省,周口市,川汇区','level'=>'3','pinyin'=>'chuanhui','code'=>'0394','zip_code'=>'466000','first'=>'C','lng'=>'114.64202','lat'=>'33.6256']);
        $this->insert('{{%region}}',['id'=>'1687','pid'=>'1685','shortname'=>'扶沟','name'=>'扶沟县','merger_name'=>'中国,河南省,周口市,扶沟县','level'=>'3','pinyin'=>'fugou','code'=>'0394','zip_code'=>'461300','first'=>'F','lng'=>'114.39477','lat'=>'34.05999']);
        $this->insert('{{%region}}',['id'=>'1688','pid'=>'1685','shortname'=>'西华','name'=>'西华县','merger_name'=>'中国,河南省,周口市,西华县','level'=>'3','pinyin'=>'xihua','code'=>'0394','zip_code'=>'466600','first'=>'X','lng'=>'114.52279','lat'=>'33.78548']);
        $this->insert('{{%region}}',['id'=>'1689','pid'=>'1685','shortname'=>'商水','name'=>'商水县','merger_name'=>'中国,河南省,周口市,商水县','level'=>'3','pinyin'=>'shangshui','code'=>'0394','zip_code'=>'466100','first'=>'S','lng'=>'114.60604','lat'=>'33.53912']);
        $this->insert('{{%region}}',['id'=>'1690','pid'=>'1685','shortname'=>'沈丘','name'=>'沈丘县','merger_name'=>'中国,河南省,周口市,沈丘县','level'=>'3','pinyin'=>'shenqiu','code'=>'0394','zip_code'=>'466300','first'=>'S','lng'=>'115.09851','lat'=>'33.40936']);
        $this->insert('{{%region}}',['id'=>'1691','pid'=>'1685','shortname'=>'郸城','name'=>'郸城县','merger_name'=>'中国,河南省,周口市,郸城县','level'=>'3','pinyin'=>'dancheng','code'=>'0394','zip_code'=>'477150','first'=>'D','lng'=>'115.17715','lat'=>'33.64485']);
        $this->insert('{{%region}}',['id'=>'1692','pid'=>'1685','shortname'=>'淮阳','name'=>'淮阳县','merger_name'=>'中国,河南省,周口市,淮阳县','level'=>'3','pinyin'=>'huaiyang','code'=>'0394','zip_code'=>'466700','first'=>'H','lng'=>'114.88848','lat'=>'33.73211']);
        $this->insert('{{%region}}',['id'=>'1693','pid'=>'1685','shortname'=>'太康','name'=>'太康县','merger_name'=>'中国,河南省,周口市,太康县','level'=>'3','pinyin'=>'taikang','code'=>'0394','zip_code'=>'461400','first'=>'T','lng'=>'114.83773','lat'=>'34.06376']);
        $this->insert('{{%region}}',['id'=>'1694','pid'=>'1685','shortname'=>'鹿邑','name'=>'鹿邑县','merger_name'=>'中国,河南省,周口市,鹿邑县','level'=>'3','pinyin'=>'luyi','code'=>'0394','zip_code'=>'477200','first'=>'L','lng'=>'115.48553','lat'=>'33.85931']);
        $this->insert('{{%region}}',['id'=>'1695','pid'=>'1685','shortname'=>'项城','name'=>'项城市','merger_name'=>'中国,河南省,周口市,项城市','level'=>'3','pinyin'=>'xiangcheng','code'=>'0394','zip_code'=>'466200','first'=>'X','lng'=>'114.87558','lat'=>'33.4672']);
        $this->insert('{{%region}}',['id'=>'1696','pid'=>'1532','shortname'=>'驻马店','name'=>'驻马店市','merger_name'=>'中国,河南省,驻马店市','level'=>'2','pinyin'=>'zhumadian','code'=>'0396','zip_code'=>'463000','first'=>'Z','lng'=>'114.024736','lat'=>'32.980169']);
        $this->insert('{{%region}}',['id'=>'1697','pid'=>'1696','shortname'=>'驿城','name'=>'驿城区','merger_name'=>'中国,河南省,驻马店市,驿城区','level'=>'3','pinyin'=>'yicheng','code'=>'0396','zip_code'=>'463000','first'=>NULL,'lng'=>'113.99377','lat'=>'32.97316']);
        $this->insert('{{%region}}',['id'=>'1698','pid'=>'1696','shortname'=>'西平','name'=>'西平县','merger_name'=>'中国,河南省,驻马店市,西平县','level'=>'3','pinyin'=>'xiping','code'=>'0396','zip_code'=>'463900','first'=>'X','lng'=>'114.02322','lat'=>'33.3845']);
        $this->insert('{{%region}}',['id'=>'1699','pid'=>'1696','shortname'=>'上蔡','name'=>'上蔡县','merger_name'=>'中国,河南省,驻马店市,上蔡县','level'=>'3','pinyin'=>'shangcai','code'=>'0396','zip_code'=>'463800','first'=>'S','lng'=>'114.26825','lat'=>'33.26825']);
        $this->insert('{{%region}}',['id'=>'1700','pid'=>'1696','shortname'=>'平舆','name'=>'平舆县','merger_name'=>'中国,河南省,驻马店市,平舆县','level'=>'3','pinyin'=>'pingyu','code'=>'0396','zip_code'=>'463400','first'=>'P','lng'=>'114.63552','lat'=>'32.95727']);
        $this->insert('{{%region}}',['id'=>'1701','pid'=>'1696','shortname'=>'正阳','name'=>'正阳县','merger_name'=>'中国,河南省,驻马店市,正阳县','level'=>'3','pinyin'=>'zhengyang','code'=>'0396','zip_code'=>'463600','first'=>'Z','lng'=>'114.38952','lat'=>'32.6039']);
        $this->insert('{{%region}}',['id'=>'1702','pid'=>'1696','shortname'=>'确山','name'=>'确山县','merger_name'=>'中国,河南省,驻马店市,确山县','level'=>'3','pinyin'=>'queshan','code'=>'0396','zip_code'=>'463200','first'=>'Q','lng'=>'114.02917','lat'=>'32.80281']);
        $this->insert('{{%region}}',['id'=>'1703','pid'=>'1696','shortname'=>'泌阳','name'=>'泌阳县','merger_name'=>'中国,河南省,驻马店市,泌阳县','level'=>'3','pinyin'=>'biyang','code'=>'0396','zip_code'=>'463700','first'=>'M','lng'=>'113.32681','lat'=>'32.71781']);
        $this->insert('{{%region}}',['id'=>'1704','pid'=>'1696','shortname'=>'汝南','name'=>'汝南县','merger_name'=>'中国,河南省,驻马店市,汝南县','level'=>'3','pinyin'=>'runan','code'=>'0396','zip_code'=>'463300','first'=>'R','lng'=>'114.36138','lat'=>'33.00461']);
        $this->insert('{{%region}}',['id'=>'1705','pid'=>'1696','shortname'=>'遂平','name'=>'遂平县','merger_name'=>'中国,河南省,驻马店市,遂平县','level'=>'3','pinyin'=>'suiping','code'=>'0396','zip_code'=>'463100','first'=>'S','lng'=>'114.01297','lat'=>'33.14571']);
        $this->insert('{{%region}}',['id'=>'1706','pid'=>'1696','shortname'=>'新蔡','name'=>'新蔡县','merger_name'=>'中国,河南省,驻马店市,新蔡县','level'=>'3','pinyin'=>'xincai','code'=>'0396','zip_code'=>'463500','first'=>'X','lng'=>'114.98199','lat'=>'32.7502']);
        $this->insert('{{%region}}',['id'=>'1707','pid'=>'1532','shortname'=>' ','name'=>'直辖县级','merger_name'=>'中国,河南省,直辖县级','level'=>'2','pinyin'=>'','code'=>'','zip_code'=>'','first'=>'Z','lng'=>'113.665412','lat'=>'34.757975']);
        $this->insert('{{%region}}',['id'=>'1708','pid'=>'1707','shortname'=>'济源','name'=>'济源市','merger_name'=>'中国,河南省,直辖县级,济源市','level'=>'3','pinyin'=>'jiyuan','code'=>'0391','zip_code'=>'454650','first'=>'J','lng'=>'112.590047','lat'=>'35.090378']);
        $this->insert('{{%region}}',['id'=>'1709','pid'=>'0','shortname'=>'湖北','name'=>'湖北省','merger_name'=>'中国,湖北省','level'=>'1','pinyin'=>'hubei','code'=>'','zip_code'=>'','first'=>'H','lng'=>'114.298572','lat'=>'30.584355']);
        $this->insert('{{%region}}',['id'=>'1710','pid'=>'1709','shortname'=>'武汉','name'=>'武汉市','merger_name'=>'中国,湖北省,武汉市','level'=>'2','pinyin'=>'wuhan','code'=>'','zip_code'=>'430014','first'=>'W','lng'=>'114.298572','lat'=>'30.584355']);
        $this->insert('{{%region}}',['id'=>'1711','pid'=>'1710','shortname'=>'江岸','name'=>'江岸区','merger_name'=>'中国,湖北省,武汉市,江岸区','level'=>'3','pinyin'=>'jiang\'an','code'=>'027','zip_code'=>'430014','first'=>'J','lng'=>'114.30943','lat'=>'30.59982']);
        $this->insert('{{%region}}',['id'=>'1712','pid'=>'1710','shortname'=>'江汉','name'=>'江汉区','merger_name'=>'中国,湖北省,武汉市,江汉区','level'=>'3','pinyin'=>'jianghan','code'=>'027','zip_code'=>'430021','first'=>'J','lng'=>'114.27093','lat'=>'30.60146']);
        $this->insert('{{%region}}',['id'=>'1713','pid'=>'1710','shortname'=>'硚口','name'=>'硚口区','merger_name'=>'中国,湖北省,武汉市,硚口区','level'=>'3','pinyin'=>'qiaokou','code'=>'027','zip_code'=>'430033','first'=>NULL,'lng'=>'114.26422','lat'=>'30.56945']);
        $this->insert('{{%region}}',['id'=>'1714','pid'=>'1710','shortname'=>'汉阳','name'=>'汉阳区','merger_name'=>'中国,湖北省,武汉市,汉阳区','level'=>'3','pinyin'=>'hanyang','code'=>'027','zip_code'=>'430050','first'=>'H','lng'=>'114.27478','lat'=>'30.54915']);
        $this->insert('{{%region}}',['id'=>'1715','pid'=>'1710','shortname'=>'武昌','name'=>'武昌区','merger_name'=>'中国,湖北省,武汉市,武昌区','level'=>'3','pinyin'=>'wuchang','code'=>'027','zip_code'=>'430061','first'=>'W','lng'=>'114.31589','lat'=>'30.55389']);
        $this->insert('{{%region}}',['id'=>'1716','pid'=>'1710','shortname'=>'青山','name'=>'青山区','merger_name'=>'中国,湖北省,武汉市,青山区','level'=>'3','pinyin'=>'qingshan','code'=>'027','zip_code'=>'430080','first'=>'Q','lng'=>'114.39117','lat'=>'30.63427']);
        $this->insert('{{%region}}',['id'=>'1717','pid'=>'1710','shortname'=>'洪山','name'=>'洪山区','merger_name'=>'中国,湖北省,武汉市,洪山区','level'=>'3','pinyin'=>'hongshan','code'=>'027','zip_code'=>'430070','first'=>'H','lng'=>'114.34375','lat'=>'30.49989']);
        $this->insert('{{%region}}',['id'=>'1718','pid'=>'1710','shortname'=>'东西湖','name'=>'东西湖区','merger_name'=>'中国,湖北省,武汉市,东西湖区','level'=>'3','pinyin'=>'dongxihu','code'=>'027','zip_code'=>'430040','first'=>'D','lng'=>'114.13708','lat'=>'30.61989']);
        $this->insert('{{%region}}',['id'=>'1719','pid'=>'1710','shortname'=>'汉南','name'=>'汉南区','merger_name'=>'中国,湖北省,武汉市,汉南区','level'=>'3','pinyin'=>'hannan','code'=>'027','zip_code'=>'430090','first'=>'H','lng'=>'114.08462','lat'=>'30.30879']);
        $this->insert('{{%region}}',['id'=>'1720','pid'=>'1710','shortname'=>'蔡甸','name'=>'蔡甸区','merger_name'=>'中国,湖北省,武汉市,蔡甸区','level'=>'3','pinyin'=>'caidian','code'=>'027','zip_code'=>'430100','first'=>'C','lng'=>'114.02929','lat'=>'30.58197']);
        $this->insert('{{%region}}',['id'=>'1721','pid'=>'1710','shortname'=>'江夏','name'=>'江夏区','merger_name'=>'中国,湖北省,武汉市,江夏区','level'=>'3','pinyin'=>'jiangxia','code'=>'027','zip_code'=>'430200','first'=>'J','lng'=>'114.31301','lat'=>'30.34653']);
        $this->insert('{{%region}}',['id'=>'1722','pid'=>'1710','shortname'=>'黄陂','name'=>'黄陂区','merger_name'=>'中国,湖北省,武汉市,黄陂区','level'=>'3','pinyin'=>'huangpi','code'=>'027','zip_code'=>'432200','first'=>'H','lng'=>'114.37512','lat'=>'30.88151']);
        $this->insert('{{%region}}',['id'=>'1723','pid'=>'1710','shortname'=>'新洲','name'=>'新洲区','merger_name'=>'中国,湖北省,武汉市,新洲区','level'=>'3','pinyin'=>'xinzhou','code'=>'027','zip_code'=>'431400','first'=>'X','lng'=>'114.80136','lat'=>'30.84145']);
        $this->insert('{{%region}}',['id'=>'1724','pid'=>'1709','shortname'=>'黄石','name'=>'黄石市','merger_name'=>'中国,湖北省,黄石市','level'=>'2','pinyin'=>'huangshi','code'=>'0714','zip_code'=>'435003','first'=>'H','lng'=>'115.077048','lat'=>'30.220074']);
        $this->insert('{{%region}}',['id'=>'1725','pid'=>'1724','shortname'=>'黄石港','name'=>'黄石港区','merger_name'=>'中国,湖北省,黄石市,黄石港区','level'=>'3','pinyin'=>'huangshigang','code'=>'0714','zip_code'=>'435000','first'=>'H','lng'=>'115.06604','lat'=>'30.22279']);
        $this->insert('{{%region}}',['id'=>'1726','pid'=>'1724','shortname'=>'西塞山','name'=>'西塞山区','merger_name'=>'中国,湖北省,黄石市,西塞山区','level'=>'3','pinyin'=>'xisaishan','code'=>'0714','zip_code'=>'435001','first'=>'X','lng'=>'115.11016','lat'=>'30.20487']);
        $this->insert('{{%region}}',['id'=>'1727','pid'=>'1724','shortname'=>'下陆','name'=>'下陆区','merger_name'=>'中国,湖北省,黄石市,下陆区','level'=>'3','pinyin'=>'xialu','code'=>'0714','zip_code'=>'435005','first'=>'X','lng'=>'114.96112','lat'=>'30.17368']);
        $this->insert('{{%region}}',['id'=>'1728','pid'=>'1724','shortname'=>'铁山','name'=>'铁山区','merger_name'=>'中国,湖北省,黄石市,铁山区','level'=>'3','pinyin'=>'tieshan','code'=>'0714','zip_code'=>'435006','first'=>'T','lng'=>'114.90109','lat'=>'30.20678']);
        $this->insert('{{%region}}',['id'=>'1729','pid'=>'1724','shortname'=>'阳新','name'=>'阳新县','merger_name'=>'中国,湖北省,黄石市,阳新县','level'=>'3','pinyin'=>'yangxin','code'=>'0714','zip_code'=>'435200','first'=>'Y','lng'=>'115.21527','lat'=>'29.83038']);
        $this->insert('{{%region}}',['id'=>'1730','pid'=>'1724','shortname'=>'大冶','name'=>'大冶市','merger_name'=>'中国,湖北省,黄石市,大冶市','level'=>'3','pinyin'=>'daye','code'=>'0714','zip_code'=>'435100','first'=>'D','lng'=>'114.97174','lat'=>'30.09438']);
        $this->insert('{{%region}}',['id'=>'1731','pid'=>'1709','shortname'=>'十堰','name'=>'十堰市','merger_name'=>'中国,湖北省,十堰市','level'=>'2','pinyin'=>'shiyan','code'=>'0719','zip_code'=>'442000','first'=>'S','lng'=>'110.785239','lat'=>'32.647017']);
        $this->insert('{{%region}}',['id'=>'1732','pid'=>'1731','shortname'=>'茅箭','name'=>'茅箭区','merger_name'=>'中国,湖北省,十堰市,茅箭区','level'=>'3','pinyin'=>'maojian','code'=>'0719','zip_code'=>'442012','first'=>'M','lng'=>'110.81341','lat'=>'32.59153']);
        $this->insert('{{%region}}',['id'=>'1733','pid'=>'1731','shortname'=>'张湾','name'=>'张湾区','merger_name'=>'中国,湖北省,十堰市,张湾区','level'=>'3','pinyin'=>'zhangwan','code'=>'0719','zip_code'=>'442001','first'=>'Z','lng'=>'110.77067','lat'=>'32.65195']);
        $this->insert('{{%region}}',['id'=>'1734','pid'=>'1731','shortname'=>'郧阳','name'=>'郧阳区','merger_name'=>'中国,湖北省,十堰市,郧阳区','level'=>'3','pinyin'=>'yunyang','code'=>'0719','zip_code'=>'442500','first'=>'Y','lng'=>'110.81854','lat'=>'32.83593']);
        $this->insert('{{%region}}',['id'=>'1735','pid'=>'1731','shortname'=>'郧西','name'=>'郧西县','merger_name'=>'中国,湖北省,十堰市,郧西县','level'=>'3','pinyin'=>'yunxi','code'=>'0719','zip_code'=>'442600','first'=>'Y','lng'=>'110.42556','lat'=>'32.99349']);
        $this->insert('{{%region}}',['id'=>'1736','pid'=>'1731','shortname'=>'竹山','name'=>'竹山县','merger_name'=>'中国,湖北省,十堰市,竹山县','level'=>'3','pinyin'=>'zhushan','code'=>'0719','zip_code'=>'442200','first'=>'Z','lng'=>'110.23071','lat'=>'32.22536']);
        $this->insert('{{%region}}',['id'=>'1737','pid'=>'1731','shortname'=>'竹溪','name'=>'竹溪县','merger_name'=>'中国,湖北省,十堰市,竹溪县','level'=>'3','pinyin'=>'zhuxi','code'=>'0719','zip_code'=>'442300','first'=>'Z','lng'=>'109.71798','lat'=>'32.31901']);
        $this->insert('{{%region}}',['id'=>'1738','pid'=>'1731','shortname'=>'房县','name'=>'房县','merger_name'=>'中国,湖北省,十堰市,房县','level'=>'3','pinyin'=>'fangxian','code'=>'0719','zip_code'=>'442100','first'=>'F','lng'=>'110.74386','lat'=>'32.05794']);
        $this->insert('{{%region}}',['id'=>'1739','pid'=>'1731','shortname'=>'丹江口','name'=>'丹江口市','merger_name'=>'中国,湖北省,十堰市,丹江口市','level'=>'3','pinyin'=>'danjiangkou','code'=>'0719','zip_code'=>'442700','first'=>'D','lng'=>'111.51525','lat'=>'32.54085']);
        $this->insert('{{%region}}',['id'=>'1740','pid'=>'1709','shortname'=>'宜昌','name'=>'宜昌市','merger_name'=>'中国,湖北省,宜昌市','level'=>'2','pinyin'=>'yichang','code'=>'0717','zip_code'=>'443000','first'=>'Y','lng'=>'111.290843','lat'=>'30.702636']);
        $this->insert('{{%region}}',['id'=>'1741','pid'=>'1740','shortname'=>'西陵','name'=>'西陵区','merger_name'=>'中国,湖北省,宜昌市,西陵区','level'=>'3','pinyin'=>'xiling','code'=>'0717','zip_code'=>'443000','first'=>'X','lng'=>'111.28573','lat'=>'30.71077']);
        $this->insert('{{%region}}',['id'=>'1742','pid'=>'1740','shortname'=>'伍家岗','name'=>'伍家岗区','merger_name'=>'中国,湖北省,宜昌市,伍家岗区','level'=>'3','pinyin'=>'wujiagang','code'=>'0717','zip_code'=>'443001','first'=>'W','lng'=>'111.3609','lat'=>'30.64434']);
        $this->insert('{{%region}}',['id'=>'1743','pid'=>'1740','shortname'=>'点军','name'=>'点军区','merger_name'=>'中国,湖北省,宜昌市,点军区','level'=>'3','pinyin'=>'dianjun','code'=>'0717','zip_code'=>'443006','first'=>'D','lng'=>'111.26828','lat'=>'30.6934']);
        $this->insert('{{%region}}',['id'=>'1744','pid'=>'1740','shortname'=>'猇亭','name'=>'猇亭区','merger_name'=>'中国,湖北省,宜昌市,猇亭区','level'=>'3','pinyin'=>'xiaoting','code'=>'0717','zip_code'=>'443007','first'=>NULL,'lng'=>'111.44079','lat'=>'30.52663']);
        $this->insert('{{%region}}',['id'=>'1745','pid'=>'1740','shortname'=>'夷陵','name'=>'夷陵区','merger_name'=>'中国,湖北省,宜昌市,夷陵区','level'=>'3','pinyin'=>'yiling','code'=>'0717','zip_code'=>'443100','first'=>'Y','lng'=>'111.3262','lat'=>'30.76881']);
        $this->insert('{{%region}}',['id'=>'1746','pid'=>'1740','shortname'=>'远安','name'=>'远安县','merger_name'=>'中国,湖北省,宜昌市,远安县','level'=>'3','pinyin'=>'yuan\'an','code'=>'0717','zip_code'=>'444200','first'=>'Y','lng'=>'111.6416','lat'=>'31.05989']);
        $this->insert('{{%region}}',['id'=>'1747','pid'=>'1740','shortname'=>'兴山','name'=>'兴山县','merger_name'=>'中国,湖北省,宜昌市,兴山县','level'=>'3','pinyin'=>'xingshan','code'=>'0717','zip_code'=>'443711','first'=>'X','lng'=>'110.74951','lat'=>'31.34686']);
        $this->insert('{{%region}}',['id'=>'1748','pid'=>'1740','shortname'=>'秭归','name'=>'秭归县','merger_name'=>'中国,湖北省,宜昌市,秭归县','level'=>'3','pinyin'=>'zigui','code'=>'0717','zip_code'=>'443600','first'=>NULL,'lng'=>'110.98156','lat'=>'30.82702']);
        $this->insert('{{%region}}',['id'=>'1749','pid'=>'1740','shortname'=>'长阳','name'=>'长阳土家族自治县','merger_name'=>'中国,湖北省,宜昌市,长阳土家族自治县','level'=>'3','pinyin'=>'changyang','code'=>'0717','zip_code'=>'443500','first'=>'C','lng'=>'111.20105','lat'=>'30.47052']);
        $this->insert('{{%region}}',['id'=>'1750','pid'=>'1740','shortname'=>'五峰','name'=>'五峰土家族自治县','merger_name'=>'中国,湖北省,宜昌市,五峰土家族自治县','level'=>'3','pinyin'=>'wufeng','code'=>'0717','zip_code'=>'443413','first'=>'W','lng'=>'110.6748','lat'=>'30.19856']);
        $this->insert('{{%region}}',['id'=>'1751','pid'=>'1740','shortname'=>'宜都','name'=>'宜都市','merger_name'=>'中国,湖北省,宜昌市,宜都市','level'=>'3','pinyin'=>'yidu','code'=>'0717','zip_code'=>'443300','first'=>'Y','lng'=>'111.45025','lat'=>'30.37807']);
        $this->insert('{{%region}}',['id'=>'1752','pid'=>'1740','shortname'=>'当阳','name'=>'当阳市','merger_name'=>'中国,湖北省,宜昌市,当阳市','level'=>'3','pinyin'=>'dangyang','code'=>'0717','zip_code'=>'444100','first'=>'D','lng'=>'111.78912','lat'=>'30.8208']);
        $this->insert('{{%region}}',['id'=>'1753','pid'=>'1740','shortname'=>'枝江','name'=>'枝江市','merger_name'=>'中国,湖北省,宜昌市,枝江市','level'=>'3','pinyin'=>'zhijiang','code'=>'0717','zip_code'=>'443200','first'=>'Z','lng'=>'111.76855','lat'=>'30.42612']);
        $this->insert('{{%region}}',['id'=>'1754','pid'=>'1709','shortname'=>'襄阳','name'=>'襄阳市','merger_name'=>'中国,湖北省,襄阳市','level'=>'2','pinyin'=>'xiangyang','code'=>'0710','zip_code'=>'441021','first'=>'X','lng'=>'112.144146','lat'=>'32.042426']);
        $this->insert('{{%region}}',['id'=>'1755','pid'=>'1754','shortname'=>'襄城','name'=>'襄城区','merger_name'=>'中国,湖北省,襄阳市,襄城区','level'=>'3','pinyin'=>'xiangcheng','code'=>'0710','zip_code'=>'441021','first'=>'X','lng'=>'112.13372','lat'=>'32.01017']);
        $this->insert('{{%region}}',['id'=>'1756','pid'=>'1754','shortname'=>'樊城','name'=>'樊城区','merger_name'=>'中国,湖北省,襄阳市,樊城区','level'=>'3','pinyin'=>'fancheng','code'=>'0710','zip_code'=>'441001','first'=>'F','lng'=>'112.13546','lat'=>'32.04482']);
        $this->insert('{{%region}}',['id'=>'1757','pid'=>'1754','shortname'=>'襄州','name'=>'襄州区','merger_name'=>'中国,湖北省,襄阳市,襄州区','level'=>'3','pinyin'=>'xiangzhou','code'=>'0710','zip_code'=>'441100','first'=>'X','lng'=>'112.150327','lat'=>'32.015088']);
        $this->insert('{{%region}}',['id'=>'1758','pid'=>'1754','shortname'=>'南漳','name'=>'南漳县','merger_name'=>'中国,湖北省,襄阳市,南漳县','level'=>'3','pinyin'=>'nanzhang','code'=>'0710','zip_code'=>'441500','first'=>'N','lng'=>'111.84603','lat'=>'31.77653']);
        $this->insert('{{%region}}',['id'=>'1759','pid'=>'1754','shortname'=>'谷城','name'=>'谷城县','merger_name'=>'中国,湖北省,襄阳市,谷城县','level'=>'3','pinyin'=>'gucheng','code'=>'0710','zip_code'=>'441700','first'=>'G','lng'=>'111.65267','lat'=>'32.26377']);
        $this->insert('{{%region}}',['id'=>'1760','pid'=>'1754','shortname'=>'保康','name'=>'保康县','merger_name'=>'中国,湖北省,襄阳市,保康县','level'=>'3','pinyin'=>'baokang','code'=>'0710','zip_code'=>'441600','first'=>'B','lng'=>'111.26138','lat'=>'31.87874']);
        $this->insert('{{%region}}',['id'=>'1761','pid'=>'1754','shortname'=>'老河口','name'=>'老河口市','merger_name'=>'中国,湖北省,襄阳市,老河口市','level'=>'3','pinyin'=>'laohekou','code'=>'0710','zip_code'=>'441800','first'=>'L','lng'=>'111.67117','lat'=>'32.38476']);
        $this->insert('{{%region}}',['id'=>'1762','pid'=>'1754','shortname'=>'枣阳','name'=>'枣阳市','merger_name'=>'中国,湖北省,襄阳市,枣阳市','level'=>'3','pinyin'=>'zaoyang','code'=>'0710','zip_code'=>'441200','first'=>'Z','lng'=>'112.77444','lat'=>'32.13142']);
        $this->insert('{{%region}}',['id'=>'1763','pid'=>'1754','shortname'=>'宜城','name'=>'宜城市','merger_name'=>'中国,湖北省,襄阳市,宜城市','level'=>'3','pinyin'=>'yicheng','code'=>'0710','zip_code'=>'441400','first'=>'Y','lng'=>'112.25772','lat'=>'31.71972']);
        $this->insert('{{%region}}',['id'=>'1764','pid'=>'1709','shortname'=>'鄂州','name'=>'鄂州市','merger_name'=>'中国,湖北省,鄂州市','level'=>'2','pinyin'=>'ezhou','code'=>'0711','zip_code'=>'436000','first'=>'E','lng'=>'114.890593','lat'=>'30.396536']);
        $this->insert('{{%region}}',['id'=>'1765','pid'=>'1764','shortname'=>'梁子湖','name'=>'梁子湖区','merger_name'=>'中国,湖北省,鄂州市,梁子湖区','level'=>'3','pinyin'=>'liangzihu','code'=>'0711','zip_code'=>'436064','first'=>'L','lng'=>'114.68463','lat'=>'30.10003']);
        $this->insert('{{%region}}',['id'=>'1766','pid'=>'1764','shortname'=>'华容','name'=>'华容区','merger_name'=>'中国,湖北省,鄂州市,华容区','level'=>'3','pinyin'=>'huarong','code'=>'0711','zip_code'=>'436030','first'=>'H','lng'=>'114.73568','lat'=>'30.53328']);
        $this->insert('{{%region}}',['id'=>'1767','pid'=>'1764','shortname'=>'鄂城','name'=>'鄂城区','merger_name'=>'中国,湖北省,鄂州市,鄂城区','level'=>'3','pinyin'=>'echeng','code'=>'0711','zip_code'=>'436000','first'=>'E','lng'=>'114.89158','lat'=>'30.40024']);
        $this->insert('{{%region}}',['id'=>'1768','pid'=>'1709','shortname'=>'荆门','name'=>'荆门市','merger_name'=>'中国,湖北省,荆门市','level'=>'2','pinyin'=>'jingmen','code'=>'0724','zip_code'=>'448000','first'=>'J','lng'=>'112.204251','lat'=>'31.03542']);
        $this->insert('{{%region}}',['id'=>'1769','pid'=>'1768','shortname'=>'东宝','name'=>'东宝区','merger_name'=>'中国,湖北省,荆门市,东宝区','level'=>'3','pinyin'=>'dongbao','code'=>'0724','zip_code'=>'448004','first'=>'D','lng'=>'112.20147','lat'=>'31.05192']);
        $this->insert('{{%region}}',['id'=>'1770','pid'=>'1768','shortname'=>'掇刀','name'=>'掇刀区','merger_name'=>'中国,湖北省,荆门市,掇刀区','level'=>'3','pinyin'=>'duodao','code'=>'0724','zip_code'=>'448124','first'=>'D','lng'=>'112.208','lat'=>'30.97316']);
        $this->insert('{{%region}}',['id'=>'1771','pid'=>'1768','shortname'=>'京山','name'=>'京山县','merger_name'=>'中国,湖北省,荆门市,京山县','level'=>'3','pinyin'=>'jingshan','code'=>'0724','zip_code'=>'431800','first'=>'J','lng'=>'113.11074','lat'=>'31.0224']);
        $this->insert('{{%region}}',['id'=>'1772','pid'=>'1768','shortname'=>'沙洋','name'=>'沙洋县','merger_name'=>'中国,湖北省,荆门市,沙洋县','level'=>'3','pinyin'=>'shayang','code'=>'0724','zip_code'=>'448200','first'=>'S','lng'=>'112.58853','lat'=>'30.70916']);
        $this->insert('{{%region}}',['id'=>'1773','pid'=>'1768','shortname'=>'钟祥','name'=>'钟祥市','merger_name'=>'中国,湖北省,荆门市,钟祥市','level'=>'3','pinyin'=>'zhongxiang','code'=>'0724','zip_code'=>'431900','first'=>'Z','lng'=>'112.58932','lat'=>'31.1678']);
        $this->insert('{{%region}}',['id'=>'1774','pid'=>'1709','shortname'=>'孝感','name'=>'孝感市','merger_name'=>'中国,湖北省,孝感市','level'=>'2','pinyin'=>'xiaogan','code'=>'0712','zip_code'=>'432100','first'=>'X','lng'=>'113.926655','lat'=>'30.926423']);
        $this->insert('{{%region}}',['id'=>'1775','pid'=>'1774','shortname'=>'孝南','name'=>'孝南区','merger_name'=>'中国,湖北省,孝感市,孝南区','level'=>'3','pinyin'=>'xiaonan','code'=>'0712','zip_code'=>'432100','first'=>'X','lng'=>'113.91111','lat'=>'30.9168']);
        $this->insert('{{%region}}',['id'=>'1776','pid'=>'1774','shortname'=>'孝昌','name'=>'孝昌县','merger_name'=>'中国,湖北省,孝感市,孝昌县','level'=>'3','pinyin'=>'xiaochang','code'=>'0712','zip_code'=>'432900','first'=>'X','lng'=>'113.99795','lat'=>'31.25799']);
        $this->insert('{{%region}}',['id'=>'1777','pid'=>'1774','shortname'=>'大悟','name'=>'大悟县','merger_name'=>'中国,湖北省,孝感市,大悟县','level'=>'3','pinyin'=>'dawu','code'=>'0712','zip_code'=>'432800','first'=>'D','lng'=>'114.12564','lat'=>'31.56176']);
        $this->insert('{{%region}}',['id'=>'1778','pid'=>'1774','shortname'=>'云梦','name'=>'云梦县','merger_name'=>'中国,湖北省,孝感市,云梦县','level'=>'3','pinyin'=>'yunmeng','code'=>'0712','zip_code'=>'432500','first'=>'Y','lng'=>'113.75289','lat'=>'31.02093']);
        $this->insert('{{%region}}',['id'=>'1779','pid'=>'1774','shortname'=>'应城','name'=>'应城市','merger_name'=>'中国,湖北省,孝感市,应城市','level'=>'3','pinyin'=>'yingcheng','code'=>'0712','zip_code'=>'432400','first'=>'Y','lng'=>'113.57287','lat'=>'30.92834']);
        $this->insert('{{%region}}',['id'=>'1780','pid'=>'1774','shortname'=>'安陆','name'=>'安陆市','merger_name'=>'中国,湖北省,孝感市,安陆市','level'=>'3','pinyin'=>'anlu','code'=>'0712','zip_code'=>'432600','first'=>'A','lng'=>'113.68557','lat'=>'31.25693']);
        $this->insert('{{%region}}',['id'=>'1781','pid'=>'1774','shortname'=>'汉川','name'=>'汉川市','merger_name'=>'中国,湖北省,孝感市,汉川市','level'=>'3','pinyin'=>'hanchuan','code'=>'0712','zip_code'=>'432300','first'=>'H','lng'=>'113.83898','lat'=>'30.66117']);
        $this->insert('{{%region}}',['id'=>'1782','pid'=>'1709','shortname'=>'荆州','name'=>'荆州市','merger_name'=>'中国,湖北省,荆州市','level'=>'2','pinyin'=>'jingzhou','code'=>'0716','zip_code'=>'434000','first'=>'J','lng'=>'112.23813','lat'=>'30.326857']);
        $this->insert('{{%region}}',['id'=>'1783','pid'=>'1782','shortname'=>'沙市','name'=>'沙市区','merger_name'=>'中国,湖北省,荆州市,沙市区','level'=>'3','pinyin'=>'shashi','code'=>'0716','zip_code'=>'434000','first'=>'S','lng'=>'112.25543','lat'=>'30.31107']);
        $this->insert('{{%region}}',['id'=>'1784','pid'=>'1782','shortname'=>'荆州','name'=>'荆州区','merger_name'=>'中国,湖北省,荆州市,荆州区','level'=>'3','pinyin'=>'jingzhou','code'=>'0716','zip_code'=>'434020','first'=>'J','lng'=>'112.19006','lat'=>'30.35264']);
        $this->insert('{{%region}}',['id'=>'1785','pid'=>'1782','shortname'=>'公安','name'=>'公安县','merger_name'=>'中国,湖北省,荆州市,公安县','level'=>'3','pinyin'=>'gong\'an','code'=>'0716','zip_code'=>'434300','first'=>'G','lng'=>'112.23242','lat'=>'30.05902']);
        $this->insert('{{%region}}',['id'=>'1786','pid'=>'1782','shortname'=>'监利','name'=>'监利县','merger_name'=>'中国,湖北省,荆州市,监利县','level'=>'3','pinyin'=>'jianli','code'=>'0716','zip_code'=>'433300','first'=>'J','lng'=>'112.89462','lat'=>'29.81494']);
        $this->insert('{{%region}}',['id'=>'1787','pid'=>'1782','shortname'=>'江陵','name'=>'江陵县','merger_name'=>'中国,湖北省,荆州市,江陵县','level'=>'3','pinyin'=>'jiangling','code'=>'0716','zip_code'=>'434101','first'=>'J','lng'=>'112.42468','lat'=>'30.04174']);
        $this->insert('{{%region}}',['id'=>'1788','pid'=>'1782','shortname'=>'石首','name'=>'石首市','merger_name'=>'中国,湖北省,荆州市,石首市','level'=>'3','pinyin'=>'shishou','code'=>'0716','zip_code'=>'434400','first'=>'S','lng'=>'112.42636','lat'=>'29.72127']);
        $this->insert('{{%region}}',['id'=>'1789','pid'=>'1782','shortname'=>'洪湖','name'=>'洪湖市','merger_name'=>'中国,湖北省,荆州市,洪湖市','level'=>'3','pinyin'=>'honghu','code'=>'0716','zip_code'=>'433200','first'=>'H','lng'=>'113.47598','lat'=>'29.827']);
        $this->insert('{{%region}}',['id'=>'1790','pid'=>'1782','shortname'=>'松滋','name'=>'松滋市','merger_name'=>'中国,湖北省,荆州市,松滋市','level'=>'3','pinyin'=>'songzi','code'=>'0716','zip_code'=>'434200','first'=>'S','lng'=>'111.76739','lat'=>'30.16965']);
        $this->insert('{{%region}}',['id'=>'1791','pid'=>'1709','shortname'=>'黄冈','name'=>'黄冈市','merger_name'=>'中国,湖北省,黄冈市','level'=>'2','pinyin'=>'huanggang','code'=>'0713','zip_code'=>'438000','first'=>'H','lng'=>'114.879365','lat'=>'30.447711']);
        $this->insert('{{%region}}',['id'=>'1792','pid'=>'1791','shortname'=>'黄州','name'=>'黄州区','merger_name'=>'中国,湖北省,黄冈市,黄州区','level'=>'3','pinyin'=>'huangzhou','code'=>'0713','zip_code'=>'438000','first'=>'H','lng'=>'114.88008','lat'=>'30.43436']);
        $this->insert('{{%region}}',['id'=>'1793','pid'=>'1791','shortname'=>'团风','name'=>'团风县','merger_name'=>'中国,湖北省,黄冈市,团风县','level'=>'3','pinyin'=>'tuanfeng','code'=>'0713','zip_code'=>'438800','first'=>'T','lng'=>'114.87228','lat'=>'30.64359']);
        $this->insert('{{%region}}',['id'=>'1794','pid'=>'1791','shortname'=>'红安','name'=>'红安县','merger_name'=>'中国,湖北省,黄冈市,红安县','level'=>'3','pinyin'=>'hong\'an','code'=>'0713','zip_code'=>'438401','first'=>'H','lng'=>'114.6224','lat'=>'31.28668']);
        $this->insert('{{%region}}',['id'=>'1795','pid'=>'1791','shortname'=>'罗田','name'=>'罗田县','merger_name'=>'中国,湖北省,黄冈市,罗田县','level'=>'3','pinyin'=>'luotian','code'=>'0713','zip_code'=>'438600','first'=>'L','lng'=>'115.39971','lat'=>'30.78255']);
        $this->insert('{{%region}}',['id'=>'1796','pid'=>'1791','shortname'=>'英山','name'=>'英山县','merger_name'=>'中国,湖北省,黄冈市,英山县','level'=>'3','pinyin'=>'yingshan','code'=>'0713','zip_code'=>'438700','first'=>'Y','lng'=>'115.68142','lat'=>'30.73516']);
        $this->insert('{{%region}}',['id'=>'1797','pid'=>'1791','shortname'=>'浠水','name'=>'浠水县','merger_name'=>'中国,湖北省,黄冈市,浠水县','level'=>'3','pinyin'=>'xishui','code'=>'0713','zip_code'=>'438200','first'=>NULL,'lng'=>'115.26913','lat'=>'30.45265']);
        $this->insert('{{%region}}',['id'=>'1798','pid'=>'1791','shortname'=>'蕲春','name'=>'蕲春县','merger_name'=>'中国,湖北省,黄冈市,蕲春县','level'=>'3','pinyin'=>'qichun','code'=>'0713','zip_code'=>'435300','first'=>NULL,'lng'=>'115.43615','lat'=>'30.22613']);
        $this->insert('{{%region}}',['id'=>'1799','pid'=>'1791','shortname'=>'黄梅','name'=>'黄梅县','merger_name'=>'中国,湖北省,黄冈市,黄梅县','level'=>'3','pinyin'=>'huangmei','code'=>'0713','zip_code'=>'435500','first'=>'H','lng'=>'115.94427','lat'=>'30.07033']);
        $this->insert('{{%region}}',['id'=>'1800','pid'=>'1791','shortname'=>'麻城','name'=>'麻城市','merger_name'=>'中国,湖北省,黄冈市,麻城市','level'=>'3','pinyin'=>'macheng','code'=>'0713','zip_code'=>'438300','first'=>'M','lng'=>'115.00988','lat'=>'31.17228']);
        $this->insert('{{%region}}',['id'=>'1801','pid'=>'1791','shortname'=>'武穴','name'=>'武穴市','merger_name'=>'中国,湖北省,黄冈市,武穴市','level'=>'3','pinyin'=>'wuxue','code'=>'0713','zip_code'=>'435400','first'=>'W','lng'=>'115.55975','lat'=>'29.84446']);
        $this->insert('{{%region}}',['id'=>'1802','pid'=>'1709','shortname'=>'咸宁','name'=>'咸宁市','merger_name'=>'中国,湖北省,咸宁市','level'=>'2','pinyin'=>'xianning','code'=>'0715','zip_code'=>'437000','first'=>'X','lng'=>'114.328963','lat'=>'29.832798']);
        $this->insert('{{%region}}',['id'=>'1803','pid'=>'1802','shortname'=>'咸安','name'=>'咸安区','merger_name'=>'中国,湖北省,咸宁市,咸安区','level'=>'3','pinyin'=>'xian\'an','code'=>'0715','zip_code'=>'437000','first'=>'X','lng'=>'114.29872','lat'=>'29.8529']);
        $this->insert('{{%region}}',['id'=>'1804','pid'=>'1802','shortname'=>'嘉鱼','name'=>'嘉鱼县','merger_name'=>'中国,湖北省,咸宁市,嘉鱼县','level'=>'3','pinyin'=>'jiayu','code'=>'0715','zip_code'=>'437200','first'=>'J','lng'=>'113.93927','lat'=>'29.97054']);
        $this->insert('{{%region}}',['id'=>'1805','pid'=>'1802','shortname'=>'通城','name'=>'通城县','merger_name'=>'中国,湖北省,咸宁市,通城县','level'=>'3','pinyin'=>'tongcheng','code'=>'0715','zip_code'=>'437400','first'=>'T','lng'=>'113.81582','lat'=>'29.24568']);
        $this->insert('{{%region}}',['id'=>'1806','pid'=>'1802','shortname'=>'崇阳','name'=>'崇阳县','merger_name'=>'中国,湖北省,咸宁市,崇阳县','level'=>'3','pinyin'=>'chongyang','code'=>'0715','zip_code'=>'437500','first'=>'C','lng'=>'114.03982','lat'=>'29.55564']);
        $this->insert('{{%region}}',['id'=>'1807','pid'=>'1802','shortname'=>'通山','name'=>'通山县','merger_name'=>'中国,湖北省,咸宁市,通山县','level'=>'3','pinyin'=>'tongshan','code'=>'0715','zip_code'=>'437600','first'=>'T','lng'=>'114.48239','lat'=>'29.6063']);
        $this->insert('{{%region}}',['id'=>'1808','pid'=>'1802','shortname'=>'赤壁','name'=>'赤壁市','merger_name'=>'中国,湖北省,咸宁市,赤壁市','level'=>'3','pinyin'=>'chibi','code'=>'0715','zip_code'=>'437300','first'=>'C','lng'=>'113.90039','lat'=>'29.72454']);
        $this->insert('{{%region}}',['id'=>'1809','pid'=>'1709','shortname'=>'随州','name'=>'随州市','merger_name'=>'中国,湖北省,随州市','level'=>'2','pinyin'=>'suizhou','code'=>'0722','zip_code'=>'441300','first'=>'S','lng'=>'113.37377','lat'=>'31.717497']);
        $this->insert('{{%region}}',['id'=>'1810','pid'=>'1809','shortname'=>'曾都','name'=>'曾都区','merger_name'=>'中国,湖北省,随州市,曾都区','level'=>'3','pinyin'=>'zengdu','code'=>'0722','zip_code'=>'441300','first'=>'Z','lng'=>'113.37128','lat'=>'31.71614']);
        $this->insert('{{%region}}',['id'=>'1811','pid'=>'1809','shortname'=>'随县','name'=>'随县','merger_name'=>'中国,湖北省,随州市,随县','level'=>'3','pinyin'=>'suixian','code'=>'0722','zip_code'=>'441309','first'=>'S','lng'=>'113.82663','lat'=>'31.6179']);
        $this->insert('{{%region}}',['id'=>'1812','pid'=>'1809','shortname'=>'广水','name'=>'广水市','merger_name'=>'中国,湖北省,随州市,广水市','level'=>'3','pinyin'=>'guangshui','code'=>'0722','zip_code'=>'432700','first'=>'G','lng'=>'113.82663','lat'=>'31.6179']);
        $this->insert('{{%region}}',['id'=>'1813','pid'=>'1709','shortname'=>'恩施','name'=>'恩施土家族苗族自治州','merger_name'=>'中国,湖北省,恩施土家族苗族自治州','level'=>'2','pinyin'=>'enshi','code'=>'0718','zip_code'=>'445000','first'=>'E','lng'=>'109.48699','lat'=>'30.283114']);
        $this->insert('{{%region}}',['id'=>'1814','pid'=>'1813','shortname'=>'恩施','name'=>'恩施市','merger_name'=>'中国,湖北省,恩施土家族苗族自治州,恩施市','level'=>'3','pinyin'=>'enshi','code'=>'0718','zip_code'=>'445000','first'=>'E','lng'=>'109.47942','lat'=>'30.29502']);
        $this->insert('{{%region}}',['id'=>'1815','pid'=>'1813','shortname'=>'利川','name'=>'利川市','merger_name'=>'中国,湖北省,恩施土家族苗族自治州,利川市','level'=>'3','pinyin'=>'lichuan','code'=>'0718','zip_code'=>'445400','first'=>'L','lng'=>'108.93591','lat'=>'30.29117']);
        $this->insert('{{%region}}',['id'=>'1816','pid'=>'1813','shortname'=>'建始','name'=>'建始县','merger_name'=>'中国,湖北省,恩施土家族苗族自治州,建始县','level'=>'3','pinyin'=>'jianshi','code'=>'0718','zip_code'=>'445300','first'=>'J','lng'=>'109.72207','lat'=>'30.60209']);
        $this->insert('{{%region}}',['id'=>'1817','pid'=>'1813','shortname'=>'巴东','name'=>'巴东县','merger_name'=>'中国,湖北省,恩施土家族苗族自治州,巴东县','level'=>'3','pinyin'=>'badong','code'=>'0718','zip_code'=>'444300','first'=>'B','lng'=>'110.34066','lat'=>'31.04233']);
        $this->insert('{{%region}}',['id'=>'1818','pid'=>'1813','shortname'=>'宣恩','name'=>'宣恩县','merger_name'=>'中国,湖北省,恩施土家族苗族自治州,宣恩县','level'=>'3','pinyin'=>'xuanen','code'=>'0718','zip_code'=>'445500','first'=>'X','lng'=>'109.49179','lat'=>'29.98714']);
        $this->insert('{{%region}}',['id'=>'1819','pid'=>'1813','shortname'=>'咸丰','name'=>'咸丰县','merger_name'=>'中国,湖北省,恩施土家族苗族自治州,咸丰县','level'=>'3','pinyin'=>'xianfeng','code'=>'0718','zip_code'=>'445600','first'=>'X','lng'=>'109.152','lat'=>'29.67983']);
        $this->insert('{{%region}}',['id'=>'1820','pid'=>'1813','shortname'=>'来凤','name'=>'来凤县','merger_name'=>'中国,湖北省,恩施土家族苗族自治州,来凤县','level'=>'3','pinyin'=>'laifeng','code'=>'0718','zip_code'=>'445700','first'=>'L','lng'=>'109.40716','lat'=>'29.49373']);
        $this->insert('{{%region}}',['id'=>'1821','pid'=>'1813','shortname'=>'鹤峰','name'=>'鹤峰县','merger_name'=>'中国,湖北省,恩施土家族苗族自治州,鹤峰县','level'=>'3','pinyin'=>'hefeng','code'=>'0718','zip_code'=>'445800','first'=>'H','lng'=>'110.03091','lat'=>'29.89072']);
        $this->insert('{{%region}}',['id'=>'1822','pid'=>'1709','shortname'=>' ','name'=>'直辖县级','merger_name'=>'中国,湖北省,直辖县级','level'=>'2','pinyin'=>'','code'=>'','zip_code'=>'','first'=>'Z','lng'=>'114.298572','lat'=>'30.584355']);
        $this->insert('{{%region}}',['id'=>'1823','pid'=>'1822','shortname'=>'仙桃','name'=>'仙桃市','merger_name'=>'中国,湖北省,直辖县级,仙桃市','level'=>'3','pinyin'=>'xiantao','code'=>'0728','zip_code'=>'433000','first'=>'X','lng'=>'113.453974','lat'=>'30.364953']);
        $this->insert('{{%region}}',['id'=>'1824','pid'=>'1822','shortname'=>'潜江','name'=>'潜江市','merger_name'=>'中国,湖北省,直辖县级,潜江市','level'=>'3','pinyin'=>'qianjiang','code'=>'0728','zip_code'=>'433100','first'=>'Q','lng'=>'112.896866','lat'=>'30.421215']);
        $this->insert('{{%region}}',['id'=>'1825','pid'=>'1822','shortname'=>'天门','name'=>'天门市','merger_name'=>'中国,湖北省,直辖县级,天门市','level'=>'3','pinyin'=>'tianmen','code'=>'0728','zip_code'=>'431700','first'=>'T','lng'=>'113.165862','lat'=>'30.653061']);
        $this->insert('{{%region}}',['id'=>'1826','pid'=>'1822','shortname'=>'神农架','name'=>'神农架林区','merger_name'=>'中国,湖北省,直辖县级,神农架林区','level'=>'3','pinyin'=>'shennongjia','code'=>'0719','zip_code'=>'442400','first'=>'S','lng'=>'110.671525','lat'=>'31.744449']);
        $this->insert('{{%region}}',['id'=>'1827','pid'=>'0','shortname'=>'湖南','name'=>'湖南省','merger_name'=>'中国,湖南省','level'=>'1','pinyin'=>'hunan','code'=>'','zip_code'=>'','first'=>'H','lng'=>'112.982279','lat'=>'28.19409']);
        $this->insert('{{%region}}',['id'=>'1828','pid'=>'1827','shortname'=>'长沙','name'=>'长沙市','merger_name'=>'中国,湖南省,长沙市','level'=>'2','pinyin'=>'changsha','code'=>'0731','zip_code'=>'410005','first'=>'C','lng'=>'112.982279','lat'=>'28.19409']);
        $this->insert('{{%region}}',['id'=>'1829','pid'=>'1828','shortname'=>'芙蓉','name'=>'芙蓉区','merger_name'=>'中国,湖南省,长沙市,芙蓉区','level'=>'3','pinyin'=>'furong','code'=>'0731','zip_code'=>'410011','first'=>NULL,'lng'=>'113.03176','lat'=>'28.1844']);
        $this->insert('{{%region}}',['id'=>'1830','pid'=>'1828','shortname'=>'天心','name'=>'天心区','merger_name'=>'中国,湖南省,长沙市,天心区','level'=>'3','pinyin'=>'tianxin','code'=>'0731','zip_code'=>'410004','first'=>'T','lng'=>'112.98991','lat'=>'28.1127']);
        $this->insert('{{%region}}',['id'=>'1831','pid'=>'1828','shortname'=>'岳麓','name'=>'岳麓区','merger_name'=>'中国,湖南省,长沙市,岳麓区','level'=>'3','pinyin'=>'yuelu','code'=>'0731','zip_code'=>'410013','first'=>'Y','lng'=>'112.93133','lat'=>'28.2351']);
        $this->insert('{{%region}}',['id'=>'1832','pid'=>'1828','shortname'=>'开福','name'=>'开福区','merger_name'=>'中国,湖南省,长沙市,开福区','level'=>'3','pinyin'=>'kaifu','code'=>'0731','zip_code'=>'410008','first'=>'K','lng'=>'112.98623','lat'=>'28.25585']);
        $this->insert('{{%region}}',['id'=>'1833','pid'=>'1828','shortname'=>'雨花','name'=>'雨花区','merger_name'=>'中国,湖南省,长沙市,雨花区','level'=>'3','pinyin'=>'yuhua','code'=>'0731','zip_code'=>'410011','first'=>'Y','lng'=>'113.03567','lat'=>'28.13541']);
        $this->insert('{{%region}}',['id'=>'1834','pid'=>'1828','shortname'=>'望城','name'=>'望城区','merger_name'=>'中国,湖南省,长沙市,望城区','level'=>'3','pinyin'=>'wangcheng','code'=>'0731','zip_code'=>'410200','first'=>'W','lng'=>'112.819549','lat'=>'28.347458']);
        $this->insert('{{%region}}',['id'=>'1835','pid'=>'1828','shortname'=>'长沙','name'=>'长沙县','merger_name'=>'中国,湖南省,长沙市,长沙县','level'=>'3','pinyin'=>'changsha','code'=>'0731','zip_code'=>'410100','first'=>'C','lng'=>'113.08071','lat'=>'28.24595']);
        $this->insert('{{%region}}',['id'=>'1836','pid'=>'1828','shortname'=>'宁乡','name'=>'宁乡县','merger_name'=>'中国,湖南省,长沙市,宁乡县','level'=>'3','pinyin'=>'ningxiang','code'=>'0731','zip_code'=>'410600','first'=>'N','lng'=>'112.55749','lat'=>'28.25358']);
        $this->insert('{{%region}}',['id'=>'1837','pid'=>'1828','shortname'=>'浏阳','name'=>'浏阳市','merger_name'=>'中国,湖南省,长沙市,浏阳市','level'=>'3','pinyin'=>'liuyang','code'=>'0731','zip_code'=>'410300','first'=>NULL,'lng'=>'113.64312','lat'=>'28.16375']);
        $this->insert('{{%region}}',['id'=>'1838','pid'=>'1827','shortname'=>'株洲','name'=>'株洲市','merger_name'=>'中国,湖南省,株洲市','level'=>'2','pinyin'=>'zhuzhou','code'=>'0731','zip_code'=>'412000','first'=>'Z','lng'=>'113.151737','lat'=>'27.835806']);
        $this->insert('{{%region}}',['id'=>'1839','pid'=>'1838','shortname'=>'荷塘','name'=>'荷塘区','merger_name'=>'中国,湖南省,株洲市,荷塘区','level'=>'3','pinyin'=>'hetang','code'=>'0731','zip_code'=>'412000','first'=>'H','lng'=>'113.17315','lat'=>'27.85569']);
        $this->insert('{{%region}}',['id'=>'1840','pid'=>'1838','shortname'=>'芦淞','name'=>'芦淞区','merger_name'=>'中国,湖南省,株洲市,芦淞区','level'=>'3','pinyin'=>'lusong','code'=>'0731','zip_code'=>'412000','first'=>'L','lng'=>'113.15562','lat'=>'27.78525']);
        $this->insert('{{%region}}',['id'=>'1841','pid'=>'1838','shortname'=>'石峰','name'=>'石峰区','merger_name'=>'中国,湖南省,株洲市,石峰区','level'=>'3','pinyin'=>'shifeng','code'=>'0731','zip_code'=>'412005','first'=>'S','lng'=>'113.11776','lat'=>'27.87552']);
        $this->insert('{{%region}}',['id'=>'1842','pid'=>'1838','shortname'=>'天元','name'=>'天元区','merger_name'=>'中国,湖南省,株洲市,天元区','level'=>'3','pinyin'=>'tianyuan','code'=>'0731','zip_code'=>'412007','first'=>'T','lng'=>'113.12335','lat'=>'27.83103']);
        $this->insert('{{%region}}',['id'=>'1843','pid'=>'1838','shortname'=>'株洲','name'=>'株洲县','merger_name'=>'中国,湖南省,株洲市,株洲县','level'=>'3','pinyin'=>'zhuzhou','code'=>'0731','zip_code'=>'412100','first'=>'Z','lng'=>'113.14428','lat'=>'27.69826']);
        $this->insert('{{%region}}',['id'=>'1844','pid'=>'1838','shortname'=>'攸县','name'=>'攸县','merger_name'=>'中国,湖南省,株洲市,攸县','level'=>'3','pinyin'=>'youxian','code'=>'0731','zip_code'=>'412300','first'=>NULL,'lng'=>'113.34365','lat'=>'27.00352']);
        $this->insert('{{%region}}',['id'=>'1845','pid'=>'1838','shortname'=>'茶陵','name'=>'茶陵县','merger_name'=>'中国,湖南省,株洲市,茶陵县','level'=>'3','pinyin'=>'chaling','code'=>'0731','zip_code'=>'412400','first'=>'C','lng'=>'113.54364','lat'=>'26.7915']);
        $this->insert('{{%region}}',['id'=>'1846','pid'=>'1838','shortname'=>'炎陵','name'=>'炎陵县','merger_name'=>'中国,湖南省,株洲市,炎陵县','level'=>'3','pinyin'=>'yanling','code'=>'0731','zip_code'=>'412500','first'=>'Y','lng'=>'113.77163','lat'=>'26.48818']);
        $this->insert('{{%region}}',['id'=>'1847','pid'=>'1838','shortname'=>'醴陵','name'=>'醴陵市','merger_name'=>'中国,湖南省,株洲市,醴陵市','level'=>'3','pinyin'=>'liling','code'=>'0731','zip_code'=>'412200','first'=>NULL,'lng'=>'113.49704','lat'=>'27.64615']);
        $this->insert('{{%region}}',['id'=>'1848','pid'=>'1827','shortname'=>'湘潭','name'=>'湘潭市','merger_name'=>'中国,湖南省,湘潭市','level'=>'2','pinyin'=>'xiangtan','code'=>'0731','zip_code'=>'411100','first'=>'X','lng'=>'112.925083','lat'=>'27.846725']);
        $this->insert('{{%region}}',['id'=>'1849','pid'=>'1848','shortname'=>'雨湖','name'=>'雨湖区','merger_name'=>'中国,湖南省,湘潭市,雨湖区','level'=>'3','pinyin'=>'yuhu','code'=>'0731','zip_code'=>'411100','first'=>'Y','lng'=>'112.90399','lat'=>'27.86859']);
        $this->insert('{{%region}}',['id'=>'1850','pid'=>'1848','shortname'=>'岳塘','name'=>'岳塘区','merger_name'=>'中国,湖南省,湘潭市,岳塘区','level'=>'3','pinyin'=>'yuetang','code'=>'0731','zip_code'=>'411101','first'=>'Y','lng'=>'112.9606','lat'=>'27.85784']);
        $this->insert('{{%region}}',['id'=>'1851','pid'=>'1848','shortname'=>'湘潭','name'=>'湘潭县','merger_name'=>'中国,湖南省,湘潭市,湘潭县','level'=>'3','pinyin'=>'xiangtan','code'=>'0731','zip_code'=>'411228','first'=>'X','lng'=>'112.9508','lat'=>'27.77893']);
        $this->insert('{{%region}}',['id'=>'1852','pid'=>'1848','shortname'=>'湘乡','name'=>'湘乡市','merger_name'=>'中国,湖南省,湘潭市,湘乡市','level'=>'3','pinyin'=>'xiangxiang','code'=>'0731','zip_code'=>'411400','first'=>'X','lng'=>'112.53512','lat'=>'27.73543']);
        $this->insert('{{%region}}',['id'=>'1853','pid'=>'1848','shortname'=>'韶山','name'=>'韶山市','merger_name'=>'中国,湖南省,湘潭市,韶山市','level'=>'3','pinyin'=>'shaoshan','code'=>'0731','zip_code'=>'411300','first'=>'S','lng'=>'112.52655','lat'=>'27.91503']);
        $this->insert('{{%region}}',['id'=>'1854','pid'=>'1827','shortname'=>'衡阳','name'=>'衡阳市','merger_name'=>'中国,湖南省,衡阳市','level'=>'2','pinyin'=>'hengyang','code'=>'0734','zip_code'=>'421001','first'=>'H','lng'=>'112.607693','lat'=>'26.900358']);
        $this->insert('{{%region}}',['id'=>'1855','pid'=>'1854','shortname'=>'珠晖','name'=>'珠晖区','merger_name'=>'中国,湖南省,衡阳市,珠晖区','level'=>'3','pinyin'=>'zhuhui','code'=>'0734','zip_code'=>'421002','first'=>'Z','lng'=>'112.62054','lat'=>'26.89361']);
        $this->insert('{{%region}}',['id'=>'1856','pid'=>'1854','shortname'=>'雁峰','name'=>'雁峰区','merger_name'=>'中国,湖南省,衡阳市,雁峰区','level'=>'3','pinyin'=>'yanfeng','code'=>'0734','zip_code'=>'421001','first'=>'Y','lng'=>'112.61654','lat'=>'26.88866']);
        $this->insert('{{%region}}',['id'=>'1857','pid'=>'1854','shortname'=>'石鼓','name'=>'石鼓区','merger_name'=>'中国,湖南省,衡阳市,石鼓区','level'=>'3','pinyin'=>'shigu','code'=>'0734','zip_code'=>'421005','first'=>'S','lng'=>'112.61069','lat'=>'26.90232']);
        $this->insert('{{%region}}',['id'=>'1858','pid'=>'1854','shortname'=>'蒸湘','name'=>'蒸湘区','merger_name'=>'中国,湖南省,衡阳市,蒸湘区','level'=>'3','pinyin'=>'zhengxiang','code'=>'0734','zip_code'=>'421001','first'=>'Z','lng'=>'112.6033','lat'=>'26.89651']);
        $this->insert('{{%region}}',['id'=>'1859','pid'=>'1854','shortname'=>'南岳','name'=>'南岳区','merger_name'=>'中国,湖南省,衡阳市,南岳区','level'=>'3','pinyin'=>'nanyue','code'=>'0734','zip_code'=>'421900','first'=>'N','lng'=>'112.7384','lat'=>'27.23262']);
        $this->insert('{{%region}}',['id'=>'1860','pid'=>'1854','shortname'=>'衡阳','name'=>'衡阳县','merger_name'=>'中国,湖南省,衡阳市,衡阳县','level'=>'3','pinyin'=>'hengyang','code'=>'0734','zip_code'=>'421200','first'=>'H','lng'=>'112.37088','lat'=>'26.9706']);
        $this->insert('{{%region}}',['id'=>'1861','pid'=>'1854','shortname'=>'衡南','name'=>'衡南县','merger_name'=>'中国,湖南省,衡阳市,衡南县','level'=>'3','pinyin'=>'hengnan','code'=>'0734','zip_code'=>'421131','first'=>'H','lng'=>'112.67788','lat'=>'26.73828']);
        $this->insert('{{%region}}',['id'=>'1862','pid'=>'1854','shortname'=>'衡山','name'=>'衡山县','merger_name'=>'中国,湖南省,衡阳市,衡山县','level'=>'3','pinyin'=>'hengshan','code'=>'0734','zip_code'=>'421300','first'=>'H','lng'=>'112.86776','lat'=>'27.23134']);
        $this->insert('{{%region}}',['id'=>'1863','pid'=>'1854','shortname'=>'衡东','name'=>'衡东县','merger_name'=>'中国,湖南省,衡阳市,衡东县','level'=>'3','pinyin'=>'hengdong','code'=>'0734','zip_code'=>'421400','first'=>'H','lng'=>'112.94833','lat'=>'27.08093']);
        $this->insert('{{%region}}',['id'=>'1864','pid'=>'1854','shortname'=>'祁东','name'=>'祁东县','merger_name'=>'中国,湖南省,衡阳市,祁东县','level'=>'3','pinyin'=>'qidong','code'=>'0734','zip_code'=>'421600','first'=>'Q','lng'=>'112.09039','lat'=>'26.79964']);
        $this->insert('{{%region}}',['id'=>'1865','pid'=>'1854','shortname'=>'耒阳','name'=>'耒阳市','merger_name'=>'中国,湖南省,衡阳市,耒阳市','level'=>'3','pinyin'=>'leiyang','code'=>'0734','zip_code'=>'421800','first'=>NULL,'lng'=>'112.85998','lat'=>'26.42132']);
        $this->insert('{{%region}}',['id'=>'1866','pid'=>'1854','shortname'=>'常宁','name'=>'常宁市','merger_name'=>'中国,湖南省,衡阳市,常宁市','level'=>'3','pinyin'=>'changning','code'=>'0734','zip_code'=>'421500','first'=>'C','lng'=>'112.4009','lat'=>'26.40692']);
        $this->insert('{{%region}}',['id'=>'1867','pid'=>'1827','shortname'=>'邵阳','name'=>'邵阳市','merger_name'=>'中国,湖南省,邵阳市','level'=>'2','pinyin'=>'shaoyang','code'=>'0739','zip_code'=>'422000','first'=>'S','lng'=>'111.46923','lat'=>'27.237842']);
        $this->insert('{{%region}}',['id'=>'1868','pid'=>'1867','shortname'=>'双清','name'=>'双清区','merger_name'=>'中国,湖南省,邵阳市,双清区','level'=>'3','pinyin'=>'shuangqing','code'=>'0739','zip_code'=>'422001','first'=>'S','lng'=>'111.49715','lat'=>'27.23291']);
        $this->insert('{{%region}}',['id'=>'1869','pid'=>'1867','shortname'=>'大祥','name'=>'大祥区','merger_name'=>'中国,湖南省,邵阳市,大祥区','level'=>'3','pinyin'=>'daxiang','code'=>'0739','zip_code'=>'422000','first'=>'D','lng'=>'111.45412','lat'=>'27.23332']);
        $this->insert('{{%region}}',['id'=>'1870','pid'=>'1867','shortname'=>'北塔','name'=>'北塔区','merger_name'=>'中国,湖南省,邵阳市,北塔区','level'=>'3','pinyin'=>'beita','code'=>'0739','zip_code'=>'422007','first'=>'B','lng'=>'111.45219','lat'=>'27.24648']);
        $this->insert('{{%region}}',['id'=>'1871','pid'=>'1867','shortname'=>'邵东','name'=>'邵东县','merger_name'=>'中国,湖南省,邵阳市,邵东县','level'=>'3','pinyin'=>'shaodong','code'=>'0739','zip_code'=>'422800','first'=>'S','lng'=>'111.74441','lat'=>'27.2584']);
        $this->insert('{{%region}}',['id'=>'1872','pid'=>'1867','shortname'=>'新邵','name'=>'新邵县','merger_name'=>'中国,湖南省,邵阳市,新邵县','level'=>'3','pinyin'=>'xinshao','code'=>'0739','zip_code'=>'422900','first'=>'X','lng'=>'111.46066','lat'=>'27.32169']);
        $this->insert('{{%region}}',['id'=>'1873','pid'=>'1867','shortname'=>'邵阳','name'=>'邵阳县','merger_name'=>'中国,湖南省,邵阳市,邵阳县','level'=>'3','pinyin'=>'shaoyang','code'=>'0739','zip_code'=>'422100','first'=>'S','lng'=>'111.27459','lat'=>'26.99143']);
        $this->insert('{{%region}}',['id'=>'1874','pid'=>'1867','shortname'=>'隆回','name'=>'隆回县','merger_name'=>'中国,湖南省,邵阳市,隆回县','level'=>'3','pinyin'=>'longhui','code'=>'0739','zip_code'=>'422200','first'=>'L','lng'=>'111.03216','lat'=>'27.10937']);
        $this->insert('{{%region}}',['id'=>'1875','pid'=>'1867','shortname'=>'洞口','name'=>'洞口县','merger_name'=>'中国,湖南省,邵阳市,洞口县','level'=>'3','pinyin'=>'dongkou','code'=>'0739','zip_code'=>'422300','first'=>'D','lng'=>'110.57388','lat'=>'27.05462']);
        $this->insert('{{%region}}',['id'=>'1876','pid'=>'1867','shortname'=>'绥宁','name'=>'绥宁县','merger_name'=>'中国,湖南省,邵阳市,绥宁县','level'=>'3','pinyin'=>'suining','code'=>'0739','zip_code'=>'422600','first'=>'S','lng'=>'110.15576','lat'=>'26.58636']);
        $this->insert('{{%region}}',['id'=>'1877','pid'=>'1867','shortname'=>'新宁','name'=>'新宁县','merger_name'=>'中国,湖南省,邵阳市,新宁县','level'=>'3','pinyin'=>'xinning','code'=>'0739','zip_code'=>'422700','first'=>'X','lng'=>'110.85131','lat'=>'26.42936']);
        $this->insert('{{%region}}',['id'=>'1878','pid'=>'1867','shortname'=>'城步','name'=>'城步苗族自治县','merger_name'=>'中国,湖南省,邵阳市,城步苗族自治县','level'=>'3','pinyin'=>'chengbu','code'=>'0739','zip_code'=>'422500','first'=>'C','lng'=>'110.3222','lat'=>'26.39048']);
        $this->insert('{{%region}}',['id'=>'1879','pid'=>'1867','shortname'=>'武冈','name'=>'武冈市','merger_name'=>'中国,湖南省,邵阳市,武冈市','level'=>'3','pinyin'=>'wugang','code'=>'0739','zip_code'=>'422400','first'=>'W','lng'=>'110.63281','lat'=>'26.72817']);
        $this->insert('{{%region}}',['id'=>'1880','pid'=>'1827','shortname'=>'岳阳','name'=>'岳阳市','merger_name'=>'中国,湖南省,岳阳市','level'=>'2','pinyin'=>'yueyang','code'=>'0730','zip_code'=>'414000','first'=>'Y','lng'=>'113.132855','lat'=>'29.37029']);
        $this->insert('{{%region}}',['id'=>'1881','pid'=>'1880','shortname'=>'岳阳楼','name'=>'岳阳楼区','merger_name'=>'中国,湖南省,岳阳市,岳阳楼区','level'=>'3','pinyin'=>'yueyanglou','code'=>'0730','zip_code'=>'414000','first'=>'Y','lng'=>'113.12942','lat'=>'29.3719']);
        $this->insert('{{%region}}',['id'=>'1882','pid'=>'1880','shortname'=>'云溪','name'=>'云溪区','merger_name'=>'中国,湖南省,岳阳市,云溪区','level'=>'3','pinyin'=>'yunxi','code'=>'0730','zip_code'=>'414009','first'=>'Y','lng'=>'113.27713','lat'=>'29.47357']);
        $this->insert('{{%region}}',['id'=>'1883','pid'=>'1880','shortname'=>'君山','name'=>'君山区','merger_name'=>'中国,湖南省,岳阳市,君山区','level'=>'3','pinyin'=>'junshan','code'=>'0730','zip_code'=>'414005','first'=>'J','lng'=>'113.00439','lat'=>'29.45941']);
        $this->insert('{{%region}}',['id'=>'1884','pid'=>'1880','shortname'=>'岳阳','name'=>'岳阳县','merger_name'=>'中国,湖南省,岳阳市,岳阳县','level'=>'3','pinyin'=>'yueyang','code'=>'0730','zip_code'=>'414100','first'=>'Y','lng'=>'113.11987','lat'=>'29.14314']);
        $this->insert('{{%region}}',['id'=>'1885','pid'=>'1880','shortname'=>'华容','name'=>'华容县','merger_name'=>'中国,湖南省,岳阳市,华容县','level'=>'3','pinyin'=>'huarong','code'=>'0730','zip_code'=>'414200','first'=>'H','lng'=>'112.54089','lat'=>'29.53019']);
        $this->insert('{{%region}}',['id'=>'1886','pid'=>'1880','shortname'=>'湘阴','name'=>'湘阴县','merger_name'=>'中国,湖南省,岳阳市,湘阴县','level'=>'3','pinyin'=>'xiangyin','code'=>'0730','zip_code'=>'414600','first'=>'X','lng'=>'112.90911','lat'=>'28.68922']);
        $this->insert('{{%region}}',['id'=>'1887','pid'=>'1880','shortname'=>'平江','name'=>'平江县','merger_name'=>'中国,湖南省,岳阳市,平江县','level'=>'3','pinyin'=>'pingjiang','code'=>'0730','zip_code'=>'414500','first'=>'P','lng'=>'113.58105','lat'=>'28.70664']);
        $this->insert('{{%region}}',['id'=>'1888','pid'=>'1880','shortname'=>'汨罗','name'=>'汨罗市','merger_name'=>'中国,湖南省,岳阳市,汨罗市','level'=>'3','pinyin'=>'miluo','code'=>'0730','zip_code'=>'414400','first'=>NULL,'lng'=>'113.06707','lat'=>'28.80631']);
        $this->insert('{{%region}}',['id'=>'1889','pid'=>'1880','shortname'=>'临湘','name'=>'临湘市','merger_name'=>'中国,湖南省,岳阳市,临湘市','level'=>'3','pinyin'=>'linxiang','code'=>'0730','zip_code'=>'414300','first'=>'L','lng'=>'113.4501','lat'=>'29.47701']);
        $this->insert('{{%region}}',['id'=>'1890','pid'=>'1827','shortname'=>'常德','name'=>'常德市','merger_name'=>'中国,湖南省,常德市','level'=>'2','pinyin'=>'changde','code'=>'0736','zip_code'=>'415000','first'=>'C','lng'=>'111.691347','lat'=>'29.040225']);
        $this->insert('{{%region}}',['id'=>'1891','pid'=>'1890','shortname'=>'武陵','name'=>'武陵区','merger_name'=>'中国,湖南省,常德市,武陵区','level'=>'3','pinyin'=>'wuling','code'=>'0736','zip_code'=>'415000','first'=>'W','lng'=>'111.69791','lat'=>'29.02876']);
        $this->insert('{{%region}}',['id'=>'1892','pid'=>'1890','shortname'=>'鼎城','name'=>'鼎城区','merger_name'=>'中国,湖南省,常德市,鼎城区','level'=>'3','pinyin'=>'dingcheng','code'=>'0736','zip_code'=>'415101','first'=>'D','lng'=>'111.68078','lat'=>'29.01859']);
        $this->insert('{{%region}}',['id'=>'1893','pid'=>'1890','shortname'=>'安乡','name'=>'安乡县','merger_name'=>'中国,湖南省,常德市,安乡县','level'=>'3','pinyin'=>'anxiang','code'=>'0736','zip_code'=>'415600','first'=>'A','lng'=>'112.16732','lat'=>'29.41326']);
        $this->insert('{{%region}}',['id'=>'1894','pid'=>'1890','shortname'=>'汉寿','name'=>'汉寿县','merger_name'=>'中国,湖南省,常德市,汉寿县','level'=>'3','pinyin'=>'hanshou','code'=>'0736','zip_code'=>'415900','first'=>'H','lng'=>'111.96691','lat'=>'28.90299']);
        $this->insert('{{%region}}',['id'=>'1895','pid'=>'1890','shortname'=>'澧县','name'=>'澧县','merger_name'=>'中国,湖南省,常德市,澧县','level'=>'3','pinyin'=>'lixian','code'=>'0736','zip_code'=>'415500','first'=>NULL,'lng'=>'111.75866','lat'=>'29.63317']);
        $this->insert('{{%region}}',['id'=>'1896','pid'=>'1890','shortname'=>'临澧','name'=>'临澧县','merger_name'=>'中国,湖南省,常德市,临澧县','level'=>'3','pinyin'=>'linli','code'=>'0736','zip_code'=>'415200','first'=>'L','lng'=>'111.65161','lat'=>'29.44163']);
        $this->insert('{{%region}}',['id'=>'1897','pid'=>'1890','shortname'=>'桃源','name'=>'桃源县','merger_name'=>'中国,湖南省,常德市,桃源县','level'=>'3','pinyin'=>'taoyuan','code'=>'0736','zip_code'=>'415700','first'=>'T','lng'=>'111.48892','lat'=>'28.90474']);
        $this->insert('{{%region}}',['id'=>'1898','pid'=>'1890','shortname'=>'石门','name'=>'石门县','merger_name'=>'中国,湖南省,常德市,石门县','level'=>'3','pinyin'=>'shimen','code'=>'0736','zip_code'=>'415300','first'=>'S','lng'=>'111.37966','lat'=>'29.58424']);
        $this->insert('{{%region}}',['id'=>'1899','pid'=>'1890','shortname'=>'津市','name'=>'津市市','merger_name'=>'中国,湖南省,常德市,津市市','level'=>'3','pinyin'=>'jinshi','code'=>'0736','zip_code'=>'415400','first'=>'J','lng'=>'111.87756','lat'=>'29.60563']);
        $this->insert('{{%region}}',['id'=>'1900','pid'=>'1827','shortname'=>'张家界','name'=>'张家界市','merger_name'=>'中国,湖南省,张家界市','level'=>'2','pinyin'=>'zhangjiajie','code'=>'0744','zip_code'=>'427000','first'=>'Z','lng'=>'110.479921','lat'=>'29.127401']);
        $this->insert('{{%region}}',['id'=>'1901','pid'=>'1900','shortname'=>'永定','name'=>'永定区','merger_name'=>'中国,湖南省,张家界市,永定区','level'=>'3','pinyin'=>'yongding','code'=>'0744','zip_code'=>'427000','first'=>'Y','lng'=>'110.47464','lat'=>'29.13387']);
        $this->insert('{{%region}}',['id'=>'1902','pid'=>'1900','shortname'=>'武陵源','name'=>'武陵源区','merger_name'=>'中国,湖南省,张家界市,武陵源区','level'=>'3','pinyin'=>'wulingyuan','code'=>'0744','zip_code'=>'427400','first'=>'W','lng'=>'110.55026','lat'=>'29.34574']);
        $this->insert('{{%region}}',['id'=>'1903','pid'=>'1900','shortname'=>'慈利','name'=>'慈利县','merger_name'=>'中国,湖南省,张家界市,慈利县','level'=>'3','pinyin'=>'cili','code'=>'0744','zip_code'=>'427200','first'=>'C','lng'=>'111.13946','lat'=>'29.42989']);
        $this->insert('{{%region}}',['id'=>'1904','pid'=>'1900','shortname'=>'桑植','name'=>'桑植县','merger_name'=>'中国,湖南省,张家界市,桑植县','level'=>'3','pinyin'=>'sangzhi','code'=>'0744','zip_code'=>'427100','first'=>'S','lng'=>'110.16308','lat'=>'29.39815']);
        $this->insert('{{%region}}',['id'=>'1905','pid'=>'1827','shortname'=>'益阳','name'=>'益阳市','merger_name'=>'中国,湖南省,益阳市','level'=>'2','pinyin'=>'yiyang','code'=>'0737','zip_code'=>'413000','first'=>'Y','lng'=>'112.355042','lat'=>'28.570066']);
        $this->insert('{{%region}}',['id'=>'1906','pid'=>'1905','shortname'=>'资阳','name'=>'资阳区','merger_name'=>'中国,湖南省,益阳市,资阳区','level'=>'3','pinyin'=>'ziyang','code'=>'0737','zip_code'=>'413001','first'=>'Z','lng'=>'112.32447','lat'=>'28.59095']);
        $this->insert('{{%region}}',['id'=>'1907','pid'=>'1905','shortname'=>'赫山','name'=>'赫山区','merger_name'=>'中国,湖南省,益阳市,赫山区','level'=>'3','pinyin'=>'heshan','code'=>'0737','zip_code'=>'413002','first'=>'H','lng'=>'112.37265','lat'=>'28.57425']);
        $this->insert('{{%region}}',['id'=>'1908','pid'=>'1905','shortname'=>'南县','name'=>'南县','merger_name'=>'中国,湖南省,益阳市,南县','level'=>'3','pinyin'=>'nanxian','code'=>'0737','zip_code'=>'413200','first'=>'N','lng'=>'112.3963','lat'=>'29.36159']);
        $this->insert('{{%region}}',['id'=>'1909','pid'=>'1905','shortname'=>'桃江','name'=>'桃江县','merger_name'=>'中国,湖南省,益阳市,桃江县','level'=>'3','pinyin'=>'taojiang','code'=>'0737','zip_code'=>'413400','first'=>'T','lng'=>'112.1557','lat'=>'28.51814']);
        $this->insert('{{%region}}',['id'=>'1910','pid'=>'1905','shortname'=>'安化','name'=>'安化县','merger_name'=>'中国,湖南省,益阳市,安化县','level'=>'3','pinyin'=>'anhua','code'=>'0737','zip_code'=>'413500','first'=>'A','lng'=>'111.21298','lat'=>'28.37424']);
        $this->insert('{{%region}}',['id'=>'1911','pid'=>'1905','shortname'=>'沅江','name'=>'沅江市','merger_name'=>'中国,湖南省,益阳市,沅江市','level'=>'3','pinyin'=>'yuanjiang','code'=>'0737','zip_code'=>'413100','first'=>NULL,'lng'=>'112.35427','lat'=>'28.84403']);
        $this->insert('{{%region}}',['id'=>'1912','pid'=>'1827','shortname'=>'郴州','name'=>'郴州市','merger_name'=>'中国,湖南省,郴州市','level'=>'2','pinyin'=>'chenzhou','code'=>'0735','zip_code'=>'423000','first'=>'C','lng'=>'113.032067','lat'=>'25.793589']);
        $this->insert('{{%region}}',['id'=>'1913','pid'=>'1912','shortname'=>'北湖','name'=>'北湖区','merger_name'=>'中国,湖南省,郴州市,北湖区','level'=>'3','pinyin'=>'beihu','code'=>'0735','zip_code'=>'423000','first'=>'B','lng'=>'113.01103','lat'=>'25.78405']);
        $this->insert('{{%region}}',['id'=>'1914','pid'=>'1912','shortname'=>'苏仙','name'=>'苏仙区','merger_name'=>'中国,湖南省,郴州市,苏仙区','level'=>'3','pinyin'=>'suxian','code'=>'0735','zip_code'=>'423000','first'=>'S','lng'=>'113.04226','lat'=>'25.80045']);
        $this->insert('{{%region}}',['id'=>'1915','pid'=>'1912','shortname'=>'桂阳','name'=>'桂阳县','merger_name'=>'中国,湖南省,郴州市,桂阳县','level'=>'3','pinyin'=>'guiyang','code'=>'0735','zip_code'=>'424400','first'=>'G','lng'=>'112.73364','lat'=>'25.75406']);
        $this->insert('{{%region}}',['id'=>'1916','pid'=>'1912','shortname'=>'宜章','name'=>'宜章县','merger_name'=>'中国,湖南省,郴州市,宜章县','level'=>'3','pinyin'=>'yizhang','code'=>'0735','zip_code'=>'424200','first'=>'Y','lng'=>'112.95147','lat'=>'25.39931']);
        $this->insert('{{%region}}',['id'=>'1917','pid'=>'1912','shortname'=>'永兴','name'=>'永兴县','merger_name'=>'中国,湖南省,郴州市,永兴县','level'=>'3','pinyin'=>'yongxing','code'=>'0735','zip_code'=>'423300','first'=>'Y','lng'=>'113.11242','lat'=>'26.12646']);
        $this->insert('{{%region}}',['id'=>'1918','pid'=>'1912','shortname'=>'嘉禾','name'=>'嘉禾县','merger_name'=>'中国,湖南省,郴州市,嘉禾县','level'=>'3','pinyin'=>'jiahe','code'=>'0735','zip_code'=>'424500','first'=>'J','lng'=>'112.36935','lat'=>'25.58795']);
        $this->insert('{{%region}}',['id'=>'1919','pid'=>'1912','shortname'=>'临武','name'=>'临武县','merger_name'=>'中国,湖南省,郴州市,临武县','level'=>'3','pinyin'=>'linwu','code'=>'0735','zip_code'=>'424300','first'=>'L','lng'=>'112.56369','lat'=>'25.27602']);
        $this->insert('{{%region}}',['id'=>'1920','pid'=>'1912','shortname'=>'汝城','name'=>'汝城县','merger_name'=>'中国,湖南省,郴州市,汝城县','level'=>'3','pinyin'=>'rucheng','code'=>'0735','zip_code'=>'424100','first'=>'R','lng'=>'113.68582','lat'=>'25.55204']);
        $this->insert('{{%region}}',['id'=>'1921','pid'=>'1912','shortname'=>'桂东','name'=>'桂东县','merger_name'=>'中国,湖南省,郴州市,桂东县','level'=>'3','pinyin'=>'guidong','code'=>'0735','zip_code'=>'423500','first'=>'G','lng'=>'113.9468','lat'=>'26.07987']);
        $this->insert('{{%region}}',['id'=>'1922','pid'=>'1912','shortname'=>'安仁','name'=>'安仁县','merger_name'=>'中国,湖南省,郴州市,安仁县','level'=>'3','pinyin'=>'anren','code'=>'0735','zip_code'=>'423600','first'=>'A','lng'=>'113.26944','lat'=>'26.70931']);
        $this->insert('{{%region}}',['id'=>'1923','pid'=>'1912','shortname'=>'资兴','name'=>'资兴市','merger_name'=>'中国,湖南省,郴州市,资兴市','level'=>'3','pinyin'=>'zixing','code'=>'0735','zip_code'=>'423400','first'=>'Z','lng'=>'113.23724','lat'=>'25.97668']);
        $this->insert('{{%region}}',['id'=>'1924','pid'=>'1827','shortname'=>'永州','name'=>'永州市','merger_name'=>'中国,湖南省,永州市','level'=>'2','pinyin'=>'yongzhou','code'=>'0746','zip_code'=>'425000','first'=>'Y','lng'=>'111.608019','lat'=>'26.434516']);
        $this->insert('{{%region}}',['id'=>'1925','pid'=>'1924','shortname'=>'零陵','name'=>'零陵区','merger_name'=>'中国,湖南省,永州市,零陵区','level'=>'3','pinyin'=>'lingling','code'=>'0746','zip_code'=>'425100','first'=>'L','lng'=>'111.62103','lat'=>'26.22109']);
        $this->insert('{{%region}}',['id'=>'1926','pid'=>'1924','shortname'=>'冷水滩','name'=>'冷水滩区','merger_name'=>'中国,湖南省,永州市,冷水滩区','level'=>'3','pinyin'=>'lengshuitan','code'=>'0746','zip_code'=>'425100','first'=>'L','lng'=>'111.59214','lat'=>'26.46107']);
        $this->insert('{{%region}}',['id'=>'1927','pid'=>'1924','shortname'=>'祁阳','name'=>'祁阳县','merger_name'=>'中国,湖南省,永州市,祁阳县','level'=>'3','pinyin'=>'qiyang','code'=>'0746','zip_code'=>'426100','first'=>'Q','lng'=>'111.84011','lat'=>'26.58009']);
        $this->insert('{{%region}}',['id'=>'1928','pid'=>'1924','shortname'=>'东安','name'=>'东安县','merger_name'=>'中国,湖南省,永州市,东安县','level'=>'3','pinyin'=>'dong\'an','code'=>'0746','zip_code'=>'425900','first'=>'D','lng'=>'111.3164','lat'=>'26.39202']);
        $this->insert('{{%region}}',['id'=>'1929','pid'=>'1924','shortname'=>'双牌','name'=>'双牌县','merger_name'=>'中国,湖南省,永州市,双牌县','level'=>'3','pinyin'=>'shuangpai','code'=>'0746','zip_code'=>'425200','first'=>'S','lng'=>'111.65927','lat'=>'25.95988']);
        $this->insert('{{%region}}',['id'=>'1930','pid'=>'1924','shortname'=>'道县','name'=>'道县','merger_name'=>'中国,湖南省,永州市,道县','level'=>'3','pinyin'=>'daoxian','code'=>'0746','zip_code'=>'425300','first'=>'D','lng'=>'111.60195','lat'=>'25.52766']);
        $this->insert('{{%region}}',['id'=>'1931','pid'=>'1924','shortname'=>'江永','name'=>'江永县','merger_name'=>'中国,湖南省,永州市,江永县','level'=>'3','pinyin'=>'jiangyong','code'=>'0746','zip_code'=>'425400','first'=>'J','lng'=>'111.34082','lat'=>'25.27233']);
        $this->insert('{{%region}}',['id'=>'1932','pid'=>'1924','shortname'=>'宁远','name'=>'宁远县','merger_name'=>'中国,湖南省,永州市,宁远县','level'=>'3','pinyin'=>'ningyuan','code'=>'0746','zip_code'=>'425600','first'=>'N','lng'=>'111.94625','lat'=>'25.56913']);
        $this->insert('{{%region}}',['id'=>'1933','pid'=>'1924','shortname'=>'蓝山','name'=>'蓝山县','merger_name'=>'中国,湖南省,永州市,蓝山县','level'=>'3','pinyin'=>'lanshan','code'=>'0746','zip_code'=>'425800','first'=>'L','lng'=>'112.19363','lat'=>'25.36794']);
        $this->insert('{{%region}}',['id'=>'1934','pid'=>'1924','shortname'=>'新田','name'=>'新田县','merger_name'=>'中国,湖南省,永州市,新田县','level'=>'3','pinyin'=>'xintian','code'=>'0746','zip_code'=>'425700','first'=>'X','lng'=>'112.22103','lat'=>'25.9095']);
        $this->insert('{{%region}}',['id'=>'1935','pid'=>'1924','shortname'=>'江华','name'=>'江华瑶族自治县','merger_name'=>'中国,湖南省,永州市,江华瑶族自治县','level'=>'3','pinyin'=>'jianghua','code'=>'0746','zip_code'=>'425500','first'=>'J','lng'=>'111.58847','lat'=>'25.1845']);
        $this->insert('{{%region}}',['id'=>'1936','pid'=>'1827','shortname'=>'怀化','name'=>'怀化市','merger_name'=>'中国,湖南省,怀化市','level'=>'2','pinyin'=>'huaihua','code'=>'0745','zip_code'=>'418000','first'=>'H','lng'=>'109.97824','lat'=>'27.550082']);
        $this->insert('{{%region}}',['id'=>'1937','pid'=>'1936','shortname'=>'鹤城','name'=>'鹤城区','merger_name'=>'中国,湖南省,怀化市,鹤城区','level'=>'3','pinyin'=>'hecheng','code'=>'0745','zip_code'=>'418000','first'=>'H','lng'=>'109.96509','lat'=>'27.54942']);
        $this->insert('{{%region}}',['id'=>'1938','pid'=>'1936','shortname'=>'中方','name'=>'中方县','merger_name'=>'中国,湖南省,怀化市,中方县','level'=>'3','pinyin'=>'zhongfang','code'=>'0745','zip_code'=>'418005','first'=>'Z','lng'=>'109.94497','lat'=>'27.43988']);
        $this->insert('{{%region}}',['id'=>'1939','pid'=>'1936','shortname'=>'沅陵','name'=>'沅陵县','merger_name'=>'中国,湖南省,怀化市,沅陵县','level'=>'3','pinyin'=>'yuanling','code'=>'0745','zip_code'=>'419600','first'=>NULL,'lng'=>'110.39633','lat'=>'28.45548']);
        $this->insert('{{%region}}',['id'=>'1940','pid'=>'1936','shortname'=>'辰溪','name'=>'辰溪县','merger_name'=>'中国,湖南省,怀化市,辰溪县','level'=>'3','pinyin'=>'chenxi','code'=>'0745','zip_code'=>'419500','first'=>'C','lng'=>'110.18942','lat'=>'28.00406']);
        $this->insert('{{%region}}',['id'=>'1941','pid'=>'1936','shortname'=>'溆浦','name'=>'溆浦县','merger_name'=>'中国,湖南省,怀化市,溆浦县','level'=>'3','pinyin'=>'xupu','code'=>'0745','zip_code'=>'419300','first'=>NULL,'lng'=>'110.59384','lat'=>'27.90836']);
        $this->insert('{{%region}}',['id'=>'1942','pid'=>'1936','shortname'=>'会同','name'=>'会同县','merger_name'=>'中国,湖南省,怀化市,会同县','level'=>'3','pinyin'=>'huitong','code'=>'0745','zip_code'=>'418300','first'=>'H','lng'=>'109.73568','lat'=>'26.88716']);
        $this->insert('{{%region}}',['id'=>'1943','pid'=>'1936','shortname'=>'麻阳','name'=>'麻阳苗族自治县','merger_name'=>'中国,湖南省,怀化市,麻阳苗族自治县','level'=>'3','pinyin'=>'mayang','code'=>'0745','zip_code'=>'419400','first'=>'M','lng'=>'109.80194','lat'=>'27.866']);
        $this->insert('{{%region}}',['id'=>'1944','pid'=>'1936','shortname'=>'新晃','name'=>'新晃侗族自治县','merger_name'=>'中国,湖南省,怀化市,新晃侗族自治县','level'=>'3','pinyin'=>'xinhuang','code'=>'0745','zip_code'=>'419200','first'=>'X','lng'=>'109.17166','lat'=>'27.35937']);
        $this->insert('{{%region}}',['id'=>'1945','pid'=>'1936','shortname'=>'芷江','name'=>'芷江侗族自治县','merger_name'=>'中国,湖南省,怀化市,芷江侗族自治县','level'=>'3','pinyin'=>'zhijiang','code'=>'0745','zip_code'=>'419100','first'=>NULL,'lng'=>'109.6849','lat'=>'27.44297']);
        $this->insert('{{%region}}',['id'=>'1946','pid'=>'1936','shortname'=>'靖州','name'=>'靖州苗族侗族自治县','merger_name'=>'中国,湖南省,怀化市,靖州苗族侗族自治县','level'=>'3','pinyin'=>'jingzhou','code'=>'0745','zip_code'=>'418400','first'=>'J','lng'=>'109.69821','lat'=>'26.57651']);
        $this->insert('{{%region}}',['id'=>'1947','pid'=>'1936','shortname'=>'通道','name'=>'通道侗族自治县','merger_name'=>'中国,湖南省,怀化市,通道侗族自治县','level'=>'3','pinyin'=>'tongdao','code'=>'0745','zip_code'=>'418500','first'=>'T','lng'=>'109.78515','lat'=>'26.1571']);
        $this->insert('{{%region}}',['id'=>'1948','pid'=>'1936','shortname'=>'洪江','name'=>'洪江市','merger_name'=>'中国,湖南省,怀化市,洪江市','level'=>'3','pinyin'=>'hongjiang','code'=>'0745','zip_code'=>'418100','first'=>'H','lng'=>'109.83651','lat'=>'27.20922']);
        $this->insert('{{%region}}',['id'=>'1949','pid'=>'1827','shortname'=>'娄底','name'=>'娄底市','merger_name'=>'中国,湖南省,娄底市','level'=>'2','pinyin'=>'loudi','code'=>'0738','zip_code'=>'417000','first'=>'L','lng'=>'112.008497','lat'=>'27.728136']);
        $this->insert('{{%region}}',['id'=>'1950','pid'=>'1949','shortname'=>'娄星','name'=>'娄星区','merger_name'=>'中国,湖南省,娄底市,娄星区','level'=>'3','pinyin'=>'louxing','code'=>'0738','zip_code'=>'417000','first'=>'L','lng'=>'112.00193','lat'=>'27.72992']);
        $this->insert('{{%region}}',['id'=>'1951','pid'=>'1949','shortname'=>'双峰','name'=>'双峰县','merger_name'=>'中国,湖南省,娄底市,双峰县','level'=>'3','pinyin'=>'shuangfeng','code'=>'0738','zip_code'=>'417700','first'=>'S','lng'=>'112.19921','lat'=>'27.45418']);
        $this->insert('{{%region}}',['id'=>'1952','pid'=>'1949','shortname'=>'新化','name'=>'新化县','merger_name'=>'中国,湖南省,娄底市,新化县','level'=>'3','pinyin'=>'xinhua','code'=>'0738','zip_code'=>'417600','first'=>'X','lng'=>'111.32739','lat'=>'27.7266']);
        $this->insert('{{%region}}',['id'=>'1953','pid'=>'1949','shortname'=>'冷水江','name'=>'冷水江市','merger_name'=>'中国,湖南省,娄底市,冷水江市','level'=>'3','pinyin'=>'lengshuijiang','code'=>'0738','zip_code'=>'417500','first'=>'L','lng'=>'111.43554','lat'=>'27.68147']);
        $this->insert('{{%region}}',['id'=>'1954','pid'=>'1949','shortname'=>'涟源','name'=>'涟源市','merger_name'=>'中国,湖南省,娄底市,涟源市','level'=>'3','pinyin'=>'lianyuan','code'=>'0738','zip_code'=>'417100','first'=>'L','lng'=>'111.67233','lat'=>'27.68831']);
        $this->insert('{{%region}}',['id'=>'1955','pid'=>'1827','shortname'=>'湘西','name'=>'湘西土家族苗族自治州','merger_name'=>'中国,湖南省,湘西土家族苗族自治州','level'=>'2','pinyin'=>'xiangxi','code'=>'0743','zip_code'=>'416000','first'=>'X','lng'=>'109.739735','lat'=>'28.314296']);
        $this->insert('{{%region}}',['id'=>'1956','pid'=>'1955','shortname'=>'吉首','name'=>'吉首市','merger_name'=>'中国,湖南省,湘西土家族苗族自治州,吉首市','level'=>'3','pinyin'=>'jishou','code'=>'0743','zip_code'=>'416000','first'=>'J','lng'=>'109.69799','lat'=>'28.26247']);
        $this->insert('{{%region}}',['id'=>'1957','pid'=>'1955','shortname'=>'泸溪','name'=>'泸溪县','merger_name'=>'中国,湖南省,湘西土家族苗族自治州,泸溪县','level'=>'3','pinyin'=>'luxi','code'=>'0743','zip_code'=>'416100','first'=>NULL,'lng'=>'110.21682','lat'=>'28.2205']);
        $this->insert('{{%region}}',['id'=>'1958','pid'=>'1955','shortname'=>'凤凰','name'=>'凤凰县','merger_name'=>'中国,湖南省,湘西土家族苗族自治州,凤凰县','level'=>'3','pinyin'=>'fenghuang','code'=>'0743','zip_code'=>'416200','first'=>'F','lng'=>'109.60156','lat'=>'27.94822']);
        $this->insert('{{%region}}',['id'=>'1959','pid'=>'1955','shortname'=>'花垣','name'=>'花垣县','merger_name'=>'中国,湖南省,湘西土家族苗族自治州,花垣县','level'=>'3','pinyin'=>'huayuan','code'=>'0743','zip_code'=>'416400','first'=>'H','lng'=>'109.48217','lat'=>'28.5721']);
        $this->insert('{{%region}}',['id'=>'1960','pid'=>'1955','shortname'=>'保靖','name'=>'保靖县','merger_name'=>'中国,湖南省,湘西土家族苗族自治州,保靖县','level'=>'3','pinyin'=>'baojing','code'=>'0743','zip_code'=>'416500','first'=>'B','lng'=>'109.66049','lat'=>'28.69997']);
        $this->insert('{{%region}}',['id'=>'1961','pid'=>'1955','shortname'=>'古丈','name'=>'古丈县','merger_name'=>'中国,湖南省,湘西土家族苗族自治州,古丈县','level'=>'3','pinyin'=>'guzhang','code'=>'0743','zip_code'=>'416300','first'=>'G','lng'=>'109.94812','lat'=>'28.61944']);
        $this->insert('{{%region}}',['id'=>'1962','pid'=>'1955','shortname'=>'永顺','name'=>'永顺县','merger_name'=>'中国,湖南省,湘西土家族苗族自治州,永顺县','level'=>'3','pinyin'=>'yongshun','code'=>'0743','zip_code'=>'416700','first'=>'Y','lng'=>'109.85266','lat'=>'29.00103']);
        $this->insert('{{%region}}',['id'=>'1963','pid'=>'1955','shortname'=>'龙山','name'=>'龙山县','merger_name'=>'中国,湖南省,湘西土家族苗族自治州,龙山县','level'=>'3','pinyin'=>'longshan','code'=>'0743','zip_code'=>'416800','first'=>'L','lng'=>'109.4432','lat'=>'29.45693']);
        $this->insert('{{%region}}',['id'=>'1964','pid'=>'0','shortname'=>'广东','name'=>'广东省','merger_name'=>'中国,广东省','level'=>'1','pinyin'=>'guangdong','code'=>'','zip_code'=>'','first'=>'G','lng'=>'113.280637','lat'=>'23.125178']);
        $this->insert('{{%region}}',['id'=>'1965','pid'=>'1964','shortname'=>'广州','name'=>'广州市','merger_name'=>'中国,广东省,广州市','level'=>'2','pinyin'=>'guangzhou','code'=>'020','zip_code'=>'510032','first'=>'G','lng'=>'113.280637','lat'=>'23.125178']);
        $this->insert('{{%region}}',['id'=>'1966','pid'=>'1965','shortname'=>'荔湾','name'=>'荔湾区','merger_name'=>'中国,广东省,广州市,荔湾区','level'=>'3','pinyin'=>'liwan','code'=>'020','zip_code'=>'510170','first'=>'L','lng'=>'113.2442','lat'=>'23.12592']);
        $this->insert('{{%region}}',['id'=>'1967','pid'=>'1965','shortname'=>'越秀','name'=>'越秀区','merger_name'=>'中国,广东省,广州市,越秀区','level'=>'3','pinyin'=>'yuexiu','code'=>'020','zip_code'=>'510030','first'=>'Y','lng'=>'113.26683','lat'=>'23.12897']);
        $this->insert('{{%region}}',['id'=>'1968','pid'=>'1965','shortname'=>'海珠','name'=>'海珠区','merger_name'=>'中国,广东省,广州市,海珠区','level'=>'3','pinyin'=>'haizhu','code'=>'020','zip_code'=>'510300','first'=>'H','lng'=>'113.26197','lat'=>'23.10379']);
        $this->insert('{{%region}}',['id'=>'1969','pid'=>'1965','shortname'=>'天河','name'=>'天河区','merger_name'=>'中国,广东省,广州市,天河区','level'=>'3','pinyin'=>'tianhe','code'=>'020','zip_code'=>'510665','first'=>'T','lng'=>'113.36112','lat'=>'23.12467']);
        $this->insert('{{%region}}',['id'=>'1970','pid'=>'1965','shortname'=>'白云','name'=>'白云区','merger_name'=>'中国,广东省,广州市,白云区','level'=>'3','pinyin'=>'baiyun','code'=>'020','zip_code'=>'510405','first'=>'B','lng'=>'113.27307','lat'=>'23.15787']);
        $this->insert('{{%region}}',['id'=>'1971','pid'=>'1965','shortname'=>'黄埔','name'=>'黄埔区','merger_name'=>'中国,广东省,广州市,黄埔区','level'=>'3','pinyin'=>'huangpu','code'=>'020','zip_code'=>'510700','first'=>'H','lng'=>'113.45895','lat'=>'23.10642']);
        $this->insert('{{%region}}',['id'=>'1972','pid'=>'1965','shortname'=>'番禺','name'=>'番禺区','merger_name'=>'中国,广东省,广州市,番禺区','level'=>'3','pinyin'=>'panyu','code'=>'020','zip_code'=>'511400','first'=>'F','lng'=>'113.38397','lat'=>'22.93599']);
        $this->insert('{{%region}}',['id'=>'1973','pid'=>'1965','shortname'=>'花都','name'=>'花都区','merger_name'=>'中国,广东省,广州市,花都区','level'=>'3','pinyin'=>'huadu','code'=>'020','zip_code'=>'510800','first'=>'H','lng'=>'113.22033','lat'=>'23.40358']);
        $this->insert('{{%region}}',['id'=>'1974','pid'=>'1965','shortname'=>'南沙','name'=>'南沙区','merger_name'=>'中国,广东省,广州市,南沙区','level'=>'3','pinyin'=>'nansha','code'=>'020','zip_code'=>'511458','first'=>'N','lng'=>'113.60845','lat'=>'22.77144']);
        $this->insert('{{%region}}',['id'=>'1975','pid'=>'1965','shortname'=>'从化','name'=>'从化区','merger_name'=>'中国,广东省,广州市,从化区','level'=>'3','pinyin'=>'conghua','code'=>'020','zip_code'=>'510900','first'=>'C','lng'=>'113.587386','lat'=>'23.545283']);
        $this->insert('{{%region}}',['id'=>'1976','pid'=>'1965','shortname'=>'增城','name'=>'增城区','merger_name'=>'中国,广东省,广州市,增城区','level'=>'3','pinyin'=>'zengcheng','code'=>'020','zip_code'=>'511300','first'=>'Z','lng'=>'113.829579','lat'=>'23.290497']);
        $this->insert('{{%region}}',['id'=>'1977','pid'=>'1964','shortname'=>'韶关','name'=>'韶关市','merger_name'=>'中国,广东省,韶关市','level'=>'2','pinyin'=>'shaoguan','code'=>'0751','zip_code'=>'512002','first'=>'S','lng'=>'113.591544','lat'=>'24.801322']);
        $this->insert('{{%region}}',['id'=>'1978','pid'=>'1977','shortname'=>'武江','name'=>'武江区','merger_name'=>'中国,广东省,韶关市,武江区','level'=>'3','pinyin'=>'wujiang','code'=>'0751','zip_code'=>'512026','first'=>'W','lng'=>'113.58767','lat'=>'24.79264']);
        $this->insert('{{%region}}',['id'=>'1979','pid'=>'1977','shortname'=>'浈江','name'=>'浈江区','merger_name'=>'中国,广东省,韶关市,浈江区','level'=>'3','pinyin'=>'zhenjiang','code'=>'0751','zip_code'=>'512023','first'=>NULL,'lng'=>'113.61109','lat'=>'24.80438']);
        $this->insert('{{%region}}',['id'=>'1980','pid'=>'1977','shortname'=>'曲江','name'=>'曲江区','merger_name'=>'中国,广东省,韶关市,曲江区','level'=>'3','pinyin'=>'qujiang','code'=>'0751','zip_code'=>'512101','first'=>'Q','lng'=>'113.60165','lat'=>'24.67915']);
        $this->insert('{{%region}}',['id'=>'1981','pid'=>'1977','shortname'=>'始兴','name'=>'始兴县','merger_name'=>'中国,广东省,韶关市,始兴县','level'=>'3','pinyin'=>'shixing','code'=>'0751','zip_code'=>'512500','first'=>'S','lng'=>'114.06799','lat'=>'24.94759']);
        $this->insert('{{%region}}',['id'=>'1982','pid'=>'1977','shortname'=>'仁化','name'=>'仁化县','merger_name'=>'中国,广东省,韶关市,仁化县','level'=>'3','pinyin'=>'renhua','code'=>'0751','zip_code'=>'512300','first'=>'R','lng'=>'113.74737','lat'=>'25.08742']);
        $this->insert('{{%region}}',['id'=>'1983','pid'=>'1977','shortname'=>'翁源','name'=>'翁源县','merger_name'=>'中国,广东省,韶关市,翁源县','level'=>'3','pinyin'=>'wengyuan','code'=>'0751','zip_code'=>'512600','first'=>'W','lng'=>'114.13385','lat'=>'24.3495']);
        $this->insert('{{%region}}',['id'=>'1984','pid'=>'1977','shortname'=>'乳源','name'=>'乳源瑶族自治县','merger_name'=>'中国,广东省,韶关市,乳源瑶族自治县','level'=>'3','pinyin'=>'ruyuan','code'=>'0751','zip_code'=>'512700','first'=>'R','lng'=>'113.27734','lat'=>'24.77803']);
        $this->insert('{{%region}}',['id'=>'1985','pid'=>'1977','shortname'=>'新丰','name'=>'新丰县','merger_name'=>'中国,广东省,韶关市,新丰县','level'=>'3','pinyin'=>'xinfeng','code'=>'0751','zip_code'=>'511100','first'=>'X','lng'=>'114.20788','lat'=>'24.05924']);
        $this->insert('{{%region}}',['id'=>'1986','pid'=>'1977','shortname'=>'乐昌','name'=>'乐昌市','merger_name'=>'中国,广东省,韶关市,乐昌市','level'=>'3','pinyin'=>'lechang','code'=>'0751','zip_code'=>'512200','first'=>'L','lng'=>'113.35653','lat'=>'25.12799']);
        $this->insert('{{%region}}',['id'=>'1987','pid'=>'1977','shortname'=>'南雄','name'=>'南雄市','merger_name'=>'中国,广东省,韶关市,南雄市','level'=>'3','pinyin'=>'nanxiong','code'=>'0751','zip_code'=>'512400','first'=>'N','lng'=>'114.30966','lat'=>'25.11706']);
        $this->insert('{{%region}}',['id'=>'1988','pid'=>'1964','shortname'=>'深圳','name'=>'深圳市','merger_name'=>'中国,广东省,深圳市','level'=>'2','pinyin'=>'shenzhen','code'=>'0755','zip_code'=>'518035','first'=>'S','lng'=>'114.085947','lat'=>'22.547']);
        $this->insert('{{%region}}',['id'=>'1989','pid'=>'1988','shortname'=>'罗湖','name'=>'罗湖区','merger_name'=>'中国,广东省,深圳市,罗湖区','level'=>'3','pinyin'=>'luohu','code'=>'0755','zip_code'=>'518021','first'=>'L','lng'=>'114.13116','lat'=>'22.54836']);
        $this->insert('{{%region}}',['id'=>'1990','pid'=>'1988','shortname'=>'福田','name'=>'福田区','merger_name'=>'中国,广东省,深圳市,福田区','level'=>'3','pinyin'=>'futian','code'=>'0755','zip_code'=>'518048','first'=>'F','lng'=>'114.05571','lat'=>'22.52245']);
        $this->insert('{{%region}}',['id'=>'1991','pid'=>'1988','shortname'=>'南山','name'=>'南山区','merger_name'=>'中国,广东省,深圳市,南山区','level'=>'3','pinyin'=>'nanshan','code'=>'0755','zip_code'=>'518051','first'=>'N','lng'=>'113.93029','lat'=>'22.53291']);
        $this->insert('{{%region}}',['id'=>'1992','pid'=>'1988','shortname'=>'宝安','name'=>'宝安区','merger_name'=>'中国,广东省,深圳市,宝安区','level'=>'3','pinyin'=>'bao\'an','code'=>'0755','zip_code'=>'518101','first'=>'B','lng'=>'113.88311','lat'=>'22.55371']);
        $this->insert('{{%region}}',['id'=>'1993','pid'=>'1988','shortname'=>'龙岗','name'=>'龙岗区','merger_name'=>'中国,广东省,深圳市,龙岗区','level'=>'3','pinyin'=>'longgang','code'=>'0755','zip_code'=>'518172','first'=>'L','lng'=>'114.24771','lat'=>'22.71986']);
        $this->insert('{{%region}}',['id'=>'1994','pid'=>'1988','shortname'=>'盐田','name'=>'盐田区','merger_name'=>'中国,广东省,深圳市,盐田区','level'=>'3','pinyin'=>'yantian','code'=>'0755','zip_code'=>'518081','first'=>'Y','lng'=>'114.23733','lat'=>'22.5578']);
        $this->insert('{{%region}}',['id'=>'1995','pid'=>'1988','shortname'=>'光明新区','name'=>'光明新区','merger_name'=>'中国,广东省,深圳市,光明新区','level'=>'3','pinyin'=>'guangmingxinqu','code'=>'0755','zip_code'=>'518100','first'=>'G','lng'=>'113.896026','lat'=>'22.777292']);
        $this->insert('{{%region}}',['id'=>'1996','pid'=>'1988','shortname'=>'坪山新区','name'=>'坪山新区','merger_name'=>'中国,广东省,深圳市,坪山新区','level'=>'3','pinyin'=>'pingshanxinqu','code'=>'0755','zip_code'=>'518000','first'=>'P','lng'=>'114.34637','lat'=>'22.690529']);
        $this->insert('{{%region}}',['id'=>'1997','pid'=>'1988','shortname'=>'大鹏新区','name'=>'大鹏新区','merger_name'=>'中国,广东省,深圳市,大鹏新区','level'=>'3','pinyin'=>'dapengxinqu','code'=>'0755','zip_code'=>'518000','first'=>'D','lng'=>'114.479901','lat'=>'22.587862']);
        $this->insert('{{%region}}',['id'=>'1998','pid'=>'1988','shortname'=>'龙华新区','name'=>'龙华新区','merger_name'=>'中国,广东省,深圳市,龙华新区','level'=>'3','pinyin'=>'longhuaxinqu','code'=>'0755','zip_code'=>'518100','first'=>'L','lng'=>'114.036585','lat'=>'22.68695']);
        $this->insert('{{%region}}',['id'=>'1999','pid'=>'1964','shortname'=>'珠海','name'=>'珠海市','merger_name'=>'中国,广东省,珠海市','level'=>'2','pinyin'=>'zhuhai','code'=>'0756','zip_code'=>'519000','first'=>'Z','lng'=>'113.552724','lat'=>'22.255899']);
        $this->insert('{{%region}}',['id'=>'2000','pid'=>'1999','shortname'=>'香洲','name'=>'香洲区','merger_name'=>'中国,广东省,珠海市,香洲区','level'=>'3','pinyin'=>'xiangzhou','code'=>'0756','zip_code'=>'519000','first'=>'X','lng'=>'113.5435','lat'=>'22.26654']);
        $this->insert('{{%region}}',['id'=>'2001','pid'=>'1999','shortname'=>'斗门','name'=>'斗门区','merger_name'=>'中国,广东省,珠海市,斗门区','level'=>'3','pinyin'=>'doumen','code'=>'0756','zip_code'=>'519110','first'=>'D','lng'=>'113.29644','lat'=>'22.20898']);
        $this->insert('{{%region}}',['id'=>'2002','pid'=>'1999','shortname'=>'金湾','name'=>'金湾区','merger_name'=>'中国,广东省,珠海市,金湾区','level'=>'3','pinyin'=>'jinwan','code'=>'0756','zip_code'=>'519040','first'=>'J','lng'=>'113.36361','lat'=>'22.14691']);
        $this->insert('{{%region}}',['id'=>'2003','pid'=>'1964','shortname'=>'汕头','name'=>'汕头市','merger_name'=>'中国,广东省,汕头市','level'=>'2','pinyin'=>'shantou','code'=>'0754','zip_code'=>'515041','first'=>'S','lng'=>'116.708463','lat'=>'23.37102']);
        $this->insert('{{%region}}',['id'=>'2004','pid'=>'2003','shortname'=>'龙湖','name'=>'龙湖区','merger_name'=>'中国,广东省,汕头市,龙湖区','level'=>'3','pinyin'=>'longhu','code'=>'0754','zip_code'=>'515041','first'=>'L','lng'=>'116.71641','lat'=>'23.37166']);
        $this->insert('{{%region}}',['id'=>'2005','pid'=>'2003','shortname'=>'金平','name'=>'金平区','merger_name'=>'中国,广东省,汕头市,金平区','level'=>'3','pinyin'=>'jinping','code'=>'0754','zip_code'=>'515041','first'=>'J','lng'=>'116.70364','lat'=>'23.36637']);
        $this->insert('{{%region}}',['id'=>'2006','pid'=>'2003','shortname'=>'濠江','name'=>'濠江区','merger_name'=>'中国,广东省,汕头市,濠江区','level'=>'3','pinyin'=>'haojiang','code'=>'0754','zip_code'=>'515071','first'=>NULL,'lng'=>'116.72659','lat'=>'23.28588']);
        $this->insert('{{%region}}',['id'=>'2007','pid'=>'2003','shortname'=>'潮阳','name'=>'潮阳区','merger_name'=>'中国,广东省,汕头市,潮阳区','level'=>'3','pinyin'=>'chaoyang','code'=>'0754','zip_code'=>'515100','first'=>'C','lng'=>'116.6015','lat'=>'23.26485']);
        $this->insert('{{%region}}',['id'=>'2008','pid'=>'2003','shortname'=>'潮南','name'=>'潮南区','merger_name'=>'中国,广东省,汕头市,潮南区','level'=>'3','pinyin'=>'chaonan','code'=>'0754','zip_code'=>'515144','first'=>'C','lng'=>'116.43188','lat'=>'23.25']);
        $this->insert('{{%region}}',['id'=>'2009','pid'=>'2003','shortname'=>'澄海','name'=>'澄海区','merger_name'=>'中国,广东省,汕头市,澄海区','level'=>'3','pinyin'=>'chenghai','code'=>'0754','zip_code'=>'515800','first'=>'C','lng'=>'116.75589','lat'=>'23.46728']);
        $this->insert('{{%region}}',['id'=>'2010','pid'=>'2003','shortname'=>'南澳','name'=>'南澳县','merger_name'=>'中国,广东省,汕头市,南澳县','level'=>'3','pinyin'=>'nanao','code'=>'0754','zip_code'=>'515900','first'=>'N','lng'=>'117.01889','lat'=>'23.4223']);
        $this->insert('{{%region}}',['id'=>'2011','pid'=>'1964','shortname'=>'佛山','name'=>'佛山市','merger_name'=>'中国,广东省,佛山市','level'=>'2','pinyin'=>'foshan','code'=>'0757','zip_code'=>'528000','first'=>'F','lng'=>'113.122717','lat'=>'23.028762']);
        $this->insert('{{%region}}',['id'=>'2012','pid'=>'2011','shortname'=>'禅城','name'=>'禅城区','merger_name'=>'中国,广东省,佛山市,禅城区','level'=>'3','pinyin'=>'chancheng','code'=>'0757','zip_code'=>'528000','first'=>NULL,'lng'=>'113.1228','lat'=>'23.00842']);
        $this->insert('{{%region}}',['id'=>'2013','pid'=>'2011','shortname'=>'南海','name'=>'南海区','merger_name'=>'中国,广东省,佛山市,南海区','level'=>'3','pinyin'=>'nanhai','code'=>'0757','zip_code'=>'528251','first'=>'N','lng'=>'113.14299','lat'=>'23.02877']);
        $this->insert('{{%region}}',['id'=>'2014','pid'=>'2011','shortname'=>'顺德','name'=>'顺德区','merger_name'=>'中国,广东省,佛山市,顺德区','level'=>'3','pinyin'=>'shunde','code'=>'0757','zip_code'=>'528300','first'=>'S','lng'=>'113.29394','lat'=>'22.80452']);
        $this->insert('{{%region}}',['id'=>'2015','pid'=>'2011','shortname'=>'三水','name'=>'三水区','merger_name'=>'中国,广东省,佛山市,三水区','level'=>'3','pinyin'=>'sanshui','code'=>'0757','zip_code'=>'528133','first'=>'S','lng'=>'112.89703','lat'=>'23.15564']);
        $this->insert('{{%region}}',['id'=>'2016','pid'=>'2011','shortname'=>'高明','name'=>'高明区','merger_name'=>'中国,广东省,佛山市,高明区','level'=>'3','pinyin'=>'gaoming','code'=>'0757','zip_code'=>'528500','first'=>'G','lng'=>'112.89254','lat'=>'22.90022']);
        $this->insert('{{%region}}',['id'=>'2017','pid'=>'1964','shortname'=>'江门','name'=>'江门市','merger_name'=>'中国,广东省,江门市','level'=>'2','pinyin'=>'jiangmen','code'=>'0750','zip_code'=>'529000','first'=>'J','lng'=>'113.094942','lat'=>'22.590431']);
        $this->insert('{{%region}}',['id'=>'2018','pid'=>'2017','shortname'=>'蓬江','name'=>'蓬江区','merger_name'=>'中国,广东省,江门市,蓬江区','level'=>'3','pinyin'=>'pengjiang','code'=>'0750','zip_code'=>'529000','first'=>'P','lng'=>'113.07849','lat'=>'22.59515']);
        $this->insert('{{%region}}',['id'=>'2019','pid'=>'2017','shortname'=>'江海','name'=>'江海区','merger_name'=>'中国,广东省,江门市,江海区','level'=>'3','pinyin'=>'jianghai','code'=>'0750','zip_code'=>'529040','first'=>'J','lng'=>'113.11099','lat'=>'22.56024']);
        $this->insert('{{%region}}',['id'=>'2020','pid'=>'2017','shortname'=>'新会','name'=>'新会区','merger_name'=>'中国,广东省,江门市,新会区','level'=>'3','pinyin'=>'xinhui','code'=>'0750','zip_code'=>'529100','first'=>'X','lng'=>'113.03225','lat'=>'22.45876']);
        $this->insert('{{%region}}',['id'=>'2021','pid'=>'2017','shortname'=>'台山','name'=>'台山市','merger_name'=>'中国,广东省,江门市,台山市','level'=>'3','pinyin'=>'taishan','code'=>'0750','zip_code'=>'529200','first'=>'T','lng'=>'112.79382','lat'=>'22.2515']);
        $this->insert('{{%region}}',['id'=>'2022','pid'=>'2017','shortname'=>'开平','name'=>'开平市','merger_name'=>'中国,广东省,江门市,开平市','level'=>'3','pinyin'=>'kaiping','code'=>'0750','zip_code'=>'529337','first'=>'K','lng'=>'112.69842','lat'=>'22.37622']);
        $this->insert('{{%region}}',['id'=>'2023','pid'=>'2017','shortname'=>'鹤山','name'=>'鹤山市','merger_name'=>'中国,广东省,江门市,鹤山市','level'=>'3','pinyin'=>'heshan','code'=>'0750','zip_code'=>'529700','first'=>'H','lng'=>'112.96429','lat'=>'22.76523']);
        $this->insert('{{%region}}',['id'=>'2024','pid'=>'2017','shortname'=>'恩平','name'=>'恩平市','merger_name'=>'中国,广东省,江门市,恩平市','level'=>'3','pinyin'=>'enping','code'=>'0750','zip_code'=>'529400','first'=>'E','lng'=>'112.30496','lat'=>'22.18288']);
        $this->insert('{{%region}}',['id'=>'2025','pid'=>'1964','shortname'=>'湛江','name'=>'湛江市','merger_name'=>'中国,广东省,湛江市','level'=>'2','pinyin'=>'zhanjiang','code'=>'0759','zip_code'=>'524047','first'=>'Z','lng'=>'110.405529','lat'=>'21.195338']);
        $this->insert('{{%region}}',['id'=>'2026','pid'=>'2025','shortname'=>'赤坎','name'=>'赤坎区','merger_name'=>'中国,广东省,湛江市,赤坎区','level'=>'3','pinyin'=>'chikan','code'=>'0759','zip_code'=>'524033','first'=>'C','lng'=>'110.36592','lat'=>'21.26606']);
        $this->insert('{{%region}}',['id'=>'2027','pid'=>'2025','shortname'=>'霞山','name'=>'霞山区','merger_name'=>'中国,广东省,湛江市,霞山区','level'=>'3','pinyin'=>'xiashan','code'=>'0759','zip_code'=>'524011','first'=>'X','lng'=>'110.39822','lat'=>'21.19181']);
        $this->insert('{{%region}}',['id'=>'2028','pid'=>'2025','shortname'=>'坡头','name'=>'坡头区','merger_name'=>'中国,广东省,湛江市,坡头区','level'=>'3','pinyin'=>'potou','code'=>'0759','zip_code'=>'524057','first'=>'P','lng'=>'110.45533','lat'=>'21.24472']);
        $this->insert('{{%region}}',['id'=>'2029','pid'=>'2025','shortname'=>'麻章','name'=>'麻章区','merger_name'=>'中国,广东省,湛江市,麻章区','level'=>'3','pinyin'=>'mazhang','code'=>'0759','zip_code'=>'524094','first'=>'M','lng'=>'110.3342','lat'=>'21.26333']);
        $this->insert('{{%region}}',['id'=>'2030','pid'=>'2025','shortname'=>'遂溪','name'=>'遂溪县','merger_name'=>'中国,广东省,湛江市,遂溪县','level'=>'3','pinyin'=>'suixi','code'=>'0759','zip_code'=>'524300','first'=>'S','lng'=>'110.25003','lat'=>'21.37721']);
        $this->insert('{{%region}}',['id'=>'2031','pid'=>'2025','shortname'=>'徐闻','name'=>'徐闻县','merger_name'=>'中国,广东省,湛江市,徐闻县','level'=>'3','pinyin'=>'xuwen','code'=>'0759','zip_code'=>'524100','first'=>'X','lng'=>'110.17379','lat'=>'20.32812']);
        $this->insert('{{%region}}',['id'=>'2032','pid'=>'2025','shortname'=>'廉江','name'=>'廉江市','merger_name'=>'中国,广东省,湛江市,廉江市','level'=>'3','pinyin'=>'lianjiang','code'=>'0759','zip_code'=>'524400','first'=>'L','lng'=>'110.28442','lat'=>'21.60917']);
        $this->insert('{{%region}}',['id'=>'2033','pid'=>'2025','shortname'=>'雷州','name'=>'雷州市','merger_name'=>'中国,广东省,湛江市,雷州市','level'=>'3','pinyin'=>'leizhou','code'=>'0759','zip_code'=>'524200','first'=>'L','lng'=>'110.10092','lat'=>'20.91428']);
        $this->insert('{{%region}}',['id'=>'2034','pid'=>'2025','shortname'=>'吴川','name'=>'吴川市','merger_name'=>'中国,广东省,湛江市,吴川市','level'=>'3','pinyin'=>'wuchuan','code'=>'0759','zip_code'=>'524500','first'=>'W','lng'=>'110.77703','lat'=>'21.44584']);
        $this->insert('{{%region}}',['id'=>'2035','pid'=>'1964','shortname'=>'茂名','name'=>'茂名市','merger_name'=>'中国,广东省,茂名市','level'=>'2','pinyin'=>'maoming','code'=>'0668','zip_code'=>'525000','first'=>'M','lng'=>'110.919229','lat'=>'21.659751']);
        $this->insert('{{%region}}',['id'=>'2036','pid'=>'2035','shortname'=>'茂南','name'=>'茂南区','merger_name'=>'中国,广东省,茂名市,茂南区','level'=>'3','pinyin'=>'maonan','code'=>'0668','zip_code'=>'525000','first'=>'M','lng'=>'110.9187','lat'=>'21.64103']);
        $this->insert('{{%region}}',['id'=>'2037','pid'=>'2035','shortname'=>'电白','name'=>'电白区','merger_name'=>'中国,广东省,茂名市,电白区','level'=>'3','pinyin'=>'dianbai','code'=>'0668','zip_code'=>'525400','first'=>'D','lng'=>'111.007264','lat'=>'21.507219']);
        $this->insert('{{%region}}',['id'=>'2038','pid'=>'2035','shortname'=>'高州','name'=>'高州市','merger_name'=>'中国,广东省,茂名市,高州市','level'=>'3','pinyin'=>'gaozhou','code'=>'0668','zip_code'=>'525200','first'=>'G','lng'=>'110.85519','lat'=>'21.92057']);
        $this->insert('{{%region}}',['id'=>'2039','pid'=>'2035','shortname'=>'化州','name'=>'化州市','merger_name'=>'中国,广东省,茂名市,化州市','level'=>'3','pinyin'=>'huazhou','code'=>'0668','zip_code'=>'525100','first'=>'H','lng'=>'110.63949','lat'=>'21.66394']);
        $this->insert('{{%region}}',['id'=>'2040','pid'=>'2035','shortname'=>'信宜','name'=>'信宜市','merger_name'=>'中国,广东省,茂名市,信宜市','level'=>'3','pinyin'=>'xinyi','code'=>'0668','zip_code'=>'525300','first'=>'X','lng'=>'110.94647','lat'=>'22.35351']);
        $this->insert('{{%region}}',['id'=>'2041','pid'=>'1964','shortname'=>'肇庆','name'=>'肇庆市','merger_name'=>'中国,广东省,肇庆市','level'=>'2','pinyin'=>'zhaoqing','code'=>'0758','zip_code'=>'526040','first'=>'Z','lng'=>'112.472529','lat'=>'23.051546']);
        $this->insert('{{%region}}',['id'=>'2042','pid'=>'2041','shortname'=>'端州','name'=>'端州区','merger_name'=>'中国,广东省,肇庆市,端州区','level'=>'3','pinyin'=>'duanzhou','code'=>'0758','zip_code'=>'526060','first'=>'D','lng'=>'112.48495','lat'=>'23.0519']);
        $this->insert('{{%region}}',['id'=>'2043','pid'=>'2041','shortname'=>'鼎湖','name'=>'鼎湖区','merger_name'=>'中国,广东省,肇庆市,鼎湖区','level'=>'3','pinyin'=>'dinghu','code'=>'0758','zip_code'=>'526070','first'=>'D','lng'=>'112.56643','lat'=>'23.15846']);
        $this->insert('{{%region}}',['id'=>'2044','pid'=>'2041','shortname'=>'广宁','name'=>'广宁县','merger_name'=>'中国,广东省,肇庆市,广宁县','level'=>'3','pinyin'=>'guangning','code'=>'0758','zip_code'=>'526300','first'=>'G','lng'=>'112.44064','lat'=>'23.6346']);
        $this->insert('{{%region}}',['id'=>'2045','pid'=>'2041','shortname'=>'怀集','name'=>'怀集县','merger_name'=>'中国,广东省,肇庆市,怀集县','level'=>'3','pinyin'=>'huaiji','code'=>'0758','zip_code'=>'526400','first'=>'H','lng'=>'112.18396','lat'=>'23.90918']);
        $this->insert('{{%region}}',['id'=>'2046','pid'=>'2041','shortname'=>'封开','name'=>'封开县','merger_name'=>'中国,广东省,肇庆市,封开县','level'=>'3','pinyin'=>'fengkai','code'=>'0758','zip_code'=>'526500','first'=>'F','lng'=>'111.50332','lat'=>'23.43571']);
        $this->insert('{{%region}}',['id'=>'2047','pid'=>'2041','shortname'=>'德庆','name'=>'德庆县','merger_name'=>'中国,广东省,肇庆市,德庆县','level'=>'3','pinyin'=>'deqing','code'=>'0758','zip_code'=>'526600','first'=>'D','lng'=>'111.78555','lat'=>'23.14371']);
        $this->insert('{{%region}}',['id'=>'2048','pid'=>'2041','shortname'=>'高要','name'=>'高要市','merger_name'=>'中国,广东省,肇庆市,高要市','level'=>'3','pinyin'=>'gaoyao','code'=>'0758','zip_code'=>'526100','first'=>'G','lng'=>'112.45834','lat'=>'23.02577']);
        $this->insert('{{%region}}',['id'=>'2049','pid'=>'2041','shortname'=>'四会','name'=>'四会市','merger_name'=>'中国,广东省,肇庆市,四会市','level'=>'3','pinyin'=>'sihui','code'=>'0758','zip_code'=>'526200','first'=>'S','lng'=>'112.73416','lat'=>'23.32686']);
        $this->insert('{{%region}}',['id'=>'2050','pid'=>'1964','shortname'=>'惠州','name'=>'惠州市','merger_name'=>'中国,广东省,惠州市','level'=>'2','pinyin'=>'huizhou','code'=>'0752','zip_code'=>'516000','first'=>'H','lng'=>'114.412599','lat'=>'23.079404']);
        $this->insert('{{%region}}',['id'=>'2051','pid'=>'2050','shortname'=>'惠城','name'=>'惠城区','merger_name'=>'中国,广东省,惠州市,惠城区','level'=>'3','pinyin'=>'huicheng','code'=>'0752','zip_code'=>'516008','first'=>'H','lng'=>'114.3828','lat'=>'23.08377']);
        $this->insert('{{%region}}',['id'=>'2052','pid'=>'2050','shortname'=>'惠阳','name'=>'惠阳区','merger_name'=>'中国,广东省,惠州市,惠阳区','level'=>'3','pinyin'=>'huiyang','code'=>'0752','zip_code'=>'516211','first'=>'H','lng'=>'114.45639','lat'=>'22.78845']);
        $this->insert('{{%region}}',['id'=>'2053','pid'=>'2050','shortname'=>'博罗','name'=>'博罗县','merger_name'=>'中国,广东省,惠州市,博罗县','level'=>'3','pinyin'=>'boluo','code'=>'0752','zip_code'=>'516100','first'=>'B','lng'=>'114.28964','lat'=>'23.17307']);
        $this->insert('{{%region}}',['id'=>'2054','pid'=>'2050','shortname'=>'惠东','name'=>'惠东县','merger_name'=>'中国,广东省,惠州市,惠东县','level'=>'3','pinyin'=>'huidong','code'=>'0752','zip_code'=>'516300','first'=>'H','lng'=>'114.72009','lat'=>'22.98484']);
        $this->insert('{{%region}}',['id'=>'2055','pid'=>'2050','shortname'=>'龙门','name'=>'龙门县','merger_name'=>'中国,广东省,惠州市,龙门县','level'=>'3','pinyin'=>'longmen','code'=>'0752','zip_code'=>'516800','first'=>'L','lng'=>'114.25479','lat'=>'23.72758']);
        $this->insert('{{%region}}',['id'=>'2056','pid'=>'1964','shortname'=>'梅州','name'=>'梅州市','merger_name'=>'中国,广东省,梅州市','level'=>'2','pinyin'=>'meizhou','code'=>'0753','zip_code'=>'514021','first'=>'M','lng'=>'116.117582','lat'=>'24.299112']);
        $this->insert('{{%region}}',['id'=>'2057','pid'=>'2056','shortname'=>'梅江','name'=>'梅江区','merger_name'=>'中国,广东省,梅州市,梅江区','level'=>'3','pinyin'=>'meijiang','code'=>'0753','zip_code'=>'514000','first'=>'M','lng'=>'116.11663','lat'=>'24.31062']);
        $this->insert('{{%region}}',['id'=>'2058','pid'=>'2056','shortname'=>'梅县','name'=>'梅县区','merger_name'=>'中国,广东省,梅州市,梅县区','level'=>'3','pinyin'=>'meixian','code'=>'0753','zip_code'=>'514787','first'=>'M','lng'=>'116.097753','lat'=>'24.286739']);
        $this->insert('{{%region}}',['id'=>'2059','pid'=>'2056','shortname'=>'大埔','name'=>'大埔县','merger_name'=>'中国,广东省,梅州市,大埔县','level'=>'3','pinyin'=>'dabu','code'=>'0753','zip_code'=>'514200','first'=>'D','lng'=>'116.69662','lat'=>'24.35325']);
        $this->insert('{{%region}}',['id'=>'2060','pid'=>'2056','shortname'=>'丰顺','name'=>'丰顺县','merger_name'=>'中国,广东省,梅州市,丰顺县','level'=>'3','pinyin'=>'fengshun','code'=>'0753','zip_code'=>'514300','first'=>'F','lng'=>'116.18219','lat'=>'23.74094']);
        $this->insert('{{%region}}',['id'=>'2061','pid'=>'2056','shortname'=>'五华','name'=>'五华县','merger_name'=>'中国,广东省,梅州市,五华县','level'=>'3','pinyin'=>'wuhua','code'=>'0753','zip_code'=>'514400','first'=>'W','lng'=>'115.77893','lat'=>'23.92417']);
        $this->insert('{{%region}}',['id'=>'2062','pid'=>'2056','shortname'=>'平远','name'=>'平远县','merger_name'=>'中国,广东省,梅州市,平远县','level'=>'3','pinyin'=>'pingyuan','code'=>'0753','zip_code'=>'514600','first'=>'P','lng'=>'115.89556','lat'=>'24.57116']);
        $this->insert('{{%region}}',['id'=>'2063','pid'=>'2056','shortname'=>'蕉岭','name'=>'蕉岭县','merger_name'=>'中国,广东省,梅州市,蕉岭县','level'=>'3','pinyin'=>'jiaoling','code'=>'0753','zip_code'=>'514100','first'=>'J','lng'=>'116.17089','lat'=>'24.65732']);
        $this->insert('{{%region}}',['id'=>'2064','pid'=>'2056','shortname'=>'兴宁','name'=>'兴宁市','merger_name'=>'中国,广东省,梅州市,兴宁市','level'=>'3','pinyin'=>'xingning','code'=>'0753','zip_code'=>'514500','first'=>'X','lng'=>'115.73141','lat'=>'24.14001']);
        $this->insert('{{%region}}',['id'=>'2065','pid'=>'1964','shortname'=>'汕尾','name'=>'汕尾市','merger_name'=>'中国,广东省,汕尾市','level'=>'2','pinyin'=>'shanwei','code'=>'0660','zip_code'=>'516600','first'=>'S','lng'=>'115.364238','lat'=>'22.774485']);
        $this->insert('{{%region}}',['id'=>'2066','pid'=>'2065','shortname'=>'城区','name'=>'城区','merger_name'=>'中国,广东省,汕尾市,城区','level'=>'3','pinyin'=>'chengqu','code'=>'0660','zip_code'=>'516600','first'=>'C','lng'=>'115.36503','lat'=>'22.7789']);
        $this->insert('{{%region}}',['id'=>'2067','pid'=>'2065','shortname'=>'海丰','name'=>'海丰县','merger_name'=>'中国,广东省,汕尾市,海丰县','level'=>'3','pinyin'=>'haifeng','code'=>'0660','zip_code'=>'516400','first'=>'H','lng'=>'115.32336','lat'=>'22.96653']);
        $this->insert('{{%region}}',['id'=>'2068','pid'=>'2065','shortname'=>'陆河','name'=>'陆河县','merger_name'=>'中国,广东省,汕尾市,陆河县','level'=>'3','pinyin'=>'luhe','code'=>'0660','zip_code'=>'516700','first'=>'L','lng'=>'115.65597','lat'=>'23.30365']);
        $this->insert('{{%region}}',['id'=>'2069','pid'=>'2065','shortname'=>'陆丰','name'=>'陆丰市','merger_name'=>'中国,广东省,汕尾市,陆丰市','level'=>'3','pinyin'=>'lufeng','code'=>'0660','zip_code'=>'516500','first'=>'L','lng'=>'115.64813','lat'=>'22.94335']);
        $this->insert('{{%region}}',['id'=>'2070','pid'=>'1964','shortname'=>'河源','name'=>'河源市','merger_name'=>'中国,广东省,河源市','level'=>'2','pinyin'=>'heyuan','code'=>'0762','zip_code'=>'517000','first'=>'H','lng'=>'114.697802','lat'=>'23.746266']);
        $this->insert('{{%region}}',['id'=>'2071','pid'=>'2070','shortname'=>'源城','name'=>'源城区','merger_name'=>'中国,广东省,河源市,源城区','level'=>'3','pinyin'=>'yuancheng','code'=>'0762','zip_code'=>'517000','first'=>'Y','lng'=>'114.70242','lat'=>'23.7341']);
        $this->insert('{{%region}}',['id'=>'2072','pid'=>'2070','shortname'=>'紫金','name'=>'紫金县','merger_name'=>'中国,广东省,河源市,紫金县','level'=>'3','pinyin'=>'zijin','code'=>'0762','zip_code'=>'517400','first'=>'Z','lng'=>'115.18365','lat'=>'23.63867']);
        $this->insert('{{%region}}',['id'=>'2073','pid'=>'2070','shortname'=>'龙川','name'=>'龙川县','merger_name'=>'中国,广东省,河源市,龙川县','level'=>'3','pinyin'=>'longchuan','code'=>'0762','zip_code'=>'517300','first'=>'L','lng'=>'115.26025','lat'=>'24.10142']);
        $this->insert('{{%region}}',['id'=>'2074','pid'=>'2070','shortname'=>'连平','name'=>'连平县','merger_name'=>'中国,广东省,河源市,连平县','level'=>'3','pinyin'=>'lianping','code'=>'0762','zip_code'=>'517100','first'=>'L','lng'=>'114.49026','lat'=>'24.37156']);
        $this->insert('{{%region}}',['id'=>'2075','pid'=>'2070','shortname'=>'和平','name'=>'和平县','merger_name'=>'中国,广东省,河源市,和平县','level'=>'3','pinyin'=>'heping','code'=>'0762','zip_code'=>'517200','first'=>'H','lng'=>'114.93841','lat'=>'24.44319']);
        $this->insert('{{%region}}',['id'=>'2076','pid'=>'2070','shortname'=>'东源','name'=>'东源县','merger_name'=>'中国,广东省,河源市,东源县','level'=>'3','pinyin'=>'dongyuan','code'=>'0762','zip_code'=>'517583','first'=>'D','lng'=>'114.74633','lat'=>'23.78835']);
        $this->insert('{{%region}}',['id'=>'2077','pid'=>'1964','shortname'=>'阳江','name'=>'阳江市','merger_name'=>'中国,广东省,阳江市','level'=>'2','pinyin'=>'yangjiang','code'=>'0662','zip_code'=>'529500','first'=>'Y','lng'=>'111.975107','lat'=>'21.859222']);
        $this->insert('{{%region}}',['id'=>'2078','pid'=>'2077','shortname'=>'江城','name'=>'江城区','merger_name'=>'中国,广东省,阳江市,江城区','level'=>'3','pinyin'=>'jiangcheng','code'=>'0662','zip_code'=>'529500','first'=>'J','lng'=>'111.95488','lat'=>'21.86193']);
        $this->insert('{{%region}}',['id'=>'2079','pid'=>'2077','shortname'=>'阳东','name'=>'阳东区','merger_name'=>'中国,广东省,阳江市,阳东区','level'=>'3','pinyin'=>'yangdong','code'=>'0662','zip_code'=>'529900','first'=>'Y','lng'=>'112.01467','lat'=>'21.87398']);
        $this->insert('{{%region}}',['id'=>'2080','pid'=>'2077','shortname'=>'阳西','name'=>'阳西县','merger_name'=>'中国,广东省,阳江市,阳西县','level'=>'3','pinyin'=>'yangxi','code'=>'0662','zip_code'=>'529800','first'=>'Y','lng'=>'111.61785','lat'=>'21.75234']);
        $this->insert('{{%region}}',['id'=>'2081','pid'=>'2077','shortname'=>'阳春','name'=>'阳春市','merger_name'=>'中国,广东省,阳江市,阳春市','level'=>'3','pinyin'=>'yangchun','code'=>'0662','zip_code'=>'529600','first'=>'Y','lng'=>'111.78854','lat'=>'22.17232']);
        $this->insert('{{%region}}',['id'=>'2082','pid'=>'1964','shortname'=>'清远','name'=>'清远市','merger_name'=>'中国,广东省,清远市','level'=>'2','pinyin'=>'qingyuan','code'=>'0763','zip_code'=>'511500','first'=>'Q','lng'=>'113.036779','lat'=>'23.704188']);
        $this->insert('{{%region}}',['id'=>'2083','pid'=>'2082','shortname'=>'清城','name'=>'清城区','merger_name'=>'中国,广东省,清远市,清城区','level'=>'3','pinyin'=>'qingcheng','code'=>'0763','zip_code'=>'511515','first'=>'Q','lng'=>'113.06265','lat'=>'23.69784']);
        $this->insert('{{%region}}',['id'=>'2084','pid'=>'2082','shortname'=>'清新','name'=>'清新区','merger_name'=>'中国,广东省,清远市,清新区','level'=>'3','pinyin'=>'qingxin','code'=>'0763','zip_code'=>'511810','first'=>'Q','lng'=>'113.015203','lat'=>'23.736949']);
        $this->insert('{{%region}}',['id'=>'2085','pid'=>'2082','shortname'=>'佛冈','name'=>'佛冈县','merger_name'=>'中国,广东省,清远市,佛冈县','level'=>'3','pinyin'=>'fogang','code'=>'0763','zip_code'=>'511600','first'=>'F','lng'=>'113.53286','lat'=>'23.87231']);
        $this->insert('{{%region}}',['id'=>'2086','pid'=>'2082','shortname'=>'阳山','name'=>'阳山县','merger_name'=>'中国,广东省,清远市,阳山县','level'=>'3','pinyin'=>'yangshan','code'=>'0763','zip_code'=>'513100','first'=>'Y','lng'=>'112.64129','lat'=>'24.46516']);
        $this->insert('{{%region}}',['id'=>'2087','pid'=>'2082','shortname'=>'连山','name'=>'连山壮族瑶族自治县','merger_name'=>'中国,广东省,清远市,连山壮族瑶族自治县','level'=>'3','pinyin'=>'lianshan','code'=>'0763','zip_code'=>'513200','first'=>'L','lng'=>'112.0802','lat'=>'24.56807']);
        $this->insert('{{%region}}',['id'=>'2088','pid'=>'2082','shortname'=>'连南','name'=>'连南瑶族自治县','merger_name'=>'中国,广东省,清远市,连南瑶族自治县','level'=>'3','pinyin'=>'liannan','code'=>'0763','zip_code'=>'513300','first'=>'L','lng'=>'112.28842','lat'=>'24.71726']);
        $this->insert('{{%region}}',['id'=>'2089','pid'=>'2082','shortname'=>'英德','name'=>'英德市','merger_name'=>'中国,广东省,清远市,英德市','level'=>'3','pinyin'=>'yingde','code'=>'0763','zip_code'=>'513000','first'=>'Y','lng'=>'113.415','lat'=>'24.18571']);
        $this->insert('{{%region}}',['id'=>'2090','pid'=>'2082','shortname'=>'连州','name'=>'连州市','merger_name'=>'中国,广东省,清远市,连州市','level'=>'3','pinyin'=>'lianzhou','code'=>'0763','zip_code'=>'513400','first'=>'L','lng'=>'112.38153','lat'=>'24.77913']);
        $this->insert('{{%region}}',['id'=>'2091','pid'=>'1964','shortname'=>'东莞','name'=>'东莞市','merger_name'=>'中国,广东省,东莞市','level'=>'2','pinyin'=>'dongguan','code'=>'0769','zip_code'=>'523888','first'=>'D','lng'=>'113.760234','lat'=>'23.048884']);
        $this->insert('{{%region}}',['id'=>'2092','pid'=>'2091','shortname'=>'莞城','name'=>'莞城区','merger_name'=>'中国,广东省,东莞市,莞城区','level'=>'3','pinyin'=>'guancheng','code'=>'0769','zip_code'=>'523128','first'=>NULL,'lng'=>'113.751043','lat'=>'23.053412']);
        $this->insert('{{%region}}',['id'=>'2093','pid'=>'2091','shortname'=>'南城','name'=>'南城区','merger_name'=>'中国,广东省,东莞市,南城区','level'=>'3','pinyin'=>'nancheng','code'=>'0769','zip_code'=>'523617','first'=>'N','lng'=>'113.752125','lat'=>'23.02018']);
        $this->insert('{{%region}}',['id'=>'2094','pid'=>'2091','shortname'=>'万江','name'=>'万江区','merger_name'=>'中国,广东省,东莞市,万江区','level'=>'3','pinyin'=>'wanjiang','code'=>'0769','zip_code'=>'523039','first'=>'W','lng'=>'113.739053','lat'=>'23.043842']);
        $this->insert('{{%region}}',['id'=>'2095','pid'=>'2091','shortname'=>'石碣','name'=>'石碣镇','merger_name'=>'中国,广东省,东莞市,石碣镇','level'=>'3','pinyin'=>'shijie','code'=>'0769','zip_code'=>'523290','first'=>'S','lng'=>'113.80217','lat'=>'23.09899']);
        $this->insert('{{%region}}',['id'=>'2096','pid'=>'2091','shortname'=>'石龙','name'=>'石龙镇','merger_name'=>'中国,广东省,东莞市,石龙镇','level'=>'3','pinyin'=>'shilong','code'=>'0769','zip_code'=>'523326','first'=>'S','lng'=>'113.876381','lat'=>'23.107444']);
        $this->insert('{{%region}}',['id'=>'2097','pid'=>'2091','shortname'=>'茶山','name'=>'茶山镇','merger_name'=>'中国,广东省,东莞市,茶山镇','level'=>'3','pinyin'=>'chashan','code'=>'0769','zip_code'=>'523380','first'=>'C','lng'=>'113.883526','lat'=>'23.062375']);
        $this->insert('{{%region}}',['id'=>'2098','pid'=>'2091','shortname'=>'石排','name'=>'石排镇','merger_name'=>'中国,广东省,东莞市,石排镇','level'=>'3','pinyin'=>'shipai','code'=>'0769','zip_code'=>'523346','first'=>'S','lng'=>'113.919859','lat'=>'23.0863']);
        $this->insert('{{%region}}',['id'=>'2099','pid'=>'2091','shortname'=>'企石','name'=>'企石镇','merger_name'=>'中国,广东省,东莞市,企石镇','level'=>'3','pinyin'=>'qishi','code'=>'0769','zip_code'=>'523507','first'=>'Q','lng'=>'114.013233','lat'=>'23.066044']);
        $this->insert('{{%region}}',['id'=>'2100','pid'=>'2091','shortname'=>'横沥','name'=>'横沥镇','merger_name'=>'中国,广东省,东莞市,横沥镇','level'=>'3','pinyin'=>'hengli','code'=>'0769','zip_code'=>'523471','first'=>'H','lng'=>'113.957436','lat'=>'23.025732']);
        $this->insert('{{%region}}',['id'=>'2101','pid'=>'2091','shortname'=>'桥头','name'=>'桥头镇','merger_name'=>'中国,广东省,东莞市,桥头镇','level'=>'3','pinyin'=>'qiaotou','code'=>'0769','zip_code'=>'523520','first'=>'Q','lng'=>'114.01385','lat'=>'22.939727']);
        $this->insert('{{%region}}',['id'=>'2102','pid'=>'2091','shortname'=>'谢岗','name'=>'谢岗镇','merger_name'=>'中国,广东省,东莞市,谢岗镇','level'=>'3','pinyin'=>'xiegang','code'=>'0769','zip_code'=>'523592','first'=>'X','lng'=>'114.141396','lat'=>'22.959664']);
        $this->insert('{{%region}}',['id'=>'2103','pid'=>'2091','shortname'=>'东坑','name'=>'东坑镇','merger_name'=>'中国,广东省,东莞市,东坑镇','level'=>'3','pinyin'=>'dongkeng','code'=>'0769','zip_code'=>'523451','first'=>'D','lng'=>'113.939835','lat'=>'22.992804']);
        $this->insert('{{%region}}',['id'=>'2104','pid'=>'2091','shortname'=>'常平','name'=>'常平镇','merger_name'=>'中国,广东省,东莞市,常平镇','level'=>'3','pinyin'=>'changping','code'=>'0769','zip_code'=>'523560','first'=>'C','lng'=>'114.029627','lat'=>'23.016116']);
        $this->insert('{{%region}}',['id'=>'2105','pid'=>'2091','shortname'=>'寮步','name'=>'寮步镇','merger_name'=>'中国,广东省,东莞市,寮步镇','level'=>'3','pinyin'=>'liaobu','code'=>'0769','zip_code'=>'523411','first'=>NULL,'lng'=>'113.884745','lat'=>'22.991738']);
        $this->insert('{{%region}}',['id'=>'2106','pid'=>'2091','shortname'=>'大朗','name'=>'大朗镇','merger_name'=>'中国,广东省,东莞市,大朗镇','level'=>'3','pinyin'=>'dalang','code'=>'0769','zip_code'=>'523770','first'=>'D','lng'=>'113.9271','lat'=>'22.965748']);
        $this->insert('{{%region}}',['id'=>'2107','pid'=>'2091','shortname'=>'麻涌','name'=>'麻涌镇','merger_name'=>'中国,广东省,东莞市,麻涌镇','level'=>'3','pinyin'=>'machong','code'=>'0769','zip_code'=>'523143','first'=>'M','lng'=>'113.546177','lat'=>'23.045315']);
        $this->insert('{{%region}}',['id'=>'2108','pid'=>'2091','shortname'=>'中堂','name'=>'中堂镇','merger_name'=>'中国,广东省,东莞市,中堂镇','level'=>'3','pinyin'=>'zhongtang','code'=>'0769','zip_code'=>'523233','first'=>'Z','lng'=>'113.654422','lat'=>'23.090164']);
        $this->insert('{{%region}}',['id'=>'2109','pid'=>'2091','shortname'=>'高埗','name'=>'高埗镇','merger_name'=>'中国,广东省,东莞市,高埗镇','level'=>'3','pinyin'=>'gaobu','code'=>'0769','zip_code'=>'523282','first'=>NULL,'lng'=>'113.735917','lat'=>'23.068415']);
        $this->insert('{{%region}}',['id'=>'2110','pid'=>'2091','shortname'=>'樟木头','name'=>'樟木头镇','merger_name'=>'中国,广东省,东莞市,樟木头镇','level'=>'3','pinyin'=>'zhangmutou','code'=>'0769','zip_code'=>'523619','first'=>'Z','lng'=>'114.066298','lat'=>'22.956682']);
        $this->insert('{{%region}}',['id'=>'2111','pid'=>'2091','shortname'=>'大岭山','name'=>'大岭山镇','merger_name'=>'中国,广东省,东莞市,大岭山镇','level'=>'3','pinyin'=>'dalingshan','code'=>'0769','zip_code'=>'523835','first'=>'D','lng'=>'113.782955','lat'=>'22.885366']);
        $this->insert('{{%region}}',['id'=>'2112','pid'=>'2091','shortname'=>'望牛墩','name'=>'望牛墩镇','merger_name'=>'中国,广东省,东莞市,望牛墩镇','level'=>'3','pinyin'=>'wangniudun','code'=>'0769','zip_code'=>'523203','first'=>'W','lng'=>'113.658847','lat'=>'23.055018']);
        $this->insert('{{%region}}',['id'=>'2113','pid'=>'2091','shortname'=>'黄江','name'=>'黄江镇','merger_name'=>'中国,广东省,东莞市,黄江镇','level'=>'3','pinyin'=>'huangjiang','code'=>'0769','zip_code'=>'523755','first'=>'H','lng'=>'113.992635','lat'=>'22.877536']);
        $this->insert('{{%region}}',['id'=>'2114','pid'=>'2091','shortname'=>'洪梅','name'=>'洪梅镇','merger_name'=>'中国,广东省,东莞市,洪梅镇','level'=>'3','pinyin'=>'hongmei','code'=>'0769','zip_code'=>'523163','first'=>'H','lng'=>'113.613081','lat'=>'22.992675']);
        $this->insert('{{%region}}',['id'=>'2115','pid'=>'2091','shortname'=>'清溪','name'=>'清溪镇','merger_name'=>'中国,广东省,东莞市,清溪镇','level'=>'3','pinyin'=>'qingxi','code'=>'0769','zip_code'=>'523660','first'=>'Q','lng'=>'114.155796','lat'=>'22.844456']);
        $this->insert('{{%region}}',['id'=>'2116','pid'=>'2091','shortname'=>'沙田','name'=>'沙田镇','merger_name'=>'中国,广东省,东莞市,沙田镇','level'=>'3','pinyin'=>'shatian','code'=>'0769','zip_code'=>'523988','first'=>'S','lng'=>'113.760234','lat'=>'23.048884']);
        $this->insert('{{%region}}',['id'=>'2117','pid'=>'2091','shortname'=>'道滘','name'=>'道滘镇','merger_name'=>'中国,广东省,东莞市,道滘镇','level'=>'3','pinyin'=>'daojiao','code'=>'0769','zip_code'=>'523171','first'=>NULL,'lng'=>'113.760234','lat'=>'23.048884']);
        $this->insert('{{%region}}',['id'=>'2118','pid'=>'2091','shortname'=>'塘厦','name'=>'塘厦镇','merger_name'=>'中国,广东省,东莞市,塘厦镇','level'=>'3','pinyin'=>'tangxia','code'=>'0769','zip_code'=>'523713','first'=>'T','lng'=>'114.10765','lat'=>'22.822862']);
        $this->insert('{{%region}}',['id'=>'2119','pid'=>'2091','shortname'=>'虎门','name'=>'虎门镇','merger_name'=>'中国,广东省,东莞市,虎门镇','level'=>'3','pinyin'=>'humen','code'=>'0769','zip_code'=>'523932','first'=>'H','lng'=>'113.71118','lat'=>'22.82615']);
        $this->insert('{{%region}}',['id'=>'2120','pid'=>'2091','shortname'=>'厚街','name'=>'厚街镇','merger_name'=>'中国,广东省,东莞市,厚街镇','level'=>'3','pinyin'=>'houjie','code'=>'0769','zip_code'=>'523960','first'=>'H','lng'=>'113.67301','lat'=>'22.940815']);
        $this->insert('{{%region}}',['id'=>'2121','pid'=>'2091','shortname'=>'凤岗','name'=>'凤岗镇','merger_name'=>'中国,广东省,东莞市,凤岗镇','level'=>'3','pinyin'=>'fenggang','code'=>'0769','zip_code'=>'523690','first'=>'F','lng'=>'114.141194','lat'=>'22.744598']);
        $this->insert('{{%region}}',['id'=>'2122','pid'=>'2091','shortname'=>'长安','name'=>'长安镇','merger_name'=>'中国,广东省,东莞市,长安镇','level'=>'3','pinyin'=>'chang\'an','code'=>'0769','zip_code'=>'523850','first'=>'C','lng'=>'113.803939','lat'=>'22.816644']);
        $this->insert('{{%region}}',['id'=>'2123','pid'=>'1964','shortname'=>'中山','name'=>'中山市','merger_name'=>'中国,广东省,中山市','level'=>'2','pinyin'=>'zhongshan','code'=>'0760','zip_code'=>'528403','first'=>'Z','lng'=>'113.382391','lat'=>'22.521113']);
        $this->insert('{{%region}}',['id'=>'2124','pid'=>'2123','shortname'=>'石岐','name'=>'石岐区','merger_name'=>'中国,广东省,中山市,石岐区','level'=>'3','pinyin'=>'shiqi','code'=>'0760','zip_code'=>'528400','first'=>'S','lng'=>'113.378835','lat'=>'22.52522']);
        $this->insert('{{%region}}',['id'=>'2125','pid'=>'2123','shortname'=>'南区','name'=>'南区','merger_name'=>'中国,广东省,中山市,南区','level'=>'3','pinyin'=>'nanqu','code'=>'0760','zip_code'=>'528400','first'=>'N','lng'=>'113.355896','lat'=>'22.486568']);
        $this->insert('{{%region}}',['id'=>'2126','pid'=>'2123','shortname'=>'五桂山','name'=>'五桂山区','merger_name'=>'中国,广东省,中山市,五桂山区','level'=>'3','pinyin'=>'wuguishan','code'=>'0760','zip_code'=>'528458','first'=>'W','lng'=>'113.41079','lat'=>'22.51968']);
        $this->insert('{{%region}}',['id'=>'2127','pid'=>'2123','shortname'=>'火炬','name'=>'火炬开发区','merger_name'=>'中国,广东省,中山市,火炬开发区','level'=>'3','pinyin'=>'huoju','code'=>'0760','zip_code'=>'528437','first'=>'H','lng'=>'113.480523','lat'=>'22.566082']);
        $this->insert('{{%region}}',['id'=>'2128','pid'=>'2123','shortname'=>'黄圃','name'=>'黄圃镇','merger_name'=>'中国,广东省,中山市,黄圃镇','level'=>'3','pinyin'=>'huangpu','code'=>'0760','zip_code'=>'528429','first'=>'H','lng'=>'113.342359','lat'=>'22.715116']);
        $this->insert('{{%region}}',['id'=>'2129','pid'=>'2123','shortname'=>'南头','name'=>'南头镇','merger_name'=>'中国,广东省,中山市,南头镇','level'=>'3','pinyin'=>'nantou','code'=>'0760','zip_code'=>'528421','first'=>'N','lng'=>'113.296358','lat'=>'22.713907']);
        $this->insert('{{%region}}',['id'=>'2130','pid'=>'2123','shortname'=>'东凤','name'=>'东凤镇','merger_name'=>'中国,广东省,中山市,东凤镇','level'=>'3','pinyin'=>'dongfeng','code'=>'0760','zip_code'=>'528425','first'=>'D','lng'=>'113.26114','lat'=>'22.68775']);
        $this->insert('{{%region}}',['id'=>'2131','pid'=>'2123','shortname'=>'阜沙','name'=>'阜沙镇','merger_name'=>'中国,广东省,中山市,阜沙镇','level'=>'3','pinyin'=>'fusha','code'=>'0760','zip_code'=>'528434','first'=>'F','lng'=>'113.353024','lat'=>'22.666364']);
        $this->insert('{{%region}}',['id'=>'2132','pid'=>'2123','shortname'=>'小榄','name'=>'小榄镇','merger_name'=>'中国,广东省,中山市,小榄镇','level'=>'3','pinyin'=>'xiaolan','code'=>'0760','zip_code'=>'528415','first'=>'X','lng'=>'113.244235','lat'=>'22.666951']);
        $this->insert('{{%region}}',['id'=>'2133','pid'=>'2123','shortname'=>'东升','name'=>'东升镇','merger_name'=>'中国,广东省,中山市,东升镇','level'=>'3','pinyin'=>'dongsheng','code'=>'0760','zip_code'=>'528400','first'=>'D','lng'=>'113.296298','lat'=>'22.614003']);
        $this->insert('{{%region}}',['id'=>'2134','pid'=>'2123','shortname'=>'古镇','name'=>'古镇镇','merger_name'=>'中国,广东省,中山市,古镇镇','level'=>'3','pinyin'=>'guzhen','code'=>'0760','zip_code'=>'528422','first'=>'G','lng'=>'113.179745','lat'=>'22.611019']);
        $this->insert('{{%region}}',['id'=>'2135','pid'=>'2123','shortname'=>'横栏','name'=>'横栏镇','merger_name'=>'中国,广东省,中山市,横栏镇','level'=>'3','pinyin'=>'henglan','code'=>'0760','zip_code'=>'528478','first'=>'H','lng'=>'113.265845','lat'=>'22.523202']);
        $this->insert('{{%region}}',['id'=>'2136','pid'=>'2123','shortname'=>'三角','name'=>'三角镇','merger_name'=>'中国,广东省,中山市,三角镇','level'=>'3','pinyin'=>'sanjiao','code'=>'0760','zip_code'=>'528422','first'=>'S','lng'=>'113.423624','lat'=>'22.677033']);
        $this->insert('{{%region}}',['id'=>'2137','pid'=>'2123','shortname'=>'民众','name'=>'民众镇','merger_name'=>'中国,广东省,中山市,民众镇','level'=>'3','pinyin'=>'minzhong','code'=>'0760','zip_code'=>'528441','first'=>'M','lng'=>'113.486025','lat'=>'22.623468']);
        $this->insert('{{%region}}',['id'=>'2138','pid'=>'2123','shortname'=>'南朗','name'=>'南朗镇','merger_name'=>'中国,广东省,中山市,南朗镇','level'=>'3','pinyin'=>'nanlang','code'=>'0760','zip_code'=>'528454','first'=>'N','lng'=>'113.533939','lat'=>'22.492378']);
        $this->insert('{{%region}}',['id'=>'2139','pid'=>'2123','shortname'=>'港口','name'=>'港口镇','merger_name'=>'中国,广东省,中山市,港口镇','level'=>'3','pinyin'=>'gangkou','code'=>'0760','zip_code'=>'528447','first'=>'G','lng'=>'113.382391','lat'=>'22.521113']);
        $this->insert('{{%region}}',['id'=>'2140','pid'=>'2123','shortname'=>'大涌','name'=>'大涌镇','merger_name'=>'中国,广东省,中山市,大涌镇','level'=>'3','pinyin'=>'dayong','code'=>'0760','zip_code'=>'528476','first'=>'D','lng'=>'113.291708','lat'=>'22.467712']);
        $this->insert('{{%region}}',['id'=>'2141','pid'=>'2123','shortname'=>'沙溪','name'=>'沙溪镇','merger_name'=>'中国,广东省,中山市,沙溪镇','level'=>'3','pinyin'=>'shaxi','code'=>'0760','zip_code'=>'528471','first'=>'S','lng'=>'113.328369','lat'=>'22.526325']);
        $this->insert('{{%region}}',['id'=>'2142','pid'=>'2123','shortname'=>'三乡','name'=>'三乡镇','merger_name'=>'中国,广东省,中山市,三乡镇','level'=>'3','pinyin'=>'sanxiang','code'=>'0760','zip_code'=>'528463','first'=>'S','lng'=>'113.4334','lat'=>'22.352494']);
        $this->insert('{{%region}}',['id'=>'2143','pid'=>'2123','shortname'=>'板芙','name'=>'板芙镇','merger_name'=>'中国,广东省,中山市,板芙镇','level'=>'3','pinyin'=>'banfu','code'=>'0760','zip_code'=>'528459','first'=>'B','lng'=>'113.320346','lat'=>'22.415674']);
        $this->insert('{{%region}}',['id'=>'2144','pid'=>'2123','shortname'=>'神湾','name'=>'神湾镇','merger_name'=>'中国,广东省,中山市,神湾镇','level'=>'3','pinyin'=>'shenwan','code'=>'0760','zip_code'=>'528462','first'=>'S','lng'=>'113.359387','lat'=>'22.312476']);
        $this->insert('{{%region}}',['id'=>'2145','pid'=>'2123','shortname'=>'坦洲','name'=>'坦洲镇','merger_name'=>'中国,广东省,中山市,坦洲镇','level'=>'3','pinyin'=>'tanzhou','code'=>'0760','zip_code'=>'528467','first'=>'T','lng'=>'113.485677','lat'=>'22.261269']);
        $this->insert('{{%region}}',['id'=>'2146','pid'=>'1964','shortname'=>'潮州','name'=>'潮州市','merger_name'=>'中国,广东省,潮州市','level'=>'2','pinyin'=>'chaozhou','code'=>'0768','zip_code'=>'521000','first'=>'C','lng'=>'116.632301','lat'=>'23.661701']);
        $this->insert('{{%region}}',['id'=>'2147','pid'=>'2146','shortname'=>'湘桥','name'=>'湘桥区','merger_name'=>'中国,广东省,潮州市,湘桥区','level'=>'3','pinyin'=>'xiangqiao','code'=>'0768','zip_code'=>'521000','first'=>'X','lng'=>'116.62805','lat'=>'23.67451']);
        $this->insert('{{%region}}',['id'=>'2148','pid'=>'2146','shortname'=>'潮安','name'=>'潮安区','merger_name'=>'中国,广东省,潮州市,潮安区','level'=>'3','pinyin'=>'chao\'an','code'=>'0768','zip_code'=>'515638','first'=>'C','lng'=>'116.592895','lat'=>'23.643656']);
        $this->insert('{{%region}}',['id'=>'2149','pid'=>'2146','shortname'=>'饶平','name'=>'饶平县','merger_name'=>'中国,广东省,潮州市,饶平县','level'=>'3','pinyin'=>'raoping','code'=>'0768','zip_code'=>'515700','first'=>'R','lng'=>'117.00692','lat'=>'23.66994']);
        $this->insert('{{%region}}',['id'=>'2150','pid'=>'1964','shortname'=>'揭阳','name'=>'揭阳市','merger_name'=>'中国,广东省,揭阳市','level'=>'2','pinyin'=>'jieyang','code'=>'0633','zip_code'=>'522000','first'=>'J','lng'=>'116.355733','lat'=>'23.543778']);
        $this->insert('{{%region}}',['id'=>'2151','pid'=>'2150','shortname'=>'榕城','name'=>'榕城区','merger_name'=>'中国,广东省,揭阳市,榕城区','level'=>'3','pinyin'=>'rongcheng','code'=>'0633','zip_code'=>'522000','first'=>NULL,'lng'=>'116.3671','lat'=>'23.52508']);
        $this->insert('{{%region}}',['id'=>'2152','pid'=>'2150','shortname'=>'揭东','name'=>'揭东区','merger_name'=>'中国,广东省,揭阳市,揭东区','level'=>'3','pinyin'=>'jiedong','code'=>'0633','zip_code'=>'515500','first'=>'J','lng'=>'116.412947','lat'=>'23.569887']);
        $this->insert('{{%region}}',['id'=>'2153','pid'=>'2150','shortname'=>'揭西','name'=>'揭西县','merger_name'=>'中国,广东省,揭阳市,揭西县','level'=>'3','pinyin'=>'jiexi','code'=>'0633','zip_code'=>'515400','first'=>'J','lng'=>'115.83883','lat'=>'23.42714']);
        $this->insert('{{%region}}',['id'=>'2154','pid'=>'2150','shortname'=>'惠来','name'=>'惠来县','merger_name'=>'中国,广东省,揭阳市,惠来县','level'=>'3','pinyin'=>'huilai','code'=>'0633','zip_code'=>'515200','first'=>'H','lng'=>'116.29599','lat'=>'23.03289']);
        $this->insert('{{%region}}',['id'=>'2155','pid'=>'2150','shortname'=>'普宁','name'=>'普宁市','merger_name'=>'中国,广东省,揭阳市,普宁市','level'=>'3','pinyin'=>'puning','code'=>'0633','zip_code'=>'515300','first'=>'P','lng'=>'116.16564','lat'=>'23.29732']);
        $this->insert('{{%region}}',['id'=>'2156','pid'=>'1964','shortname'=>'云浮','name'=>'云浮市','merger_name'=>'中国,广东省,云浮市','level'=>'2','pinyin'=>'yunfu','code'=>'0766','zip_code'=>'527300','first'=>'Y','lng'=>'112.044439','lat'=>'22.929801']);
        $this->insert('{{%region}}',['id'=>'2157','pid'=>'2156','shortname'=>'云城','name'=>'云城区','merger_name'=>'中国,广东省,云浮市,云城区','level'=>'3','pinyin'=>'yuncheng','code'=>'0766','zip_code'=>'527300','first'=>'Y','lng'=>'112.03908','lat'=>'22.92996']);
        $this->insert('{{%region}}',['id'=>'2158','pid'=>'2156','shortname'=>'云安','name'=>'云安区','merger_name'=>'中国,广东省,云浮市,云安区','level'=>'3','pinyin'=>'yun\'an','code'=>'0766','zip_code'=>'527500','first'=>'Y','lng'=>'112.00936','lat'=>'23.07779']);
        $this->insert('{{%region}}',['id'=>'2159','pid'=>'2156','shortname'=>'新兴','name'=>'新兴县','merger_name'=>'中国,广东省,云浮市,新兴县','level'=>'3','pinyin'=>'xinxing','code'=>'0766','zip_code'=>'527400','first'=>'X','lng'=>'112.23019','lat'=>'22.69734']);
        $this->insert('{{%region}}',['id'=>'2160','pid'=>'2156','shortname'=>'郁南','name'=>'郁南县','merger_name'=>'中国,广东省,云浮市,郁南县','level'=>'3','pinyin'=>'yunan','code'=>'0766','zip_code'=>'527100','first'=>'Y','lng'=>'111.53387','lat'=>'23.23307']);
        $this->insert('{{%region}}',['id'=>'2161','pid'=>'2156','shortname'=>'罗定','name'=>'罗定市','merger_name'=>'中国,广东省,云浮市,罗定市','level'=>'3','pinyin'=>'luoding','code'=>'0766','zip_code'=>'527200','first'=>'L','lng'=>'111.56979','lat'=>'22.76967']);
        $this->insert('{{%region}}',['id'=>'2162','pid'=>'0','shortname'=>'广西','name'=>'广西壮族自治区','merger_name'=>'中国,广西壮族自治区','level'=>'1','pinyin'=>'guangxi','code'=>'','zip_code'=>'','first'=>'G','lng'=>'108.320004','lat'=>'22.82402']);
        $this->insert('{{%region}}',['id'=>'2163','pid'=>'2162','shortname'=>'南宁','name'=>'南宁市','merger_name'=>'中国,广西壮族自治区,南宁市','level'=>'2','pinyin'=>'nanning','code'=>'0771','zip_code'=>'530028','first'=>'N','lng'=>'108.320004','lat'=>'22.82402']);
        $this->insert('{{%region}}',['id'=>'2164','pid'=>'2163','shortname'=>'兴宁','name'=>'兴宁区','merger_name'=>'中国,广西壮族自治区,南宁市,兴宁区','level'=>'3','pinyin'=>'xingning','code'=>'0771','zip_code'=>'530023','first'=>'X','lng'=>'108.36694','lat'=>'22.85355']);
        $this->insert('{{%region}}',['id'=>'2165','pid'=>'2163','shortname'=>'青秀','name'=>'青秀区','merger_name'=>'中国,广西壮族自治区,南宁市,青秀区','level'=>'3','pinyin'=>'qingxiu','code'=>'0771','zip_code'=>'530213','first'=>'Q','lng'=>'108.49545','lat'=>'22.78511']);
        $this->insert('{{%region}}',['id'=>'2166','pid'=>'2163','shortname'=>'江南','name'=>'江南区','merger_name'=>'中国,广西壮族自治区,南宁市,江南区','level'=>'3','pinyin'=>'jiangnan','code'=>'0771','zip_code'=>'530031','first'=>'J','lng'=>'108.27325','lat'=>'22.78127']);
        $this->insert('{{%region}}',['id'=>'2167','pid'=>'2163','shortname'=>'西乡塘','name'=>'西乡塘区','merger_name'=>'中国,广西壮族自治区,南宁市,西乡塘区','level'=>'3','pinyin'=>'xixiangtang','code'=>'0771','zip_code'=>'530001','first'=>'X','lng'=>'108.31347','lat'=>'22.83386']);
        $this->insert('{{%region}}',['id'=>'2168','pid'=>'2163','shortname'=>'良庆','name'=>'良庆区','merger_name'=>'中国,广西壮族自治区,南宁市,良庆区','level'=>'3','pinyin'=>'liangqing','code'=>'0771','zip_code'=>'530219','first'=>'L','lng'=>'108.41284','lat'=>'22.74914']);
        $this->insert('{{%region}}',['id'=>'2169','pid'=>'2163','shortname'=>'邕宁','name'=>'邕宁区','merger_name'=>'中国,广西壮族自治区,南宁市,邕宁区','level'=>'3','pinyin'=>'yongning','code'=>'0771','zip_code'=>'530200','first'=>NULL,'lng'=>'108.48684','lat'=>'22.75628']);
        $this->insert('{{%region}}',['id'=>'2170','pid'=>'2163','shortname'=>'武鸣','name'=>'武鸣县','merger_name'=>'中国,广西壮族自治区,南宁市,武鸣县','level'=>'3','pinyin'=>'wuming','code'=>'0771','zip_code'=>'530100','first'=>'W','lng'=>'108.27719','lat'=>'23.15643']);
        $this->insert('{{%region}}',['id'=>'2171','pid'=>'2163','shortname'=>'隆安','name'=>'隆安县','merger_name'=>'中国,广西壮族自治区,南宁市,隆安县','level'=>'3','pinyin'=>'long\'an','code'=>'0771','zip_code'=>'532700','first'=>'L','lng'=>'107.69192','lat'=>'23.17336']);
        $this->insert('{{%region}}',['id'=>'2172','pid'=>'2163','shortname'=>'马山','name'=>'马山县','merger_name'=>'中国,广西壮族自治区,南宁市,马山县','level'=>'3','pinyin'=>'mashan','code'=>'0771','zip_code'=>'530600','first'=>'M','lng'=>'108.17697','lat'=>'23.70931']);
        $this->insert('{{%region}}',['id'=>'2173','pid'=>'2163','shortname'=>'上林','name'=>'上林县','merger_name'=>'中国,广西壮族自治区,南宁市,上林县','level'=>'3','pinyin'=>'shanglin','code'=>'0771','zip_code'=>'530500','first'=>'S','lng'=>'108.60522','lat'=>'23.432']);
        $this->insert('{{%region}}',['id'=>'2174','pid'=>'2163','shortname'=>'宾阳','name'=>'宾阳县','merger_name'=>'中国,广西壮族自治区,南宁市,宾阳县','level'=>'3','pinyin'=>'binyang','code'=>'0771','zip_code'=>'530400','first'=>'B','lng'=>'108.81185','lat'=>'23.2196']);
        $this->insert('{{%region}}',['id'=>'2175','pid'=>'2163','shortname'=>'横县','name'=>'横县','merger_name'=>'中国,广西壮族自治区,南宁市,横县','level'=>'3','pinyin'=>'hengxian','code'=>'0771','zip_code'=>'530300','first'=>'H','lng'=>'109.26608','lat'=>'22.68448']);
        $this->insert('{{%region}}',['id'=>'2176','pid'=>'2163','shortname'=>'埌东','name'=>'埌东新区','merger_name'=>'中国,广西壮族自治区,南宁市,埌东新区','level'=>'3','pinyin'=>'langdong','code'=>'0771','zip_code'=>'530000','first'=>NULL,'lng'=>'108.419094','lat'=>'22.812976']);
        $this->insert('{{%region}}',['id'=>'2177','pid'=>'2162','shortname'=>'柳州','name'=>'柳州市','merger_name'=>'中国,广西壮族自治区,柳州市','level'=>'2','pinyin'=>'liuzhou','code'=>'0772','zip_code'=>'545001','first'=>'L','lng'=>'109.411703','lat'=>'24.314617']);
        $this->insert('{{%region}}',['id'=>'2178','pid'=>'2177','shortname'=>'城中','name'=>'城中区','merger_name'=>'中国,广西壮族自治区,柳州市,城中区','level'=>'3','pinyin'=>'chengzhong','code'=>'0772','zip_code'=>'545001','first'=>'C','lng'=>'109.41082','lat'=>'24.31543']);
        $this->insert('{{%region}}',['id'=>'2179','pid'=>'2177','shortname'=>'鱼峰','name'=>'鱼峰区','merger_name'=>'中国,广西壮族自治区,柳州市,鱼峰区','level'=>'3','pinyin'=>'yufeng','code'=>'0772','zip_code'=>'545005','first'=>'Y','lng'=>'109.4533','lat'=>'24.31868']);
        $this->insert('{{%region}}',['id'=>'2180','pid'=>'2177','shortname'=>'柳南','name'=>'柳南区','merger_name'=>'中国,广西壮族自治区,柳州市,柳南区','level'=>'3','pinyin'=>'liunan','code'=>'0772','zip_code'=>'545007','first'=>'L','lng'=>'109.38548','lat'=>'24.33599']);
        $this->insert('{{%region}}',['id'=>'2181','pid'=>'2177','shortname'=>'柳北','name'=>'柳北区','merger_name'=>'中国,广西壮族自治区,柳州市,柳北区','level'=>'3','pinyin'=>'liubei','code'=>'0772','zip_code'=>'545002','first'=>'L','lng'=>'109.40202','lat'=>'24.36267']);
        $this->insert('{{%region}}',['id'=>'2182','pid'=>'2177','shortname'=>'柳江','name'=>'柳江县','merger_name'=>'中国,广西壮族自治区,柳州市,柳江县','level'=>'3','pinyin'=>'liujiang','code'=>'0772','zip_code'=>'545100','first'=>'L','lng'=>'109.33273','lat'=>'24.25596']);
        $this->insert('{{%region}}',['id'=>'2183','pid'=>'2177','shortname'=>'柳城','name'=>'柳城县','merger_name'=>'中国,广西壮族自治区,柳州市,柳城县','level'=>'3','pinyin'=>'liucheng','code'=>'0772','zip_code'=>'545200','first'=>'L','lng'=>'109.23877','lat'=>'24.64951']);
        $this->insert('{{%region}}',['id'=>'2184','pid'=>'2177','shortname'=>'鹿寨','name'=>'鹿寨县','merger_name'=>'中国,广西壮族自治区,柳州市,鹿寨县','level'=>'3','pinyin'=>'luzhai','code'=>'0772','zip_code'=>'545600','first'=>'L','lng'=>'109.75177','lat'=>'24.47306']);
        $this->insert('{{%region}}',['id'=>'2185','pid'=>'2177','shortname'=>'融安','name'=>'融安县','merger_name'=>'中国,广西壮族自治区,柳州市,融安县','level'=>'3','pinyin'=>'rong\'an','code'=>'0772','zip_code'=>'545400','first'=>'R','lng'=>'109.39761','lat'=>'25.22465']);
        $this->insert('{{%region}}',['id'=>'2186','pid'=>'2177','shortname'=>'融水','name'=>'融水苗族自治县','merger_name'=>'中国,广西壮族自治区,柳州市,融水苗族自治县','level'=>'3','pinyin'=>'rongshui','code'=>'0772','zip_code'=>'545300','first'=>'R','lng'=>'109.25634','lat'=>'25.06628']);
        $this->insert('{{%region}}',['id'=>'2187','pid'=>'2177','shortname'=>'三江','name'=>'三江侗族自治县','merger_name'=>'中国,广西壮族自治区,柳州市,三江侗族自治县','level'=>'3','pinyin'=>'sanjiang','code'=>'0772','zip_code'=>'545500','first'=>'S','lng'=>'109.60446','lat'=>'25.78428']);
        $this->insert('{{%region}}',['id'=>'2188','pid'=>'2177','shortname'=>'柳东','name'=>'柳东新区','merger_name'=>'中国,广西壮族自治区,柳州市,柳东新区','level'=>'3','pinyin'=>'liudong','code'=>'0772','zip_code'=>'545000','first'=>'L','lng'=>'109.437053','lat'=>'24.329204']);
        $this->insert('{{%region}}',['id'=>'2189','pid'=>'2162','shortname'=>'桂林','name'=>'桂林市','merger_name'=>'中国,广西壮族自治区,桂林市','level'=>'2','pinyin'=>'guilin','code'=>'0773','zip_code'=>'541100','first'=>'G','lng'=>'110.299121','lat'=>'25.274215']);
        $this->insert('{{%region}}',['id'=>'2190','pid'=>'2189','shortname'=>'秀峰','name'=>'秀峰区','merger_name'=>'中国,广西壮族自治区,桂林市,秀峰区','level'=>'3','pinyin'=>'xiufeng','code'=>'0773','zip_code'=>'541001','first'=>'X','lng'=>'110.28915','lat'=>'25.28249']);
        $this->insert('{{%region}}',['id'=>'2191','pid'=>'2189','shortname'=>'叠彩','name'=>'叠彩区','merger_name'=>'中国,广西壮族自治区,桂林市,叠彩区','level'=>'3','pinyin'=>'diecai','code'=>'0773','zip_code'=>'541001','first'=>'D','lng'=>'110.30195','lat'=>'25.31381']);
        $this->insert('{{%region}}',['id'=>'2192','pid'=>'2189','shortname'=>'象山','name'=>'象山区','merger_name'=>'中国,广西壮族自治区,桂林市,象山区','level'=>'3','pinyin'=>'xiangshan','code'=>'0773','zip_code'=>'541002','first'=>'X','lng'=>'110.28108','lat'=>'25.26168']);
        $this->insert('{{%region}}',['id'=>'2193','pid'=>'2189','shortname'=>'七星','name'=>'七星区','merger_name'=>'中国,广西壮族自治区,桂林市,七星区','level'=>'3','pinyin'=>'qixing','code'=>'0773','zip_code'=>'541004','first'=>'Q','lng'=>'110.31793','lat'=>'25.2525']);
        $this->insert('{{%region}}',['id'=>'2194','pid'=>'2189','shortname'=>'雁山','name'=>'雁山区','merger_name'=>'中国,广西壮族自治区,桂林市,雁山区','level'=>'3','pinyin'=>'yanshan','code'=>'0773','zip_code'=>'541006','first'=>'Y','lng'=>'110.30911','lat'=>'25.06038']);
        $this->insert('{{%region}}',['id'=>'2195','pid'=>'2189','shortname'=>'临桂','name'=>'临桂区','merger_name'=>'中国,广西壮族自治区,桂林市,临桂区','level'=>'3','pinyin'=>'lingui','code'=>'0773','zip_code'=>'541100','first'=>'L','lng'=>'110.205487','lat'=>'25.246257']);
        $this->insert('{{%region}}',['id'=>'2196','pid'=>'2189','shortname'=>'阳朔','name'=>'阳朔县','merger_name'=>'中国,广西壮族自治区,桂林市,阳朔县','level'=>'3','pinyin'=>'yangshuo','code'=>'0773','zip_code'=>'541900','first'=>'Y','lng'=>'110.49475','lat'=>'24.77579']);
        $this->insert('{{%region}}',['id'=>'2197','pid'=>'2189','shortname'=>'灵川','name'=>'灵川县','merger_name'=>'中国,广西壮族自治区,桂林市,灵川县','level'=>'3','pinyin'=>'lingchuan','code'=>'0773','zip_code'=>'541200','first'=>'L','lng'=>'110.32949','lat'=>'25.41292']);
        $this->insert('{{%region}}',['id'=>'2198','pid'=>'2189','shortname'=>'全州','name'=>'全州县','merger_name'=>'中国,广西壮族自治区,桂林市,全州县','level'=>'3','pinyin'=>'quanzhou','code'=>'0773','zip_code'=>'541503','first'=>'Q','lng'=>'111.07211','lat'=>'25.92799']);
        $this->insert('{{%region}}',['id'=>'2199','pid'=>'2189','shortname'=>'兴安','name'=>'兴安县','merger_name'=>'中国,广西壮族自治区,桂林市,兴安县','level'=>'3','pinyin'=>'xing\'an','code'=>'0773','zip_code'=>'541300','first'=>'X','lng'=>'110.67144','lat'=>'25.61167']);
        $this->insert('{{%region}}',['id'=>'2200','pid'=>'2189','shortname'=>'永福','name'=>'永福县','merger_name'=>'中国,广西壮族自治区,桂林市,永福县','level'=>'3','pinyin'=>'yongfu','code'=>'0773','zip_code'=>'541800','first'=>'Y','lng'=>'109.98333','lat'=>'24.98004']);
        $this->insert('{{%region}}',['id'=>'2201','pid'=>'2189','shortname'=>'灌阳','name'=>'灌阳县','merger_name'=>'中国,广西壮族自治区,桂林市,灌阳县','level'=>'3','pinyin'=>'guanyang','code'=>'0773','zip_code'=>'541600','first'=>'G','lng'=>'111.15954','lat'=>'25.48803']);
        $this->insert('{{%region}}',['id'=>'2202','pid'=>'2189','shortname'=>'龙胜','name'=>'龙胜各族自治县','merger_name'=>'中国,广西壮族自治区,桂林市,龙胜各族自治县','level'=>'3','pinyin'=>'longsheng','code'=>'0773','zip_code'=>'541700','first'=>'L','lng'=>'110.01226','lat'=>'25.79614']);
        $this->insert('{{%region}}',['id'=>'2203','pid'=>'2189','shortname'=>'资源','name'=>'资源县','merger_name'=>'中国,广西壮族自治区,桂林市,资源县','level'=>'3','pinyin'=>'ziyuan','code'=>'0773','zip_code'=>'541400','first'=>'Z','lng'=>'110.65255','lat'=>'26.04237']);
        $this->insert('{{%region}}',['id'=>'2204','pid'=>'2189','shortname'=>'平乐','name'=>'平乐县','merger_name'=>'中国,广西壮族自治区,桂林市,平乐县','level'=>'3','pinyin'=>'pingle','code'=>'0773','zip_code'=>'542400','first'=>'P','lng'=>'110.64175','lat'=>'24.63242']);
        $this->insert('{{%region}}',['id'=>'2205','pid'=>'2189','shortname'=>'荔浦','name'=>'荔浦县','merger_name'=>'中国,广西壮族自治区,桂林市,荔浦县','level'=>'3','pinyin'=>'lipu','code'=>'0773','zip_code'=>'546600','first'=>'L','lng'=>'110.3971','lat'=>'24.49589']);
        $this->insert('{{%region}}',['id'=>'2206','pid'=>'2189','shortname'=>'恭城','name'=>'恭城瑶族自治县','merger_name'=>'中国,广西壮族自治区,桂林市,恭城瑶族自治县','level'=>'3','pinyin'=>'gongcheng','code'=>'0773','zip_code'=>'542500','first'=>'G','lng'=>'110.83035','lat'=>'24.83286']);
        $this->insert('{{%region}}',['id'=>'2207','pid'=>'2162','shortname'=>'梧州','name'=>'梧州市','merger_name'=>'中国,广西壮族自治区,梧州市','level'=>'2','pinyin'=>'wuzhou','code'=>'0774','zip_code'=>'543002','first'=>'W','lng'=>'111.316229','lat'=>'23.472309']);
        $this->insert('{{%region}}',['id'=>'2208','pid'=>'2207','shortname'=>'万秀','name'=>'万秀区','merger_name'=>'中国,广西壮族自治区,梧州市,万秀区','level'=>'3','pinyin'=>'wanxiu','code'=>'0774','zip_code'=>'543000','first'=>'W','lng'=>'111.32052','lat'=>'23.47298']);
        $this->insert('{{%region}}',['id'=>'2209','pid'=>'2207','shortname'=>'长洲','name'=>'长洲区','merger_name'=>'中国,广西壮族自治区,梧州市,长洲区','level'=>'3','pinyin'=>'changzhou','code'=>'0774','zip_code'=>'543003','first'=>'C','lng'=>'111.27494','lat'=>'23.48573']);
        $this->insert('{{%region}}',['id'=>'2210','pid'=>'2207','shortname'=>'龙圩','name'=>'龙圩区','merger_name'=>'中国,广西壮族自治区,梧州市,龙圩区','level'=>'3','pinyin'=>'longxu','code'=>'0774','zip_code'=>'543002','first'=>'L','lng'=>'111.316229','lat'=>'23.472309']);
        $this->insert('{{%region}}',['id'=>'2211','pid'=>'2207','shortname'=>'苍梧','name'=>'苍梧县','merger_name'=>'中国,广西壮族自治区,梧州市,苍梧县','level'=>'3','pinyin'=>'cangwu','code'=>'0774','zip_code'=>'543100','first'=>'C','lng'=>'111.24533','lat'=>'23.42049']);
        $this->insert('{{%region}}',['id'=>'2212','pid'=>'2207','shortname'=>'藤县','name'=>'藤县','merger_name'=>'中国,广西壮族自治区,梧州市,藤县','level'=>'3','pinyin'=>'tengxian','code'=>'0774','zip_code'=>'543300','first'=>'T','lng'=>'110.91418','lat'=>'23.37605']);
        $this->insert('{{%region}}',['id'=>'2213','pid'=>'2207','shortname'=>'蒙山','name'=>'蒙山县','merger_name'=>'中国,广西壮族自治区,梧州市,蒙山县','level'=>'3','pinyin'=>'mengshan','code'=>'0774','zip_code'=>'546700','first'=>'M','lng'=>'110.52221','lat'=>'24.20168']);
        $this->insert('{{%region}}',['id'=>'2214','pid'=>'2207','shortname'=>'岑溪','name'=>'岑溪市','merger_name'=>'中国,广西壮族自治区,梧州市,岑溪市','level'=>'3','pinyin'=>'cenxi','code'=>'0774','zip_code'=>'543200','first'=>NULL,'lng'=>'110.99594','lat'=>'22.9191']);
        $this->insert('{{%region}}',['id'=>'2215','pid'=>'2162','shortname'=>'北海','name'=>'北海市','merger_name'=>'中国,广西壮族自治区,北海市','level'=>'2','pinyin'=>'beihai','code'=>'0779','zip_code'=>'536000','first'=>'B','lng'=>'109.119254','lat'=>'21.473343']);
        $this->insert('{{%region}}',['id'=>'2216','pid'=>'2215','shortname'=>'海城','name'=>'海城区','merger_name'=>'中国,广西壮族自治区,北海市,海城区','level'=>'3','pinyin'=>'haicheng','code'=>'0779','zip_code'=>'536000','first'=>'H','lng'=>'109.11744','lat'=>'21.47501']);
        $this->insert('{{%region}}',['id'=>'2217','pid'=>'2215','shortname'=>'银海','name'=>'银海区','merger_name'=>'中国,广西壮族自治区,北海市,银海区','level'=>'3','pinyin'=>'yinhai','code'=>'0779','zip_code'=>'536000','first'=>'Y','lng'=>'109.13029','lat'=>'21.4783']);
        $this->insert('{{%region}}',['id'=>'2218','pid'=>'2215','shortname'=>'铁山港','name'=>'铁山港区','merger_name'=>'中国,广西壮族自治区,北海市,铁山港区','level'=>'3','pinyin'=>'tieshangang','code'=>'0779','zip_code'=>'536017','first'=>'T','lng'=>'109.45578','lat'=>'21.59661']);
        $this->insert('{{%region}}',['id'=>'2219','pid'=>'2215','shortname'=>'合浦','name'=>'合浦县','merger_name'=>'中国,广西壮族自治区,北海市,合浦县','level'=>'3','pinyin'=>'hepu','code'=>'0779','zip_code'=>'536100','first'=>'H','lng'=>'109.20068','lat'=>'21.66601']);
        $this->insert('{{%region}}',['id'=>'2220','pid'=>'2162','shortname'=>'防城港','name'=>'防城港市','merger_name'=>'中国,广西壮族自治区,防城港市','level'=>'2','pinyin'=>'fangchenggang','code'=>'0770','zip_code'=>'538001','first'=>'F','lng'=>'108.345478','lat'=>'21.614631']);
        $this->insert('{{%region}}',['id'=>'2221','pid'=>'2220','shortname'=>'港口','name'=>'港口区','merger_name'=>'中国,广西壮族自治区,防城港市,港口区','level'=>'3','pinyin'=>'gangkou','code'=>'0770','zip_code'=>'538001','first'=>'G','lng'=>'108.38022','lat'=>'21.64342']);
        $this->insert('{{%region}}',['id'=>'2222','pid'=>'2220','shortname'=>'防城','name'=>'防城区','merger_name'=>'中国,广西壮族自治区,防城港市,防城区','level'=>'3','pinyin'=>'fangcheng','code'=>'0770','zip_code'=>'538021','first'=>'F','lng'=>'108.35726','lat'=>'21.76464']);
        $this->insert('{{%region}}',['id'=>'2223','pid'=>'2220','shortname'=>'上思','name'=>'上思县','merger_name'=>'中国,广西壮族自治区,防城港市,上思县','level'=>'3','pinyin'=>'shangsi','code'=>'0770','zip_code'=>'535500','first'=>'S','lng'=>'107.9823','lat'=>'22.14957']);
        $this->insert('{{%region}}',['id'=>'2224','pid'=>'2220','shortname'=>'东兴','name'=>'东兴市','merger_name'=>'中国,广西壮族自治区,防城港市,东兴市','level'=>'3','pinyin'=>'dongxing','code'=>'0770','zip_code'=>'538100','first'=>'D','lng'=>'107.97204','lat'=>'21.54713']);
        $this->insert('{{%region}}',['id'=>'2225','pid'=>'2162','shortname'=>'钦州','name'=>'钦州市','merger_name'=>'中国,广西壮族自治区,钦州市','level'=>'2','pinyin'=>'qinzhou','code'=>'0777','zip_code'=>'535099','first'=>'Q','lng'=>'108.624175','lat'=>'21.967127']);
        $this->insert('{{%region}}',['id'=>'2226','pid'=>'2225','shortname'=>'钦南','name'=>'钦南区','merger_name'=>'中国,广西壮族自治区,钦州市,钦南区','level'=>'3','pinyin'=>'qinnan','code'=>'0777','zip_code'=>'535099','first'=>'Q','lng'=>'108.61775','lat'=>'21.95137']);
        $this->insert('{{%region}}',['id'=>'2227','pid'=>'2225','shortname'=>'钦北','name'=>'钦北区','merger_name'=>'中国,广西壮族自治区,钦州市,钦北区','level'=>'3','pinyin'=>'qinbei','code'=>'0777','zip_code'=>'535099','first'=>'Q','lng'=>'108.63037','lat'=>'21.95127']);
        $this->insert('{{%region}}',['id'=>'2228','pid'=>'2225','shortname'=>'灵山','name'=>'灵山县','merger_name'=>'中国,广西壮族自治区,钦州市,灵山县','level'=>'3','pinyin'=>'lingshan','code'=>'0777','zip_code'=>'535099','first'=>'L','lng'=>'109.29153','lat'=>'22.4165']);
        $this->insert('{{%region}}',['id'=>'2229','pid'=>'2225','shortname'=>'浦北','name'=>'浦北县','merger_name'=>'中国,广西壮族自治区,钦州市,浦北县','level'=>'3','pinyin'=>'pubei','code'=>'0777','zip_code'=>'535099','first'=>'P','lng'=>'109.55572','lat'=>'22.26888']);
        $this->insert('{{%region}}',['id'=>'2230','pid'=>'2162','shortname'=>'贵港','name'=>'贵港市','merger_name'=>'中国,广西壮族自治区,贵港市','level'=>'2','pinyin'=>'guigang','code'=>'0775','zip_code'=>'537100','first'=>'G','lng'=>'109.602146','lat'=>'23.0936']);
        $this->insert('{{%region}}',['id'=>'2231','pid'=>'2230','shortname'=>'港北','name'=>'港北区','merger_name'=>'中国,广西壮族自治区,贵港市,港北区','level'=>'3','pinyin'=>'gangbei','code'=>'0775','zip_code'=>'537100','first'=>'G','lng'=>'109.57224','lat'=>'23.11153']);
        $this->insert('{{%region}}',['id'=>'2232','pid'=>'2230','shortname'=>'港南','name'=>'港南区','merger_name'=>'中国,广西壮族自治区,贵港市,港南区','level'=>'3','pinyin'=>'gangnan','code'=>'0775','zip_code'=>'537100','first'=>'G','lng'=>'109.60617','lat'=>'23.07226']);
        $this->insert('{{%region}}',['id'=>'2233','pid'=>'2230','shortname'=>'覃塘','name'=>'覃塘区','merger_name'=>'中国,广西壮族自治区,贵港市,覃塘区','level'=>'3','pinyin'=>'qintang','code'=>'0775','zip_code'=>'537121','first'=>NULL,'lng'=>'109.44293','lat'=>'23.12677']);
        $this->insert('{{%region}}',['id'=>'2234','pid'=>'2230','shortname'=>'平南','name'=>'平南县','merger_name'=>'中国,广西壮族自治区,贵港市,平南县','level'=>'3','pinyin'=>'pingnan','code'=>'0775','zip_code'=>'537300','first'=>'P','lng'=>'110.39062','lat'=>'23.54201']);
        $this->insert('{{%region}}',['id'=>'2235','pid'=>'2230','shortname'=>'桂平','name'=>'桂平市','merger_name'=>'中国,广西壮族自治区,贵港市,桂平市','level'=>'3','pinyin'=>'guiping','code'=>'0775','zip_code'=>'537200','first'=>'G','lng'=>'110.08105','lat'=>'23.39339']);
        $this->insert('{{%region}}',['id'=>'2236','pid'=>'2162','shortname'=>'玉林','name'=>'玉林市','merger_name'=>'中国,广西壮族自治区,玉林市','level'=>'2','pinyin'=>'yulin','code'=>'0775','zip_code'=>'537000','first'=>'Y','lng'=>'110.154393','lat'=>'22.63136']);
        $this->insert('{{%region}}',['id'=>'2237','pid'=>'2236','shortname'=>'玉州','name'=>'玉州区','merger_name'=>'中国,广西壮族自治区,玉林市,玉州区','level'=>'3','pinyin'=>'yuzhou','code'=>'0775','zip_code'=>'537000','first'=>'Y','lng'=>'110.15114','lat'=>'22.6281']);
        $this->insert('{{%region}}',['id'=>'2238','pid'=>'2236','shortname'=>'福绵','name'=>'福绵区','merger_name'=>'中国,广西壮族自治区,玉林市,福绵区','level'=>'3','pinyin'=>'fumian','code'=>'0775','zip_code'=>'537023','first'=>'F','lng'=>'110.064816','lat'=>'22.583057']);
        $this->insert('{{%region}}',['id'=>'2239','pid'=>'2236','shortname'=>'玉东','name'=>'玉东新区','merger_name'=>'中国,广西壮族自治区,玉林市,玉东新区','level'=>'3','pinyin'=>'yudong','code'=>'0775','zip_code'=>'537000','first'=>'Y','lng'=>'110.154393','lat'=>'22.63136']);
        $this->insert('{{%region}}',['id'=>'2240','pid'=>'2236','shortname'=>'容县','name'=>'容县','merger_name'=>'中国,广西壮族自治区,玉林市,容县','level'=>'3','pinyin'=>'rongxian','code'=>'0775','zip_code'=>'537500','first'=>'R','lng'=>'110.55593','lat'=>'22.85701']);
        $this->insert('{{%region}}',['id'=>'2241','pid'=>'2236','shortname'=>'陆川','name'=>'陆川县','merger_name'=>'中国,广西壮族自治区,玉林市,陆川县','level'=>'3','pinyin'=>'luchuan','code'=>'0775','zip_code'=>'537700','first'=>'L','lng'=>'110.26413','lat'=>'22.32454']);
        $this->insert('{{%region}}',['id'=>'2242','pid'=>'2236','shortname'=>'博白','name'=>'博白县','merger_name'=>'中国,广西壮族自治区,玉林市,博白县','level'=>'3','pinyin'=>'bobai','code'=>'0775','zip_code'=>'537600','first'=>'B','lng'=>'109.97744','lat'=>'22.27286']);
        $this->insert('{{%region}}',['id'=>'2243','pid'=>'2236','shortname'=>'兴业','name'=>'兴业县','merger_name'=>'中国,广西壮族自治区,玉林市,兴业县','level'=>'3','pinyin'=>'xingye','code'=>'0775','zip_code'=>'537800','first'=>'X','lng'=>'109.87612','lat'=>'22.74237']);
        $this->insert('{{%region}}',['id'=>'2244','pid'=>'2236','shortname'=>'北流','name'=>'北流市','merger_name'=>'中国,广西壮族自治区,玉林市,北流市','level'=>'3','pinyin'=>'beiliu','code'=>'0775','zip_code'=>'537400','first'=>'B','lng'=>'110.35302','lat'=>'22.70817']);
        $this->insert('{{%region}}',['id'=>'2245','pid'=>'2162','shortname'=>'百色','name'=>'百色市','merger_name'=>'中国,广西壮族自治区,百色市','level'=>'2','pinyin'=>'baise','code'=>'0776','zip_code'=>'533000','first'=>'B','lng'=>'106.616285','lat'=>'23.897742']);
        $this->insert('{{%region}}',['id'=>'2246','pid'=>'2245','shortname'=>'右江','name'=>'右江区','merger_name'=>'中国,广西壮族自治区,百色市,右江区','level'=>'3','pinyin'=>'youjiang','code'=>'0776','zip_code'=>'533000','first'=>'Y','lng'=>'106.61764','lat'=>'23.9009']);
        $this->insert('{{%region}}',['id'=>'2247','pid'=>'2245','shortname'=>'田阳','name'=>'田阳县','merger_name'=>'中国,广西壮族自治区,百色市,田阳县','level'=>'3','pinyin'=>'tianyang','code'=>'0776','zip_code'=>'533600','first'=>'T','lng'=>'106.91558','lat'=>'23.73535']);
        $this->insert('{{%region}}',['id'=>'2248','pid'=>'2245','shortname'=>'田东','name'=>'田东县','merger_name'=>'中国,广西壮族自治区,百色市,田东县','level'=>'3','pinyin'=>'tiandong','code'=>'0776','zip_code'=>'531500','first'=>'T','lng'=>'107.12432','lat'=>'23.60003']);
        $this->insert('{{%region}}',['id'=>'2249','pid'=>'2245','shortname'=>'平果','name'=>'平果县','merger_name'=>'中国,广西壮族自治区,百色市,平果县','level'=>'3','pinyin'=>'pingguo','code'=>'0776','zip_code'=>'531400','first'=>'P','lng'=>'107.59045','lat'=>'23.32969']);
        $this->insert('{{%region}}',['id'=>'2250','pid'=>'2245','shortname'=>'德保','name'=>'德保县','merger_name'=>'中国,广西壮族自治区,百色市,德保县','level'=>'3','pinyin'=>'debao','code'=>'0776','zip_code'=>'533700','first'=>'D','lng'=>'106.61917','lat'=>'23.32515']);
        $this->insert('{{%region}}',['id'=>'2251','pid'=>'2245','shortname'=>'靖西','name'=>'靖西县','merger_name'=>'中国,广西壮族自治区,百色市,靖西县','level'=>'3','pinyin'=>'jingxi','code'=>'0776','zip_code'=>'533800','first'=>'J','lng'=>'106.41766','lat'=>'23.13425']);
        $this->insert('{{%region}}',['id'=>'2252','pid'=>'2245','shortname'=>'那坡','name'=>'那坡县','merger_name'=>'中国,广西壮族自治区,百色市,那坡县','level'=>'3','pinyin'=>'napo','code'=>'0776','zip_code'=>'533900','first'=>'N','lng'=>'105.84191','lat'=>'23.40649']);
        $this->insert('{{%region}}',['id'=>'2253','pid'=>'2245','shortname'=>'凌云','name'=>'凌云县','merger_name'=>'中国,广西壮族自治区,百色市,凌云县','level'=>'3','pinyin'=>'lingyun','code'=>'0776','zip_code'=>'533100','first'=>'L','lng'=>'106.56155','lat'=>'24.34747']);
        $this->insert('{{%region}}',['id'=>'2254','pid'=>'2245','shortname'=>'乐业','name'=>'乐业县','merger_name'=>'中国,广西壮族自治区,百色市,乐业县','level'=>'3','pinyin'=>'leye','code'=>'0776','zip_code'=>'533200','first'=>'L','lng'=>'106.56124','lat'=>'24.78295']);
        $this->insert('{{%region}}',['id'=>'2255','pid'=>'2245','shortname'=>'田林','name'=>'田林县','merger_name'=>'中国,广西壮族自治区,百色市,田林县','level'=>'3','pinyin'=>'tianlin','code'=>'0776','zip_code'=>'533300','first'=>'T','lng'=>'106.22882','lat'=>'24.29207']);
        $this->insert('{{%region}}',['id'=>'2256','pid'=>'2245','shortname'=>'西林','name'=>'西林县','merger_name'=>'中国,广西壮族自治区,百色市,西林县','level'=>'3','pinyin'=>'xilin','code'=>'0776','zip_code'=>'533500','first'=>'X','lng'=>'105.09722','lat'=>'24.48966']);
        $this->insert('{{%region}}',['id'=>'2257','pid'=>'2245','shortname'=>'隆林','name'=>'隆林各族自治县','merger_name'=>'中国,广西壮族自治区,百色市,隆林各族自治县','level'=>'3','pinyin'=>'longlin','code'=>'0776','zip_code'=>'533400','first'=>'L','lng'=>'105.34295','lat'=>'24.77036']);
        $this->insert('{{%region}}',['id'=>'2258','pid'=>'2162','shortname'=>'贺州','name'=>'贺州市','merger_name'=>'中国,广西壮族自治区,贺州市','level'=>'2','pinyin'=>'hezhou','code'=>'0774','zip_code'=>'542800','first'=>'H','lng'=>'111.552056','lat'=>'24.414141']);
        $this->insert('{{%region}}',['id'=>'2259','pid'=>'2258','shortname'=>'八步','name'=>'八步区','merger_name'=>'中国,广西壮族自治区,贺州市,八步区','level'=>'3','pinyin'=>'babu','code'=>'0774','zip_code'=>'542800','first'=>'B','lng'=>'111.55225','lat'=>'24.41179']);
        $this->insert('{{%region}}',['id'=>'2260','pid'=>'2258','shortname'=>'昭平','name'=>'昭平县','merger_name'=>'中国,广西壮族自治区,贺州市,昭平县','level'=>'3','pinyin'=>'zhaoping','code'=>'0774','zip_code'=>'546800','first'=>'Z','lng'=>'110.81082','lat'=>'24.1701']);
        $this->insert('{{%region}}',['id'=>'2261','pid'=>'2258','shortname'=>'钟山','name'=>'钟山县','merger_name'=>'中国,广西壮族自治区,贺州市,钟山县','level'=>'3','pinyin'=>'zhongshan','code'=>'0774','zip_code'=>'542600','first'=>'Z','lng'=>'111.30459','lat'=>'24.52482']);
        $this->insert('{{%region}}',['id'=>'2262','pid'=>'2258','shortname'=>'富川','name'=>'富川瑶族自治县','merger_name'=>'中国,广西壮族自治区,贺州市,富川瑶族自治县','level'=>'3','pinyin'=>'fuchuan','code'=>'0774','zip_code'=>'542700','first'=>'F','lng'=>'111.27767','lat'=>'24.81431']);
        $this->insert('{{%region}}',['id'=>'2263','pid'=>'2258','shortname'=>'平桂','name'=>'平桂管理区','merger_name'=>'中国,广西壮族自治区,贺州市,平桂管理区','level'=>'3','pinyin'=>'pingui','code'=>'0774','zip_code'=>'542800','first'=>'P','lng'=>'111.485651','lat'=>'24.458041']);
        $this->insert('{{%region}}',['id'=>'2264','pid'=>'2162','shortname'=>'河池','name'=>'河池市','merger_name'=>'中国,广西壮族自治区,河池市','level'=>'2','pinyin'=>'hechi','code'=>'0778','zip_code'=>'547000','first'=>'H','lng'=>'108.062105','lat'=>'24.695899']);
        $this->insert('{{%region}}',['id'=>'2265','pid'=>'2264','shortname'=>'金城江','name'=>'金城江区','merger_name'=>'中国,广西壮族自治区,河池市,金城江区','level'=>'3','pinyin'=>'jinchengjiang','code'=>'0779','zip_code'=>'547000','first'=>'J','lng'=>'108.03727','lat'=>'24.6897']);
        $this->insert('{{%region}}',['id'=>'2266','pid'=>'2264','shortname'=>'南丹','name'=>'南丹县','merger_name'=>'中国,广西壮族自治区,河池市,南丹县','level'=>'3','pinyin'=>'nandan','code'=>'0781','zip_code'=>'547200','first'=>'N','lng'=>'107.54562','lat'=>'24.9776']);
        $this->insert('{{%region}}',['id'=>'2267','pid'=>'2264','shortname'=>'天峨','name'=>'天峨县','merger_name'=>'中国,广西壮族自治区,河池市,天峨县','level'=>'3','pinyin'=>'tiane','code'=>'0782','zip_code'=>'547300','first'=>'T','lng'=>'107.17205','lat'=>'24.99593']);
        $this->insert('{{%region}}',['id'=>'2268','pid'=>'2264','shortname'=>'凤山','name'=>'凤山县','merger_name'=>'中国,广西壮族自治区,河池市,凤山县','level'=>'3','pinyin'=>'fengshan','code'=>'0783','zip_code'=>'547600','first'=>'F','lng'=>'107.04892','lat'=>'24.54215']);
        $this->insert('{{%region}}',['id'=>'2269','pid'=>'2264','shortname'=>'东兰','name'=>'东兰县','merger_name'=>'中国,广西壮族自治区,河池市,东兰县','level'=>'3','pinyin'=>'donglan','code'=>'0784','zip_code'=>'547400','first'=>'D','lng'=>'107.37527','lat'=>'24.51053']);
        $this->insert('{{%region}}',['id'=>'2270','pid'=>'2264','shortname'=>'罗城','name'=>'罗城仫佬族自治县','merger_name'=>'中国,广西壮族自治区,河池市,罗城仫佬族自治县','level'=>'3','pinyin'=>'luocheng','code'=>'0785','zip_code'=>'546400','first'=>'L','lng'=>'108.90777','lat'=>'24.77923']);
        $this->insert('{{%region}}',['id'=>'2271','pid'=>'2264','shortname'=>'环江','name'=>'环江毛南族自治县','merger_name'=>'中国,广西壮族自治区,河池市,环江毛南族自治县','level'=>'3','pinyin'=>'huanjiang','code'=>'0786','zip_code'=>'547100','first'=>'H','lng'=>'108.26055','lat'=>'24.82916']);
        $this->insert('{{%region}}',['id'=>'2272','pid'=>'2264','shortname'=>'巴马','name'=>'巴马瑶族自治县','merger_name'=>'中国,广西壮族自治区,河池市,巴马瑶族自治县','level'=>'3','pinyin'=>'bama','code'=>'0787','zip_code'=>'547500','first'=>'B','lng'=>'107.25308','lat'=>'24.14135']);
        $this->insert('{{%region}}',['id'=>'2273','pid'=>'2264','shortname'=>'都安','name'=>'都安瑶族自治县','merger_name'=>'中国,广西壮族自治区,河池市,都安瑶族自治县','level'=>'3','pinyin'=>'du\'an','code'=>'0788','zip_code'=>'530700','first'=>'D','lng'=>'108.10116','lat'=>'23.93245']);
        $this->insert('{{%region}}',['id'=>'2274','pid'=>'2264','shortname'=>'大化','name'=>'大化瑶族自治县','merger_name'=>'中国,广西壮族自治区,河池市,大化瑶族自治县','level'=>'3','pinyin'=>'dahua','code'=>'0789','zip_code'=>'530800','first'=>'D','lng'=>'107.9985','lat'=>'23.74487']);
        $this->insert('{{%region}}',['id'=>'2275','pid'=>'2264','shortname'=>'宜州','name'=>'宜州市','merger_name'=>'中国,广西壮族自治区,河池市,宜州市','level'=>'3','pinyin'=>'yizhou','code'=>'0780','zip_code'=>'546300','first'=>'Y','lng'=>'108.65304','lat'=>'24.49391']);
        $this->insert('{{%region}}',['id'=>'2276','pid'=>'2162','shortname'=>'来宾','name'=>'来宾市','merger_name'=>'中国,广西壮族自治区,来宾市','level'=>'2','pinyin'=>'laibin','code'=>'0772','zip_code'=>'546100','first'=>'L','lng'=>'109.229772','lat'=>'23.733766']);
        $this->insert('{{%region}}',['id'=>'2277','pid'=>'2276','shortname'=>'兴宾','name'=>'兴宾区','merger_name'=>'中国,广西壮族自治区,来宾市,兴宾区','level'=>'3','pinyin'=>'xingbin','code'=>'0772','zip_code'=>'546100','first'=>'X','lng'=>'109.23471','lat'=>'23.72731']);
        $this->insert('{{%region}}',['id'=>'2278','pid'=>'2276','shortname'=>'忻城','name'=>'忻城县','merger_name'=>'中国,广西壮族自治区,来宾市,忻城县','level'=>'3','pinyin'=>'xincheng','code'=>'0772','zip_code'=>'546200','first'=>'X','lng'=>'108.66357','lat'=>'24.06862']);
        $this->insert('{{%region}}',['id'=>'2279','pid'=>'2276','shortname'=>'象州','name'=>'象州县','merger_name'=>'中国,广西壮族自治区,来宾市,象州县','level'=>'3','pinyin'=>'xiangzhou','code'=>'0772','zip_code'=>'545800','first'=>'X','lng'=>'109.6994','lat'=>'23.97355']);
        $this->insert('{{%region}}',['id'=>'2280','pid'=>'2276','shortname'=>'武宣','name'=>'武宣县','merger_name'=>'中国,广西壮族自治区,来宾市,武宣县','level'=>'3','pinyin'=>'wuxuan','code'=>'0772','zip_code'=>'545900','first'=>'W','lng'=>'109.66284','lat'=>'23.59474']);
        $this->insert('{{%region}}',['id'=>'2281','pid'=>'2276','shortname'=>'金秀','name'=>'金秀瑶族自治县','merger_name'=>'中国,广西壮族自治区,来宾市,金秀瑶族自治县','level'=>'3','pinyin'=>'jinxiu','code'=>'0772','zip_code'=>'545799','first'=>'J','lng'=>'110.19079','lat'=>'24.12929']);
        $this->insert('{{%region}}',['id'=>'2282','pid'=>'2276','shortname'=>'合山','name'=>'合山市','merger_name'=>'中国,广西壮族自治区,来宾市,合山市','level'=>'3','pinyin'=>'heshan','code'=>'0772','zip_code'=>'546500','first'=>'H','lng'=>'108.88586','lat'=>'23.80619']);
        $this->insert('{{%region}}',['id'=>'2283','pid'=>'2162','shortname'=>'崇左','name'=>'崇左市','merger_name'=>'中国,广西壮族自治区,崇左市','level'=>'2','pinyin'=>'chongzuo','code'=>'0771','zip_code'=>'532299','first'=>'C','lng'=>'107.353926','lat'=>'22.404108']);
        $this->insert('{{%region}}',['id'=>'2284','pid'=>'2283','shortname'=>'江州','name'=>'江州区','merger_name'=>'中国,广西壮族自治区,崇左市,江州区','level'=>'3','pinyin'=>'jiangzhou','code'=>'0771','zip_code'=>'532299','first'=>'J','lng'=>'107.34747','lat'=>'22.41135']);
        $this->insert('{{%region}}',['id'=>'2285','pid'=>'2283','shortname'=>'扶绥','name'=>'扶绥县','merger_name'=>'中国,广西壮族自治区,崇左市,扶绥县','level'=>'3','pinyin'=>'fusui','code'=>'0771','zip_code'=>'532199','first'=>'F','lng'=>'107.90405','lat'=>'22.63413']);
        $this->insert('{{%region}}',['id'=>'2286','pid'=>'2283','shortname'=>'宁明','name'=>'宁明县','merger_name'=>'中国,广西壮族自治区,崇左市,宁明县','level'=>'3','pinyin'=>'ningming','code'=>'0771','zip_code'=>'532599','first'=>'N','lng'=>'107.07299','lat'=>'22.13655']);
        $this->insert('{{%region}}',['id'=>'2287','pid'=>'2283','shortname'=>'龙州','name'=>'龙州县','merger_name'=>'中国,广西壮族自治区,崇左市,龙州县','level'=>'3','pinyin'=>'longzhou','code'=>'0771','zip_code'=>'532499','first'=>'L','lng'=>'106.85415','lat'=>'22.33937']);
        $this->insert('{{%region}}',['id'=>'2288','pid'=>'2283','shortname'=>'大新','name'=>'大新县','merger_name'=>'中国,广西壮族自治区,崇左市,大新县','level'=>'3','pinyin'=>'daxin','code'=>'0771','zip_code'=>'532399','first'=>'D','lng'=>'107.19821','lat'=>'22.83412']);
        $this->insert('{{%region}}',['id'=>'2289','pid'=>'2283','shortname'=>'天等','name'=>'天等县','merger_name'=>'中国,广西壮族自治区,崇左市,天等县','level'=>'3','pinyin'=>'tiandeng','code'=>'0771','zip_code'=>'532899','first'=>'T','lng'=>'107.13998','lat'=>'23.077']);
        $this->insert('{{%region}}',['id'=>'2290','pid'=>'2283','shortname'=>'凭祥','name'=>'凭祥市','merger_name'=>'中国,广西壮族自治区,崇左市,凭祥市','level'=>'3','pinyin'=>'pingxiang','code'=>'0771','zip_code'=>'532699','first'=>'P','lng'=>'106.75534','lat'=>'22.10573']);
        $this->insert('{{%region}}',['id'=>'2291','pid'=>'0','shortname'=>'海南','name'=>'海南省','merger_name'=>'中国,海南省','level'=>'1','pinyin'=>'hainan','code'=>'','zip_code'=>'','first'=>'H','lng'=>'110.33119','lat'=>'20.031971']);
        $this->insert('{{%region}}',['id'=>'2292','pid'=>'2291','shortname'=>'海口','name'=>'海口市','merger_name'=>'中国,海南省,海口市','level'=>'2','pinyin'=>'haikou','code'=>'0898','zip_code'=>'570000','first'=>'H','lng'=>'110.33119','lat'=>'20.031971']);
        $this->insert('{{%region}}',['id'=>'2293','pid'=>'2292','shortname'=>'秀英','name'=>'秀英区','merger_name'=>'中国,海南省,海口市,秀英区','level'=>'3','pinyin'=>'xiuying','code'=>'0898','zip_code'=>'570311','first'=>'X','lng'=>'110.29345','lat'=>'20.00752']);
        $this->insert('{{%region}}',['id'=>'2294','pid'=>'2292','shortname'=>'龙华','name'=>'龙华区','merger_name'=>'中国,海南省,海口市,龙华区','level'=>'3','pinyin'=>'longhua','code'=>'0898','zip_code'=>'570145','first'=>'L','lng'=>'110.30194','lat'=>'20.02866']);
        $this->insert('{{%region}}',['id'=>'2295','pid'=>'2292','shortname'=>'琼山','name'=>'琼山区','merger_name'=>'中国,海南省,海口市,琼山区','level'=>'3','pinyin'=>'qiongshan','code'=>'0898','zip_code'=>'571100','first'=>'Q','lng'=>'110.35418','lat'=>'20.00321']);
        $this->insert('{{%region}}',['id'=>'2296','pid'=>'2292','shortname'=>'美兰','name'=>'美兰区','merger_name'=>'中国,海南省,海口市,美兰区','level'=>'3','pinyin'=>'meilan','code'=>'0898','zip_code'=>'570203','first'=>'M','lng'=>'110.36908','lat'=>'20.02864']);
        $this->insert('{{%region}}',['id'=>'2297','pid'=>'2291','shortname'=>'三亚','name'=>'三亚市','merger_name'=>'中国,海南省,三亚市','level'=>'2','pinyin'=>'sanya','code'=>'0898','zip_code'=>'572000','first'=>'S','lng'=>'109.508268','lat'=>'18.247872']);
        $this->insert('{{%region}}',['id'=>'2298','pid'=>'2297','shortname'=>'海棠','name'=>'海棠区','merger_name'=>'中国,海南省,三亚市,海棠区','level'=>'3','pinyin'=>'haitang','code'=>'0898','zip_code'=>'572000','first'=>'H','lng'=>'109.508268','lat'=>'18.247872']);
        $this->insert('{{%region}}',['id'=>'2299','pid'=>'2297','shortname'=>'吉阳','name'=>'吉阳区','merger_name'=>'中国,海南省,三亚市,吉阳区','level'=>'3','pinyin'=>'jiyang','code'=>'0898','zip_code'=>'572000','first'=>'J','lng'=>'109.508268','lat'=>'18.247872']);
        $this->insert('{{%region}}',['id'=>'2300','pid'=>'2297','shortname'=>'天涯','name'=>'天涯区','merger_name'=>'中国,海南省,三亚市,天涯区','level'=>'3','pinyin'=>'tianya','code'=>'0898','zip_code'=>'572000','first'=>'T','lng'=>'109.508268','lat'=>'18.247872']);
        $this->insert('{{%region}}',['id'=>'2301','pid'=>'2297','shortname'=>'崖州','name'=>'崖州区','merger_name'=>'中国,海南省,三亚市,崖州区','level'=>'3','pinyin'=>'yazhou','code'=>'0898','zip_code'=>'572000','first'=>'Y','lng'=>'109.508268','lat'=>'18.247872']);
        $this->insert('{{%region}}',['id'=>'2302','pid'=>'2291','shortname'=>'三沙','name'=>'三沙市','merger_name'=>'中国,海南省,三沙市','level'=>'2','pinyin'=>'sansha','code'=>'0898','zip_code'=>'573199','first'=>'S','lng'=>'112.34882','lat'=>'16.831039']);
        $this->insert('{{%region}}',['id'=>'2303','pid'=>'2302','shortname'=>'西沙','name'=>'西沙群岛','merger_name'=>'中国,海南省,三沙市,西沙群岛','level'=>'3','pinyin'=>'xishaislands','code'=>'0898','zip_code'=>'572000','first'=>'X','lng'=>'112.025528','lat'=>'16.331342']);
        $this->insert('{{%region}}',['id'=>'2304','pid'=>'2302','shortname'=>'南沙','name'=>'南沙群岛','merger_name'=>'中国,海南省,三沙市,南沙群岛','level'=>'3','pinyin'=>'nanshaislands','code'=>'0898','zip_code'=>'573100','first'=>'N','lng'=>'116.749998','lat'=>'11.471888']);
        $this->insert('{{%region}}',['id'=>'2305','pid'=>'2302','shortname'=>'中沙','name'=>'中沙群岛','merger_name'=>'中国,海南省,三沙市,中沙群岛','level'=>'3','pinyin'=>'zhongshaislands','code'=>'0898','zip_code'=>'573100','first'=>'Z','lng'=>'117.740071','lat'=>'15.112856']);
        $this->insert('{{%region}}',['id'=>'2306','pid'=>'2291','shortname'=>' ','name'=>'直辖县级','merger_name'=>'中国,海南省,直辖县级','level'=>'2','pinyin'=>'','code'=>'','zip_code'=>'','first'=>'Z','lng'=>'109.503479','lat'=>'18.739906']);
        $this->insert('{{%region}}',['id'=>'2307','pid'=>'2306','shortname'=>'五指山','name'=>'五指山市','merger_name'=>'中国,海南省,直辖县级,五指山市','level'=>'3','pinyin'=>'wuzhishan','code'=>'0898','zip_code'=>'572200','first'=>'W','lng'=>'109.516662','lat'=>'18.776921']);
        $this->insert('{{%region}}',['id'=>'2308','pid'=>'2306','shortname'=>'琼海','name'=>'琼海市','merger_name'=>'中国,海南省,直辖县级,琼海市','level'=>'3','pinyin'=>'qionghai','code'=>'0898','zip_code'=>'571400','first'=>'Q','lng'=>'110.466785','lat'=>'19.246011']);
        $this->insert('{{%region}}',['id'=>'2309','pid'=>'2306','shortname'=>'儋州','name'=>'儋州市','merger_name'=>'中国,海南省,直辖县级,儋州市','level'=>'3','pinyin'=>'danzhou','code'=>'0898','zip_code'=>'571700','first'=>NULL,'lng'=>'109.576782','lat'=>'19.517486']);
        $this->insert('{{%region}}',['id'=>'2310','pid'=>'2306','shortname'=>'文昌','name'=>'文昌市','merger_name'=>'中国,海南省,直辖县级,文昌市','level'=>'3','pinyin'=>'wenchang','code'=>'0898','zip_code'=>'571339','first'=>'W','lng'=>'110.753975','lat'=>'19.612986']);
        $this->insert('{{%region}}',['id'=>'2311','pid'=>'2306','shortname'=>'万宁','name'=>'万宁市','merger_name'=>'中国,海南省,直辖县级,万宁市','level'=>'3','pinyin'=>'wanning','code'=>'0898','zip_code'=>'571500','first'=>'W','lng'=>'110.388793','lat'=>'18.796216']);
        $this->insert('{{%region}}',['id'=>'2312','pid'=>'2306','shortname'=>'东方','name'=>'东方市','merger_name'=>'中国,海南省,直辖县级,东方市','level'=>'3','pinyin'=>'dongfang','code'=>'0898','zip_code'=>'572600','first'=>'D','lng'=>'108.653789','lat'=>'19.10198']);
        $this->insert('{{%region}}',['id'=>'2313','pid'=>'2306','shortname'=>'定安','name'=>'定安县','merger_name'=>'中国,海南省,直辖县级,定安县','level'=>'3','pinyin'=>'ding\'an','code'=>'0898','zip_code'=>'571200','first'=>'D','lng'=>'110.323959','lat'=>'19.699211']);
        $this->insert('{{%region}}',['id'=>'2314','pid'=>'2306','shortname'=>'屯昌','name'=>'屯昌县','merger_name'=>'中国,海南省,直辖县级,屯昌县','level'=>'3','pinyin'=>'tunchang','code'=>'0898','zip_code'=>'571600','first'=>'T','lng'=>'110.102773','lat'=>'19.362916']);
        $this->insert('{{%region}}',['id'=>'2315','pid'=>'2306','shortname'=>'澄迈','name'=>'澄迈县','merger_name'=>'中国,海南省,直辖县级,澄迈县','level'=>'3','pinyin'=>'chengmai','code'=>'0898','zip_code'=>'571900','first'=>'C','lng'=>'110.007147','lat'=>'19.737095']);
        $this->insert('{{%region}}',['id'=>'2316','pid'=>'2306','shortname'=>'临高','name'=>'临高县','merger_name'=>'中国,海南省,直辖县级,临高县','level'=>'3','pinyin'=>'lingao','code'=>'0898','zip_code'=>'571800','first'=>'L','lng'=>'109.687697','lat'=>'19.908293']);
        $this->insert('{{%region}}',['id'=>'2317','pid'=>'2306','shortname'=>'白沙','name'=>'白沙黎族自治县','merger_name'=>'中国,海南省,直辖县级,白沙黎族自治县','level'=>'3','pinyin'=>'baisha','code'=>'0898','zip_code'=>'572800','first'=>'B','lng'=>'109.452606','lat'=>'19.224584']);
        $this->insert('{{%region}}',['id'=>'2318','pid'=>'2306','shortname'=>'昌江','name'=>'昌江黎族自治县','merger_name'=>'中国,海南省,直辖县级,昌江黎族自治县','level'=>'3','pinyin'=>'changjiang','code'=>'0898','zip_code'=>'572700','first'=>'C','lng'=>'109.053351','lat'=>'19.260968']);
        $this->insert('{{%region}}',['id'=>'2319','pid'=>'2306','shortname'=>'乐东','name'=>'乐东黎族自治县','merger_name'=>'中国,海南省,直辖县级,乐东黎族自治县','level'=>'3','pinyin'=>'ledong','code'=>'0898','zip_code'=>'572500','first'=>'L','lng'=>'109.175444','lat'=>'18.74758']);
        $this->insert('{{%region}}',['id'=>'2320','pid'=>'2306','shortname'=>'陵水','name'=>'陵水黎族自治县','merger_name'=>'中国,海南省,直辖县级,陵水黎族自治县','level'=>'3','pinyin'=>'lingshui','code'=>'0898','zip_code'=>'572400','first'=>'L','lng'=>'110.037218','lat'=>'18.505006']);
        $this->insert('{{%region}}',['id'=>'2321','pid'=>'2306','shortname'=>'保亭','name'=>'保亭黎族苗族自治县','merger_name'=>'中国,海南省,直辖县级,保亭黎族苗族自治县','level'=>'3','pinyin'=>'baoting','code'=>'0898','zip_code'=>'572300','first'=>'B','lng'=>'109.70245','lat'=>'18.636371']);
        $this->insert('{{%region}}',['id'=>'2322','pid'=>'2306','shortname'=>'琼中','name'=>'琼中黎族苗族自治县','merger_name'=>'中国,海南省,直辖县级,琼中黎族苗族自治县','level'=>'3','pinyin'=>'qiongzhong','code'=>'0898','zip_code'=>'572900','first'=>'Q','lng'=>'109.839996','lat'=>'19.03557']);
        $this->insert('{{%region}}',['id'=>'2323','pid'=>'0','shortname'=>'重庆','name'=>'重庆市','merger_name'=>'中国,重庆','level'=>'1','pinyin'=>'chongqing','code'=>'','zip_code'=>'','first'=>'Z','lng'=>'106.504962','lat'=>'29.533155']);
        $this->insert('{{%region}}',['id'=>'2324','pid'=>'2323','shortname'=>'重庆','name'=>'重庆市','merger_name'=>'中国,重庆,重庆市','level'=>'2','pinyin'=>'chongqing','code'=>'023','zip_code'=>'400000','first'=>'Z','lng'=>'106.504962','lat'=>'29.533155']);
        $this->insert('{{%region}}',['id'=>'2325','pid'=>'2324','shortname'=>'万州','name'=>'万州区','merger_name'=>'中国,重庆,重庆市,万州区','level'=>'3','pinyin'=>'wanzhou','code'=>'023','zip_code'=>'404000','first'=>'W','lng'=>'108.40869','lat'=>'30.80788']);
        $this->insert('{{%region}}',['id'=>'2326','pid'=>'2324','shortname'=>'涪陵','name'=>'涪陵区','merger_name'=>'中国,重庆,重庆市,涪陵区','level'=>'3','pinyin'=>'fuling','code'=>'023','zip_code'=>'408000','first'=>'F','lng'=>'107.39007','lat'=>'29.70292']);
        $this->insert('{{%region}}',['id'=>'2327','pid'=>'2324','shortname'=>'渝中','name'=>'渝中区','merger_name'=>'中国,重庆,重庆市,渝中区','level'=>'3','pinyin'=>'yuzhong','code'=>'023','zip_code'=>'400010','first'=>'Y','lng'=>'106.56901','lat'=>'29.55279']);
        $this->insert('{{%region}}',['id'=>'2328','pid'=>'2324','shortname'=>'大渡口','name'=>'大渡口区','merger_name'=>'中国,重庆,重庆市,大渡口区','level'=>'3','pinyin'=>'dadukou','code'=>'023','zip_code'=>'400080','first'=>'D','lng'=>'106.48262','lat'=>'29.48447']);
        $this->insert('{{%region}}',['id'=>'2329','pid'=>'2324','shortname'=>'江北','name'=>'江北区','merger_name'=>'中国,重庆,重庆市,江北区','level'=>'3','pinyin'=>'jiangbei','code'=>'023','zip_code'=>'400020','first'=>'J','lng'=>'106.57434','lat'=>'29.60658']);
        $this->insert('{{%region}}',['id'=>'2330','pid'=>'2324','shortname'=>'沙坪坝','name'=>'沙坪坝区','merger_name'=>'中国,重庆,重庆市,沙坪坝区','level'=>'3','pinyin'=>'shapingba','code'=>'023','zip_code'=>'400030','first'=>'S','lng'=>'106.45752','lat'=>'29.54113']);
        $this->insert('{{%region}}',['id'=>'2331','pid'=>'2324','shortname'=>'九龙坡','name'=>'九龙坡区','merger_name'=>'中国,重庆,重庆市,九龙坡区','level'=>'3','pinyin'=>'jiulongpo','code'=>'023','zip_code'=>'400050','first'=>'J','lng'=>'106.51107','lat'=>'29.50197']);
        $this->insert('{{%region}}',['id'=>'2332','pid'=>'2324','shortname'=>'南岸','name'=>'南岸区','merger_name'=>'中国,重庆,重庆市,南岸区','level'=>'3','pinyin'=>'nan\'an','code'=>'023','zip_code'=>'400064','first'=>'N','lng'=>'106.56347','lat'=>'29.52311']);
        $this->insert('{{%region}}',['id'=>'2333','pid'=>'2324','shortname'=>'北碚','name'=>'北碚区','merger_name'=>'中国,重庆,重庆市,北碚区','level'=>'3','pinyin'=>'beibei','code'=>'023','zip_code'=>'400700','first'=>'B','lng'=>'106.39614','lat'=>'29.80574']);
        $this->insert('{{%region}}',['id'=>'2334','pid'=>'2324','shortname'=>'綦江','name'=>'綦江区','merger_name'=>'中国,重庆,重庆市,綦江区','level'=>'3','pinyin'=>'qijiang','code'=>'023','zip_code'=>'400800','first'=>NULL,'lng'=>'106.926779','lat'=>'28.960656']);
        $this->insert('{{%region}}',['id'=>'2335','pid'=>'2324','shortname'=>'大足','name'=>'大足区','merger_name'=>'中国,重庆,重庆市,大足区','level'=>'3','pinyin'=>'dazu','code'=>'023','zip_code'=>'400900','first'=>'D','lng'=>'105.768121','lat'=>'29.484025']);
        $this->insert('{{%region}}',['id'=>'2336','pid'=>'2324','shortname'=>'渝北','name'=>'渝北区','merger_name'=>'中国,重庆,重庆市,渝北区','level'=>'3','pinyin'=>'yubei','code'=>'023','zip_code'=>'401120','first'=>'Y','lng'=>'106.6307','lat'=>'29.7182']);
        $this->insert('{{%region}}',['id'=>'2337','pid'=>'2324','shortname'=>'巴南','name'=>'巴南区','merger_name'=>'中国,重庆,重庆市,巴南区','level'=>'3','pinyin'=>'banan','code'=>'023','zip_code'=>'401320','first'=>'B','lng'=>'106.52365','lat'=>'29.38311']);
        $this->insert('{{%region}}',['id'=>'2338','pid'=>'2324','shortname'=>'黔江','name'=>'黔江区','merger_name'=>'中国,重庆,重庆市,黔江区','level'=>'3','pinyin'=>'qianjiang','code'=>'023','zip_code'=>'409700','first'=>'Q','lng'=>'108.7709','lat'=>'29.5332']);
        $this->insert('{{%region}}',['id'=>'2339','pid'=>'2324','shortname'=>'长寿','name'=>'长寿区','merger_name'=>'中国,重庆,重庆市,长寿区','level'=>'3','pinyin'=>'changshou','code'=>'023','zip_code'=>'401220','first'=>'C','lng'=>'107.08166','lat'=>'29.85359']);
        $this->insert('{{%region}}',['id'=>'2340','pid'=>'2324','shortname'=>'江津','name'=>'江津区','merger_name'=>'中国,重庆,重庆市,江津区','level'=>'3','pinyin'=>'jiangjin','code'=>'023','zip_code'=>'402260','first'=>'J','lng'=>'106.25912','lat'=>'29.29008']);
        $this->insert('{{%region}}',['id'=>'2341','pid'=>'2324','shortname'=>'合川','name'=>'合川区','merger_name'=>'中国,重庆,重庆市,合川区','level'=>'3','pinyin'=>'hechuan','code'=>'023','zip_code'=>'401520','first'=>'H','lng'=>'106.27633','lat'=>'29.97227']);
        $this->insert('{{%region}}',['id'=>'2342','pid'=>'2324','shortname'=>'永川','name'=>'永川区','merger_name'=>'中国,重庆,重庆市,永川区','level'=>'3','pinyin'=>'yongchuan','code'=>'023','zip_code'=>'402160','first'=>'Y','lng'=>'105.927','lat'=>'29.35593']);
        $this->insert('{{%region}}',['id'=>'2343','pid'=>'2324','shortname'=>'南川','name'=>'南川区','merger_name'=>'中国,重庆,重庆市,南川区','level'=>'3','pinyin'=>'nanchuan','code'=>'023','zip_code'=>'408400','first'=>'N','lng'=>'107.09936','lat'=>'29.15751']);
        $this->insert('{{%region}}',['id'=>'2344','pid'=>'2324','shortname'=>'璧山','name'=>'璧山区','merger_name'=>'中国,重庆,重庆市,璧山区','level'=>'3','pinyin'=>'bishan','code'=>'023','zip_code'=>'402760','first'=>NULL,'lng'=>'106.231126','lat'=>'29.593581']);
        $this->insert('{{%region}}',['id'=>'2345','pid'=>'2324','shortname'=>'铜梁','name'=>'铜梁区','merger_name'=>'中国,重庆,重庆市,铜梁区','level'=>'3','pinyin'=>'tongliang','code'=>'023','zip_code'=>'402560','first'=>'T','lng'=>'106.054948','lat'=>'29.839944']);
        $this->insert('{{%region}}',['id'=>'2346','pid'=>'2324','shortname'=>'潼南','name'=>'潼南县','merger_name'=>'中国,重庆,重庆市,潼南县','level'=>'3','pinyin'=>'tongnan','code'=>'023','zip_code'=>'402660','first'=>NULL,'lng'=>'105.84005','lat'=>'30.1912']);
        $this->insert('{{%region}}',['id'=>'2347','pid'=>'2324','shortname'=>'荣昌','name'=>'荣昌县','merger_name'=>'中国,重庆,重庆市,荣昌县','level'=>'3','pinyin'=>'rongchang','code'=>'023','zip_code'=>'402460','first'=>'R','lng'=>'105.59442','lat'=>'29.40488']);
        $this->insert('{{%region}}',['id'=>'2348','pid'=>'2324','shortname'=>'梁平','name'=>'梁平县','merger_name'=>'中国,重庆,重庆市,梁平县','level'=>'3','pinyin'=>'liangping','code'=>'023','zip_code'=>'405200','first'=>'L','lng'=>'107.79998','lat'=>'30.67545']);
        $this->insert('{{%region}}',['id'=>'2349','pid'=>'2324','shortname'=>'城口','name'=>'城口县','merger_name'=>'中国,重庆,重庆市,城口县','level'=>'3','pinyin'=>'chengkou','code'=>'023','zip_code'=>'405900','first'=>'C','lng'=>'108.66513','lat'=>'31.94801']);
        $this->insert('{{%region}}',['id'=>'2350','pid'=>'2324','shortname'=>'丰都','name'=>'丰都县','merger_name'=>'中国,重庆,重庆市,丰都县','level'=>'3','pinyin'=>'fengdu','code'=>'023','zip_code'=>'408200','first'=>'F','lng'=>'107.73098','lat'=>'29.86348']);
        $this->insert('{{%region}}',['id'=>'2351','pid'=>'2324','shortname'=>'垫江','name'=>'垫江县','merger_name'=>'中国,重庆,重庆市,垫江县','level'=>'3','pinyin'=>'dianjiang','code'=>'023','zip_code'=>'408300','first'=>'D','lng'=>'107.35446','lat'=>'30.33359']);
        $this->insert('{{%region}}',['id'=>'2352','pid'=>'2324','shortname'=>'武隆','name'=>'武隆县','merger_name'=>'中国,重庆,重庆市,武隆县','level'=>'3','pinyin'=>'wulong','code'=>'023','zip_code'=>'408500','first'=>'W','lng'=>'107.7601','lat'=>'29.32548']);
        $this->insert('{{%region}}',['id'=>'2353','pid'=>'2324','shortname'=>'忠县','name'=>'忠县','merger_name'=>'中国,重庆,重庆市,忠县','level'=>'3','pinyin'=>'zhongxian','code'=>'023','zip_code'=>'404300','first'=>'Z','lng'=>'108.03689','lat'=>'30.28898']);
        $this->insert('{{%region}}',['id'=>'2354','pid'=>'2324','shortname'=>'开县','name'=>'开县','merger_name'=>'中国,重庆,重庆市,开县','level'=>'3','pinyin'=>'kaixian','code'=>'023','zip_code'=>'405400','first'=>'K','lng'=>'108.39306','lat'=>'31.16095']);
        $this->insert('{{%region}}',['id'=>'2355','pid'=>'2324','shortname'=>'云阳','name'=>'云阳县','merger_name'=>'中国,重庆,重庆市,云阳县','level'=>'3','pinyin'=>'yunyang','code'=>'023','zip_code'=>'404500','first'=>'Y','lng'=>'108.69726','lat'=>'30.93062']);
        $this->insert('{{%region}}',['id'=>'2356','pid'=>'2324','shortname'=>'奉节','name'=>'奉节县','merger_name'=>'中国,重庆,重庆市,奉节县','level'=>'3','pinyin'=>'fengjie','code'=>'023','zip_code'=>'404600','first'=>'F','lng'=>'109.46478','lat'=>'31.01825']);
        $this->insert('{{%region}}',['id'=>'2357','pid'=>'2324','shortname'=>'巫山','name'=>'巫山县','merger_name'=>'中国,重庆,重庆市,巫山县','level'=>'3','pinyin'=>'wushan','code'=>'023','zip_code'=>'404700','first'=>'W','lng'=>'109.87814','lat'=>'31.07458']);
        $this->insert('{{%region}}',['id'=>'2358','pid'=>'2324','shortname'=>'巫溪','name'=>'巫溪县','merger_name'=>'中国,重庆,重庆市,巫溪县','level'=>'3','pinyin'=>'wuxi','code'=>'023','zip_code'=>'405800','first'=>'W','lng'=>'109.63128','lat'=>'31.39756']);
        $this->insert('{{%region}}',['id'=>'2359','pid'=>'2324','shortname'=>'石柱','name'=>'石柱土家族自治县','merger_name'=>'中国,重庆,重庆市,石柱土家族自治县','level'=>'3','pinyin'=>'shizhu','code'=>'023','zip_code'=>'409100','first'=>'S','lng'=>'108.11389','lat'=>'30.00054']);
        $this->insert('{{%region}}',['id'=>'2360','pid'=>'2324','shortname'=>'秀山','name'=>'秀山土家族苗族自治县','merger_name'=>'中国,重庆,重庆市,秀山土家族苗族自治县','level'=>'3','pinyin'=>'xiushan','code'=>'023','zip_code'=>'409900','first'=>'X','lng'=>'108.98861','lat'=>'28.45062']);
        $this->insert('{{%region}}',['id'=>'2361','pid'=>'2324','shortname'=>'酉阳','name'=>'酉阳土家族苗族自治县','merger_name'=>'中国,重庆,重庆市,酉阳土家族苗族自治县','level'=>'3','pinyin'=>'youyang','code'=>'023','zip_code'=>'409800','first'=>'Y','lng'=>'108.77212','lat'=>'28.8446']);
        $this->insert('{{%region}}',['id'=>'2362','pid'=>'2324','shortname'=>'彭水','name'=>'彭水苗族土家族自治县','merger_name'=>'中国,重庆,重庆市,彭水苗族土家族自治县','level'=>'3','pinyin'=>'pengshui','code'=>'023','zip_code'=>'409600','first'=>'P','lng'=>'108.16638','lat'=>'29.29516']);
        $this->insert('{{%region}}',['id'=>'2363','pid'=>'2323','shortname'=>'两江新区','name'=>'两江新区','merger_name'=>'中国,重庆,两江新区','level'=>'2','pinyin'=>'liangjiangxinqu','code'=>'023','zip_code'=>'400000','first'=>'L','lng'=>'106.463344','lat'=>'29.729153']);
        $this->insert('{{%region}}',['id'=>'2364','pid'=>'2363','shortname'=>'北部新区','name'=>'北部新区','merger_name'=>'中国,重庆,两江新区,北部新区','level'=>'3','pinyin'=>'beibuxinqu','code'=>'023','zip_code'=>'400000','first'=>'B','lng'=>'106.488841','lat'=>'29.667062']);
        $this->insert('{{%region}}',['id'=>'2365','pid'=>'2363','shortname'=>'保税港区','name'=>'保税港区','merger_name'=>'中国,重庆,两江新区,保税港区','level'=>'3','pinyin'=>'baoshuigangqu','code'=>'023','zip_code'=>'400000','first'=>'B','lng'=>'106.638184','lat'=>'29.716311']);
        $this->insert('{{%region}}',['id'=>'2366','pid'=>'2363','shortname'=>'工业园区','name'=>'工业园区','merger_name'=>'中国,重庆,两江新区,工业园区','level'=>'3','pinyin'=>'gongyeyuanqu','code'=>'023','zip_code'=>'400000','first'=>'G','lng'=>'106.626434','lat'=>'29.55554']);
        $this->insert('{{%region}}',['id'=>'2367','pid'=>'0','shortname'=>'四川','name'=>'四川省','merger_name'=>'中国,四川省','level'=>'1','pinyin'=>'sichuan','code'=>'','zip_code'=>'','first'=>'S','lng'=>'104.065735','lat'=>'30.659462']);
        $this->insert('{{%region}}',['id'=>'2368','pid'=>'2367','shortname'=>'成都','name'=>'成都市','merger_name'=>'中国,四川省,成都市','level'=>'2','pinyin'=>'chengdu','code'=>'028','zip_code'=>'610015','first'=>'C','lng'=>'104.065735','lat'=>'30.659462']);
        $this->insert('{{%region}}',['id'=>'2369','pid'=>'2368','shortname'=>'锦江','name'=>'锦江区','merger_name'=>'中国,四川省,成都市,锦江区','level'=>'3','pinyin'=>'jinjiang','code'=>'028','zip_code'=>'610021','first'=>'J','lng'=>'104.08347','lat'=>'30.65614']);
        $this->insert('{{%region}}',['id'=>'2370','pid'=>'2368','shortname'=>'青羊','name'=>'青羊区','merger_name'=>'中国,四川省,成都市,青羊区','level'=>'3','pinyin'=>'qingyang','code'=>'028','zip_code'=>'610031','first'=>'Q','lng'=>'104.06151','lat'=>'30.67387']);
        $this->insert('{{%region}}',['id'=>'2371','pid'=>'2368','shortname'=>'金牛','name'=>'金牛区','merger_name'=>'中国,四川省,成都市,金牛区','level'=>'3','pinyin'=>'jinniu','code'=>'028','zip_code'=>'610036','first'=>'J','lng'=>'104.05114','lat'=>'30.69126']);
        $this->insert('{{%region}}',['id'=>'2372','pid'=>'2368','shortname'=>'武侯','name'=>'武侯区','merger_name'=>'中国,四川省,成都市,武侯区','level'=>'3','pinyin'=>'wuhou','code'=>'028','zip_code'=>'610041','first'=>'W','lng'=>'104.04303','lat'=>'30.64235']);
        $this->insert('{{%region}}',['id'=>'2373','pid'=>'2368','shortname'=>'成华','name'=>'成华区','merger_name'=>'中国,四川省,成都市,成华区','level'=>'3','pinyin'=>'chenghua','code'=>'028','zip_code'=>'610066','first'=>'C','lng'=>'104.10193','lat'=>'30.65993']);
        $this->insert('{{%region}}',['id'=>'2374','pid'=>'2368','shortname'=>'龙泉驿','name'=>'龙泉驿区','merger_name'=>'中国,四川省,成都市,龙泉驿区','level'=>'3','pinyin'=>'longquanyi','code'=>'028','zip_code'=>'610100','first'=>'L','lng'=>'104.27462','lat'=>'30.55658']);
        $this->insert('{{%region}}',['id'=>'2375','pid'=>'2368','shortname'=>'青白江','name'=>'青白江区','merger_name'=>'中国,四川省,成都市,青白江区','level'=>'3','pinyin'=>'qingbaijiang','code'=>'028','zip_code'=>'610300','first'=>'Q','lng'=>'104.251','lat'=>'30.87841']);
        $this->insert('{{%region}}',['id'=>'2376','pid'=>'2368','shortname'=>'新都','name'=>'新都区','merger_name'=>'中国,四川省,成都市,新都区','level'=>'3','pinyin'=>'xindu','code'=>'028','zip_code'=>'610500','first'=>'X','lng'=>'104.15921','lat'=>'30.82314']);
        $this->insert('{{%region}}',['id'=>'2377','pid'=>'2368','shortname'=>'温江','name'=>'温江区','merger_name'=>'中国,四川省,成都市,温江区','level'=>'3','pinyin'=>'wenjiang','code'=>'028','zip_code'=>'611130','first'=>'W','lng'=>'103.84881','lat'=>'30.68444']);
        $this->insert('{{%region}}',['id'=>'2378','pid'=>'2368','shortname'=>'金堂','name'=>'金堂县','merger_name'=>'中国,四川省,成都市,金堂县','level'=>'3','pinyin'=>'jintang','code'=>'028','zip_code'=>'610400','first'=>'J','lng'=>'104.41195','lat'=>'30.86195']);
        $this->insert('{{%region}}',['id'=>'2379','pid'=>'2368','shortname'=>'双流','name'=>'双流县','merger_name'=>'中国,四川省,成都市,双流县','level'=>'3','pinyin'=>'shuangliu','code'=>'028','zip_code'=>'610200','first'=>'S','lng'=>'103.92373','lat'=>'30.57444']);
        $this->insert('{{%region}}',['id'=>'2380','pid'=>'2368','shortname'=>'郫县','name'=>'郫县','merger_name'=>'中国,四川省,成都市,郫县','level'=>'3','pinyin'=>'pixian','code'=>'028','zip_code'=>'611730','first'=>NULL,'lng'=>'103.88717','lat'=>'30.81054']);
        $this->insert('{{%region}}',['id'=>'2381','pid'=>'2368','shortname'=>'大邑','name'=>'大邑县','merger_name'=>'中国,四川省,成都市,大邑县','level'=>'3','pinyin'=>'dayi','code'=>'028','zip_code'=>'611330','first'=>'D','lng'=>'103.52075','lat'=>'30.58738']);
        $this->insert('{{%region}}',['id'=>'2382','pid'=>'2368','shortname'=>'蒲江','name'=>'蒲江县','merger_name'=>'中国,四川省,成都市,蒲江县','level'=>'3','pinyin'=>'pujiang','code'=>'028','zip_code'=>'611630','first'=>'P','lng'=>'103.50616','lat'=>'30.19667']);
        $this->insert('{{%region}}',['id'=>'2383','pid'=>'2368','shortname'=>'新津','name'=>'新津县','merger_name'=>'中国,四川省,成都市,新津县','level'=>'3','pinyin'=>'xinjin','code'=>'028','zip_code'=>'611430','first'=>'X','lng'=>'103.8114','lat'=>'30.40983']);
        $this->insert('{{%region}}',['id'=>'2384','pid'=>'2368','shortname'=>'都江堰','name'=>'都江堰市','merger_name'=>'中国,四川省,成都市,都江堰市','level'=>'3','pinyin'=>'dujiangyan','code'=>'028','zip_code'=>'611830','first'=>'D','lng'=>'103.61941','lat'=>'30.99825']);
        $this->insert('{{%region}}',['id'=>'2385','pid'=>'2368','shortname'=>'彭州','name'=>'彭州市','merger_name'=>'中国,四川省,成都市,彭州市','level'=>'3','pinyin'=>'pengzhou','code'=>'028','zip_code'=>'611930','first'=>'P','lng'=>'103.958','lat'=>'30.99011']);
        $this->insert('{{%region}}',['id'=>'2386','pid'=>'2368','shortname'=>'邛崃','name'=>'邛崃市','merger_name'=>'中国,四川省,成都市,邛崃市','level'=>'3','pinyin'=>'qionglai','code'=>'028','zip_code'=>'611530','first'=>NULL,'lng'=>'103.46283','lat'=>'30.41489']);
        $this->insert('{{%region}}',['id'=>'2387','pid'=>'2368','shortname'=>'崇州','name'=>'崇州市','merger_name'=>'中国,四川省,成都市,崇州市','level'=>'3','pinyin'=>'chongzhou','code'=>'028','zip_code'=>'611230','first'=>'C','lng'=>'103.67285','lat'=>'30.63014']);
        $this->insert('{{%region}}',['id'=>'2388','pid'=>'2367','shortname'=>'自贡','name'=>'自贡市','merger_name'=>'中国,四川省,自贡市','level'=>'2','pinyin'=>'zigong','code'=>'0813','zip_code'=>'643000','first'=>'Z','lng'=>'104.773447','lat'=>'29.352765']);
        $this->insert('{{%region}}',['id'=>'2389','pid'=>'2388','shortname'=>'自流井','name'=>'自流井区','merger_name'=>'中国,四川省,自贡市,自流井区','level'=>'3','pinyin'=>'ziliujing','code'=>'0813','zip_code'=>'643000','first'=>'Z','lng'=>'104.77719','lat'=>'29.33745']);
        $this->insert('{{%region}}',['id'=>'2390','pid'=>'2388','shortname'=>'贡井','name'=>'贡井区','merger_name'=>'中国,四川省,自贡市,贡井区','level'=>'3','pinyin'=>'gongjing','code'=>'0813','zip_code'=>'643020','first'=>'G','lng'=>'104.71536','lat'=>'29.34576']);
        $this->insert('{{%region}}',['id'=>'2391','pid'=>'2388','shortname'=>'大安','name'=>'大安区','merger_name'=>'中国,四川省,自贡市,大安区','level'=>'3','pinyin'=>'da\'an','code'=>'0813','zip_code'=>'643010','first'=>'D','lng'=>'104.77383','lat'=>'29.36364']);
        $this->insert('{{%region}}',['id'=>'2392','pid'=>'2388','shortname'=>'沿滩','name'=>'沿滩区','merger_name'=>'中国,四川省,自贡市,沿滩区','level'=>'3','pinyin'=>'yantan','code'=>'0813','zip_code'=>'643030','first'=>'Y','lng'=>'104.88012','lat'=>'29.26611']);
        $this->insert('{{%region}}',['id'=>'2393','pid'=>'2388','shortname'=>'荣县','name'=>'荣县','merger_name'=>'中国,四川省,自贡市,荣县','level'=>'3','pinyin'=>'rongxian','code'=>'0813','zip_code'=>'643100','first'=>'R','lng'=>'104.4176','lat'=>'29.44445']);
        $this->insert('{{%region}}',['id'=>'2394','pid'=>'2388','shortname'=>'富顺','name'=>'富顺县','merger_name'=>'中国,四川省,自贡市,富顺县','level'=>'3','pinyin'=>'fushun','code'=>'0813','zip_code'=>'643200','first'=>'F','lng'=>'104.97491','lat'=>'29.18123']);
        $this->insert('{{%region}}',['id'=>'2395','pid'=>'2367','shortname'=>'攀枝花','name'=>'攀枝花市','merger_name'=>'中国,四川省,攀枝花市','level'=>'2','pinyin'=>'panzhihua','code'=>'0812','zip_code'=>'617000','first'=>'P','lng'=>'101.716007','lat'=>'26.580446']);
        $this->insert('{{%region}}',['id'=>'2396','pid'=>'2395','shortname'=>'东区','name'=>'东区','merger_name'=>'中国,四川省,攀枝花市,东区','level'=>'3','pinyin'=>'dongqu','code'=>'0812','zip_code'=>'617067','first'=>'D','lng'=>'101.7052','lat'=>'26.54677']);
        $this->insert('{{%region}}',['id'=>'2397','pid'=>'2395','shortname'=>'西区','name'=>'西区','merger_name'=>'中国,四川省,攀枝花市,西区','level'=>'3','pinyin'=>'xiqu','code'=>'0812','zip_code'=>'617068','first'=>'X','lng'=>'101.63058','lat'=>'26.59753']);
        $this->insert('{{%region}}',['id'=>'2398','pid'=>'2395','shortname'=>'仁和','name'=>'仁和区','merger_name'=>'中国,四川省,攀枝花市,仁和区','level'=>'3','pinyin'=>'renhe','code'=>'0812','zip_code'=>'617061','first'=>'R','lng'=>'101.73812','lat'=>'26.49841']);
        $this->insert('{{%region}}',['id'=>'2399','pid'=>'2395','shortname'=>'米易','name'=>'米易县','merger_name'=>'中国,四川省,攀枝花市,米易县','level'=>'3','pinyin'=>'miyi','code'=>'0812','zip_code'=>'617200','first'=>'M','lng'=>'102.11132','lat'=>'26.88718']);
        $this->insert('{{%region}}',['id'=>'2400','pid'=>'2395','shortname'=>'盐边','name'=>'盐边县','merger_name'=>'中国,四川省,攀枝花市,盐边县','level'=>'3','pinyin'=>'yanbian','code'=>'0812','zip_code'=>'617100','first'=>'Y','lng'=>'101.85446','lat'=>'26.68847']);
        $this->insert('{{%region}}',['id'=>'2401','pid'=>'2367','shortname'=>'泸州','name'=>'泸州市','merger_name'=>'中国,四川省,泸州市','level'=>'2','pinyin'=>'luzhou','code'=>'0830','zip_code'=>'646000','first'=>NULL,'lng'=>'105.443348','lat'=>'28.889138']);
        $this->insert('{{%region}}',['id'=>'2402','pid'=>'2401','shortname'=>'江阳','name'=>'江阳区','merger_name'=>'中国,四川省,泸州市,江阳区','level'=>'3','pinyin'=>'jiangyang','code'=>'0830','zip_code'=>'646000','first'=>'J','lng'=>'105.45336','lat'=>'28.88934']);
        $this->insert('{{%region}}',['id'=>'2403','pid'=>'2401','shortname'=>'纳溪','name'=>'纳溪区','merger_name'=>'中国,四川省,泸州市,纳溪区','level'=>'3','pinyin'=>'naxi','code'=>'0830','zip_code'=>'646300','first'=>'N','lng'=>'105.37255','lat'=>'28.77343']);
        $this->insert('{{%region}}',['id'=>'2404','pid'=>'2401','shortname'=>'龙马潭','name'=>'龙马潭区','merger_name'=>'中国,四川省,泸州市,龙马潭区','level'=>'3','pinyin'=>'longmatan','code'=>'0830','zip_code'=>'646000','first'=>'L','lng'=>'105.43774','lat'=>'28.91308']);
        $this->insert('{{%region}}',['id'=>'2405','pid'=>'2401','shortname'=>'泸县','name'=>'泸县','merger_name'=>'中国,四川省,泸州市,泸县','level'=>'3','pinyin'=>'luxian','code'=>'0830','zip_code'=>'646106','first'=>NULL,'lng'=>'105.38192','lat'=>'29.15041']);
        $this->insert('{{%region}}',['id'=>'2406','pid'=>'2401','shortname'=>'合江','name'=>'合江县','merger_name'=>'中国,四川省,泸州市,合江县','level'=>'3','pinyin'=>'hejiang','code'=>'0830','zip_code'=>'646200','first'=>'H','lng'=>'105.8352','lat'=>'28.81005']);
        $this->insert('{{%region}}',['id'=>'2407','pid'=>'2401','shortname'=>'叙永','name'=>'叙永县','merger_name'=>'中国,四川省,泸州市,叙永县','level'=>'3','pinyin'=>'xuyong','code'=>'0830','zip_code'=>'646400','first'=>'X','lng'=>'105.44473','lat'=>'28.15586']);
        $this->insert('{{%region}}',['id'=>'2408','pid'=>'2401','shortname'=>'古蔺','name'=>'古蔺县','merger_name'=>'中国,四川省,泸州市,古蔺县','level'=>'3','pinyin'=>'gulin','code'=>'0830','zip_code'=>'646500','first'=>'G','lng'=>'105.81347','lat'=>'28.03867']);
        $this->insert('{{%region}}',['id'=>'2409','pid'=>'2367','shortname'=>'德阳','name'=>'德阳市','merger_name'=>'中国,四川省,德阳市','level'=>'2','pinyin'=>'deyang','code'=>'0838','zip_code'=>'618000','first'=>'D','lng'=>'104.398651','lat'=>'31.127991']);
        $this->insert('{{%region}}',['id'=>'2410','pid'=>'2409','shortname'=>'旌阳','name'=>'旌阳区','merger_name'=>'中国,四川省,德阳市,旌阳区','level'=>'3','pinyin'=>'jingyang','code'=>'0838','zip_code'=>'618000','first'=>NULL,'lng'=>'104.39367','lat'=>'31.13906']);
        $this->insert('{{%region}}',['id'=>'2411','pid'=>'2409','shortname'=>'中江','name'=>'中江县','merger_name'=>'中国,四川省,德阳市,中江县','level'=>'3','pinyin'=>'zhongjiang','code'=>'0838','zip_code'=>'618100','first'=>'Z','lng'=>'104.67861','lat'=>'31.03297']);
        $this->insert('{{%region}}',['id'=>'2412','pid'=>'2409','shortname'=>'罗江','name'=>'罗江县','merger_name'=>'中国,四川省,德阳市,罗江县','level'=>'3','pinyin'=>'luojiang','code'=>'0838','zip_code'=>'618500','first'=>'L','lng'=>'104.51025','lat'=>'31.31665']);
        $this->insert('{{%region}}',['id'=>'2413','pid'=>'2409','shortname'=>'广汉','name'=>'广汉市','merger_name'=>'中国,四川省,德阳市,广汉市','level'=>'3','pinyin'=>'guanghan','code'=>'0838','zip_code'=>'618300','first'=>'G','lng'=>'104.28234','lat'=>'30.97686']);
        $this->insert('{{%region}}',['id'=>'2414','pid'=>'2409','shortname'=>'什邡','name'=>'什邡市','merger_name'=>'中国,四川省,德阳市,什邡市','level'=>'3','pinyin'=>'shifang','code'=>'0838','zip_code'=>'618400','first'=>'S','lng'=>'104.16754','lat'=>'31.1264']);
        $this->insert('{{%region}}',['id'=>'2415','pid'=>'2409','shortname'=>'绵竹','name'=>'绵竹市','merger_name'=>'中国,四川省,德阳市,绵竹市','level'=>'3','pinyin'=>'mianzhu','code'=>'0838','zip_code'=>'618200','first'=>'M','lng'=>'104.22076','lat'=>'31.33772']);
        $this->insert('{{%region}}',['id'=>'2416','pid'=>'2367','shortname'=>'绵阳','name'=>'绵阳市','merger_name'=>'中国,四川省,绵阳市','level'=>'2','pinyin'=>'mianyang','code'=>'0816','zip_code'=>'621000','first'=>'M','lng'=>'104.741722','lat'=>'31.46402']);
        $this->insert('{{%region}}',['id'=>'2417','pid'=>'2416','shortname'=>'涪城','name'=>'涪城区','merger_name'=>'中国,四川省,绵阳市,涪城区','level'=>'3','pinyin'=>'fucheng','code'=>'0816','zip_code'=>'621000','first'=>'F','lng'=>'104.75719','lat'=>'31.45522']);
        $this->insert('{{%region}}',['id'=>'2418','pid'=>'2416','shortname'=>'游仙','name'=>'游仙区','merger_name'=>'中国,四川省,绵阳市,游仙区','level'=>'3','pinyin'=>'youxian','code'=>'0816','zip_code'=>'621022','first'=>'Y','lng'=>'104.77092','lat'=>'31.46574']);
        $this->insert('{{%region}}',['id'=>'2419','pid'=>'2416','shortname'=>'三台','name'=>'三台县','merger_name'=>'中国,四川省,绵阳市,三台县','level'=>'3','pinyin'=>'santai','code'=>'0816','zip_code'=>'621100','first'=>'S','lng'=>'105.09079','lat'=>'31.09179']);
        $this->insert('{{%region}}',['id'=>'2420','pid'=>'2416','shortname'=>'盐亭','name'=>'盐亭县','merger_name'=>'中国,四川省,绵阳市,盐亭县','level'=>'3','pinyin'=>'yanting','code'=>'0816','zip_code'=>'621600','first'=>'Y','lng'=>'105.3898','lat'=>'31.22176']);
        $this->insert('{{%region}}',['id'=>'2421','pid'=>'2416','shortname'=>'安县','name'=>'安县','merger_name'=>'中国,四川省,绵阳市,安县','level'=>'3','pinyin'=>'anxian','code'=>'0816','zip_code'=>'622650','first'=>'A','lng'=>'104.56738','lat'=>'31.53487']);
        $this->insert('{{%region}}',['id'=>'2422','pid'=>'2416','shortname'=>'梓潼','name'=>'梓潼县','merger_name'=>'中国,四川省,绵阳市,梓潼县','level'=>'3','pinyin'=>'zitong','code'=>'0816','zip_code'=>'622150','first'=>NULL,'lng'=>'105.16183','lat'=>'31.6359']);
        $this->insert('{{%region}}',['id'=>'2423','pid'=>'2416','shortname'=>'北川','name'=>'北川羌族自治县','merger_name'=>'中国,四川省,绵阳市,北川羌族自治县','level'=>'3','pinyin'=>'beichuan','code'=>'0816','zip_code'=>'622750','first'=>'B','lng'=>'104.46408','lat'=>'31.83286']);
        $this->insert('{{%region}}',['id'=>'2424','pid'=>'2416','shortname'=>'平武','name'=>'平武县','merger_name'=>'中国,四川省,绵阳市,平武县','level'=>'3','pinyin'=>'pingwu','code'=>'0816','zip_code'=>'622550','first'=>'P','lng'=>'104.52862','lat'=>'32.40791']);
        $this->insert('{{%region}}',['id'=>'2425','pid'=>'2416','shortname'=>'江油','name'=>'江油市','merger_name'=>'中国,四川省,绵阳市,江油市','level'=>'3','pinyin'=>'jiangyou','code'=>'0816','zip_code'=>'621700','first'=>'J','lng'=>'104.74539','lat'=>'31.77775']);
        $this->insert('{{%region}}',['id'=>'2426','pid'=>'2367','shortname'=>'广元','name'=>'广元市','merger_name'=>'中国,四川省,广元市','level'=>'2','pinyin'=>'guangyuan','code'=>'0839','zip_code'=>'628000','first'=>'G','lng'=>'105.829757','lat'=>'32.433668']);
        $this->insert('{{%region}}',['id'=>'2427','pid'=>'2426','shortname'=>'利州','name'=>'利州区','merger_name'=>'中国,四川省,广元市,利州区','level'=>'3','pinyin'=>'lizhou','code'=>'0839','zip_code'=>'628017','first'=>'L','lng'=>'105.826194','lat'=>'32.432276']);
        $this->insert('{{%region}}',['id'=>'2428','pid'=>'2426','shortname'=>'昭化','name'=>'昭化区','merger_name'=>'中国,四川省,广元市,昭化区','level'=>'3','pinyin'=>'zhaohua','code'=>'0839','zip_code'=>'628017','first'=>'Z','lng'=>'105.640491','lat'=>'32.386518']);
        $this->insert('{{%region}}',['id'=>'2429','pid'=>'2426','shortname'=>'朝天','name'=>'朝天区','merger_name'=>'中国,四川省,广元市,朝天区','level'=>'3','pinyin'=>'chaotian','code'=>'0839','zip_code'=>'628017','first'=>'C','lng'=>'105.89273','lat'=>'32.64398']);
        $this->insert('{{%region}}',['id'=>'2430','pid'=>'2426','shortname'=>'旺苍','name'=>'旺苍县','merger_name'=>'中国,四川省,广元市,旺苍县','level'=>'3','pinyin'=>'wangcang','code'=>'0839','zip_code'=>'628200','first'=>'W','lng'=>'106.29022','lat'=>'32.22845']);
        $this->insert('{{%region}}',['id'=>'2431','pid'=>'2426','shortname'=>'青川','name'=>'青川县','merger_name'=>'中国,四川省,广元市,青川县','level'=>'3','pinyin'=>'qingchuan','code'=>'0839','zip_code'=>'628100','first'=>'Q','lng'=>'105.2391','lat'=>'32.58563']);
        $this->insert('{{%region}}',['id'=>'2432','pid'=>'2426','shortname'=>'剑阁','name'=>'剑阁县','merger_name'=>'中国,四川省,广元市,剑阁县','level'=>'3','pinyin'=>'jiange','code'=>'0839','zip_code'=>'628300','first'=>'J','lng'=>'105.5252','lat'=>'32.28845']);
        $this->insert('{{%region}}',['id'=>'2433','pid'=>'2426','shortname'=>'苍溪','name'=>'苍溪县','merger_name'=>'中国,四川省,广元市,苍溪县','level'=>'3','pinyin'=>'cangxi','code'=>'0839','zip_code'=>'628400','first'=>'C','lng'=>'105.936','lat'=>'31.73209']);
        $this->insert('{{%region}}',['id'=>'2434','pid'=>'2367','shortname'=>'遂宁','name'=>'遂宁市','merger_name'=>'中国,四川省,遂宁市','level'=>'2','pinyin'=>'suining','code'=>'0825','zip_code'=>'629000','first'=>'S','lng'=>'105.571331','lat'=>'30.513311']);
        $this->insert('{{%region}}',['id'=>'2435','pid'=>'2434','shortname'=>'船山','name'=>'船山区','merger_name'=>'中国,四川省,遂宁市,船山区','level'=>'3','pinyin'=>'chuanshan','code'=>'0825','zip_code'=>'629000','first'=>'C','lng'=>'105.5809','lat'=>'30.49991']);
        $this->insert('{{%region}}',['id'=>'2436','pid'=>'2434','shortname'=>'安居','name'=>'安居区','merger_name'=>'中国,四川省,遂宁市,安居区','level'=>'3','pinyin'=>'anju','code'=>'0825','zip_code'=>'629000','first'=>'A','lng'=>'105.46402','lat'=>'30.35778']);
        $this->insert('{{%region}}',['id'=>'2437','pid'=>'2434','shortname'=>'蓬溪','name'=>'蓬溪县','merger_name'=>'中国,四川省,遂宁市,蓬溪县','level'=>'3','pinyin'=>'pengxi','code'=>'0825','zip_code'=>'629100','first'=>'P','lng'=>'105.70752','lat'=>'30.75775']);
        $this->insert('{{%region}}',['id'=>'2438','pid'=>'2434','shortname'=>'射洪','name'=>'射洪县','merger_name'=>'中国,四川省,遂宁市,射洪县','level'=>'3','pinyin'=>'shehong','code'=>'0825','zip_code'=>'629200','first'=>'S','lng'=>'105.38922','lat'=>'30.87203']);
        $this->insert('{{%region}}',['id'=>'2439','pid'=>'2434','shortname'=>'大英','name'=>'大英县','merger_name'=>'中国,四川省,遂宁市,大英县','level'=>'3','pinyin'=>'daying','code'=>'0825','zip_code'=>'629300','first'=>'D','lng'=>'105.24346','lat'=>'30.59434']);
        $this->insert('{{%region}}',['id'=>'2440','pid'=>'2367','shortname'=>'内江','name'=>'内江市','merger_name'=>'中国,四川省,内江市','level'=>'2','pinyin'=>'neijiang','code'=>'0832','zip_code'=>'641000','first'=>'N','lng'=>'105.066138','lat'=>'29.58708']);
        $this->insert('{{%region}}',['id'=>'2441','pid'=>'2440','shortname'=>'市中区','name'=>'市中区','merger_name'=>'中国,四川省,内江市,市中区','level'=>'3','pinyin'=>'shizhongqu','code'=>'0832','zip_code'=>'641000','first'=>'S','lng'=>'105.0679','lat'=>'29.58709']);
        $this->insert('{{%region}}',['id'=>'2442','pid'=>'2440','shortname'=>'东兴','name'=>'东兴区','merger_name'=>'中国,四川省,内江市,东兴区','level'=>'3','pinyin'=>'dongxing','code'=>'0832','zip_code'=>'641100','first'=>'D','lng'=>'105.07554','lat'=>'29.59278']);
        $this->insert('{{%region}}',['id'=>'2443','pid'=>'2440','shortname'=>'威远','name'=>'威远县','merger_name'=>'中国,四川省,内江市,威远县','level'=>'3','pinyin'=>'weiyuan','code'=>'0832','zip_code'=>'642450','first'=>'W','lng'=>'104.66955','lat'=>'29.52823']);
        $this->insert('{{%region}}',['id'=>'2444','pid'=>'2440','shortname'=>'资中','name'=>'资中县','merger_name'=>'中国,四川省,内江市,资中县','level'=>'3','pinyin'=>'zizhong','code'=>'0832','zip_code'=>'641200','first'=>'Z','lng'=>'104.85205','lat'=>'29.76409']);
        $this->insert('{{%region}}',['id'=>'2445','pid'=>'2440','shortname'=>'隆昌','name'=>'隆昌县','merger_name'=>'中国,四川省,内江市,隆昌县','level'=>'3','pinyin'=>'longchang','code'=>'0832','zip_code'=>'642150','first'=>'L','lng'=>'105.28738','lat'=>'29.33937']);
        $this->insert('{{%region}}',['id'=>'2446','pid'=>'2367','shortname'=>'乐山','name'=>'乐山市','merger_name'=>'中国,四川省,乐山市','level'=>'2','pinyin'=>'leshan','code'=>'0833','zip_code'=>'614000','first'=>'L','lng'=>'103.761263','lat'=>'29.582024']);
        $this->insert('{{%region}}',['id'=>'2447','pid'=>'2446','shortname'=>'市中区','name'=>'市中区','merger_name'=>'中国,四川省,乐山市,市中区','level'=>'3','pinyin'=>'shizhongqu','code'=>'0833','zip_code'=>'614000','first'=>'S','lng'=>'103.76159','lat'=>'29.55543']);
        $this->insert('{{%region}}',['id'=>'2448','pid'=>'2446','shortname'=>'沙湾','name'=>'沙湾区','merger_name'=>'中国,四川省,乐山市,沙湾区','level'=>'3','pinyin'=>'shawan','code'=>'0833','zip_code'=>'614900','first'=>'S','lng'=>'103.54873','lat'=>'29.41194']);
        $this->insert('{{%region}}',['id'=>'2449','pid'=>'2446','shortname'=>'五通桥','name'=>'五通桥区','merger_name'=>'中国,四川省,乐山市,五通桥区','level'=>'3','pinyin'=>'wutongqiao','code'=>'0833','zip_code'=>'614800','first'=>'W','lng'=>'103.82345','lat'=>'29.40344']);
        $this->insert('{{%region}}',['id'=>'2450','pid'=>'2446','shortname'=>'金口河','name'=>'金口河区','merger_name'=>'中国,四川省,乐山市,金口河区','level'=>'3','pinyin'=>'jinkouhe','code'=>'0833','zip_code'=>'614700','first'=>'J','lng'=>'103.07858','lat'=>'29.24578']);
        $this->insert('{{%region}}',['id'=>'2451','pid'=>'2446','shortname'=>'犍为','name'=>'犍为县','merger_name'=>'中国,四川省,乐山市,犍为县','level'=>'3','pinyin'=>'qianwei','code'=>'0833','zip_code'=>'614400','first'=>NULL,'lng'=>'103.94989','lat'=>'29.20973']);
        $this->insert('{{%region}}',['id'=>'2452','pid'=>'2446','shortname'=>'井研','name'=>'井研县','merger_name'=>'中国,四川省,乐山市,井研县','level'=>'3','pinyin'=>'jingyan','code'=>'0833','zip_code'=>'613100','first'=>'J','lng'=>'104.07019','lat'=>'29.65228']);
        $this->insert('{{%region}}',['id'=>'2453','pid'=>'2446','shortname'=>'夹江','name'=>'夹江县','merger_name'=>'中国,四川省,乐山市,夹江县','level'=>'3','pinyin'=>'jiajiang','code'=>'0833','zip_code'=>'614100','first'=>'J','lng'=>'103.57199','lat'=>'29.73868']);
        $this->insert('{{%region}}',['id'=>'2454','pid'=>'2446','shortname'=>'沐川','name'=>'沐川县','merger_name'=>'中国,四川省,乐山市,沐川县','level'=>'3','pinyin'=>'muchuan','code'=>'0833','zip_code'=>'614500','first'=>NULL,'lng'=>'103.90353','lat'=>'28.95646']);
        $this->insert('{{%region}}',['id'=>'2455','pid'=>'2446','shortname'=>'峨边','name'=>'峨边彝族自治县','merger_name'=>'中国,四川省,乐山市,峨边彝族自治县','level'=>'3','pinyin'=>'ebian','code'=>'0833','zip_code'=>'614300','first'=>'E','lng'=>'103.26339','lat'=>'29.23004']);
        $this->insert('{{%region}}',['id'=>'2456','pid'=>'2446','shortname'=>'马边','name'=>'马边彝族自治县','merger_name'=>'中国,四川省,乐山市,马边彝族自治县','level'=>'3','pinyin'=>'mabian','code'=>'0833','zip_code'=>'614600','first'=>'M','lng'=>'103.54617','lat'=>'28.83593']);
        $this->insert('{{%region}}',['id'=>'2457','pid'=>'2446','shortname'=>'峨眉山','name'=>'峨眉山市','merger_name'=>'中国,四川省,乐山市,峨眉山市','level'=>'3','pinyin'=>'emeishan','code'=>'0833','zip_code'=>'614200','first'=>'E','lng'=>'103.4844','lat'=>'29.60117']);
        $this->insert('{{%region}}',['id'=>'2458','pid'=>'2367','shortname'=>'南充','name'=>'南充市','merger_name'=>'中国,四川省,南充市','level'=>'2','pinyin'=>'nanchong','code'=>'0817','zip_code'=>'637000','first'=>'N','lng'=>'106.082974','lat'=>'30.795281']);
        $this->insert('{{%region}}',['id'=>'2459','pid'=>'2458','shortname'=>'顺庆','name'=>'顺庆区','merger_name'=>'中国,四川省,南充市,顺庆区','level'=>'3','pinyin'=>'shunqing','code'=>'0817','zip_code'=>'637000','first'=>'S','lng'=>'106.09216','lat'=>'30.79642']);
        $this->insert('{{%region}}',['id'=>'2460','pid'=>'2458','shortname'=>'高坪','name'=>'高坪区','merger_name'=>'中国,四川省,南充市,高坪区','level'=>'3','pinyin'=>'gaoping','code'=>'0817','zip_code'=>'637100','first'=>'G','lng'=>'106.11894','lat'=>'30.78162']);
        $this->insert('{{%region}}',['id'=>'2461','pid'=>'2458','shortname'=>'嘉陵','name'=>'嘉陵区','merger_name'=>'中国,四川省,南充市,嘉陵区','level'=>'3','pinyin'=>'jialing','code'=>'0817','zip_code'=>'637100','first'=>'J','lng'=>'106.07141','lat'=>'30.75848']);
        $this->insert('{{%region}}',['id'=>'2462','pid'=>'2458','shortname'=>'南部','name'=>'南部县','merger_name'=>'中国,四川省,南充市,南部县','level'=>'3','pinyin'=>'nanbu','code'=>'0817','zip_code'=>'637300','first'=>'N','lng'=>'106.06738','lat'=>'31.35451']);
        $this->insert('{{%region}}',['id'=>'2463','pid'=>'2458','shortname'=>'营山','name'=>'营山县','merger_name'=>'中国,四川省,南充市,营山县','level'=>'3','pinyin'=>'yingshan','code'=>'0817','zip_code'=>'637700','first'=>'Y','lng'=>'106.56637','lat'=>'31.07747']);
        $this->insert('{{%region}}',['id'=>'2464','pid'=>'2458','shortname'=>'蓬安','name'=>'蓬安县','merger_name'=>'中国,四川省,南充市,蓬安县','level'=>'3','pinyin'=>'peng\'an','code'=>'0817','zip_code'=>'637800','first'=>'P','lng'=>'106.41262','lat'=>'31.02964']);
        $this->insert('{{%region}}',['id'=>'2465','pid'=>'2458','shortname'=>'仪陇','name'=>'仪陇县','merger_name'=>'中国,四川省,南充市,仪陇县','level'=>'3','pinyin'=>'yilong','code'=>'0817','zip_code'=>'637600','first'=>'Y','lng'=>'106.29974','lat'=>'31.27628']);
        $this->insert('{{%region}}',['id'=>'2466','pid'=>'2458','shortname'=>'西充','name'=>'西充县','merger_name'=>'中国,四川省,南充市,西充县','level'=>'3','pinyin'=>'xichong','code'=>'0817','zip_code'=>'637200','first'=>'X','lng'=>'105.89996','lat'=>'30.9969']);
        $this->insert('{{%region}}',['id'=>'2467','pid'=>'2458','shortname'=>'阆中','name'=>'阆中市','merger_name'=>'中国,四川省,南充市,阆中市','level'=>'3','pinyin'=>'langzhong','code'=>'0817','zip_code'=>'637400','first'=>NULL,'lng'=>'106.00494','lat'=>'31.55832']);
        $this->insert('{{%region}}',['id'=>'2468','pid'=>'2367','shortname'=>'眉山','name'=>'眉山市','merger_name'=>'中国,四川省,眉山市','level'=>'2','pinyin'=>'meishan','code'=>'028','zip_code'=>'620020','first'=>'M','lng'=>'103.831788','lat'=>'30.048318']);
        $this->insert('{{%region}}',['id'=>'2469','pid'=>'2468','shortname'=>'东坡','name'=>'东坡区','merger_name'=>'中国,四川省,眉山市,东坡区','level'=>'3','pinyin'=>'dongpo','code'=>'028','zip_code'=>'620010','first'=>'D','lng'=>'103.832','lat'=>'30.04219']);
        $this->insert('{{%region}}',['id'=>'2470','pid'=>'2468','shortname'=>'彭山','name'=>'彭山区','merger_name'=>'中国,四川省,眉山市,彭山区','level'=>'3','pinyin'=>'pengshan','code'=>'028','zip_code'=>'620860','first'=>'P','lng'=>'103.87268','lat'=>'30.19283']);
        $this->insert('{{%region}}',['id'=>'2471','pid'=>'2468','shortname'=>'仁寿','name'=>'仁寿县','merger_name'=>'中国,四川省,眉山市,仁寿县','level'=>'3','pinyin'=>'renshou','code'=>'028','zip_code'=>'620500','first'=>'R','lng'=>'104.13412','lat'=>'29.99599']);
        $this->insert('{{%region}}',['id'=>'2472','pid'=>'2468','shortname'=>'洪雅','name'=>'洪雅县','merger_name'=>'中国,四川省,眉山市,洪雅县','level'=>'3','pinyin'=>'hongya','code'=>'028','zip_code'=>'620360','first'=>'H','lng'=>'103.37313','lat'=>'29.90661']);
        $this->insert('{{%region}}',['id'=>'2473','pid'=>'2468','shortname'=>'丹棱','name'=>'丹棱县','merger_name'=>'中国,四川省,眉山市,丹棱县','level'=>'3','pinyin'=>'danling','code'=>'028','zip_code'=>'620200','first'=>'D','lng'=>'103.51339','lat'=>'30.01562']);
        $this->insert('{{%region}}',['id'=>'2474','pid'=>'2468','shortname'=>'青神','name'=>'青神县','merger_name'=>'中国,四川省,眉山市,青神县','level'=>'3','pinyin'=>'qingshen','code'=>'028','zip_code'=>'620460','first'=>'Q','lng'=>'103.84771','lat'=>'29.83235']);
        $this->insert('{{%region}}',['id'=>'2475','pid'=>'2367','shortname'=>'宜宾','name'=>'宜宾市','merger_name'=>'中国,四川省,宜宾市','level'=>'2','pinyin'=>'yibin','code'=>'0831','zip_code'=>'644000','first'=>'Y','lng'=>'104.630825','lat'=>'28.760189']);
        $this->insert('{{%region}}',['id'=>'2476','pid'=>'2475','shortname'=>'翠屏','name'=>'翠屏区','merger_name'=>'中国,四川省,宜宾市,翠屏区','level'=>'3','pinyin'=>'cuiping','code'=>'0831','zip_code'=>'644000','first'=>'C','lng'=>'104.61978','lat'=>'28.76566']);
        $this->insert('{{%region}}',['id'=>'2477','pid'=>'2475','shortname'=>'南溪','name'=>'南溪区','merger_name'=>'中国,四川省,宜宾市,南溪区','level'=>'3','pinyin'=>'nanxi','code'=>'0831','zip_code'=>'644100','first'=>'N','lng'=>'104.981133','lat'=>'28.839806']);
        $this->insert('{{%region}}',['id'=>'2478','pid'=>'2475','shortname'=>'宜宾','name'=>'宜宾县','merger_name'=>'中国,四川省,宜宾市,宜宾县','level'=>'3','pinyin'=>'yibin','code'=>'0831','zip_code'=>'644600','first'=>'Y','lng'=>'104.53314','lat'=>'28.68996']);
        $this->insert('{{%region}}',['id'=>'2479','pid'=>'2475','shortname'=>'江安','name'=>'江安县','merger_name'=>'中国,四川省,宜宾市,江安县','level'=>'3','pinyin'=>'jiang\'an','code'=>'0831','zip_code'=>'644200','first'=>'J','lng'=>'105.06683','lat'=>'28.72385']);
        $this->insert('{{%region}}',['id'=>'2480','pid'=>'2475','shortname'=>'长宁','name'=>'长宁县','merger_name'=>'中国,四川省,宜宾市,长宁县','level'=>'3','pinyin'=>'changning','code'=>'0831','zip_code'=>'644300','first'=>'C','lng'=>'104.9252','lat'=>'28.57777']);
        $this->insert('{{%region}}',['id'=>'2481','pid'=>'2475','shortname'=>'高县','name'=>'高县','merger_name'=>'中国,四川省,宜宾市,高县','level'=>'3','pinyin'=>'gaoxian','code'=>'0831','zip_code'=>'645150','first'=>'G','lng'=>'104.51754','lat'=>'28.43619']);
        $this->insert('{{%region}}',['id'=>'2482','pid'=>'2475','shortname'=>'珙县','name'=>'珙县','merger_name'=>'中国,四川省,宜宾市,珙县','level'=>'3','pinyin'=>'gongxian','code'=>'0831','zip_code'=>'644500','first'=>NULL,'lng'=>'104.71398','lat'=>'28.44512']);
        $this->insert('{{%region}}',['id'=>'2483','pid'=>'2475','shortname'=>'筠连','name'=>'筠连县','merger_name'=>'中国,四川省,宜宾市,筠连县','level'=>'3','pinyin'=>'junlian','code'=>'0831','zip_code'=>'645250','first'=>NULL,'lng'=>'104.51217','lat'=>'28.16495']);
        $this->insert('{{%region}}',['id'=>'2484','pid'=>'2475','shortname'=>'兴文','name'=>'兴文县','merger_name'=>'中国,四川省,宜宾市,兴文县','level'=>'3','pinyin'=>'xingwen','code'=>'0831','zip_code'=>'644400','first'=>'X','lng'=>'105.23675','lat'=>'28.3044']);
        $this->insert('{{%region}}',['id'=>'2485','pid'=>'2475','shortname'=>'屏山','name'=>'屏山县','merger_name'=>'中国,四川省,宜宾市,屏山县','level'=>'3','pinyin'=>'pingshan','code'=>'0831','zip_code'=>'645350','first'=>'P','lng'=>'104.16293','lat'=>'28.64369']);
        $this->insert('{{%region}}',['id'=>'2486','pid'=>'2367','shortname'=>'广安','name'=>'广安市','merger_name'=>'中国,四川省,广安市','level'=>'2','pinyin'=>'guang\'an','code'=>'0826','zip_code'=>'638000','first'=>'G','lng'=>'106.633369','lat'=>'30.456398']);
        $this->insert('{{%region}}',['id'=>'2487','pid'=>'2486','shortname'=>'广安','name'=>'广安区','merger_name'=>'中国,四川省,广安市,广安区','level'=>'3','pinyin'=>'guang\'an','code'=>'0826','zip_code'=>'638000','first'=>'G','lng'=>'106.64163','lat'=>'30.47389']);
        $this->insert('{{%region}}',['id'=>'2488','pid'=>'2486','shortname'=>'前锋','name'=>'前锋区','merger_name'=>'中国,四川省,广安市,前锋区','level'=>'3','pinyin'=>'qianfeng','code'=>'0826','zip_code'=>'638019','first'=>'Q','lng'=>'106.893537','lat'=>'30.494572']);
        $this->insert('{{%region}}',['id'=>'2489','pid'=>'2486','shortname'=>'岳池','name'=>'岳池县','merger_name'=>'中国,四川省,广安市,岳池县','level'=>'3','pinyin'=>'yuechi','code'=>'0826','zip_code'=>'638300','first'=>'Y','lng'=>'106.44079','lat'=>'30.53918']);
        $this->insert('{{%region}}',['id'=>'2490','pid'=>'2486','shortname'=>'武胜','name'=>'武胜县','merger_name'=>'中国,四川省,广安市,武胜县','level'=>'3','pinyin'=>'wusheng','code'=>'0826','zip_code'=>'638400','first'=>'W','lng'=>'106.29592','lat'=>'30.34932']);
        $this->insert('{{%region}}',['id'=>'2491','pid'=>'2486','shortname'=>'邻水','name'=>'邻水县','merger_name'=>'中国,四川省,广安市,邻水县','level'=>'3','pinyin'=>'linshui','code'=>'0826','zip_code'=>'638500','first'=>'L','lng'=>'106.92968','lat'=>'30.33449']);
        $this->insert('{{%region}}',['id'=>'2492','pid'=>'2486','shortname'=>'华蓥','name'=>'华蓥市','merger_name'=>'中国,四川省,广安市,华蓥市','level'=>'3','pinyin'=>'huaying','code'=>'0826','zip_code'=>'638600','first'=>'H','lng'=>'106.78466','lat'=>'30.39007']);
        $this->insert('{{%region}}',['id'=>'2493','pid'=>'2367','shortname'=>'达州','name'=>'达州市','merger_name'=>'中国,四川省,达州市','level'=>'2','pinyin'=>'dazhou','code'=>'0818','zip_code'=>'635000','first'=>'D','lng'=>'107.502262','lat'=>'31.209484']);
        $this->insert('{{%region}}',['id'=>'2494','pid'=>'2493','shortname'=>'通川','name'=>'通川区','merger_name'=>'中国,四川省,达州市,通川区','level'=>'3','pinyin'=>'tongchuan','code'=>'0818','zip_code'=>'635000','first'=>'T','lng'=>'107.50456','lat'=>'31.21469']);
        $this->insert('{{%region}}',['id'=>'2495','pid'=>'2493','shortname'=>'达川','name'=>'达川区','merger_name'=>'中国,四川省,达州市,达川区','level'=>'3','pinyin'=>'dachuan','code'=>'0818','zip_code'=>'635000','first'=>'D','lng'=>'107.502262','lat'=>'31.209484']);
        $this->insert('{{%region}}',['id'=>'2496','pid'=>'2493','shortname'=>'宣汉','name'=>'宣汉县','merger_name'=>'中国,四川省,达州市,宣汉县','level'=>'3','pinyin'=>'xuanhan','code'=>'0818','zip_code'=>'636150','first'=>'X','lng'=>'107.72775','lat'=>'31.35516']);
        $this->insert('{{%region}}',['id'=>'2497','pid'=>'2493','shortname'=>'开江','name'=>'开江县','merger_name'=>'中国,四川省,达州市,开江县','level'=>'3','pinyin'=>'kaijiang','code'=>'0818','zip_code'=>'636250','first'=>'K','lng'=>'107.86889','lat'=>'31.0841']);
        $this->insert('{{%region}}',['id'=>'2498','pid'=>'2493','shortname'=>'大竹','name'=>'大竹县','merger_name'=>'中国,四川省,达州市,大竹县','level'=>'3','pinyin'=>'dazhu','code'=>'0818','zip_code'=>'635100','first'=>'D','lng'=>'107.20855','lat'=>'30.74147']);
        $this->insert('{{%region}}',['id'=>'2499','pid'=>'2493','shortname'=>'渠县','name'=>'渠县','merger_name'=>'中国,四川省,达州市,渠县','level'=>'3','pinyin'=>'quxian','code'=>'0818','zip_code'=>'635200','first'=>'Q','lng'=>'106.97381','lat'=>'30.8376']);
        $this->insert('{{%region}}',['id'=>'2500','pid'=>'2493','shortname'=>'万源','name'=>'万源市','merger_name'=>'中国,四川省,达州市,万源市','level'=>'3','pinyin'=>'wanyuan','code'=>'0818','zip_code'=>'636350','first'=>'W','lng'=>'108.03598','lat'=>'32.08091']);
        $this->insert('{{%region}}',['id'=>'2501','pid'=>'2367','shortname'=>'雅安','name'=>'雅安市','merger_name'=>'中国,四川省,雅安市','level'=>'2','pinyin'=>'ya\'an','code'=>'0835','zip_code'=>'625000','first'=>'Y','lng'=>'103.001033','lat'=>'29.987722']);
        $this->insert('{{%region}}',['id'=>'2502','pid'=>'2501','shortname'=>'雨城','name'=>'雨城区','merger_name'=>'中国,四川省,雅安市,雨城区','level'=>'3','pinyin'=>'yucheng','code'=>'0835','zip_code'=>'625000','first'=>'Y','lng'=>'103.03305','lat'=>'30.00531']);
        $this->insert('{{%region}}',['id'=>'2503','pid'=>'2501','shortname'=>'名山','name'=>'名山区','merger_name'=>'中国,四川省,雅安市,名山区','level'=>'3','pinyin'=>'mingshan','code'=>'0835','zip_code'=>'625100','first'=>'M','lng'=>'103.112214','lat'=>'30.084718']);
        $this->insert('{{%region}}',['id'=>'2504','pid'=>'2501','shortname'=>'荥经','name'=>'荥经县','merger_name'=>'中国,四川省,雅安市,荥经县','level'=>'3','pinyin'=>'yingjing','code'=>'0835','zip_code'=>'625200','first'=>NULL,'lng'=>'102.84652','lat'=>'29.79402']);
        $this->insert('{{%region}}',['id'=>'2505','pid'=>'2501','shortname'=>'汉源','name'=>'汉源县','merger_name'=>'中国,四川省,雅安市,汉源县','level'=>'3','pinyin'=>'hanyuan','code'=>'0835','zip_code'=>'625300','first'=>'H','lng'=>'102.6784','lat'=>'29.35168']);
        $this->insert('{{%region}}',['id'=>'2506','pid'=>'2501','shortname'=>'石棉','name'=>'石棉县','merger_name'=>'中国,四川省,雅安市,石棉县','level'=>'3','pinyin'=>'shimian','code'=>'0835','zip_code'=>'625400','first'=>'S','lng'=>'102.35943','lat'=>'29.22796']);
        $this->insert('{{%region}}',['id'=>'2507','pid'=>'2501','shortname'=>'天全','name'=>'天全县','merger_name'=>'中国,四川省,雅安市,天全县','level'=>'3','pinyin'=>'tianquan','code'=>'0835','zip_code'=>'625500','first'=>'T','lng'=>'102.75906','lat'=>'30.06754']);
        $this->insert('{{%region}}',['id'=>'2508','pid'=>'2501','shortname'=>'芦山','name'=>'芦山县','merger_name'=>'中国,四川省,雅安市,芦山县','level'=>'3','pinyin'=>'lushan','code'=>'0835','zip_code'=>'625600','first'=>'L','lng'=>'102.92791','lat'=>'30.14369']);
        $this->insert('{{%region}}',['id'=>'2509','pid'=>'2501','shortname'=>'宝兴','name'=>'宝兴县','merger_name'=>'中国,四川省,雅安市,宝兴县','level'=>'3','pinyin'=>'baoxing','code'=>'0835','zip_code'=>'625700','first'=>'B','lng'=>'102.81555','lat'=>'30.36836']);
        $this->insert('{{%region}}',['id'=>'2510','pid'=>'2367','shortname'=>'巴中','name'=>'巴中市','merger_name'=>'中国,四川省,巴中市','level'=>'2','pinyin'=>'bazhong','code'=>'0827','zip_code'=>'636000','first'=>'B','lng'=>'106.753669','lat'=>'31.858809']);
        $this->insert('{{%region}}',['id'=>'2511','pid'=>'2510','shortname'=>'巴州','name'=>'巴州区','merger_name'=>'中国,四川省,巴中市,巴州区','level'=>'3','pinyin'=>'bazhou','code'=>'0827','zip_code'=>'636001','first'=>'B','lng'=>'106.76889','lat'=>'31.85125']);
        $this->insert('{{%region}}',['id'=>'2512','pid'=>'2510','shortname'=>'恩阳','name'=>'恩阳区','merger_name'=>'中国,四川省,巴中市,恩阳区','level'=>'3','pinyin'=>'enyang','code'=>'0827','zip_code'=>'636064','first'=>'E','lng'=>'106.753669','lat'=>'31.858809']);
        $this->insert('{{%region}}',['id'=>'2513','pid'=>'2510','shortname'=>'通江','name'=>'通江县','merger_name'=>'中国,四川省,巴中市,通江县','level'=>'3','pinyin'=>'tongjiang','code'=>'0827','zip_code'=>'636700','first'=>'T','lng'=>'107.24398','lat'=>'31.91294']);
        $this->insert('{{%region}}',['id'=>'2514','pid'=>'2510','shortname'=>'南江','name'=>'南江县','merger_name'=>'中国,四川省,巴中市,南江县','level'=>'3','pinyin'=>'nanjiang','code'=>'0827','zip_code'=>'636600','first'=>'N','lng'=>'106.84164','lat'=>'32.35335']);
        $this->insert('{{%region}}',['id'=>'2515','pid'=>'2510','shortname'=>'平昌','name'=>'平昌县','merger_name'=>'中国,四川省,巴中市,平昌县','level'=>'3','pinyin'=>'pingchang','code'=>'0827','zip_code'=>'636400','first'=>'P','lng'=>'107.10424','lat'=>'31.5594']);
        $this->insert('{{%region}}',['id'=>'2516','pid'=>'2367','shortname'=>'资阳','name'=>'资阳市','merger_name'=>'中国,四川省,资阳市','level'=>'2','pinyin'=>'ziyang','code'=>'028','zip_code'=>'641300','first'=>'Z','lng'=>'104.641917','lat'=>'30.122211']);
        $this->insert('{{%region}}',['id'=>'2517','pid'=>'2516','shortname'=>'雁江','name'=>'雁江区','merger_name'=>'中国,四川省,资阳市,雁江区','level'=>'3','pinyin'=>'yanjiang','code'=>'028','zip_code'=>'641300','first'=>'Y','lng'=>'104.65216','lat'=>'30.11525']);
        $this->insert('{{%region}}',['id'=>'2518','pid'=>'2516','shortname'=>'安岳','name'=>'安岳县','merger_name'=>'中国,四川省,资阳市,安岳县','level'=>'3','pinyin'=>'anyue','code'=>'028','zip_code'=>'642350','first'=>'A','lng'=>'105.3363','lat'=>'30.09786']);
        $this->insert('{{%region}}',['id'=>'2519','pid'=>'2516','shortname'=>'乐至','name'=>'乐至县','merger_name'=>'中国,四川省,资阳市,乐至县','level'=>'3','pinyin'=>'lezhi','code'=>'028','zip_code'=>'641500','first'=>'L','lng'=>'105.03207','lat'=>'30.27227']);
        $this->insert('{{%region}}',['id'=>'2520','pid'=>'2516','shortname'=>'简阳','name'=>'简阳市','merger_name'=>'中国,四川省,资阳市,简阳市','level'=>'3','pinyin'=>'jianyang','code'=>'028','zip_code'=>'641400','first'=>'J','lng'=>'104.54864','lat'=>'30.3904']);
        $this->insert('{{%region}}',['id'=>'2521','pid'=>'2367','shortname'=>'阿坝','name'=>'阿坝藏族羌族自治州','merger_name'=>'中国,四川省,阿坝藏族羌族自治州','level'=>'2','pinyin'=>'aba','code'=>'0837','zip_code'=>'624000','first'=>'A','lng'=>'102.221374','lat'=>'31.899792']);
        $this->insert('{{%region}}',['id'=>'2522','pid'=>'2521','shortname'=>'汶川','name'=>'汶川县','merger_name'=>'中国,四川省,阿坝藏族羌族自治州,汶川县','level'=>'3','pinyin'=>'wenchuan','code'=>'0837','zip_code'=>'623000','first'=>NULL,'lng'=>'103.59079','lat'=>'31.47326']);
        $this->insert('{{%region}}',['id'=>'2523','pid'=>'2521','shortname'=>'理县','name'=>'理县','merger_name'=>'中国,四川省,阿坝藏族羌族自治州,理县','level'=>'3','pinyin'=>'lixian','code'=>'0837','zip_code'=>'623100','first'=>'L','lng'=>'103.17175','lat'=>'31.43603']);
        $this->insert('{{%region}}',['id'=>'2524','pid'=>'2521','shortname'=>'茂县','name'=>'茂县','merger_name'=>'中国,四川省,阿坝藏族羌族自治州,茂县','level'=>'3','pinyin'=>'maoxian','code'=>'0837','zip_code'=>'623200','first'=>'M','lng'=>'103.85372','lat'=>'31.682']);
        $this->insert('{{%region}}',['id'=>'2525','pid'=>'2521','shortname'=>'松潘','name'=>'松潘县','merger_name'=>'中国,四川省,阿坝藏族羌族自治州,松潘县','level'=>'3','pinyin'=>'songpan','code'=>'0837','zip_code'=>'623300','first'=>'S','lng'=>'103.59924','lat'=>'32.63871']);
        $this->insert('{{%region}}',['id'=>'2526','pid'=>'2521','shortname'=>'九寨沟','name'=>'九寨沟县','merger_name'=>'中国,四川省,阿坝藏族羌族自治州,九寨沟县','level'=>'3','pinyin'=>'jiuzhaigou','code'=>'0837','zip_code'=>'623400','first'=>'J','lng'=>'104.23672','lat'=>'33.26318']);
        $this->insert('{{%region}}',['id'=>'2527','pid'=>'2521','shortname'=>'金川','name'=>'金川县','merger_name'=>'中国,四川省,阿坝藏族羌族自治州,金川县','level'=>'3','pinyin'=>'jinchuan','code'=>'0837','zip_code'=>'624100','first'=>'J','lng'=>'102.06555','lat'=>'31.47623']);
        $this->insert('{{%region}}',['id'=>'2528','pid'=>'2521','shortname'=>'小金','name'=>'小金县','merger_name'=>'中国,四川省,阿坝藏族羌族自治州,小金县','level'=>'3','pinyin'=>'xiaojin','code'=>'0837','zip_code'=>'624200','first'=>'X','lng'=>'102.36499','lat'=>'30.99934']);
        $this->insert('{{%region}}',['id'=>'2529','pid'=>'2521','shortname'=>'黑水','name'=>'黑水县','merger_name'=>'中国,四川省,阿坝藏族羌族自治州,黑水县','level'=>'3','pinyin'=>'heishui','code'=>'0837','zip_code'=>'623500','first'=>'H','lng'=>'102.99176','lat'=>'32.06184']);
        $this->insert('{{%region}}',['id'=>'2530','pid'=>'2521','shortname'=>'马尔康','name'=>'马尔康县','merger_name'=>'中国,四川省,阿坝藏族羌族自治州,马尔康县','level'=>'3','pinyin'=>'maerkang','code'=>'0837','zip_code'=>'624000','first'=>'M','lng'=>'102.20625','lat'=>'31.90584']);
        $this->insert('{{%region}}',['id'=>'2531','pid'=>'2521','shortname'=>'壤塘','name'=>'壤塘县','merger_name'=>'中国,四川省,阿坝藏族羌族自治州,壤塘县','level'=>'3','pinyin'=>'rangtang','code'=>'0837','zip_code'=>'624300','first'=>'R','lng'=>'100.9783','lat'=>'32.26578']);
        $this->insert('{{%region}}',['id'=>'2532','pid'=>'2521','shortname'=>'阿坝','name'=>'阿坝县','merger_name'=>'中国,四川省,阿坝藏族羌族自治州,阿坝县','level'=>'3','pinyin'=>'aba','code'=>'0837','zip_code'=>'624600','first'=>'A','lng'=>'101.70632','lat'=>'32.90301']);
        $this->insert('{{%region}}',['id'=>'2533','pid'=>'2521','shortname'=>'若尔盖','name'=>'若尔盖县','merger_name'=>'中国,四川省,阿坝藏族羌族自治州,若尔盖县','level'=>'3','pinyin'=>'ruoergai','code'=>'0837','zip_code'=>'624500','first'=>'R','lng'=>'102.9598','lat'=>'33.57432']);
        $this->insert('{{%region}}',['id'=>'2534','pid'=>'2521','shortname'=>'红原','name'=>'红原县','merger_name'=>'中国,四川省,阿坝藏族羌族自治州,红原县','level'=>'3','pinyin'=>'hongyuan','code'=>'0837','zip_code'=>'624400','first'=>'H','lng'=>'102.54525','lat'=>'32.78989']);
        $this->insert('{{%region}}',['id'=>'2535','pid'=>'2367','shortname'=>'甘孜','name'=>'甘孜藏族自治州','merger_name'=>'中国,四川省,甘孜藏族自治州','level'=>'2','pinyin'=>'garze','code'=>'0836','zip_code'=>'626000','first'=>'G','lng'=>'101.963815','lat'=>'30.050663']);
        $this->insert('{{%region}}',['id'=>'2536','pid'=>'2535','shortname'=>'康定','name'=>'康定县','merger_name'=>'中国,四川省,甘孜藏族自治州,康定县','level'=>'3','pinyin'=>'kangding','code'=>'0836','zip_code'=>'626000','first'=>'K','lng'=>'101.96487','lat'=>'30.05532']);
        $this->insert('{{%region}}',['id'=>'2537','pid'=>'2535','shortname'=>'泸定','name'=>'泸定县','merger_name'=>'中国,四川省,甘孜藏族自治州,泸定县','level'=>'3','pinyin'=>'luding','code'=>'0836','zip_code'=>'626100','first'=>NULL,'lng'=>'102.23507','lat'=>'29.91475']);
        $this->insert('{{%region}}',['id'=>'2538','pid'=>'2535','shortname'=>'丹巴','name'=>'丹巴县','merger_name'=>'中国,四川省,甘孜藏族自治州,丹巴县','level'=>'3','pinyin'=>'danba','code'=>'0836','zip_code'=>'626300','first'=>'D','lng'=>'101.88424','lat'=>'30.87656']);
        $this->insert('{{%region}}',['id'=>'2539','pid'=>'2535','shortname'=>'九龙','name'=>'九龙县','merger_name'=>'中国,四川省,甘孜藏族自治州,九龙县','level'=>'3','pinyin'=>'jiulong','code'=>'0836','zip_code'=>'626200','first'=>'J','lng'=>'101.50848','lat'=>'29.00091']);
        $this->insert('{{%region}}',['id'=>'2540','pid'=>'2535','shortname'=>'雅江','name'=>'雅江县','merger_name'=>'中国,四川省,甘孜藏族自治州,雅江县','level'=>'3','pinyin'=>'yajiang','code'=>'0836','zip_code'=>'627450','first'=>'Y','lng'=>'101.01492','lat'=>'30.03281']);
        $this->insert('{{%region}}',['id'=>'2541','pid'=>'2535','shortname'=>'道孚','name'=>'道孚县','merger_name'=>'中国,四川省,甘孜藏族自治州,道孚县','level'=>'3','pinyin'=>'daofu','code'=>'0836','zip_code'=>'626400','first'=>'D','lng'=>'101.12554','lat'=>'30.98046']);
        $this->insert('{{%region}}',['id'=>'2542','pid'=>'2535','shortname'=>'炉霍','name'=>'炉霍县','merger_name'=>'中国,四川省,甘孜藏族自治州,炉霍县','level'=>'3','pinyin'=>'luhuo','code'=>'0836','zip_code'=>'626500','first'=>'L','lng'=>'100.67681','lat'=>'31.3917']);
        $this->insert('{{%region}}',['id'=>'2543','pid'=>'2535','shortname'=>'甘孜','name'=>'甘孜县','merger_name'=>'中国,四川省,甘孜藏族自治州,甘孜县','level'=>'3','pinyin'=>'ganzi','code'=>'0836','zip_code'=>'626700','first'=>'G','lng'=>'99.99307','lat'=>'31.62672']);
        $this->insert('{{%region}}',['id'=>'2544','pid'=>'2535','shortname'=>'新龙','name'=>'新龙县','merger_name'=>'中国,四川省,甘孜藏族自治州,新龙县','level'=>'3','pinyin'=>'xinlong','code'=>'0836','zip_code'=>'626800','first'=>'X','lng'=>'100.3125','lat'=>'30.94067']);
        $this->insert('{{%region}}',['id'=>'2545','pid'=>'2535','shortname'=>'德格','name'=>'德格县','merger_name'=>'中国,四川省,甘孜藏族自治州,德格县','level'=>'3','pinyin'=>'dege','code'=>'0836','zip_code'=>'627250','first'=>'D','lng'=>'98.58078','lat'=>'31.80615']);
        $this->insert('{{%region}}',['id'=>'2546','pid'=>'2535','shortname'=>'白玉','name'=>'白玉县','merger_name'=>'中国,四川省,甘孜藏族自治州,白玉县','level'=>'3','pinyin'=>'baiyu','code'=>'0836','zip_code'=>'627150','first'=>'B','lng'=>'98.82568','lat'=>'31.20902']);
        $this->insert('{{%region}}',['id'=>'2547','pid'=>'2535','shortname'=>'石渠','name'=>'石渠县','merger_name'=>'中国,四川省,甘孜藏族自治州,石渠县','level'=>'3','pinyin'=>'shiqu','code'=>'0836','zip_code'=>'627350','first'=>'S','lng'=>'98.10156','lat'=>'32.97884']);
        $this->insert('{{%region}}',['id'=>'2548','pid'=>'2535','shortname'=>'色达','name'=>'色达县','merger_name'=>'中国,四川省,甘孜藏族自治州,色达县','level'=>'3','pinyin'=>'seda','code'=>'0836','zip_code'=>'626600','first'=>'S','lng'=>'100.33224','lat'=>'32.26839']);
        $this->insert('{{%region}}',['id'=>'2549','pid'=>'2535','shortname'=>'理塘','name'=>'理塘县','merger_name'=>'中国,四川省,甘孜藏族自治州,理塘县','level'=>'3','pinyin'=>'litang','code'=>'0836','zip_code'=>'627550','first'=>'L','lng'=>'100.27005','lat'=>'29.99674']);
        $this->insert('{{%region}}',['id'=>'2550','pid'=>'2535','shortname'=>'巴塘','name'=>'巴塘县','merger_name'=>'中国,四川省,甘孜藏族自治州,巴塘县','level'=>'3','pinyin'=>'batang','code'=>'0836','zip_code'=>'627650','first'=>'B','lng'=>'99.10409','lat'=>'30.00423']);
        $this->insert('{{%region}}',['id'=>'2551','pid'=>'2535','shortname'=>'乡城','name'=>'乡城县','merger_name'=>'中国,四川省,甘孜藏族自治州,乡城县','level'=>'3','pinyin'=>'xiangcheng','code'=>'0836','zip_code'=>'627850','first'=>'X','lng'=>'99.79943','lat'=>'28.93554']);
        $this->insert('{{%region}}',['id'=>'2552','pid'=>'2535','shortname'=>'稻城','name'=>'稻城县','merger_name'=>'中国,四川省,甘孜藏族自治州,稻城县','level'=>'3','pinyin'=>'daocheng','code'=>'0836','zip_code'=>'627750','first'=>'D','lng'=>'100.29809','lat'=>'29.0379']);
        $this->insert('{{%region}}',['id'=>'2553','pid'=>'2535','shortname'=>'得荣','name'=>'得荣县','merger_name'=>'中国,四川省,甘孜藏族自治州,得荣县','level'=>'3','pinyin'=>'derong','code'=>'0836','zip_code'=>'627950','first'=>'D','lng'=>'99.28628','lat'=>'28.71297']);
        $this->insert('{{%region}}',['id'=>'2554','pid'=>'2367','shortname'=>'凉山','name'=>'凉山彝族自治州','merger_name'=>'中国,四川省,凉山彝族自治州','level'=>'2','pinyin'=>'liangshan','code'=>'0834','zip_code'=>'615000','first'=>'L','lng'=>'102.258746','lat'=>'27.886762']);
        $this->insert('{{%region}}',['id'=>'2555','pid'=>'2554','shortname'=>'西昌','name'=>'西昌市','merger_name'=>'中国,四川省,凉山彝族自治州,西昌市','level'=>'3','pinyin'=>'xichang','code'=>'0835','zip_code'=>'615000','first'=>'X','lng'=>'102.26413','lat'=>'27.89524']);
        $this->insert('{{%region}}',['id'=>'2556','pid'=>'2554','shortname'=>'木里','name'=>'木里藏族自治县','merger_name'=>'中国,四川省,凉山彝族自治州,木里藏族自治县','level'=>'3','pinyin'=>'muli','code'=>'0851','zip_code'=>'615800','first'=>'M','lng'=>'101.2796','lat'=>'27.92875']);
        $this->insert('{{%region}}',['id'=>'2557','pid'=>'2554','shortname'=>'盐源','name'=>'盐源县','merger_name'=>'中国,四川省,凉山彝族自治州,盐源县','level'=>'3','pinyin'=>'yanyuan','code'=>'0836','zip_code'=>'615700','first'=>'Y','lng'=>'101.5097','lat'=>'27.42177']);
        $this->insert('{{%region}}',['id'=>'2558','pid'=>'2554','shortname'=>'德昌','name'=>'德昌县','merger_name'=>'中国,四川省,凉山彝族自治州,德昌县','level'=>'3','pinyin'=>'dechang','code'=>'0837','zip_code'=>'615500','first'=>'D','lng'=>'102.18017','lat'=>'27.40482']);
        $this->insert('{{%region}}',['id'=>'2559','pid'=>'2554','shortname'=>'会理','name'=>'会理县','merger_name'=>'中国,四川省,凉山彝族自治州,会理县','level'=>'3','pinyin'=>'huili','code'=>'0838','zip_code'=>'615100','first'=>'H','lng'=>'102.24539','lat'=>'26.65627']);
        $this->insert('{{%region}}',['id'=>'2560','pid'=>'2554','shortname'=>'会东','name'=>'会东县','merger_name'=>'中国,四川省,凉山彝族自治州,会东县','level'=>'3','pinyin'=>'huidong','code'=>'0839','zip_code'=>'615200','first'=>'H','lng'=>'102.57815','lat'=>'26.63429']);
        $this->insert('{{%region}}',['id'=>'2561','pid'=>'2554','shortname'=>'宁南','name'=>'宁南县','merger_name'=>'中国,四川省,凉山彝族自治州,宁南县','level'=>'3','pinyin'=>'ningnan','code'=>'0840','zip_code'=>'615400','first'=>'N','lng'=>'102.76116','lat'=>'27.06567']);
        $this->insert('{{%region}}',['id'=>'2562','pid'=>'2554','shortname'=>'普格','name'=>'普格县','merger_name'=>'中国,四川省,凉山彝族自治州,普格县','level'=>'3','pinyin'=>'puge','code'=>'0841','zip_code'=>'615300','first'=>'P','lng'=>'102.54055','lat'=>'27.37485']);
        $this->insert('{{%region}}',['id'=>'2563','pid'=>'2554','shortname'=>'布拖','name'=>'布拖县','merger_name'=>'中国,四川省,凉山彝族自治州,布拖县','level'=>'3','pinyin'=>'butuo','code'=>'0842','zip_code'=>'616350','first'=>'B','lng'=>'102.81234','lat'=>'27.7079']);
        $this->insert('{{%region}}',['id'=>'2564','pid'=>'2554','shortname'=>'金阳','name'=>'金阳县','merger_name'=>'中国,四川省,凉山彝族自治州,金阳县','level'=>'3','pinyin'=>'jinyang','code'=>'0843','zip_code'=>'616250','first'=>'J','lng'=>'103.24774','lat'=>'27.69698']);
        $this->insert('{{%region}}',['id'=>'2565','pid'=>'2554','shortname'=>'昭觉','name'=>'昭觉县','merger_name'=>'中国,四川省,凉山彝族自治州,昭觉县','level'=>'3','pinyin'=>'zhaojue','code'=>'0844','zip_code'=>'616150','first'=>'Z','lng'=>'102.84661','lat'=>'28.01155']);
        $this->insert('{{%region}}',['id'=>'2566','pid'=>'2554','shortname'=>'喜德','name'=>'喜德县','merger_name'=>'中国,四川省,凉山彝族自治州,喜德县','level'=>'3','pinyin'=>'xide','code'=>'0845','zip_code'=>'616750','first'=>'X','lng'=>'102.41336','lat'=>'28.30739']);
        $this->insert('{{%region}}',['id'=>'2567','pid'=>'2554','shortname'=>'冕宁','name'=>'冕宁县','merger_name'=>'中国,四川省,凉山彝族自治州,冕宁县','level'=>'3','pinyin'=>'mianning','code'=>'0846','zip_code'=>'615600','first'=>'M','lng'=>'102.17108','lat'=>'28.55161']);
        $this->insert('{{%region}}',['id'=>'2568','pid'=>'2554','shortname'=>'越西','name'=>'越西县','merger_name'=>'中国,四川省,凉山彝族自治州,越西县','level'=>'3','pinyin'=>'yuexi','code'=>'0847','zip_code'=>'616650','first'=>'Y','lng'=>'102.5079','lat'=>'28.64133']);
        $this->insert('{{%region}}',['id'=>'2569','pid'=>'2554','shortname'=>'甘洛','name'=>'甘洛县','merger_name'=>'中国,四川省,凉山彝族自治州,甘洛县','level'=>'3','pinyin'=>'ganluo','code'=>'0848','zip_code'=>'616850','first'=>'G','lng'=>'102.77154','lat'=>'28.96624']);
        $this->insert('{{%region}}',['id'=>'2570','pid'=>'2554','shortname'=>'美姑','name'=>'美姑县','merger_name'=>'中国,四川省,凉山彝族自治州,美姑县','level'=>'3','pinyin'=>'meigu','code'=>'0849','zip_code'=>'616450','first'=>'M','lng'=>'103.13116','lat'=>'28.32596']);
        $this->insert('{{%region}}',['id'=>'2571','pid'=>'2554','shortname'=>'雷波','name'=>'雷波县','merger_name'=>'中国,四川省,凉山彝族自治州,雷波县','level'=>'3','pinyin'=>'leibo','code'=>'0850','zip_code'=>'616550','first'=>'L','lng'=>'103.57287','lat'=>'28.26407']);
        $this->insert('{{%region}}',['id'=>'2572','pid'=>'0','shortname'=>'贵州','name'=>'贵州省','merger_name'=>'中国,贵州省','level'=>'1','pinyin'=>'guizhou','code'=>'','zip_code'=>'','first'=>'G','lng'=>'106.713478','lat'=>'26.578343']);
        $this->insert('{{%region}}',['id'=>'2573','pid'=>'2572','shortname'=>'贵阳','name'=>'贵阳市','merger_name'=>'中国,贵州省,贵阳市','level'=>'2','pinyin'=>'guiyang','code'=>'0851','zip_code'=>'550001','first'=>'G','lng'=>'106.713478','lat'=>'26.578343']);
        $this->insert('{{%region}}',['id'=>'2574','pid'=>'2573','shortname'=>'南明','name'=>'南明区','merger_name'=>'中国,贵州省,贵阳市,南明区','level'=>'3','pinyin'=>'nanming','code'=>'0851','zip_code'=>'550001','first'=>'N','lng'=>'106.7145','lat'=>'26.56819']);
        $this->insert('{{%region}}',['id'=>'2575','pid'=>'2573','shortname'=>'云岩','name'=>'云岩区','merger_name'=>'中国,贵州省,贵阳市,云岩区','level'=>'3','pinyin'=>'yunyan','code'=>'0851','zip_code'=>'550001','first'=>'Y','lng'=>'106.72485','lat'=>'26.60484']);
        $this->insert('{{%region}}',['id'=>'2576','pid'=>'2573','shortname'=>'花溪','name'=>'花溪区','merger_name'=>'中国,贵州省,贵阳市,花溪区','level'=>'3','pinyin'=>'huaxi','code'=>'0851','zip_code'=>'550025','first'=>'H','lng'=>'106.67688','lat'=>'26.43343']);
        $this->insert('{{%region}}',['id'=>'2577','pid'=>'2573','shortname'=>'乌当','name'=>'乌当区','merger_name'=>'中国,贵州省,贵阳市,乌当区','level'=>'3','pinyin'=>'wudang','code'=>'0851','zip_code'=>'550018','first'=>'W','lng'=>'106.7521','lat'=>'26.6302']);
        $this->insert('{{%region}}',['id'=>'2578','pid'=>'2573','shortname'=>'白云','name'=>'白云区','merger_name'=>'中国,贵州省,贵阳市,白云区','level'=>'3','pinyin'=>'baiyun','code'=>'0851','zip_code'=>'550014','first'=>'B','lng'=>'106.63088','lat'=>'26.68284']);
        $this->insert('{{%region}}',['id'=>'2579','pid'=>'2573','shortname'=>'观山湖','name'=>'观山湖区','merger_name'=>'中国,贵州省,贵阳市,观山湖区','level'=>'3','pinyin'=>'guanshanhu','code'=>'0851','zip_code'=>'550009','first'=>'G','lng'=>'106.625442','lat'=>'26.618209']);
        $this->insert('{{%region}}',['id'=>'2580','pid'=>'2573','shortname'=>'开阳','name'=>'开阳县','merger_name'=>'中国,贵州省,贵阳市,开阳县','level'=>'3','pinyin'=>'kaiyang','code'=>'0851','zip_code'=>'550300','first'=>'K','lng'=>'106.9692','lat'=>'27.05533']);
        $this->insert('{{%region}}',['id'=>'2581','pid'=>'2573','shortname'=>'息烽','name'=>'息烽县','merger_name'=>'中国,贵州省,贵阳市,息烽县','level'=>'3','pinyin'=>'xifeng','code'=>'0851','zip_code'=>'551100','first'=>'X','lng'=>'106.738','lat'=>'27.09346']);
        $this->insert('{{%region}}',['id'=>'2582','pid'=>'2573','shortname'=>'修文','name'=>'修文县','merger_name'=>'中国,贵州省,贵阳市,修文县','level'=>'3','pinyin'=>'xiuwen','code'=>'0851','zip_code'=>'550200','first'=>'X','lng'=>'106.59487','lat'=>'26.83783']);
        $this->insert('{{%region}}',['id'=>'2583','pid'=>'2573','shortname'=>'清镇','name'=>'清镇市','merger_name'=>'中国,贵州省,贵阳市,清镇市','level'=>'3','pinyin'=>'qingzhen','code'=>'0851','zip_code'=>'551400','first'=>'Q','lng'=>'106.46862','lat'=>'26.55261']);
        $this->insert('{{%region}}',['id'=>'2584','pid'=>'2572','shortname'=>'六盘水','name'=>'六盘水市','merger_name'=>'中国,贵州省,六盘水市','level'=>'2','pinyin'=>'liupanshui','code'=>'0858','zip_code'=>'553400','first'=>'L','lng'=>'104.846743','lat'=>'26.584643']);
        $this->insert('{{%region}}',['id'=>'2585','pid'=>'2584','shortname'=>'钟山','name'=>'钟山区','merger_name'=>'中国,贵州省,六盘水市,钟山区','level'=>'3','pinyin'=>'zhongshan','code'=>'0858','zip_code'=>'553000','first'=>'Z','lng'=>'104.87848','lat'=>'26.57699']);
        $this->insert('{{%region}}',['id'=>'2586','pid'=>'2584','shortname'=>'六枝','name'=>'六枝特区','merger_name'=>'中国,贵州省,六盘水市,六枝特区','level'=>'3','pinyin'=>'liuzhi','code'=>'0858','zip_code'=>'553400','first'=>'L','lng'=>'105.48062','lat'=>'26.20117']);
        $this->insert('{{%region}}',['id'=>'2587','pid'=>'2584','shortname'=>'水城','name'=>'水城县','merger_name'=>'中国,贵州省,六盘水市,水城县','level'=>'3','pinyin'=>'shuicheng','code'=>'0858','zip_code'=>'553000','first'=>'S','lng'=>'104.95764','lat'=>'26.54785']);
        $this->insert('{{%region}}',['id'=>'2588','pid'=>'2584','shortname'=>'盘县','name'=>'盘县','merger_name'=>'中国,贵州省,六盘水市,盘县','level'=>'3','pinyin'=>'panxian','code'=>'0858','zip_code'=>'561601','first'=>'P','lng'=>'104.47061','lat'=>'25.7136']);
        $this->insert('{{%region}}',['id'=>'2589','pid'=>'2572','shortname'=>'遵义','name'=>'遵义市','merger_name'=>'中国,贵州省,遵义市','level'=>'2','pinyin'=>'zunyi','code'=>'0852','zip_code'=>'563000','first'=>'Z','lng'=>'106.937265','lat'=>'27.706626']);
        $this->insert('{{%region}}',['id'=>'2590','pid'=>'2589','shortname'=>'红花岗','name'=>'红花岗区','merger_name'=>'中国,贵州省,遵义市,红花岗区','level'=>'3','pinyin'=>'honghuagang','code'=>'0852','zip_code'=>'563000','first'=>'H','lng'=>'106.89404','lat'=>'27.64471']);
        $this->insert('{{%region}}',['id'=>'2591','pid'=>'2589','shortname'=>'汇川','name'=>'汇川区','merger_name'=>'中国,贵州省,遵义市,汇川区','level'=>'3','pinyin'=>'huichuan','code'=>'0852','zip_code'=>'563000','first'=>'H','lng'=>'106.9393','lat'=>'27.70625']);
        $this->insert('{{%region}}',['id'=>'2592','pid'=>'2589','shortname'=>'遵义','name'=>'遵义县','merger_name'=>'中国,贵州省,遵义市,遵义县','level'=>'3','pinyin'=>'zunyi','code'=>'0852','zip_code'=>'563100','first'=>'Z','lng'=>'106.83331','lat'=>'27.53772']);
        $this->insert('{{%region}}',['id'=>'2593','pid'=>'2589','shortname'=>'桐梓','name'=>'桐梓县','merger_name'=>'中国,贵州省,遵义市,桐梓县','level'=>'3','pinyin'=>'tongzi','code'=>'0852','zip_code'=>'563200','first'=>'T','lng'=>'106.82568','lat'=>'28.13806']);
        $this->insert('{{%region}}',['id'=>'2594','pid'=>'2589','shortname'=>'绥阳','name'=>'绥阳县','merger_name'=>'中国,贵州省,遵义市,绥阳县','level'=>'3','pinyin'=>'suiyang','code'=>'0852','zip_code'=>'563300','first'=>'S','lng'=>'107.19064','lat'=>'27.94702']);
        $this->insert('{{%region}}',['id'=>'2595','pid'=>'2589','shortname'=>'正安','name'=>'正安县','merger_name'=>'中国,贵州省,遵义市,正安县','level'=>'3','pinyin'=>'zheng\'an','code'=>'0852','zip_code'=>'563400','first'=>'Z','lng'=>'107.44357','lat'=>'28.5512']);
        $this->insert('{{%region}}',['id'=>'2596','pid'=>'2589','shortname'=>'道真','name'=>'道真仡佬族苗族自治县','merger_name'=>'中国,贵州省,遵义市,道真仡佬族苗族自治县','level'=>'3','pinyin'=>'daozhen','code'=>'0852','zip_code'=>'563500','first'=>'D','lng'=>'107.61152','lat'=>'28.864']);
        $this->insert('{{%region}}',['id'=>'2597','pid'=>'2589','shortname'=>'务川','name'=>'务川仡佬族苗族自治县','merger_name'=>'中国,贵州省,遵义市,务川仡佬族苗族自治县','level'=>'3','pinyin'=>'wuchuan','code'=>'0852','zip_code'=>'564300','first'=>'W','lng'=>'107.88935','lat'=>'28.52227']);
        $this->insert('{{%region}}',['id'=>'2598','pid'=>'2589','shortname'=>'凤冈','name'=>'凤冈县','merger_name'=>'中国,贵州省,遵义市,凤冈县','level'=>'3','pinyin'=>'fenggang','code'=>'0852','zip_code'=>'564200','first'=>'F','lng'=>'107.71682','lat'=>'27.95461']);
        $this->insert('{{%region}}',['id'=>'2599','pid'=>'2589','shortname'=>'湄潭','name'=>'湄潭县','merger_name'=>'中国,贵州省,遵义市,湄潭县','level'=>'3','pinyin'=>'meitan','code'=>'0852','zip_code'=>'564100','first'=>NULL,'lng'=>'107.48779','lat'=>'27.76676']);
        $this->insert('{{%region}}',['id'=>'2600','pid'=>'2589','shortname'=>'余庆','name'=>'余庆县','merger_name'=>'中国,贵州省,遵义市,余庆县','level'=>'3','pinyin'=>'yuqing','code'=>'0852','zip_code'=>'564400','first'=>'Y','lng'=>'107.88821','lat'=>'27.22532']);
        $this->insert('{{%region}}',['id'=>'2601','pid'=>'2589','shortname'=>'习水','name'=>'习水县','merger_name'=>'中国,贵州省,遵义市,习水县','level'=>'3','pinyin'=>'xishui','code'=>'0852','zip_code'=>'564600','first'=>'X','lng'=>'106.21267','lat'=>'28.31976']);
        $this->insert('{{%region}}',['id'=>'2602','pid'=>'2589','shortname'=>'赤水','name'=>'赤水市','merger_name'=>'中国,贵州省,遵义市,赤水市','level'=>'3','pinyin'=>'chishui','code'=>'0852','zip_code'=>'564700','first'=>'C','lng'=>'105.69845','lat'=>'28.58921']);
        $this->insert('{{%region}}',['id'=>'2603','pid'=>'2589','shortname'=>'仁怀','name'=>'仁怀市','merger_name'=>'中国,贵州省,遵义市,仁怀市','level'=>'3','pinyin'=>'renhuai','code'=>'0852','zip_code'=>'564500','first'=>'R','lng'=>'106.40152','lat'=>'27.79231']);
        $this->insert('{{%region}}',['id'=>'2604','pid'=>'2572','shortname'=>'安顺','name'=>'安顺市','merger_name'=>'中国,贵州省,安顺市','level'=>'2','pinyin'=>'anshun','code'=>'0853','zip_code'=>'561000','first'=>'A','lng'=>'105.932188','lat'=>'26.245544']);
        $this->insert('{{%region}}',['id'=>'2605','pid'=>'2604','shortname'=>'西秀','name'=>'西秀区','merger_name'=>'中国,贵州省,安顺市,西秀区','level'=>'3','pinyin'=>'xixiu','code'=>'0853','zip_code'=>'561000','first'=>'X','lng'=>'105.96585','lat'=>'26.24491']);
        $this->insert('{{%region}}',['id'=>'2606','pid'=>'2604','shortname'=>'平坝','name'=>'平坝区','merger_name'=>'中国,贵州省,安顺市,平坝区','level'=>'3','pinyin'=>'pingba','code'=>'0853','zip_code'=>'561100','first'=>'P','lng'=>'106.25683','lat'=>'26.40543']);
        $this->insert('{{%region}}',['id'=>'2607','pid'=>'2604','shortname'=>'普定','name'=>'普定县','merger_name'=>'中国,贵州省,安顺市,普定县','level'=>'3','pinyin'=>'puding','code'=>'0853','zip_code'=>'562100','first'=>'P','lng'=>'105.74285','lat'=>'26.30141']);
        $this->insert('{{%region}}',['id'=>'2608','pid'=>'2604','shortname'=>'镇宁','name'=>'镇宁布依族苗族自治县','merger_name'=>'中国,贵州省,安顺市,镇宁布依族苗族自治县','level'=>'3','pinyin'=>'zhenning','code'=>'0853','zip_code'=>'561200','first'=>'Z','lng'=>'105.76513','lat'=>'26.05533']);
        $this->insert('{{%region}}',['id'=>'2609','pid'=>'2604','shortname'=>'关岭','name'=>'关岭布依族苗族自治县','merger_name'=>'中国,贵州省,安顺市,关岭布依族苗族自治县','level'=>'3','pinyin'=>'guanling','code'=>'0853','zip_code'=>'561300','first'=>'G','lng'=>'105.61883','lat'=>'25.94248']);
        $this->insert('{{%region}}',['id'=>'2610','pid'=>'2604','shortname'=>'紫云','name'=>'紫云苗族布依族自治县','merger_name'=>'中国,贵州省,安顺市,紫云苗族布依族自治县','level'=>'3','pinyin'=>'ziyun','code'=>'0853','zip_code'=>'550800','first'=>'Z','lng'=>'106.08364','lat'=>'25.75258']);
        $this->insert('{{%region}}',['id'=>'2611','pid'=>'2572','shortname'=>'毕节','name'=>'毕节市','merger_name'=>'中国,贵州省,毕节市','level'=>'2','pinyin'=>'bijie','code'=>'0857','zip_code'=>'551700','first'=>'B','lng'=>'105.28501','lat'=>'27.301693']);
        $this->insert('{{%region}}',['id'=>'2612','pid'=>'2611','shortname'=>'七星关','name'=>'七星关区','merger_name'=>'中国,贵州省,毕节市,七星关区','level'=>'3','pinyin'=>'qixingguan','code'=>'0857','zip_code'=>'551700','first'=>'Q','lng'=>'104.9497','lat'=>'27.153556']);
        $this->insert('{{%region}}',['id'=>'2613','pid'=>'2611','shortname'=>'大方','name'=>'大方县','merger_name'=>'中国,贵州省,毕节市,大方县','level'=>'3','pinyin'=>'dafang','code'=>'0857','zip_code'=>'551600','first'=>'D','lng'=>'105.609254','lat'=>'27.143521']);
        $this->insert('{{%region}}',['id'=>'2614','pid'=>'2611','shortname'=>'黔西','name'=>'黔西县','merger_name'=>'中国,贵州省,毕节市,黔西县','level'=>'3','pinyin'=>'qianxi','code'=>'0857','zip_code'=>'551500','first'=>'Q','lng'=>'106.038299','lat'=>'27.024923']);
        $this->insert('{{%region}}',['id'=>'2615','pid'=>'2611','shortname'=>'金沙','name'=>'金沙县','merger_name'=>'中国,贵州省,毕节市,金沙县','level'=>'3','pinyin'=>'jinsha','code'=>'0857','zip_code'=>'551800','first'=>'J','lng'=>'106.222103','lat'=>'27.459693']);
        $this->insert('{{%region}}',['id'=>'2616','pid'=>'2611','shortname'=>'织金','name'=>'织金县','merger_name'=>'中国,贵州省,毕节市,织金县','level'=>'3','pinyin'=>'zhijin','code'=>'0857','zip_code'=>'552100','first'=>'Z','lng'=>'105.768997','lat'=>'26.668497']);
        $this->insert('{{%region}}',['id'=>'2617','pid'=>'2611','shortname'=>'纳雍','name'=>'纳雍县','merger_name'=>'中国,贵州省,毕节市,纳雍县','level'=>'3','pinyin'=>'nayong','code'=>'0857','zip_code'=>'553300','first'=>'N','lng'=>'105.375322','lat'=>'26.769875']);
        $this->insert('{{%region}}',['id'=>'2618','pid'=>'2611','shortname'=>'威宁','name'=>'威宁彝族回族苗族自治县','merger_name'=>'中国,贵州省,毕节市,威宁彝族回族苗族自治县','level'=>'3','pinyin'=>'weining','code'=>'0857','zip_code'=>'553100','first'=>'W','lng'=>'104.286523','lat'=>'26.859099']);
        $this->insert('{{%region}}',['id'=>'2619','pid'=>'2611','shortname'=>'赫章','name'=>'赫章县','merger_name'=>'中国,贵州省,毕节市,赫章县','level'=>'3','pinyin'=>'hezhang','code'=>'0857','zip_code'=>'553200','first'=>'H','lng'=>'104.726438','lat'=>'27.119243']);
        $this->insert('{{%region}}',['id'=>'2620','pid'=>'2572','shortname'=>'铜仁','name'=>'铜仁市','merger_name'=>'中国,贵州省,铜仁市','level'=>'2','pinyin'=>'tongren','code'=>'0856','zip_code'=>'554300','first'=>'T','lng'=>'109.191555','lat'=>'27.718346']);
        $this->insert('{{%region}}',['id'=>'2621','pid'=>'2620','shortname'=>'碧江','name'=>'碧江区','merger_name'=>'中国,贵州省,铜仁市,碧江区','level'=>'3','pinyin'=>'bijiang','code'=>'0856','zip_code'=>'554300','first'=>'B','lng'=>'109.191555','lat'=>'27.718346']);
        $this->insert('{{%region}}',['id'=>'2622','pid'=>'2620','shortname'=>'万山','name'=>'万山区','merger_name'=>'中国,贵州省,铜仁市,万山区','level'=>'3','pinyin'=>'wanshan','code'=>'0856','zip_code'=>'554200','first'=>'W','lng'=>'109.21199','lat'=>'27.51903']);
        $this->insert('{{%region}}',['id'=>'2623','pid'=>'2620','shortname'=>'江口','name'=>'江口县','merger_name'=>'中国,贵州省,铜仁市,江口县','level'=>'3','pinyin'=>'jiangkou','code'=>'0856','zip_code'=>'554400','first'=>'J','lng'=>'108.848427','lat'=>'27.691904']);
        $this->insert('{{%region}}',['id'=>'2624','pid'=>'2620','shortname'=>'玉屏','name'=>'玉屏侗族自治县','merger_name'=>'中国,贵州省,铜仁市,玉屏侗族自治县','level'=>'3','pinyin'=>'yuping','code'=>'0856','zip_code'=>'554004','first'=>'Y','lng'=>'108.917882','lat'=>'27.238024']);
        $this->insert('{{%region}}',['id'=>'2625','pid'=>'2620','shortname'=>'石阡','name'=>'石阡县','merger_name'=>'中国,贵州省,铜仁市,石阡县','level'=>'3','pinyin'=>'shiqian','code'=>'0856','zip_code'=>'555100','first'=>'S','lng'=>'108.229854','lat'=>'27.519386']);
        $this->insert('{{%region}}',['id'=>'2626','pid'=>'2620','shortname'=>'思南','name'=>'思南县','merger_name'=>'中国,贵州省,铜仁市,思南县','level'=>'3','pinyin'=>'sinan','code'=>'0856','zip_code'=>'565100','first'=>'S','lng'=>'108.255827','lat'=>'27.941331']);
        $this->insert('{{%region}}',['id'=>'2627','pid'=>'2620','shortname'=>'印江','name'=>'印江土家族苗族自治县','merger_name'=>'中国,贵州省,铜仁市,印江土家族苗族自治县','level'=>'3','pinyin'=>'yinjiang','code'=>'0856','zip_code'=>'555200','first'=>'Y','lng'=>'108.405517','lat'=>'27.997976']);
        $this->insert('{{%region}}',['id'=>'2628','pid'=>'2620','shortname'=>'德江','name'=>'德江县','merger_name'=>'中国,贵州省,铜仁市,德江县','level'=>'3','pinyin'=>'dejiang','code'=>'0856','zip_code'=>'565200','first'=>'D','lng'=>'108.117317','lat'=>'28.26094']);
        $this->insert('{{%region}}',['id'=>'2629','pid'=>'2620','shortname'=>'沿河','name'=>'沿河土家族自治县','merger_name'=>'中国,贵州省,铜仁市,沿河土家族自治县','level'=>'3','pinyin'=>'yuanhe','code'=>'0856','zip_code'=>'565300','first'=>'Y','lng'=>'108.495746','lat'=>'28.560487']);
        $this->insert('{{%region}}',['id'=>'2630','pid'=>'2620','shortname'=>'松桃','name'=>'松桃苗族自治县','merger_name'=>'中国,贵州省,铜仁市,松桃苗族自治县','level'=>'3','pinyin'=>'songtao','code'=>'0856','zip_code'=>'554100','first'=>'S','lng'=>'109.202627','lat'=>'28.165419']);
        $this->insert('{{%region}}',['id'=>'2631','pid'=>'2572','shortname'=>'黔西南','name'=>'黔西南布依族苗族自治州','merger_name'=>'中国,贵州省,黔西南布依族苗族自治州','level'=>'2','pinyin'=>'qianxinan','code'=>'0859','zip_code'=>'562400','first'=>'Q','lng'=>'104.897971','lat'=>'25.08812']);
        $this->insert('{{%region}}',['id'=>'2632','pid'=>'2631','shortname'=>'兴义','name'=>'兴义市 ','merger_name'=>'中国,贵州省,黔西南布依族苗族自治州,兴义市 ','level'=>'3','pinyin'=>'xingyi','code'=>'0859','zip_code'=>'562400','first'=>'X','lng'=>'104.89548','lat'=>'25.09205']);
        $this->insert('{{%region}}',['id'=>'2633','pid'=>'2631','shortname'=>'兴仁','name'=>'兴仁县','merger_name'=>'中国,贵州省,黔西南布依族苗族自治州,兴仁县','level'=>'3','pinyin'=>'xingren','code'=>'0859','zip_code'=>'562300','first'=>'X','lng'=>'105.18652','lat'=>'25.43282']);
        $this->insert('{{%region}}',['id'=>'2634','pid'=>'2631','shortname'=>'普安','name'=>'普安县','merger_name'=>'中国,贵州省,黔西南布依族苗族自治州,普安县','level'=>'3','pinyin'=>'pu\'an','code'=>'0859','zip_code'=>'561500','first'=>'P','lng'=>'104.95529','lat'=>'25.78603']);
        $this->insert('{{%region}}',['id'=>'2635','pid'=>'2631','shortname'=>'晴隆','name'=>'晴隆县','merger_name'=>'中国,贵州省,黔西南布依族苗族自治州,晴隆县','level'=>'3','pinyin'=>'qinglong','code'=>'0859','zip_code'=>'561400','first'=>'Q','lng'=>'105.2192','lat'=>'25.83522']);
        $this->insert('{{%region}}',['id'=>'2636','pid'=>'2631','shortname'=>'贞丰','name'=>'贞丰县','merger_name'=>'中国,贵州省,黔西南布依族苗族自治州,贞丰县','level'=>'3','pinyin'=>'zhenfeng','code'=>'0859','zip_code'=>'562200','first'=>'Z','lng'=>'105.65454','lat'=>'25.38464']);
        $this->insert('{{%region}}',['id'=>'2637','pid'=>'2631','shortname'=>'望谟','name'=>'望谟县','merger_name'=>'中国,贵州省,黔西南布依族苗族自治州,望谟县','level'=>'3','pinyin'=>'wangmo','code'=>'0859','zip_code'=>'552300','first'=>'W','lng'=>'106.09957','lat'=>'25.17822']);
        $this->insert('{{%region}}',['id'=>'2638','pid'=>'2631','shortname'=>'册亨','name'=>'册亨县','merger_name'=>'中国,贵州省,黔西南布依族苗族自治州,册亨县','level'=>'3','pinyin'=>'ceheng','code'=>'0859','zip_code'=>'552200','first'=>'C','lng'=>'105.8124','lat'=>'24.98376']);
        $this->insert('{{%region}}',['id'=>'2639','pid'=>'2631','shortname'=>'安龙','name'=>'安龙县','merger_name'=>'中国,贵州省,黔西南布依族苗族自治州,安龙县','level'=>'3','pinyin'=>'anlong','code'=>'0859','zip_code'=>'552400','first'=>'A','lng'=>'105.44268','lat'=>'25.09818']);
        $this->insert('{{%region}}',['id'=>'2640','pid'=>'2572','shortname'=>'黔东南','name'=>'黔东南苗族侗族自治州','merger_name'=>'中国,贵州省,黔东南苗族侗族自治州','level'=>'2','pinyin'=>'qiandongnan','code'=>'0855','zip_code'=>'556000','first'=>'Q','lng'=>'107.977488','lat'=>'26.583352']);
        $this->insert('{{%region}}',['id'=>'2641','pid'=>'2640','shortname'=>'凯里','name'=>'凯里市','merger_name'=>'中国,贵州省,黔东南苗族侗族自治州,凯里市','level'=>'3','pinyin'=>'kaili','code'=>'0855','zip_code'=>'556000','first'=>'K','lng'=>'107.98132','lat'=>'26.56689']);
        $this->insert('{{%region}}',['id'=>'2642','pid'=>'2640','shortname'=>'黄平','name'=>'黄平县','merger_name'=>'中国,贵州省,黔东南苗族侗族自治州,黄平县','level'=>'3','pinyin'=>'huangping','code'=>'0855','zip_code'=>'556100','first'=>'H','lng'=>'107.90179','lat'=>'26.89573']);
        $this->insert('{{%region}}',['id'=>'2643','pid'=>'2640','shortname'=>'施秉','name'=>'施秉县','merger_name'=>'中国,贵州省,黔东南苗族侗族自治州,施秉县','level'=>'3','pinyin'=>'shibing','code'=>'0855','zip_code'=>'556200','first'=>'S','lng'=>'108.12597','lat'=>'27.03495']);
        $this->insert('{{%region}}',['id'=>'2644','pid'=>'2640','shortname'=>'三穗','name'=>'三穗县','merger_name'=>'中国,贵州省,黔东南苗族侗族自治州,三穗县','level'=>'3','pinyin'=>'sansui','code'=>'0855','zip_code'=>'556500','first'=>'S','lng'=>'108.67132','lat'=>'26.94765']);
        $this->insert('{{%region}}',['id'=>'2645','pid'=>'2640','shortname'=>'镇远','name'=>'镇远县','merger_name'=>'中国,贵州省,黔东南苗族侗族自治州,镇远县','level'=>'3','pinyin'=>'zhenyuan','code'=>'0855','zip_code'=>'557700','first'=>'Z','lng'=>'108.42721','lat'=>'27.04933']);
        $this->insert('{{%region}}',['id'=>'2646','pid'=>'2640','shortname'=>'岑巩','name'=>'岑巩县','merger_name'=>'中国,贵州省,黔东南苗族侗族自治州,岑巩县','level'=>'3','pinyin'=>'cengong','code'=>'0855','zip_code'=>'557800','first'=>NULL,'lng'=>'108.81884','lat'=>'27.17539']);
        $this->insert('{{%region}}',['id'=>'2647','pid'=>'2640','shortname'=>'天柱','name'=>'天柱县','merger_name'=>'中国,贵州省,黔东南苗族侗族自治州,天柱县','level'=>'3','pinyin'=>'tianzhu','code'=>'0855','zip_code'=>'556600','first'=>'T','lng'=>'109.20718','lat'=>'26.90781']);
        $this->insert('{{%region}}',['id'=>'2648','pid'=>'2640','shortname'=>'锦屏','name'=>'锦屏县','merger_name'=>'中国,贵州省,黔东南苗族侗族自治州,锦屏县','level'=>'3','pinyin'=>'jinping','code'=>'0855','zip_code'=>'556700','first'=>'J','lng'=>'109.19982','lat'=>'26.67635']);
        $this->insert('{{%region}}',['id'=>'2649','pid'=>'2640','shortname'=>'剑河','name'=>'剑河县','merger_name'=>'中国,贵州省,黔东南苗族侗族自治州,剑河县','level'=>'3','pinyin'=>'jianhe','code'=>'0855','zip_code'=>'556400','first'=>'J','lng'=>'108.5913','lat'=>'26.6525']);
        $this->insert('{{%region}}',['id'=>'2650','pid'=>'2640','shortname'=>'台江','name'=>'台江县','merger_name'=>'中国,贵州省,黔东南苗族侗族自治州,台江县','level'=>'3','pinyin'=>'taijiang','code'=>'0855','zip_code'=>'556300','first'=>'T','lng'=>'108.31814','lat'=>'26.66916']);
        $this->insert('{{%region}}',['id'=>'2651','pid'=>'2640','shortname'=>'黎平','name'=>'黎平县','merger_name'=>'中国,贵州省,黔东南苗族侗族自治州,黎平县','level'=>'3','pinyin'=>'liping','code'=>'0855','zip_code'=>'557300','first'=>'L','lng'=>'109.13607','lat'=>'26.23114']);
        $this->insert('{{%region}}',['id'=>'2652','pid'=>'2640','shortname'=>'榕江','name'=>'榕江县','merger_name'=>'中国,贵州省,黔东南苗族侗族自治州,榕江县','level'=>'3','pinyin'=>'rongjiang','code'=>'0855','zip_code'=>'557200','first'=>NULL,'lng'=>'108.52072','lat'=>'25.92421']);
        $this->insert('{{%region}}',['id'=>'2653','pid'=>'2640','shortname'=>'从江','name'=>'从江县','merger_name'=>'中国,贵州省,黔东南苗族侗族自治州,从江县','level'=>'3','pinyin'=>'congjiang','code'=>'0855','zip_code'=>'557400','first'=>'C','lng'=>'108.90527','lat'=>'25.75415']);
        $this->insert('{{%region}}',['id'=>'2654','pid'=>'2640','shortname'=>'雷山','name'=>'雷山县','merger_name'=>'中国,贵州省,黔东南苗族侗族自治州,雷山县','level'=>'3','pinyin'=>'leishan','code'=>'0855','zip_code'=>'557100','first'=>'L','lng'=>'108.07745','lat'=>'26.38385']);
        $this->insert('{{%region}}',['id'=>'2655','pid'=>'2640','shortname'=>'麻江','name'=>'麻江县','merger_name'=>'中国,贵州省,黔东南苗族侗族自治州,麻江县','level'=>'3','pinyin'=>'majiang','code'=>'0855','zip_code'=>'557600','first'=>'M','lng'=>'107.59155','lat'=>'26.49235']);
        $this->insert('{{%region}}',['id'=>'2656','pid'=>'2640','shortname'=>'丹寨','name'=>'丹寨县','merger_name'=>'中国,贵州省,黔东南苗族侗族自治州,丹寨县','level'=>'3','pinyin'=>'danzhai','code'=>'0855','zip_code'=>'557500','first'=>'D','lng'=>'107.79718','lat'=>'26.19816']);
        $this->insert('{{%region}}',['id'=>'2657','pid'=>'2572','shortname'=>'黔南','name'=>'黔南布依族苗族自治州','merger_name'=>'中国,贵州省,黔南布依族苗族自治州','level'=>'2','pinyin'=>'qiannan','code'=>'0854','zip_code'=>'558000','first'=>'Q','lng'=>'107.517156','lat'=>'26.258219']);
        $this->insert('{{%region}}',['id'=>'2658','pid'=>'2657','shortname'=>'都匀','name'=>'都匀市','merger_name'=>'中国,贵州省,黔南布依族苗族自治州,都匀市','level'=>'3','pinyin'=>'duyun','code'=>'0854','zip_code'=>'558000','first'=>'D','lng'=>'107.51872','lat'=>'26.2594']);
        $this->insert('{{%region}}',['id'=>'2659','pid'=>'2657','shortname'=>'福泉','name'=>'福泉市','merger_name'=>'中国,贵州省,黔南布依族苗族自治州,福泉市','level'=>'3','pinyin'=>'fuquan','code'=>'0854','zip_code'=>'550500','first'=>'F','lng'=>'107.51715','lat'=>'26.67989']);
        $this->insert('{{%region}}',['id'=>'2660','pid'=>'2657','shortname'=>'荔波','name'=>'荔波县','merger_name'=>'中国,贵州省,黔南布依族苗族自治州,荔波县','level'=>'3','pinyin'=>'libo','code'=>'0854','zip_code'=>'558400','first'=>'L','lng'=>'107.88592','lat'=>'25.4139']);
        $this->insert('{{%region}}',['id'=>'2661','pid'=>'2657','shortname'=>'贵定','name'=>'贵定县','merger_name'=>'中国,贵州省,黔南布依族苗族自治州,贵定县','level'=>'3','pinyin'=>'guiding','code'=>'0854','zip_code'=>'551300','first'=>'G','lng'=>'107.23654','lat'=>'26.57812']);
        $this->insert('{{%region}}',['id'=>'2662','pid'=>'2657','shortname'=>'瓮安','name'=>'瓮安县','merger_name'=>'中国,贵州省,黔南布依族苗族自治州,瓮安县','level'=>'3','pinyin'=>'weng\'an','code'=>'0854','zip_code'=>'550400','first'=>'W','lng'=>'107.4757','lat'=>'27.06813']);
        $this->insert('{{%region}}',['id'=>'2663','pid'=>'2657','shortname'=>'独山','name'=>'独山县','merger_name'=>'中国,贵州省,黔南布依族苗族自治州,独山县','level'=>'3','pinyin'=>'dushan','code'=>'0854','zip_code'=>'558200','first'=>'D','lng'=>'107.54101','lat'=>'25.8245']);
        $this->insert('{{%region}}',['id'=>'2664','pid'=>'2657','shortname'=>'平塘','name'=>'平塘县','merger_name'=>'中国,贵州省,黔南布依族苗族自治州,平塘县','level'=>'3','pinyin'=>'pingtang','code'=>'0854','zip_code'=>'558300','first'=>'P','lng'=>'107.32428','lat'=>'25.83294']);
        $this->insert('{{%region}}',['id'=>'2665','pid'=>'2657','shortname'=>'罗甸','name'=>'罗甸县','merger_name'=>'中国,贵州省,黔南布依族苗族自治州,罗甸县','level'=>'3','pinyin'=>'luodian','code'=>'0854','zip_code'=>'550100','first'=>'L','lng'=>'106.75186','lat'=>'25.42586']);
        $this->insert('{{%region}}',['id'=>'2666','pid'=>'2657','shortname'=>'长顺','name'=>'长顺县','merger_name'=>'中国,贵州省,黔南布依族苗族自治州,长顺县','level'=>'3','pinyin'=>'changshun','code'=>'0854','zip_code'=>'550700','first'=>'C','lng'=>'106.45217','lat'=>'26.02299']);
        $this->insert('{{%region}}',['id'=>'2667','pid'=>'2657','shortname'=>'龙里','name'=>'龙里县','merger_name'=>'中国,贵州省,黔南布依族苗族自治州,龙里县','level'=>'3','pinyin'=>'longli','code'=>'0854','zip_code'=>'551200','first'=>'L','lng'=>'106.97662','lat'=>'26.45076']);
        $this->insert('{{%region}}',['id'=>'2668','pid'=>'2657','shortname'=>'惠水','name'=>'惠水县','merger_name'=>'中国,贵州省,黔南布依族苗族自治州,惠水县','level'=>'3','pinyin'=>'huishui','code'=>'0854','zip_code'=>'550600','first'=>'H','lng'=>'106.65911','lat'=>'26.13389']);
        $this->insert('{{%region}}',['id'=>'2669','pid'=>'2657','shortname'=>'三都','name'=>'三都水族自治县','merger_name'=>'中国,贵州省,黔南布依族苗族自治州,三都水族自治县','level'=>'3','pinyin'=>'sandu','code'=>'0854','zip_code'=>'558100','first'=>'S','lng'=>'107.87464','lat'=>'25.98562']);
        $this->insert('{{%region}}',['id'=>'2670','pid'=>'0','shortname'=>'云南','name'=>'云南省','merger_name'=>'中国,云南省','level'=>'1','pinyin'=>'yunnan','code'=>'','zip_code'=>'','first'=>'Y','lng'=>'102.712251','lat'=>'25.040609']);
        $this->insert('{{%region}}',['id'=>'2671','pid'=>'2670','shortname'=>'昆明','name'=>'昆明市','merger_name'=>'中国,云南省,昆明市','level'=>'2','pinyin'=>'kunming','code'=>'0871','zip_code'=>'650500','first'=>'K','lng'=>'102.712251','lat'=>'25.040609']);
        $this->insert('{{%region}}',['id'=>'2672','pid'=>'2671','shortname'=>'五华','name'=>'五华区','merger_name'=>'中国,云南省,昆明市,五华区','level'=>'3','pinyin'=>'wuhua','code'=>'0871','zip_code'=>'650021','first'=>'W','lng'=>'102.70786','lat'=>'25.03521']);
        $this->insert('{{%region}}',['id'=>'2673','pid'=>'2671','shortname'=>'盘龙','name'=>'盘龙区','merger_name'=>'中国,云南省,昆明市,盘龙区','level'=>'3','pinyin'=>'panlong','code'=>'0871','zip_code'=>'650051','first'=>'P','lng'=>'102.71994','lat'=>'25.04053']);
        $this->insert('{{%region}}',['id'=>'2674','pid'=>'2671','shortname'=>'官渡','name'=>'官渡区','merger_name'=>'中国,云南省,昆明市,官渡区','level'=>'3','pinyin'=>'guandu','code'=>'0871','zip_code'=>'650200','first'=>'G','lng'=>'102.74362','lat'=>'25.01497']);
        $this->insert('{{%region}}',['id'=>'2675','pid'=>'2671','shortname'=>'西山','name'=>'西山区','merger_name'=>'中国,云南省,昆明市,西山区','level'=>'3','pinyin'=>'xishan','code'=>'0871','zip_code'=>'650118','first'=>'X','lng'=>'102.66464','lat'=>'25.03796']);
        $this->insert('{{%region}}',['id'=>'2676','pid'=>'2671','shortname'=>'东川','name'=>'东川区','merger_name'=>'中国,云南省,昆明市,东川区','level'=>'3','pinyin'=>'dongchuan','code'=>'0871','zip_code'=>'654100','first'=>'D','lng'=>'103.18832','lat'=>'26.083']);
        $this->insert('{{%region}}',['id'=>'2677','pid'=>'2671','shortname'=>'呈贡','name'=>'呈贡区','merger_name'=>'中国,云南省,昆明市,呈贡区','level'=>'3','pinyin'=>'chenggong','code'=>'0871','zip_code'=>'650500','first'=>'C','lng'=>'102.801382','lat'=>'24.889275']);
        $this->insert('{{%region}}',['id'=>'2678','pid'=>'2671','shortname'=>'晋宁','name'=>'晋宁县','merger_name'=>'中国,云南省,昆明市,晋宁县','level'=>'3','pinyin'=>'jinning','code'=>'0871','zip_code'=>'650600','first'=>'J','lng'=>'102.59393','lat'=>'24.6665']);
        $this->insert('{{%region}}',['id'=>'2679','pid'=>'2671','shortname'=>'富民','name'=>'富民县','merger_name'=>'中国,云南省,昆明市,富民县','level'=>'3','pinyin'=>'fumin','code'=>'0871','zip_code'=>'650400','first'=>'F','lng'=>'102.4985','lat'=>'25.22119']);
        $this->insert('{{%region}}',['id'=>'2680','pid'=>'2671','shortname'=>'宜良','name'=>'宜良县','merger_name'=>'中国,云南省,昆明市,宜良县','level'=>'3','pinyin'=>'yiliang','code'=>'0871','zip_code'=>'652100','first'=>'Y','lng'=>'103.14117','lat'=>'24.91705']);
        $this->insert('{{%region}}',['id'=>'2681','pid'=>'2671','shortname'=>'石林','name'=>'石林彝族自治县','merger_name'=>'中国,云南省,昆明市,石林彝族自治县','level'=>'3','pinyin'=>'shilin','code'=>'0871','zip_code'=>'652200','first'=>'S','lng'=>'103.27148','lat'=>'24.75897']);
        $this->insert('{{%region}}',['id'=>'2682','pid'=>'2671','shortname'=>'嵩明','name'=>'嵩明县','merger_name'=>'中国,云南省,昆明市,嵩明县','level'=>'3','pinyin'=>'songming','code'=>'0871','zip_code'=>'651700','first'=>NULL,'lng'=>'103.03729','lat'=>'25.33986']);
        $this->insert('{{%region}}',['id'=>'2683','pid'=>'2671','shortname'=>'禄劝','name'=>'禄劝彝族苗族自治县','merger_name'=>'中国,云南省,昆明市,禄劝彝族苗族自治县','level'=>'3','pinyin'=>'luquan','code'=>'0871','zip_code'=>'651500','first'=>'L','lng'=>'102.4671','lat'=>'25.55387']);
        $this->insert('{{%region}}',['id'=>'2684','pid'=>'2671','shortname'=>'寻甸','name'=>'寻甸回族彝族自治县 ','merger_name'=>'中国,云南省,昆明市,寻甸回族彝族自治县 ','level'=>'3','pinyin'=>'xundian','code'=>'0871','zip_code'=>'655200','first'=>'X','lng'=>'103.2557','lat'=>'25.55961']);
        $this->insert('{{%region}}',['id'=>'2685','pid'=>'2671','shortname'=>'安宁','name'=>'安宁市','merger_name'=>'中国,云南省,昆明市,安宁市','level'=>'3','pinyin'=>'anning','code'=>'0871','zip_code'=>'650300','first'=>'A','lng'=>'102.46972','lat'=>'24.91652']);
        $this->insert('{{%region}}',['id'=>'2686','pid'=>'2670','shortname'=>'曲靖','name'=>'曲靖市','merger_name'=>'中国,云南省,曲靖市','level'=>'2','pinyin'=>'qujing','code'=>'0874','zip_code'=>'655000','first'=>'Q','lng'=>'103.797851','lat'=>'25.501557']);
        $this->insert('{{%region}}',['id'=>'2687','pid'=>'2686','shortname'=>'麒麟','name'=>'麒麟区','merger_name'=>'中国,云南省,曲靖市,麒麟区','level'=>'3','pinyin'=>'qilin','code'=>'0874','zip_code'=>'655000','first'=>NULL,'lng'=>'103.80504','lat'=>'25.49515']);
        $this->insert('{{%region}}',['id'=>'2688','pid'=>'2686','shortname'=>'马龙','name'=>'马龙县','merger_name'=>'中国,云南省,曲靖市,马龙县','level'=>'3','pinyin'=>'malong','code'=>'0874','zip_code'=>'655100','first'=>'M','lng'=>'103.57873','lat'=>'25.42521']);
        $this->insert('{{%region}}',['id'=>'2689','pid'=>'2686','shortname'=>'陆良','name'=>'陆良县','merger_name'=>'中国,云南省,曲靖市,陆良县','level'=>'3','pinyin'=>'luliang','code'=>'0874','zip_code'=>'655600','first'=>'L','lng'=>'103.6665','lat'=>'25.02335']);
        $this->insert('{{%region}}',['id'=>'2690','pid'=>'2686','shortname'=>'师宗','name'=>'师宗县','merger_name'=>'中国,云南省,曲靖市,师宗县','level'=>'3','pinyin'=>'shizong','code'=>'0874','zip_code'=>'655700','first'=>'S','lng'=>'103.99084','lat'=>'24.82822']);
        $this->insert('{{%region}}',['id'=>'2691','pid'=>'2686','shortname'=>'罗平','name'=>'罗平县','merger_name'=>'中国,云南省,曲靖市,罗平县','level'=>'3','pinyin'=>'luoping','code'=>'0874','zip_code'=>'655800','first'=>'L','lng'=>'104.30859','lat'=>'24.88444']);
        $this->insert('{{%region}}',['id'=>'2692','pid'=>'2686','shortname'=>'富源','name'=>'富源县','merger_name'=>'中国,云南省,曲靖市,富源县','level'=>'3','pinyin'=>'fuyuan','code'=>'0874','zip_code'=>'655500','first'=>'F','lng'=>'104.25387','lat'=>'25.66587']);
        $this->insert('{{%region}}',['id'=>'2693','pid'=>'2686','shortname'=>'会泽','name'=>'会泽县','merger_name'=>'中国,云南省,曲靖市,会泽县','level'=>'3','pinyin'=>'huize','code'=>'0874','zip_code'=>'654200','first'=>'H','lng'=>'103.30017','lat'=>'26.41076']);
        $this->insert('{{%region}}',['id'=>'2694','pid'=>'2686','shortname'=>'沾益','name'=>'沾益县','merger_name'=>'中国,云南省,曲靖市,沾益县','level'=>'3','pinyin'=>'zhanyi','code'=>'0874','zip_code'=>'655331','first'=>'Z','lng'=>'103.82135','lat'=>'25.60715']);
        $this->insert('{{%region}}',['id'=>'2695','pid'=>'2686','shortname'=>'宣威','name'=>'宣威市','merger_name'=>'中国,云南省,曲靖市,宣威市','level'=>'3','pinyin'=>'xuanwei','code'=>'0874','zip_code'=>'655400','first'=>'X','lng'=>'104.10409','lat'=>'26.2173']);
        $this->insert('{{%region}}',['id'=>'2696','pid'=>'2670','shortname'=>'玉溪','name'=>'玉溪市','merger_name'=>'中国,云南省,玉溪市','level'=>'2','pinyin'=>'yuxi','code'=>'0877','zip_code'=>'653100','first'=>'Y','lng'=>'102.543907','lat'=>'24.350461']);
        $this->insert('{{%region}}',['id'=>'2697','pid'=>'2696','shortname'=>'红塔','name'=>'红塔区','merger_name'=>'中国,云南省,玉溪市,红塔区','level'=>'3','pinyin'=>'hongta','code'=>'0877','zip_code'=>'653100','first'=>'H','lng'=>'102.5449','lat'=>'24.35411']);
        $this->insert('{{%region}}',['id'=>'2698','pid'=>'2696','shortname'=>'江川','name'=>'江川县','merger_name'=>'中国,云南省,玉溪市,江川县','level'=>'3','pinyin'=>'jiangchuan','code'=>'0877','zip_code'=>'652600','first'=>'J','lng'=>'102.75412','lat'=>'24.28863']);
        $this->insert('{{%region}}',['id'=>'2699','pid'=>'2696','shortname'=>'澄江','name'=>'澄江县','merger_name'=>'中国,云南省,玉溪市,澄江县','level'=>'3','pinyin'=>'chengjiang','code'=>'0877','zip_code'=>'652500','first'=>'C','lng'=>'102.90817','lat'=>'24.67376']);
        $this->insert('{{%region}}',['id'=>'2700','pid'=>'2696','shortname'=>'通海','name'=>'通海县','merger_name'=>'中国,云南省,玉溪市,通海县','level'=>'3','pinyin'=>'tonghai','code'=>'0877','zip_code'=>'652700','first'=>'T','lng'=>'102.76641','lat'=>'24.11362']);
        $this->insert('{{%region}}',['id'=>'2701','pid'=>'2696','shortname'=>'华宁','name'=>'华宁县','merger_name'=>'中国,云南省,玉溪市,华宁县','level'=>'3','pinyin'=>'huaning','code'=>'0877','zip_code'=>'652800','first'=>'H','lng'=>'102.92831','lat'=>'24.1926']);
        $this->insert('{{%region}}',['id'=>'2702','pid'=>'2696','shortname'=>'易门','name'=>'易门县','merger_name'=>'中国,云南省,玉溪市,易门县','level'=>'3','pinyin'=>'yimen','code'=>'0877','zip_code'=>'651100','first'=>'Y','lng'=>'102.16354','lat'=>'24.67122']);
        $this->insert('{{%region}}',['id'=>'2703','pid'=>'2696','shortname'=>'峨山','name'=>'峨山彝族自治县','merger_name'=>'中国,云南省,玉溪市,峨山彝族自治县','level'=>'3','pinyin'=>'eshan','code'=>'0877','zip_code'=>'653200','first'=>'E','lng'=>'102.40576','lat'=>'24.16904']);
        $this->insert('{{%region}}',['id'=>'2704','pid'=>'2696','shortname'=>'新平','name'=>'新平彝族傣族自治县','merger_name'=>'中国,云南省,玉溪市,新平彝族傣族自治县','level'=>'3','pinyin'=>'xinping','code'=>'0877','zip_code'=>'653400','first'=>'X','lng'=>'101.98895','lat'=>'24.06886']);
        $this->insert('{{%region}}',['id'=>'2705','pid'=>'2696','shortname'=>'元江','name'=>'元江哈尼族彝族傣族自治县','merger_name'=>'中国,云南省,玉溪市,元江哈尼族彝族傣族自治县','level'=>'3','pinyin'=>'yuanjiang','code'=>'0877','zip_code'=>'653300','first'=>'Y','lng'=>'101.99812','lat'=>'23.59655']);
        $this->insert('{{%region}}',['id'=>'2706','pid'=>'2670','shortname'=>'保山','name'=>'保山市','merger_name'=>'中国,云南省,保山市','level'=>'2','pinyin'=>'baoshan','code'=>'0875','zip_code'=>'678000','first'=>'B','lng'=>'99.167133','lat'=>'25.111802']);
        $this->insert('{{%region}}',['id'=>'2707','pid'=>'2706','shortname'=>'隆阳','name'=>'隆阳区','merger_name'=>'中国,云南省,保山市,隆阳区','level'=>'3','pinyin'=>'longyang','code'=>'0875','zip_code'=>'678000','first'=>'L','lng'=>'99.16334','lat'=>'25.11163']);
        $this->insert('{{%region}}',['id'=>'2708','pid'=>'2706','shortname'=>'施甸','name'=>'施甸县','merger_name'=>'中国,云南省,保山市,施甸县','level'=>'3','pinyin'=>'shidian','code'=>'0875','zip_code'=>'678200','first'=>'S','lng'=>'99.18768','lat'=>'24.72418']);
        $this->insert('{{%region}}',['id'=>'2709','pid'=>'2706','shortname'=>'腾冲','name'=>'腾冲县','merger_name'=>'中国,云南省,保山市,腾冲县','level'=>'3','pinyin'=>'tengchong','code'=>'0875','zip_code'=>'679100','first'=>'T','lng'=>'98.49414','lat'=>'25.02539']);
        $this->insert('{{%region}}',['id'=>'2710','pid'=>'2706','shortname'=>'龙陵','name'=>'龙陵县','merger_name'=>'中国,云南省,保山市,龙陵县','level'=>'3','pinyin'=>'longling','code'=>'0875','zip_code'=>'678300','first'=>'L','lng'=>'98.69024','lat'=>'24.58746']);
        $this->insert('{{%region}}',['id'=>'2711','pid'=>'2706','shortname'=>'昌宁','name'=>'昌宁县','merger_name'=>'中国,云南省,保山市,昌宁县','level'=>'3','pinyin'=>'changning','code'=>'0875','zip_code'=>'678100','first'=>'C','lng'=>'99.6036','lat'=>'24.82763']);
        $this->insert('{{%region}}',['id'=>'2712','pid'=>'2670','shortname'=>'昭通','name'=>'昭通市','merger_name'=>'中国,云南省,昭通市','level'=>'2','pinyin'=>'zhaotong','code'=>'0870','zip_code'=>'657000','first'=>'Z','lng'=>'103.717216','lat'=>'27.336999']);
        $this->insert('{{%region}}',['id'=>'2713','pid'=>'2712','shortname'=>'昭阳','name'=>'昭阳区','merger_name'=>'中国,云南省,昭通市,昭阳区','level'=>'3','pinyin'=>'zhaoyang','code'=>'0870','zip_code'=>'657000','first'=>'Z','lng'=>'103.70654','lat'=>'27.31998']);
        $this->insert('{{%region}}',['id'=>'2714','pid'=>'2712','shortname'=>'鲁甸','name'=>'鲁甸县','merger_name'=>'中国,云南省,昭通市,鲁甸县','level'=>'3','pinyin'=>'ludian','code'=>'0870','zip_code'=>'657100','first'=>'L','lng'=>'103.54721','lat'=>'27.19238']);
        $this->insert('{{%region}}',['id'=>'2715','pid'=>'2712','shortname'=>'巧家','name'=>'巧家县','merger_name'=>'中国,云南省,昭通市,巧家县','level'=>'3','pinyin'=>'qiaojia','code'=>'0870','zip_code'=>'654600','first'=>'Q','lng'=>'102.92416','lat'=>'26.91237']);
        $this->insert('{{%region}}',['id'=>'2716','pid'=>'2712','shortname'=>'盐津','name'=>'盐津县','merger_name'=>'中国,云南省,昭通市,盐津县','level'=>'3','pinyin'=>'yanjin','code'=>'0870','zip_code'=>'657500','first'=>'Y','lng'=>'104.23461','lat'=>'28.10856']);
        $this->insert('{{%region}}',['id'=>'2717','pid'=>'2712','shortname'=>'大关','name'=>'大关县','merger_name'=>'中国,云南省,昭通市,大关县','level'=>'3','pinyin'=>'daguan','code'=>'0870','zip_code'=>'657400','first'=>'D','lng'=>'103.89254','lat'=>'27.7488']);
        $this->insert('{{%region}}',['id'=>'2718','pid'=>'2712','shortname'=>'永善','name'=>'永善县','merger_name'=>'中国,云南省,昭通市,永善县','level'=>'3','pinyin'=>'yongshan','code'=>'0870','zip_code'=>'657300','first'=>'Y','lng'=>'103.63504','lat'=>'28.2279']);
        $this->insert('{{%region}}',['id'=>'2719','pid'=>'2712','shortname'=>'绥江','name'=>'绥江县','merger_name'=>'中国,云南省,昭通市,绥江县','level'=>'3','pinyin'=>'suijiang','code'=>'0870','zip_code'=>'657700','first'=>'S','lng'=>'103.94937','lat'=>'28.59661']);
        $this->insert('{{%region}}',['id'=>'2720','pid'=>'2712','shortname'=>'镇雄','name'=>'镇雄县','merger_name'=>'中国,云南省,昭通市,镇雄县','level'=>'3','pinyin'=>'zhenxiong','code'=>'0870','zip_code'=>'657200','first'=>'Z','lng'=>'104.87258','lat'=>'27.43981']);
        $this->insert('{{%region}}',['id'=>'2721','pid'=>'2712','shortname'=>'彝良','name'=>'彝良县','merger_name'=>'中国,云南省,昭通市,彝良县','level'=>'3','pinyin'=>'yiliang','code'=>'0870','zip_code'=>'657600','first'=>'Y','lng'=>'104.04983','lat'=>'27.62809']);
        $this->insert('{{%region}}',['id'=>'2722','pid'=>'2712','shortname'=>'威信','name'=>'威信县','merger_name'=>'中国,云南省,昭通市,威信县','level'=>'3','pinyin'=>'weixin','code'=>'0870','zip_code'=>'657900','first'=>'W','lng'=>'105.04754','lat'=>'27.84065']);
        $this->insert('{{%region}}',['id'=>'2723','pid'=>'2712','shortname'=>'水富','name'=>'水富县','merger_name'=>'中国,云南省,昭通市,水富县','level'=>'3','pinyin'=>'shuifu','code'=>'0870','zip_code'=>'657800','first'=>'S','lng'=>'104.4158','lat'=>'28.62986']);
        $this->insert('{{%region}}',['id'=>'2724','pid'=>'2670','shortname'=>'丽江','name'=>'丽江市','merger_name'=>'中国,云南省,丽江市','level'=>'2','pinyin'=>'lijiang','code'=>'0888','zip_code'=>'674100','first'=>'L','lng'=>'100.233026','lat'=>'26.872108']);
        $this->insert('{{%region}}',['id'=>'2725','pid'=>'2724','shortname'=>'古城','name'=>'古城区','merger_name'=>'中国,云南省,丽江市,古城区','level'=>'3','pinyin'=>'gucheng','code'=>'0888','zip_code'=>'674100','first'=>'G','lng'=>'100.2257','lat'=>'26.87697']);
        $this->insert('{{%region}}',['id'=>'2726','pid'=>'2724','shortname'=>'玉龙','name'=>'玉龙纳西族自治县','merger_name'=>'中国,云南省,丽江市,玉龙纳西族自治县','level'=>'3','pinyin'=>'yulong','code'=>'0888','zip_code'=>'674100','first'=>'Y','lng'=>'100.2369','lat'=>'26.82149']);
        $this->insert('{{%region}}',['id'=>'2727','pid'=>'2724','shortname'=>'永胜','name'=>'永胜县','merger_name'=>'中国,云南省,丽江市,永胜县','level'=>'3','pinyin'=>'yongsheng','code'=>'0888','zip_code'=>'674200','first'=>'Y','lng'=>'100.74667','lat'=>'26.68591']);
        $this->insert('{{%region}}',['id'=>'2728','pid'=>'2724','shortname'=>'华坪','name'=>'华坪县','merger_name'=>'中国,云南省,丽江市,华坪县','level'=>'3','pinyin'=>'huaping','code'=>'0888','zip_code'=>'674800','first'=>'H','lng'=>'101.26562','lat'=>'26.62967']);
        $this->insert('{{%region}}',['id'=>'2729','pid'=>'2724','shortname'=>'宁蒗','name'=>'宁蒗彝族自治县','merger_name'=>'中国,云南省,丽江市,宁蒗彝族自治县','level'=>'3','pinyin'=>'ninglang','code'=>'0888','zip_code'=>'674300','first'=>'N','lng'=>'100.8507','lat'=>'27.28179']);
        $this->insert('{{%region}}',['id'=>'2730','pid'=>'2670','shortname'=>'普洱','name'=>'普洱市','merger_name'=>'中国,云南省,普洱市','level'=>'2','pinyin'=>'pu\'er','code'=>'0879','zip_code'=>'665000','first'=>'P','lng'=>'100.972344','lat'=>'22.777321']);
        $this->insert('{{%region}}',['id'=>'2731','pid'=>'2730','shortname'=>'思茅','name'=>'思茅区','merger_name'=>'中国,云南省,普洱市,思茅区','level'=>'3','pinyin'=>'simao','code'=>'0879','zip_code'=>'665000','first'=>'S','lng'=>'100.97716','lat'=>'22.78691']);
        $this->insert('{{%region}}',['id'=>'2732','pid'=>'2730','shortname'=>'宁洱','name'=>'宁洱哈尼族彝族自治县','merger_name'=>'中国,云南省,普洱市,宁洱哈尼族彝族自治县','level'=>'3','pinyin'=>'ninger','code'=>'0879','zip_code'=>'665100','first'=>'N','lng'=>'101.04653','lat'=>'23.06341']);
        $this->insert('{{%region}}',['id'=>'2733','pid'=>'2730','shortname'=>'墨江','name'=>'墨江哈尼族自治县','merger_name'=>'中国,云南省,普洱市,墨江哈尼族自治县','level'=>'3','pinyin'=>'mojiang','code'=>'0879','zip_code'=>'654800','first'=>'M','lng'=>'101.69171','lat'=>'23.43214']);
        $this->insert('{{%region}}',['id'=>'2734','pid'=>'2730','shortname'=>'景东','name'=>'景东彝族自治县','merger_name'=>'中国,云南省,普洱市,景东彝族自治县','level'=>'3','pinyin'=>'jingdong','code'=>'0879','zip_code'=>'676200','first'=>'J','lng'=>'100.83599','lat'=>'24.44791']);
        $this->insert('{{%region}}',['id'=>'2735','pid'=>'2730','shortname'=>'景谷','name'=>'景谷傣族彝族自治县','merger_name'=>'中国,云南省,普洱市,景谷傣族彝族自治县','level'=>'3','pinyin'=>'jinggu','code'=>'0879','zip_code'=>'666400','first'=>'J','lng'=>'100.70251','lat'=>'23.49705']);
        $this->insert('{{%region}}',['id'=>'2736','pid'=>'2730','shortname'=>'镇沅','name'=>'镇沅彝族哈尼族拉祜族自治县','merger_name'=>'中国,云南省,普洱市,镇沅彝族哈尼族拉祜族自治县','level'=>'3','pinyin'=>'zhenyuan','code'=>'0879','zip_code'=>'666500','first'=>'Z','lng'=>'101.10675','lat'=>'24.00557']);
        $this->insert('{{%region}}',['id'=>'2737','pid'=>'2730','shortname'=>'江城','name'=>'江城哈尼族彝族自治县','merger_name'=>'中国,云南省,普洱市,江城哈尼族彝族自治县','level'=>'3','pinyin'=>'jiangcheng','code'=>'0879','zip_code'=>'665900','first'=>'J','lng'=>'101.85788','lat'=>'22.58424']);
        $this->insert('{{%region}}',['id'=>'2738','pid'=>'2730','shortname'=>'孟连','name'=>'孟连傣族拉祜族佤族自治县','merger_name'=>'中国,云南省,普洱市,孟连傣族拉祜族佤族自治县','level'=>'3','pinyin'=>'menglian','code'=>'0879','zip_code'=>'665800','first'=>'M','lng'=>'99.58424','lat'=>'22.32922']);
        $this->insert('{{%region}}',['id'=>'2739','pid'=>'2730','shortname'=>'澜沧','name'=>'澜沧拉祜族自治县','merger_name'=>'中国,云南省,普洱市,澜沧拉祜族自治县','level'=>'3','pinyin'=>'lancang','code'=>'0879','zip_code'=>'665600','first'=>'L','lng'=>'99.93591','lat'=>'22.55474']);
        $this->insert('{{%region}}',['id'=>'2740','pid'=>'2730','shortname'=>'西盟','name'=>'西盟佤族自治县','merger_name'=>'中国,云南省,普洱市,西盟佤族自治县','level'=>'3','pinyin'=>'ximeng','code'=>'0879','zip_code'=>'665700','first'=>'X','lng'=>'99.59869','lat'=>'22.64774']);
        $this->insert('{{%region}}',['id'=>'2741','pid'=>'2670','shortname'=>'临沧','name'=>'临沧市','merger_name'=>'中国,云南省,临沧市','level'=>'2','pinyin'=>'lincang','code'=>'0883','zip_code'=>'677000','first'=>'L','lng'=>'100.08697','lat'=>'23.886567']);
        $this->insert('{{%region}}',['id'=>'2742','pid'=>'2741','shortname'=>'临翔','name'=>'临翔区','merger_name'=>'中国,云南省,临沧市,临翔区','level'=>'3','pinyin'=>'linxiang','code'=>'0883','zip_code'=>'677000','first'=>'L','lng'=>'100.08242','lat'=>'23.89497']);
        $this->insert('{{%region}}',['id'=>'2743','pid'=>'2741','shortname'=>'凤庆','name'=>'凤庆县','merger_name'=>'中国,云南省,临沧市,凤庆县','level'=>'3','pinyin'=>'fengqing','code'=>'0883','zip_code'=>'675900','first'=>'F','lng'=>'99.92837','lat'=>'24.58034']);
        $this->insert('{{%region}}',['id'=>'2744','pid'=>'2741','shortname'=>'云县','name'=>'云县','merger_name'=>'中国,云南省,临沧市,云县','level'=>'3','pinyin'=>'yunxian','code'=>'0883','zip_code'=>'675800','first'=>'Y','lng'=>'100.12808','lat'=>'24.44675']);
        $this->insert('{{%region}}',['id'=>'2745','pid'=>'2741','shortname'=>'永德','name'=>'永德县','merger_name'=>'中国,云南省,临沧市,永德县','level'=>'3','pinyin'=>'yongde','code'=>'0883','zip_code'=>'677600','first'=>'Y','lng'=>'99.25326','lat'=>'24.0276']);
        $this->insert('{{%region}}',['id'=>'2746','pid'=>'2741','shortname'=>'镇康','name'=>'镇康县','merger_name'=>'中国,云南省,临沧市,镇康县','level'=>'3','pinyin'=>'zhenkang','code'=>'0883','zip_code'=>'677704','first'=>'Z','lng'=>'98.8255','lat'=>'23.76241']);
        $this->insert('{{%region}}',['id'=>'2747','pid'=>'2741','shortname'=>'双江','name'=>'双江拉祜族佤族布朗族傣族自治县','merger_name'=>'中国,云南省,临沧市,双江拉祜族佤族布朗族傣族自治县','level'=>'3','pinyin'=>'shuangjiang','code'=>'0883','zip_code'=>'677300','first'=>'S','lng'=>'99.82769','lat'=>'23.47349']);
        $this->insert('{{%region}}',['id'=>'2748','pid'=>'2741','shortname'=>'耿马','name'=>'耿马傣族佤族自治县','merger_name'=>'中国,云南省,临沧市,耿马傣族佤族自治县','level'=>'3','pinyin'=>'gengma','code'=>'0883','zip_code'=>'677500','first'=>'G','lng'=>'99.39785','lat'=>'23.53776']);
        $this->insert('{{%region}}',['id'=>'2749','pid'=>'2741','shortname'=>'沧源','name'=>'沧源佤族自治县','merger_name'=>'中国,云南省,临沧市,沧源佤族自治县','level'=>'3','pinyin'=>'cangyuan','code'=>'0883','zip_code'=>'677400','first'=>'C','lng'=>'99.24545','lat'=>'23.14821']);
        $this->insert('{{%region}}',['id'=>'2750','pid'=>'2670','shortname'=>'楚雄','name'=>'楚雄彝族自治州','merger_name'=>'中国,云南省,楚雄彝族自治州','level'=>'2','pinyin'=>'chuxiong','code'=>'0878','zip_code'=>'675000','first'=>'C','lng'=>'101.546046','lat'=>'25.041988']);
        $this->insert('{{%region}}',['id'=>'2751','pid'=>'2750','shortname'=>'楚雄','name'=>'楚雄市','merger_name'=>'中国,云南省,楚雄彝族自治州,楚雄市','level'=>'3','pinyin'=>'chuxiong','code'=>'0878','zip_code'=>'675000','first'=>'C','lng'=>'101.54615','lat'=>'25.0329']);
        $this->insert('{{%region}}',['id'=>'2752','pid'=>'2750','shortname'=>'双柏','name'=>'双柏县','merger_name'=>'中国,云南省,楚雄彝族自治州,双柏县','level'=>'3','pinyin'=>'shuangbai','code'=>'0878','zip_code'=>'675100','first'=>'S','lng'=>'101.64205','lat'=>'24.68882']);
        $this->insert('{{%region}}',['id'=>'2753','pid'=>'2750','shortname'=>'牟定','name'=>'牟定县','merger_name'=>'中国,云南省,楚雄彝族自治州,牟定县','level'=>'3','pinyin'=>'mouding','code'=>'0878','zip_code'=>'675500','first'=>'M','lng'=>'101.54','lat'=>'25.31551']);
        $this->insert('{{%region}}',['id'=>'2754','pid'=>'2750','shortname'=>'南华','name'=>'南华县','merger_name'=>'中国,云南省,楚雄彝族自治州,南华县','level'=>'3','pinyin'=>'nanhua','code'=>'0878','zip_code'=>'675200','first'=>'N','lng'=>'101.27313','lat'=>'25.19293']);
        $this->insert('{{%region}}',['id'=>'2755','pid'=>'2750','shortname'=>'姚安','name'=>'姚安县','merger_name'=>'中国,云南省,楚雄彝族自治州,姚安县','level'=>'3','pinyin'=>'yao\'an','code'=>'0878','zip_code'=>'675300','first'=>'Y','lng'=>'101.24279','lat'=>'25.50467']);
        $this->insert('{{%region}}',['id'=>'2756','pid'=>'2750','shortname'=>'大姚','name'=>'大姚县','merger_name'=>'中国,云南省,楚雄彝族自治州,大姚县','level'=>'3','pinyin'=>'dayao','code'=>'0878','zip_code'=>'675400','first'=>'D','lng'=>'101.32397','lat'=>'25.72218']);
        $this->insert('{{%region}}',['id'=>'2757','pid'=>'2750','shortname'=>'永仁','name'=>'永仁县','merger_name'=>'中国,云南省,楚雄彝族自治州,永仁县','level'=>'3','pinyin'=>'yongren','code'=>'0878','zip_code'=>'651400','first'=>'Y','lng'=>'101.6716','lat'=>'26.05794']);
        $this->insert('{{%region}}',['id'=>'2758','pid'=>'2750','shortname'=>'元谋','name'=>'元谋县','merger_name'=>'中国,云南省,楚雄彝族自治州,元谋县','level'=>'3','pinyin'=>'yuanmou','code'=>'0878','zip_code'=>'651300','first'=>'Y','lng'=>'101.87728','lat'=>'25.70438']);
        $this->insert('{{%region}}',['id'=>'2759','pid'=>'2750','shortname'=>'武定','name'=>'武定县','merger_name'=>'中国,云南省,楚雄彝族自治州,武定县','level'=>'3','pinyin'=>'wuding','code'=>'0878','zip_code'=>'651600','first'=>'W','lng'=>'102.4038','lat'=>'25.5295']);
        $this->insert('{{%region}}',['id'=>'2760','pid'=>'2750','shortname'=>'禄丰','name'=>'禄丰县','merger_name'=>'中国,云南省,楚雄彝族自治州,禄丰县','level'=>'3','pinyin'=>'lufeng','code'=>'0878','zip_code'=>'651200','first'=>'L','lng'=>'102.07797','lat'=>'25.14815']);
        $this->insert('{{%region}}',['id'=>'2761','pid'=>'2670','shortname'=>'红河','name'=>'红河哈尼族彝族自治州','merger_name'=>'中国,云南省,红河哈尼族彝族自治州','level'=>'2','pinyin'=>'honghe','code'=>'0873','zip_code'=>'661400','first'=>'H','lng'=>'103.384182','lat'=>'23.366775']);
        $this->insert('{{%region}}',['id'=>'2762','pid'=>'2761','shortname'=>'个旧','name'=>'个旧市','merger_name'=>'中国,云南省,红河哈尼族彝族自治州,个旧市','level'=>'3','pinyin'=>'gejiu','code'=>'0873','zip_code'=>'661000','first'=>'G','lng'=>'103.15966','lat'=>'23.35894']);
        $this->insert('{{%region}}',['id'=>'2763','pid'=>'2761','shortname'=>'开远','name'=>'开远市','merger_name'=>'中国,云南省,红河哈尼族彝族自治州,开远市','level'=>'3','pinyin'=>'kaiyuan','code'=>'0873','zip_code'=>'661600','first'=>'K','lng'=>'103.26986','lat'=>'23.71012']);
        $this->insert('{{%region}}',['id'=>'2764','pid'=>'2761','shortname'=>'蒙自','name'=>'蒙自市','merger_name'=>'中国,云南省,红河哈尼族彝族自治州,蒙自市','level'=>'3','pinyin'=>'mengzi','code'=>'0873','zip_code'=>'661101','first'=>'M','lng'=>'103.385005','lat'=>'23.366843']);
        $this->insert('{{%region}}',['id'=>'2765','pid'=>'2761','shortname'=>'弥勒','name'=>'弥勒市','merger_name'=>'中国,云南省,红河哈尼族彝族自治州,弥勒市','level'=>'3','pinyin'=>'mile','code'=>'0873','zip_code'=>'652300','first'=>'M','lng'=>'103.436988','lat'=>'24.40837']);
        $this->insert('{{%region}}',['id'=>'2766','pid'=>'2761','shortname'=>'屏边','name'=>'屏边苗族自治县','merger_name'=>'中国,云南省,红河哈尼族彝族自治州,屏边苗族自治县','level'=>'3','pinyin'=>'pingbian','code'=>'0873','zip_code'=>'661200','first'=>'P','lng'=>'103.68554','lat'=>'22.98425']);
        $this->insert('{{%region}}',['id'=>'2767','pid'=>'2761','shortname'=>'建水','name'=>'建水县','merger_name'=>'中国,云南省,红河哈尼族彝族自治州,建水县','level'=>'3','pinyin'=>'jianshui','code'=>'0873','zip_code'=>'654300','first'=>'J','lng'=>'102.82656','lat'=>'23.63472']);
        $this->insert('{{%region}}',['id'=>'2768','pid'=>'2761','shortname'=>'石屏','name'=>'石屏县','merger_name'=>'中国,云南省,红河哈尼族彝族自治州,石屏县','level'=>'3','pinyin'=>'shiping','code'=>'0873','zip_code'=>'662200','first'=>'S','lng'=>'102.49408','lat'=>'23.71441']);
        $this->insert('{{%region}}',['id'=>'2769','pid'=>'2761','shortname'=>'泸西','name'=>'泸西县','merger_name'=>'中国,云南省,红河哈尼族彝族自治州,泸西县','level'=>'3','pinyin'=>'luxi','code'=>'0873','zip_code'=>'652400','first'=>NULL,'lng'=>'103.76373','lat'=>'24.52854']);
        $this->insert('{{%region}}',['id'=>'2770','pid'=>'2761','shortname'=>'元阳','name'=>'元阳县','merger_name'=>'中国,云南省,红河哈尼族彝族自治州,元阳县','level'=>'3','pinyin'=>'yuanyang','code'=>'0873','zip_code'=>'662400','first'=>'Y','lng'=>'102.83261','lat'=>'23.22281']);
        $this->insert('{{%region}}',['id'=>'2771','pid'=>'2761','shortname'=>'红河县','name'=>'红河县','merger_name'=>'中国,云南省,红河哈尼族彝族自治州,红河县','level'=>'3','pinyin'=>'honghexian','code'=>'0873','zip_code'=>'654400','first'=>'H','lng'=>'102.42059','lat'=>'23.36767']);
        $this->insert('{{%region}}',['id'=>'2772','pid'=>'2761','shortname'=>'金平','name'=>'金平苗族瑶族傣族自治县','merger_name'=>'中国,云南省,红河哈尼族彝族自治州,金平苗族瑶族傣族自治县','level'=>'3','pinyin'=>'jinping','code'=>'0873','zip_code'=>'661500','first'=>'J','lng'=>'103.22651','lat'=>'22.77959']);
        $this->insert('{{%region}}',['id'=>'2773','pid'=>'2761','shortname'=>'绿春','name'=>'绿春县','merger_name'=>'中国,云南省,红河哈尼族彝族自治州,绿春县','level'=>'3','pinyin'=>'lvchun','code'=>'0873','zip_code'=>'662500','first'=>'L','lng'=>'102.39672','lat'=>'22.99371']);
        $this->insert('{{%region}}',['id'=>'2774','pid'=>'2761','shortname'=>'河口','name'=>'河口瑶族自治县','merger_name'=>'中国,云南省,红河哈尼族彝族自治州,河口瑶族自治县','level'=>'3','pinyin'=>'hekou','code'=>'0873','zip_code'=>'661300','first'=>'H','lng'=>'103.93936','lat'=>'22.52929']);
        $this->insert('{{%region}}',['id'=>'2775','pid'=>'2670','shortname'=>'文山','name'=>'文山壮族苗族自治州','merger_name'=>'中国,云南省,文山壮族苗族自治州','level'=>'2','pinyin'=>'wenshan','code'=>'0876','zip_code'=>'663000','first'=>'W','lng'=>'104.24401','lat'=>'23.36951']);
        $this->insert('{{%region}}',['id'=>'2776','pid'=>'2775','shortname'=>'文山','name'=>'文山市','merger_name'=>'中国,云南省,文山壮族苗族自治州,文山市','level'=>'3','pinyin'=>'wenshan','code'=>'0876','zip_code'=>'663000','first'=>'W','lng'=>'104.244277','lat'=>'23.369216']);
        $this->insert('{{%region}}',['id'=>'2777','pid'=>'2775','shortname'=>'砚山','name'=>'砚山县','merger_name'=>'中国,云南省,文山壮族苗族自治州,砚山县','level'=>'3','pinyin'=>'yanshan','code'=>'0876','zip_code'=>'663100','first'=>'Y','lng'=>'104.33306','lat'=>'23.60723']);
        $this->insert('{{%region}}',['id'=>'2778','pid'=>'2775','shortname'=>'西畴','name'=>'西畴县','merger_name'=>'中国,云南省,文山壮族苗族自治州,西畴县','level'=>'3','pinyin'=>'xichou','code'=>'0876','zip_code'=>'663500','first'=>'X','lng'=>'104.67419','lat'=>'23.43941']);
        $this->insert('{{%region}}',['id'=>'2779','pid'=>'2775','shortname'=>'麻栗坡','name'=>'麻栗坡县','merger_name'=>'中国,云南省,文山壮族苗族自治州,麻栗坡县','level'=>'3','pinyin'=>'malipo','code'=>'0876','zip_code'=>'663600','first'=>'M','lng'=>'104.70132','lat'=>'23.12028']);
        $this->insert('{{%region}}',['id'=>'2780','pid'=>'2775','shortname'=>'马关','name'=>'马关县','merger_name'=>'中国,云南省,文山壮族苗族自治州,马关县','level'=>'3','pinyin'=>'maguan','code'=>'0876','zip_code'=>'663700','first'=>'M','lng'=>'104.39514','lat'=>'23.01293']);
        $this->insert('{{%region}}',['id'=>'2781','pid'=>'2775','shortname'=>'丘北','name'=>'丘北县','merger_name'=>'中国,云南省,文山壮族苗族自治州,丘北县','level'=>'3','pinyin'=>'qiubei','code'=>'0876','zip_code'=>'663200','first'=>'Q','lng'=>'104.19256','lat'=>'24.03957']);
        $this->insert('{{%region}}',['id'=>'2782','pid'=>'2775','shortname'=>'广南','name'=>'广南县','merger_name'=>'中国,云南省,文山壮族苗族自治州,广南县','level'=>'3','pinyin'=>'guangnan','code'=>'0876','zip_code'=>'663300','first'=>'G','lng'=>'105.05511','lat'=>'24.0464']);
        $this->insert('{{%region}}',['id'=>'2783','pid'=>'2775','shortname'=>'富宁','name'=>'富宁县','merger_name'=>'中国,云南省,文山壮族苗族自治州,富宁县','level'=>'3','pinyin'=>'funing','code'=>'0876','zip_code'=>'663400','first'=>'F','lng'=>'105.63085','lat'=>'23.62536']);
        $this->insert('{{%region}}',['id'=>'2784','pid'=>'2670','shortname'=>'西双版纳','name'=>'西双版纳傣族自治州','merger_name'=>'中国,云南省,西双版纳傣族自治州','level'=>'2','pinyin'=>'xishuangbanna','code'=>'0691','zip_code'=>'666100','first'=>'X','lng'=>'100.797941','lat'=>'22.001724']);
        $this->insert('{{%region}}',['id'=>'2785','pid'=>'2784','shortname'=>'景洪','name'=>'景洪市','merger_name'=>'中国,云南省,西双版纳傣族自治州,景洪市','level'=>'3','pinyin'=>'jinghong','code'=>'0691','zip_code'=>'666100','first'=>'J','lng'=>'100.79977','lat'=>'22.01071']);
        $this->insert('{{%region}}',['id'=>'2786','pid'=>'2784','shortname'=>'勐海','name'=>'勐海县','merger_name'=>'中国,云南省,西双版纳傣族自治州,勐海县','level'=>'3','pinyin'=>'menghai','code'=>'0691','zip_code'=>'666200','first'=>NULL,'lng'=>'100.44931','lat'=>'21.96175']);
        $this->insert('{{%region}}',['id'=>'2787','pid'=>'2784','shortname'=>'勐腊','name'=>'勐腊县','merger_name'=>'中国,云南省,西双版纳傣族自治州,勐腊县','level'=>'3','pinyin'=>'mengla','code'=>'0691','zip_code'=>'666300','first'=>NULL,'lng'=>'101.56488','lat'=>'21.48162']);
        $this->insert('{{%region}}',['id'=>'2788','pid'=>'2670','shortname'=>'大理','name'=>'大理白族自治州','merger_name'=>'中国,云南省,大理白族自治州','level'=>'2','pinyin'=>'dali','code'=>'0872','zip_code'=>'671000','first'=>'D','lng'=>'100.240037','lat'=>'25.592765']);
        $this->insert('{{%region}}',['id'=>'2789','pid'=>'2788','shortname'=>'大理','name'=>'大理市','merger_name'=>'中国,云南省,大理白族自治州,大理市','level'=>'3','pinyin'=>'dali','code'=>'0872','zip_code'=>'671000','first'=>'D','lng'=>'100.22998','lat'=>'25.59157']);
        $this->insert('{{%region}}',['id'=>'2790','pid'=>'2788','shortname'=>'漾濞','name'=>'漾濞彝族自治县','merger_name'=>'中国,云南省,大理白族自治州,漾濞彝族自治县','level'=>'3','pinyin'=>'yangbi','code'=>'0872','zip_code'=>'672500','first'=>'Y','lng'=>'99.95474','lat'=>'25.6652']);
        $this->insert('{{%region}}',['id'=>'2791','pid'=>'2788','shortname'=>'祥云','name'=>'祥云县','merger_name'=>'中国,云南省,大理白族自治州,祥云县','level'=>'3','pinyin'=>'xiangyun','code'=>'0872','zip_code'=>'672100','first'=>'X','lng'=>'100.55761','lat'=>'25.47342']);
        $this->insert('{{%region}}',['id'=>'2792','pid'=>'2788','shortname'=>'宾川','name'=>'宾川县','merger_name'=>'中国,云南省,大理白族自治州,宾川县','level'=>'3','pinyin'=>'binchuan','code'=>'0872','zip_code'=>'671600','first'=>'B','lng'=>'100.57666','lat'=>'25.83144']);
        $this->insert('{{%region}}',['id'=>'2793','pid'=>'2788','shortname'=>'弥渡','name'=>'弥渡县','merger_name'=>'中国,云南省,大理白族自治州,弥渡县','level'=>'3','pinyin'=>'midu','code'=>'0872','zip_code'=>'675600','first'=>'M','lng'=>'100.49075','lat'=>'25.34179']);
        $this->insert('{{%region}}',['id'=>'2794','pid'=>'2788','shortname'=>'南涧','name'=>'南涧彝族自治县','merger_name'=>'中国,云南省,大理白族自治州,南涧彝族自治县','level'=>'3','pinyin'=>'nanjian','code'=>'0872','zip_code'=>'675700','first'=>'N','lng'=>'100.50964','lat'=>'25.04349']);
        $this->insert('{{%region}}',['id'=>'2795','pid'=>'2788','shortname'=>'巍山','name'=>'巍山彝族回族自治县','merger_name'=>'中国,云南省,大理白族自治州,巍山彝族回族自治县','level'=>'3','pinyin'=>'weishan','code'=>'0872','zip_code'=>'672400','first'=>'W','lng'=>'100.30612','lat'=>'25.23197']);
        $this->insert('{{%region}}',['id'=>'2796','pid'=>'2788','shortname'=>'永平','name'=>'永平县','merger_name'=>'中国,云南省,大理白族自治州,永平县','level'=>'3','pinyin'=>'yongping','code'=>'0872','zip_code'=>'672600','first'=>'Y','lng'=>'99.54095','lat'=>'25.46451']);
        $this->insert('{{%region}}',['id'=>'2797','pid'=>'2788','shortname'=>'云龙','name'=>'云龙县','merger_name'=>'中国,云南省,大理白族自治州,云龙县','level'=>'3','pinyin'=>'yunlong','code'=>'0872','zip_code'=>'672700','first'=>'Y','lng'=>'99.37255','lat'=>'25.88505']);
        $this->insert('{{%region}}',['id'=>'2798','pid'=>'2788','shortname'=>'洱源','name'=>'洱源县','merger_name'=>'中国,云南省,大理白族自治州,洱源县','level'=>'3','pinyin'=>'eryuan','code'=>'0872','zip_code'=>'671200','first'=>'E','lng'=>'99.94903','lat'=>'26.10829']);
        $this->insert('{{%region}}',['id'=>'2799','pid'=>'2788','shortname'=>'剑川','name'=>'剑川县','merger_name'=>'中国,云南省,大理白族自治州,剑川县','level'=>'3','pinyin'=>'jianchuan','code'=>'0872','zip_code'=>'671300','first'=>'J','lng'=>'99.90545','lat'=>'26.53688']);
        $this->insert('{{%region}}',['id'=>'2800','pid'=>'2788','shortname'=>'鹤庆','name'=>'鹤庆县','merger_name'=>'中国,云南省,大理白族自治州,鹤庆县','level'=>'3','pinyin'=>'heqing','code'=>'0872','zip_code'=>'671500','first'=>'H','lng'=>'100.17697','lat'=>'26.55798']);
        $this->insert('{{%region}}',['id'=>'2801','pid'=>'2670','shortname'=>'德宏','name'=>'德宏傣族景颇族自治州','merger_name'=>'中国,云南省,德宏傣族景颇族自治州','level'=>'2','pinyin'=>'dehong','code'=>'0692','zip_code'=>'678400','first'=>'D','lng'=>'98.578363','lat'=>'24.436694']);
        $this->insert('{{%region}}',['id'=>'2802','pid'=>'2801','shortname'=>'瑞丽','name'=>'瑞丽市','merger_name'=>'中国,云南省,德宏傣族景颇族自治州,瑞丽市','level'=>'3','pinyin'=>'ruili','code'=>'0692','zip_code'=>'678600','first'=>'R','lng'=>'97.85183','lat'=>'24.01277']);
        $this->insert('{{%region}}',['id'=>'2803','pid'=>'2801','shortname'=>'芒市','name'=>'芒市','merger_name'=>'中国,云南省,德宏傣族景颇族自治州,芒市','level'=>'3','pinyin'=>'mangshi','code'=>'0692','zip_code'=>'678400','first'=>'M','lng'=>'98.588641','lat'=>'24.433735']);
        $this->insert('{{%region}}',['id'=>'2804','pid'=>'2801','shortname'=>'梁河','name'=>'梁河县','merger_name'=>'中国,云南省,德宏傣族景颇族自治州,梁河县','level'=>'3','pinyin'=>'lianghe','code'=>'0692','zip_code'=>'679200','first'=>'L','lng'=>'98.29705','lat'=>'24.80658']);
        $this->insert('{{%region}}',['id'=>'2805','pid'=>'2801','shortname'=>'盈江','name'=>'盈江县','merger_name'=>'中国,云南省,德宏傣族景颇族自治州,盈江县','level'=>'3','pinyin'=>'yingjiang','code'=>'0692','zip_code'=>'679300','first'=>'Y','lng'=>'97.93179','lat'=>'24.70579']);
        $this->insert('{{%region}}',['id'=>'2806','pid'=>'2801','shortname'=>'陇川','name'=>'陇川县','merger_name'=>'中国,云南省,德宏傣族景颇族自治州,陇川县','level'=>'3','pinyin'=>'longchuan','code'=>'0692','zip_code'=>'678700','first'=>'L','lng'=>'97.79199','lat'=>'24.18302']);
        $this->insert('{{%region}}',['id'=>'2807','pid'=>'2670','shortname'=>'怒江','name'=>'怒江傈僳族自治州','merger_name'=>'中国,云南省,怒江傈僳族自治州','level'=>'2','pinyin'=>'nujiang','code'=>'0886','zip_code'=>'673100','first'=>'N','lng'=>'98.854304','lat'=>'25.850949']);
        $this->insert('{{%region}}',['id'=>'2808','pid'=>'2807','shortname'=>'泸水','name'=>'泸水县','merger_name'=>'中国,云南省,怒江傈僳族自治州,泸水县','level'=>'3','pinyin'=>'lushui','code'=>'0886','zip_code'=>'673100','first'=>NULL,'lng'=>'98.85534','lat'=>'25.83772']);
        $this->insert('{{%region}}',['id'=>'2809','pid'=>'2807','shortname'=>'福贡','name'=>'福贡县','merger_name'=>'中国,云南省,怒江傈僳族自治州,福贡县','level'=>'3','pinyin'=>'fugong','code'=>'0886','zip_code'=>'673400','first'=>'F','lng'=>'98.86969','lat'=>'26.90366']);
        $this->insert('{{%region}}',['id'=>'2810','pid'=>'2807','shortname'=>'贡山','name'=>'贡山独龙族怒族自治县','merger_name'=>'中国,云南省,怒江傈僳族自治州,贡山独龙族怒族自治县','level'=>'3','pinyin'=>'gongshan','code'=>'0886','zip_code'=>'673500','first'=>'G','lng'=>'98.66583','lat'=>'27.74088']);
        $this->insert('{{%region}}',['id'=>'2811','pid'=>'2807','shortname'=>'兰坪','name'=>'兰坪白族普米族自治县','merger_name'=>'中国,云南省,怒江傈僳族自治州,兰坪白族普米族自治县','level'=>'3','pinyin'=>'lanping','code'=>'0886','zip_code'=>'671400','first'=>'L','lng'=>'99.41891','lat'=>'26.45251']);
        $this->insert('{{%region}}',['id'=>'2812','pid'=>'2670','shortname'=>'迪庆','name'=>'迪庆藏族自治州','merger_name'=>'中国,云南省,迪庆藏族自治州','level'=>'2','pinyin'=>'deqen','code'=>'0887','zip_code'=>'674400','first'=>'D','lng'=>'99.706463','lat'=>'27.826853']);
        $this->insert('{{%region}}',['id'=>'2813','pid'=>'2812','shortname'=>'香格里拉','name'=>'香格里拉市','merger_name'=>'中国,云南省,迪庆藏族自治州,香格里拉市','level'=>'3','pinyin'=>'xianggelila','code'=>'0887','zip_code'=>'674400','first'=>'X','lng'=>'99.70601','lat'=>'27.82308']);
        $this->insert('{{%region}}',['id'=>'2814','pid'=>'2812','shortname'=>'德钦','name'=>'德钦县','merger_name'=>'中国,云南省,迪庆藏族自治州,德钦县','level'=>'3','pinyin'=>'deqin','code'=>'0887','zip_code'=>'674500','first'=>'D','lng'=>'98.91082','lat'=>'28.4863']);
        $this->insert('{{%region}}',['id'=>'2815','pid'=>'2812','shortname'=>'维西','name'=>'维西傈僳族自治县','merger_name'=>'中国,云南省,迪庆藏族自治州,维西傈僳族自治县','level'=>'3','pinyin'=>'weixi','code'=>'0887','zip_code'=>'674600','first'=>'W','lng'=>'99.28402','lat'=>'27.1793']);
        $this->insert('{{%region}}',['id'=>'2816','pid'=>'0','shortname'=>'西藏','name'=>'西藏自治区','merger_name'=>'中国,西藏自治区','level'=>'1','pinyin'=>'tibet','code'=>'','zip_code'=>'','first'=>'X','lng'=>'91.132212','lat'=>'29.660361']);
        $this->insert('{{%region}}',['id'=>'2817','pid'=>'2816','shortname'=>'拉萨','name'=>'拉萨市','merger_name'=>'中国,西藏自治区,拉萨市','level'=>'2','pinyin'=>'lhasa','code'=>'0891','zip_code'=>'850000','first'=>'L','lng'=>'91.132212','lat'=>'29.660361']);
        $this->insert('{{%region}}',['id'=>'2818','pid'=>'2817','shortname'=>'城关','name'=>'城关区','merger_name'=>'中国,西藏自治区,拉萨市,城关区','level'=>'3','pinyin'=>'chengguan','code'=>'0891','zip_code'=>'850000','first'=>'C','lng'=>'91.13859','lat'=>'29.65312']);
        $this->insert('{{%region}}',['id'=>'2819','pid'=>'2817','shortname'=>'林周','name'=>'林周县','merger_name'=>'中国,西藏自治区,拉萨市,林周县','level'=>'3','pinyin'=>'linzhou','code'=>'0891','zip_code'=>'851600','first'=>'L','lng'=>'91.2586','lat'=>'29.89445']);
        $this->insert('{{%region}}',['id'=>'2820','pid'=>'2817','shortname'=>'当雄','name'=>'当雄县','merger_name'=>'中国,西藏自治区,拉萨市,当雄县','level'=>'3','pinyin'=>'dangxiong','code'=>'0891','zip_code'=>'851500','first'=>'D','lng'=>'91.10076','lat'=>'30.48309']);
        $this->insert('{{%region}}',['id'=>'2821','pid'=>'2817','shortname'=>'尼木','name'=>'尼木县','merger_name'=>'中国,西藏自治区,拉萨市,尼木县','level'=>'3','pinyin'=>'nimu','code'=>'0891','zip_code'=>'851300','first'=>'N','lng'=>'90.16378','lat'=>'29.43353']);
        $this->insert('{{%region}}',['id'=>'2822','pid'=>'2817','shortname'=>'曲水','name'=>'曲水县','merger_name'=>'中国,西藏自治区,拉萨市,曲水县','level'=>'3','pinyin'=>'qushui','code'=>'0891','zip_code'=>'850600','first'=>'Q','lng'=>'90.73187','lat'=>'29.35636']);
        $this->insert('{{%region}}',['id'=>'2823','pid'=>'2817','shortname'=>'堆龙德庆','name'=>'堆龙德庆县','merger_name'=>'中国,西藏自治区,拉萨市,堆龙德庆县','level'=>'3','pinyin'=>'duilongdeqing','code'=>'0891','zip_code'=>'851400','first'=>'D','lng'=>'91.00033','lat'=>'29.65002']);
        $this->insert('{{%region}}',['id'=>'2824','pid'=>'2817','shortname'=>'达孜','name'=>'达孜县','merger_name'=>'中国,西藏自治区,拉萨市,达孜县','level'=>'3','pinyin'=>'dazi','code'=>'0891','zip_code'=>'850100','first'=>'D','lng'=>'91.35757','lat'=>'29.6722']);
        $this->insert('{{%region}}',['id'=>'2825','pid'=>'2817','shortname'=>'墨竹工卡','name'=>'墨竹工卡县','merger_name'=>'中国,西藏自治区,拉萨市,墨竹工卡县','level'=>'3','pinyin'=>'mozhugongka','code'=>'0891','zip_code'=>'850200','first'=>'M','lng'=>'91.72814','lat'=>'29.83614']);
        $this->insert('{{%region}}',['id'=>'2826','pid'=>'2816','shortname'=>'日喀则','name'=>'日喀则市','merger_name'=>'中国,西藏自治区,日喀则市','level'=>'2','pinyin'=>'rikaze','code'=>'0892','zip_code'=>'857000','first'=>'R','lng'=>'88.884874','lat'=>'29.263792']);
        $this->insert('{{%region}}',['id'=>'2827','pid'=>'2826','shortname'=>'桑珠孜','name'=>'桑珠孜区','merger_name'=>'中国,西藏自治区,日喀则市,桑珠孜区','level'=>'3','pinyin'=>'sangzhuzi','code'=>'0892','zip_code'=>'857000','first'=>'S','lng'=>'88.880367','lat'=>'29.269565']);
        $this->insert('{{%region}}',['id'=>'2828','pid'=>'2826','shortname'=>'南木林','name'=>'南木林县','merger_name'=>'中国,西藏自治区,日喀则市,南木林县','level'=>'3','pinyin'=>'nanmulin','code'=>'0892','zip_code'=>'857100','first'=>'N','lng'=>'89.09686','lat'=>'29.68206']);
        $this->insert('{{%region}}',['id'=>'2829','pid'=>'2826','shortname'=>'江孜','name'=>'江孜县','merger_name'=>'中国,西藏自治区,日喀则市,江孜县','level'=>'3','pinyin'=>'jiangzi','code'=>'0892','zip_code'=>'857400','first'=>'J','lng'=>'89.60263','lat'=>'28.91744']);
        $this->insert('{{%region}}',['id'=>'2830','pid'=>'2826','shortname'=>'定日','name'=>'定日县','merger_name'=>'中国,西藏自治区,日喀则市,定日县','level'=>'3','pinyin'=>'dingri','code'=>'0892','zip_code'=>'858200','first'=>'D','lng'=>'87.12176','lat'=>'28.66129']);
        $this->insert('{{%region}}',['id'=>'2831','pid'=>'2826','shortname'=>'萨迦','name'=>'萨迦县','merger_name'=>'中国,西藏自治区,日喀则市,萨迦县','level'=>'3','pinyin'=>'sajia','code'=>'0892','zip_code'=>'857800','first'=>'S','lng'=>'88.02191','lat'=>'28.90299']);
        $this->insert('{{%region}}',['id'=>'2832','pid'=>'2826','shortname'=>'拉孜','name'=>'拉孜县','merger_name'=>'中国,西藏自治区,日喀则市,拉孜县','level'=>'3','pinyin'=>'lazi','code'=>'0892','zip_code'=>'858100','first'=>'L','lng'=>'87.63412','lat'=>'29.085']);
        $this->insert('{{%region}}',['id'=>'2833','pid'=>'2826','shortname'=>'昂仁','name'=>'昂仁县','merger_name'=>'中国,西藏自治区,日喀则市,昂仁县','level'=>'3','pinyin'=>'angren','code'=>'0892','zip_code'=>'858500','first'=>'A','lng'=>'87.23858','lat'=>'29.29496']);
        $this->insert('{{%region}}',['id'=>'2834','pid'=>'2826','shortname'=>'谢通门','name'=>'谢通门县','merger_name'=>'中国,西藏自治区,日喀则市,谢通门县','level'=>'3','pinyin'=>'xietongmen','code'=>'0892','zip_code'=>'858900','first'=>'X','lng'=>'88.26242','lat'=>'29.43337']);
        $this->insert('{{%region}}',['id'=>'2835','pid'=>'2826','shortname'=>'白朗','name'=>'白朗县','merger_name'=>'中国,西藏自治区,日喀则市,白朗县','level'=>'3','pinyin'=>'bailang','code'=>'0892','zip_code'=>'857300','first'=>'B','lng'=>'89.26205','lat'=>'29.10553']);
        $this->insert('{{%region}}',['id'=>'2836','pid'=>'2826','shortname'=>'仁布','name'=>'仁布县','merger_name'=>'中国,西藏自治区,日喀则市,仁布县','level'=>'3','pinyin'=>'renbu','code'=>'0892','zip_code'=>'857200','first'=>'R','lng'=>'89.84228','lat'=>'29.2301']);
        $this->insert('{{%region}}',['id'=>'2837','pid'=>'2826','shortname'=>'康马','name'=>'康马县','merger_name'=>'中国,西藏自治区,日喀则市,康马县','level'=>'3','pinyin'=>'kangma','code'=>'0892','zip_code'=>'857500','first'=>'K','lng'=>'89.68527','lat'=>'28.5567']);
        $this->insert('{{%region}}',['id'=>'2838','pid'=>'2826','shortname'=>'定结','name'=>'定结县','merger_name'=>'中国,西藏自治区,日喀则市,定结县','level'=>'3','pinyin'=>'dingjie','code'=>'0892','zip_code'=>'857900','first'=>'D','lng'=>'87.77255','lat'=>'28.36403']);
        $this->insert('{{%region}}',['id'=>'2839','pid'=>'2826','shortname'=>'仲巴','name'=>'仲巴县','merger_name'=>'中国,西藏自治区,日喀则市,仲巴县','level'=>'3','pinyin'=>'zhongba','code'=>'0892','zip_code'=>'858800','first'=>'Z','lng'=>'84.02951','lat'=>'29.76595']);
        $this->insert('{{%region}}',['id'=>'2840','pid'=>'2826','shortname'=>'亚东','name'=>'亚东县','merger_name'=>'中国,西藏自治区,日喀则市,亚东县','level'=>'3','pinyin'=>'yadong','code'=>'0892','zip_code'=>'857600','first'=>'Y','lng'=>'88.90802','lat'=>'27.4839']);
        $this->insert('{{%region}}',['id'=>'2841','pid'=>'2826','shortname'=>'吉隆','name'=>'吉隆县','merger_name'=>'中国,西藏自治区,日喀则市,吉隆县','level'=>'3','pinyin'=>'jilong','code'=>'0892','zip_code'=>'858700','first'=>'J','lng'=>'85.29846','lat'=>'28.85382']);
        $this->insert('{{%region}}',['id'=>'2842','pid'=>'2826','shortname'=>'聂拉木','name'=>'聂拉木县','merger_name'=>'中国,西藏自治区,日喀则市,聂拉木县','level'=>'3','pinyin'=>'nielamu','code'=>'0892','zip_code'=>'858300','first'=>'N','lng'=>'85.97998','lat'=>'28.15645']);
        $this->insert('{{%region}}',['id'=>'2843','pid'=>'2826','shortname'=>'萨嘎','name'=>'萨嘎县','merger_name'=>'中国,西藏自治区,日喀则市,萨嘎县','level'=>'3','pinyin'=>'saga','code'=>'0892','zip_code'=>'857800','first'=>'S','lng'=>'85.23413','lat'=>'29.32936']);
        $this->insert('{{%region}}',['id'=>'2844','pid'=>'2826','shortname'=>'岗巴','name'=>'岗巴县','merger_name'=>'中国,西藏自治区,日喀则市,岗巴县','level'=>'3','pinyin'=>'gangba','code'=>'0892','zip_code'=>'857700','first'=>'G','lng'=>'88.52069','lat'=>'28.27504']);
        $this->insert('{{%region}}',['id'=>'2845','pid'=>'2816','shortname'=>'昌都','name'=>'昌都市','merger_name'=>'中国,西藏自治区,昌都市','level'=>'2','pinyin'=>'qamdo','code'=>'0895','zip_code'=>'854000','first'=>'C','lng'=>'97.178452','lat'=>'31.136875']);
        $this->insert('{{%region}}',['id'=>'2846','pid'=>'2845','shortname'=>'昌都','name'=>'卡若区','merger_name'=>'中国,西藏自治区,昌都市,卡若区','level'=>'3','pinyin'=>'karuo','code'=>'0895','zip_code'=>'854000','first'=>'K','lng'=>'97.18043','lat'=>'31.1385']);
        $this->insert('{{%region}}',['id'=>'2847','pid'=>'2845','shortname'=>'江达','name'=>'江达县','merger_name'=>'中国,西藏自治区,昌都市,江达县','level'=>'3','pinyin'=>'jiangda','code'=>'0895','zip_code'=>'854100','first'=>'J','lng'=>'98.21865','lat'=>'31.50343']);
        $this->insert('{{%region}}',['id'=>'2848','pid'=>'2845','shortname'=>'贡觉','name'=>'贡觉县','merger_name'=>'中国,西藏自治区,昌都市,贡觉县','level'=>'3','pinyin'=>'gongjue','code'=>'0895','zip_code'=>'854200','first'=>'G','lng'=>'98.27163','lat'=>'30.85941']);
        $this->insert('{{%region}}',['id'=>'2849','pid'=>'2845','shortname'=>'类乌齐','name'=>'类乌齐县','merger_name'=>'中国,西藏自治区,昌都市,类乌齐县','level'=>'3','pinyin'=>'leiwuqi','code'=>'0895','zip_code'=>'855600','first'=>'L','lng'=>'96.60015','lat'=>'31.21207']);
        $this->insert('{{%region}}',['id'=>'2850','pid'=>'2845','shortname'=>'丁青','name'=>'丁青县','merger_name'=>'中国,西藏自治区,昌都市,丁青县','level'=>'3','pinyin'=>'dingqing','code'=>'0895','zip_code'=>'855700','first'=>'D','lng'=>'95.59362','lat'=>'31.41621']);
        $this->insert('{{%region}}',['id'=>'2851','pid'=>'2845','shortname'=>'察雅','name'=>'察雅县','merger_name'=>'中国,西藏自治区,昌都市,察雅县','level'=>'3','pinyin'=>'chaya','code'=>'0895','zip_code'=>'854300','first'=>'C','lng'=>'97.56521','lat'=>'30.65336']);
        $this->insert('{{%region}}',['id'=>'2852','pid'=>'2845','shortname'=>'八宿','name'=>'八宿县','merger_name'=>'中国,西藏自治区,昌都市,八宿县','level'=>'3','pinyin'=>'basu','code'=>'0895','zip_code'=>'854600','first'=>'B','lng'=>'96.9176','lat'=>'30.05346']);
        $this->insert('{{%region}}',['id'=>'2853','pid'=>'2845','shortname'=>'左贡','name'=>'左贡县','merger_name'=>'中国,西藏自治区,昌都市,左贡县','level'=>'3','pinyin'=>'zuogong','code'=>'0895','zip_code'=>'854400','first'=>'Z','lng'=>'97.84429','lat'=>'29.67108']);
        $this->insert('{{%region}}',['id'=>'2854','pid'=>'2845','shortname'=>'芒康','name'=>'芒康县','merger_name'=>'中国,西藏自治区,昌都市,芒康县','level'=>'3','pinyin'=>'mangkang','code'=>'0895','zip_code'=>'854500','first'=>'M','lng'=>'98.59378','lat'=>'29.67946']);
        $this->insert('{{%region}}',['id'=>'2855','pid'=>'2845','shortname'=>'洛隆','name'=>'洛隆县','merger_name'=>'中国,西藏自治区,昌都市,洛隆县','level'=>'3','pinyin'=>'luolong','code'=>'0895','zip_code'=>'855400','first'=>'L','lng'=>'95.82644','lat'=>'30.74049']);
        $this->insert('{{%region}}',['id'=>'2856','pid'=>'2845','shortname'=>'边坝','name'=>'边坝县','merger_name'=>'中国,西藏自治区,昌都市,边坝县','level'=>'3','pinyin'=>'bianba','code'=>'0895','zip_code'=>'855500','first'=>'B','lng'=>'94.70687','lat'=>'30.93434']);
        $this->insert('{{%region}}',['id'=>'2857','pid'=>'2816','shortname'=>'山南','name'=>'山南地区','merger_name'=>'中国,西藏自治区,山南地区','level'=>'2','pinyin'=>'shannan','code'=>'0893','zip_code'=>'856000','first'=>'S','lng'=>'91.766529','lat'=>'29.236023']);
        $this->insert('{{%region}}',['id'=>'2858','pid'=>'2857','shortname'=>'乃东','name'=>'乃东县','merger_name'=>'中国,西藏自治区,山南地区,乃东县','level'=>'3','pinyin'=>'naidong','code'=>'0893','zip_code'=>'856100','first'=>'N','lng'=>'91.76153','lat'=>'29.2249']);
        $this->insert('{{%region}}',['id'=>'2859','pid'=>'2857','shortname'=>'扎囊','name'=>'扎囊县','merger_name'=>'中国,西藏自治区,山南地区,扎囊县','level'=>'3','pinyin'=>'zhanang','code'=>'0893','zip_code'=>'850800','first'=>'Z','lng'=>'91.33288','lat'=>'29.2399']);
        $this->insert('{{%region}}',['id'=>'2860','pid'=>'2857','shortname'=>'贡嘎','name'=>'贡嘎县','merger_name'=>'中国,西藏自治区,山南地区,贡嘎县','level'=>'3','pinyin'=>'gongga','code'=>'0893','zip_code'=>'850700','first'=>'G','lng'=>'90.98867','lat'=>'29.29408']);
        $this->insert('{{%region}}',['id'=>'2861','pid'=>'2857','shortname'=>'桑日','name'=>'桑日县','merger_name'=>'中国,西藏自治区,山南地区,桑日县','level'=>'3','pinyin'=>'sangri','code'=>'0893','zip_code'=>'856200','first'=>'S','lng'=>'92.02005','lat'=>'29.26643']);
        $this->insert('{{%region}}',['id'=>'2862','pid'=>'2857','shortname'=>'琼结','name'=>'琼结县','merger_name'=>'中国,西藏自治区,山南地区,琼结县','level'=>'3','pinyin'=>'qiongjie','code'=>'0893','zip_code'=>'856800','first'=>'Q','lng'=>'91.68093','lat'=>'29.02632']);
        $this->insert('{{%region}}',['id'=>'2863','pid'=>'2857','shortname'=>'曲松','name'=>'曲松县','merger_name'=>'中国,西藏自治区,山南地区,曲松县','level'=>'3','pinyin'=>'qusong','code'=>'0893','zip_code'=>'856300','first'=>'Q','lng'=>'92.20263','lat'=>'29.06412']);
        $this->insert('{{%region}}',['id'=>'2864','pid'=>'2857','shortname'=>'措美','name'=>'措美县','merger_name'=>'中国,西藏自治区,山南地区,措美县','level'=>'3','pinyin'=>'cuomei','code'=>'0893','zip_code'=>'856900','first'=>'C','lng'=>'91.43237','lat'=>'28.43794']);
        $this->insert('{{%region}}',['id'=>'2865','pid'=>'2857','shortname'=>'洛扎','name'=>'洛扎县','merger_name'=>'中国,西藏自治区,山南地区,洛扎县','level'=>'3','pinyin'=>'luozha','code'=>'0893','zip_code'=>'856600','first'=>'L','lng'=>'90.86035','lat'=>'28.3872']);
        $this->insert('{{%region}}',['id'=>'2866','pid'=>'2857','shortname'=>'加查','name'=>'加查县','merger_name'=>'中国,西藏自治区,山南地区,加查县','level'=>'3','pinyin'=>'jiacha','code'=>'0893','zip_code'=>'856400','first'=>'J','lng'=>'92.57702','lat'=>'29.13973']);
        $this->insert('{{%region}}',['id'=>'2867','pid'=>'2857','shortname'=>'隆子','name'=>'隆子县','merger_name'=>'中国,西藏自治区,山南地区,隆子县','level'=>'3','pinyin'=>'longzi','code'=>'0893','zip_code'=>'856600','first'=>'L','lng'=>'92.46148','lat'=>'28.40797']);
        $this->insert('{{%region}}',['id'=>'2868','pid'=>'2857','shortname'=>'错那','name'=>'错那县','merger_name'=>'中国,西藏自治区,山南地区,错那县','level'=>'3','pinyin'=>'cuona','code'=>'0893','zip_code'=>'856700','first'=>'C','lng'=>'91.95752','lat'=>'27.99224']);
        $this->insert('{{%region}}',['id'=>'2869','pid'=>'2857','shortname'=>'浪卡子','name'=>'浪卡子县','merger_name'=>'中国,西藏自治区,山南地区,浪卡子县','level'=>'3','pinyin'=>'langkazi','code'=>'0893','zip_code'=>'851100','first'=>'L','lng'=>'90.40002','lat'=>'28.96948']);
        $this->insert('{{%region}}',['id'=>'2870','pid'=>'2816','shortname'=>'那曲','name'=>'那曲地区','merger_name'=>'中国,西藏自治区,那曲地区','level'=>'2','pinyin'=>'nagqu','code'=>'0896','zip_code'=>'852000','first'=>'N','lng'=>'92.060214','lat'=>'31.476004']);
        $this->insert('{{%region}}',['id'=>'2871','pid'=>'2870','shortname'=>'那曲','name'=>'那曲县','merger_name'=>'中国,西藏自治区,那曲地区,那曲县','level'=>'3','pinyin'=>'naqu','code'=>'0896','zip_code'=>'852000','first'=>'N','lng'=>'92.0535','lat'=>'31.46964']);
        $this->insert('{{%region}}',['id'=>'2872','pid'=>'2870','shortname'=>'嘉黎','name'=>'嘉黎县','merger_name'=>'中国,西藏自治区,那曲地区,嘉黎县','level'=>'3','pinyin'=>'jiali','code'=>'0896','zip_code'=>'852400','first'=>'J','lng'=>'93.24987','lat'=>'30.64233']);
        $this->insert('{{%region}}',['id'=>'2873','pid'=>'2870','shortname'=>'比如','name'=>'比如县','merger_name'=>'中国,西藏自治区,那曲地区,比如县','level'=>'3','pinyin'=>'biru','code'=>'0896','zip_code'=>'852300','first'=>'B','lng'=>'93.68685','lat'=>'31.4779']);
        $this->insert('{{%region}}',['id'=>'2874','pid'=>'2870','shortname'=>'聂荣','name'=>'聂荣县','merger_name'=>'中国,西藏自治区,那曲地区,聂荣县','level'=>'3','pinyin'=>'nierong','code'=>'0896','zip_code'=>'853500','first'=>'N','lng'=>'92.29574','lat'=>'32.11193']);
        $this->insert('{{%region}}',['id'=>'2875','pid'=>'2870','shortname'=>'安多','name'=>'安多县','merger_name'=>'中国,西藏自治区,那曲地区,安多县','level'=>'3','pinyin'=>'anduo','code'=>'0896','zip_code'=>'853400','first'=>'A','lng'=>'91.6795','lat'=>'32.26125']);
        $this->insert('{{%region}}',['id'=>'2876','pid'=>'2870','shortname'=>'申扎','name'=>'申扎县','merger_name'=>'中国,西藏自治区,那曲地区,申扎县','level'=>'3','pinyin'=>'shenzha','code'=>'0896','zip_code'=>'853100','first'=>'S','lng'=>'88.70776','lat'=>'30.92995']);
        $this->insert('{{%region}}',['id'=>'2877','pid'=>'2870','shortname'=>'索县','name'=>'索县','merger_name'=>'中国,西藏自治区,那曲地区,索县','level'=>'3','pinyin'=>'suoxian','code'=>'0896','zip_code'=>'852200','first'=>'S','lng'=>'93.78295','lat'=>'31.88427']);
        $this->insert('{{%region}}',['id'=>'2878','pid'=>'2870','shortname'=>'班戈','name'=>'班戈县','merger_name'=>'中国,西藏自治区,那曲地区,班戈县','level'=>'3','pinyin'=>'bange','code'=>'0896','zip_code'=>'852500','first'=>'B','lng'=>'90.01907','lat'=>'31.36149']);
        $this->insert('{{%region}}',['id'=>'2879','pid'=>'2870','shortname'=>'巴青','name'=>'巴青县','merger_name'=>'中国,西藏自治区,那曲地区,巴青县','level'=>'3','pinyin'=>'baqing','code'=>'0896','zip_code'=>'852100','first'=>'B','lng'=>'94.05316','lat'=>'31.91833']);
        $this->insert('{{%region}}',['id'=>'2880','pid'=>'2870','shortname'=>'尼玛','name'=>'尼玛县','merger_name'=>'中国,西藏自治区,那曲地区,尼玛县','level'=>'3','pinyin'=>'nima','code'=>'0896','zip_code'=>'852600','first'=>'N','lng'=>'87.25256','lat'=>'31.79654']);
        $this->insert('{{%region}}',['id'=>'2881','pid'=>'2870','shortname'=>'双湖','name'=>'双湖县','merger_name'=>'中国,西藏自治区,那曲地区,双湖县','level'=>'3','pinyin'=>'shuanghu','code'=>'0896','zip_code'=>'852600','first'=>'S','lng'=>'88.837776','lat'=>'33.189032']);
        $this->insert('{{%region}}',['id'=>'2882','pid'=>'2816','shortname'=>'阿里','name'=>'阿里地区','merger_name'=>'中国,西藏自治区,阿里地区','level'=>'2','pinyin'=>'ngari','code'=>'0897','zip_code'=>'859000','first'=>'A','lng'=>'80.105498','lat'=>'32.503187']);
        $this->insert('{{%region}}',['id'=>'2883','pid'=>'2882','shortname'=>'普兰','name'=>'普兰县','merger_name'=>'中国,西藏自治区,阿里地区,普兰县','level'=>'3','pinyin'=>'pulan','code'=>'0897','zip_code'=>'859500','first'=>'P','lng'=>'81.177','lat'=>'30.30002']);
        $this->insert('{{%region}}',['id'=>'2884','pid'=>'2882','shortname'=>'札达','name'=>'札达县','merger_name'=>'中国,西藏自治区,阿里地区,札达县','level'=>'3','pinyin'=>'zhada','code'=>'0897','zip_code'=>'859600','first'=>'Z','lng'=>'79.80255','lat'=>'31.48345']);
        $this->insert('{{%region}}',['id'=>'2885','pid'=>'2882','shortname'=>'噶尔','name'=>'噶尔县','merger_name'=>'中国,西藏自治区,阿里地区,噶尔县','level'=>'3','pinyin'=>'gaer','code'=>'0897','zip_code'=>'859400','first'=>'G','lng'=>'80.09579','lat'=>'32.50024']);
        $this->insert('{{%region}}',['id'=>'2886','pid'=>'2882','shortname'=>'日土','name'=>'日土县','merger_name'=>'中国,西藏自治区,阿里地区,日土县','level'=>'3','pinyin'=>'ritu','code'=>'0897','zip_code'=>'859700','first'=>'R','lng'=>'79.7131','lat'=>'33.38741']);
        $this->insert('{{%region}}',['id'=>'2887','pid'=>'2882','shortname'=>'革吉','name'=>'革吉县','merger_name'=>'中国,西藏自治区,阿里地区,革吉县','level'=>'3','pinyin'=>'geji','code'=>'0897','zip_code'=>'859100','first'=>'G','lng'=>'81.151','lat'=>'32.3964']);
        $this->insert('{{%region}}',['id'=>'2888','pid'=>'2882','shortname'=>'改则','name'=>'改则县','merger_name'=>'中国,西藏自治区,阿里地区,改则县','level'=>'3','pinyin'=>'gaize','code'=>'0897','zip_code'=>'859200','first'=>'G','lng'=>'84.06295','lat'=>'32.30446']);
        $this->insert('{{%region}}',['id'=>'2889','pid'=>'2882','shortname'=>'措勤','name'=>'措勤县','merger_name'=>'中国,西藏自治区,阿里地区,措勤县','level'=>'3','pinyin'=>'cuoqin','code'=>'0897','zip_code'=>'859300','first'=>'C','lng'=>'85.16616','lat'=>'31.02095']);
        $this->insert('{{%region}}',['id'=>'2890','pid'=>'2816','shortname'=>'林芝','name'=>'林芝地区','merger_name'=>'中国,西藏自治区,林芝地区','level'=>'2','pinyin'=>'nyingchi','code'=>'0894','zip_code'=>'850400','first'=>'L','lng'=>'94.362348','lat'=>'29.654693']);
        $this->insert('{{%region}}',['id'=>'2891','pid'=>'2890','shortname'=>'林芝','name'=>'林芝县','merger_name'=>'中国,西藏自治区,林芝地区,林芝县','level'=>'3','pinyin'=>'linzhi','code'=>'0894','zip_code'=>'850400','first'=>'L','lng'=>'94.48391','lat'=>'29.57562']);
        $this->insert('{{%region}}',['id'=>'2892','pid'=>'2890','shortname'=>'工布江达','name'=>'工布江达县','merger_name'=>'中国,西藏自治区,林芝地区,工布江达县','level'=>'3','pinyin'=>'gongbujiangda','code'=>'0894','zip_code'=>'850300','first'=>'G','lng'=>'93.2452','lat'=>'29.88576']);
        $this->insert('{{%region}}',['id'=>'2893','pid'=>'2890','shortname'=>'米林','name'=>'米林县','merger_name'=>'中国,西藏自治区,林芝地区,米林县','level'=>'3','pinyin'=>'milin','code'=>'0894','zip_code'=>'850500','first'=>'M','lng'=>'94.21316','lat'=>'29.21535']);
        $this->insert('{{%region}}',['id'=>'2894','pid'=>'2890','shortname'=>'墨脱','name'=>'墨脱县','merger_name'=>'中国,西藏自治区,林芝地区,墨脱县','level'=>'3','pinyin'=>'motuo','code'=>'0894','zip_code'=>'855300','first'=>'M','lng'=>'95.3316','lat'=>'29.32698']);
        $this->insert('{{%region}}',['id'=>'2895','pid'=>'2890','shortname'=>'波密','name'=>'波密县','merger_name'=>'中国,西藏自治区,林芝地区,波密县','level'=>'3','pinyin'=>'bomi','code'=>'0894','zip_code'=>'855200','first'=>'B','lng'=>'95.77096','lat'=>'29.85907']);
        $this->insert('{{%region}}',['id'=>'2896','pid'=>'2890','shortname'=>'察隅','name'=>'察隅县','merger_name'=>'中国,西藏自治区,林芝地区,察隅县','level'=>'3','pinyin'=>'chayu','code'=>'0894','zip_code'=>'855100','first'=>'C','lng'=>'97.46679','lat'=>'28.6618']);
        $this->insert('{{%region}}',['id'=>'2897','pid'=>'2890','shortname'=>'朗县','name'=>'朗县','merger_name'=>'中国,西藏自治区,林芝地区,朗县','level'=>'3','pinyin'=>'langxian','code'=>'0894','zip_code'=>'856500','first'=>'L','lng'=>'93.0754','lat'=>'29.04549']);
        $this->insert('{{%region}}',['id'=>'2898','pid'=>'0','shortname'=>'陕西','name'=>'陕西省','merger_name'=>'中国,陕西省','level'=>'1','pinyin'=>'shaanxi','code'=>'','zip_code'=>'','first'=>'S','lng'=>'108.948024','lat'=>'34.263161']);
        $this->insert('{{%region}}',['id'=>'2899','pid'=>'2898','shortname'=>'西安','name'=>'西安市','merger_name'=>'中国,陕西省,西安市','level'=>'2','pinyin'=>'xi\'an','code'=>'029','zip_code'=>'710003','first'=>'X','lng'=>'108.948024','lat'=>'34.263161']);
        $this->insert('{{%region}}',['id'=>'2900','pid'=>'2899','shortname'=>'新城','name'=>'新城区','merger_name'=>'中国,陕西省,西安市,新城区','level'=>'3','pinyin'=>'xincheng','code'=>'029','zip_code'=>'710004','first'=>'X','lng'=>'108.9608','lat'=>'34.26641']);
        $this->insert('{{%region}}',['id'=>'2901','pid'=>'2899','shortname'=>'碑林','name'=>'碑林区','merger_name'=>'中国,陕西省,西安市,碑林区','level'=>'3','pinyin'=>'beilin','code'=>'029','zip_code'=>'710001','first'=>'B','lng'=>'108.93426','lat'=>'34.2304']);
        $this->insert('{{%region}}',['id'=>'2902','pid'=>'2899','shortname'=>'莲湖','name'=>'莲湖区','merger_name'=>'中国,陕西省,西安市,莲湖区','level'=>'3','pinyin'=>'lianhu','code'=>'029','zip_code'=>'710003','first'=>'L','lng'=>'108.9401','lat'=>'34.26709']);
        $this->insert('{{%region}}',['id'=>'2903','pid'=>'2899','shortname'=>'灞桥','name'=>'灞桥区','merger_name'=>'中国,陕西省,西安市,灞桥区','level'=>'3','pinyin'=>'baqiao','code'=>'029','zip_code'=>'710038','first'=>NULL,'lng'=>'109.06451','lat'=>'34.27264']);
        $this->insert('{{%region}}',['id'=>'2904','pid'=>'2899','shortname'=>'未央','name'=>'未央区','merger_name'=>'中国,陕西省,西安市,未央区','level'=>'3','pinyin'=>'weiyang','code'=>'029','zip_code'=>'710014','first'=>'W','lng'=>'108.94683','lat'=>'34.29296']);
        $this->insert('{{%region}}',['id'=>'2905','pid'=>'2899','shortname'=>'雁塔','name'=>'雁塔区','merger_name'=>'中国,陕西省,西安市,雁塔区','level'=>'3','pinyin'=>'yanta','code'=>'029','zip_code'=>'710061','first'=>'Y','lng'=>'108.94866','lat'=>'34.22245']);
        $this->insert('{{%region}}',['id'=>'2906','pid'=>'2899','shortname'=>'阎良','name'=>'阎良区','merger_name'=>'中国,陕西省,西安市,阎良区','level'=>'3','pinyin'=>'yanliang','code'=>'029','zip_code'=>'710087','first'=>'Y','lng'=>'109.22616','lat'=>'34.66221']);
        $this->insert('{{%region}}',['id'=>'2907','pid'=>'2899','shortname'=>'临潼','name'=>'临潼区','merger_name'=>'中国,陕西省,西安市,临潼区','level'=>'3','pinyin'=>'lintong','code'=>'029','zip_code'=>'710600','first'=>'L','lng'=>'109.21417','lat'=>'34.36665']);
        $this->insert('{{%region}}',['id'=>'2908','pid'=>'2899','shortname'=>'长安','name'=>'长安区','merger_name'=>'中国,陕西省,西安市,长安区','level'=>'3','pinyin'=>'chang\'an','code'=>'029','zip_code'=>'710100','first'=>'C','lng'=>'108.94586','lat'=>'34.15559']);
        $this->insert('{{%region}}',['id'=>'2909','pid'=>'2899','shortname'=>'蓝田','name'=>'蓝田县','merger_name'=>'中国,陕西省,西安市,蓝田县','level'=>'3','pinyin'=>'lantian','code'=>'029','zip_code'=>'710500','first'=>'L','lng'=>'109.32339','lat'=>'34.15128']);
        $this->insert('{{%region}}',['id'=>'2910','pid'=>'2899','shortname'=>'周至','name'=>'周至县','merger_name'=>'中国,陕西省,西安市,周至县','level'=>'3','pinyin'=>'zhouzhi','code'=>'029','zip_code'=>'710400','first'=>'Z','lng'=>'108.22207','lat'=>'34.16337']);
        $this->insert('{{%region}}',['id'=>'2911','pid'=>'2899','shortname'=>'户县','name'=>'户县','merger_name'=>'中国,陕西省,西安市,户县','level'=>'3','pinyin'=>'huxian','code'=>'029','zip_code'=>'710300','first'=>'H','lng'=>'108.60513','lat'=>'34.10856']);
        $this->insert('{{%region}}',['id'=>'2912','pid'=>'2899','shortname'=>'高陵','name'=>'高陵区','merger_name'=>'中国,陕西省,西安市,高陵区','level'=>'3','pinyin'=>'gaoling','code'=>'029','zip_code'=>'710200','first'=>'G','lng'=>'109.08816','lat'=>'34.53483']);
        $this->insert('{{%region}}',['id'=>'2913','pid'=>'2898','shortname'=>'铜川','name'=>'铜川市','merger_name'=>'中国,陕西省,铜川市','level'=>'2','pinyin'=>'tongchuan','code'=>'0919','zip_code'=>'727100','first'=>'T','lng'=>'108.963122','lat'=>'34.90892']);
        $this->insert('{{%region}}',['id'=>'2914','pid'=>'2913','shortname'=>'王益','name'=>'王益区','merger_name'=>'中国,陕西省,铜川市,王益区','level'=>'3','pinyin'=>'wangyi','code'=>'0919','zip_code'=>'727000','first'=>'W','lng'=>'109.07564','lat'=>'35.06896']);
        $this->insert('{{%region}}',['id'=>'2915','pid'=>'2913','shortname'=>'印台','name'=>'印台区','merger_name'=>'中国,陕西省,铜川市,印台区','level'=>'3','pinyin'=>'yintai','code'=>'0919','zip_code'=>'727007','first'=>'Y','lng'=>'109.10208','lat'=>'35.1169']);
        $this->insert('{{%region}}',['id'=>'2916','pid'=>'2913','shortname'=>'耀州','name'=>'耀州区','merger_name'=>'中国,陕西省,铜川市,耀州区','level'=>'3','pinyin'=>'yaozhou','code'=>'0919','zip_code'=>'727100','first'=>'Y','lng'=>'108.98556','lat'=>'34.91308']);
        $this->insert('{{%region}}',['id'=>'2917','pid'=>'2913','shortname'=>'宜君','name'=>'宜君县','merger_name'=>'中国,陕西省,铜川市,宜君县','level'=>'3','pinyin'=>'yijun','code'=>'0919','zip_code'=>'727200','first'=>'Y','lng'=>'109.11813','lat'=>'35.40108']);
        $this->insert('{{%region}}',['id'=>'2918','pid'=>'2898','shortname'=>'宝鸡','name'=>'宝鸡市','merger_name'=>'中国,陕西省,宝鸡市','level'=>'2','pinyin'=>'baoji','code'=>'0917','zip_code'=>'721000','first'=>'B','lng'=>'107.14487','lat'=>'34.369315']);
        $this->insert('{{%region}}',['id'=>'2919','pid'=>'2918','shortname'=>'渭滨','name'=>'渭滨区','merger_name'=>'中国,陕西省,宝鸡市,渭滨区','level'=>'3','pinyin'=>'weibin','code'=>'0917','zip_code'=>'721000','first'=>'W','lng'=>'107.14991','lat'=>'34.37116']);
        $this->insert('{{%region}}',['id'=>'2920','pid'=>'2918','shortname'=>'金台','name'=>'金台区','merger_name'=>'中国,陕西省,宝鸡市,金台区','level'=>'3','pinyin'=>'jintai','code'=>'0917','zip_code'=>'721000','first'=>'J','lng'=>'107.14691','lat'=>'34.37612']);
        $this->insert('{{%region}}',['id'=>'2921','pid'=>'2918','shortname'=>'陈仓','name'=>'陈仓区','merger_name'=>'中国,陕西省,宝鸡市,陈仓区','level'=>'3','pinyin'=>'chencang','code'=>'0917','zip_code'=>'721300','first'=>'C','lng'=>'107.38742','lat'=>'34.35451']);
        $this->insert('{{%region}}',['id'=>'2922','pid'=>'2918','shortname'=>'凤翔','name'=>'凤翔县','merger_name'=>'中国,陕西省,宝鸡市,凤翔县','level'=>'3','pinyin'=>'fengxiang','code'=>'0917','zip_code'=>'721400','first'=>'F','lng'=>'107.39645','lat'=>'34.52321']);
        $this->insert('{{%region}}',['id'=>'2923','pid'=>'2918','shortname'=>'岐山','name'=>'岐山县','merger_name'=>'中国,陕西省,宝鸡市,岐山县','level'=>'3','pinyin'=>'qishan','code'=>'0917','zip_code'=>'722400','first'=>NULL,'lng'=>'107.62173','lat'=>'34.44378']);
        $this->insert('{{%region}}',['id'=>'2924','pid'=>'2918','shortname'=>'扶风','name'=>'扶风县','merger_name'=>'中国,陕西省,宝鸡市,扶风县','level'=>'3','pinyin'=>'fufeng','code'=>'0917','zip_code'=>'722200','first'=>'F','lng'=>'107.90017','lat'=>'34.37524']);
        $this->insert('{{%region}}',['id'=>'2925','pid'=>'2918','shortname'=>'眉县','name'=>'眉县','merger_name'=>'中国,陕西省,宝鸡市,眉县','level'=>'3','pinyin'=>'meixian','code'=>'0917','zip_code'=>'722300','first'=>'M','lng'=>'107.75079','lat'=>'34.27569']);
        $this->insert('{{%region}}',['id'=>'2926','pid'=>'2918','shortname'=>'陇县','name'=>'陇县','merger_name'=>'中国,陕西省,宝鸡市,陇县','level'=>'3','pinyin'=>'longxian','code'=>'0917','zip_code'=>'721200','first'=>'L','lng'=>'106.85946','lat'=>'34.89404']);
        $this->insert('{{%region}}',['id'=>'2927','pid'=>'2918','shortname'=>'千阳','name'=>'千阳县','merger_name'=>'中国,陕西省,宝鸡市,千阳县','level'=>'3','pinyin'=>'qianyang','code'=>'0917','zip_code'=>'721100','first'=>'Q','lng'=>'107.13043','lat'=>'34.64219']);
        $this->insert('{{%region}}',['id'=>'2928','pid'=>'2918','shortname'=>'麟游','name'=>'麟游县','merger_name'=>'中国,陕西省,宝鸡市,麟游县','level'=>'3','pinyin'=>'linyou','code'=>'0917','zip_code'=>'721500','first'=>NULL,'lng'=>'107.79623','lat'=>'34.67844']);
        $this->insert('{{%region}}',['id'=>'2929','pid'=>'2918','shortname'=>'凤县','name'=>'凤县','merger_name'=>'中国,陕西省,宝鸡市,凤县','level'=>'3','pinyin'=>'fengxian','code'=>'0917','zip_code'=>'721700','first'=>'F','lng'=>'106.52356','lat'=>'33.91172']);
        $this->insert('{{%region}}',['id'=>'2930','pid'=>'2918','shortname'=>'太白','name'=>'太白县','merger_name'=>'中国,陕西省,宝鸡市,太白县','level'=>'3','pinyin'=>'taibai','code'=>'0917','zip_code'=>'721600','first'=>'T','lng'=>'107.31646','lat'=>'34.06207']);
        $this->insert('{{%region}}',['id'=>'2931','pid'=>'2898','shortname'=>'咸阳','name'=>'咸阳市','merger_name'=>'中国,陕西省,咸阳市','level'=>'2','pinyin'=>'xianyang','code'=>'029','zip_code'=>'712000','first'=>'X','lng'=>'108.705117','lat'=>'34.333439']);
        $this->insert('{{%region}}',['id'=>'2932','pid'=>'2931','shortname'=>'秦都','name'=>'秦都区','merger_name'=>'中国,陕西省,咸阳市,秦都区','level'=>'3','pinyin'=>'qindu','code'=>'029','zip_code'=>'712000','first'=>'Q','lng'=>'108.71493','lat'=>'34.33804']);
        $this->insert('{{%region}}',['id'=>'2933','pid'=>'2931','shortname'=>'杨陵','name'=>'杨陵区','merger_name'=>'中国,陕西省,咸阳市,杨陵区','level'=>'3','pinyin'=>'yangling','code'=>'029','zip_code'=>'712100','first'=>'Y','lng'=>'108.083481','lat'=>'34.270434']);
        $this->insert('{{%region}}',['id'=>'2934','pid'=>'2931','shortname'=>'渭城','name'=>'渭城区','merger_name'=>'中国,陕西省,咸阳市,渭城区','level'=>'3','pinyin'=>'weicheng','code'=>'029','zip_code'=>'712000','first'=>'W','lng'=>'108.72227','lat'=>'34.33198']);
        $this->insert('{{%region}}',['id'=>'2935','pid'=>'2931','shortname'=>'三原','name'=>'三原县','merger_name'=>'中国,陕西省,咸阳市,三原县','level'=>'3','pinyin'=>'sanyuan','code'=>'029','zip_code'=>'713800','first'=>'S','lng'=>'108.93194','lat'=>'34.61556']);
        $this->insert('{{%region}}',['id'=>'2936','pid'=>'2931','shortname'=>'泾阳','name'=>'泾阳县','merger_name'=>'中国,陕西省,咸阳市,泾阳县','level'=>'3','pinyin'=>'jingyang','code'=>'029','zip_code'=>'713700','first'=>NULL,'lng'=>'108.84259','lat'=>'34.52705']);
        $this->insert('{{%region}}',['id'=>'2937','pid'=>'2931','shortname'=>'乾县','name'=>'乾县','merger_name'=>'中国,陕西省,咸阳市,乾县','level'=>'3','pinyin'=>'qianxian','code'=>'029','zip_code'=>'713300','first'=>'Q','lng'=>'108.24231','lat'=>'34.52946']);
        $this->insert('{{%region}}',['id'=>'2938','pid'=>'2931','shortname'=>'礼泉','name'=>'礼泉县','merger_name'=>'中国,陕西省,咸阳市,礼泉县','level'=>'3','pinyin'=>'liquan','code'=>'029','zip_code'=>'713200','first'=>'L','lng'=>'108.4263','lat'=>'34.48455']);
        $this->insert('{{%region}}',['id'=>'2939','pid'=>'2931','shortname'=>'永寿','name'=>'永寿县','merger_name'=>'中国,陕西省,咸阳市,永寿县','level'=>'3','pinyin'=>'yongshou','code'=>'029','zip_code'=>'713400','first'=>'Y','lng'=>'108.14474','lat'=>'34.69081']);
        $this->insert('{{%region}}',['id'=>'2940','pid'=>'2931','shortname'=>'彬县','name'=>'彬县','merger_name'=>'中国,陕西省,咸阳市,彬县','level'=>'3','pinyin'=>'binxian','code'=>'029','zip_code'=>'713500','first'=>'B','lng'=>'108.08468','lat'=>'35.0342']);
        $this->insert('{{%region}}',['id'=>'2941','pid'=>'2931','shortname'=>'长武','name'=>'长武县','merger_name'=>'中国,陕西省,咸阳市,长武县','level'=>'3','pinyin'=>'changwu','code'=>'029','zip_code'=>'713600','first'=>'C','lng'=>'107.7951','lat'=>'35.2067']);
        $this->insert('{{%region}}',['id'=>'2942','pid'=>'2931','shortname'=>'旬邑','name'=>'旬邑县','merger_name'=>'中国,陕西省,咸阳市,旬邑县','level'=>'3','pinyin'=>'xunyi','code'=>'029','zip_code'=>'711300','first'=>'X','lng'=>'108.3341','lat'=>'35.11338']);
        $this->insert('{{%region}}',['id'=>'2943','pid'=>'2931','shortname'=>'淳化','name'=>'淳化县','merger_name'=>'中国,陕西省,咸阳市,淳化县','level'=>'3','pinyin'=>'chunhua','code'=>'029','zip_code'=>'711200','first'=>'C','lng'=>'108.58026','lat'=>'34.79886']);
        $this->insert('{{%region}}',['id'=>'2944','pid'=>'2931','shortname'=>'武功','name'=>'武功县','merger_name'=>'中国,陕西省,咸阳市,武功县','level'=>'3','pinyin'=>'wugong','code'=>'029','zip_code'=>'712200','first'=>'W','lng'=>'108.20434','lat'=>'34.26003']);
        $this->insert('{{%region}}',['id'=>'2945','pid'=>'2931','shortname'=>'兴平','name'=>'兴平市','merger_name'=>'中国,陕西省,咸阳市,兴平市','level'=>'3','pinyin'=>'xingping','code'=>'029','zip_code'=>'713100','first'=>'X','lng'=>'108.49057','lat'=>'34.29785']);
        $this->insert('{{%region}}',['id'=>'2946','pid'=>'2898','shortname'=>'渭南','name'=>'渭南市','merger_name'=>'中国,陕西省,渭南市','level'=>'2','pinyin'=>'weinan','code'=>'0913','zip_code'=>'714000','first'=>'W','lng'=>'109.502882','lat'=>'34.499381']);
        $this->insert('{{%region}}',['id'=>'2947','pid'=>'2946','shortname'=>'临渭','name'=>'临渭区','merger_name'=>'中国,陕西省,渭南市,临渭区','level'=>'3','pinyin'=>'linwei','code'=>'0913','zip_code'=>'714000','first'=>'L','lng'=>'109.49296','lat'=>'34.49822']);
        $this->insert('{{%region}}',['id'=>'2948','pid'=>'2946','shortname'=>'华县','name'=>'华县','merger_name'=>'中国,陕西省,渭南市,华县','level'=>'3','pinyin'=>'huaxian','code'=>'0913','zip_code'=>'714100','first'=>'H','lng'=>'109.77185','lat'=>'34.51255']);
        $this->insert('{{%region}}',['id'=>'2949','pid'=>'2946','shortname'=>'潼关','name'=>'潼关县','merger_name'=>'中国,陕西省,渭南市,潼关县','level'=>'3','pinyin'=>'tongguan','code'=>'0913','zip_code'=>'714300','first'=>NULL,'lng'=>'110.24362','lat'=>'34.54284']);
        $this->insert('{{%region}}',['id'=>'2950','pid'=>'2946','shortname'=>'大荔','name'=>'大荔县','merger_name'=>'中国,陕西省,渭南市,大荔县','level'=>'3','pinyin'=>'dali','code'=>'0913','zip_code'=>'715100','first'=>'D','lng'=>'109.94216','lat'=>'34.79565']);
        $this->insert('{{%region}}',['id'=>'2951','pid'=>'2946','shortname'=>'合阳','name'=>'合阳县','merger_name'=>'中国,陕西省,渭南市,合阳县','level'=>'3','pinyin'=>'heyang','code'=>'0913','zip_code'=>'715300','first'=>'H','lng'=>'110.14862','lat'=>'35.23805']);
        $this->insert('{{%region}}',['id'=>'2952','pid'=>'2946','shortname'=>'澄城','name'=>'澄城县','merger_name'=>'中国,陕西省,渭南市,澄城县','level'=>'3','pinyin'=>'chengcheng','code'=>'0913','zip_code'=>'715200','first'=>'C','lng'=>'109.93444','lat'=>'35.18396']);
        $this->insert('{{%region}}',['id'=>'2953','pid'=>'2946','shortname'=>'蒲城','name'=>'蒲城县','merger_name'=>'中国,陕西省,渭南市,蒲城县','level'=>'3','pinyin'=>'pucheng','code'=>'0913','zip_code'=>'715500','first'=>'P','lng'=>'109.5903','lat'=>'34.9568']);
        $this->insert('{{%region}}',['id'=>'2954','pid'=>'2946','shortname'=>'白水','name'=>'白水县','merger_name'=>'中国,陕西省,渭南市,白水县','level'=>'3','pinyin'=>'baishui','code'=>'0913','zip_code'=>'715600','first'=>'B','lng'=>'109.59286','lat'=>'35.17863']);
        $this->insert('{{%region}}',['id'=>'2955','pid'=>'2946','shortname'=>'富平','name'=>'富平县','merger_name'=>'中国,陕西省,渭南市,富平县','level'=>'3','pinyin'=>'fuping','code'=>'0913','zip_code'=>'711700','first'=>'F','lng'=>'109.1802','lat'=>'34.75109']);
        $this->insert('{{%region}}',['id'=>'2956','pid'=>'2946','shortname'=>'韩城','name'=>'韩城市','merger_name'=>'中国,陕西省,渭南市,韩城市','level'=>'3','pinyin'=>'hancheng','code'=>'0913','zip_code'=>'715400','first'=>'H','lng'=>'110.44238','lat'=>'35.47926']);
        $this->insert('{{%region}}',['id'=>'2957','pid'=>'2946','shortname'=>'华阴','name'=>'华阴市','merger_name'=>'中国,陕西省,渭南市,华阴市','level'=>'3','pinyin'=>'huayin','code'=>'0913','zip_code'=>'714200','first'=>'H','lng'=>'110.08752','lat'=>'34.56608']);
        $this->insert('{{%region}}',['id'=>'2958','pid'=>'2898','shortname'=>'延安','name'=>'延安市','merger_name'=>'中国,陕西省,延安市','level'=>'2','pinyin'=>'yan\'an','code'=>'0911','zip_code'=>'716000','first'=>'Y','lng'=>'109.49081','lat'=>'36.596537']);
        $this->insert('{{%region}}',['id'=>'2959','pid'=>'2958','shortname'=>'宝塔','name'=>'宝塔区','merger_name'=>'中国,陕西省,延安市,宝塔区','level'=>'3','pinyin'=>'baota','code'=>'0911','zip_code'=>'716000','first'=>'B','lng'=>'109.49336','lat'=>'36.59154']);
        $this->insert('{{%region}}',['id'=>'2960','pid'=>'2958','shortname'=>'延长','name'=>'延长县','merger_name'=>'中国,陕西省,延安市,延长县','level'=>'3','pinyin'=>'yanchang','code'=>'0911','zip_code'=>'717100','first'=>'Y','lng'=>'110.01083','lat'=>'36.57904']);
        $this->insert('{{%region}}',['id'=>'2961','pid'=>'2958','shortname'=>'延川','name'=>'延川县','merger_name'=>'中国,陕西省,延安市,延川县','level'=>'3','pinyin'=>'yanchuan','code'=>'0911','zip_code'=>'717200','first'=>'Y','lng'=>'110.19415','lat'=>'36.87817']);
        $this->insert('{{%region}}',['id'=>'2962','pid'=>'2958','shortname'=>'子长','name'=>'子长县','merger_name'=>'中国,陕西省,延安市,子长县','level'=>'3','pinyin'=>'zichang','code'=>'0911','zip_code'=>'717300','first'=>'Z','lng'=>'109.67532','lat'=>'37.14253']);
        $this->insert('{{%region}}',['id'=>'2963','pid'=>'2958','shortname'=>'安塞','name'=>'安塞县','merger_name'=>'中国,陕西省,延安市,安塞县','level'=>'3','pinyin'=>'ansai','code'=>'0911','zip_code'=>'717400','first'=>'A','lng'=>'109.32708','lat'=>'36.86507']);
        $this->insert('{{%region}}',['id'=>'2964','pid'=>'2958','shortname'=>'志丹','name'=>'志丹县','merger_name'=>'中国,陕西省,延安市,志丹县','level'=>'3','pinyin'=>'zhidan','code'=>'0911','zip_code'=>'717500','first'=>'Z','lng'=>'108.76815','lat'=>'36.82177']);
        $this->insert('{{%region}}',['id'=>'2965','pid'=>'2958','shortname'=>'吴起','name'=>'吴起县','merger_name'=>'中国,陕西省,延安市,吴起县','level'=>'3','pinyin'=>'wuqi','code'=>'0911','zip_code'=>'717600','first'=>'W','lng'=>'108.17611','lat'=>'36.92785']);
        $this->insert('{{%region}}',['id'=>'2966','pid'=>'2958','shortname'=>'甘泉','name'=>'甘泉县','merger_name'=>'中国,陕西省,延安市,甘泉县','level'=>'3','pinyin'=>'ganquan','code'=>'0911','zip_code'=>'716100','first'=>'G','lng'=>'109.35012','lat'=>'36.27754']);
        $this->insert('{{%region}}',['id'=>'2967','pid'=>'2958','shortname'=>'富县','name'=>'富县','merger_name'=>'中国,陕西省,延安市,富县','level'=>'3','pinyin'=>'fuxian','code'=>'0911','zip_code'=>'727500','first'=>'F','lng'=>'109.37927','lat'=>'35.98803']);
        $this->insert('{{%region}}',['id'=>'2968','pid'=>'2958','shortname'=>'洛川','name'=>'洛川县','merger_name'=>'中国,陕西省,延安市,洛川县','level'=>'3','pinyin'=>'luochuan','code'=>'0911','zip_code'=>'727400','first'=>'L','lng'=>'109.43286','lat'=>'35.76076']);
        $this->insert('{{%region}}',['id'=>'2969','pid'=>'2958','shortname'=>'宜川','name'=>'宜川县','merger_name'=>'中国,陕西省,延安市,宜川县','level'=>'3','pinyin'=>'yichuan','code'=>'0911','zip_code'=>'716200','first'=>'Y','lng'=>'110.17196','lat'=>'36.04732']);
        $this->insert('{{%region}}',['id'=>'2970','pid'=>'2958','shortname'=>'黄龙','name'=>'黄龙县','merger_name'=>'中国,陕西省,延安市,黄龙县','level'=>'3','pinyin'=>'huanglong','code'=>'0911','zip_code'=>'715700','first'=>'H','lng'=>'109.84259','lat'=>'35.58349']);
        $this->insert('{{%region}}',['id'=>'2971','pid'=>'2958','shortname'=>'黄陵','name'=>'黄陵县','merger_name'=>'中国,陕西省,延安市,黄陵县','level'=>'3','pinyin'=>'huangling','code'=>'0911','zip_code'=>'727300','first'=>'H','lng'=>'109.26333','lat'=>'35.58357']);
        $this->insert('{{%region}}',['id'=>'2972','pid'=>'2898','shortname'=>'汉中','name'=>'汉中市','merger_name'=>'中国,陕西省,汉中市','level'=>'2','pinyin'=>'hanzhong','code'=>'0916','zip_code'=>'723000','first'=>'H','lng'=>'107.028621','lat'=>'33.077668']);
        $this->insert('{{%region}}',['id'=>'2973','pid'=>'2972','shortname'=>'汉台','name'=>'汉台区','merger_name'=>'中国,陕西省,汉中市,汉台区','level'=>'3','pinyin'=>'hantai','code'=>'0916','zip_code'=>'723000','first'=>'H','lng'=>'107.03187','lat'=>'33.06774']);
        $this->insert('{{%region}}',['id'=>'2974','pid'=>'2972','shortname'=>'南郑','name'=>'南郑县','merger_name'=>'中国,陕西省,汉中市,南郑县','level'=>'3','pinyin'=>'nanzheng','code'=>'0916','zip_code'=>'723100','first'=>'N','lng'=>'106.94024','lat'=>'33.00299']);
        $this->insert('{{%region}}',['id'=>'2975','pid'=>'2972','shortname'=>'城固','name'=>'城固县','merger_name'=>'中国,陕西省,汉中市,城固县','level'=>'3','pinyin'=>'chenggu','code'=>'0916','zip_code'=>'723200','first'=>'C','lng'=>'107.33367','lat'=>'33.15661']);
        $this->insert('{{%region}}',['id'=>'2976','pid'=>'2972','shortname'=>'洋县','name'=>'洋县','merger_name'=>'中国,陕西省,汉中市,洋县','level'=>'3','pinyin'=>'yangxian','code'=>'0916','zip_code'=>'723300','first'=>'Y','lng'=>'107.54672','lat'=>'33.22102']);
        $this->insert('{{%region}}',['id'=>'2977','pid'=>'2972','shortname'=>'西乡','name'=>'西乡县','merger_name'=>'中国,陕西省,汉中市,西乡县','level'=>'3','pinyin'=>'xixiang','code'=>'0916','zip_code'=>'723500','first'=>'X','lng'=>'107.76867','lat'=>'32.98411']);
        $this->insert('{{%region}}',['id'=>'2978','pid'=>'2972','shortname'=>'勉县','name'=>'勉县','merger_name'=>'中国,陕西省,汉中市,勉县','level'=>'3','pinyin'=>'mianxian','code'=>'0916','zip_code'=>'724200','first'=>'M','lng'=>'106.67584','lat'=>'33.15273']);
        $this->insert('{{%region}}',['id'=>'2979','pid'=>'2972','shortname'=>'宁强','name'=>'宁强县','merger_name'=>'中国,陕西省,汉中市,宁强县','level'=>'3','pinyin'=>'ningqiang','code'=>'0916','zip_code'=>'724400','first'=>'N','lng'=>'106.25958','lat'=>'32.82881']);
        $this->insert('{{%region}}',['id'=>'2980','pid'=>'2972','shortname'=>'略阳','name'=>'略阳县','merger_name'=>'中国,陕西省,汉中市,略阳县','level'=>'3','pinyin'=>'lueyang','code'=>'0916','zip_code'=>'724300','first'=>'L','lng'=>'106.15399','lat'=>'33.33009']);
        $this->insert('{{%region}}',['id'=>'2981','pid'=>'2972','shortname'=>'镇巴','name'=>'镇巴县','merger_name'=>'中国,陕西省,汉中市,镇巴县','level'=>'3','pinyin'=>'zhenba','code'=>'0916','zip_code'=>'723600','first'=>'Z','lng'=>'107.89648','lat'=>'32.53487']);
        $this->insert('{{%region}}',['id'=>'2982','pid'=>'2972','shortname'=>'留坝','name'=>'留坝县','merger_name'=>'中国,陕西省,汉中市,留坝县','level'=>'3','pinyin'=>'liuba','code'=>'0916','zip_code'=>'724100','first'=>'L','lng'=>'106.92233','lat'=>'33.61606']);
        $this->insert('{{%region}}',['id'=>'2983','pid'=>'2972','shortname'=>'佛坪','name'=>'佛坪县','merger_name'=>'中国,陕西省,汉中市,佛坪县','level'=>'3','pinyin'=>'foping','code'=>'0916','zip_code'=>'723400','first'=>'F','lng'=>'107.98974','lat'=>'33.52496']);
        $this->insert('{{%region}}',['id'=>'2984','pid'=>'2898','shortname'=>'榆林','name'=>'榆林市','merger_name'=>'中国,陕西省,榆林市','level'=>'2','pinyin'=>'yulin','code'=>'0912','zip_code'=>'719000','first'=>'Y','lng'=>'109.741193','lat'=>'38.290162']);
        $this->insert('{{%region}}',['id'=>'2985','pid'=>'2984','shortname'=>'榆阳','name'=>'榆阳区','merger_name'=>'中国,陕西省,榆林市,榆阳区','level'=>'3','pinyin'=>'yuyang','code'=>'0912','zip_code'=>'719000','first'=>'Y','lng'=>'109.73473','lat'=>'38.27843']);
        $this->insert('{{%region}}',['id'=>'2986','pid'=>'2984','shortname'=>'神木','name'=>'神木县','merger_name'=>'中国,陕西省,榆林市,神木县','level'=>'3','pinyin'=>'shenmu','code'=>'0912','zip_code'=>'719300','first'=>'S','lng'=>'110.4989','lat'=>'38.84234']);
        $this->insert('{{%region}}',['id'=>'2987','pid'=>'2984','shortname'=>'府谷','name'=>'府谷县','merger_name'=>'中国,陕西省,榆林市,府谷县','level'=>'3','pinyin'=>'fugu','code'=>'0912','zip_code'=>'719400','first'=>'F','lng'=>'111.06723','lat'=>'39.02805']);
        $this->insert('{{%region}}',['id'=>'2988','pid'=>'2984','shortname'=>'横山','name'=>'横山县','merger_name'=>'中国,陕西省,榆林市,横山县','level'=>'3','pinyin'=>'hengshan','code'=>'0912','zip_code'=>'719100','first'=>'H','lng'=>'109.29568','lat'=>'37.958']);
        $this->insert('{{%region}}',['id'=>'2989','pid'=>'2984','shortname'=>'靖边','name'=>'靖边县','merger_name'=>'中国,陕西省,榆林市,靖边县','level'=>'3','pinyin'=>'jingbian','code'=>'0912','zip_code'=>'718500','first'=>'J','lng'=>'108.79412','lat'=>'37.59938']);
        $this->insert('{{%region}}',['id'=>'2990','pid'=>'2984','shortname'=>'定边','name'=>'定边县','merger_name'=>'中国,陕西省,榆林市,定边县','level'=>'3','pinyin'=>'dingbian','code'=>'0912','zip_code'=>'718600','first'=>'D','lng'=>'107.59793','lat'=>'37.59037']);
        $this->insert('{{%region}}',['id'=>'2991','pid'=>'2984','shortname'=>'绥德','name'=>'绥德县','merger_name'=>'中国,陕西省,榆林市,绥德县','level'=>'3','pinyin'=>'suide','code'=>'0912','zip_code'=>'718000','first'=>'S','lng'=>'110.26126','lat'=>'37.49778']);
        $this->insert('{{%region}}',['id'=>'2992','pid'=>'2984','shortname'=>'米脂','name'=>'米脂县','merger_name'=>'中国,陕西省,榆林市,米脂县','level'=>'3','pinyin'=>'mizhi','code'=>'0912','zip_code'=>'718100','first'=>'M','lng'=>'110.18417','lat'=>'37.75529']);
        $this->insert('{{%region}}',['id'=>'2993','pid'=>'2984','shortname'=>'佳县','name'=>'佳县','merger_name'=>'中国,陕西省,榆林市,佳县','level'=>'3','pinyin'=>'jiaxian','code'=>'0912','zip_code'=>'719200','first'=>'J','lng'=>'110.49362','lat'=>'38.02248']);
        $this->insert('{{%region}}',['id'=>'2994','pid'=>'2984','shortname'=>'吴堡','name'=>'吴堡县','merger_name'=>'中国,陕西省,榆林市,吴堡县','level'=>'3','pinyin'=>'wubu','code'=>'0912','zip_code'=>'718200','first'=>'W','lng'=>'110.74533','lat'=>'37.45709']);
        $this->insert('{{%region}}',['id'=>'2995','pid'=>'2984','shortname'=>'清涧','name'=>'清涧县','merger_name'=>'中国,陕西省,榆林市,清涧县','level'=>'3','pinyin'=>'qingjian','code'=>'0912','zip_code'=>'718300','first'=>'Q','lng'=>'110.12173','lat'=>'37.08854']);
        $this->insert('{{%region}}',['id'=>'2996','pid'=>'2984','shortname'=>'子洲','name'=>'子洲县','merger_name'=>'中国,陕西省,榆林市,子洲县','level'=>'3','pinyin'=>'zizhou','code'=>'0912','zip_code'=>'718400','first'=>'Z','lng'=>'110.03488','lat'=>'37.61238']);
        $this->insert('{{%region}}',['id'=>'2997','pid'=>'2898','shortname'=>'安康','name'=>'安康市','merger_name'=>'中国,陕西省,安康市','level'=>'2','pinyin'=>'ankang','code'=>'0915','zip_code'=>'725000','first'=>'A','lng'=>'109.029273','lat'=>'32.6903']);
        $this->insert('{{%region}}',['id'=>'2998','pid'=>'2997','shortname'=>'汉滨','name'=>'汉滨区','merger_name'=>'中国,陕西省,安康市,汉滨区','level'=>'3','pinyin'=>'hanbin','code'=>'0915','zip_code'=>'725000','first'=>'H','lng'=>'109.02683','lat'=>'32.69517']);
        $this->insert('{{%region}}',['id'=>'2999','pid'=>'2997','shortname'=>'汉阴','name'=>'汉阴县','merger_name'=>'中国,陕西省,安康市,汉阴县','level'=>'3','pinyin'=>'hanyin','code'=>'0915','zip_code'=>'725100','first'=>'H','lng'=>'108.51098','lat'=>'32.89129']);
        $this->insert('{{%region}}',['id'=>'3000','pid'=>'2997','shortname'=>'石泉','name'=>'石泉县','merger_name'=>'中国,陕西省,安康市,石泉县','level'=>'3','pinyin'=>'shiquan','code'=>'0915','zip_code'=>'725200','first'=>'S','lng'=>'108.24755','lat'=>'33.03971']);
        $this->insert('{{%region}}',['id'=>'3001','pid'=>'2997','shortname'=>'宁陕','name'=>'宁陕县','merger_name'=>'中国,陕西省,安康市,宁陕县','level'=>'3','pinyin'=>'ningshan','code'=>'0915','zip_code'=>'711600','first'=>'N','lng'=>'108.31515','lat'=>'33.31726']);
        $this->insert('{{%region}}',['id'=>'3002','pid'=>'2997','shortname'=>'紫阳','name'=>'紫阳县','merger_name'=>'中国,陕西省,安康市,紫阳县','level'=>'3','pinyin'=>'ziyang','code'=>'0915','zip_code'=>'725300','first'=>'Z','lng'=>'108.5368','lat'=>'32.52115']);
        $this->insert('{{%region}}',['id'=>'3003','pid'=>'2997','shortname'=>'岚皋','name'=>'岚皋县','merger_name'=>'中国,陕西省,安康市,岚皋县','level'=>'3','pinyin'=>'langao','code'=>'0915','zip_code'=>'725400','first'=>NULL,'lng'=>'108.90289','lat'=>'32.30794']);
        $this->insert('{{%region}}',['id'=>'3004','pid'=>'2997','shortname'=>'平利','name'=>'平利县','merger_name'=>'中国,陕西省,安康市,平利县','level'=>'3','pinyin'=>'pingli','code'=>'0915','zip_code'=>'725500','first'=>'P','lng'=>'109.35775','lat'=>'32.39111']);
        $this->insert('{{%region}}',['id'=>'3005','pid'=>'2997','shortname'=>'镇坪','name'=>'镇坪县','merger_name'=>'中国,陕西省,安康市,镇坪县','level'=>'3','pinyin'=>'zhenping','code'=>'0915','zip_code'=>'725600','first'=>'Z','lng'=>'109.52456','lat'=>'31.8833']);
        $this->insert('{{%region}}',['id'=>'3006','pid'=>'2997','shortname'=>'旬阳','name'=>'旬阳县','merger_name'=>'中国,陕西省,安康市,旬阳县','level'=>'3','pinyin'=>'xunyang','code'=>'0915','zip_code'=>'725700','first'=>'X','lng'=>'109.3619','lat'=>'32.83207']);
        $this->insert('{{%region}}',['id'=>'3007','pid'=>'2997','shortname'=>'白河','name'=>'白河县','merger_name'=>'中国,陕西省,安康市,白河县','level'=>'3','pinyin'=>'baihe','code'=>'0915','zip_code'=>'725800','first'=>'B','lng'=>'110.11315','lat'=>'32.80955']);
        $this->insert('{{%region}}',['id'=>'3008','pid'=>'2898','shortname'=>'商洛','name'=>'商洛市','merger_name'=>'中国,陕西省,商洛市','level'=>'2','pinyin'=>'shangluo','code'=>'0914','zip_code'=>'726000','first'=>'S','lng'=>'109.939776','lat'=>'33.868319']);
        $this->insert('{{%region}}',['id'=>'3009','pid'=>'3008','shortname'=>'商州','name'=>'商州区','merger_name'=>'中国,陕西省,商洛市,商州区','level'=>'3','pinyin'=>'shangzhou','code'=>'0914','zip_code'=>'726000','first'=>'S','lng'=>'109.94126','lat'=>'33.8627']);
        $this->insert('{{%region}}',['id'=>'3010','pid'=>'3008','shortname'=>'洛南','name'=>'洛南县','merger_name'=>'中国,陕西省,商洛市,洛南县','level'=>'3','pinyin'=>'luonan','code'=>'0914','zip_code'=>'726100','first'=>'L','lng'=>'110.14645','lat'=>'34.08994']);
        $this->insert('{{%region}}',['id'=>'3011','pid'=>'3008','shortname'=>'丹凤','name'=>'丹凤县','merger_name'=>'中国,陕西省,商洛市,丹凤县','level'=>'3','pinyin'=>'danfeng','code'=>'0914','zip_code'=>'726200','first'=>'D','lng'=>'110.33486','lat'=>'33.69468']);
        $this->insert('{{%region}}',['id'=>'3012','pid'=>'3008','shortname'=>'商南','name'=>'商南县','merger_name'=>'中国,陕西省,商洛市,商南县','level'=>'3','pinyin'=>'shangnan','code'=>'0914','zip_code'=>'726300','first'=>'S','lng'=>'110.88375','lat'=>'33.52581']);
        $this->insert('{{%region}}',['id'=>'3013','pid'=>'3008','shortname'=>'山阳','name'=>'山阳县','merger_name'=>'中国,陕西省,商洛市,山阳县','level'=>'3','pinyin'=>'shanyang','code'=>'0914','zip_code'=>'726400','first'=>'S','lng'=>'109.88784','lat'=>'33.52931']);
        $this->insert('{{%region}}',['id'=>'3014','pid'=>'3008','shortname'=>'镇安','name'=>'镇安县','merger_name'=>'中国,陕西省,商洛市,镇安县','level'=>'3','pinyin'=>'zhen\'an','code'=>'0914','zip_code'=>'711500','first'=>'Z','lng'=>'109.15374','lat'=>'33.42366']);
        $this->insert('{{%region}}',['id'=>'3015','pid'=>'3008','shortname'=>'柞水','name'=>'柞水县','merger_name'=>'中国,陕西省,商洛市,柞水县','level'=>'3','pinyin'=>'zhashui','code'=>'0914','zip_code'=>'711400','first'=>'Z','lng'=>'109.11105','lat'=>'33.6831']);
        $this->insert('{{%region}}',['id'=>'3016','pid'=>'2898','shortname'=>'西咸','name'=>'西咸新区','merger_name'=>'中国,陕西省,西咸新区','level'=>'2','pinyin'=>'xixian','code'=>'029','zip_code'=>'712000','first'=>'X','lng'=>'108.810654','lat'=>'34.307144']);
        $this->insert('{{%region}}',['id'=>'3017','pid'=>'3016','shortname'=>'空港','name'=>'空港新城','merger_name'=>'中国,陕西省,西咸新区,空港新城','level'=>'3','pinyin'=>'konggang','code'=>'0374','zip_code'=>'461000','first'=>'K','lng'=>'108.760529','lat'=>'34.440894']);
        $this->insert('{{%region}}',['id'=>'3018','pid'=>'3016','shortname'=>'沣东','name'=>'沣东新城','merger_name'=>'中国,陕西省,西咸新区,沣东新城','level'=>'3','pinyin'=>'fengdong','code'=>'029','zip_code'=>'710000','first'=>NULL,'lng'=>'108.82988','lat'=>'34.267431']);
        $this->insert('{{%region}}',['id'=>'3019','pid'=>'3016','shortname'=>'秦汉','name'=>'秦汉新城','merger_name'=>'中国,陕西省,西咸新区,秦汉新城','level'=>'3','pinyin'=>'qinhan','code'=>'029','zip_code'=>'712000','first'=>'Q','lng'=>'108.83812','lat'=>'34.386513']);
        $this->insert('{{%region}}',['id'=>'3020','pid'=>'3016','shortname'=>'沣西','name'=>'沣西新城','merger_name'=>'中国,陕西省,西咸新区,沣西新城','level'=>'3','pinyin'=>'fengxi','code'=>'029','zip_code'=>'710000','first'=>NULL,'lng'=>'108.71215','lat'=>'34.190453']);
        $this->insert('{{%region}}',['id'=>'3021','pid'=>'3016','shortname'=>'泾河','name'=>'泾河新城','merger_name'=>'中国,陕西省,西咸新区,泾河新城','level'=>'3','pinyin'=>'jinghe','code'=>'029','zip_code'=>'713700','first'=>NULL,'lng'=>'109.049603','lat'=>'34.460587']);
        $this->insert('{{%region}}',['id'=>'3022','pid'=>'0','shortname'=>'甘肃','name'=>'甘肃省','merger_name'=>'中国,甘肃省','level'=>'1','pinyin'=>'gansu','code'=>'','zip_code'=>'','first'=>'G','lng'=>'103.823557','lat'=>'36.058039']);
        $this->insert('{{%region}}',['id'=>'3023','pid'=>'3022','shortname'=>'兰州','name'=>'兰州市','merger_name'=>'中国,甘肃省,兰州市','level'=>'2','pinyin'=>'lanzhou','code'=>'0931','zip_code'=>'730030','first'=>'L','lng'=>'103.823557','lat'=>'36.058039']);
        $this->insert('{{%region}}',['id'=>'3024','pid'=>'3023','shortname'=>'城关','name'=>'城关区','merger_name'=>'中国,甘肃省,兰州市,城关区','level'=>'3','pinyin'=>'chengguan','code'=>'0931','zip_code'=>'730030','first'=>'C','lng'=>'103.8252','lat'=>'36.05725']);
        $this->insert('{{%region}}',['id'=>'3025','pid'=>'3023','shortname'=>'七里河','name'=>'七里河区','merger_name'=>'中国,甘肃省,兰州市,七里河区','level'=>'3','pinyin'=>'qilihe','code'=>'0931','zip_code'=>'730050','first'=>'Q','lng'=>'103.78564','lat'=>'36.06585']);
        $this->insert('{{%region}}',['id'=>'3026','pid'=>'3023','shortname'=>'西固','name'=>'西固区','merger_name'=>'中国,甘肃省,兰州市,西固区','level'=>'3','pinyin'=>'xigu','code'=>'0931','zip_code'=>'730060','first'=>'X','lng'=>'103.62811','lat'=>'36.08858']);
        $this->insert('{{%region}}',['id'=>'3027','pid'=>'3023','shortname'=>'安宁','name'=>'安宁区','merger_name'=>'中国,甘肃省,兰州市,安宁区','level'=>'3','pinyin'=>'anning','code'=>'0931','zip_code'=>'730070','first'=>'A','lng'=>'103.7189','lat'=>'36.10384']);
        $this->insert('{{%region}}',['id'=>'3028','pid'=>'3023','shortname'=>'红古','name'=>'红古区','merger_name'=>'中国,甘肃省,兰州市,红古区','level'=>'3','pinyin'=>'honggu','code'=>'0931','zip_code'=>'730084','first'=>'H','lng'=>'102.85955','lat'=>'36.34537']);
        $this->insert('{{%region}}',['id'=>'3029','pid'=>'3023','shortname'=>'永登','name'=>'永登县','merger_name'=>'中国,甘肃省,兰州市,永登县','level'=>'3','pinyin'=>'yongdeng','code'=>'0931','zip_code'=>'730300','first'=>'Y','lng'=>'103.26055','lat'=>'36.73522']);
        $this->insert('{{%region}}',['id'=>'3030','pid'=>'3023','shortname'=>'皋兰','name'=>'皋兰县','merger_name'=>'中国,甘肃省,兰州市,皋兰县','level'=>'3','pinyin'=>'gaolan','code'=>'0931','zip_code'=>'730200','first'=>'G','lng'=>'103.94506','lat'=>'36.33215']);
        $this->insert('{{%region}}',['id'=>'3031','pid'=>'3023','shortname'=>'榆中','name'=>'榆中县','merger_name'=>'中国,甘肃省,兰州市,榆中县','level'=>'3','pinyin'=>'yuzhong','code'=>'0931','zip_code'=>'730100','first'=>'Y','lng'=>'104.1145','lat'=>'35.84415']);
        $this->insert('{{%region}}',['id'=>'3032','pid'=>'3022','shortname'=>'嘉峪关','name'=>'嘉峪关市','merger_name'=>'中国,甘肃省,嘉峪关市','level'=>'2','pinyin'=>'jiayuguan','code'=>'0937','zip_code'=>'735100','first'=>'J','lng'=>'98.277304','lat'=>'39.786529']);
        $this->insert('{{%region}}',['id'=>'3033','pid'=>'3032','shortname'=>'雄关','name'=>'雄关区','merger_name'=>'中国,甘肃省,嘉峪关市,雄关区','level'=>'3','pinyin'=>'xiongguan','code'=>'0937','zip_code'=>'735100','first'=>'X','lng'=>'98.277398','lat'=>'39.77925']);
        $this->insert('{{%region}}',['id'=>'3034','pid'=>'3032','shortname'=>'长城','name'=>'长城区','merger_name'=>'中国,甘肃省,嘉峪关市,长城区','level'=>'3','pinyin'=>'changcheng','code'=>'0937','zip_code'=>'735106','first'=>'C','lng'=>'98.273523','lat'=>'39.787431']);
        $this->insert('{{%region}}',['id'=>'3035','pid'=>'3032','shortname'=>'镜铁','name'=>'镜铁区','merger_name'=>'中国,甘肃省,嘉峪关市,镜铁区','level'=>'3','pinyin'=>'jingtie','code'=>'0937','zip_code'=>'735100','first'=>'J','lng'=>'98.277304','lat'=>'39.786529']);
        $this->insert('{{%region}}',['id'=>'3036','pid'=>'3022','shortname'=>'金昌','name'=>'金昌市','merger_name'=>'中国,甘肃省,金昌市','level'=>'2','pinyin'=>'jinchang','code'=>'0935','zip_code'=>'737100','first'=>'J','lng'=>'102.187888','lat'=>'38.514238']);
        $this->insert('{{%region}}',['id'=>'3037','pid'=>'3036','shortname'=>'金川','name'=>'金川区','merger_name'=>'中国,甘肃省,金昌市,金川区','level'=>'3','pinyin'=>'jinchuan','code'=>'0935','zip_code'=>'737100','first'=>'J','lng'=>'102.19376','lat'=>'38.52101']);
        $this->insert('{{%region}}',['id'=>'3038','pid'=>'3036','shortname'=>'永昌','name'=>'永昌县','merger_name'=>'中国,甘肃省,金昌市,永昌县','level'=>'3','pinyin'=>'yongchang','code'=>'0935','zip_code'=>'737200','first'=>'Y','lng'=>'101.97222','lat'=>'38.24711']);
        $this->insert('{{%region}}',['id'=>'3039','pid'=>'3022','shortname'=>'白银','name'=>'白银市','merger_name'=>'中国,甘肃省,白银市','level'=>'2','pinyin'=>'baiyin','code'=>'0943','zip_code'=>'730900','first'=>'B','lng'=>'104.173606','lat'=>'36.54568']);
        $this->insert('{{%region}}',['id'=>'3040','pid'=>'3039','shortname'=>'白银','name'=>'白银区','merger_name'=>'中国,甘肃省,白银市,白银区','level'=>'3','pinyin'=>'baiyin','code'=>'0943','zip_code'=>'730900','first'=>'B','lng'=>'104.17355','lat'=>'36.54411']);
        $this->insert('{{%region}}',['id'=>'3041','pid'=>'3039','shortname'=>'平川','name'=>'平川区','merger_name'=>'中国,甘肃省,白银市,平川区','level'=>'3','pinyin'=>'pingchuan','code'=>'0943','zip_code'=>'730913','first'=>'P','lng'=>'104.82498','lat'=>'36.7277']);
        $this->insert('{{%region}}',['id'=>'3042','pid'=>'3039','shortname'=>'靖远','name'=>'靖远县','merger_name'=>'中国,甘肃省,白银市,靖远县','level'=>'3','pinyin'=>'jingyuan','code'=>'0943','zip_code'=>'730600','first'=>'J','lng'=>'104.68325','lat'=>'36.56602']);
        $this->insert('{{%region}}',['id'=>'3043','pid'=>'3039','shortname'=>'会宁','name'=>'会宁县','merger_name'=>'中国,甘肃省,白银市,会宁县','level'=>'3','pinyin'=>'huining','code'=>'0943','zip_code'=>'730700','first'=>'H','lng'=>'105.05297','lat'=>'35.69626']);
        $this->insert('{{%region}}',['id'=>'3044','pid'=>'3039','shortname'=>'景泰','name'=>'景泰县','merger_name'=>'中国,甘肃省,白银市,景泰县','level'=>'3','pinyin'=>'jingtai','code'=>'0943','zip_code'=>'730400','first'=>'J','lng'=>'104.06295','lat'=>'37.18359']);
        $this->insert('{{%region}}',['id'=>'3045','pid'=>'3022','shortname'=>'天水','name'=>'天水市','merger_name'=>'中国,甘肃省,天水市','level'=>'2','pinyin'=>'tianshui','code'=>'0938','zip_code'=>'741000','first'=>'T','lng'=>'105.724998','lat'=>'34.578529']);
        $this->insert('{{%region}}',['id'=>'3046','pid'=>'3045','shortname'=>'秦州','name'=>'秦州区','merger_name'=>'中国,甘肃省,天水市,秦州区','level'=>'3','pinyin'=>'qinzhou','code'=>'0938','zip_code'=>'741000','first'=>'Q','lng'=>'105.72421','lat'=>'34.58089']);
        $this->insert('{{%region}}',['id'=>'3047','pid'=>'3045','shortname'=>'麦积','name'=>'麦积区','merger_name'=>'中国,甘肃省,天水市,麦积区','level'=>'3','pinyin'=>'maiji','code'=>'0938','zip_code'=>'741020','first'=>'M','lng'=>'105.89013','lat'=>'34.57069']);
        $this->insert('{{%region}}',['id'=>'3048','pid'=>'3045','shortname'=>'清水','name'=>'清水县','merger_name'=>'中国,甘肃省,天水市,清水县','level'=>'3','pinyin'=>'qingshui','code'=>'0938','zip_code'=>'741400','first'=>'Q','lng'=>'106.13671','lat'=>'34.75032']);
        $this->insert('{{%region}}',['id'=>'3049','pid'=>'3045','shortname'=>'秦安','name'=>'秦安县','merger_name'=>'中国,甘肃省,天水市,秦安县','level'=>'3','pinyin'=>'qin\'an','code'=>'0938','zip_code'=>'741600','first'=>'Q','lng'=>'105.66955','lat'=>'34.85894']);
        $this->insert('{{%region}}',['id'=>'3050','pid'=>'3045','shortname'=>'甘谷','name'=>'甘谷县','merger_name'=>'中国,甘肃省,天水市,甘谷县','level'=>'3','pinyin'=>'gangu','code'=>'0938','zip_code'=>'741200','first'=>'G','lng'=>'105.33291','lat'=>'34.73665']);
        $this->insert('{{%region}}',['id'=>'3051','pid'=>'3045','shortname'=>'武山','name'=>'武山县','merger_name'=>'中国,甘肃省,天水市,武山县','level'=>'3','pinyin'=>'wushan','code'=>'0938','zip_code'=>'741300','first'=>'W','lng'=>'104.88382','lat'=>'34.72123']);
        $this->insert('{{%region}}',['id'=>'3052','pid'=>'3045','shortname'=>'张家川','name'=>'张家川回族自治县','merger_name'=>'中国,甘肃省,天水市,张家川回族自治县','level'=>'3','pinyin'=>'zhangjiachuan','code'=>'0938','zip_code'=>'741500','first'=>'Z','lng'=>'106.21582','lat'=>'34.99582']);
        $this->insert('{{%region}}',['id'=>'3053','pid'=>'3022','shortname'=>'武威','name'=>'武威市','merger_name'=>'中国,甘肃省,武威市','level'=>'2','pinyin'=>'wuwei','code'=>'0935','zip_code'=>'733000','first'=>'W','lng'=>'102.634697','lat'=>'37.929996']);
        $this->insert('{{%region}}',['id'=>'3054','pid'=>'3053','shortname'=>'凉州','name'=>'凉州区','merger_name'=>'中国,甘肃省,武威市,凉州区','level'=>'3','pinyin'=>'liangzhou','code'=>'0935','zip_code'=>'733000','first'=>'L','lng'=>'102.64203','lat'=>'37.92832']);
        $this->insert('{{%region}}',['id'=>'3055','pid'=>'3053','shortname'=>'民勤','name'=>'民勤县','merger_name'=>'中国,甘肃省,武威市,民勤县','level'=>'3','pinyin'=>'minqin','code'=>'0935','zip_code'=>'733300','first'=>'M','lng'=>'103.09011','lat'=>'38.62487']);
        $this->insert('{{%region}}',['id'=>'3056','pid'=>'3053','shortname'=>'古浪','name'=>'古浪县','merger_name'=>'中国,甘肃省,武威市,古浪县','level'=>'3','pinyin'=>'gulang','code'=>'0935','zip_code'=>'733100','first'=>'G','lng'=>'102.89154','lat'=>'37.46508']);
        $this->insert('{{%region}}',['id'=>'3057','pid'=>'3053','shortname'=>'天祝','name'=>'天祝藏族自治县','merger_name'=>'中国,甘肃省,武威市,天祝藏族自治县','level'=>'3','pinyin'=>'tianzhu','code'=>'0935','zip_code'=>'733200','first'=>'T','lng'=>'103.1361','lat'=>'36.97715']);
        $this->insert('{{%region}}',['id'=>'3058','pid'=>'3022','shortname'=>'张掖','name'=>'张掖市','merger_name'=>'中国,甘肃省,张掖市','level'=>'2','pinyin'=>'zhangye','code'=>'0936','zip_code'=>'734000','first'=>'Z','lng'=>'100.455472','lat'=>'38.932897']);
        $this->insert('{{%region}}',['id'=>'3059','pid'=>'3058','shortname'=>'甘州','name'=>'甘州区','merger_name'=>'中国,甘肃省,张掖市,甘州区','level'=>'3','pinyin'=>'ganzhou','code'=>'0936','zip_code'=>'734000','first'=>'G','lng'=>'100.4527','lat'=>'38.92947']);
        $this->insert('{{%region}}',['id'=>'3060','pid'=>'3058','shortname'=>'肃南','name'=>'肃南裕固族自治县','merger_name'=>'中国,甘肃省,张掖市,肃南裕固族自治县','level'=>'3','pinyin'=>'sunan','code'=>'0936','zip_code'=>'734400','first'=>'S','lng'=>'99.61407','lat'=>'38.83776']);
        $this->insert('{{%region}}',['id'=>'3061','pid'=>'3058','shortname'=>'民乐','name'=>'民乐县','merger_name'=>'中国,甘肃省,张掖市,民乐县','level'=>'3','pinyin'=>'minle','code'=>'0936','zip_code'=>'734500','first'=>'M','lng'=>'100.81091','lat'=>'38.43479']);
        $this->insert('{{%region}}',['id'=>'3062','pid'=>'3058','shortname'=>'临泽','name'=>'临泽县','merger_name'=>'中国,甘肃省,张掖市,临泽县','level'=>'3','pinyin'=>'linze','code'=>'0936','zip_code'=>'734200','first'=>'L','lng'=>'100.16445','lat'=>'39.15252']);
        $this->insert('{{%region}}',['id'=>'3063','pid'=>'3058','shortname'=>'高台','name'=>'高台县','merger_name'=>'中国,甘肃省,张掖市,高台县','level'=>'3','pinyin'=>'gaotai','code'=>'0936','zip_code'=>'734300','first'=>'G','lng'=>'99.81918','lat'=>'39.37829']);
        $this->insert('{{%region}}',['id'=>'3064','pid'=>'3058','shortname'=>'山丹','name'=>'山丹县','merger_name'=>'中国,甘肃省,张掖市,山丹县','level'=>'3','pinyin'=>'shandan','code'=>'0936','zip_code'=>'734100','first'=>'S','lng'=>'101.09359','lat'=>'38.78468']);
        $this->insert('{{%region}}',['id'=>'3065','pid'=>'3022','shortname'=>'平凉','name'=>'平凉市','merger_name'=>'中国,甘肃省,平凉市','level'=>'2','pinyin'=>'pingliang','code'=>'0933','zip_code'=>'744000','first'=>'P','lng'=>'106.684691','lat'=>'35.54279']);
        $this->insert('{{%region}}',['id'=>'3066','pid'=>'3065','shortname'=>'崆峒','name'=>'崆峒区','merger_name'=>'中国,甘肃省,平凉市,崆峒区','level'=>'3','pinyin'=>'kongtong','code'=>'0933','zip_code'=>'744000','first'=>NULL,'lng'=>'106.67483','lat'=>'35.54262']);
        $this->insert('{{%region}}',['id'=>'3067','pid'=>'3065','shortname'=>'泾川','name'=>'泾川县','merger_name'=>'中国,甘肃省,平凉市,泾川县','level'=>'3','pinyin'=>'jingchuan','code'=>'0933','zip_code'=>'744300','first'=>NULL,'lng'=>'107.36581','lat'=>'35.33223']);
        $this->insert('{{%region}}',['id'=>'3068','pid'=>'3065','shortname'=>'灵台','name'=>'灵台县','merger_name'=>'中国,甘肃省,平凉市,灵台县','level'=>'3','pinyin'=>'lingtai','code'=>'0933','zip_code'=>'744400','first'=>'L','lng'=>'107.6174','lat'=>'35.06768']);
        $this->insert('{{%region}}',['id'=>'3069','pid'=>'3065','shortname'=>'崇信','name'=>'崇信县','merger_name'=>'中国,甘肃省,平凉市,崇信县','level'=>'3','pinyin'=>'chongxin','code'=>'0933','zip_code'=>'744200','first'=>'C','lng'=>'107.03738','lat'=>'35.30344']);
        $this->insert('{{%region}}',['id'=>'3070','pid'=>'3065','shortname'=>'华亭','name'=>'华亭县','merger_name'=>'中国,甘肃省,平凉市,华亭县','level'=>'3','pinyin'=>'huating','code'=>'0933','zip_code'=>'744100','first'=>'H','lng'=>'106.65463','lat'=>'35.2183']);
        $this->insert('{{%region}}',['id'=>'3071','pid'=>'3065','shortname'=>'庄浪','name'=>'庄浪县','merger_name'=>'中国,甘肃省,平凉市,庄浪县','level'=>'3','pinyin'=>'zhuanglang','code'=>'0933','zip_code'=>'744600','first'=>'Z','lng'=>'106.03662','lat'=>'35.20235']);
        $this->insert('{{%region}}',['id'=>'3072','pid'=>'3065','shortname'=>'静宁','name'=>'静宁县','merger_name'=>'中国,甘肃省,平凉市,静宁县','level'=>'3','pinyin'=>'jingning','code'=>'0933','zip_code'=>'743400','first'=>'J','lng'=>'105.72723','lat'=>'35.51991']);
        $this->insert('{{%region}}',['id'=>'3073','pid'=>'3022','shortname'=>'酒泉','name'=>'酒泉市','merger_name'=>'中国,甘肃省,酒泉市','level'=>'2','pinyin'=>'jiuquan','code'=>'0937','zip_code'=>'735000','first'=>'J','lng'=>'98.510795','lat'=>'39.744023']);
        $this->insert('{{%region}}',['id'=>'3074','pid'=>'3073','shortname'=>'肃州','name'=>'肃州区','merger_name'=>'中国,甘肃省,酒泉市,肃州区','level'=>'3','pinyin'=>'suzhou','code'=>'0937','zip_code'=>'735000','first'=>'S','lng'=>'98.50775','lat'=>'39.74506']);
        $this->insert('{{%region}}',['id'=>'3075','pid'=>'3073','shortname'=>'金塔','name'=>'金塔县','merger_name'=>'中国,甘肃省,酒泉市,金塔县','level'=>'3','pinyin'=>'jinta','code'=>'0937','zip_code'=>'735300','first'=>'J','lng'=>'98.90002','lat'=>'39.97733']);
        $this->insert('{{%region}}',['id'=>'3076','pid'=>'3073','shortname'=>'瓜州','name'=>'瓜州县','merger_name'=>'中国,甘肃省,酒泉市,瓜州县','level'=>'3','pinyin'=>'guazhou','code'=>'0937','zip_code'=>'736100','first'=>'G','lng'=>'95.78271','lat'=>'40.51548']);
        $this->insert('{{%region}}',['id'=>'3077','pid'=>'3073','shortname'=>'肃北','name'=>'肃北蒙古族自治县','merger_name'=>'中国,甘肃省,酒泉市,肃北蒙古族自治县','level'=>'3','pinyin'=>'subei','code'=>'0937','zip_code'=>'736300','first'=>'S','lng'=>'94.87649','lat'=>'39.51214']);
        $this->insert('{{%region}}',['id'=>'3078','pid'=>'3073','shortname'=>'阿克塞','name'=>'阿克塞哈萨克族自治县','merger_name'=>'中国,甘肃省,酒泉市,阿克塞哈萨克族自治县','level'=>'3','pinyin'=>'akesai','code'=>'0937','zip_code'=>'736400','first'=>'A','lng'=>'94.34097','lat'=>'39.63435']);
        $this->insert('{{%region}}',['id'=>'3079','pid'=>'3073','shortname'=>'玉门','name'=>'玉门市','merger_name'=>'中国,甘肃省,酒泉市,玉门市','level'=>'3','pinyin'=>'yumen','code'=>'0937','zip_code'=>'735200','first'=>'Y','lng'=>'97.04538','lat'=>'40.29172']);
        $this->insert('{{%region}}',['id'=>'3080','pid'=>'3073','shortname'=>'敦煌','name'=>'敦煌市','merger_name'=>'中国,甘肃省,酒泉市,敦煌市','level'=>'3','pinyin'=>'dunhuang','code'=>'0937','zip_code'=>'736200','first'=>'D','lng'=>'94.66159','lat'=>'40.14211']);
        $this->insert('{{%region}}',['id'=>'3081','pid'=>'3022','shortname'=>'庆阳','name'=>'庆阳市','merger_name'=>'中国,甘肃省,庆阳市','level'=>'2','pinyin'=>'qingyang','code'=>'0934','zip_code'=>'745000','first'=>'Q','lng'=>'107.638372','lat'=>'35.734218']);
        $this->insert('{{%region}}',['id'=>'3082','pid'=>'3081','shortname'=>'西峰','name'=>'西峰区','merger_name'=>'中国,甘肃省,庆阳市,西峰区','level'=>'3','pinyin'=>'xifeng','code'=>'0934','zip_code'=>'745000','first'=>'X','lng'=>'107.65107','lat'=>'35.73065']);
        $this->insert('{{%region}}',['id'=>'3083','pid'=>'3081','shortname'=>'庆城','name'=>'庆城县','merger_name'=>'中国,甘肃省,庆阳市,庆城县','level'=>'3','pinyin'=>'qingcheng','code'=>'0934','zip_code'=>'745100','first'=>'Q','lng'=>'107.88272','lat'=>'36.01507']);
        $this->insert('{{%region}}',['id'=>'3084','pid'=>'3081','shortname'=>'环县','name'=>'环县','merger_name'=>'中国,甘肃省,庆阳市,环县','level'=>'3','pinyin'=>'huanxian','code'=>'0934','zip_code'=>'745700','first'=>'H','lng'=>'107.30835','lat'=>'36.56846']);
        $this->insert('{{%region}}',['id'=>'3085','pid'=>'3081','shortname'=>'华池','name'=>'华池县','merger_name'=>'中国,甘肃省,庆阳市,华池县','level'=>'3','pinyin'=>'huachi','code'=>'0934','zip_code'=>'745600','first'=>'H','lng'=>'107.9891','lat'=>'36.46108']);
        $this->insert('{{%region}}',['id'=>'3086','pid'=>'3081','shortname'=>'合水','name'=>'合水县','merger_name'=>'中国,甘肃省,庆阳市,合水县','level'=>'3','pinyin'=>'heshui','code'=>'0934','zip_code'=>'745400','first'=>'H','lng'=>'108.02032','lat'=>'35.81911']);
        $this->insert('{{%region}}',['id'=>'3087','pid'=>'3081','shortname'=>'正宁','name'=>'正宁县','merger_name'=>'中国,甘肃省,庆阳市,正宁县','level'=>'3','pinyin'=>'zhengning','code'=>'0934','zip_code'=>'745300','first'=>'Z','lng'=>'108.36007','lat'=>'35.49174']);
        $this->insert('{{%region}}',['id'=>'3088','pid'=>'3081','shortname'=>'宁县','name'=>'宁县','merger_name'=>'中国,甘肃省,庆阳市,宁县','level'=>'3','pinyin'=>'ningxian','code'=>'0934','zip_code'=>'745200','first'=>'N','lng'=>'107.92517','lat'=>'35.50164']);
        $this->insert('{{%region}}',['id'=>'3089','pid'=>'3081','shortname'=>'镇原','name'=>'镇原县','merger_name'=>'中国,甘肃省,庆阳市,镇原县','level'=>'3','pinyin'=>'zhenyuan','code'=>'0934','zip_code'=>'744500','first'=>'Z','lng'=>'107.199','lat'=>'35.67712']);
        $this->insert('{{%region}}',['id'=>'3090','pid'=>'3022','shortname'=>'定西','name'=>'定西市','merger_name'=>'中国,甘肃省,定西市','level'=>'2','pinyin'=>'dingxi','code'=>'0932','zip_code'=>'743000','first'=>'D','lng'=>'104.626294','lat'=>'35.579578']);
        $this->insert('{{%region}}',['id'=>'3091','pid'=>'3090','shortname'=>'安定','name'=>'安定区','merger_name'=>'中国,甘肃省,定西市,安定区','level'=>'3','pinyin'=>'anding','code'=>'0932','zip_code'=>'743000','first'=>'A','lng'=>'104.6106','lat'=>'35.58066']);
        $this->insert('{{%region}}',['id'=>'3092','pid'=>'3090','shortname'=>'通渭','name'=>'通渭县','merger_name'=>'中国,甘肃省,定西市,通渭县','level'=>'3','pinyin'=>'tongwei','code'=>'0932','zip_code'=>'743300','first'=>'T','lng'=>'105.24224','lat'=>'35.21101']);
        $this->insert('{{%region}}',['id'=>'3093','pid'=>'3090','shortname'=>'陇西','name'=>'陇西县','merger_name'=>'中国,甘肃省,定西市,陇西县','level'=>'3','pinyin'=>'longxi','code'=>'0932','zip_code'=>'748100','first'=>'L','lng'=>'104.63446','lat'=>'35.00238']);
        $this->insert('{{%region}}',['id'=>'3094','pid'=>'3090','shortname'=>'渭源','name'=>'渭源县','merger_name'=>'中国,甘肃省,定西市,渭源县','level'=>'3','pinyin'=>'weiyuan','code'=>'0932','zip_code'=>'748200','first'=>'W','lng'=>'104.21435','lat'=>'35.13649']);
        $this->insert('{{%region}}',['id'=>'3095','pid'=>'3090','shortname'=>'临洮','name'=>'临洮县','merger_name'=>'中国,甘肃省,定西市,临洮县','level'=>'3','pinyin'=>'lintao','code'=>'0932','zip_code'=>'730500','first'=>'L','lng'=>'103.86196','lat'=>'35.3751']);
        $this->insert('{{%region}}',['id'=>'3096','pid'=>'3090','shortname'=>'漳县','name'=>'漳县','merger_name'=>'中国,甘肃省,定西市,漳县','level'=>'3','pinyin'=>'zhangxian','code'=>'0932','zip_code'=>'748300','first'=>'Z','lng'=>'104.46704','lat'=>'34.84977']);
        $this->insert('{{%region}}',['id'=>'3097','pid'=>'3090','shortname'=>'岷县','name'=>'岷县','merger_name'=>'中国,甘肃省,定西市,岷县','level'=>'3','pinyin'=>'minxian','code'=>'0932','zip_code'=>'748400','first'=>NULL,'lng'=>'104.03772','lat'=>'34.43444']);
        $this->insert('{{%region}}',['id'=>'3098','pid'=>'3022','shortname'=>'陇南','name'=>'陇南市','merger_name'=>'中国,甘肃省,陇南市','level'=>'2','pinyin'=>'longnan','code'=>'0939','zip_code'=>'746000','first'=>'L','lng'=>'104.929379','lat'=>'33.388598']);
        $this->insert('{{%region}}',['id'=>'3099','pid'=>'3098','shortname'=>'武都','name'=>'武都区','merger_name'=>'中国,甘肃省,陇南市,武都区','level'=>'3','pinyin'=>'wudu','code'=>'0939','zip_code'=>'746000','first'=>'W','lng'=>'104.92652','lat'=>'33.39239']);
        $this->insert('{{%region}}',['id'=>'3100','pid'=>'3098','shortname'=>'成县','name'=>'成县','merger_name'=>'中国,甘肃省,陇南市,成县','level'=>'3','pinyin'=>'chengxian','code'=>'0939','zip_code'=>'742500','first'=>'C','lng'=>'105.72586','lat'=>'33.73925']);
        $this->insert('{{%region}}',['id'=>'3101','pid'=>'3098','shortname'=>'文县','name'=>'文县','merger_name'=>'中国,甘肃省,陇南市,文县','level'=>'3','pinyin'=>'wenxian','code'=>'0939','zip_code'=>'746400','first'=>'W','lng'=>'104.68362','lat'=>'32.94337']);
        $this->insert('{{%region}}',['id'=>'3102','pid'=>'3098','shortname'=>'宕昌','name'=>'宕昌县','merger_name'=>'中国,甘肃省,陇南市,宕昌县','level'=>'3','pinyin'=>'dangchang','code'=>'0939','zip_code'=>'748500','first'=>NULL,'lng'=>'104.39349','lat'=>'34.04732']);
        $this->insert('{{%region}}',['id'=>'3103','pid'=>'3098','shortname'=>'康县','name'=>'康县','merger_name'=>'中国,甘肃省,陇南市,康县','level'=>'3','pinyin'=>'kangxian','code'=>'0939','zip_code'=>'746500','first'=>'K','lng'=>'105.60711','lat'=>'33.32912']);
        $this->insert('{{%region}}',['id'=>'3104','pid'=>'3098','shortname'=>'西和','name'=>'西和县','merger_name'=>'中国,甘肃省,陇南市,西和县','level'=>'3','pinyin'=>'xihe','code'=>'0939','zip_code'=>'742100','first'=>'X','lng'=>'105.30099','lat'=>'34.01432']);
        $this->insert('{{%region}}',['id'=>'3105','pid'=>'3098','shortname'=>'礼县','name'=>'礼县','merger_name'=>'中国,甘肃省,陇南市,礼县','level'=>'3','pinyin'=>'lixian','code'=>'0939','zip_code'=>'742200','first'=>'L','lng'=>'105.17785','lat'=>'34.18935']);
        $this->insert('{{%region}}',['id'=>'3106','pid'=>'3098','shortname'=>'徽县','name'=>'徽县','merger_name'=>'中国,甘肃省,陇南市,徽县','level'=>'3','pinyin'=>'huixian','code'=>'0939','zip_code'=>'742300','first'=>'H','lng'=>'106.08529','lat'=>'33.76898']);
        $this->insert('{{%region}}',['id'=>'3107','pid'=>'3098','shortname'=>'两当','name'=>'两当县','merger_name'=>'中国,甘肃省,陇南市,两当县','level'=>'3','pinyin'=>'liangdang','code'=>'0939','zip_code'=>'742400','first'=>'L','lng'=>'106.30484','lat'=>'33.9096']);
        $this->insert('{{%region}}',['id'=>'3108','pid'=>'3022','shortname'=>'临夏','name'=>'临夏回族自治州','merger_name'=>'中国,甘肃省,临夏回族自治州','level'=>'2','pinyin'=>'linxia','code'=>'0930','zip_code'=>'731100','first'=>'L','lng'=>'103.212006','lat'=>'35.599446']);
        $this->insert('{{%region}}',['id'=>'3109','pid'=>'3108','shortname'=>'临夏','name'=>'临夏市','merger_name'=>'中国,甘肃省,临夏回族自治州,临夏市','level'=>'3','pinyin'=>'linxia','code'=>'0930','zip_code'=>'731100','first'=>'L','lng'=>'103.21','lat'=>'35.59916']);
        $this->insert('{{%region}}',['id'=>'3110','pid'=>'3108','shortname'=>'临夏','name'=>'临夏县','merger_name'=>'中国,甘肃省,临夏回族自治州,临夏县','level'=>'3','pinyin'=>'linxia','code'=>'0930','zip_code'=>'731800','first'=>'L','lng'=>'102.9938','lat'=>'35.49519']);
        $this->insert('{{%region}}',['id'=>'3111','pid'=>'3108','shortname'=>'康乐','name'=>'康乐县','merger_name'=>'中国,甘肃省,临夏回族自治州,康乐县','level'=>'3','pinyin'=>'kangle','code'=>'0930','zip_code'=>'731500','first'=>'K','lng'=>'103.71093','lat'=>'35.37219']);
        $this->insert('{{%region}}',['id'=>'3112','pid'=>'3108','shortname'=>'永靖','name'=>'永靖县','merger_name'=>'中国,甘肃省,临夏回族自治州,永靖县','level'=>'3','pinyin'=>'yongjing','code'=>'0930','zip_code'=>'731600','first'=>'Y','lng'=>'103.32043','lat'=>'35.93835']);
        $this->insert('{{%region}}',['id'=>'3113','pid'=>'3108','shortname'=>'广河','name'=>'广河县','merger_name'=>'中国,甘肃省,临夏回族自治州,广河县','level'=>'3','pinyin'=>'guanghe','code'=>'0930','zip_code'=>'731300','first'=>'G','lng'=>'103.56933','lat'=>'35.48097']);
        $this->insert('{{%region}}',['id'=>'3114','pid'=>'3108','shortname'=>'和政','name'=>'和政县','merger_name'=>'中国,甘肃省,临夏回族自治州,和政县','level'=>'3','pinyin'=>'hezheng','code'=>'0930','zip_code'=>'731200','first'=>'H','lng'=>'103.34936','lat'=>'35.42592']);
        $this->insert('{{%region}}',['id'=>'3115','pid'=>'3108','shortname'=>'东乡族','name'=>'东乡族自治县','merger_name'=>'中国,甘肃省,临夏回族自治州,东乡族自治县','level'=>'3','pinyin'=>'dongxiangzu','code'=>'0930','zip_code'=>'731400','first'=>'D','lng'=>'103.39477','lat'=>'35.66471']);
        $this->insert('{{%region}}',['id'=>'3116','pid'=>'3108','shortname'=>'积石山','name'=>'积石山保安族东乡族撒拉族自治县','merger_name'=>'中国,甘肃省,临夏回族自治州,积石山保安族东乡族撒拉族自治县','level'=>'3','pinyin'=>'jishishan','code'=>'0930','zip_code'=>'731700','first'=>'J','lng'=>'102.87374','lat'=>'35.7182']);
        $this->insert('{{%region}}',['id'=>'3117','pid'=>'3022','shortname'=>'甘南','name'=>'甘南藏族自治州','merger_name'=>'中国,甘肃省,甘南藏族自治州','level'=>'2','pinyin'=>'gannan','code'=>'0941','zip_code'=>'747000','first'=>'G','lng'=>'102.911008','lat'=>'34.986354']);
        $this->insert('{{%region}}',['id'=>'3118','pid'=>'3117','shortname'=>'合作','name'=>'合作市','merger_name'=>'中国,甘肃省,甘南藏族自治州,合作市','level'=>'3','pinyin'=>'hezuo','code'=>'0941','zip_code'=>'747000','first'=>'H','lng'=>'102.91082','lat'=>'35.00016']);
        $this->insert('{{%region}}',['id'=>'3119','pid'=>'3117','shortname'=>'临潭','name'=>'临潭县','merger_name'=>'中国,甘肃省,甘南藏族自治州,临潭县','level'=>'3','pinyin'=>'lintan','code'=>'0941','zip_code'=>'747500','first'=>'L','lng'=>'103.35287','lat'=>'34.69515']);
        $this->insert('{{%region}}',['id'=>'3120','pid'=>'3117','shortname'=>'卓尼','name'=>'卓尼县','merger_name'=>'中国,甘肃省,甘南藏族自治州,卓尼县','level'=>'3','pinyin'=>'zhuoni','code'=>'0941','zip_code'=>'747600','first'=>'Z','lng'=>'103.50811','lat'=>'34.58919']);
        $this->insert('{{%region}}',['id'=>'3121','pid'=>'3117','shortname'=>'舟曲','name'=>'舟曲县','merger_name'=>'中国,甘肃省,甘南藏族自治州,舟曲县','level'=>'3','pinyin'=>'zhouqu','code'=>'0941','zip_code'=>'746300','first'=>'Z','lng'=>'104.37155','lat'=>'33.78468']);
        $this->insert('{{%region}}',['id'=>'3122','pid'=>'3117','shortname'=>'迭部','name'=>'迭部县','merger_name'=>'中国,甘肃省,甘南藏族自治州,迭部县','level'=>'3','pinyin'=>'diebu','code'=>'0941','zip_code'=>'747400','first'=>'D','lng'=>'103.22274','lat'=>'34.05623']);
        $this->insert('{{%region}}',['id'=>'3123','pid'=>'3117','shortname'=>'玛曲','name'=>'玛曲县','merger_name'=>'中国,甘肃省,甘南藏族自治州,玛曲县','level'=>'3','pinyin'=>'maqu','code'=>'0941','zip_code'=>'747300','first'=>'M','lng'=>'102.0754','lat'=>'33.997']);
        $this->insert('{{%region}}',['id'=>'3124','pid'=>'3117','shortname'=>'碌曲','name'=>'碌曲县','merger_name'=>'中国,甘肃省,甘南藏族自治州,碌曲县','level'=>'3','pinyin'=>'luqu','code'=>'0941','zip_code'=>'747200','first'=>'L','lng'=>'102.49176','lat'=>'34.58872']);
        $this->insert('{{%region}}',['id'=>'3125','pid'=>'3117','shortname'=>'夏河','name'=>'夏河县','merger_name'=>'中国,甘肃省,甘南藏族自治州,夏河县','level'=>'3','pinyin'=>'xiahe','code'=>'0941','zip_code'=>'747100','first'=>'X','lng'=>'102.52215','lat'=>'35.20487']);
        $this->insert('{{%region}}',['id'=>'3126','pid'=>'0','shortname'=>'青海','name'=>'青海省','merger_name'=>'中国,青海省','level'=>'1','pinyin'=>'qinghai','code'=>'','zip_code'=>'','first'=>'Q','lng'=>'101.778916','lat'=>'36.623178']);
        $this->insert('{{%region}}',['id'=>'3127','pid'=>'3126','shortname'=>'西宁','name'=>'西宁市','merger_name'=>'中国,青海省,西宁市','level'=>'2','pinyin'=>'xining','code'=>'0971','zip_code'=>'810000','first'=>'X','lng'=>'101.778916','lat'=>'36.623178']);
        $this->insert('{{%region}}',['id'=>'3128','pid'=>'3127','shortname'=>'城东','name'=>'城东区','merger_name'=>'中国,青海省,西宁市,城东区','level'=>'3','pinyin'=>'chengdong','code'=>'0971','zip_code'=>'810007','first'=>'C','lng'=>'101.80373','lat'=>'36.59969']);
        $this->insert('{{%region}}',['id'=>'3129','pid'=>'3127','shortname'=>'城中','name'=>'城中区','merger_name'=>'中国,青海省,西宁市,城中区','level'=>'3','pinyin'=>'chengzhong','code'=>'0971','zip_code'=>'810000','first'=>'C','lng'=>'101.78394','lat'=>'36.62279']);
        $this->insert('{{%region}}',['id'=>'3130','pid'=>'3127','shortname'=>'城西','name'=>'城西区','merger_name'=>'中国,青海省,西宁市,城西区','level'=>'3','pinyin'=>'chengxi','code'=>'0971','zip_code'=>'810001','first'=>'C','lng'=>'101.76588','lat'=>'36.62828']);
        $this->insert('{{%region}}',['id'=>'3131','pid'=>'3127','shortname'=>'城北','name'=>'城北区','merger_name'=>'中国,青海省,西宁市,城北区','level'=>'3','pinyin'=>'chengbei','code'=>'0971','zip_code'=>'810003','first'=>'C','lng'=>'101.7662','lat'=>'36.65014']);
        $this->insert('{{%region}}',['id'=>'3132','pid'=>'3127','shortname'=>'大通','name'=>'大通回族土族自治县','merger_name'=>'中国,青海省,西宁市,大通回族土族自治县','level'=>'3','pinyin'=>'datong','code'=>'0971','zip_code'=>'810100','first'=>'D','lng'=>'101.70236','lat'=>'36.93489']);
        $this->insert('{{%region}}',['id'=>'3133','pid'=>'3127','shortname'=>'湟中','name'=>'湟中县','merger_name'=>'中国,青海省,西宁市,湟中县','level'=>'3','pinyin'=>'huangzhong','code'=>'0971','zip_code'=>'811600','first'=>NULL,'lng'=>'101.57159','lat'=>'36.50083']);
        $this->insert('{{%region}}',['id'=>'3134','pid'=>'3127','shortname'=>'湟源','name'=>'湟源县','merger_name'=>'中国,青海省,西宁市,湟源县','level'=>'3','pinyin'=>'huangyuan','code'=>'0971','zip_code'=>'812100','first'=>NULL,'lng'=>'101.25643','lat'=>'36.68243']);
        $this->insert('{{%region}}',['id'=>'3135','pid'=>'3126','shortname'=>'海东','name'=>'海东市','merger_name'=>'中国,青海省,海东市','level'=>'2','pinyin'=>'haidong','code'=>'0972','zip_code'=>'810700','first'=>'H','lng'=>'102.10327','lat'=>'36.502916']);
        $this->insert('{{%region}}',['id'=>'3136','pid'=>'3135','shortname'=>'乐都','name'=>'乐都区','merger_name'=>'中国,青海省,海东市,乐都区','level'=>'3','pinyin'=>'ledu','code'=>'0972','zip_code'=>'810700','first'=>'L','lng'=>'102.402431','lat'=>'36.480291']);
        $this->insert('{{%region}}',['id'=>'3137','pid'=>'3135','shortname'=>'平安','name'=>'平安县','merger_name'=>'中国,青海省,海东市,平安县','level'=>'3','pinyin'=>'ping\'an','code'=>'0972','zip_code'=>'810600','first'=>'P','lng'=>'102.104295','lat'=>'36.502714']);
        $this->insert('{{%region}}',['id'=>'3138','pid'=>'3135','shortname'=>'民和','name'=>'民和回族土族自治县','merger_name'=>'中国,青海省,海东市,民和回族土族自治县','level'=>'3','pinyin'=>'minhe','code'=>'0972','zip_code'=>'810800','first'=>'M','lng'=>'102.804209','lat'=>'36.329451']);
        $this->insert('{{%region}}',['id'=>'3139','pid'=>'3135','shortname'=>'互助','name'=>'互助土族自治县','merger_name'=>'中国,青海省,海东市,互助土族自治县','level'=>'3','pinyin'=>'huzhu','code'=>'0972','zip_code'=>'810500','first'=>'H','lng'=>'101.956734','lat'=>'36.83994']);
        $this->insert('{{%region}}',['id'=>'3140','pid'=>'3135','shortname'=>'化隆','name'=>'化隆回族自治县','merger_name'=>'中国,青海省,海东市,化隆回族自治县','level'=>'3','pinyin'=>'hualong','code'=>'0972','zip_code'=>'810900','first'=>'H','lng'=>'102.262329','lat'=>'36.098322']);
        $this->insert('{{%region}}',['id'=>'3141','pid'=>'3135','shortname'=>'循化','name'=>'循化撒拉族自治县','merger_name'=>'中国,青海省,海东市,循化撒拉族自治县','level'=>'3','pinyin'=>'xunhua','code'=>'0972','zip_code'=>'811100','first'=>'X','lng'=>'102.486534','lat'=>'35.847247']);
        $this->insert('{{%region}}',['id'=>'3142','pid'=>'3126','shortname'=>'海北','name'=>'海北藏族自治州','merger_name'=>'中国,青海省,海北藏族自治州','level'=>'2','pinyin'=>'haibei','code'=>'0970','zip_code'=>'812200','first'=>'H','lng'=>'100.901059','lat'=>'36.959435']);
        $this->insert('{{%region}}',['id'=>'3143','pid'=>'3142','shortname'=>'门源','name'=>'门源回族自治县','merger_name'=>'中国,青海省,海北藏族自治州,门源回族自治县','level'=>'3','pinyin'=>'menyuan','code'=>'0970','zip_code'=>'810300','first'=>'M','lng'=>'101.62228','lat'=>'37.37611']);
        $this->insert('{{%region}}',['id'=>'3144','pid'=>'3142','shortname'=>'祁连','name'=>'祁连县','merger_name'=>'中国,青海省,海北藏族自治州,祁连县','level'=>'3','pinyin'=>'qilian','code'=>'0970','zip_code'=>'810400','first'=>'Q','lng'=>'100.24618','lat'=>'38.17901']);
        $this->insert('{{%region}}',['id'=>'3145','pid'=>'3142','shortname'=>'海晏','name'=>'海晏县','merger_name'=>'中国,青海省,海北藏族自治州,海晏县','level'=>'3','pinyin'=>'haiyan','code'=>'0970','zip_code'=>'812200','first'=>'H','lng'=>'100.9927','lat'=>'36.89902']);
        $this->insert('{{%region}}',['id'=>'3146','pid'=>'3142','shortname'=>'刚察','name'=>'刚察县','merger_name'=>'中国,青海省,海北藏族自治州,刚察县','level'=>'3','pinyin'=>'gangcha','code'=>'0970','zip_code'=>'812300','first'=>'G','lng'=>'100.14675','lat'=>'37.32161']);
        $this->insert('{{%region}}',['id'=>'3147','pid'=>'3126','shortname'=>'黄南','name'=>'黄南藏族自治州','merger_name'=>'中国,青海省,黄南藏族自治州','level'=>'2','pinyin'=>'huangnan','code'=>'0973','zip_code'=>'811300','first'=>'H','lng'=>'102.019988','lat'=>'35.517744']);
        $this->insert('{{%region}}',['id'=>'3148','pid'=>'3147','shortname'=>'同仁','name'=>'同仁县','merger_name'=>'中国,青海省,黄南藏族自治州,同仁县','level'=>'3','pinyin'=>'tongren','code'=>'0973','zip_code'=>'811300','first'=>'T','lng'=>'102.0184','lat'=>'35.51603']);
        $this->insert('{{%region}}',['id'=>'3149','pid'=>'3147','shortname'=>'尖扎','name'=>'尖扎县','merger_name'=>'中国,青海省,黄南藏族自治州,尖扎县','level'=>'3','pinyin'=>'jianzha','code'=>'0973','zip_code'=>'811200','first'=>'J','lng'=>'102.03411','lat'=>'35.93947']);
        $this->insert('{{%region}}',['id'=>'3150','pid'=>'3147','shortname'=>'泽库','name'=>'泽库县','merger_name'=>'中国,青海省,黄南藏族自治州,泽库县','level'=>'3','pinyin'=>'zeku','code'=>'0973','zip_code'=>'811400','first'=>'Z','lng'=>'101.46444','lat'=>'35.03519']);
        $this->insert('{{%region}}',['id'=>'3151','pid'=>'3147','shortname'=>'河南','name'=>'河南蒙古族自治县','merger_name'=>'中国,青海省,黄南藏族自治州,河南蒙古族自治县','level'=>'3','pinyin'=>'henan','code'=>'0973','zip_code'=>'811500','first'=>'H','lng'=>'101.60864','lat'=>'34.73476']);
        $this->insert('{{%region}}',['id'=>'3152','pid'=>'3126','shortname'=>'海南','name'=>'海南藏族自治州','merger_name'=>'中国,青海省,海南藏族自治州','level'=>'2','pinyin'=>'hainan','code'=>'0974','zip_code'=>'813000','first'=>'H','lng'=>'100.619542','lat'=>'36.280353']);
        $this->insert('{{%region}}',['id'=>'3153','pid'=>'3152','shortname'=>'共和','name'=>'共和县','merger_name'=>'中国,青海省,海南藏族自治州,共和县','level'=>'3','pinyin'=>'gonghe','code'=>'0974','zip_code'=>'813000','first'=>'G','lng'=>'100.62003','lat'=>'36.2841']);
        $this->insert('{{%region}}',['id'=>'3154','pid'=>'3152','shortname'=>'同德','name'=>'同德县','merger_name'=>'中国,青海省,海南藏族自治州,同德县','level'=>'3','pinyin'=>'tongde','code'=>'0974','zip_code'=>'813200','first'=>'T','lng'=>'100.57159','lat'=>'35.25488']);
        $this->insert('{{%region}}',['id'=>'3155','pid'=>'3152','shortname'=>'贵德','name'=>'贵德县','merger_name'=>'中国,青海省,海南藏族自治州,贵德县','level'=>'3','pinyin'=>'guide','code'=>'0974','zip_code'=>'811700','first'=>'G','lng'=>'101.432','lat'=>'36.044']);
        $this->insert('{{%region}}',['id'=>'3156','pid'=>'3152','shortname'=>'兴海','name'=>'兴海县','merger_name'=>'中国,青海省,海南藏族自治州,兴海县','level'=>'3','pinyin'=>'xinghai','code'=>'0974','zip_code'=>'813300','first'=>'X','lng'=>'99.98846','lat'=>'35.59031']);
        $this->insert('{{%region}}',['id'=>'3157','pid'=>'3152','shortname'=>'贵南','name'=>'贵南县','merger_name'=>'中国,青海省,海南藏族自治州,贵南县','level'=>'3','pinyin'=>'guinan','code'=>'0974','zip_code'=>'813100','first'=>'G','lng'=>'100.74716','lat'=>'35.58667']);
        $this->insert('{{%region}}',['id'=>'3158','pid'=>'3126','shortname'=>'果洛','name'=>'果洛藏族自治州','merger_name'=>'中国,青海省,果洛藏族自治州','level'=>'2','pinyin'=>'golog','code'=>'0975','zip_code'=>'814000','first'=>'G','lng'=>'100.242143','lat'=>'34.4736']);
        $this->insert('{{%region}}',['id'=>'3159','pid'=>'3158','shortname'=>'玛沁','name'=>'玛沁县','merger_name'=>'中国,青海省,果洛藏族自治州,玛沁县','level'=>'3','pinyin'=>'maqin','code'=>'0975','zip_code'=>'814000','first'=>'M','lng'=>'100.23901','lat'=>'34.47746']);
        $this->insert('{{%region}}',['id'=>'3160','pid'=>'3158','shortname'=>'班玛','name'=>'班玛县','merger_name'=>'中国,青海省,果洛藏族自治州,班玛县','level'=>'3','pinyin'=>'banma','code'=>'0975','zip_code'=>'814300','first'=>'B','lng'=>'100.73745','lat'=>'32.93253']);
        $this->insert('{{%region}}',['id'=>'3161','pid'=>'3158','shortname'=>'甘德','name'=>'甘德县','merger_name'=>'中国,青海省,果洛藏族自治州,甘德县','level'=>'3','pinyin'=>'gande','code'=>'0975','zip_code'=>'814100','first'=>'G','lng'=>'99.90246','lat'=>'33.96838']);
        $this->insert('{{%region}}',['id'=>'3162','pid'=>'3158','shortname'=>'达日','name'=>'达日县','merger_name'=>'中国,青海省,果洛藏族自治州,达日县','level'=>'3','pinyin'=>'dari','code'=>'0975','zip_code'=>'814200','first'=>'D','lng'=>'99.65179','lat'=>'33.75193']);
        $this->insert('{{%region}}',['id'=>'3163','pid'=>'3158','shortname'=>'久治','name'=>'久治县','merger_name'=>'中国,青海省,果洛藏族自治州,久治县','level'=>'3','pinyin'=>'jiuzhi','code'=>'0975','zip_code'=>'624700','first'=>'J','lng'=>'101.48342','lat'=>'33.42989']);
        $this->insert('{{%region}}',['id'=>'3164','pid'=>'3158','shortname'=>'玛多','name'=>'玛多县','merger_name'=>'中国,青海省,果洛藏族自治州,玛多县','level'=>'3','pinyin'=>'maduo','code'=>'0975','zip_code'=>'813500','first'=>'M','lng'=>'98.20996','lat'=>'34.91567']);
        $this->insert('{{%region}}',['id'=>'3165','pid'=>'3126','shortname'=>'玉树','name'=>'玉树藏族自治州','merger_name'=>'中国,青海省,玉树藏族自治州','level'=>'2','pinyin'=>'yushu','code'=>'0976','zip_code'=>'815000','first'=>'Y','lng'=>'97.008522','lat'=>'33.004049']);
        $this->insert('{{%region}}',['id'=>'3166','pid'=>'3165','shortname'=>'玉树','name'=>'玉树市','merger_name'=>'中国,青海省,玉树藏族自治州,玉树市','level'=>'3','pinyin'=>'yushu','code'=>'0976','zip_code'=>'815000','first'=>'Y','lng'=>'97.008762','lat'=>'33.00393']);
        $this->insert('{{%region}}',['id'=>'3167','pid'=>'3165','shortname'=>'杂多','name'=>'杂多县','merger_name'=>'中国,青海省,玉树藏族自治州,杂多县','level'=>'3','pinyin'=>'zaduo','code'=>'0976','zip_code'=>'815300','first'=>'Z','lng'=>'95.29864','lat'=>'32.89318']);
        $this->insert('{{%region}}',['id'=>'3168','pid'=>'3165','shortname'=>'称多','name'=>'称多县','merger_name'=>'中国,青海省,玉树藏族自治州,称多县','level'=>'3','pinyin'=>'chenduo','code'=>'0976','zip_code'=>'815100','first'=>'C','lng'=>'97.10788','lat'=>'33.36899']);
        $this->insert('{{%region}}',['id'=>'3169','pid'=>'3165','shortname'=>'治多','name'=>'治多县','merger_name'=>'中国,青海省,玉树藏族自治州,治多县','level'=>'3','pinyin'=>'zhiduo','code'=>'0976','zip_code'=>'815400','first'=>'Z','lng'=>'95.61572','lat'=>'33.8528']);
        $this->insert('{{%region}}',['id'=>'3170','pid'=>'3165','shortname'=>'囊谦','name'=>'囊谦县','merger_name'=>'中国,青海省,玉树藏族自治州,囊谦县','level'=>'3','pinyin'=>'nangqian','code'=>'0976','zip_code'=>'815200','first'=>'N','lng'=>'96.47753','lat'=>'32.20359']);
        $this->insert('{{%region}}',['id'=>'3171','pid'=>'3165','shortname'=>'曲麻莱','name'=>'曲麻莱县','merger_name'=>'中国,青海省,玉树藏族自治州,曲麻莱县','level'=>'3','pinyin'=>'qumalai','code'=>'0976','zip_code'=>'815500','first'=>'Q','lng'=>'95.79757','lat'=>'34.12609']);
        $this->insert('{{%region}}',['id'=>'3172','pid'=>'3126','shortname'=>'海西','name'=>'海西蒙古族藏族自治州','merger_name'=>'中国,青海省,海西蒙古族藏族自治州','level'=>'2','pinyin'=>'haixi','code'=>'0977','zip_code'=>'817000','first'=>'H','lng'=>'97.370785','lat'=>'37.374663']);
        $this->insert('{{%region}}',['id'=>'3173','pid'=>'3172','shortname'=>'格尔木','name'=>'格尔木市','merger_name'=>'中国,青海省,海西蒙古族藏族自治州,格尔木市','level'=>'3','pinyin'=>'geermu','code'=>'0977','zip_code'=>'816000','first'=>'G','lng'=>'94.90329','lat'=>'36.40236']);
        $this->insert('{{%region}}',['id'=>'3174','pid'=>'3172','shortname'=>'德令哈','name'=>'德令哈市','merger_name'=>'中国,青海省,海西蒙古族藏族自治州,德令哈市','level'=>'3','pinyin'=>'delingha','code'=>'0977','zip_code'=>'817000','first'=>'D','lng'=>'97.36084','lat'=>'37.36946']);
        $this->insert('{{%region}}',['id'=>'3175','pid'=>'3172','shortname'=>'乌兰','name'=>'乌兰县','merger_name'=>'中国,青海省,海西蒙古族藏族自治州,乌兰县','level'=>'3','pinyin'=>'wulan','code'=>'0977','zip_code'=>'817100','first'=>'W','lng'=>'98.48196','lat'=>'36.93471']);
        $this->insert('{{%region}}',['id'=>'3176','pid'=>'3172','shortname'=>'都兰','name'=>'都兰县','merger_name'=>'中国,青海省,海西蒙古族藏族自治州,都兰县','level'=>'3','pinyin'=>'dulan','code'=>'0977','zip_code'=>'816100','first'=>'D','lng'=>'98.09228','lat'=>'36.30135']);
        $this->insert('{{%region}}',['id'=>'3177','pid'=>'3172','shortname'=>'天峻','name'=>'天峻县','merger_name'=>'中国,青海省,海西蒙古族藏族自治州,天峻县','level'=>'3','pinyin'=>'tianjun','code'=>'0977','zip_code'=>'817200','first'=>'T','lng'=>'99.02453','lat'=>'37.30326']);
        $this->insert('{{%region}}',['id'=>'3178','pid'=>'0','shortname'=>'宁夏','name'=>'宁夏回族自治区','merger_name'=>'中国,宁夏回族自治区','level'=>'1','pinyin'=>'ningxia','code'=>'','zip_code'=>'','first'=>'N','lng'=>'106.278179','lat'=>'38.46637']);
        $this->insert('{{%region}}',['id'=>'3179','pid'=>'3178','shortname'=>'银川','name'=>'银川市','merger_name'=>'中国,宁夏回族自治区,银川市','level'=>'2','pinyin'=>'yinchuan','code'=>'0951','zip_code'=>'750004','first'=>'Y','lng'=>'106.278179','lat'=>'38.46637']);
        $this->insert('{{%region}}',['id'=>'3180','pid'=>'3179','shortname'=>'兴庆','name'=>'兴庆区','merger_name'=>'中国,宁夏回族自治区,银川市,兴庆区','level'=>'3','pinyin'=>'xingqing','code'=>'0951','zip_code'=>'750001','first'=>'X','lng'=>'106.28872','lat'=>'38.47392']);
        $this->insert('{{%region}}',['id'=>'3181','pid'=>'3179','shortname'=>'西夏','name'=>'西夏区','merger_name'=>'中国,宁夏回族自治区,银川市,西夏区','level'=>'3','pinyin'=>'xixia','code'=>'0951','zip_code'=>'750021','first'=>'X','lng'=>'106.15023','lat'=>'38.49137']);
        $this->insert('{{%region}}',['id'=>'3182','pid'=>'3179','shortname'=>'金凤','name'=>'金凤区','merger_name'=>'中国,宁夏回族自治区,银川市,金凤区','level'=>'3','pinyin'=>'jinfeng','code'=>'0951','zip_code'=>'750011','first'=>'J','lng'=>'106.24261','lat'=>'38.47294']);
        $this->insert('{{%region}}',['id'=>'3183','pid'=>'3179','shortname'=>'永宁','name'=>'永宁县','merger_name'=>'中国,宁夏回族自治区,银川市,永宁县','level'=>'3','pinyin'=>'yongning','code'=>'0951','zip_code'=>'750100','first'=>'Y','lng'=>'106.2517','lat'=>'38.27559']);
        $this->insert('{{%region}}',['id'=>'3184','pid'=>'3179','shortname'=>'贺兰','name'=>'贺兰县','merger_name'=>'中国,宁夏回族自治区,银川市,贺兰县','level'=>'3','pinyin'=>'helan','code'=>'0951','zip_code'=>'750200','first'=>'H','lng'=>'106.34982','lat'=>'38.5544']);
        $this->insert('{{%region}}',['id'=>'3185','pid'=>'3179','shortname'=>'灵武','name'=>'灵武市','merger_name'=>'中国,宁夏回族自治区,银川市,灵武市','level'=>'3','pinyin'=>'lingwu','code'=>'0951','zip_code'=>'750004','first'=>'L','lng'=>'106.33999','lat'=>'38.10266']);
        $this->insert('{{%region}}',['id'=>'3186','pid'=>'3178','shortname'=>'石嘴山','name'=>'石嘴山市','merger_name'=>'中国,宁夏回族自治区,石嘴山市','level'=>'2','pinyin'=>'shizuishan','code'=>'0952','zip_code'=>'753000','first'=>'S','lng'=>'106.376173','lat'=>'39.01333']);
        $this->insert('{{%region}}',['id'=>'3187','pid'=>'3186','shortname'=>'大武口','name'=>'大武口区','merger_name'=>'中国,宁夏回族自治区,石嘴山市,大武口区','level'=>'3','pinyin'=>'dawukou','code'=>'0952','zip_code'=>'753000','first'=>'D','lng'=>'106.37717','lat'=>'39.01226']);
        $this->insert('{{%region}}',['id'=>'3188','pid'=>'3186','shortname'=>'惠农','name'=>'惠农区','merger_name'=>'中国,宁夏回族自治区,石嘴山市,惠农区','level'=>'3','pinyin'=>'huinong','code'=>'0952','zip_code'=>'753600','first'=>'H','lng'=>'106.71145','lat'=>'39.13193']);
        $this->insert('{{%region}}',['id'=>'3189','pid'=>'3186','shortname'=>'平罗','name'=>'平罗县','merger_name'=>'中国,宁夏回族自治区,石嘴山市,平罗县','level'=>'3','pinyin'=>'pingluo','code'=>'0952','zip_code'=>'753400','first'=>'P','lng'=>'106.54538','lat'=>'38.90429']);
        $this->insert('{{%region}}',['id'=>'3190','pid'=>'3178','shortname'=>'吴忠','name'=>'吴忠市','merger_name'=>'中国,宁夏回族自治区,吴忠市','level'=>'2','pinyin'=>'wuzhong','code'=>'0953','zip_code'=>'751100','first'=>'W','lng'=>'106.199409','lat'=>'37.986165']);
        $this->insert('{{%region}}',['id'=>'3191','pid'=>'3190','shortname'=>'利通','name'=>'利通区','merger_name'=>'中国,宁夏回族自治区,吴忠市,利通区','level'=>'3','pinyin'=>'litong','code'=>'0953','zip_code'=>'751100','first'=>'L','lng'=>'106.20311','lat'=>'37.98512']);
        $this->insert('{{%region}}',['id'=>'3192','pid'=>'3190','shortname'=>'红寺堡','name'=>'红寺堡区','merger_name'=>'中国,宁夏回族自治区,吴忠市,红寺堡区','level'=>'3','pinyin'=>'hongsibao','code'=>'0953','zip_code'=>'751900','first'=>'H','lng'=>'106.19822','lat'=>'37.99747']);
        $this->insert('{{%region}}',['id'=>'3193','pid'=>'3190','shortname'=>'盐池','name'=>'盐池县','merger_name'=>'中国,宁夏回族自治区,吴忠市,盐池县','level'=>'3','pinyin'=>'yanchi','code'=>'0953','zip_code'=>'751500','first'=>'Y','lng'=>'107.40707','lat'=>'37.7833']);
        $this->insert('{{%region}}',['id'=>'3194','pid'=>'3190','shortname'=>'同心','name'=>'同心县','merger_name'=>'中国,宁夏回族自治区,吴忠市,同心县','level'=>'3','pinyin'=>'tongxin','code'=>'0953','zip_code'=>'751300','first'=>'T','lng'=>'105.91418','lat'=>'36.98116']);
        $this->insert('{{%region}}',['id'=>'3195','pid'=>'3190','shortname'=>'青铜峡','name'=>'青铜峡市','merger_name'=>'中国,宁夏回族自治区,吴忠市,青铜峡市','level'=>'3','pinyin'=>'qingtongxia','code'=>'0953','zip_code'=>'751600','first'=>'Q','lng'=>'106.07489','lat'=>'38.02004']);
        $this->insert('{{%region}}',['id'=>'3196','pid'=>'3178','shortname'=>'固原','name'=>'固原市','merger_name'=>'中国,宁夏回族自治区,固原市','level'=>'2','pinyin'=>'guyuan','code'=>'0954','zip_code'=>'756000','first'=>'G','lng'=>'106.285241','lat'=>'36.004561']);
        $this->insert('{{%region}}',['id'=>'3197','pid'=>'3196','shortname'=>'原州','name'=>'原州区','merger_name'=>'中国,宁夏回族自治区,固原市,原州区','level'=>'3','pinyin'=>'yuanzhou','code'=>'0954','zip_code'=>'756000','first'=>'Y','lng'=>'106.28778','lat'=>'36.00374']);
        $this->insert('{{%region}}',['id'=>'3198','pid'=>'3196','shortname'=>'西吉','name'=>'西吉县','merger_name'=>'中国,宁夏回族自治区,固原市,西吉县','level'=>'3','pinyin'=>'xiji','code'=>'0954','zip_code'=>'756200','first'=>'X','lng'=>'105.73107','lat'=>'35.96616']);
        $this->insert('{{%region}}',['id'=>'3199','pid'=>'3196','shortname'=>'隆德','name'=>'隆德县','merger_name'=>'中国,宁夏回族自治区,固原市,隆德县','level'=>'3','pinyin'=>'longde','code'=>'0954','zip_code'=>'756300','first'=>'L','lng'=>'106.12426','lat'=>'35.61718']);
        $this->insert('{{%region}}',['id'=>'3200','pid'=>'3196','shortname'=>'泾源','name'=>'泾源县','merger_name'=>'中国,宁夏回族自治区,固原市,泾源县','level'=>'3','pinyin'=>'jingyuan','code'=>'0954','zip_code'=>'756400','first'=>NULL,'lng'=>'106.33902','lat'=>'35.49072']);
        $this->insert('{{%region}}',['id'=>'3201','pid'=>'3196','shortname'=>'彭阳','name'=>'彭阳县','merger_name'=>'中国,宁夏回族自治区,固原市,彭阳县','level'=>'3','pinyin'=>'pengyang','code'=>'0954','zip_code'=>'756500','first'=>'P','lng'=>'106.64462','lat'=>'35.85076']);
        $this->insert('{{%region}}',['id'=>'3202','pid'=>'3178','shortname'=>'中卫','name'=>'中卫市','merger_name'=>'中国,宁夏回族自治区,中卫市','level'=>'2','pinyin'=>'zhongwei','code'=>'0955','zip_code'=>'751700','first'=>'Z','lng'=>'105.189568','lat'=>'37.514951']);
        $this->insert('{{%region}}',['id'=>'3203','pid'=>'3202','shortname'=>'沙坡头','name'=>'沙坡头区','merger_name'=>'中国,宁夏回族自治区,中卫市,沙坡头区','level'=>'3','pinyin'=>'shapotou','code'=>'0955','zip_code'=>'755000','first'=>'S','lng'=>'105.18962','lat'=>'37.51044']);
        $this->insert('{{%region}}',['id'=>'3204','pid'=>'3202','shortname'=>'中宁','name'=>'中宁县','merger_name'=>'中国,宁夏回族自治区,中卫市,中宁县','level'=>'3','pinyin'=>'zhongning','code'=>'0955','zip_code'=>'751200','first'=>'Z','lng'=>'105.68515','lat'=>'37.49149']);
        $this->insert('{{%region}}',['id'=>'3205','pid'=>'3202','shortname'=>'海原','name'=>'海原县','merger_name'=>'中国,宁夏回族自治区,中卫市,海原县','level'=>'3','pinyin'=>'haiyuan','code'=>'0955','zip_code'=>'751800','first'=>'H','lng'=>'105.64712','lat'=>'36.56498']);
        $this->insert('{{%region}}',['id'=>'3206','pid'=>'0','shortname'=>'新疆','name'=>'新疆维吾尔自治区','merger_name'=>'中国,新疆维吾尔自治区','level'=>'1','pinyin'=>'xinjiang','code'=>'','zip_code'=>'','first'=>'X','lng'=>'87.617733','lat'=>'43.792818']);
        $this->insert('{{%region}}',['id'=>'3207','pid'=>'3206','shortname'=>'乌鲁木齐','name'=>'乌鲁木齐市','merger_name'=>'中国,新疆维吾尔自治区,乌鲁木齐市','level'=>'2','pinyin'=>'urumqi','code'=>'0991','zip_code'=>'830002','first'=>'W','lng'=>'87.617733','lat'=>'43.792818']);
        $this->insert('{{%region}}',['id'=>'3208','pid'=>'3207','shortname'=>'天山','name'=>'天山区','merger_name'=>'中国,新疆维吾尔自治区,乌鲁木齐市,天山区','level'=>'3','pinyin'=>'tianshan','code'=>'0991','zip_code'=>'830002','first'=>'T','lng'=>'87.63167','lat'=>'43.79439']);
        $this->insert('{{%region}}',['id'=>'3209','pid'=>'3207','shortname'=>'沙依巴克','name'=>'沙依巴克区','merger_name'=>'中国,新疆维吾尔自治区,乌鲁木齐市,沙依巴克区','level'=>'3','pinyin'=>'shayibake','code'=>'0991','zip_code'=>'830000','first'=>'S','lng'=>'87.59788','lat'=>'43.80118']);
        $this->insert('{{%region}}',['id'=>'3210','pid'=>'3207','shortname'=>'新市','name'=>'新市区','merger_name'=>'中国,新疆维吾尔自治区,乌鲁木齐市,新市区','level'=>'3','pinyin'=>'xinshi','code'=>'0991','zip_code'=>'830011','first'=>'X','lng'=>'87.57406','lat'=>'43.84348']);
        $this->insert('{{%region}}',['id'=>'3211','pid'=>'3207','shortname'=>'水磨沟','name'=>'水磨沟区','merger_name'=>'中国,新疆维吾尔自治区,乌鲁木齐市,水磨沟区','level'=>'3','pinyin'=>'shuimogou','code'=>'0991','zip_code'=>'830017','first'=>'S','lng'=>'87.64249','lat'=>'43.83247']);
        $this->insert('{{%region}}',['id'=>'3212','pid'=>'3207','shortname'=>'头屯河','name'=>'头屯河区','merger_name'=>'中国,新疆维吾尔自治区,乌鲁木齐市,头屯河区','level'=>'3','pinyin'=>'toutunhe','code'=>'0991','zip_code'=>'830022','first'=>'T','lng'=>'87.29138','lat'=>'43.85487']);
        $this->insert('{{%region}}',['id'=>'3213','pid'=>'3207','shortname'=>'达坂城','name'=>'达坂城区','merger_name'=>'中国,新疆维吾尔自治区,乌鲁木齐市,达坂城区','level'=>'3','pinyin'=>'dabancheng','code'=>'0991','zip_code'=>'830039','first'=>'D','lng'=>'88.30697','lat'=>'43.35797']);
        $this->insert('{{%region}}',['id'=>'3214','pid'=>'3207','shortname'=>'米东','name'=>'米东区','merger_name'=>'中国,新疆维吾尔自治区,乌鲁木齐市,米东区','level'=>'3','pinyin'=>'midong','code'=>'0991','zip_code'=>'830019','first'=>'M','lng'=>'87.68583','lat'=>'43.94739']);
        $this->insert('{{%region}}',['id'=>'3215','pid'=>'3207','shortname'=>'乌鲁木齐','name'=>'乌鲁木齐县','merger_name'=>'中国,新疆维吾尔自治区,乌鲁木齐市,乌鲁木齐县','level'=>'3','pinyin'=>'wulumuqi','code'=>'0991','zip_code'=>'830063','first'=>'W','lng'=>'87.40939','lat'=>'43.47125']);
        $this->insert('{{%region}}',['id'=>'3216','pid'=>'3206','shortname'=>'克拉玛依','name'=>'克拉玛依市','merger_name'=>'中国,新疆维吾尔自治区,克拉玛依市','level'=>'2','pinyin'=>'karamay','code'=>'0990','zip_code'=>'834000','first'=>'K','lng'=>'84.873946','lat'=>'45.595886']);
        $this->insert('{{%region}}',['id'=>'3217','pid'=>'3216','shortname'=>'独山子','name'=>'独山子区','merger_name'=>'中国,新疆维吾尔自治区,克拉玛依市,独山子区','level'=>'3','pinyin'=>'dushanzi','code'=>'0992','zip_code'=>'834021','first'=>'D','lng'=>'84.88671','lat'=>'44.32867']);
        $this->insert('{{%region}}',['id'=>'3218','pid'=>'3216','shortname'=>'克拉玛依','name'=>'克拉玛依区','merger_name'=>'中国,新疆维吾尔自治区,克拉玛依市,克拉玛依区','level'=>'3','pinyin'=>'kelamayi','code'=>'0990','zip_code'=>'834000','first'=>'K','lng'=>'84.86225','lat'=>'45.59089']);
        $this->insert('{{%region}}',['id'=>'3219','pid'=>'3216','shortname'=>'白碱滩','name'=>'白碱滩区','merger_name'=>'中国,新疆维吾尔自治区,克拉玛依市,白碱滩区','level'=>'3','pinyin'=>'baijiantan','code'=>'0990','zip_code'=>'834008','first'=>'B','lng'=>'85.13244','lat'=>'45.68768']);
        $this->insert('{{%region}}',['id'=>'3220','pid'=>'3216','shortname'=>'乌尔禾','name'=>'乌尔禾区','merger_name'=>'中国,新疆维吾尔自治区,克拉玛依市,乌尔禾区','level'=>'3','pinyin'=>'wuerhe','code'=>'0990','zip_code'=>'834012','first'=>'W','lng'=>'85.69143','lat'=>'46.09006']);
        $this->insert('{{%region}}',['id'=>'3221','pid'=>'3206','shortname'=>'吐鲁番','name'=>'吐鲁番地区','merger_name'=>'中国,新疆维吾尔自治区,吐鲁番地区','level'=>'2','pinyin'=>'turpan','code'=>'0995','zip_code'=>'838000','first'=>'T','lng'=>'89.184078','lat'=>'42.947613']);
        $this->insert('{{%region}}',['id'=>'3222','pid'=>'3221','shortname'=>'吐鲁番','name'=>'吐鲁番市','merger_name'=>'中国,新疆维吾尔自治区,吐鲁番地区,吐鲁番市','level'=>'3','pinyin'=>'tulufan','code'=>'0995','zip_code'=>'838000','first'=>'T','lng'=>'89.18579','lat'=>'42.93505']);
        $this->insert('{{%region}}',['id'=>'3223','pid'=>'3221','shortname'=>'鄯善','name'=>'鄯善县','merger_name'=>'中国,新疆维吾尔自治区,吐鲁番地区,鄯善县','level'=>'3','pinyin'=>'shanshan','code'=>'0995','zip_code'=>'838200','first'=>NULL,'lng'=>'90.21402','lat'=>'42.8635']);
        $this->insert('{{%region}}',['id'=>'3224','pid'=>'3221','shortname'=>'托克逊','name'=>'托克逊县','merger_name'=>'中国,新疆维吾尔自治区,吐鲁番地区,托克逊县','level'=>'3','pinyin'=>'tuokexun','code'=>'0995','zip_code'=>'838100','first'=>'T','lng'=>'88.65823','lat'=>'42.79231']);
        $this->insert('{{%region}}',['id'=>'3225','pid'=>'3206','shortname'=>'哈密','name'=>'哈密地区','merger_name'=>'中国,新疆维吾尔自治区,哈密地区','level'=>'2','pinyin'=>'hami','code'=>'0902','zip_code'=>'839000','first'=>'H','lng'=>'93.51316','lat'=>'42.833248']);
        $this->insert('{{%region}}',['id'=>'3226','pid'=>'3225','shortname'=>'哈密','name'=>'哈密市','merger_name'=>'中国,新疆维吾尔自治区,哈密地区,哈密市','level'=>'3','pinyin'=>'hami','code'=>'0902','zip_code'=>'839000','first'=>'H','lng'=>'93.51452','lat'=>'42.82699']);
        $this->insert('{{%region}}',['id'=>'3227','pid'=>'3225','shortname'=>'巴里坤','name'=>'巴里坤哈萨克自治县','merger_name'=>'中国,新疆维吾尔自治区,哈密地区,巴里坤哈萨克自治县','level'=>'3','pinyin'=>'balikun','code'=>'0902','zip_code'=>'839200','first'=>'B','lng'=>'93.01236','lat'=>'43.59993']);
        $this->insert('{{%region}}',['id'=>'3228','pid'=>'3225','shortname'=>'伊吾','name'=>'伊吾县','merger_name'=>'中国,新疆维吾尔自治区,哈密地区,伊吾县','level'=>'3','pinyin'=>'yiwu','code'=>'0902','zip_code'=>'839300','first'=>'Y','lng'=>'94.69403','lat'=>'43.2537']);
        $this->insert('{{%region}}',['id'=>'3229','pid'=>'3206','shortname'=>'昌吉','name'=>'昌吉回族自治州','merger_name'=>'中国,新疆维吾尔自治区,昌吉回族自治州','level'=>'2','pinyin'=>'changji','code'=>'0994','zip_code'=>'831100','first'=>'C','lng'=>'87.304012','lat'=>'44.014577']);
        $this->insert('{{%region}}',['id'=>'3230','pid'=>'3229','shortname'=>'昌吉','name'=>'昌吉市','merger_name'=>'中国,新疆维吾尔自治区,昌吉回族自治州,昌吉市','level'=>'3','pinyin'=>'changji','code'=>'0994','zip_code'=>'831100','first'=>'C','lng'=>'87.30249','lat'=>'44.01267']);
        $this->insert('{{%region}}',['id'=>'3231','pid'=>'3229','shortname'=>'阜康','name'=>'阜康市','merger_name'=>'中国,新疆维吾尔自治区,昌吉回族自治州,阜康市','level'=>'3','pinyin'=>'fukang','code'=>'0994','zip_code'=>'831500','first'=>'F','lng'=>'87.98529','lat'=>'44.1584']);
        $this->insert('{{%region}}',['id'=>'3232','pid'=>'3229','shortname'=>'呼图壁','name'=>'呼图壁县','merger_name'=>'中国,新疆维吾尔自治区,昌吉回族自治州,呼图壁县','level'=>'3','pinyin'=>'hutubi','code'=>'0994','zip_code'=>'831200','first'=>'H','lng'=>'86.89892','lat'=>'44.18977']);
        $this->insert('{{%region}}',['id'=>'3233','pid'=>'3229','shortname'=>'玛纳斯','name'=>'玛纳斯县','merger_name'=>'中国,新疆维吾尔自治区,昌吉回族自治州,玛纳斯县','level'=>'3','pinyin'=>'manasi','code'=>'0994','zip_code'=>'832200','first'=>'M','lng'=>'86.2145','lat'=>'44.30438']);
        $this->insert('{{%region}}',['id'=>'3234','pid'=>'3229','shortname'=>'奇台','name'=>'奇台县','merger_name'=>'中国,新疆维吾尔自治区,昌吉回族自治州,奇台县','level'=>'3','pinyin'=>'qitai','code'=>'0994','zip_code'=>'831800','first'=>'Q','lng'=>'89.5932','lat'=>'44.02221']);
        $this->insert('{{%region}}',['id'=>'3235','pid'=>'3229','shortname'=>'吉木萨尔','name'=>'吉木萨尔县','merger_name'=>'中国,新疆维吾尔自治区,昌吉回族自治州,吉木萨尔县','level'=>'3','pinyin'=>'jimusaer','code'=>'0994','zip_code'=>'831700','first'=>'J','lng'=>'89.18078','lat'=>'44.00048']);
        $this->insert('{{%region}}',['id'=>'3236','pid'=>'3229','shortname'=>'木垒','name'=>'木垒哈萨克自治县','merger_name'=>'中国,新疆维吾尔自治区,昌吉回族自治州,木垒哈萨克自治县','level'=>'3','pinyin'=>'mulei','code'=>'0994','zip_code'=>'831900','first'=>'M','lng'=>'90.28897','lat'=>'43.83508']);
        $this->insert('{{%region}}',['id'=>'3237','pid'=>'3206','shortname'=>'博尔塔拉','name'=>'博尔塔拉蒙古自治州','merger_name'=>'中国,新疆维吾尔自治区,博尔塔拉蒙古自治州','level'=>'2','pinyin'=>'bortala','code'=>'0909','zip_code'=>'833400','first'=>'B','lng'=>'82.074778','lat'=>'44.903258']);
        $this->insert('{{%region}}',['id'=>'3238','pid'=>'3237','shortname'=>'博乐','name'=>'博乐市','merger_name'=>'中国,新疆维吾尔自治区,博尔塔拉蒙古自治州,博乐市','level'=>'3','pinyin'=>'bole','code'=>'0909','zip_code'=>'833400','first'=>'B','lng'=>'82.0713','lat'=>'44.90052']);
        $this->insert('{{%region}}',['id'=>'3239','pid'=>'3237','shortname'=>'阿拉山口','name'=>'阿拉山口市','merger_name'=>'中国,新疆维吾尔自治区,博尔塔拉蒙古自治州,阿拉山口市','level'=>'3','pinyin'=>'alashankou','code'=>'0909','zip_code'=>'833400','first'=>'A','lng'=>'82.567721','lat'=>'45.170616']);
        $this->insert('{{%region}}',['id'=>'3240','pid'=>'3237','shortname'=>'精河','name'=>'精河县','merger_name'=>'中国,新疆维吾尔自治区,博尔塔拉蒙古自治州,精河县','level'=>'3','pinyin'=>'jinghe','code'=>'0909','zip_code'=>'833300','first'=>'J','lng'=>'82.89419','lat'=>'44.60774']);
        $this->insert('{{%region}}',['id'=>'3241','pid'=>'3237','shortname'=>'温泉','name'=>'温泉县','merger_name'=>'中国,新疆维吾尔自治区,博尔塔拉蒙古自治州,温泉县','level'=>'3','pinyin'=>'wenquan','code'=>'0909','zip_code'=>'833500','first'=>'W','lng'=>'81.03134','lat'=>'44.97373']);
        $this->insert('{{%region}}',['id'=>'3242','pid'=>'3206','shortname'=>'巴音郭楞','name'=>'巴音郭楞蒙古自治州','merger_name'=>'中国,新疆维吾尔自治区,巴音郭楞蒙古自治州','level'=>'2','pinyin'=>'bayingol','code'=>'0996','zip_code'=>'841000','first'=>'B','lng'=>'86.150969','lat'=>'41.768552']);
        $this->insert('{{%region}}',['id'=>'3243','pid'=>'3242','shortname'=>'库尔勒','name'=>'库尔勒市','merger_name'=>'中国,新疆维吾尔自治区,巴音郭楞蒙古自治州,库尔勒市','level'=>'3','pinyin'=>'kuerle','code'=>'0996','zip_code'=>'841000','first'=>'K','lng'=>'86.15528','lat'=>'41.76602']);
        $this->insert('{{%region}}',['id'=>'3244','pid'=>'3242','shortname'=>'轮台','name'=>'轮台县','merger_name'=>'中国,新疆维吾尔自治区,巴音郭楞蒙古自治州,轮台县','level'=>'3','pinyin'=>'luntai','code'=>'0996','zip_code'=>'841600','first'=>'L','lng'=>'84.26101','lat'=>'41.77642']);
        $this->insert('{{%region}}',['id'=>'3245','pid'=>'3242','shortname'=>'尉犁','name'=>'尉犁县','merger_name'=>'中国,新疆维吾尔自治区,巴音郭楞蒙古自治州,尉犁县','level'=>'3','pinyin'=>'yuli','code'=>'0996','zip_code'=>'841500','first'=>'W','lng'=>'86.25903','lat'=>'41.33632']);
        $this->insert('{{%region}}',['id'=>'3246','pid'=>'3242','shortname'=>'若羌','name'=>'若羌县','merger_name'=>'中国,新疆维吾尔自治区,巴音郭楞蒙古自治州,若羌县','level'=>'3','pinyin'=>'ruoqiang','code'=>'0996','zip_code'=>'841800','first'=>'R','lng'=>'88.16812','lat'=>'39.0179']);
        $this->insert('{{%region}}',['id'=>'3247','pid'=>'3242','shortname'=>'且末','name'=>'且末县','merger_name'=>'中国,新疆维吾尔自治区,巴音郭楞蒙古自治州,且末县','level'=>'3','pinyin'=>'qiemo','code'=>'0996','zip_code'=>'841900','first'=>'Q','lng'=>'85.52975','lat'=>'38.14534']);
        $this->insert('{{%region}}',['id'=>'3248','pid'=>'3242','shortname'=>'焉耆','name'=>'焉耆回族自治县','merger_name'=>'中国,新疆维吾尔自治区,巴音郭楞蒙古自治州,焉耆回族自治县','level'=>'3','pinyin'=>'yanqi','code'=>'0996','zip_code'=>'841100','first'=>'Y','lng'=>'86.5744','lat'=>'42.059']);
        $this->insert('{{%region}}',['id'=>'3249','pid'=>'3242','shortname'=>'和静','name'=>'和静县','merger_name'=>'中国,新疆维吾尔自治区,巴音郭楞蒙古自治州,和静县','level'=>'3','pinyin'=>'hejing','code'=>'0996','zip_code'=>'841300','first'=>'H','lng'=>'86.39611','lat'=>'42.31838']);
        $this->insert('{{%region}}',['id'=>'3250','pid'=>'3242','shortname'=>'和硕','name'=>'和硕县','merger_name'=>'中国,新疆维吾尔自治区,巴音郭楞蒙古自治州,和硕县','level'=>'3','pinyin'=>'heshuo','code'=>'0996','zip_code'=>'841200','first'=>'H','lng'=>'86.86392','lat'=>'42.26814']);
        $this->insert('{{%region}}',['id'=>'3251','pid'=>'3242','shortname'=>'博湖','name'=>'博湖县','merger_name'=>'中国,新疆维吾尔自治区,巴音郭楞蒙古自治州,博湖县','level'=>'3','pinyin'=>'bohu','code'=>'0996','zip_code'=>'841400','first'=>'B','lng'=>'86.63333','lat'=>'41.98014']);
        $this->insert('{{%region}}',['id'=>'3252','pid'=>'3206','shortname'=>'阿克苏','name'=>'阿克苏地区','merger_name'=>'中国,新疆维吾尔自治区,阿克苏地区','level'=>'2','pinyin'=>'aksu','code'=>'0997','zip_code'=>'843000','first'=>'A','lng'=>'80.265068','lat'=>'41.170712']);
        $this->insert('{{%region}}',['id'=>'3253','pid'=>'3252','shortname'=>'阿克苏','name'=>'阿克苏市','merger_name'=>'中国,新疆维吾尔自治区,阿克苏地区,阿克苏市','level'=>'3','pinyin'=>'akesu','code'=>'0997','zip_code'=>'843000','first'=>'A','lng'=>'80.26338','lat'=>'41.16754']);
        $this->insert('{{%region}}',['id'=>'3254','pid'=>'3252','shortname'=>'温宿','name'=>'温宿县','merger_name'=>'中国,新疆维吾尔自治区,阿克苏地区,温宿县','level'=>'3','pinyin'=>'wensu','code'=>'0997','zip_code'=>'843100','first'=>'W','lng'=>'80.24173','lat'=>'41.27679']);
        $this->insert('{{%region}}',['id'=>'3255','pid'=>'3252','shortname'=>'库车','name'=>'库车县','merger_name'=>'中国,新疆维吾尔自治区,阿克苏地区,库车县','level'=>'3','pinyin'=>'kuche','code'=>'0997','zip_code'=>'842000','first'=>'K','lng'=>'82.96209','lat'=>'41.71793']);
        $this->insert('{{%region}}',['id'=>'3256','pid'=>'3252','shortname'=>'沙雅','name'=>'沙雅县','merger_name'=>'中国,新疆维吾尔自治区,阿克苏地区,沙雅县','level'=>'3','pinyin'=>'shaya','code'=>'0997','zip_code'=>'842200','first'=>'S','lng'=>'82.78131','lat'=>'41.22497']);
        $this->insert('{{%region}}',['id'=>'3257','pid'=>'3252','shortname'=>'新和','name'=>'新和县','merger_name'=>'中国,新疆维吾尔自治区,阿克苏地区,新和县','level'=>'3','pinyin'=>'xinhe','code'=>'0997','zip_code'=>'842100','first'=>'X','lng'=>'82.61053','lat'=>'41.54964']);
        $this->insert('{{%region}}',['id'=>'3258','pid'=>'3252','shortname'=>'拜城','name'=>'拜城县','merger_name'=>'中国,新疆维吾尔自治区,阿克苏地区,拜城县','level'=>'3','pinyin'=>'baicheng','code'=>'0997','zip_code'=>'842300','first'=>'B','lng'=>'81.87564','lat'=>'41.79801']);
        $this->insert('{{%region}}',['id'=>'3259','pid'=>'3252','shortname'=>'乌什','name'=>'乌什县','merger_name'=>'中国,新疆维吾尔自治区,阿克苏地区,乌什县','level'=>'3','pinyin'=>'wushi','code'=>'0997','zip_code'=>'843400','first'=>'W','lng'=>'79.22937','lat'=>'41.21569']);
        $this->insert('{{%region}}',['id'=>'3260','pid'=>'3252','shortname'=>'阿瓦提','name'=>'阿瓦提县','merger_name'=>'中国,新疆维吾尔自治区,阿克苏地区,阿瓦提县','level'=>'3','pinyin'=>'awati','code'=>'0997','zip_code'=>'843200','first'=>'A','lng'=>'80.38336','lat'=>'40.63926']);
        $this->insert('{{%region}}',['id'=>'3261','pid'=>'3252','shortname'=>'柯坪','name'=>'柯坪县','merger_name'=>'中国,新疆维吾尔自治区,阿克苏地区,柯坪县','level'=>'3','pinyin'=>'keping','code'=>'0997','zip_code'=>'843600','first'=>'K','lng'=>'79.04751','lat'=>'40.50585']);
        $this->insert('{{%region}}',['id'=>'3262','pid'=>'3206','shortname'=>'克孜勒苏','name'=>'克孜勒苏柯尔克孜自治州','merger_name'=>'中国,新疆维吾尔自治区,克孜勒苏柯尔克孜自治州','level'=>'2','pinyin'=>'kizilsu','code'=>'0908','zip_code'=>'845350','first'=>'K','lng'=>'76.172825','lat'=>'39.713431']);
        $this->insert('{{%region}}',['id'=>'3263','pid'=>'3262','shortname'=>'阿图什','name'=>'阿图什市','merger_name'=>'中国,新疆维吾尔自治区,克孜勒苏柯尔克孜自治州,阿图什市','level'=>'3','pinyin'=>'atushi','code'=>'0908','zip_code'=>'845350','first'=>'A','lng'=>'76.16827','lat'=>'39.71615']);
        $this->insert('{{%region}}',['id'=>'3264','pid'=>'3262','shortname'=>'阿克陶','name'=>'阿克陶县','merger_name'=>'中国,新疆维吾尔自治区,克孜勒苏柯尔克孜自治州,阿克陶县','level'=>'3','pinyin'=>'aketao','code'=>'0908','zip_code'=>'845550','first'=>'A','lng'=>'75.94692','lat'=>'39.14892']);
        $this->insert('{{%region}}',['id'=>'3265','pid'=>'3262','shortname'=>'阿合奇','name'=>'阿合奇县','merger_name'=>'中国,新疆维吾尔自治区,克孜勒苏柯尔克孜自治州,阿合奇县','level'=>'3','pinyin'=>'aheqi','code'=>'0997','zip_code'=>'843500','first'=>'A','lng'=>'78.44848','lat'=>'40.93947']);
        $this->insert('{{%region}}',['id'=>'3266','pid'=>'3262','shortname'=>'乌恰','name'=>'乌恰县','merger_name'=>'中国,新疆维吾尔自治区,克孜勒苏柯尔克孜自治州,乌恰县','level'=>'3','pinyin'=>'wuqia','code'=>'0908','zip_code'=>'845450','first'=>'W','lng'=>'75.25839','lat'=>'39.71984']);
        $this->insert('{{%region}}',['id'=>'3267','pid'=>'3206','shortname'=>'喀什','name'=>'喀什地区','merger_name'=>'中国,新疆维吾尔自治区,喀什地区','level'=>'2','pinyin'=>'kashgar','code'=>'0998','zip_code'=>'844000','first'=>'K','lng'=>'75.989138','lat'=>'39.467664']);
        $this->insert('{{%region}}',['id'=>'3268','pid'=>'3267','shortname'=>'喀什','name'=>'喀什市','merger_name'=>'中国,新疆维吾尔自治区,喀什地区,喀什市','level'=>'3','pinyin'=>'kashi','code'=>'0998','zip_code'=>'844000','first'=>'K','lng'=>'75.99379','lat'=>'39.46768']);
        $this->insert('{{%region}}',['id'=>'3269','pid'=>'3267','shortname'=>'疏附','name'=>'疏附县','merger_name'=>'中国,新疆维吾尔自治区,喀什地区,疏附县','level'=>'3','pinyin'=>'shufu','code'=>'0998','zip_code'=>'844100','first'=>'S','lng'=>'75.86029','lat'=>'39.37534']);
        $this->insert('{{%region}}',['id'=>'3270','pid'=>'3267','shortname'=>'疏勒','name'=>'疏勒县','merger_name'=>'中国,新疆维吾尔自治区,喀什地区,疏勒县','level'=>'3','pinyin'=>'shule','code'=>'0998','zip_code'=>'844200','first'=>'S','lng'=>'76.05398','lat'=>'39.40625']);
        $this->insert('{{%region}}',['id'=>'3271','pid'=>'3267','shortname'=>'英吉沙','name'=>'英吉沙县','merger_name'=>'中国,新疆维吾尔自治区,喀什地区,英吉沙县','level'=>'3','pinyin'=>'yingjisha','code'=>'0998','zip_code'=>'844500','first'=>'Y','lng'=>'76.17565','lat'=>'38.92968']);
        $this->insert('{{%region}}',['id'=>'3272','pid'=>'3267','shortname'=>'泽普','name'=>'泽普县','merger_name'=>'中国,新疆维吾尔自治区,喀什地区,泽普县','level'=>'3','pinyin'=>'zepu','code'=>'0998','zip_code'=>'844800','first'=>'Z','lng'=>'77.27145','lat'=>'38.18935']);
        $this->insert('{{%region}}',['id'=>'3273','pid'=>'3267','shortname'=>'莎车','name'=>'莎车县','merger_name'=>'中国,新疆维吾尔自治区,喀什地区,莎车县','level'=>'3','pinyin'=>'shache','code'=>'0998','zip_code'=>'844700','first'=>'S','lng'=>'77.24316','lat'=>'38.41601']);
        $this->insert('{{%region}}',['id'=>'3274','pid'=>'3267','shortname'=>'叶城','name'=>'叶城县','merger_name'=>'中国,新疆维吾尔自治区,喀什地区,叶城县','level'=>'3','pinyin'=>'yecheng','code'=>'0998','zip_code'=>'844900','first'=>'Y','lng'=>'77.41659','lat'=>'37.88324']);
        $this->insert('{{%region}}',['id'=>'3275','pid'=>'3267','shortname'=>'麦盖提','name'=>'麦盖提县','merger_name'=>'中国,新疆维吾尔自治区,喀什地区,麦盖提县','level'=>'3','pinyin'=>'maigaiti','code'=>'0998','zip_code'=>'844600','first'=>'M','lng'=>'77.64224','lat'=>'38.89662']);
        $this->insert('{{%region}}',['id'=>'3276','pid'=>'3267','shortname'=>'岳普湖','name'=>'岳普湖县','merger_name'=>'中国,新疆维吾尔自治区,喀什地区,岳普湖县','level'=>'3','pinyin'=>'yuepuhu','code'=>'0998','zip_code'=>'844400','first'=>'Y','lng'=>'76.77233','lat'=>'39.23561']);
        $this->insert('{{%region}}',['id'=>'3277','pid'=>'3267','shortname'=>'伽师','name'=>'伽师县','merger_name'=>'中国,新疆维吾尔自治区,喀什地区,伽师县','level'=>'3','pinyin'=>'jiashi','code'=>'0998','zip_code'=>'844300','first'=>NULL,'lng'=>'76.72372','lat'=>'39.48801']);
        $this->insert('{{%region}}',['id'=>'3278','pid'=>'3267','shortname'=>'巴楚','name'=>'巴楚县','merger_name'=>'中国,新疆维吾尔自治区,喀什地区,巴楚县','level'=>'3','pinyin'=>'bachu','code'=>'0998','zip_code'=>'843800','first'=>'B','lng'=>'78.54888','lat'=>'39.7855']);
        $this->insert('{{%region}}',['id'=>'3279','pid'=>'3267','shortname'=>'塔什库尔干塔吉克','name'=>'塔什库尔干塔吉克自治县','merger_name'=>'中国,新疆维吾尔自治区,喀什地区,塔什库尔干塔吉克自治县','level'=>'3','pinyin'=>'tashikuergantajike','code'=>'0998','zip_code'=>'845250','first'=>'T','lng'=>'75.23196','lat'=>'37.77893']);
        $this->insert('{{%region}}',['id'=>'3280','pid'=>'3206','shortname'=>'和田','name'=>'和田地区','merger_name'=>'中国,新疆维吾尔自治区,和田地区','level'=>'2','pinyin'=>'hotan','code'=>'0903','zip_code'=>'848000','first'=>'H','lng'=>'79.92533','lat'=>'37.110687']);
        $this->insert('{{%region}}',['id'=>'3281','pid'=>'3280','shortname'=>'和田市','name'=>'和田市','merger_name'=>'中国,新疆维吾尔自治区,和田地区,和田市','level'=>'3','pinyin'=>'hetianshi','code'=>'0903','zip_code'=>'848000','first'=>'H','lng'=>'79.91353','lat'=>'37.11214']);
        $this->insert('{{%region}}',['id'=>'3282','pid'=>'3280','shortname'=>'和田县','name'=>'和田县','merger_name'=>'中国,新疆维吾尔自治区,和田地区,和田县','level'=>'3','pinyin'=>'hetianxian','code'=>'0903','zip_code'=>'848000','first'=>'H','lng'=>'79.82874','lat'=>'37.08922']);
        $this->insert('{{%region}}',['id'=>'3283','pid'=>'3280','shortname'=>'墨玉','name'=>'墨玉县','merger_name'=>'中国,新疆维吾尔自治区,和田地区,墨玉县','level'=>'3','pinyin'=>'moyu','code'=>'0903','zip_code'=>'848100','first'=>'M','lng'=>'79.74035','lat'=>'37.27248']);
        $this->insert('{{%region}}',['id'=>'3284','pid'=>'3280','shortname'=>'皮山','name'=>'皮山县','merger_name'=>'中国,新疆维吾尔自治区,和田地区,皮山县','level'=>'3','pinyin'=>'pishan','code'=>'0903','zip_code'=>'845150','first'=>'P','lng'=>'78.28125','lat'=>'37.62007']);
        $this->insert('{{%region}}',['id'=>'3285','pid'=>'3280','shortname'=>'洛浦','name'=>'洛浦县','merger_name'=>'中国,新疆维吾尔自治区,和田地区,洛浦县','level'=>'3','pinyin'=>'luopu','code'=>'0903','zip_code'=>'848200','first'=>'L','lng'=>'80.18536','lat'=>'37.07364']);
        $this->insert('{{%region}}',['id'=>'3286','pid'=>'3280','shortname'=>'策勒','name'=>'策勒县','merger_name'=>'中国,新疆维吾尔自治区,和田地区,策勒县','level'=>'3','pinyin'=>'cele','code'=>'0903','zip_code'=>'848300','first'=>'C','lng'=>'80.80999','lat'=>'36.99843']);
        $this->insert('{{%region}}',['id'=>'3287','pid'=>'3280','shortname'=>'于田','name'=>'于田县','merger_name'=>'中国,新疆维吾尔自治区,和田地区,于田县','level'=>'3','pinyin'=>'yutian','code'=>'0903','zip_code'=>'848400','first'=>'Y','lng'=>'81.66717','lat'=>'36.854']);
        $this->insert('{{%region}}',['id'=>'3288','pid'=>'3280','shortname'=>'民丰','name'=>'民丰县','merger_name'=>'中国,新疆维吾尔自治区,和田地区,民丰县','level'=>'3','pinyin'=>'minfeng','code'=>'0903','zip_code'=>'848500','first'=>'M','lng'=>'82.68444','lat'=>'37.06577']);
        $this->insert('{{%region}}',['id'=>'3289','pid'=>'3206','shortname'=>'伊犁','name'=>'伊犁哈萨克自治州','merger_name'=>'中国,新疆维吾尔自治区,伊犁哈萨克自治州','level'=>'2','pinyin'=>'ili','code'=>'0999','zip_code'=>'835100','first'=>'Y','lng'=>'81.317946','lat'=>'43.92186']);
        $this->insert('{{%region}}',['id'=>'3290','pid'=>'3289','shortname'=>'伊宁','name'=>'伊宁市','merger_name'=>'中国,新疆维吾尔自治区,伊犁哈萨克自治州,伊宁市','level'=>'3','pinyin'=>'yining','code'=>'0999','zip_code'=>'835000','first'=>'Y','lng'=>'81.32932','lat'=>'43.91294']);
        $this->insert('{{%region}}',['id'=>'3291','pid'=>'3289','shortname'=>'奎屯','name'=>'奎屯市','merger_name'=>'中国,新疆维吾尔自治区,伊犁哈萨克自治州,奎屯市','level'=>'3','pinyin'=>'kuitun','code'=>'0992','zip_code'=>'833200','first'=>'K','lng'=>'84.90228','lat'=>'44.425']);
        $this->insert('{{%region}}',['id'=>'3292','pid'=>'3289','shortname'=>'霍尔果斯','name'=>'霍尔果斯市','merger_name'=>'中国,新疆维吾尔自治区,伊犁哈萨克自治州,霍尔果斯市','level'=>'3','pinyin'=>'huoerguosi','code'=>'0999','zip_code'=>'835221','first'=>'H','lng'=>'80.418189','lat'=>'44.205778']);
        $this->insert('{{%region}}',['id'=>'3293','pid'=>'3289','shortname'=>'伊宁','name'=>'伊宁县','merger_name'=>'中国,新疆维吾尔自治区,伊犁哈萨克自治州,伊宁县','level'=>'3','pinyin'=>'yining','code'=>'0999','zip_code'=>'835100','first'=>'Y','lng'=>'81.52764','lat'=>'43.97863']);
        $this->insert('{{%region}}',['id'=>'3294','pid'=>'3289','shortname'=>'察布查尔锡伯','name'=>'察布查尔锡伯自治县','merger_name'=>'中国,新疆维吾尔自治区,伊犁哈萨克自治州,察布查尔锡伯自治县','level'=>'3','pinyin'=>'chabuchaerxibo','code'=>'0999','zip_code'=>'835300','first'=>'C','lng'=>'81.14956','lat'=>'43.84023']);
        $this->insert('{{%region}}',['id'=>'3295','pid'=>'3289','shortname'=>'霍城','name'=>'霍城县','merger_name'=>'中国,新疆维吾尔自治区,伊犁哈萨克自治州,霍城县','level'=>'3','pinyin'=>'huocheng','code'=>'0999','zip_code'=>'835200','first'=>'H','lng'=>'80.87826','lat'=>'44.0533']);
        $this->insert('{{%region}}',['id'=>'3296','pid'=>'3289','shortname'=>'巩留','name'=>'巩留县','merger_name'=>'中国,新疆维吾尔自治区,伊犁哈萨克自治州,巩留县','level'=>'3','pinyin'=>'gongliu','code'=>'0999','zip_code'=>'835400','first'=>'G','lng'=>'82.22851','lat'=>'43.48429']);
        $this->insert('{{%region}}',['id'=>'3297','pid'=>'3289','shortname'=>'新源','name'=>'新源县','merger_name'=>'中国,新疆维吾尔自治区,伊犁哈萨克自治州,新源县','level'=>'3','pinyin'=>'xinyuan','code'=>'0999','zip_code'=>'835800','first'=>'X','lng'=>'83.26095','lat'=>'43.4284']);
        $this->insert('{{%region}}',['id'=>'3298','pid'=>'3289','shortname'=>'昭苏','name'=>'昭苏县','merger_name'=>'中国,新疆维吾尔自治区,伊犁哈萨克自治州,昭苏县','level'=>'3','pinyin'=>'zhaosu','code'=>'0999','zip_code'=>'835600','first'=>'Z','lng'=>'81.1307','lat'=>'43.15828']);
        $this->insert('{{%region}}',['id'=>'3299','pid'=>'3289','shortname'=>'特克斯','name'=>'特克斯县','merger_name'=>'中国,新疆维吾尔自治区,伊犁哈萨克自治州,特克斯县','level'=>'3','pinyin'=>'tekesi','code'=>'0999','zip_code'=>'835500','first'=>'T','lng'=>'81.84005','lat'=>'43.21938']);
        $this->insert('{{%region}}',['id'=>'3300','pid'=>'3289','shortname'=>'尼勒克','name'=>'尼勒克县','merger_name'=>'中国,新疆维吾尔自治区,伊犁哈萨克自治州,尼勒克县','level'=>'3','pinyin'=>'nileke','code'=>'0999','zip_code'=>'835700','first'=>'N','lng'=>'82.51184','lat'=>'43.79901']);
        $this->insert('{{%region}}',['id'=>'3301','pid'=>'3206','shortname'=>'塔城','name'=>'塔城地区','merger_name'=>'中国,新疆维吾尔自治区,塔城地区','level'=>'2','pinyin'=>'qoqek','code'=>'0901','zip_code'=>'834700','first'=>'T','lng'=>'82.985732','lat'=>'46.746301']);
        $this->insert('{{%region}}',['id'=>'3302','pid'=>'3301','shortname'=>'塔城','name'=>'塔城市','merger_name'=>'中国,新疆维吾尔自治区,塔城地区,塔城市','level'=>'3','pinyin'=>'tacheng','code'=>'0901','zip_code'=>'834700','first'=>'T','lng'=>'82.97892','lat'=>'46.74852']);
        $this->insert('{{%region}}',['id'=>'3303','pid'=>'3301','shortname'=>'乌苏','name'=>'乌苏市','merger_name'=>'中国,新疆维吾尔自治区,塔城地区,乌苏市','level'=>'3','pinyin'=>'wusu','code'=>'0992','zip_code'=>'833000','first'=>'W','lng'=>'84.68258','lat'=>'44.43729']);
        $this->insert('{{%region}}',['id'=>'3304','pid'=>'3301','shortname'=>'额敏','name'=>'额敏县','merger_name'=>'中国,新疆维吾尔自治区,塔城地区,额敏县','level'=>'3','pinyin'=>'emin','code'=>'0901','zip_code'=>'834600','first'=>'E','lng'=>'83.62872','lat'=>'46.5284']);
        $this->insert('{{%region}}',['id'=>'3305','pid'=>'3301','shortname'=>'沙湾','name'=>'沙湾县','merger_name'=>'中国,新疆维吾尔自治区,塔城地区,沙湾县','level'=>'3','pinyin'=>'shawan','code'=>'0993','zip_code'=>'832100','first'=>'S','lng'=>'85.61932','lat'=>'44.33144']);
        $this->insert('{{%region}}',['id'=>'3306','pid'=>'3301','shortname'=>'托里','name'=>'托里县','merger_name'=>'中国,新疆维吾尔自治区,塔城地区,托里县','level'=>'3','pinyin'=>'tuoli','code'=>'0901','zip_code'=>'834500','first'=>'T','lng'=>'83.60592','lat'=>'45.93623']);
        $this->insert('{{%region}}',['id'=>'3307','pid'=>'3301','shortname'=>'裕民','name'=>'裕民县','merger_name'=>'中国,新疆维吾尔自治区,塔城地区,裕民县','level'=>'3','pinyin'=>'yumin','code'=>'0901','zip_code'=>'834800','first'=>'Y','lng'=>'82.99002','lat'=>'46.20377']);
        $this->insert('{{%region}}',['id'=>'3308','pid'=>'3301','shortname'=>'和布克赛尔','name'=>'和布克赛尔蒙古自治县','merger_name'=>'中国,新疆维吾尔自治区,塔城地区,和布克赛尔蒙古自治县','level'=>'3','pinyin'=>'hebukesaier','code'=>'0990','zip_code'=>'834400','first'=>'H','lng'=>'85.72662','lat'=>'46.79362']);
        $this->insert('{{%region}}',['id'=>'3309','pid'=>'3206','shortname'=>'阿勒泰','name'=>'阿勒泰地区','merger_name'=>'中国,新疆维吾尔自治区,阿勒泰地区','level'=>'2','pinyin'=>'altay','code'=>'0906','zip_code'=>'836500','first'=>'A','lng'=>'88.13963','lat'=>'47.848393']);
        $this->insert('{{%region}}',['id'=>'3310','pid'=>'3309','shortname'=>'阿勒泰','name'=>'阿勒泰市','merger_name'=>'中国,新疆维吾尔自治区,阿勒泰地区,阿勒泰市','level'=>'3','pinyin'=>'aletai','code'=>'0906','zip_code'=>'836500','first'=>'A','lng'=>'88.13913','lat'=>'47.8317']);
        $this->insert('{{%region}}',['id'=>'3311','pid'=>'3309','shortname'=>'布尔津','name'=>'布尔津县','merger_name'=>'中国,新疆维吾尔自治区,阿勒泰地区,布尔津县','level'=>'3','pinyin'=>'buerjin','code'=>'0906','zip_code'=>'836600','first'=>'B','lng'=>'86.85751','lat'=>'47.70062']);
        $this->insert('{{%region}}',['id'=>'3312','pid'=>'3309','shortname'=>'富蕴','name'=>'富蕴县','merger_name'=>'中国,新疆维吾尔自治区,阿勒泰地区,富蕴县','level'=>'3','pinyin'=>'fuyun','code'=>'0906','zip_code'=>'836100','first'=>'F','lng'=>'89.52679','lat'=>'46.99444']);
        $this->insert('{{%region}}',['id'=>'3313','pid'=>'3309','shortname'=>'福海','name'=>'福海县','merger_name'=>'中国,新疆维吾尔自治区,阿勒泰地区,福海县','level'=>'3','pinyin'=>'fuhai','code'=>'0906','zip_code'=>'836400','first'=>'F','lng'=>'87.49508','lat'=>'47.11065']);
        $this->insert('{{%region}}',['id'=>'3314','pid'=>'3309','shortname'=>'哈巴河','name'=>'哈巴河县','merger_name'=>'中国,新疆维吾尔自治区,阿勒泰地区,哈巴河县','level'=>'3','pinyin'=>'habahe','code'=>'0906','zip_code'=>'836700','first'=>'H','lng'=>'86.42092','lat'=>'48.06046']);
        $this->insert('{{%region}}',['id'=>'3315','pid'=>'3309','shortname'=>'青河','name'=>'青河县','merger_name'=>'中国,新疆维吾尔自治区,阿勒泰地区,青河县','level'=>'3','pinyin'=>'qinghe','code'=>'0906','zip_code'=>'836200','first'=>'Q','lng'=>'90.38305','lat'=>'46.67382']);
        $this->insert('{{%region}}',['id'=>'3316','pid'=>'3309','shortname'=>'吉木乃','name'=>'吉木乃县','merger_name'=>'中国,新疆维吾尔自治区,阿勒泰地区,吉木乃县','level'=>'3','pinyin'=>'jimunai','code'=>'0906','zip_code'=>'836800','first'=>'J','lng'=>'85.87814','lat'=>'47.43359']);
        $this->insert('{{%region}}',['id'=>'3317','pid'=>'3206','shortname'=>' ','name'=>'直辖县级','merger_name'=>'中国,新疆维吾尔自治区,直辖县级','level'=>'2','pinyin'=>'','code'=>'','zip_code'=>'','first'=>'Z','lng'=>'91.132212','lat'=>'29.660361']);
        $this->insert('{{%region}}',['id'=>'3318','pid'=>'3317','shortname'=>'石河子','name'=>'石河子市','merger_name'=>'中国,新疆维吾尔自治区,直辖县级,石河子市','level'=>'3','pinyin'=>'shihezi','code'=>'0993','zip_code'=>'832000','first'=>'S','lng'=>'86.041075','lat'=>'44.305886']);
        $this->insert('{{%region}}',['id'=>'3319','pid'=>'3317','shortname'=>'阿拉尔','name'=>'阿拉尔市','merger_name'=>'中国,新疆维吾尔自治区,直辖县级,阿拉尔市','level'=>'3','pinyin'=>'aral','code'=>'0997','zip_code'=>'843300','first'=>'A','lng'=>'81.285884','lat'=>'40.541914']);
        $this->insert('{{%region}}',['id'=>'3320','pid'=>'3317','shortname'=>'图木舒克','name'=>'图木舒克市','merger_name'=>'中国,新疆维吾尔自治区,直辖县级,图木舒克市','level'=>'3','pinyin'=>'tumxuk','code'=>'0998','zip_code'=>'843806','first'=>'T','lng'=>'79.077978','lat'=>'39.867316']);
        $this->insert('{{%region}}',['id'=>'3321','pid'=>'3317','shortname'=>'五家渠','name'=>'五家渠市','merger_name'=>'中国,新疆维吾尔自治区,直辖县级,五家渠市','level'=>'3','pinyin'=>'wujiaqu','code'=>'0994','zip_code'=>'831300','first'=>'W','lng'=>'87.526884','lat'=>'44.167401']);
        $this->insert('{{%region}}',['id'=>'3322','pid'=>'3317','shortname'=>'北屯','name'=>'北屯市','merger_name'=>'中国,新疆维吾尔自治区,直辖县级,北屯市','level'=>'3','pinyin'=>'beitun','code'=>'0906','zip_code'=>'836000','first'=>'B','lng'=>'87.808456','lat'=>'47.362308']);
        $this->insert('{{%region}}',['id'=>'3323','pid'=>'3317','shortname'=>'铁门关','name'=>'铁门关市','merger_name'=>'中国,新疆维吾尔自治区,直辖县级,铁门关市','level'=>'3','pinyin'=>'tiemenguan','code'=>'0906','zip_code'=>'836000','first'=>'T','lng'=>'86.194687','lat'=>'41.811007']);
        $this->insert('{{%region}}',['id'=>'3324','pid'=>'3317','shortname'=>'双河','name'=>'双河市','merger_name'=>'中国,新疆维吾尔自治区,直辖县级,双河市','level'=>'3','pinyin'=>'shuanghe','code'=>'0909','zip_code'=>'833408','first'=>'S','lng'=>'91.132212','lat'=>'29.660361']);
        $this->insert('{{%region}}',['id'=>'3325','pid'=>'0','shortname'=>'台湾','name'=>'台湾省','merger_name'=>'中国,台湾省','level'=>'1','pinyin'=>'taiwan','code'=>'','zip_code'=>'','first'=>'T','lng'=>'121.509062','lat'=>'25.044332']);
        $this->insert('{{%region}}',['id'=>'3326','pid'=>'3325','shortname'=>'台北','name'=>'台北市','merger_name'=>'中国,台湾省,台北市','level'=>'2','pinyin'=>'taipei','code'=>'02','zip_code'=>'1','first'=>'T','lng'=>'121.565170','lat'=>'25.037798']);
        $this->insert('{{%region}}',['id'=>'3327','pid'=>'3326','shortname'=>'松山','name'=>'松山区','merger_name'=>'中国,台湾省,台北市,松山区','level'=>'3','pinyin'=>'songshan','code'=>'02','zip_code'=>'105','first'=>'S','lng'=>'121.577206','lat'=>'25.049698']);
        $this->insert('{{%region}}',['id'=>'3328','pid'=>'3326','shortname'=>'信义','name'=>'信义区','merger_name'=>'中国,台湾省,台北市,信义区','level'=>'3','pinyin'=>'xinyi','code'=>'02','zip_code'=>'110','first'=>'X','lng'=>'121.751381','lat'=>'25.129407']);
        $this->insert('{{%region}}',['id'=>'3329','pid'=>'3326','shortname'=>'大安','name'=>'大安区','merger_name'=>'中国,台湾省,台北市,大安区','level'=>'3','pinyin'=>'da\'an','code'=>'02','zip_code'=>'106','first'=>'D','lng'=>'121.534648','lat'=>'25.026406']);
        $this->insert('{{%region}}',['id'=>'3330','pid'=>'3326','shortname'=>'中山','name'=>'中山区','merger_name'=>'中国,台湾省,台北市,中山区','level'=>'3','pinyin'=>'zhongshan','code'=>'02','zip_code'=>'104','first'=>'Z','lng'=>'121.533468','lat'=>'25.064361']);
        $this->insert('{{%region}}',['id'=>'3331','pid'=>'3326','shortname'=>'中正','name'=>'中正区','merger_name'=>'中国,台湾省,台北市,中正区','level'=>'3','pinyin'=>'zhongzheng','code'=>'02','zip_code'=>'100','first'=>'Z','lng'=>'121.518267','lat'=>'25.032361']);
        $this->insert('{{%region}}',['id'=>'3332','pid'=>'3326','shortname'=>'大同','name'=>'大同区','merger_name'=>'中国,台湾省,台北市,大同区','level'=>'3','pinyin'=>'datong','code'=>'02','zip_code'=>'103','first'=>'D','lng'=>'121.515514','lat'=>'25.065986']);
        $this->insert('{{%region}}',['id'=>'3333','pid'=>'3326','shortname'=>'万华','name'=>'万华区','merger_name'=>'中国,台湾省,台北市,万华区','level'=>'3','pinyin'=>'wanhua','code'=>'02','zip_code'=>'108','first'=>'W','lng'=>'121.499332','lat'=>'25.031933']);
        $this->insert('{{%region}}',['id'=>'3334','pid'=>'3326','shortname'=>'文山','name'=>'文山区','merger_name'=>'中国,台湾省,台北市,文山区','level'=>'3','pinyin'=>'wenshan','code'=>'02','zip_code'=>'116','first'=>'W','lng'=>'121.570458','lat'=>'24.989786']);
        $this->insert('{{%region}}',['id'=>'3335','pid'=>'3326','shortname'=>'南港','name'=>'南港区','merger_name'=>'中国,台湾省,台北市,南港区','level'=>'3','pinyin'=>'nangang','code'=>'02','zip_code'=>'115','first'=>'N','lng'=>'121.606858','lat'=>'25.054656']);
        $this->insert('{{%region}}',['id'=>'3336','pid'=>'3326','shortname'=>'内湖','name'=>'内湖区','merger_name'=>'中国,台湾省,台北市,内湖区','level'=>'3','pinyin'=>'nahu','code'=>'02','zip_code'=>'114','first'=>'N','lng'=>'121.588998','lat'=>'25.069664']);
        $this->insert('{{%region}}',['id'=>'3337','pid'=>'3326','shortname'=>'士林','name'=>'士林区','merger_name'=>'中国,台湾省,台北市,士林区','level'=>'3','pinyin'=>'shilin','code'=>'02','zip_code'=>'111','first'=>'S','lng'=>'121.519874','lat'=>'25.092822']);
        $this->insert('{{%region}}',['id'=>'3338','pid'=>'3326','shortname'=>'北投','name'=>'北投区','merger_name'=>'中国,台湾省,台北市,北投区','level'=>'3','pinyin'=>'beitou','code'=>'02','zip_code'=>'112','first'=>'B','lng'=>'121.501379','lat'=>'25.132419']);
        $this->insert('{{%region}}',['id'=>'3339','pid'=>'3325','shortname'=>'高雄','name'=>'高雄市','merger_name'=>'中国,台湾省,高雄市','level'=>'2','pinyin'=>'kaohsiung','code'=>'07','zip_code'=>'8','first'=>'G','lng'=>'120.311922','lat'=>'22.620856']);
        $this->insert('{{%region}}',['id'=>'3340','pid'=>'3339','shortname'=>'盐埕','name'=>'盐埕区','merger_name'=>'中国,台湾省,高雄市,盐埕区','level'=>'3','pinyin'=>'yancheng','code'=>'07','zip_code'=>'803','first'=>'Y','lng'=>'120.286795','lat'=>'22.624666']);
        $this->insert('{{%region}}',['id'=>'3341','pid'=>'3339','shortname'=>'鼓山','name'=>'鼓山区','merger_name'=>'中国,台湾省,高雄市,鼓山区','level'=>'3','pinyin'=>'gushan','code'=>'07','zip_code'=>'804','first'=>'G','lng'=>'120.281154','lat'=>'22.636797']);
        $this->insert('{{%region}}',['id'=>'3342','pid'=>'3339','shortname'=>'左营','name'=>'左营区','merger_name'=>'中国,台湾省,高雄市,左营区','level'=>'3','pinyin'=>'zuoying','code'=>'07','zip_code'=>'813','first'=>'Z','lng'=>'120.294958','lat'=>'22.690124']);
        $this->insert('{{%region}}',['id'=>'3343','pid'=>'3339','shortname'=>'楠梓','name'=>'楠梓区','merger_name'=>'中国,台湾省,高雄市,楠梓区','level'=>'3','pinyin'=>'nanzi','code'=>'07','zip_code'=>'811','first'=>NULL,'lng'=>'120.326314','lat'=>'22.728401']);
        $this->insert('{{%region}}',['id'=>'3344','pid'=>'3339','shortname'=>'三民','name'=>'三民区','merger_name'=>'中国,台湾省,高雄市,三民区','level'=>'3','pinyin'=>'sanmin','code'=>'07','zip_code'=>'807','first'=>'S','lng'=>'120.299622','lat'=>'22.647695']);
        $this->insert('{{%region}}',['id'=>'3345','pid'=>'3339','shortname'=>'新兴','name'=>'新兴区','merger_name'=>'中国,台湾省,高雄市,新兴区','level'=>'3','pinyin'=>'xinxing','code'=>'07','zip_code'=>'800','first'=>'X','lng'=>'120.309535','lat'=>'22.631147']);
        $this->insert('{{%region}}',['id'=>'3346','pid'=>'3339','shortname'=>'前金','name'=>'前金区','merger_name'=>'中国,台湾省,高雄市,前金区','level'=>'3','pinyin'=>'qianjin','code'=>'07','zip_code'=>'801','first'=>'Q','lng'=>'120.294159','lat'=>'22.627421']);
        $this->insert('{{%region}}',['id'=>'3347','pid'=>'3339','shortname'=>'苓雅','name'=>'苓雅区','merger_name'=>'中国,台湾省,高雄市,苓雅区','level'=>'3','pinyin'=>'lingya','code'=>'07','zip_code'=>'802','first'=>NULL,'lng'=>'120.312347','lat'=>'22.621770']);
        $this->insert('{{%region}}',['id'=>'3348','pid'=>'3339','shortname'=>'前镇','name'=>'前镇区','merger_name'=>'中国,台湾省,高雄市,前镇区','level'=>'3','pinyin'=>'qianzhen','code'=>'07','zip_code'=>'806','first'=>'Q','lng'=>'120.318583','lat'=>'22.586425']);
        $this->insert('{{%region}}',['id'=>'3349','pid'=>'3339','shortname'=>'旗津','name'=>'旗津区','merger_name'=>'中国,台湾省,高雄市,旗津区','level'=>'3','pinyin'=>'qijin','code'=>'07','zip_code'=>'805','first'=>'Q','lng'=>'120.284429','lat'=>'22.590565']);
        $this->insert('{{%region}}',['id'=>'3350','pid'=>'3339','shortname'=>'小港','name'=>'小港区','merger_name'=>'中国,台湾省,高雄市,小港区','level'=>'3','pinyin'=>'xiaogang','code'=>'07','zip_code'=>'812','first'=>'X','lng'=>'120.337970','lat'=>'22.565354']);
        $this->insert('{{%region}}',['id'=>'3351','pid'=>'3339','shortname'=>'凤山','name'=>'凤山区','merger_name'=>'中国,台湾省,高雄市,凤山区','level'=>'3','pinyin'=>'fengshan','code'=>'07','zip_code'=>'830','first'=>'F','lng'=>'120.356892','lat'=>'22.626945']);
        $this->insert('{{%region}}',['id'=>'3352','pid'=>'3339','shortname'=>'林园','name'=>'林园区','merger_name'=>'中国,台湾省,高雄市,林园区','level'=>'3','pinyin'=>'linyuan','code'=>'07','zip_code'=>'832','first'=>'L','lng'=>'120.395977','lat'=>'22.501490']);
        $this->insert('{{%region}}',['id'=>'3353','pid'=>'3339','shortname'=>'大寮','name'=>'大寮区','merger_name'=>'中国,台湾省,高雄市,大寮区','level'=>'3','pinyin'=>'daliao','code'=>'07','zip_code'=>'831','first'=>'D','lng'=>'120.395422','lat'=>'22.605386']);
        $this->insert('{{%region}}',['id'=>'3354','pid'=>'3339','shortname'=>'大树','name'=>'大树区','merger_name'=>'中国,台湾省,高雄市,大树区','level'=>'3','pinyin'=>'dashu','code'=>'07','zip_code'=>'840','first'=>'D','lng'=>'120.433095','lat'=>'22.693394']);
        $this->insert('{{%region}}',['id'=>'3355','pid'=>'3339','shortname'=>'大社','name'=>'大社区','merger_name'=>'中国,台湾省,高雄市,大社区','level'=>'3','pinyin'=>'dashe','code'=>'07','zip_code'=>'815','first'=>'D','lng'=>'120.346635','lat'=>'22.729966']);
        $this->insert('{{%region}}',['id'=>'3356','pid'=>'3339','shortname'=>'仁武','name'=>'仁武区','merger_name'=>'中国,台湾省,高雄市,仁武区','level'=>'3','pinyin'=>'renwu','code'=>'07','zip_code'=>'814','first'=>'R','lng'=>'120.347779','lat'=>'22.701901']);
        $this->insert('{{%region}}',['id'=>'3357','pid'=>'3339','shortname'=>'鸟松','name'=>'鸟松区','merger_name'=>'中国,台湾省,高雄市,鸟松区','level'=>'3','pinyin'=>'niaosong','code'=>'07','zip_code'=>'833','first'=>'N','lng'=>'120.364402','lat'=>'22.659340']);
        $this->insert('{{%region}}',['id'=>'3358','pid'=>'3339','shortname'=>'冈山','name'=>'冈山区','merger_name'=>'中国,台湾省,高雄市,冈山区','level'=>'3','pinyin'=>'gangshan','code'=>'07','zip_code'=>'820','first'=>'G','lng'=>'120.295820','lat'=>'22.796762']);
        $this->insert('{{%region}}',['id'=>'3359','pid'=>'3339','shortname'=>'桥头','name'=>'桥头区','merger_name'=>'中国,台湾省,高雄市,桥头区','level'=>'3','pinyin'=>'qiaotou','code'=>'07','zip_code'=>'825','first'=>'Q','lng'=>'120.305741','lat'=>'22.757501']);
        $this->insert('{{%region}}',['id'=>'3360','pid'=>'3339','shortname'=>'燕巢','name'=>'燕巢区','merger_name'=>'中国,台湾省,高雄市,燕巢区','level'=>'3','pinyin'=>'yanchao','code'=>'07','zip_code'=>'824','first'=>'Y','lng'=>'120.361956','lat'=>'22.793370']);
        $this->insert('{{%region}}',['id'=>'3361','pid'=>'3339','shortname'=>'田寮','name'=>'田寮区','merger_name'=>'中国,台湾省,高雄市,田寮区','level'=>'3','pinyin'=>'tianliao','code'=>'07','zip_code'=>'823','first'=>'T','lng'=>'120.359636','lat'=>'22.869307']);
        $this->insert('{{%region}}',['id'=>'3362','pid'=>'3339','shortname'=>'阿莲','name'=>'阿莲区','merger_name'=>'中国,台湾省,高雄市,阿莲区','level'=>'3','pinyin'=>'alian','code'=>'07','zip_code'=>'822','first'=>'A','lng'=>'120.327036','lat'=>'22.883703']);
        $this->insert('{{%region}}',['id'=>'3363','pid'=>'3339','shortname'=>'路竹','name'=>'路竹区','merger_name'=>'中国,台湾省,高雄市,路竹区','level'=>'3','pinyin'=>'luzhu','code'=>'07','zip_code'=>'821','first'=>'L','lng'=>'120.261828','lat'=>'22.856851']);
        $this->insert('{{%region}}',['id'=>'3364','pid'=>'3339','shortname'=>'湖内','name'=>'湖内区','merger_name'=>'中国,台湾省,高雄市,湖内区','level'=>'3','pinyin'=>'huna','code'=>'07','zip_code'=>'829','first'=>'H','lng'=>'120.211530','lat'=>'22.908188']);
        $this->insert('{{%region}}',['id'=>'3365','pid'=>'3339','shortname'=>'茄萣','name'=>'茄萣区','merger_name'=>'中国,台湾省,高雄市,茄萣区','level'=>'3','pinyin'=>'qieding','code'=>'07','zip_code'=>'852','first'=>NULL,'lng'=>'120.182815','lat'=>'22.906556']);
        $this->insert('{{%region}}',['id'=>'3366','pid'=>'3339','shortname'=>'永安','name'=>'永安区','merger_name'=>'中国,台湾省,高雄市,永安区','level'=>'3','pinyin'=>'yong\'an','code'=>'07','zip_code'=>'828','first'=>'Y','lng'=>'120.225308','lat'=>'22.818580']);
        $this->insert('{{%region}}',['id'=>'3367','pid'=>'3339','shortname'=>'弥陀','name'=>'弥陀区','merger_name'=>'中国,台湾省,高雄市,弥陀区','level'=>'3','pinyin'=>'mituo','code'=>'07','zip_code'=>'827','first'=>'M','lng'=>'120.247344','lat'=>'22.782879']);
        $this->insert('{{%region}}',['id'=>'3368','pid'=>'3339','shortname'=>'梓官','name'=>'梓官区','merger_name'=>'中国,台湾省,高雄市,梓官区','level'=>'3','pinyin'=>'ziguan','code'=>'07','zip_code'=>'826','first'=>NULL,'lng'=>'120.267322','lat'=>'22.760475']);
        $this->insert('{{%region}}',['id'=>'3369','pid'=>'3339','shortname'=>'旗山','name'=>'旗山区','merger_name'=>'中国,台湾省,高雄市,旗山区','level'=>'3','pinyin'=>'qishan','code'=>'07','zip_code'=>'842','first'=>'Q','lng'=>'120.483550','lat'=>'22.888491']);
        $this->insert('{{%region}}',['id'=>'3370','pid'=>'3339','shortname'=>'美浓','name'=>'美浓区','merger_name'=>'中国,台湾省,高雄市,美浓区','level'=>'3','pinyin'=>'meinong','code'=>'07','zip_code'=>'843','first'=>'M','lng'=>'120.541530','lat'=>'22.897880']);
        $this->insert('{{%region}}',['id'=>'3371','pid'=>'3339','shortname'=>'六龟','name'=>'六龟区','merger_name'=>'中国,台湾省,高雄市,六龟区','level'=>'3','pinyin'=>'liugui','code'=>'07','zip_code'=>'844','first'=>'L','lng'=>'120.633418','lat'=>'22.997914']);
        $this->insert('{{%region}}',['id'=>'3372','pid'=>'3339','shortname'=>'甲仙','name'=>'甲仙区','merger_name'=>'中国,台湾省,高雄市,甲仙区','level'=>'3','pinyin'=>'jiaxian','code'=>'07','zip_code'=>'847','first'=>'J','lng'=>'120.591185','lat'=>'23.084688']);
        $this->insert('{{%region}}',['id'=>'3373','pid'=>'3339','shortname'=>'杉林','name'=>'杉林区','merger_name'=>'中国,台湾省,高雄市,杉林区','level'=>'3','pinyin'=>'shanlin','code'=>'07','zip_code'=>'846','first'=>'S','lng'=>'120.538980','lat'=>'22.970712']);
        $this->insert('{{%region}}',['id'=>'3374','pid'=>'3339','shortname'=>'内门','name'=>'内门区','merger_name'=>'中国,台湾省,高雄市,内门区','level'=>'3','pinyin'=>'namen','code'=>'07','zip_code'=>'845','first'=>'N','lng'=>'120.462351','lat'=>'22.943437']);
        $this->insert('{{%region}}',['id'=>'3375','pid'=>'3339','shortname'=>'茂林','name'=>'茂林区','merger_name'=>'中国,台湾省,高雄市,茂林区','level'=>'3','pinyin'=>'maolin','code'=>'07','zip_code'=>'851','first'=>'M','lng'=>'120.663217','lat'=>'22.886248']);
        $this->insert('{{%region}}',['id'=>'3376','pid'=>'3339','shortname'=>'桃源','name'=>'桃源区','merger_name'=>'中国,台湾省,高雄市,桃源区','level'=>'3','pinyin'=>'taoyuan','code'=>'07','zip_code'=>'848','first'=>'T','lng'=>'120.760049','lat'=>'23.159137']);
        $this->insert('{{%region}}',['id'=>'3377','pid'=>'3339','shortname'=>'那玛夏','name'=>'那玛夏区','merger_name'=>'中国,台湾省,高雄市,那玛夏区','level'=>'3','pinyin'=>'namaxia','code'=>'07','zip_code'=>'849','first'=>'N','lng'=>'120.692799','lat'=>'23.216964']);
        $this->insert('{{%region}}',['id'=>'3378','pid'=>'3325','shortname'=>'基隆','name'=>'基隆市','merger_name'=>'中国,台湾省,基隆市','level'=>'2','pinyin'=>'keelung','code'=>'02','zip_code'=>'2','first'=>'J','lng'=>'121.746248','lat'=>'25.130741']);
        $this->insert('{{%region}}',['id'=>'3379','pid'=>'3378','shortname'=>'中正','name'=>'中正区','merger_name'=>'中国,台湾省,基隆市,中正区','level'=>'3','pinyin'=>'zhongzheng','code'=>'02','zip_code'=>'202','first'=>'Z','lng'=>'121.518267','lat'=>'25.032361']);
        $this->insert('{{%region}}',['id'=>'3380','pid'=>'3378','shortname'=>'七堵','name'=>'七堵区','merger_name'=>'中国,台湾省,基隆市,七堵区','level'=>'3','pinyin'=>'qidu','code'=>'02','zip_code'=>'206','first'=>'Q','lng'=>'121.713032','lat'=>'25.095739']);
        $this->insert('{{%region}}',['id'=>'3381','pid'=>'3378','shortname'=>'暖暖','name'=>'暖暖区','merger_name'=>'中国,台湾省,基隆市,暖暖区','level'=>'3','pinyin'=>'nuannuan','code'=>'02','zip_code'=>'205','first'=>'N','lng'=>'121.736102','lat'=>'25.099777']);
        $this->insert('{{%region}}',['id'=>'3382','pid'=>'3378','shortname'=>'仁爱','name'=>'仁爱区','merger_name'=>'中国,台湾省,基隆市,仁爱区','level'=>'3','pinyin'=>'renai','code'=>'02','zip_code'=>'200','first'=>'R','lng'=>'121.740940','lat'=>'25.127526']);
        $this->insert('{{%region}}',['id'=>'3383','pid'=>'3378','shortname'=>'中山','name'=>'中山区','merger_name'=>'中国,台湾省,基隆市,中山区','level'=>'3','pinyin'=>'zhongshan','code'=>'02','zip_code'=>'203','first'=>'Z','lng'=>'121.739132','lat'=>'25.133991']);
        $this->insert('{{%region}}',['id'=>'3384','pid'=>'3378','shortname'=>'安乐','name'=>'安乐区','merger_name'=>'中国,台湾省,基隆市,安乐区','level'=>'3','pinyin'=>'anle','code'=>'02','zip_code'=>'204','first'=>'A','lng'=>'121.723203','lat'=>'25.120910']);
        $this->insert('{{%region}}',['id'=>'3385','pid'=>'3378','shortname'=>'信义','name'=>'信义区','merger_name'=>'中国,台湾省,基隆市,信义区','level'=>'3','pinyin'=>'xinyi','code'=>'02','zip_code'=>'201','first'=>'X','lng'=>'121.751381','lat'=>'25.129407']);
        $this->insert('{{%region}}',['id'=>'3386','pid'=>'3325','shortname'=>'台中','name'=>'台中市','merger_name'=>'中国,台湾省,台中市','level'=>'2','pinyin'=>'taichung','code'=>'04','zip_code'=>'4','first'=>'T','lng'=>'120.679040','lat'=>'24.138620']);
        $this->insert('{{%region}}',['id'=>'3387','pid'=>'3386','shortname'=>'中区','name'=>'中区','merger_name'=>'中国,台湾省,台中市,中区','level'=>'3','pinyin'=>'zhongqu','code'=>'04','zip_code'=>'400','first'=>'Z','lng'=>'120.679510','lat'=>'24.143830']);
        $this->insert('{{%region}}',['id'=>'3388','pid'=>'3386','shortname'=>'东区','name'=>'东区','merger_name'=>'中国,台湾省,台中市,东区','level'=>'3','pinyin'=>'dongqu','code'=>'04','zip_code'=>'401','first'=>'D','lng'=>'120.704','lat'=>'24.13662']);
        $this->insert('{{%region}}',['id'=>'3389','pid'=>'3386','shortname'=>'南区','name'=>'南区','merger_name'=>'中国,台湾省,台中市,南区','level'=>'3','pinyin'=>'nanqu','code'=>'04','zip_code'=>'402','first'=>'N','lng'=>'120.188648','lat'=>'22.960944']);
        $this->insert('{{%region}}',['id'=>'3390','pid'=>'3386','shortname'=>'西区','name'=>'西区','merger_name'=>'中国,台湾省,台中市,西区','level'=>'3','pinyin'=>'xiqu','code'=>'04','zip_code'=>'403','first'=>'X','lng'=>'120.67104','lat'=>'24.14138']);
        $this->insert('{{%region}}',['id'=>'3391','pid'=>'3386','shortname'=>'北区','name'=>'北区','merger_name'=>'中国,台湾省,台中市,北区','level'=>'3','pinyin'=>'beiqu','code'=>'04','zip_code'=>'404','first'=>'B','lng'=>'120.682410','lat'=>'24.166040']);
        $this->insert('{{%region}}',['id'=>'3392','pid'=>'3386','shortname'=>'西屯','name'=>'西屯区','merger_name'=>'中国,台湾省,台中市,西屯区','level'=>'3','pinyin'=>'xitun','code'=>'04','zip_code'=>'407','first'=>'X','lng'=>'120.639820','lat'=>'24.181340']);
        $this->insert('{{%region}}',['id'=>'3393','pid'=>'3386','shortname'=>'南屯','name'=>'南屯区','merger_name'=>'中国,台湾省,台中市,南屯区','level'=>'3','pinyin'=>'nantun','code'=>'04','zip_code'=>'408','first'=>'N','lng'=>'120.643080','lat'=>'24.138270']);
        $this->insert('{{%region}}',['id'=>'3394','pid'=>'3386','shortname'=>'北屯','name'=>'北屯区','merger_name'=>'中国,台湾省,台中市,北屯区','level'=>'3','pinyin'=>'beitun','code'=>'04','zip_code'=>'406','first'=>'B','lng'=>'120.686250','lat'=>'24.182220']);
        $this->insert('{{%region}}',['id'=>'3395','pid'=>'3386','shortname'=>'丰原','name'=>'丰原区','merger_name'=>'中国,台湾省,台中市,丰原区','level'=>'3','pinyin'=>'fengyuan','code'=>'04','zip_code'=>'420','first'=>'F','lng'=>'120.718460','lat'=>'24.242190']);
        $this->insert('{{%region}}',['id'=>'3396','pid'=>'3386','shortname'=>'东势','name'=>'东势区','merger_name'=>'中国,台湾省,台中市,东势区','level'=>'3','pinyin'=>'dongshi','code'=>'04','zip_code'=>'423','first'=>'D','lng'=>'120.827770','lat'=>'24.258610']);
        $this->insert('{{%region}}',['id'=>'3397','pid'=>'3386','shortname'=>'大甲','name'=>'大甲区','merger_name'=>'中国,台湾省,台中市,大甲区','level'=>'3','pinyin'=>'dajia','code'=>'04','zip_code'=>'437','first'=>'D','lng'=>'120.622390','lat'=>'24.348920']);
        $this->insert('{{%region}}',['id'=>'3398','pid'=>'3386','shortname'=>'清水','name'=>'清水区','merger_name'=>'中国,台湾省,台中市,清水区','level'=>'3','pinyin'=>'qingshui','code'=>'04','zip_code'=>'436','first'=>'Q','lng'=>'120.559780','lat'=>'24.268650']);
        $this->insert('{{%region}}',['id'=>'3399','pid'=>'3386','shortname'=>'沙鹿','name'=>'沙鹿区','merger_name'=>'中国,台湾省,台中市,沙鹿区','level'=>'3','pinyin'=>'shalu','code'=>'04','zip_code'=>'433','first'=>'S','lng'=>'120.565700','lat'=>'24.233480']);
        $this->insert('{{%region}}',['id'=>'3400','pid'=>'3386','shortname'=>'梧栖','name'=>'梧栖区','merger_name'=>'中国,台湾省,台中市,梧栖区','level'=>'3','pinyin'=>'wuqi','code'=>'04','zip_code'=>'435','first'=>'W','lng'=>'120.531520','lat'=>'24.254960']);
        $this->insert('{{%region}}',['id'=>'3401','pid'=>'3386','shortname'=>'后里','name'=>'后里区','merger_name'=>'中国,台湾省,台中市,后里区','level'=>'3','pinyin'=>'houli','code'=>'04','zip_code'=>'421','first'=>'H','lng'=>'120.710710','lat'=>'24.304910']);
        $this->insert('{{%region}}',['id'=>'3402','pid'=>'3386','shortname'=>'神冈','name'=>'神冈区','merger_name'=>'中国,台湾省,台中市,神冈区','level'=>'3','pinyin'=>'shengang','code'=>'04','zip_code'=>'429','first'=>'S','lng'=>'120.661550','lat'=>'24.257770']);
        $this->insert('{{%region}}',['id'=>'3403','pid'=>'3386','shortname'=>'潭子','name'=>'潭子区','merger_name'=>'中国,台湾省,台中市,潭子区','level'=>'3','pinyin'=>'tanzi','code'=>'04','zip_code'=>'427','first'=>'T','lng'=>'120.705160','lat'=>'24.209530']);
        $this->insert('{{%region}}',['id'=>'3404','pid'=>'3386','shortname'=>'大雅','name'=>'大雅区','merger_name'=>'中国,台湾省,台中市,大雅区','level'=>'3','pinyin'=>'daya','code'=>'04','zip_code'=>'428','first'=>'D','lng'=>'120.647780','lat'=>'24.229230']);
        $this->insert('{{%region}}',['id'=>'3405','pid'=>'3386','shortname'=>'新社','name'=>'新社区','merger_name'=>'中国,台湾省,台中市,新社区','level'=>'3','pinyin'=>'xinshe','code'=>'04','zip_code'=>'426','first'=>'X','lng'=>'120.809500','lat'=>'24.234140']);
        $this->insert('{{%region}}',['id'=>'3406','pid'=>'3386','shortname'=>'石冈','name'=>'石冈区','merger_name'=>'中国,台湾省,台中市,石冈区','level'=>'3','pinyin'=>'shigang','code'=>'04','zip_code'=>'422','first'=>'S','lng'=>'120.780410','lat'=>'24.274980']);
        $this->insert('{{%region}}',['id'=>'3407','pid'=>'3386','shortname'=>'外埔','name'=>'外埔区','merger_name'=>'中国,台湾省,台中市,外埔区','level'=>'3','pinyin'=>'waipu','code'=>'04','zip_code'=>'438','first'=>'W','lng'=>'120.654370','lat'=>'24.332010']);
        $this->insert('{{%region}}',['id'=>'3408','pid'=>'3386','shortname'=>'大安','name'=>'大安区','merger_name'=>'中国,台湾省,台中市,大安区','level'=>'3','pinyin'=>'da\'an','code'=>'04','zip_code'=>'439','first'=>'D','lng'=>'120.58652','lat'=>'24.34607']);
        $this->insert('{{%region}}',['id'=>'3409','pid'=>'3386','shortname'=>'乌日','name'=>'乌日区','merger_name'=>'中国,台湾省,台中市,乌日区','level'=>'3','pinyin'=>'wuri','code'=>'04','zip_code'=>'414','first'=>'W','lng'=>'120.623810','lat'=>'24.104500']);
        $this->insert('{{%region}}',['id'=>'3410','pid'=>'3386','shortname'=>'大肚','name'=>'大肚区','merger_name'=>'中国,台湾省,台中市,大肚区','level'=>'3','pinyin'=>'dadu','code'=>'04','zip_code'=>'432','first'=>'D','lng'=>'120.540960','lat'=>'24.153660']);
        $this->insert('{{%region}}',['id'=>'3411','pid'=>'3386','shortname'=>'龙井','name'=>'龙井区','merger_name'=>'中国,台湾省,台中市,龙井区','level'=>'3','pinyin'=>'longjing','code'=>'04','zip_code'=>'434','first'=>'L','lng'=>'120.545940','lat'=>'24.192710']);
        $this->insert('{{%region}}',['id'=>'3412','pid'=>'3386','shortname'=>'雾峰','name'=>'雾峰区','merger_name'=>'中国,台湾省,台中市,雾峰区','level'=>'3','pinyin'=>'wufeng','code'=>'04','zip_code'=>'413','first'=>'W','lng'=>'120.700200','lat'=>'24.061520']);
        $this->insert('{{%region}}',['id'=>'3413','pid'=>'3386','shortname'=>'太平','name'=>'太平区','merger_name'=>'中国,台湾省,台中市,太平区','level'=>'3','pinyin'=>'taiping','code'=>'04','zip_code'=>'411','first'=>'T','lng'=>'120.718523','lat'=>'24.126472']);
        $this->insert('{{%region}}',['id'=>'3414','pid'=>'3386','shortname'=>'大里','name'=>'大里区','merger_name'=>'中国,台湾省,台中市,大里区','level'=>'3','pinyin'=>'dali','code'=>'04','zip_code'=>'412','first'=>'D','lng'=>'120.677860','lat'=>'24.099390']);
        $this->insert('{{%region}}',['id'=>'3415','pid'=>'3386','shortname'=>'和平','name'=>'和平区','merger_name'=>'中国,台湾省,台中市,和平区','level'=>'3','pinyin'=>'heping','code'=>'04','zip_code'=>'424','first'=>'H','lng'=>'120.88349','lat'=>'24.17477']);
        $this->insert('{{%region}}',['id'=>'3416','pid'=>'3325','shortname'=>'台南','name'=>'台南市','merger_name'=>'中国,台湾省,台南市','level'=>'2','pinyin'=>'tainan','code'=>'06','zip_code'=>'7','first'=>'T','lng'=>'120.279363','lat'=>'23.172478']);
        $this->insert('{{%region}}',['id'=>'3417','pid'=>'3416','shortname'=>'东区','name'=>'东区','merger_name'=>'中国,台湾省,台南市,东区','level'=>'3','pinyin'=>'dongqu','code'=>'06','zip_code'=>'701','first'=>'D','lng'=>'120.224198','lat'=>'22.980072']);
        $this->insert('{{%region}}',['id'=>'3418','pid'=>'3416','shortname'=>'南区','name'=>'南区','merger_name'=>'中国,台湾省,台南市,南区','level'=>'3','pinyin'=>'nanqu','code'=>'06','zip_code'=>'702','first'=>'N','lng'=>'120.188648','lat'=>'22.960944']);
        $this->insert('{{%region}}',['id'=>'3419','pid'=>'3416','shortname'=>'北区','name'=>'北区','merger_name'=>'中国,台湾省,台南市,北区','level'=>'3','pinyin'=>'beiqu','code'=>'06','zip_code'=>'704','first'=>'B','lng'=>'120.682410','lat'=>'24.166040']);
        $this->insert('{{%region}}',['id'=>'3420','pid'=>'3416','shortname'=>'安南','name'=>'安南区','merger_name'=>'中国,台湾省,台南市,安南区','level'=>'3','pinyin'=>'annan','code'=>'06','zip_code'=>'709','first'=>'A','lng'=>'120.184617','lat'=>'23.047230']);
        $this->insert('{{%region}}',['id'=>'3421','pid'=>'3416','shortname'=>'安平','name'=>'安平区','merger_name'=>'中国,台湾省,台南市,安平区','level'=>'3','pinyin'=>'anping','code'=>'06','zip_code'=>'708','first'=>'A','lng'=>'120.166810','lat'=>'23.000763']);
        $this->insert('{{%region}}',['id'=>'3422','pid'=>'3416','shortname'=>'中西','name'=>'中西区','merger_name'=>'中国,台湾省,台南市,中西区','level'=>'3','pinyin'=>'zhongxi','code'=>'06','zip_code'=>'700','first'=>'Z','lng'=>'120.205957','lat'=>'22.992152']);
        $this->insert('{{%region}}',['id'=>'3423','pid'=>'3416','shortname'=>'新营','name'=>'新营区','merger_name'=>'中国,台湾省,台南市,新营区','level'=>'3','pinyin'=>'xinying','code'=>'06','zip_code'=>'730','first'=>'X','lng'=>'120.316698','lat'=>'23.310274']);
        $this->insert('{{%region}}',['id'=>'3424','pid'=>'3416','shortname'=>'盐水','name'=>'盐水区','merger_name'=>'中国,台湾省,台南市,盐水区','level'=>'3','pinyin'=>'yanshui','code'=>'06','zip_code'=>'737','first'=>'Y','lng'=>'120.266398','lat'=>'23.319828']);
        $this->insert('{{%region}}',['id'=>'3425','pid'=>'3416','shortname'=>'白河','name'=>'白河区','merger_name'=>'中国,台湾省,台南市,白河区','level'=>'3','pinyin'=>'baihe','code'=>'06','zip_code'=>'732','first'=>'B','lng'=>'120.415810','lat'=>'23.351221']);
        $this->insert('{{%region}}',['id'=>'3426','pid'=>'3416','shortname'=>'柳营','name'=>'柳营区','merger_name'=>'中国,台湾省,台南市,柳营区','level'=>'3','pinyin'=>'liuying','code'=>'06','zip_code'=>'736','first'=>'L','lng'=>'120.311286','lat'=>'23.278133']);
        $this->insert('{{%region}}',['id'=>'3427','pid'=>'3416','shortname'=>'后壁','name'=>'后壁区','merger_name'=>'中国,台湾省,台南市,后壁区','level'=>'3','pinyin'=>'houbi','code'=>'06','zip_code'=>'731','first'=>'H','lng'=>'120.362726','lat'=>'23.366721']);
        $this->insert('{{%region}}',['id'=>'3428','pid'=>'3416','shortname'=>'东山','name'=>'东山区','merger_name'=>'中国,台湾省,台南市,东山区','level'=>'3','pinyin'=>'dongshan','code'=>'06','zip_code'=>'733','first'=>'D','lng'=>'120.403984','lat'=>'23.326092']);
        $this->insert('{{%region}}',['id'=>'3429','pid'=>'3416','shortname'=>'麻豆','name'=>'麻豆区','merger_name'=>'中国,台湾省,台南市,麻豆区','level'=>'3','pinyin'=>'madou','code'=>'06','zip_code'=>'721','first'=>'M','lng'=>'120.248179','lat'=>'23.181680']);
        $this->insert('{{%region}}',['id'=>'3430','pid'=>'3416','shortname'=>'下营','name'=>'下营区','merger_name'=>'中国,台湾省,台南市,下营区','level'=>'3','pinyin'=>'xiaying','code'=>'06','zip_code'=>'735','first'=>'X','lng'=>'120.264484','lat'=>'23.235413']);
        $this->insert('{{%region}}',['id'=>'3431','pid'=>'3416','shortname'=>'六甲','name'=>'六甲区','merger_name'=>'中国,台湾省,台南市,六甲区','level'=>'3','pinyin'=>'liujia','code'=>'06','zip_code'=>'734','first'=>'L','lng'=>'120.347600','lat'=>'23.231931']);
        $this->insert('{{%region}}',['id'=>'3432','pid'=>'3416','shortname'=>'官田','name'=>'官田区','merger_name'=>'中国,台湾省,台南市,官田区','level'=>'3','pinyin'=>'guantian','code'=>'06','zip_code'=>'720','first'=>'G','lng'=>'120.314374','lat'=>'23.194652']);
        $this->insert('{{%region}}',['id'=>'3433','pid'=>'3416','shortname'=>'大内','name'=>'大内区','merger_name'=>'中国,台湾省,台南市,大内区','level'=>'3','pinyin'=>'dana','code'=>'06','zip_code'=>'742','first'=>'D','lng'=>'120.348853','lat'=>'23.119460']);
        $this->insert('{{%region}}',['id'=>'3434','pid'=>'3416','shortname'=>'佳里','name'=>'佳里区','merger_name'=>'中国,台湾省,台南市,佳里区','level'=>'3','pinyin'=>'jiali','code'=>'06','zip_code'=>'722','first'=>'J','lng'=>'120.177211','lat'=>'23.165121']);
        $this->insert('{{%region}}',['id'=>'3435','pid'=>'3416','shortname'=>'学甲','name'=>'学甲区','merger_name'=>'中国,台湾省,台南市,学甲区','level'=>'3','pinyin'=>'xuejia','code'=>'06','zip_code'=>'726','first'=>'X','lng'=>'120.180255','lat'=>'23.232348']);
        $this->insert('{{%region}}',['id'=>'3436','pid'=>'3416','shortname'=>'西港','name'=>'西港区','merger_name'=>'中国,台湾省,台南市,西港区','level'=>'3','pinyin'=>'xigang','code'=>'06','zip_code'=>'723','first'=>'X','lng'=>'120.203618','lat'=>'23.123057']);
        $this->insert('{{%region}}',['id'=>'3437','pid'=>'3416','shortname'=>'七股','name'=>'七股区','merger_name'=>'中国,台湾省,台南市,七股区','level'=>'3','pinyin'=>'qigu','code'=>'06','zip_code'=>'724','first'=>'Q','lng'=>'120.140003','lat'=>'23.140545']);
        $this->insert('{{%region}}',['id'=>'3438','pid'=>'3416','shortname'=>'将军','name'=>'将军区','merger_name'=>'中国,台湾省,台南市,将军区','level'=>'3','pinyin'=>'jiangjun','code'=>'06','zip_code'=>'725','first'=>'J','lng'=>'120.156871','lat'=>'23.199543']);
        $this->insert('{{%region}}',['id'=>'3439','pid'=>'3416','shortname'=>'北门','name'=>'北门区','merger_name'=>'中国,台湾省,台南市,北门区','level'=>'3','pinyin'=>'beimen','code'=>'06','zip_code'=>'727','first'=>'B','lng'=>'120.125821','lat'=>'23.267148']);
        $this->insert('{{%region}}',['id'=>'3440','pid'=>'3416','shortname'=>'新化','name'=>'新化区','merger_name'=>'中国,台湾省,台南市,新化区','level'=>'3','pinyin'=>'xinhua','code'=>'06','zip_code'=>'712','first'=>'X','lng'=>'120.310807','lat'=>'23.038533']);
        $this->insert('{{%region}}',['id'=>'3441','pid'=>'3416','shortname'=>'善化','name'=>'善化区','merger_name'=>'中国,台湾省,台南市,善化区','level'=>'3','pinyin'=>'shanhua','code'=>'06','zip_code'=>'741','first'=>'S','lng'=>'120.296895','lat'=>'23.132261']);
        $this->insert('{{%region}}',['id'=>'3442','pid'=>'3416','shortname'=>'新市','name'=>'新市区','merger_name'=>'中国,台湾省,台南市,新市区','level'=>'3','pinyin'=>'xinshi','code'=>'06','zip_code'=>'744','first'=>'X','lng'=>'120.295138','lat'=>'23.07897']);
        $this->insert('{{%region}}',['id'=>'3443','pid'=>'3416','shortname'=>'安定','name'=>'安定区','merger_name'=>'中国,台湾省,台南市,安定区','level'=>'3','pinyin'=>'anding','code'=>'06','zip_code'=>'745','first'=>'A','lng'=>'120.237083','lat'=>'23.121498']);
        $this->insert('{{%region}}',['id'=>'3444','pid'=>'3416','shortname'=>'山上','name'=>'山上区','merger_name'=>'中国,台湾省,台南市,山上区','level'=>'3','pinyin'=>'shanshang','code'=>'06','zip_code'=>'743','first'=>'S','lng'=>'120.352908','lat'=>'23.103223']);
        $this->insert('{{%region}}',['id'=>'3445','pid'=>'3416','shortname'=>'玉井','name'=>'玉井区','merger_name'=>'中国,台湾省,台南市,玉井区','level'=>'3','pinyin'=>'yujing','code'=>'06','zip_code'=>'714','first'=>'Y','lng'=>'120.460110','lat'=>'23.123859']);
        $this->insert('{{%region}}',['id'=>'3446','pid'=>'3416','shortname'=>'楠西','name'=>'楠西区','merger_name'=>'中国,台湾省,台南市,楠西区','level'=>'3','pinyin'=>'nanxi','code'=>'06','zip_code'=>'715','first'=>NULL,'lng'=>'120.485396','lat'=>'23.173454']);
        $this->insert('{{%region}}',['id'=>'3447','pid'=>'3416','shortname'=>'南化','name'=>'南化区','merger_name'=>'中国,台湾省,台南市,南化区','level'=>'3','pinyin'=>'nanhua','code'=>'06','zip_code'=>'716','first'=>'N','lng'=>'120.477116','lat'=>'23.042614']);
        $this->insert('{{%region}}',['id'=>'3448','pid'=>'3416','shortname'=>'左镇','name'=>'左镇区','merger_name'=>'中国,台湾省,台南市,左镇区','level'=>'3','pinyin'=>'zuozhen','code'=>'06','zip_code'=>'713','first'=>'Z','lng'=>'120.407309','lat'=>'23.057955']);
        $this->insert('{{%region}}',['id'=>'3449','pid'=>'3416','shortname'=>'仁德','name'=>'仁德区','merger_name'=>'中国,台湾省,台南市,仁德区','level'=>'3','pinyin'=>'rende','code'=>'06','zip_code'=>'717','first'=>'R','lng'=>'120.251520','lat'=>'22.972212']);
        $this->insert('{{%region}}',['id'=>'3450','pid'=>'3416','shortname'=>'归仁','name'=>'归仁区','merger_name'=>'中国,台湾省,台南市,归仁区','level'=>'3','pinyin'=>'guiren','code'=>'06','zip_code'=>'711','first'=>'G','lng'=>'120.293791','lat'=>'22.967081']);
        $this->insert('{{%region}}',['id'=>'3451','pid'=>'3416','shortname'=>'关庙','name'=>'关庙区','merger_name'=>'中国,台湾省,台南市,关庙区','level'=>'3','pinyin'=>'guanmiao','code'=>'06','zip_code'=>'718','first'=>'G','lng'=>'120.327689','lat'=>'22.962949']);
        $this->insert('{{%region}}',['id'=>'3452','pid'=>'3416','shortname'=>'龙崎','name'=>'龙崎区','merger_name'=>'中国,台湾省,台南市,龙崎区','level'=>'3','pinyin'=>'longqi','code'=>'06','zip_code'=>'719','first'=>'L','lng'=>'120.360824','lat'=>'22.965681']);
        $this->insert('{{%region}}',['id'=>'3453','pid'=>'3416','shortname'=>'永康','name'=>'永康区','merger_name'=>'中国,台湾省,台南市,永康区','level'=>'3','pinyin'=>'yongkang','code'=>'06','zip_code'=>'710','first'=>'Y','lng'=>'120.257069','lat'=>'23.026061']);
        $this->insert('{{%region}}',['id'=>'3454','pid'=>'3325','shortname'=>'新竹','name'=>'新竹市','merger_name'=>'中国,台湾省,新竹市','level'=>'2','pinyin'=>'hsinchu','code'=>'03','zip_code'=>'3','first'=>'X','lng'=>'120.968798','lat'=>'24.806738']);
        $this->insert('{{%region}}',['id'=>'3455','pid'=>'3454','shortname'=>'东区','name'=>'东区','merger_name'=>'中国,台湾省,新竹市,东区','level'=>'3','pinyin'=>'dongqu','code'=>'03','zip_code'=>'300','first'=>'D','lng'=>'120.970239','lat'=>'24.801337']);
        $this->insert('{{%region}}',['id'=>'3456','pid'=>'3454','shortname'=>'北区','name'=>'北区','merger_name'=>'中国,台湾省,新竹市,北区','level'=>'3','pinyin'=>'beiqu','code'=>'03','zip_code'=>'','first'=>'B','lng'=>'120.682410','lat'=>'24.166040']);
        $this->insert('{{%region}}',['id'=>'3457','pid'=>'3454','shortname'=>'香山','name'=>'香山区','merger_name'=>'中国,台湾省,新竹市,香山区','level'=>'3','pinyin'=>'xiangshan','code'=>'03','zip_code'=>'','first'=>'X','lng'=>'120.956679','lat'=>'24.768933']);
        $this->insert('{{%region}}',['id'=>'3458','pid'=>'3325','shortname'=>'嘉义','name'=>'嘉义市','merger_name'=>'中国,台湾省,嘉义市','level'=>'2','pinyin'=>'chiayi','code'=>'05','zip_code'=>'6','first'=>'J','lng'=>'120.452538','lat'=>'23.481568']);
        $this->insert('{{%region}}',['id'=>'3459','pid'=>'3458','shortname'=>'东区','name'=>'东区','merger_name'=>'中国,台湾省,嘉义市,东区','level'=>'3','pinyin'=>'dongqu','code'=>'05','zip_code'=>'600','first'=>'D','lng'=>'120.458009','lat'=>'23.486213']);
        $this->insert('{{%region}}',['id'=>'3460','pid'=>'3458','shortname'=>'西区','name'=>'西区','merger_name'=>'中国,台湾省,嘉义市,西区','level'=>'3','pinyin'=>'xiqu','code'=>'05','zip_code'=>'600','first'=>'X','lng'=>'120.437493','lat'=>'23.473029']);
        $this->insert('{{%region}}',['id'=>'3461','pid'=>'3325','shortname'=>'新北','name'=>'新北市','merger_name'=>'中国,台湾省,新北市','level'=>'2','pinyin'=>'newtaipei','code'=>'02','zip_code'=>'2','first'=>'X','lng'=>'121.465746','lat'=>'25.012366']);
        $this->insert('{{%region}}',['id'=>'3462','pid'=>'3461','shortname'=>'板桥','name'=>'板桥区','merger_name'=>'中国,台湾省,新北市,板桥区','level'=>'3','pinyin'=>'banqiao','code'=>'02','zip_code'=>'220','first'=>'B','lng'=>'121.459084','lat'=>'25.009578']);
        $this->insert('{{%region}}',['id'=>'3463','pid'=>'3461','shortname'=>'三重','name'=>'三重区','merger_name'=>'中国,台湾省,新北市,三重区','level'=>'3','pinyin'=>'sanzhong','code'=>'02','zip_code'=>'241','first'=>'S','lng'=>'121.488102','lat'=>'25.061486']);
        $this->insert('{{%region}}',['id'=>'3464','pid'=>'3461','shortname'=>'中和','name'=>'中和区','merger_name'=>'中国,台湾省,新北市,中和区','level'=>'3','pinyin'=>'zhonghe','code'=>'02','zip_code'=>'235','first'=>'Z','lng'=>'121.498980','lat'=>'24.999397']);
        $this->insert('{{%region}}',['id'=>'3465','pid'=>'3461','shortname'=>'永和','name'=>'永和区','merger_name'=>'中国,台湾省,新北市,永和区','level'=>'3','pinyin'=>'yonghe','code'=>'02','zip_code'=>'234','first'=>'Y','lng'=>'121.513660','lat'=>'25.007802']);
        $this->insert('{{%region}}',['id'=>'3466','pid'=>'3461','shortname'=>'新庄','name'=>'新庄区','merger_name'=>'中国,台湾省,新北市,新庄区','level'=>'3','pinyin'=>'xinzhuang','code'=>'02','zip_code'=>'242','first'=>'X','lng'=>'121.450413','lat'=>'25.035947']);
        $this->insert('{{%region}}',['id'=>'3467','pid'=>'3461','shortname'=>'新店','name'=>'新店区','merger_name'=>'中国,台湾省,新北市,新店区','level'=>'3','pinyin'=>'xindian','code'=>'02','zip_code'=>'231','first'=>'X','lng'=>'121.541750','lat'=>'24.967558']);
        $this->insert('{{%region}}',['id'=>'3468','pid'=>'3461','shortname'=>'树林','name'=>'树林区','merger_name'=>'中国,台湾省,新北市,树林区','level'=>'3','pinyin'=>'shulin','code'=>'02','zip_code'=>'238','first'=>'S','lng'=>'121.420533','lat'=>'24.990706']);
        $this->insert('{{%region}}',['id'=>'3469','pid'=>'3461','shortname'=>'莺歌','name'=>'莺歌区','merger_name'=>'中国,台湾省,新北市,莺歌区','level'=>'3','pinyin'=>'yingge','code'=>'02','zip_code'=>'239','first'=>NULL,'lng'=>'121.354573','lat'=>'24.955413']);
        $this->insert('{{%region}}',['id'=>'3470','pid'=>'3461','shortname'=>'三峡','name'=>'三峡区','merger_name'=>'中国,台湾省,新北市,三峡区','level'=>'3','pinyin'=>'sanxia','code'=>'02','zip_code'=>'237','first'=>'S','lng'=>'121.368905','lat'=>'24.934339']);
        $this->insert('{{%region}}',['id'=>'3471','pid'=>'3461','shortname'=>'淡水','name'=>'淡水区','merger_name'=>'中国,台湾省,新北市,淡水区','level'=>'3','pinyin'=>'danshui','code'=>'02','zip_code'=>'251','first'=>'D','lng'=>'121.440915','lat'=>'25.169452']);
        $this->insert('{{%region}}',['id'=>'3472','pid'=>'3461','shortname'=>'汐止','name'=>'汐止区','merger_name'=>'中国,台湾省,新北市,汐止区','level'=>'3','pinyin'=>'xizhi','code'=>'02','zip_code'=>'221','first'=>'X','lng'=>'121.629470','lat'=>'25.062999']);
        $this->insert('{{%region}}',['id'=>'3473','pid'=>'3461','shortname'=>'瑞芳','name'=>'瑞芳区','merger_name'=>'中国,台湾省,新北市,瑞芳区','level'=>'3','pinyin'=>'ruifang','code'=>'02','zip_code'=>'224','first'=>'R','lng'=>'121.810061','lat'=>'25.108895']);
        $this->insert('{{%region}}',['id'=>'3474','pid'=>'3461','shortname'=>'土城','name'=>'土城区','merger_name'=>'中国,台湾省,新北市,土城区','level'=>'3','pinyin'=>'tucheng','code'=>'02','zip_code'=>'236','first'=>'T','lng'=>'121.443348','lat'=>'24.972201']);
        $this->insert('{{%region}}',['id'=>'3475','pid'=>'3461','shortname'=>'芦洲','name'=>'芦洲区','merger_name'=>'中国,台湾省,新北市,芦洲区','level'=>'3','pinyin'=>'luzhou','code'=>'02','zip_code'=>'247','first'=>'L','lng'=>'121.473700','lat'=>'25.084923']);
        $this->insert('{{%region}}',['id'=>'3476','pid'=>'3461','shortname'=>'五股','name'=>'五股区','merger_name'=>'中国,台湾省,新北市,五股区','level'=>'3','pinyin'=>'wugu','code'=>'02','zip_code'=>'248','first'=>'W','lng'=>'121.438156','lat'=>'25.082743']);
        $this->insert('{{%region}}',['id'=>'3477','pid'=>'3461','shortname'=>'泰山','name'=>'泰山区','merger_name'=>'中国,台湾省,新北市,泰山区','level'=>'3','pinyin'=>'taishan','code'=>'02','zip_code'=>'243','first'=>'T','lng'=>'121.430811','lat'=>'25.058864']);
        $this->insert('{{%region}}',['id'=>'3478','pid'=>'3461','shortname'=>'林口','name'=>'林口区','merger_name'=>'中国,台湾省,新北市,林口区','level'=>'3','pinyin'=>'linkou','code'=>'02','zip_code'=>'244','first'=>'L','lng'=>'121.391602','lat'=>'25.077531']);
        $this->insert('{{%region}}',['id'=>'3479','pid'=>'3461','shortname'=>'深坑','name'=>'深坑区','merger_name'=>'中国,台湾省,新北市,深坑区','level'=>'3','pinyin'=>'shenkeng','code'=>'02','zip_code'=>'222','first'=>'S','lng'=>'121.615670','lat'=>'25.002329']);
        $this->insert('{{%region}}',['id'=>'3480','pid'=>'3461','shortname'=>'石碇','name'=>'石碇区','merger_name'=>'中国,台湾省,新北市,石碇区','level'=>'3','pinyin'=>'shiding','code'=>'02','zip_code'=>'223','first'=>'S','lng'=>'121.658567','lat'=>'24.991679']);
        $this->insert('{{%region}}',['id'=>'3481','pid'=>'3461','shortname'=>'坪林','name'=>'坪林区','merger_name'=>'中国,台湾省,新北市,坪林区','level'=>'3','pinyin'=>'pinglin','code'=>'02','zip_code'=>'232','first'=>'P','lng'=>'121.711185','lat'=>'24.937388']);
        $this->insert('{{%region}}',['id'=>'3482','pid'=>'3461','shortname'=>'三芝','name'=>'三芝区','merger_name'=>'中国,台湾省,新北市,三芝区','level'=>'3','pinyin'=>'sanzhi','code'=>'02','zip_code'=>'252','first'=>'S','lng'=>'121.500866','lat'=>'25.258047']);
        $this->insert('{{%region}}',['id'=>'3483','pid'=>'3461','shortname'=>'石门','name'=>'石门区','merger_name'=>'中国,台湾省,新北市,石门区','level'=>'3','pinyin'=>'shimen','code'=>'02','zip_code'=>'253','first'=>'S','lng'=>'121.568491','lat'=>'25.290412']);
        $this->insert('{{%region}}',['id'=>'3484','pid'=>'3461','shortname'=>'八里','name'=>'八里区','merger_name'=>'中国,台湾省,新北市,八里区','level'=>'3','pinyin'=>'bali','code'=>'02','zip_code'=>'249','first'=>'B','lng'=>'121.398227','lat'=>'25.146680']);
        $this->insert('{{%region}}',['id'=>'3485','pid'=>'3461','shortname'=>'平溪','name'=>'平溪区','merger_name'=>'中国,台湾省,新北市,平溪区','level'=>'3','pinyin'=>'pingxi','code'=>'02','zip_code'=>'226','first'=>'P','lng'=>'121.738255','lat'=>'25.025725']);
        $this->insert('{{%region}}',['id'=>'3486','pid'=>'3461','shortname'=>'双溪','name'=>'双溪区','merger_name'=>'中国,台湾省,新北市,双溪区','level'=>'3','pinyin'=>'shuangxi','code'=>'02','zip_code'=>'227','first'=>'S','lng'=>'121.865676','lat'=>'25.033409']);
        $this->insert('{{%region}}',['id'=>'3487','pid'=>'3461','shortname'=>'贡寮','name'=>'贡寮区','merger_name'=>'中国,台湾省,新北市,贡寮区','level'=>'3','pinyin'=>'gongliao','code'=>'02','zip_code'=>'228','first'=>'G','lng'=>'121.908185','lat'=>'25.022388']);
        $this->insert('{{%region}}',['id'=>'3488','pid'=>'3461','shortname'=>'金山','name'=>'金山区','merger_name'=>'中国,台湾省,新北市,金山区','level'=>'3','pinyin'=>'jinshan','code'=>'02','zip_code'=>'208','first'=>'J','lng'=>'121.636427','lat'=>'25.221883']);
        $this->insert('{{%region}}',['id'=>'3489','pid'=>'3461','shortname'=>'万里','name'=>'万里区','merger_name'=>'中国,台湾省,新北市,万里区','level'=>'3','pinyin'=>'wanli','code'=>'02','zip_code'=>'207','first'=>'W','lng'=>'121.688687','lat'=>'25.181234']);
        $this->insert('{{%region}}',['id'=>'3490','pid'=>'3461','shortname'=>'乌来','name'=>'乌来区','merger_name'=>'中国,台湾省,新北市,乌来区','level'=>'3','pinyin'=>'wulai','code'=>'02','zip_code'=>'233','first'=>'W','lng'=>'121.550531','lat'=>'24.865296']);
        $this->insert('{{%region}}',['id'=>'3491','pid'=>'3325','shortname'=>'宜兰','name'=>'宜兰县','merger_name'=>'中国,台湾省,宜兰县','level'=>'2','pinyin'=>'yilan','code'=>'03','zip_code'=>'2','first'=>'Y','lng'=>'121.500000','lat'=>'24.600000']);
        $this->insert('{{%region}}',['id'=>'3492','pid'=>'3491','shortname'=>'宜兰','name'=>'宜兰市','merger_name'=>'中国,台湾省,宜兰县,宜兰市','level'=>'3','pinyin'=>'yilan','code'=>'03','zip_code'=>'260','first'=>'Y','lng'=>'121.753476','lat'=>'24.751682']);
        $this->insert('{{%region}}',['id'=>'3493','pid'=>'3491','shortname'=>'罗东','name'=>'罗东镇','merger_name'=>'中国,台湾省,宜兰县,罗东镇','level'=>'3','pinyin'=>'luodong','code'=>'03','zip_code'=>'265','first'=>'L','lng'=>'121.766919','lat'=>'24.677033']);
        $this->insert('{{%region}}',['id'=>'3494','pid'=>'3491','shortname'=>'苏澳','name'=>'苏澳镇','merger_name'=>'中国,台湾省,宜兰县,苏澳镇','level'=>'3','pinyin'=>'suao','code'=>'03','zip_code'=>'270','first'=>'S','lng'=>'121.842656','lat'=>'24.594622']);
        $this->insert('{{%region}}',['id'=>'3495','pid'=>'3491','shortname'=>'头城','name'=>'头城镇','merger_name'=>'中国,台湾省,宜兰县,头城镇','level'=>'3','pinyin'=>'toucheng','code'=>'03','zip_code'=>'261','first'=>'T','lng'=>'121.823307','lat'=>'24.859217']);
        $this->insert('{{%region}}',['id'=>'3496','pid'=>'3491','shortname'=>'礁溪','name'=>'礁溪乡','merger_name'=>'中国,台湾省,宜兰县,礁溪乡','level'=>'3','pinyin'=>'jiaoxi','code'=>'03','zip_code'=>'262','first'=>'J','lng'=>'121.766680','lat'=>'24.822345']);
        $this->insert('{{%region}}',['id'=>'3497','pid'=>'3491','shortname'=>'壮围','name'=>'壮围乡','merger_name'=>'中国,台湾省,宜兰县,壮围乡','level'=>'3','pinyin'=>'zhuangwei','code'=>'03','zip_code'=>'263','first'=>'Z','lng'=>'121.781619','lat'=>'24.744949']);
        $this->insert('{{%region}}',['id'=>'3498','pid'=>'3491','shortname'=>'员山','name'=>'员山乡','merger_name'=>'中国,台湾省,宜兰县,员山乡','level'=>'3','pinyin'=>'yuanshan','code'=>'03','zip_code'=>'264','first'=>'Y','lng'=>'121.721733','lat'=>'24.741771']);
        $this->insert('{{%region}}',['id'=>'3499','pid'=>'3491','shortname'=>'冬山','name'=>'冬山乡','merger_name'=>'中国,台湾省,宜兰县,冬山乡','level'=>'3','pinyin'=>'dongshan','code'=>'03','zip_code'=>'269','first'=>'D','lng'=>'121.792280','lat'=>'24.634514']);
        $this->insert('{{%region}}',['id'=>'3500','pid'=>'3491','shortname'=>'五结','name'=>'五结乡','merger_name'=>'中国,台湾省,宜兰县,五结乡','level'=>'3','pinyin'=>'wujie','code'=>'03','zip_code'=>'268','first'=>'W','lng'=>'121.798297','lat'=>'24.684640']);
        $this->insert('{{%region}}',['id'=>'3501','pid'=>'3491','shortname'=>'三星','name'=>'三星乡','merger_name'=>'中国,台湾省,宜兰县,三星乡','level'=>'3','pinyin'=>'sanxing','code'=>'03','zip_code'=>'266','first'=>'S','lng'=>'121.003418','lat'=>'23.775291']);
        $this->insert('{{%region}}',['id'=>'3502','pid'=>'3491','shortname'=>'大同','name'=>'大同乡','merger_name'=>'中国,台湾省,宜兰县,大同乡','level'=>'3','pinyin'=>'datong','code'=>'03','zip_code'=>'267','first'=>'D','lng'=>'121.605557','lat'=>'24.675997']);
        $this->insert('{{%region}}',['id'=>'3503','pid'=>'3491','shortname'=>'南澳','name'=>'南澳乡','merger_name'=>'中国,台湾省,宜兰县,南澳乡','level'=>'3','pinyin'=>'nanao','code'=>'03','zip_code'=>'272','first'=>'N','lng'=>'121.799810','lat'=>'24.465393']);
        $this->insert('{{%region}}',['id'=>'3504','pid'=>'3325','shortname'=>'桃园','name'=>'桃园县','merger_name'=>'中国,台湾省,桃园县','level'=>'2','pinyin'=>'taoyuan','code'=>'03','zip_code'=>'3','first'=>'T','lng'=>'121.083000','lat'=>'25.000000']);
        $this->insert('{{%region}}',['id'=>'3505','pid'=>'3504','shortname'=>'桃园','name'=>'桃园市','merger_name'=>'中国,台湾省,桃园县,桃园市','level'=>'3','pinyin'=>'taoyuan','code'=>'03','zip_code'=>'330','first'=>'T','lng'=>'121.301337','lat'=>'24.993777']);
        $this->insert('{{%region}}',['id'=>'3506','pid'=>'3504','shortname'=>'中坜','name'=>'中坜市','merger_name'=>'中国,台湾省,桃园县,中坜市','level'=>'3','pinyin'=>'zhongli','code'=>'03','zip_code'=>'320','first'=>'Z','lng'=>'121.224926','lat'=>'24.965353']);
        $this->insert('{{%region}}',['id'=>'3507','pid'=>'3504','shortname'=>'平镇','name'=>'平镇市','merger_name'=>'中国,台湾省,桃园县,平镇市','level'=>'3','pinyin'=>'pingzhen','code'=>'03','zip_code'=>'324','first'=>'P','lng'=>'121.218359','lat'=>'24.945752']);
        $this->insert('{{%region}}',['id'=>'3508','pid'=>'3504','shortname'=>'八德','name'=>'八德市','merger_name'=>'中国,台湾省,桃园县,八德市','level'=>'3','pinyin'=>'bade','code'=>'03','zip_code'=>'334','first'=>'B','lng'=>'121.284655','lat'=>'24.928651']);
        $this->insert('{{%region}}',['id'=>'3509','pid'=>'3504','shortname'=>'杨梅','name'=>'杨梅市','merger_name'=>'中国,台湾省,桃园县,杨梅市','level'=>'3','pinyin'=>'yangmei','code'=>'03','zip_code'=>'326','first'=>'Y','lng'=>'121.145873','lat'=>'24.907575']);
        $this->insert('{{%region}}',['id'=>'3510','pid'=>'3504','shortname'=>'芦竹','name'=>'芦竹市','merger_name'=>'中国,台湾省,桃园县,芦竹市','level'=>'3','pinyin'=>'luzhu','code'=>'03','zip_code'=>'338','first'=>'L','lng'=>'121.292064','lat'=>'25.045392']);
        $this->insert('{{%region}}',['id'=>'3511','pid'=>'3504','shortname'=>'大溪','name'=>'大溪镇','merger_name'=>'中国,台湾省,桃园县,大溪镇','level'=>'3','pinyin'=>'daxi','code'=>'03','zip_code'=>'335','first'=>'D','lng'=>'121.286962','lat'=>'24.880584']);
        $this->insert('{{%region}}',['id'=>'3512','pid'=>'3504','shortname'=>'大园','name'=>'大园乡','merger_name'=>'中国,台湾省,桃园县,大园乡','level'=>'3','pinyin'=>'dayuan','code'=>'03','zip_code'=>'337','first'=>'D','lng'=>'121.196292','lat'=>'25.064471']);
        $this->insert('{{%region}}',['id'=>'3513','pid'=>'3504','shortname'=>'龟山','name'=>'龟山乡','merger_name'=>'中国,台湾省,桃园县,龟山乡','level'=>'3','pinyin'=>'guishan','code'=>'03','zip_code'=>'333','first'=>'G','lng'=>'121.337767','lat'=>'24.992517']);
        $this->insert('{{%region}}',['id'=>'3514','pid'=>'3504','shortname'=>'龙潭','name'=>'龙潭乡','merger_name'=>'中国,台湾省,桃园县,龙潭乡','level'=>'3','pinyin'=>'longtan','code'=>'03','zip_code'=>'325','first'=>'L','lng'=>'121.216392','lat'=>'24.863851']);
        $this->insert('{{%region}}',['id'=>'3515','pid'=>'3504','shortname'=>'新屋','name'=>'新屋乡','merger_name'=>'中国,台湾省,桃园县,新屋乡','level'=>'3','pinyin'=>'xinwu','code'=>'03','zip_code'=>'327','first'=>'X','lng'=>'121.105801','lat'=>'24.972203']);
        $this->insert('{{%region}}',['id'=>'3516','pid'=>'3504','shortname'=>'观音','name'=>'观音乡','merger_name'=>'中国,台湾省,桃园县,观音乡','level'=>'3','pinyin'=>'guanyin','code'=>'03','zip_code'=>'328','first'=>'G','lng'=>'121.077519','lat'=>'25.033303']);
        $this->insert('{{%region}}',['id'=>'3517','pid'=>'3504','shortname'=>'复兴','name'=>'复兴乡','merger_name'=>'中国,台湾省,桃园县,复兴乡','level'=>'3','pinyin'=>'fuxing','code'=>'03','zip_code'=>'336','first'=>'F','lng'=>'121.352613','lat'=>'24.820908']);
        $this->insert('{{%region}}',['id'=>'3518','pid'=>'3325','shortname'=>'新竹','name'=>'新竹县','merger_name'=>'中国,台湾省,新竹县','level'=>'2','pinyin'=>'hsinchu','code'=>'03','zip_code'=>'3','first'=>'X','lng'=>'121.160000','lat'=>'24.600000']);
        $this->insert('{{%region}}',['id'=>'3519','pid'=>'3518','shortname'=>'竹北','name'=>'竹北市','merger_name'=>'中国,台湾省,新竹县,竹北市','level'=>'3','pinyin'=>'zhubei','code'=>'03','zip_code'=>'302','first'=>'Z','lng'=>'121.004317','lat'=>'24.839652']);
        $this->insert('{{%region}}',['id'=>'3520','pid'=>'3518','shortname'=>'竹东','name'=>'竹东镇','merger_name'=>'中国,台湾省,新竹县,竹东镇','level'=>'3','pinyin'=>'zhudong','code'=>'03','zip_code'=>'310','first'=>'Z','lng'=>'121.086418','lat'=>'24.733601']);
        $this->insert('{{%region}}',['id'=>'3521','pid'=>'3518','shortname'=>'新埔','name'=>'新埔镇','merger_name'=>'中国,台湾省,新竹县,新埔镇','level'=>'3','pinyin'=>'xinpu','code'=>'03','zip_code'=>'305','first'=>'X','lng'=>'121.072804','lat'=>'24.824820']);
        $this->insert('{{%region}}',['id'=>'3522','pid'=>'3518','shortname'=>'关西','name'=>'关西镇','merger_name'=>'中国,台湾省,新竹县,关西镇','level'=>'3','pinyin'=>'guanxi','code'=>'03','zip_code'=>'306','first'=>'G','lng'=>'121.177301','lat'=>'24.788842']);
        $this->insert('{{%region}}',['id'=>'3523','pid'=>'3518','shortname'=>'湖口','name'=>'湖口乡','merger_name'=>'中国,台湾省,新竹县,湖口乡','level'=>'3','pinyin'=>'hukou','code'=>'03','zip_code'=>'303','first'=>'H','lng'=>'121.043691','lat'=>'24.903943']);
        $this->insert('{{%region}}',['id'=>'3524','pid'=>'3518','shortname'=>'新丰','name'=>'新丰乡','merger_name'=>'中国,台湾省,新竹县,新丰乡','level'=>'3','pinyin'=>'xinfeng','code'=>'03','zip_code'=>'304','first'=>'X','lng'=>'120.983006','lat'=>'24.899600']);
        $this->insert('{{%region}}',['id'=>'3525','pid'=>'3518','shortname'=>'芎林','name'=>'芎林乡','merger_name'=>'中国,台湾省,新竹县,芎林乡','level'=>'3','pinyin'=>'xionglin','code'=>'03','zip_code'=>'307','first'=>NULL,'lng'=>'121.076924','lat'=>'24.774436']);
        $this->insert('{{%region}}',['id'=>'3526','pid'=>'3518','shortname'=>'横山','name'=>'横山乡','merger_name'=>'中国,台湾省,新竹县,横山乡','level'=>'3','pinyin'=>'hengshan','code'=>'03','zip_code'=>'312','first'=>'H','lng'=>'121.116244','lat'=>'24.720807']);
        $this->insert('{{%region}}',['id'=>'3527','pid'=>'3518','shortname'=>'北埔','name'=>'北埔乡','merger_name'=>'中国,台湾省,新竹县,北埔乡','level'=>'3','pinyin'=>'beipu','code'=>'03','zip_code'=>'314','first'=>'B','lng'=>'121.053156','lat'=>'24.697126']);
        $this->insert('{{%region}}',['id'=>'3528','pid'=>'3518','shortname'=>'宝山','name'=>'宝山乡','merger_name'=>'中国,台湾省,新竹县,宝山乡','level'=>'3','pinyin'=>'baoshan','code'=>'03','zip_code'=>'308','first'=>'B','lng'=>'120.985752','lat'=>'24.760975']);
        $this->insert('{{%region}}',['id'=>'3529','pid'=>'3518','shortname'=>'峨眉','name'=>'峨眉乡','merger_name'=>'中国,台湾省,新竹县,峨眉乡','level'=>'3','pinyin'=>'emei','code'=>'03','zip_code'=>'315','first'=>'E','lng'=>'121.015291','lat'=>'24.686127']);
        $this->insert('{{%region}}',['id'=>'3530','pid'=>'3518','shortname'=>'尖石','name'=>'尖石乡','merger_name'=>'中国,台湾省,新竹县,尖石乡','level'=>'3','pinyin'=>'jianshi','code'=>'03','zip_code'=>'313','first'=>'J','lng'=>'121.197802','lat'=>'24.704360']);
        $this->insert('{{%region}}',['id'=>'3531','pid'=>'3518','shortname'=>'五峰','name'=>'五峰乡','merger_name'=>'中国,台湾省,新竹县,五峰乡','level'=>'3','pinyin'=>'wufeng','code'=>'03','zip_code'=>'311','first'=>'W','lng'=>'121.003418','lat'=>'23.775291']);
        $this->insert('{{%region}}',['id'=>'3532','pid'=>'3325','shortname'=>'苗栗','name'=>'苗栗县','merger_name'=>'中国,台湾省,苗栗县','level'=>'2','pinyin'=>'miaoli','code'=>'037','zip_code'=>'3','first'=>'M','lng'=>'120.750000','lat'=>'24.500000']);
        $this->insert('{{%region}}',['id'=>'3533','pid'=>'3532','shortname'=>'苗栗','name'=>'苗栗市','merger_name'=>'中国,台湾省,苗栗县,苗栗市','level'=>'3','pinyin'=>'miaoli','code'=>'037','zip_code'=>'360','first'=>'M','lng'=>'120.818869','lat'=>'24.561472']);
        $this->insert('{{%region}}',['id'=>'3534','pid'=>'3532','shortname'=>'苑里','name'=>'苑里镇','merger_name'=>'中国,台湾省,苗栗县,苑里镇','level'=>'3','pinyin'=>'yuanli','code'=>'037','zip_code'=>'358','first'=>'Y','lng'=>'120.648907','lat'=>'24.441750']);
        $this->insert('{{%region}}',['id'=>'3535','pid'=>'3532','shortname'=>'通霄','name'=>'通霄镇','merger_name'=>'中国,台湾省,苗栗县,通霄镇','level'=>'3','pinyin'=>'tongxiao','code'=>'037','zip_code'=>'357','first'=>'T','lng'=>'120.676700','lat'=>'24.489087']);
        $this->insert('{{%region}}',['id'=>'3536','pid'=>'3532','shortname'=>'竹南','name'=>'竹南镇','merger_name'=>'中国,台湾省,苗栗县,竹南镇','level'=>'3','pinyin'=>'zhunan','code'=>'037','zip_code'=>'350','first'=>'Z','lng'=>'120.872641','lat'=>'24.685513']);
        $this->insert('{{%region}}',['id'=>'3537','pid'=>'3532','shortname'=>'头份','name'=>'头份镇','merger_name'=>'中国,台湾省,苗栗县,头份镇','level'=>'3','pinyin'=>'toufen','code'=>'037','zip_code'=>'351','first'=>'T','lng'=>'120.895188','lat'=>'24.687993']);
        $this->insert('{{%region}}',['id'=>'3538','pid'=>'3532','shortname'=>'后龙','name'=>'后龙镇','merger_name'=>'中国,台湾省,苗栗县,后龙镇','level'=>'3','pinyin'=>'houlong','code'=>'037','zip_code'=>'356','first'=>'H','lng'=>'120.786480','lat'=>'24.612617']);
        $this->insert('{{%region}}',['id'=>'3539','pid'=>'3532','shortname'=>'卓兰','name'=>'卓兰镇','merger_name'=>'中国,台湾省,苗栗县,卓兰镇','level'=>'3','pinyin'=>'zhuolan','code'=>'037','zip_code'=>'369','first'=>'Z','lng'=>'120.823441','lat'=>'24.309509']);
        $this->insert('{{%region}}',['id'=>'3540','pid'=>'3532','shortname'=>'大湖','name'=>'大湖乡','merger_name'=>'中国,台湾省,苗栗县,大湖乡','level'=>'3','pinyin'=>'dahu','code'=>'037','zip_code'=>'364','first'=>'D','lng'=>'120.863641','lat'=>'24.422547']);
        $this->insert('{{%region}}',['id'=>'3541','pid'=>'3532','shortname'=>'公馆','name'=>'公馆乡','merger_name'=>'中国,台湾省,苗栗县,公馆乡','level'=>'3','pinyin'=>'gongguan','code'=>'037','zip_code'=>'363','first'=>'G','lng'=>'120.822983','lat'=>'24.499108']);
        $this->insert('{{%region}}',['id'=>'3542','pid'=>'3532','shortname'=>'铜锣','name'=>'铜锣乡','merger_name'=>'中国,台湾省,苗栗县,铜锣乡','level'=>'3','pinyin'=>'tongluo','code'=>'037','zip_code'=>'366','first'=>'T','lng'=>'121.003418','lat'=>'23.775291']);
        $this->insert('{{%region}}',['id'=>'3543','pid'=>'3532','shortname'=>'南庄','name'=>'南庄乡','merger_name'=>'中国,台湾省,苗栗县,南庄乡','level'=>'3','pinyin'=>'nanzhuang','code'=>'037','zip_code'=>'353','first'=>'N','lng'=>'120.994957','lat'=>'24.596835']);
        $this->insert('{{%region}}',['id'=>'3544','pid'=>'3532','shortname'=>'头屋','name'=>'头屋乡','merger_name'=>'中国,台湾省,苗栗县,头屋乡','level'=>'3','pinyin'=>'touwu','code'=>'037','zip_code'=>'362','first'=>'T','lng'=>'120.846616','lat'=>'24.574249']);
        $this->insert('{{%region}}',['id'=>'3545','pid'=>'3532','shortname'=>'三义','name'=>'三义乡','merger_name'=>'中国,台湾省,苗栗县,三义乡','level'=>'3','pinyin'=>'sanyi','code'=>'037','zip_code'=>'367','first'=>'S','lng'=>'120.742340','lat'=>'24.350270']);
        $this->insert('{{%region}}',['id'=>'3546','pid'=>'3532','shortname'=>'西湖','name'=>'西湖乡','merger_name'=>'中国,台湾省,苗栗县,西湖乡','level'=>'3','pinyin'=>'xihu','code'=>'037','zip_code'=>'368','first'=>'X','lng'=>'121.003418','lat'=>'23.775291']);
        $this->insert('{{%region}}',['id'=>'3547','pid'=>'3532','shortname'=>'造桥','name'=>'造桥乡','merger_name'=>'中国,台湾省,苗栗县,造桥乡','level'=>'3','pinyin'=>'zaoqiao','code'=>'037','zip_code'=>'361','first'=>'Z','lng'=>'120.862399','lat'=>'24.637537']);
        $this->insert('{{%region}}',['id'=>'3548','pid'=>'3532','shortname'=>'三湾','name'=>'三湾乡','merger_name'=>'中国,台湾省,苗栗县,三湾乡','level'=>'3','pinyin'=>'sanwan','code'=>'037','zip_code'=>'352','first'=>'S','lng'=>'120.951484','lat'=>'24.651051']);
        $this->insert('{{%region}}',['id'=>'3549','pid'=>'3532','shortname'=>'狮潭','name'=>'狮潭乡','merger_name'=>'中国,台湾省,苗栗县,狮潭乡','level'=>'3','pinyin'=>'shitan','code'=>'037','zip_code'=>'354','first'=>'S','lng'=>'120.918024','lat'=>'24.540004']);
        $this->insert('{{%region}}',['id'=>'3550','pid'=>'3532','shortname'=>'泰安','name'=>'泰安乡','merger_name'=>'中国,台湾省,苗栗县,泰安乡','level'=>'3','pinyin'=>'tai\'an','code'=>'037','zip_code'=>'365','first'=>'T','lng'=>'120.904441','lat'=>'24.442600']);
        $this->insert('{{%region}}',['id'=>'3551','pid'=>'3325','shortname'=>'彰化','name'=>'彰化县','merger_name'=>'中国,台湾省,彰化县','level'=>'2','pinyin'=>'changhua','code'=>'04','zip_code'=>'5','first'=>'Z','lng'=>'120.416000','lat'=>'24.000000']);
        $this->insert('{{%region}}',['id'=>'3552','pid'=>'3551','shortname'=>'彰化市','name'=>'彰化市','merger_name'=>'中国,台湾省,彰化县,彰化市','level'=>'3','pinyin'=>'zhanghuashi','code'=>'04','zip_code'=>'500','first'=>'Z','lng'=>'120.542294','lat'=>'24.080911']);
        $this->insert('{{%region}}',['id'=>'3553','pid'=>'3551','shortname'=>'鹿港','name'=>'鹿港镇','merger_name'=>'中国,台湾省,彰化县,鹿港镇','level'=>'3','pinyin'=>'lugang','code'=>'04','zip_code'=>'505','first'=>'L','lng'=>'120.435392','lat'=>'24.056937']);
        $this->insert('{{%region}}',['id'=>'3554','pid'=>'3551','shortname'=>'和美','name'=>'和美镇','merger_name'=>'中国,台湾省,彰化县,和美镇','level'=>'3','pinyin'=>'hemei','code'=>'04','zip_code'=>'508','first'=>'H','lng'=>'120.500265','lat'=>'24.110904']);
        $this->insert('{{%region}}',['id'=>'3555','pid'=>'3551','shortname'=>'线西','name'=>'线西乡','merger_name'=>'中国,台湾省,彰化县,线西乡','level'=>'3','pinyin'=>'xianxi','code'=>'04','zip_code'=>'507','first'=>'X','lng'=>'120.465921','lat'=>'24.128653']);
        $this->insert('{{%region}}',['id'=>'3556','pid'=>'3551','shortname'=>'伸港','name'=>'伸港乡','merger_name'=>'中国,台湾省,彰化县,伸港乡','level'=>'3','pinyin'=>'shengang','code'=>'04','zip_code'=>'509','first'=>'S','lng'=>'120.484224','lat'=>'24.146081']);
        $this->insert('{{%region}}',['id'=>'3557','pid'=>'3551','shortname'=>'福兴','name'=>'福兴乡','merger_name'=>'中国,台湾省,彰化县,福兴乡','level'=>'3','pinyin'=>'fuxing','code'=>'04','zip_code'=>'506','first'=>'F','lng'=>'120.443682','lat'=>'24.047883']);
        $this->insert('{{%region}}',['id'=>'3558','pid'=>'3551','shortname'=>'秀水','name'=>'秀水乡','merger_name'=>'中国,台湾省,彰化县,秀水乡','level'=>'3','pinyin'=>'xiushui','code'=>'04','zip_code'=>'504','first'=>'X','lng'=>'120.502658','lat'=>'24.035267']);
        $this->insert('{{%region}}',['id'=>'3559','pid'=>'3551','shortname'=>'花坛','name'=>'花坛乡','merger_name'=>'中国,台湾省,彰化县,花坛乡','level'=>'3','pinyin'=>'huatan','code'=>'04','zip_code'=>'503','first'=>'H','lng'=>'120.538403','lat'=>'24.029399']);
        $this->insert('{{%region}}',['id'=>'3560','pid'=>'3551','shortname'=>'芬园','name'=>'芬园乡','merger_name'=>'中国,台湾省,彰化县,芬园乡','level'=>'3','pinyin'=>'fenyuan','code'=>'04','zip_code'=>'502','first'=>'F','lng'=>'120.629024','lat'=>'24.013658']);
        $this->insert('{{%region}}',['id'=>'3561','pid'=>'3551','shortname'=>'员林','name'=>'员林镇','merger_name'=>'中国,台湾省,彰化县,员林镇','level'=>'3','pinyin'=>'yuanlin','code'=>'04','zip_code'=>'510','first'=>'Y','lng'=>'120.574625','lat'=>'23.958999']);
        $this->insert('{{%region}}',['id'=>'3562','pid'=>'3551','shortname'=>'溪湖','name'=>'溪湖镇','merger_name'=>'中国,台湾省,彰化县,溪湖镇','level'=>'3','pinyin'=>'xihu','code'=>'04','zip_code'=>'514','first'=>'X','lng'=>'120.479144','lat'=>'23.962315']);
        $this->insert('{{%region}}',['id'=>'3563','pid'=>'3551','shortname'=>'田中','name'=>'田中镇','merger_name'=>'中国,台湾省,彰化县,田中镇','level'=>'3','pinyin'=>'tianzhong','code'=>'04','zip_code'=>'520','first'=>'T','lng'=>'120.580629','lat'=>'23.861718']);
        $this->insert('{{%region}}',['id'=>'3564','pid'=>'3551','shortname'=>'大村','name'=>'大村乡','merger_name'=>'中国,台湾省,彰化县,大村乡','level'=>'3','pinyin'=>'dacun','code'=>'04','zip_code'=>'515','first'=>'D','lng'=>'120.540713','lat'=>'23.993726']);
        $this->insert('{{%region}}',['id'=>'3565','pid'=>'3551','shortname'=>'埔盐','name'=>'埔盐乡','merger_name'=>'中国,台湾省,彰化县,埔盐乡','level'=>'3','pinyin'=>'puyan','code'=>'04','zip_code'=>'516','first'=>'P','lng'=>'120.464044','lat'=>'24.000346']);
        $this->insert('{{%region}}',['id'=>'3566','pid'=>'3551','shortname'=>'埔心','name'=>'埔心乡','merger_name'=>'中国,台湾省,彰化县,埔心乡','level'=>'3','pinyin'=>'puxin','code'=>'04','zip_code'=>'513','first'=>'P','lng'=>'120.543568','lat'=>'23.953019']);
        $this->insert('{{%region}}',['id'=>'3567','pid'=>'3551','shortname'=>'永靖','name'=>'永靖乡','merger_name'=>'中国,台湾省,彰化县,永靖乡','level'=>'3','pinyin'=>'yongjing','code'=>'04','zip_code'=>'512','first'=>'Y','lng'=>'120.547775','lat'=>'23.924703']);
        $this->insert('{{%region}}',['id'=>'3568','pid'=>'3551','shortname'=>'社头','name'=>'社头乡','merger_name'=>'中国,台湾省,彰化县,社头乡','level'=>'3','pinyin'=>'shetou','code'=>'04','zip_code'=>'511','first'=>'S','lng'=>'120.582681','lat'=>'23.896686']);
        $this->insert('{{%region}}',['id'=>'3569','pid'=>'3551','shortname'=>'二水','name'=>'二水乡','merger_name'=>'中国,台湾省,彰化县,二水乡','level'=>'3','pinyin'=>'ershui','code'=>'04','zip_code'=>'530','first'=>'E','lng'=>'120.618788','lat'=>'23.806995']);
        $this->insert('{{%region}}',['id'=>'3570','pid'=>'3551','shortname'=>'北斗','name'=>'北斗镇','merger_name'=>'中国,台湾省,彰化县,北斗镇','level'=>'3','pinyin'=>'beidou','code'=>'04','zip_code'=>'521','first'=>'B','lng'=>'120.520449','lat'=>'23.870911']);
        $this->insert('{{%region}}',['id'=>'3571','pid'=>'3551','shortname'=>'二林','name'=>'二林镇','merger_name'=>'中国,台湾省,彰化县,二林镇','level'=>'3','pinyin'=>'erlin','code'=>'04','zip_code'=>'526','first'=>'E','lng'=>'120.374468','lat'=>'23.899751']);
        $this->insert('{{%region}}',['id'=>'3572','pid'=>'3551','shortname'=>'田尾','name'=>'田尾乡','merger_name'=>'中国,台湾省,彰化县,田尾乡','level'=>'3','pinyin'=>'tianwei','code'=>'04','zip_code'=>'522','first'=>'T','lng'=>'120.524717','lat'=>'23.890735']);
        $this->insert('{{%region}}',['id'=>'3573','pid'=>'3551','shortname'=>'埤头','name'=>'埤头乡','merger_name'=>'中国,台湾省,彰化县,埤头乡','level'=>'3','pinyin'=>'pitou','code'=>'04','zip_code'=>'523','first'=>NULL,'lng'=>'120.462599','lat'=>'23.891324']);
        $this->insert('{{%region}}',['id'=>'3574','pid'=>'3551','shortname'=>'芳苑','name'=>'芳苑乡','merger_name'=>'中国,台湾省,彰化县,芳苑乡','level'=>'3','pinyin'=>'fangyuan','code'=>'04','zip_code'=>'528','first'=>'F','lng'=>'120.320329','lat'=>'23.924222']);
        $this->insert('{{%region}}',['id'=>'3575','pid'=>'3551','shortname'=>'大城','name'=>'大城乡','merger_name'=>'中国,台湾省,彰化县,大城乡','level'=>'3','pinyin'=>'dacheng','code'=>'04','zip_code'=>'527','first'=>'D','lng'=>'120.320934','lat'=>'23.852382']);
        $this->insert('{{%region}}',['id'=>'3576','pid'=>'3551','shortname'=>'竹塘','name'=>'竹塘乡','merger_name'=>'中国,台湾省,彰化县,竹塘乡','level'=>'3','pinyin'=>'zhutang','code'=>'04','zip_code'=>'525','first'=>'Z','lng'=>'120.427499','lat'=>'23.860112']);
        $this->insert('{{%region}}',['id'=>'3577','pid'=>'3551','shortname'=>'溪州','name'=>'溪州乡','merger_name'=>'中国,台湾省,彰化县,溪州乡','level'=>'3','pinyin'=>'xizhou','code'=>'04','zip_code'=>'524','first'=>'X','lng'=>'120.498706','lat'=>'23.851229']);
        $this->insert('{{%region}}',['id'=>'3578','pid'=>'3325','shortname'=>'南投','name'=>'南投县','merger_name'=>'中国,台湾省,南投县','level'=>'2','pinyin'=>'nantou','code'=>'049','zip_code'=>'5','first'=>'N','lng'=>'120.830000','lat'=>'23.830000']);
        $this->insert('{{%region}}',['id'=>'3579','pid'=>'3578','shortname'=>'南投市','name'=>'南投市','merger_name'=>'中国,台湾省,南投县,南投市','level'=>'3','pinyin'=>'nantoushi','code'=>'049','zip_code'=>'540','first'=>'N','lng'=>'120.683706','lat'=>'23.909956']);
        $this->insert('{{%region}}',['id'=>'3580','pid'=>'3578','shortname'=>'埔里','name'=>'埔里镇','merger_name'=>'中国,台湾省,南投县,埔里镇','level'=>'3','pinyin'=>'puli','code'=>'049','zip_code'=>'545','first'=>'P','lng'=>'120.964648','lat'=>'23.964789']);
        $this->insert('{{%region}}',['id'=>'3581','pid'=>'3578','shortname'=>'草屯','name'=>'草屯镇','merger_name'=>'中国,台湾省,南投县,草屯镇','level'=>'3','pinyin'=>'caotun','code'=>'049','zip_code'=>'542','first'=>'C','lng'=>'120.680343','lat'=>'23.973947']);
        $this->insert('{{%region}}',['id'=>'3582','pid'=>'3578','shortname'=>'竹山','name'=>'竹山镇','merger_name'=>'中国,台湾省,南投县,竹山镇','level'=>'3','pinyin'=>'zhushan','code'=>'049','zip_code'=>'557','first'=>'Z','lng'=>'120.672007','lat'=>'23.757655']);
        $this->insert('{{%region}}',['id'=>'3583','pid'=>'3578','shortname'=>'集集','name'=>'集集镇','merger_name'=>'中国,台湾省,南投县,集集镇','level'=>'3','pinyin'=>'jiji','code'=>'049','zip_code'=>'552','first'=>'J','lng'=>'120.783673','lat'=>'23.829013']);
        $this->insert('{{%region}}',['id'=>'3584','pid'=>'3578','shortname'=>'名间','name'=>'名间乡','merger_name'=>'中国,台湾省,南投县,名间乡','level'=>'3','pinyin'=>'mingjian','code'=>'049','zip_code'=>'551','first'=>'M','lng'=>'120.702797','lat'=>'23.838427']);
        $this->insert('{{%region}}',['id'=>'3585','pid'=>'3578','shortname'=>'鹿谷','name'=>'鹿谷乡','merger_name'=>'中国,台湾省,南投县,鹿谷乡','level'=>'3','pinyin'=>'lugu','code'=>'049','zip_code'=>'558','first'=>'L','lng'=>'120.752796','lat'=>'23.744471']);
        $this->insert('{{%region}}',['id'=>'3586','pid'=>'3578','shortname'=>'中寮','name'=>'中寮乡','merger_name'=>'中国,台湾省,南投县,中寮乡','level'=>'3','pinyin'=>'zhongliao','code'=>'049','zip_code'=>'541','first'=>'Z','lng'=>'120.766654','lat'=>'23.878935']);
        $this->insert('{{%region}}',['id'=>'3587','pid'=>'3578','shortname'=>'鱼池','name'=>'鱼池乡','merger_name'=>'中国,台湾省,南投县,鱼池乡','level'=>'3','pinyin'=>'yuchi','code'=>'049','zip_code'=>'555','first'=>'Y','lng'=>'120.936060','lat'=>'23.896356']);
        $this->insert('{{%region}}',['id'=>'3588','pid'=>'3578','shortname'=>'国姓','name'=>'国姓乡','merger_name'=>'中国,台湾省,南投县,国姓乡','level'=>'3','pinyin'=>'guoxing','code'=>'049','zip_code'=>'544','first'=>'G','lng'=>'120.858541','lat'=>'24.042298']);
        $this->insert('{{%region}}',['id'=>'3589','pid'=>'3578','shortname'=>'水里','name'=>'水里乡','merger_name'=>'中国,台湾省,南投县,水里乡','level'=>'3','pinyin'=>'shuili','code'=>'049','zip_code'=>'553','first'=>'S','lng'=>'120.855912','lat'=>'23.812086']);
        $this->insert('{{%region}}',['id'=>'3590','pid'=>'3578','shortname'=>'信义','name'=>'信义乡','merger_name'=>'中国,台湾省,南投县,信义乡','level'=>'3','pinyin'=>'xinyi','code'=>'049','zip_code'=>'556','first'=>'X','lng'=>'120.855257','lat'=>'23.699922']);
        $this->insert('{{%region}}',['id'=>'3591','pid'=>'3578','shortname'=>'仁爱','name'=>'仁爱乡','merger_name'=>'中国,台湾省,南投县,仁爱乡','level'=>'3','pinyin'=>'renai','code'=>'049','zip_code'=>'546','first'=>'R','lng'=>'121.133543','lat'=>'24.024429']);
        $this->insert('{{%region}}',['id'=>'3592','pid'=>'3325','shortname'=>'云林','name'=>'云林县','merger_name'=>'中国,台湾省,云林县','level'=>'2','pinyin'=>'yunlin','code'=>'05','zip_code'=>'6','first'=>'Y','lng'=>'120.250000','lat'=>'23.750000']);
        $this->insert('{{%region}}',['id'=>'3593','pid'=>'3592','shortname'=>'斗六','name'=>'斗六市','merger_name'=>'中国,台湾省,云林县,斗六市','level'=>'3','pinyin'=>'douliu','code'=>'05','zip_code'=>'640','first'=>'D','lng'=>'120.527360','lat'=>'23.697651']);
        $this->insert('{{%region}}',['id'=>'3594','pid'=>'3592','shortname'=>'斗南','name'=>'斗南镇','merger_name'=>'中国,台湾省,云林县,斗南镇','level'=>'3','pinyin'=>'dounan','code'=>'05','zip_code'=>'630','first'=>'D','lng'=>'120.479075','lat'=>'23.679731']);
        $this->insert('{{%region}}',['id'=>'3595','pid'=>'3592','shortname'=>'虎尾','name'=>'虎尾镇','merger_name'=>'中国,台湾省,云林县,虎尾镇','level'=>'3','pinyin'=>'huwei','code'=>'05','zip_code'=>'632','first'=>'H','lng'=>'120.445339','lat'=>'23.708182']);
        $this->insert('{{%region}}',['id'=>'3596','pid'=>'3592','shortname'=>'西螺','name'=>'西螺镇','merger_name'=>'中国,台湾省,云林县,西螺镇','level'=>'3','pinyin'=>'xiluo','code'=>'05','zip_code'=>'648','first'=>'X','lng'=>'120.466010','lat'=>'23.797984']);
        $this->insert('{{%region}}',['id'=>'3597','pid'=>'3592','shortname'=>'土库','name'=>'土库镇','merger_name'=>'中国,台湾省,云林县,土库镇','level'=>'3','pinyin'=>'tuku','code'=>'05','zip_code'=>'633','first'=>'T','lng'=>'120.392572','lat'=>'23.677822']);
        $this->insert('{{%region}}',['id'=>'3598','pid'=>'3592','shortname'=>'北港','name'=>'北港镇','merger_name'=>'中国,台湾省,云林县,北港镇','level'=>'3','pinyin'=>'beigang','code'=>'05','zip_code'=>'651','first'=>'B','lng'=>'120.302393','lat'=>'23.575525']);
        $this->insert('{{%region}}',['id'=>'3599','pid'=>'3592','shortname'=>'古坑','name'=>'古坑乡','merger_name'=>'中国,台湾省,云林县,古坑乡','level'=>'3','pinyin'=>'gukeng','code'=>'05','zip_code'=>'646','first'=>'G','lng'=>'120.562043','lat'=>'23.642568']);
        $this->insert('{{%region}}',['id'=>'3600','pid'=>'3592','shortname'=>'大埤','name'=>'大埤乡','merger_name'=>'中国,台湾省,云林县,大埤乡','level'=>'3','pinyin'=>'dapi','code'=>'05','zip_code'=>'631','first'=>'D','lng'=>'120.430516','lat'=>'23.645908']);
        $this->insert('{{%region}}',['id'=>'3601','pid'=>'3592','shortname'=>'莿桐','name'=>'莿桐乡','merger_name'=>'中国,台湾省,云林县,莿桐乡','level'=>'3','pinyin'=>'citong','code'=>'05','zip_code'=>'647','first'=>NULL,'lng'=>'120.502374','lat'=>'23.760784']);
        $this->insert('{{%region}}',['id'=>'3602','pid'=>'3592','shortname'=>'林内','name'=>'林内乡','merger_name'=>'中国,台湾省,云林县,林内乡','level'=>'3','pinyin'=>'linna','code'=>'05','zip_code'=>'643','first'=>'L','lng'=>'120.611365','lat'=>'23.758712']);
        $this->insert('{{%region}}',['id'=>'3603','pid'=>'3592','shortname'=>'二仑','name'=>'二仑乡','merger_name'=>'中国,台湾省,云林县,二仑乡','level'=>'3','pinyin'=>'erlun','code'=>'05','zip_code'=>'649','first'=>'E','lng'=>'120.415077','lat'=>'23.771273']);
        $this->insert('{{%region}}',['id'=>'3604','pid'=>'3592','shortname'=>'仑背','name'=>'仑背乡','merger_name'=>'中国,台湾省,云林县,仑背乡','level'=>'3','pinyin'=>'lunbei','code'=>'05','zip_code'=>'637','first'=>'L','lng'=>'120.353895','lat'=>'23.758840']);
        $this->insert('{{%region}}',['id'=>'3605','pid'=>'3592','shortname'=>'麦寮','name'=>'麦寮乡','merger_name'=>'中国,台湾省,云林县,麦寮乡','level'=>'3','pinyin'=>'mailiao','code'=>'05','zip_code'=>'638','first'=>'M','lng'=>'120.252043','lat'=>'23.753841']);
        $this->insert('{{%region}}',['id'=>'3606','pid'=>'3592','shortname'=>'东势','name'=>'东势乡','merger_name'=>'中国,台湾省,云林县,东势乡','level'=>'3','pinyin'=>'dongshi','code'=>'05','zip_code'=>'635','first'=>'D','lng'=>'120.252672','lat'=>'23.674679']);
        $this->insert('{{%region}}',['id'=>'3607','pid'=>'3592','shortname'=>'褒忠','name'=>'褒忠乡','merger_name'=>'中国,台湾省,云林县,褒忠乡','level'=>'3','pinyin'=>'baozhong','code'=>'05','zip_code'=>'634','first'=>'B','lng'=>'120.310488','lat'=>'23.694245']);
        $this->insert('{{%region}}',['id'=>'3608','pid'=>'3592','shortname'=>'台西','name'=>'台西乡','merger_name'=>'中国,台湾省,云林县,台西乡','level'=>'3','pinyin'=>'taixi','code'=>'05','zip_code'=>'636','first'=>'T','lng'=>'120.196141','lat'=>'23.702819']);
        $this->insert('{{%region}}',['id'=>'3609','pid'=>'3592','shortname'=>'元长','name'=>'元长乡','merger_name'=>'中国,台湾省,云林县,元长乡','level'=>'3','pinyin'=>'yuanchang','code'=>'05','zip_code'=>'655','first'=>'Y','lng'=>'120.315124','lat'=>'23.649458']);
        $this->insert('{{%region}}',['id'=>'3610','pid'=>'3592','shortname'=>'四湖','name'=>'四湖乡','merger_name'=>'中国,台湾省,云林县,四湖乡','level'=>'3','pinyin'=>'sihu','code'=>'05','zip_code'=>'654','first'=>'S','lng'=>'120.225741','lat'=>'23.637740']);
        $this->insert('{{%region}}',['id'=>'3611','pid'=>'3592','shortname'=>'口湖','name'=>'口湖乡','merger_name'=>'中国,台湾省,云林县,口湖乡','level'=>'3','pinyin'=>'kouhu','code'=>'05','zip_code'=>'653','first'=>'K','lng'=>'120.185370','lat'=>'23.582406']);
        $this->insert('{{%region}}',['id'=>'3612','pid'=>'3592','shortname'=>'水林','name'=>'水林乡','merger_name'=>'中国,台湾省,云林县,水林乡','level'=>'3','pinyin'=>'shuilin','code'=>'05','zip_code'=>'652','first'=>'S','lng'=>'120.245948','lat'=>'23.572634']);
        $this->insert('{{%region}}',['id'=>'3613','pid'=>'3325','shortname'=>'嘉义','name'=>'嘉义县','merger_name'=>'中国,台湾省,嘉义县','level'=>'2','pinyin'=>'chiayi','code'=>'05','zip_code'=>'6','first'=>'J','lng'=>'120.300000','lat'=>'23.500000']);
        $this->insert('{{%region}}',['id'=>'3614','pid'=>'3613','shortname'=>'太保','name'=>'太保市','merger_name'=>'中国,台湾省,嘉义县,太保市','level'=>'3','pinyin'=>'taibao','code'=>'05','zip_code'=>'612','first'=>'T','lng'=>'120.332876','lat'=>'23.459647']);
        $this->insert('{{%region}}',['id'=>'3615','pid'=>'3613','shortname'=>'朴子','name'=>'朴子市','merger_name'=>'中国,台湾省,嘉义县,朴子市','level'=>'3','pinyin'=>'puzi','code'=>'05','zip_code'=>'613','first'=>'P','lng'=>'120.247014','lat'=>'23.464961']);
        $this->insert('{{%region}}',['id'=>'3616','pid'=>'3613','shortname'=>'布袋','name'=>'布袋镇','merger_name'=>'中国,台湾省,嘉义县,布袋镇','level'=>'3','pinyin'=>'budai','code'=>'05','zip_code'=>'625','first'=>'B','lng'=>'120.166936','lat'=>'23.377979']);
        $this->insert('{{%region}}',['id'=>'3617','pid'=>'3613','shortname'=>'大林','name'=>'大林镇','merger_name'=>'中国,台湾省,嘉义县,大林镇','level'=>'3','pinyin'=>'dalin','code'=>'05','zip_code'=>'622','first'=>'D','lng'=>'120.471336','lat'=>'23.603815']);
        $this->insert('{{%region}}',['id'=>'3618','pid'=>'3613','shortname'=>'民雄','name'=>'民雄乡','merger_name'=>'中国,台湾省,嘉义县,民雄乡','level'=>'3','pinyin'=>'minxiong','code'=>'05','zip_code'=>'621','first'=>'M','lng'=>'120.428577','lat'=>'23.551456']);
        $this->insert('{{%region}}',['id'=>'3619','pid'=>'3613','shortname'=>'溪口','name'=>'溪口乡','merger_name'=>'中国,台湾省,嘉义县,溪口乡','level'=>'3','pinyin'=>'xikou','code'=>'05','zip_code'=>'623','first'=>'X','lng'=>'120.393822','lat'=>'23.602223']);
        $this->insert('{{%region}}',['id'=>'3620','pid'=>'3613','shortname'=>'新港','name'=>'新港乡','merger_name'=>'中国,台湾省,嘉义县,新港乡','level'=>'3','pinyin'=>'xingang','code'=>'05','zip_code'=>'616','first'=>'X','lng'=>'120.347647','lat'=>'23.551806']);
        $this->insert('{{%region}}',['id'=>'3621','pid'=>'3613','shortname'=>'六脚','name'=>'六脚乡','merger_name'=>'中国,台湾省,嘉义县,六脚乡','level'=>'3','pinyin'=>'liujiao','code'=>'05','zip_code'=>'615','first'=>'L','lng'=>'120.291083','lat'=>'23.493942']);
        $this->insert('{{%region}}',['id'=>'3622','pid'=>'3613','shortname'=>'东石','name'=>'东石乡','merger_name'=>'中国,台湾省,嘉义县,东石乡','level'=>'3','pinyin'=>'dongshi','code'=>'05','zip_code'=>'614','first'=>'D','lng'=>'120.153822','lat'=>'23.459235']);
        $this->insert('{{%region}}',['id'=>'3623','pid'=>'3613','shortname'=>'义竹','name'=>'义竹乡','merger_name'=>'中国,台湾省,嘉义县,义竹乡','level'=>'3','pinyin'=>'yizhu','code'=>'05','zip_code'=>'624','first'=>'Y','lng'=>'120.243423','lat'=>'23.336277']);
        $this->insert('{{%region}}',['id'=>'3624','pid'=>'3613','shortname'=>'鹿草','name'=>'鹿草乡','merger_name'=>'中国,台湾省,嘉义县,鹿草乡','level'=>'3','pinyin'=>'lucao','code'=>'05','zip_code'=>'611','first'=>'L','lng'=>'120.308370','lat'=>'23.410784']);
        $this->insert('{{%region}}',['id'=>'3625','pid'=>'3613','shortname'=>'水上','name'=>'水上乡','merger_name'=>'中国,台湾省,嘉义县,水上乡','level'=>'3','pinyin'=>'shuishang','code'=>'05','zip_code'=>'608','first'=>'S','lng'=>'120.397936','lat'=>'23.428104']);
        $this->insert('{{%region}}',['id'=>'3626','pid'=>'3613','shortname'=>'中埔','name'=>'中埔乡','merger_name'=>'中国,台湾省,嘉义县,中埔乡','level'=>'3','pinyin'=>'zhongpu','code'=>'05','zip_code'=>'606','first'=>'Z','lng'=>'120.522948','lat'=>'23.425148']);
        $this->insert('{{%region}}',['id'=>'3627','pid'=>'3613','shortname'=>'竹崎','name'=>'竹崎乡','merger_name'=>'中国,台湾省,嘉义县,竹崎乡','level'=>'3','pinyin'=>'zhuqi','code'=>'05','zip_code'=>'604','first'=>'Z','lng'=>'120.551466','lat'=>'23.523184']);
        $this->insert('{{%region}}',['id'=>'3628','pid'=>'3613','shortname'=>'梅山','name'=>'梅山乡','merger_name'=>'中国,台湾省,嘉义县,梅山乡','level'=>'3','pinyin'=>'meishan','code'=>'05','zip_code'=>'603','first'=>'M','lng'=>'120.557192','lat'=>'23.584915']);
        $this->insert('{{%region}}',['id'=>'3629','pid'=>'3613','shortname'=>'番路','name'=>'番路乡','merger_name'=>'中国,台湾省,嘉义县,番路乡','level'=>'3','pinyin'=>'fanlu','code'=>'05','zip_code'=>'602','first'=>'F','lng'=>'120.555043','lat'=>'23.465222']);
        $this->insert('{{%region}}',['id'=>'3630','pid'=>'3613','shortname'=>'大埔','name'=>'大埔乡','merger_name'=>'中国,台湾省,嘉义县,大埔乡','level'=>'3','pinyin'=>'dapu','code'=>'05','zip_code'=>'607','first'=>'D','lng'=>'120.593795','lat'=>'23.296715']);
        $this->insert('{{%region}}',['id'=>'3631','pid'=>'3613','shortname'=>'阿里山','name'=>'阿里山乡','merger_name'=>'中国,台湾省,嘉义县,阿里山乡','level'=>'3','pinyin'=>'alishan','code'=>'05','zip_code'=>'605','first'=>'A','lng'=>'120.732520','lat'=>'23.467950']);
        $this->insert('{{%region}}',['id'=>'3632','pid'=>'3325','shortname'=>'屏东','name'=>'屏东县','merger_name'=>'中国,台湾省,屏东县','level'=>'2','pinyin'=>'pingtung','code'=>'08','zip_code'=>'9','first'=>'P','lng'=>'120.487928','lat'=>'22.682802']);
        $this->insert('{{%region}}',['id'=>'3633','pid'=>'3632','shortname'=>'屏东','name'=>'屏东市','merger_name'=>'中国,台湾省,屏东县,屏东市','level'=>'3','pinyin'=>'pingdong','code'=>'08','zip_code'=>'900','first'=>'P','lng'=>'120.488465','lat'=>'22.669723']);
        $this->insert('{{%region}}',['id'=>'3634','pid'=>'3632','shortname'=>'潮州','name'=>'潮州镇','merger_name'=>'中国,台湾省,屏东县,潮州镇','level'=>'3','pinyin'=>'chaozhou','code'=>'08','zip_code'=>'920','first'=>'C','lng'=>'120.542854','lat'=>'22.550536']);
        $this->insert('{{%region}}',['id'=>'3635','pid'=>'3632','shortname'=>'东港','name'=>'东港镇','merger_name'=>'中国,台湾省,屏东县,东港镇','level'=>'3','pinyin'=>'donggang','code'=>'08','zip_code'=>'928','first'=>'D','lng'=>'120.454489','lat'=>'22.466626']);
        $this->insert('{{%region}}',['id'=>'3636','pid'=>'3632','shortname'=>'恒春','name'=>'恒春镇','merger_name'=>'中国,台湾省,屏东县,恒春镇','level'=>'3','pinyin'=>'hengchun','code'=>'08','zip_code'=>'946','first'=>'H','lng'=>'120.745451','lat'=>'22.002373']);
        $this->insert('{{%region}}',['id'=>'3637','pid'=>'3632','shortname'=>'万丹','name'=>'万丹乡','merger_name'=>'中国,台湾省,屏东县,万丹乡','level'=>'3','pinyin'=>'wandan','code'=>'08','zip_code'=>'913','first'=>'W','lng'=>'120.484533','lat'=>'22.589839']);
        $this->insert('{{%region}}',['id'=>'3638','pid'=>'3632','shortname'=>'长治','name'=>'长治乡','merger_name'=>'中国,台湾省,屏东县,长治乡','level'=>'3','pinyin'=>'changzhi','code'=>'08','zip_code'=>'908','first'=>'C','lng'=>'120.527614','lat'=>'22.677062']);
        $this->insert('{{%region}}',['id'=>'3639','pid'=>'3632','shortname'=>'麟洛','name'=>'麟洛乡','merger_name'=>'中国,台湾省,屏东县,麟洛乡','level'=>'3','pinyin'=>'linluo','code'=>'08','zip_code'=>'909','first'=>NULL,'lng'=>'120.527283','lat'=>'22.650604']);
        $this->insert('{{%region}}',['id'=>'3640','pid'=>'3632','shortname'=>'九如','name'=>'九如乡','merger_name'=>'中国,台湾省,屏东县,九如乡','level'=>'3','pinyin'=>'jiuru','code'=>'08','zip_code'=>'904','first'=>'J','lng'=>'120.490142','lat'=>'22.739778']);
        $this->insert('{{%region}}',['id'=>'3641','pid'=>'3632','shortname'=>'里港','name'=>'里港乡','merger_name'=>'中国,台湾省,屏东县,里港乡','level'=>'3','pinyin'=>'ligang','code'=>'08','zip_code'=>'905','first'=>'L','lng'=>'120.494490','lat'=>'22.779220']);
        $this->insert('{{%region}}',['id'=>'3642','pid'=>'3632','shortname'=>'盐埔','name'=>'盐埔乡','merger_name'=>'中国,台湾省,屏东县,盐埔乡','level'=>'3','pinyin'=>'yanpu','code'=>'08','zip_code'=>'907','first'=>'Y','lng'=>'120.572849','lat'=>'22.754783']);
        $this->insert('{{%region}}',['id'=>'3643','pid'=>'3632','shortname'=>'高树','name'=>'高树乡','merger_name'=>'中国,台湾省,屏东县,高树乡','level'=>'3','pinyin'=>'gaoshu','code'=>'08','zip_code'=>'906','first'=>'G','lng'=>'120.600214','lat'=>'22.826789']);
        $this->insert('{{%region}}',['id'=>'3644','pid'=>'3632','shortname'=>'万峦','name'=>'万峦乡','merger_name'=>'中国,台湾省,屏东县,万峦乡','level'=>'3','pinyin'=>'wanluan','code'=>'08','zip_code'=>'923','first'=>'W','lng'=>'120.566477','lat'=>'22.571965']);
        $this->insert('{{%region}}',['id'=>'3645','pid'=>'3632','shortname'=>'内埔','name'=>'内埔乡','merger_name'=>'中国,台湾省,屏东县,内埔乡','level'=>'3','pinyin'=>'napu','code'=>'08','zip_code'=>'912','first'=>'N','lng'=>'120.566865','lat'=>'22.611967']);
        $this->insert('{{%region}}',['id'=>'3646','pid'=>'3632','shortname'=>'竹田','name'=>'竹田乡','merger_name'=>'中国,台湾省,屏东县,竹田乡','level'=>'3','pinyin'=>'zhutian','code'=>'08','zip_code'=>'911','first'=>'Z','lng'=>'120.544038','lat'=>'22.584678']);
        $this->insert('{{%region}}',['id'=>'3647','pid'=>'3632','shortname'=>'新埤','name'=>'新埤乡','merger_name'=>'中国,台湾省,屏东县,新埤乡','level'=>'3','pinyin'=>'xinpi','code'=>'08','zip_code'=>'925','first'=>'X','lng'=>'120.549546','lat'=>'22.469976']);
        $this->insert('{{%region}}',['id'=>'3648','pid'=>'3632','shortname'=>'枋寮','name'=>'枋寮乡','merger_name'=>'中国,台湾省,屏东县,枋寮乡','level'=>'3','pinyin'=>'fangliao','code'=>'08','zip_code'=>'940','first'=>NULL,'lng'=>'120.593438','lat'=>'22.365560']);
        $this->insert('{{%region}}',['id'=>'3649','pid'=>'3632','shortname'=>'新园','name'=>'新园乡','merger_name'=>'中国,台湾省,屏东县,新园乡','level'=>'3','pinyin'=>'xinyuan','code'=>'08','zip_code'=>'932','first'=>'X','lng'=>'120.461739','lat'=>'22.543952']);
        $this->insert('{{%region}}',['id'=>'3650','pid'=>'3632','shortname'=>'崁顶','name'=>'崁顶乡','merger_name'=>'中国,台湾省,屏东县,崁顶乡','level'=>'3','pinyin'=>'kanding','code'=>'08','zip_code'=>'924','first'=>NULL,'lng'=>'120.514571','lat'=>'22.514795']);
        $this->insert('{{%region}}',['id'=>'3651','pid'=>'3632','shortname'=>'林边','name'=>'林边乡','merger_name'=>'中国,台湾省,屏东县,林边乡','level'=>'3','pinyin'=>'linbian','code'=>'08','zip_code'=>'927','first'=>'L','lng'=>'120.515091','lat'=>'22.434015']);
        $this->insert('{{%region}}',['id'=>'3652','pid'=>'3632','shortname'=>'南州','name'=>'南州乡','merger_name'=>'中国,台湾省,屏东县,南州乡','level'=>'3','pinyin'=>'nanzhou','code'=>'08','zip_code'=>'926','first'=>'N','lng'=>'120.509808','lat'=>'22.490192']);
        $this->insert('{{%region}}',['id'=>'3653','pid'=>'3632','shortname'=>'佳冬','name'=>'佳冬乡','merger_name'=>'中国,台湾省,屏东县,佳冬乡','level'=>'3','pinyin'=>'jiadong','code'=>'08','zip_code'=>'931','first'=>'J','lng'=>'120.551544','lat'=>'22.417653']);
        $this->insert('{{%region}}',['id'=>'3654','pid'=>'3632','shortname'=>'琉球','name'=>'琉球乡','merger_name'=>'中国,台湾省,屏东县,琉球乡','level'=>'3','pinyin'=>'liuqiu','code'=>'08','zip_code'=>'929','first'=>'L','lng'=>'120.369020','lat'=>'22.342366']);
        $this->insert('{{%region}}',['id'=>'3655','pid'=>'3632','shortname'=>'车城','name'=>'车城乡','merger_name'=>'中国,台湾省,屏东县,车城乡','level'=>'3','pinyin'=>'checheng','code'=>'08','zip_code'=>'944','first'=>'C','lng'=>'120.710979','lat'=>'22.072077']);
        $this->insert('{{%region}}',['id'=>'3656','pid'=>'3632','shortname'=>'满州','name'=>'满州乡','merger_name'=>'中国,台湾省,屏东县,满州乡','level'=>'3','pinyin'=>'manzhou','code'=>'08','zip_code'=>'947','first'=>'M','lng'=>'120.838843','lat'=>'22.020853']);
        $this->insert('{{%region}}',['id'=>'3657','pid'=>'3632','shortname'=>'枋山','name'=>'枋山乡','merger_name'=>'中国,台湾省,屏东县,枋山乡','level'=>'3','pinyin'=>'fangshan','code'=>'08','zip_code'=>'941','first'=>NULL,'lng'=>'120.656356','lat'=>'22.260338']);
        $this->insert('{{%region}}',['id'=>'3658','pid'=>'3632','shortname'=>'三地门','name'=>'三地门乡','merger_name'=>'中国,台湾省,屏东县,三地门乡','level'=>'3','pinyin'=>'sandimen','code'=>'08','zip_code'=>'901','first'=>'S','lng'=>'120.654486','lat'=>'22.713877']);
        $this->insert('{{%region}}',['id'=>'3659','pid'=>'3632','shortname'=>'雾台','name'=>'雾台乡','merger_name'=>'中国,台湾省,屏东县,雾台乡','level'=>'3','pinyin'=>'wutai','code'=>'08','zip_code'=>'902','first'=>'W','lng'=>'120.732318','lat'=>'22.744877']);
        $this->insert('{{%region}}',['id'=>'3660','pid'=>'3632','shortname'=>'玛家','name'=>'玛家乡','merger_name'=>'中国,台湾省,屏东县,玛家乡','level'=>'3','pinyin'=>'majia','code'=>'08','zip_code'=>'903','first'=>'M','lng'=>'120.644130','lat'=>'22.706718']);
        $this->insert('{{%region}}',['id'=>'3661','pid'=>'3632','shortname'=>'泰武','name'=>'泰武乡','merger_name'=>'中国,台湾省,屏东县,泰武乡','level'=>'3','pinyin'=>'taiwu','code'=>'08','zip_code'=>'921','first'=>'T','lng'=>'120.632856','lat'=>'22.591819']);
        $this->insert('{{%region}}',['id'=>'3662','pid'=>'3632','shortname'=>'来义','name'=>'来义乡','merger_name'=>'中国,台湾省,屏东县,来义乡','level'=>'3','pinyin'=>'laiyi','code'=>'08','zip_code'=>'922','first'=>'L','lng'=>'120.633601','lat'=>'22.525866']);
        $this->insert('{{%region}}',['id'=>'3663','pid'=>'3632','shortname'=>'春日','name'=>'春日乡','merger_name'=>'中国,台湾省,屏东县,春日乡','level'=>'3','pinyin'=>'chunri','code'=>'08','zip_code'=>'942','first'=>'C','lng'=>'120.628793','lat'=>'22.370672']);
        $this->insert('{{%region}}',['id'=>'3664','pid'=>'3632','shortname'=>'狮子','name'=>'狮子乡','merger_name'=>'中国,台湾省,屏东县,狮子乡','level'=>'3','pinyin'=>'shizi','code'=>'08','zip_code'=>'943','first'=>'S','lng'=>'120.704617','lat'=>'22.201917']);
        $this->insert('{{%region}}',['id'=>'3665','pid'=>'3632','shortname'=>'牡丹','name'=>'牡丹乡','merger_name'=>'中国,台湾省,屏东县,牡丹乡','level'=>'3','pinyin'=>'mudan','code'=>'08','zip_code'=>'945','first'=>'M','lng'=>'120.770108','lat'=>'22.125687']);
        $this->insert('{{%region}}',['id'=>'3666','pid'=>'3325','shortname'=>'台东','name'=>'台东县','merger_name'=>'中国,台湾省,台东县','level'=>'2','pinyin'=>'taitung','code'=>'089','zip_code'=>'9','first'=>'T','lng'=>'120.916000','lat'=>'23.000000']);
        $this->insert('{{%region}}',['id'=>'3667','pid'=>'3666','shortname'=>'台东','name'=>'台东市','merger_name'=>'中国,台湾省,台东县,台东市','level'=>'3','pinyin'=>'taidong','code'=>'089','zip_code'=>'950','first'=>'T','lng'=>'121.145654','lat'=>'22.756045']);
        $this->insert('{{%region}}',['id'=>'3668','pid'=>'3666','shortname'=>'成功','name'=>'成功镇','merger_name'=>'中国,台湾省,台东县,成功镇','level'=>'3','pinyin'=>'chenggong','code'=>'089','zip_code'=>'961','first'=>'C','lng'=>'121.379571','lat'=>'23.100223']);
        $this->insert('{{%region}}',['id'=>'3669','pid'=>'3666','shortname'=>'关山','name'=>'关山镇','merger_name'=>'中国,台湾省,台东县,关山镇','level'=>'3','pinyin'=>'guanshan','code'=>'089','zip_code'=>'956','first'=>'G','lng'=>'121.163134','lat'=>'23.047450']);
        $this->insert('{{%region}}',['id'=>'3670','pid'=>'3666','shortname'=>'卑南','name'=>'卑南乡','merger_name'=>'中国,台湾省,台东县,卑南乡','level'=>'3','pinyin'=>'beinan','code'=>'089','zip_code'=>'954','first'=>'B','lng'=>'121.083503','lat'=>'22.786039']);
        $this->insert('{{%region}}',['id'=>'3671','pid'=>'3666','shortname'=>'鹿野','name'=>'鹿野乡','merger_name'=>'中国,台湾省,台东县,鹿野乡','level'=>'3','pinyin'=>'luye','code'=>'089','zip_code'=>'955','first'=>'L','lng'=>'121.135982','lat'=>'22.913951']);
        $this->insert('{{%region}}',['id'=>'3672','pid'=>'3666','shortname'=>'池上','name'=>'池上乡','merger_name'=>'中国,台湾省,台东县,池上乡','level'=>'3','pinyin'=>'chishang','code'=>'089','zip_code'=>'958','first'=>'C','lng'=>'121.215139','lat'=>'23.122393']);
        $this->insert('{{%region}}',['id'=>'3673','pid'=>'3666','shortname'=>'东河','name'=>'东河乡','merger_name'=>'中国,台湾省,台东县,东河乡','level'=>'3','pinyin'=>'donghe','code'=>'089','zip_code'=>'959','first'=>'D','lng'=>'121.300334','lat'=>'22.969934']);
        $this->insert('{{%region}}',['id'=>'3674','pid'=>'3666','shortname'=>'长滨','name'=>'长滨乡','merger_name'=>'中国,台湾省,台东县,长滨乡','level'=>'3','pinyin'=>'changbin','code'=>'089','zip_code'=>'962','first'=>'C','lng'=>'121.451522','lat'=>'23.315041']);
        $this->insert('{{%region}}',['id'=>'3675','pid'=>'3666','shortname'=>'太麻里','name'=>'太麻里乡','merger_name'=>'中国,台湾省,台东县,太麻里乡','level'=>'3','pinyin'=>'taimali','code'=>'089','zip_code'=>'963','first'=>'T','lng'=>'121.007394','lat'=>'22.615383']);
        $this->insert('{{%region}}',['id'=>'3676','pid'=>'3666','shortname'=>'大武','name'=>'大武乡','merger_name'=>'中国,台湾省,台东县,大武乡','level'=>'3','pinyin'=>'dawu','code'=>'089','zip_code'=>'965','first'=>'D','lng'=>'120.889938','lat'=>'22.339919']);
        $this->insert('{{%region}}',['id'=>'3677','pid'=>'3666','shortname'=>'绿岛','name'=>'绿岛乡','merger_name'=>'中国,台湾省,台东县,绿岛乡','level'=>'3','pinyin'=>'lvdao','code'=>'089','zip_code'=>'951','first'=>'L','lng'=>'121.492596','lat'=>'22.661676']);
        $this->insert('{{%region}}',['id'=>'3678','pid'=>'3666','shortname'=>'海端','name'=>'海端乡','merger_name'=>'中国,台湾省,台东县,海端乡','level'=>'3','pinyin'=>'haiduan','code'=>'089','zip_code'=>'957','first'=>'H','lng'=>'121.172008','lat'=>'23.101074']);
        $this->insert('{{%region}}',['id'=>'3679','pid'=>'3666','shortname'=>'延平','name'=>'延平乡','merger_name'=>'中国,台湾省,台东县,延平乡','level'=>'3','pinyin'=>'yanping','code'=>'089','zip_code'=>'953','first'=>'Y','lng'=>'121.084499','lat'=>'22.902358']);
        $this->insert('{{%region}}',['id'=>'3680','pid'=>'3666','shortname'=>'金峰','name'=>'金峰乡','merger_name'=>'中国,台湾省,台东县,金峰乡','level'=>'3','pinyin'=>'jinfeng','code'=>'089','zip_code'=>'964','first'=>'J','lng'=>'120.971292','lat'=>'22.595511']);
        $this->insert('{{%region}}',['id'=>'3681','pid'=>'3666','shortname'=>'达仁','name'=>'达仁乡','merger_name'=>'中国,台湾省,台东县,达仁乡','level'=>'3','pinyin'=>'daren','code'=>'089','zip_code'=>'966','first'=>'D','lng'=>'120.884131','lat'=>'22.294869']);
        $this->insert('{{%region}}',['id'=>'3682','pid'=>'3666','shortname'=>'兰屿','name'=>'兰屿乡','merger_name'=>'中国,台湾省,台东县,兰屿乡','level'=>'3','pinyin'=>'lanyu','code'=>'089','zip_code'=>'952','first'=>'L','lng'=>'121.532473','lat'=>'22.056736']);
        $this->insert('{{%region}}',['id'=>'3683','pid'=>'3325','shortname'=>'花莲','name'=>'花莲县','merger_name'=>'中国,台湾省,花莲县','level'=>'2','pinyin'=>'hualien','code'=>'03','zip_code'=>'9','first'=>'H','lng'=>'121.300000','lat'=>'23.830000']);
        $this->insert('{{%region}}',['id'=>'3684','pid'=>'3683','shortname'=>'花莲','name'=>'花莲市','merger_name'=>'中国,台湾省,花莲县,花莲市','level'=>'3','pinyin'=>'hualian','code'=>'03','zip_code'=>'970','first'=>'H','lng'=>'121.606810','lat'=>'23.982074']);
        $this->insert('{{%region}}',['id'=>'3685','pid'=>'3683','shortname'=>'凤林','name'=>'凤林镇','merger_name'=>'中国,台湾省,花莲县,凤林镇','level'=>'3','pinyin'=>'fenglin','code'=>'03','zip_code'=>'975','first'=>'F','lng'=>'121.451687','lat'=>'23.744648']);
        $this->insert('{{%region}}',['id'=>'3686','pid'=>'3683','shortname'=>'玉里','name'=>'玉里镇','merger_name'=>'中国,台湾省,花莲县,玉里镇','level'=>'3','pinyin'=>'yuli','code'=>'03','zip_code'=>'981','first'=>'Y','lng'=>'121.316445','lat'=>'23.336509']);
        $this->insert('{{%region}}',['id'=>'3687','pid'=>'3683','shortname'=>'新城','name'=>'新城乡','merger_name'=>'中国,台湾省,花莲县,新城乡','level'=>'3','pinyin'=>'xincheng','code'=>'03','zip_code'=>'971','first'=>'X','lng'=>'121.640512','lat'=>'24.128133']);
        $this->insert('{{%region}}',['id'=>'3688','pid'=>'3683','shortname'=>'吉安','name'=>'吉安乡','merger_name'=>'中国,台湾省,花莲县,吉安乡','level'=>'3','pinyin'=>'ji\'an','code'=>'03','zip_code'=>'973','first'=>'J','lng'=>'121.568005','lat'=>'23.961635']);
        $this->insert('{{%region}}',['id'=>'3689','pid'=>'3683','shortname'=>'寿丰','name'=>'寿丰乡','merger_name'=>'中国,台湾省,花莲县,寿丰乡','level'=>'3','pinyin'=>'shoufeng','code'=>'03','zip_code'=>'974','first'=>'S','lng'=>'121.508955','lat'=>'23.870680']);
        $this->insert('{{%region}}',['id'=>'3690','pid'=>'3683','shortname'=>'光复','name'=>'光复乡','merger_name'=>'中国,台湾省,花莲县,光复乡','level'=>'3','pinyin'=>'guangfu','code'=>'03','zip_code'=>'976','first'=>'G','lng'=>'121.423496','lat'=>'23.669084']);
        $this->insert('{{%region}}',['id'=>'3691','pid'=>'3683','shortname'=>'丰滨','name'=>'丰滨乡','merger_name'=>'中国,台湾省,花莲县,丰滨乡','level'=>'3','pinyin'=>'fengbin','code'=>'03','zip_code'=>'977','first'=>'F','lng'=>'121.518639','lat'=>'23.597080']);
        $this->insert('{{%region}}',['id'=>'3692','pid'=>'3683','shortname'=>'瑞穗','name'=>'瑞穗乡','merger_name'=>'中国,台湾省,花莲县,瑞穗乡','level'=>'3','pinyin'=>'ruisui','code'=>'03','zip_code'=>'978','first'=>'R','lng'=>'121.375992','lat'=>'23.496817']);
        $this->insert('{{%region}}',['id'=>'3693','pid'=>'3683','shortname'=>'富里','name'=>'富里乡','merger_name'=>'中国,台湾省,花莲县,富里乡','level'=>'3','pinyin'=>'fuli','code'=>'03','zip_code'=>'983','first'=>'F','lng'=>'121.250124','lat'=>'23.179984']);
        $this->insert('{{%region}}',['id'=>'3694','pid'=>'3683','shortname'=>'秀林','name'=>'秀林乡','merger_name'=>'中国,台湾省,花莲县,秀林乡','level'=>'3','pinyin'=>'xiulin','code'=>'03','zip_code'=>'972','first'=>'X','lng'=>'121.620381','lat'=>'24.116642']);
        $this->insert('{{%region}}',['id'=>'3695','pid'=>'3683','shortname'=>'万荣','name'=>'万荣乡','merger_name'=>'中国,台湾省,花莲县,万荣乡','level'=>'3','pinyin'=>'wanrong','code'=>'03','zip_code'=>'979','first'=>'W','lng'=>'121.407493','lat'=>'23.715346']);
        $this->insert('{{%region}}',['id'=>'3696','pid'=>'3683','shortname'=>'卓溪','name'=>'卓溪乡','merger_name'=>'中国,台湾省,花莲县,卓溪乡','level'=>'3','pinyin'=>'zhuoxi','code'=>'03','zip_code'=>'982','first'=>'Z','lng'=>'121.303422','lat'=>'23.346369']);
        $this->insert('{{%region}}',['id'=>'3697','pid'=>'3325','shortname'=>'澎湖','name'=>'澎湖县','merger_name'=>'中国,台湾省,澎湖县','level'=>'2','pinyin'=>'penghu','code'=>'06','zip_code'=>'8','first'=>'P','lng'=>'119.566417','lat'=>'23.569733']);
        $this->insert('{{%region}}',['id'=>'3698','pid'=>'3697','shortname'=>'马公','name'=>'马公市','merger_name'=>'中国,台湾省,澎湖县,马公市','level'=>'3','pinyin'=>'magong','code'=>'06','zip_code'=>'880','first'=>'M','lng'=>'119.566499','lat'=>'23.565845']);
        $this->insert('{{%region}}',['id'=>'3699','pid'=>'3697','shortname'=>'湖西','name'=>'湖西乡','merger_name'=>'中国,台湾省,澎湖县,湖西乡','level'=>'3','pinyin'=>'huxi','code'=>'06','zip_code'=>'885','first'=>'H','lng'=>'119.659666','lat'=>'23.583358']);
        $this->insert('{{%region}}',['id'=>'3700','pid'=>'3697','shortname'=>'白沙','name'=>'白沙乡','merger_name'=>'中国,台湾省,澎湖县,白沙乡','level'=>'3','pinyin'=>'baisha','code'=>'06','zip_code'=>'884','first'=>'B','lng'=>'119.597919','lat'=>'23.666060']);
        $this->insert('{{%region}}',['id'=>'3701','pid'=>'3697','shortname'=>'西屿','name'=>'西屿乡','merger_name'=>'中国,台湾省,澎湖县,西屿乡','level'=>'3','pinyin'=>'xiyu','code'=>'06','zip_code'=>'881','first'=>'X','lng'=>'119.506974','lat'=>'23.600836']);
        $this->insert('{{%region}}',['id'=>'3702','pid'=>'3697','shortname'=>'望安','name'=>'望安乡','merger_name'=>'中国,台湾省,澎湖县,望安乡','level'=>'3','pinyin'=>'wang\'an','code'=>'06','zip_code'=>'882','first'=>'W','lng'=>'119.500538','lat'=>'23.357531']);
        $this->insert('{{%region}}',['id'=>'3703','pid'=>'3697','shortname'=>'七美','name'=>'七美乡','merger_name'=>'中国,台湾省,澎湖县,七美乡','level'=>'3','pinyin'=>'qimei','code'=>'06','zip_code'=>'883','first'=>'Q','lng'=>'119.423929','lat'=>'23.206018']);
        $this->insert('{{%region}}',['id'=>'3704','pid'=>'3325','shortname'=>'金门','name'=>'金门县','merger_name'=>'中国,台湾省,金门县','level'=>'2','pinyin'=>'jinmen','code'=>'082','zip_code'=>'8','first'=>'J','lng'=>'118.317089','lat'=>'24.432706']);
        $this->insert('{{%region}}',['id'=>'3705','pid'=>'3704','shortname'=>'金城','name'=>'金城镇','merger_name'=>'中国,台湾省,金门县,金城镇','level'=>'3','pinyin'=>'jincheng','code'=>'082','zip_code'=>'893','first'=>'J','lng'=>'118.316667','lat'=>'24.416667']);
        $this->insert('{{%region}}',['id'=>'3706','pid'=>'3704','shortname'=>'金湖','name'=>'金湖镇','merger_name'=>'中国,台湾省,金门县,金湖镇','level'=>'3','pinyin'=>'jinhu','code'=>'082','zip_code'=>'891','first'=>'J','lng'=>'118.419743','lat'=>'24.438633']);
        $this->insert('{{%region}}',['id'=>'3707','pid'=>'3704','shortname'=>'金沙','name'=>'金沙镇','merger_name'=>'中国,台湾省,金门县,金沙镇','level'=>'3','pinyin'=>'jinsha','code'=>'082','zip_code'=>'890','first'=>'J','lng'=>'118.427993','lat'=>'24.481109']);
        $this->insert('{{%region}}',['id'=>'3708','pid'=>'3704','shortname'=>'金宁','name'=>'金宁乡','merger_name'=>'中国,台湾省,金门县,金宁乡','level'=>'3','pinyin'=>'jinning','code'=>'082','zip_code'=>'892','first'=>'J','lng'=>'118.334506','lat'=>'24.45672']);
        $this->insert('{{%region}}',['id'=>'3709','pid'=>'3704','shortname'=>'烈屿','name'=>'烈屿乡','merger_name'=>'中国,台湾省,金门县,烈屿乡','level'=>'3','pinyin'=>'lieyu','code'=>'082','zip_code'=>'894','first'=>'L','lng'=>'118.247255','lat'=>'24.433102']);
        $this->insert('{{%region}}',['id'=>'3710','pid'=>'3704','shortname'=>'乌丘','name'=>'乌丘乡','merger_name'=>'中国,台湾省,金门县,乌丘乡','level'=>'3','pinyin'=>'wuqiu','code'=>'082','zip_code'=>'896','first'=>'W','lng'=>'118.319578','lat'=>'24.435038']);
        $this->insert('{{%region}}',['id'=>'3711','pid'=>'3325','shortname'=>'连江','name'=>'连江县','merger_name'=>'中国,台湾省,连江县','level'=>'2','pinyin'=>'lienchiang','code'=>'0836','zip_code'=>'2','first'=>'L','lng'=>'119.539704','lat'=>'26.197364']);
        $this->insert('{{%region}}',['id'=>'3712','pid'=>'3711','shortname'=>'南竿','name'=>'南竿乡','merger_name'=>'中国,台湾省,连江县,南竿乡','level'=>'3','pinyin'=>'nangan','code'=>'0836','zip_code'=>'209','first'=>'N','lng'=>'119.944267','lat'=>'26.144035']);
        $this->insert('{{%region}}',['id'=>'3713','pid'=>'3711','shortname'=>'北竿','name'=>'北竿乡','merger_name'=>'中国,台湾省,连江县,北竿乡','level'=>'3','pinyin'=>'beigan','code'=>'0836','zip_code'=>'210','first'=>'B','lng'=>'120.000572','lat'=>'26.221983']);
        $this->insert('{{%region}}',['id'=>'3714','pid'=>'3711','shortname'=>'莒光','name'=>'莒光乡','merger_name'=>'中国,台湾省,连江县,莒光乡','level'=>'3','pinyin'=>'juguang','code'=>'0836','zip_code'=>'211','first'=>NULL,'lng'=>'119.940405','lat'=>'25.976256']);
        $this->insert('{{%region}}',['id'=>'3715','pid'=>'3711','shortname'=>'东引','name'=>'东引乡','merger_name'=>'中国,台湾省,连江县,东引乡','level'=>'3','pinyin'=>'dongyin','code'=>'0836','zip_code'=>'212','first'=>'D','lng'=>'120.493955','lat'=>'26.366164']);
        $this->insert('{{%region}}',['id'=>'3716','pid'=>'0','shortname'=>'香港','name'=>'香港特别行政区','merger_name'=>'中国,香港特别行政区','level'=>'1','pinyin'=>'hongkong','code'=>'','zip_code'=>'','first'=>'X','lng'=>'114.173355','lat'=>'22.320048']);
        $this->insert('{{%region}}',['id'=>'3717','pid'=>'3716','shortname'=>'香港岛','name'=>'香港岛','merger_name'=>'中国,香港特别行政区,香港岛','level'=>'2','pinyin'=>'hongkongisland','code'=>'00852','zip_code'=>'999077','first'=>'X','lng'=>'114.177314','lat'=>'22.266416']);
        $this->insert('{{%region}}',['id'=>'3718','pid'=>'3717','shortname'=>'中西区','name'=>'中西区','merger_name'=>'中国,香港特别行政区,香港岛,中西区','level'=>'3','pinyin'=>'centralandwesterndistrict','code'=>'00852','zip_code'=>'999077','first'=>'Z','lng'=>'114.154374','lat'=>'22.281981']);
        $this->insert('{{%region}}',['id'=>'3719','pid'=>'3717','shortname'=>'湾仔区','name'=>'湾仔区','merger_name'=>'中国,香港特别行政区,香港岛,湾仔区','level'=>'3','pinyin'=>'wanchaidistrict','code'=>'00852','zip_code'=>'999077','first'=>'W','lng'=>'114.182915','lat'=>'22.276389']);
        $this->insert('{{%region}}',['id'=>'3720','pid'=>'3717','shortname'=>'东区','name'=>'东区','merger_name'=>'中国,香港特别行政区,香港岛,东区','level'=>'3','pinyin'=>'easterndistrict','code'=>'00852','zip_code'=>'999077','first'=>'D','lng'=>'114.255993','lat'=>'22.262755']);
        $this->insert('{{%region}}',['id'=>'3721','pid'=>'3717','shortname'=>'南区','name'=>'南区','merger_name'=>'中国,香港特别行政区,香港岛,南区','level'=>'3','pinyin'=>'southerndistrict','code'=>'00852','zip_code'=>'999077','first'=>'N','lng'=>'114.174134','lat'=>'22.24676']);
        $this->insert('{{%region}}',['id'=>'3722','pid'=>'3716','shortname'=>'九龙','name'=>'九龙','merger_name'=>'中国,香港特别行政区,九龙','level'=>'2','pinyin'=>'kowloon','code'=>'00852','zip_code'=>'999077','first'=>'J','lng'=>'114.17495','lat'=>'22.327115']);
        $this->insert('{{%region}}',['id'=>'3723','pid'=>'3722','shortname'=>'油尖旺','name'=>'油尖旺区','merger_name'=>'中国,香港特别行政区,九龙,油尖旺区','level'=>'3','pinyin'=>'yautsimmong','code'=>'00852','zip_code'=>'999077','first'=>'Y','lng'=>'114.173332','lat'=>'22.311704']);
        $this->insert('{{%region}}',['id'=>'3724','pid'=>'3722','shortname'=>'深水埗','name'=>'深水埗区','merger_name'=>'中国,香港特别行政区,九龙,深水埗区','level'=>'3','pinyin'=>'shamshuipo','code'=>'00852','zip_code'=>'999077','first'=>NULL,'lng'=>'114.16721','lat'=>'22.328171']);
        $this->insert('{{%region}}',['id'=>'3725','pid'=>'3722','shortname'=>'九龙城','name'=>'九龙城区','merger_name'=>'中国,香港特别行政区,九龙,九龙城区','level'=>'3','pinyin'=>'jiulongcheng','code'=>'00852','zip_code'=>'999077','first'=>'J','lng'=>'114.195053','lat'=>'22.32673']);
        $this->insert('{{%region}}',['id'=>'3726','pid'=>'3722','shortname'=>'黄大仙','name'=>'黄大仙区','merger_name'=>'中国,香港特别行政区,九龙,黄大仙区','level'=>'3','pinyin'=>'wongtaisin','code'=>'00852','zip_code'=>'999077','first'=>'H','lng'=>'114.19924','lat'=>'22.336313']);
        $this->insert('{{%region}}',['id'=>'3727','pid'=>'3722','shortname'=>'观塘','name'=>'观塘区','merger_name'=>'中国,香港特别行政区,九龙,观塘区','level'=>'3','pinyin'=>'kwuntong','code'=>'00852','zip_code'=>'999077','first'=>'G','lng'=>'114.231268','lat'=>'22.30943']);
        $this->insert('{{%region}}',['id'=>'3728','pid'=>'3716','shortname'=>'新界','name'=>'新界','merger_name'=>'中国,香港特别行政区,新界','level'=>'2','pinyin'=>'newterritories','code'=>'00852','zip_code'=>'999077','first'=>'X','lng'=>'114.202408','lat'=>'22.341766']);
        $this->insert('{{%region}}',['id'=>'3729','pid'=>'3728','shortname'=>'荃湾','name'=>'荃湾区','merger_name'=>'中国,香港特别行政区,新界,荃湾区','level'=>'3','pinyin'=>'tsuenwan','code'=>'00852','zip_code'=>'999077','first'=>NULL,'lng'=>'114.122952','lat'=>'22.370973']);
        $this->insert('{{%region}}',['id'=>'3730','pid'=>'3728','shortname'=>'屯门','name'=>'屯门区','merger_name'=>'中国,香港特别行政区,新界,屯门区','level'=>'3','pinyin'=>'tuenmun','code'=>'00852','zip_code'=>'999077','first'=>'T','lng'=>'113.977416','lat'=>'22.391047']);
        $this->insert('{{%region}}',['id'=>'3731','pid'=>'3728','shortname'=>'元朗','name'=>'元朗区','merger_name'=>'中国,香港特别行政区,新界,元朗区','level'=>'3','pinyin'=>'yuenlong','code'=>'00852','zip_code'=>'999077','first'=>'Y','lng'=>'114.039796','lat'=>'22.443342']);
        $this->insert('{{%region}}',['id'=>'3732','pid'=>'3728','shortname'=>'北区','name'=>'北区','merger_name'=>'中国,香港特别行政区,新界,北区','level'=>'3','pinyin'=>'northdistrict','code'=>'00852','zip_code'=>'999077','first'=>'B','lng'=>'114.148959','lat'=>'22.494086']);
        $this->insert('{{%region}}',['id'=>'3733','pid'=>'3728','shortname'=>'大埔','name'=>'大埔区','merger_name'=>'中国,香港特别行政区,新界,大埔区','level'=>'3','pinyin'=>'taipo','code'=>'00852','zip_code'=>'999077','first'=>'D','lng'=>'114.171743','lat'=>'22.445653']);
        $this->insert('{{%region}}',['id'=>'3734','pid'=>'3728','shortname'=>'西贡','name'=>'西贡区','merger_name'=>'中国,香港特别行政区,新界,西贡区','level'=>'3','pinyin'=>'saikung','code'=>'00852','zip_code'=>'999077','first'=>'X','lng'=>'114.27854','lat'=>'22.37944']);
        $this->insert('{{%region}}',['id'=>'3735','pid'=>'3728','shortname'=>'沙田','name'=>'沙田区','merger_name'=>'中国,香港特别行政区,新界,沙田区','level'=>'3','pinyin'=>'shatin','code'=>'00852','zip_code'=>'999077','first'=>'S','lng'=>'114.191941','lat'=>'22.379294']);
        $this->insert('{{%region}}',['id'=>'3736','pid'=>'3728','shortname'=>'葵青','name'=>'葵青区','merger_name'=>'中国,香港特别行政区,新界,葵青区','level'=>'3','pinyin'=>'kwaitsing','code'=>'00852','zip_code'=>'999077','first'=>'K','lng'=>'114.13932','lat'=>'22.363877']);
        $this->insert('{{%region}}',['id'=>'3737','pid'=>'3728','shortname'=>'离岛','name'=>'离岛区','merger_name'=>'中国,香港特别行政区,新界,离岛区','level'=>'3','pinyin'=>'outlyingislands','code'=>'00852','zip_code'=>'999077','first'=>'L','lng'=>'113.945842','lat'=>'22.281508']);
        $this->insert('{{%region}}',['id'=>'3738','pid'=>'0','shortname'=>'澳门','name'=>'澳门特别行政区','merger_name'=>'中国,澳门特别行政区','level'=>'1','pinyin'=>'macau','code'=>'','zip_code'=>'','first'=>'A','lng'=>'113.54909','lat'=>'22.198951']);
        $this->insert('{{%region}}',['id'=>'3739','pid'=>'3738','shortname'=>'澳门半岛','name'=>'澳门半岛','merger_name'=>'中国,澳门特别行政区,澳门半岛','level'=>'2','pinyin'=>'macaupeninsula','code'=>'00853','zip_code'=>'999078','first'=>'A','lng'=>'113.549134','lat'=>'22.198751']);
        $this->insert('{{%region}}',['id'=>'3740','pid'=>'3739','shortname'=>'花地玛堂区','name'=>'花地玛堂区','merger_name'=>'中国,澳门特别行政区,澳门半岛,花地玛堂区','level'=>'3','pinyin'=>'nossasenhoradefatima','code'=>'00853','zip_code'=>'999078','first'=>'H','lng'=>'113.552284','lat'=>'22.208067']);
        $this->insert('{{%region}}',['id'=>'3741','pid'=>'3739','shortname'=>'圣安多尼堂区','name'=>'圣安多尼堂区','merger_name'=>'中国,澳门特别行政区,澳门半岛,圣安多尼堂区','level'=>'3','pinyin'=>'santoantonio','code'=>'00853','zip_code'=>'999078','first'=>'S','lng'=>'113.564301','lat'=>'22.12381']);
        $this->insert('{{%region}}',['id'=>'3742','pid'=>'3739','shortname'=>'大堂','name'=>'大堂区','merger_name'=>'中国,澳门特别行政区,澳门半岛,大堂区','level'=>'3','pinyin'=>'sé','code'=>'00853','zip_code'=>'999078','first'=>'D','lng'=>'113.552971','lat'=>'22.188359']);
        $this->insert('{{%region}}',['id'=>'3743','pid'=>'3739','shortname'=>'望德堂区','name'=>'望德堂区','merger_name'=>'中国,澳门特别行政区,澳门半岛,望德堂区','level'=>'3','pinyin'=>'saolazaro','code'=>'00853','zip_code'=>'999078','first'=>'W','lng'=>'113.550568','lat'=>'22.194081']);
        $this->insert('{{%region}}',['id'=>'3744','pid'=>'3739','shortname'=>'风顺堂区','name'=>'风顺堂区','merger_name'=>'中国,澳门特别行政区,澳门半岛,风顺堂区','level'=>'3','pinyin'=>'saolourenco','code'=>'00853','zip_code'=>'999078','first'=>'F','lng'=>'113.541928','lat'=>'22.187368']);
        $this->insert('{{%region}}',['id'=>'3745','pid'=>'3738','shortname'=>'氹仔岛','name'=>'氹仔岛','merger_name'=>'中国,澳门特别行政区,氹仔岛','level'=>'2','pinyin'=>'taipa','code'=>'00853','zip_code'=>'999078','first'=>NULL,'lng'=>'113.577669','lat'=>'22.156838']);
        $this->insert('{{%region}}',['id'=>'3746','pid'=>'3745','shortname'=>'嘉模堂区','name'=>'嘉模堂区','merger_name'=>'中国,澳门特别行政区,氹仔岛,嘉模堂区','level'=>'3','pinyin'=>'ourladyofcarmel\'sparish','code'=>'00853','zip_code'=>'999078','first'=>'J','lng'=>'113.565303','lat'=>'22.149029']);
        $this->insert('{{%region}}',['id'=>'3747','pid'=>'3738','shortname'=>'路环岛','name'=>'路环岛','merger_name'=>'中国,澳门特别行政区,路环岛','level'=>'2','pinyin'=>'coloane','code'=>'00853','zip_code'=>'999078','first'=>'L','lng'=>'113.564857','lat'=>'22.116226']);
        $this->insert('{{%region}}',['id'=>'3748','pid'=>'3747','shortname'=>'圣方济各堂区','name'=>'圣方济各堂区','merger_name'=>'中国,澳门特别行政区,路环岛,圣方济各堂区','level'=>'3','pinyin'=>'stfrancisxavier\'sparish','code'=>'00853','zip_code'=>'999078','first'=>'S','lng'=>'113.559954','lat'=>'22.123486']);
        
        /* 设置外键约束 */
        $this->execute('SET foreign_key_checks = 1;');
    }

    public function down()
    {
        $this->execute('SET foreign_key_checks = 0');
        /* 删除表 */
        $this->dropTable('{{%region}}');
        $this->execute('SET foreign_key_checks = 1;');
    }
}

