ARG VARIANT="8.0"
# FROM mcr.microsoft.com/vscode/devcontainers/dotnetcore:0-${VARIANT}
FROM mcr.microsoft.com/dotnet/sdk:${VARIANT}

# This Dockerfile adds a non-root user with sudo access. Update the “remoteUser” property in
# devcontainer.json to use it. More info: https://aka.ms/vscode-remote/containers/non-root-user.
ARG USERNAME=vscode
ARG USER_UID=1000
ARG USER_GID=$USER_UID

# Options for common setup script - SHA generated on release
ARG INSTALL_ZSH="false"
ARG UPGRADE_PACKAGES="true"
ARG COMMON_SCRIPT_SOURCE="https://raw.githubusercontent.com/microsoft/vscode-dev-containers/master/script-library/common-debian.sh"
ARG COMMON_SCRIPT_SHA="dev-mode"

ENV PATH="${PATH}:/home/vscode/.dotnet/tools"

# Install needed packages and setup non-root user. Use a separate RUN statement to add your own dependencies.
RUN apt-get update \
    && export DEBIAN_FRONTEND=noninteractive \
    && apt-get -y install --no-install-recommends curl ca-certificates 2>&1 \
    && curl -sSL  ${COMMON_SCRIPT_SOURCE} -o /tmp/common-setup.sh \
    && ([ "${COMMON_SCRIPT_SHA}" = "dev-mode" ] || (echo "${COMMON_SCRIPT_SHA} /tmp/common-setup.sh" | sha256sum -c -)) \
    && /bin/bash /tmp/common-setup.sh "${INSTALL_ZSH}" "${USERNAME}" "${USER_UID}" "${USER_GID}" "${UPGRADE_PACKAGES}" \
    # Clean up
    && apt-get autoremove -y \
    && apt-get clean -y \
    && rm -rf /var/lib/apt/lists/* /tmp/common-setup.sh

ARG PACKAGE_VERSION="*"

COPY nupkg /tmp/nupkg

RUN \
    dotnet tool install ghul.compiler --tool-path /usr/local/bin --version "${PACKAGE_VERSION}" --add-source /tmp/nupkg && \
    chmod +x `find /usr/local/bin/.store/ghul.compiler/ -type f -name ilasm` && \
    ln -s /usr/local/bin/ghul-compiler /usr/local/bin/dotnet-ghul-compiler