# IR values

IR value nodes represent operands and expressions during code generation.  Each value usually corresponds to a single IL instruction, though some combine multiple steps for convenience.  Every value has an optional `Type` and may be able to produce an address for use with load/store instructions.

Important concepts:

- `value.ghul` – base class with common properties such as `type` and `has_address`.
- Subfolders `call/`, `load/`, `store/` and `literal/` group values that map directly to IL opcodes.
- Higher level nodes like `tuple.ghul` or `isa.ghul` expand into several IL instructions when emitted.
- `block.ghul` groups a sequence of values

Values are generated by the `generate_il` pass and emitted in order by the IR context, ultimately producing the IL assembler source fed to `ilasm`.
