# WiX Toolset v3 Manual Table of Contents

* [Windows Installer XML (WiX)](main/index.md)
   * [WiX Toolset License](main/license.md)
   * [Getting Started Learning WiX](main/wix_learning.md)
   * [Getting Help](main/help.md)
* [Tools and Concepts](overview/index.md)
   * [File Types](overview/files.md)
   * [List of Tools](overview/alltools.md)
   * [Tools and Concepts](overview/tools.md)
   * [Preprocessor](overview/preprocessor.md)
   * [Compiler](overview/candle.md)
   * [Linker (light)](overview/light.md)
   * [Library Tool (lit)](overview/lit.md)
   * [Harvest Tool (Heat)](overview/heat.md)
   * [Insignia](overview/insignia.md)
   * [WixCop](overview/wixcop.md)
   * [Unit-testing custom actions with Lux](overview/lux.md)
   * [MSI Tables to WiX Schema](overview/msitowix.md)
   * [Code Pages](overview/codepage.md)
   * [Useful Windows Installer Information](overview/msi_useful_links.md)
* [Working in Visual Studio](votive/index.md)
   * [Project Templates](votive/votive_project_templates.md)
   * [Item Templates](votive/votive_item_templates.md)
   * [Project Property Pages](votive/votive_property_pages.md)
   * [Reading the Default WiX Project Template](votive/votive_project_template_default.md)
   * [Creating a simple setup](votive/authoring_first_votive_project.md)
   * [Using Project References and Variables](votive/votive_project_references.md)
* [Working with MSBuild](msbuild/index.md)
   * [Creating a .wixproj File](msbuild/authoring_first_msbuild_project.md)
   * [Integrating WiX Projects Into Daily Builds](msbuild/daily_builds.md)
   * [Building WiX Projects In Team Foundation Build](msbuild/wix_with_team_build.md)
   * [WiX MSBuild Target Reference](msbuild/target_reference/index.md)
      * [HarvestDirectory Target](msbuild/target_reference/harvestdirectory.md)
      * [HarvestFile Target](msbuild/target_reference/harvestfile.md)
      * [HarvestProjects Target](msbuild/target_reference/harvestprojects.md)
   * [WiX MSBuild Task Reference](msbuild/task_reference/index.md)
      * [Candle Task](msbuild/task_reference/candle.md)
      * [HeatDirectory Task](msbuild/task_reference/heatdirectory.md)
      * [HeatFile Task](msbuild/task_reference/heatfile.md)
      * [HeatProject Task](msbuild/task_reference/heatproject.md)
      * [Insignia Task](msbuild/task_reference/insignia.md)
      * [Light Task](msbuild/task_reference/light.md)
      * [Lit Task](msbuild/task_reference/lit.md)
* [WixUI Dialog Library](wixui/index.md)
   * [Using Built-in WixUI Dialog Sets](wixui/wixui_dialog_library.md)
   * [Customizing Built-in WixUI Dialog Sets](wixui/wixui_customizations.md)
   * [Using Localized Versions of WixUI](wixui/wixui_localization.md)
   * [WixUI Dialog Library Reference](wixui/dialog_reference/index.md)
      * [WixUI_Advanced Dialog Set](wixui/dialog_reference/wixui_advanced.md)
      * [WixUI_FeatureTree Dialog Set](wixui/dialog_reference/wixui_featuretree.md)
      * [WixUI_InstallDir Dialog Set](wixui/dialog_reference/wixui_installdir.md)
      * [WixUI_Minimal Dialog Set](wixui/dialog_reference/wixui_minimal.md)
      * [WixUI_Mondo Dialog Set](wixui/dialog_reference/wixui_mondo.md)
      * [WixUI Dialogs](wixui/dialog_reference/wixui_dialogs.md)
* [Building Installation Package Bundles](bundle/index.md)
   * [Create the Skeleton Bundle Authoring](bundle/authoring_bundle_skeleton.md)
   * [Author Bootstrapper Application for a Bundle](bundle/authoring_bundle_application.md)
   * [Author a Bundle Package Manifest](bundle/authoring_bundle_package_manifest.md)
   * [Burn Built-in Variables](bundle/bundle_built_in_variables.md)
   * [Define Searches Using Variables](bundle/bundle_define_searches.md)
   * [Chain Packages into a Bundle](bundle/bundle_author_chain.md)
   * [Working with WiX Standard Bootstrapper Application](bundle/wixstdba/index.md)
      * [Specifying the WiX Standard Bootstrapper Application License](bundle/wixstdba/wixstdba_license.md)
      * [Changing the WiX Standard Bootstrapper Application Branding](bundle/wixstdba/wixstdba_branding.md)
      * [Customize the WiX Standard Bootstrapper Application Layout](bundle/wixstdba/wixstdba_customize.md)
      * [Using WiX Standard Bootstrapper Application Variables](bundle/wixstdba/wixstdba_variables.md)
   * [Building a Custom Bootstrapper Application](bundle/ba/index.md)
      * [Bootstrapper Application Interface](bundle/ba/bootstrapper_application_interface.md)
* [How To Guides](howtos/index.md)
   * [How To: Files, Shortcuts and Registry](howtos/files_and_registry/index.md)
      * [How To: Add a File to Your Installer](howtos/files_and_registry/add_a_file.md)
      * [How To: Check the Version Number of a File During Installation](howtos/files_and_registry/check_the_version_number.md)
      * [How To: Create a Shortcut on the Start Menu](howtos/files_and_registry/create_start_menu_shortcut.md)
      * [How To: Create a Shortcut to a Webpage](howtos/files_and_registry/create_internet_shortcut.md)
      * [How To: Create an Uninstall Shortcut](howtos/files_and_registry/create_uninstall_shortcut.md)
      * [How To: NGen Managed Assemblies During Installation](howtos/files_and_registry/ngen_managed_assemblies.md)
      * [How To: Reference another DirectorySearch element](howtos/files_and_registry/directorysearchref.md)
      * [How To: Get the parent directory of a file search](howtos/files_and_registry/parentdirectorysearch.md)
      * [How To: Read a Registry Entry During Installation](howtos/files_and_registry/read_a_registry_entry.md)
      * [How To: Write a Registry Entry During Installation](howtos/files_and_registry/write_a_registry_entry.md)
   * [How To: Redistributables and Install Checks](howtos/redistributables_and_install_checks/index.md)
      * [How To: Block Installation Based on OS Version](howtos/redistributables_and_install_checks/block_install_on_os.md)
      * [How To: Block Bootstrapper Installation Based on Registry Key](howtos/redistributables_and_install_checks/block_stdba_install_on_reg.md)
      * [How To: Check for .NET Framework Versions](howtos/redistributables_and_install_checks/check_for_dotnet.md)
      * [How To: Install DirectX 9.0 With Your Installer](howtos/redistributables_and_install_checks/install_directx9.md)
      * [How To: Install the .NET Framework Using Burn](howtos/redistributables_and_install_checks/install_dotnet.md)
      * [How To: Install the Visual C++ Redistributable with your installer](howtos/redistributables_and_install_checks/install_vcredist.md)
   * [How To: User Interface and Localization](howtos/ui_and_localization/index.md)
      * [How To: Build a Localized Version of Your Installer](howtos/ui_and_localization/build_a_localized_version.md)
      * [Specifying Cultures to Build](howtos/ui_and_localization/specifying_cultures_to_build.md)
      * [How To: Make your installer localizable](howtos/ui_and_localization/make_installer_localizable.md)
      * [How To: Set Your Installer's Icon in Add/Remove Programs](howtos/ui_and_localization/configure_arp_appearance.md)
      * [How To: Run the Installed Application After Setup](howtos/ui_and_localization/run_program_after_install.md)
   * [How To: Updates](howtos/updates/index.md)
      * [How To: Implement a Major Upgrade In Your Installer](howtos/updates/major_upgrade.md)
   * [How to: Author product dependencies](howtos/author_product_dependencies.md)
   * [How To: General How Tos](howtos/general/index.md)
      * [How To: Use WiX Extensions](howtos/general/extension_usage_introduction.md)
      * [How To: Generate a GUID](howtos/general/generate_guids.md)
      * [How To: Get a Log of Your Installation for Debugging](howtos/general/get_a_log.md)
      * [How To: Look Inside Your MSI With Orca](howtos/general/look_inside_msi.md)
      * [How To: Optimize build speed](howtos/general/optimizing_builds.md)
      * [How To: Specify source files](howtos/general/specifying_source_files.md)
      * [How To: Install a Windows service](howtos/general/install_windows_service.md)
* [Standard Custom Actions](customactions/index.md)
   * [Using Standard Custom Actions](customactions/using_standard_customactions.md)
   * [OSInfo custom actions](customactions/osinfo.md)
   * [Performance Counter Custom Action](customactions/perfmon.md)
   * [Quiet Execution Custom Action](customactions/qtexec.md)
   * [ShellExecute CustomAction](customactions/shellexec.md)
   * [WixDirectXExtension](customactions/wixdirectxextension.md)
   * [WixExitEarlyWithSuccess Custom Action](customactions/wixexitearlywithsuccess.md)
   * [WixFailWhenDeferred Custom Action](customactions/wixfailwhendeferred.md)
   * [WixGamingExtension](customactions/wixgamingextension.md)
   * [WixNetfxExtension](customactions/wixnetfxextension.md)
   * [WixBroadcastSettingChange and WixBroadcastEnvironmentChange Custom Actions](customactions/wixsettingchange.md)
   * [WixVSExtension](customactions/wixvsextension.md)
   * [WixWaitForEvent Custom Action](customactions/wixwaitforevent.md)
* [Creating patches](patching/index.md)
   * [Using Patch Creation Properties](patching/patch_building.md)
   * [Restrictions for Patches](patching/patch_restrictions.md)
   * [Using Purely WiX](patching/wix_patching.md)
* [WiX Schema References](xsd/index.md)
   * [Bal Schema](xsd/bal/index.md)
      * [Condition Element (Bal Extension)](xsd/bal/condition.md)
      * [Overridable Attribute (Bal Extension)](xsd/bal/overridable.md)
      * [PrereqSupportPackage Attribute (Bal Extension)](xsd/bal/prereqsupportpackage.md)
      * [UseUILanguages Attribute (Bal Extension)](xsd/bal/useuilanguages.md)
      * [WixManagedBootstrapperApplicationHost Element (Bal Extension)](xsd/bal/wixmanagedbootstrapperapplicationhost.md)
      * [WixStandardBootstrapperApplication Element (Bal Extension)](xsd/bal/wixstandardbootstrapperapplication.md)
   * [Complus Schema](xsd/complus/index.md)
      * [ComPlusApplication Element (Complus Extension)](xsd/complus/complusapplication.md)
      * [ComPlusApplicationRole Element (Complus Extension)](xsd/complus/complusapplicationrole.md)
      * [ComPlusAssembly Element (Complus Extension)](xsd/complus/complusassembly.md)
      * [ComPlusAssemblyDependency Element (Complus Extension)](xsd/complus/complusassemblydependency.md)
      * [ComPlusComponent Element (Complus Extension)](xsd/complus/compluscomponent.md)
      * [ComPlusGroupInApplicationRole Element (Complus Extension)](xsd/complus/complusgroupinapplicationrole.md)
      * [ComPlusGroupInPartitionRole Element (Complus Extension)](xsd/complus/complusgroupinpartitionrole.md)
      * [ComPlusInterface Element (Complus Extension)](xsd/complus/complusinterface.md)
      * [ComPlusMethod Element (Complus Extension)](xsd/complus/complusmethod.md)
      * [ComPlusPartition Element (Complus Extension)](xsd/complus/compluspartition.md)
      * [ComPlusPartitionRole Element (Complus Extension)](xsd/complus/compluspartitionrole.md)
      * [ComPlusPartitionUser Element (Complus Extension)](xsd/complus/compluspartitionuser.md)
      * [ComPlusRoleForComponent Element (Complus Extension)](xsd/complus/complusroleforcomponent.md)
      * [ComPlusRoleForInterface Element (Complus Extension)](xsd/complus/complusroleforinterface.md)
      * [ComPlusRoleForMethod Element (Complus Extension)](xsd/complus/complusroleformethod.md)
      * [ComPlusSubscription Element (Complus Extension)](xsd/complus/complussubscription.md)
      * [ComPlusUserInApplicationRole Element (Complus Extension)](xsd/complus/complususerinapplicationrole.md)
      * [ComPlusUserInPartitionRole Element (Complus Extension)](xsd/complus/complususerinpartitionrole.md)
   * [Dependency Schema](xsd/dependency/index.md)
      * [ProviderKey Attribute (Dependency Extension)](xsd/dependency/providerkey.md)
      * [Provides Element (Dependency Extension)](xsd/dependency/provides.md)
      * [Requires Element (Dependency Extension)](xsd/dependency/requires.md)
      * [RequiresRef Element (Dependency Extension)](xsd/dependency/requiresref.md)
   * [Difxapp Schema](xsd/difxapp/index.md)
      * [Driver Element (Difxapp Extension)](xsd/difxapp/driver.md)
   * [Firewall Schema](xsd/firewall/index.md)
      * [FirewallException Element (Firewall Extension)](xsd/firewall/firewallexception.md)
      * [RemoteAddress Element (Firewall Extension)](xsd/firewall/remoteaddress.md)
   * [Gaming Schema](xsd/gaming/index.md)
      * [Game Element (Gaming Extension)](xsd/gaming/game.md)
      * [IsRichSavedGame Attribute (Gaming Extension)](xsd/gaming/isrichsavedgame.md)
      * [PlayTask Element (Gaming Extension)](xsd/gaming/playtask.md)
      * [SupportTask Element (Gaming Extension)](xsd/gaming/supporttask.md)
   * [Http Schema](xsd/http/index.md)
      * [UrlAce Element (Http Extension)](xsd/http/urlace.md)
      * [UrlReservation Element (Http Extension)](xsd/http/urlreservation.md)
   * [Iis Schema](xsd/iis/index.md)
      * [Certificate Element (Iis Extension)](xsd/iis/certificate.md)
      * [CertificateRef Element (Iis Extension)](xsd/iis/certificateref.md)
      * [HttpHeader Element (Iis Extension)](xsd/iis/httpheader.md)
      * [MimeMap Element (Iis Extension)](xsd/iis/mimemap.md)
      * [RecycleTime Element (Iis Extension)](xsd/iis/recycletime.md)
      * [WebAddress Element (Iis Extension)](xsd/iis/webaddress.md)
      * [WebApplication Element (Iis Extension)](xsd/iis/webapplication.md)
      * [WebApplicationExtension Element (Iis Extension)](xsd/iis/webapplicationextension.md)
      * [WebAppPool Element (Iis Extension)](xsd/iis/webapppool.md)
      * [WebDir Element (Iis Extension)](xsd/iis/webdir.md)
      * [WebDirProperties Element (Iis Extension)](xsd/iis/webdirproperties.md)
      * [WebError Element (Iis Extension)](xsd/iis/weberror.md)
      * [WebFilter Element (Iis Extension)](xsd/iis/webfilter.md)
      * [WebLog Element (Iis Extension)](xsd/iis/weblog.md)
      * [WebProperty Element (Iis Extension)](xsd/iis/webproperty.md)
      * [WebServiceExtension Element (Iis Extension)](xsd/iis/webserviceextension.md)
      * [WebSite Element (Iis Extension)](xsd/iis/website.md)
      * [WebVirtualDir Element (Iis Extension)](xsd/iis/webvirtualdir.md)
   * [Lux Schema](xsd/lux/index.md)
      * [Condition Element (Lux Extension)](xsd/lux/condition.md)
      * [Expression Element (Lux Extension)](xsd/lux/expression.md)
      * [Mutation Element (Lux Extension)](xsd/lux/mutation.md)
      * [UnitTest Element (Lux Extension)](xsd/lux/unittest.md)
      * [UnitTestRef Element (Lux Extension)](xsd/lux/unittestref.md)
   * [Msmq Schema](xsd/msmq/index.md)
      * [MessageQueue Element (Msmq Extension)](xsd/msmq/messagequeue.md)
      * [MessageQueuePermission Element (Msmq Extension)](xsd/msmq/messagequeuepermission.md)
   * [Netfx Schema](xsd/netfx/index.md)
      * [NativeImage Element (Netfx Extension)](xsd/netfx/nativeimage.md)
   * [Ps Schema](xsd/ps/index.md)
      * [FormatsFile Element (Ps Extension)](xsd/ps/formatsfile.md)
      * [RequiredVersion Attribute (Ps Extension)](xsd/ps/requiredversion.md)
      * [SnapIn Element (Ps Extension)](xsd/ps/snapin.md)
      * [TypesFile Element (Ps Extension)](xsd/ps/typesfile.md)
   * [Sql Schema](xsd/sql/index.md)
      * [SqlDatabase Element (Sql Extension)](xsd/sql/sqldatabase.md)
      * [SqlFileSpec Element (Sql Extension)](xsd/sql/sqlfilespec.md)
      * [SqlLogFileSpec Element (Sql Extension)](xsd/sql/sqllogfilespec.md)
      * [SqlScript Element (Sql Extension)](xsd/sql/sqlscript.md)
      * [SqlString Element (Sql Extension)](xsd/sql/sqlstring.md)
   * [Tag Schema](xsd/tag/index.md)
      * [Tag Element (Tag Extension)](xsd/tag/tag/)
      * [TagRef Element (Tag Extension)](xsd/tag/tagref.md)
   * [Thmutil Schema](xsd/thmutil/index.md)
      * [Billboard Element (Thmutil Extension)](xsd/thmutil/billboard.md)
      * [Button Element (Thmutil Extension)](xsd/thmutil/button.md)
      * [Checkbox Element (Thmutil Extension)](xsd/thmutil/checkbox.md)
      * [Column Element (Thmutil Extension)](xsd/thmutil/column.md)
      * [Combobox Element (Thmutil Extension)](xsd/thmutil/combobox.md)
      * [Editbox Element (Thmutil Extension)](xsd/thmutil/editbox.md)
      * [Font Element (Thmutil Extension)](xsd/thmutil/font.md)
      * [Hyperlink Element (Thmutil Extension)](xsd/thmutil/hyperlink.md)
      * [Hypertext Element (Thmutil Extension)](xsd/thmutil/hypertext.md)
      * [Image Element (Thmutil Extension)](xsd/thmutil/image.md)
      * [ImageList Element (Thmutil Extension)](xsd/thmutil/imagelist.md)
      * [ListView Element (Thmutil Extension)](xsd/thmutil/listview.md)
      * [Page Element (Thmutil Extension)](xsd/thmutil/page.md)
      * [Progressbar Element (Thmutil Extension)](xsd/thmutil/progressbar.md)
      * [Richedit Element (Thmutil Extension)](xsd/thmutil/richedit.md)
      * [Static Element (Thmutil Extension)](xsd/thmutil/static.md)
      * [Tab Element (Thmutil Extension)](xsd/thmutil/tab.md)
      * [Text Element (Thmutil Extension)](xsd/thmutil/text.md)
      * [Theme Element (Thmutil Extension)](xsd/thmutil/theme.md)
      * [TreeView Element (Thmutil Extension)](xsd/thmutil/treeview.md)
      * [Window Element (Thmutil Extension)](xsd/thmutil/window.md)
   * [Util Schema](xsd/util/index.md)
      * [CloseApplication Element (Util Extension)](xsd/util/closeapplication.md)
      * [ComponentSearch Element (Util Extension)](xsd/util/componentsearch.md)
      * [ComponentSearchRef Element (Util Extension)](xsd/util/componentsearchref.md)
      * [DirectorySearch Element (Util Extension)](xsd/util/directorysearch.md)
      * [DirectorySearchRef Element (Util Extension)](xsd/util/directorysearchref.md)
      * [EventManifest Element (Util Extension)](xsd/util/eventmanifest.md)
      * [EventSource Element (Util Extension)](xsd/util/eventsource.md)
      * [FileSearch Element (Util Extension)](xsd/util/filesearch.md)
      * [FileSearchRef Element (Util Extension)](xsd/util/filesearchref.md)
      * [FileShare Element (Util Extension)](xsd/util/fileshare.md)
      * [FileSharePermission Element (Util Extension)](xsd/util/filesharepermission.md)
      * [Group Element (Util Extension)](xsd/util/group.md)
      * [GroupRef Element (Util Extension)](xsd/util/groupref.md)
      * [InternetShortcut Element (Util Extension)](xsd/util/internetshortcut.md)
      * [PerfCounter Element (Util Extension)](xsd/util/perfcounter.md)
      * [PerfCounterManifest Element (Util Extension)](xsd/util/perfcountermanifest.md)
      * [PerformanceCategory Element (Util Extension)](xsd/util/performancecategory.md)
      * [PerformanceCounter Element (Util Extension)](xsd/util/performancecounter.md)
      * [PermissionEx Element (Util Extension)](xsd/util/permissionex.md)
      * [ProductSearch Element (Util Extension)](xsd/util/productsearch.md)
      * [ProductSearchRef Element (Util Extension)](xsd/util/productsearchref.md)
      * [RegistrySearch Element (Util Extension)](xsd/util/registrysearch.md)
      * [RegistrySearchRef Element (Util Extension)](xsd/util/registrysearchref.md)
      * [RemoveFolderEx Element (Util Extension)](xsd/util/removefolderex.md)
      * [RestartResource Element (Util Extension)](xsd/util/restartresource.md)
      * [ServiceConfig Element (Util Extension)](xsd/util/serviceconfig.md)
      * [User Element (Util Extension)](xsd/util/user.md)
      * [XmlConfig Element (Util Extension)](xsd/util/xmlconfig.md)
      * [XmlFile Element (Util Extension)](xsd/util/xmlfile.md)
   * [Vs Schema](xsd/vs/index.md)
      * [HelpCollection Element (Vs Extension)](xsd/vs/helpcollection.md)
      * [HelpCollectionRef Element (Vs Extension)](xsd/vs/helpcollectionref.md)
      * [HelpFile Element (Vs Extension)](xsd/vs/helpfile.md)
      * [HelpFileRef Element (Vs Extension)](xsd/vs/helpfileref.md)
      * [HelpFilter Element (Vs Extension)](xsd/vs/helpfilter.md)
      * [HelpFilterRef Element (Vs Extension)](xsd/vs/helpfilterref.md)
      * [PlugCollectionInto Element (Vs Extension)](xsd/vs/plugcollectioninto.md)
      * [VsixPackage Element (Vs Extension)](xsd/vs/vsixpackage.md)
   * [Wix Schema](xsd/wix/index.md)
      * [AdminExecuteSequence Element](xsd/wix/adminexecutesequence.md)
      * [AdminUISequence Element](xsd/wix/adminuisequence.md)
      * [AdvertiseExecuteSequence Element](xsd/wix/advertiseexecutesequence.md)
      * [All Element](xsd/wix/all.md)
      * [AllocateRegistrySpace Element](xsd/wix/allocateregistryspace.md)
      * [AppData Element](xsd/wix/appdata.md)
      * [AppId Element](xsd/wix/appid.md)
      * [ApprovedExeForElevation Element](xsd/wix/approvedexeforelevation.md)
      * [AppSearch Element](xsd/wix/appsearch.md)
      * [AssemblyName Element](xsd/wix/assemblyname.md)
      * [Billboard Element](xsd/wix/billboard.md)
      * [BillboardAction Element](xsd/wix/billboardaction.md)
      * [Binary Element](xsd/wix/binary.md)
      * [BinaryRef Element](xsd/wix/binaryref.md)
      * [BindImage Element](xsd/wix/bindimage.md)
      * [BootstrapperApplication Element](xsd/wix/bootstrapperapplication.md)
      * [BootstrapperApplicationRef Element](xsd/wix/bootstrapperapplicationref.md)
      * [Bundle Element](xsd/wix/bundle.md)
      * [Catalog Element](xsd/wix/catalog.md)
      * [Category Element](xsd/wix/category.md)
      * [CCPSearch Element](xsd/wix/ccpsearch.md)
      * [Chain Element](xsd/wix/chain.md)
      * [Class Element](xsd/wix/class.md)
      * [Column Element](xsd/wix/column.md)
      * [ComboBox Element](xsd/wix/combobox.md)
      * [CommandLine Element](xsd/wix/commandline.md)
      * [ComplianceCheck Element](xsd/wix/compliancecheck.md)
      * [ComplianceDrive Element](xsd/wix/compliancedrive.md)
      * [Component Element](xsd/wix/component.md)
      * [ComponentGroup Element](xsd/wix/componentgroup.md)
      * [ComponentGroupRef Element](xsd/wix/componentgroupref.md)
      * [ComponentRef Element](xsd/wix/componentref.md)
      * [ComponentSearch Element](xsd/wix/componentsearch.md)
      * [Condition Element](xsd/wix/condition.md)
      * [Configuration Element](xsd/wix/configuration.md)
      * [ConfigurationData Element](xsd/wix/configurationdata.md)
      * [Container Element](xsd/wix/container.md)
      * [ContainerRef Element](xsd/wix/containerref.md)
      * [Control Element](xsd/wix/control.md)
      * [CopyFile Element](xsd/wix/copyfile.md)
      * [CostFinalize Element](xsd/wix/costfinalize.md)
      * [CostInitialize Element](xsd/wix/costinitialize.md)
      * [CreateFolder Element](xsd/wix/createfolder.md)
      * [CreateFolders Element](xsd/wix/createfolders.md)
      * [CreateShortcuts Element](xsd/wix/createshortcuts.md)
      * [Custom Element](xsd/wix/custom.md)
      * [CustomAction Element](xsd/wix/customaction.md)
      * [CustomActionRef Element](xsd/wix/customactionref.md)
      * [CustomProperty Element](xsd/wix/customproperty.md)
      * [CustomTable Element](xsd/wix/customtable.md)
      * [Data Element](xsd/wix/data.md)
      * [DeleteServices Element](xsd/wix/deleteservices.md)
      * [Dependency Element](xsd/wix/dependency.md)
      * [Dialog Element](xsd/wix/dialog.md)
      * [DialogRef Element](xsd/wix/dialogref.md)
      * [DigitalCertificate Element](xsd/wix/digitalcertificate.md)
      * [DigitalCertificateRef Element](xsd/wix/digitalcertificateref.md)
      * [DigitalSignature Element](xsd/wix/digitalsignature.md)
      * [Directory Element](xsd/wix/directory.md)
      * [DirectoryRef Element](xsd/wix/directoryref.md)
      * [DirectorySearch Element](xsd/wix/directorysearch.md)
      * [DirectorySearchRef Element](xsd/wix/directorysearchref.md)
      * [DisableRollback Element](xsd/wix/disablerollback.md)
      * [DuplicateFiles Element](xsd/wix/duplicatefiles.md)
      * [EmbeddedChainer Element](xsd/wix/embeddedchainer.md)
      * [EmbeddedChainerRef Element](xsd/wix/embeddedchainerref.md)
      * [EmbeddedUI Element](xsd/wix/embeddedui.md)
      * [EmbeddedUIResource Element](xsd/wix/embeddeduiresource.md)
      * [EnsureTable Element](xsd/wix/ensuretable.md)
      * [Environment Element](xsd/wix/environment.md)
      * [Error Element](xsd/wix/error.md)
      * [Exclusion Element](xsd/wix/exclusion.md)
      * [ExecuteAction Element](xsd/wix/executeaction.md)
      * [ExePackage Element](xsd/wix/exepackage.md)
      * [ExitCode Element](xsd/wix/exitcode.md)
      * [Extension Element](xsd/wix/extension.md)
      * [ExternalFile Element](xsd/wix/externalfile.md)
      * [Failure Element](xsd/wix/failure.md)
      * [Family Element](xsd/wix/family.md)
      * [Feature Element](xsd/wix/feature.md)
      * [FeatureGroup Element](xsd/wix/featuregroup.md)
      * [FeatureGroupRef Element](xsd/wix/featuregroupref.md)
      * [FeatureRef Element](xsd/wix/featureref.md)
      * [File Element](xsd/wix/file.md)
      * [FileCost Element](xsd/wix/filecost.md)
      * [FileSearch Element](xsd/wix/filesearch.md)
      * [FileSearchRef Element](xsd/wix/filesearchref.md)
      * [FileTypeMask Element](xsd/wix/filetypemask.md)
      * [FindRelatedProducts Element](xsd/wix/findrelatedproducts.md)
      * [ForceReboot Element](xsd/wix/forcereboot.md)
      * [Fragment Element](xsd/wix/fragment.md)
      * [Icon Element](xsd/wix/icon.md)
      * [IconRef Element](xsd/wix/iconref.md)
      * [IgnoreModularization Element](xsd/wix/ignoremodularization.md)
      * [IgnoreRange Element](xsd/wix/ignorerange.md)
      * [IgnoreTable Element](xsd/wix/ignoretable.md)
      * [Include Element](xsd/wix/include.md)
      * [IniFile Element](xsd/wix/inifile.md)
      * [IniFileSearch Element](xsd/wix/inifilesearch.md)
      * [InstallAdminPackage Element](xsd/wix/installadminpackage.md)
      * [InstallExecute Element](xsd/wix/installexecute.md)
      * [InstallExecuteAgain Element](xsd/wix/installexecuteagain.md)
      * [InstallExecuteSequence Element](xsd/wix/installexecutesequence.md)
      * [InstallFiles Element](xsd/wix/installfiles.md)
      * [InstallFinalize Element](xsd/wix/installfinalize.md)
      * [InstallInitialize Element](xsd/wix/installinitialize.md)
      * [InstallODBC Element](xsd/wix/installodbc.md)
      * [InstallServices Element](xsd/wix/installservices.md)
      * [InstallUISequence Element](xsd/wix/installuisequence.md)
      * [InstallValidate Element](xsd/wix/installvalidate.md)
      * [Instance Element](xsd/wix/instance.md)
      * [InstanceTransforms Element](xsd/wix/instancetransforms.md)
      * [Interface Element](xsd/wix/interface.md)
      * [IsolateComponent Element](xsd/wix/isolatecomponent.md)
      * [IsolateComponents Element](xsd/wix/isolatecomponents.md)
      * [LaunchConditions Element](xsd/wix/launchconditions.md)
      * [ListBox Element](xsd/wix/listbox.md)
      * [ListItem Element](xsd/wix/listitem.md)
      * [ListView Element](xsd/wix/listview.md)
      * [Log Element](xsd/wix/log.md)
      * [MajorUpgrade Element](xsd/wix/majorupgrade.md)
      * [Media Element](xsd/wix/media.md)
      * [MediaTemplate Element](xsd/wix/mediatemplate.md)
      * [Merge Element](xsd/wix/merge.md)
      * [MergeRef Element](xsd/wix/mergeref.md)
      * [MigrateFeatureStates Element](xsd/wix/migratefeaturestates.md)
      * [MIME Element](xsd/wix/mime.md)
      * [Module Element](xsd/wix/module.md)
      * [MoveFiles Element](xsd/wix/movefiles.md)
      * [MsiPackage Element](xsd/wix/msipackage.md)
      * [MsiProperty Element](xsd/wix/msiproperty.md)
      * [MsiPublishAssemblies Element](xsd/wix/msipublishassemblies.md)
      * [MsiUnpublishAssemblies Element](xsd/wix/msiunpublishassemblies.md)
      * [MspPackage Element](xsd/wix/msppackage.md)
      * [MsuPackage Element](xsd/wix/msupackage.md)
      * [MultiStringValue Element](xsd/wix/multistringvalue.md)
      * [ODBCDataSource Element](xsd/wix/odbcdatasource.md)
      * [ODBCDriver Element](xsd/wix/odbcdriver.md)
      * [ODBCTranslator Element](xsd/wix/odbctranslator.md)
      * [OptimizeCustomActions Element](xsd/wix/optimizecustomactions.md)
      * [OptionalUpdateRegistration Element](xsd/wix/optionalupdateregistration.md)
      * [Package Element](xsd/wix/package.md)
      * [PackageCertificates Element](xsd/wix/packagecertificates.md)
      * [PackageGroup Element](xsd/wix/packagegroup.md)
      * [PackageGroupRef Element](xsd/wix/packagegroupref.md)
      * [Patch Element](xsd/wix/patch.md)
      * [PatchBaseline Element](xsd/wix/patchbaseline.md)
      * [PatchCertificates Element](xsd/wix/patchcertificates.md)
      * [PatchCreation Element](xsd/wix/patchcreation.md)
      * [PatchFamily Element](xsd/wix/patchfamily.md)
      * [PatchFamilyGroup Element](xsd/wix/patchfamilygroup.md)
      * [PatchFamilyGroupRef Element](xsd/wix/patchfamilygroupref.md)
      * [PatchFamilyRef Element](xsd/wix/patchfamilyref.md)
      * [PatchFiles Element](xsd/wix/patchfiles.md)
      * [PatchInformation Element](xsd/wix/patchinformation.md)
      * [PatchMetadata Element](xsd/wix/patchmetadata.md)
      * [PatchProperty Element](xsd/wix/patchproperty.md)
      * [PatchSequence Element](xsd/wix/patchsequence.md)
      * [Payload Element](xsd/wix/payload.md)
      * [PayloadGroup Element](xsd/wix/payloadgroup.md)
      * [PayloadGroupRef Element](xsd/wix/payloadgroupref.md)
      * [Permission Element](xsd/wix/permission.md)
      * [PermissionEx Element](xsd/wix/permissionex.md)
      * [ProcessComponents Element](xsd/wix/processcomponents.md)
      * [Product Element](xsd/wix/product.md)
      * [ProductSearch Element](xsd/wix/productsearch.md)
      * [ProgId Element](xsd/wix/progid.md)
      * [ProgressText Element](xsd/wix/progresstext.md)
      * [Property Element](xsd/wix/property.md)
      * [PropertyRef Element](xsd/wix/propertyref.md)
      * [ProtectFile Element](xsd/wix/protectfile.md)
      * [ProtectRange Element](xsd/wix/protectrange.md)
      * [Publish Element](xsd/wix/publish.md)
      * [PublishComponents Element](xsd/wix/publishcomponents.md)
      * [PublishFeatures Element](xsd/wix/publishfeatures.md)
      * [PublishProduct Element](xsd/wix/publishproduct.md)
      * [RadioButton Element](xsd/wix/radiobutton.md)
      * [RadioButtonGroup Element](xsd/wix/radiobuttongroup.md)
      * [RegisterClassInfo Element](xsd/wix/registerclassinfo.md)
      * [RegisterComPlus Element](xsd/wix/registercomplus.md)
      * [RegisterExtensionInfo Element](xsd/wix/registerextensioninfo.md)
      * [RegisterFonts Element](xsd/wix/registerfonts.md)
      * [RegisterMIMEInfo Element](xsd/wix/registermimeinfo.md)
      * [RegisterProduct Element](xsd/wix/registerproduct.md)
      * [RegisterProgIdInfo Element](xsd/wix/registerprogidinfo.md)
      * [RegisterTypeLibraries Element](xsd/wix/registertypelibraries.md)
      * [RegisterUser Element](xsd/wix/registeruser.md)
      * [Registry Element](xsd/wix/registry.md)
      * [RegistryKey Element](xsd/wix/registrykey.md)
      * [RegistrySearch Element](xsd/wix/registrysearch.md)
      * [RegistrySearchRef Element](xsd/wix/registrysearchref.md)
      * [RegistryValue Element](xsd/wix/registryvalue.md)
      * [RelatedBundle Element](xsd/wix/relatedbundle.md)
      * [RemotePayload Element](xsd/wix/remotepayload.md)
      * [RemoveDuplicateFiles Element](xsd/wix/removeduplicatefiles.md)
      * [RemoveEnvironmentStrings Element](xsd/wix/removeenvironmentstrings.md)
      * [RemoveExistingProducts Element](xsd/wix/removeexistingproducts.md)
      * [RemoveFile Element](xsd/wix/removefile.md)
      * [RemoveFiles Element](xsd/wix/removefiles.md)
      * [RemoveFolder Element](xsd/wix/removefolder.md)
      * [RemoveFolders Element](xsd/wix/removefolders.md)
      * [RemoveIniValues Element](xsd/wix/removeinivalues.md)
      * [RemoveODBC Element](xsd/wix/removeodbc.md)
      * [RemoveRegistryKey Element](xsd/wix/removeregistrykey.md)
      * [RemoveRegistryValue Element](xsd/wix/removeregistryvalue.md)
      * [RemoveRegistryValues Element](xsd/wix/removeregistryvalues.md)
      * [RemoveShortcuts Element](xsd/wix/removeshortcuts.md)
      * [ReplacePatch Element](xsd/wix/replacepatch.md)
      * [RequiredPrivilege Element](xsd/wix/requiredprivilege.md)
      * [ReserveCost Element](xsd/wix/reservecost.md)
      * [ResolveSource Element](xsd/wix/resolvesource.md)
      * [RMCCPSearch Element](xsd/wix/rmccpsearch.md)
      * [RollbackBoundary Element](xsd/wix/rollbackboundary.md)
      * [Row Element](xsd/wix/row.md)
      * [ScheduleReboot Element](xsd/wix/schedulereboot.md)
      * [SelfRegModules Element](xsd/wix/selfregmodules.md)
      * [SelfUnregModules Element](xsd/wix/selfunregmodules.md)
      * [ServiceArgument Element](xsd/wix/serviceargument.md)
      * [ServiceConfig Element](xsd/wix/serviceconfig.md)
      * [ServiceConfigFailureActions Element](xsd/wix/serviceconfigfailureactions.md)
      * [ServiceControl Element](xsd/wix/servicecontrol.md)
      * [ServiceDependency Element](xsd/wix/servicedependency.md)
      * [ServiceInstall Element](xsd/wix/serviceinstall.md)
      * [SetDirectory Element](xsd/wix/setdirectory.md)
      * [SetODBCFolders Element](xsd/wix/setodbcfolders.md)
      * [SetProperty Element](xsd/wix/setproperty.md)
      * [SFPCatalog Element](xsd/wix/sfpcatalog.md)
      * [SFPFile Element](xsd/wix/sfpfile.md)
      * [Shortcut Element](xsd/wix/shortcut.md)
      * [ShortcutProperty Element](xsd/wix/shortcutproperty.md)
      * [Show Element](xsd/wix/show.md)
      * [SlipstreamMsp Element](xsd/wix/slipstreammsp.md)
      * [StartServices Element](xsd/wix/startservices.md)
      * [StopServices Element](xsd/wix/stopservices.md)
      * [Subscribe Element](xsd/wix/subscribe.md)
      * [Substitution Element](xsd/wix/substitution.md)
      * [SymbolPath Element](xsd/wix/symbolpath.md)
      * [TargetFile Element](xsd/wix/targetfile.md)
      * [TargetImage Element](xsd/wix/targetimage.md)
      * [TargetProductCode Element](xsd/wix/targetproductcode.md)
      * [TargetProductCodes Element](xsd/wix/targetproductcodes.md)
      * [Text Element](xsd/wix/text.md)
      * [TextStyle Element](xsd/wix/textstyle.md)
      * [TypeLib Element](xsd/wix/typelib.md)
      * [UI Element](xsd/wix/ui.md)
      * [UIRef Element](xsd/wix/uiref.md)
      * [UIText Element](xsd/wix/uitext.md)
      * [UnpublishComponents Element](xsd/wix/unpublishcomponents.md)
      * [UnpublishFeatures Element](xsd/wix/unpublishfeatures.md)
      * [UnregisterClassInfo Element](xsd/wix/unregisterclassinfo.md)
      * [UnregisterComPlus Element](xsd/wix/unregistercomplus.md)
      * [UnregisterExtensionInfo Element](xsd/wix/unregisterextensioninfo.md)
      * [UnregisterFonts Element](xsd/wix/unregisterfonts.md)
      * [UnregisterMIMEInfo Element](xsd/wix/unregistermimeinfo.md)
      * [UnregisterProgIdInfo Element](xsd/wix/unregisterprogidinfo.md)
      * [UnregisterTypeLibraries Element](xsd/wix/unregistertypelibraries.md)
      * [Update Element](xsd/wix/update.md)
      * [Upgrade Element](xsd/wix/upgrade.md)
      * [UpgradeFile Element](xsd/wix/upgradefile.md)
      * [UpgradeImage Element](xsd/wix/upgradeimage.md)
      * [UpgradeVersion Element](xsd/wix/upgradeversion.md)
      * [UX Element](xsd/wix/ux.md)
      * [Validate Element](xsd/wix/validate.md)
      * [ValidateProductID Element](xsd/wix/validateproductid.md)
      * [Variable Element](xsd/wix/variable.md)
      * [Verb Element](xsd/wix/verb.md)
      * [Wix Element](xsd/wix/wix/)
      * [WixVariable Element](xsd/wix/wixvariable.md)
      * [WriteEnvironmentStrings Element](xsd/wix/writeenvironmentstrings.md)
      * [WriteIniValues Element](xsd/wix/writeinivalues.md)
      * [WriteRegistryValues Element](xsd/wix/writeregistryvalues.md)
   * [Wixloc Schema](xsd/wixloc/index.md)
      * [String Element (Wixloc Extension)](xsd/wixloc/string.md)
      * [UI Element (Wixloc Extension)](xsd/wixloc/ui.md)
      * [WixLocalization Element (Wixloc Extension)](xsd/wixloc/wixlocalization.md)
* [Developing for WiX](wixdev/index.md)
   * [Developing for Votive](wixdev/votive_development.md)
   * [Adding to the WiX Documentation](wixdev/help_development.md)
   * [Developing WiX Extensions](wixdev/extensions/index.md)
      * [Introduction to Developing WiX Extensions](wixdev/extensions/extension_development_intro.md)
      * [Extensions](wixdev/extensions/extensions/index.md)
      * [Creating a Simple WiX Extension](wixdev/extensions/extension_development_simple_example.md)
      * [Creating a Preprocessor Extension](wixdev/extensions/extension_development_preprocessor.md)
      * [Adding Custom Actions](wixdev/extensions/authoring_custom_actions.md)
      * [Localized Extensions](wixdev/extensions/localized_extensions.md)
   * [Testing WiX](wixdev/tests/index.md)
      * [Running WiX Tests](wixdev/tests/tests_runningtests.md)
      * [Writing WiX Tests](wixdev/tests/tests_writingtests.md)
