<?php

namespace ccxt;

// PLEASE DO NOT EDIT THIS FILE, IT IS GENERATED AND WILL BE OVERWRITTEN:
// https://github.com/ccxt/ccxt/blob/master/CONTRIBUTING.md#how-to-contribute-code

class bitso extends Exchange {

    public function describe () {
        return array_replace_recursive (parent::describe (), array (
            'id' => 'bitso',
            'name' => 'Bitso',
            'countries' => 'MX', // Mexico
            'rateLimit' => 2000, // 30 requests per minute
            'version' => 'v3',
            'has' => array (
                'CORS' => true,
            ),
            'urls' => array (
                'logo' => 'https://user-images.githubusercontent.com/1294454/27766335-715ce7aa-5ed5-11e7-88a8-173a27bb30fe.jpg',
                'api' => 'https://api.bitso.com',
                'www' => 'https://bitso.com',
                'doc' => 'https://bitso.com/api_info',
                'fees' => 'https://bitso.com/fees?l=es',
            ),
            'api' => array (
                'public' => array (
                    'get' => array (
                        'available_books',
                        'ticker',
                        'order_book',
                        'trades',
                    ),
                ),
                'private' => array (
                    'get' => array (
                        'account_status',
                        'balance',
                        'fees',
                        'fundings',
                        'fundings/{fid}',
                        'funding_destination',
                        'kyc_documents',
                        'ledger',
                        'ledger/trades',
                        'ledger/fees',
                        'ledger/fundings',
                        'ledger/withdrawals',
                        'mx_bank_codes',
                        'open_orders',
                        'order_trades/{oid}',
                        'orders/{oid}',
                        'user_trades',
                        'user_trades/{tid}',
                        'withdrawals/',
                        'withdrawals/{wid}',
                    ),
                    'post' => array (
                        'bitcoin_withdrawal',
                        'debit_card_withdrawal',
                        'ether_withdrawal',
                        'orders',
                        'phone_number',
                        'phone_verification',
                        'phone_withdrawal',
                        'spei_withdrawal',
                    ),
                    'delete' => array (
                        'orders/{oid}',
                        'orders/all',
                    ),
                ),
            ),
        ));
    }

    public function fetch_markets () {
        $markets = $this->publicGetAvailableBooks ();
        $result = array ();
        for ($i = 0; $i < count ($markets['payload']); $i++) {
            $market = $markets['payload'][$i];
            $id = $market['book'];
            $symbol = str_replace ('_', '/', strtoupper ($id));
            list ($base, $quote) = explode ('/', $symbol);
            $limits = array (
                'amount' => array (
                    'min' => floatval ($market['minimum_amount']),
                    'max' => floatval ($market['maximum_amount']),
                ),
                'price' => array (
                    'min' => floatval ($market['minimum_price']),
                    'max' => floatval ($market['maximum_price']),
                ),
                'cost' => array (
                    'min' => floatval ($market['minimum_value']),
                    'max' => floatval ($market['maximum_value']),
                ),
            );
            $precision = array (
                'amount' => $this->precision_from_string($market['minimum_amount']),
                'price' => $this->precision_from_string($market['minimum_price']),
            );
            $lot = $limits['amount']['min'];
            $result[] = array (
                'id' => $id,
                'symbol' => $symbol,
                'base' => $base,
                'quote' => $quote,
                'info' => $market,
                'lot' => $lot,
                'limits' => $limits,
                'precision' => $precision,
            );
        }
        return $result;
    }

    public function fetch_balance ($params = array ()) {
        $this->load_markets();
        $response = $this->privateGetBalance ();
        $balances = $response['payload']['balances'];
        $result = array ( 'info' => $response );
        for ($b = 0; $b < count ($balances); $b++) {
            $balance = $balances[$b];
            $currency = strtoupper ($balance['currency']);
            $account = array (
                'free' => floatval ($balance['available']),
                'used' => floatval ($balance['locked']),
                'total' => floatval ($balance['total']),
            );
            $result[$currency] = $account;
        }
        return $this->parse_balance($result);
    }

    public function fetch_order_book ($symbol, $limit = null, $params = array ()) {
        $this->load_markets();
        $response = $this->publicGetOrderBook (array_merge (array (
            'book' => $this->market_id($symbol),
        ), $params));
        $orderbook = $response['payload'];
        $timestamp = $this->parse8601 ($orderbook['updated_at']);
        return $this->parse_order_book($orderbook, $timestamp, 'bids', 'asks', 'price', 'amount');
    }

    public function fetch_ticker ($symbol, $params = array ()) {
        $this->load_markets();
        $response = $this->publicGetTicker (array_merge (array (
            'book' => $this->market_id($symbol),
        ), $params));
        $ticker = $response['payload'];
        $timestamp = $this->parse8601 ($ticker['created_at']);
        $vwap = floatval ($ticker['vwap']);
        $baseVolume = floatval ($ticker['volume']);
        $quoteVolume = $baseVolume * $vwap;
        return array (
            'symbol' => $symbol,
            'timestamp' => $timestamp,
            'datetime' => $this->iso8601 ($timestamp),
            'high' => floatval ($ticker['high']),
            'low' => floatval ($ticker['low']),
            'bid' => floatval ($ticker['bid']),
            'ask' => floatval ($ticker['ask']),
            'vwap' => $vwap,
            'open' => null,
            'close' => null,
            'first' => null,
            'last' => floatval ($ticker['last']),
            'change' => null,
            'percentage' => null,
            'average' => null,
            'baseVolume' => $baseVolume,
            'quoteVolume' => $quoteVolume,
            'info' => $ticker,
        );
    }

    public function parse_trade ($trade, $market = null) {
        $timestamp = $this->parse8601 ($trade['created_at']);
        $symbol = null;
        if ($market === null) {
            $marketId = $this->safe_string($trade, 'book');
            if (is_array ($this->markets_by_id) && array_key_exists ($marketId, $this->markets_by_id))
                $market = $this->markets_by_id[$marketId];
        }
        if ($market !== null)
            $symbol = $market['symbol'];
        $side = $this->safe_string($trade, 'side');
        if ($side === null)
            $side = $this->safe_string($trade, 'maker_side');
        $amount = $this->safe_float($trade, 'amount');
        if ($amount === null)
            $amount = $this->safe_float($trade, 'major');
        if ($amount !== null)
            $amount = abs ($amount);
        $fee = null;
        $feeCost = $this->safe_float($trade, 'fees_amount');
        if ($feeCost !== null) {
            $feeCurrency = $this->safe_string($trade, 'fees_currency');
            if ($feeCurrency !== null) {
                if (is_array ($this->currencies_by_id) && array_key_exists ($feeCurrency, $this->currencies_by_id))
                    $feeCurrency = $this->currencies_by_id[$feeCurrency]['code'];
            }
            $fee = array (
                'cost' => $feeCost,
                'currency' => $feeCurrency,
            );
        }
        $cost = $this->safe_float($trade, 'minor');
        if ($cost !== null)
            $cost = abs ($cost);
        $price = $this->safe_float($trade, 'price');
        $orderId = $this->safe_string($trade, 'oid');
        return array (
            'id' => (string) $trade['tid'],
            'info' => $trade,
            'timestamp' => $timestamp,
            'datetime' => $this->iso8601 ($timestamp),
            'symbol' => $symbol,
            'order' => $orderId,
            'type' => null,
            'side' => $side,
            'price' => $price,
            'amount' => $amount,
            'cost' => $cost,
            'fee' => $fee,
        );
    }

    public function fetch_trades ($symbol, $since = null, $limit = null, $params = array ()) {
        $this->load_markets();
        $market = $this->market ($symbol);
        $response = $this->publicGetTrades (array_merge (array (
            'book' => $market['id'],
        ), $params));
        return $this->parse_trades($response['payload'], $market, $since, $limit);
    }

    public function fetch_my_trades ($symbol = null, $since = null, $limit = 25, $params = array ()) {
        $this->load_markets();
        $market = $this->market ($symbol);
        // the don't support fetching trades starting from a date yet
        // use the `marker` extra param for that
        // this is not a typo, the variable name is 'marker' (don't confuse with 'market')
        $markerInParams = (is_array ($params) && array_key_exists ('marker', $params));
        // warn the user with an exception if the user wants to filter
        // starting from $since timestamp, but does not set the trade id with an extra 'marker' param
        if (($since !== null) && !$markerInParams)
            throw ExchangeError ($this->id . ' fetchMyTrades does not support fetching trades starting from a timestamp with the `$since` argument, use the `marker` extra param to filter starting from an integer trade id');
        // convert it to an integer unconditionally
        if ($markerInParams)
            $params = array_merge ($params, array (
                'marker' => intval ($params['marker']),
            ));
        $request = array (
            'book' => $market['id'],
            'limit' => $limit, // default = 25, max = 100
            // 'sort' => 'desc', // default = desc
            // 'marker' => id, // integer id to start from
        );
        $response = $this->privateGetUserTrades (array_merge ($request, $params));
        return $this->parse_trades($response['payload'], $market, $since, $limit);
    }

    public function create_order ($symbol, $type, $side, $amount, $price = null, $params = array ()) {
        $this->load_markets();
        $order = array (
            'book' => $this->market_id($symbol),
            'side' => $side,
            'type' => $type,
            'major' => $this->amount_to_precision($symbol, $amount),
        );
        if ($type === 'limit')
            $order['price'] = $this->price_to_precision($symbol, $price);
        $response = $this->privatePostOrders (array_merge ($order, $params));
        return array (
            'info' => $response,
            'id' => $response['payload']['oid'],
        );
    }

    public function cancel_order ($id, $symbol = null, $params = array ()) {
        $this->load_markets();
        return $this->privateDeleteOrdersOid (array ( 'oid' => $id ));
    }

    public function parse_order_status ($status) {
        $statuses = array (
            'partial-fill' => 'open', // this is a common substitution in ccxt
        );
        if (is_array ($statuses) && array_key_exists ($status, $statuses))
            return $statuses['status'];
        return $status;
    }

    public function parse_order ($order, $market = null) {
        $side = $order['side'];
        $status = $this->parse_order_status($order['status']);
        $symbol = null;
        if ($market === null) {
            $marketId = $order['book'];
            if (is_array ($this->markets_by_id) && array_key_exists ($marketId, $this->markets_by_id))
                $market = $this->markets_by_id[$marketId];
        }
        if ($market)
            $symbol = $market['symbol'];
        $orderType = $order['type'];
        $timestamp = $this->parse8601 ($order['created_at']);
        $amount = floatval ($order['original_amount']);
        $remaining = floatval ($order['unfilled_amount']);
        $filled = $amount - $remaining;
        $result = array (
            'info' => $order,
            'id' => $order['oid'],
            'timestamp' => $timestamp,
            'datetime' => $this->iso8601 ($timestamp),
            'symbol' => $symbol,
            'type' => $orderType,
            'side' => $side,
            'price' => $this->safe_float($order, 'price'),
            'amount' => $amount,
            'cost' => null,
            'remaining' => $remaining,
            'filled' => $filled,
            'status' => $status,
            'fee' => null,
        );
        return $result;
    }

    public function fetch_open_orders ($symbol = null, $since = null, $limit = 25, $params = array ()) {
        $this->load_markets();
        $market = $this->market ($symbol);
        // the don't support fetching trades starting from a date yet
        // use the `marker` extra param for that
        // this is not a typo, the variable name is 'marker' (don't confuse with 'market')
        $markerInParams = (is_array ($params) && array_key_exists ('marker', $params));
        // warn the user with an exception if the user wants to filter
        // starting from $since timestamp, but does not set the trade id with an extra 'marker' param
        if (($since !== null) && !$markerInParams)
            throw ExchangeError ($this->id . ' fetchOpenOrders does not support fetching $orders starting from a timestamp with the `$since` argument, use the `marker` extra param to filter starting from an integer trade id');
        // convert it to an integer unconditionally
        if ($markerInParams)
            $params = array_merge ($params, array (
                'marker' => intval ($params['marker']),
            ));
        $request = array (
            'book' => $market['id'],
            'limit' => $limit, // default = 25, max = 100
            // 'sort' => 'desc', // default = desc
            // 'marker' => id, // integer id to start from
        );
        $response = $this->privateGetOpenOrders (array_merge ($request, $params));
        $orders = $this->parse_orders($response['payload'], $market, $since, $limit);
        return $orders;
    }

    public function sign ($path, $api = 'public', $method = 'GET', $params = array (), $headers = null, $body = null) {
        $endpoint = '/' . $this->version . '/' . $this->implode_params($path, $params);
        $query = $this->omit ($params, $this->extract_params($path));
        if ($method === 'GET') {
            if ($query)
                $endpoint .= '?' . $this->urlencode ($query);
        }
        $url = $this->urls['api'] . $endpoint;
        if ($api === 'private') {
            $this->check_required_credentials();
            $nonce = (string) $this->nonce ();
            $request = implode ('', array ($nonce, $method, $endpoint));
            if ($method !== 'GET') {
                if ($query) {
                    $body = $this->json ($query);
                    $request .= $body;
                }
            }
            $signature = $this->hmac ($this->encode ($request), $this->encode ($this->secret));
            $auth = $this->apiKey . ':' . $nonce . ':' . $signature;
            $headers = array (
                'Authorization' => 'Bitso ' . $auth,
                'Content-Type' => 'application/json',
            );
        }
        return array ( 'url' => $url, 'method' => $method, 'body' => $body, 'headers' => $headers );
    }

    public function request ($path, $api = 'public', $method = 'GET', $params = array (), $headers = null, $body = null) {
        $response = $this->fetch2 ($path, $api, $method, $params, $headers, $body);
        if (is_array ($response) && array_key_exists ('success', $response))
            if ($response['success'])
                return $response;
        throw new ExchangeError ($this->id . ' ' . $this->json ($response));
    }
}
