// Copyright 2018 The go-libvirt Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//
// Code generated by internal/lvgen/generate.go. DO NOT EDIT.
//
// To regenerate, run 'go generate' in internal/lvgen.
//

package constants

// qemu constants
const (
	ProgramQEMU      = 0x20008087
	ProgramKeepAlive = 0x6b656570
)

// qemu procedure identifiers
const (
	QEMUDomainMonitor                       = 1
	QEMUConnectDomainMonitorEventRegister   = 4
	QEMUConnectDomainMonitorEventDeregister = 5
	QEMUDomainMonitorEvent                  = 6
)

const (
	// PacketLengthSize is the packet length, in bytes.
	PacketLengthSize = 4

	// HeaderSize is the packet header size, in bytes.
	HeaderSize = 24

	// UUIDSize is the length of a UUID, in bytes.
	UUIDSize = 16
)

// These are libvirt procedure numbers which correspond to each respective
// API call between remote_internal driver and libvirtd. Each procedure is
// identified by a unique number which *may change in any future libvirt
// update*.
//
// Examples:
//	REMOTE_PROC_CONNECT_OPEN = 1
//	REMOTE_PROC_DOMAIN_DEFINE_XML = 11
//	REMOTE_PROC_DOMAIN_MIGRATE_SET_MAX_SPEED = 207,
const (
	// From enums:
	// AuthNone is libvirt's REMOTE_AUTH_NONE
	AuthNone = 0
	// AuthSasl is libvirt's REMOTE_AUTH_SASL
	AuthSasl = 1
	// AuthPolkit is libvirt's REMOTE_AUTH_POLKIT
	AuthPolkit = 2
	// ProcConnectOpen is libvirt's REMOTE_PROC_CONNECT_OPEN
	ProcConnectOpen = 1
	// ProcConnectClose is libvirt's REMOTE_PROC_CONNECT_CLOSE
	ProcConnectClose = 2
	// ProcConnectGetType is libvirt's REMOTE_PROC_CONNECT_GET_TYPE
	ProcConnectGetType = 3
	// ProcConnectGetVersion is libvirt's REMOTE_PROC_CONNECT_GET_VERSION
	ProcConnectGetVersion = 4
	// ProcConnectGetMaxVcpus is libvirt's REMOTE_PROC_CONNECT_GET_MAX_VCPUS
	ProcConnectGetMaxVcpus = 5
	// ProcNodeGetInfo is libvirt's REMOTE_PROC_NODE_GET_INFO
	ProcNodeGetInfo = 6
	// ProcConnectGetCapabilities is libvirt's REMOTE_PROC_CONNECT_GET_CAPABILITIES
	ProcConnectGetCapabilities = 7
	// ProcDomainAttachDevice is libvirt's REMOTE_PROC_DOMAIN_ATTACH_DEVICE
	ProcDomainAttachDevice = 8
	// ProcDomainCreate is libvirt's REMOTE_PROC_DOMAIN_CREATE
	ProcDomainCreate = 9
	// ProcDomainCreateXML is libvirt's REMOTE_PROC_DOMAIN_CREATE_XML
	ProcDomainCreateXML = 10
	// ProcDomainDefineXML is libvirt's REMOTE_PROC_DOMAIN_DEFINE_XML
	ProcDomainDefineXML = 11
	// ProcDomainDestroy is libvirt's REMOTE_PROC_DOMAIN_DESTROY
	ProcDomainDestroy = 12
	// ProcDomainDetachDevice is libvirt's REMOTE_PROC_DOMAIN_DETACH_DEVICE
	ProcDomainDetachDevice = 13
	// ProcDomainGetXMLDesc is libvirt's REMOTE_PROC_DOMAIN_GET_XML_DESC
	ProcDomainGetXMLDesc = 14
	// ProcDomainGetAutostart is libvirt's REMOTE_PROC_DOMAIN_GET_AUTOSTART
	ProcDomainGetAutostart = 15
	// ProcDomainGetInfo is libvirt's REMOTE_PROC_DOMAIN_GET_INFO
	ProcDomainGetInfo = 16
	// ProcDomainGetMaxMemory is libvirt's REMOTE_PROC_DOMAIN_GET_MAX_MEMORY
	ProcDomainGetMaxMemory = 17
	// ProcDomainGetMaxVcpus is libvirt's REMOTE_PROC_DOMAIN_GET_MAX_VCPUS
	ProcDomainGetMaxVcpus = 18
	// ProcDomainGetOsType is libvirt's REMOTE_PROC_DOMAIN_GET_OS_TYPE
	ProcDomainGetOsType = 19
	// ProcDomainGetVcpus is libvirt's REMOTE_PROC_DOMAIN_GET_VCPUS
	ProcDomainGetVcpus = 20
	// ProcConnectListDefinedDomains is libvirt's REMOTE_PROC_CONNECT_LIST_DEFINED_DOMAINS
	ProcConnectListDefinedDomains = 21
	// ProcDomainLookupByID is libvirt's REMOTE_PROC_DOMAIN_LOOKUP_BY_ID
	ProcDomainLookupByID = 22
	// ProcDomainLookupByName is libvirt's REMOTE_PROC_DOMAIN_LOOKUP_BY_NAME
	ProcDomainLookupByName = 23
	// ProcDomainLookupByUUID is libvirt's REMOTE_PROC_DOMAIN_LOOKUP_BY_UUID
	ProcDomainLookupByUUID = 24
	// ProcConnectNumOfDefinedDomains is libvirt's REMOTE_PROC_CONNECT_NUM_OF_DEFINED_DOMAINS
	ProcConnectNumOfDefinedDomains = 25
	// ProcDomainPinVcpu is libvirt's REMOTE_PROC_DOMAIN_PIN_VCPU
	ProcDomainPinVcpu = 26
	// ProcDomainReboot is libvirt's REMOTE_PROC_DOMAIN_REBOOT
	ProcDomainReboot = 27
	// ProcDomainResume is libvirt's REMOTE_PROC_DOMAIN_RESUME
	ProcDomainResume = 28
	// ProcDomainSetAutostart is libvirt's REMOTE_PROC_DOMAIN_SET_AUTOSTART
	ProcDomainSetAutostart = 29
	// ProcDomainSetMaxMemory is libvirt's REMOTE_PROC_DOMAIN_SET_MAX_MEMORY
	ProcDomainSetMaxMemory = 30
	// ProcDomainSetMemory is libvirt's REMOTE_PROC_DOMAIN_SET_MEMORY
	ProcDomainSetMemory = 31
	// ProcDomainSetVcpus is libvirt's REMOTE_PROC_DOMAIN_SET_VCPUS
	ProcDomainSetVcpus = 32
	// ProcDomainShutdown is libvirt's REMOTE_PROC_DOMAIN_SHUTDOWN
	ProcDomainShutdown = 33
	// ProcDomainSuspend is libvirt's REMOTE_PROC_DOMAIN_SUSPEND
	ProcDomainSuspend = 34
	// ProcDomainUndefine is libvirt's REMOTE_PROC_DOMAIN_UNDEFINE
	ProcDomainUndefine = 35
	// ProcConnectListDefinedNetworks is libvirt's REMOTE_PROC_CONNECT_LIST_DEFINED_NETWORKS
	ProcConnectListDefinedNetworks = 36
	// ProcConnectListDomains is libvirt's REMOTE_PROC_CONNECT_LIST_DOMAINS
	ProcConnectListDomains = 37
	// ProcConnectListNetworks is libvirt's REMOTE_PROC_CONNECT_LIST_NETWORKS
	ProcConnectListNetworks = 38
	// ProcNetworkCreate is libvirt's REMOTE_PROC_NETWORK_CREATE
	ProcNetworkCreate = 39
	// ProcNetworkCreateXML is libvirt's REMOTE_PROC_NETWORK_CREATE_XML
	ProcNetworkCreateXML = 40
	// ProcNetworkDefineXML is libvirt's REMOTE_PROC_NETWORK_DEFINE_XML
	ProcNetworkDefineXML = 41
	// ProcNetworkDestroy is libvirt's REMOTE_PROC_NETWORK_DESTROY
	ProcNetworkDestroy = 42
	// ProcNetworkGetXMLDesc is libvirt's REMOTE_PROC_NETWORK_GET_XML_DESC
	ProcNetworkGetXMLDesc = 43
	// ProcNetworkGetAutostart is libvirt's REMOTE_PROC_NETWORK_GET_AUTOSTART
	ProcNetworkGetAutostart = 44
	// ProcNetworkGetBridgeName is libvirt's REMOTE_PROC_NETWORK_GET_BRIDGE_NAME
	ProcNetworkGetBridgeName = 45
	// ProcNetworkLookupByName is libvirt's REMOTE_PROC_NETWORK_LOOKUP_BY_NAME
	ProcNetworkLookupByName = 46
	// ProcNetworkLookupByUUID is libvirt's REMOTE_PROC_NETWORK_LOOKUP_BY_UUID
	ProcNetworkLookupByUUID = 47
	// ProcNetworkSetAutostart is libvirt's REMOTE_PROC_NETWORK_SET_AUTOSTART
	ProcNetworkSetAutostart = 48
	// ProcNetworkUndefine is libvirt's REMOTE_PROC_NETWORK_UNDEFINE
	ProcNetworkUndefine = 49
	// ProcConnectNumOfDefinedNetworks is libvirt's REMOTE_PROC_CONNECT_NUM_OF_DEFINED_NETWORKS
	ProcConnectNumOfDefinedNetworks = 50
	// ProcConnectNumOfDomains is libvirt's REMOTE_PROC_CONNECT_NUM_OF_DOMAINS
	ProcConnectNumOfDomains = 51
	// ProcConnectNumOfNetworks is libvirt's REMOTE_PROC_CONNECT_NUM_OF_NETWORKS
	ProcConnectNumOfNetworks = 52
	// ProcDomainCoreDump is libvirt's REMOTE_PROC_DOMAIN_CORE_DUMP
	ProcDomainCoreDump = 53
	// ProcDomainRestore is libvirt's REMOTE_PROC_DOMAIN_RESTORE
	ProcDomainRestore = 54
	// ProcDomainSave is libvirt's REMOTE_PROC_DOMAIN_SAVE
	ProcDomainSave = 55
	// ProcDomainGetSchedulerType is libvirt's REMOTE_PROC_DOMAIN_GET_SCHEDULER_TYPE
	ProcDomainGetSchedulerType = 56
	// ProcDomainGetSchedulerParameters is libvirt's REMOTE_PROC_DOMAIN_GET_SCHEDULER_PARAMETERS
	ProcDomainGetSchedulerParameters = 57
	// ProcDomainSetSchedulerParameters is libvirt's REMOTE_PROC_DOMAIN_SET_SCHEDULER_PARAMETERS
	ProcDomainSetSchedulerParameters = 58
	// ProcConnectGetHostname is libvirt's REMOTE_PROC_CONNECT_GET_HOSTNAME
	ProcConnectGetHostname = 59
	// ProcConnectSupportsFeature is libvirt's REMOTE_PROC_CONNECT_SUPPORTS_FEATURE
	ProcConnectSupportsFeature = 60
	// ProcDomainMigratePrepare is libvirt's REMOTE_PROC_DOMAIN_MIGRATE_PREPARE
	ProcDomainMigratePrepare = 61
	// ProcDomainMigratePerform is libvirt's REMOTE_PROC_DOMAIN_MIGRATE_PERFORM
	ProcDomainMigratePerform = 62
	// ProcDomainMigrateFinish is libvirt's REMOTE_PROC_DOMAIN_MIGRATE_FINISH
	ProcDomainMigrateFinish = 63
	// ProcDomainBlockStats is libvirt's REMOTE_PROC_DOMAIN_BLOCK_STATS
	ProcDomainBlockStats = 64
	// ProcDomainInterfaceStats is libvirt's REMOTE_PROC_DOMAIN_INTERFACE_STATS
	ProcDomainInterfaceStats = 65
	// ProcAuthList is libvirt's REMOTE_PROC_AUTH_LIST
	ProcAuthList = 66
	// ProcAuthSaslInit is libvirt's REMOTE_PROC_AUTH_SASL_INIT
	ProcAuthSaslInit = 67
	// ProcAuthSaslStart is libvirt's REMOTE_PROC_AUTH_SASL_START
	ProcAuthSaslStart = 68
	// ProcAuthSaslStep is libvirt's REMOTE_PROC_AUTH_SASL_STEP
	ProcAuthSaslStep = 69
	// ProcAuthPolkit is libvirt's REMOTE_PROC_AUTH_POLKIT
	ProcAuthPolkit = 70
	// ProcConnectNumOfStoragePools is libvirt's REMOTE_PROC_CONNECT_NUM_OF_STORAGE_POOLS
	ProcConnectNumOfStoragePools = 71
	// ProcConnectListStoragePools is libvirt's REMOTE_PROC_CONNECT_LIST_STORAGE_POOLS
	ProcConnectListStoragePools = 72
	// ProcConnectNumOfDefinedStoragePools is libvirt's REMOTE_PROC_CONNECT_NUM_OF_DEFINED_STORAGE_POOLS
	ProcConnectNumOfDefinedStoragePools = 73
	// ProcConnectListDefinedStoragePools is libvirt's REMOTE_PROC_CONNECT_LIST_DEFINED_STORAGE_POOLS
	ProcConnectListDefinedStoragePools = 74
	// ProcConnectFindStoragePoolSources is libvirt's REMOTE_PROC_CONNECT_FIND_STORAGE_POOL_SOURCES
	ProcConnectFindStoragePoolSources = 75
	// ProcStoragePoolCreateXML is libvirt's REMOTE_PROC_STORAGE_POOL_CREATE_XML
	ProcStoragePoolCreateXML = 76
	// ProcStoragePoolDefineXML is libvirt's REMOTE_PROC_STORAGE_POOL_DEFINE_XML
	ProcStoragePoolDefineXML = 77
	// ProcStoragePoolCreate is libvirt's REMOTE_PROC_STORAGE_POOL_CREATE
	ProcStoragePoolCreate = 78
	// ProcStoragePoolBuild is libvirt's REMOTE_PROC_STORAGE_POOL_BUILD
	ProcStoragePoolBuild = 79
	// ProcStoragePoolDestroy is libvirt's REMOTE_PROC_STORAGE_POOL_DESTROY
	ProcStoragePoolDestroy = 80
	// ProcStoragePoolDelete is libvirt's REMOTE_PROC_STORAGE_POOL_DELETE
	ProcStoragePoolDelete = 81
	// ProcStoragePoolUndefine is libvirt's REMOTE_PROC_STORAGE_POOL_UNDEFINE
	ProcStoragePoolUndefine = 82
	// ProcStoragePoolRefresh is libvirt's REMOTE_PROC_STORAGE_POOL_REFRESH
	ProcStoragePoolRefresh = 83
	// ProcStoragePoolLookupByName is libvirt's REMOTE_PROC_STORAGE_POOL_LOOKUP_BY_NAME
	ProcStoragePoolLookupByName = 84
	// ProcStoragePoolLookupByUUID is libvirt's REMOTE_PROC_STORAGE_POOL_LOOKUP_BY_UUID
	ProcStoragePoolLookupByUUID = 85
	// ProcStoragePoolLookupByVolume is libvirt's REMOTE_PROC_STORAGE_POOL_LOOKUP_BY_VOLUME
	ProcStoragePoolLookupByVolume = 86
	// ProcStoragePoolGetInfo is libvirt's REMOTE_PROC_STORAGE_POOL_GET_INFO
	ProcStoragePoolGetInfo = 87
	// ProcStoragePoolGetXMLDesc is libvirt's REMOTE_PROC_STORAGE_POOL_GET_XML_DESC
	ProcStoragePoolGetXMLDesc = 88
	// ProcStoragePoolGetAutostart is libvirt's REMOTE_PROC_STORAGE_POOL_GET_AUTOSTART
	ProcStoragePoolGetAutostart = 89
	// ProcStoragePoolSetAutostart is libvirt's REMOTE_PROC_STORAGE_POOL_SET_AUTOSTART
	ProcStoragePoolSetAutostart = 90
	// ProcStoragePoolNumOfVolumes is libvirt's REMOTE_PROC_STORAGE_POOL_NUM_OF_VOLUMES
	ProcStoragePoolNumOfVolumes = 91
	// ProcStoragePoolListVolumes is libvirt's REMOTE_PROC_STORAGE_POOL_LIST_VOLUMES
	ProcStoragePoolListVolumes = 92
	// ProcStorageVolCreateXML is libvirt's REMOTE_PROC_STORAGE_VOL_CREATE_XML
	ProcStorageVolCreateXML = 93
	// ProcStorageVolDelete is libvirt's REMOTE_PROC_STORAGE_VOL_DELETE
	ProcStorageVolDelete = 94
	// ProcStorageVolLookupByName is libvirt's REMOTE_PROC_STORAGE_VOL_LOOKUP_BY_NAME
	ProcStorageVolLookupByName = 95
	// ProcStorageVolLookupByKey is libvirt's REMOTE_PROC_STORAGE_VOL_LOOKUP_BY_KEY
	ProcStorageVolLookupByKey = 96
	// ProcStorageVolLookupByPath is libvirt's REMOTE_PROC_STORAGE_VOL_LOOKUP_BY_PATH
	ProcStorageVolLookupByPath = 97
	// ProcStorageVolGetInfo is libvirt's REMOTE_PROC_STORAGE_VOL_GET_INFO
	ProcStorageVolGetInfo = 98
	// ProcStorageVolGetXMLDesc is libvirt's REMOTE_PROC_STORAGE_VOL_GET_XML_DESC
	ProcStorageVolGetXMLDesc = 99
	// ProcStorageVolGetPath is libvirt's REMOTE_PROC_STORAGE_VOL_GET_PATH
	ProcStorageVolGetPath = 100
	// ProcNodeGetCellsFreeMemory is libvirt's REMOTE_PROC_NODE_GET_CELLS_FREE_MEMORY
	ProcNodeGetCellsFreeMemory = 101
	// ProcNodeGetFreeMemory is libvirt's REMOTE_PROC_NODE_GET_FREE_MEMORY
	ProcNodeGetFreeMemory = 102
	// ProcDomainBlockPeek is libvirt's REMOTE_PROC_DOMAIN_BLOCK_PEEK
	ProcDomainBlockPeek = 103
	// ProcDomainMemoryPeek is libvirt's REMOTE_PROC_DOMAIN_MEMORY_PEEK
	ProcDomainMemoryPeek = 104
	// ProcConnectDomainEventRegister is libvirt's REMOTE_PROC_CONNECT_DOMAIN_EVENT_REGISTER
	ProcConnectDomainEventRegister = 105
	// ProcConnectDomainEventDeregister is libvirt's REMOTE_PROC_CONNECT_DOMAIN_EVENT_DEREGISTER
	ProcConnectDomainEventDeregister = 106
	// ProcDomainEventLifecycle is libvirt's REMOTE_PROC_DOMAIN_EVENT_LIFECYCLE
	ProcDomainEventLifecycle = 107
	// ProcDomainMigratePrepare2 is libvirt's REMOTE_PROC_DOMAIN_MIGRATE_PREPARE2
	ProcDomainMigratePrepare2 = 108
	// ProcDomainMigrateFinish2 is libvirt's REMOTE_PROC_DOMAIN_MIGRATE_FINISH2
	ProcDomainMigrateFinish2 = 109
	// ProcConnectGetUri is libvirt's REMOTE_PROC_CONNECT_GET_URI
	ProcConnectGetUri = 110
	// ProcNodeNumOfDevices is libvirt's REMOTE_PROC_NODE_NUM_OF_DEVICES
	ProcNodeNumOfDevices = 111
	// ProcNodeListDevices is libvirt's REMOTE_PROC_NODE_LIST_DEVICES
	ProcNodeListDevices = 112
	// ProcNodeDeviceLookupByName is libvirt's REMOTE_PROC_NODE_DEVICE_LOOKUP_BY_NAME
	ProcNodeDeviceLookupByName = 113
	// ProcNodeDeviceGetXMLDesc is libvirt's REMOTE_PROC_NODE_DEVICE_GET_XML_DESC
	ProcNodeDeviceGetXMLDesc = 114
	// ProcNodeDeviceGetParent is libvirt's REMOTE_PROC_NODE_DEVICE_GET_PARENT
	ProcNodeDeviceGetParent = 115
	// ProcNodeDeviceNumOfCaps is libvirt's REMOTE_PROC_NODE_DEVICE_NUM_OF_CAPS
	ProcNodeDeviceNumOfCaps = 116
	// ProcNodeDeviceListCaps is libvirt's REMOTE_PROC_NODE_DEVICE_LIST_CAPS
	ProcNodeDeviceListCaps = 117
	// ProcNodeDeviceDettach is libvirt's REMOTE_PROC_NODE_DEVICE_DETTACH
	ProcNodeDeviceDettach = 118
	// ProcNodeDeviceReAttach is libvirt's REMOTE_PROC_NODE_DEVICE_RE_ATTACH
	ProcNodeDeviceReAttach = 119
	// ProcNodeDeviceReset is libvirt's REMOTE_PROC_NODE_DEVICE_RESET
	ProcNodeDeviceReset = 120
	// ProcDomainGetSecurityLabel is libvirt's REMOTE_PROC_DOMAIN_GET_SECURITY_LABEL
	ProcDomainGetSecurityLabel = 121
	// ProcNodeGetSecurityModel is libvirt's REMOTE_PROC_NODE_GET_SECURITY_MODEL
	ProcNodeGetSecurityModel = 122
	// ProcNodeDeviceCreateXML is libvirt's REMOTE_PROC_NODE_DEVICE_CREATE_XML
	ProcNodeDeviceCreateXML = 123
	// ProcNodeDeviceDestroy is libvirt's REMOTE_PROC_NODE_DEVICE_DESTROY
	ProcNodeDeviceDestroy = 124
	// ProcStorageVolCreateXMLFrom is libvirt's REMOTE_PROC_STORAGE_VOL_CREATE_XML_FROM
	ProcStorageVolCreateXMLFrom = 125
	// ProcConnectNumOfInterfaces is libvirt's REMOTE_PROC_CONNECT_NUM_OF_INTERFACES
	ProcConnectNumOfInterfaces = 126
	// ProcConnectListInterfaces is libvirt's REMOTE_PROC_CONNECT_LIST_INTERFACES
	ProcConnectListInterfaces = 127
	// ProcInterfaceLookupByName is libvirt's REMOTE_PROC_INTERFACE_LOOKUP_BY_NAME
	ProcInterfaceLookupByName = 128
	// ProcInterfaceLookupByMacString is libvirt's REMOTE_PROC_INTERFACE_LOOKUP_BY_MAC_STRING
	ProcInterfaceLookupByMacString = 129
	// ProcInterfaceGetXMLDesc is libvirt's REMOTE_PROC_INTERFACE_GET_XML_DESC
	ProcInterfaceGetXMLDesc = 130
	// ProcInterfaceDefineXML is libvirt's REMOTE_PROC_INTERFACE_DEFINE_XML
	ProcInterfaceDefineXML = 131
	// ProcInterfaceUndefine is libvirt's REMOTE_PROC_INTERFACE_UNDEFINE
	ProcInterfaceUndefine = 132
	// ProcInterfaceCreate is libvirt's REMOTE_PROC_INTERFACE_CREATE
	ProcInterfaceCreate = 133
	// ProcInterfaceDestroy is libvirt's REMOTE_PROC_INTERFACE_DESTROY
	ProcInterfaceDestroy = 134
	// ProcConnectDomainXMLFromNative is libvirt's REMOTE_PROC_CONNECT_DOMAIN_XML_FROM_NATIVE
	ProcConnectDomainXMLFromNative = 135
	// ProcConnectDomainXMLToNative is libvirt's REMOTE_PROC_CONNECT_DOMAIN_XML_TO_NATIVE
	ProcConnectDomainXMLToNative = 136
	// ProcConnectNumOfDefinedInterfaces is libvirt's REMOTE_PROC_CONNECT_NUM_OF_DEFINED_INTERFACES
	ProcConnectNumOfDefinedInterfaces = 137
	// ProcConnectListDefinedInterfaces is libvirt's REMOTE_PROC_CONNECT_LIST_DEFINED_INTERFACES
	ProcConnectListDefinedInterfaces = 138
	// ProcConnectNumOfSecrets is libvirt's REMOTE_PROC_CONNECT_NUM_OF_SECRETS
	ProcConnectNumOfSecrets = 139
	// ProcConnectListSecrets is libvirt's REMOTE_PROC_CONNECT_LIST_SECRETS
	ProcConnectListSecrets = 140
	// ProcSecretLookupByUUID is libvirt's REMOTE_PROC_SECRET_LOOKUP_BY_UUID
	ProcSecretLookupByUUID = 141
	// ProcSecretDefineXML is libvirt's REMOTE_PROC_SECRET_DEFINE_XML
	ProcSecretDefineXML = 142
	// ProcSecretGetXMLDesc is libvirt's REMOTE_PROC_SECRET_GET_XML_DESC
	ProcSecretGetXMLDesc = 143
	// ProcSecretSetValue is libvirt's REMOTE_PROC_SECRET_SET_VALUE
	ProcSecretSetValue = 144
	// ProcSecretGetValue is libvirt's REMOTE_PROC_SECRET_GET_VALUE
	ProcSecretGetValue = 145
	// ProcSecretUndefine is libvirt's REMOTE_PROC_SECRET_UNDEFINE
	ProcSecretUndefine = 146
	// ProcSecretLookupByUsage is libvirt's REMOTE_PROC_SECRET_LOOKUP_BY_USAGE
	ProcSecretLookupByUsage = 147
	// ProcDomainMigratePrepareTunnel is libvirt's REMOTE_PROC_DOMAIN_MIGRATE_PREPARE_TUNNEL
	ProcDomainMigratePrepareTunnel = 148
	// ProcConnectIsSecure is libvirt's REMOTE_PROC_CONNECT_IS_SECURE
	ProcConnectIsSecure = 149
	// ProcDomainIsActive is libvirt's REMOTE_PROC_DOMAIN_IS_ACTIVE
	ProcDomainIsActive = 150
	// ProcDomainIsPersistent is libvirt's REMOTE_PROC_DOMAIN_IS_PERSISTENT
	ProcDomainIsPersistent = 151
	// ProcNetworkIsActive is libvirt's REMOTE_PROC_NETWORK_IS_ACTIVE
	ProcNetworkIsActive = 152
	// ProcNetworkIsPersistent is libvirt's REMOTE_PROC_NETWORK_IS_PERSISTENT
	ProcNetworkIsPersistent = 153
	// ProcStoragePoolIsActive is libvirt's REMOTE_PROC_STORAGE_POOL_IS_ACTIVE
	ProcStoragePoolIsActive = 154
	// ProcStoragePoolIsPersistent is libvirt's REMOTE_PROC_STORAGE_POOL_IS_PERSISTENT
	ProcStoragePoolIsPersistent = 155
	// ProcInterfaceIsActive is libvirt's REMOTE_PROC_INTERFACE_IS_ACTIVE
	ProcInterfaceIsActive = 156
	// ProcConnectGetLibVersion is libvirt's REMOTE_PROC_CONNECT_GET_LIB_VERSION
	ProcConnectGetLibVersion = 157
	// ProcConnectCompareCPU is libvirt's REMOTE_PROC_CONNECT_COMPARE_CPU
	ProcConnectCompareCPU = 158
	// ProcDomainMemoryStats is libvirt's REMOTE_PROC_DOMAIN_MEMORY_STATS
	ProcDomainMemoryStats = 159
	// ProcDomainAttachDeviceFlags is libvirt's REMOTE_PROC_DOMAIN_ATTACH_DEVICE_FLAGS
	ProcDomainAttachDeviceFlags = 160
	// ProcDomainDetachDeviceFlags is libvirt's REMOTE_PROC_DOMAIN_DETACH_DEVICE_FLAGS
	ProcDomainDetachDeviceFlags = 161
	// ProcConnectBaselineCPU is libvirt's REMOTE_PROC_CONNECT_BASELINE_CPU
	ProcConnectBaselineCPU = 162
	// ProcDomainGetJobInfo is libvirt's REMOTE_PROC_DOMAIN_GET_JOB_INFO
	ProcDomainGetJobInfo = 163
	// ProcDomainAbortJob is libvirt's REMOTE_PROC_DOMAIN_ABORT_JOB
	ProcDomainAbortJob = 164
	// ProcStorageVolWipe is libvirt's REMOTE_PROC_STORAGE_VOL_WIPE
	ProcStorageVolWipe = 165
	// ProcDomainMigrateSetMaxDowntime is libvirt's REMOTE_PROC_DOMAIN_MIGRATE_SET_MAX_DOWNTIME
	ProcDomainMigrateSetMaxDowntime = 166
	// ProcConnectDomainEventRegisterAny is libvirt's REMOTE_PROC_CONNECT_DOMAIN_EVENT_REGISTER_ANY
	ProcConnectDomainEventRegisterAny = 167
	// ProcConnectDomainEventDeregisterAny is libvirt's REMOTE_PROC_CONNECT_DOMAIN_EVENT_DEREGISTER_ANY
	ProcConnectDomainEventDeregisterAny = 168
	// ProcDomainEventReboot is libvirt's REMOTE_PROC_DOMAIN_EVENT_REBOOT
	ProcDomainEventReboot = 169
	// ProcDomainEventRtcChange is libvirt's REMOTE_PROC_DOMAIN_EVENT_RTC_CHANGE
	ProcDomainEventRtcChange = 170
	// ProcDomainEventWatchdog is libvirt's REMOTE_PROC_DOMAIN_EVENT_WATCHDOG
	ProcDomainEventWatchdog = 171
	// ProcDomainEventIOError is libvirt's REMOTE_PROC_DOMAIN_EVENT_IO_ERROR
	ProcDomainEventIOError = 172
	// ProcDomainEventGraphics is libvirt's REMOTE_PROC_DOMAIN_EVENT_GRAPHICS
	ProcDomainEventGraphics = 173
	// ProcDomainUpdateDeviceFlags is libvirt's REMOTE_PROC_DOMAIN_UPDATE_DEVICE_FLAGS
	ProcDomainUpdateDeviceFlags = 174
	// ProcNwfilterLookupByName is libvirt's REMOTE_PROC_NWFILTER_LOOKUP_BY_NAME
	ProcNwfilterLookupByName = 175
	// ProcNwfilterLookupByUUID is libvirt's REMOTE_PROC_NWFILTER_LOOKUP_BY_UUID
	ProcNwfilterLookupByUUID = 176
	// ProcNwfilterGetXMLDesc is libvirt's REMOTE_PROC_NWFILTER_GET_XML_DESC
	ProcNwfilterGetXMLDesc = 177
	// ProcConnectNumOfNwfilters is libvirt's REMOTE_PROC_CONNECT_NUM_OF_NWFILTERS
	ProcConnectNumOfNwfilters = 178
	// ProcConnectListNwfilters is libvirt's REMOTE_PROC_CONNECT_LIST_NWFILTERS
	ProcConnectListNwfilters = 179
	// ProcNwfilterDefineXML is libvirt's REMOTE_PROC_NWFILTER_DEFINE_XML
	ProcNwfilterDefineXML = 180
	// ProcNwfilterUndefine is libvirt's REMOTE_PROC_NWFILTER_UNDEFINE
	ProcNwfilterUndefine = 181
	// ProcDomainManagedSave is libvirt's REMOTE_PROC_DOMAIN_MANAGED_SAVE
	ProcDomainManagedSave = 182
	// ProcDomainHasManagedSaveImage is libvirt's REMOTE_PROC_DOMAIN_HAS_MANAGED_SAVE_IMAGE
	ProcDomainHasManagedSaveImage = 183
	// ProcDomainManagedSaveRemove is libvirt's REMOTE_PROC_DOMAIN_MANAGED_SAVE_REMOVE
	ProcDomainManagedSaveRemove = 184
	// ProcDomainSnapshotCreateXML is libvirt's REMOTE_PROC_DOMAIN_SNAPSHOT_CREATE_XML
	ProcDomainSnapshotCreateXML = 185
	// ProcDomainSnapshotGetXMLDesc is libvirt's REMOTE_PROC_DOMAIN_SNAPSHOT_GET_XML_DESC
	ProcDomainSnapshotGetXMLDesc = 186
	// ProcDomainSnapshotNum is libvirt's REMOTE_PROC_DOMAIN_SNAPSHOT_NUM
	ProcDomainSnapshotNum = 187
	// ProcDomainSnapshotListNames is libvirt's REMOTE_PROC_DOMAIN_SNAPSHOT_LIST_NAMES
	ProcDomainSnapshotListNames = 188
	// ProcDomainSnapshotLookupByName is libvirt's REMOTE_PROC_DOMAIN_SNAPSHOT_LOOKUP_BY_NAME
	ProcDomainSnapshotLookupByName = 189
	// ProcDomainHasCurrentSnapshot is libvirt's REMOTE_PROC_DOMAIN_HAS_CURRENT_SNAPSHOT
	ProcDomainHasCurrentSnapshot = 190
	// ProcDomainSnapshotCurrent is libvirt's REMOTE_PROC_DOMAIN_SNAPSHOT_CURRENT
	ProcDomainSnapshotCurrent = 191
	// ProcDomainRevertToSnapshot is libvirt's REMOTE_PROC_DOMAIN_REVERT_TO_SNAPSHOT
	ProcDomainRevertToSnapshot = 192
	// ProcDomainSnapshotDelete is libvirt's REMOTE_PROC_DOMAIN_SNAPSHOT_DELETE
	ProcDomainSnapshotDelete = 193
	// ProcDomainGetBlockInfo is libvirt's REMOTE_PROC_DOMAIN_GET_BLOCK_INFO
	ProcDomainGetBlockInfo = 194
	// ProcDomainEventIOErrorReason is libvirt's REMOTE_PROC_DOMAIN_EVENT_IO_ERROR_REASON
	ProcDomainEventIOErrorReason = 195
	// ProcDomainCreateWithFlags is libvirt's REMOTE_PROC_DOMAIN_CREATE_WITH_FLAGS
	ProcDomainCreateWithFlags = 196
	// ProcDomainSetMemoryParameters is libvirt's REMOTE_PROC_DOMAIN_SET_MEMORY_PARAMETERS
	ProcDomainSetMemoryParameters = 197
	// ProcDomainGetMemoryParameters is libvirt's REMOTE_PROC_DOMAIN_GET_MEMORY_PARAMETERS
	ProcDomainGetMemoryParameters = 198
	// ProcDomainSetVcpusFlags is libvirt's REMOTE_PROC_DOMAIN_SET_VCPUS_FLAGS
	ProcDomainSetVcpusFlags = 199
	// ProcDomainGetVcpusFlags is libvirt's REMOTE_PROC_DOMAIN_GET_VCPUS_FLAGS
	ProcDomainGetVcpusFlags = 200
	// ProcDomainOpenConsole is libvirt's REMOTE_PROC_DOMAIN_OPEN_CONSOLE
	ProcDomainOpenConsole = 201
	// ProcDomainIsUpdated is libvirt's REMOTE_PROC_DOMAIN_IS_UPDATED
	ProcDomainIsUpdated = 202
	// ProcConnectGetSysinfo is libvirt's REMOTE_PROC_CONNECT_GET_SYSINFO
	ProcConnectGetSysinfo = 203
	// ProcDomainSetMemoryFlags is libvirt's REMOTE_PROC_DOMAIN_SET_MEMORY_FLAGS
	ProcDomainSetMemoryFlags = 204
	// ProcDomainSetBlkioParameters is libvirt's REMOTE_PROC_DOMAIN_SET_BLKIO_PARAMETERS
	ProcDomainSetBlkioParameters = 205
	// ProcDomainGetBlkioParameters is libvirt's REMOTE_PROC_DOMAIN_GET_BLKIO_PARAMETERS
	ProcDomainGetBlkioParameters = 206
	// ProcDomainMigrateSetMaxSpeed is libvirt's REMOTE_PROC_DOMAIN_MIGRATE_SET_MAX_SPEED
	ProcDomainMigrateSetMaxSpeed = 207
	// ProcStorageVolUpload is libvirt's REMOTE_PROC_STORAGE_VOL_UPLOAD
	ProcStorageVolUpload = 208
	// ProcStorageVolDownload is libvirt's REMOTE_PROC_STORAGE_VOL_DOWNLOAD
	ProcStorageVolDownload = 209
	// ProcDomainInjectNmi is libvirt's REMOTE_PROC_DOMAIN_INJECT_NMI
	ProcDomainInjectNmi = 210
	// ProcDomainScreenshot is libvirt's REMOTE_PROC_DOMAIN_SCREENSHOT
	ProcDomainScreenshot = 211
	// ProcDomainGetState is libvirt's REMOTE_PROC_DOMAIN_GET_STATE
	ProcDomainGetState = 212
	// ProcDomainMigrateBegin3 is libvirt's REMOTE_PROC_DOMAIN_MIGRATE_BEGIN3
	ProcDomainMigrateBegin3 = 213
	// ProcDomainMigratePrepare3 is libvirt's REMOTE_PROC_DOMAIN_MIGRATE_PREPARE3
	ProcDomainMigratePrepare3 = 214
	// ProcDomainMigratePrepareTunnel3 is libvirt's REMOTE_PROC_DOMAIN_MIGRATE_PREPARE_TUNNEL3
	ProcDomainMigratePrepareTunnel3 = 215
	// ProcDomainMigratePerform3 is libvirt's REMOTE_PROC_DOMAIN_MIGRATE_PERFORM3
	ProcDomainMigratePerform3 = 216
	// ProcDomainMigrateFinish3 is libvirt's REMOTE_PROC_DOMAIN_MIGRATE_FINISH3
	ProcDomainMigrateFinish3 = 217
	// ProcDomainMigrateConfirm3 is libvirt's REMOTE_PROC_DOMAIN_MIGRATE_CONFIRM3
	ProcDomainMigrateConfirm3 = 218
	// ProcDomainSetSchedulerParametersFlags is libvirt's REMOTE_PROC_DOMAIN_SET_SCHEDULER_PARAMETERS_FLAGS
	ProcDomainSetSchedulerParametersFlags = 219
	// ProcInterfaceChangeBegin is libvirt's REMOTE_PROC_INTERFACE_CHANGE_BEGIN
	ProcInterfaceChangeBegin = 220
	// ProcInterfaceChangeCommit is libvirt's REMOTE_PROC_INTERFACE_CHANGE_COMMIT
	ProcInterfaceChangeCommit = 221
	// ProcInterfaceChangeRollback is libvirt's REMOTE_PROC_INTERFACE_CHANGE_ROLLBACK
	ProcInterfaceChangeRollback = 222
	// ProcDomainGetSchedulerParametersFlags is libvirt's REMOTE_PROC_DOMAIN_GET_SCHEDULER_PARAMETERS_FLAGS
	ProcDomainGetSchedulerParametersFlags = 223
	// ProcDomainEventControlError is libvirt's REMOTE_PROC_DOMAIN_EVENT_CONTROL_ERROR
	ProcDomainEventControlError = 224
	// ProcDomainPinVcpuFlags is libvirt's REMOTE_PROC_DOMAIN_PIN_VCPU_FLAGS
	ProcDomainPinVcpuFlags = 225
	// ProcDomainSendKey is libvirt's REMOTE_PROC_DOMAIN_SEND_KEY
	ProcDomainSendKey = 226
	// ProcNodeGetCPUStats is libvirt's REMOTE_PROC_NODE_GET_CPU_STATS
	ProcNodeGetCPUStats = 227
	// ProcNodeGetMemoryStats is libvirt's REMOTE_PROC_NODE_GET_MEMORY_STATS
	ProcNodeGetMemoryStats = 228
	// ProcDomainGetControlInfo is libvirt's REMOTE_PROC_DOMAIN_GET_CONTROL_INFO
	ProcDomainGetControlInfo = 229
	// ProcDomainGetVcpuPinInfo is libvirt's REMOTE_PROC_DOMAIN_GET_VCPU_PIN_INFO
	ProcDomainGetVcpuPinInfo = 230
	// ProcDomainUndefineFlags is libvirt's REMOTE_PROC_DOMAIN_UNDEFINE_FLAGS
	ProcDomainUndefineFlags = 231
	// ProcDomainSaveFlags is libvirt's REMOTE_PROC_DOMAIN_SAVE_FLAGS
	ProcDomainSaveFlags = 232
	// ProcDomainRestoreFlags is libvirt's REMOTE_PROC_DOMAIN_RESTORE_FLAGS
	ProcDomainRestoreFlags = 233
	// ProcDomainDestroyFlags is libvirt's REMOTE_PROC_DOMAIN_DESTROY_FLAGS
	ProcDomainDestroyFlags = 234
	// ProcDomainSaveImageGetXMLDesc is libvirt's REMOTE_PROC_DOMAIN_SAVE_IMAGE_GET_XML_DESC
	ProcDomainSaveImageGetXMLDesc = 235
	// ProcDomainSaveImageDefineXML is libvirt's REMOTE_PROC_DOMAIN_SAVE_IMAGE_DEFINE_XML
	ProcDomainSaveImageDefineXML = 236
	// ProcDomainBlockJobAbort is libvirt's REMOTE_PROC_DOMAIN_BLOCK_JOB_ABORT
	ProcDomainBlockJobAbort = 237
	// ProcDomainGetBlockJobInfo is libvirt's REMOTE_PROC_DOMAIN_GET_BLOCK_JOB_INFO
	ProcDomainGetBlockJobInfo = 238
	// ProcDomainBlockJobSetSpeed is libvirt's REMOTE_PROC_DOMAIN_BLOCK_JOB_SET_SPEED
	ProcDomainBlockJobSetSpeed = 239
	// ProcDomainBlockPull is libvirt's REMOTE_PROC_DOMAIN_BLOCK_PULL
	ProcDomainBlockPull = 240
	// ProcDomainEventBlockJob is libvirt's REMOTE_PROC_DOMAIN_EVENT_BLOCK_JOB
	ProcDomainEventBlockJob = 241
	// ProcDomainMigrateGetMaxSpeed is libvirt's REMOTE_PROC_DOMAIN_MIGRATE_GET_MAX_SPEED
	ProcDomainMigrateGetMaxSpeed = 242
	// ProcDomainBlockStatsFlags is libvirt's REMOTE_PROC_DOMAIN_BLOCK_STATS_FLAGS
	ProcDomainBlockStatsFlags = 243
	// ProcDomainSnapshotGetParent is libvirt's REMOTE_PROC_DOMAIN_SNAPSHOT_GET_PARENT
	ProcDomainSnapshotGetParent = 244
	// ProcDomainReset is libvirt's REMOTE_PROC_DOMAIN_RESET
	ProcDomainReset = 245
	// ProcDomainSnapshotNumChildren is libvirt's REMOTE_PROC_DOMAIN_SNAPSHOT_NUM_CHILDREN
	ProcDomainSnapshotNumChildren = 246
	// ProcDomainSnapshotListChildrenNames is libvirt's REMOTE_PROC_DOMAIN_SNAPSHOT_LIST_CHILDREN_NAMES
	ProcDomainSnapshotListChildrenNames = 247
	// ProcDomainEventDiskChange is libvirt's REMOTE_PROC_DOMAIN_EVENT_DISK_CHANGE
	ProcDomainEventDiskChange = 248
	// ProcDomainOpenGraphics is libvirt's REMOTE_PROC_DOMAIN_OPEN_GRAPHICS
	ProcDomainOpenGraphics = 249
	// ProcNodeSuspendForDuration is libvirt's REMOTE_PROC_NODE_SUSPEND_FOR_DURATION
	ProcNodeSuspendForDuration = 250
	// ProcDomainBlockResize is libvirt's REMOTE_PROC_DOMAIN_BLOCK_RESIZE
	ProcDomainBlockResize = 251
	// ProcDomainSetBlockIOTune is libvirt's REMOTE_PROC_DOMAIN_SET_BLOCK_IO_TUNE
	ProcDomainSetBlockIOTune = 252
	// ProcDomainGetBlockIOTune is libvirt's REMOTE_PROC_DOMAIN_GET_BLOCK_IO_TUNE
	ProcDomainGetBlockIOTune = 253
	// ProcDomainSetNumaParameters is libvirt's REMOTE_PROC_DOMAIN_SET_NUMA_PARAMETERS
	ProcDomainSetNumaParameters = 254
	// ProcDomainGetNumaParameters is libvirt's REMOTE_PROC_DOMAIN_GET_NUMA_PARAMETERS
	ProcDomainGetNumaParameters = 255
	// ProcDomainSetInterfaceParameters is libvirt's REMOTE_PROC_DOMAIN_SET_INTERFACE_PARAMETERS
	ProcDomainSetInterfaceParameters = 256
	// ProcDomainGetInterfaceParameters is libvirt's REMOTE_PROC_DOMAIN_GET_INTERFACE_PARAMETERS
	ProcDomainGetInterfaceParameters = 257
	// ProcDomainShutdownFlags is libvirt's REMOTE_PROC_DOMAIN_SHUTDOWN_FLAGS
	ProcDomainShutdownFlags = 258
	// ProcStorageVolWipePattern is libvirt's REMOTE_PROC_STORAGE_VOL_WIPE_PATTERN
	ProcStorageVolWipePattern = 259
	// ProcStorageVolResize is libvirt's REMOTE_PROC_STORAGE_VOL_RESIZE
	ProcStorageVolResize = 260
	// ProcDomainPmSuspendForDuration is libvirt's REMOTE_PROC_DOMAIN_PM_SUSPEND_FOR_DURATION
	ProcDomainPmSuspendForDuration = 261
	// ProcDomainGetCPUStats is libvirt's REMOTE_PROC_DOMAIN_GET_CPU_STATS
	ProcDomainGetCPUStats = 262
	// ProcDomainGetDiskErrors is libvirt's REMOTE_PROC_DOMAIN_GET_DISK_ERRORS
	ProcDomainGetDiskErrors = 263
	// ProcDomainSetMetadata is libvirt's REMOTE_PROC_DOMAIN_SET_METADATA
	ProcDomainSetMetadata = 264
	// ProcDomainGetMetadata is libvirt's REMOTE_PROC_DOMAIN_GET_METADATA
	ProcDomainGetMetadata = 265
	// ProcDomainBlockRebase is libvirt's REMOTE_PROC_DOMAIN_BLOCK_REBASE
	ProcDomainBlockRebase = 266
	// ProcDomainPmWakeup is libvirt's REMOTE_PROC_DOMAIN_PM_WAKEUP
	ProcDomainPmWakeup = 267
	// ProcDomainEventTrayChange is libvirt's REMOTE_PROC_DOMAIN_EVENT_TRAY_CHANGE
	ProcDomainEventTrayChange = 268
	// ProcDomainEventPmwakeup is libvirt's REMOTE_PROC_DOMAIN_EVENT_PMWAKEUP
	ProcDomainEventPmwakeup = 269
	// ProcDomainEventPmsuspend is libvirt's REMOTE_PROC_DOMAIN_EVENT_PMSUSPEND
	ProcDomainEventPmsuspend = 270
	// ProcDomainSnapshotIsCurrent is libvirt's REMOTE_PROC_DOMAIN_SNAPSHOT_IS_CURRENT
	ProcDomainSnapshotIsCurrent = 271
	// ProcDomainSnapshotHasMetadata is libvirt's REMOTE_PROC_DOMAIN_SNAPSHOT_HAS_METADATA
	ProcDomainSnapshotHasMetadata = 272
	// ProcConnectListAllDomains is libvirt's REMOTE_PROC_CONNECT_LIST_ALL_DOMAINS
	ProcConnectListAllDomains = 273
	// ProcDomainListAllSnapshots is libvirt's REMOTE_PROC_DOMAIN_LIST_ALL_SNAPSHOTS
	ProcDomainListAllSnapshots = 274
	// ProcDomainSnapshotListAllChildren is libvirt's REMOTE_PROC_DOMAIN_SNAPSHOT_LIST_ALL_CHILDREN
	ProcDomainSnapshotListAllChildren = 275
	// ProcDomainEventBalloonChange is libvirt's REMOTE_PROC_DOMAIN_EVENT_BALLOON_CHANGE
	ProcDomainEventBalloonChange = 276
	// ProcDomainGetHostname is libvirt's REMOTE_PROC_DOMAIN_GET_HOSTNAME
	ProcDomainGetHostname = 277
	// ProcDomainGetSecurityLabelList is libvirt's REMOTE_PROC_DOMAIN_GET_SECURITY_LABEL_LIST
	ProcDomainGetSecurityLabelList = 278
	// ProcDomainPinEmulator is libvirt's REMOTE_PROC_DOMAIN_PIN_EMULATOR
	ProcDomainPinEmulator = 279
	// ProcDomainGetEmulatorPinInfo is libvirt's REMOTE_PROC_DOMAIN_GET_EMULATOR_PIN_INFO
	ProcDomainGetEmulatorPinInfo = 280
	// ProcConnectListAllStoragePools is libvirt's REMOTE_PROC_CONNECT_LIST_ALL_STORAGE_POOLS
	ProcConnectListAllStoragePools = 281
	// ProcStoragePoolListAllVolumes is libvirt's REMOTE_PROC_STORAGE_POOL_LIST_ALL_VOLUMES
	ProcStoragePoolListAllVolumes = 282
	// ProcConnectListAllNetworks is libvirt's REMOTE_PROC_CONNECT_LIST_ALL_NETWORKS
	ProcConnectListAllNetworks = 283
	// ProcConnectListAllInterfaces is libvirt's REMOTE_PROC_CONNECT_LIST_ALL_INTERFACES
	ProcConnectListAllInterfaces = 284
	// ProcConnectListAllNodeDevices is libvirt's REMOTE_PROC_CONNECT_LIST_ALL_NODE_DEVICES
	ProcConnectListAllNodeDevices = 285
	// ProcConnectListAllNwfilters is libvirt's REMOTE_PROC_CONNECT_LIST_ALL_NWFILTERS
	ProcConnectListAllNwfilters = 286
	// ProcConnectListAllSecrets is libvirt's REMOTE_PROC_CONNECT_LIST_ALL_SECRETS
	ProcConnectListAllSecrets = 287
	// ProcNodeSetMemoryParameters is libvirt's REMOTE_PROC_NODE_SET_MEMORY_PARAMETERS
	ProcNodeSetMemoryParameters = 288
	// ProcNodeGetMemoryParameters is libvirt's REMOTE_PROC_NODE_GET_MEMORY_PARAMETERS
	ProcNodeGetMemoryParameters = 289
	// ProcDomainBlockCommit is libvirt's REMOTE_PROC_DOMAIN_BLOCK_COMMIT
	ProcDomainBlockCommit = 290
	// ProcNetworkUpdate is libvirt's REMOTE_PROC_NETWORK_UPDATE
	ProcNetworkUpdate = 291
	// ProcDomainEventPmsuspendDisk is libvirt's REMOTE_PROC_DOMAIN_EVENT_PMSUSPEND_DISK
	ProcDomainEventPmsuspendDisk = 292
	// ProcNodeGetCPUMap is libvirt's REMOTE_PROC_NODE_GET_CPU_MAP
	ProcNodeGetCPUMap = 293
	// ProcDomainFstrim is libvirt's REMOTE_PROC_DOMAIN_FSTRIM
	ProcDomainFstrim = 294
	// ProcDomainSendProcessSignal is libvirt's REMOTE_PROC_DOMAIN_SEND_PROCESS_SIGNAL
	ProcDomainSendProcessSignal = 295
	// ProcDomainOpenChannel is libvirt's REMOTE_PROC_DOMAIN_OPEN_CHANNEL
	ProcDomainOpenChannel = 296
	// ProcNodeDeviceLookupScsiHostByWwn is libvirt's REMOTE_PROC_NODE_DEVICE_LOOKUP_SCSI_HOST_BY_WWN
	ProcNodeDeviceLookupScsiHostByWwn = 297
	// ProcDomainGetJobStats is libvirt's REMOTE_PROC_DOMAIN_GET_JOB_STATS
	ProcDomainGetJobStats = 298
	// ProcDomainMigrateGetCompressionCache is libvirt's REMOTE_PROC_DOMAIN_MIGRATE_GET_COMPRESSION_CACHE
	ProcDomainMigrateGetCompressionCache = 299
	// ProcDomainMigrateSetCompressionCache is libvirt's REMOTE_PROC_DOMAIN_MIGRATE_SET_COMPRESSION_CACHE
	ProcDomainMigrateSetCompressionCache = 300
	// ProcNodeDeviceDetachFlags is libvirt's REMOTE_PROC_NODE_DEVICE_DETACH_FLAGS
	ProcNodeDeviceDetachFlags = 301
	// ProcDomainMigrateBegin3Params is libvirt's REMOTE_PROC_DOMAIN_MIGRATE_BEGIN3_PARAMS
	ProcDomainMigrateBegin3Params = 302
	// ProcDomainMigratePrepare3Params is libvirt's REMOTE_PROC_DOMAIN_MIGRATE_PREPARE3_PARAMS
	ProcDomainMigratePrepare3Params = 303
	// ProcDomainMigratePrepareTunnel3Params is libvirt's REMOTE_PROC_DOMAIN_MIGRATE_PREPARE_TUNNEL3_PARAMS
	ProcDomainMigratePrepareTunnel3Params = 304
	// ProcDomainMigratePerform3Params is libvirt's REMOTE_PROC_DOMAIN_MIGRATE_PERFORM3_PARAMS
	ProcDomainMigratePerform3Params = 305
	// ProcDomainMigrateFinish3Params is libvirt's REMOTE_PROC_DOMAIN_MIGRATE_FINISH3_PARAMS
	ProcDomainMigrateFinish3Params = 306
	// ProcDomainMigrateConfirm3Params is libvirt's REMOTE_PROC_DOMAIN_MIGRATE_CONFIRM3_PARAMS
	ProcDomainMigrateConfirm3Params = 307
	// ProcDomainSetMemoryStatsPeriod is libvirt's REMOTE_PROC_DOMAIN_SET_MEMORY_STATS_PERIOD
	ProcDomainSetMemoryStatsPeriod = 308
	// ProcDomainCreateXMLWithFiles is libvirt's REMOTE_PROC_DOMAIN_CREATE_XML_WITH_FILES
	ProcDomainCreateXMLWithFiles = 309
	// ProcDomainCreateWithFiles is libvirt's REMOTE_PROC_DOMAIN_CREATE_WITH_FILES
	ProcDomainCreateWithFiles = 310
	// ProcDomainEventDeviceRemoved is libvirt's REMOTE_PROC_DOMAIN_EVENT_DEVICE_REMOVED
	ProcDomainEventDeviceRemoved = 311
	// ProcConnectGetCPUModelNames is libvirt's REMOTE_PROC_CONNECT_GET_CPU_MODEL_NAMES
	ProcConnectGetCPUModelNames = 312
	// ProcConnectNetworkEventRegisterAny is libvirt's REMOTE_PROC_CONNECT_NETWORK_EVENT_REGISTER_ANY
	ProcConnectNetworkEventRegisterAny = 313
	// ProcConnectNetworkEventDeregisterAny is libvirt's REMOTE_PROC_CONNECT_NETWORK_EVENT_DEREGISTER_ANY
	ProcConnectNetworkEventDeregisterAny = 314
	// ProcNetworkEventLifecycle is libvirt's REMOTE_PROC_NETWORK_EVENT_LIFECYCLE
	ProcNetworkEventLifecycle = 315
	// ProcConnectDomainEventCallbackRegisterAny is libvirt's REMOTE_PROC_CONNECT_DOMAIN_EVENT_CALLBACK_REGISTER_ANY
	ProcConnectDomainEventCallbackRegisterAny = 316
	// ProcConnectDomainEventCallbackDeregisterAny is libvirt's REMOTE_PROC_CONNECT_DOMAIN_EVENT_CALLBACK_DEREGISTER_ANY
	ProcConnectDomainEventCallbackDeregisterAny = 317
	// ProcDomainEventCallbackLifecycle is libvirt's REMOTE_PROC_DOMAIN_EVENT_CALLBACK_LIFECYCLE
	ProcDomainEventCallbackLifecycle = 318
	// ProcDomainEventCallbackReboot is libvirt's REMOTE_PROC_DOMAIN_EVENT_CALLBACK_REBOOT
	ProcDomainEventCallbackReboot = 319
	// ProcDomainEventCallbackRtcChange is libvirt's REMOTE_PROC_DOMAIN_EVENT_CALLBACK_RTC_CHANGE
	ProcDomainEventCallbackRtcChange = 320
	// ProcDomainEventCallbackWatchdog is libvirt's REMOTE_PROC_DOMAIN_EVENT_CALLBACK_WATCHDOG
	ProcDomainEventCallbackWatchdog = 321
	// ProcDomainEventCallbackIOError is libvirt's REMOTE_PROC_DOMAIN_EVENT_CALLBACK_IO_ERROR
	ProcDomainEventCallbackIOError = 322
	// ProcDomainEventCallbackGraphics is libvirt's REMOTE_PROC_DOMAIN_EVENT_CALLBACK_GRAPHICS
	ProcDomainEventCallbackGraphics = 323
	// ProcDomainEventCallbackIOErrorReason is libvirt's REMOTE_PROC_DOMAIN_EVENT_CALLBACK_IO_ERROR_REASON
	ProcDomainEventCallbackIOErrorReason = 324
	// ProcDomainEventCallbackControlError is libvirt's REMOTE_PROC_DOMAIN_EVENT_CALLBACK_CONTROL_ERROR
	ProcDomainEventCallbackControlError = 325
	// ProcDomainEventCallbackBlockJob is libvirt's REMOTE_PROC_DOMAIN_EVENT_CALLBACK_BLOCK_JOB
	ProcDomainEventCallbackBlockJob = 326
	// ProcDomainEventCallbackDiskChange is libvirt's REMOTE_PROC_DOMAIN_EVENT_CALLBACK_DISK_CHANGE
	ProcDomainEventCallbackDiskChange = 327
	// ProcDomainEventCallbackTrayChange is libvirt's REMOTE_PROC_DOMAIN_EVENT_CALLBACK_TRAY_CHANGE
	ProcDomainEventCallbackTrayChange = 328
	// ProcDomainEventCallbackPmwakeup is libvirt's REMOTE_PROC_DOMAIN_EVENT_CALLBACK_PMWAKEUP
	ProcDomainEventCallbackPmwakeup = 329
	// ProcDomainEventCallbackPmsuspend is libvirt's REMOTE_PROC_DOMAIN_EVENT_CALLBACK_PMSUSPEND
	ProcDomainEventCallbackPmsuspend = 330
	// ProcDomainEventCallbackBalloonChange is libvirt's REMOTE_PROC_DOMAIN_EVENT_CALLBACK_BALLOON_CHANGE
	ProcDomainEventCallbackBalloonChange = 331
	// ProcDomainEventCallbackPmsuspendDisk is libvirt's REMOTE_PROC_DOMAIN_EVENT_CALLBACK_PMSUSPEND_DISK
	ProcDomainEventCallbackPmsuspendDisk = 332
	// ProcDomainEventCallbackDeviceRemoved is libvirt's REMOTE_PROC_DOMAIN_EVENT_CALLBACK_DEVICE_REMOVED
	ProcDomainEventCallbackDeviceRemoved = 333
	// ProcDomainCoreDumpWithFormat is libvirt's REMOTE_PROC_DOMAIN_CORE_DUMP_WITH_FORMAT
	ProcDomainCoreDumpWithFormat = 334
	// ProcDomainFsfreeze is libvirt's REMOTE_PROC_DOMAIN_FSFREEZE
	ProcDomainFsfreeze = 335
	// ProcDomainFsthaw is libvirt's REMOTE_PROC_DOMAIN_FSTHAW
	ProcDomainFsthaw = 336
	// ProcDomainGetTime is libvirt's REMOTE_PROC_DOMAIN_GET_TIME
	ProcDomainGetTime = 337
	// ProcDomainSetTime is libvirt's REMOTE_PROC_DOMAIN_SET_TIME
	ProcDomainSetTime = 338
	// ProcDomainEventBlockJob2 is libvirt's REMOTE_PROC_DOMAIN_EVENT_BLOCK_JOB_2
	ProcDomainEventBlockJob2 = 339
	// ProcNodeGetFreePages is libvirt's REMOTE_PROC_NODE_GET_FREE_PAGES
	ProcNodeGetFreePages = 340
	// ProcNetworkGetDhcpLeases is libvirt's REMOTE_PROC_NETWORK_GET_DHCP_LEASES
	ProcNetworkGetDhcpLeases = 341
	// ProcConnectGetDomainCapabilities is libvirt's REMOTE_PROC_CONNECT_GET_DOMAIN_CAPABILITIES
	ProcConnectGetDomainCapabilities = 342
	// ProcDomainOpenGraphicsFd is libvirt's REMOTE_PROC_DOMAIN_OPEN_GRAPHICS_FD
	ProcDomainOpenGraphicsFd = 343
	// ProcConnectGetAllDomainStats is libvirt's REMOTE_PROC_CONNECT_GET_ALL_DOMAIN_STATS
	ProcConnectGetAllDomainStats = 344
	// ProcDomainBlockCopy is libvirt's REMOTE_PROC_DOMAIN_BLOCK_COPY
	ProcDomainBlockCopy = 345
	// ProcDomainEventCallbackTunable is libvirt's REMOTE_PROC_DOMAIN_EVENT_CALLBACK_TUNABLE
	ProcDomainEventCallbackTunable = 346
	// ProcNodeAllocPages is libvirt's REMOTE_PROC_NODE_ALLOC_PAGES
	ProcNodeAllocPages = 347
	// ProcDomainEventCallbackAgentLifecycle is libvirt's REMOTE_PROC_DOMAIN_EVENT_CALLBACK_AGENT_LIFECYCLE
	ProcDomainEventCallbackAgentLifecycle = 348
	// ProcDomainGetFsinfo is libvirt's REMOTE_PROC_DOMAIN_GET_FSINFO
	ProcDomainGetFsinfo = 349
	// ProcDomainDefineXMLFlags is libvirt's REMOTE_PROC_DOMAIN_DEFINE_XML_FLAGS
	ProcDomainDefineXMLFlags = 350
	// ProcDomainGetIothreadInfo is libvirt's REMOTE_PROC_DOMAIN_GET_IOTHREAD_INFO
	ProcDomainGetIothreadInfo = 351
	// ProcDomainPinIothread is libvirt's REMOTE_PROC_DOMAIN_PIN_IOTHREAD
	ProcDomainPinIothread = 352
	// ProcDomainInterfaceAddresses is libvirt's REMOTE_PROC_DOMAIN_INTERFACE_ADDRESSES
	ProcDomainInterfaceAddresses = 353
	// ProcDomainEventCallbackDeviceAdded is libvirt's REMOTE_PROC_DOMAIN_EVENT_CALLBACK_DEVICE_ADDED
	ProcDomainEventCallbackDeviceAdded = 354
	// ProcDomainAddIothread is libvirt's REMOTE_PROC_DOMAIN_ADD_IOTHREAD
	ProcDomainAddIothread = 355
	// ProcDomainDelIothread is libvirt's REMOTE_PROC_DOMAIN_DEL_IOTHREAD
	ProcDomainDelIothread = 356
	// ProcDomainSetUserPassword is libvirt's REMOTE_PROC_DOMAIN_SET_USER_PASSWORD
	ProcDomainSetUserPassword = 357
	// ProcDomainRename is libvirt's REMOTE_PROC_DOMAIN_RENAME
	ProcDomainRename = 358
	// ProcDomainEventCallbackMigrationIteration is libvirt's REMOTE_PROC_DOMAIN_EVENT_CALLBACK_MIGRATION_ITERATION
	ProcDomainEventCallbackMigrationIteration = 359
	// ProcConnectRegisterCloseCallback is libvirt's REMOTE_PROC_CONNECT_REGISTER_CLOSE_CALLBACK
	ProcConnectRegisterCloseCallback = 360
	// ProcConnectUnregisterCloseCallback is libvirt's REMOTE_PROC_CONNECT_UNREGISTER_CLOSE_CALLBACK
	ProcConnectUnregisterCloseCallback = 361
	// ProcConnectEventConnectionClosed is libvirt's REMOTE_PROC_CONNECT_EVENT_CONNECTION_CLOSED
	ProcConnectEventConnectionClosed = 362
	// ProcDomainEventCallbackJobCompleted is libvirt's REMOTE_PROC_DOMAIN_EVENT_CALLBACK_JOB_COMPLETED
	ProcDomainEventCallbackJobCompleted = 363
	// ProcDomainMigrateStartPostCopy is libvirt's REMOTE_PROC_DOMAIN_MIGRATE_START_POST_COPY
	ProcDomainMigrateStartPostCopy = 364
	// ProcDomainGetPerfEvents is libvirt's REMOTE_PROC_DOMAIN_GET_PERF_EVENTS
	ProcDomainGetPerfEvents = 365
	// ProcDomainSetPerfEvents is libvirt's REMOTE_PROC_DOMAIN_SET_PERF_EVENTS
	ProcDomainSetPerfEvents = 366
	// ProcDomainEventCallbackDeviceRemovalFailed is libvirt's REMOTE_PROC_DOMAIN_EVENT_CALLBACK_DEVICE_REMOVAL_FAILED
	ProcDomainEventCallbackDeviceRemovalFailed = 367
	// ProcConnectStoragePoolEventRegisterAny is libvirt's REMOTE_PROC_CONNECT_STORAGE_POOL_EVENT_REGISTER_ANY
	ProcConnectStoragePoolEventRegisterAny = 368
	// ProcConnectStoragePoolEventDeregisterAny is libvirt's REMOTE_PROC_CONNECT_STORAGE_POOL_EVENT_DEREGISTER_ANY
	ProcConnectStoragePoolEventDeregisterAny = 369
	// ProcStoragePoolEventLifecycle is libvirt's REMOTE_PROC_STORAGE_POOL_EVENT_LIFECYCLE
	ProcStoragePoolEventLifecycle = 370
	// ProcDomainGetGuestVcpus is libvirt's REMOTE_PROC_DOMAIN_GET_GUEST_VCPUS
	ProcDomainGetGuestVcpus = 371
	// ProcDomainSetGuestVcpus is libvirt's REMOTE_PROC_DOMAIN_SET_GUEST_VCPUS
	ProcDomainSetGuestVcpus = 372
	// ProcStoragePoolEventRefresh is libvirt's REMOTE_PROC_STORAGE_POOL_EVENT_REFRESH
	ProcStoragePoolEventRefresh = 373
	// ProcConnectNodeDeviceEventRegisterAny is libvirt's REMOTE_PROC_CONNECT_NODE_DEVICE_EVENT_REGISTER_ANY
	ProcConnectNodeDeviceEventRegisterAny = 374
	// ProcConnectNodeDeviceEventDeregisterAny is libvirt's REMOTE_PROC_CONNECT_NODE_DEVICE_EVENT_DEREGISTER_ANY
	ProcConnectNodeDeviceEventDeregisterAny = 375
	// ProcNodeDeviceEventLifecycle is libvirt's REMOTE_PROC_NODE_DEVICE_EVENT_LIFECYCLE
	ProcNodeDeviceEventLifecycle = 376
	// ProcNodeDeviceEventUpdate is libvirt's REMOTE_PROC_NODE_DEVICE_EVENT_UPDATE
	ProcNodeDeviceEventUpdate = 377
	// ProcStorageVolGetInfoFlags is libvirt's REMOTE_PROC_STORAGE_VOL_GET_INFO_FLAGS
	ProcStorageVolGetInfoFlags = 378
	// ProcDomainEventCallbackMetadataChange is libvirt's REMOTE_PROC_DOMAIN_EVENT_CALLBACK_METADATA_CHANGE
	ProcDomainEventCallbackMetadataChange = 379
	// ProcConnectSecretEventRegisterAny is libvirt's REMOTE_PROC_CONNECT_SECRET_EVENT_REGISTER_ANY
	ProcConnectSecretEventRegisterAny = 380
	// ProcConnectSecretEventDeregisterAny is libvirt's REMOTE_PROC_CONNECT_SECRET_EVENT_DEREGISTER_ANY
	ProcConnectSecretEventDeregisterAny = 381
	// ProcSecretEventLifecycle is libvirt's REMOTE_PROC_SECRET_EVENT_LIFECYCLE
	ProcSecretEventLifecycle = 382
	// ProcSecretEventValueChanged is libvirt's REMOTE_PROC_SECRET_EVENT_VALUE_CHANGED
	ProcSecretEventValueChanged = 383
	// ProcDomainSetVcpu is libvirt's REMOTE_PROC_DOMAIN_SET_VCPU
	ProcDomainSetVcpu = 384
	// ProcDomainEventBlockThreshold is libvirt's REMOTE_PROC_DOMAIN_EVENT_BLOCK_THRESHOLD
	ProcDomainEventBlockThreshold = 385
	// ProcDomainSetBlockThreshold is libvirt's REMOTE_PROC_DOMAIN_SET_BLOCK_THRESHOLD
	ProcDomainSetBlockThreshold = 386
	// ProcDomainMigrateGetMaxDowntime is libvirt's REMOTE_PROC_DOMAIN_MIGRATE_GET_MAX_DOWNTIME
	ProcDomainMigrateGetMaxDowntime = 387
	// ProcDomainManagedSaveGetXMLDesc is libvirt's REMOTE_PROC_DOMAIN_MANAGED_SAVE_GET_XML_DESC
	ProcDomainManagedSaveGetXMLDesc = 388
	// ProcDomainManagedSaveDefineXML is libvirt's REMOTE_PROC_DOMAIN_MANAGED_SAVE_DEFINE_XML
	ProcDomainManagedSaveDefineXML = 389
	// ProcDomainSetLifecycleAction is libvirt's REMOTE_PROC_DOMAIN_SET_LIFECYCLE_ACTION
	ProcDomainSetLifecycleAction = 390
	// ProcStoragePoolLookupByTargetPath is libvirt's REMOTE_PROC_STORAGE_POOL_LOOKUP_BY_TARGET_PATH
	ProcStoragePoolLookupByTargetPath = 391
	// ProcDomainDetachDeviceAlias is libvirt's REMOTE_PROC_DOMAIN_DETACH_DEVICE_ALIAS
	ProcDomainDetachDeviceAlias = 392
	// ProcConnectCompareHypervisorCPU is libvirt's REMOTE_PROC_CONNECT_COMPARE_HYPERVISOR_CPU
	ProcConnectCompareHypervisorCPU = 393
	// ProcConnectBaselineHypervisorCPU is libvirt's REMOTE_PROC_CONNECT_BASELINE_HYPERVISOR_CPU
	ProcConnectBaselineHypervisorCPU = 394
	// ProcNodeGetSevInfo is libvirt's REMOTE_PROC_NODE_GET_SEV_INFO
	ProcNodeGetSevInfo = 395
	// ProcDomainGetLaunchSecurityInfo is libvirt's REMOTE_PROC_DOMAIN_GET_LAUNCH_SECURITY_INFO
	ProcDomainGetLaunchSecurityInfo = 396
	// ProcNwfilterBindingLookupByPortDev is libvirt's REMOTE_PROC_NWFILTER_BINDING_LOOKUP_BY_PORT_DEV
	ProcNwfilterBindingLookupByPortDev = 397
	// ProcNwfilterBindingGetXMLDesc is libvirt's REMOTE_PROC_NWFILTER_BINDING_GET_XML_DESC
	ProcNwfilterBindingGetXMLDesc = 398
	// ProcNwfilterBindingCreateXML is libvirt's REMOTE_PROC_NWFILTER_BINDING_CREATE_XML
	ProcNwfilterBindingCreateXML = 399
	// ProcNwfilterBindingDelete is libvirt's REMOTE_PROC_NWFILTER_BINDING_DELETE
	ProcNwfilterBindingDelete = 400
	// ProcConnectListAllNwfilterBindings is libvirt's REMOTE_PROC_CONNECT_LIST_ALL_NWFILTER_BINDINGS
	ProcConnectListAllNwfilterBindings = 401
	// ProcDomainSetIothreadParams is libvirt's REMOTE_PROC_DOMAIN_SET_IOTHREAD_PARAMS
	ProcDomainSetIothreadParams = 402


	// From consts:
	// StringMax is libvirt's REMOTE_STRING_MAX
	StringMax = 4194304
	// DomainListMax is libvirt's REMOTE_DOMAIN_LIST_MAX
	DomainListMax = 16384
	// CpumapMax is libvirt's REMOTE_CPUMAP_MAX
	CpumapMax = 2048
	// VcpuinfoMax is libvirt's REMOTE_VCPUINFO_MAX
	VcpuinfoMax = 16384
	// CpumapsMax is libvirt's REMOTE_CPUMAPS_MAX
	CpumapsMax = 8388608
	// IothreadInfoMax is libvirt's REMOTE_IOTHREAD_INFO_MAX
	IothreadInfoMax = 16384
	// MigrateCookieMax is libvirt's REMOTE_MIGRATE_COOKIE_MAX
	MigrateCookieMax = 4194304
	// NetworkListMax is libvirt's REMOTE_NETWORK_LIST_MAX
	NetworkListMax = 16384
	// InterfaceListMax is libvirt's REMOTE_INTERFACE_LIST_MAX
	InterfaceListMax = 16384
	// StoragePoolListMax is libvirt's REMOTE_STORAGE_POOL_LIST_MAX
	StoragePoolListMax = 16384
	// StorageVolListMax is libvirt's REMOTE_STORAGE_VOL_LIST_MAX
	StorageVolListMax = 16384
	// NodeDeviceListMax is libvirt's REMOTE_NODE_DEVICE_LIST_MAX
	NodeDeviceListMax = 65536
	// NodeDeviceCapsListMax is libvirt's REMOTE_NODE_DEVICE_CAPS_LIST_MAX
	NodeDeviceCapsListMax = 65536
	// NwfilterListMax is libvirt's REMOTE_NWFILTER_LIST_MAX
	NwfilterListMax = 16384
	// NwfilterBindingListMax is libvirt's REMOTE_NWFILTER_BINDING_LIST_MAX
	NwfilterBindingListMax = 16384
	// DomainSchedulerParametersMax is libvirt's REMOTE_DOMAIN_SCHEDULER_PARAMETERS_MAX
	DomainSchedulerParametersMax = 16
	// DomainBlkioParametersMax is libvirt's REMOTE_DOMAIN_BLKIO_PARAMETERS_MAX
	DomainBlkioParametersMax = 16
	// DomainMemoryParametersMax is libvirt's REMOTE_DOMAIN_MEMORY_PARAMETERS_MAX
	DomainMemoryParametersMax = 16
	// DomainBlockIOTuneParametersMax is libvirt's REMOTE_DOMAIN_BLOCK_IO_TUNE_PARAMETERS_MAX
	DomainBlockIOTuneParametersMax = 32
	// DomainNumaParametersMax is libvirt's REMOTE_DOMAIN_NUMA_PARAMETERS_MAX
	DomainNumaParametersMax = 16
	// DomainPerfEventsMax is libvirt's REMOTE_DOMAIN_PERF_EVENTS_MAX
	DomainPerfEventsMax = 64
	// DomainBlockCopyParametersMax is libvirt's REMOTE_DOMAIN_BLOCK_COPY_PARAMETERS_MAX
	DomainBlockCopyParametersMax = 16
	// NodeCPUStatsMax is libvirt's REMOTE_NODE_CPU_STATS_MAX
	NodeCPUStatsMax = 16
	// NodeMemoryStatsMax is libvirt's REMOTE_NODE_MEMORY_STATS_MAX
	NodeMemoryStatsMax = 16
	// DomainBlockStatsParametersMax is libvirt's REMOTE_DOMAIN_BLOCK_STATS_PARAMETERS_MAX
	DomainBlockStatsParametersMax = 16
	// NodeMaxCells is libvirt's REMOTE_NODE_MAX_CELLS
	NodeMaxCells = 1024
	// AuthSaslDataMax is libvirt's REMOTE_AUTH_SASL_DATA_MAX
	AuthSaslDataMax = 65536
	// AuthTypeListMax is libvirt's REMOTE_AUTH_TYPE_LIST_MAX
	AuthTypeListMax = 20
	// DomainMemoryStatsMax is libvirt's REMOTE_DOMAIN_MEMORY_STATS_MAX
	DomainMemoryStatsMax = 1024
	// DomainSnapshotListMax is libvirt's REMOTE_DOMAIN_SNAPSHOT_LIST_MAX
	DomainSnapshotListMax = 16384
	// DomainBlockPeekBufferMax is libvirt's REMOTE_DOMAIN_BLOCK_PEEK_BUFFER_MAX
	DomainBlockPeekBufferMax = 4194304
	// DomainMemoryPeekBufferMax is libvirt's REMOTE_DOMAIN_MEMORY_PEEK_BUFFER_MAX
	DomainMemoryPeekBufferMax = 4194304
	// SecurityLabelListMax is libvirt's REMOTE_SECURITY_LABEL_LIST_MAX
	SecurityLabelListMax = 64
	// SecretValueMax is libvirt's REMOTE_SECRET_VALUE_MAX
	SecretValueMax = 65536
	// SecretListMax is libvirt's REMOTE_SECRET_LIST_MAX
	SecretListMax = 16384
	// CPUBaselineMax is libvirt's REMOTE_CPU_BASELINE_MAX
	CPUBaselineMax = 256
	// DomainSendKeyMax is libvirt's REMOTE_DOMAIN_SEND_KEY_MAX
	DomainSendKeyMax = 16
	// DomainInterfaceParametersMax is libvirt's REMOTE_DOMAIN_INTERFACE_PARAMETERS_MAX
	DomainInterfaceParametersMax = 16
	// DomainGetCPUStatsNcpusMax is libvirt's REMOTE_DOMAIN_GET_CPU_STATS_NCPUS_MAX
	DomainGetCPUStatsNcpusMax = 128
	// DomainGetCPUStatsMax is libvirt's REMOTE_DOMAIN_GET_CPU_STATS_MAX
	DomainGetCPUStatsMax = 2048
	// DomainDiskErrorsMax is libvirt's REMOTE_DOMAIN_DISK_ERRORS_MAX
	DomainDiskErrorsMax = 256
	// NodeMemoryParametersMax is libvirt's REMOTE_NODE_MEMORY_PARAMETERS_MAX
	NodeMemoryParametersMax = 64
	// DomainMigrateParamListMax is libvirt's REMOTE_DOMAIN_MIGRATE_PARAM_LIST_MAX
	DomainMigrateParamListMax = 64
	// DomainJobStatsMax is libvirt's REMOTE_DOMAIN_JOB_STATS_MAX
	DomainJobStatsMax = 64
	// ConnectCPUModelsMax is libvirt's REMOTE_CONNECT_CPU_MODELS_MAX
	ConnectCPUModelsMax = 8192
	// DomainFsfreezeMountpointsMax is libvirt's REMOTE_DOMAIN_FSFREEZE_MOUNTPOINTS_MAX
	DomainFsfreezeMountpointsMax = 256
	// NetworkDhcpLeasesMax is libvirt's REMOTE_NETWORK_DHCP_LEASES_MAX
	NetworkDhcpLeasesMax = 65536
	// ConnectGetAllDomainStatsMax is libvirt's REMOTE_CONNECT_GET_ALL_DOMAIN_STATS_MAX
	ConnectGetAllDomainStatsMax = 262144
	// DomainEventTunableMax is libvirt's REMOTE_DOMAIN_EVENT_TUNABLE_MAX
	DomainEventTunableMax = 2048
	// DomainFsinfoMax is libvirt's REMOTE_DOMAIN_FSINFO_MAX
	DomainFsinfoMax = 256
	// DomainFsinfoDisksMax is libvirt's REMOTE_DOMAIN_FSINFO_DISKS_MAX
	DomainFsinfoDisksMax = 256
	// DomainInterfaceMax is libvirt's REMOTE_DOMAIN_INTERFACE_MAX
	DomainInterfaceMax = 2048
	// DomainIPAddrMax is libvirt's REMOTE_DOMAIN_IP_ADDR_MAX
	DomainIPAddrMax = 2048
	// DomainGuestVcpuParamsMax is libvirt's REMOTE_DOMAIN_GUEST_VCPU_PARAMS_MAX
	DomainGuestVcpuParamsMax = 64
	// DomainIothreadParamsMax is libvirt's REMOTE_DOMAIN_IOTHREAD_PARAMS_MAX
	DomainIothreadParamsMax = 64
	// NodeSevInfoMax is libvirt's REMOTE_NODE_SEV_INFO_MAX
	NodeSevInfoMax = 64
	// DomainLaunchSecurityInfoParamsMax is libvirt's REMOTE_DOMAIN_LAUNCH_SECURITY_INFO_PARAMS_MAX
	DomainLaunchSecurityInfoParamsMax = 64
	// DomainEventGraphicsIdentityMax is libvirt's REMOTE_DOMAIN_EVENT_GRAPHICS_IDENTITY_MAX
	DomainEventGraphicsIdentityMax = 20
	// Program is libvirt's REMOTE_PROGRAM
	Program = 0x20008086
	// ProtocolVersion is libvirt's REMOTE_PROTOCOL_VERSION
	ProtocolVersion = 1
)
