// Copyright 2018 The go-libvirt Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//
// Code generated by internal/lvgen/generate.go. DO NOT EDIT.
//
// To regenerate, run 'go generate' in internal/lvgen.
//

package libvirt

import (
	"bytes"
	"fmt"
	"io"
	"reflect"

	"github.com/digitalocean/go-libvirt/internal/constants"
	"github.com/digitalocean/go-libvirt/internal/go-xdr/xdr2"
)

const (
	VirUUIDBuflen = 16
)

type typedParamDecoder struct {}

// Decode decodes a TypedParam. These are part of the libvirt spec, and not xdr
// proper. TypedParams contain a name, which is called Field for some reason,
// and a Value, which itself has a "discriminant" - an integer enum encoding the
// actual type, and a value, the length of which varies based on the actual
// type.
func (tpd typedParamDecoder) Decode(d *xdr.Decoder, v reflect.Value) (int, error) {
	// Get the name of the typed param first
	name, n, err := d.DecodeString()
	if err != nil {
		return n, err
	}
	val, n2, err := tpd.decodeTypedParamValue(d)
	n += n2
	if err != nil {
		return n, err
	}
	tp := &TypedParam{Field: name, Value: *val}
	v.Set(reflect.ValueOf(*tp))

	return n, nil
}

// decodeTypedParamValue decodes the Value part of a TypedParam.
func (typedParamDecoder) decodeTypedParamValue(d *xdr.Decoder) (*TypedParamValue, int, error) {
	// All TypedParamValues begin with a uint32 discriminant that tells us what
	// type they are.
	discriminant, n, err := d.DecodeUint()
	if err != nil {
		return nil, n, err
	}
	var n2 int
	var tpv *TypedParamValue
	switch discriminant {
	case 1:
		var val int32
		n2, err = d.Decode(&val)
		tpv = &TypedParamValue{D: discriminant, I: val}
	case 2:
		var val uint32
		n2, err = d.Decode(&val)
		tpv = &TypedParamValue{D: discriminant, I: val}
	case 3:
		var val int64
		n2, err = d.Decode(&val)
		tpv = &TypedParamValue{D: discriminant, I: val}
	case 4:
		var val uint64
		n2, err = d.Decode(&val)
		tpv = &TypedParamValue{D: discriminant, I: val}
	case 5:
		var val float64
		n2, err = d.Decode(&val)
		tpv = &TypedParamValue{D: discriminant, I: val}
	case 6:
		var val int32
		n2, err = d.Decode(&val)
		tpv = &TypedParamValue{D: discriminant, I: val}
	case 7:
		var val string
		n2, err = d.Decode(&val)
		tpv = &TypedParamValue{D: discriminant, I: val}

	default:
		err = fmt.Errorf("invalid parameter type %v", discriminant)
	}
	n += n2

	return tpv, n, err
}

//
// Typedefs:
//
// OptString is libvirt's remote_string
type OptString []string
// UUID is libvirt's remote_uuid
type UUID [VirUUIDBuflen]byte
// OptDomain is libvirt's remote_domain
type OptDomain []Domain
// OptNetwork is libvirt's remote_network
type OptNetwork []Network
// OptNwfilter is libvirt's remote_nwfilter
type OptNwfilter []Nwfilter
// OptNwfilterBinding is libvirt's remote_nwfilter_binding
type OptNwfilterBinding []NwfilterBinding
// OptStoragePool is libvirt's remote_storage_pool
type OptStoragePool []StoragePool
// OptStorageVol is libvirt's remote_storage_vol
type OptStorageVol []StorageVol
// OptNodeDevice is libvirt's remote_node_device
type OptNodeDevice []NodeDevice
// OptSecret is libvirt's remote_secret
type OptSecret []Secret

//
// Enums:
//
// AuthType is libvirt's remote_auth_type
type AuthType int32
// Procedure is libvirt's remote_procedure
type Procedure int32

//
// Structs:
//
// Domain is libvirt's remote_nonnull_domain
type Domain struct {
	Name string
	UUID UUID
	ID int32
}

// Network is libvirt's remote_nonnull_network
type Network struct {
	Name string
	UUID UUID
}

// Nwfilter is libvirt's remote_nonnull_nwfilter
type Nwfilter struct {
	Name string
	UUID UUID
}

// NwfilterBinding is libvirt's remote_nonnull_nwfilter_binding
type NwfilterBinding struct {
	Portdev string
	Filtername string
}

// Interface is libvirt's remote_nonnull_interface
type Interface struct {
	Name string
	Mac string
}

// StoragePool is libvirt's remote_nonnull_storage_pool
type StoragePool struct {
	Name string
	UUID UUID
}

// StorageVol is libvirt's remote_nonnull_storage_vol
type StorageVol struct {
	Pool string
	Name string
	Key string
}

// NodeDevice is libvirt's remote_nonnull_node_device
type NodeDevice struct {
	Name string
}

// Secret is libvirt's remote_nonnull_secret
type Secret struct {
	UUID UUID
	UsageType int32
	UsageID string
}

// DomainSnapshot is libvirt's remote_nonnull_domain_snapshot
type DomainSnapshot struct {
	Name string
	Dom Domain
}

// Error is libvirt's remote_error
type Error struct {
	Code int32
	OptDomain int32
	Message OptString
	Level int32
	Dom OptDomain
	Str1 OptString
	Str2 OptString
	Str3 OptString
	Int1 int32
	Int2 int32
	Net OptNetwork
}

// VcpuInfo is libvirt's remote_vcpu_info
type VcpuInfo struct {
	Number uint32
	State int32
	CPUTime uint64
	CPU int32
}

// TypedParam is libvirt's remote_typed_param
type TypedParam struct {
	Field string
	Value TypedParamValue
}

// NodeGetCPUStats is libvirt's remote_node_get_cpu_stats
type NodeGetCPUStats struct {
	Field string
	Value uint64
}

// NodeGetMemoryStats is libvirt's remote_node_get_memory_stats
type NodeGetMemoryStats struct {
	Field string
	Value uint64
}

// DomainDiskError is libvirt's remote_domain_disk_error
type DomainDiskError struct {
	Disk string
	Error int32
}

// ConnectOpenArgs is libvirt's remote_connect_open_args
type ConnectOpenArgs struct {
	Name OptString
	Flags ConnectFlags
}

// ConnectSupportsFeatureArgs is libvirt's remote_connect_supports_feature_args
type ConnectSupportsFeatureArgs struct {
	Feature int32
}

// ConnectSupportsFeatureRet is libvirt's remote_connect_supports_feature_ret
type ConnectSupportsFeatureRet struct {
	Supported int32
}

// ConnectGetTypeRet is libvirt's remote_connect_get_type_ret
type ConnectGetTypeRet struct {
	Type string
}

// ConnectGetVersionRet is libvirt's remote_connect_get_version_ret
type ConnectGetVersionRet struct {
	HvVer uint64
}

// ConnectGetLibVersionRet is libvirt's remote_connect_get_lib_version_ret
type ConnectGetLibVersionRet struct {
	LibVer uint64
}

// ConnectGetHostnameRet is libvirt's remote_connect_get_hostname_ret
type ConnectGetHostnameRet struct {
	Hostname string
}

// ConnectGetSysinfoArgs is libvirt's remote_connect_get_sysinfo_args
type ConnectGetSysinfoArgs struct {
	Flags uint32
}

// ConnectGetSysinfoRet is libvirt's remote_connect_get_sysinfo_ret
type ConnectGetSysinfoRet struct {
	Sysinfo string
}

// ConnectGetUriRet is libvirt's remote_connect_get_uri_ret
type ConnectGetUriRet struct {
	Uri string
}

// ConnectGetMaxVcpusArgs is libvirt's remote_connect_get_max_vcpus_args
type ConnectGetMaxVcpusArgs struct {
	Type OptString
}

// ConnectGetMaxVcpusRet is libvirt's remote_connect_get_max_vcpus_ret
type ConnectGetMaxVcpusRet struct {
	MaxVcpus int32
}

// NodeGetInfoRet is libvirt's remote_node_get_info_ret
type NodeGetInfoRet struct {
	Model [32]int8
	Memory uint64
	Cpus int32
	Mhz int32
	Nodes int32
	Sockets int32
	Cores int32
	Threads int32
}

// ConnectGetCapabilitiesRet is libvirt's remote_connect_get_capabilities_ret
type ConnectGetCapabilitiesRet struct {
	Capabilities string
}

// ConnectGetDomainCapabilitiesArgs is libvirt's remote_connect_get_domain_capabilities_args
type ConnectGetDomainCapabilitiesArgs struct {
	Emulatorbin OptString
	Arch OptString
	Machine OptString
	Virttype OptString
	Flags uint32
}

// ConnectGetDomainCapabilitiesRet is libvirt's remote_connect_get_domain_capabilities_ret
type ConnectGetDomainCapabilitiesRet struct {
	Capabilities string
}

// NodeGetCPUStatsArgs is libvirt's remote_node_get_cpu_stats_args
type NodeGetCPUStatsArgs struct {
	CPUNum int32
	Nparams int32
	Flags uint32
}

// NodeGetCPUStatsRet is libvirt's remote_node_get_cpu_stats_ret
type NodeGetCPUStatsRet struct {
	Params []NodeGetCPUStats
	Nparams int32
}

// NodeGetMemoryStatsArgs is libvirt's remote_node_get_memory_stats_args
type NodeGetMemoryStatsArgs struct {
	Nparams int32
	CellNum int32
	Flags uint32
}

// NodeGetMemoryStatsRet is libvirt's remote_node_get_memory_stats_ret
type NodeGetMemoryStatsRet struct {
	Params []NodeGetMemoryStats
	Nparams int32
}

// NodeGetCellsFreeMemoryArgs is libvirt's remote_node_get_cells_free_memory_args
type NodeGetCellsFreeMemoryArgs struct {
	StartCell int32
	Maxcells int32
}

// NodeGetCellsFreeMemoryRet is libvirt's remote_node_get_cells_free_memory_ret
type NodeGetCellsFreeMemoryRet struct {
	Cells []uint64
}

// NodeGetFreeMemoryRet is libvirt's remote_node_get_free_memory_ret
type NodeGetFreeMemoryRet struct {
	FreeMem uint64
}

// DomainGetSchedulerTypeArgs is libvirt's remote_domain_get_scheduler_type_args
type DomainGetSchedulerTypeArgs struct {
	Dom Domain
}

// DomainGetSchedulerTypeRet is libvirt's remote_domain_get_scheduler_type_ret
type DomainGetSchedulerTypeRet struct {
	Type string
	Nparams int32
}

// DomainGetSchedulerParametersArgs is libvirt's remote_domain_get_scheduler_parameters_args
type DomainGetSchedulerParametersArgs struct {
	Dom Domain
	Nparams int32
}

// DomainGetSchedulerParametersRet is libvirt's remote_domain_get_scheduler_parameters_ret
type DomainGetSchedulerParametersRet struct {
	Params []TypedParam
}

// DomainGetSchedulerParametersFlagsArgs is libvirt's remote_domain_get_scheduler_parameters_flags_args
type DomainGetSchedulerParametersFlagsArgs struct {
	Dom Domain
	Nparams int32
	Flags uint32
}

// DomainGetSchedulerParametersFlagsRet is libvirt's remote_domain_get_scheduler_parameters_flags_ret
type DomainGetSchedulerParametersFlagsRet struct {
	Params []TypedParam
}

// DomainSetSchedulerParametersArgs is libvirt's remote_domain_set_scheduler_parameters_args
type DomainSetSchedulerParametersArgs struct {
	Dom Domain
	Params []TypedParam
}

// DomainSetSchedulerParametersFlagsArgs is libvirt's remote_domain_set_scheduler_parameters_flags_args
type DomainSetSchedulerParametersFlagsArgs struct {
	Dom Domain
	Params []TypedParam
	Flags uint32
}

// DomainSetBlkioParametersArgs is libvirt's remote_domain_set_blkio_parameters_args
type DomainSetBlkioParametersArgs struct {
	Dom Domain
	Params []TypedParam
	Flags uint32
}

// DomainGetBlkioParametersArgs is libvirt's remote_domain_get_blkio_parameters_args
type DomainGetBlkioParametersArgs struct {
	Dom Domain
	Nparams int32
	Flags uint32
}

// DomainGetBlkioParametersRet is libvirt's remote_domain_get_blkio_parameters_ret
type DomainGetBlkioParametersRet struct {
	Params []TypedParam
	Nparams int32
}

// DomainSetMemoryParametersArgs is libvirt's remote_domain_set_memory_parameters_args
type DomainSetMemoryParametersArgs struct {
	Dom Domain
	Params []TypedParam
	Flags uint32
}

// DomainGetMemoryParametersArgs is libvirt's remote_domain_get_memory_parameters_args
type DomainGetMemoryParametersArgs struct {
	Dom Domain
	Nparams int32
	Flags uint32
}

// DomainGetMemoryParametersRet is libvirt's remote_domain_get_memory_parameters_ret
type DomainGetMemoryParametersRet struct {
	Params []TypedParam
	Nparams int32
}

// DomainBlockResizeArgs is libvirt's remote_domain_block_resize_args
type DomainBlockResizeArgs struct {
	Dom Domain
	Disk string
	Size uint64
	Flags DomainBlockResizeFlags
}

// DomainSetNumaParametersArgs is libvirt's remote_domain_set_numa_parameters_args
type DomainSetNumaParametersArgs struct {
	Dom Domain
	Params []TypedParam
	Flags uint32
}

// DomainGetNumaParametersArgs is libvirt's remote_domain_get_numa_parameters_args
type DomainGetNumaParametersArgs struct {
	Dom Domain
	Nparams int32
	Flags uint32
}

// DomainGetNumaParametersRet is libvirt's remote_domain_get_numa_parameters_ret
type DomainGetNumaParametersRet struct {
	Params []TypedParam
	Nparams int32
}

// DomainSetPerfEventsArgs is libvirt's remote_domain_set_perf_events_args
type DomainSetPerfEventsArgs struct {
	Dom Domain
	Params []TypedParam
	Flags DomainModificationImpact
}

// DomainGetPerfEventsArgs is libvirt's remote_domain_get_perf_events_args
type DomainGetPerfEventsArgs struct {
	Dom Domain
	Flags DomainModificationImpact
}

// DomainGetPerfEventsRet is libvirt's remote_domain_get_perf_events_ret
type DomainGetPerfEventsRet struct {
	Params []TypedParam
}

// DomainBlockStatsArgs is libvirt's remote_domain_block_stats_args
type DomainBlockStatsArgs struct {
	Dom Domain
	Path string
}

// DomainBlockStatsRet is libvirt's remote_domain_block_stats_ret
type DomainBlockStatsRet struct {
	RdReq int64
	RdBytes int64
	WrReq int64
	WrBytes int64
	Errs int64
}

// DomainBlockStatsFlagsArgs is libvirt's remote_domain_block_stats_flags_args
type DomainBlockStatsFlagsArgs struct {
	Dom Domain
	Path string
	Nparams int32
	Flags uint32
}

// DomainBlockStatsFlagsRet is libvirt's remote_domain_block_stats_flags_ret
type DomainBlockStatsFlagsRet struct {
	Params []TypedParam
	Nparams int32
}

// DomainInterfaceStatsArgs is libvirt's remote_domain_interface_stats_args
type DomainInterfaceStatsArgs struct {
	Dom Domain
	Device string
}

// DomainInterfaceStatsRet is libvirt's remote_domain_interface_stats_ret
type DomainInterfaceStatsRet struct {
	RxBytes int64
	RxPackets int64
	RxErrs int64
	RxDrop int64
	TxBytes int64
	TxPackets int64
	TxErrs int64
	TxDrop int64
}

// DomainSetInterfaceParametersArgs is libvirt's remote_domain_set_interface_parameters_args
type DomainSetInterfaceParametersArgs struct {
	Dom Domain
	Device string
	Params []TypedParam
	Flags uint32
}

// DomainGetInterfaceParametersArgs is libvirt's remote_domain_get_interface_parameters_args
type DomainGetInterfaceParametersArgs struct {
	Dom Domain
	Device string
	Nparams int32
	Flags DomainModificationImpact
}

// DomainGetInterfaceParametersRet is libvirt's remote_domain_get_interface_parameters_ret
type DomainGetInterfaceParametersRet struct {
	Params []TypedParam
	Nparams int32
}

// DomainMemoryStatsArgs is libvirt's remote_domain_memory_stats_args
type DomainMemoryStatsArgs struct {
	Dom Domain
	MaxStats uint32
	Flags uint32
}

// DomainMemoryStat is libvirt's remote_domain_memory_stat
type DomainMemoryStat struct {
	Tag int32
	Val uint64
}

// DomainMemoryStatsRet is libvirt's remote_domain_memory_stats_ret
type DomainMemoryStatsRet struct {
	Stats []DomainMemoryStat
}

// DomainBlockPeekArgs is libvirt's remote_domain_block_peek_args
type DomainBlockPeekArgs struct {
	Dom Domain
	Path string
	Offset uint64
	Size uint32
	Flags uint32
}

// DomainBlockPeekRet is libvirt's remote_domain_block_peek_ret
type DomainBlockPeekRet struct {
	Buffer []byte
}

// DomainMemoryPeekArgs is libvirt's remote_domain_memory_peek_args
type DomainMemoryPeekArgs struct {
	Dom Domain
	Offset uint64
	Size uint32
	Flags DomainMemoryFlags
}

// DomainMemoryPeekRet is libvirt's remote_domain_memory_peek_ret
type DomainMemoryPeekRet struct {
	Buffer []byte
}

// DomainGetBlockInfoArgs is libvirt's remote_domain_get_block_info_args
type DomainGetBlockInfoArgs struct {
	Dom Domain
	Path string
	Flags uint32
}

// DomainGetBlockInfoRet is libvirt's remote_domain_get_block_info_ret
type DomainGetBlockInfoRet struct {
	Allocation uint64
	Capacity uint64
	Physical uint64
}

// ConnectListDomainsArgs is libvirt's remote_connect_list_domains_args
type ConnectListDomainsArgs struct {
	Maxids int32
}

// ConnectListDomainsRet is libvirt's remote_connect_list_domains_ret
type ConnectListDomainsRet struct {
	Ids []int32
}

// ConnectNumOfDomainsRet is libvirt's remote_connect_num_of_domains_ret
type ConnectNumOfDomainsRet struct {
	Num int32
}

// DomainCreateXMLArgs is libvirt's remote_domain_create_xml_args
type DomainCreateXMLArgs struct {
	XMLDesc string
	Flags DomainCreateFlags
}

// DomainCreateXMLRet is libvirt's remote_domain_create_xml_ret
type DomainCreateXMLRet struct {
	Dom Domain
}

// DomainCreateXMLWithFilesArgs is libvirt's remote_domain_create_xml_with_files_args
type DomainCreateXMLWithFilesArgs struct {
	XMLDesc string
	Flags DomainCreateFlags
}

// DomainCreateXMLWithFilesRet is libvirt's remote_domain_create_xml_with_files_ret
type DomainCreateXMLWithFilesRet struct {
	Dom Domain
}

// DomainLookupByIDArgs is libvirt's remote_domain_lookup_by_id_args
type DomainLookupByIDArgs struct {
	ID int32
}

// DomainLookupByIDRet is libvirt's remote_domain_lookup_by_id_ret
type DomainLookupByIDRet struct {
	Dom Domain
}

// DomainLookupByUUIDArgs is libvirt's remote_domain_lookup_by_uuid_args
type DomainLookupByUUIDArgs struct {
	UUID UUID
}

// DomainLookupByUUIDRet is libvirt's remote_domain_lookup_by_uuid_ret
type DomainLookupByUUIDRet struct {
	Dom Domain
}

// DomainLookupByNameArgs is libvirt's remote_domain_lookup_by_name_args
type DomainLookupByNameArgs struct {
	Name string
}

// DomainLookupByNameRet is libvirt's remote_domain_lookup_by_name_ret
type DomainLookupByNameRet struct {
	Dom Domain
}

// DomainSuspendArgs is libvirt's remote_domain_suspend_args
type DomainSuspendArgs struct {
	Dom Domain
}

// DomainResumeArgs is libvirt's remote_domain_resume_args
type DomainResumeArgs struct {
	Dom Domain
}

// DomainPmSuspendForDurationArgs is libvirt's remote_domain_pm_suspend_for_duration_args
type DomainPmSuspendForDurationArgs struct {
	Dom Domain
	Target uint32
	Duration uint64
	Flags uint32
}

// DomainPmWakeupArgs is libvirt's remote_domain_pm_wakeup_args
type DomainPmWakeupArgs struct {
	Dom Domain
	Flags uint32
}

// DomainShutdownArgs is libvirt's remote_domain_shutdown_args
type DomainShutdownArgs struct {
	Dom Domain
}

// DomainRebootArgs is libvirt's remote_domain_reboot_args
type DomainRebootArgs struct {
	Dom Domain
	Flags DomainRebootFlagValues
}

// DomainResetArgs is libvirt's remote_domain_reset_args
type DomainResetArgs struct {
	Dom Domain
	Flags uint32
}

// DomainDestroyArgs is libvirt's remote_domain_destroy_args
type DomainDestroyArgs struct {
	Dom Domain
}

// DomainDestroyFlagsArgs is libvirt's remote_domain_destroy_flags_args
type DomainDestroyFlagsArgs struct {
	Dom Domain
	Flags DomainDestroyFlagsValues
}

// DomainGetOsTypeArgs is libvirt's remote_domain_get_os_type_args
type DomainGetOsTypeArgs struct {
	Dom Domain
}

// DomainGetOsTypeRet is libvirt's remote_domain_get_os_type_ret
type DomainGetOsTypeRet struct {
	Type string
}

// DomainGetMaxMemoryArgs is libvirt's remote_domain_get_max_memory_args
type DomainGetMaxMemoryArgs struct {
	Dom Domain
}

// DomainGetMaxMemoryRet is libvirt's remote_domain_get_max_memory_ret
type DomainGetMaxMemoryRet struct {
	Memory uint64
}

// DomainSetMaxMemoryArgs is libvirt's remote_domain_set_max_memory_args
type DomainSetMaxMemoryArgs struct {
	Dom Domain
	Memory uint64
}

// DomainSetMemoryArgs is libvirt's remote_domain_set_memory_args
type DomainSetMemoryArgs struct {
	Dom Domain
	Memory uint64
}

// DomainSetMemoryFlagsArgs is libvirt's remote_domain_set_memory_flags_args
type DomainSetMemoryFlagsArgs struct {
	Dom Domain
	Memory uint64
	Flags uint32
}

// DomainSetMemoryStatsPeriodArgs is libvirt's remote_domain_set_memory_stats_period_args
type DomainSetMemoryStatsPeriodArgs struct {
	Dom Domain
	Period int32
	Flags DomainMemoryModFlags
}

// DomainGetInfoArgs is libvirt's remote_domain_get_info_args
type DomainGetInfoArgs struct {
	Dom Domain
}

// DomainGetInfoRet is libvirt's remote_domain_get_info_ret
type DomainGetInfoRet struct {
	State uint8
	MaxMem uint64
	Memory uint64
	NrVirtCPU uint16
	CPUTime uint64
}

// DomainSaveArgs is libvirt's remote_domain_save_args
type DomainSaveArgs struct {
	Dom Domain
	To string
}

// DomainSaveFlagsArgs is libvirt's remote_domain_save_flags_args
type DomainSaveFlagsArgs struct {
	Dom Domain
	To string
	Dxml OptString
	Flags uint32
}

// DomainRestoreArgs is libvirt's remote_domain_restore_args
type DomainRestoreArgs struct {
	From string
}

// DomainRestoreFlagsArgs is libvirt's remote_domain_restore_flags_args
type DomainRestoreFlagsArgs struct {
	From string
	Dxml OptString
	Flags uint32
}

// DomainSaveImageGetXMLDescArgs is libvirt's remote_domain_save_image_get_xml_desc_args
type DomainSaveImageGetXMLDescArgs struct {
	File string
	Flags uint32
}

// DomainSaveImageGetXMLDescRet is libvirt's remote_domain_save_image_get_xml_desc_ret
type DomainSaveImageGetXMLDescRet struct {
	XML string
}

// DomainSaveImageDefineXMLArgs is libvirt's remote_domain_save_image_define_xml_args
type DomainSaveImageDefineXMLArgs struct {
	File string
	Dxml string
	Flags uint32
}

// DomainCoreDumpArgs is libvirt's remote_domain_core_dump_args
type DomainCoreDumpArgs struct {
	Dom Domain
	To string
	Flags DomainCoreDumpFlags
}

// DomainCoreDumpWithFormatArgs is libvirt's remote_domain_core_dump_with_format_args
type DomainCoreDumpWithFormatArgs struct {
	Dom Domain
	To string
	Dumpformat uint32
	Flags DomainCoreDumpFlags
}

// DomainScreenshotArgs is libvirt's remote_domain_screenshot_args
type DomainScreenshotArgs struct {
	Dom Domain
	Screen uint32
	Flags uint32
}

// DomainScreenshotRet is libvirt's remote_domain_screenshot_ret
type DomainScreenshotRet struct {
	Mime OptString
}

// DomainGetXMLDescArgs is libvirt's remote_domain_get_xml_desc_args
type DomainGetXMLDescArgs struct {
	Dom Domain
	Flags DomainXMLFlags
}

// DomainGetXMLDescRet is libvirt's remote_domain_get_xml_desc_ret
type DomainGetXMLDescRet struct {
	XML string
}

// DomainMigratePrepareArgs is libvirt's remote_domain_migrate_prepare_args
type DomainMigratePrepareArgs struct {
	UriIn OptString
	Flags uint64
	Dname OptString
	Resource uint64
}

// DomainMigratePrepareRet is libvirt's remote_domain_migrate_prepare_ret
type DomainMigratePrepareRet struct {
	Cookie []byte
	UriOut OptString
}

// DomainMigratePerformArgs is libvirt's remote_domain_migrate_perform_args
type DomainMigratePerformArgs struct {
	Dom Domain
	Cookie []byte
	Uri string
	Flags uint64
	Dname OptString
	Resource uint64
}

// DomainMigrateFinishArgs is libvirt's remote_domain_migrate_finish_args
type DomainMigrateFinishArgs struct {
	Dname string
	Cookie []byte
	Uri string
	Flags uint64
}

// DomainMigrateFinishRet is libvirt's remote_domain_migrate_finish_ret
type DomainMigrateFinishRet struct {
	Ddom Domain
}

// DomainMigratePrepare2Args is libvirt's remote_domain_migrate_prepare2_args
type DomainMigratePrepare2Args struct {
	UriIn OptString
	Flags uint64
	Dname OptString
	Resource uint64
	DomXML string
}

// DomainMigratePrepare2Ret is libvirt's remote_domain_migrate_prepare2_ret
type DomainMigratePrepare2Ret struct {
	Cookie []byte
	UriOut OptString
}

// DomainMigrateFinish2Args is libvirt's remote_domain_migrate_finish2_args
type DomainMigrateFinish2Args struct {
	Dname string
	Cookie []byte
	Uri string
	Flags uint64
	Retcode int32
}

// DomainMigrateFinish2Ret is libvirt's remote_domain_migrate_finish2_ret
type DomainMigrateFinish2Ret struct {
	Ddom Domain
}

// ConnectListDefinedDomainsArgs is libvirt's remote_connect_list_defined_domains_args
type ConnectListDefinedDomainsArgs struct {
	Maxnames int32
}

// ConnectListDefinedDomainsRet is libvirt's remote_connect_list_defined_domains_ret
type ConnectListDefinedDomainsRet struct {
	Names []string
}

// ConnectNumOfDefinedDomainsRet is libvirt's remote_connect_num_of_defined_domains_ret
type ConnectNumOfDefinedDomainsRet struct {
	Num int32
}

// DomainCreateArgs is libvirt's remote_domain_create_args
type DomainCreateArgs struct {
	Dom Domain
}

// DomainCreateWithFlagsArgs is libvirt's remote_domain_create_with_flags_args
type DomainCreateWithFlagsArgs struct {
	Dom Domain
	Flags uint32
}

// DomainCreateWithFlagsRet is libvirt's remote_domain_create_with_flags_ret
type DomainCreateWithFlagsRet struct {
	Dom Domain
}

// DomainCreateWithFilesArgs is libvirt's remote_domain_create_with_files_args
type DomainCreateWithFilesArgs struct {
	Dom Domain
	Flags DomainCreateFlags
}

// DomainCreateWithFilesRet is libvirt's remote_domain_create_with_files_ret
type DomainCreateWithFilesRet struct {
	Dom Domain
}

// DomainDefineXMLArgs is libvirt's remote_domain_define_xml_args
type DomainDefineXMLArgs struct {
	XML string
}

// DomainDefineXMLRet is libvirt's remote_domain_define_xml_ret
type DomainDefineXMLRet struct {
	Dom Domain
}

// DomainDefineXMLFlagsArgs is libvirt's remote_domain_define_xml_flags_args
type DomainDefineXMLFlagsArgs struct {
	XML string
	Flags DomainDefineFlags
}

// DomainDefineXMLFlagsRet is libvirt's remote_domain_define_xml_flags_ret
type DomainDefineXMLFlagsRet struct {
	Dom Domain
}

// DomainUndefineArgs is libvirt's remote_domain_undefine_args
type DomainUndefineArgs struct {
	Dom Domain
}

// DomainUndefineFlagsArgs is libvirt's remote_domain_undefine_flags_args
type DomainUndefineFlagsArgs struct {
	Dom Domain
	Flags DomainUndefineFlagsValues
}

// DomainInjectNmiArgs is libvirt's remote_domain_inject_nmi_args
type DomainInjectNmiArgs struct {
	Dom Domain
	Flags uint32
}

// DomainSendKeyArgs is libvirt's remote_domain_send_key_args
type DomainSendKeyArgs struct {
	Dom Domain
	Codeset uint32
	Holdtime uint32
	Keycodes []uint32
	Flags uint32
}

// DomainSendProcessSignalArgs is libvirt's remote_domain_send_process_signal_args
type DomainSendProcessSignalArgs struct {
	Dom Domain
	PidValue int64
	Signum uint32
	Flags uint32
}

// DomainSetVcpusArgs is libvirt's remote_domain_set_vcpus_args
type DomainSetVcpusArgs struct {
	Dom Domain
	Nvcpus uint32
}

// DomainSetVcpusFlagsArgs is libvirt's remote_domain_set_vcpus_flags_args
type DomainSetVcpusFlagsArgs struct {
	Dom Domain
	Nvcpus uint32
	Flags uint32
}

// DomainGetVcpusFlagsArgs is libvirt's remote_domain_get_vcpus_flags_args
type DomainGetVcpusFlagsArgs struct {
	Dom Domain
	Flags uint32
}

// DomainGetVcpusFlagsRet is libvirt's remote_domain_get_vcpus_flags_ret
type DomainGetVcpusFlagsRet struct {
	Num int32
}

// DomainPinVcpuArgs is libvirt's remote_domain_pin_vcpu_args
type DomainPinVcpuArgs struct {
	Dom Domain
	Vcpu uint32
	Cpumap []byte
}

// DomainPinVcpuFlagsArgs is libvirt's remote_domain_pin_vcpu_flags_args
type DomainPinVcpuFlagsArgs struct {
	Dom Domain
	Vcpu uint32
	Cpumap []byte
	Flags uint32
}

// DomainGetVcpuPinInfoArgs is libvirt's remote_domain_get_vcpu_pin_info_args
type DomainGetVcpuPinInfoArgs struct {
	Dom Domain
	Ncpumaps int32
	Maplen int32
	Flags uint32
}

// DomainGetVcpuPinInfoRet is libvirt's remote_domain_get_vcpu_pin_info_ret
type DomainGetVcpuPinInfoRet struct {
	Cpumaps []byte
	Num int32
}

// DomainPinEmulatorArgs is libvirt's remote_domain_pin_emulator_args
type DomainPinEmulatorArgs struct {
	Dom Domain
	Cpumap []byte
	Flags DomainModificationImpact
}

// DomainGetEmulatorPinInfoArgs is libvirt's remote_domain_get_emulator_pin_info_args
type DomainGetEmulatorPinInfoArgs struct {
	Dom Domain
	Maplen int32
	Flags DomainModificationImpact
}

// DomainGetEmulatorPinInfoRet is libvirt's remote_domain_get_emulator_pin_info_ret
type DomainGetEmulatorPinInfoRet struct {
	Cpumaps []byte
	Ret int32
}

// DomainGetVcpusArgs is libvirt's remote_domain_get_vcpus_args
type DomainGetVcpusArgs struct {
	Dom Domain
	Maxinfo int32
	Maplen int32
}

// DomainGetVcpusRet is libvirt's remote_domain_get_vcpus_ret
type DomainGetVcpusRet struct {
	Info []VcpuInfo
	Cpumaps []byte
}

// DomainGetMaxVcpusArgs is libvirt's remote_domain_get_max_vcpus_args
type DomainGetMaxVcpusArgs struct {
	Dom Domain
}

// DomainGetMaxVcpusRet is libvirt's remote_domain_get_max_vcpus_ret
type DomainGetMaxVcpusRet struct {
	Num int32
}

// DomainIothreadInfo is libvirt's remote_domain_iothread_info
type DomainIothreadInfo struct {
	IothreadID uint32
	Cpumap []byte
}

// DomainGetIothreadInfoArgs is libvirt's remote_domain_get_iothread_info_args
type DomainGetIothreadInfoArgs struct {
	Dom Domain
	Flags DomainModificationImpact
}

// DomainGetIothreadInfoRet is libvirt's remote_domain_get_iothread_info_ret
type DomainGetIothreadInfoRet struct {
	Info []DomainIothreadInfo
	Ret uint32
}

// DomainPinIothreadArgs is libvirt's remote_domain_pin_iothread_args
type DomainPinIothreadArgs struct {
	Dom Domain
	IothreadsID uint32
	Cpumap []byte
	Flags DomainModificationImpact
}

// DomainAddIothreadArgs is libvirt's remote_domain_add_iothread_args
type DomainAddIothreadArgs struct {
	Dom Domain
	IothreadID uint32
	Flags DomainModificationImpact
}

// DomainDelIothreadArgs is libvirt's remote_domain_del_iothread_args
type DomainDelIothreadArgs struct {
	Dom Domain
	IothreadID uint32
	Flags DomainModificationImpact
}

// DomainSetIothreadParamsArgs is libvirt's remote_domain_set_iothread_params_args
type DomainSetIothreadParamsArgs struct {
	Dom Domain
	IothreadID uint32
	Params []TypedParam
	Flags uint32
}

// DomainGetSecurityLabelArgs is libvirt's remote_domain_get_security_label_args
type DomainGetSecurityLabelArgs struct {
	Dom Domain
}

// DomainGetSecurityLabelRet is libvirt's remote_domain_get_security_label_ret
type DomainGetSecurityLabelRet struct {
	Label []int8
	Enforcing int32
}

// DomainGetSecurityLabelListArgs is libvirt's remote_domain_get_security_label_list_args
type DomainGetSecurityLabelListArgs struct {
	Dom Domain
}

// DomainGetSecurityLabelListRet is libvirt's remote_domain_get_security_label_list_ret
type DomainGetSecurityLabelListRet struct {
	Labels []DomainGetSecurityLabelRet
	Ret int32
}

// NodeGetSecurityModelRet is libvirt's remote_node_get_security_model_ret
type NodeGetSecurityModelRet struct {
	Model []int8
	Doi []int8
}

// DomainAttachDeviceArgs is libvirt's remote_domain_attach_device_args
type DomainAttachDeviceArgs struct {
	Dom Domain
	XML string
}

// DomainAttachDeviceFlagsArgs is libvirt's remote_domain_attach_device_flags_args
type DomainAttachDeviceFlagsArgs struct {
	Dom Domain
	XML string
	Flags uint32
}

// DomainDetachDeviceArgs is libvirt's remote_domain_detach_device_args
type DomainDetachDeviceArgs struct {
	Dom Domain
	XML string
}

// DomainDetachDeviceFlagsArgs is libvirt's remote_domain_detach_device_flags_args
type DomainDetachDeviceFlagsArgs struct {
	Dom Domain
	XML string
	Flags uint32
}

// DomainUpdateDeviceFlagsArgs is libvirt's remote_domain_update_device_flags_args
type DomainUpdateDeviceFlagsArgs struct {
	Dom Domain
	XML string
	Flags DomainDeviceModifyFlags
}

// DomainDetachDeviceAliasArgs is libvirt's remote_domain_detach_device_alias_args
type DomainDetachDeviceAliasArgs struct {
	Dom Domain
	Alias string
	Flags uint32
}

// DomainGetAutostartArgs is libvirt's remote_domain_get_autostart_args
type DomainGetAutostartArgs struct {
	Dom Domain
}

// DomainGetAutostartRet is libvirt's remote_domain_get_autostart_ret
type DomainGetAutostartRet struct {
	Autostart int32
}

// DomainSetAutostartArgs is libvirt's remote_domain_set_autostart_args
type DomainSetAutostartArgs struct {
	Dom Domain
	Autostart int32
}

// DomainSetMetadataArgs is libvirt's remote_domain_set_metadata_args
type DomainSetMetadataArgs struct {
	Dom Domain
	Type int32
	Metadata OptString
	Key OptString
	Uri OptString
	Flags DomainModificationImpact
}

// DomainGetMetadataArgs is libvirt's remote_domain_get_metadata_args
type DomainGetMetadataArgs struct {
	Dom Domain
	Type int32
	Uri OptString
	Flags DomainModificationImpact
}

// DomainGetMetadataRet is libvirt's remote_domain_get_metadata_ret
type DomainGetMetadataRet struct {
	Metadata string
}

// DomainBlockJobAbortArgs is libvirt's remote_domain_block_job_abort_args
type DomainBlockJobAbortArgs struct {
	Dom Domain
	Path string
	Flags DomainBlockJobAbortFlags
}

// DomainGetBlockJobInfoArgs is libvirt's remote_domain_get_block_job_info_args
type DomainGetBlockJobInfoArgs struct {
	Dom Domain
	Path string
	Flags uint32
}

// DomainGetBlockJobInfoRet is libvirt's remote_domain_get_block_job_info_ret
type DomainGetBlockJobInfoRet struct {
	Found int32
	Type int32
	Bandwidth uint64
	Cur uint64
	End uint64
}

// DomainBlockJobSetSpeedArgs is libvirt's remote_domain_block_job_set_speed_args
type DomainBlockJobSetSpeedArgs struct {
	Dom Domain
	Path string
	Bandwidth uint64
	Flags DomainBlockJobSetSpeedFlags
}

// DomainBlockPullArgs is libvirt's remote_domain_block_pull_args
type DomainBlockPullArgs struct {
	Dom Domain
	Path string
	Bandwidth uint64
	Flags DomainBlockPullFlags
}

// DomainBlockRebaseArgs is libvirt's remote_domain_block_rebase_args
type DomainBlockRebaseArgs struct {
	Dom Domain
	Path string
	Base OptString
	Bandwidth uint64
	Flags DomainBlockRebaseFlags
}

// DomainBlockCopyArgs is libvirt's remote_domain_block_copy_args
type DomainBlockCopyArgs struct {
	Dom Domain
	Path string
	Destxml string
	Params []TypedParam
	Flags DomainBlockCopyFlags
}

// DomainBlockCommitArgs is libvirt's remote_domain_block_commit_args
type DomainBlockCommitArgs struct {
	Dom Domain
	Disk string
	Base OptString
	Top OptString
	Bandwidth uint64
	Flags DomainBlockCommitFlags
}

// DomainSetBlockIOTuneArgs is libvirt's remote_domain_set_block_io_tune_args
type DomainSetBlockIOTuneArgs struct {
	Dom Domain
	Disk string
	Params []TypedParam
	Flags uint32
}

// DomainGetBlockIOTuneArgs is libvirt's remote_domain_get_block_io_tune_args
type DomainGetBlockIOTuneArgs struct {
	Dom Domain
	Disk OptString
	Nparams int32
	Flags uint32
}

// DomainGetBlockIOTuneRet is libvirt's remote_domain_get_block_io_tune_ret
type DomainGetBlockIOTuneRet struct {
	Params []TypedParam
	Nparams int32
}

// DomainGetCPUStatsArgs is libvirt's remote_domain_get_cpu_stats_args
type DomainGetCPUStatsArgs struct {
	Dom Domain
	Nparams uint32
	StartCPU int32
	Ncpus uint32
	Flags TypedParameterFlags
}

// DomainGetCPUStatsRet is libvirt's remote_domain_get_cpu_stats_ret
type DomainGetCPUStatsRet struct {
	Params []TypedParam
	Nparams int32
}

// DomainGetHostnameArgs is libvirt's remote_domain_get_hostname_args
type DomainGetHostnameArgs struct {
	Dom Domain
	Flags uint32
}

// DomainGetHostnameRet is libvirt's remote_domain_get_hostname_ret
type DomainGetHostnameRet struct {
	Hostname string
}

// ConnectNumOfNetworksRet is libvirt's remote_connect_num_of_networks_ret
type ConnectNumOfNetworksRet struct {
	Num int32
}

// ConnectListNetworksArgs is libvirt's remote_connect_list_networks_args
type ConnectListNetworksArgs struct {
	Maxnames int32
}

// ConnectListNetworksRet is libvirt's remote_connect_list_networks_ret
type ConnectListNetworksRet struct {
	Names []string
}

// ConnectNumOfDefinedNetworksRet is libvirt's remote_connect_num_of_defined_networks_ret
type ConnectNumOfDefinedNetworksRet struct {
	Num int32
}

// ConnectListDefinedNetworksArgs is libvirt's remote_connect_list_defined_networks_args
type ConnectListDefinedNetworksArgs struct {
	Maxnames int32
}

// ConnectListDefinedNetworksRet is libvirt's remote_connect_list_defined_networks_ret
type ConnectListDefinedNetworksRet struct {
	Names []string
}

// NetworkLookupByUUIDArgs is libvirt's remote_network_lookup_by_uuid_args
type NetworkLookupByUUIDArgs struct {
	UUID UUID
}

// NetworkLookupByUUIDRet is libvirt's remote_network_lookup_by_uuid_ret
type NetworkLookupByUUIDRet struct {
	Net Network
}

// NetworkLookupByNameArgs is libvirt's remote_network_lookup_by_name_args
type NetworkLookupByNameArgs struct {
	Name string
}

// NetworkLookupByNameRet is libvirt's remote_network_lookup_by_name_ret
type NetworkLookupByNameRet struct {
	Net Network
}

// NetworkCreateXMLArgs is libvirt's remote_network_create_xml_args
type NetworkCreateXMLArgs struct {
	XML string
}

// NetworkCreateXMLRet is libvirt's remote_network_create_xml_ret
type NetworkCreateXMLRet struct {
	Net Network
}

// NetworkDefineXMLArgs is libvirt's remote_network_define_xml_args
type NetworkDefineXMLArgs struct {
	XML string
}

// NetworkDefineXMLRet is libvirt's remote_network_define_xml_ret
type NetworkDefineXMLRet struct {
	Net Network
}

// NetworkUndefineArgs is libvirt's remote_network_undefine_args
type NetworkUndefineArgs struct {
	Net Network
}

// NetworkUpdateArgs is libvirt's remote_network_update_args
type NetworkUpdateArgs struct {
	Net Network
	Command uint32
	Section uint32
	ParentIndex int32
	XML string
	Flags NetworkUpdateFlags
}

// NetworkCreateArgs is libvirt's remote_network_create_args
type NetworkCreateArgs struct {
	Net Network
}

// NetworkDestroyArgs is libvirt's remote_network_destroy_args
type NetworkDestroyArgs struct {
	Net Network
}

// NetworkGetXMLDescArgs is libvirt's remote_network_get_xml_desc_args
type NetworkGetXMLDescArgs struct {
	Net Network
	Flags uint32
}

// NetworkGetXMLDescRet is libvirt's remote_network_get_xml_desc_ret
type NetworkGetXMLDescRet struct {
	XML string
}

// NetworkGetBridgeNameArgs is libvirt's remote_network_get_bridge_name_args
type NetworkGetBridgeNameArgs struct {
	Net Network
}

// NetworkGetBridgeNameRet is libvirt's remote_network_get_bridge_name_ret
type NetworkGetBridgeNameRet struct {
	Name string
}

// NetworkGetAutostartArgs is libvirt's remote_network_get_autostart_args
type NetworkGetAutostartArgs struct {
	Net Network
}

// NetworkGetAutostartRet is libvirt's remote_network_get_autostart_ret
type NetworkGetAutostartRet struct {
	Autostart int32
}

// NetworkSetAutostartArgs is libvirt's remote_network_set_autostart_args
type NetworkSetAutostartArgs struct {
	Net Network
	Autostart int32
}

// ConnectNumOfNwfiltersRet is libvirt's remote_connect_num_of_nwfilters_ret
type ConnectNumOfNwfiltersRet struct {
	Num int32
}

// ConnectListNwfiltersArgs is libvirt's remote_connect_list_nwfilters_args
type ConnectListNwfiltersArgs struct {
	Maxnames int32
}

// ConnectListNwfiltersRet is libvirt's remote_connect_list_nwfilters_ret
type ConnectListNwfiltersRet struct {
	Names []string
}

// NwfilterLookupByUUIDArgs is libvirt's remote_nwfilter_lookup_by_uuid_args
type NwfilterLookupByUUIDArgs struct {
	UUID UUID
}

// NwfilterLookupByUUIDRet is libvirt's remote_nwfilter_lookup_by_uuid_ret
type NwfilterLookupByUUIDRet struct {
	OptNwfilter Nwfilter
}

// NwfilterLookupByNameArgs is libvirt's remote_nwfilter_lookup_by_name_args
type NwfilterLookupByNameArgs struct {
	Name string
}

// NwfilterLookupByNameRet is libvirt's remote_nwfilter_lookup_by_name_ret
type NwfilterLookupByNameRet struct {
	OptNwfilter Nwfilter
}

// NwfilterDefineXMLArgs is libvirt's remote_nwfilter_define_xml_args
type NwfilterDefineXMLArgs struct {
	XML string
}

// NwfilterDefineXMLRet is libvirt's remote_nwfilter_define_xml_ret
type NwfilterDefineXMLRet struct {
	OptNwfilter Nwfilter
}

// NwfilterUndefineArgs is libvirt's remote_nwfilter_undefine_args
type NwfilterUndefineArgs struct {
	OptNwfilter Nwfilter
}

// NwfilterGetXMLDescArgs is libvirt's remote_nwfilter_get_xml_desc_args
type NwfilterGetXMLDescArgs struct {
	OptNwfilter Nwfilter
	Flags uint32
}

// NwfilterGetXMLDescRet is libvirt's remote_nwfilter_get_xml_desc_ret
type NwfilterGetXMLDescRet struct {
	XML string
}

// ConnectNumOfInterfacesRet is libvirt's remote_connect_num_of_interfaces_ret
type ConnectNumOfInterfacesRet struct {
	Num int32
}

// ConnectListInterfacesArgs is libvirt's remote_connect_list_interfaces_args
type ConnectListInterfacesArgs struct {
	Maxnames int32
}

// ConnectListInterfacesRet is libvirt's remote_connect_list_interfaces_ret
type ConnectListInterfacesRet struct {
	Names []string
}

// ConnectNumOfDefinedInterfacesRet is libvirt's remote_connect_num_of_defined_interfaces_ret
type ConnectNumOfDefinedInterfacesRet struct {
	Num int32
}

// ConnectListDefinedInterfacesArgs is libvirt's remote_connect_list_defined_interfaces_args
type ConnectListDefinedInterfacesArgs struct {
	Maxnames int32
}

// ConnectListDefinedInterfacesRet is libvirt's remote_connect_list_defined_interfaces_ret
type ConnectListDefinedInterfacesRet struct {
	Names []string
}

// InterfaceLookupByNameArgs is libvirt's remote_interface_lookup_by_name_args
type InterfaceLookupByNameArgs struct {
	Name string
}

// InterfaceLookupByNameRet is libvirt's remote_interface_lookup_by_name_ret
type InterfaceLookupByNameRet struct {
	Iface Interface
}

// InterfaceLookupByMacStringArgs is libvirt's remote_interface_lookup_by_mac_string_args
type InterfaceLookupByMacStringArgs struct {
	Mac string
}

// InterfaceLookupByMacStringRet is libvirt's remote_interface_lookup_by_mac_string_ret
type InterfaceLookupByMacStringRet struct {
	Iface Interface
}

// InterfaceGetXMLDescArgs is libvirt's remote_interface_get_xml_desc_args
type InterfaceGetXMLDescArgs struct {
	Iface Interface
	Flags uint32
}

// InterfaceGetXMLDescRet is libvirt's remote_interface_get_xml_desc_ret
type InterfaceGetXMLDescRet struct {
	XML string
}

// InterfaceDefineXMLArgs is libvirt's remote_interface_define_xml_args
type InterfaceDefineXMLArgs struct {
	XML string
	Flags uint32
}

// InterfaceDefineXMLRet is libvirt's remote_interface_define_xml_ret
type InterfaceDefineXMLRet struct {
	Iface Interface
}

// InterfaceUndefineArgs is libvirt's remote_interface_undefine_args
type InterfaceUndefineArgs struct {
	Iface Interface
}

// InterfaceCreateArgs is libvirt's remote_interface_create_args
type InterfaceCreateArgs struct {
	Iface Interface
	Flags uint32
}

// InterfaceDestroyArgs is libvirt's remote_interface_destroy_args
type InterfaceDestroyArgs struct {
	Iface Interface
	Flags uint32
}

// InterfaceChangeBeginArgs is libvirt's remote_interface_change_begin_args
type InterfaceChangeBeginArgs struct {
	Flags uint32
}

// InterfaceChangeCommitArgs is libvirt's remote_interface_change_commit_args
type InterfaceChangeCommitArgs struct {
	Flags uint32
}

// InterfaceChangeRollbackArgs is libvirt's remote_interface_change_rollback_args
type InterfaceChangeRollbackArgs struct {
	Flags uint32
}

// AuthListRet is libvirt's remote_auth_list_ret
type AuthListRet struct {
	Types []AuthType
}

// AuthSaslInitRet is libvirt's remote_auth_sasl_init_ret
type AuthSaslInitRet struct {
	Mechlist string
}

// AuthSaslStartArgs is libvirt's remote_auth_sasl_start_args
type AuthSaslStartArgs struct {
	Mech string
	Nil int32
	Data []int8
}

// AuthSaslStartRet is libvirt's remote_auth_sasl_start_ret
type AuthSaslStartRet struct {
	Complete int32
	Nil int32
	Data []int8
}

// AuthSaslStepArgs is libvirt's remote_auth_sasl_step_args
type AuthSaslStepArgs struct {
	Nil int32
	Data []int8
}

// AuthSaslStepRet is libvirt's remote_auth_sasl_step_ret
type AuthSaslStepRet struct {
	Complete int32
	Nil int32
	Data []int8
}

// AuthPolkitRet is libvirt's remote_auth_polkit_ret
type AuthPolkitRet struct {
	Complete int32
}

// ConnectNumOfStoragePoolsRet is libvirt's remote_connect_num_of_storage_pools_ret
type ConnectNumOfStoragePoolsRet struct {
	Num int32
}

// ConnectListStoragePoolsArgs is libvirt's remote_connect_list_storage_pools_args
type ConnectListStoragePoolsArgs struct {
	Maxnames int32
}

// ConnectListStoragePoolsRet is libvirt's remote_connect_list_storage_pools_ret
type ConnectListStoragePoolsRet struct {
	Names []string
}

// ConnectNumOfDefinedStoragePoolsRet is libvirt's remote_connect_num_of_defined_storage_pools_ret
type ConnectNumOfDefinedStoragePoolsRet struct {
	Num int32
}

// ConnectListDefinedStoragePoolsArgs is libvirt's remote_connect_list_defined_storage_pools_args
type ConnectListDefinedStoragePoolsArgs struct {
	Maxnames int32
}

// ConnectListDefinedStoragePoolsRet is libvirt's remote_connect_list_defined_storage_pools_ret
type ConnectListDefinedStoragePoolsRet struct {
	Names []string
}

// ConnectFindStoragePoolSourcesArgs is libvirt's remote_connect_find_storage_pool_sources_args
type ConnectFindStoragePoolSourcesArgs struct {
	Type string
	SrcSpec OptString
	Flags uint32
}

// ConnectFindStoragePoolSourcesRet is libvirt's remote_connect_find_storage_pool_sources_ret
type ConnectFindStoragePoolSourcesRet struct {
	XML string
}

// StoragePoolLookupByUUIDArgs is libvirt's remote_storage_pool_lookup_by_uuid_args
type StoragePoolLookupByUUIDArgs struct {
	UUID UUID
}

// StoragePoolLookupByUUIDRet is libvirt's remote_storage_pool_lookup_by_uuid_ret
type StoragePoolLookupByUUIDRet struct {
	Pool StoragePool
}

// StoragePoolLookupByNameArgs is libvirt's remote_storage_pool_lookup_by_name_args
type StoragePoolLookupByNameArgs struct {
	Name string
}

// StoragePoolLookupByNameRet is libvirt's remote_storage_pool_lookup_by_name_ret
type StoragePoolLookupByNameRet struct {
	Pool StoragePool
}

// StoragePoolLookupByVolumeArgs is libvirt's remote_storage_pool_lookup_by_volume_args
type StoragePoolLookupByVolumeArgs struct {
	Vol StorageVol
}

// StoragePoolLookupByVolumeRet is libvirt's remote_storage_pool_lookup_by_volume_ret
type StoragePoolLookupByVolumeRet struct {
	Pool StoragePool
}

// StoragePoolLookupByTargetPathArgs is libvirt's remote_storage_pool_lookup_by_target_path_args
type StoragePoolLookupByTargetPathArgs struct {
	Path string
}

// StoragePoolLookupByTargetPathRet is libvirt's remote_storage_pool_lookup_by_target_path_ret
type StoragePoolLookupByTargetPathRet struct {
	Pool StoragePool
}

// StoragePoolCreateXMLArgs is libvirt's remote_storage_pool_create_xml_args
type StoragePoolCreateXMLArgs struct {
	XML string
	Flags StoragePoolCreateFlags
}

// StoragePoolCreateXMLRet is libvirt's remote_storage_pool_create_xml_ret
type StoragePoolCreateXMLRet struct {
	Pool StoragePool
}

// StoragePoolDefineXMLArgs is libvirt's remote_storage_pool_define_xml_args
type StoragePoolDefineXMLArgs struct {
	XML string
	Flags uint32
}

// StoragePoolDefineXMLRet is libvirt's remote_storage_pool_define_xml_ret
type StoragePoolDefineXMLRet struct {
	Pool StoragePool
}

// StoragePoolBuildArgs is libvirt's remote_storage_pool_build_args
type StoragePoolBuildArgs struct {
	Pool StoragePool
	Flags StoragePoolBuildFlags
}

// StoragePoolUndefineArgs is libvirt's remote_storage_pool_undefine_args
type StoragePoolUndefineArgs struct {
	Pool StoragePool
}

// StoragePoolCreateArgs is libvirt's remote_storage_pool_create_args
type StoragePoolCreateArgs struct {
	Pool StoragePool
	Flags StoragePoolCreateFlags
}

// StoragePoolDestroyArgs is libvirt's remote_storage_pool_destroy_args
type StoragePoolDestroyArgs struct {
	Pool StoragePool
}

// StoragePoolDeleteArgs is libvirt's remote_storage_pool_delete_args
type StoragePoolDeleteArgs struct {
	Pool StoragePool
	Flags StoragePoolDeleteFlags
}

// StoragePoolRefreshArgs is libvirt's remote_storage_pool_refresh_args
type StoragePoolRefreshArgs struct {
	Pool StoragePool
	Flags uint32
}

// StoragePoolGetXMLDescArgs is libvirt's remote_storage_pool_get_xml_desc_args
type StoragePoolGetXMLDescArgs struct {
	Pool StoragePool
	Flags StorageXMLFlags
}

// StoragePoolGetXMLDescRet is libvirt's remote_storage_pool_get_xml_desc_ret
type StoragePoolGetXMLDescRet struct {
	XML string
}

// StoragePoolGetInfoArgs is libvirt's remote_storage_pool_get_info_args
type StoragePoolGetInfoArgs struct {
	Pool StoragePool
}

// StoragePoolGetInfoRet is libvirt's remote_storage_pool_get_info_ret
type StoragePoolGetInfoRet struct {
	State uint8
	Capacity uint64
	Allocation uint64
	Available uint64
}

// StoragePoolGetAutostartArgs is libvirt's remote_storage_pool_get_autostart_args
type StoragePoolGetAutostartArgs struct {
	Pool StoragePool
}

// StoragePoolGetAutostartRet is libvirt's remote_storage_pool_get_autostart_ret
type StoragePoolGetAutostartRet struct {
	Autostart int32
}

// StoragePoolSetAutostartArgs is libvirt's remote_storage_pool_set_autostart_args
type StoragePoolSetAutostartArgs struct {
	Pool StoragePool
	Autostart int32
}

// StoragePoolNumOfVolumesArgs is libvirt's remote_storage_pool_num_of_volumes_args
type StoragePoolNumOfVolumesArgs struct {
	Pool StoragePool
}

// StoragePoolNumOfVolumesRet is libvirt's remote_storage_pool_num_of_volumes_ret
type StoragePoolNumOfVolumesRet struct {
	Num int32
}

// StoragePoolListVolumesArgs is libvirt's remote_storage_pool_list_volumes_args
type StoragePoolListVolumesArgs struct {
	Pool StoragePool
	Maxnames int32
}

// StoragePoolListVolumesRet is libvirt's remote_storage_pool_list_volumes_ret
type StoragePoolListVolumesRet struct {
	Names []string
}

// StorageVolLookupByNameArgs is libvirt's remote_storage_vol_lookup_by_name_args
type StorageVolLookupByNameArgs struct {
	Pool StoragePool
	Name string
}

// StorageVolLookupByNameRet is libvirt's remote_storage_vol_lookup_by_name_ret
type StorageVolLookupByNameRet struct {
	Vol StorageVol
}

// StorageVolLookupByKeyArgs is libvirt's remote_storage_vol_lookup_by_key_args
type StorageVolLookupByKeyArgs struct {
	Key string
}

// StorageVolLookupByKeyRet is libvirt's remote_storage_vol_lookup_by_key_ret
type StorageVolLookupByKeyRet struct {
	Vol StorageVol
}

// StorageVolLookupByPathArgs is libvirt's remote_storage_vol_lookup_by_path_args
type StorageVolLookupByPathArgs struct {
	Path string
}

// StorageVolLookupByPathRet is libvirt's remote_storage_vol_lookup_by_path_ret
type StorageVolLookupByPathRet struct {
	Vol StorageVol
}

// StorageVolCreateXMLArgs is libvirt's remote_storage_vol_create_xml_args
type StorageVolCreateXMLArgs struct {
	Pool StoragePool
	XML string
	Flags StorageVolCreateFlags
}

// StorageVolCreateXMLRet is libvirt's remote_storage_vol_create_xml_ret
type StorageVolCreateXMLRet struct {
	Vol StorageVol
}

// StorageVolCreateXMLFromArgs is libvirt's remote_storage_vol_create_xml_from_args
type StorageVolCreateXMLFromArgs struct {
	Pool StoragePool
	XML string
	Clonevol StorageVol
	Flags StorageVolCreateFlags
}

// StorageVolCreateXMLFromRet is libvirt's remote_storage_vol_create_xml_from_ret
type StorageVolCreateXMLFromRet struct {
	Vol StorageVol
}

// StorageVolDeleteArgs is libvirt's remote_storage_vol_delete_args
type StorageVolDeleteArgs struct {
	Vol StorageVol
	Flags StorageVolDeleteFlags
}

// StorageVolWipeArgs is libvirt's remote_storage_vol_wipe_args
type StorageVolWipeArgs struct {
	Vol StorageVol
	Flags uint32
}

// StorageVolWipePatternArgs is libvirt's remote_storage_vol_wipe_pattern_args
type StorageVolWipePatternArgs struct {
	Vol StorageVol
	Algorithm uint32
	Flags uint32
}

// StorageVolGetXMLDescArgs is libvirt's remote_storage_vol_get_xml_desc_args
type StorageVolGetXMLDescArgs struct {
	Vol StorageVol
	Flags uint32
}

// StorageVolGetXMLDescRet is libvirt's remote_storage_vol_get_xml_desc_ret
type StorageVolGetXMLDescRet struct {
	XML string
}

// StorageVolGetInfoArgs is libvirt's remote_storage_vol_get_info_args
type StorageVolGetInfoArgs struct {
	Vol StorageVol
}

// StorageVolGetInfoRet is libvirt's remote_storage_vol_get_info_ret
type StorageVolGetInfoRet struct {
	Type int8
	Capacity uint64
	Allocation uint64
}

// StorageVolGetInfoFlagsArgs is libvirt's remote_storage_vol_get_info_flags_args
type StorageVolGetInfoFlagsArgs struct {
	Vol StorageVol
	Flags uint32
}

// StorageVolGetInfoFlagsRet is libvirt's remote_storage_vol_get_info_flags_ret
type StorageVolGetInfoFlagsRet struct {
	Type int8
	Capacity uint64
	Allocation uint64
}

// StorageVolGetPathArgs is libvirt's remote_storage_vol_get_path_args
type StorageVolGetPathArgs struct {
	Vol StorageVol
}

// StorageVolGetPathRet is libvirt's remote_storage_vol_get_path_ret
type StorageVolGetPathRet struct {
	Name string
}

// StorageVolResizeArgs is libvirt's remote_storage_vol_resize_args
type StorageVolResizeArgs struct {
	Vol StorageVol
	Capacity uint64
	Flags StorageVolResizeFlags
}

// NodeNumOfDevicesArgs is libvirt's remote_node_num_of_devices_args
type NodeNumOfDevicesArgs struct {
	Cap OptString
	Flags uint32
}

// NodeNumOfDevicesRet is libvirt's remote_node_num_of_devices_ret
type NodeNumOfDevicesRet struct {
	Num int32
}

// NodeListDevicesArgs is libvirt's remote_node_list_devices_args
type NodeListDevicesArgs struct {
	Cap OptString
	Maxnames int32
	Flags uint32
}

// NodeListDevicesRet is libvirt's remote_node_list_devices_ret
type NodeListDevicesRet struct {
	Names []string
}

// NodeDeviceLookupByNameArgs is libvirt's remote_node_device_lookup_by_name_args
type NodeDeviceLookupByNameArgs struct {
	Name string
}

// NodeDeviceLookupByNameRet is libvirt's remote_node_device_lookup_by_name_ret
type NodeDeviceLookupByNameRet struct {
	Dev NodeDevice
}

// NodeDeviceLookupScsiHostByWwnArgs is libvirt's remote_node_device_lookup_scsi_host_by_wwn_args
type NodeDeviceLookupScsiHostByWwnArgs struct {
	Wwnn string
	Wwpn string
	Flags uint32
}

// NodeDeviceLookupScsiHostByWwnRet is libvirt's remote_node_device_lookup_scsi_host_by_wwn_ret
type NodeDeviceLookupScsiHostByWwnRet struct {
	Dev NodeDevice
}

// NodeDeviceGetXMLDescArgs is libvirt's remote_node_device_get_xml_desc_args
type NodeDeviceGetXMLDescArgs struct {
	Name string
	Flags uint32
}

// NodeDeviceGetXMLDescRet is libvirt's remote_node_device_get_xml_desc_ret
type NodeDeviceGetXMLDescRet struct {
	XML string
}

// NodeDeviceGetParentArgs is libvirt's remote_node_device_get_parent_args
type NodeDeviceGetParentArgs struct {
	Name string
}

// NodeDeviceGetParentRet is libvirt's remote_node_device_get_parent_ret
type NodeDeviceGetParentRet struct {
	ParentName OptString
}

// NodeDeviceNumOfCapsArgs is libvirt's remote_node_device_num_of_caps_args
type NodeDeviceNumOfCapsArgs struct {
	Name string
}

// NodeDeviceNumOfCapsRet is libvirt's remote_node_device_num_of_caps_ret
type NodeDeviceNumOfCapsRet struct {
	Num int32
}

// NodeDeviceListCapsArgs is libvirt's remote_node_device_list_caps_args
type NodeDeviceListCapsArgs struct {
	Name string
	Maxnames int32
}

// NodeDeviceListCapsRet is libvirt's remote_node_device_list_caps_ret
type NodeDeviceListCapsRet struct {
	Names []string
}

// NodeDeviceDettachArgs is libvirt's remote_node_device_dettach_args
type NodeDeviceDettachArgs struct {
	Name string
}

// NodeDeviceDetachFlagsArgs is libvirt's remote_node_device_detach_flags_args
type NodeDeviceDetachFlagsArgs struct {
	Name string
	DriverName OptString
	Flags uint32
}

// NodeDeviceReAttachArgs is libvirt's remote_node_device_re_attach_args
type NodeDeviceReAttachArgs struct {
	Name string
}

// NodeDeviceResetArgs is libvirt's remote_node_device_reset_args
type NodeDeviceResetArgs struct {
	Name string
}

// NodeDeviceCreateXMLArgs is libvirt's remote_node_device_create_xml_args
type NodeDeviceCreateXMLArgs struct {
	XMLDesc string
	Flags uint32
}

// NodeDeviceCreateXMLRet is libvirt's remote_node_device_create_xml_ret
type NodeDeviceCreateXMLRet struct {
	Dev NodeDevice
}

// NodeDeviceDestroyArgs is libvirt's remote_node_device_destroy_args
type NodeDeviceDestroyArgs struct {
	Name string
}

// ConnectDomainEventRegisterRet is libvirt's remote_connect_domain_event_register_ret
type ConnectDomainEventRegisterRet struct {
	CbRegistered int32
}

// ConnectDomainEventDeregisterRet is libvirt's remote_connect_domain_event_deregister_ret
type ConnectDomainEventDeregisterRet struct {
	CbRegistered int32
}

// DomainEventLifecycleMsg is libvirt's remote_domain_event_lifecycle_msg
type DomainEventLifecycleMsg struct {
	Dom Domain
	Event int32
	Detail int32
}

// DomainEventCallbackLifecycleMsg is libvirt's remote_domain_event_callback_lifecycle_msg
type DomainEventCallbackLifecycleMsg struct {
	CallbackID int32
	Msg DomainEventLifecycleMsg
}

// ConnectDomainXMLFromNativeArgs is libvirt's remote_connect_domain_xml_from_native_args
type ConnectDomainXMLFromNativeArgs struct {
	NativeFormat string
	NativeConfig string
	Flags uint32
}

// ConnectDomainXMLFromNativeRet is libvirt's remote_connect_domain_xml_from_native_ret
type ConnectDomainXMLFromNativeRet struct {
	DomainXML string
}

// ConnectDomainXMLToNativeArgs is libvirt's remote_connect_domain_xml_to_native_args
type ConnectDomainXMLToNativeArgs struct {
	NativeFormat string
	DomainXML string
	Flags uint32
}

// ConnectDomainXMLToNativeRet is libvirt's remote_connect_domain_xml_to_native_ret
type ConnectDomainXMLToNativeRet struct {
	NativeConfig string
}

// ConnectNumOfSecretsRet is libvirt's remote_connect_num_of_secrets_ret
type ConnectNumOfSecretsRet struct {
	Num int32
}

// ConnectListSecretsArgs is libvirt's remote_connect_list_secrets_args
type ConnectListSecretsArgs struct {
	Maxuuids int32
}

// ConnectListSecretsRet is libvirt's remote_connect_list_secrets_ret
type ConnectListSecretsRet struct {
	Uuids []string
}

// SecretLookupByUUIDArgs is libvirt's remote_secret_lookup_by_uuid_args
type SecretLookupByUUIDArgs struct {
	UUID UUID
}

// SecretLookupByUUIDRet is libvirt's remote_secret_lookup_by_uuid_ret
type SecretLookupByUUIDRet struct {
	OptSecret Secret
}

// SecretDefineXMLArgs is libvirt's remote_secret_define_xml_args
type SecretDefineXMLArgs struct {
	XML string
	Flags uint32
}

// SecretDefineXMLRet is libvirt's remote_secret_define_xml_ret
type SecretDefineXMLRet struct {
	OptSecret Secret
}

// SecretGetXMLDescArgs is libvirt's remote_secret_get_xml_desc_args
type SecretGetXMLDescArgs struct {
	OptSecret Secret
	Flags uint32
}

// SecretGetXMLDescRet is libvirt's remote_secret_get_xml_desc_ret
type SecretGetXMLDescRet struct {
	XML string
}

// SecretSetValueArgs is libvirt's remote_secret_set_value_args
type SecretSetValueArgs struct {
	OptSecret Secret
	Value []byte
	Flags uint32
}

// SecretGetValueArgs is libvirt's remote_secret_get_value_args
type SecretGetValueArgs struct {
	OptSecret Secret
	Flags uint32
}

// SecretGetValueRet is libvirt's remote_secret_get_value_ret
type SecretGetValueRet struct {
	Value []byte
}

// SecretUndefineArgs is libvirt's remote_secret_undefine_args
type SecretUndefineArgs struct {
	OptSecret Secret
}

// SecretLookupByUsageArgs is libvirt's remote_secret_lookup_by_usage_args
type SecretLookupByUsageArgs struct {
	UsageType int32
	UsageID string
}

// SecretLookupByUsageRet is libvirt's remote_secret_lookup_by_usage_ret
type SecretLookupByUsageRet struct {
	OptSecret Secret
}

// DomainMigratePrepareTunnelArgs is libvirt's remote_domain_migrate_prepare_tunnel_args
type DomainMigratePrepareTunnelArgs struct {
	Flags uint64
	Dname OptString
	Resource uint64
	DomXML string
}

// ConnectIsSecureRet is libvirt's remote_connect_is_secure_ret
type ConnectIsSecureRet struct {
	Secure int32
}

// DomainIsActiveArgs is libvirt's remote_domain_is_active_args
type DomainIsActiveArgs struct {
	Dom Domain
}

// DomainIsActiveRet is libvirt's remote_domain_is_active_ret
type DomainIsActiveRet struct {
	Active int32
}

// DomainIsPersistentArgs is libvirt's remote_domain_is_persistent_args
type DomainIsPersistentArgs struct {
	Dom Domain
}

// DomainIsPersistentRet is libvirt's remote_domain_is_persistent_ret
type DomainIsPersistentRet struct {
	Persistent int32
}

// DomainIsUpdatedArgs is libvirt's remote_domain_is_updated_args
type DomainIsUpdatedArgs struct {
	Dom Domain
}

// DomainIsUpdatedRet is libvirt's remote_domain_is_updated_ret
type DomainIsUpdatedRet struct {
	Updated int32
}

// NetworkIsActiveArgs is libvirt's remote_network_is_active_args
type NetworkIsActiveArgs struct {
	Net Network
}

// NetworkIsActiveRet is libvirt's remote_network_is_active_ret
type NetworkIsActiveRet struct {
	Active int32
}

// NetworkIsPersistentArgs is libvirt's remote_network_is_persistent_args
type NetworkIsPersistentArgs struct {
	Net Network
}

// NetworkIsPersistentRet is libvirt's remote_network_is_persistent_ret
type NetworkIsPersistentRet struct {
	Persistent int32
}

// StoragePoolIsActiveArgs is libvirt's remote_storage_pool_is_active_args
type StoragePoolIsActiveArgs struct {
	Pool StoragePool
}

// StoragePoolIsActiveRet is libvirt's remote_storage_pool_is_active_ret
type StoragePoolIsActiveRet struct {
	Active int32
}

// StoragePoolIsPersistentArgs is libvirt's remote_storage_pool_is_persistent_args
type StoragePoolIsPersistentArgs struct {
	Pool StoragePool
}

// StoragePoolIsPersistentRet is libvirt's remote_storage_pool_is_persistent_ret
type StoragePoolIsPersistentRet struct {
	Persistent int32
}

// InterfaceIsActiveArgs is libvirt's remote_interface_is_active_args
type InterfaceIsActiveArgs struct {
	Iface Interface
}

// InterfaceIsActiveRet is libvirt's remote_interface_is_active_ret
type InterfaceIsActiveRet struct {
	Active int32
}

// ConnectCompareCPUArgs is libvirt's remote_connect_compare_cpu_args
type ConnectCompareCPUArgs struct {
	XML string
	Flags ConnectCompareCPUFlags
}

// ConnectCompareCPURet is libvirt's remote_connect_compare_cpu_ret
type ConnectCompareCPURet struct {
	Result int32
}

// ConnectBaselineCPUArgs is libvirt's remote_connect_baseline_cpu_args
type ConnectBaselineCPUArgs struct {
	XMLCPUs []string
	Flags ConnectBaselineCPUFlags
}

// ConnectBaselineCPURet is libvirt's remote_connect_baseline_cpu_ret
type ConnectBaselineCPURet struct {
	CPU string
}

// DomainGetJobInfoArgs is libvirt's remote_domain_get_job_info_args
type DomainGetJobInfoArgs struct {
	Dom Domain
}

// DomainGetJobInfoRet is libvirt's remote_domain_get_job_info_ret
type DomainGetJobInfoRet struct {
	Type int32
	TimeElapsed uint64
	TimeRemaining uint64
	DataTotal uint64
	DataProcessed uint64
	DataRemaining uint64
	MemTotal uint64
	MemProcessed uint64
	MemRemaining uint64
	FileTotal uint64
	FileProcessed uint64
	FileRemaining uint64
}

// DomainGetJobStatsArgs is libvirt's remote_domain_get_job_stats_args
type DomainGetJobStatsArgs struct {
	Dom Domain
	Flags DomainGetJobStatsFlags
}

// DomainGetJobStatsRet is libvirt's remote_domain_get_job_stats_ret
type DomainGetJobStatsRet struct {
	Type int32
	Params []TypedParam
}

// DomainAbortJobArgs is libvirt's remote_domain_abort_job_args
type DomainAbortJobArgs struct {
	Dom Domain
}

// DomainMigrateGetMaxDowntimeArgs is libvirt's remote_domain_migrate_get_max_downtime_args
type DomainMigrateGetMaxDowntimeArgs struct {
	Dom Domain
	Flags uint32
}

// DomainMigrateGetMaxDowntimeRet is libvirt's remote_domain_migrate_get_max_downtime_ret
type DomainMigrateGetMaxDowntimeRet struct {
	Downtime uint64
}

// DomainMigrateSetMaxDowntimeArgs is libvirt's remote_domain_migrate_set_max_downtime_args
type DomainMigrateSetMaxDowntimeArgs struct {
	Dom Domain
	Downtime uint64
	Flags uint32
}

// DomainMigrateGetCompressionCacheArgs is libvirt's remote_domain_migrate_get_compression_cache_args
type DomainMigrateGetCompressionCacheArgs struct {
	Dom Domain
	Flags uint32
}

// DomainMigrateGetCompressionCacheRet is libvirt's remote_domain_migrate_get_compression_cache_ret
type DomainMigrateGetCompressionCacheRet struct {
	CacheSize uint64
}

// DomainMigrateSetCompressionCacheArgs is libvirt's remote_domain_migrate_set_compression_cache_args
type DomainMigrateSetCompressionCacheArgs struct {
	Dom Domain
	CacheSize uint64
	Flags uint32
}

// DomainMigrateSetMaxSpeedArgs is libvirt's remote_domain_migrate_set_max_speed_args
type DomainMigrateSetMaxSpeedArgs struct {
	Dom Domain
	Bandwidth uint64
	Flags uint32
}

// DomainMigrateGetMaxSpeedArgs is libvirt's remote_domain_migrate_get_max_speed_args
type DomainMigrateGetMaxSpeedArgs struct {
	Dom Domain
	Flags uint32
}

// DomainMigrateGetMaxSpeedRet is libvirt's remote_domain_migrate_get_max_speed_ret
type DomainMigrateGetMaxSpeedRet struct {
	Bandwidth uint64
}

// ConnectDomainEventRegisterAnyArgs is libvirt's remote_connect_domain_event_register_any_args
type ConnectDomainEventRegisterAnyArgs struct {
	EventID int32
}

// ConnectDomainEventDeregisterAnyArgs is libvirt's remote_connect_domain_event_deregister_any_args
type ConnectDomainEventDeregisterAnyArgs struct {
	EventID int32
}

// ConnectDomainEventCallbackRegisterAnyArgs is libvirt's remote_connect_domain_event_callback_register_any_args
type ConnectDomainEventCallbackRegisterAnyArgs struct {
	EventID int32
	Dom OptDomain
}

// ConnectDomainEventCallbackRegisterAnyRet is libvirt's remote_connect_domain_event_callback_register_any_ret
type ConnectDomainEventCallbackRegisterAnyRet struct {
	CallbackID int32
}

// ConnectDomainEventCallbackDeregisterAnyArgs is libvirt's remote_connect_domain_event_callback_deregister_any_args
type ConnectDomainEventCallbackDeregisterAnyArgs struct {
	CallbackID int32
}

// DomainEventRebootMsg is libvirt's remote_domain_event_reboot_msg
type DomainEventRebootMsg struct {
	Dom Domain
}

// DomainEventCallbackRebootMsg is libvirt's remote_domain_event_callback_reboot_msg
type DomainEventCallbackRebootMsg struct {
	CallbackID int32
	Msg DomainEventRebootMsg
}

// DomainEventRtcChangeMsg is libvirt's remote_domain_event_rtc_change_msg
type DomainEventRtcChangeMsg struct {
	Dom Domain
	Offset int64
}

// DomainEventCallbackRtcChangeMsg is libvirt's remote_domain_event_callback_rtc_change_msg
type DomainEventCallbackRtcChangeMsg struct {
	CallbackID int32
	Msg DomainEventRtcChangeMsg
}

// DomainEventWatchdogMsg is libvirt's remote_domain_event_watchdog_msg
type DomainEventWatchdogMsg struct {
	Dom Domain
	Action int32
}

// DomainEventCallbackWatchdogMsg is libvirt's remote_domain_event_callback_watchdog_msg
type DomainEventCallbackWatchdogMsg struct {
	CallbackID int32
	Msg DomainEventWatchdogMsg
}

// DomainEventIOErrorMsg is libvirt's remote_domain_event_io_error_msg
type DomainEventIOErrorMsg struct {
	Dom Domain
	SrcPath string
	DevAlias string
	Action int32
}

// DomainEventCallbackIOErrorMsg is libvirt's remote_domain_event_callback_io_error_msg
type DomainEventCallbackIOErrorMsg struct {
	CallbackID int32
	Msg DomainEventIOErrorMsg
}

// DomainEventIOErrorReasonMsg is libvirt's remote_domain_event_io_error_reason_msg
type DomainEventIOErrorReasonMsg struct {
	Dom Domain
	SrcPath string
	DevAlias string
	Action int32
	Reason string
}

// DomainEventCallbackIOErrorReasonMsg is libvirt's remote_domain_event_callback_io_error_reason_msg
type DomainEventCallbackIOErrorReasonMsg struct {
	CallbackID int32
	Msg DomainEventIOErrorReasonMsg
}

// DomainEventGraphicsAddress is libvirt's remote_domain_event_graphics_address
type DomainEventGraphicsAddress struct {
	Family int32
	Node string
	Service string
}

// DomainEventGraphicsIdentity is libvirt's remote_domain_event_graphics_identity
type DomainEventGraphicsIdentity struct {
	Type string
	Name string
}

// DomainEventGraphicsMsg is libvirt's remote_domain_event_graphics_msg
type DomainEventGraphicsMsg struct {
	Dom Domain
	Phase int32
	Local DomainEventGraphicsAddress
	Remote DomainEventGraphicsAddress
	AuthScheme string
	Subject []DomainEventGraphicsIdentity
}

// DomainEventCallbackGraphicsMsg is libvirt's remote_domain_event_callback_graphics_msg
type DomainEventCallbackGraphicsMsg struct {
	CallbackID int32
	Msg DomainEventGraphicsMsg
}

// DomainEventBlockJobMsg is libvirt's remote_domain_event_block_job_msg
type DomainEventBlockJobMsg struct {
	Dom Domain
	Path string
	Type int32
	Status int32
}

// DomainEventCallbackBlockJobMsg is libvirt's remote_domain_event_callback_block_job_msg
type DomainEventCallbackBlockJobMsg struct {
	CallbackID int32
	Msg DomainEventBlockJobMsg
}

// DomainEventDiskChangeMsg is libvirt's remote_domain_event_disk_change_msg
type DomainEventDiskChangeMsg struct {
	Dom Domain
	OldSrcPath OptString
	NewSrcPath OptString
	DevAlias string
	Reason int32
}

// DomainEventCallbackDiskChangeMsg is libvirt's remote_domain_event_callback_disk_change_msg
type DomainEventCallbackDiskChangeMsg struct {
	CallbackID int32
	Msg DomainEventDiskChangeMsg
}

// DomainEventTrayChangeMsg is libvirt's remote_domain_event_tray_change_msg
type DomainEventTrayChangeMsg struct {
	Dom Domain
	DevAlias string
	Reason int32
}

// DomainEventCallbackTrayChangeMsg is libvirt's remote_domain_event_callback_tray_change_msg
type DomainEventCallbackTrayChangeMsg struct {
	CallbackID int32
	Msg DomainEventTrayChangeMsg
}

// DomainEventPmwakeupMsg is libvirt's remote_domain_event_pmwakeup_msg
type DomainEventPmwakeupMsg struct {
	Dom Domain
}

// DomainEventCallbackPmwakeupMsg is libvirt's remote_domain_event_callback_pmwakeup_msg
type DomainEventCallbackPmwakeupMsg struct {
	CallbackID int32
	Reason int32
	Msg DomainEventPmwakeupMsg
}

// DomainEventPmsuspendMsg is libvirt's remote_domain_event_pmsuspend_msg
type DomainEventPmsuspendMsg struct {
	Dom Domain
}

// DomainEventCallbackPmsuspendMsg is libvirt's remote_domain_event_callback_pmsuspend_msg
type DomainEventCallbackPmsuspendMsg struct {
	CallbackID int32
	Reason int32
	Msg DomainEventPmsuspendMsg
}

// DomainEventBalloonChangeMsg is libvirt's remote_domain_event_balloon_change_msg
type DomainEventBalloonChangeMsg struct {
	Dom Domain
	Actual uint64
}

// DomainEventCallbackBalloonChangeMsg is libvirt's remote_domain_event_callback_balloon_change_msg
type DomainEventCallbackBalloonChangeMsg struct {
	CallbackID int32
	Msg DomainEventBalloonChangeMsg
}

// DomainEventPmsuspendDiskMsg is libvirt's remote_domain_event_pmsuspend_disk_msg
type DomainEventPmsuspendDiskMsg struct {
	Dom Domain
}

// DomainEventCallbackPmsuspendDiskMsg is libvirt's remote_domain_event_callback_pmsuspend_disk_msg
type DomainEventCallbackPmsuspendDiskMsg struct {
	CallbackID int32
	Reason int32
	Msg DomainEventPmsuspendDiskMsg
}

// DomainManagedSaveArgs is libvirt's remote_domain_managed_save_args
type DomainManagedSaveArgs struct {
	Dom Domain
	Flags uint32
}

// DomainHasManagedSaveImageArgs is libvirt's remote_domain_has_managed_save_image_args
type DomainHasManagedSaveImageArgs struct {
	Dom Domain
	Flags uint32
}

// DomainHasManagedSaveImageRet is libvirt's remote_domain_has_managed_save_image_ret
type DomainHasManagedSaveImageRet struct {
	Result int32
}

// DomainManagedSaveRemoveArgs is libvirt's remote_domain_managed_save_remove_args
type DomainManagedSaveRemoveArgs struct {
	Dom Domain
	Flags uint32
}

// DomainManagedSaveGetXMLDescArgs is libvirt's remote_domain_managed_save_get_xml_desc_args
type DomainManagedSaveGetXMLDescArgs struct {
	Dom Domain
	Flags DomainXMLFlags
}

// DomainManagedSaveGetXMLDescRet is libvirt's remote_domain_managed_save_get_xml_desc_ret
type DomainManagedSaveGetXMLDescRet struct {
	XML string
}

// DomainManagedSaveDefineXMLArgs is libvirt's remote_domain_managed_save_define_xml_args
type DomainManagedSaveDefineXMLArgs struct {
	Dom Domain
	Dxml OptString
	Flags DomainSaveRestoreFlags
}

// DomainSnapshotCreateXMLArgs is libvirt's remote_domain_snapshot_create_xml_args
type DomainSnapshotCreateXMLArgs struct {
	Dom Domain
	XMLDesc string
	Flags uint32
}

// DomainSnapshotCreateXMLRet is libvirt's remote_domain_snapshot_create_xml_ret
type DomainSnapshotCreateXMLRet struct {
	Snap DomainSnapshot
}

// DomainSnapshotGetXMLDescArgs is libvirt's remote_domain_snapshot_get_xml_desc_args
type DomainSnapshotGetXMLDescArgs struct {
	Snap DomainSnapshot
	Flags uint32
}

// DomainSnapshotGetXMLDescRet is libvirt's remote_domain_snapshot_get_xml_desc_ret
type DomainSnapshotGetXMLDescRet struct {
	XML string
}

// DomainSnapshotNumArgs is libvirt's remote_domain_snapshot_num_args
type DomainSnapshotNumArgs struct {
	Dom Domain
	Flags uint32
}

// DomainSnapshotNumRet is libvirt's remote_domain_snapshot_num_ret
type DomainSnapshotNumRet struct {
	Num int32
}

// DomainSnapshotListNamesArgs is libvirt's remote_domain_snapshot_list_names_args
type DomainSnapshotListNamesArgs struct {
	Dom Domain
	Maxnames int32
	Flags uint32
}

// DomainSnapshotListNamesRet is libvirt's remote_domain_snapshot_list_names_ret
type DomainSnapshotListNamesRet struct {
	Names []string
}

// DomainListAllSnapshotsArgs is libvirt's remote_domain_list_all_snapshots_args
type DomainListAllSnapshotsArgs struct {
	Dom Domain
	NeedResults int32
	Flags uint32
}

// DomainListAllSnapshotsRet is libvirt's remote_domain_list_all_snapshots_ret
type DomainListAllSnapshotsRet struct {
	Snapshots []DomainSnapshot
	Ret int32
}

// DomainSnapshotNumChildrenArgs is libvirt's remote_domain_snapshot_num_children_args
type DomainSnapshotNumChildrenArgs struct {
	Snap DomainSnapshot
	Flags uint32
}

// DomainSnapshotNumChildrenRet is libvirt's remote_domain_snapshot_num_children_ret
type DomainSnapshotNumChildrenRet struct {
	Num int32
}

// DomainSnapshotListChildrenNamesArgs is libvirt's remote_domain_snapshot_list_children_names_args
type DomainSnapshotListChildrenNamesArgs struct {
	Snap DomainSnapshot
	Maxnames int32
	Flags uint32
}

// DomainSnapshotListChildrenNamesRet is libvirt's remote_domain_snapshot_list_children_names_ret
type DomainSnapshotListChildrenNamesRet struct {
	Names []string
}

// DomainSnapshotListAllChildrenArgs is libvirt's remote_domain_snapshot_list_all_children_args
type DomainSnapshotListAllChildrenArgs struct {
	Snapshot DomainSnapshot
	NeedResults int32
	Flags uint32
}

// DomainSnapshotListAllChildrenRet is libvirt's remote_domain_snapshot_list_all_children_ret
type DomainSnapshotListAllChildrenRet struct {
	Snapshots []DomainSnapshot
	Ret int32
}

// DomainSnapshotLookupByNameArgs is libvirt's remote_domain_snapshot_lookup_by_name_args
type DomainSnapshotLookupByNameArgs struct {
	Dom Domain
	Name string
	Flags uint32
}

// DomainSnapshotLookupByNameRet is libvirt's remote_domain_snapshot_lookup_by_name_ret
type DomainSnapshotLookupByNameRet struct {
	Snap DomainSnapshot
}

// DomainHasCurrentSnapshotArgs is libvirt's remote_domain_has_current_snapshot_args
type DomainHasCurrentSnapshotArgs struct {
	Dom Domain
	Flags uint32
}

// DomainHasCurrentSnapshotRet is libvirt's remote_domain_has_current_snapshot_ret
type DomainHasCurrentSnapshotRet struct {
	Result int32
}

// DomainSnapshotGetParentArgs is libvirt's remote_domain_snapshot_get_parent_args
type DomainSnapshotGetParentArgs struct {
	Snap DomainSnapshot
	Flags uint32
}

// DomainSnapshotGetParentRet is libvirt's remote_domain_snapshot_get_parent_ret
type DomainSnapshotGetParentRet struct {
	Snap DomainSnapshot
}

// DomainSnapshotCurrentArgs is libvirt's remote_domain_snapshot_current_args
type DomainSnapshotCurrentArgs struct {
	Dom Domain
	Flags uint32
}

// DomainSnapshotCurrentRet is libvirt's remote_domain_snapshot_current_ret
type DomainSnapshotCurrentRet struct {
	Snap DomainSnapshot
}

// DomainSnapshotIsCurrentArgs is libvirt's remote_domain_snapshot_is_current_args
type DomainSnapshotIsCurrentArgs struct {
	Snap DomainSnapshot
	Flags uint32
}

// DomainSnapshotIsCurrentRet is libvirt's remote_domain_snapshot_is_current_ret
type DomainSnapshotIsCurrentRet struct {
	Current int32
}

// DomainSnapshotHasMetadataArgs is libvirt's remote_domain_snapshot_has_metadata_args
type DomainSnapshotHasMetadataArgs struct {
	Snap DomainSnapshot
	Flags uint32
}

// DomainSnapshotHasMetadataRet is libvirt's remote_domain_snapshot_has_metadata_ret
type DomainSnapshotHasMetadataRet struct {
	Metadata int32
}

// DomainRevertToSnapshotArgs is libvirt's remote_domain_revert_to_snapshot_args
type DomainRevertToSnapshotArgs struct {
	Snap DomainSnapshot
	Flags uint32
}

// DomainSnapshotDeleteArgs is libvirt's remote_domain_snapshot_delete_args
type DomainSnapshotDeleteArgs struct {
	Snap DomainSnapshot
	Flags DomainSnapshotDeleteFlags
}

// DomainOpenConsoleArgs is libvirt's remote_domain_open_console_args
type DomainOpenConsoleArgs struct {
	Dom Domain
	DevName OptString
	Flags uint32
}

// DomainOpenChannelArgs is libvirt's remote_domain_open_channel_args
type DomainOpenChannelArgs struct {
	Dom Domain
	Name OptString
	Flags DomainChannelFlags
}

// StorageVolUploadArgs is libvirt's remote_storage_vol_upload_args
type StorageVolUploadArgs struct {
	Vol StorageVol
	Offset uint64
	Length uint64
	Flags StorageVolUploadFlags
}

// StorageVolDownloadArgs is libvirt's remote_storage_vol_download_args
type StorageVolDownloadArgs struct {
	Vol StorageVol
	Offset uint64
	Length uint64
	Flags StorageVolDownloadFlags
}

// DomainGetStateArgs is libvirt's remote_domain_get_state_args
type DomainGetStateArgs struct {
	Dom Domain
	Flags uint32
}

// DomainGetStateRet is libvirt's remote_domain_get_state_ret
type DomainGetStateRet struct {
	State int32
	Reason int32
}

// DomainMigrateBegin3Args is libvirt's remote_domain_migrate_begin3_args
type DomainMigrateBegin3Args struct {
	Dom Domain
	Xmlin OptString
	Flags uint64
	Dname OptString
	Resource uint64
}

// DomainMigrateBegin3Ret is libvirt's remote_domain_migrate_begin3_ret
type DomainMigrateBegin3Ret struct {
	CookieOut []byte
	XML string
}

// DomainMigratePrepare3Args is libvirt's remote_domain_migrate_prepare3_args
type DomainMigratePrepare3Args struct {
	CookieIn []byte
	UriIn OptString
	Flags uint64
	Dname OptString
	Resource uint64
	DomXML string
}

// DomainMigratePrepare3Ret is libvirt's remote_domain_migrate_prepare3_ret
type DomainMigratePrepare3Ret struct {
	CookieOut []byte
	UriOut OptString
}

// DomainMigratePrepareTunnel3Args is libvirt's remote_domain_migrate_prepare_tunnel3_args
type DomainMigratePrepareTunnel3Args struct {
	CookieIn []byte
	Flags uint64
	Dname OptString
	Resource uint64
	DomXML string
}

// DomainMigratePrepareTunnel3Ret is libvirt's remote_domain_migrate_prepare_tunnel3_ret
type DomainMigratePrepareTunnel3Ret struct {
	CookieOut []byte
}

// DomainMigratePerform3Args is libvirt's remote_domain_migrate_perform3_args
type DomainMigratePerform3Args struct {
	Dom Domain
	Xmlin OptString
	CookieIn []byte
	Dconnuri OptString
	Uri OptString
	Flags uint64
	Dname OptString
	Resource uint64
}

// DomainMigratePerform3Ret is libvirt's remote_domain_migrate_perform3_ret
type DomainMigratePerform3Ret struct {
	CookieOut []byte
}

// DomainMigrateFinish3Args is libvirt's remote_domain_migrate_finish3_args
type DomainMigrateFinish3Args struct {
	Dname string
	CookieIn []byte
	Dconnuri OptString
	Uri OptString
	Flags uint64
	Cancelled int32
}

// DomainMigrateFinish3Ret is libvirt's remote_domain_migrate_finish3_ret
type DomainMigrateFinish3Ret struct {
	Dom Domain
	CookieOut []byte
}

// DomainMigrateConfirm3Args is libvirt's remote_domain_migrate_confirm3_args
type DomainMigrateConfirm3Args struct {
	Dom Domain
	CookieIn []byte
	Flags uint64
	Cancelled int32
}

// DomainEventControlErrorMsg is libvirt's remote_domain_event_control_error_msg
type DomainEventControlErrorMsg struct {
	Dom Domain
}

// DomainEventCallbackControlErrorMsg is libvirt's remote_domain_event_callback_control_error_msg
type DomainEventCallbackControlErrorMsg struct {
	CallbackID int32
	Msg DomainEventControlErrorMsg
}

// DomainGetControlInfoArgs is libvirt's remote_domain_get_control_info_args
type DomainGetControlInfoArgs struct {
	Dom Domain
	Flags uint32
}

// DomainGetControlInfoRet is libvirt's remote_domain_get_control_info_ret
type DomainGetControlInfoRet struct {
	State uint32
	Details uint32
	StateTime uint64
}

// DomainOpenGraphicsArgs is libvirt's remote_domain_open_graphics_args
type DomainOpenGraphicsArgs struct {
	Dom Domain
	Idx uint32
	Flags DomainOpenGraphicsFlags
}

// DomainOpenGraphicsFdArgs is libvirt's remote_domain_open_graphics_fd_args
type DomainOpenGraphicsFdArgs struct {
	Dom Domain
	Idx uint32
	Flags DomainOpenGraphicsFlags
}

// NodeSuspendForDurationArgs is libvirt's remote_node_suspend_for_duration_args
type NodeSuspendForDurationArgs struct {
	Target uint32
	Duration uint64
	Flags uint32
}

// DomainShutdownFlagsArgs is libvirt's remote_domain_shutdown_flags_args
type DomainShutdownFlagsArgs struct {
	Dom Domain
	Flags DomainShutdownFlagValues
}

// DomainGetDiskErrorsArgs is libvirt's remote_domain_get_disk_errors_args
type DomainGetDiskErrorsArgs struct {
	Dom Domain
	Maxerrors uint32
	Flags uint32
}

// DomainGetDiskErrorsRet is libvirt's remote_domain_get_disk_errors_ret
type DomainGetDiskErrorsRet struct {
	Errors []DomainDiskError
	Nerrors int32
}

// ConnectListAllDomainsArgs is libvirt's remote_connect_list_all_domains_args
type ConnectListAllDomainsArgs struct {
	NeedResults int32
	Flags ConnectListAllDomainsFlags
}

// ConnectListAllDomainsRet is libvirt's remote_connect_list_all_domains_ret
type ConnectListAllDomainsRet struct {
	Domains []Domain
	Ret uint32
}

// ConnectListAllStoragePoolsArgs is libvirt's remote_connect_list_all_storage_pools_args
type ConnectListAllStoragePoolsArgs struct {
	NeedResults int32
	Flags ConnectListAllStoragePoolsFlags
}

// ConnectListAllStoragePoolsRet is libvirt's remote_connect_list_all_storage_pools_ret
type ConnectListAllStoragePoolsRet struct {
	Pools []StoragePool
	Ret uint32
}

// StoragePoolListAllVolumesArgs is libvirt's remote_storage_pool_list_all_volumes_args
type StoragePoolListAllVolumesArgs struct {
	Pool StoragePool
	NeedResults int32
	Flags uint32
}

// StoragePoolListAllVolumesRet is libvirt's remote_storage_pool_list_all_volumes_ret
type StoragePoolListAllVolumesRet struct {
	Vols []StorageVol
	Ret uint32
}

// ConnectListAllNetworksArgs is libvirt's remote_connect_list_all_networks_args
type ConnectListAllNetworksArgs struct {
	NeedResults int32
	Flags ConnectListAllNetworksFlags
}

// ConnectListAllNetworksRet is libvirt's remote_connect_list_all_networks_ret
type ConnectListAllNetworksRet struct {
	Nets []Network
	Ret uint32
}

// ConnectListAllInterfacesArgs is libvirt's remote_connect_list_all_interfaces_args
type ConnectListAllInterfacesArgs struct {
	NeedResults int32
	Flags ConnectListAllInterfacesFlags
}

// ConnectListAllInterfacesRet is libvirt's remote_connect_list_all_interfaces_ret
type ConnectListAllInterfacesRet struct {
	Ifaces []Interface
	Ret uint32
}

// ConnectListAllNodeDevicesArgs is libvirt's remote_connect_list_all_node_devices_args
type ConnectListAllNodeDevicesArgs struct {
	NeedResults int32
	Flags uint32
}

// ConnectListAllNodeDevicesRet is libvirt's remote_connect_list_all_node_devices_ret
type ConnectListAllNodeDevicesRet struct {
	Devices []NodeDevice
	Ret uint32
}

// ConnectListAllNwfiltersArgs is libvirt's remote_connect_list_all_nwfilters_args
type ConnectListAllNwfiltersArgs struct {
	NeedResults int32
	Flags uint32
}

// ConnectListAllNwfiltersRet is libvirt's remote_connect_list_all_nwfilters_ret
type ConnectListAllNwfiltersRet struct {
	Filters []Nwfilter
	Ret uint32
}

// ConnectListAllSecretsArgs is libvirt's remote_connect_list_all_secrets_args
type ConnectListAllSecretsArgs struct {
	NeedResults int32
	Flags ConnectListAllSecretsFlags
}

// ConnectListAllSecretsRet is libvirt's remote_connect_list_all_secrets_ret
type ConnectListAllSecretsRet struct {
	Secrets []Secret
	Ret uint32
}

// NodeSetMemoryParametersArgs is libvirt's remote_node_set_memory_parameters_args
type NodeSetMemoryParametersArgs struct {
	Params []TypedParam
	Flags uint32
}

// NodeGetMemoryParametersArgs is libvirt's remote_node_get_memory_parameters_args
type NodeGetMemoryParametersArgs struct {
	Nparams int32
	Flags uint32
}

// NodeGetMemoryParametersRet is libvirt's remote_node_get_memory_parameters_ret
type NodeGetMemoryParametersRet struct {
	Params []TypedParam
	Nparams int32
}

// NodeGetCPUMapArgs is libvirt's remote_node_get_cpu_map_args
type NodeGetCPUMapArgs struct {
	NeedMap int32
	NeedOnline int32
	Flags uint32
}

// NodeGetCPUMapRet is libvirt's remote_node_get_cpu_map_ret
type NodeGetCPUMapRet struct {
	Cpumap []byte
	Online uint32
	Ret int32
}

// DomainFstrimArgs is libvirt's remote_domain_fstrim_args
type DomainFstrimArgs struct {
	Dom Domain
	MountPoint OptString
	Minimum uint64
	Flags uint32
}

// DomainGetTimeArgs is libvirt's remote_domain_get_time_args
type DomainGetTimeArgs struct {
	Dom Domain
	Flags uint32
}

// DomainGetTimeRet is libvirt's remote_domain_get_time_ret
type DomainGetTimeRet struct {
	Seconds int64
	Nseconds uint32
}

// DomainSetTimeArgs is libvirt's remote_domain_set_time_args
type DomainSetTimeArgs struct {
	Dom Domain
	Seconds int64
	Nseconds uint32
	Flags DomainSetTimeFlags
}

// DomainMigrateBegin3ParamsArgs is libvirt's remote_domain_migrate_begin3_params_args
type DomainMigrateBegin3ParamsArgs struct {
	Dom Domain
	Params []TypedParam
	Flags uint32
}

// DomainMigrateBegin3ParamsRet is libvirt's remote_domain_migrate_begin3_params_ret
type DomainMigrateBegin3ParamsRet struct {
	CookieOut []byte
	XML string
}

// DomainMigratePrepare3ParamsArgs is libvirt's remote_domain_migrate_prepare3_params_args
type DomainMigratePrepare3ParamsArgs struct {
	Params []TypedParam
	CookieIn []byte
	Flags uint32
}

// DomainMigratePrepare3ParamsRet is libvirt's remote_domain_migrate_prepare3_params_ret
type DomainMigratePrepare3ParamsRet struct {
	CookieOut []byte
	UriOut OptString
}

// DomainMigratePrepareTunnel3ParamsArgs is libvirt's remote_domain_migrate_prepare_tunnel3_params_args
type DomainMigratePrepareTunnel3ParamsArgs struct {
	Params []TypedParam
	CookieIn []byte
	Flags uint32
}

// DomainMigratePrepareTunnel3ParamsRet is libvirt's remote_domain_migrate_prepare_tunnel3_params_ret
type DomainMigratePrepareTunnel3ParamsRet struct {
	CookieOut []byte
}

// DomainMigratePerform3ParamsArgs is libvirt's remote_domain_migrate_perform3_params_args
type DomainMigratePerform3ParamsArgs struct {
	Dom Domain
	Dconnuri OptString
	Params []TypedParam
	CookieIn []byte
	Flags DomainMigrateFlags
}

// DomainMigratePerform3ParamsRet is libvirt's remote_domain_migrate_perform3_params_ret
type DomainMigratePerform3ParamsRet struct {
	CookieOut []byte
}

// DomainMigrateFinish3ParamsArgs is libvirt's remote_domain_migrate_finish3_params_args
type DomainMigrateFinish3ParamsArgs struct {
	Params []TypedParam
	CookieIn []byte
	Flags uint32
	Cancelled int32
}

// DomainMigrateFinish3ParamsRet is libvirt's remote_domain_migrate_finish3_params_ret
type DomainMigrateFinish3ParamsRet struct {
	Dom Domain
	CookieOut []byte
}

// DomainMigrateConfirm3ParamsArgs is libvirt's remote_domain_migrate_confirm3_params_args
type DomainMigrateConfirm3ParamsArgs struct {
	Dom Domain
	Params []TypedParam
	CookieIn []byte
	Flags uint32
	Cancelled int32
}

// DomainEventDeviceRemovedMsg is libvirt's remote_domain_event_device_removed_msg
type DomainEventDeviceRemovedMsg struct {
	Dom Domain
	DevAlias string
}

// DomainEventCallbackDeviceRemovedMsg is libvirt's remote_domain_event_callback_device_removed_msg
type DomainEventCallbackDeviceRemovedMsg struct {
	CallbackID int32
	Msg DomainEventDeviceRemovedMsg
}

// DomainEventBlockJob2Msg is libvirt's remote_domain_event_block_job_2_msg
type DomainEventBlockJob2Msg struct {
	CallbackID int32
	Dom Domain
	Dst string
	Type int32
	Status int32
}

// DomainEventBlockThresholdMsg is libvirt's remote_domain_event_block_threshold_msg
type DomainEventBlockThresholdMsg struct {
	CallbackID int32
	Dom Domain
	Dev string
	Path OptString
	Threshold uint64
	Excess uint64
}

// DomainEventCallbackTunableMsg is libvirt's remote_domain_event_callback_tunable_msg
type DomainEventCallbackTunableMsg struct {
	CallbackID int32
	Dom Domain
	Params []TypedParam
}

// DomainEventCallbackDeviceAddedMsg is libvirt's remote_domain_event_callback_device_added_msg
type DomainEventCallbackDeviceAddedMsg struct {
	CallbackID int32
	Dom Domain
	DevAlias string
}

// ConnectEventConnectionClosedMsg is libvirt's remote_connect_event_connection_closed_msg
type ConnectEventConnectionClosedMsg struct {
	Reason int32
}

// ConnectGetCPUModelNamesArgs is libvirt's remote_connect_get_cpu_model_names_args
type ConnectGetCPUModelNamesArgs struct {
	Arch string
	NeedResults int32
	Flags uint32
}

// ConnectGetCPUModelNamesRet is libvirt's remote_connect_get_cpu_model_names_ret
type ConnectGetCPUModelNamesRet struct {
	Models []string
	Ret int32
}

// ConnectNetworkEventRegisterAnyArgs is libvirt's remote_connect_network_event_register_any_args
type ConnectNetworkEventRegisterAnyArgs struct {
	EventID int32
	Net OptNetwork
}

// ConnectNetworkEventRegisterAnyRet is libvirt's remote_connect_network_event_register_any_ret
type ConnectNetworkEventRegisterAnyRet struct {
	CallbackID int32
}

// ConnectNetworkEventDeregisterAnyArgs is libvirt's remote_connect_network_event_deregister_any_args
type ConnectNetworkEventDeregisterAnyArgs struct {
	CallbackID int32
}

// NetworkEventLifecycleMsg is libvirt's remote_network_event_lifecycle_msg
type NetworkEventLifecycleMsg struct {
	CallbackID int32
	Net Network
	Event int32
	Detail int32
}

// ConnectStoragePoolEventRegisterAnyArgs is libvirt's remote_connect_storage_pool_event_register_any_args
type ConnectStoragePoolEventRegisterAnyArgs struct {
	EventID int32
	Pool OptStoragePool
}

// ConnectStoragePoolEventRegisterAnyRet is libvirt's remote_connect_storage_pool_event_register_any_ret
type ConnectStoragePoolEventRegisterAnyRet struct {
	CallbackID int32
}

// ConnectStoragePoolEventDeregisterAnyArgs is libvirt's remote_connect_storage_pool_event_deregister_any_args
type ConnectStoragePoolEventDeregisterAnyArgs struct {
	CallbackID int32
}

// StoragePoolEventLifecycleMsg is libvirt's remote_storage_pool_event_lifecycle_msg
type StoragePoolEventLifecycleMsg struct {
	CallbackID int32
	Pool StoragePool
	Event int32
	Detail int32
}

// StoragePoolEventRefreshMsg is libvirt's remote_storage_pool_event_refresh_msg
type StoragePoolEventRefreshMsg struct {
	CallbackID int32
	Pool StoragePool
}

// ConnectNodeDeviceEventRegisterAnyArgs is libvirt's remote_connect_node_device_event_register_any_args
type ConnectNodeDeviceEventRegisterAnyArgs struct {
	EventID int32
	Dev OptNodeDevice
}

// ConnectNodeDeviceEventRegisterAnyRet is libvirt's remote_connect_node_device_event_register_any_ret
type ConnectNodeDeviceEventRegisterAnyRet struct {
	CallbackID int32
}

// ConnectNodeDeviceEventDeregisterAnyArgs is libvirt's remote_connect_node_device_event_deregister_any_args
type ConnectNodeDeviceEventDeregisterAnyArgs struct {
	CallbackID int32
}

// NodeDeviceEventLifecycleMsg is libvirt's remote_node_device_event_lifecycle_msg
type NodeDeviceEventLifecycleMsg struct {
	CallbackID int32
	Dev NodeDevice
	Event int32
	Detail int32
}

// NodeDeviceEventUpdateMsg is libvirt's remote_node_device_event_update_msg
type NodeDeviceEventUpdateMsg struct {
	CallbackID int32
	Dev NodeDevice
}

// DomainFsfreezeArgs is libvirt's remote_domain_fsfreeze_args
type DomainFsfreezeArgs struct {
	Dom Domain
	Mountpoints []string
	Flags uint32
}

// DomainFsfreezeRet is libvirt's remote_domain_fsfreeze_ret
type DomainFsfreezeRet struct {
	Filesystems int32
}

// DomainFsthawArgs is libvirt's remote_domain_fsthaw_args
type DomainFsthawArgs struct {
	Dom Domain
	Mountpoints []string
	Flags uint32
}

// DomainFsthawRet is libvirt's remote_domain_fsthaw_ret
type DomainFsthawRet struct {
	Filesystems int32
}

// NodeGetFreePagesArgs is libvirt's remote_node_get_free_pages_args
type NodeGetFreePagesArgs struct {
	Pages []uint32
	StartCell int32
	CellCount uint32
	Flags uint32
}

// NodeGetFreePagesRet is libvirt's remote_node_get_free_pages_ret
type NodeGetFreePagesRet struct {
	Counts []uint64
}

// NodeAllocPagesArgs is libvirt's remote_node_alloc_pages_args
type NodeAllocPagesArgs struct {
	PageSizes []uint32
	PageCounts []uint64
	StartCell int32
	CellCount uint32
	Flags NodeAllocPagesFlags
}

// NodeAllocPagesRet is libvirt's remote_node_alloc_pages_ret
type NodeAllocPagesRet struct {
	Ret int32
}

// NetworkDhcpLease is libvirt's remote_network_dhcp_lease
type NetworkDhcpLease struct {
	Iface string
	Expirytime int64
	Type int32
	Mac OptString
	Iaid OptString
	Ipaddr string
	Prefix uint32
	Hostname OptString
	Clientid OptString
}

// NetworkGetDhcpLeasesArgs is libvirt's remote_network_get_dhcp_leases_args
type NetworkGetDhcpLeasesArgs struct {
	Net Network
	Mac OptString
	NeedResults int32
	Flags uint32
}

// NetworkGetDhcpLeasesRet is libvirt's remote_network_get_dhcp_leases_ret
type NetworkGetDhcpLeasesRet struct {
	Leases []NetworkDhcpLease
	Ret uint32
}

// DomainStatsRecord is libvirt's remote_domain_stats_record
type DomainStatsRecord struct {
	Dom Domain
	Params []TypedParam
}

// ConnectGetAllDomainStatsArgs is libvirt's remote_connect_get_all_domain_stats_args
type ConnectGetAllDomainStatsArgs struct {
	Doms []Domain
	Stats uint32
	Flags ConnectGetAllDomainStatsFlags
}

// DomainEventCallbackAgentLifecycleMsg is libvirt's remote_domain_event_callback_agent_lifecycle_msg
type DomainEventCallbackAgentLifecycleMsg struct {
	CallbackID int32
	Dom Domain
	State int32
	Reason int32
}

// ConnectGetAllDomainStatsRet is libvirt's remote_connect_get_all_domain_stats_ret
type ConnectGetAllDomainStatsRet struct {
	RetStats []DomainStatsRecord
}

// DomainFsinfo is libvirt's remote_domain_fsinfo
type DomainFsinfo struct {
	Mountpoint string
	Name string
	Fstype string
	DevAliases []string
}

// DomainGetFsinfoArgs is libvirt's remote_domain_get_fsinfo_args
type DomainGetFsinfoArgs struct {
	Dom Domain
	Flags uint32
}

// DomainGetFsinfoRet is libvirt's remote_domain_get_fsinfo_ret
type DomainGetFsinfoRet struct {
	Info []DomainFsinfo
	Ret uint32
}

// DomainIPAddr is libvirt's remote_domain_ip_addr
type DomainIPAddr struct {
	Type int32
	Addr string
	Prefix uint32
}

// DomainInterface is libvirt's remote_domain_interface
type DomainInterface struct {
	Name string
	Hwaddr OptString
	Addrs []DomainIPAddr
}

// DomainInterfaceAddressesArgs is libvirt's remote_domain_interface_addresses_args
type DomainInterfaceAddressesArgs struct {
	Dom Domain
	Source uint32
	Flags uint32
}

// DomainInterfaceAddressesRet is libvirt's remote_domain_interface_addresses_ret
type DomainInterfaceAddressesRet struct {
	Ifaces []DomainInterface
}

// DomainSetUserPasswordArgs is libvirt's remote_domain_set_user_password_args
type DomainSetUserPasswordArgs struct {
	Dom Domain
	User OptString
	Password OptString
	Flags DomainSetUserPasswordFlags
}

// DomainRenameArgs is libvirt's remote_domain_rename_args
type DomainRenameArgs struct {
	Dom Domain
	NewName OptString
	Flags uint32
}

// DomainRenameRet is libvirt's remote_domain_rename_ret
type DomainRenameRet struct {
	Retcode int32
}

// DomainEventCallbackMigrationIterationMsg is libvirt's remote_domain_event_callback_migration_iteration_msg
type DomainEventCallbackMigrationIterationMsg struct {
	CallbackID int32
	Dom Domain
	Iteration int32
}

// DomainEventCallbackJobCompletedMsg is libvirt's remote_domain_event_callback_job_completed_msg
type DomainEventCallbackJobCompletedMsg struct {
	CallbackID int32
	Dom Domain
	Params []TypedParam
}

// DomainMigrateStartPostCopyArgs is libvirt's remote_domain_migrate_start_post_copy_args
type DomainMigrateStartPostCopyArgs struct {
	Dom Domain
	Flags uint32
}

// DomainEventCallbackDeviceRemovalFailedMsg is libvirt's remote_domain_event_callback_device_removal_failed_msg
type DomainEventCallbackDeviceRemovalFailedMsg struct {
	CallbackID int32
	Dom Domain
	DevAlias string
}

// DomainGetGuestVcpusArgs is libvirt's remote_domain_get_guest_vcpus_args
type DomainGetGuestVcpusArgs struct {
	Dom Domain
	Flags uint32
}

// DomainGetGuestVcpusRet is libvirt's remote_domain_get_guest_vcpus_ret
type DomainGetGuestVcpusRet struct {
	Params []TypedParam
}

// DomainSetGuestVcpusArgs is libvirt's remote_domain_set_guest_vcpus_args
type DomainSetGuestVcpusArgs struct {
	Dom Domain
	Cpumap string
	State int32
	Flags uint32
}

// DomainSetVcpuArgs is libvirt's remote_domain_set_vcpu_args
type DomainSetVcpuArgs struct {
	Dom Domain
	Cpumap string
	State int32
	Flags DomainModificationImpact
}

// DomainEventCallbackMetadataChangeMsg is libvirt's remote_domain_event_callback_metadata_change_msg
type DomainEventCallbackMetadataChangeMsg struct {
	CallbackID int32
	Dom Domain
	Type int32
	Nsuri OptString
}

// ConnectSecretEventRegisterAnyArgs is libvirt's remote_connect_secret_event_register_any_args
type ConnectSecretEventRegisterAnyArgs struct {
	EventID int32
	OptSecret OptSecret
}

// ConnectSecretEventRegisterAnyRet is libvirt's remote_connect_secret_event_register_any_ret
type ConnectSecretEventRegisterAnyRet struct {
	CallbackID int32
}

// ConnectSecretEventDeregisterAnyArgs is libvirt's remote_connect_secret_event_deregister_any_args
type ConnectSecretEventDeregisterAnyArgs struct {
	CallbackID int32
}

// SecretEventLifecycleMsg is libvirt's remote_secret_event_lifecycle_msg
type SecretEventLifecycleMsg struct {
	CallbackID int32
	OptSecret Secret
	Event int32
	Detail int32
}

// SecretEventValueChangedMsg is libvirt's remote_secret_event_value_changed_msg
type SecretEventValueChangedMsg struct {
	CallbackID int32
	OptSecret Secret
}

// DomainSetBlockThresholdArgs is libvirt's remote_domain_set_block_threshold_args
type DomainSetBlockThresholdArgs struct {
	Dom Domain
	Dev string
	Threshold uint64
	Flags uint32
}

// DomainSetLifecycleActionArgs is libvirt's remote_domain_set_lifecycle_action_args
type DomainSetLifecycleActionArgs struct {
	Dom Domain
	Type uint32
	Action uint32
	Flags DomainModificationImpact
}

// ConnectCompareHypervisorCPUArgs is libvirt's remote_connect_compare_hypervisor_cpu_args
type ConnectCompareHypervisorCPUArgs struct {
	Emulator OptString
	Arch OptString
	Machine OptString
	Virttype OptString
	XMLCPU string
	Flags uint32
}

// ConnectCompareHypervisorCPURet is libvirt's remote_connect_compare_hypervisor_cpu_ret
type ConnectCompareHypervisorCPURet struct {
	Result int32
}

// ConnectBaselineHypervisorCPUArgs is libvirt's remote_connect_baseline_hypervisor_cpu_args
type ConnectBaselineHypervisorCPUArgs struct {
	Emulator OptString
	Arch OptString
	Machine OptString
	Virttype OptString
	XMLCPUs []string
	Flags uint32
}

// ConnectBaselineHypervisorCPURet is libvirt's remote_connect_baseline_hypervisor_cpu_ret
type ConnectBaselineHypervisorCPURet struct {
	CPU string
}

// NodeGetSevInfoArgs is libvirt's remote_node_get_sev_info_args
type NodeGetSevInfoArgs struct {
	Nparams int32
	Flags uint32
}

// NodeGetSevInfoRet is libvirt's remote_node_get_sev_info_ret
type NodeGetSevInfoRet struct {
	Params []TypedParam
	Nparams int32
}

// DomainGetLaunchSecurityInfoArgs is libvirt's remote_domain_get_launch_security_info_args
type DomainGetLaunchSecurityInfoArgs struct {
	Dom Domain
	Flags uint32
}

// DomainGetLaunchSecurityInfoRet is libvirt's remote_domain_get_launch_security_info_ret
type DomainGetLaunchSecurityInfoRet struct {
	Params []TypedParam
}

// NwfilterBindingLookupByPortDevArgs is libvirt's remote_nwfilter_binding_lookup_by_port_dev_args
type NwfilterBindingLookupByPortDevArgs struct {
	Name string
}

// NwfilterBindingLookupByPortDevRet is libvirt's remote_nwfilter_binding_lookup_by_port_dev_ret
type NwfilterBindingLookupByPortDevRet struct {
	OptNwfilter NwfilterBinding
}

// NwfilterBindingCreateXMLArgs is libvirt's remote_nwfilter_binding_create_xml_args
type NwfilterBindingCreateXMLArgs struct {
	XML string
	Flags uint32
}

// NwfilterBindingCreateXMLRet is libvirt's remote_nwfilter_binding_create_xml_ret
type NwfilterBindingCreateXMLRet struct {
	OptNwfilter NwfilterBinding
}

// NwfilterBindingDeleteArgs is libvirt's remote_nwfilter_binding_delete_args
type NwfilterBindingDeleteArgs struct {
	OptNwfilter NwfilterBinding
}

// NwfilterBindingGetXMLDescArgs is libvirt's remote_nwfilter_binding_get_xml_desc_args
type NwfilterBindingGetXMLDescArgs struct {
	OptNwfilter NwfilterBinding
	Flags uint32
}

// NwfilterBindingGetXMLDescRet is libvirt's remote_nwfilter_binding_get_xml_desc_ret
type NwfilterBindingGetXMLDescRet struct {
	XML string
}

// ConnectListAllNwfilterBindingsArgs is libvirt's remote_connect_list_all_nwfilter_bindings_args
type ConnectListAllNwfilterBindingsArgs struct {
	NeedResults int32
	Flags uint32
}

// ConnectListAllNwfilterBindingsRet is libvirt's remote_connect_list_all_nwfilter_bindings_ret
type ConnectListAllNwfilterBindingsRet struct {
	Bindings []NwfilterBinding
	Ret uint32
}



// TypedParamValue is a discriminated union.
type TypedParamValue struct {
	D uint32
	I interface{}
}

// NewTypedParamValueInt creates a discriminated union value satisfying
// the TypedParamValue interface.
func NewTypedParamValueInt(v int32) *TypedParamValue {
	return &TypedParamValue{D: 1, I: v}
}

// NewTypedParamValueUint creates a discriminated union value satisfying
// the TypedParamValue interface.
func NewTypedParamValueUint(v uint32) *TypedParamValue {
	return &TypedParamValue{D: 2, I: v}
}

// NewTypedParamValueLlong creates a discriminated union value satisfying
// the TypedParamValue interface.
func NewTypedParamValueLlong(v int64) *TypedParamValue {
	return &TypedParamValue{D: 3, I: v}
}

// NewTypedParamValueUllong creates a discriminated union value satisfying
// the TypedParamValue interface.
func NewTypedParamValueUllong(v uint64) *TypedParamValue {
	return &TypedParamValue{D: 4, I: v}
}

// NewTypedParamValueDouble creates a discriminated union value satisfying
// the TypedParamValue interface.
func NewTypedParamValueDouble(v float64) *TypedParamValue {
	return &TypedParamValue{D: 5, I: v}
}

// NewTypedParamValueBoolean creates a discriminated union value satisfying
// the TypedParamValue interface.
func NewTypedParamValueBoolean(v int32) *TypedParamValue {
	return &TypedParamValue{D: 6, I: v}
}

// NewTypedParamValueString creates a discriminated union value satisfying
// the TypedParamValue interface.
func NewTypedParamValueString(v string) *TypedParamValue {
	return &TypedParamValue{D: 7, I: v}
}


// ConnectOpen is the go wrapper for REMOTE_PROC_CONNECT_OPEN.
func (l *Libvirt) ConnectOpen(Name OptString, Flags ConnectFlags) (err error) {
	var buf []byte

	args := ConnectOpenArgs {
		Name: Name,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(1, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// ConnectClose is the go wrapper for REMOTE_PROC_CONNECT_CLOSE.
func (l *Libvirt) ConnectClose() (err error) {
	var buf []byte


	_, err = l.requestStream(2, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// ConnectGetType is the go wrapper for REMOTE_PROC_CONNECT_GET_TYPE.
func (l *Libvirt) ConnectGetType() (rType string, err error) {
	var buf []byte

	var r response
	r, err = l.requestStream(3, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Type: string
	_, err = dec.Decode(&rType)
	if err != nil {
		return
	}

	return
}

// ConnectGetVersion is the go wrapper for REMOTE_PROC_CONNECT_GET_VERSION.
func (l *Libvirt) ConnectGetVersion() (rHvVer uint64, err error) {
	var buf []byte

	var r response
	r, err = l.requestStream(4, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// HvVer: uint64
	_, err = dec.Decode(&rHvVer)
	if err != nil {
		return
	}

	return
}

// ConnectGetMaxVcpus is the go wrapper for REMOTE_PROC_CONNECT_GET_MAX_VCPUS.
func (l *Libvirt) ConnectGetMaxVcpus(Type OptString) (rMaxVcpus int32, err error) {
	var buf []byte

	args := ConnectGetMaxVcpusArgs {
		Type: Type,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(5, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// MaxVcpus: int32
	_, err = dec.Decode(&rMaxVcpus)
	if err != nil {
		return
	}

	return
}

// NodeGetInfo is the go wrapper for REMOTE_PROC_NODE_GET_INFO.
func (l *Libvirt) NodeGetInfo() (rModel [32]int8, rMemory uint64, rCpus int32, rMhz int32, rNodes int32, rSockets int32, rCores int32, rThreads int32, err error) {
	var buf []byte

	var r response
	r, err = l.requestStream(6, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Model: [32]int8
	_, err = dec.Decode(&rModel)
	if err != nil {
		return
	}
	// Memory: uint64
	_, err = dec.Decode(&rMemory)
	if err != nil {
		return
	}
	// Cpus: int32
	_, err = dec.Decode(&rCpus)
	if err != nil {
		return
	}
	// Mhz: int32
	_, err = dec.Decode(&rMhz)
	if err != nil {
		return
	}
	// Nodes: int32
	_, err = dec.Decode(&rNodes)
	if err != nil {
		return
	}
	// Sockets: int32
	_, err = dec.Decode(&rSockets)
	if err != nil {
		return
	}
	// Cores: int32
	_, err = dec.Decode(&rCores)
	if err != nil {
		return
	}
	// Threads: int32
	_, err = dec.Decode(&rThreads)
	if err != nil {
		return
	}

	return
}

// ConnectGetCapabilities is the go wrapper for REMOTE_PROC_CONNECT_GET_CAPABILITIES.
func (l *Libvirt) ConnectGetCapabilities() (rCapabilities string, err error) {
	var buf []byte

	var r response
	r, err = l.requestStream(7, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Capabilities: string
	_, err = dec.Decode(&rCapabilities)
	if err != nil {
		return
	}

	return
}

// DomainAttachDevice is the go wrapper for REMOTE_PROC_DOMAIN_ATTACH_DEVICE.
func (l *Libvirt) DomainAttachDevice(Dom Domain, XML string) (err error) {
	var buf []byte

	args := DomainAttachDeviceArgs {
		Dom: Dom,
		XML: XML,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(8, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainCreate is the go wrapper for REMOTE_PROC_DOMAIN_CREATE.
func (l *Libvirt) DomainCreate(Dom Domain) (err error) {
	var buf []byte

	args := DomainCreateArgs {
		Dom: Dom,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(9, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainCreateXML is the go wrapper for REMOTE_PROC_DOMAIN_CREATE_XML.
func (l *Libvirt) DomainCreateXML(XMLDesc string, Flags DomainCreateFlags) (rDom Domain, err error) {
	var buf []byte

	args := DomainCreateXMLArgs {
		XMLDesc: XMLDesc,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(10, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Dom: Domain
	_, err = dec.Decode(&rDom)
	if err != nil {
		return
	}

	return
}

// DomainDefineXML is the go wrapper for REMOTE_PROC_DOMAIN_DEFINE_XML.
func (l *Libvirt) DomainDefineXML(XML string) (rDom Domain, err error) {
	var buf []byte

	args := DomainDefineXMLArgs {
		XML: XML,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(11, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Dom: Domain
	_, err = dec.Decode(&rDom)
	if err != nil {
		return
	}

	return
}

// DomainDestroy is the go wrapper for REMOTE_PROC_DOMAIN_DESTROY.
func (l *Libvirt) DomainDestroy(Dom Domain) (err error) {
	var buf []byte

	args := DomainDestroyArgs {
		Dom: Dom,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(12, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainDetachDevice is the go wrapper for REMOTE_PROC_DOMAIN_DETACH_DEVICE.
func (l *Libvirt) DomainDetachDevice(Dom Domain, XML string) (err error) {
	var buf []byte

	args := DomainDetachDeviceArgs {
		Dom: Dom,
		XML: XML,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(13, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainGetXMLDesc is the go wrapper for REMOTE_PROC_DOMAIN_GET_XML_DESC.
func (l *Libvirt) DomainGetXMLDesc(Dom Domain, Flags DomainXMLFlags) (rXML string, err error) {
	var buf []byte

	args := DomainGetXMLDescArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(14, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// XML: string
	_, err = dec.Decode(&rXML)
	if err != nil {
		return
	}

	return
}

// DomainGetAutostart is the go wrapper for REMOTE_PROC_DOMAIN_GET_AUTOSTART.
func (l *Libvirt) DomainGetAutostart(Dom Domain) (rAutostart int32, err error) {
	var buf []byte

	args := DomainGetAutostartArgs {
		Dom: Dom,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(15, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Autostart: int32
	_, err = dec.Decode(&rAutostart)
	if err != nil {
		return
	}

	return
}

// DomainGetInfo is the go wrapper for REMOTE_PROC_DOMAIN_GET_INFO.
func (l *Libvirt) DomainGetInfo(Dom Domain) (rState uint8, rMaxMem uint64, rMemory uint64, rNrVirtCPU uint16, rCPUTime uint64, err error) {
	var buf []byte

	args := DomainGetInfoArgs {
		Dom: Dom,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(16, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// State: uint8
	_, err = dec.Decode(&rState)
	if err != nil {
		return
	}
	// MaxMem: uint64
	_, err = dec.Decode(&rMaxMem)
	if err != nil {
		return
	}
	// Memory: uint64
	_, err = dec.Decode(&rMemory)
	if err != nil {
		return
	}
	// NrVirtCPU: uint16
	_, err = dec.Decode(&rNrVirtCPU)
	if err != nil {
		return
	}
	// CPUTime: uint64
	_, err = dec.Decode(&rCPUTime)
	if err != nil {
		return
	}

	return
}

// DomainGetMaxMemory is the go wrapper for REMOTE_PROC_DOMAIN_GET_MAX_MEMORY.
func (l *Libvirt) DomainGetMaxMemory(Dom Domain) (rMemory uint64, err error) {
	var buf []byte

	args := DomainGetMaxMemoryArgs {
		Dom: Dom,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(17, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Memory: uint64
	_, err = dec.Decode(&rMemory)
	if err != nil {
		return
	}

	return
}

// DomainGetMaxVcpus is the go wrapper for REMOTE_PROC_DOMAIN_GET_MAX_VCPUS.
func (l *Libvirt) DomainGetMaxVcpus(Dom Domain) (rNum int32, err error) {
	var buf []byte

	args := DomainGetMaxVcpusArgs {
		Dom: Dom,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(18, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Num: int32
	_, err = dec.Decode(&rNum)
	if err != nil {
		return
	}

	return
}

// DomainGetOsType is the go wrapper for REMOTE_PROC_DOMAIN_GET_OS_TYPE.
func (l *Libvirt) DomainGetOsType(Dom Domain) (rType string, err error) {
	var buf []byte

	args := DomainGetOsTypeArgs {
		Dom: Dom,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(19, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Type: string
	_, err = dec.Decode(&rType)
	if err != nil {
		return
	}

	return
}

// DomainGetVcpus is the go wrapper for REMOTE_PROC_DOMAIN_GET_VCPUS.
func (l *Libvirt) DomainGetVcpus(Dom Domain, Maxinfo int32, Maplen int32) (rInfo []VcpuInfo, rCpumaps []byte, err error) {
	var buf []byte

	args := DomainGetVcpusArgs {
		Dom: Dom,
		Maxinfo: Maxinfo,
		Maplen: Maplen,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(20, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Info: []VcpuInfo
	_, err = dec.Decode(&rInfo)
	if err != nil {
		return
	}
	// Cpumaps: []byte
	_, err = dec.Decode(&rCpumaps)
	if err != nil {
		return
	}

	return
}

// ConnectListDefinedDomains is the go wrapper for REMOTE_PROC_CONNECT_LIST_DEFINED_DOMAINS.
func (l *Libvirt) ConnectListDefinedDomains(Maxnames int32) (rNames []string, err error) {
	var buf []byte

	args := ConnectListDefinedDomainsArgs {
		Maxnames: Maxnames,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(21, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Names: []string
	_, err = dec.Decode(&rNames)
	if err != nil {
		return
	}

	return
}

// DomainLookupByID is the go wrapper for REMOTE_PROC_DOMAIN_LOOKUP_BY_ID.
func (l *Libvirt) DomainLookupByID(ID int32) (rDom Domain, err error) {
	var buf []byte

	args := DomainLookupByIDArgs {
		ID: ID,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(22, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Dom: Domain
	_, err = dec.Decode(&rDom)
	if err != nil {
		return
	}

	return
}

// DomainLookupByName is the go wrapper for REMOTE_PROC_DOMAIN_LOOKUP_BY_NAME.
func (l *Libvirt) DomainLookupByName(Name string) (rDom Domain, err error) {
	var buf []byte

	args := DomainLookupByNameArgs {
		Name: Name,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(23, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Dom: Domain
	_, err = dec.Decode(&rDom)
	if err != nil {
		return
	}

	return
}

// DomainLookupByUUID is the go wrapper for REMOTE_PROC_DOMAIN_LOOKUP_BY_UUID.
func (l *Libvirt) DomainLookupByUUID(UUID UUID) (rDom Domain, err error) {
	var buf []byte

	args := DomainLookupByUUIDArgs {
		UUID: UUID,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(24, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Dom: Domain
	_, err = dec.Decode(&rDom)
	if err != nil {
		return
	}

	return
}

// ConnectNumOfDefinedDomains is the go wrapper for REMOTE_PROC_CONNECT_NUM_OF_DEFINED_DOMAINS.
func (l *Libvirt) ConnectNumOfDefinedDomains() (rNum int32, err error) {
	var buf []byte

	var r response
	r, err = l.requestStream(25, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Num: int32
	_, err = dec.Decode(&rNum)
	if err != nil {
		return
	}

	return
}

// DomainPinVcpu is the go wrapper for REMOTE_PROC_DOMAIN_PIN_VCPU.
func (l *Libvirt) DomainPinVcpu(Dom Domain, Vcpu uint32, Cpumap []byte) (err error) {
	var buf []byte

	args := DomainPinVcpuArgs {
		Dom: Dom,
		Vcpu: Vcpu,
		Cpumap: Cpumap,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(26, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainReboot is the go wrapper for REMOTE_PROC_DOMAIN_REBOOT.
func (l *Libvirt) DomainReboot(Dom Domain, Flags DomainRebootFlagValues) (err error) {
	var buf []byte

	args := DomainRebootArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(27, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainResume is the go wrapper for REMOTE_PROC_DOMAIN_RESUME.
func (l *Libvirt) DomainResume(Dom Domain) (err error) {
	var buf []byte

	args := DomainResumeArgs {
		Dom: Dom,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(28, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainSetAutostart is the go wrapper for REMOTE_PROC_DOMAIN_SET_AUTOSTART.
func (l *Libvirt) DomainSetAutostart(Dom Domain, Autostart int32) (err error) {
	var buf []byte

	args := DomainSetAutostartArgs {
		Dom: Dom,
		Autostart: Autostart,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(29, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainSetMaxMemory is the go wrapper for REMOTE_PROC_DOMAIN_SET_MAX_MEMORY.
func (l *Libvirt) DomainSetMaxMemory(Dom Domain, Memory uint64) (err error) {
	var buf []byte

	args := DomainSetMaxMemoryArgs {
		Dom: Dom,
		Memory: Memory,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(30, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainSetMemory is the go wrapper for REMOTE_PROC_DOMAIN_SET_MEMORY.
func (l *Libvirt) DomainSetMemory(Dom Domain, Memory uint64) (err error) {
	var buf []byte

	args := DomainSetMemoryArgs {
		Dom: Dom,
		Memory: Memory,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(31, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainSetVcpus is the go wrapper for REMOTE_PROC_DOMAIN_SET_VCPUS.
func (l *Libvirt) DomainSetVcpus(Dom Domain, Nvcpus uint32) (err error) {
	var buf []byte

	args := DomainSetVcpusArgs {
		Dom: Dom,
		Nvcpus: Nvcpus,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(32, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainShutdown is the go wrapper for REMOTE_PROC_DOMAIN_SHUTDOWN.
func (l *Libvirt) DomainShutdown(Dom Domain) (err error) {
	var buf []byte

	args := DomainShutdownArgs {
		Dom: Dom,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(33, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainSuspend is the go wrapper for REMOTE_PROC_DOMAIN_SUSPEND.
func (l *Libvirt) DomainSuspend(Dom Domain) (err error) {
	var buf []byte

	args := DomainSuspendArgs {
		Dom: Dom,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(34, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainUndefine is the go wrapper for REMOTE_PROC_DOMAIN_UNDEFINE.
func (l *Libvirt) DomainUndefine(Dom Domain) (err error) {
	var buf []byte

	args := DomainUndefineArgs {
		Dom: Dom,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(35, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// ConnectListDefinedNetworks is the go wrapper for REMOTE_PROC_CONNECT_LIST_DEFINED_NETWORKS.
func (l *Libvirt) ConnectListDefinedNetworks(Maxnames int32) (rNames []string, err error) {
	var buf []byte

	args := ConnectListDefinedNetworksArgs {
		Maxnames: Maxnames,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(36, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Names: []string
	_, err = dec.Decode(&rNames)
	if err != nil {
		return
	}

	return
}

// ConnectListDomains is the go wrapper for REMOTE_PROC_CONNECT_LIST_DOMAINS.
func (l *Libvirt) ConnectListDomains(Maxids int32) (rIds []int32, err error) {
	var buf []byte

	args := ConnectListDomainsArgs {
		Maxids: Maxids,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(37, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Ids: []int32
	_, err = dec.Decode(&rIds)
	if err != nil {
		return
	}

	return
}

// ConnectListNetworks is the go wrapper for REMOTE_PROC_CONNECT_LIST_NETWORKS.
func (l *Libvirt) ConnectListNetworks(Maxnames int32) (rNames []string, err error) {
	var buf []byte

	args := ConnectListNetworksArgs {
		Maxnames: Maxnames,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(38, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Names: []string
	_, err = dec.Decode(&rNames)
	if err != nil {
		return
	}

	return
}

// NetworkCreate is the go wrapper for REMOTE_PROC_NETWORK_CREATE.
func (l *Libvirt) NetworkCreate(Net Network) (err error) {
	var buf []byte

	args := NetworkCreateArgs {
		Net: Net,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(39, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// NetworkCreateXML is the go wrapper for REMOTE_PROC_NETWORK_CREATE_XML.
func (l *Libvirt) NetworkCreateXML(XML string) (rNet Network, err error) {
	var buf []byte

	args := NetworkCreateXMLArgs {
		XML: XML,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(40, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Net: Network
	_, err = dec.Decode(&rNet)
	if err != nil {
		return
	}

	return
}

// NetworkDefineXML is the go wrapper for REMOTE_PROC_NETWORK_DEFINE_XML.
func (l *Libvirt) NetworkDefineXML(XML string) (rNet Network, err error) {
	var buf []byte

	args := NetworkDefineXMLArgs {
		XML: XML,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(41, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Net: Network
	_, err = dec.Decode(&rNet)
	if err != nil {
		return
	}

	return
}

// NetworkDestroy is the go wrapper for REMOTE_PROC_NETWORK_DESTROY.
func (l *Libvirt) NetworkDestroy(Net Network) (err error) {
	var buf []byte

	args := NetworkDestroyArgs {
		Net: Net,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(42, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// NetworkGetXMLDesc is the go wrapper for REMOTE_PROC_NETWORK_GET_XML_DESC.
func (l *Libvirt) NetworkGetXMLDesc(Net Network, Flags uint32) (rXML string, err error) {
	var buf []byte

	args := NetworkGetXMLDescArgs {
		Net: Net,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(43, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// XML: string
	_, err = dec.Decode(&rXML)
	if err != nil {
		return
	}

	return
}

// NetworkGetAutostart is the go wrapper for REMOTE_PROC_NETWORK_GET_AUTOSTART.
func (l *Libvirt) NetworkGetAutostart(Net Network) (rAutostart int32, err error) {
	var buf []byte

	args := NetworkGetAutostartArgs {
		Net: Net,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(44, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Autostart: int32
	_, err = dec.Decode(&rAutostart)
	if err != nil {
		return
	}

	return
}

// NetworkGetBridgeName is the go wrapper for REMOTE_PROC_NETWORK_GET_BRIDGE_NAME.
func (l *Libvirt) NetworkGetBridgeName(Net Network) (rName string, err error) {
	var buf []byte

	args := NetworkGetBridgeNameArgs {
		Net: Net,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(45, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Name: string
	_, err = dec.Decode(&rName)
	if err != nil {
		return
	}

	return
}

// NetworkLookupByName is the go wrapper for REMOTE_PROC_NETWORK_LOOKUP_BY_NAME.
func (l *Libvirt) NetworkLookupByName(Name string) (rNet Network, err error) {
	var buf []byte

	args := NetworkLookupByNameArgs {
		Name: Name,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(46, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Net: Network
	_, err = dec.Decode(&rNet)
	if err != nil {
		return
	}

	return
}

// NetworkLookupByUUID is the go wrapper for REMOTE_PROC_NETWORK_LOOKUP_BY_UUID.
func (l *Libvirt) NetworkLookupByUUID(UUID UUID) (rNet Network, err error) {
	var buf []byte

	args := NetworkLookupByUUIDArgs {
		UUID: UUID,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(47, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Net: Network
	_, err = dec.Decode(&rNet)
	if err != nil {
		return
	}

	return
}

// NetworkSetAutostart is the go wrapper for REMOTE_PROC_NETWORK_SET_AUTOSTART.
func (l *Libvirt) NetworkSetAutostart(Net Network, Autostart int32) (err error) {
	var buf []byte

	args := NetworkSetAutostartArgs {
		Net: Net,
		Autostart: Autostart,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(48, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// NetworkUndefine is the go wrapper for REMOTE_PROC_NETWORK_UNDEFINE.
func (l *Libvirt) NetworkUndefine(Net Network) (err error) {
	var buf []byte

	args := NetworkUndefineArgs {
		Net: Net,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(49, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// ConnectNumOfDefinedNetworks is the go wrapper for REMOTE_PROC_CONNECT_NUM_OF_DEFINED_NETWORKS.
func (l *Libvirt) ConnectNumOfDefinedNetworks() (rNum int32, err error) {
	var buf []byte

	var r response
	r, err = l.requestStream(50, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Num: int32
	_, err = dec.Decode(&rNum)
	if err != nil {
		return
	}

	return
}

// ConnectNumOfDomains is the go wrapper for REMOTE_PROC_CONNECT_NUM_OF_DOMAINS.
func (l *Libvirt) ConnectNumOfDomains() (rNum int32, err error) {
	var buf []byte

	var r response
	r, err = l.requestStream(51, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Num: int32
	_, err = dec.Decode(&rNum)
	if err != nil {
		return
	}

	return
}

// ConnectNumOfNetworks is the go wrapper for REMOTE_PROC_CONNECT_NUM_OF_NETWORKS.
func (l *Libvirt) ConnectNumOfNetworks() (rNum int32, err error) {
	var buf []byte

	var r response
	r, err = l.requestStream(52, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Num: int32
	_, err = dec.Decode(&rNum)
	if err != nil {
		return
	}

	return
}

// DomainCoreDump is the go wrapper for REMOTE_PROC_DOMAIN_CORE_DUMP.
func (l *Libvirt) DomainCoreDump(Dom Domain, To string, Flags DomainCoreDumpFlags) (err error) {
	var buf []byte

	args := DomainCoreDumpArgs {
		Dom: Dom,
		To: To,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(53, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainRestore is the go wrapper for REMOTE_PROC_DOMAIN_RESTORE.
func (l *Libvirt) DomainRestore(From string) (err error) {
	var buf []byte

	args := DomainRestoreArgs {
		From: From,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(54, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainSave is the go wrapper for REMOTE_PROC_DOMAIN_SAVE.
func (l *Libvirt) DomainSave(Dom Domain, To string) (err error) {
	var buf []byte

	args := DomainSaveArgs {
		Dom: Dom,
		To: To,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(55, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainGetSchedulerType is the go wrapper for REMOTE_PROC_DOMAIN_GET_SCHEDULER_TYPE.
func (l *Libvirt) DomainGetSchedulerType(Dom Domain) (rType string, rNparams int32, err error) {
	var buf []byte

	args := DomainGetSchedulerTypeArgs {
		Dom: Dom,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(56, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Type: string
	_, err = dec.Decode(&rType)
	if err != nil {
		return
	}
	// Nparams: int32
	_, err = dec.Decode(&rNparams)
	if err != nil {
		return
	}

	return
}

// DomainGetSchedulerParameters is the go wrapper for REMOTE_PROC_DOMAIN_GET_SCHEDULER_PARAMETERS.
func (l *Libvirt) DomainGetSchedulerParameters(Dom Domain, Nparams int32) (rParams []TypedParam, err error) {
	var buf []byte

	args := DomainGetSchedulerParametersArgs {
		Dom: Dom,
		Nparams: Nparams,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(57, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Params: []TypedParam
	_, err = dec.Decode(&rParams)
	if err != nil {
		return
	}

	return
}

// DomainSetSchedulerParameters is the go wrapper for REMOTE_PROC_DOMAIN_SET_SCHEDULER_PARAMETERS.
func (l *Libvirt) DomainSetSchedulerParameters(Dom Domain, Params []TypedParam) (err error) {
	var buf []byte

	args := DomainSetSchedulerParametersArgs {
		Dom: Dom,
		Params: Params,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(58, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// ConnectGetHostname is the go wrapper for REMOTE_PROC_CONNECT_GET_HOSTNAME.
func (l *Libvirt) ConnectGetHostname() (rHostname string, err error) {
	var buf []byte

	var r response
	r, err = l.requestStream(59, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Hostname: string
	_, err = dec.Decode(&rHostname)
	if err != nil {
		return
	}

	return
}

// ConnectSupportsFeature is the go wrapper for REMOTE_PROC_CONNECT_SUPPORTS_FEATURE.
func (l *Libvirt) ConnectSupportsFeature(Feature int32) (rSupported int32, err error) {
	var buf []byte

	args := ConnectSupportsFeatureArgs {
		Feature: Feature,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(60, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Supported: int32
	_, err = dec.Decode(&rSupported)
	if err != nil {
		return
	}

	return
}

// DomainMigratePrepare is the go wrapper for REMOTE_PROC_DOMAIN_MIGRATE_PREPARE.
func (l *Libvirt) DomainMigratePrepare(UriIn OptString, Flags uint64, Dname OptString, Resource uint64) (rCookie []byte, rUriOut OptString, err error) {
	var buf []byte

	args := DomainMigratePrepareArgs {
		UriIn: UriIn,
		Flags: Flags,
		Dname: Dname,
		Resource: Resource,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(61, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Cookie: []byte
	_, err = dec.Decode(&rCookie)
	if err != nil {
		return
	}
	// UriOut: OptString
	_, err = dec.Decode(&rUriOut)
	if err != nil {
		return
	}

	return
}

// DomainMigratePerform is the go wrapper for REMOTE_PROC_DOMAIN_MIGRATE_PERFORM.
func (l *Libvirt) DomainMigratePerform(Dom Domain, Cookie []byte, Uri string, Flags uint64, Dname OptString, Resource uint64) (err error) {
	var buf []byte

	args := DomainMigratePerformArgs {
		Dom: Dom,
		Cookie: Cookie,
		Uri: Uri,
		Flags: Flags,
		Dname: Dname,
		Resource: Resource,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(62, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainMigrateFinish is the go wrapper for REMOTE_PROC_DOMAIN_MIGRATE_FINISH.
func (l *Libvirt) DomainMigrateFinish(Dname string, Cookie []byte, Uri string, Flags uint64) (rDdom Domain, err error) {
	var buf []byte

	args := DomainMigrateFinishArgs {
		Dname: Dname,
		Cookie: Cookie,
		Uri: Uri,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(63, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Ddom: Domain
	_, err = dec.Decode(&rDdom)
	if err != nil {
		return
	}

	return
}

// DomainBlockStats is the go wrapper for REMOTE_PROC_DOMAIN_BLOCK_STATS.
func (l *Libvirt) DomainBlockStats(Dom Domain, Path string) (rRdReq int64, rRdBytes int64, rWrReq int64, rWrBytes int64, rErrs int64, err error) {
	var buf []byte

	args := DomainBlockStatsArgs {
		Dom: Dom,
		Path: Path,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(64, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// RdReq: int64
	_, err = dec.Decode(&rRdReq)
	if err != nil {
		return
	}
	// RdBytes: int64
	_, err = dec.Decode(&rRdBytes)
	if err != nil {
		return
	}
	// WrReq: int64
	_, err = dec.Decode(&rWrReq)
	if err != nil {
		return
	}
	// WrBytes: int64
	_, err = dec.Decode(&rWrBytes)
	if err != nil {
		return
	}
	// Errs: int64
	_, err = dec.Decode(&rErrs)
	if err != nil {
		return
	}

	return
}

// DomainInterfaceStats is the go wrapper for REMOTE_PROC_DOMAIN_INTERFACE_STATS.
func (l *Libvirt) DomainInterfaceStats(Dom Domain, Device string) (rRxBytes int64, rRxPackets int64, rRxErrs int64, rRxDrop int64, rTxBytes int64, rTxPackets int64, rTxErrs int64, rTxDrop int64, err error) {
	var buf []byte

	args := DomainInterfaceStatsArgs {
		Dom: Dom,
		Device: Device,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(65, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// RxBytes: int64
	_, err = dec.Decode(&rRxBytes)
	if err != nil {
		return
	}
	// RxPackets: int64
	_, err = dec.Decode(&rRxPackets)
	if err != nil {
		return
	}
	// RxErrs: int64
	_, err = dec.Decode(&rRxErrs)
	if err != nil {
		return
	}
	// RxDrop: int64
	_, err = dec.Decode(&rRxDrop)
	if err != nil {
		return
	}
	// TxBytes: int64
	_, err = dec.Decode(&rTxBytes)
	if err != nil {
		return
	}
	// TxPackets: int64
	_, err = dec.Decode(&rTxPackets)
	if err != nil {
		return
	}
	// TxErrs: int64
	_, err = dec.Decode(&rTxErrs)
	if err != nil {
		return
	}
	// TxDrop: int64
	_, err = dec.Decode(&rTxDrop)
	if err != nil {
		return
	}

	return
}

// AuthList is the go wrapper for REMOTE_PROC_AUTH_LIST.
func (l *Libvirt) AuthList() (rTypes []AuthType, err error) {
	var buf []byte

	var r response
	r, err = l.requestStream(66, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Types: []AuthType
	_, err = dec.Decode(&rTypes)
	if err != nil {
		return
	}

	return
}

// AuthSaslInit is the go wrapper for REMOTE_PROC_AUTH_SASL_INIT.
func (l *Libvirt) AuthSaslInit() (rMechlist string, err error) {
	var buf []byte

	var r response
	r, err = l.requestStream(67, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Mechlist: string
	_, err = dec.Decode(&rMechlist)
	if err != nil {
		return
	}

	return
}

// AuthSaslStart is the go wrapper for REMOTE_PROC_AUTH_SASL_START.
func (l *Libvirt) AuthSaslStart(Mech string, Nil int32, Data []int8) (rComplete int32, rNil int32, rData []int8, err error) {
	var buf []byte

	args := AuthSaslStartArgs {
		Mech: Mech,
		Nil: Nil,
		Data: Data,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(68, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Complete: int32
	_, err = dec.Decode(&rComplete)
	if err != nil {
		return
	}
	// Nil: int32
	_, err = dec.Decode(&rNil)
	if err != nil {
		return
	}
	// Data: []int8
	_, err = dec.Decode(&rData)
	if err != nil {
		return
	}

	return
}

// AuthSaslStep is the go wrapper for REMOTE_PROC_AUTH_SASL_STEP.
func (l *Libvirt) AuthSaslStep(Nil int32, Data []int8) (rComplete int32, rNil int32, rData []int8, err error) {
	var buf []byte

	args := AuthSaslStepArgs {
		Nil: Nil,
		Data: Data,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(69, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Complete: int32
	_, err = dec.Decode(&rComplete)
	if err != nil {
		return
	}
	// Nil: int32
	_, err = dec.Decode(&rNil)
	if err != nil {
		return
	}
	// Data: []int8
	_, err = dec.Decode(&rData)
	if err != nil {
		return
	}

	return
}

// AuthPolkit is the go wrapper for REMOTE_PROC_AUTH_POLKIT.
func (l *Libvirt) AuthPolkit() (rComplete int32, err error) {
	var buf []byte

	var r response
	r, err = l.requestStream(70, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Complete: int32
	_, err = dec.Decode(&rComplete)
	if err != nil {
		return
	}

	return
}

// ConnectNumOfStoragePools is the go wrapper for REMOTE_PROC_CONNECT_NUM_OF_STORAGE_POOLS.
func (l *Libvirt) ConnectNumOfStoragePools() (rNum int32, err error) {
	var buf []byte

	var r response
	r, err = l.requestStream(71, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Num: int32
	_, err = dec.Decode(&rNum)
	if err != nil {
		return
	}

	return
}

// ConnectListStoragePools is the go wrapper for REMOTE_PROC_CONNECT_LIST_STORAGE_POOLS.
func (l *Libvirt) ConnectListStoragePools(Maxnames int32) (rNames []string, err error) {
	var buf []byte

	args := ConnectListStoragePoolsArgs {
		Maxnames: Maxnames,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(72, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Names: []string
	_, err = dec.Decode(&rNames)
	if err != nil {
		return
	}

	return
}

// ConnectNumOfDefinedStoragePools is the go wrapper for REMOTE_PROC_CONNECT_NUM_OF_DEFINED_STORAGE_POOLS.
func (l *Libvirt) ConnectNumOfDefinedStoragePools() (rNum int32, err error) {
	var buf []byte

	var r response
	r, err = l.requestStream(73, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Num: int32
	_, err = dec.Decode(&rNum)
	if err != nil {
		return
	}

	return
}

// ConnectListDefinedStoragePools is the go wrapper for REMOTE_PROC_CONNECT_LIST_DEFINED_STORAGE_POOLS.
func (l *Libvirt) ConnectListDefinedStoragePools(Maxnames int32) (rNames []string, err error) {
	var buf []byte

	args := ConnectListDefinedStoragePoolsArgs {
		Maxnames: Maxnames,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(74, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Names: []string
	_, err = dec.Decode(&rNames)
	if err != nil {
		return
	}

	return
}

// ConnectFindStoragePoolSources is the go wrapper for REMOTE_PROC_CONNECT_FIND_STORAGE_POOL_SOURCES.
func (l *Libvirt) ConnectFindStoragePoolSources(Type string, SrcSpec OptString, Flags uint32) (rXML string, err error) {
	var buf []byte

	args := ConnectFindStoragePoolSourcesArgs {
		Type: Type,
		SrcSpec: SrcSpec,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(75, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// XML: string
	_, err = dec.Decode(&rXML)
	if err != nil {
		return
	}

	return
}

// StoragePoolCreateXML is the go wrapper for REMOTE_PROC_STORAGE_POOL_CREATE_XML.
func (l *Libvirt) StoragePoolCreateXML(XML string, Flags StoragePoolCreateFlags) (rPool StoragePool, err error) {
	var buf []byte

	args := StoragePoolCreateXMLArgs {
		XML: XML,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(76, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Pool: StoragePool
	_, err = dec.Decode(&rPool)
	if err != nil {
		return
	}

	return
}

// StoragePoolDefineXML is the go wrapper for REMOTE_PROC_STORAGE_POOL_DEFINE_XML.
func (l *Libvirt) StoragePoolDefineXML(XML string, Flags uint32) (rPool StoragePool, err error) {
	var buf []byte

	args := StoragePoolDefineXMLArgs {
		XML: XML,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(77, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Pool: StoragePool
	_, err = dec.Decode(&rPool)
	if err != nil {
		return
	}

	return
}

// StoragePoolCreate is the go wrapper for REMOTE_PROC_STORAGE_POOL_CREATE.
func (l *Libvirt) StoragePoolCreate(Pool StoragePool, Flags StoragePoolCreateFlags) (err error) {
	var buf []byte

	args := StoragePoolCreateArgs {
		Pool: Pool,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(78, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// StoragePoolBuild is the go wrapper for REMOTE_PROC_STORAGE_POOL_BUILD.
func (l *Libvirt) StoragePoolBuild(Pool StoragePool, Flags StoragePoolBuildFlags) (err error) {
	var buf []byte

	args := StoragePoolBuildArgs {
		Pool: Pool,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(79, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// StoragePoolDestroy is the go wrapper for REMOTE_PROC_STORAGE_POOL_DESTROY.
func (l *Libvirt) StoragePoolDestroy(Pool StoragePool) (err error) {
	var buf []byte

	args := StoragePoolDestroyArgs {
		Pool: Pool,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(80, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// StoragePoolDelete is the go wrapper for REMOTE_PROC_STORAGE_POOL_DELETE.
func (l *Libvirt) StoragePoolDelete(Pool StoragePool, Flags StoragePoolDeleteFlags) (err error) {
	var buf []byte

	args := StoragePoolDeleteArgs {
		Pool: Pool,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(81, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// StoragePoolUndefine is the go wrapper for REMOTE_PROC_STORAGE_POOL_UNDEFINE.
func (l *Libvirt) StoragePoolUndefine(Pool StoragePool) (err error) {
	var buf []byte

	args := StoragePoolUndefineArgs {
		Pool: Pool,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(82, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// StoragePoolRefresh is the go wrapper for REMOTE_PROC_STORAGE_POOL_REFRESH.
func (l *Libvirt) StoragePoolRefresh(Pool StoragePool, Flags uint32) (err error) {
	var buf []byte

	args := StoragePoolRefreshArgs {
		Pool: Pool,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(83, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// StoragePoolLookupByName is the go wrapper for REMOTE_PROC_STORAGE_POOL_LOOKUP_BY_NAME.
func (l *Libvirt) StoragePoolLookupByName(Name string) (rPool StoragePool, err error) {
	var buf []byte

	args := StoragePoolLookupByNameArgs {
		Name: Name,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(84, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Pool: StoragePool
	_, err = dec.Decode(&rPool)
	if err != nil {
		return
	}

	return
}

// StoragePoolLookupByUUID is the go wrapper for REMOTE_PROC_STORAGE_POOL_LOOKUP_BY_UUID.
func (l *Libvirt) StoragePoolLookupByUUID(UUID UUID) (rPool StoragePool, err error) {
	var buf []byte

	args := StoragePoolLookupByUUIDArgs {
		UUID: UUID,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(85, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Pool: StoragePool
	_, err = dec.Decode(&rPool)
	if err != nil {
		return
	}

	return
}

// StoragePoolLookupByVolume is the go wrapper for REMOTE_PROC_STORAGE_POOL_LOOKUP_BY_VOLUME.
func (l *Libvirt) StoragePoolLookupByVolume(Vol StorageVol) (rPool StoragePool, err error) {
	var buf []byte

	args := StoragePoolLookupByVolumeArgs {
		Vol: Vol,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(86, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Pool: StoragePool
	_, err = dec.Decode(&rPool)
	if err != nil {
		return
	}

	return
}

// StoragePoolGetInfo is the go wrapper for REMOTE_PROC_STORAGE_POOL_GET_INFO.
func (l *Libvirt) StoragePoolGetInfo(Pool StoragePool) (rState uint8, rCapacity uint64, rAllocation uint64, rAvailable uint64, err error) {
	var buf []byte

	args := StoragePoolGetInfoArgs {
		Pool: Pool,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(87, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// State: uint8
	_, err = dec.Decode(&rState)
	if err != nil {
		return
	}
	// Capacity: uint64
	_, err = dec.Decode(&rCapacity)
	if err != nil {
		return
	}
	// Allocation: uint64
	_, err = dec.Decode(&rAllocation)
	if err != nil {
		return
	}
	// Available: uint64
	_, err = dec.Decode(&rAvailable)
	if err != nil {
		return
	}

	return
}

// StoragePoolGetXMLDesc is the go wrapper for REMOTE_PROC_STORAGE_POOL_GET_XML_DESC.
func (l *Libvirt) StoragePoolGetXMLDesc(Pool StoragePool, Flags StorageXMLFlags) (rXML string, err error) {
	var buf []byte

	args := StoragePoolGetXMLDescArgs {
		Pool: Pool,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(88, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// XML: string
	_, err = dec.Decode(&rXML)
	if err != nil {
		return
	}

	return
}

// StoragePoolGetAutostart is the go wrapper for REMOTE_PROC_STORAGE_POOL_GET_AUTOSTART.
func (l *Libvirt) StoragePoolGetAutostart(Pool StoragePool) (rAutostart int32, err error) {
	var buf []byte

	args := StoragePoolGetAutostartArgs {
		Pool: Pool,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(89, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Autostart: int32
	_, err = dec.Decode(&rAutostart)
	if err != nil {
		return
	}

	return
}

// StoragePoolSetAutostart is the go wrapper for REMOTE_PROC_STORAGE_POOL_SET_AUTOSTART.
func (l *Libvirt) StoragePoolSetAutostart(Pool StoragePool, Autostart int32) (err error) {
	var buf []byte

	args := StoragePoolSetAutostartArgs {
		Pool: Pool,
		Autostart: Autostart,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(90, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// StoragePoolNumOfVolumes is the go wrapper for REMOTE_PROC_STORAGE_POOL_NUM_OF_VOLUMES.
func (l *Libvirt) StoragePoolNumOfVolumes(Pool StoragePool) (rNum int32, err error) {
	var buf []byte

	args := StoragePoolNumOfVolumesArgs {
		Pool: Pool,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(91, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Num: int32
	_, err = dec.Decode(&rNum)
	if err != nil {
		return
	}

	return
}

// StoragePoolListVolumes is the go wrapper for REMOTE_PROC_STORAGE_POOL_LIST_VOLUMES.
func (l *Libvirt) StoragePoolListVolumes(Pool StoragePool, Maxnames int32) (rNames []string, err error) {
	var buf []byte

	args := StoragePoolListVolumesArgs {
		Pool: Pool,
		Maxnames: Maxnames,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(92, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Names: []string
	_, err = dec.Decode(&rNames)
	if err != nil {
		return
	}

	return
}

// StorageVolCreateXML is the go wrapper for REMOTE_PROC_STORAGE_VOL_CREATE_XML.
func (l *Libvirt) StorageVolCreateXML(Pool StoragePool, XML string, Flags StorageVolCreateFlags) (rVol StorageVol, err error) {
	var buf []byte

	args := StorageVolCreateXMLArgs {
		Pool: Pool,
		XML: XML,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(93, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Vol: StorageVol
	_, err = dec.Decode(&rVol)
	if err != nil {
		return
	}

	return
}

// StorageVolDelete is the go wrapper for REMOTE_PROC_STORAGE_VOL_DELETE.
func (l *Libvirt) StorageVolDelete(Vol StorageVol, Flags StorageVolDeleteFlags) (err error) {
	var buf []byte

	args := StorageVolDeleteArgs {
		Vol: Vol,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(94, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// StorageVolLookupByName is the go wrapper for REMOTE_PROC_STORAGE_VOL_LOOKUP_BY_NAME.
func (l *Libvirt) StorageVolLookupByName(Pool StoragePool, Name string) (rVol StorageVol, err error) {
	var buf []byte

	args := StorageVolLookupByNameArgs {
		Pool: Pool,
		Name: Name,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(95, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Vol: StorageVol
	_, err = dec.Decode(&rVol)
	if err != nil {
		return
	}

	return
}

// StorageVolLookupByKey is the go wrapper for REMOTE_PROC_STORAGE_VOL_LOOKUP_BY_KEY.
func (l *Libvirt) StorageVolLookupByKey(Key string) (rVol StorageVol, err error) {
	var buf []byte

	args := StorageVolLookupByKeyArgs {
		Key: Key,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(96, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Vol: StorageVol
	_, err = dec.Decode(&rVol)
	if err != nil {
		return
	}

	return
}

// StorageVolLookupByPath is the go wrapper for REMOTE_PROC_STORAGE_VOL_LOOKUP_BY_PATH.
func (l *Libvirt) StorageVolLookupByPath(Path string) (rVol StorageVol, err error) {
	var buf []byte

	args := StorageVolLookupByPathArgs {
		Path: Path,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(97, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Vol: StorageVol
	_, err = dec.Decode(&rVol)
	if err != nil {
		return
	}

	return
}

// StorageVolGetInfo is the go wrapper for REMOTE_PROC_STORAGE_VOL_GET_INFO.
func (l *Libvirt) StorageVolGetInfo(Vol StorageVol) (rType int8, rCapacity uint64, rAllocation uint64, err error) {
	var buf []byte

	args := StorageVolGetInfoArgs {
		Vol: Vol,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(98, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Type: int8
	_, err = dec.Decode(&rType)
	if err != nil {
		return
	}
	// Capacity: uint64
	_, err = dec.Decode(&rCapacity)
	if err != nil {
		return
	}
	// Allocation: uint64
	_, err = dec.Decode(&rAllocation)
	if err != nil {
		return
	}

	return
}

// StorageVolGetXMLDesc is the go wrapper for REMOTE_PROC_STORAGE_VOL_GET_XML_DESC.
func (l *Libvirt) StorageVolGetXMLDesc(Vol StorageVol, Flags uint32) (rXML string, err error) {
	var buf []byte

	args := StorageVolGetXMLDescArgs {
		Vol: Vol,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(99, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// XML: string
	_, err = dec.Decode(&rXML)
	if err != nil {
		return
	}

	return
}

// StorageVolGetPath is the go wrapper for REMOTE_PROC_STORAGE_VOL_GET_PATH.
func (l *Libvirt) StorageVolGetPath(Vol StorageVol) (rName string, err error) {
	var buf []byte

	args := StorageVolGetPathArgs {
		Vol: Vol,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(100, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Name: string
	_, err = dec.Decode(&rName)
	if err != nil {
		return
	}

	return
}

// NodeGetCellsFreeMemory is the go wrapper for REMOTE_PROC_NODE_GET_CELLS_FREE_MEMORY.
func (l *Libvirt) NodeGetCellsFreeMemory(StartCell int32, Maxcells int32) (rCells []uint64, err error) {
	var buf []byte

	args := NodeGetCellsFreeMemoryArgs {
		StartCell: StartCell,
		Maxcells: Maxcells,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(101, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Cells: []uint64
	_, err = dec.Decode(&rCells)
	if err != nil {
		return
	}

	return
}

// NodeGetFreeMemory is the go wrapper for REMOTE_PROC_NODE_GET_FREE_MEMORY.
func (l *Libvirt) NodeGetFreeMemory() (rFreeMem uint64, err error) {
	var buf []byte

	var r response
	r, err = l.requestStream(102, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// FreeMem: uint64
	_, err = dec.Decode(&rFreeMem)
	if err != nil {
		return
	}

	return
}

// DomainBlockPeek is the go wrapper for REMOTE_PROC_DOMAIN_BLOCK_PEEK.
func (l *Libvirt) DomainBlockPeek(Dom Domain, Path string, Offset uint64, Size uint32, Flags uint32) (rBuffer []byte, err error) {
	var buf []byte

	args := DomainBlockPeekArgs {
		Dom: Dom,
		Path: Path,
		Offset: Offset,
		Size: Size,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(103, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Buffer: []byte
	_, err = dec.Decode(&rBuffer)
	if err != nil {
		return
	}

	return
}

// DomainMemoryPeek is the go wrapper for REMOTE_PROC_DOMAIN_MEMORY_PEEK.
func (l *Libvirt) DomainMemoryPeek(Dom Domain, Offset uint64, Size uint32, Flags DomainMemoryFlags) (rBuffer []byte, err error) {
	var buf []byte

	args := DomainMemoryPeekArgs {
		Dom: Dom,
		Offset: Offset,
		Size: Size,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(104, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Buffer: []byte
	_, err = dec.Decode(&rBuffer)
	if err != nil {
		return
	}

	return
}

// ConnectDomainEventRegister is the go wrapper for REMOTE_PROC_CONNECT_DOMAIN_EVENT_REGISTER.
func (l *Libvirt) ConnectDomainEventRegister() (rCbRegistered int32, err error) {
	var buf []byte

	var r response
	r, err = l.requestStream(105, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// CbRegistered: int32
	_, err = dec.Decode(&rCbRegistered)
	if err != nil {
		return
	}

	return
}

// ConnectDomainEventDeregister is the go wrapper for REMOTE_PROC_CONNECT_DOMAIN_EVENT_DEREGISTER.
func (l *Libvirt) ConnectDomainEventDeregister() (rCbRegistered int32, err error) {
	var buf []byte

	var r response
	r, err = l.requestStream(106, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// CbRegistered: int32
	_, err = dec.Decode(&rCbRegistered)
	if err != nil {
		return
	}

	return
}

// DomainEventLifecycle is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_LIFECYCLE.
func (l *Libvirt) DomainEventLifecycle() (err error) {
	var buf []byte


	_, err = l.requestStream(107, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainMigratePrepare2 is the go wrapper for REMOTE_PROC_DOMAIN_MIGRATE_PREPARE2.
func (l *Libvirt) DomainMigratePrepare2(UriIn OptString, Flags uint64, Dname OptString, Resource uint64, DomXML string) (rCookie []byte, rUriOut OptString, err error) {
	var buf []byte

	args := DomainMigratePrepare2Args {
		UriIn: UriIn,
		Flags: Flags,
		Dname: Dname,
		Resource: Resource,
		DomXML: DomXML,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(108, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Cookie: []byte
	_, err = dec.Decode(&rCookie)
	if err != nil {
		return
	}
	// UriOut: OptString
	_, err = dec.Decode(&rUriOut)
	if err != nil {
		return
	}

	return
}

// DomainMigrateFinish2 is the go wrapper for REMOTE_PROC_DOMAIN_MIGRATE_FINISH2.
func (l *Libvirt) DomainMigrateFinish2(Dname string, Cookie []byte, Uri string, Flags uint64, Retcode int32) (rDdom Domain, err error) {
	var buf []byte

	args := DomainMigrateFinish2Args {
		Dname: Dname,
		Cookie: Cookie,
		Uri: Uri,
		Flags: Flags,
		Retcode: Retcode,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(109, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Ddom: Domain
	_, err = dec.Decode(&rDdom)
	if err != nil {
		return
	}

	return
}

// ConnectGetUri is the go wrapper for REMOTE_PROC_CONNECT_GET_URI.
func (l *Libvirt) ConnectGetUri() (rUri string, err error) {
	var buf []byte

	var r response
	r, err = l.requestStream(110, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Uri: string
	_, err = dec.Decode(&rUri)
	if err != nil {
		return
	}

	return
}

// NodeNumOfDevices is the go wrapper for REMOTE_PROC_NODE_NUM_OF_DEVICES.
func (l *Libvirt) NodeNumOfDevices(Cap OptString, Flags uint32) (rNum int32, err error) {
	var buf []byte

	args := NodeNumOfDevicesArgs {
		Cap: Cap,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(111, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Num: int32
	_, err = dec.Decode(&rNum)
	if err != nil {
		return
	}

	return
}

// NodeListDevices is the go wrapper for REMOTE_PROC_NODE_LIST_DEVICES.
func (l *Libvirt) NodeListDevices(Cap OptString, Maxnames int32, Flags uint32) (rNames []string, err error) {
	var buf []byte

	args := NodeListDevicesArgs {
		Cap: Cap,
		Maxnames: Maxnames,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(112, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Names: []string
	_, err = dec.Decode(&rNames)
	if err != nil {
		return
	}

	return
}

// NodeDeviceLookupByName is the go wrapper for REMOTE_PROC_NODE_DEVICE_LOOKUP_BY_NAME.
func (l *Libvirt) NodeDeviceLookupByName(Name string) (rDev NodeDevice, err error) {
	var buf []byte

	args := NodeDeviceLookupByNameArgs {
		Name: Name,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(113, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Dev: NodeDevice
	_, err = dec.Decode(&rDev)
	if err != nil {
		return
	}

	return
}

// NodeDeviceGetXMLDesc is the go wrapper for REMOTE_PROC_NODE_DEVICE_GET_XML_DESC.
func (l *Libvirt) NodeDeviceGetXMLDesc(Name string, Flags uint32) (rXML string, err error) {
	var buf []byte

	args := NodeDeviceGetXMLDescArgs {
		Name: Name,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(114, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// XML: string
	_, err = dec.Decode(&rXML)
	if err != nil {
		return
	}

	return
}

// NodeDeviceGetParent is the go wrapper for REMOTE_PROC_NODE_DEVICE_GET_PARENT.
func (l *Libvirt) NodeDeviceGetParent(Name string) (rParentName OptString, err error) {
	var buf []byte

	args := NodeDeviceGetParentArgs {
		Name: Name,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(115, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// ParentName: OptString
	_, err = dec.Decode(&rParentName)
	if err != nil {
		return
	}

	return
}

// NodeDeviceNumOfCaps is the go wrapper for REMOTE_PROC_NODE_DEVICE_NUM_OF_CAPS.
func (l *Libvirt) NodeDeviceNumOfCaps(Name string) (rNum int32, err error) {
	var buf []byte

	args := NodeDeviceNumOfCapsArgs {
		Name: Name,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(116, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Num: int32
	_, err = dec.Decode(&rNum)
	if err != nil {
		return
	}

	return
}

// NodeDeviceListCaps is the go wrapper for REMOTE_PROC_NODE_DEVICE_LIST_CAPS.
func (l *Libvirt) NodeDeviceListCaps(Name string, Maxnames int32) (rNames []string, err error) {
	var buf []byte

	args := NodeDeviceListCapsArgs {
		Name: Name,
		Maxnames: Maxnames,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(117, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Names: []string
	_, err = dec.Decode(&rNames)
	if err != nil {
		return
	}

	return
}

// NodeDeviceDettach is the go wrapper for REMOTE_PROC_NODE_DEVICE_DETTACH.
func (l *Libvirt) NodeDeviceDettach(Name string) (err error) {
	var buf []byte

	args := NodeDeviceDettachArgs {
		Name: Name,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(118, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// NodeDeviceReAttach is the go wrapper for REMOTE_PROC_NODE_DEVICE_RE_ATTACH.
func (l *Libvirt) NodeDeviceReAttach(Name string) (err error) {
	var buf []byte

	args := NodeDeviceReAttachArgs {
		Name: Name,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(119, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// NodeDeviceReset is the go wrapper for REMOTE_PROC_NODE_DEVICE_RESET.
func (l *Libvirt) NodeDeviceReset(Name string) (err error) {
	var buf []byte

	args := NodeDeviceResetArgs {
		Name: Name,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(120, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainGetSecurityLabel is the go wrapper for REMOTE_PROC_DOMAIN_GET_SECURITY_LABEL.
func (l *Libvirt) DomainGetSecurityLabel(Dom Domain) (rLabel []int8, rEnforcing int32, err error) {
	var buf []byte

	args := DomainGetSecurityLabelArgs {
		Dom: Dom,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(121, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Label: []int8
	_, err = dec.Decode(&rLabel)
	if err != nil {
		return
	}
	// Enforcing: int32
	_, err = dec.Decode(&rEnforcing)
	if err != nil {
		return
	}

	return
}

// NodeGetSecurityModel is the go wrapper for REMOTE_PROC_NODE_GET_SECURITY_MODEL.
func (l *Libvirt) NodeGetSecurityModel() (rModel []int8, rDoi []int8, err error) {
	var buf []byte

	var r response
	r, err = l.requestStream(122, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Model: []int8
	_, err = dec.Decode(&rModel)
	if err != nil {
		return
	}
	// Doi: []int8
	_, err = dec.Decode(&rDoi)
	if err != nil {
		return
	}

	return
}

// NodeDeviceCreateXML is the go wrapper for REMOTE_PROC_NODE_DEVICE_CREATE_XML.
func (l *Libvirt) NodeDeviceCreateXML(XMLDesc string, Flags uint32) (rDev NodeDevice, err error) {
	var buf []byte

	args := NodeDeviceCreateXMLArgs {
		XMLDesc: XMLDesc,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(123, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Dev: NodeDevice
	_, err = dec.Decode(&rDev)
	if err != nil {
		return
	}

	return
}

// NodeDeviceDestroy is the go wrapper for REMOTE_PROC_NODE_DEVICE_DESTROY.
func (l *Libvirt) NodeDeviceDestroy(Name string) (err error) {
	var buf []byte

	args := NodeDeviceDestroyArgs {
		Name: Name,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(124, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// StorageVolCreateXMLFrom is the go wrapper for REMOTE_PROC_STORAGE_VOL_CREATE_XML_FROM.
func (l *Libvirt) StorageVolCreateXMLFrom(Pool StoragePool, XML string, Clonevol StorageVol, Flags StorageVolCreateFlags) (rVol StorageVol, err error) {
	var buf []byte

	args := StorageVolCreateXMLFromArgs {
		Pool: Pool,
		XML: XML,
		Clonevol: Clonevol,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(125, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Vol: StorageVol
	_, err = dec.Decode(&rVol)
	if err != nil {
		return
	}

	return
}

// ConnectNumOfInterfaces is the go wrapper for REMOTE_PROC_CONNECT_NUM_OF_INTERFACES.
func (l *Libvirt) ConnectNumOfInterfaces() (rNum int32, err error) {
	var buf []byte

	var r response
	r, err = l.requestStream(126, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Num: int32
	_, err = dec.Decode(&rNum)
	if err != nil {
		return
	}

	return
}

// ConnectListInterfaces is the go wrapper for REMOTE_PROC_CONNECT_LIST_INTERFACES.
func (l *Libvirt) ConnectListInterfaces(Maxnames int32) (rNames []string, err error) {
	var buf []byte

	args := ConnectListInterfacesArgs {
		Maxnames: Maxnames,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(127, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Names: []string
	_, err = dec.Decode(&rNames)
	if err != nil {
		return
	}

	return
}

// InterfaceLookupByName is the go wrapper for REMOTE_PROC_INTERFACE_LOOKUP_BY_NAME.
func (l *Libvirt) InterfaceLookupByName(Name string) (rIface Interface, err error) {
	var buf []byte

	args := InterfaceLookupByNameArgs {
		Name: Name,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(128, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Iface: Interface
	_, err = dec.Decode(&rIface)
	if err != nil {
		return
	}

	return
}

// InterfaceLookupByMacString is the go wrapper for REMOTE_PROC_INTERFACE_LOOKUP_BY_MAC_STRING.
func (l *Libvirt) InterfaceLookupByMacString(Mac string) (rIface Interface, err error) {
	var buf []byte

	args := InterfaceLookupByMacStringArgs {
		Mac: Mac,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(129, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Iface: Interface
	_, err = dec.Decode(&rIface)
	if err != nil {
		return
	}

	return
}

// InterfaceGetXMLDesc is the go wrapper for REMOTE_PROC_INTERFACE_GET_XML_DESC.
func (l *Libvirt) InterfaceGetXMLDesc(Iface Interface, Flags uint32) (rXML string, err error) {
	var buf []byte

	args := InterfaceGetXMLDescArgs {
		Iface: Iface,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(130, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// XML: string
	_, err = dec.Decode(&rXML)
	if err != nil {
		return
	}

	return
}

// InterfaceDefineXML is the go wrapper for REMOTE_PROC_INTERFACE_DEFINE_XML.
func (l *Libvirt) InterfaceDefineXML(XML string, Flags uint32) (rIface Interface, err error) {
	var buf []byte

	args := InterfaceDefineXMLArgs {
		XML: XML,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(131, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Iface: Interface
	_, err = dec.Decode(&rIface)
	if err != nil {
		return
	}

	return
}

// InterfaceUndefine is the go wrapper for REMOTE_PROC_INTERFACE_UNDEFINE.
func (l *Libvirt) InterfaceUndefine(Iface Interface) (err error) {
	var buf []byte

	args := InterfaceUndefineArgs {
		Iface: Iface,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(132, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// InterfaceCreate is the go wrapper for REMOTE_PROC_INTERFACE_CREATE.
func (l *Libvirt) InterfaceCreate(Iface Interface, Flags uint32) (err error) {
	var buf []byte

	args := InterfaceCreateArgs {
		Iface: Iface,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(133, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// InterfaceDestroy is the go wrapper for REMOTE_PROC_INTERFACE_DESTROY.
func (l *Libvirt) InterfaceDestroy(Iface Interface, Flags uint32) (err error) {
	var buf []byte

	args := InterfaceDestroyArgs {
		Iface: Iface,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(134, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// ConnectDomainXMLFromNative is the go wrapper for REMOTE_PROC_CONNECT_DOMAIN_XML_FROM_NATIVE.
func (l *Libvirt) ConnectDomainXMLFromNative(NativeFormat string, NativeConfig string, Flags uint32) (rDomainXML string, err error) {
	var buf []byte

	args := ConnectDomainXMLFromNativeArgs {
		NativeFormat: NativeFormat,
		NativeConfig: NativeConfig,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(135, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// DomainXML: string
	_, err = dec.Decode(&rDomainXML)
	if err != nil {
		return
	}

	return
}

// ConnectDomainXMLToNative is the go wrapper for REMOTE_PROC_CONNECT_DOMAIN_XML_TO_NATIVE.
func (l *Libvirt) ConnectDomainXMLToNative(NativeFormat string, DomainXML string, Flags uint32) (rNativeConfig string, err error) {
	var buf []byte

	args := ConnectDomainXMLToNativeArgs {
		NativeFormat: NativeFormat,
		DomainXML: DomainXML,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(136, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// NativeConfig: string
	_, err = dec.Decode(&rNativeConfig)
	if err != nil {
		return
	}

	return
}

// ConnectNumOfDefinedInterfaces is the go wrapper for REMOTE_PROC_CONNECT_NUM_OF_DEFINED_INTERFACES.
func (l *Libvirt) ConnectNumOfDefinedInterfaces() (rNum int32, err error) {
	var buf []byte

	var r response
	r, err = l.requestStream(137, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Num: int32
	_, err = dec.Decode(&rNum)
	if err != nil {
		return
	}

	return
}

// ConnectListDefinedInterfaces is the go wrapper for REMOTE_PROC_CONNECT_LIST_DEFINED_INTERFACES.
func (l *Libvirt) ConnectListDefinedInterfaces(Maxnames int32) (rNames []string, err error) {
	var buf []byte

	args := ConnectListDefinedInterfacesArgs {
		Maxnames: Maxnames,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(138, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Names: []string
	_, err = dec.Decode(&rNames)
	if err != nil {
		return
	}

	return
}

// ConnectNumOfSecrets is the go wrapper for REMOTE_PROC_CONNECT_NUM_OF_SECRETS.
func (l *Libvirt) ConnectNumOfSecrets() (rNum int32, err error) {
	var buf []byte

	var r response
	r, err = l.requestStream(139, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Num: int32
	_, err = dec.Decode(&rNum)
	if err != nil {
		return
	}

	return
}

// ConnectListSecrets is the go wrapper for REMOTE_PROC_CONNECT_LIST_SECRETS.
func (l *Libvirt) ConnectListSecrets(Maxuuids int32) (rUuids []string, err error) {
	var buf []byte

	args := ConnectListSecretsArgs {
		Maxuuids: Maxuuids,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(140, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Uuids: []string
	_, err = dec.Decode(&rUuids)
	if err != nil {
		return
	}

	return
}

// SecretLookupByUUID is the go wrapper for REMOTE_PROC_SECRET_LOOKUP_BY_UUID.
func (l *Libvirt) SecretLookupByUUID(UUID UUID) (rOptSecret Secret, err error) {
	var buf []byte

	args := SecretLookupByUUIDArgs {
		UUID: UUID,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(141, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// OptSecret: Secret
	_, err = dec.Decode(&rOptSecret)
	if err != nil {
		return
	}

	return
}

// SecretDefineXML is the go wrapper for REMOTE_PROC_SECRET_DEFINE_XML.
func (l *Libvirt) SecretDefineXML(XML string, Flags uint32) (rOptSecret Secret, err error) {
	var buf []byte

	args := SecretDefineXMLArgs {
		XML: XML,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(142, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// OptSecret: Secret
	_, err = dec.Decode(&rOptSecret)
	if err != nil {
		return
	}

	return
}

// SecretGetXMLDesc is the go wrapper for REMOTE_PROC_SECRET_GET_XML_DESC.
func (l *Libvirt) SecretGetXMLDesc(OptSecret Secret, Flags uint32) (rXML string, err error) {
	var buf []byte

	args := SecretGetXMLDescArgs {
		OptSecret: OptSecret,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(143, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// XML: string
	_, err = dec.Decode(&rXML)
	if err != nil {
		return
	}

	return
}

// SecretSetValue is the go wrapper for REMOTE_PROC_SECRET_SET_VALUE.
func (l *Libvirt) SecretSetValue(OptSecret Secret, Value []byte, Flags uint32) (err error) {
	var buf []byte

	args := SecretSetValueArgs {
		OptSecret: OptSecret,
		Value: Value,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(144, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// SecretGetValue is the go wrapper for REMOTE_PROC_SECRET_GET_VALUE.
func (l *Libvirt) SecretGetValue(OptSecret Secret, Flags uint32) (rValue []byte, err error) {
	var buf []byte

	args := SecretGetValueArgs {
		OptSecret: OptSecret,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(145, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Value: []byte
	_, err = dec.Decode(&rValue)
	if err != nil {
		return
	}

	return
}

// SecretUndefine is the go wrapper for REMOTE_PROC_SECRET_UNDEFINE.
func (l *Libvirt) SecretUndefine(OptSecret Secret) (err error) {
	var buf []byte

	args := SecretUndefineArgs {
		OptSecret: OptSecret,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(146, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// SecretLookupByUsage is the go wrapper for REMOTE_PROC_SECRET_LOOKUP_BY_USAGE.
func (l *Libvirt) SecretLookupByUsage(UsageType int32, UsageID string) (rOptSecret Secret, err error) {
	var buf []byte

	args := SecretLookupByUsageArgs {
		UsageType: UsageType,
		UsageID: UsageID,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(147, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// OptSecret: Secret
	_, err = dec.Decode(&rOptSecret)
	if err != nil {
		return
	}

	return
}

// DomainMigratePrepareTunnel is the go wrapper for REMOTE_PROC_DOMAIN_MIGRATE_PREPARE_TUNNEL.
func (l *Libvirt) DomainMigratePrepareTunnel(Flags uint64, outStream io.Reader, Dname OptString, Resource uint64, DomXML string) (err error) {
	var buf []byte

	args := DomainMigratePrepareTunnelArgs {
		Flags: Flags,
		Dname: Dname,
		Resource: Resource,
		DomXML: DomXML,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(148, constants.Program, buf, outStream, nil)
	if err != nil {
		return
	}

	return
}

// ConnectIsSecure is the go wrapper for REMOTE_PROC_CONNECT_IS_SECURE.
func (l *Libvirt) ConnectIsSecure() (rSecure int32, err error) {
	var buf []byte

	var r response
	r, err = l.requestStream(149, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Secure: int32
	_, err = dec.Decode(&rSecure)
	if err != nil {
		return
	}

	return
}

// DomainIsActive is the go wrapper for REMOTE_PROC_DOMAIN_IS_ACTIVE.
func (l *Libvirt) DomainIsActive(Dom Domain) (rActive int32, err error) {
	var buf []byte

	args := DomainIsActiveArgs {
		Dom: Dom,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(150, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Active: int32
	_, err = dec.Decode(&rActive)
	if err != nil {
		return
	}

	return
}

// DomainIsPersistent is the go wrapper for REMOTE_PROC_DOMAIN_IS_PERSISTENT.
func (l *Libvirt) DomainIsPersistent(Dom Domain) (rPersistent int32, err error) {
	var buf []byte

	args := DomainIsPersistentArgs {
		Dom: Dom,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(151, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Persistent: int32
	_, err = dec.Decode(&rPersistent)
	if err != nil {
		return
	}

	return
}

// NetworkIsActive is the go wrapper for REMOTE_PROC_NETWORK_IS_ACTIVE.
func (l *Libvirt) NetworkIsActive(Net Network) (rActive int32, err error) {
	var buf []byte

	args := NetworkIsActiveArgs {
		Net: Net,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(152, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Active: int32
	_, err = dec.Decode(&rActive)
	if err != nil {
		return
	}

	return
}

// NetworkIsPersistent is the go wrapper for REMOTE_PROC_NETWORK_IS_PERSISTENT.
func (l *Libvirt) NetworkIsPersistent(Net Network) (rPersistent int32, err error) {
	var buf []byte

	args := NetworkIsPersistentArgs {
		Net: Net,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(153, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Persistent: int32
	_, err = dec.Decode(&rPersistent)
	if err != nil {
		return
	}

	return
}

// StoragePoolIsActive is the go wrapper for REMOTE_PROC_STORAGE_POOL_IS_ACTIVE.
func (l *Libvirt) StoragePoolIsActive(Pool StoragePool) (rActive int32, err error) {
	var buf []byte

	args := StoragePoolIsActiveArgs {
		Pool: Pool,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(154, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Active: int32
	_, err = dec.Decode(&rActive)
	if err != nil {
		return
	}

	return
}

// StoragePoolIsPersistent is the go wrapper for REMOTE_PROC_STORAGE_POOL_IS_PERSISTENT.
func (l *Libvirt) StoragePoolIsPersistent(Pool StoragePool) (rPersistent int32, err error) {
	var buf []byte

	args := StoragePoolIsPersistentArgs {
		Pool: Pool,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(155, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Persistent: int32
	_, err = dec.Decode(&rPersistent)
	if err != nil {
		return
	}

	return
}

// InterfaceIsActive is the go wrapper for REMOTE_PROC_INTERFACE_IS_ACTIVE.
func (l *Libvirt) InterfaceIsActive(Iface Interface) (rActive int32, err error) {
	var buf []byte

	args := InterfaceIsActiveArgs {
		Iface: Iface,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(156, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Active: int32
	_, err = dec.Decode(&rActive)
	if err != nil {
		return
	}

	return
}

// ConnectGetLibVersion is the go wrapper for REMOTE_PROC_CONNECT_GET_LIB_VERSION.
func (l *Libvirt) ConnectGetLibVersion() (rLibVer uint64, err error) {
	var buf []byte

	var r response
	r, err = l.requestStream(157, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// LibVer: uint64
	_, err = dec.Decode(&rLibVer)
	if err != nil {
		return
	}

	return
}

// ConnectCompareCPU is the go wrapper for REMOTE_PROC_CONNECT_COMPARE_CPU.
func (l *Libvirt) ConnectCompareCPU(XML string, Flags ConnectCompareCPUFlags) (rResult int32, err error) {
	var buf []byte

	args := ConnectCompareCPUArgs {
		XML: XML,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(158, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Result: int32
	_, err = dec.Decode(&rResult)
	if err != nil {
		return
	}

	return
}

// DomainMemoryStats is the go wrapper for REMOTE_PROC_DOMAIN_MEMORY_STATS.
func (l *Libvirt) DomainMemoryStats(Dom Domain, MaxStats uint32, Flags uint32) (rStats []DomainMemoryStat, err error) {
	var buf []byte

	args := DomainMemoryStatsArgs {
		Dom: Dom,
		MaxStats: MaxStats,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(159, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Stats: []DomainMemoryStat
	_, err = dec.Decode(&rStats)
	if err != nil {
		return
	}

	return
}

// DomainAttachDeviceFlags is the go wrapper for REMOTE_PROC_DOMAIN_ATTACH_DEVICE_FLAGS.
func (l *Libvirt) DomainAttachDeviceFlags(Dom Domain, XML string, Flags uint32) (err error) {
	var buf []byte

	args := DomainAttachDeviceFlagsArgs {
		Dom: Dom,
		XML: XML,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(160, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainDetachDeviceFlags is the go wrapper for REMOTE_PROC_DOMAIN_DETACH_DEVICE_FLAGS.
func (l *Libvirt) DomainDetachDeviceFlags(Dom Domain, XML string, Flags uint32) (err error) {
	var buf []byte

	args := DomainDetachDeviceFlagsArgs {
		Dom: Dom,
		XML: XML,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(161, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// ConnectBaselineCPU is the go wrapper for REMOTE_PROC_CONNECT_BASELINE_CPU.
func (l *Libvirt) ConnectBaselineCPU(XMLCPUs []string, Flags ConnectBaselineCPUFlags) (rCPU string, err error) {
	var buf []byte

	args := ConnectBaselineCPUArgs {
		XMLCPUs: XMLCPUs,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(162, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// CPU: string
	_, err = dec.Decode(&rCPU)
	if err != nil {
		return
	}

	return
}

// DomainGetJobInfo is the go wrapper for REMOTE_PROC_DOMAIN_GET_JOB_INFO.
func (l *Libvirt) DomainGetJobInfo(Dom Domain) (rType int32, rTimeElapsed uint64, rTimeRemaining uint64, rDataTotal uint64, rDataProcessed uint64, rDataRemaining uint64, rMemTotal uint64, rMemProcessed uint64, rMemRemaining uint64, rFileTotal uint64, rFileProcessed uint64, rFileRemaining uint64, err error) {
	var buf []byte

	args := DomainGetJobInfoArgs {
		Dom: Dom,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(163, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Type: int32
	_, err = dec.Decode(&rType)
	if err != nil {
		return
	}
	// TimeElapsed: uint64
	_, err = dec.Decode(&rTimeElapsed)
	if err != nil {
		return
	}
	// TimeRemaining: uint64
	_, err = dec.Decode(&rTimeRemaining)
	if err != nil {
		return
	}
	// DataTotal: uint64
	_, err = dec.Decode(&rDataTotal)
	if err != nil {
		return
	}
	// DataProcessed: uint64
	_, err = dec.Decode(&rDataProcessed)
	if err != nil {
		return
	}
	// DataRemaining: uint64
	_, err = dec.Decode(&rDataRemaining)
	if err != nil {
		return
	}
	// MemTotal: uint64
	_, err = dec.Decode(&rMemTotal)
	if err != nil {
		return
	}
	// MemProcessed: uint64
	_, err = dec.Decode(&rMemProcessed)
	if err != nil {
		return
	}
	// MemRemaining: uint64
	_, err = dec.Decode(&rMemRemaining)
	if err != nil {
		return
	}
	// FileTotal: uint64
	_, err = dec.Decode(&rFileTotal)
	if err != nil {
		return
	}
	// FileProcessed: uint64
	_, err = dec.Decode(&rFileProcessed)
	if err != nil {
		return
	}
	// FileRemaining: uint64
	_, err = dec.Decode(&rFileRemaining)
	if err != nil {
		return
	}

	return
}

// DomainAbortJob is the go wrapper for REMOTE_PROC_DOMAIN_ABORT_JOB.
func (l *Libvirt) DomainAbortJob(Dom Domain) (err error) {
	var buf []byte

	args := DomainAbortJobArgs {
		Dom: Dom,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(164, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// StorageVolWipe is the go wrapper for REMOTE_PROC_STORAGE_VOL_WIPE.
func (l *Libvirt) StorageVolWipe(Vol StorageVol, Flags uint32) (err error) {
	var buf []byte

	args := StorageVolWipeArgs {
		Vol: Vol,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(165, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainMigrateSetMaxDowntime is the go wrapper for REMOTE_PROC_DOMAIN_MIGRATE_SET_MAX_DOWNTIME.
func (l *Libvirt) DomainMigrateSetMaxDowntime(Dom Domain, Downtime uint64, Flags uint32) (err error) {
	var buf []byte

	args := DomainMigrateSetMaxDowntimeArgs {
		Dom: Dom,
		Downtime: Downtime,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(166, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// ConnectDomainEventRegisterAny is the go wrapper for REMOTE_PROC_CONNECT_DOMAIN_EVENT_REGISTER_ANY.
func (l *Libvirt) ConnectDomainEventRegisterAny(EventID int32) (err error) {
	var buf []byte

	args := ConnectDomainEventRegisterAnyArgs {
		EventID: EventID,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(167, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// ConnectDomainEventDeregisterAny is the go wrapper for REMOTE_PROC_CONNECT_DOMAIN_EVENT_DEREGISTER_ANY.
func (l *Libvirt) ConnectDomainEventDeregisterAny(EventID int32) (err error) {
	var buf []byte

	args := ConnectDomainEventDeregisterAnyArgs {
		EventID: EventID,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(168, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventReboot is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_REBOOT.
func (l *Libvirt) DomainEventReboot() (err error) {
	var buf []byte


	_, err = l.requestStream(169, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventRtcChange is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_RTC_CHANGE.
func (l *Libvirt) DomainEventRtcChange() (err error) {
	var buf []byte


	_, err = l.requestStream(170, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventWatchdog is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_WATCHDOG.
func (l *Libvirt) DomainEventWatchdog() (err error) {
	var buf []byte


	_, err = l.requestStream(171, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventIOError is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_IO_ERROR.
func (l *Libvirt) DomainEventIOError() (err error) {
	var buf []byte


	_, err = l.requestStream(172, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventGraphics is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_GRAPHICS.
func (l *Libvirt) DomainEventGraphics() (err error) {
	var buf []byte


	_, err = l.requestStream(173, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainUpdateDeviceFlags is the go wrapper for REMOTE_PROC_DOMAIN_UPDATE_DEVICE_FLAGS.
func (l *Libvirt) DomainUpdateDeviceFlags(Dom Domain, XML string, Flags DomainDeviceModifyFlags) (err error) {
	var buf []byte

	args := DomainUpdateDeviceFlagsArgs {
		Dom: Dom,
		XML: XML,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(174, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// NwfilterLookupByName is the go wrapper for REMOTE_PROC_NWFILTER_LOOKUP_BY_NAME.
func (l *Libvirt) NwfilterLookupByName(Name string) (rOptNwfilter Nwfilter, err error) {
	var buf []byte

	args := NwfilterLookupByNameArgs {
		Name: Name,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(175, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// OptNwfilter: Nwfilter
	_, err = dec.Decode(&rOptNwfilter)
	if err != nil {
		return
	}

	return
}

// NwfilterLookupByUUID is the go wrapper for REMOTE_PROC_NWFILTER_LOOKUP_BY_UUID.
func (l *Libvirt) NwfilterLookupByUUID(UUID UUID) (rOptNwfilter Nwfilter, err error) {
	var buf []byte

	args := NwfilterLookupByUUIDArgs {
		UUID: UUID,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(176, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// OptNwfilter: Nwfilter
	_, err = dec.Decode(&rOptNwfilter)
	if err != nil {
		return
	}

	return
}

// NwfilterGetXMLDesc is the go wrapper for REMOTE_PROC_NWFILTER_GET_XML_DESC.
func (l *Libvirt) NwfilterGetXMLDesc(OptNwfilter Nwfilter, Flags uint32) (rXML string, err error) {
	var buf []byte

	args := NwfilterGetXMLDescArgs {
		OptNwfilter: OptNwfilter,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(177, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// XML: string
	_, err = dec.Decode(&rXML)
	if err != nil {
		return
	}

	return
}

// ConnectNumOfNwfilters is the go wrapper for REMOTE_PROC_CONNECT_NUM_OF_NWFILTERS.
func (l *Libvirt) ConnectNumOfNwfilters() (rNum int32, err error) {
	var buf []byte

	var r response
	r, err = l.requestStream(178, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Num: int32
	_, err = dec.Decode(&rNum)
	if err != nil {
		return
	}

	return
}

// ConnectListNwfilters is the go wrapper for REMOTE_PROC_CONNECT_LIST_NWFILTERS.
func (l *Libvirt) ConnectListNwfilters(Maxnames int32) (rNames []string, err error) {
	var buf []byte

	args := ConnectListNwfiltersArgs {
		Maxnames: Maxnames,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(179, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Names: []string
	_, err = dec.Decode(&rNames)
	if err != nil {
		return
	}

	return
}

// NwfilterDefineXML is the go wrapper for REMOTE_PROC_NWFILTER_DEFINE_XML.
func (l *Libvirt) NwfilterDefineXML(XML string) (rOptNwfilter Nwfilter, err error) {
	var buf []byte

	args := NwfilterDefineXMLArgs {
		XML: XML,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(180, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// OptNwfilter: Nwfilter
	_, err = dec.Decode(&rOptNwfilter)
	if err != nil {
		return
	}

	return
}

// NwfilterUndefine is the go wrapper for REMOTE_PROC_NWFILTER_UNDEFINE.
func (l *Libvirt) NwfilterUndefine(OptNwfilter Nwfilter) (err error) {
	var buf []byte

	args := NwfilterUndefineArgs {
		OptNwfilter: OptNwfilter,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(181, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainManagedSave is the go wrapper for REMOTE_PROC_DOMAIN_MANAGED_SAVE.
func (l *Libvirt) DomainManagedSave(Dom Domain, Flags uint32) (err error) {
	var buf []byte

	args := DomainManagedSaveArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(182, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainHasManagedSaveImage is the go wrapper for REMOTE_PROC_DOMAIN_HAS_MANAGED_SAVE_IMAGE.
func (l *Libvirt) DomainHasManagedSaveImage(Dom Domain, Flags uint32) (rResult int32, err error) {
	var buf []byte

	args := DomainHasManagedSaveImageArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(183, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Result: int32
	_, err = dec.Decode(&rResult)
	if err != nil {
		return
	}

	return
}

// DomainManagedSaveRemove is the go wrapper for REMOTE_PROC_DOMAIN_MANAGED_SAVE_REMOVE.
func (l *Libvirt) DomainManagedSaveRemove(Dom Domain, Flags uint32) (err error) {
	var buf []byte

	args := DomainManagedSaveRemoveArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(184, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainSnapshotCreateXML is the go wrapper for REMOTE_PROC_DOMAIN_SNAPSHOT_CREATE_XML.
func (l *Libvirt) DomainSnapshotCreateXML(Dom Domain, XMLDesc string, Flags uint32) (rSnap DomainSnapshot, err error) {
	var buf []byte

	args := DomainSnapshotCreateXMLArgs {
		Dom: Dom,
		XMLDesc: XMLDesc,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(185, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Snap: DomainSnapshot
	_, err = dec.Decode(&rSnap)
	if err != nil {
		return
	}

	return
}

// DomainSnapshotGetXMLDesc is the go wrapper for REMOTE_PROC_DOMAIN_SNAPSHOT_GET_XML_DESC.
func (l *Libvirt) DomainSnapshotGetXMLDesc(Snap DomainSnapshot, Flags uint32) (rXML string, err error) {
	var buf []byte

	args := DomainSnapshotGetXMLDescArgs {
		Snap: Snap,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(186, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// XML: string
	_, err = dec.Decode(&rXML)
	if err != nil {
		return
	}

	return
}

// DomainSnapshotNum is the go wrapper for REMOTE_PROC_DOMAIN_SNAPSHOT_NUM.
func (l *Libvirt) DomainSnapshotNum(Dom Domain, Flags uint32) (rNum int32, err error) {
	var buf []byte

	args := DomainSnapshotNumArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(187, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Num: int32
	_, err = dec.Decode(&rNum)
	if err != nil {
		return
	}

	return
}

// DomainSnapshotListNames is the go wrapper for REMOTE_PROC_DOMAIN_SNAPSHOT_LIST_NAMES.
func (l *Libvirt) DomainSnapshotListNames(Dom Domain, Maxnames int32, Flags uint32) (rNames []string, err error) {
	var buf []byte

	args := DomainSnapshotListNamesArgs {
		Dom: Dom,
		Maxnames: Maxnames,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(188, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Names: []string
	_, err = dec.Decode(&rNames)
	if err != nil {
		return
	}

	return
}

// DomainSnapshotLookupByName is the go wrapper for REMOTE_PROC_DOMAIN_SNAPSHOT_LOOKUP_BY_NAME.
func (l *Libvirt) DomainSnapshotLookupByName(Dom Domain, Name string, Flags uint32) (rSnap DomainSnapshot, err error) {
	var buf []byte

	args := DomainSnapshotLookupByNameArgs {
		Dom: Dom,
		Name: Name,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(189, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Snap: DomainSnapshot
	_, err = dec.Decode(&rSnap)
	if err != nil {
		return
	}

	return
}

// DomainHasCurrentSnapshot is the go wrapper for REMOTE_PROC_DOMAIN_HAS_CURRENT_SNAPSHOT.
func (l *Libvirt) DomainHasCurrentSnapshot(Dom Domain, Flags uint32) (rResult int32, err error) {
	var buf []byte

	args := DomainHasCurrentSnapshotArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(190, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Result: int32
	_, err = dec.Decode(&rResult)
	if err != nil {
		return
	}

	return
}

// DomainSnapshotCurrent is the go wrapper for REMOTE_PROC_DOMAIN_SNAPSHOT_CURRENT.
func (l *Libvirt) DomainSnapshotCurrent(Dom Domain, Flags uint32) (rSnap DomainSnapshot, err error) {
	var buf []byte

	args := DomainSnapshotCurrentArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(191, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Snap: DomainSnapshot
	_, err = dec.Decode(&rSnap)
	if err != nil {
		return
	}

	return
}

// DomainRevertToSnapshot is the go wrapper for REMOTE_PROC_DOMAIN_REVERT_TO_SNAPSHOT.
func (l *Libvirt) DomainRevertToSnapshot(Snap DomainSnapshot, Flags uint32) (err error) {
	var buf []byte

	args := DomainRevertToSnapshotArgs {
		Snap: Snap,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(192, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainSnapshotDelete is the go wrapper for REMOTE_PROC_DOMAIN_SNAPSHOT_DELETE.
func (l *Libvirt) DomainSnapshotDelete(Snap DomainSnapshot, Flags DomainSnapshotDeleteFlags) (err error) {
	var buf []byte

	args := DomainSnapshotDeleteArgs {
		Snap: Snap,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(193, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainGetBlockInfo is the go wrapper for REMOTE_PROC_DOMAIN_GET_BLOCK_INFO.
func (l *Libvirt) DomainGetBlockInfo(Dom Domain, Path string, Flags uint32) (rAllocation uint64, rCapacity uint64, rPhysical uint64, err error) {
	var buf []byte

	args := DomainGetBlockInfoArgs {
		Dom: Dom,
		Path: Path,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(194, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Allocation: uint64
	_, err = dec.Decode(&rAllocation)
	if err != nil {
		return
	}
	// Capacity: uint64
	_, err = dec.Decode(&rCapacity)
	if err != nil {
		return
	}
	// Physical: uint64
	_, err = dec.Decode(&rPhysical)
	if err != nil {
		return
	}

	return
}

// DomainEventIOErrorReason is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_IO_ERROR_REASON.
func (l *Libvirt) DomainEventIOErrorReason() (err error) {
	var buf []byte


	_, err = l.requestStream(195, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainCreateWithFlags is the go wrapper for REMOTE_PROC_DOMAIN_CREATE_WITH_FLAGS.
func (l *Libvirt) DomainCreateWithFlags(Dom Domain, Flags uint32) (rDom Domain, err error) {
	var buf []byte

	args := DomainCreateWithFlagsArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(196, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Dom: Domain
	_, err = dec.Decode(&rDom)
	if err != nil {
		return
	}

	return
}

// DomainSetMemoryParameters is the go wrapper for REMOTE_PROC_DOMAIN_SET_MEMORY_PARAMETERS.
func (l *Libvirt) DomainSetMemoryParameters(Dom Domain, Params []TypedParam, Flags uint32) (err error) {
	var buf []byte

	args := DomainSetMemoryParametersArgs {
		Dom: Dom,
		Params: Params,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(197, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainGetMemoryParameters is the go wrapper for REMOTE_PROC_DOMAIN_GET_MEMORY_PARAMETERS.
func (l *Libvirt) DomainGetMemoryParameters(Dom Domain, Nparams int32, Flags uint32) (rParams []TypedParam, rNparams int32, err error) {
	var buf []byte

	args := DomainGetMemoryParametersArgs {
		Dom: Dom,
		Nparams: Nparams,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(198, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Params: []TypedParam
	_, err = dec.Decode(&rParams)
	if err != nil {
		return
	}
	// Nparams: int32
	_, err = dec.Decode(&rNparams)
	if err != nil {
		return
	}

	return
}

// DomainSetVcpusFlags is the go wrapper for REMOTE_PROC_DOMAIN_SET_VCPUS_FLAGS.
func (l *Libvirt) DomainSetVcpusFlags(Dom Domain, Nvcpus uint32, Flags uint32) (err error) {
	var buf []byte

	args := DomainSetVcpusFlagsArgs {
		Dom: Dom,
		Nvcpus: Nvcpus,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(199, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainGetVcpusFlags is the go wrapper for REMOTE_PROC_DOMAIN_GET_VCPUS_FLAGS.
func (l *Libvirt) DomainGetVcpusFlags(Dom Domain, Flags uint32) (rNum int32, err error) {
	var buf []byte

	args := DomainGetVcpusFlagsArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(200, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Num: int32
	_, err = dec.Decode(&rNum)
	if err != nil {
		return
	}

	return
}

// DomainOpenConsole is the go wrapper for REMOTE_PROC_DOMAIN_OPEN_CONSOLE.
func (l *Libvirt) DomainOpenConsole(Dom Domain, DevName OptString, inStream io.Writer, Flags uint32) (err error) {
	var buf []byte

	args := DomainOpenConsoleArgs {
		Dom: Dom,
		DevName: DevName,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(201, constants.Program, buf, nil, inStream)
	if err != nil {
		return
	}

	return
}

// DomainIsUpdated is the go wrapper for REMOTE_PROC_DOMAIN_IS_UPDATED.
func (l *Libvirt) DomainIsUpdated(Dom Domain) (rUpdated int32, err error) {
	var buf []byte

	args := DomainIsUpdatedArgs {
		Dom: Dom,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(202, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Updated: int32
	_, err = dec.Decode(&rUpdated)
	if err != nil {
		return
	}

	return
}

// ConnectGetSysinfo is the go wrapper for REMOTE_PROC_CONNECT_GET_SYSINFO.
func (l *Libvirt) ConnectGetSysinfo(Flags uint32) (rSysinfo string, err error) {
	var buf []byte

	args := ConnectGetSysinfoArgs {
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(203, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Sysinfo: string
	_, err = dec.Decode(&rSysinfo)
	if err != nil {
		return
	}

	return
}

// DomainSetMemoryFlags is the go wrapper for REMOTE_PROC_DOMAIN_SET_MEMORY_FLAGS.
func (l *Libvirt) DomainSetMemoryFlags(Dom Domain, Memory uint64, Flags uint32) (err error) {
	var buf []byte

	args := DomainSetMemoryFlagsArgs {
		Dom: Dom,
		Memory: Memory,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(204, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainSetBlkioParameters is the go wrapper for REMOTE_PROC_DOMAIN_SET_BLKIO_PARAMETERS.
func (l *Libvirt) DomainSetBlkioParameters(Dom Domain, Params []TypedParam, Flags uint32) (err error) {
	var buf []byte

	args := DomainSetBlkioParametersArgs {
		Dom: Dom,
		Params: Params,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(205, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainGetBlkioParameters is the go wrapper for REMOTE_PROC_DOMAIN_GET_BLKIO_PARAMETERS.
func (l *Libvirt) DomainGetBlkioParameters(Dom Domain, Nparams int32, Flags uint32) (rParams []TypedParam, rNparams int32, err error) {
	var buf []byte

	args := DomainGetBlkioParametersArgs {
		Dom: Dom,
		Nparams: Nparams,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(206, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Params: []TypedParam
	_, err = dec.Decode(&rParams)
	if err != nil {
		return
	}
	// Nparams: int32
	_, err = dec.Decode(&rNparams)
	if err != nil {
		return
	}

	return
}

// DomainMigrateSetMaxSpeed is the go wrapper for REMOTE_PROC_DOMAIN_MIGRATE_SET_MAX_SPEED.
func (l *Libvirt) DomainMigrateSetMaxSpeed(Dom Domain, Bandwidth uint64, Flags uint32) (err error) {
	var buf []byte

	args := DomainMigrateSetMaxSpeedArgs {
		Dom: Dom,
		Bandwidth: Bandwidth,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(207, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// StorageVolUpload is the go wrapper for REMOTE_PROC_STORAGE_VOL_UPLOAD.
func (l *Libvirt) StorageVolUpload(Vol StorageVol, outStream io.Reader, Offset uint64, Length uint64, Flags StorageVolUploadFlags) (err error) {
	var buf []byte

	args := StorageVolUploadArgs {
		Vol: Vol,
		Offset: Offset,
		Length: Length,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(208, constants.Program, buf, outStream, nil)
	if err != nil {
		return
	}

	return
}

// StorageVolDownload is the go wrapper for REMOTE_PROC_STORAGE_VOL_DOWNLOAD.
func (l *Libvirt) StorageVolDownload(Vol StorageVol, inStream io.Writer, Offset uint64, Length uint64, Flags StorageVolDownloadFlags) (err error) {
	var buf []byte

	args := StorageVolDownloadArgs {
		Vol: Vol,
		Offset: Offset,
		Length: Length,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(209, constants.Program, buf, nil, inStream)
	if err != nil {
		return
	}

	return
}

// DomainInjectNmi is the go wrapper for REMOTE_PROC_DOMAIN_INJECT_NMI.
func (l *Libvirt) DomainInjectNmi(Dom Domain, Flags uint32) (err error) {
	var buf []byte

	args := DomainInjectNmiArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(210, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainScreenshot is the go wrapper for REMOTE_PROC_DOMAIN_SCREENSHOT.
func (l *Libvirt) DomainScreenshot(Dom Domain, inStream io.Writer, Screen uint32, Flags uint32) (rMime OptString, err error) {
	var buf []byte

	args := DomainScreenshotArgs {
		Dom: Dom,
		Screen: Screen,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(211, constants.Program, buf, nil, inStream)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Mime: OptString
	_, err = dec.Decode(&rMime)
	if err != nil {
		return
	}

	return
}

// DomainGetState is the go wrapper for REMOTE_PROC_DOMAIN_GET_STATE.
func (l *Libvirt) DomainGetState(Dom Domain, Flags uint32) (rState int32, rReason int32, err error) {
	var buf []byte

	args := DomainGetStateArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(212, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// State: int32
	_, err = dec.Decode(&rState)
	if err != nil {
		return
	}
	// Reason: int32
	_, err = dec.Decode(&rReason)
	if err != nil {
		return
	}

	return
}

// DomainMigrateBegin3 is the go wrapper for REMOTE_PROC_DOMAIN_MIGRATE_BEGIN3.
func (l *Libvirt) DomainMigrateBegin3(Dom Domain, Xmlin OptString, Flags uint64, Dname OptString, Resource uint64) (rCookieOut []byte, rXML string, err error) {
	var buf []byte

	args := DomainMigrateBegin3Args {
		Dom: Dom,
		Xmlin: Xmlin,
		Flags: Flags,
		Dname: Dname,
		Resource: Resource,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(213, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// CookieOut: []byte
	_, err = dec.Decode(&rCookieOut)
	if err != nil {
		return
	}
	// XML: string
	_, err = dec.Decode(&rXML)
	if err != nil {
		return
	}

	return
}

// DomainMigratePrepare3 is the go wrapper for REMOTE_PROC_DOMAIN_MIGRATE_PREPARE3.
func (l *Libvirt) DomainMigratePrepare3(CookieIn []byte, UriIn OptString, Flags uint64, Dname OptString, Resource uint64, DomXML string) (rCookieOut []byte, rUriOut OptString, err error) {
	var buf []byte

	args := DomainMigratePrepare3Args {
		CookieIn: CookieIn,
		UriIn: UriIn,
		Flags: Flags,
		Dname: Dname,
		Resource: Resource,
		DomXML: DomXML,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(214, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// CookieOut: []byte
	_, err = dec.Decode(&rCookieOut)
	if err != nil {
		return
	}
	// UriOut: OptString
	_, err = dec.Decode(&rUriOut)
	if err != nil {
		return
	}

	return
}

// DomainMigratePrepareTunnel3 is the go wrapper for REMOTE_PROC_DOMAIN_MIGRATE_PREPARE_TUNNEL3.
func (l *Libvirt) DomainMigratePrepareTunnel3(CookieIn []byte, outStream io.Reader, Flags uint64, Dname OptString, Resource uint64, DomXML string) (rCookieOut []byte, err error) {
	var buf []byte

	args := DomainMigratePrepareTunnel3Args {
		CookieIn: CookieIn,
		Flags: Flags,
		Dname: Dname,
		Resource: Resource,
		DomXML: DomXML,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(215, constants.Program, buf, outStream, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// CookieOut: []byte
	_, err = dec.Decode(&rCookieOut)
	if err != nil {
		return
	}

	return
}

// DomainMigratePerform3 is the go wrapper for REMOTE_PROC_DOMAIN_MIGRATE_PERFORM3.
func (l *Libvirt) DomainMigratePerform3(Dom Domain, Xmlin OptString, CookieIn []byte, Dconnuri OptString, Uri OptString, Flags uint64, Dname OptString, Resource uint64) (rCookieOut []byte, err error) {
	var buf []byte

	args := DomainMigratePerform3Args {
		Dom: Dom,
		Xmlin: Xmlin,
		CookieIn: CookieIn,
		Dconnuri: Dconnuri,
		Uri: Uri,
		Flags: Flags,
		Dname: Dname,
		Resource: Resource,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(216, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// CookieOut: []byte
	_, err = dec.Decode(&rCookieOut)
	if err != nil {
		return
	}

	return
}

// DomainMigrateFinish3 is the go wrapper for REMOTE_PROC_DOMAIN_MIGRATE_FINISH3.
func (l *Libvirt) DomainMigrateFinish3(Dname string, CookieIn []byte, Dconnuri OptString, Uri OptString, Flags uint64, Cancelled int32) (rDom Domain, rCookieOut []byte, err error) {
	var buf []byte

	args := DomainMigrateFinish3Args {
		Dname: Dname,
		CookieIn: CookieIn,
		Dconnuri: Dconnuri,
		Uri: Uri,
		Flags: Flags,
		Cancelled: Cancelled,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(217, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Dom: Domain
	_, err = dec.Decode(&rDom)
	if err != nil {
		return
	}
	// CookieOut: []byte
	_, err = dec.Decode(&rCookieOut)
	if err != nil {
		return
	}

	return
}

// DomainMigrateConfirm3 is the go wrapper for REMOTE_PROC_DOMAIN_MIGRATE_CONFIRM3.
func (l *Libvirt) DomainMigrateConfirm3(Dom Domain, CookieIn []byte, Flags uint64, Cancelled int32) (err error) {
	var buf []byte

	args := DomainMigrateConfirm3Args {
		Dom: Dom,
		CookieIn: CookieIn,
		Flags: Flags,
		Cancelled: Cancelled,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(218, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainSetSchedulerParametersFlags is the go wrapper for REMOTE_PROC_DOMAIN_SET_SCHEDULER_PARAMETERS_FLAGS.
func (l *Libvirt) DomainSetSchedulerParametersFlags(Dom Domain, Params []TypedParam, Flags uint32) (err error) {
	var buf []byte

	args := DomainSetSchedulerParametersFlagsArgs {
		Dom: Dom,
		Params: Params,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(219, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// InterfaceChangeBegin is the go wrapper for REMOTE_PROC_INTERFACE_CHANGE_BEGIN.
func (l *Libvirt) InterfaceChangeBegin(Flags uint32) (err error) {
	var buf []byte

	args := InterfaceChangeBeginArgs {
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(220, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// InterfaceChangeCommit is the go wrapper for REMOTE_PROC_INTERFACE_CHANGE_COMMIT.
func (l *Libvirt) InterfaceChangeCommit(Flags uint32) (err error) {
	var buf []byte

	args := InterfaceChangeCommitArgs {
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(221, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// InterfaceChangeRollback is the go wrapper for REMOTE_PROC_INTERFACE_CHANGE_ROLLBACK.
func (l *Libvirt) InterfaceChangeRollback(Flags uint32) (err error) {
	var buf []byte

	args := InterfaceChangeRollbackArgs {
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(222, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainGetSchedulerParametersFlags is the go wrapper for REMOTE_PROC_DOMAIN_GET_SCHEDULER_PARAMETERS_FLAGS.
func (l *Libvirt) DomainGetSchedulerParametersFlags(Dom Domain, Nparams int32, Flags uint32) (rParams []TypedParam, err error) {
	var buf []byte

	args := DomainGetSchedulerParametersFlagsArgs {
		Dom: Dom,
		Nparams: Nparams,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(223, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Params: []TypedParam
	_, err = dec.Decode(&rParams)
	if err != nil {
		return
	}

	return
}

// DomainEventControlError is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_CONTROL_ERROR.
func (l *Libvirt) DomainEventControlError() (err error) {
	var buf []byte


	_, err = l.requestStream(224, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainPinVcpuFlags is the go wrapper for REMOTE_PROC_DOMAIN_PIN_VCPU_FLAGS.
func (l *Libvirt) DomainPinVcpuFlags(Dom Domain, Vcpu uint32, Cpumap []byte, Flags uint32) (err error) {
	var buf []byte

	args := DomainPinVcpuFlagsArgs {
		Dom: Dom,
		Vcpu: Vcpu,
		Cpumap: Cpumap,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(225, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainSendKey is the go wrapper for REMOTE_PROC_DOMAIN_SEND_KEY.
func (l *Libvirt) DomainSendKey(Dom Domain, Codeset uint32, Holdtime uint32, Keycodes []uint32, Flags uint32) (err error) {
	var buf []byte

	args := DomainSendKeyArgs {
		Dom: Dom,
		Codeset: Codeset,
		Holdtime: Holdtime,
		Keycodes: Keycodes,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(226, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// NodeGetCPUStats is the go wrapper for REMOTE_PROC_NODE_GET_CPU_STATS.
func (l *Libvirt) NodeGetCPUStats(CPUNum int32, Nparams int32, Flags uint32) (rParams []NodeGetCPUStats, rNparams int32, err error) {
	var buf []byte

	args := NodeGetCPUStatsArgs {
		CPUNum: CPUNum,
		Nparams: Nparams,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(227, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Params: []NodeGetCPUStats
	_, err = dec.Decode(&rParams)
	if err != nil {
		return
	}
	// Nparams: int32
	_, err = dec.Decode(&rNparams)
	if err != nil {
		return
	}

	return
}

// NodeGetMemoryStats is the go wrapper for REMOTE_PROC_NODE_GET_MEMORY_STATS.
func (l *Libvirt) NodeGetMemoryStats(Nparams int32, CellNum int32, Flags uint32) (rParams []NodeGetMemoryStats, rNparams int32, err error) {
	var buf []byte

	args := NodeGetMemoryStatsArgs {
		Nparams: Nparams,
		CellNum: CellNum,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(228, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Params: []NodeGetMemoryStats
	_, err = dec.Decode(&rParams)
	if err != nil {
		return
	}
	// Nparams: int32
	_, err = dec.Decode(&rNparams)
	if err != nil {
		return
	}

	return
}

// DomainGetControlInfo is the go wrapper for REMOTE_PROC_DOMAIN_GET_CONTROL_INFO.
func (l *Libvirt) DomainGetControlInfo(Dom Domain, Flags uint32) (rState uint32, rDetails uint32, rStateTime uint64, err error) {
	var buf []byte

	args := DomainGetControlInfoArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(229, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// State: uint32
	_, err = dec.Decode(&rState)
	if err != nil {
		return
	}
	// Details: uint32
	_, err = dec.Decode(&rDetails)
	if err != nil {
		return
	}
	// StateTime: uint64
	_, err = dec.Decode(&rStateTime)
	if err != nil {
		return
	}

	return
}

// DomainGetVcpuPinInfo is the go wrapper for REMOTE_PROC_DOMAIN_GET_VCPU_PIN_INFO.
func (l *Libvirt) DomainGetVcpuPinInfo(Dom Domain, Ncpumaps int32, Maplen int32, Flags uint32) (rCpumaps []byte, rNum int32, err error) {
	var buf []byte

	args := DomainGetVcpuPinInfoArgs {
		Dom: Dom,
		Ncpumaps: Ncpumaps,
		Maplen: Maplen,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(230, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Cpumaps: []byte
	_, err = dec.Decode(&rCpumaps)
	if err != nil {
		return
	}
	// Num: int32
	_, err = dec.Decode(&rNum)
	if err != nil {
		return
	}

	return
}

// DomainUndefineFlags is the go wrapper for REMOTE_PROC_DOMAIN_UNDEFINE_FLAGS.
func (l *Libvirt) DomainUndefineFlags(Dom Domain, Flags DomainUndefineFlagsValues) (err error) {
	var buf []byte

	args := DomainUndefineFlagsArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(231, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainSaveFlags is the go wrapper for REMOTE_PROC_DOMAIN_SAVE_FLAGS.
func (l *Libvirt) DomainSaveFlags(Dom Domain, To string, Dxml OptString, Flags uint32) (err error) {
	var buf []byte

	args := DomainSaveFlagsArgs {
		Dom: Dom,
		To: To,
		Dxml: Dxml,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(232, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainRestoreFlags is the go wrapper for REMOTE_PROC_DOMAIN_RESTORE_FLAGS.
func (l *Libvirt) DomainRestoreFlags(From string, Dxml OptString, Flags uint32) (err error) {
	var buf []byte

	args := DomainRestoreFlagsArgs {
		From: From,
		Dxml: Dxml,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(233, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainDestroyFlags is the go wrapper for REMOTE_PROC_DOMAIN_DESTROY_FLAGS.
func (l *Libvirt) DomainDestroyFlags(Dom Domain, Flags DomainDestroyFlagsValues) (err error) {
	var buf []byte

	args := DomainDestroyFlagsArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(234, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainSaveImageGetXMLDesc is the go wrapper for REMOTE_PROC_DOMAIN_SAVE_IMAGE_GET_XML_DESC.
func (l *Libvirt) DomainSaveImageGetXMLDesc(File string, Flags uint32) (rXML string, err error) {
	var buf []byte

	args := DomainSaveImageGetXMLDescArgs {
		File: File,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(235, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// XML: string
	_, err = dec.Decode(&rXML)
	if err != nil {
		return
	}

	return
}

// DomainSaveImageDefineXML is the go wrapper for REMOTE_PROC_DOMAIN_SAVE_IMAGE_DEFINE_XML.
func (l *Libvirt) DomainSaveImageDefineXML(File string, Dxml string, Flags uint32) (err error) {
	var buf []byte

	args := DomainSaveImageDefineXMLArgs {
		File: File,
		Dxml: Dxml,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(236, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainBlockJobAbort is the go wrapper for REMOTE_PROC_DOMAIN_BLOCK_JOB_ABORT.
func (l *Libvirt) DomainBlockJobAbort(Dom Domain, Path string, Flags DomainBlockJobAbortFlags) (err error) {
	var buf []byte

	args := DomainBlockJobAbortArgs {
		Dom: Dom,
		Path: Path,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(237, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainGetBlockJobInfo is the go wrapper for REMOTE_PROC_DOMAIN_GET_BLOCK_JOB_INFO.
func (l *Libvirt) DomainGetBlockJobInfo(Dom Domain, Path string, Flags uint32) (rFound int32, rType int32, rBandwidth uint64, rCur uint64, rEnd uint64, err error) {
	var buf []byte

	args := DomainGetBlockJobInfoArgs {
		Dom: Dom,
		Path: Path,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(238, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Found: int32
	_, err = dec.Decode(&rFound)
	if err != nil {
		return
	}
	// Type: int32
	_, err = dec.Decode(&rType)
	if err != nil {
		return
	}
	// Bandwidth: uint64
	_, err = dec.Decode(&rBandwidth)
	if err != nil {
		return
	}
	// Cur: uint64
	_, err = dec.Decode(&rCur)
	if err != nil {
		return
	}
	// End: uint64
	_, err = dec.Decode(&rEnd)
	if err != nil {
		return
	}

	return
}

// DomainBlockJobSetSpeed is the go wrapper for REMOTE_PROC_DOMAIN_BLOCK_JOB_SET_SPEED.
func (l *Libvirt) DomainBlockJobSetSpeed(Dom Domain, Path string, Bandwidth uint64, Flags DomainBlockJobSetSpeedFlags) (err error) {
	var buf []byte

	args := DomainBlockJobSetSpeedArgs {
		Dom: Dom,
		Path: Path,
		Bandwidth: Bandwidth,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(239, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainBlockPull is the go wrapper for REMOTE_PROC_DOMAIN_BLOCK_PULL.
func (l *Libvirt) DomainBlockPull(Dom Domain, Path string, Bandwidth uint64, Flags DomainBlockPullFlags) (err error) {
	var buf []byte

	args := DomainBlockPullArgs {
		Dom: Dom,
		Path: Path,
		Bandwidth: Bandwidth,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(240, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventBlockJob is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_BLOCK_JOB.
func (l *Libvirt) DomainEventBlockJob() (err error) {
	var buf []byte


	_, err = l.requestStream(241, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainMigrateGetMaxSpeed is the go wrapper for REMOTE_PROC_DOMAIN_MIGRATE_GET_MAX_SPEED.
func (l *Libvirt) DomainMigrateGetMaxSpeed(Dom Domain, Flags uint32) (rBandwidth uint64, err error) {
	var buf []byte

	args := DomainMigrateGetMaxSpeedArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(242, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Bandwidth: uint64
	_, err = dec.Decode(&rBandwidth)
	if err != nil {
		return
	}

	return
}

// DomainBlockStatsFlags is the go wrapper for REMOTE_PROC_DOMAIN_BLOCK_STATS_FLAGS.
func (l *Libvirt) DomainBlockStatsFlags(Dom Domain, Path string, Nparams int32, Flags uint32) (rParams []TypedParam, rNparams int32, err error) {
	var buf []byte

	args := DomainBlockStatsFlagsArgs {
		Dom: Dom,
		Path: Path,
		Nparams: Nparams,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(243, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Params: []TypedParam
	_, err = dec.Decode(&rParams)
	if err != nil {
		return
	}
	// Nparams: int32
	_, err = dec.Decode(&rNparams)
	if err != nil {
		return
	}

	return
}

// DomainSnapshotGetParent is the go wrapper for REMOTE_PROC_DOMAIN_SNAPSHOT_GET_PARENT.
func (l *Libvirt) DomainSnapshotGetParent(Snap DomainSnapshot, Flags uint32) (rSnap DomainSnapshot, err error) {
	var buf []byte

	args := DomainSnapshotGetParentArgs {
		Snap: Snap,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(244, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Snap: DomainSnapshot
	_, err = dec.Decode(&rSnap)
	if err != nil {
		return
	}

	return
}

// DomainReset is the go wrapper for REMOTE_PROC_DOMAIN_RESET.
func (l *Libvirt) DomainReset(Dom Domain, Flags uint32) (err error) {
	var buf []byte

	args := DomainResetArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(245, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainSnapshotNumChildren is the go wrapper for REMOTE_PROC_DOMAIN_SNAPSHOT_NUM_CHILDREN.
func (l *Libvirt) DomainSnapshotNumChildren(Snap DomainSnapshot, Flags uint32) (rNum int32, err error) {
	var buf []byte

	args := DomainSnapshotNumChildrenArgs {
		Snap: Snap,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(246, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Num: int32
	_, err = dec.Decode(&rNum)
	if err != nil {
		return
	}

	return
}

// DomainSnapshotListChildrenNames is the go wrapper for REMOTE_PROC_DOMAIN_SNAPSHOT_LIST_CHILDREN_NAMES.
func (l *Libvirt) DomainSnapshotListChildrenNames(Snap DomainSnapshot, Maxnames int32, Flags uint32) (rNames []string, err error) {
	var buf []byte

	args := DomainSnapshotListChildrenNamesArgs {
		Snap: Snap,
		Maxnames: Maxnames,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(247, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Names: []string
	_, err = dec.Decode(&rNames)
	if err != nil {
		return
	}

	return
}

// DomainEventDiskChange is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_DISK_CHANGE.
func (l *Libvirt) DomainEventDiskChange() (err error) {
	var buf []byte


	_, err = l.requestStream(248, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainOpenGraphics is the go wrapper for REMOTE_PROC_DOMAIN_OPEN_GRAPHICS.
func (l *Libvirt) DomainOpenGraphics(Dom Domain, Idx uint32, Flags DomainOpenGraphicsFlags) (err error) {
	var buf []byte

	args := DomainOpenGraphicsArgs {
		Dom: Dom,
		Idx: Idx,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(249, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// NodeSuspendForDuration is the go wrapper for REMOTE_PROC_NODE_SUSPEND_FOR_DURATION.
func (l *Libvirt) NodeSuspendForDuration(Target uint32, Duration uint64, Flags uint32) (err error) {
	var buf []byte

	args := NodeSuspendForDurationArgs {
		Target: Target,
		Duration: Duration,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(250, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainBlockResize is the go wrapper for REMOTE_PROC_DOMAIN_BLOCK_RESIZE.
func (l *Libvirt) DomainBlockResize(Dom Domain, Disk string, Size uint64, Flags DomainBlockResizeFlags) (err error) {
	var buf []byte

	args := DomainBlockResizeArgs {
		Dom: Dom,
		Disk: Disk,
		Size: Size,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(251, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainSetBlockIOTune is the go wrapper for REMOTE_PROC_DOMAIN_SET_BLOCK_IO_TUNE.
func (l *Libvirt) DomainSetBlockIOTune(Dom Domain, Disk string, Params []TypedParam, Flags uint32) (err error) {
	var buf []byte

	args := DomainSetBlockIOTuneArgs {
		Dom: Dom,
		Disk: Disk,
		Params: Params,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(252, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainGetBlockIOTune is the go wrapper for REMOTE_PROC_DOMAIN_GET_BLOCK_IO_TUNE.
func (l *Libvirt) DomainGetBlockIOTune(Dom Domain, Disk OptString, Nparams int32, Flags uint32) (rParams []TypedParam, rNparams int32, err error) {
	var buf []byte

	args := DomainGetBlockIOTuneArgs {
		Dom: Dom,
		Disk: Disk,
		Nparams: Nparams,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(253, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Params: []TypedParam
	_, err = dec.Decode(&rParams)
	if err != nil {
		return
	}
	// Nparams: int32
	_, err = dec.Decode(&rNparams)
	if err != nil {
		return
	}

	return
}

// DomainSetNumaParameters is the go wrapper for REMOTE_PROC_DOMAIN_SET_NUMA_PARAMETERS.
func (l *Libvirt) DomainSetNumaParameters(Dom Domain, Params []TypedParam, Flags uint32) (err error) {
	var buf []byte

	args := DomainSetNumaParametersArgs {
		Dom: Dom,
		Params: Params,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(254, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainGetNumaParameters is the go wrapper for REMOTE_PROC_DOMAIN_GET_NUMA_PARAMETERS.
func (l *Libvirt) DomainGetNumaParameters(Dom Domain, Nparams int32, Flags uint32) (rParams []TypedParam, rNparams int32, err error) {
	var buf []byte

	args := DomainGetNumaParametersArgs {
		Dom: Dom,
		Nparams: Nparams,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(255, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Params: []TypedParam
	_, err = dec.Decode(&rParams)
	if err != nil {
		return
	}
	// Nparams: int32
	_, err = dec.Decode(&rNparams)
	if err != nil {
		return
	}

	return
}

// DomainSetInterfaceParameters is the go wrapper for REMOTE_PROC_DOMAIN_SET_INTERFACE_PARAMETERS.
func (l *Libvirt) DomainSetInterfaceParameters(Dom Domain, Device string, Params []TypedParam, Flags uint32) (err error) {
	var buf []byte

	args := DomainSetInterfaceParametersArgs {
		Dom: Dom,
		Device: Device,
		Params: Params,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(256, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainGetInterfaceParameters is the go wrapper for REMOTE_PROC_DOMAIN_GET_INTERFACE_PARAMETERS.
func (l *Libvirt) DomainGetInterfaceParameters(Dom Domain, Device string, Nparams int32, Flags DomainModificationImpact) (rParams []TypedParam, rNparams int32, err error) {
	var buf []byte

	args := DomainGetInterfaceParametersArgs {
		Dom: Dom,
		Device: Device,
		Nparams: Nparams,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(257, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Params: []TypedParam
	_, err = dec.Decode(&rParams)
	if err != nil {
		return
	}
	// Nparams: int32
	_, err = dec.Decode(&rNparams)
	if err != nil {
		return
	}

	return
}

// DomainShutdownFlags is the go wrapper for REMOTE_PROC_DOMAIN_SHUTDOWN_FLAGS.
func (l *Libvirt) DomainShutdownFlags(Dom Domain, Flags DomainShutdownFlagValues) (err error) {
	var buf []byte

	args := DomainShutdownFlagsArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(258, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// StorageVolWipePattern is the go wrapper for REMOTE_PROC_STORAGE_VOL_WIPE_PATTERN.
func (l *Libvirt) StorageVolWipePattern(Vol StorageVol, Algorithm uint32, Flags uint32) (err error) {
	var buf []byte

	args := StorageVolWipePatternArgs {
		Vol: Vol,
		Algorithm: Algorithm,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(259, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// StorageVolResize is the go wrapper for REMOTE_PROC_STORAGE_VOL_RESIZE.
func (l *Libvirt) StorageVolResize(Vol StorageVol, Capacity uint64, Flags StorageVolResizeFlags) (err error) {
	var buf []byte

	args := StorageVolResizeArgs {
		Vol: Vol,
		Capacity: Capacity,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(260, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainPmSuspendForDuration is the go wrapper for REMOTE_PROC_DOMAIN_PM_SUSPEND_FOR_DURATION.
func (l *Libvirt) DomainPmSuspendForDuration(Dom Domain, Target uint32, Duration uint64, Flags uint32) (err error) {
	var buf []byte

	args := DomainPmSuspendForDurationArgs {
		Dom: Dom,
		Target: Target,
		Duration: Duration,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(261, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainGetCPUStats is the go wrapper for REMOTE_PROC_DOMAIN_GET_CPU_STATS.
func (l *Libvirt) DomainGetCPUStats(Dom Domain, Nparams uint32, StartCPU int32, Ncpus uint32, Flags TypedParameterFlags) (rParams []TypedParam, rNparams int32, err error) {
	var buf []byte

	args := DomainGetCPUStatsArgs {
		Dom: Dom,
		Nparams: Nparams,
		StartCPU: StartCPU,
		Ncpus: Ncpus,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(262, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Params: []TypedParam
	_, err = dec.Decode(&rParams)
	if err != nil {
		return
	}
	// Nparams: int32
	_, err = dec.Decode(&rNparams)
	if err != nil {
		return
	}

	return
}

// DomainGetDiskErrors is the go wrapper for REMOTE_PROC_DOMAIN_GET_DISK_ERRORS.
func (l *Libvirt) DomainGetDiskErrors(Dom Domain, Maxerrors uint32, Flags uint32) (rErrors []DomainDiskError, rNerrors int32, err error) {
	var buf []byte

	args := DomainGetDiskErrorsArgs {
		Dom: Dom,
		Maxerrors: Maxerrors,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(263, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Errors: []DomainDiskError
	_, err = dec.Decode(&rErrors)
	if err != nil {
		return
	}
	// Nerrors: int32
	_, err = dec.Decode(&rNerrors)
	if err != nil {
		return
	}

	return
}

// DomainSetMetadata is the go wrapper for REMOTE_PROC_DOMAIN_SET_METADATA.
func (l *Libvirt) DomainSetMetadata(Dom Domain, Type int32, Metadata OptString, Key OptString, Uri OptString, Flags DomainModificationImpact) (err error) {
	var buf []byte

	args := DomainSetMetadataArgs {
		Dom: Dom,
		Type: Type,
		Metadata: Metadata,
		Key: Key,
		Uri: Uri,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(264, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainGetMetadata is the go wrapper for REMOTE_PROC_DOMAIN_GET_METADATA.
func (l *Libvirt) DomainGetMetadata(Dom Domain, Type int32, Uri OptString, Flags DomainModificationImpact) (rMetadata string, err error) {
	var buf []byte

	args := DomainGetMetadataArgs {
		Dom: Dom,
		Type: Type,
		Uri: Uri,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(265, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Metadata: string
	_, err = dec.Decode(&rMetadata)
	if err != nil {
		return
	}

	return
}

// DomainBlockRebase is the go wrapper for REMOTE_PROC_DOMAIN_BLOCK_REBASE.
func (l *Libvirt) DomainBlockRebase(Dom Domain, Path string, Base OptString, Bandwidth uint64, Flags DomainBlockRebaseFlags) (err error) {
	var buf []byte

	args := DomainBlockRebaseArgs {
		Dom: Dom,
		Path: Path,
		Base: Base,
		Bandwidth: Bandwidth,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(266, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainPmWakeup is the go wrapper for REMOTE_PROC_DOMAIN_PM_WAKEUP.
func (l *Libvirt) DomainPmWakeup(Dom Domain, Flags uint32) (err error) {
	var buf []byte

	args := DomainPmWakeupArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(267, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventTrayChange is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_TRAY_CHANGE.
func (l *Libvirt) DomainEventTrayChange() (err error) {
	var buf []byte


	_, err = l.requestStream(268, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventPmwakeup is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_PMWAKEUP.
func (l *Libvirt) DomainEventPmwakeup() (err error) {
	var buf []byte


	_, err = l.requestStream(269, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventPmsuspend is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_PMSUSPEND.
func (l *Libvirt) DomainEventPmsuspend() (err error) {
	var buf []byte


	_, err = l.requestStream(270, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainSnapshotIsCurrent is the go wrapper for REMOTE_PROC_DOMAIN_SNAPSHOT_IS_CURRENT.
func (l *Libvirt) DomainSnapshotIsCurrent(Snap DomainSnapshot, Flags uint32) (rCurrent int32, err error) {
	var buf []byte

	args := DomainSnapshotIsCurrentArgs {
		Snap: Snap,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(271, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Current: int32
	_, err = dec.Decode(&rCurrent)
	if err != nil {
		return
	}

	return
}

// DomainSnapshotHasMetadata is the go wrapper for REMOTE_PROC_DOMAIN_SNAPSHOT_HAS_METADATA.
func (l *Libvirt) DomainSnapshotHasMetadata(Snap DomainSnapshot, Flags uint32) (rMetadata int32, err error) {
	var buf []byte

	args := DomainSnapshotHasMetadataArgs {
		Snap: Snap,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(272, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Metadata: int32
	_, err = dec.Decode(&rMetadata)
	if err != nil {
		return
	}

	return
}

// ConnectListAllDomains is the go wrapper for REMOTE_PROC_CONNECT_LIST_ALL_DOMAINS.
func (l *Libvirt) ConnectListAllDomains(NeedResults int32, Flags ConnectListAllDomainsFlags) (rDomains []Domain, rRet uint32, err error) {
	var buf []byte

	args := ConnectListAllDomainsArgs {
		NeedResults: NeedResults,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(273, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Domains: []Domain
	_, err = dec.Decode(&rDomains)
	if err != nil {
		return
	}
	// Ret: uint32
	_, err = dec.Decode(&rRet)
	if err != nil {
		return
	}

	return
}

// DomainListAllSnapshots is the go wrapper for REMOTE_PROC_DOMAIN_LIST_ALL_SNAPSHOTS.
func (l *Libvirt) DomainListAllSnapshots(Dom Domain, NeedResults int32, Flags uint32) (rSnapshots []DomainSnapshot, rRet int32, err error) {
	var buf []byte

	args := DomainListAllSnapshotsArgs {
		Dom: Dom,
		NeedResults: NeedResults,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(274, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Snapshots: []DomainSnapshot
	_, err = dec.Decode(&rSnapshots)
	if err != nil {
		return
	}
	// Ret: int32
	_, err = dec.Decode(&rRet)
	if err != nil {
		return
	}

	return
}

// DomainSnapshotListAllChildren is the go wrapper for REMOTE_PROC_DOMAIN_SNAPSHOT_LIST_ALL_CHILDREN.
func (l *Libvirt) DomainSnapshotListAllChildren(Snapshot DomainSnapshot, NeedResults int32, Flags uint32) (rSnapshots []DomainSnapshot, rRet int32, err error) {
	var buf []byte

	args := DomainSnapshotListAllChildrenArgs {
		Snapshot: Snapshot,
		NeedResults: NeedResults,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(275, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Snapshots: []DomainSnapshot
	_, err = dec.Decode(&rSnapshots)
	if err != nil {
		return
	}
	// Ret: int32
	_, err = dec.Decode(&rRet)
	if err != nil {
		return
	}

	return
}

// DomainEventBalloonChange is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_BALLOON_CHANGE.
func (l *Libvirt) DomainEventBalloonChange() (err error) {
	var buf []byte


	_, err = l.requestStream(276, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainGetHostname is the go wrapper for REMOTE_PROC_DOMAIN_GET_HOSTNAME.
func (l *Libvirt) DomainGetHostname(Dom Domain, Flags uint32) (rHostname string, err error) {
	var buf []byte

	args := DomainGetHostnameArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(277, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Hostname: string
	_, err = dec.Decode(&rHostname)
	if err != nil {
		return
	}

	return
}

// DomainGetSecurityLabelList is the go wrapper for REMOTE_PROC_DOMAIN_GET_SECURITY_LABEL_LIST.
func (l *Libvirt) DomainGetSecurityLabelList(Dom Domain) (rLabels []DomainGetSecurityLabelRet, rRet int32, err error) {
	var buf []byte

	args := DomainGetSecurityLabelListArgs {
		Dom: Dom,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(278, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Labels: []DomainGetSecurityLabelRet
	_, err = dec.Decode(&rLabels)
	if err != nil {
		return
	}
	// Ret: int32
	_, err = dec.Decode(&rRet)
	if err != nil {
		return
	}

	return
}

// DomainPinEmulator is the go wrapper for REMOTE_PROC_DOMAIN_PIN_EMULATOR.
func (l *Libvirt) DomainPinEmulator(Dom Domain, Cpumap []byte, Flags DomainModificationImpact) (err error) {
	var buf []byte

	args := DomainPinEmulatorArgs {
		Dom: Dom,
		Cpumap: Cpumap,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(279, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainGetEmulatorPinInfo is the go wrapper for REMOTE_PROC_DOMAIN_GET_EMULATOR_PIN_INFO.
func (l *Libvirt) DomainGetEmulatorPinInfo(Dom Domain, Maplen int32, Flags DomainModificationImpact) (rCpumaps []byte, rRet int32, err error) {
	var buf []byte

	args := DomainGetEmulatorPinInfoArgs {
		Dom: Dom,
		Maplen: Maplen,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(280, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Cpumaps: []byte
	_, err = dec.Decode(&rCpumaps)
	if err != nil {
		return
	}
	// Ret: int32
	_, err = dec.Decode(&rRet)
	if err != nil {
		return
	}

	return
}

// ConnectListAllStoragePools is the go wrapper for REMOTE_PROC_CONNECT_LIST_ALL_STORAGE_POOLS.
func (l *Libvirt) ConnectListAllStoragePools(NeedResults int32, Flags ConnectListAllStoragePoolsFlags) (rPools []StoragePool, rRet uint32, err error) {
	var buf []byte

	args := ConnectListAllStoragePoolsArgs {
		NeedResults: NeedResults,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(281, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Pools: []StoragePool
	_, err = dec.Decode(&rPools)
	if err != nil {
		return
	}
	// Ret: uint32
	_, err = dec.Decode(&rRet)
	if err != nil {
		return
	}

	return
}

// StoragePoolListAllVolumes is the go wrapper for REMOTE_PROC_STORAGE_POOL_LIST_ALL_VOLUMES.
func (l *Libvirt) StoragePoolListAllVolumes(Pool StoragePool, NeedResults int32, Flags uint32) (rVols []StorageVol, rRet uint32, err error) {
	var buf []byte

	args := StoragePoolListAllVolumesArgs {
		Pool: Pool,
		NeedResults: NeedResults,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(282, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Vols: []StorageVol
	_, err = dec.Decode(&rVols)
	if err != nil {
		return
	}
	// Ret: uint32
	_, err = dec.Decode(&rRet)
	if err != nil {
		return
	}

	return
}

// ConnectListAllNetworks is the go wrapper for REMOTE_PROC_CONNECT_LIST_ALL_NETWORKS.
func (l *Libvirt) ConnectListAllNetworks(NeedResults int32, Flags ConnectListAllNetworksFlags) (rNets []Network, rRet uint32, err error) {
	var buf []byte

	args := ConnectListAllNetworksArgs {
		NeedResults: NeedResults,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(283, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Nets: []Network
	_, err = dec.Decode(&rNets)
	if err != nil {
		return
	}
	// Ret: uint32
	_, err = dec.Decode(&rRet)
	if err != nil {
		return
	}

	return
}

// ConnectListAllInterfaces is the go wrapper for REMOTE_PROC_CONNECT_LIST_ALL_INTERFACES.
func (l *Libvirt) ConnectListAllInterfaces(NeedResults int32, Flags ConnectListAllInterfacesFlags) (rIfaces []Interface, rRet uint32, err error) {
	var buf []byte

	args := ConnectListAllInterfacesArgs {
		NeedResults: NeedResults,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(284, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Ifaces: []Interface
	_, err = dec.Decode(&rIfaces)
	if err != nil {
		return
	}
	// Ret: uint32
	_, err = dec.Decode(&rRet)
	if err != nil {
		return
	}

	return
}

// ConnectListAllNodeDevices is the go wrapper for REMOTE_PROC_CONNECT_LIST_ALL_NODE_DEVICES.
func (l *Libvirt) ConnectListAllNodeDevices(NeedResults int32, Flags uint32) (rDevices []NodeDevice, rRet uint32, err error) {
	var buf []byte

	args := ConnectListAllNodeDevicesArgs {
		NeedResults: NeedResults,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(285, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Devices: []NodeDevice
	_, err = dec.Decode(&rDevices)
	if err != nil {
		return
	}
	// Ret: uint32
	_, err = dec.Decode(&rRet)
	if err != nil {
		return
	}

	return
}

// ConnectListAllNwfilters is the go wrapper for REMOTE_PROC_CONNECT_LIST_ALL_NWFILTERS.
func (l *Libvirt) ConnectListAllNwfilters(NeedResults int32, Flags uint32) (rFilters []Nwfilter, rRet uint32, err error) {
	var buf []byte

	args := ConnectListAllNwfiltersArgs {
		NeedResults: NeedResults,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(286, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Filters: []Nwfilter
	_, err = dec.Decode(&rFilters)
	if err != nil {
		return
	}
	// Ret: uint32
	_, err = dec.Decode(&rRet)
	if err != nil {
		return
	}

	return
}

// ConnectListAllSecrets is the go wrapper for REMOTE_PROC_CONNECT_LIST_ALL_SECRETS.
func (l *Libvirt) ConnectListAllSecrets(NeedResults int32, Flags ConnectListAllSecretsFlags) (rSecrets []Secret, rRet uint32, err error) {
	var buf []byte

	args := ConnectListAllSecretsArgs {
		NeedResults: NeedResults,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(287, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Secrets: []Secret
	_, err = dec.Decode(&rSecrets)
	if err != nil {
		return
	}
	// Ret: uint32
	_, err = dec.Decode(&rRet)
	if err != nil {
		return
	}

	return
}

// NodeSetMemoryParameters is the go wrapper for REMOTE_PROC_NODE_SET_MEMORY_PARAMETERS.
func (l *Libvirt) NodeSetMemoryParameters(Params []TypedParam, Flags uint32) (err error) {
	var buf []byte

	args := NodeSetMemoryParametersArgs {
		Params: Params,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(288, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// NodeGetMemoryParameters is the go wrapper for REMOTE_PROC_NODE_GET_MEMORY_PARAMETERS.
func (l *Libvirt) NodeGetMemoryParameters(Nparams int32, Flags uint32) (rParams []TypedParam, rNparams int32, err error) {
	var buf []byte

	args := NodeGetMemoryParametersArgs {
		Nparams: Nparams,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(289, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Params: []TypedParam
	_, err = dec.Decode(&rParams)
	if err != nil {
		return
	}
	// Nparams: int32
	_, err = dec.Decode(&rNparams)
	if err != nil {
		return
	}

	return
}

// DomainBlockCommit is the go wrapper for REMOTE_PROC_DOMAIN_BLOCK_COMMIT.
func (l *Libvirt) DomainBlockCommit(Dom Domain, Disk string, Base OptString, Top OptString, Bandwidth uint64, Flags DomainBlockCommitFlags) (err error) {
	var buf []byte

	args := DomainBlockCommitArgs {
		Dom: Dom,
		Disk: Disk,
		Base: Base,
		Top: Top,
		Bandwidth: Bandwidth,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(290, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// NetworkUpdate is the go wrapper for REMOTE_PROC_NETWORK_UPDATE.
func (l *Libvirt) NetworkUpdate(Net Network, Command uint32, Section uint32, ParentIndex int32, XML string, Flags NetworkUpdateFlags) (err error) {
	var buf []byte

	args := NetworkUpdateArgs {
		Net: Net,
		Command: Command,
		Section: Section,
		ParentIndex: ParentIndex,
		XML: XML,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(291, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventPmsuspendDisk is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_PMSUSPEND_DISK.
func (l *Libvirt) DomainEventPmsuspendDisk() (err error) {
	var buf []byte


	_, err = l.requestStream(292, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// NodeGetCPUMap is the go wrapper for REMOTE_PROC_NODE_GET_CPU_MAP.
func (l *Libvirt) NodeGetCPUMap(NeedMap int32, NeedOnline int32, Flags uint32) (rCpumap []byte, rOnline uint32, rRet int32, err error) {
	var buf []byte

	args := NodeGetCPUMapArgs {
		NeedMap: NeedMap,
		NeedOnline: NeedOnline,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(293, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Cpumap: []byte
	_, err = dec.Decode(&rCpumap)
	if err != nil {
		return
	}
	// Online: uint32
	_, err = dec.Decode(&rOnline)
	if err != nil {
		return
	}
	// Ret: int32
	_, err = dec.Decode(&rRet)
	if err != nil {
		return
	}

	return
}

// DomainFstrim is the go wrapper for REMOTE_PROC_DOMAIN_FSTRIM.
func (l *Libvirt) DomainFstrim(Dom Domain, MountPoint OptString, Minimum uint64, Flags uint32) (err error) {
	var buf []byte

	args := DomainFstrimArgs {
		Dom: Dom,
		MountPoint: MountPoint,
		Minimum: Minimum,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(294, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainSendProcessSignal is the go wrapper for REMOTE_PROC_DOMAIN_SEND_PROCESS_SIGNAL.
func (l *Libvirt) DomainSendProcessSignal(Dom Domain, PidValue int64, Signum uint32, Flags uint32) (err error) {
	var buf []byte

	args := DomainSendProcessSignalArgs {
		Dom: Dom,
		PidValue: PidValue,
		Signum: Signum,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(295, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainOpenChannel is the go wrapper for REMOTE_PROC_DOMAIN_OPEN_CHANNEL.
func (l *Libvirt) DomainOpenChannel(Dom Domain, Name OptString, inStream io.Writer, Flags DomainChannelFlags) (err error) {
	var buf []byte

	args := DomainOpenChannelArgs {
		Dom: Dom,
		Name: Name,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(296, constants.Program, buf, nil, inStream)
	if err != nil {
		return
	}

	return
}

// NodeDeviceLookupScsiHostByWwn is the go wrapper for REMOTE_PROC_NODE_DEVICE_LOOKUP_SCSI_HOST_BY_WWN.
func (l *Libvirt) NodeDeviceLookupScsiHostByWwn(Wwnn string, Wwpn string, Flags uint32) (rDev NodeDevice, err error) {
	var buf []byte

	args := NodeDeviceLookupScsiHostByWwnArgs {
		Wwnn: Wwnn,
		Wwpn: Wwpn,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(297, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Dev: NodeDevice
	_, err = dec.Decode(&rDev)
	if err != nil {
		return
	}

	return
}

// DomainGetJobStats is the go wrapper for REMOTE_PROC_DOMAIN_GET_JOB_STATS.
func (l *Libvirt) DomainGetJobStats(Dom Domain, Flags DomainGetJobStatsFlags) (rType int32, rParams []TypedParam, err error) {
	var buf []byte

	args := DomainGetJobStatsArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(298, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Type: int32
	_, err = dec.Decode(&rType)
	if err != nil {
		return
	}
	// Params: []TypedParam
	_, err = dec.Decode(&rParams)
	if err != nil {
		return
	}

	return
}

// DomainMigrateGetCompressionCache is the go wrapper for REMOTE_PROC_DOMAIN_MIGRATE_GET_COMPRESSION_CACHE.
func (l *Libvirt) DomainMigrateGetCompressionCache(Dom Domain, Flags uint32) (rCacheSize uint64, err error) {
	var buf []byte

	args := DomainMigrateGetCompressionCacheArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(299, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// CacheSize: uint64
	_, err = dec.Decode(&rCacheSize)
	if err != nil {
		return
	}

	return
}

// DomainMigrateSetCompressionCache is the go wrapper for REMOTE_PROC_DOMAIN_MIGRATE_SET_COMPRESSION_CACHE.
func (l *Libvirt) DomainMigrateSetCompressionCache(Dom Domain, CacheSize uint64, Flags uint32) (err error) {
	var buf []byte

	args := DomainMigrateSetCompressionCacheArgs {
		Dom: Dom,
		CacheSize: CacheSize,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(300, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// NodeDeviceDetachFlags is the go wrapper for REMOTE_PROC_NODE_DEVICE_DETACH_FLAGS.
func (l *Libvirt) NodeDeviceDetachFlags(Name string, DriverName OptString, Flags uint32) (err error) {
	var buf []byte

	args := NodeDeviceDetachFlagsArgs {
		Name: Name,
		DriverName: DriverName,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(301, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainMigrateBegin3Params is the go wrapper for REMOTE_PROC_DOMAIN_MIGRATE_BEGIN3_PARAMS.
func (l *Libvirt) DomainMigrateBegin3Params(Dom Domain, Params []TypedParam, Flags uint32) (rCookieOut []byte, rXML string, err error) {
	var buf []byte

	args := DomainMigrateBegin3ParamsArgs {
		Dom: Dom,
		Params: Params,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(302, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// CookieOut: []byte
	_, err = dec.Decode(&rCookieOut)
	if err != nil {
		return
	}
	// XML: string
	_, err = dec.Decode(&rXML)
	if err != nil {
		return
	}

	return
}

// DomainMigratePrepare3Params is the go wrapper for REMOTE_PROC_DOMAIN_MIGRATE_PREPARE3_PARAMS.
func (l *Libvirt) DomainMigratePrepare3Params(Params []TypedParam, CookieIn []byte, Flags uint32) (rCookieOut []byte, rUriOut OptString, err error) {
	var buf []byte

	args := DomainMigratePrepare3ParamsArgs {
		Params: Params,
		CookieIn: CookieIn,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(303, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// CookieOut: []byte
	_, err = dec.Decode(&rCookieOut)
	if err != nil {
		return
	}
	// UriOut: OptString
	_, err = dec.Decode(&rUriOut)
	if err != nil {
		return
	}

	return
}

// DomainMigratePrepareTunnel3Params is the go wrapper for REMOTE_PROC_DOMAIN_MIGRATE_PREPARE_TUNNEL3_PARAMS.
func (l *Libvirt) DomainMigratePrepareTunnel3Params(Params []TypedParam, CookieIn []byte, Flags uint32) (rCookieOut []byte, err error) {
	var buf []byte

	args := DomainMigratePrepareTunnel3ParamsArgs {
		Params: Params,
		CookieIn: CookieIn,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(304, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// CookieOut: []byte
	_, err = dec.Decode(&rCookieOut)
	if err != nil {
		return
	}

	return
}

// DomainMigratePerform3Params is the go wrapper for REMOTE_PROC_DOMAIN_MIGRATE_PERFORM3_PARAMS.
func (l *Libvirt) DomainMigratePerform3Params(Dom Domain, Dconnuri OptString, Params []TypedParam, CookieIn []byte, Flags DomainMigrateFlags) (rCookieOut []byte, err error) {
	var buf []byte

	args := DomainMigratePerform3ParamsArgs {
		Dom: Dom,
		Dconnuri: Dconnuri,
		Params: Params,
		CookieIn: CookieIn,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(305, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// CookieOut: []byte
	_, err = dec.Decode(&rCookieOut)
	if err != nil {
		return
	}

	return
}

// DomainMigrateFinish3Params is the go wrapper for REMOTE_PROC_DOMAIN_MIGRATE_FINISH3_PARAMS.
func (l *Libvirt) DomainMigrateFinish3Params(Params []TypedParam, CookieIn []byte, Flags uint32, Cancelled int32) (rDom Domain, rCookieOut []byte, err error) {
	var buf []byte

	args := DomainMigrateFinish3ParamsArgs {
		Params: Params,
		CookieIn: CookieIn,
		Flags: Flags,
		Cancelled: Cancelled,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(306, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Dom: Domain
	_, err = dec.Decode(&rDom)
	if err != nil {
		return
	}
	// CookieOut: []byte
	_, err = dec.Decode(&rCookieOut)
	if err != nil {
		return
	}

	return
}

// DomainMigrateConfirm3Params is the go wrapper for REMOTE_PROC_DOMAIN_MIGRATE_CONFIRM3_PARAMS.
func (l *Libvirt) DomainMigrateConfirm3Params(Dom Domain, Params []TypedParam, CookieIn []byte, Flags uint32, Cancelled int32) (err error) {
	var buf []byte

	args := DomainMigrateConfirm3ParamsArgs {
		Dom: Dom,
		Params: Params,
		CookieIn: CookieIn,
		Flags: Flags,
		Cancelled: Cancelled,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(307, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainSetMemoryStatsPeriod is the go wrapper for REMOTE_PROC_DOMAIN_SET_MEMORY_STATS_PERIOD.
func (l *Libvirt) DomainSetMemoryStatsPeriod(Dom Domain, Period int32, Flags DomainMemoryModFlags) (err error) {
	var buf []byte

	args := DomainSetMemoryStatsPeriodArgs {
		Dom: Dom,
		Period: Period,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(308, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainCreateXMLWithFiles is the go wrapper for REMOTE_PROC_DOMAIN_CREATE_XML_WITH_FILES.
func (l *Libvirt) DomainCreateXMLWithFiles(XMLDesc string, Flags DomainCreateFlags) (rDom Domain, err error) {
	var buf []byte

	args := DomainCreateXMLWithFilesArgs {
		XMLDesc: XMLDesc,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(309, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Dom: Domain
	_, err = dec.Decode(&rDom)
	if err != nil {
		return
	}

	return
}

// DomainCreateWithFiles is the go wrapper for REMOTE_PROC_DOMAIN_CREATE_WITH_FILES.
func (l *Libvirt) DomainCreateWithFiles(Dom Domain, Flags DomainCreateFlags) (rDom Domain, err error) {
	var buf []byte

	args := DomainCreateWithFilesArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(310, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Dom: Domain
	_, err = dec.Decode(&rDom)
	if err != nil {
		return
	}

	return
}

// DomainEventDeviceRemoved is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_DEVICE_REMOVED.
func (l *Libvirt) DomainEventDeviceRemoved() (err error) {
	var buf []byte


	_, err = l.requestStream(311, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// ConnectGetCPUModelNames is the go wrapper for REMOTE_PROC_CONNECT_GET_CPU_MODEL_NAMES.
func (l *Libvirt) ConnectGetCPUModelNames(Arch string, NeedResults int32, Flags uint32) (rModels []string, rRet int32, err error) {
	var buf []byte

	args := ConnectGetCPUModelNamesArgs {
		Arch: Arch,
		NeedResults: NeedResults,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(312, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Models: []string
	_, err = dec.Decode(&rModels)
	if err != nil {
		return
	}
	// Ret: int32
	_, err = dec.Decode(&rRet)
	if err != nil {
		return
	}

	return
}

// ConnectNetworkEventRegisterAny is the go wrapper for REMOTE_PROC_CONNECT_NETWORK_EVENT_REGISTER_ANY.
func (l *Libvirt) ConnectNetworkEventRegisterAny(EventID int32, Net OptNetwork) (rCallbackID int32, err error) {
	var buf []byte

	args := ConnectNetworkEventRegisterAnyArgs {
		EventID: EventID,
		Net: Net,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(313, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// CallbackID: int32
	_, err = dec.Decode(&rCallbackID)
	if err != nil {
		return
	}

	return
}

// ConnectNetworkEventDeregisterAny is the go wrapper for REMOTE_PROC_CONNECT_NETWORK_EVENT_DEREGISTER_ANY.
func (l *Libvirt) ConnectNetworkEventDeregisterAny(CallbackID int32) (err error) {
	var buf []byte

	args := ConnectNetworkEventDeregisterAnyArgs {
		CallbackID: CallbackID,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(314, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// NetworkEventLifecycle is the go wrapper for REMOTE_PROC_NETWORK_EVENT_LIFECYCLE.
func (l *Libvirt) NetworkEventLifecycle() (err error) {
	var buf []byte


	_, err = l.requestStream(315, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// ConnectDomainEventCallbackRegisterAny is the go wrapper for REMOTE_PROC_CONNECT_DOMAIN_EVENT_CALLBACK_REGISTER_ANY.
func (l *Libvirt) ConnectDomainEventCallbackRegisterAny(EventID int32, Dom OptDomain) (rCallbackID int32, err error) {
	var buf []byte

	args := ConnectDomainEventCallbackRegisterAnyArgs {
		EventID: EventID,
		Dom: Dom,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(316, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// CallbackID: int32
	_, err = dec.Decode(&rCallbackID)
	if err != nil {
		return
	}

	return
}

// ConnectDomainEventCallbackDeregisterAny is the go wrapper for REMOTE_PROC_CONNECT_DOMAIN_EVENT_CALLBACK_DEREGISTER_ANY.
func (l *Libvirt) ConnectDomainEventCallbackDeregisterAny(CallbackID int32) (err error) {
	var buf []byte

	args := ConnectDomainEventCallbackDeregisterAnyArgs {
		CallbackID: CallbackID,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(317, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventCallbackLifecycle is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_CALLBACK_LIFECYCLE.
func (l *Libvirt) DomainEventCallbackLifecycle() (err error) {
	var buf []byte


	_, err = l.requestStream(318, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventCallbackReboot is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_CALLBACK_REBOOT.
func (l *Libvirt) DomainEventCallbackReboot() (err error) {
	var buf []byte


	_, err = l.requestStream(319, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventCallbackRtcChange is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_CALLBACK_RTC_CHANGE.
func (l *Libvirt) DomainEventCallbackRtcChange() (err error) {
	var buf []byte


	_, err = l.requestStream(320, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventCallbackWatchdog is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_CALLBACK_WATCHDOG.
func (l *Libvirt) DomainEventCallbackWatchdog() (err error) {
	var buf []byte


	_, err = l.requestStream(321, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventCallbackIOError is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_CALLBACK_IO_ERROR.
func (l *Libvirt) DomainEventCallbackIOError() (err error) {
	var buf []byte


	_, err = l.requestStream(322, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventCallbackGraphics is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_CALLBACK_GRAPHICS.
func (l *Libvirt) DomainEventCallbackGraphics() (err error) {
	var buf []byte


	_, err = l.requestStream(323, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventCallbackIOErrorReason is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_CALLBACK_IO_ERROR_REASON.
func (l *Libvirt) DomainEventCallbackIOErrorReason() (err error) {
	var buf []byte


	_, err = l.requestStream(324, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventCallbackControlError is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_CALLBACK_CONTROL_ERROR.
func (l *Libvirt) DomainEventCallbackControlError() (err error) {
	var buf []byte


	_, err = l.requestStream(325, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventCallbackBlockJob is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_CALLBACK_BLOCK_JOB.
func (l *Libvirt) DomainEventCallbackBlockJob() (err error) {
	var buf []byte


	_, err = l.requestStream(326, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventCallbackDiskChange is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_CALLBACK_DISK_CHANGE.
func (l *Libvirt) DomainEventCallbackDiskChange() (err error) {
	var buf []byte


	_, err = l.requestStream(327, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventCallbackTrayChange is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_CALLBACK_TRAY_CHANGE.
func (l *Libvirt) DomainEventCallbackTrayChange() (err error) {
	var buf []byte


	_, err = l.requestStream(328, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventCallbackPmwakeup is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_CALLBACK_PMWAKEUP.
func (l *Libvirt) DomainEventCallbackPmwakeup() (err error) {
	var buf []byte


	_, err = l.requestStream(329, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventCallbackPmsuspend is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_CALLBACK_PMSUSPEND.
func (l *Libvirt) DomainEventCallbackPmsuspend() (err error) {
	var buf []byte


	_, err = l.requestStream(330, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventCallbackBalloonChange is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_CALLBACK_BALLOON_CHANGE.
func (l *Libvirt) DomainEventCallbackBalloonChange() (err error) {
	var buf []byte


	_, err = l.requestStream(331, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventCallbackPmsuspendDisk is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_CALLBACK_PMSUSPEND_DISK.
func (l *Libvirt) DomainEventCallbackPmsuspendDisk() (err error) {
	var buf []byte


	_, err = l.requestStream(332, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventCallbackDeviceRemoved is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_CALLBACK_DEVICE_REMOVED.
func (l *Libvirt) DomainEventCallbackDeviceRemoved() (err error) {
	var buf []byte


	_, err = l.requestStream(333, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainCoreDumpWithFormat is the go wrapper for REMOTE_PROC_DOMAIN_CORE_DUMP_WITH_FORMAT.
func (l *Libvirt) DomainCoreDumpWithFormat(Dom Domain, To string, Dumpformat uint32, Flags DomainCoreDumpFlags) (err error) {
	var buf []byte

	args := DomainCoreDumpWithFormatArgs {
		Dom: Dom,
		To: To,
		Dumpformat: Dumpformat,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(334, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainFsfreeze is the go wrapper for REMOTE_PROC_DOMAIN_FSFREEZE.
func (l *Libvirt) DomainFsfreeze(Dom Domain, Mountpoints []string, Flags uint32) (rFilesystems int32, err error) {
	var buf []byte

	args := DomainFsfreezeArgs {
		Dom: Dom,
		Mountpoints: Mountpoints,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(335, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Filesystems: int32
	_, err = dec.Decode(&rFilesystems)
	if err != nil {
		return
	}

	return
}

// DomainFsthaw is the go wrapper for REMOTE_PROC_DOMAIN_FSTHAW.
func (l *Libvirt) DomainFsthaw(Dom Domain, Mountpoints []string, Flags uint32) (rFilesystems int32, err error) {
	var buf []byte

	args := DomainFsthawArgs {
		Dom: Dom,
		Mountpoints: Mountpoints,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(336, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Filesystems: int32
	_, err = dec.Decode(&rFilesystems)
	if err != nil {
		return
	}

	return
}

// DomainGetTime is the go wrapper for REMOTE_PROC_DOMAIN_GET_TIME.
func (l *Libvirt) DomainGetTime(Dom Domain, Flags uint32) (rSeconds int64, rNseconds uint32, err error) {
	var buf []byte

	args := DomainGetTimeArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(337, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Seconds: int64
	_, err = dec.Decode(&rSeconds)
	if err != nil {
		return
	}
	// Nseconds: uint32
	_, err = dec.Decode(&rNseconds)
	if err != nil {
		return
	}

	return
}

// DomainSetTime is the go wrapper for REMOTE_PROC_DOMAIN_SET_TIME.
func (l *Libvirt) DomainSetTime(Dom Domain, Seconds int64, Nseconds uint32, Flags DomainSetTimeFlags) (err error) {
	var buf []byte

	args := DomainSetTimeArgs {
		Dom: Dom,
		Seconds: Seconds,
		Nseconds: Nseconds,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(338, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventBlockJob2 is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_BLOCK_JOB_2.
func (l *Libvirt) DomainEventBlockJob2() (err error) {
	var buf []byte


	_, err = l.requestStream(339, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// NodeGetFreePages is the go wrapper for REMOTE_PROC_NODE_GET_FREE_PAGES.
func (l *Libvirt) NodeGetFreePages(Pages []uint32, StartCell int32, CellCount uint32, Flags uint32) (rCounts []uint64, err error) {
	var buf []byte

	args := NodeGetFreePagesArgs {
		Pages: Pages,
		StartCell: StartCell,
		CellCount: CellCount,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(340, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Counts: []uint64
	_, err = dec.Decode(&rCounts)
	if err != nil {
		return
	}

	return
}

// NetworkGetDhcpLeases is the go wrapper for REMOTE_PROC_NETWORK_GET_DHCP_LEASES.
func (l *Libvirt) NetworkGetDhcpLeases(Net Network, Mac OptString, NeedResults int32, Flags uint32) (rLeases []NetworkDhcpLease, rRet uint32, err error) {
	var buf []byte

	args := NetworkGetDhcpLeasesArgs {
		Net: Net,
		Mac: Mac,
		NeedResults: NeedResults,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(341, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Leases: []NetworkDhcpLease
	_, err = dec.Decode(&rLeases)
	if err != nil {
		return
	}
	// Ret: uint32
	_, err = dec.Decode(&rRet)
	if err != nil {
		return
	}

	return
}

// ConnectGetDomainCapabilities is the go wrapper for REMOTE_PROC_CONNECT_GET_DOMAIN_CAPABILITIES.
func (l *Libvirt) ConnectGetDomainCapabilities(Emulatorbin OptString, Arch OptString, Machine OptString, Virttype OptString, Flags uint32) (rCapabilities string, err error) {
	var buf []byte

	args := ConnectGetDomainCapabilitiesArgs {
		Emulatorbin: Emulatorbin,
		Arch: Arch,
		Machine: Machine,
		Virttype: Virttype,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(342, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Capabilities: string
	_, err = dec.Decode(&rCapabilities)
	if err != nil {
		return
	}

	return
}

// DomainOpenGraphicsFd is the go wrapper for REMOTE_PROC_DOMAIN_OPEN_GRAPHICS_FD.
func (l *Libvirt) DomainOpenGraphicsFd(Dom Domain, Idx uint32, Flags DomainOpenGraphicsFlags) (err error) {
	var buf []byte

	args := DomainOpenGraphicsFdArgs {
		Dom: Dom,
		Idx: Idx,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(343, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// ConnectGetAllDomainStats is the go wrapper for REMOTE_PROC_CONNECT_GET_ALL_DOMAIN_STATS.
func (l *Libvirt) ConnectGetAllDomainStats(Doms []Domain, Stats uint32, Flags ConnectGetAllDomainStatsFlags) (rRetStats []DomainStatsRecord, err error) {
	var buf []byte

	args := ConnectGetAllDomainStatsArgs {
		Doms: Doms,
		Stats: Stats,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(344, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// RetStats: []DomainStatsRecord
	_, err = dec.Decode(&rRetStats)
	if err != nil {
		return
	}

	return
}

// DomainBlockCopy is the go wrapper for REMOTE_PROC_DOMAIN_BLOCK_COPY.
func (l *Libvirt) DomainBlockCopy(Dom Domain, Path string, Destxml string, Params []TypedParam, Flags DomainBlockCopyFlags) (err error) {
	var buf []byte

	args := DomainBlockCopyArgs {
		Dom: Dom,
		Path: Path,
		Destxml: Destxml,
		Params: Params,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(345, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventCallbackTunable is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_CALLBACK_TUNABLE.
func (l *Libvirt) DomainEventCallbackTunable() (err error) {
	var buf []byte


	_, err = l.requestStream(346, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// NodeAllocPages is the go wrapper for REMOTE_PROC_NODE_ALLOC_PAGES.
func (l *Libvirt) NodeAllocPages(PageSizes []uint32, PageCounts []uint64, StartCell int32, CellCount uint32, Flags NodeAllocPagesFlags) (rRet int32, err error) {
	var buf []byte

	args := NodeAllocPagesArgs {
		PageSizes: PageSizes,
		PageCounts: PageCounts,
		StartCell: StartCell,
		CellCount: CellCount,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(347, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Ret: int32
	_, err = dec.Decode(&rRet)
	if err != nil {
		return
	}

	return
}

// DomainEventCallbackAgentLifecycle is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_CALLBACK_AGENT_LIFECYCLE.
func (l *Libvirt) DomainEventCallbackAgentLifecycle() (err error) {
	var buf []byte


	_, err = l.requestStream(348, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainGetFsinfo is the go wrapper for REMOTE_PROC_DOMAIN_GET_FSINFO.
func (l *Libvirt) DomainGetFsinfo(Dom Domain, Flags uint32) (rInfo []DomainFsinfo, rRet uint32, err error) {
	var buf []byte

	args := DomainGetFsinfoArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(349, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Info: []DomainFsinfo
	_, err = dec.Decode(&rInfo)
	if err != nil {
		return
	}
	// Ret: uint32
	_, err = dec.Decode(&rRet)
	if err != nil {
		return
	}

	return
}

// DomainDefineXMLFlags is the go wrapper for REMOTE_PROC_DOMAIN_DEFINE_XML_FLAGS.
func (l *Libvirt) DomainDefineXMLFlags(XML string, Flags DomainDefineFlags) (rDom Domain, err error) {
	var buf []byte

	args := DomainDefineXMLFlagsArgs {
		XML: XML,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(350, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Dom: Domain
	_, err = dec.Decode(&rDom)
	if err != nil {
		return
	}

	return
}

// DomainGetIothreadInfo is the go wrapper for REMOTE_PROC_DOMAIN_GET_IOTHREAD_INFO.
func (l *Libvirt) DomainGetIothreadInfo(Dom Domain, Flags DomainModificationImpact) (rInfo []DomainIothreadInfo, rRet uint32, err error) {
	var buf []byte

	args := DomainGetIothreadInfoArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(351, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Info: []DomainIothreadInfo
	_, err = dec.Decode(&rInfo)
	if err != nil {
		return
	}
	// Ret: uint32
	_, err = dec.Decode(&rRet)
	if err != nil {
		return
	}

	return
}

// DomainPinIothread is the go wrapper for REMOTE_PROC_DOMAIN_PIN_IOTHREAD.
func (l *Libvirt) DomainPinIothread(Dom Domain, IothreadsID uint32, Cpumap []byte, Flags DomainModificationImpact) (err error) {
	var buf []byte

	args := DomainPinIothreadArgs {
		Dom: Dom,
		IothreadsID: IothreadsID,
		Cpumap: Cpumap,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(352, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainInterfaceAddresses is the go wrapper for REMOTE_PROC_DOMAIN_INTERFACE_ADDRESSES.
func (l *Libvirt) DomainInterfaceAddresses(Dom Domain, Source uint32, Flags uint32) (rIfaces []DomainInterface, err error) {
	var buf []byte

	args := DomainInterfaceAddressesArgs {
		Dom: Dom,
		Source: Source,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(353, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Ifaces: []DomainInterface
	_, err = dec.Decode(&rIfaces)
	if err != nil {
		return
	}

	return
}

// DomainEventCallbackDeviceAdded is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_CALLBACK_DEVICE_ADDED.
func (l *Libvirt) DomainEventCallbackDeviceAdded() (err error) {
	var buf []byte


	_, err = l.requestStream(354, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainAddIothread is the go wrapper for REMOTE_PROC_DOMAIN_ADD_IOTHREAD.
func (l *Libvirt) DomainAddIothread(Dom Domain, IothreadID uint32, Flags DomainModificationImpact) (err error) {
	var buf []byte

	args := DomainAddIothreadArgs {
		Dom: Dom,
		IothreadID: IothreadID,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(355, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainDelIothread is the go wrapper for REMOTE_PROC_DOMAIN_DEL_IOTHREAD.
func (l *Libvirt) DomainDelIothread(Dom Domain, IothreadID uint32, Flags DomainModificationImpact) (err error) {
	var buf []byte

	args := DomainDelIothreadArgs {
		Dom: Dom,
		IothreadID: IothreadID,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(356, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainSetUserPassword is the go wrapper for REMOTE_PROC_DOMAIN_SET_USER_PASSWORD.
func (l *Libvirt) DomainSetUserPassword(Dom Domain, User OptString, Password OptString, Flags DomainSetUserPasswordFlags) (err error) {
	var buf []byte

	args := DomainSetUserPasswordArgs {
		Dom: Dom,
		User: User,
		Password: Password,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(357, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainRename is the go wrapper for REMOTE_PROC_DOMAIN_RENAME.
func (l *Libvirt) DomainRename(Dom Domain, NewName OptString, Flags uint32) (rRetcode int32, err error) {
	var buf []byte

	args := DomainRenameArgs {
		Dom: Dom,
		NewName: NewName,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(358, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Retcode: int32
	_, err = dec.Decode(&rRetcode)
	if err != nil {
		return
	}

	return
}

// DomainEventCallbackMigrationIteration is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_CALLBACK_MIGRATION_ITERATION.
func (l *Libvirt) DomainEventCallbackMigrationIteration() (err error) {
	var buf []byte


	_, err = l.requestStream(359, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// ConnectRegisterCloseCallback is the go wrapper for REMOTE_PROC_CONNECT_REGISTER_CLOSE_CALLBACK.
func (l *Libvirt) ConnectRegisterCloseCallback() (err error) {
	var buf []byte


	_, err = l.requestStream(360, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// ConnectUnregisterCloseCallback is the go wrapper for REMOTE_PROC_CONNECT_UNREGISTER_CLOSE_CALLBACK.
func (l *Libvirt) ConnectUnregisterCloseCallback() (err error) {
	var buf []byte


	_, err = l.requestStream(361, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// ConnectEventConnectionClosed is the go wrapper for REMOTE_PROC_CONNECT_EVENT_CONNECTION_CLOSED.
func (l *Libvirt) ConnectEventConnectionClosed() (err error) {
	var buf []byte


	_, err = l.requestStream(362, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventCallbackJobCompleted is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_CALLBACK_JOB_COMPLETED.
func (l *Libvirt) DomainEventCallbackJobCompleted() (err error) {
	var buf []byte


	_, err = l.requestStream(363, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainMigrateStartPostCopy is the go wrapper for REMOTE_PROC_DOMAIN_MIGRATE_START_POST_COPY.
func (l *Libvirt) DomainMigrateStartPostCopy(Dom Domain, Flags uint32) (err error) {
	var buf []byte

	args := DomainMigrateStartPostCopyArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(364, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainGetPerfEvents is the go wrapper for REMOTE_PROC_DOMAIN_GET_PERF_EVENTS.
func (l *Libvirt) DomainGetPerfEvents(Dom Domain, Flags DomainModificationImpact) (rParams []TypedParam, err error) {
	var buf []byte

	args := DomainGetPerfEventsArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(365, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Params: []TypedParam
	_, err = dec.Decode(&rParams)
	if err != nil {
		return
	}

	return
}

// DomainSetPerfEvents is the go wrapper for REMOTE_PROC_DOMAIN_SET_PERF_EVENTS.
func (l *Libvirt) DomainSetPerfEvents(Dom Domain, Params []TypedParam, Flags DomainModificationImpact) (err error) {
	var buf []byte

	args := DomainSetPerfEventsArgs {
		Dom: Dom,
		Params: Params,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(366, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventCallbackDeviceRemovalFailed is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_CALLBACK_DEVICE_REMOVAL_FAILED.
func (l *Libvirt) DomainEventCallbackDeviceRemovalFailed() (err error) {
	var buf []byte


	_, err = l.requestStream(367, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// ConnectStoragePoolEventRegisterAny is the go wrapper for REMOTE_PROC_CONNECT_STORAGE_POOL_EVENT_REGISTER_ANY.
func (l *Libvirt) ConnectStoragePoolEventRegisterAny(EventID int32, Pool OptStoragePool) (rCallbackID int32, err error) {
	var buf []byte

	args := ConnectStoragePoolEventRegisterAnyArgs {
		EventID: EventID,
		Pool: Pool,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(368, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// CallbackID: int32
	_, err = dec.Decode(&rCallbackID)
	if err != nil {
		return
	}

	return
}

// ConnectStoragePoolEventDeregisterAny is the go wrapper for REMOTE_PROC_CONNECT_STORAGE_POOL_EVENT_DEREGISTER_ANY.
func (l *Libvirt) ConnectStoragePoolEventDeregisterAny(CallbackID int32) (err error) {
	var buf []byte

	args := ConnectStoragePoolEventDeregisterAnyArgs {
		CallbackID: CallbackID,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(369, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// StoragePoolEventLifecycle is the go wrapper for REMOTE_PROC_STORAGE_POOL_EVENT_LIFECYCLE.
func (l *Libvirt) StoragePoolEventLifecycle() (err error) {
	var buf []byte


	_, err = l.requestStream(370, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainGetGuestVcpus is the go wrapper for REMOTE_PROC_DOMAIN_GET_GUEST_VCPUS.
func (l *Libvirt) DomainGetGuestVcpus(Dom Domain, Flags uint32) (rParams []TypedParam, err error) {
	var buf []byte

	args := DomainGetGuestVcpusArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(371, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Params: []TypedParam
	_, err = dec.Decode(&rParams)
	if err != nil {
		return
	}

	return
}

// DomainSetGuestVcpus is the go wrapper for REMOTE_PROC_DOMAIN_SET_GUEST_VCPUS.
func (l *Libvirt) DomainSetGuestVcpus(Dom Domain, Cpumap string, State int32, Flags uint32) (err error) {
	var buf []byte

	args := DomainSetGuestVcpusArgs {
		Dom: Dom,
		Cpumap: Cpumap,
		State: State,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(372, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// StoragePoolEventRefresh is the go wrapper for REMOTE_PROC_STORAGE_POOL_EVENT_REFRESH.
func (l *Libvirt) StoragePoolEventRefresh() (err error) {
	var buf []byte


	_, err = l.requestStream(373, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// ConnectNodeDeviceEventRegisterAny is the go wrapper for REMOTE_PROC_CONNECT_NODE_DEVICE_EVENT_REGISTER_ANY.
func (l *Libvirt) ConnectNodeDeviceEventRegisterAny(EventID int32, Dev OptNodeDevice) (rCallbackID int32, err error) {
	var buf []byte

	args := ConnectNodeDeviceEventRegisterAnyArgs {
		EventID: EventID,
		Dev: Dev,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(374, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// CallbackID: int32
	_, err = dec.Decode(&rCallbackID)
	if err != nil {
		return
	}

	return
}

// ConnectNodeDeviceEventDeregisterAny is the go wrapper for REMOTE_PROC_CONNECT_NODE_DEVICE_EVENT_DEREGISTER_ANY.
func (l *Libvirt) ConnectNodeDeviceEventDeregisterAny(CallbackID int32) (err error) {
	var buf []byte

	args := ConnectNodeDeviceEventDeregisterAnyArgs {
		CallbackID: CallbackID,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(375, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// NodeDeviceEventLifecycle is the go wrapper for REMOTE_PROC_NODE_DEVICE_EVENT_LIFECYCLE.
func (l *Libvirt) NodeDeviceEventLifecycle() (err error) {
	var buf []byte


	_, err = l.requestStream(376, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// NodeDeviceEventUpdate is the go wrapper for REMOTE_PROC_NODE_DEVICE_EVENT_UPDATE.
func (l *Libvirt) NodeDeviceEventUpdate() (err error) {
	var buf []byte


	_, err = l.requestStream(377, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// StorageVolGetInfoFlags is the go wrapper for REMOTE_PROC_STORAGE_VOL_GET_INFO_FLAGS.
func (l *Libvirt) StorageVolGetInfoFlags(Vol StorageVol, Flags uint32) (rType int8, rCapacity uint64, rAllocation uint64, err error) {
	var buf []byte

	args := StorageVolGetInfoFlagsArgs {
		Vol: Vol,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(378, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Type: int8
	_, err = dec.Decode(&rType)
	if err != nil {
		return
	}
	// Capacity: uint64
	_, err = dec.Decode(&rCapacity)
	if err != nil {
		return
	}
	// Allocation: uint64
	_, err = dec.Decode(&rAllocation)
	if err != nil {
		return
	}

	return
}

// DomainEventCallbackMetadataChange is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_CALLBACK_METADATA_CHANGE.
func (l *Libvirt) DomainEventCallbackMetadataChange() (err error) {
	var buf []byte


	_, err = l.requestStream(379, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// ConnectSecretEventRegisterAny is the go wrapper for REMOTE_PROC_CONNECT_SECRET_EVENT_REGISTER_ANY.
func (l *Libvirt) ConnectSecretEventRegisterAny(EventID int32, OptSecret OptSecret) (rCallbackID int32, err error) {
	var buf []byte

	args := ConnectSecretEventRegisterAnyArgs {
		EventID: EventID,
		OptSecret: OptSecret,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(380, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// CallbackID: int32
	_, err = dec.Decode(&rCallbackID)
	if err != nil {
		return
	}

	return
}

// ConnectSecretEventDeregisterAny is the go wrapper for REMOTE_PROC_CONNECT_SECRET_EVENT_DEREGISTER_ANY.
func (l *Libvirt) ConnectSecretEventDeregisterAny(CallbackID int32) (err error) {
	var buf []byte

	args := ConnectSecretEventDeregisterAnyArgs {
		CallbackID: CallbackID,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(381, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// SecretEventLifecycle is the go wrapper for REMOTE_PROC_SECRET_EVENT_LIFECYCLE.
func (l *Libvirt) SecretEventLifecycle() (err error) {
	var buf []byte


	_, err = l.requestStream(382, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// SecretEventValueChanged is the go wrapper for REMOTE_PROC_SECRET_EVENT_VALUE_CHANGED.
func (l *Libvirt) SecretEventValueChanged() (err error) {
	var buf []byte


	_, err = l.requestStream(383, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainSetVcpu is the go wrapper for REMOTE_PROC_DOMAIN_SET_VCPU.
func (l *Libvirt) DomainSetVcpu(Dom Domain, Cpumap string, State int32, Flags DomainModificationImpact) (err error) {
	var buf []byte

	args := DomainSetVcpuArgs {
		Dom: Dom,
		Cpumap: Cpumap,
		State: State,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(384, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainEventBlockThreshold is the go wrapper for REMOTE_PROC_DOMAIN_EVENT_BLOCK_THRESHOLD.
func (l *Libvirt) DomainEventBlockThreshold() (err error) {
	var buf []byte


	_, err = l.requestStream(385, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainSetBlockThreshold is the go wrapper for REMOTE_PROC_DOMAIN_SET_BLOCK_THRESHOLD.
func (l *Libvirt) DomainSetBlockThreshold(Dom Domain, Dev string, Threshold uint64, Flags uint32) (err error) {
	var buf []byte

	args := DomainSetBlockThresholdArgs {
		Dom: Dom,
		Dev: Dev,
		Threshold: Threshold,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(386, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainMigrateGetMaxDowntime is the go wrapper for REMOTE_PROC_DOMAIN_MIGRATE_GET_MAX_DOWNTIME.
func (l *Libvirt) DomainMigrateGetMaxDowntime(Dom Domain, Flags uint32) (rDowntime uint64, err error) {
	var buf []byte

	args := DomainMigrateGetMaxDowntimeArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(387, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Downtime: uint64
	_, err = dec.Decode(&rDowntime)
	if err != nil {
		return
	}

	return
}

// DomainManagedSaveGetXMLDesc is the go wrapper for REMOTE_PROC_DOMAIN_MANAGED_SAVE_GET_XML_DESC.
func (l *Libvirt) DomainManagedSaveGetXMLDesc(Dom Domain, Flags DomainXMLFlags) (rXML string, err error) {
	var buf []byte

	args := DomainManagedSaveGetXMLDescArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(388, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// XML: string
	_, err = dec.Decode(&rXML)
	if err != nil {
		return
	}

	return
}

// DomainManagedSaveDefineXML is the go wrapper for REMOTE_PROC_DOMAIN_MANAGED_SAVE_DEFINE_XML.
func (l *Libvirt) DomainManagedSaveDefineXML(Dom Domain, Dxml OptString, Flags DomainSaveRestoreFlags) (err error) {
	var buf []byte

	args := DomainManagedSaveDefineXMLArgs {
		Dom: Dom,
		Dxml: Dxml,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(389, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// DomainSetLifecycleAction is the go wrapper for REMOTE_PROC_DOMAIN_SET_LIFECYCLE_ACTION.
func (l *Libvirt) DomainSetLifecycleAction(Dom Domain, Type uint32, Action uint32, Flags DomainModificationImpact) (err error) {
	var buf []byte

	args := DomainSetLifecycleActionArgs {
		Dom: Dom,
		Type: Type,
		Action: Action,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(390, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// StoragePoolLookupByTargetPath is the go wrapper for REMOTE_PROC_STORAGE_POOL_LOOKUP_BY_TARGET_PATH.
func (l *Libvirt) StoragePoolLookupByTargetPath(Path string) (rPool StoragePool, err error) {
	var buf []byte

	args := StoragePoolLookupByTargetPathArgs {
		Path: Path,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(391, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Pool: StoragePool
	_, err = dec.Decode(&rPool)
	if err != nil {
		return
	}

	return
}

// DomainDetachDeviceAlias is the go wrapper for REMOTE_PROC_DOMAIN_DETACH_DEVICE_ALIAS.
func (l *Libvirt) DomainDetachDeviceAlias(Dom Domain, Alias string, Flags uint32) (err error) {
	var buf []byte

	args := DomainDetachDeviceAliasArgs {
		Dom: Dom,
		Alias: Alias,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(392, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// ConnectCompareHypervisorCPU is the go wrapper for REMOTE_PROC_CONNECT_COMPARE_HYPERVISOR_CPU.
func (l *Libvirt) ConnectCompareHypervisorCPU(Emulator OptString, Arch OptString, Machine OptString, Virttype OptString, XMLCPU string, Flags uint32) (rResult int32, err error) {
	var buf []byte

	args := ConnectCompareHypervisorCPUArgs {
		Emulator: Emulator,
		Arch: Arch,
		Machine: Machine,
		Virttype: Virttype,
		XMLCPU: XMLCPU,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(393, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Result: int32
	_, err = dec.Decode(&rResult)
	if err != nil {
		return
	}

	return
}

// ConnectBaselineHypervisorCPU is the go wrapper for REMOTE_PROC_CONNECT_BASELINE_HYPERVISOR_CPU.
func (l *Libvirt) ConnectBaselineHypervisorCPU(Emulator OptString, Arch OptString, Machine OptString, Virttype OptString, XMLCPUs []string, Flags uint32) (rCPU string, err error) {
	var buf []byte

	args := ConnectBaselineHypervisorCPUArgs {
		Emulator: Emulator,
		Arch: Arch,
		Machine: Machine,
		Virttype: Virttype,
		XMLCPUs: XMLCPUs,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(394, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// CPU: string
	_, err = dec.Decode(&rCPU)
	if err != nil {
		return
	}

	return
}

// NodeGetSevInfo is the go wrapper for REMOTE_PROC_NODE_GET_SEV_INFO.
func (l *Libvirt) NodeGetSevInfo(Nparams int32, Flags uint32) (rParams []TypedParam, rNparams int32, err error) {
	var buf []byte

	args := NodeGetSevInfoArgs {
		Nparams: Nparams,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(395, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Params: []TypedParam
	_, err = dec.Decode(&rParams)
	if err != nil {
		return
	}
	// Nparams: int32
	_, err = dec.Decode(&rNparams)
	if err != nil {
		return
	}

	return
}

// DomainGetLaunchSecurityInfo is the go wrapper for REMOTE_PROC_DOMAIN_GET_LAUNCH_SECURITY_INFO.
func (l *Libvirt) DomainGetLaunchSecurityInfo(Dom Domain, Flags uint32) (rParams []TypedParam, err error) {
	var buf []byte

	args := DomainGetLaunchSecurityInfoArgs {
		Dom: Dom,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(396, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Params: []TypedParam
	_, err = dec.Decode(&rParams)
	if err != nil {
		return
	}

	return
}

// NwfilterBindingLookupByPortDev is the go wrapper for REMOTE_PROC_NWFILTER_BINDING_LOOKUP_BY_PORT_DEV.
func (l *Libvirt) NwfilterBindingLookupByPortDev(Name string) (rOptNwfilter NwfilterBinding, err error) {
	var buf []byte

	args := NwfilterBindingLookupByPortDevArgs {
		Name: Name,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(397, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// OptNwfilter: NwfilterBinding
	_, err = dec.Decode(&rOptNwfilter)
	if err != nil {
		return
	}

	return
}

// NwfilterBindingGetXMLDesc is the go wrapper for REMOTE_PROC_NWFILTER_BINDING_GET_XML_DESC.
func (l *Libvirt) NwfilterBindingGetXMLDesc(OptNwfilter NwfilterBinding, Flags uint32) (rXML string, err error) {
	var buf []byte

	args := NwfilterBindingGetXMLDescArgs {
		OptNwfilter: OptNwfilter,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(398, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// XML: string
	_, err = dec.Decode(&rXML)
	if err != nil {
		return
	}

	return
}

// NwfilterBindingCreateXML is the go wrapper for REMOTE_PROC_NWFILTER_BINDING_CREATE_XML.
func (l *Libvirt) NwfilterBindingCreateXML(XML string, Flags uint32) (rOptNwfilter NwfilterBinding, err error) {
	var buf []byte

	args := NwfilterBindingCreateXMLArgs {
		XML: XML,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(399, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// OptNwfilter: NwfilterBinding
	_, err = dec.Decode(&rOptNwfilter)
	if err != nil {
		return
	}

	return
}

// NwfilterBindingDelete is the go wrapper for REMOTE_PROC_NWFILTER_BINDING_DELETE.
func (l *Libvirt) NwfilterBindingDelete(OptNwfilter NwfilterBinding) (err error) {
	var buf []byte

	args := NwfilterBindingDeleteArgs {
		OptNwfilter: OptNwfilter,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(400, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

// ConnectListAllNwfilterBindings is the go wrapper for REMOTE_PROC_CONNECT_LIST_ALL_NWFILTER_BINDINGS.
func (l *Libvirt) ConnectListAllNwfilterBindings(NeedResults int32, Flags uint32) (rBindings []NwfilterBinding, rRet uint32, err error) {
	var buf []byte

	args := ConnectListAllNwfilterBindingsArgs {
		NeedResults: NeedResults,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}

	var r response
	r, err = l.requestStream(401, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	// Return value unmarshaling
	tpd := typedParamDecoder{}
	ct := map[string]xdr.TypeDecoder{"libvirt.TypedParam": tpd}
	rdr := bytes.NewReader(r.Payload)
	dec := xdr.NewDecoderCustomTypes(rdr, 0, ct)
	// Bindings: []NwfilterBinding
	_, err = dec.Decode(&rBindings)
	if err != nil {
		return
	}
	// Ret: uint32
	_, err = dec.Decode(&rRet)
	if err != nil {
		return
	}

	return
}

// DomainSetIothreadParams is the go wrapper for REMOTE_PROC_DOMAIN_SET_IOTHREAD_PARAMS.
func (l *Libvirt) DomainSetIothreadParams(Dom Domain, IothreadID uint32, Params []TypedParam, Flags uint32) (err error) {
	var buf []byte

	args := DomainSetIothreadParamsArgs {
		Dom: Dom,
		IothreadID: IothreadID,
		Params: Params,
		Flags: Flags,
	}

	buf, err = encode(&args)
	if err != nil {
		return
	}


	_, err = l.requestStream(402, constants.Program, buf, nil, nil)
	if err != nil {
		return
	}

	return
}

