//Code is generated by ucloud code generator, don't modify it by hand, it will cause undefined behaviors.
//go:generate ucloud-gen-go-api UHost CopyCustomImage

package uhost

import (
	"github.com/ucloud/ucloud-sdk-go/ucloud/request"
	"github.com/ucloud/ucloud-sdk-go/ucloud/response"
)

// CopyCustomImageRequest is request schema for CopyCustomImage action
type CopyCustomImageRequest struct {
	request.CommonBase

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"false"`

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// 源镜像Id, 参见 DescribeImage
	SourceImageId *string `required:"true"`

	// 目标项目Id, 参见 GetProjectList
	TargetProjectId *string `required:"true"`

	// 目标地域，不跨地域不用填
	TargetRegion *string `required:"false"`

	// 目标镜像名称
	TargetImageName *string `required:"false"`

	// 目标镜像描述
	TargetImageDescription *string `required:"false"`
}

// CopyCustomImageResponse is response schema for CopyCustomImage action
type CopyCustomImageResponse struct {
	response.CommonBase

	// 目标镜像Id
	TargetImageId string
}

// NewCopyCustomImageRequest will create request of CopyCustomImage action.
func (c *UHostClient) NewCopyCustomImageRequest() *CopyCustomImageRequest {
	req := &CopyCustomImageRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(false)
	return req
}

// CopyCustomImage - 复制自制镜像
func (c *UHostClient) CopyCustomImage(req *CopyCustomImageRequest) (*CopyCustomImageResponse, error) {
	var err error
	var res CopyCustomImageResponse

	err = c.Client.InvokeAction("CopyCustomImage", req, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}
