//Code is generated by ucloud code generator, don't modify it by hand, it will cause undefined behaviors.
//go:generate ucloud-gen-go-api UHost ResizeUHostInstance

package uhost

import (
	"github.com/ucloud/ucloud-sdk-go/ucloud/request"
	"github.com/ucloud/ucloud-sdk-go/ucloud/response"
)

// ResizeUHostInstanceRequest is request schema for ResizeUHostInstance action
type ResizeUHostInstanceRequest struct {
	request.CommonBase

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"false"`

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// UHost实例ID 参见 [DescribeUHostInstance](describe_uhost_instance.html)
	UHostId *string `required:"true"`

	// 虚拟CPU核数。可选参数：1-32（可选范围与UHostType相关）。默认值为当前实例的CPU核数
	CPU *int `required:"false"`

	// 内存大小。单位：MB。范围 ：[1024, 262144]，取值为1024的倍数（可选范围与UHostType相关）。默认值为当前实例的内存大小。
	Memory *int `required:"false"`

	// 【待废弃】数据盘大小，单位：GB，范围[10,1000]； SSD机型，单位：GB，范围[100,500]；步长：10，默认值为当前实例的数据盘大小，数据盘不支持缩容，因此不允许输入比当前实例数据盘大小的值
	DiskSpace *int `required:"false"`

	// 【待废弃】系统盘大小，单位：GB，范围[20,100]，步长：10，系统盘不支持缩容，因此不允许输入比当前实例系统盘小的值
	BootDiskSpace *int `required:"false"`

	// 网卡升降级（1，表示升级，2表示降级，0表示不变）
	NetCapValue *int `required:"false"`
}

// ResizeUHostInstanceResponse is response schema for ResizeUHostInstance action
type ResizeUHostInstanceResponse struct {
	response.CommonBase

	// UHost实例ID
	UhostId string
}

// NewResizeUHostInstanceRequest will create request of ResizeUHostInstance action.
func (c *UHostClient) NewResizeUHostInstanceRequest() *ResizeUHostInstanceRequest {
	req := &ResizeUHostInstanceRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

// ResizeUHostInstance - 修改指定UHost实例的资源配置，如CPU核心数，内存容量大小，网络增强等。可选配置范围请参考[[api:uhost-api:uhost_type|云主机机型说明]]。
func (c *UHostClient) ResizeUHostInstance(req *ResizeUHostInstanceRequest) (*ResizeUHostInstanceResponse, error) {
	var err error
	var res ResizeUHostInstanceResponse

	err = c.Client.InvokeAction("ResizeUHostInstance", req, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}
