//Code is generated by ucloud code generator, don't modify it by hand, it will cause undefined behaviors.
//go:generate ucloud-gen-go-api UHost TerminateUHostInstance

package uhost

import (
	"github.com/ucloud/ucloud-sdk-go/ucloud/request"
	"github.com/ucloud/ucloud-sdk-go/ucloud/response"
)

// TerminateUHostInstanceRequest is request schema for TerminateUHostInstance action
type TerminateUHostInstanceRequest struct {
	request.CommonBase

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"false"`

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// UHost资源Id 参见 [DescribeUHostInstance](describe_uhost_instance.html)
	UHostId *string `required:"true"`

	// 是否直接删除，0表示按照原来的逻辑（有回收站权限，则进入回收站），1表示直接删除
	Destroy *int `required:"false"`

	// 是否释放绑定的EIP。true: 解绑EIP后，并释放；其他值或不填：解绑EIP。
	ReleaseEIP *bool `required:"false"`

	// 是否删除挂载的数据盘。true删除，其他不删除。
	ReleaseUDisk *bool `required:"false"`
}

// TerminateUHostInstanceResponse is response schema for TerminateUHostInstance action
type TerminateUHostInstanceResponse struct {
	response.CommonBase

	// 放入回收站:"Yes", 彻底删除：“No”
	InRecycle string

	// UHost 实例 Id
	UHostId string
}

// NewTerminateUHostInstanceRequest will create request of TerminateUHostInstance action.
func (c *UHostClient) NewTerminateUHostInstanceRequest() *TerminateUHostInstanceRequest {
	req := &TerminateUHostInstanceRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

// TerminateUHostInstance - 删除指定数据中心的UHost实例。
func (c *UHostClient) TerminateUHostInstance(req *TerminateUHostInstanceRequest) (*TerminateUHostInstanceResponse, error) {
	var err error
	var res TerminateUHostInstanceResponse

	err = c.Client.InvokeAction("TerminateUHostInstance", req, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}
