// Code is generated by ucloud-model, DO NOT EDIT IT.

package vpc

import (
	"github.com/ucloud/ucloud-sdk-go/ucloud/request"
	"github.com/ucloud/ucloud-sdk-go/ucloud/response"
)

// CreateNATGWRequest is request schema for CreateNATGW action
type CreateNATGWRequest struct {
	request.CommonBase

	// [公共参数] 项目Id。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// NAT网关绑定的EIPId
	EIPIds []string `required:"true"`

	// NAT网关绑定的防火墙Id
	FirewallId *string `required:"true"`

	// 白名单开关标记。0表示关闭，1表示开启。默认为0
	IfOpen *int `required:"false"`

	// NAT网关名称
	NATGWName *string `required:"true"`

	// 备注。默认为空
	Remark *string `required:"false"`

	// NAT网关绑定的子网Id
	SubnetworkIds []string `required:"true"`

	// 业务组。默认为空
	Tag *string `required:"false"`

	// NAT网关所属的VPC Id。默认为Default VPC Id
	VPCId *string `required:"false"`
}

// CreateNATGWResponse is response schema for CreateNATGW action
type CreateNATGWResponse struct {
	response.CommonBase

	// 申请到的NATGateWay Id
	NATGWId string
}

// NewCreateNATGWRequest will create request of CreateNATGW action.
func (c *VPCClient) NewCreateNATGWRequest() *CreateNATGWRequest {
	req := &CreateNATGWRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(false)
	return req
}

// CreateNATGW - 创建NAT网关
func (c *VPCClient) CreateNATGW(req *CreateNATGWRequest) (*CreateNATGWResponse, error) {
	var err error
	var res CreateNATGWResponse

	reqCopier := *req

	err = c.Client.InvokeAction("CreateNATGW", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}
