//Code is generated by ucloud code generator, don't modify it by hand, it will cause undefined behaviors.
//go:generate ucloud-gen-go-api VPC CreateSubnet

package vpc

import (
	"github.com/ucloud/ucloud-sdk-go/ucloud/request"
	"github.com/ucloud/ucloud-sdk-go/ucloud/response"
)

// CreateSubnetRequest is request schema for CreateSubnet action
type CreateSubnetRequest struct {
	request.CommonBase

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// VPC资源ID
	VPCId *string `required:"true"`

	// 子网网络地址，例如192.168.0.0
	Subnet *string `required:"true"`

	// 子网网络号位数，默认为24
	Netmask *int `required:"false"`

	// 子网名称，默认为Subnet
	SubnetName *string `required:"false"`

	// 业务组名称，默认为Default
	Tag *string `required:"false"`

	// 备注
	Remark *string `required:"false"`
}

// CreateSubnetResponse is response schema for CreateSubnet action
type CreateSubnetResponse struct {
	response.CommonBase

	// 子网ID
	SubnetId string
}

// NewCreateSubnetRequest will create request of CreateSubnet action.
func (c *VPCClient) NewCreateSubnetRequest() *CreateSubnetRequest {
	req := &CreateSubnetRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(false)
	return req
}

// CreateSubnet - 创建子网
func (c *VPCClient) CreateSubnet(req *CreateSubnetRequest) (*CreateSubnetResponse, error) {
	var err error
	var res CreateSubnetResponse

	err = c.Client.InvokeAction("CreateSubnet", req, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}
