// Code is generated by ucloud-model, DO NOT EDIT IT.

package vpc

import (
	"github.com/ucloud/ucloud-sdk-go/ucloud/request"
	"github.com/ucloud/ucloud-sdk-go/ucloud/response"
)

// UpdateNATGWPolicyRequest is request schema for UpdateNATGWPolicy action
type UpdateNATGWPolicyRequest struct {
	request.CommonBase

	// [公共参数] 项目Id。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 目标IP。填写对饮的目标IP地址
	DstIP *string `required:"true"`

	// 目标端口。可填写固定端口，也可填写端口范围。支持的端口范围为1-65535
	DstPort *string `required:"true"`

	// NAT网关Id
	NATGWId *string `required:"true"`

	// 转发策略Id
	PolicyId *string `required:"true"`

	// 转发策略名称。默认为空
	PolicyName *string `required:"false"`

	// 协议类型。枚举值为：TCP 、 UDP
	Protocol *string `required:"true"`

	// 源IP。填写对应的EIP Id
	SrcEIPId *string `required:"true"`

	// 源端口。可填写固定端口，也可填写端口范围。支持的端口范围为1-6553
	SrcPort *string `required:"true"`
}

// UpdateNATGWPolicyResponse is response schema for UpdateNATGWPolicy action
type UpdateNATGWPolicyResponse struct {
	response.CommonBase
}

// NewUpdateNATGWPolicyRequest will create request of UpdateNATGWPolicy action.
func (c *VPCClient) NewUpdateNATGWPolicyRequest() *UpdateNATGWPolicyRequest {
	req := &UpdateNATGWPolicyRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

// UpdateNATGWPolicy - 更新NAT网关端口转发规则
func (c *VPCClient) UpdateNATGWPolicy(req *UpdateNATGWPolicyRequest) (*UpdateNATGWPolicyResponse, error) {
	var err error
	var res UpdateNATGWPolicyResponse

	reqCopier := *req

	err = c.Client.InvokeAction("UpdateNATGWPolicy", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}
