// Code is generated by ucloud-model, DO NOT EDIT IT.

package vpc

import (
	"github.com/ucloud/ucloud-sdk-go/ucloud/request"
	"github.com/ucloud/ucloud-sdk-go/ucloud/response"
)

// UpdateNATGWSubnetRequest is request schema for UpdateNATGWSubnet action
type UpdateNATGWSubnetRequest struct {
	request.CommonBase

	// [公共参数] 项目Id。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// NAT网关Id
	NATGWId *string `required:"true"`

	// NAT网关绑定的子网Id
	SubnetworkIds []string `required:"true"`
}

// UpdateNATGWSubnetResponse is response schema for UpdateNATGWSubnet action
type UpdateNATGWSubnetResponse struct {
	response.CommonBase
}

// NewUpdateNATGWSubnetRequest will create request of UpdateNATGWSubnet action.
func (c *VPCClient) NewUpdateNATGWSubnetRequest() *UpdateNATGWSubnetRequest {
	req := &UpdateNATGWSubnetRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

// UpdateNATGWSubnet - 更新NAT网关绑定的子网
func (c *VPCClient) UpdateNATGWSubnet(req *UpdateNATGWSubnetRequest) (*UpdateNATGWSubnetResponse, error) {
	var err error
	var res UpdateNATGWSubnetResponse

	reqCopier := *req

	err = c.Client.InvokeAction("UpdateNATGWSubnet", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}
