// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/compute/v1/instancegroup/instance_group_service.proto

package instancegroup

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type InstanceGroupView int32

const (
	// Doesn't include the metadata of the instance template in the server response.
	InstanceGroupView_BASIC InstanceGroupView = 0
	// Returns the metadata of the instance template in the server response.
	InstanceGroupView_FULL InstanceGroupView = 1
)

var InstanceGroupView_name = map[int32]string{
	0: "BASIC",
	1: "FULL",
}

var InstanceGroupView_value = map[string]int32{
	"BASIC": 0,
	"FULL":  1,
}

func (x InstanceGroupView) String() string {
	return proto.EnumName(InstanceGroupView_name, int32(x))
}

func (InstanceGroupView) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_fc51cd26b96eed88, []int{0}
}

type GetInstanceGroupRequest struct {
	// ID of the InstanceGroup resource to return.
	// To get the instance group ID, use an [InstanceGroupService.List] request.
	InstanceGroupId string `protobuf:"bytes,1,opt,name=instance_group_id,json=instanceGroupId,proto3" json:"instance_group_id,omitempty"`
	// Defines which information about the Instance template should be returned in the server response.
	View                 InstanceGroupView `protobuf:"varint,2,opt,name=view,proto3,enum=yandex.cloud.compute.v1.instancegroup.InstanceGroupView" json:"view,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *GetInstanceGroupRequest) Reset()         { *m = GetInstanceGroupRequest{} }
func (m *GetInstanceGroupRequest) String() string { return proto.CompactTextString(m) }
func (*GetInstanceGroupRequest) ProtoMessage()    {}
func (*GetInstanceGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fc51cd26b96eed88, []int{0}
}

func (m *GetInstanceGroupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetInstanceGroupRequest.Unmarshal(m, b)
}
func (m *GetInstanceGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetInstanceGroupRequest.Marshal(b, m, deterministic)
}
func (m *GetInstanceGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetInstanceGroupRequest.Merge(m, src)
}
func (m *GetInstanceGroupRequest) XXX_Size() int {
	return xxx_messageInfo_GetInstanceGroupRequest.Size(m)
}
func (m *GetInstanceGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetInstanceGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetInstanceGroupRequest proto.InternalMessageInfo

func (m *GetInstanceGroupRequest) GetInstanceGroupId() string {
	if m != nil {
		return m.InstanceGroupId
	}
	return ""
}

func (m *GetInstanceGroupRequest) GetView() InstanceGroupView {
	if m != nil {
		return m.View
	}
	return InstanceGroupView_BASIC
}

type CreateInstanceGroupRequest struct {
	// ID of the folder to create an instance group in.
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the instance group.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the instance group.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Instance template that the instance group belongs to.
	InstanceTemplate *InstanceTemplate `protobuf:"bytes,6,opt,name=instance_template,json=instanceTemplate,proto3" json:"instance_template,omitempty"`
	// Scaling policy of the instance group.
	ScalePolicy *ScalePolicy `protobuf:"bytes,7,opt,name=scale_policy,json=scalePolicy,proto3" json:"scale_policy,omitempty"`
	// Deployment policy of the instance group.
	DeployPolicy *DeployPolicy `protobuf:"bytes,8,opt,name=deploy_policy,json=deployPolicy,proto3" json:"deploy_policy,omitempty"`
	// Allocation policy of the instance group by zones and regions.
	AllocationPolicy *AllocationPolicy `protobuf:"bytes,9,opt,name=allocation_policy,json=allocationPolicy,proto3" json:"allocation_policy,omitempty"`
	// Load balancing specification.
	LoadBalancerSpec *LoadBalancerSpec `protobuf:"bytes,10,opt,name=load_balancer_spec,json=loadBalancerSpec,proto3" json:"load_balancer_spec,omitempty"`
	// Health checking specification. For more information, see [Health check](/docs/load-balancer/concepts/health-check).
	HealthChecksSpec *HealthChecksSpec `protobuf:"bytes,11,opt,name=health_checks_spec,json=healthChecksSpec,proto3" json:"health_checks_spec,omitempty"`
	// ID of the service account. The service account will be used for all API calls
	// made by the Instance Groups component on behalf of the user (for example, creating instances, adding them to load balancer target group, etc.). For more information, see [Service accounts](/docs/iam/concepts/users/service-accounts).
	// To get the service account ID, use a [yandex.cloud.iam.v1.ServiceAccountService.List] request.
	ServiceAccountId     string   `protobuf:"bytes,12,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateInstanceGroupRequest) Reset()         { *m = CreateInstanceGroupRequest{} }
func (m *CreateInstanceGroupRequest) String() string { return proto.CompactTextString(m) }
func (*CreateInstanceGroupRequest) ProtoMessage()    {}
func (*CreateInstanceGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fc51cd26b96eed88, []int{1}
}

func (m *CreateInstanceGroupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateInstanceGroupRequest.Unmarshal(m, b)
}
func (m *CreateInstanceGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateInstanceGroupRequest.Marshal(b, m, deterministic)
}
func (m *CreateInstanceGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateInstanceGroupRequest.Merge(m, src)
}
func (m *CreateInstanceGroupRequest) XXX_Size() int {
	return xxx_messageInfo_CreateInstanceGroupRequest.Size(m)
}
func (m *CreateInstanceGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateInstanceGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateInstanceGroupRequest proto.InternalMessageInfo

func (m *CreateInstanceGroupRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *CreateInstanceGroupRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateInstanceGroupRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *CreateInstanceGroupRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *CreateInstanceGroupRequest) GetInstanceTemplate() *InstanceTemplate {
	if m != nil {
		return m.InstanceTemplate
	}
	return nil
}

func (m *CreateInstanceGroupRequest) GetScalePolicy() *ScalePolicy {
	if m != nil {
		return m.ScalePolicy
	}
	return nil
}

func (m *CreateInstanceGroupRequest) GetDeployPolicy() *DeployPolicy {
	if m != nil {
		return m.DeployPolicy
	}
	return nil
}

func (m *CreateInstanceGroupRequest) GetAllocationPolicy() *AllocationPolicy {
	if m != nil {
		return m.AllocationPolicy
	}
	return nil
}

func (m *CreateInstanceGroupRequest) GetLoadBalancerSpec() *LoadBalancerSpec {
	if m != nil {
		return m.LoadBalancerSpec
	}
	return nil
}

func (m *CreateInstanceGroupRequest) GetHealthChecksSpec() *HealthChecksSpec {
	if m != nil {
		return m.HealthChecksSpec
	}
	return nil
}

func (m *CreateInstanceGroupRequest) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

type CreateInstanceGroupFromYamlRequest struct {
	// ID of the folder to create an instance group in.
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// CreateInstanceGroupRequest in YAML format.
	InstanceGroupYaml    string   `protobuf:"bytes,2,opt,name=instance_group_yaml,json=instanceGroupYaml,proto3" json:"instance_group_yaml,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateInstanceGroupFromYamlRequest) Reset()         { *m = CreateInstanceGroupFromYamlRequest{} }
func (m *CreateInstanceGroupFromYamlRequest) String() string { return proto.CompactTextString(m) }
func (*CreateInstanceGroupFromYamlRequest) ProtoMessage()    {}
func (*CreateInstanceGroupFromYamlRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fc51cd26b96eed88, []int{2}
}

func (m *CreateInstanceGroupFromYamlRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateInstanceGroupFromYamlRequest.Unmarshal(m, b)
}
func (m *CreateInstanceGroupFromYamlRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateInstanceGroupFromYamlRequest.Marshal(b, m, deterministic)
}
func (m *CreateInstanceGroupFromYamlRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateInstanceGroupFromYamlRequest.Merge(m, src)
}
func (m *CreateInstanceGroupFromYamlRequest) XXX_Size() int {
	return xxx_messageInfo_CreateInstanceGroupFromYamlRequest.Size(m)
}
func (m *CreateInstanceGroupFromYamlRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateInstanceGroupFromYamlRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateInstanceGroupFromYamlRequest proto.InternalMessageInfo

func (m *CreateInstanceGroupFromYamlRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *CreateInstanceGroupFromYamlRequest) GetInstanceGroupYaml() string {
	if m != nil {
		return m.InstanceGroupYaml
	}
	return ""
}

type CreateInstanceGroupMetadata struct {
	// ID of the instance group that is being created.
	InstanceGroupId      string   `protobuf:"bytes,1,opt,name=instance_group_id,json=instanceGroupId,proto3" json:"instance_group_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateInstanceGroupMetadata) Reset()         { *m = CreateInstanceGroupMetadata{} }
func (m *CreateInstanceGroupMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateInstanceGroupMetadata) ProtoMessage()    {}
func (*CreateInstanceGroupMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fc51cd26b96eed88, []int{3}
}

func (m *CreateInstanceGroupMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateInstanceGroupMetadata.Unmarshal(m, b)
}
func (m *CreateInstanceGroupMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateInstanceGroupMetadata.Marshal(b, m, deterministic)
}
func (m *CreateInstanceGroupMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateInstanceGroupMetadata.Merge(m, src)
}
func (m *CreateInstanceGroupMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateInstanceGroupMetadata.Size(m)
}
func (m *CreateInstanceGroupMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateInstanceGroupMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateInstanceGroupMetadata proto.InternalMessageInfo

func (m *CreateInstanceGroupMetadata) GetInstanceGroupId() string {
	if m != nil {
		return m.InstanceGroupId
	}
	return ""
}

type UpdateInstanceGroupRequest struct {
	// ID of the instance group to update.
	// To get the instance group ID, use an [InstanceGroupService.List] request.
	InstanceGroupId string `protobuf:"bytes,1,opt,name=instance_group_id,json=instanceGroupId,proto3" json:"instance_group_id,omitempty"`
	// Field mask that specifies which fields of the InstanceGroup resource are going to be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Name of the instance group.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the instance group.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs.
	//
	// The existing set of `labels` is completely replaced by the provided set.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Instance template that the instance group belongs to.
	InstanceTemplate *InstanceTemplate `protobuf:"bytes,6,opt,name=instance_template,json=instanceTemplate,proto3" json:"instance_template,omitempty"`
	// Scaling policy of the instance group.
	ScalePolicy *ScalePolicy `protobuf:"bytes,7,opt,name=scale_policy,json=scalePolicy,proto3" json:"scale_policy,omitempty"`
	// Deployment policy of the instance group.
	DeployPolicy *DeployPolicy `protobuf:"bytes,8,opt,name=deploy_policy,json=deployPolicy,proto3" json:"deploy_policy,omitempty"`
	// Allocation policy of the instance group by zones and regions.
	AllocationPolicy *AllocationPolicy `protobuf:"bytes,9,opt,name=allocation_policy,json=allocationPolicy,proto3" json:"allocation_policy,omitempty"`
	// Health checking specification. For more information, see [Health check](/docs/load-balancer/concepts/health-check).
	HealthChecksSpec *HealthChecksSpec `protobuf:"bytes,11,opt,name=health_checks_spec,json=healthChecksSpec,proto3" json:"health_checks_spec,omitempty"`
	// ID of the service account. The service account will be used for all API calls
	// made by the Instance Groups component on behalf of the user (for example, creating instances, adding them to load balancer target group, etc.). For more information, see [Service accounts](/docs/iam/concepts/users/service-accounts).
	// To get the service account ID, use a [yandex.cloud.iam.v1.ServiceAccountService.List] request.
	ServiceAccountId string `protobuf:"bytes,12,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// Load Balancer specification for load balancing support.
	LoadBalancerSpec     *LoadBalancerSpec `protobuf:"bytes,14,opt,name=load_balancer_spec,json=loadBalancerSpec,proto3" json:"load_balancer_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UpdateInstanceGroupRequest) Reset()         { *m = UpdateInstanceGroupRequest{} }
func (m *UpdateInstanceGroupRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateInstanceGroupRequest) ProtoMessage()    {}
func (*UpdateInstanceGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fc51cd26b96eed88, []int{4}
}

func (m *UpdateInstanceGroupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateInstanceGroupRequest.Unmarshal(m, b)
}
func (m *UpdateInstanceGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateInstanceGroupRequest.Marshal(b, m, deterministic)
}
func (m *UpdateInstanceGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateInstanceGroupRequest.Merge(m, src)
}
func (m *UpdateInstanceGroupRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateInstanceGroupRequest.Size(m)
}
func (m *UpdateInstanceGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateInstanceGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateInstanceGroupRequest proto.InternalMessageInfo

func (m *UpdateInstanceGroupRequest) GetInstanceGroupId() string {
	if m != nil {
		return m.InstanceGroupId
	}
	return ""
}

func (m *UpdateInstanceGroupRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateInstanceGroupRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateInstanceGroupRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *UpdateInstanceGroupRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *UpdateInstanceGroupRequest) GetInstanceTemplate() *InstanceTemplate {
	if m != nil {
		return m.InstanceTemplate
	}
	return nil
}

func (m *UpdateInstanceGroupRequest) GetScalePolicy() *ScalePolicy {
	if m != nil {
		return m.ScalePolicy
	}
	return nil
}

func (m *UpdateInstanceGroupRequest) GetDeployPolicy() *DeployPolicy {
	if m != nil {
		return m.DeployPolicy
	}
	return nil
}

func (m *UpdateInstanceGroupRequest) GetAllocationPolicy() *AllocationPolicy {
	if m != nil {
		return m.AllocationPolicy
	}
	return nil
}

func (m *UpdateInstanceGroupRequest) GetHealthChecksSpec() *HealthChecksSpec {
	if m != nil {
		return m.HealthChecksSpec
	}
	return nil
}

func (m *UpdateInstanceGroupRequest) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

func (m *UpdateInstanceGroupRequest) GetLoadBalancerSpec() *LoadBalancerSpec {
	if m != nil {
		return m.LoadBalancerSpec
	}
	return nil
}

type UpdateInstanceGroupFromYamlRequest struct {
	// ID of the instance group to update.
	// To get the instance group ID, use an [InstanceGroupService.List] request.
	InstanceGroupId string `protobuf:"bytes,1,opt,name=instance_group_id,json=instanceGroupId,proto3" json:"instance_group_id,omitempty"`
	// UpdateInstanceGroupRequest in YAML format.
	InstanceGroupYaml    string   `protobuf:"bytes,2,opt,name=instance_group_yaml,json=instanceGroupYaml,proto3" json:"instance_group_yaml,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateInstanceGroupFromYamlRequest) Reset()         { *m = UpdateInstanceGroupFromYamlRequest{} }
func (m *UpdateInstanceGroupFromYamlRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateInstanceGroupFromYamlRequest) ProtoMessage()    {}
func (*UpdateInstanceGroupFromYamlRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fc51cd26b96eed88, []int{5}
}

func (m *UpdateInstanceGroupFromYamlRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateInstanceGroupFromYamlRequest.Unmarshal(m, b)
}
func (m *UpdateInstanceGroupFromYamlRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateInstanceGroupFromYamlRequest.Marshal(b, m, deterministic)
}
func (m *UpdateInstanceGroupFromYamlRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateInstanceGroupFromYamlRequest.Merge(m, src)
}
func (m *UpdateInstanceGroupFromYamlRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateInstanceGroupFromYamlRequest.Size(m)
}
func (m *UpdateInstanceGroupFromYamlRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateInstanceGroupFromYamlRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateInstanceGroupFromYamlRequest proto.InternalMessageInfo

func (m *UpdateInstanceGroupFromYamlRequest) GetInstanceGroupId() string {
	if m != nil {
		return m.InstanceGroupId
	}
	return ""
}

func (m *UpdateInstanceGroupFromYamlRequest) GetInstanceGroupYaml() string {
	if m != nil {
		return m.InstanceGroupYaml
	}
	return ""
}

type UpdateInstanceGroupMetadata struct {
	// ID of the InstanceGroup resource that is being updated.
	// To get the instance group ID, use an [InstanceGroupService.List] request.
	InstanceGroupId      string   `protobuf:"bytes,1,opt,name=instance_group_id,json=instanceGroupId,proto3" json:"instance_group_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateInstanceGroupMetadata) Reset()         { *m = UpdateInstanceGroupMetadata{} }
func (m *UpdateInstanceGroupMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateInstanceGroupMetadata) ProtoMessage()    {}
func (*UpdateInstanceGroupMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fc51cd26b96eed88, []int{6}
}

func (m *UpdateInstanceGroupMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateInstanceGroupMetadata.Unmarshal(m, b)
}
func (m *UpdateInstanceGroupMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateInstanceGroupMetadata.Marshal(b, m, deterministic)
}
func (m *UpdateInstanceGroupMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateInstanceGroupMetadata.Merge(m, src)
}
func (m *UpdateInstanceGroupMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateInstanceGroupMetadata.Size(m)
}
func (m *UpdateInstanceGroupMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateInstanceGroupMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateInstanceGroupMetadata proto.InternalMessageInfo

func (m *UpdateInstanceGroupMetadata) GetInstanceGroupId() string {
	if m != nil {
		return m.InstanceGroupId
	}
	return ""
}

type DeleteInstanceGroupRequest struct {
	// ID of the instance group to delete.
	// To get the instance group ID, use an [InstanceGroupService.List] request.
	InstanceGroupId      string   `protobuf:"bytes,1,opt,name=instance_group_id,json=instanceGroupId,proto3" json:"instance_group_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteInstanceGroupRequest) Reset()         { *m = DeleteInstanceGroupRequest{} }
func (m *DeleteInstanceGroupRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteInstanceGroupRequest) ProtoMessage()    {}
func (*DeleteInstanceGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fc51cd26b96eed88, []int{7}
}

func (m *DeleteInstanceGroupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteInstanceGroupRequest.Unmarshal(m, b)
}
func (m *DeleteInstanceGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteInstanceGroupRequest.Marshal(b, m, deterministic)
}
func (m *DeleteInstanceGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteInstanceGroupRequest.Merge(m, src)
}
func (m *DeleteInstanceGroupRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteInstanceGroupRequest.Size(m)
}
func (m *DeleteInstanceGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteInstanceGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteInstanceGroupRequest proto.InternalMessageInfo

func (m *DeleteInstanceGroupRequest) GetInstanceGroupId() string {
	if m != nil {
		return m.InstanceGroupId
	}
	return ""
}

type DeleteInstanceGroupMetadata struct {
	// ID of the instance group that is being deleted.
	// To get the instance group ID, use an [InstanceGroupService.List] request.
	InstanceGroupId      string   `protobuf:"bytes,1,opt,name=instance_group_id,json=instanceGroupId,proto3" json:"instance_group_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteInstanceGroupMetadata) Reset()         { *m = DeleteInstanceGroupMetadata{} }
func (m *DeleteInstanceGroupMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteInstanceGroupMetadata) ProtoMessage()    {}
func (*DeleteInstanceGroupMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fc51cd26b96eed88, []int{8}
}

func (m *DeleteInstanceGroupMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteInstanceGroupMetadata.Unmarshal(m, b)
}
func (m *DeleteInstanceGroupMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteInstanceGroupMetadata.Marshal(b, m, deterministic)
}
func (m *DeleteInstanceGroupMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteInstanceGroupMetadata.Merge(m, src)
}
func (m *DeleteInstanceGroupMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteInstanceGroupMetadata.Size(m)
}
func (m *DeleteInstanceGroupMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteInstanceGroupMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteInstanceGroupMetadata proto.InternalMessageInfo

func (m *DeleteInstanceGroupMetadata) GetInstanceGroupId() string {
	if m != nil {
		return m.InstanceGroupId
	}
	return ""
}

type DeleteInstancesMetadata struct {
	// ID of the instance group that the instances are being deleted from.
	InstanceGroupId      string   `protobuf:"bytes,1,opt,name=instance_group_id,json=instanceGroupId,proto3" json:"instance_group_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteInstancesMetadata) Reset()         { *m = DeleteInstancesMetadata{} }
func (m *DeleteInstancesMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteInstancesMetadata) ProtoMessage()    {}
func (*DeleteInstancesMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fc51cd26b96eed88, []int{9}
}

func (m *DeleteInstancesMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteInstancesMetadata.Unmarshal(m, b)
}
func (m *DeleteInstancesMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteInstancesMetadata.Marshal(b, m, deterministic)
}
func (m *DeleteInstancesMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteInstancesMetadata.Merge(m, src)
}
func (m *DeleteInstancesMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteInstancesMetadata.Size(m)
}
func (m *DeleteInstancesMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteInstancesMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteInstancesMetadata proto.InternalMessageInfo

func (m *DeleteInstancesMetadata) GetInstanceGroupId() string {
	if m != nil {
		return m.InstanceGroupId
	}
	return ""
}

type ListInstanceGroupsRequest struct {
	// ID of the folder to list instance groups in.
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListInstanceGroupsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results,
	// set [page_token] to the [ListInstanceGroupsResponse.next_page_token]
	// returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// Currently you can use filtering only on the [InstanceGroup.name] field.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Defines which information about the Instance template should be returned in the server response.
	View                 InstanceGroupView `protobuf:"varint,5,opt,name=view,proto3,enum=yandex.cloud.compute.v1.instancegroup.InstanceGroupView" json:"view,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ListInstanceGroupsRequest) Reset()         { *m = ListInstanceGroupsRequest{} }
func (m *ListInstanceGroupsRequest) String() string { return proto.CompactTextString(m) }
func (*ListInstanceGroupsRequest) ProtoMessage()    {}
func (*ListInstanceGroupsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fc51cd26b96eed88, []int{10}
}

func (m *ListInstanceGroupsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstanceGroupsRequest.Unmarshal(m, b)
}
func (m *ListInstanceGroupsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstanceGroupsRequest.Marshal(b, m, deterministic)
}
func (m *ListInstanceGroupsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstanceGroupsRequest.Merge(m, src)
}
func (m *ListInstanceGroupsRequest) XXX_Size() int {
	return xxx_messageInfo_ListInstanceGroupsRequest.Size(m)
}
func (m *ListInstanceGroupsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstanceGroupsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstanceGroupsRequest proto.InternalMessageInfo

func (m *ListInstanceGroupsRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *ListInstanceGroupsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListInstanceGroupsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListInstanceGroupsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListInstanceGroupsRequest) GetView() InstanceGroupView {
	if m != nil {
		return m.View
	}
	return InstanceGroupView_BASIC
}

type ListInstanceGroupsResponse struct {
	// Lists instance groups for the specified folder.
	InstanceGroups []*InstanceGroup `protobuf:"bytes,1,rep,name=instance_groups,json=instanceGroups,proto3" json:"instance_groups,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListInstanceGroupsRequest.page_size], use
	// [next_page_token] as the value
	// for the [ListInstanceGroupsRequest.page_token] query parameter
	// in the next list request. Each subsequent list request will have its own
	// [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstanceGroupsResponse) Reset()         { *m = ListInstanceGroupsResponse{} }
func (m *ListInstanceGroupsResponse) String() string { return proto.CompactTextString(m) }
func (*ListInstanceGroupsResponse) ProtoMessage()    {}
func (*ListInstanceGroupsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_fc51cd26b96eed88, []int{11}
}

func (m *ListInstanceGroupsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstanceGroupsResponse.Unmarshal(m, b)
}
func (m *ListInstanceGroupsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstanceGroupsResponse.Marshal(b, m, deterministic)
}
func (m *ListInstanceGroupsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstanceGroupsResponse.Merge(m, src)
}
func (m *ListInstanceGroupsResponse) XXX_Size() int {
	return xxx_messageInfo_ListInstanceGroupsResponse.Size(m)
}
func (m *ListInstanceGroupsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstanceGroupsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstanceGroupsResponse proto.InternalMessageInfo

func (m *ListInstanceGroupsResponse) GetInstanceGroups() []*InstanceGroup {
	if m != nil {
		return m.InstanceGroups
	}
	return nil
}

func (m *ListInstanceGroupsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type ListInstanceGroupInstancesRequest struct {
	// ID of the InstanceGroup resource to list instances for.
	// To get the instance group ID, use an [InstanceGroupService.List] request.
	InstanceGroupId string `protobuf:"bytes,1,opt,name=instance_group_id,json=instanceGroupId,proto3" json:"instance_group_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListInstanceGroupInstancesResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results,
	// set [page_token] to the [ListInstanceGroupInstancesResponse.next_page_token]
	// returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// Currently you can use filtering only on the [InstanceGroup.name] field.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstanceGroupInstancesRequest) Reset()         { *m = ListInstanceGroupInstancesRequest{} }
func (m *ListInstanceGroupInstancesRequest) String() string { return proto.CompactTextString(m) }
func (*ListInstanceGroupInstancesRequest) ProtoMessage()    {}
func (*ListInstanceGroupInstancesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fc51cd26b96eed88, []int{12}
}

func (m *ListInstanceGroupInstancesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstanceGroupInstancesRequest.Unmarshal(m, b)
}
func (m *ListInstanceGroupInstancesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstanceGroupInstancesRequest.Marshal(b, m, deterministic)
}
func (m *ListInstanceGroupInstancesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstanceGroupInstancesRequest.Merge(m, src)
}
func (m *ListInstanceGroupInstancesRequest) XXX_Size() int {
	return xxx_messageInfo_ListInstanceGroupInstancesRequest.Size(m)
}
func (m *ListInstanceGroupInstancesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstanceGroupInstancesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstanceGroupInstancesRequest proto.InternalMessageInfo

func (m *ListInstanceGroupInstancesRequest) GetInstanceGroupId() string {
	if m != nil {
		return m.InstanceGroupId
	}
	return ""
}

func (m *ListInstanceGroupInstancesRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListInstanceGroupInstancesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListInstanceGroupInstancesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListInstanceGroupInstancesResponse struct {
	// Lists instances for the specified instance group.
	Instances []*ManagedInstance `protobuf:"bytes,1,rep,name=instances,proto3" json:"instances,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is more than [ListInstanceGroupInstancesRequest.page_size], use
	// [next_page_token] as the value
	// for the [ListInstanceGroupInstancesRequest.page_token] query parameter
	// in the next list request. Each subsequent list request will have its own
	// [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstanceGroupInstancesResponse) Reset()         { *m = ListInstanceGroupInstancesResponse{} }
func (m *ListInstanceGroupInstancesResponse) String() string { return proto.CompactTextString(m) }
func (*ListInstanceGroupInstancesResponse) ProtoMessage()    {}
func (*ListInstanceGroupInstancesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_fc51cd26b96eed88, []int{13}
}

func (m *ListInstanceGroupInstancesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstanceGroupInstancesResponse.Unmarshal(m, b)
}
func (m *ListInstanceGroupInstancesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstanceGroupInstancesResponse.Marshal(b, m, deterministic)
}
func (m *ListInstanceGroupInstancesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstanceGroupInstancesResponse.Merge(m, src)
}
func (m *ListInstanceGroupInstancesResponse) XXX_Size() int {
	return xxx_messageInfo_ListInstanceGroupInstancesResponse.Size(m)
}
func (m *ListInstanceGroupInstancesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstanceGroupInstancesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstanceGroupInstancesResponse proto.InternalMessageInfo

func (m *ListInstanceGroupInstancesResponse) GetInstances() []*ManagedInstance {
	if m != nil {
		return m.Instances
	}
	return nil
}

func (m *ListInstanceGroupInstancesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type ListInstanceGroupOperationsRequest struct {
	// ID of the InstanceGroup resource to list operations for.
	// To get the instance group ID, use a [InstanceGroupService.List] request.
	InstanceGroupId string `protobuf:"bytes,1,opt,name=instance_group_id,json=instanceGroupId,proto3" json:"instance_group_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is more than [page_size], the service returns a [ListInstanceGroupOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListInstanceGroupOperationsResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// Currently you can use filtering only on the [InstanceGroup.name] field.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstanceGroupOperationsRequest) Reset()         { *m = ListInstanceGroupOperationsRequest{} }
func (m *ListInstanceGroupOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListInstanceGroupOperationsRequest) ProtoMessage()    {}
func (*ListInstanceGroupOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fc51cd26b96eed88, []int{14}
}

func (m *ListInstanceGroupOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstanceGroupOperationsRequest.Unmarshal(m, b)
}
func (m *ListInstanceGroupOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstanceGroupOperationsRequest.Marshal(b, m, deterministic)
}
func (m *ListInstanceGroupOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstanceGroupOperationsRequest.Merge(m, src)
}
func (m *ListInstanceGroupOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListInstanceGroupOperationsRequest.Size(m)
}
func (m *ListInstanceGroupOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstanceGroupOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstanceGroupOperationsRequest proto.InternalMessageInfo

func (m *ListInstanceGroupOperationsRequest) GetInstanceGroupId() string {
	if m != nil {
		return m.InstanceGroupId
	}
	return ""
}

func (m *ListInstanceGroupOperationsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListInstanceGroupOperationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListInstanceGroupOperationsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListInstanceGroupOperationsResponse struct {
	// Lists operations for the specified instance group.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is more than [ListInstanceGroupOperationsRequest.page_size], use the [next_page_token] as the value
	// for the [ListInstanceGroupOperationsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstanceGroupOperationsResponse) Reset()         { *m = ListInstanceGroupOperationsResponse{} }
func (m *ListInstanceGroupOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListInstanceGroupOperationsResponse) ProtoMessage()    {}
func (*ListInstanceGroupOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_fc51cd26b96eed88, []int{15}
}

func (m *ListInstanceGroupOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstanceGroupOperationsResponse.Unmarshal(m, b)
}
func (m *ListInstanceGroupOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstanceGroupOperationsResponse.Marshal(b, m, deterministic)
}
func (m *ListInstanceGroupOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstanceGroupOperationsResponse.Merge(m, src)
}
func (m *ListInstanceGroupOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListInstanceGroupOperationsResponse.Size(m)
}
func (m *ListInstanceGroupOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstanceGroupOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstanceGroupOperationsResponse proto.InternalMessageInfo

func (m *ListInstanceGroupOperationsResponse) GetOperations() []*operation.Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListInstanceGroupOperationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type ListInstanceGroupLogRecordsRequest struct {
	// ID of the InstanceGroup resource to list logs for.
	// To get the instance group ID, use an [InstanceGroupService.List] request.
	InstanceGroupId string `protobuf:"bytes,1,opt,name=instance_group_id,json=instanceGroupId,proto3" json:"instance_group_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListInstanceGroupLogRecordsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results,
	// set [page_token] to the [ListInstanceGroupLogRecordsResponse.next_page_token]
	// returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// Currently you can use filtering only on the [InstanceGroup.name] field.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstanceGroupLogRecordsRequest) Reset()         { *m = ListInstanceGroupLogRecordsRequest{} }
func (m *ListInstanceGroupLogRecordsRequest) String() string { return proto.CompactTextString(m) }
func (*ListInstanceGroupLogRecordsRequest) ProtoMessage()    {}
func (*ListInstanceGroupLogRecordsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fc51cd26b96eed88, []int{16}
}

func (m *ListInstanceGroupLogRecordsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstanceGroupLogRecordsRequest.Unmarshal(m, b)
}
func (m *ListInstanceGroupLogRecordsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstanceGroupLogRecordsRequest.Marshal(b, m, deterministic)
}
func (m *ListInstanceGroupLogRecordsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstanceGroupLogRecordsRequest.Merge(m, src)
}
func (m *ListInstanceGroupLogRecordsRequest) XXX_Size() int {
	return xxx_messageInfo_ListInstanceGroupLogRecordsRequest.Size(m)
}
func (m *ListInstanceGroupLogRecordsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstanceGroupLogRecordsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstanceGroupLogRecordsRequest proto.InternalMessageInfo

func (m *ListInstanceGroupLogRecordsRequest) GetInstanceGroupId() string {
	if m != nil {
		return m.InstanceGroupId
	}
	return ""
}

func (m *ListInstanceGroupLogRecordsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListInstanceGroupLogRecordsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListInstanceGroupLogRecordsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListInstanceGroupLogRecordsResponse struct {
	// Lists logs for the specified instance group.
	LogRecords []*LogRecord `protobuf:"bytes,1,rep,name=log_records,json=logRecords,proto3" json:"log_records,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListInstanceGroupLogRecordsRequest.page_size], use
	// [next_page_token] as the value
	// for the [ListInstanceGroupLogRecordsRequest.page_token] query parameter
	// in the next list request. Each subsequent list request will have its own
	// [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstanceGroupLogRecordsResponse) Reset()         { *m = ListInstanceGroupLogRecordsResponse{} }
func (m *ListInstanceGroupLogRecordsResponse) String() string { return proto.CompactTextString(m) }
func (*ListInstanceGroupLogRecordsResponse) ProtoMessage()    {}
func (*ListInstanceGroupLogRecordsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_fc51cd26b96eed88, []int{17}
}

func (m *ListInstanceGroupLogRecordsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstanceGroupLogRecordsResponse.Unmarshal(m, b)
}
func (m *ListInstanceGroupLogRecordsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstanceGroupLogRecordsResponse.Marshal(b, m, deterministic)
}
func (m *ListInstanceGroupLogRecordsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstanceGroupLogRecordsResponse.Merge(m, src)
}
func (m *ListInstanceGroupLogRecordsResponse) XXX_Size() int {
	return xxx_messageInfo_ListInstanceGroupLogRecordsResponse.Size(m)
}
func (m *ListInstanceGroupLogRecordsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstanceGroupLogRecordsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstanceGroupLogRecordsResponse proto.InternalMessageInfo

func (m *ListInstanceGroupLogRecordsResponse) GetLogRecords() []*LogRecord {
	if m != nil {
		return m.LogRecords
	}
	return nil
}

func (m *ListInstanceGroupLogRecordsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterEnum("yandex.cloud.compute.v1.instancegroup.InstanceGroupView", InstanceGroupView_name, InstanceGroupView_value)
	proto.RegisterType((*GetInstanceGroupRequest)(nil), "yandex.cloud.compute.v1.instancegroup.GetInstanceGroupRequest")
	proto.RegisterType((*CreateInstanceGroupRequest)(nil), "yandex.cloud.compute.v1.instancegroup.CreateInstanceGroupRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.compute.v1.instancegroup.CreateInstanceGroupRequest.LabelsEntry")
	proto.RegisterType((*CreateInstanceGroupFromYamlRequest)(nil), "yandex.cloud.compute.v1.instancegroup.CreateInstanceGroupFromYamlRequest")
	proto.RegisterType((*CreateInstanceGroupMetadata)(nil), "yandex.cloud.compute.v1.instancegroup.CreateInstanceGroupMetadata")
	proto.RegisterType((*UpdateInstanceGroupRequest)(nil), "yandex.cloud.compute.v1.instancegroup.UpdateInstanceGroupRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.compute.v1.instancegroup.UpdateInstanceGroupRequest.LabelsEntry")
	proto.RegisterType((*UpdateInstanceGroupFromYamlRequest)(nil), "yandex.cloud.compute.v1.instancegroup.UpdateInstanceGroupFromYamlRequest")
	proto.RegisterType((*UpdateInstanceGroupMetadata)(nil), "yandex.cloud.compute.v1.instancegroup.UpdateInstanceGroupMetadata")
	proto.RegisterType((*DeleteInstanceGroupRequest)(nil), "yandex.cloud.compute.v1.instancegroup.DeleteInstanceGroupRequest")
	proto.RegisterType((*DeleteInstanceGroupMetadata)(nil), "yandex.cloud.compute.v1.instancegroup.DeleteInstanceGroupMetadata")
	proto.RegisterType((*DeleteInstancesMetadata)(nil), "yandex.cloud.compute.v1.instancegroup.DeleteInstancesMetadata")
	proto.RegisterType((*ListInstanceGroupsRequest)(nil), "yandex.cloud.compute.v1.instancegroup.ListInstanceGroupsRequest")
	proto.RegisterType((*ListInstanceGroupsResponse)(nil), "yandex.cloud.compute.v1.instancegroup.ListInstanceGroupsResponse")
	proto.RegisterType((*ListInstanceGroupInstancesRequest)(nil), "yandex.cloud.compute.v1.instancegroup.ListInstanceGroupInstancesRequest")
	proto.RegisterType((*ListInstanceGroupInstancesResponse)(nil), "yandex.cloud.compute.v1.instancegroup.ListInstanceGroupInstancesResponse")
	proto.RegisterType((*ListInstanceGroupOperationsRequest)(nil), "yandex.cloud.compute.v1.instancegroup.ListInstanceGroupOperationsRequest")
	proto.RegisterType((*ListInstanceGroupOperationsResponse)(nil), "yandex.cloud.compute.v1.instancegroup.ListInstanceGroupOperationsResponse")
	proto.RegisterType((*ListInstanceGroupLogRecordsRequest)(nil), "yandex.cloud.compute.v1.instancegroup.ListInstanceGroupLogRecordsRequest")
	proto.RegisterType((*ListInstanceGroupLogRecordsResponse)(nil), "yandex.cloud.compute.v1.instancegroup.ListInstanceGroupLogRecordsResponse")
}

func init() {
	proto.RegisterFile("yandex/cloud/compute/v1/instancegroup/instance_group_service.proto", fileDescriptor_fc51cd26b96eed88)
}

var fileDescriptor_fc51cd26b96eed88 = []byte{
	// 1558 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x59, 0xcd, 0x6f, 0x1b, 0x45,
	0x1b, 0x7f, 0x37, 0x71, 0xfc, 0xc6, 0x8f, 0x93, 0xd4, 0x99, 0xb7, 0xaf, 0x6a, 0xb6, 0xad, 0x9a,
	0x2c, 0x50, 0xa2, 0x50, 0x7f, 0xe6, 0xa3, 0xf9, 0x68, 0xa1, 0x76, 0x3f, 0x8d, 0x12, 0x51, 0x36,
	0x6d, 0x51, 0x1b, 0x15, 0x6b, 0xb2, 0x3b, 0x71, 0x96, 0xac, 0x77, 0x17, 0xef, 0x3a, 0x6d, 0x52,
	0x7a, 0x29, 0xb7, 0x1c, 0x10, 0x12, 0x17, 0x8e, 0x14, 0x24, 0xae, 0x48, 0xe5, 0x6f, 0x40, 0xc9,
	0x85, 0x0b, 0x1f, 0x07, 0x38, 0x70, 0xaa, 0x10, 0x42, 0x88, 0x43, 0x8f, 0x9c, 0xd0, 0xce, 0x8c,
	0x1d, 0xaf, 0xbf, 0xba, 0x76, 0x52, 0x51, 0x09, 0x6e, 0xde, 0x99, 0x79, 0x3e, 0x7e, 0xbf, 0x67,
	0xe7, 0x37, 0xcf, 0xac, 0x21, 0xbb, 0x89, 0x0d, 0x95, 0xdc, 0x4d, 0x28, 0xba, 0x59, 0x56, 0x13,
	0x8a, 0x59, 0xb4, 0xca, 0x0e, 0x49, 0x6c, 0xa4, 0x12, 0x9a, 0x61, 0x3b, 0xd8, 0x50, 0x48, 0xa1,
	0x64, 0x96, 0xad, 0xea, 0x53, 0x9e, 0x3e, 0xe6, 0x6d, 0x52, 0xda, 0xd0, 0x14, 0x12, 0xb7, 0x4a,
	0xa6, 0x63, 0xa2, 0x97, 0x99, 0x8f, 0x38, 0xf5, 0x11, 0xe7, 0x3e, 0xe2, 0x1b, 0xa9, 0xb8, 0xc7,
	0x87, 0x38, 0x52, 0x30, 0xcd, 0x82, 0x4e, 0x12, 0xd4, 0x68, 0xa5, 0xbc, 0x9a, 0x58, 0xd5, 0x88,
	0xae, 0xe6, 0x8b, 0xd8, 0x5e, 0x67, 0x8e, 0xc4, 0x63, 0x7c, 0x05, 0xb6, 0xb4, 0x04, 0x36, 0x0c,
	0xd3, 0xc1, 0x8e, 0x66, 0x1a, 0x36, 0x9f, 0x1d, 0xf1, 0xa4, 0xea, 0xae, 0x31, 0x2d, 0x52, 0xa2,
	0x4b, 0xf8, 0x8a, 0xb9, 0x6e, 0xc0, 0x70, 0xdb, 0x93, 0x1e, 0xdb, 0xaa, 0xe7, 0x86, 0x18, 0xc7,
	0x3d, 0xeb, 0x36, 0xb0, 0xae, 0xa9, 0x35, 0xd3, 0xd2, 0x43, 0x01, 0x8e, 0x5c, 0x26, 0x4e, 0x8e,
	0x87, 0xb8, 0xec, 0x46, 0x90, 0xc9, 0x7b, 0x65, 0x62, 0x3b, 0x68, 0x06, 0x86, 0xeb, 0x78, 0xd4,
	0xd4, 0xa8, 0x30, 0x22, 0x8c, 0x85, 0xb2, 0x03, 0xbf, 0xee, 0xa4, 0x84, 0xed, 0xdd, 0x54, 0xe0,
	0xcc, 0xd9, 0xa9, 0xa4, 0x7c, 0x48, 0xab, 0x35, 0xcf, 0xa9, 0x68, 0x01, 0x02, 0x1b, 0x1a, 0xb9,
	0x13, 0xed, 0x19, 0x11, 0xc6, 0x86, 0xd2, 0x33, 0x71, 0x5f, 0x84, 0xc7, 0x3d, 0x49, 0xdc, 0xd0,
	0xc8, 0x1d, 0x99, 0x7a, 0x91, 0x3e, 0xe9, 0x07, 0xf1, 0x7c, 0x89, 0x60, 0x87, 0x34, 0x4d, 0x73,
	0x14, 0x42, 0xab, 0xa6, 0xae, 0x92, 0xd2, 0x5e, 0x7a, 0x01, 0x37, 0x3d, 0xb9, 0x9f, 0x0d, 0xe7,
	0x54, 0x34, 0x05, 0x01, 0x03, 0x17, 0x49, 0xb4, 0x97, 0xce, 0x8e, 0x3e, 0xd9, 0x49, 0x1d, 0x7f,
	0x7f, 0x19, 0xc7, 0xb6, 0x6e, 0x2f, 0xc7, 0x70, 0x6c, 0x2b, 0x19, 0x9b, 0xbd, 0x7d, 0x2f, 0x75,
	0x6a, 0x3a, 0x75, 0x7f, 0x99, 0x3f, 0xc9, 0x74, 0x39, 0x7a, 0x15, 0xc2, 0x2a, 0xb1, 0x95, 0x92,
	0x66, 0xb9, 0x8c, 0x45, 0x03, 0xd4, 0x3a, 0xb4, 0xbd, 0x9b, 0xea, 0x3b, 0x73, 0x36, 0x3d, 0x35,
	0x2d, 0xd7, 0xce, 0xa2, 0x2f, 0x04, 0x08, 0xea, 0x78, 0x85, 0xe8, 0x76, 0xb4, 0x6f, 0xa4, 0x77,
	0x2c, 0x9c, 0x5e, 0xf4, 0x09, 0xbb, 0x35, 0xb4, 0xf8, 0x02, 0xf5, 0x77, 0xd1, 0x70, 0x4a, 0x9b,
	0xd9, 0xd7, 0x9f, 0xec, 0xa4, 0xc2, 0xcb, 0xb1, 0x7c, 0x32, 0x36, 0xeb, 0x66, 0x3e, 0xfe, 0x80,
	0xb2, 0x3f, 0x3d, 0xc9, 0xaa, 0x30, 0x3d, 0xf1, 0x68, 0x37, 0x15, 0x14, 0x03, 0xa9, 0x18, 0xfd,
	0x85, 0x50, 0x84, 0xe3, 0xab, 0xae, 0x97, 0x79, 0x76, 0xe8, 0xdd, 0x9a, 0xb2, 0x3a, 0xa4, 0x68,
	0xe9, 0xd8, 0x21, 0xd1, 0xe0, 0x88, 0x30, 0x16, 0x4e, 0x9f, 0xee, 0xb0, 0x52, 0xd7, 0xb8, 0x39,
	0x27, 0x3c, 0xa2, 0xd5, 0x8d, 0xa3, 0x65, 0x18, 0xb0, 0x15, 0xac, 0x93, 0xbc, 0x65, 0xea, 0x9a,
	0xb2, 0x19, 0xfd, 0x2f, 0x0d, 0x93, 0xf6, 0x19, 0x66, 0xc9, 0x35, 0xbd, 0x4a, 0x2d, 0x79, 0x84,
	0xb0, 0xbd, 0x37, 0x84, 0xde, 0x81, 0x41, 0x95, 0x58, 0xba, 0xb9, 0x59, 0xf1, 0xde, 0x4f, 0xbd,
	0x4f, 0xf8, 0xf4, 0x7e, 0x81, 0xda, 0x7a, 0xdc, 0x0f, 0xa8, 0x35, 0x63, 0x2e, 0x51, 0x58, 0xd7,
	0x4d, 0x85, 0xee, 0x97, 0x4a, 0x8c, 0x50, 0x47, 0x44, 0x65, 0xaa, 0xf6, 0x9e, 0x38, 0x11, 0x5c,
	0x37, 0x8e, 0x08, 0x20, 0xdd, 0xc4, 0x6a, 0x7e, 0x05, 0xeb, 0xae, 0x75, 0x29, 0x6f, 0x5b, 0x44,
	0x89, 0x42, 0x47, 0xc1, 0x16, 0x4c, 0xac, 0x66, 0xb9, 0xfd, 0x92, 0x45, 0x14, 0x39, 0xa2, 0xd7,
	0x8d, 0xb8, 0x61, 0xd6, 0x08, 0xd6, 0x9d, 0xb5, 0xbc, 0xb2, 0x46, 0x94, 0x75, 0x9b, 0x85, 0x09,
	0x77, 0x14, 0xe6, 0x0a, 0x75, 0x70, 0x9e, 0xda, 0xb3, 0x30, 0x6b, 0x75, 0x23, 0xe8, 0x14, 0x20,
	0x2e, 0xb9, 0x79, 0xac, 0x28, 0x66, 0xd9, 0x70, 0xdc, 0xbd, 0x39, 0xe0, 0xee, 0x1f, 0x39, 0xc2,
	0x67, 0x32, 0x6c, 0x22, 0xa7, 0x8a, 0xb3, 0x10, 0xae, 0x79, 0xd1, 0x51, 0x04, 0x7a, 0xd7, 0xc9,
	0x26, 0xdb, 0xc9, 0xb2, 0xfb, 0x13, 0x1d, 0x86, 0xbe, 0x0d, 0xac, 0x97, 0x09, 0xd5, 0x93, 0x90,
	0xcc, 0x1e, 0xe6, 0x7a, 0x66, 0x04, 0x69, 0x5b, 0x00, 0xa9, 0xc9, 0xfe, 0xb9, 0x54, 0x32, 0x8b,
	0x37, 0x71, 0x51, 0xef, 0x40, 0x22, 0x32, 0xf0, 0xbf, 0x3a, 0xb1, 0xdb, 0xc4, 0x45, 0x9d, 0x45,
	0xcc, 0x0e, 0x73, 0xb9, 0x0b, 0x9d, 0x39, 0x9b, 0x4a, 0x4e, 0xce, 0x4c, 0x9d, 0x9e, 0x96, 0x87,
	0x3d, 0x9a, 0xe7, 0x06, 0x93, 0x96, 0xe0, 0x68, 0x93, 0x5c, 0x16, 0x89, 0x83, 0x55, 0xec, 0x60,
	0x34, 0xd9, 0x5a, 0x4e, 0xfb, 0x5b, 0x4a, 0xa9, 0xf4, 0x7b, 0x3f, 0x88, 0xd7, 0x2d, 0xb5, 0x95,
	0xf8, 0x75, 0xaf, 0xd1, 0xf3, 0x10, 0x2e, 0x53, 0xbf, 0xf4, 0x44, 0xa3, 0x40, 0xc3, 0x69, 0x31,
	0xce, 0x8e, 0xb4, 0x78, 0xe5, 0xd0, 0x8b, 0x5f, 0x72, 0x0f, 0xbd, 0x45, 0x6c, 0xaf, 0xcb, 0xc0,
	0x96, 0xbb, 0xbf, 0x9f, 0x6f, 0x41, 0x6d, 0x4d, 0xd7, 0xbf, 0x82, 0xfa, 0x4f, 0x12, 0xd4, 0xe7,
	0x4e, 0xe9, 0x5a, 0xa8, 0xfc, 0xd0, 0x01, 0xab, 0xfc, 0x7e, 0x04, 0xf5, 0xa1, 0x00, 0x52, 0x93,
	0xfd, 0x53, 0x2f, 0xa8, 0xdd, 0xcb, 0xce, 0x01, 0xe8, 0x6c, 0x0e, 0x8e, 0x36, 0x49, 0xb1, 0xaa,
	0xb3, 0xe3, 0x2d, 0x73, 0x6b, 0x54, 0xd7, 0x1b, 0x20, 0x5e, 0x20, 0x3a, 0x39, 0x68, 0x71, 0x75,
	0x53, 0x6c, 0xe2, 0xb7, 0xab, 0x14, 0x2f, 0xc2, 0x11, 0xaf, 0x2b, 0xbb, 0x2b, 0x37, 0x1f, 0xf4,
	0xc0, 0x0b, 0x0b, 0x9a, 0xed, 0xed, 0xf4, 0xed, 0x0e, 0x0e, 0xc8, 0x57, 0x20, 0x64, 0xe1, 0x02,
	0xc9, 0xdb, 0xda, 0x16, 0x7b, 0x6f, 0x7a, 0xb3, 0xf0, 0xe7, 0x4e, 0x2a, 0xe8, 0x96, 0x2a, 0x99,
	0x94, 0xfb, 0xdd, 0xc9, 0x25, 0x6d, 0x8b, 0xa0, 0x31, 0x00, 0xba, 0xd0, 0x31, 0xd7, 0x89, 0xc1,
	0x4f, 0x08, 0xae, 0xf1, 0xa9, 0x64, 0x52, 0xa6, 0x5e, 0xae, 0xb9, 0x73, 0x48, 0x82, 0xe0, 0xaa,
	0xa6, 0x3b, 0xa4, 0xc4, 0x4f, 0x02, 0xd8, 0xde, 0xad, 0xfa, 0xe3, 0x33, 0xd5, 0xab, 0x44, 0xdf,
	0x81, 0x5c, 0x25, 0x3e, 0x17, 0x40, 0x6c, 0xc6, 0x82, 0x6d, 0x99, 0x86, 0x4d, 0xd0, 0x6d, 0x38,
	0xe4, 0x25, 0xd4, 0x8e, 0x0a, 0xf4, 0xe8, 0x99, 0xec, 0x26, 0xae, 0x3c, 0xe4, 0x29, 0x82, 0x8d,
	0x4e, 0xc2, 0x21, 0x83, 0xdc, 0x75, 0xf2, 0x35, 0xf4, 0xb0, 0x0d, 0x38, 0xe8, 0x0e, 0x5f, 0xad,
	0xf0, 0x22, 0x7d, 0x2f, 0xc0, 0x68, 0x43, 0x96, 0xd5, 0xf2, 0xef, 0x7f, 0x0f, 0xfe, 0x3d, 0xa5,
	0x94, 0x3e, 0x13, 0x40, 0x6a, 0x07, 0x8b, 0x17, 0xe1, 0x1a, 0x84, 0x2a, 0x09, 0x57, 0xe8, 0x9f,
	0xf6, 0x49, 0xff, 0x22, 0x36, 0x70, 0x81, 0xa8, 0x15, 0x9f, 0xf2, 0x9e, 0x23, 0xdf, 0xdc, 0xff,
	0xd0, 0x2c, 0xc9, 0x37, 0x2b, 0x97, 0xea, 0x67, 0x48, 0x7e, 0x32, 0xf6, 0x4c, 0xc9, 0xff, 0x48,
	0x80, 0x17, 0xdb, 0xe2, 0xe2, 0xec, 0x67, 0x00, 0xaa, 0x9f, 0x10, 0x2a, 0xf4, 0x8f, 0x7a, 0xe9,
	0xdf, 0xfb, 0xc4, 0x50, 0xb5, 0x97, 0x6b, 0x8c, 0x7c, 0x53, 0xfd, 0x4d, 0x33, 0xaa, 0x17, 0xcc,
	0x82, 0x4c, 0x14, 0xb3, 0xa4, 0x56, 0xa9, 0x4e, 0xb6, 0xa6, 0x9a, 0x69, 0xd4, 0xf3, 0x42, 0xf1,
	0xa7, 0xcd, 0x28, 0xae, 0xc5, 0xc3, 0x29, 0x7e, 0x0b, 0xc2, 0xba, 0x59, 0xc8, 0x97, 0xd8, 0x30,
	0xe7, 0x38, 0xe9, 0xfb, 0xf8, 0xe7, 0xfe, 0x64, 0xd0, 0xab, 0xae, 0xfd, 0x52, 0x3e, 0x3e, 0x06,
	0xc3, 0x0d, 0xd2, 0x88, 0x42, 0xd0, 0x97, 0xcd, 0x2c, 0xe5, 0xce, 0x47, 0xfe, 0x83, 0xfa, 0x21,
	0x70, 0xe9, 0xfa, 0xc2, 0x42, 0x44, 0x48, 0x7f, 0x38, 0x0c, 0x87, 0x3d, 0x4b, 0x97, 0x58, 0x33,
	0x83, 0xbe, 0x12, 0xa0, 0xf7, 0x32, 0x71, 0xd0, 0x6b, 0x3e, 0x13, 0x6e, 0xf1, 0x75, 0x49, 0xec,
	0x4a, 0x52, 0xa5, 0xe9, 0x07, 0xdf, 0x3d, 0xfe, 0xb8, 0x27, 0x89, 0xe2, 0xcd, 0x3e, 0x97, 0x31,
	0x99, 0x4d, 0xdc, 0x6b, 0x78, 0x5d, 0xee, 0xa3, 0x2f, 0x05, 0x08, 0xb8, 0xb5, 0x41, 0xe7, 0xfc,
	0xf2, 0xdc, 0xea, 0xac, 0x14, 0x33, 0xfb, 0xf0, 0xc0, 0xde, 0x00, 0x49, 0xa2, 0x28, 0x8e, 0x21,
	0xb1, 0x35, 0x0a, 0xf4, 0xb5, 0x00, 0x41, 0x76, 0x9d, 0x44, 0x99, 0x7d, 0x7f, 0x49, 0x12, 0x9f,
	0xbe, 0x85, 0xa5, 0xeb, 0x8f, 0xbe, 0x1d, 0x3f, 0xd5, 0xfe, 0x0a, 0x3b, 0xe8, 0x19, 0xa6, 0x20,
	0x4e, 0x48, 0x6d, 0x40, 0xcc, 0x09, 0xe3, 0xe8, 0x27, 0x01, 0x86, 0x98, 0xcf, 0x4a, 0x13, 0x89,
	0x72, 0xdd, 0xe3, 0xa9, 0x6b, 0x44, 0xfd, 0xe0, 0xba, 0xd5, 0x15, 0xae, 0x97, 0xa4, 0x13, 0x6d,
	0x70, 0xb9, 0x3d, 0xab, 0x0b, 0xee, 0x47, 0x01, 0x82, 0xac, 0x17, 0xf5, 0x5d, 0xa4, 0xd6, 0xb7,
	0x53, 0x3f, 0x60, 0x34, 0x06, 0xa6, 0x5d, 0xff, 0xdb, 0x04, 0xcc, 0x44, 0xba, 0xc3, 0xfd, 0xe2,
	0x62, 0xfb, 0x43, 0x80, 0x21, 0x16, 0xa7, 0xe3, 0xc2, 0x3d, 0xfd, 0x06, 0xe1, 0x07, 0xab, 0xd1,
	0x15, 0xd6, 0x99, 0xf4, 0x44, 0x87, 0x58, 0x2b, 0xc5, 0xfc, 0x59, 0x80, 0x20, 0x6b, 0xb5, 0x7d,
	0x17, 0xb3, 0xf5, 0xe5, 0xc1, 0x2f, 0xc0, 0xc9, 0xf6, 0x37, 0x85, 0xff, 0xd7, 0x7f, 0x8f, 0xb9,
	0x58, 0xb4, 0x9c, 0x4d, 0x26, 0x82, 0xe3, 0x9d, 0x8a, 0xe0, 0x2f, 0x02, 0x0c, 0xd6, 0xaa, 0x92,
	0x8d, 0xae, 0x74, 0xab, 0x65, 0xf5, 0xdd, 0xa8, 0x98, 0x3b, 0x00, 0x4f, 0x5c, 0x1d, 0xcf, 0x51,
	0x78, 0x73, 0x68, 0xa6, 0x33, 0x78, 0x89, 0xbd, 0x66, 0xef, 0x37, 0x01, 0x86, 0xdc, 0x40, 0x7b,
	0xfd, 0x0d, 0xea, 0x3a, 0xbf, 0x86, 0xde, 0x4f, 0x7c, 0xe3, 0x20, 0x5c, 0x71, 0xac, 0x19, 0x8a,
	0x75, 0x1e, 0xcd, 0x76, 0x88, 0xb5, 0xa6, 0xdd, 0x7a, 0xcc, 0xc1, 0xee, 0x75, 0x1a, 0xdd, 0x83,
	0x6d, 0xe8, 0xbe, 0xba, 0x07, 0xdb, 0xd8, 0xf8, 0x48, 0xf3, 0x14, 0xec, 0x14, 0xea, 0x74, 0x83,
	0xea, 0x66, 0xc1, 0xce, 0xde, 0xbc, 0xf5, 0x76, 0x41, 0x73, 0xd6, 0xca, 0x2b, 0x6e, 0x0e, 0x09,
	0x96, 0x54, 0x8c, 0xfd, 0xab, 0x55, 0x30, 0x63, 0x05, 0x62, 0xd0, 0x2d, 0x92, 0xf0, 0xf5, 0x97,
	0xda, 0xbc, 0xe7, 0x69, 0x25, 0x48, 0x4d, 0x27, 0xfe, 0x0a, 0x00, 0x00, 0xff, 0xff, 0xc6, 0x0e,
	0xaf, 0x7a, 0x5d, 0x1c, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// InstanceGroupServiceClient is the client API for InstanceGroupService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type InstanceGroupServiceClient interface {
	// Returns the specified InstanceGroup resource.
	//
	// To get the list of available InstanceGroup resources, make a [List] request.
	Get(ctx context.Context, in *GetInstanceGroupRequest, opts ...grpc.CallOption) (*InstanceGroup, error)
	// Retrieves the list of InstanceGroup resources in the specified folder.
	List(ctx context.Context, in *ListInstanceGroupsRequest, opts ...grpc.CallOption) (*ListInstanceGroupsResponse, error)
	// Creates an instance group in the specified folder.
	// This method starts an operation that can be cancelled by another operation.
	Create(ctx context.Context, in *CreateInstanceGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Creates an instance group in the specified folder from a YAML file.
	// This method starts an operation that can be cancelled by another operation.
	CreateFromYaml(ctx context.Context, in *CreateInstanceGroupFromYamlRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified instance group.
	// This method starts an operation that can be cancelled by another operation.
	Update(ctx context.Context, in *UpdateInstanceGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified instance group from a YAML file.
	// This method starts an operation that can be cancelled by another operation.
	UpdateFromYaml(ctx context.Context, in *UpdateInstanceGroupFromYamlRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified instance group.
	Delete(ctx context.Context, in *DeleteInstanceGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists instances for the specified instance group.
	ListInstances(ctx context.Context, in *ListInstanceGroupInstancesRequest, opts ...grpc.CallOption) (*ListInstanceGroupInstancesResponse, error)
	// Lists operations for the specified instance group.
	ListOperations(ctx context.Context, in *ListInstanceGroupOperationsRequest, opts ...grpc.CallOption) (*ListInstanceGroupOperationsResponse, error)
	// Lists logs for the specified instance group.
	ListLogRecords(ctx context.Context, in *ListInstanceGroupLogRecordsRequest, opts ...grpc.CallOption) (*ListInstanceGroupLogRecordsResponse, error)
}

type instanceGroupServiceClient struct {
	cc *grpc.ClientConn
}

func NewInstanceGroupServiceClient(cc *grpc.ClientConn) InstanceGroupServiceClient {
	return &instanceGroupServiceClient{cc}
}

func (c *instanceGroupServiceClient) Get(ctx context.Context, in *GetInstanceGroupRequest, opts ...grpc.CallOption) (*InstanceGroup, error) {
	out := new(InstanceGroup)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.instancegroup.InstanceGroupService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupServiceClient) List(ctx context.Context, in *ListInstanceGroupsRequest, opts ...grpc.CallOption) (*ListInstanceGroupsResponse, error) {
	out := new(ListInstanceGroupsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.instancegroup.InstanceGroupService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupServiceClient) Create(ctx context.Context, in *CreateInstanceGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.instancegroup.InstanceGroupService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupServiceClient) CreateFromYaml(ctx context.Context, in *CreateInstanceGroupFromYamlRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.instancegroup.InstanceGroupService/CreateFromYaml", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupServiceClient) Update(ctx context.Context, in *UpdateInstanceGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.instancegroup.InstanceGroupService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupServiceClient) UpdateFromYaml(ctx context.Context, in *UpdateInstanceGroupFromYamlRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.instancegroup.InstanceGroupService/UpdateFromYaml", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupServiceClient) Delete(ctx context.Context, in *DeleteInstanceGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.instancegroup.InstanceGroupService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupServiceClient) ListInstances(ctx context.Context, in *ListInstanceGroupInstancesRequest, opts ...grpc.CallOption) (*ListInstanceGroupInstancesResponse, error) {
	out := new(ListInstanceGroupInstancesResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.instancegroup.InstanceGroupService/ListInstances", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupServiceClient) ListOperations(ctx context.Context, in *ListInstanceGroupOperationsRequest, opts ...grpc.CallOption) (*ListInstanceGroupOperationsResponse, error) {
	out := new(ListInstanceGroupOperationsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.instancegroup.InstanceGroupService/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupServiceClient) ListLogRecords(ctx context.Context, in *ListInstanceGroupLogRecordsRequest, opts ...grpc.CallOption) (*ListInstanceGroupLogRecordsResponse, error) {
	out := new(ListInstanceGroupLogRecordsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.instancegroup.InstanceGroupService/ListLogRecords", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// InstanceGroupServiceServer is the server API for InstanceGroupService service.
type InstanceGroupServiceServer interface {
	// Returns the specified InstanceGroup resource.
	//
	// To get the list of available InstanceGroup resources, make a [List] request.
	Get(context.Context, *GetInstanceGroupRequest) (*InstanceGroup, error)
	// Retrieves the list of InstanceGroup resources in the specified folder.
	List(context.Context, *ListInstanceGroupsRequest) (*ListInstanceGroupsResponse, error)
	// Creates an instance group in the specified folder.
	// This method starts an operation that can be cancelled by another operation.
	Create(context.Context, *CreateInstanceGroupRequest) (*operation.Operation, error)
	// Creates an instance group in the specified folder from a YAML file.
	// This method starts an operation that can be cancelled by another operation.
	CreateFromYaml(context.Context, *CreateInstanceGroupFromYamlRequest) (*operation.Operation, error)
	// Updates the specified instance group.
	// This method starts an operation that can be cancelled by another operation.
	Update(context.Context, *UpdateInstanceGroupRequest) (*operation.Operation, error)
	// Updates the specified instance group from a YAML file.
	// This method starts an operation that can be cancelled by another operation.
	UpdateFromYaml(context.Context, *UpdateInstanceGroupFromYamlRequest) (*operation.Operation, error)
	// Deletes the specified instance group.
	Delete(context.Context, *DeleteInstanceGroupRequest) (*operation.Operation, error)
	// Lists instances for the specified instance group.
	ListInstances(context.Context, *ListInstanceGroupInstancesRequest) (*ListInstanceGroupInstancesResponse, error)
	// Lists operations for the specified instance group.
	ListOperations(context.Context, *ListInstanceGroupOperationsRequest) (*ListInstanceGroupOperationsResponse, error)
	// Lists logs for the specified instance group.
	ListLogRecords(context.Context, *ListInstanceGroupLogRecordsRequest) (*ListInstanceGroupLogRecordsResponse, error)
}

// UnimplementedInstanceGroupServiceServer can be embedded to have forward compatible implementations.
type UnimplementedInstanceGroupServiceServer struct {
}

func (*UnimplementedInstanceGroupServiceServer) Get(ctx context.Context, req *GetInstanceGroupRequest) (*InstanceGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedInstanceGroupServiceServer) List(ctx context.Context, req *ListInstanceGroupsRequest) (*ListInstanceGroupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedInstanceGroupServiceServer) Create(ctx context.Context, req *CreateInstanceGroupRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (*UnimplementedInstanceGroupServiceServer) CreateFromYaml(ctx context.Context, req *CreateInstanceGroupFromYamlRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFromYaml not implemented")
}
func (*UnimplementedInstanceGroupServiceServer) Update(ctx context.Context, req *UpdateInstanceGroupRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (*UnimplementedInstanceGroupServiceServer) UpdateFromYaml(ctx context.Context, req *UpdateInstanceGroupFromYamlRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFromYaml not implemented")
}
func (*UnimplementedInstanceGroupServiceServer) Delete(ctx context.Context, req *DeleteInstanceGroupRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedInstanceGroupServiceServer) ListInstances(ctx context.Context, req *ListInstanceGroupInstancesRequest) (*ListInstanceGroupInstancesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstances not implemented")
}
func (*UnimplementedInstanceGroupServiceServer) ListOperations(ctx context.Context, req *ListInstanceGroupOperationsRequest) (*ListInstanceGroupOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOperations not implemented")
}
func (*UnimplementedInstanceGroupServiceServer) ListLogRecords(ctx context.Context, req *ListInstanceGroupLogRecordsRequest) (*ListInstanceGroupLogRecordsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLogRecords not implemented")
}

func RegisterInstanceGroupServiceServer(s *grpc.Server, srv InstanceGroupServiceServer) {
	s.RegisterService(&_InstanceGroupService_serviceDesc, srv)
}

func _InstanceGroupService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.instancegroup.InstanceGroupService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupServiceServer).Get(ctx, req.(*GetInstanceGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstanceGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.instancegroup.InstanceGroupService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupServiceServer).List(ctx, req.(*ListInstanceGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstanceGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.instancegroup.InstanceGroupService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupServiceServer).Create(ctx, req.(*CreateInstanceGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupService_CreateFromYaml_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstanceGroupFromYamlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupServiceServer).CreateFromYaml(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.instancegroup.InstanceGroupService/CreateFromYaml",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupServiceServer).CreateFromYaml(ctx, req.(*CreateInstanceGroupFromYamlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInstanceGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.instancegroup.InstanceGroupService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupServiceServer).Update(ctx, req.(*UpdateInstanceGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupService_UpdateFromYaml_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInstanceGroupFromYamlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupServiceServer).UpdateFromYaml(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.instancegroup.InstanceGroupService/UpdateFromYaml",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupServiceServer).UpdateFromYaml(ctx, req.(*UpdateInstanceGroupFromYamlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.instancegroup.InstanceGroupService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupServiceServer).Delete(ctx, req.(*DeleteInstanceGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupService_ListInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstanceGroupInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupServiceServer).ListInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.instancegroup.InstanceGroupService/ListInstances",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupServiceServer).ListInstances(ctx, req.(*ListInstanceGroupInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstanceGroupOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.instancegroup.InstanceGroupService/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupServiceServer).ListOperations(ctx, req.(*ListInstanceGroupOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupService_ListLogRecords_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstanceGroupLogRecordsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupServiceServer).ListLogRecords(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.instancegroup.InstanceGroupService/ListLogRecords",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupServiceServer).ListLogRecords(ctx, req.(*ListInstanceGroupLogRecordsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _InstanceGroupService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.compute.v1.instancegroup.InstanceGroupService",
	HandlerType: (*InstanceGroupServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _InstanceGroupService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _InstanceGroupService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _InstanceGroupService_Create_Handler,
		},
		{
			MethodName: "CreateFromYaml",
			Handler:    _InstanceGroupService_CreateFromYaml_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _InstanceGroupService_Update_Handler,
		},
		{
			MethodName: "UpdateFromYaml",
			Handler:    _InstanceGroupService_UpdateFromYaml_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _InstanceGroupService_Delete_Handler,
		},
		{
			MethodName: "ListInstances",
			Handler:    _InstanceGroupService_ListInstances_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _InstanceGroupService_ListOperations_Handler,
		},
		{
			MethodName: "ListLogRecords",
			Handler:    _InstanceGroupService_ListLogRecords_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/compute/v1/instancegroup/instance_group_service.proto",
}
