// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/mdb/postgresql/v1/database_service.proto

package postgresql

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type GetDatabaseRequest struct {
	// ID of the PostgreSQL cluster that the database belongs to.
	// To get the cluster ID use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the PostgreSQL Database resource to return.
	// To get the name of the database use a [DatabaseService.List] request.
	DatabaseName         string   `protobuf:"bytes,2,opt,name=database_name,json=databaseName,proto3" json:"database_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetDatabaseRequest) Reset()         { *m = GetDatabaseRequest{} }
func (m *GetDatabaseRequest) String() string { return proto.CompactTextString(m) }
func (*GetDatabaseRequest) ProtoMessage()    {}
func (*GetDatabaseRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7019892c5f2c1745, []int{0}
}

func (m *GetDatabaseRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDatabaseRequest.Unmarshal(m, b)
}
func (m *GetDatabaseRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDatabaseRequest.Marshal(b, m, deterministic)
}
func (m *GetDatabaseRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDatabaseRequest.Merge(m, src)
}
func (m *GetDatabaseRequest) XXX_Size() int {
	return xxx_messageInfo_GetDatabaseRequest.Size(m)
}
func (m *GetDatabaseRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDatabaseRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDatabaseRequest proto.InternalMessageInfo

func (m *GetDatabaseRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *GetDatabaseRequest) GetDatabaseName() string {
	if m != nil {
		return m.DatabaseName
	}
	return ""
}

type ListDatabasesRequest struct {
	// ID of the PostgreSQL cluster to list databases in.
	// To get the cluster ID use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	PageSize  int64  `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, Set [page_token] to the [ListDatabasesResponse.next_page_token]
	// returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDatabasesRequest) Reset()         { *m = ListDatabasesRequest{} }
func (m *ListDatabasesRequest) String() string { return proto.CompactTextString(m) }
func (*ListDatabasesRequest) ProtoMessage()    {}
func (*ListDatabasesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7019892c5f2c1745, []int{1}
}

func (m *ListDatabasesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDatabasesRequest.Unmarshal(m, b)
}
func (m *ListDatabasesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDatabasesRequest.Marshal(b, m, deterministic)
}
func (m *ListDatabasesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDatabasesRequest.Merge(m, src)
}
func (m *ListDatabasesRequest) XXX_Size() int {
	return xxx_messageInfo_ListDatabasesRequest.Size(m)
}
func (m *ListDatabasesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDatabasesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDatabasesRequest proto.InternalMessageInfo

func (m *ListDatabasesRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListDatabasesRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListDatabasesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListDatabasesResponse struct {
	// List of PostgreSQL Database resources.
	Databases []*Database `protobuf:"bytes,1,rep,name=databases,proto3" json:"databases,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListDatabasesRequest.page_size], use the [next_page_token] as the value
	// for the [ListDatabasesRequest.page_token] parameter in the next list request. Each subsequent
	// list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDatabasesResponse) Reset()         { *m = ListDatabasesResponse{} }
func (m *ListDatabasesResponse) String() string { return proto.CompactTextString(m) }
func (*ListDatabasesResponse) ProtoMessage()    {}
func (*ListDatabasesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7019892c5f2c1745, []int{2}
}

func (m *ListDatabasesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDatabasesResponse.Unmarshal(m, b)
}
func (m *ListDatabasesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDatabasesResponse.Marshal(b, m, deterministic)
}
func (m *ListDatabasesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDatabasesResponse.Merge(m, src)
}
func (m *ListDatabasesResponse) XXX_Size() int {
	return xxx_messageInfo_ListDatabasesResponse.Size(m)
}
func (m *ListDatabasesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDatabasesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDatabasesResponse proto.InternalMessageInfo

func (m *ListDatabasesResponse) GetDatabases() []*Database {
	if m != nil {
		return m.Databases
	}
	return nil
}

func (m *ListDatabasesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateDatabaseRequest struct {
	// ID of the PostgreSQL cluster to create a database in.
	// To get the cluster ID use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Configuration of the database to create.
	DatabaseSpec         *DatabaseSpec `protobuf:"bytes,2,opt,name=database_spec,json=databaseSpec,proto3" json:"database_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *CreateDatabaseRequest) Reset()         { *m = CreateDatabaseRequest{} }
func (m *CreateDatabaseRequest) String() string { return proto.CompactTextString(m) }
func (*CreateDatabaseRequest) ProtoMessage()    {}
func (*CreateDatabaseRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7019892c5f2c1745, []int{3}
}

func (m *CreateDatabaseRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateDatabaseRequest.Unmarshal(m, b)
}
func (m *CreateDatabaseRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateDatabaseRequest.Marshal(b, m, deterministic)
}
func (m *CreateDatabaseRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateDatabaseRequest.Merge(m, src)
}
func (m *CreateDatabaseRequest) XXX_Size() int {
	return xxx_messageInfo_CreateDatabaseRequest.Size(m)
}
func (m *CreateDatabaseRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateDatabaseRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateDatabaseRequest proto.InternalMessageInfo

func (m *CreateDatabaseRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CreateDatabaseRequest) GetDatabaseSpec() *DatabaseSpec {
	if m != nil {
		return m.DatabaseSpec
	}
	return nil
}

type CreateDatabaseMetadata struct {
	// ID of the PostgreSQL cluster where a database is being created.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the PostgreSQL database that is being created.
	DatabaseName         string   `protobuf:"bytes,2,opt,name=database_name,json=databaseName,proto3" json:"database_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateDatabaseMetadata) Reset()         { *m = CreateDatabaseMetadata{} }
func (m *CreateDatabaseMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateDatabaseMetadata) ProtoMessage()    {}
func (*CreateDatabaseMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_7019892c5f2c1745, []int{4}
}

func (m *CreateDatabaseMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateDatabaseMetadata.Unmarshal(m, b)
}
func (m *CreateDatabaseMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateDatabaseMetadata.Marshal(b, m, deterministic)
}
func (m *CreateDatabaseMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateDatabaseMetadata.Merge(m, src)
}
func (m *CreateDatabaseMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateDatabaseMetadata.Size(m)
}
func (m *CreateDatabaseMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateDatabaseMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateDatabaseMetadata proto.InternalMessageInfo

func (m *CreateDatabaseMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CreateDatabaseMetadata) GetDatabaseName() string {
	if m != nil {
		return m.DatabaseName
	}
	return ""
}

type UpdateDatabaseRequest struct {
	// ID of the PostgreSQL cluster to update a database in.
	// To get the cluster ID use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the database to update.
	// To get the name of the database use a [DatabaseService.List] request.
	DatabaseName string `protobuf:"bytes,2,opt,name=database_name,json=databaseName,proto3" json:"database_name,omitempty"`
	// Field mask that specifies which fields of the Database resource should be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// PostgreSQL extensions that should be enabled for the database.
	//
	// If the field is sent, the list of enabled extensions is rewritten entirely.
	// Therefore, to disable an active extension you should simply send the list omitting this extension.
	Extensions           []*Extension `protobuf:"bytes,4,rep,name=extensions,proto3" json:"extensions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *UpdateDatabaseRequest) Reset()         { *m = UpdateDatabaseRequest{} }
func (m *UpdateDatabaseRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateDatabaseRequest) ProtoMessage()    {}
func (*UpdateDatabaseRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7019892c5f2c1745, []int{5}
}

func (m *UpdateDatabaseRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateDatabaseRequest.Unmarshal(m, b)
}
func (m *UpdateDatabaseRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateDatabaseRequest.Marshal(b, m, deterministic)
}
func (m *UpdateDatabaseRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateDatabaseRequest.Merge(m, src)
}
func (m *UpdateDatabaseRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateDatabaseRequest.Size(m)
}
func (m *UpdateDatabaseRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateDatabaseRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateDatabaseRequest proto.InternalMessageInfo

func (m *UpdateDatabaseRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *UpdateDatabaseRequest) GetDatabaseName() string {
	if m != nil {
		return m.DatabaseName
	}
	return ""
}

func (m *UpdateDatabaseRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateDatabaseRequest) GetExtensions() []*Extension {
	if m != nil {
		return m.Extensions
	}
	return nil
}

type UpdateDatabaseMetadata struct {
	// ID of the PostgreSQL cluster where a database is being updated.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the PostgreSQL database that is being updated.
	DatabaseName         string   `protobuf:"bytes,2,opt,name=database_name,json=databaseName,proto3" json:"database_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateDatabaseMetadata) Reset()         { *m = UpdateDatabaseMetadata{} }
func (m *UpdateDatabaseMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateDatabaseMetadata) ProtoMessage()    {}
func (*UpdateDatabaseMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_7019892c5f2c1745, []int{6}
}

func (m *UpdateDatabaseMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateDatabaseMetadata.Unmarshal(m, b)
}
func (m *UpdateDatabaseMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateDatabaseMetadata.Marshal(b, m, deterministic)
}
func (m *UpdateDatabaseMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateDatabaseMetadata.Merge(m, src)
}
func (m *UpdateDatabaseMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateDatabaseMetadata.Size(m)
}
func (m *UpdateDatabaseMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateDatabaseMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateDatabaseMetadata proto.InternalMessageInfo

func (m *UpdateDatabaseMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *UpdateDatabaseMetadata) GetDatabaseName() string {
	if m != nil {
		return m.DatabaseName
	}
	return ""
}

type DeleteDatabaseRequest struct {
	// ID of the PostgreSQL cluster to delete a database in.
	// To get the cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the database to delete.
	// To get the name of the database, use a [DatabaseService.List] request.
	DatabaseName         string   `protobuf:"bytes,2,opt,name=database_name,json=databaseName,proto3" json:"database_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteDatabaseRequest) Reset()         { *m = DeleteDatabaseRequest{} }
func (m *DeleteDatabaseRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteDatabaseRequest) ProtoMessage()    {}
func (*DeleteDatabaseRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7019892c5f2c1745, []int{7}
}

func (m *DeleteDatabaseRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteDatabaseRequest.Unmarshal(m, b)
}
func (m *DeleteDatabaseRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteDatabaseRequest.Marshal(b, m, deterministic)
}
func (m *DeleteDatabaseRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteDatabaseRequest.Merge(m, src)
}
func (m *DeleteDatabaseRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteDatabaseRequest.Size(m)
}
func (m *DeleteDatabaseRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteDatabaseRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteDatabaseRequest proto.InternalMessageInfo

func (m *DeleteDatabaseRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *DeleteDatabaseRequest) GetDatabaseName() string {
	if m != nil {
		return m.DatabaseName
	}
	return ""
}

type DeleteDatabaseMetadata struct {
	// ID of the PostgreSQL cluster where a database is being deleted.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the PostgreSQL database that is being deleted.
	DatabaseName         string   `protobuf:"bytes,2,opt,name=database_name,json=databaseName,proto3" json:"database_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteDatabaseMetadata) Reset()         { *m = DeleteDatabaseMetadata{} }
func (m *DeleteDatabaseMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteDatabaseMetadata) ProtoMessage()    {}
func (*DeleteDatabaseMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_7019892c5f2c1745, []int{8}
}

func (m *DeleteDatabaseMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteDatabaseMetadata.Unmarshal(m, b)
}
func (m *DeleteDatabaseMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteDatabaseMetadata.Marshal(b, m, deterministic)
}
func (m *DeleteDatabaseMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteDatabaseMetadata.Merge(m, src)
}
func (m *DeleteDatabaseMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteDatabaseMetadata.Size(m)
}
func (m *DeleteDatabaseMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteDatabaseMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteDatabaseMetadata proto.InternalMessageInfo

func (m *DeleteDatabaseMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *DeleteDatabaseMetadata) GetDatabaseName() string {
	if m != nil {
		return m.DatabaseName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetDatabaseRequest)(nil), "yandex.cloud.mdb.postgresql.v1.GetDatabaseRequest")
	proto.RegisterType((*ListDatabasesRequest)(nil), "yandex.cloud.mdb.postgresql.v1.ListDatabasesRequest")
	proto.RegisterType((*ListDatabasesResponse)(nil), "yandex.cloud.mdb.postgresql.v1.ListDatabasesResponse")
	proto.RegisterType((*CreateDatabaseRequest)(nil), "yandex.cloud.mdb.postgresql.v1.CreateDatabaseRequest")
	proto.RegisterType((*CreateDatabaseMetadata)(nil), "yandex.cloud.mdb.postgresql.v1.CreateDatabaseMetadata")
	proto.RegisterType((*UpdateDatabaseRequest)(nil), "yandex.cloud.mdb.postgresql.v1.UpdateDatabaseRequest")
	proto.RegisterType((*UpdateDatabaseMetadata)(nil), "yandex.cloud.mdb.postgresql.v1.UpdateDatabaseMetadata")
	proto.RegisterType((*DeleteDatabaseRequest)(nil), "yandex.cloud.mdb.postgresql.v1.DeleteDatabaseRequest")
	proto.RegisterType((*DeleteDatabaseMetadata)(nil), "yandex.cloud.mdb.postgresql.v1.DeleteDatabaseMetadata")
}

func init() {
	proto.RegisterFile("yandex/cloud/mdb/postgresql/v1/database_service.proto", fileDescriptor_7019892c5f2c1745)
}

var fileDescriptor_7019892c5f2c1745 = []byte{
	// 817 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x56, 0xcd, 0x4f, 0x1b, 0x47,
	0x14, 0xd7, 0x62, 0xd7, 0xc2, 0x63, 0x28, 0xd2, 0xa8, 0xae, 0x2c, 0xab, 0x20, 0xba, 0x95, 0xa8,
	0xeb, 0x76, 0x77, 0xbd, 0xa6, 0xa0, 0xb6, 0x40, 0xa5, 0x9a, 0xaf, 0xa2, 0x04, 0x88, 0x96, 0x44,
	0x91, 0x48, 0x22, 0x6b, 0xec, 0x1d, 0x36, 0x2b, 0xbc, 0x1f, 0x78, 0xc6, 0x0e, 0x1f, 0xe2, 0x90,
	0x1c, 0x12, 0x85, 0x5b, 0x12, 0x29, 0xb7, 0xfc, 0x13, 0xe4, 0x8f, 0x00, 0x29, 0x37, 0x72, 0xcc,
	0x35, 0x8a, 0x72, 0xce, 0x31, 0xa7, 0x68, 0x66, 0xfc, 0xb5, 0x60, 0xb0, 0x03, 0x3e, 0xe4, 0x66,
	0xcf, 0x7b, 0xbf, 0xb7, 0xbf, 0xdf, 0x9b, 0xf7, 0x7e, 0xbb, 0x60, 0x62, 0x07, 0xb9, 0x26, 0xde,
	0xd6, 0x8a, 0x25, 0xaf, 0x62, 0x6a, 0x8e, 0x59, 0xd0, 0x7c, 0x8f, 0x50, 0xab, 0x8c, 0xc9, 0x56,
	0x49, 0xab, 0xea, 0x9a, 0x89, 0x28, 0x2a, 0x20, 0x82, 0xf3, 0x04, 0x97, 0xab, 0x76, 0x11, 0xab,
	0x7e, 0xd9, 0xa3, 0x1e, 0x1c, 0x11, 0x30, 0x95, 0xc3, 0x54, 0xc7, 0x2c, 0xa8, 0x4d, 0x98, 0x5a,
	0xd5, 0x93, 0x3f, 0x59, 0x9e, 0x67, 0x95, 0xb0, 0x86, 0x7c, 0x5b, 0x43, 0xae, 0xeb, 0x51, 0x44,
	0x6d, 0xcf, 0x25, 0x02, 0x9d, 0x1c, 0xad, 0x45, 0xf9, 0xbf, 0x42, 0x65, 0x43, 0xdb, 0xb0, 0x71,
	0xc9, 0xcc, 0x3b, 0x88, 0x6c, 0xd6, 0x33, 0x02, 0xb4, 0x58, 0x15, 0xcf, 0xc7, 0x65, 0x5e, 0xa4,
	0x96, 0x31, 0x1c, 0xc8, 0xa8, 0xa2, 0x92, 0x6d, 0xb6, 0x86, 0xc7, 0x02, 0xe1, 0x06, 0xf8, 0x4c,
	0x19, 0xa5, 0x4b, 0xfd, 0x22, 0x5d, 0x7e, 0x2c, 0x01, 0xb8, 0x88, 0xe9, 0x5c, 0xed, 0xd4, 0xc0,
	0x5b, 0x15, 0x4c, 0x28, 0xfc, 0x1d, 0x80, 0x62, 0xa9, 0x42, 0x28, 0x2e, 0xe7, 0x6d, 0x33, 0x21,
	0x8d, 0x4a, 0xa9, 0x68, 0x6e, 0xe0, 0xe3, 0x91, 0x2e, 0x1d, 0x1c, 0xeb, 0xe1, 0xe9, 0x99, 0x89,
	0x8c, 0x11, 0xad, 0xc5, 0x97, 0x4c, 0x38, 0x0b, 0x06, 0x1b, 0x5d, 0x75, 0x91, 0x83, 0x13, 0x7d,
	0x3c, 0x7f, 0x84, 0xe5, 0x7f, 0x3a, 0xd2, 0xbf, 0xbf, 0x83, 0x94, 0xdd, 0xff, 0x94, 0xf5, 0x8c,
	0xf2, 0x77, 0x5e, 0xb9, 0x97, 0x16, 0x15, 0x26, 0xc7, 0x8d, 0x81, 0x3a, 0x68, 0x05, 0x39, 0x58,
	0x7e, 0x29, 0x81, 0x1f, 0xae, 0xdb, 0xa4, 0xc1, 0x84, 0x5c, 0x8a, 0xca, 0xaf, 0x20, 0xea, 0x23,
	0x0b, 0xe7, 0x89, 0xbd, 0x2b, 0x68, 0x84, 0x72, 0xe0, 0xf3, 0x91, 0x1e, 0x99, 0x9e, 0xd1, 0x33,
	0x99, 0x8c, 0xd1, 0xcf, 0x82, 0x6b, 0xf6, 0x2e, 0x86, 0x29, 0x00, 0x78, 0x22, 0xf5, 0x36, 0xb1,
	0x9b, 0x08, 0xf1, 0xaa, 0xd1, 0x83, 0x63, 0xfd, 0x3b, 0x9e, 0x69, 0xf0, 0x2a, 0x37, 0x59, 0x4c,
	0x7e, 0x22, 0x81, 0xf8, 0x29, 0x62, 0xc4, 0xf7, 0x5c, 0x82, 0xe1, 0x02, 0x88, 0xd6, 0x25, 0x90,
	0x84, 0x34, 0x1a, 0x4a, 0xc5, 0xb2, 0x29, 0xf5, 0xe2, 0x39, 0x52, 0x1b, 0x8d, 0x6e, 0x42, 0xe1,
	0x18, 0x18, 0x72, 0xf1, 0x36, 0xcd, 0xb7, 0x10, 0xe2, 0x1d, 0x34, 0x06, 0xd9, 0xf1, 0x8d, 0x06,
	0x93, 0x57, 0x12, 0x88, 0xcf, 0x96, 0x31, 0xa2, 0xf8, 0x4a, 0xd7, 0x75, 0xbb, 0xe5, 0xba, 0x88,
	0x8f, 0x8b, 0xfc, 0x61, 0xb1, 0xec, 0x1f, 0xdd, 0x52, 0x5f, 0xf3, 0x71, 0x31, 0x17, 0x66, 0xd5,
	0x9b, 0x57, 0xc8, 0xce, 0xe4, 0xbb, 0xe0, 0xc7, 0x20, 0xbd, 0x65, 0x4c, 0x11, 0xcb, 0x80, 0xc3,
	0x67, 0xf9, 0xb5, 0x32, 0xfa, 0xa5, 0xed, 0x00, 0x9d, 0x1a, 0x90, 0x67, 0x7d, 0x20, 0x7e, 0xcb,
	0x37, 0xaf, 0xaa, 0xbe, 0x17, 0xc3, 0x0a, 0xa7, 0x40, 0xac, 0xc2, 0xa9, 0xf0, 0x15, 0xe7, 0xe3,
	0x13, 0xcb, 0x26, 0x55, 0xe1, 0x02, 0x6a, 0xdd, 0x05, 0xd4, 0x05, 0xe6, 0x02, 0xcb, 0x88, 0x6c,
	0x1a, 0x40, 0xa4, 0xb3, 0xdf, 0x70, 0x09, 0x00, 0xbc, 0x4d, 0xb1, 0x4b, 0x98, 0x81, 0x24, 0xc2,
	0x7c, 0x6e, 0x7e, 0xeb, 0xd4, 0xfc, 0xf9, 0x3a, 0xc2, 0x68, 0x01, 0xb3, 0x8e, 0x07, 0x5b, 0xd2,
	0xd3, 0x8e, 0x3f, 0x95, 0x40, 0x7c, 0x0e, 0x97, 0xf0, 0x37, 0xd0, 0x71, 0xa6, 0x34, 0x48, 0xa5,
	0x97, 0x4a, 0xb3, 0xcf, 0xfb, 0xc1, 0x50, 0x63, 0xbc, 0xc5, 0x7b, 0x01, 0xbe, 0x96, 0x40, 0x68,
	0x11, 0x53, 0x98, 0xed, 0x74, 0x35, 0x67, 0xed, 0x33, 0xd9, 0xb5, 0x0d, 0xc8, 0x2b, 0x8f, 0xde,
	0xbe, 0x7f, 0xd1, 0xf7, 0x3f, 0x5c, 0xd0, 0x1c, 0xe4, 0x22, 0x0b, 0x9b, 0x4a, 0xd0, 0xae, 0x6b,
	0x42, 0x88, 0xb6, 0xd7, 0x14, 0xb9, 0xdf, 0x30, 0x71, 0xa2, 0xed, 0x05, 0xc4, 0xed, 0x33, 0xd6,
	0x61, 0xe6, 0x56, 0xf0, 0xcf, 0x4e, 0x14, 0xda, 0x99, 0x6d, 0x72, 0xe2, 0x2b, 0x51, 0xc2, 0x09,
	0xe5, 0x7f, 0xb9, 0x8a, 0xbf, 0xe0, 0xe4, 0xe5, 0x54, 0xc0, 0x37, 0x12, 0x88, 0x08, 0xeb, 0x80,
	0x1d, 0x19, 0xb4, 0x75, 0xc0, 0xe4, 0xcf, 0x41, 0x58, 0xf3, 0xad, 0xb8, 0x5a, 0xff, 0x25, 0x5b,
	0x87, 0x27, 0x69, 0xf9, 0x5c, 0x8b, 0xea, 0xaf, 0x9f, 0x70, 0x29, 0x53, 0xf2, 0x25, 0xa5, 0xfc,
	0x23, 0xa5, 0xe1, 0x3b, 0x09, 0x44, 0xc4, 0x5a, 0x76, 0x56, 0xd3, 0xd6, 0xd1, 0xba, 0x51, 0xf3,
	0x40, 0xa8, 0x39, 0x67, 0xfd, 0x83, 0x6a, 0xae, 0x65, 0x7b, 0x34, 0x5e, 0x4c, 0xdd, 0x07, 0x09,
	0x44, 0xc4, 0x2a, 0x76, 0x56, 0xd7, 0xd6, 0x3d, 0xba, 0x51, 0xf7, 0x50, 0x3a, 0x3c, 0x49, 0x6b,
	0xe7, 0xee, 0x7c, 0xfc, 0xb4, 0xd3, 0xce, 0x3b, 0x3e, 0xdd, 0x11, 0xab, 0x94, 0xee, 0x91, 0xd6,
	0xdc, 0xea, 0xfa, 0xb2, 0x65, 0xd3, 0xfb, 0x95, 0x82, 0x5a, 0xf4, 0x1c, 0x4d, 0x50, 0x56, 0xc4,
	0x67, 0x95, 0xe5, 0x29, 0x16, 0x76, 0xf9, 0xd3, 0xb5, 0x8b, 0xbf, 0xb7, 0xa6, 0x9a, 0xff, 0x0a,
	0x11, 0x0e, 0x18, 0xff, 0x12, 0x00, 0x00, 0xff, 0xff, 0x6b, 0x1c, 0xc6, 0xf8, 0xa3, 0x0a, 0x00,
	0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// DatabaseServiceClient is the client API for DatabaseService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DatabaseServiceClient interface {
	// Returns the specified PostgreSQL Database resource.
	//
	// To get the list of available PostgreSQL Database resources, make a [List] request.
	Get(ctx context.Context, in *GetDatabaseRequest, opts ...grpc.CallOption) (*Database, error)
	// Retrieves the list of PostgreSQL Database resources in the specified cluster.
	List(ctx context.Context, in *ListDatabasesRequest, opts ...grpc.CallOption) (*ListDatabasesResponse, error)
	// Creates a new PostgreSQL database in the specified cluster.
	Create(ctx context.Context, in *CreateDatabaseRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified PostgreSQL database.
	Update(ctx context.Context, in *UpdateDatabaseRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified PostgreSQL database.
	Delete(ctx context.Context, in *DeleteDatabaseRequest, opts ...grpc.CallOption) (*operation.Operation, error)
}

type databaseServiceClient struct {
	cc *grpc.ClientConn
}

func NewDatabaseServiceClient(cc *grpc.ClientConn) DatabaseServiceClient {
	return &databaseServiceClient{cc}
}

func (c *databaseServiceClient) Get(ctx context.Context, in *GetDatabaseRequest, opts ...grpc.CallOption) (*Database, error) {
	out := new(Database)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.DatabaseService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseServiceClient) List(ctx context.Context, in *ListDatabasesRequest, opts ...grpc.CallOption) (*ListDatabasesResponse, error) {
	out := new(ListDatabasesResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.DatabaseService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseServiceClient) Create(ctx context.Context, in *CreateDatabaseRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.DatabaseService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseServiceClient) Update(ctx context.Context, in *UpdateDatabaseRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.DatabaseService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseServiceClient) Delete(ctx context.Context, in *DeleteDatabaseRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.DatabaseService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DatabaseServiceServer is the server API for DatabaseService service.
type DatabaseServiceServer interface {
	// Returns the specified PostgreSQL Database resource.
	//
	// To get the list of available PostgreSQL Database resources, make a [List] request.
	Get(context.Context, *GetDatabaseRequest) (*Database, error)
	// Retrieves the list of PostgreSQL Database resources in the specified cluster.
	List(context.Context, *ListDatabasesRequest) (*ListDatabasesResponse, error)
	// Creates a new PostgreSQL database in the specified cluster.
	Create(context.Context, *CreateDatabaseRequest) (*operation.Operation, error)
	// Updates the specified PostgreSQL database.
	Update(context.Context, *UpdateDatabaseRequest) (*operation.Operation, error)
	// Deletes the specified PostgreSQL database.
	Delete(context.Context, *DeleteDatabaseRequest) (*operation.Operation, error)
}

// UnimplementedDatabaseServiceServer can be embedded to have forward compatible implementations.
type UnimplementedDatabaseServiceServer struct {
}

func (*UnimplementedDatabaseServiceServer) Get(ctx context.Context, req *GetDatabaseRequest) (*Database, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedDatabaseServiceServer) List(ctx context.Context, req *ListDatabasesRequest) (*ListDatabasesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedDatabaseServiceServer) Create(ctx context.Context, req *CreateDatabaseRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (*UnimplementedDatabaseServiceServer) Update(ctx context.Context, req *UpdateDatabaseRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (*UnimplementedDatabaseServiceServer) Delete(ctx context.Context, req *DeleteDatabaseRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}

func RegisterDatabaseServiceServer(s *grpc.Server, srv DatabaseServiceServer) {
	s.RegisterService(&_DatabaseService_serviceDesc, srv)
}

func _DatabaseService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.DatabaseService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseServiceServer).Get(ctx, req.(*GetDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDatabasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.DatabaseService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseServiceServer).List(ctx, req.(*ListDatabasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.DatabaseService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseServiceServer).Create(ctx, req.(*CreateDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.DatabaseService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseServiceServer).Update(ctx, req.(*UpdateDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.DatabaseService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseServiceServer).Delete(ctx, req.(*DeleteDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DatabaseService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.mdb.postgresql.v1.DatabaseService",
	HandlerType: (*DatabaseServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _DatabaseService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _DatabaseService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _DatabaseService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _DatabaseService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _DatabaseService_Delete_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/mdb/postgresql/v1/database_service.proto",
}
