# Releases

## Update Git

The most important part of the release process is updating the embedded Git package. This can be done using this one-liner:

```sh
yarn update-embedded-git
```

This script:

- retrieves the latest `dugite-native` release from the GitHub API
- gets the checksums embedded in the release
- generates the `script/embedded-git.json` payload to be used at install time

### Note

If you don't want the latest dugite-native release for some reason, you can edit the release URL in `script/update-embedded-git.js` to point to a different GitHub release URL.

```js
const url = `https://api.github.com/repos/desktop/dugite-native/releases/23544533`
```

## Release/Publishing

Before running the commands in 'Publishing to NPM',
create a new release branch of the form `releases/x.x.x`

After running commands in 'Publishing to NPM', the release branch should be pushed. Now, you need to get it reviewed and merged.

After that, don't forget publish the release on the repo.

- Go to https://github.com/desktop/dugite/releases
- Click click `Draft a New Release`
- Fill in form
- Hit `Publish release`

## Publishing to NPM

Releases are done to NPM, and are currently limited to the core team.

```sh
# to ensure everything is up-to-date
yarn

yarn build

# if you have not run `yarn build` before, a couple of you cloning auth test will fail.
yarn test

# you might need to do a different sort of version bump here
npm version minor

# this will also run the test suite and fail if any errors found
# this will also run `git push --follow-tags` at the end
# remember to `npm login`
npm publish
```
