import React from 'react';
import {SignOutButton} from './SignOut'
import { Link } from 'react-router-dom';
import * as routes from '../constants/routes';

const Navigation = ({loggedInUser}) =>
  <div>
      {
          loggedInUser
          ? <NavigationAuth />
          : <NavigationNonAuth />
      }
  </div>

    const NavigationAuth = () =>
        <ul>
            <li><Link to={routes.LANDING}>Landing</Link></li>
            <li><Link to={routes.HOME}>Home</Link></li>
            <li><Link to={routes.ACCOUNT}>Account</Link></li>
            <li><SignOutButton /></li>
        </ul>

    const NavigationNonAuth = () =>
        <ul>
            <li><Link to={routes.LANDING}>Landing</Link></li>
            <li><Link to={routes.SIGN_IN}>Sign In</Link></li>
        </ul>
export default Navigation;
