// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/ai/vision/v1/vision_service.proto

package vision

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type Feature_Type int32

const (
	Feature_TYPE_UNSPECIFIED Feature_Type = 0
	// Text detection (OCR) feature.
	Feature_TEXT_DETECTION Feature_Type = 1
	// Classification feature.
	Feature_CLASSIFICATION Feature_Type = 2
	// Face detection feature.
	Feature_FACE_DETECTION Feature_Type = 3
	// Image copy search.
	Feature_IMAGE_COPY_SEARCH Feature_Type = 4
)

var Feature_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "TEXT_DETECTION",
	2: "CLASSIFICATION",
	3: "FACE_DETECTION",
	4: "IMAGE_COPY_SEARCH",
}

var Feature_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED":  0,
	"TEXT_DETECTION":    1,
	"CLASSIFICATION":    2,
	"FACE_DETECTION":    3,
	"IMAGE_COPY_SEARCH": 4,
}

func (x Feature_Type) String() string {
	return proto.EnumName(Feature_Type_name, int32(x))
}

func (Feature_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_6d06b6b52fd28cc5, []int{2, 0}
}

type BatchAnalyzeRequest struct {
	// A list of specifications. Each specification contains the file to analyze and features to use for analysis.
	//
	// Restrictions:
	// * Supported file formats: JPEG, PNG.
	// * Maximum file size: 1 MB.
	// * Image size should not exceed 20M pixels (length x width).
	AnalyzeSpecs []*AnalyzeSpec `protobuf:"bytes,1,rep,name=analyze_specs,json=analyzeSpecs,proto3" json:"analyze_specs,omitempty"`
	// ID of the folder to which you have access.
	// Required for authorization with a user account (see [yandex.cloud.iam.v1.UserAccount] resource).
	// Don't specify this field if you make the request on behalf of a service account.
	FolderId             string   `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BatchAnalyzeRequest) Reset()         { *m = BatchAnalyzeRequest{} }
func (m *BatchAnalyzeRequest) String() string { return proto.CompactTextString(m) }
func (*BatchAnalyzeRequest) ProtoMessage()    {}
func (*BatchAnalyzeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d06b6b52fd28cc5, []int{0}
}

func (m *BatchAnalyzeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchAnalyzeRequest.Unmarshal(m, b)
}
func (m *BatchAnalyzeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchAnalyzeRequest.Marshal(b, m, deterministic)
}
func (m *BatchAnalyzeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchAnalyzeRequest.Merge(m, src)
}
func (m *BatchAnalyzeRequest) XXX_Size() int {
	return xxx_messageInfo_BatchAnalyzeRequest.Size(m)
}
func (m *BatchAnalyzeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchAnalyzeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchAnalyzeRequest proto.InternalMessageInfo

func (m *BatchAnalyzeRequest) GetAnalyzeSpecs() []*AnalyzeSpec {
	if m != nil {
		return m.AnalyzeSpecs
	}
	return nil
}

func (m *BatchAnalyzeRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

type AnalyzeSpec struct {
	// Types that are valid to be assigned to Source:
	//	*AnalyzeSpec_Content
	//	*AnalyzeSpec_Signature
	Source isAnalyzeSpec_Source `protobuf_oneof:"source"`
	// Requested features to use for analysis.
	//
	// Max count of requested features for one file is 8.
	Features []*Feature `protobuf:"bytes,3,rep,name=features,proto3" json:"features,omitempty"`
	// [MIME type](https://en.wikipedia.org/wiki/Media_type) of content (for example, `` application/pdf ``).
	MimeType             string   `protobuf:"bytes,4,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AnalyzeSpec) Reset()         { *m = AnalyzeSpec{} }
func (m *AnalyzeSpec) String() string { return proto.CompactTextString(m) }
func (*AnalyzeSpec) ProtoMessage()    {}
func (*AnalyzeSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d06b6b52fd28cc5, []int{1}
}

func (m *AnalyzeSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnalyzeSpec.Unmarshal(m, b)
}
func (m *AnalyzeSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnalyzeSpec.Marshal(b, m, deterministic)
}
func (m *AnalyzeSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnalyzeSpec.Merge(m, src)
}
func (m *AnalyzeSpec) XXX_Size() int {
	return xxx_messageInfo_AnalyzeSpec.Size(m)
}
func (m *AnalyzeSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_AnalyzeSpec.DiscardUnknown(m)
}

var xxx_messageInfo_AnalyzeSpec proto.InternalMessageInfo

type isAnalyzeSpec_Source interface {
	isAnalyzeSpec_Source()
}

type AnalyzeSpec_Content struct {
	Content []byte `protobuf:"bytes,1,opt,name=content,proto3,oneof"`
}

type AnalyzeSpec_Signature struct {
	Signature string `protobuf:"bytes,5,opt,name=signature,proto3,oneof"`
}

func (*AnalyzeSpec_Content) isAnalyzeSpec_Source() {}

func (*AnalyzeSpec_Signature) isAnalyzeSpec_Source() {}

func (m *AnalyzeSpec) GetSource() isAnalyzeSpec_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *AnalyzeSpec) GetContent() []byte {
	if x, ok := m.GetSource().(*AnalyzeSpec_Content); ok {
		return x.Content
	}
	return nil
}

func (m *AnalyzeSpec) GetSignature() string {
	if x, ok := m.GetSource().(*AnalyzeSpec_Signature); ok {
		return x.Signature
	}
	return ""
}

func (m *AnalyzeSpec) GetFeatures() []*Feature {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *AnalyzeSpec) GetMimeType() string {
	if m != nil {
		return m.MimeType
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AnalyzeSpec) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AnalyzeSpec_Content)(nil),
		(*AnalyzeSpec_Signature)(nil),
	}
}

type Feature struct {
	// Type of requested feature.
	Type Feature_Type `protobuf:"varint,1,opt,name=type,proto3,enum=yandex.cloud.ai.vision.v1.Feature_Type" json:"type,omitempty"`
	// Types that are valid to be assigned to Config:
	//	*Feature_ClassificationConfig
	//	*Feature_TextDetectionConfig
	Config               isFeature_Config `protobuf_oneof:"config"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Feature) Reset()         { *m = Feature{} }
func (m *Feature) String() string { return proto.CompactTextString(m) }
func (*Feature) ProtoMessage()    {}
func (*Feature) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d06b6b52fd28cc5, []int{2}
}

func (m *Feature) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Feature.Unmarshal(m, b)
}
func (m *Feature) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Feature.Marshal(b, m, deterministic)
}
func (m *Feature) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Feature.Merge(m, src)
}
func (m *Feature) XXX_Size() int {
	return xxx_messageInfo_Feature.Size(m)
}
func (m *Feature) XXX_DiscardUnknown() {
	xxx_messageInfo_Feature.DiscardUnknown(m)
}

var xxx_messageInfo_Feature proto.InternalMessageInfo

func (m *Feature) GetType() Feature_Type {
	if m != nil {
		return m.Type
	}
	return Feature_TYPE_UNSPECIFIED
}

type isFeature_Config interface {
	isFeature_Config()
}

type Feature_ClassificationConfig struct {
	ClassificationConfig *FeatureClassificationConfig `protobuf:"bytes,2,opt,name=classification_config,json=classificationConfig,proto3,oneof"`
}

type Feature_TextDetectionConfig struct {
	TextDetectionConfig *FeatureTextDetectionConfig `protobuf:"bytes,3,opt,name=text_detection_config,json=textDetectionConfig,proto3,oneof"`
}

func (*Feature_ClassificationConfig) isFeature_Config() {}

func (*Feature_TextDetectionConfig) isFeature_Config() {}

func (m *Feature) GetConfig() isFeature_Config {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Feature) GetClassificationConfig() *FeatureClassificationConfig {
	if x, ok := m.GetConfig().(*Feature_ClassificationConfig); ok {
		return x.ClassificationConfig
	}
	return nil
}

func (m *Feature) GetTextDetectionConfig() *FeatureTextDetectionConfig {
	if x, ok := m.GetConfig().(*Feature_TextDetectionConfig); ok {
		return x.TextDetectionConfig
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Feature) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Feature_ClassificationConfig)(nil),
		(*Feature_TextDetectionConfig)(nil),
	}
}

type FeatureClassificationConfig struct {
	// Model to use for image classification.
	Model                string   `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FeatureClassificationConfig) Reset()         { *m = FeatureClassificationConfig{} }
func (m *FeatureClassificationConfig) String() string { return proto.CompactTextString(m) }
func (*FeatureClassificationConfig) ProtoMessage()    {}
func (*FeatureClassificationConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d06b6b52fd28cc5, []int{3}
}

func (m *FeatureClassificationConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FeatureClassificationConfig.Unmarshal(m, b)
}
func (m *FeatureClassificationConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FeatureClassificationConfig.Marshal(b, m, deterministic)
}
func (m *FeatureClassificationConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FeatureClassificationConfig.Merge(m, src)
}
func (m *FeatureClassificationConfig) XXX_Size() int {
	return xxx_messageInfo_FeatureClassificationConfig.Size(m)
}
func (m *FeatureClassificationConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_FeatureClassificationConfig.DiscardUnknown(m)
}

var xxx_messageInfo_FeatureClassificationConfig proto.InternalMessageInfo

func (m *FeatureClassificationConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

type FeatureTextDetectionConfig struct {
	// List of the languages to recognize text.
	// Specified in [ISO 639-1](https://en.wikipedia.org/wiki/ISO_639-1) format (for example, `` ru ``).
	LanguageCodes []string `protobuf:"bytes,1,rep,name=language_codes,json=languageCodes,proto3" json:"language_codes,omitempty"`
	// Model to use for text detection.
	// Possible values:
	// * page (default) — this model is suitable for detecting multiple text entries in an image.
	// * line — this model is suitable for cropped images with one line of text.
	Model                string   `protobuf:"bytes,2,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FeatureTextDetectionConfig) Reset()         { *m = FeatureTextDetectionConfig{} }
func (m *FeatureTextDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*FeatureTextDetectionConfig) ProtoMessage()    {}
func (*FeatureTextDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d06b6b52fd28cc5, []int{4}
}

func (m *FeatureTextDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FeatureTextDetectionConfig.Unmarshal(m, b)
}
func (m *FeatureTextDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FeatureTextDetectionConfig.Marshal(b, m, deterministic)
}
func (m *FeatureTextDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FeatureTextDetectionConfig.Merge(m, src)
}
func (m *FeatureTextDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_FeatureTextDetectionConfig.Size(m)
}
func (m *FeatureTextDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_FeatureTextDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_FeatureTextDetectionConfig proto.InternalMessageInfo

func (m *FeatureTextDetectionConfig) GetLanguageCodes() []string {
	if m != nil {
		return m.LanguageCodes
	}
	return nil
}

func (m *FeatureTextDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

type BatchAnalyzeResponse struct {
	// Request results.
	// Results have the same order as specifications in the request.
	Results              []*AnalyzeResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *BatchAnalyzeResponse) Reset()         { *m = BatchAnalyzeResponse{} }
func (m *BatchAnalyzeResponse) String() string { return proto.CompactTextString(m) }
func (*BatchAnalyzeResponse) ProtoMessage()    {}
func (*BatchAnalyzeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d06b6b52fd28cc5, []int{5}
}

func (m *BatchAnalyzeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchAnalyzeResponse.Unmarshal(m, b)
}
func (m *BatchAnalyzeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchAnalyzeResponse.Marshal(b, m, deterministic)
}
func (m *BatchAnalyzeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchAnalyzeResponse.Merge(m, src)
}
func (m *BatchAnalyzeResponse) XXX_Size() int {
	return xxx_messageInfo_BatchAnalyzeResponse.Size(m)
}
func (m *BatchAnalyzeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchAnalyzeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BatchAnalyzeResponse proto.InternalMessageInfo

func (m *BatchAnalyzeResponse) GetResults() []*AnalyzeResult {
	if m != nil {
		return m.Results
	}
	return nil
}

type AnalyzeResult struct {
	// Results for each requested feature.
	// Feature results have the same order as in the request.
	Results []*FeatureResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	// Return error in case of error with file processing.
	Error                *status.Status `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *AnalyzeResult) Reset()         { *m = AnalyzeResult{} }
func (m *AnalyzeResult) String() string { return proto.CompactTextString(m) }
func (*AnalyzeResult) ProtoMessage()    {}
func (*AnalyzeResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d06b6b52fd28cc5, []int{6}
}

func (m *AnalyzeResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnalyzeResult.Unmarshal(m, b)
}
func (m *AnalyzeResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnalyzeResult.Marshal(b, m, deterministic)
}
func (m *AnalyzeResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnalyzeResult.Merge(m, src)
}
func (m *AnalyzeResult) XXX_Size() int {
	return xxx_messageInfo_AnalyzeResult.Size(m)
}
func (m *AnalyzeResult) XXX_DiscardUnknown() {
	xxx_messageInfo_AnalyzeResult.DiscardUnknown(m)
}

var xxx_messageInfo_AnalyzeResult proto.InternalMessageInfo

func (m *AnalyzeResult) GetResults() []*FeatureResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *AnalyzeResult) GetError() *status.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

type FeatureResult struct {
	// Types that are valid to be assigned to Feature:
	//	*FeatureResult_TextDetection
	//	*FeatureResult_Classification
	//	*FeatureResult_FaceDetection
	//	*FeatureResult_ImageCopySearch
	Feature isFeatureResult_Feature `protobuf_oneof:"feature"`
	// Return error in case of error during the specified feature processing.
	Error                *status.Status `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *FeatureResult) Reset()         { *m = FeatureResult{} }
func (m *FeatureResult) String() string { return proto.CompactTextString(m) }
func (*FeatureResult) ProtoMessage()    {}
func (*FeatureResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d06b6b52fd28cc5, []int{7}
}

func (m *FeatureResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FeatureResult.Unmarshal(m, b)
}
func (m *FeatureResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FeatureResult.Marshal(b, m, deterministic)
}
func (m *FeatureResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FeatureResult.Merge(m, src)
}
func (m *FeatureResult) XXX_Size() int {
	return xxx_messageInfo_FeatureResult.Size(m)
}
func (m *FeatureResult) XXX_DiscardUnknown() {
	xxx_messageInfo_FeatureResult.DiscardUnknown(m)
}

var xxx_messageInfo_FeatureResult proto.InternalMessageInfo

type isFeatureResult_Feature interface {
	isFeatureResult_Feature()
}

type FeatureResult_TextDetection struct {
	TextDetection *TextAnnotation `protobuf:"bytes,2,opt,name=text_detection,json=textDetection,proto3,oneof"`
}

type FeatureResult_Classification struct {
	Classification *ClassAnnotation `protobuf:"bytes,3,opt,name=classification,proto3,oneof"`
}

type FeatureResult_FaceDetection struct {
	FaceDetection *FaceAnnotation `protobuf:"bytes,4,opt,name=face_detection,json=faceDetection,proto3,oneof"`
}

type FeatureResult_ImageCopySearch struct {
	ImageCopySearch *ImageCopySearchAnnotation `protobuf:"bytes,5,opt,name=image_copy_search,json=imageCopySearch,proto3,oneof"`
}

func (*FeatureResult_TextDetection) isFeatureResult_Feature() {}

func (*FeatureResult_Classification) isFeatureResult_Feature() {}

func (*FeatureResult_FaceDetection) isFeatureResult_Feature() {}

func (*FeatureResult_ImageCopySearch) isFeatureResult_Feature() {}

func (m *FeatureResult) GetFeature() isFeatureResult_Feature {
	if m != nil {
		return m.Feature
	}
	return nil
}

func (m *FeatureResult) GetTextDetection() *TextAnnotation {
	if x, ok := m.GetFeature().(*FeatureResult_TextDetection); ok {
		return x.TextDetection
	}
	return nil
}

func (m *FeatureResult) GetClassification() *ClassAnnotation {
	if x, ok := m.GetFeature().(*FeatureResult_Classification); ok {
		return x.Classification
	}
	return nil
}

func (m *FeatureResult) GetFaceDetection() *FaceAnnotation {
	if x, ok := m.GetFeature().(*FeatureResult_FaceDetection); ok {
		return x.FaceDetection
	}
	return nil
}

func (m *FeatureResult) GetImageCopySearch() *ImageCopySearchAnnotation {
	if x, ok := m.GetFeature().(*FeatureResult_ImageCopySearch); ok {
		return x.ImageCopySearch
	}
	return nil
}

func (m *FeatureResult) GetError() *status.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*FeatureResult) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*FeatureResult_TextDetection)(nil),
		(*FeatureResult_Classification)(nil),
		(*FeatureResult_FaceDetection)(nil),
		(*FeatureResult_ImageCopySearch)(nil),
	}
}

func init() {
	proto.RegisterEnum("yandex.cloud.ai.vision.v1.Feature_Type", Feature_Type_name, Feature_Type_value)
	proto.RegisterType((*BatchAnalyzeRequest)(nil), "yandex.cloud.ai.vision.v1.BatchAnalyzeRequest")
	proto.RegisterType((*AnalyzeSpec)(nil), "yandex.cloud.ai.vision.v1.AnalyzeSpec")
	proto.RegisterType((*Feature)(nil), "yandex.cloud.ai.vision.v1.Feature")
	proto.RegisterType((*FeatureClassificationConfig)(nil), "yandex.cloud.ai.vision.v1.FeatureClassificationConfig")
	proto.RegisterType((*FeatureTextDetectionConfig)(nil), "yandex.cloud.ai.vision.v1.FeatureTextDetectionConfig")
	proto.RegisterType((*BatchAnalyzeResponse)(nil), "yandex.cloud.ai.vision.v1.BatchAnalyzeResponse")
	proto.RegisterType((*AnalyzeResult)(nil), "yandex.cloud.ai.vision.v1.AnalyzeResult")
	proto.RegisterType((*FeatureResult)(nil), "yandex.cloud.ai.vision.v1.FeatureResult")
}

func init() {
	proto.RegisterFile("yandex/cloud/ai/vision/v1/vision_service.proto", fileDescriptor_6d06b6b52fd28cc5)
}

var fileDescriptor_6d06b6b52fd28cc5 = []byte{
	// 941 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x55, 0x41, 0x6f, 0xe2, 0xc6,
	0x17, 0xc7, 0x81, 0x04, 0x78, 0x04, 0xfe, 0xd9, 0xd9, 0x44, 0xcb, 0x3f, 0xdd, 0x6d, 0x23, 0x4b,
	0xdd, 0xd2, 0x54, 0xb1, 0x63, 0x12, 0xd2, 0xa8, 0x0b, 0x95, 0xb0, 0x03, 0x0b, 0x52, 0xbb, 0x1b,
	0x19, 0x5a, 0x75, 0xf7, 0x62, 0x4d, 0x86, 0x81, 0x58, 0x05, 0xdb, 0xb5, 0x07, 0x14, 0x2a, 0xf5,
	0xb2, 0x47, 0x8e, 0xdd, 0x73, 0x8f, 0xed, 0xe7, 0x68, 0x6f, 0xdc, 0xfb, 0x15, 0x2a, 0xf5, 0x6b,
	0x54, 0x1e, 0x9b, 0x04, 0x27, 0x1b, 0x93, 0xdb, 0xe8, 0xbd, 0xdf, 0xfb, 0xbd, 0xf7, 0x66, 0x7e,
	0x6f, 0x1e, 0x48, 0x53, 0x6c, 0xf5, 0xe8, 0x95, 0x4c, 0x86, 0xf6, 0xb8, 0x27, 0x63, 0x53, 0x9e,
	0x98, 0x9e, 0x69, 0x5b, 0xf2, 0x44, 0x09, 0x4f, 0x86, 0x47, 0xdd, 0x89, 0x49, 0xa8, 0xe4, 0xb8,
	0x36, 0xb3, 0xd1, 0xff, 0x03, 0xbc, 0xc4, 0xf1, 0x12, 0x36, 0xa5, 0x00, 0x25, 0x4d, 0x94, 0xdd,
	0x18, 0x2a, 0x46, 0xaf, 0x98, 0xd1, 0xa3, 0x8c, 0x12, 0xe6, 0x83, 0x39, 0x55, 0x1c, 0x9e, 0x0c,
	0xb1, 0xe7, 0x99, 0x7d, 0x93, 0xe0, 0x87, 0xe1, 0xfb, 0x98, 0xd0, 0x3b, 0xfc, 0xca, 0xfd, 0x78,
	0x73, 0x84, 0x07, 0xd4, 0x20, 0xb6, 0x33, 0x35, 0x3c, 0x8a, 0x5d, 0x72, 0x19, 0x86, 0x3c, 0x8b,
	0x84, 0x4c, 0xf0, 0xd0, 0xec, 0x2d, 0x57, 0xf0, 0x74, 0x60, 0xdb, 0x83, 0x21, 0x95, 0xb1, 0x63,
	0xca, 0xd8, 0xb2, 0x6c, 0xc6, 0x9d, 0x5e, 0xe8, 0x7d, 0x12, 0x7a, 0x5d, 0x87, 0xc8, 0x1e, 0xc3,
	0x6c, 0x1c, 0x3a, 0xc4, 0x5f, 0x05, 0x78, 0xac, 0x62, 0x46, 0x2e, 0xeb, 0x16, 0x1e, 0x4e, 0x7f,
	0xa6, 0x3a, 0xfd, 0x69, 0x4c, 0x3d, 0x86, 0xba, 0x90, 0xc7, 0x81, 0xc5, 0xf0, 0x1c, 0x4a, 0xbc,
	0xa2, 0xb0, 0x97, 0x2c, 0xe5, 0xca, 0xcf, 0xa5, 0x7b, 0xef, 0x58, 0x0a, 0x19, 0x3a, 0x0e, 0x25,
	0x6a, 0xfa, 0xdd, 0x5c, 0x49, 0x2a, 0x07, 0xa7, 0xfa, 0x26, 0xbe, 0xb1, 0x7a, 0xe8, 0x53, 0xc8,
	0xf6, 0xed, 0x61, 0x8f, 0xba, 0x86, 0xd9, 0x2b, 0xae, 0xed, 0x09, 0xa5, 0xac, 0x9a, 0x99, 0xcd,
	0x95, 0x54, 0xb5, 0x56, 0x39, 0xd4, 0x33, 0x81, 0xab, 0xdd, 0x13, 0xff, 0x15, 0x20, 0xb7, 0xc4,
	0x86, 0xf6, 0x21, 0x4d, 0x6c, 0x8b, 0x51, 0x8b, 0x15, 0x85, 0x3d, 0xa1, 0xb4, 0xa9, 0x16, 0x66,
	0x73, 0x05, 0xaa, 0x35, 0xe5, 0xf0, 0xf8, 0xb4, 0xf2, 0xe5, 0xc9, 0x61, 0x2b, 0xa1, 0x2f, 0x00,
	0xe8, 0x0b, 0xc8, 0x7a, 0xe6, 0xc0, 0xc2, 0x6c, 0xec, 0xd2, 0xe2, 0x3a, 0x4f, 0x91, 0x9b, 0xcd,
	0x95, 0x74, 0xb5, 0xa6, 0x9c, 0x1c, 0x9d, 0x1e, 0xb7, 0x12, 0xfa, 0x8d, 0x1f, 0xbd, 0x84, 0x4c,
	0x9f, 0xf2, 0xa3, 0x57, 0x4c, 0xf2, 0x06, 0xc5, 0x98, 0x06, 0x9b, 0x01, 0xf4, 0xa6, 0xb9, 0xeb,
	0x60, 0xf4, 0x1c, 0xb2, 0x23, 0x73, 0x44, 0x0d, 0x36, 0x75, 0x68, 0x31, 0xc5, 0xb3, 0x66, 0x67,
	0x73, 0x65, 0xbd, 0x5a, 0x2b, 0x57, 0x2a, 0x7a, 0xc6, 0xf7, 0x75, 0xa7, 0x0e, 0x55, 0x0b, 0xb0,
	0xe1, 0xd9, 0x63, 0x97, 0x50, 0x94, 0xfa, 0xf3, 0x2f, 0x45, 0x10, 0x7f, 0x4b, 0x42, 0x3a, 0xa4,
	0x45, 0x2f, 0x20, 0xc5, 0xc3, 0xfd, 0x16, 0x0b, 0xe5, 0xcf, 0x56, 0x17, 0x22, 0xf9, 0x94, 0x3a,
	0x0f, 0x42, 0x23, 0xd8, 0x89, 0x0a, 0xd3, 0x20, 0xb6, 0xd5, 0x37, 0x07, 0xfc, 0x96, 0x73, 0xe5,
	0x93, 0xd5, 0x6c, 0x5a, 0x24, 0x5c, 0xe3, 0xd1, 0xad, 0x84, 0xbe, 0x4d, 0x3e, 0x60, 0x47, 0x3f,
	0xc2, 0x4e, 0x74, 0x6e, 0x16, 0xe9, 0x92, 0x3c, 0x5d, 0x65, 0x75, 0xba, 0x2e, 0xbd, 0x62, 0x67,
	0x8b, 0xe8, 0xeb, 0x6c, 0x8f, 0xd9, 0x5d, 0xb3, 0x68, 0x43, 0xca, 0xef, 0x14, 0x6d, 0xc3, 0x56,
	0xf7, 0xcd, 0x79, 0xc3, 0xf8, 0xee, 0x55, 0xe7, 0xbc, 0xa1, 0xb5, 0x9b, 0xed, 0xc6, 0xd9, 0x56,
	0x02, 0x21, 0x28, 0x74, 0x1b, 0x3f, 0x74, 0x8d, 0xb3, 0x46, 0xb7, 0xa1, 0x75, 0xdb, 0xaf, 0x5f,
	0x6d, 0x09, 0xbe, 0x4d, 0xfb, 0xa6, 0xde, 0xe9, 0xb4, 0x9b, 0x6d, 0xad, 0xce, 0x6d, 0x6b, 0xbe,
	0xad, 0x59, 0xd7, 0x1a, 0x4b, 0xb8, 0x24, 0xda, 0x81, 0x47, 0xed, 0x6f, 0xeb, 0x2f, 0x1b, 0x86,
	0xf6, 0xfa, 0xfc, 0x8d, 0xd1, 0x69, 0xd4, 0x75, 0xad, 0xb5, 0x95, 0x52, 0x33, 0xb0, 0x11, 0xb4,
	0x23, 0x7e, 0x0d, 0x1f, 0xc5, 0x5c, 0x0f, 0xfa, 0x04, 0xd6, 0x47, 0x76, 0x8f, 0x0e, 0xf9, 0x9b,
	0x2d, 0x3d, 0xf9, 0x89, 0x1e, 0xd8, 0x45, 0x0f, 0x76, 0xef, 0xef, 0x17, 0x55, 0xa0, 0x30, 0xc4,
	0xd6, 0x60, 0x1c, 0x0c, 0x7c, 0x8f, 0x06, 0x53, 0x96, 0x55, 0x0b, 0xa1, 0xc0, 0x66, 0x73, 0x25,
	0x59, 0xad, 0x1d, 0xe9, 0xf9, 0x05, 0x4a, 0xf3, 0x41, 0xe8, 0xe3, 0x45, 0xd6, 0xdb, 0x13, 0x14,
	0x26, 0x7d, 0x0b, 0xdb, 0xd1, 0x91, 0xf6, 0x1c, 0xdb, 0xf2, 0x28, 0x52, 0x21, 0xed, 0x52, 0x6f,
	0x3c, 0x64, 0x8b, 0x69, 0x2e, 0xad, 0x9e, 0x66, 0x9d, 0x07, 0xe8, 0x8b, 0x40, 0xf1, 0x17, 0xc8,
	0x47, 0x3c, 0xcb, 0xa4, 0x6b, 0x2b, 0x49, 0xc3, 0xbb, 0xb8, 0x45, 0x8a, 0x4a, 0xb0, 0x4e, 0x5d,
	0xd7, 0x76, 0xf9, 0x35, 0xe6, 0xca, 0x48, 0x0a, 0x7e, 0x2b, 0xc9, 0x75, 0x88, 0xd4, 0xe1, 0xbf,
	0x95, 0x1e, 0x00, 0xc4, 0x3f, 0x92, 0x90, 0x8f, 0x90, 0x20, 0x1d, 0x0a, 0x51, 0x25, 0x86, 0x8a,
	0xff, 0x3c, 0xa6, 0x0c, 0xff, 0x2d, 0xea, 0xd7, 0x7f, 0x64, 0x2b, 0xa1, 0xe7, 0x23, 0xb2, 0x43,
	0x5d, 0x28, 0x44, 0x55, 0x1f, 0xca, 0x7a, 0x3f, 0x86, 0x93, 0xeb, 0x23, 0x42, 0x7a, 0x8b, 0xc3,
	0xaf, 0x34, 0xba, 0x0b, 0xf8, 0x47, 0x11, 0x5f, 0x69, 0x13, 0x13, 0x1a, 0xad, 0xd4, 0xa7, 0xb8,
	0xa9, 0xf4, 0x02, 0x1e, 0xdd, 0xd9, 0x17, 0xfc, 0xd7, 0xcb, 0x95, 0x8f, 0x63, 0x68, 0xdb, 0x23,
	0x2e, 0x26, 0x67, 0xda, 0xe1, 0x11, 0x91, 0x0c, 0xff, 0x33, 0xa3, 0xce, 0x87, 0xbf, 0x8e, 0x9a,
	0x85, 0x74, 0xf8, 0x23, 0x96, 0x7f, 0x17, 0x20, 0xff, 0x3d, 0xcf, 0xd7, 0x09, 0x76, 0x34, 0x7a,
	0x2f, 0xc0, 0xe6, 0xb2, 0x2c, 0x91, 0x14, 0x53, 0xe0, 0x07, 0x56, 0xd2, 0xae, 0xfc, 0x60, 0x7c,
	0xa0, 0x77, 0x51, 0x7c, 0xf7, 0xf7, 0x3f, 0xef, 0xd7, 0x9e, 0x8a, 0x4f, 0x96, 0xb6, 0xeb, 0xc5,
	0x12, 0xf0, 0x2b, 0x61, 0x5f, 0xa5, 0xf0, 0x2c, 0xca, 0xea, 0x98, 0x11, 0xe6, 0xb7, 0x67, 0x03,
	0x93, 0x5d, 0x8e, 0x2f, 0x24, 0x62, 0x8f, 0xe4, 0x00, 0x79, 0x10, 0x6c, 0xe0, 0x81, 0x7d, 0x30,
	0xa0, 0x16, 0xdf, 0xa2, 0xf2, 0xbd, 0xdb, 0xfc, 0x45, 0x70, 0xba, 0xd8, 0xe0, 0xb8, 0xa3, 0xff,
	0x02, 0x00, 0x00, 0xff, 0xff, 0x1a, 0xe9, 0xa0, 0xc9, 0xd3, 0x08, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// VisionServiceClient is the client API for VisionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type VisionServiceClient interface {
	// Analyzes a batch of images and returns results with annotations.
	BatchAnalyze(ctx context.Context, in *BatchAnalyzeRequest, opts ...grpc.CallOption) (*BatchAnalyzeResponse, error)
}

type visionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewVisionServiceClient(cc grpc.ClientConnInterface) VisionServiceClient {
	return &visionServiceClient{cc}
}

func (c *visionServiceClient) BatchAnalyze(ctx context.Context, in *BatchAnalyzeRequest, opts ...grpc.CallOption) (*BatchAnalyzeResponse, error) {
	out := new(BatchAnalyzeResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.ai.vision.v1.VisionService/BatchAnalyze", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VisionServiceServer is the server API for VisionService service.
type VisionServiceServer interface {
	// Analyzes a batch of images and returns results with annotations.
	BatchAnalyze(context.Context, *BatchAnalyzeRequest) (*BatchAnalyzeResponse, error)
}

// UnimplementedVisionServiceServer can be embedded to have forward compatible implementations.
type UnimplementedVisionServiceServer struct {
}

func (*UnimplementedVisionServiceServer) BatchAnalyze(ctx context.Context, req *BatchAnalyzeRequest) (*BatchAnalyzeResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BatchAnalyze not implemented")
}

func RegisterVisionServiceServer(s *grpc.Server, srv VisionServiceServer) {
	s.RegisterService(&_VisionService_serviceDesc, srv)
}

func _VisionService_BatchAnalyze_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchAnalyzeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisionServiceServer).BatchAnalyze(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.ai.vision.v1.VisionService/BatchAnalyze",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisionServiceServer).BatchAnalyze(ctx, req.(*BatchAnalyzeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VisionService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.ai.vision.v1.VisionService",
	HandlerType: (*VisionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "BatchAnalyze",
			Handler:    _VisionService_BatchAnalyze_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/ai/vision/v1/vision_service.proto",
}
