// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/compute/v1/instancegroup/instance_group.proto

package instancegroup

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type IpVersion int32

const (
	IpVersion_IP_VERSION_UNSPECIFIED IpVersion = 0
	// IPv4 address, for example 192.168.0.0.
	IpVersion_IPV4 IpVersion = 1
	// IPv6 address, not available yet.
	IpVersion_IPV6 IpVersion = 2
)

var IpVersion_name = map[int32]string{
	0: "IP_VERSION_UNSPECIFIED",
	1: "IPV4",
	2: "IPV6",
}

var IpVersion_value = map[string]int32{
	"IP_VERSION_UNSPECIFIED": 0,
	"IPV4":                   1,
	"IPV6":                   2,
}

func (x IpVersion) String() string {
	return proto.EnumName(IpVersion_name, int32(x))
}

func (IpVersion) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{0}
}

type InstanceGroup_Status int32

const (
	InstanceGroup_STATUS_UNSPECIFIED InstanceGroup_Status = 0
	// Instance group is being started and will become active soon.
	InstanceGroup_STARTING InstanceGroup_Status = 1
	// Instance group is active.
	// In this state the group manages its instances and monitors their health,
	// creating, deleting, stopping, updating and starting instances as needed.
	// To stop the instance group, call [yandex.cloud.compute.v1.instancegroup.InstanceGroupService.Stop].
	InstanceGroup_ACTIVE InstanceGroup_Status = 2
	// Instance group is being stopped.
	// Group's instances stop receiving traffic from the load balancer (if any) and are then stopped.
	InstanceGroup_STOPPING InstanceGroup_Status = 3
	// Instance group is stopped.
	// In this state the group cannot be updated and does not react to any changes made to its instances.
	// To start the instance group, call [yandex.cloud.compute.v1.instancegroup.InstanceGroupService.Start].
	InstanceGroup_STOPPED InstanceGroup_Status = 4
	// Instance group is being deleted.
	InstanceGroup_DELETING InstanceGroup_Status = 5
)

var InstanceGroup_Status_name = map[int32]string{
	0: "STATUS_UNSPECIFIED",
	1: "STARTING",
	2: "ACTIVE",
	3: "STOPPING",
	4: "STOPPED",
	5: "DELETING",
}

var InstanceGroup_Status_value = map[string]int32{
	"STATUS_UNSPECIFIED": 0,
	"STARTING":           1,
	"ACTIVE":             2,
	"STOPPING":           3,
	"STOPPED":            4,
	"DELETING":           5,
}

func (x InstanceGroup_Status) String() string {
	return proto.EnumName(InstanceGroup_Status_name, int32(x))
}

func (InstanceGroup_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{0, 0}
}

type ScalePolicy_CustomRule_RuleType int32

const (
	ScalePolicy_CustomRule_RULE_TYPE_UNSPECIFIED ScalePolicy_CustomRule_RuleType = 0
	// This type means that the metric applies to one instance.
	// First, Instance Groups calculates the average metric value for each instance,
	// then averages the values for instances in one availability zone.
	// This type of metric must have the `instance_id` label.
	ScalePolicy_CustomRule_UTILIZATION ScalePolicy_CustomRule_RuleType = 1
	// This type means that the metric applies to instances in one availability zone.
	// This type of metric must have the `zone_id` label.
	ScalePolicy_CustomRule_WORKLOAD ScalePolicy_CustomRule_RuleType = 2
)

var ScalePolicy_CustomRule_RuleType_name = map[int32]string{
	0: "RULE_TYPE_UNSPECIFIED",
	1: "UTILIZATION",
	2: "WORKLOAD",
}

var ScalePolicy_CustomRule_RuleType_value = map[string]int32{
	"RULE_TYPE_UNSPECIFIED": 0,
	"UTILIZATION":           1,
	"WORKLOAD":              2,
}

func (x ScalePolicy_CustomRule_RuleType) String() string {
	return proto.EnumName(ScalePolicy_CustomRule_RuleType_name, int32(x))
}

func (ScalePolicy_CustomRule_RuleType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{4, 2, 0}
}

type ScalePolicy_CustomRule_MetricType int32

const (
	ScalePolicy_CustomRule_METRIC_TYPE_UNSPECIFIED ScalePolicy_CustomRule_MetricType = 0
	// This type is used for metrics that show the metric value at a certain point in time,
	// such as requests per second to the server on an instance.
	//
	// Instance Groups calculates the average metric value for the period
	// specified in the [AutoScale.measurement_duration] field.
	ScalePolicy_CustomRule_GAUGE ScalePolicy_CustomRule_MetricType = 1
	// This type is used for metrics that monotonically increase over time,
	// such as the total number of requests to the server on an instance.
	//
	// Instance Groups calculates the average value increase for the period
	// specified in the [AutoScale.measurement_duration] field.
	ScalePolicy_CustomRule_COUNTER ScalePolicy_CustomRule_MetricType = 2
)

var ScalePolicy_CustomRule_MetricType_name = map[int32]string{
	0: "METRIC_TYPE_UNSPECIFIED",
	1: "GAUGE",
	2: "COUNTER",
}

var ScalePolicy_CustomRule_MetricType_value = map[string]int32{
	"METRIC_TYPE_UNSPECIFIED": 0,
	"GAUGE":                   1,
	"COUNTER":                 2,
}

func (x ScalePolicy_CustomRule_MetricType) String() string {
	return proto.EnumName(ScalePolicy_CustomRule_MetricType_name, int32(x))
}

func (ScalePolicy_CustomRule_MetricType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{4, 2, 1}
}

type AttachedDiskSpec_Mode int32

const (
	AttachedDiskSpec_MODE_UNSPECIFIED AttachedDiskSpec_Mode = 0
	// Read-only access.
	AttachedDiskSpec_READ_ONLY AttachedDiskSpec_Mode = 1
	// Read/Write access.
	AttachedDiskSpec_READ_WRITE AttachedDiskSpec_Mode = 2
)

var AttachedDiskSpec_Mode_name = map[int32]string{
	0: "MODE_UNSPECIFIED",
	1: "READ_ONLY",
	2: "READ_WRITE",
}

var AttachedDiskSpec_Mode_value = map[string]int32{
	"MODE_UNSPECIFIED": 0,
	"READ_ONLY":        1,
	"READ_WRITE":       2,
}

func (x AttachedDiskSpec_Mode) String() string {
	return proto.EnumName(AttachedDiskSpec_Mode_name, int32(x))
}

func (AttachedDiskSpec_Mode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{9, 0}
}

type NetworkSettings_Type int32

const (
	NetworkSettings_TYPE_UNSPECIFIED     NetworkSettings_Type = 0
	NetworkSettings_STANDARD             NetworkSettings_Type = 1
	NetworkSettings_SOFTWARE_ACCELERATED NetworkSettings_Type = 2
	NetworkSettings_HARDWARE_ACCELERATED NetworkSettings_Type = 3
)

var NetworkSettings_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "STANDARD",
	2: "SOFTWARE_ACCELERATED",
	3: "HARDWARE_ACCELERATED",
}

var NetworkSettings_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED":     0,
	"STANDARD":             1,
	"SOFTWARE_ACCELERATED": 2,
	"HARDWARE_ACCELERATED": 3,
}

func (x NetworkSettings_Type) String() string {
	return proto.EnumName(NetworkSettings_Type_name, int32(x))
}

func (NetworkSettings_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{14, 0}
}

type ManagedInstance_Status int32

const (
	ManagedInstance_STATUS_UNSPECIFIED ManagedInstance_Status = 0
	// Instance is being created.
	ManagedInstance_CREATING_INSTANCE ManagedInstance_Status = 11
	// Instance is being updated.
	ManagedInstance_UPDATING_INSTANCE ManagedInstance_Status = 12
	// Instance is being deleted.
	ManagedInstance_DELETING_INSTANCE ManagedInstance_Status = 13
	// Instance is being started.
	ManagedInstance_STARTING_INSTANCE ManagedInstance_Status = 14
	// Instance is being stopped.
	ManagedInstance_STOPPING_INSTANCE ManagedInstance_Status = 15
	// Instance has been created successfully, but startup duration has not elapsed yet.
	ManagedInstance_AWAITING_STARTUP_DURATION ManagedInstance_Status = 16
	// Instance has been created successfully and startup duration has elapsed, but health checks have not passed yet and the managed instance is not ready to receive traffic.
	ManagedInstance_CHECKING_HEALTH ManagedInstance_Status = 17
	// Instance Groups is initiating health checks and routing traffic to the instances.
	ManagedInstance_OPENING_TRAFFIC ManagedInstance_Status = 18
	// Instance is now receiving traffic, but warmup duration has not elapsed yet.
	ManagedInstance_AWAITING_WARMUP_DURATION ManagedInstance_Status = 19
	// Instance Groups has initiated the process of stopping routing traffic to the instances.
	ManagedInstance_CLOSING_TRAFFIC ManagedInstance_Status = 20
	// Instance is running normally and its attributes match the current InstanceTemplate.
	ManagedInstance_RUNNING_ACTUAL ManagedInstance_Status = 21
	// Instance is running normally, but its attributes do not match the current InstanceTemplate.
	// It will be updated, recreated or deleted shortly.
	ManagedInstance_RUNNING_OUTDATED ManagedInstance_Status = 22
	// Instance was stopped.
	ManagedInstance_STOPPED ManagedInstance_Status = 23
	// Instance was deleted.
	ManagedInstance_DELETED ManagedInstance_Status = 24
)

var ManagedInstance_Status_name = map[int32]string{
	0:  "STATUS_UNSPECIFIED",
	11: "CREATING_INSTANCE",
	12: "UPDATING_INSTANCE",
	13: "DELETING_INSTANCE",
	14: "STARTING_INSTANCE",
	15: "STOPPING_INSTANCE",
	16: "AWAITING_STARTUP_DURATION",
	17: "CHECKING_HEALTH",
	18: "OPENING_TRAFFIC",
	19: "AWAITING_WARMUP_DURATION",
	20: "CLOSING_TRAFFIC",
	21: "RUNNING_ACTUAL",
	22: "RUNNING_OUTDATED",
	23: "STOPPED",
	24: "DELETED",
}

var ManagedInstance_Status_value = map[string]int32{
	"STATUS_UNSPECIFIED":        0,
	"CREATING_INSTANCE":         11,
	"UPDATING_INSTANCE":         12,
	"DELETING_INSTANCE":         13,
	"STARTING_INSTANCE":         14,
	"STOPPING_INSTANCE":         15,
	"AWAITING_STARTUP_DURATION": 16,
	"CHECKING_HEALTH":           17,
	"OPENING_TRAFFIC":           18,
	"AWAITING_WARMUP_DURATION":  19,
	"CLOSING_TRAFFIC":           20,
	"RUNNING_ACTUAL":            21,
	"RUNNING_OUTDATED":          22,
	"STOPPED":                   23,
	"DELETED":                   24,
}

func (x ManagedInstance_Status) String() string {
	return proto.EnumName(ManagedInstance_Status_name, int32(x))
}

func (ManagedInstance_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{19, 0}
}

type InstanceGroup struct {
	// ID of the instance group.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the instance group belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the instance group.
	// The name is unique within the folder.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the instance group.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Instance template for creating the instance group.
	// For more information, see [Instance Templates](/docs/compute/concepts/ig-instance-templates).
	InstanceTemplate *InstanceTemplate `protobuf:"bytes,7,opt,name=instance_template,json=instanceTemplate,proto3" json:"instance_template,omitempty"`
	// [Scaling policy](/docs/compute/concepts/instance-groups/scale) of the instance group.
	ScalePolicy *ScalePolicy `protobuf:"bytes,8,opt,name=scale_policy,json=scalePolicy,proto3" json:"scale_policy,omitempty"`
	// Deployment policy of the instance group.
	DeployPolicy *DeployPolicy `protobuf:"bytes,9,opt,name=deploy_policy,json=deployPolicy,proto3" json:"deploy_policy,omitempty"`
	// Allocation policy of the instance group by zones and regions.
	AllocationPolicy *AllocationPolicy `protobuf:"bytes,10,opt,name=allocation_policy,json=allocationPolicy,proto3" json:"allocation_policy,omitempty"`
	// Information that indicates which entities can be related to this load balancer.
	LoadBalancerState *LoadBalancerState `protobuf:"bytes,11,opt,name=load_balancer_state,json=loadBalancerState,proto3" json:"load_balancer_state,omitempty"`
	// States of instances for this instance group.
	ManagedInstancesState *ManagedInstancesState `protobuf:"bytes,12,opt,name=managed_instances_state,json=managedInstancesState,proto3" json:"managed_instances_state,omitempty"`
	// Load balancing specification.
	LoadBalancerSpec *LoadBalancerSpec `protobuf:"bytes,14,opt,name=load_balancer_spec,json=loadBalancerSpec,proto3" json:"load_balancer_spec,omitempty"`
	// Health checking specification. For more information, see [Health check](/docs/load-balancer/concepts/health-check).
	HealthChecksSpec *HealthChecksSpec `protobuf:"bytes,15,opt,name=health_checks_spec,json=healthChecksSpec,proto3" json:"health_checks_spec,omitempty"`
	// ID of the service account. The service account will be used for all API calls
	// made by the Instance Groups component on behalf of the user (for example, creating instances, adding them to load balancer target group, etc.). For more information, see [Service accounts](/docs/iam/concepts/users/service-accounts).
	// To get the service account ID, use a [yandex.cloud.iam.v1.ServiceAccountService.List] request.
	ServiceAccountId string `protobuf:"bytes,16,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// Status of the instance group.
	Status    InstanceGroup_Status `protobuf:"varint,17,opt,name=status,proto3,enum=yandex.cloud.compute.v1.instancegroup.InstanceGroup_Status" json:"status,omitempty"`
	Variables []*Variable          `protobuf:"bytes,18,rep,name=variables,proto3" json:"variables,omitempty"`
	// Flag that inhibits deletion of the instance group
	DeletionProtection   bool     `protobuf:"varint,19,opt,name=deletion_protection,json=deletionProtection,proto3" json:"deletion_protection,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InstanceGroup) Reset()         { *m = InstanceGroup{} }
func (m *InstanceGroup) String() string { return proto.CompactTextString(m) }
func (*InstanceGroup) ProtoMessage()    {}
func (*InstanceGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{0}
}

func (m *InstanceGroup) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstanceGroup.Unmarshal(m, b)
}
func (m *InstanceGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstanceGroup.Marshal(b, m, deterministic)
}
func (m *InstanceGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstanceGroup.Merge(m, src)
}
func (m *InstanceGroup) XXX_Size() int {
	return xxx_messageInfo_InstanceGroup.Size(m)
}
func (m *InstanceGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_InstanceGroup.DiscardUnknown(m)
}

var xxx_messageInfo_InstanceGroup proto.InternalMessageInfo

func (m *InstanceGroup) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *InstanceGroup) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *InstanceGroup) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *InstanceGroup) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *InstanceGroup) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *InstanceGroup) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *InstanceGroup) GetInstanceTemplate() *InstanceTemplate {
	if m != nil {
		return m.InstanceTemplate
	}
	return nil
}

func (m *InstanceGroup) GetScalePolicy() *ScalePolicy {
	if m != nil {
		return m.ScalePolicy
	}
	return nil
}

func (m *InstanceGroup) GetDeployPolicy() *DeployPolicy {
	if m != nil {
		return m.DeployPolicy
	}
	return nil
}

func (m *InstanceGroup) GetAllocationPolicy() *AllocationPolicy {
	if m != nil {
		return m.AllocationPolicy
	}
	return nil
}

func (m *InstanceGroup) GetLoadBalancerState() *LoadBalancerState {
	if m != nil {
		return m.LoadBalancerState
	}
	return nil
}

func (m *InstanceGroup) GetManagedInstancesState() *ManagedInstancesState {
	if m != nil {
		return m.ManagedInstancesState
	}
	return nil
}

func (m *InstanceGroup) GetLoadBalancerSpec() *LoadBalancerSpec {
	if m != nil {
		return m.LoadBalancerSpec
	}
	return nil
}

func (m *InstanceGroup) GetHealthChecksSpec() *HealthChecksSpec {
	if m != nil {
		return m.HealthChecksSpec
	}
	return nil
}

func (m *InstanceGroup) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

func (m *InstanceGroup) GetStatus() InstanceGroup_Status {
	if m != nil {
		return m.Status
	}
	return InstanceGroup_STATUS_UNSPECIFIED
}

func (m *InstanceGroup) GetVariables() []*Variable {
	if m != nil {
		return m.Variables
	}
	return nil
}

func (m *InstanceGroup) GetDeletionProtection() bool {
	if m != nil {
		return m.DeletionProtection
	}
	return false
}

type Variable struct {
	Key                  string   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Variable) Reset()         { *m = Variable{} }
func (m *Variable) String() string { return proto.CompactTextString(m) }
func (*Variable) ProtoMessage()    {}
func (*Variable) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{1}
}

func (m *Variable) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Variable.Unmarshal(m, b)
}
func (m *Variable) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Variable.Marshal(b, m, deterministic)
}
func (m *Variable) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Variable.Merge(m, src)
}
func (m *Variable) XXX_Size() int {
	return xxx_messageInfo_Variable.Size(m)
}
func (m *Variable) XXX_DiscardUnknown() {
	xxx_messageInfo_Variable.DiscardUnknown(m)
}

var xxx_messageInfo_Variable proto.InternalMessageInfo

func (m *Variable) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *Variable) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

type LoadBalancerState struct {
	// ID of the target group used for load balancing.
	TargetGroupId string `protobuf:"bytes,1,opt,name=target_group_id,json=targetGroupId,proto3" json:"target_group_id,omitempty"`
	// Status message of the target group.
	StatusMessage        string   `protobuf:"bytes,2,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LoadBalancerState) Reset()         { *m = LoadBalancerState{} }
func (m *LoadBalancerState) String() string { return proto.CompactTextString(m) }
func (*LoadBalancerState) ProtoMessage()    {}
func (*LoadBalancerState) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{2}
}

func (m *LoadBalancerState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LoadBalancerState.Unmarshal(m, b)
}
func (m *LoadBalancerState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LoadBalancerState.Marshal(b, m, deterministic)
}
func (m *LoadBalancerState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoadBalancerState.Merge(m, src)
}
func (m *LoadBalancerState) XXX_Size() int {
	return xxx_messageInfo_LoadBalancerState.Size(m)
}
func (m *LoadBalancerState) XXX_DiscardUnknown() {
	xxx_messageInfo_LoadBalancerState.DiscardUnknown(m)
}

var xxx_messageInfo_LoadBalancerState proto.InternalMessageInfo

func (m *LoadBalancerState) GetTargetGroupId() string {
	if m != nil {
		return m.TargetGroupId
	}
	return ""
}

func (m *LoadBalancerState) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

type ManagedInstancesState struct {
	// Target number of instances for this instance group.
	TargetSize int64 `protobuf:"varint,1,opt,name=target_size,json=targetSize,proto3" json:"target_size,omitempty"`
	// The number of running instances that match the current instance template. For more information, see [ManagedInstance.Status.RUNNING_ACTUAL].
	RunningActualCount int64 `protobuf:"varint,4,opt,name=running_actual_count,json=runningActualCount,proto3" json:"running_actual_count,omitempty"`
	// The number of running instances that does not match the current instance template. For more information, see [ManagedInstance.Status.RUNNING_OUTDATED].
	RunningOutdatedCount int64 `protobuf:"varint,5,opt,name=running_outdated_count,json=runningOutdatedCount,proto3" json:"running_outdated_count,omitempty"`
	// The number of instances in flight (for example, updating, starting, deleting). For more information, see [ManagedInstance.Status].
	ProcessingCount      int64    `protobuf:"varint,6,opt,name=processing_count,json=processingCount,proto3" json:"processing_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ManagedInstancesState) Reset()         { *m = ManagedInstancesState{} }
func (m *ManagedInstancesState) String() string { return proto.CompactTextString(m) }
func (*ManagedInstancesState) ProtoMessage()    {}
func (*ManagedInstancesState) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{3}
}

func (m *ManagedInstancesState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ManagedInstancesState.Unmarshal(m, b)
}
func (m *ManagedInstancesState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ManagedInstancesState.Marshal(b, m, deterministic)
}
func (m *ManagedInstancesState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ManagedInstancesState.Merge(m, src)
}
func (m *ManagedInstancesState) XXX_Size() int {
	return xxx_messageInfo_ManagedInstancesState.Size(m)
}
func (m *ManagedInstancesState) XXX_DiscardUnknown() {
	xxx_messageInfo_ManagedInstancesState.DiscardUnknown(m)
}

var xxx_messageInfo_ManagedInstancesState proto.InternalMessageInfo

func (m *ManagedInstancesState) GetTargetSize() int64 {
	if m != nil {
		return m.TargetSize
	}
	return 0
}

func (m *ManagedInstancesState) GetRunningActualCount() int64 {
	if m != nil {
		return m.RunningActualCount
	}
	return 0
}

func (m *ManagedInstancesState) GetRunningOutdatedCount() int64 {
	if m != nil {
		return m.RunningOutdatedCount
	}
	return 0
}

func (m *ManagedInstancesState) GetProcessingCount() int64 {
	if m != nil {
		return m.ProcessingCount
	}
	return 0
}

type ManagedInstancesState_Statuses struct {
	// Instance is being created.
	Creating int64 `protobuf:"varint,1,opt,name=creating,proto3" json:"creating,omitempty"`
	// Instance is being started.
	Starting int64 `protobuf:"varint,2,opt,name=starting,proto3" json:"starting,omitempty"`
	// Instance is being opened to receive traffic.
	Opening int64 `protobuf:"varint,3,opt,name=opening,proto3" json:"opening,omitempty"`
	// Instance is being warmed.
	Warming int64 `protobuf:"varint,4,opt,name=warming,proto3" json:"warming,omitempty"`
	// Instance is running normally.
	Running int64 `protobuf:"varint,5,opt,name=running,proto3" json:"running,omitempty"`
	// Instance is being closed to traffic.
	Closing int64 `protobuf:"varint,6,opt,name=closing,proto3" json:"closing,omitempty"`
	// Instance is being stopped.
	Stopping int64 `protobuf:"varint,7,opt,name=stopping,proto3" json:"stopping,omitempty"`
	// Instance is being updated.
	Updating int64 `protobuf:"varint,8,opt,name=updating,proto3" json:"updating,omitempty"`
	// Instance is being deleted.
	Deleting int64 `protobuf:"varint,9,opt,name=deleting,proto3" json:"deleting,omitempty"`
	// Instance failed and needs to be recreated.
	Failed               int64    `protobuf:"varint,10,opt,name=failed,proto3" json:"failed,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ManagedInstancesState_Statuses) Reset()         { *m = ManagedInstancesState_Statuses{} }
func (m *ManagedInstancesState_Statuses) String() string { return proto.CompactTextString(m) }
func (*ManagedInstancesState_Statuses) ProtoMessage()    {}
func (*ManagedInstancesState_Statuses) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{3, 0}
}

func (m *ManagedInstancesState_Statuses) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ManagedInstancesState_Statuses.Unmarshal(m, b)
}
func (m *ManagedInstancesState_Statuses) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ManagedInstancesState_Statuses.Marshal(b, m, deterministic)
}
func (m *ManagedInstancesState_Statuses) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ManagedInstancesState_Statuses.Merge(m, src)
}
func (m *ManagedInstancesState_Statuses) XXX_Size() int {
	return xxx_messageInfo_ManagedInstancesState_Statuses.Size(m)
}
func (m *ManagedInstancesState_Statuses) XXX_DiscardUnknown() {
	xxx_messageInfo_ManagedInstancesState_Statuses.DiscardUnknown(m)
}

var xxx_messageInfo_ManagedInstancesState_Statuses proto.InternalMessageInfo

func (m *ManagedInstancesState_Statuses) GetCreating() int64 {
	if m != nil {
		return m.Creating
	}
	return 0
}

func (m *ManagedInstancesState_Statuses) GetStarting() int64 {
	if m != nil {
		return m.Starting
	}
	return 0
}

func (m *ManagedInstancesState_Statuses) GetOpening() int64 {
	if m != nil {
		return m.Opening
	}
	return 0
}

func (m *ManagedInstancesState_Statuses) GetWarming() int64 {
	if m != nil {
		return m.Warming
	}
	return 0
}

func (m *ManagedInstancesState_Statuses) GetRunning() int64 {
	if m != nil {
		return m.Running
	}
	return 0
}

func (m *ManagedInstancesState_Statuses) GetClosing() int64 {
	if m != nil {
		return m.Closing
	}
	return 0
}

func (m *ManagedInstancesState_Statuses) GetStopping() int64 {
	if m != nil {
		return m.Stopping
	}
	return 0
}

func (m *ManagedInstancesState_Statuses) GetUpdating() int64 {
	if m != nil {
		return m.Updating
	}
	return 0
}

func (m *ManagedInstancesState_Statuses) GetDeleting() int64 {
	if m != nil {
		return m.Deleting
	}
	return 0
}

func (m *ManagedInstancesState_Statuses) GetFailed() int64 {
	if m != nil {
		return m.Failed
	}
	return 0
}

type ScalePolicy struct {
	// Types that are valid to be assigned to ScaleType:
	//	*ScalePolicy_FixedScale_
	//	*ScalePolicy_AutoScale_
	ScaleType isScalePolicy_ScaleType `protobuf_oneof:"scale_type"`
	// Test spec for [automatic scaling policy](/docs/compute/concepts/instance-groups/scale#auto-scale) of the instance group.
	TestAutoScale        *ScalePolicy_AutoScale `protobuf:"bytes,3,opt,name=test_auto_scale,json=testAutoScale,proto3" json:"test_auto_scale,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *ScalePolicy) Reset()         { *m = ScalePolicy{} }
func (m *ScalePolicy) String() string { return proto.CompactTextString(m) }
func (*ScalePolicy) ProtoMessage()    {}
func (*ScalePolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{4}
}

func (m *ScalePolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScalePolicy.Unmarshal(m, b)
}
func (m *ScalePolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScalePolicy.Marshal(b, m, deterministic)
}
func (m *ScalePolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScalePolicy.Merge(m, src)
}
func (m *ScalePolicy) XXX_Size() int {
	return xxx_messageInfo_ScalePolicy.Size(m)
}
func (m *ScalePolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_ScalePolicy.DiscardUnknown(m)
}

var xxx_messageInfo_ScalePolicy proto.InternalMessageInfo

type isScalePolicy_ScaleType interface {
	isScalePolicy_ScaleType()
}

type ScalePolicy_FixedScale_ struct {
	FixedScale *ScalePolicy_FixedScale `protobuf:"bytes,1,opt,name=fixed_scale,json=fixedScale,proto3,oneof"`
}

type ScalePolicy_AutoScale_ struct {
	AutoScale *ScalePolicy_AutoScale `protobuf:"bytes,2,opt,name=auto_scale,json=autoScale,proto3,oneof"`
}

func (*ScalePolicy_FixedScale_) isScalePolicy_ScaleType() {}

func (*ScalePolicy_AutoScale_) isScalePolicy_ScaleType() {}

func (m *ScalePolicy) GetScaleType() isScalePolicy_ScaleType {
	if m != nil {
		return m.ScaleType
	}
	return nil
}

func (m *ScalePolicy) GetFixedScale() *ScalePolicy_FixedScale {
	if x, ok := m.GetScaleType().(*ScalePolicy_FixedScale_); ok {
		return x.FixedScale
	}
	return nil
}

func (m *ScalePolicy) GetAutoScale() *ScalePolicy_AutoScale {
	if x, ok := m.GetScaleType().(*ScalePolicy_AutoScale_); ok {
		return x.AutoScale
	}
	return nil
}

func (m *ScalePolicy) GetTestAutoScale() *ScalePolicy_AutoScale {
	if m != nil {
		return m.TestAutoScale
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ScalePolicy) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ScalePolicy_FixedScale_)(nil),
		(*ScalePolicy_AutoScale_)(nil),
	}
}

type ScalePolicy_AutoScale struct {
	// Lower limit for instance count in each zone.
	MinZoneSize int64 `protobuf:"varint,1,opt,name=min_zone_size,json=minZoneSize,proto3" json:"min_zone_size,omitempty"`
	// Upper limit for total instance count (across all zones).
	// 0 means maximum limit = 100.
	MaxSize int64 `protobuf:"varint,2,opt,name=max_size,json=maxSize,proto3" json:"max_size,omitempty"`
	// Time in seconds allotted for averaging metrics.
	MeasurementDuration *duration.Duration `protobuf:"bytes,3,opt,name=measurement_duration,json=measurementDuration,proto3" json:"measurement_duration,omitempty"`
	// The warmup time of the instance in seconds. During this time,
	// traffic is sent to the instance, but instance metrics are not collected.
	WarmupDuration *duration.Duration `protobuf:"bytes,4,opt,name=warmup_duration,json=warmupDuration,proto3" json:"warmup_duration,omitempty"`
	// Minimum amount of time in seconds allotted for monitoring before
	// Instance Groups can reduce the number of instances in the group.
	// During this time, the group size doesn't decrease, even if the new metric values
	// indicate that it should.
	StabilizationDuration *duration.Duration `protobuf:"bytes,5,opt,name=stabilization_duration,json=stabilizationDuration,proto3" json:"stabilization_duration,omitempty"`
	// Target group size.
	InitialSize int64 `protobuf:"varint,6,opt,name=initial_size,json=initialSize,proto3" json:"initial_size,omitempty"`
	// Defines an autoscaling rule based on the average CPU utilization of the instance group.
	CpuUtilizationRule *ScalePolicy_CpuUtilizationRule `protobuf:"bytes,7,opt,name=cpu_utilization_rule,json=cpuUtilizationRule,proto3" json:"cpu_utilization_rule,omitempty"`
	// Defines an autoscaling rule based on a [custom metric](/docs/monitoring/operations/metric/add) from Yandex Monitoring.
	CustomRules          []*ScalePolicy_CustomRule `protobuf:"bytes,8,rep,name=custom_rules,json=customRules,proto3" json:"custom_rules,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *ScalePolicy_AutoScale) Reset()         { *m = ScalePolicy_AutoScale{} }
func (m *ScalePolicy_AutoScale) String() string { return proto.CompactTextString(m) }
func (*ScalePolicy_AutoScale) ProtoMessage()    {}
func (*ScalePolicy_AutoScale) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{4, 0}
}

func (m *ScalePolicy_AutoScale) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScalePolicy_AutoScale.Unmarshal(m, b)
}
func (m *ScalePolicy_AutoScale) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScalePolicy_AutoScale.Marshal(b, m, deterministic)
}
func (m *ScalePolicy_AutoScale) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScalePolicy_AutoScale.Merge(m, src)
}
func (m *ScalePolicy_AutoScale) XXX_Size() int {
	return xxx_messageInfo_ScalePolicy_AutoScale.Size(m)
}
func (m *ScalePolicy_AutoScale) XXX_DiscardUnknown() {
	xxx_messageInfo_ScalePolicy_AutoScale.DiscardUnknown(m)
}

var xxx_messageInfo_ScalePolicy_AutoScale proto.InternalMessageInfo

func (m *ScalePolicy_AutoScale) GetMinZoneSize() int64 {
	if m != nil {
		return m.MinZoneSize
	}
	return 0
}

func (m *ScalePolicy_AutoScale) GetMaxSize() int64 {
	if m != nil {
		return m.MaxSize
	}
	return 0
}

func (m *ScalePolicy_AutoScale) GetMeasurementDuration() *duration.Duration {
	if m != nil {
		return m.MeasurementDuration
	}
	return nil
}

func (m *ScalePolicy_AutoScale) GetWarmupDuration() *duration.Duration {
	if m != nil {
		return m.WarmupDuration
	}
	return nil
}

func (m *ScalePolicy_AutoScale) GetStabilizationDuration() *duration.Duration {
	if m != nil {
		return m.StabilizationDuration
	}
	return nil
}

func (m *ScalePolicy_AutoScale) GetInitialSize() int64 {
	if m != nil {
		return m.InitialSize
	}
	return 0
}

func (m *ScalePolicy_AutoScale) GetCpuUtilizationRule() *ScalePolicy_CpuUtilizationRule {
	if m != nil {
		return m.CpuUtilizationRule
	}
	return nil
}

func (m *ScalePolicy_AutoScale) GetCustomRules() []*ScalePolicy_CustomRule {
	if m != nil {
		return m.CustomRules
	}
	return nil
}

type ScalePolicy_CpuUtilizationRule struct {
	// Target CPU utilization level. Instance Groups maintains this level for each availability zone.
	UtilizationTarget    float64  `protobuf:"fixed64,1,opt,name=utilization_target,json=utilizationTarget,proto3" json:"utilization_target,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ScalePolicy_CpuUtilizationRule) Reset()         { *m = ScalePolicy_CpuUtilizationRule{} }
func (m *ScalePolicy_CpuUtilizationRule) String() string { return proto.CompactTextString(m) }
func (*ScalePolicy_CpuUtilizationRule) ProtoMessage()    {}
func (*ScalePolicy_CpuUtilizationRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{4, 1}
}

func (m *ScalePolicy_CpuUtilizationRule) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScalePolicy_CpuUtilizationRule.Unmarshal(m, b)
}
func (m *ScalePolicy_CpuUtilizationRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScalePolicy_CpuUtilizationRule.Marshal(b, m, deterministic)
}
func (m *ScalePolicy_CpuUtilizationRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScalePolicy_CpuUtilizationRule.Merge(m, src)
}
func (m *ScalePolicy_CpuUtilizationRule) XXX_Size() int {
	return xxx_messageInfo_ScalePolicy_CpuUtilizationRule.Size(m)
}
func (m *ScalePolicy_CpuUtilizationRule) XXX_DiscardUnknown() {
	xxx_messageInfo_ScalePolicy_CpuUtilizationRule.DiscardUnknown(m)
}

var xxx_messageInfo_ScalePolicy_CpuUtilizationRule proto.InternalMessageInfo

func (m *ScalePolicy_CpuUtilizationRule) GetUtilizationTarget() float64 {
	if m != nil {
		return m.UtilizationTarget
	}
	return 0
}

type ScalePolicy_CustomRule struct {
	// Custom metric rule type. This field affects which label from
	// the custom metric should be used: `zone_id` or `instance_id`.
	RuleType ScalePolicy_CustomRule_RuleType `protobuf:"varint,1,opt,name=rule_type,json=ruleType,proto3,enum=yandex.cloud.compute.v1.instancegroup.ScalePolicy_CustomRule_RuleType" json:"rule_type,omitempty"`
	// Type of custom metric. This field affects how Instance Groups calculates the average metric value.
	MetricType ScalePolicy_CustomRule_MetricType `protobuf:"varint,2,opt,name=metric_type,json=metricType,proto3,enum=yandex.cloud.compute.v1.instancegroup.ScalePolicy_CustomRule_MetricType" json:"metric_type,omitempty"`
	// Name of custom metric in Yandex Monitoring that should be used for scaling.
	MetricName string `protobuf:"bytes,3,opt,name=metric_name,json=metricName,proto3" json:"metric_name,omitempty"`
	// Labels of custom metric in Yandex Monitoring that should be used for scaling.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Target value for the custom metric. Instance Groups maintains this level for each availability zone.
	Target               float64  `protobuf:"fixed64,4,opt,name=target,proto3" json:"target,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ScalePolicy_CustomRule) Reset()         { *m = ScalePolicy_CustomRule{} }
func (m *ScalePolicy_CustomRule) String() string { return proto.CompactTextString(m) }
func (*ScalePolicy_CustomRule) ProtoMessage()    {}
func (*ScalePolicy_CustomRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{4, 2}
}

func (m *ScalePolicy_CustomRule) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScalePolicy_CustomRule.Unmarshal(m, b)
}
func (m *ScalePolicy_CustomRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScalePolicy_CustomRule.Marshal(b, m, deterministic)
}
func (m *ScalePolicy_CustomRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScalePolicy_CustomRule.Merge(m, src)
}
func (m *ScalePolicy_CustomRule) XXX_Size() int {
	return xxx_messageInfo_ScalePolicy_CustomRule.Size(m)
}
func (m *ScalePolicy_CustomRule) XXX_DiscardUnknown() {
	xxx_messageInfo_ScalePolicy_CustomRule.DiscardUnknown(m)
}

var xxx_messageInfo_ScalePolicy_CustomRule proto.InternalMessageInfo

func (m *ScalePolicy_CustomRule) GetRuleType() ScalePolicy_CustomRule_RuleType {
	if m != nil {
		return m.RuleType
	}
	return ScalePolicy_CustomRule_RULE_TYPE_UNSPECIFIED
}

func (m *ScalePolicy_CustomRule) GetMetricType() ScalePolicy_CustomRule_MetricType {
	if m != nil {
		return m.MetricType
	}
	return ScalePolicy_CustomRule_METRIC_TYPE_UNSPECIFIED
}

func (m *ScalePolicy_CustomRule) GetMetricName() string {
	if m != nil {
		return m.MetricName
	}
	return ""
}

func (m *ScalePolicy_CustomRule) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *ScalePolicy_CustomRule) GetTarget() float64 {
	if m != nil {
		return m.Target
	}
	return 0
}

type ScalePolicy_FixedScale struct {
	// Number of instances in the instance group.
	Size                 int64    `protobuf:"varint,1,opt,name=size,proto3" json:"size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ScalePolicy_FixedScale) Reset()         { *m = ScalePolicy_FixedScale{} }
func (m *ScalePolicy_FixedScale) String() string { return proto.CompactTextString(m) }
func (*ScalePolicy_FixedScale) ProtoMessage()    {}
func (*ScalePolicy_FixedScale) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{4, 3}
}

func (m *ScalePolicy_FixedScale) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScalePolicy_FixedScale.Unmarshal(m, b)
}
func (m *ScalePolicy_FixedScale) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScalePolicy_FixedScale.Marshal(b, m, deterministic)
}
func (m *ScalePolicy_FixedScale) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScalePolicy_FixedScale.Merge(m, src)
}
func (m *ScalePolicy_FixedScale) XXX_Size() int {
	return xxx_messageInfo_ScalePolicy_FixedScale.Size(m)
}
func (m *ScalePolicy_FixedScale) XXX_DiscardUnknown() {
	xxx_messageInfo_ScalePolicy_FixedScale.DiscardUnknown(m)
}

var xxx_messageInfo_ScalePolicy_FixedScale proto.InternalMessageInfo

func (m *ScalePolicy_FixedScale) GetSize() int64 {
	if m != nil {
		return m.Size
	}
	return 0
}

type DeployPolicy struct {
	// The maximum number of running instances that can be taken offline (i.e., stopped or deleted) at the same time
	// during the update process.
	// If [max_expansion] is not specified or set to zero, [max_unavailable] must be set to a non-zero value.
	MaxUnavailable int64 `protobuf:"varint,1,opt,name=max_unavailable,json=maxUnavailable,proto3" json:"max_unavailable,omitempty"`
	// The maximum number of instances that can be deleted at the same time.
	MaxDeleting int64 `protobuf:"varint,2,opt,name=max_deleting,json=maxDeleting,proto3" json:"max_deleting,omitempty"`
	// The maximum number of instances that can be created at the same time.
	MaxCreating int64 `protobuf:"varint,3,opt,name=max_creating,json=maxCreating,proto3" json:"max_creating,omitempty"`
	// The maximum number of instances that can be temporarily allocated above the group's target size
	// during the update process.
	// If [max_unavailable] is not specified or set to zero, [max_expansion] must be set to a non-zero value.
	MaxExpansion int64 `protobuf:"varint,6,opt,name=max_expansion,json=maxExpansion,proto3" json:"max_expansion,omitempty"`
	// Instance startup duration.
	// Instance will be considered up and running (and start receiving traffic) only after startup_duration
	// has elapsed and all health checks are passed.
	// See [yandex.cloud.compute.v1.instancegroup.ManagedInstance.Status] for more information.
	StartupDuration      *duration.Duration `protobuf:"bytes,7,opt,name=startup_duration,json=startupDuration,proto3" json:"startup_duration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *DeployPolicy) Reset()         { *m = DeployPolicy{} }
func (m *DeployPolicy) String() string { return proto.CompactTextString(m) }
func (*DeployPolicy) ProtoMessage()    {}
func (*DeployPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{5}
}

func (m *DeployPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeployPolicy.Unmarshal(m, b)
}
func (m *DeployPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeployPolicy.Marshal(b, m, deterministic)
}
func (m *DeployPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeployPolicy.Merge(m, src)
}
func (m *DeployPolicy) XXX_Size() int {
	return xxx_messageInfo_DeployPolicy.Size(m)
}
func (m *DeployPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_DeployPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_DeployPolicy proto.InternalMessageInfo

func (m *DeployPolicy) GetMaxUnavailable() int64 {
	if m != nil {
		return m.MaxUnavailable
	}
	return 0
}

func (m *DeployPolicy) GetMaxDeleting() int64 {
	if m != nil {
		return m.MaxDeleting
	}
	return 0
}

func (m *DeployPolicy) GetMaxCreating() int64 {
	if m != nil {
		return m.MaxCreating
	}
	return 0
}

func (m *DeployPolicy) GetMaxExpansion() int64 {
	if m != nil {
		return m.MaxExpansion
	}
	return 0
}

func (m *DeployPolicy) GetStartupDuration() *duration.Duration {
	if m != nil {
		return m.StartupDuration
	}
	return nil
}

type AllocationPolicy struct {
	// List of availability zones.
	Zones                []*AllocationPolicy_Zone `protobuf:"bytes,1,rep,name=zones,proto3" json:"zones,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *AllocationPolicy) Reset()         { *m = AllocationPolicy{} }
func (m *AllocationPolicy) String() string { return proto.CompactTextString(m) }
func (*AllocationPolicy) ProtoMessage()    {}
func (*AllocationPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{6}
}

func (m *AllocationPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AllocationPolicy.Unmarshal(m, b)
}
func (m *AllocationPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AllocationPolicy.Marshal(b, m, deterministic)
}
func (m *AllocationPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AllocationPolicy.Merge(m, src)
}
func (m *AllocationPolicy) XXX_Size() int {
	return xxx_messageInfo_AllocationPolicy.Size(m)
}
func (m *AllocationPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_AllocationPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_AllocationPolicy proto.InternalMessageInfo

func (m *AllocationPolicy) GetZones() []*AllocationPolicy_Zone {
	if m != nil {
		return m.Zones
	}
	return nil
}

type AllocationPolicy_Zone struct {
	// ID of the availability zone where the instance resides.
	ZoneId               string   `protobuf:"bytes,1,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AllocationPolicy_Zone) Reset()         { *m = AllocationPolicy_Zone{} }
func (m *AllocationPolicy_Zone) String() string { return proto.CompactTextString(m) }
func (*AllocationPolicy_Zone) ProtoMessage()    {}
func (*AllocationPolicy_Zone) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{6, 0}
}

func (m *AllocationPolicy_Zone) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AllocationPolicy_Zone.Unmarshal(m, b)
}
func (m *AllocationPolicy_Zone) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AllocationPolicy_Zone.Marshal(b, m, deterministic)
}
func (m *AllocationPolicy_Zone) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AllocationPolicy_Zone.Merge(m, src)
}
func (m *AllocationPolicy_Zone) XXX_Size() int {
	return xxx_messageInfo_AllocationPolicy_Zone.Size(m)
}
func (m *AllocationPolicy_Zone) XXX_DiscardUnknown() {
	xxx_messageInfo_AllocationPolicy_Zone.DiscardUnknown(m)
}

var xxx_messageInfo_AllocationPolicy_Zone proto.InternalMessageInfo

func (m *AllocationPolicy_Zone) GetZoneId() string {
	if m != nil {
		return m.ZoneId
	}
	return ""
}

type InstanceTemplate struct {
	// Description of the instance template.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// ID of the hardware platform configuration for the instance.
	// Platforms allows you to create various types of instances: with a large amount of memory,
	// with a large number of cores, with a burstable performance.
	// For more information, see [Platforms](/docs/compute/concepts/vm-platforms).
	PlatformId string `protobuf:"bytes,3,opt,name=platform_id,json=platformId,proto3" json:"platform_id,omitempty"`
	// Computing resources of the instance such as the amount of memory and number of cores.
	ResourcesSpec *ResourcesSpec `protobuf:"bytes,4,opt,name=resources_spec,json=resourcesSpec,proto3" json:"resources_spec,omitempty"`
	// The metadata `key:value` pairs assigned to this instance template. This includes custom metadata and predefined keys.
	//
	// Metadata values may contain one of the supported placeholders:
	//   {instance_group.id}
	//   {instance.short_id}
	//   {instance.index}
	//   {instance.index_in_zone}
	//   {instance.zone_id}
	// InstanceGroup and Instance labels may be copied to metadata following way:
	//   {instance_group.labels.some_label_key}
	//   {instance.labels.another_label_key}
	// These placeholders will be substituted for each created instance anywhere in the value text.
	// In the rare case the value requires to contain this placeholder explicitly,
	// it must be escaped with double brackets, in example {instance.index}.
	//
	// For example, you may use the metadata in order to provide your public SSH key to the instance.
	// For more information, see [Metadata](/docs/compute/concepts/vm-metadata).
	Metadata map[string]string `protobuf:"bytes,5,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Boot disk specification that will be attached to the instance.
	BootDiskSpec *AttachedDiskSpec `protobuf:"bytes,6,opt,name=boot_disk_spec,json=bootDiskSpec,proto3" json:"boot_disk_spec,omitempty"`
	// Array of secondary disks that will be attached to the instance.
	SecondaryDiskSpecs []*AttachedDiskSpec `protobuf:"bytes,7,rep,name=secondary_disk_specs,json=secondaryDiskSpecs,proto3" json:"secondary_disk_specs,omitempty"`
	// Array of network interfaces that will be attached to the instance.
	NetworkInterfaceSpecs []*NetworkInterfaceSpec `protobuf:"bytes,8,rep,name=network_interface_specs,json=networkInterfaceSpecs,proto3" json:"network_interface_specs,omitempty"`
	// Scheduling policy for the instance.
	SchedulingPolicy *SchedulingPolicy `protobuf:"bytes,9,opt,name=scheduling_policy,json=schedulingPolicy,proto3" json:"scheduling_policy,omitempty"`
	// Service account ID for the instance.
	ServiceAccountId string `protobuf:"bytes,10,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// Network settings for the instance.
	NetworkSettings *NetworkSettings `protobuf:"bytes,11,opt,name=network_settings,json=networkSettings,proto3" json:"network_settings,omitempty"`
	// Name of the instance.
	// In order to be unique it must contain at least on of instance unique placeholders:
	//   {instance.short_id}
	//   {instance.index}
	//   combination of {instance.zone_id} and {instance.index_in_zone}
	// Example: my-instance-{instance.index}
	// If not set, default is used: {instance_group.id}-{instance.short_id}
	// It may also contain another placeholders, see metadata doc for full list.
	Name string `protobuf:"bytes,12,opt,name=name,proto3" json:"name,omitempty"`
	// Host name for the instance.
	// This field is used to generate the [yandex.cloud.compute.v1.Instance.fqdn] value.
	// The host name must be unique within the network and region.
	// If not specified, the host name will be equal to [yandex.cloud.compute.v1.Instance.id] of the instance
	// and FQDN will be `<id>.auto.internal`. Otherwise FQDN will be `<hostname>.<region_id>.internal`.
	//
	// In order to be unique it must contain at least on of instance unique placeholders:
	//   {instance.short_id}
	//   {instance.index}
	//   combination of {instance.zone_id} and {instance.index_in_zone}
	// Example: my-instance-{instance.index}
	// If not set, `name` value will be used
	// It may also contain another placeholders, see metadata doc for full list.
	Hostname             string   `protobuf:"bytes,13,opt,name=hostname,proto3" json:"hostname,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InstanceTemplate) Reset()         { *m = InstanceTemplate{} }
func (m *InstanceTemplate) String() string { return proto.CompactTextString(m) }
func (*InstanceTemplate) ProtoMessage()    {}
func (*InstanceTemplate) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{7}
}

func (m *InstanceTemplate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstanceTemplate.Unmarshal(m, b)
}
func (m *InstanceTemplate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstanceTemplate.Marshal(b, m, deterministic)
}
func (m *InstanceTemplate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstanceTemplate.Merge(m, src)
}
func (m *InstanceTemplate) XXX_Size() int {
	return xxx_messageInfo_InstanceTemplate.Size(m)
}
func (m *InstanceTemplate) XXX_DiscardUnknown() {
	xxx_messageInfo_InstanceTemplate.DiscardUnknown(m)
}

var xxx_messageInfo_InstanceTemplate proto.InternalMessageInfo

func (m *InstanceTemplate) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *InstanceTemplate) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *InstanceTemplate) GetPlatformId() string {
	if m != nil {
		return m.PlatformId
	}
	return ""
}

func (m *InstanceTemplate) GetResourcesSpec() *ResourcesSpec {
	if m != nil {
		return m.ResourcesSpec
	}
	return nil
}

func (m *InstanceTemplate) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *InstanceTemplate) GetBootDiskSpec() *AttachedDiskSpec {
	if m != nil {
		return m.BootDiskSpec
	}
	return nil
}

func (m *InstanceTemplate) GetSecondaryDiskSpecs() []*AttachedDiskSpec {
	if m != nil {
		return m.SecondaryDiskSpecs
	}
	return nil
}

func (m *InstanceTemplate) GetNetworkInterfaceSpecs() []*NetworkInterfaceSpec {
	if m != nil {
		return m.NetworkInterfaceSpecs
	}
	return nil
}

func (m *InstanceTemplate) GetSchedulingPolicy() *SchedulingPolicy {
	if m != nil {
		return m.SchedulingPolicy
	}
	return nil
}

func (m *InstanceTemplate) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

func (m *InstanceTemplate) GetNetworkSettings() *NetworkSettings {
	if m != nil {
		return m.NetworkSettings
	}
	return nil
}

func (m *InstanceTemplate) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *InstanceTemplate) GetHostname() string {
	if m != nil {
		return m.Hostname
	}
	return ""
}

type ResourcesSpec struct {
	// The amount of memory available to the instance, specified in bytes.
	Memory int64 `protobuf:"varint,1,opt,name=memory,proto3" json:"memory,omitempty"`
	// The number of cores available to the instance.
	Cores int64 `protobuf:"varint,2,opt,name=cores,proto3" json:"cores,omitempty"`
	// Baseline level of CPU performance with the ability to burst performance above that baseline level.
	// This field sets baseline performance for each core.
	CoreFraction int64 `protobuf:"varint,3,opt,name=core_fraction,json=coreFraction,proto3" json:"core_fraction,omitempty"`
	// The number of GPUs available to the instance.
	Gpus                 int64    `protobuf:"varint,4,opt,name=gpus,proto3" json:"gpus,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResourcesSpec) Reset()         { *m = ResourcesSpec{} }
func (m *ResourcesSpec) String() string { return proto.CompactTextString(m) }
func (*ResourcesSpec) ProtoMessage()    {}
func (*ResourcesSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{8}
}

func (m *ResourcesSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResourcesSpec.Unmarshal(m, b)
}
func (m *ResourcesSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResourcesSpec.Marshal(b, m, deterministic)
}
func (m *ResourcesSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourcesSpec.Merge(m, src)
}
func (m *ResourcesSpec) XXX_Size() int {
	return xxx_messageInfo_ResourcesSpec.Size(m)
}
func (m *ResourcesSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourcesSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ResourcesSpec proto.InternalMessageInfo

func (m *ResourcesSpec) GetMemory() int64 {
	if m != nil {
		return m.Memory
	}
	return 0
}

func (m *ResourcesSpec) GetCores() int64 {
	if m != nil {
		return m.Cores
	}
	return 0
}

func (m *ResourcesSpec) GetCoreFraction() int64 {
	if m != nil {
		return m.CoreFraction
	}
	return 0
}

func (m *ResourcesSpec) GetGpus() int64 {
	if m != nil {
		return m.Gpus
	}
	return 0
}

type AttachedDiskSpec struct {
	// Access mode to the Disk resource.
	Mode AttachedDiskSpec_Mode `protobuf:"varint,1,opt,name=mode,proto3,enum=yandex.cloud.compute.v1.instancegroup.AttachedDiskSpec_Mode" json:"mode,omitempty"`
	// Serial number that is reflected in the /dev/disk/by-id/ tree
	// of a Linux operating system running within the instance.
	//
	// This value can be used to reference the device for mounting, resizing, and so on, from within the instance.
	DeviceName string `protobuf:"bytes,2,opt,name=device_name,json=deviceName,proto3" json:"device_name,omitempty"`
	//oneof disk_spec or disk_id
	// Disk specification that is attached to the instance. For more information, see [Disks](/docs/compute/concepts/disk).
	DiskSpec *AttachedDiskSpec_DiskSpec `protobuf:"bytes,3,opt,name=disk_spec,json=diskSpec,proto3" json:"disk_spec,omitempty"`
	// Set to use an existing disk. To set use variables.
	DiskId               string   `protobuf:"bytes,4,opt,name=disk_id,json=diskId,proto3" json:"disk_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AttachedDiskSpec) Reset()         { *m = AttachedDiskSpec{} }
func (m *AttachedDiskSpec) String() string { return proto.CompactTextString(m) }
func (*AttachedDiskSpec) ProtoMessage()    {}
func (*AttachedDiskSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{9}
}

func (m *AttachedDiskSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AttachedDiskSpec.Unmarshal(m, b)
}
func (m *AttachedDiskSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AttachedDiskSpec.Marshal(b, m, deterministic)
}
func (m *AttachedDiskSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttachedDiskSpec.Merge(m, src)
}
func (m *AttachedDiskSpec) XXX_Size() int {
	return xxx_messageInfo_AttachedDiskSpec.Size(m)
}
func (m *AttachedDiskSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_AttachedDiskSpec.DiscardUnknown(m)
}

var xxx_messageInfo_AttachedDiskSpec proto.InternalMessageInfo

func (m *AttachedDiskSpec) GetMode() AttachedDiskSpec_Mode {
	if m != nil {
		return m.Mode
	}
	return AttachedDiskSpec_MODE_UNSPECIFIED
}

func (m *AttachedDiskSpec) GetDeviceName() string {
	if m != nil {
		return m.DeviceName
	}
	return ""
}

func (m *AttachedDiskSpec) GetDiskSpec() *AttachedDiskSpec_DiskSpec {
	if m != nil {
		return m.DiskSpec
	}
	return nil
}

func (m *AttachedDiskSpec) GetDiskId() string {
	if m != nil {
		return m.DiskId
	}
	return ""
}

type AttachedDiskSpec_DiskSpec struct {
	// Description of the disk.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// ID of the disk type.
	TypeId string `protobuf:"bytes,2,opt,name=type_id,json=typeId,proto3" json:"type_id,omitempty"`
	// Size of the disk, specified in bytes.
	Size int64 `protobuf:"varint,3,opt,name=size,proto3" json:"size,omitempty"`
	// Types that are valid to be assigned to SourceOneof:
	//	*AttachedDiskSpec_DiskSpec_ImageId
	//	*AttachedDiskSpec_DiskSpec_SnapshotId
	SourceOneof          isAttachedDiskSpec_DiskSpec_SourceOneof `protobuf_oneof:"source_oneof"`
	XXX_NoUnkeyedLiteral struct{}                                `json:"-"`
	XXX_unrecognized     []byte                                  `json:"-"`
	XXX_sizecache        int32                                   `json:"-"`
}

func (m *AttachedDiskSpec_DiskSpec) Reset()         { *m = AttachedDiskSpec_DiskSpec{} }
func (m *AttachedDiskSpec_DiskSpec) String() string { return proto.CompactTextString(m) }
func (*AttachedDiskSpec_DiskSpec) ProtoMessage()    {}
func (*AttachedDiskSpec_DiskSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{9, 0}
}

func (m *AttachedDiskSpec_DiskSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AttachedDiskSpec_DiskSpec.Unmarshal(m, b)
}
func (m *AttachedDiskSpec_DiskSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AttachedDiskSpec_DiskSpec.Marshal(b, m, deterministic)
}
func (m *AttachedDiskSpec_DiskSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttachedDiskSpec_DiskSpec.Merge(m, src)
}
func (m *AttachedDiskSpec_DiskSpec) XXX_Size() int {
	return xxx_messageInfo_AttachedDiskSpec_DiskSpec.Size(m)
}
func (m *AttachedDiskSpec_DiskSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_AttachedDiskSpec_DiskSpec.DiscardUnknown(m)
}

var xxx_messageInfo_AttachedDiskSpec_DiskSpec proto.InternalMessageInfo

func (m *AttachedDiskSpec_DiskSpec) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *AttachedDiskSpec_DiskSpec) GetTypeId() string {
	if m != nil {
		return m.TypeId
	}
	return ""
}

func (m *AttachedDiskSpec_DiskSpec) GetSize() int64 {
	if m != nil {
		return m.Size
	}
	return 0
}

type isAttachedDiskSpec_DiskSpec_SourceOneof interface {
	isAttachedDiskSpec_DiskSpec_SourceOneof()
}

type AttachedDiskSpec_DiskSpec_ImageId struct {
	ImageId string `protobuf:"bytes,4,opt,name=image_id,json=imageId,proto3,oneof"`
}

type AttachedDiskSpec_DiskSpec_SnapshotId struct {
	SnapshotId string `protobuf:"bytes,5,opt,name=snapshot_id,json=snapshotId,proto3,oneof"`
}

func (*AttachedDiskSpec_DiskSpec_ImageId) isAttachedDiskSpec_DiskSpec_SourceOneof() {}

func (*AttachedDiskSpec_DiskSpec_SnapshotId) isAttachedDiskSpec_DiskSpec_SourceOneof() {}

func (m *AttachedDiskSpec_DiskSpec) GetSourceOneof() isAttachedDiskSpec_DiskSpec_SourceOneof {
	if m != nil {
		return m.SourceOneof
	}
	return nil
}

func (m *AttachedDiskSpec_DiskSpec) GetImageId() string {
	if x, ok := m.GetSourceOneof().(*AttachedDiskSpec_DiskSpec_ImageId); ok {
		return x.ImageId
	}
	return ""
}

func (m *AttachedDiskSpec_DiskSpec) GetSnapshotId() string {
	if x, ok := m.GetSourceOneof().(*AttachedDiskSpec_DiskSpec_SnapshotId); ok {
		return x.SnapshotId
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AttachedDiskSpec_DiskSpec) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AttachedDiskSpec_DiskSpec_ImageId)(nil),
		(*AttachedDiskSpec_DiskSpec_SnapshotId)(nil),
	}
}

type NetworkInterfaceSpec struct {
	// ID of the network.
	NetworkId string `protobuf:"bytes,1,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// IDs of the subnets.
	SubnetIds []string `protobuf:"bytes,2,rep,name=subnet_ids,json=subnetIds,proto3" json:"subnet_ids,omitempty"`
	// Primary IPv4 address that is assigned to the instance for this network interface.
	PrimaryV4AddressSpec *PrimaryAddressSpec `protobuf:"bytes,3,opt,name=primary_v4_address_spec,json=primaryV4AddressSpec,proto3" json:"primary_v4_address_spec,omitempty"`
	// Primary IPv6 address that is assigned to the instance for this network interface. IPv6 not available yet.
	PrimaryV6AddressSpec *PrimaryAddressSpec `protobuf:"bytes,4,opt,name=primary_v6_address_spec,json=primaryV6AddressSpec,proto3" json:"primary_v6_address_spec,omitempty"`
	// IDs of security groups.
	SecurityGroupIds     []string `protobuf:"bytes,5,rep,name=security_group_ids,json=securityGroupIds,proto3" json:"security_group_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NetworkInterfaceSpec) Reset()         { *m = NetworkInterfaceSpec{} }
func (m *NetworkInterfaceSpec) String() string { return proto.CompactTextString(m) }
func (*NetworkInterfaceSpec) ProtoMessage()    {}
func (*NetworkInterfaceSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{10}
}

func (m *NetworkInterfaceSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NetworkInterfaceSpec.Unmarshal(m, b)
}
func (m *NetworkInterfaceSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NetworkInterfaceSpec.Marshal(b, m, deterministic)
}
func (m *NetworkInterfaceSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkInterfaceSpec.Merge(m, src)
}
func (m *NetworkInterfaceSpec) XXX_Size() int {
	return xxx_messageInfo_NetworkInterfaceSpec.Size(m)
}
func (m *NetworkInterfaceSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkInterfaceSpec.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkInterfaceSpec proto.InternalMessageInfo

func (m *NetworkInterfaceSpec) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

func (m *NetworkInterfaceSpec) GetSubnetIds() []string {
	if m != nil {
		return m.SubnetIds
	}
	return nil
}

func (m *NetworkInterfaceSpec) GetPrimaryV4AddressSpec() *PrimaryAddressSpec {
	if m != nil {
		return m.PrimaryV4AddressSpec
	}
	return nil
}

func (m *NetworkInterfaceSpec) GetPrimaryV6AddressSpec() *PrimaryAddressSpec {
	if m != nil {
		return m.PrimaryV6AddressSpec
	}
	return nil
}

func (m *NetworkInterfaceSpec) GetSecurityGroupIds() []string {
	if m != nil {
		return m.SecurityGroupIds
	}
	return nil
}

type PrimaryAddressSpec struct {
	// An external IP address configuration.
	// If not specified, then this managed instance will have no external internet access.
	OneToOneNatSpec      *OneToOneNatSpec `protobuf:"bytes,1,opt,name=one_to_one_nat_spec,json=oneToOneNatSpec,proto3" json:"one_to_one_nat_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *PrimaryAddressSpec) Reset()         { *m = PrimaryAddressSpec{} }
func (m *PrimaryAddressSpec) String() string { return proto.CompactTextString(m) }
func (*PrimaryAddressSpec) ProtoMessage()    {}
func (*PrimaryAddressSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{11}
}

func (m *PrimaryAddressSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PrimaryAddressSpec.Unmarshal(m, b)
}
func (m *PrimaryAddressSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PrimaryAddressSpec.Marshal(b, m, deterministic)
}
func (m *PrimaryAddressSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrimaryAddressSpec.Merge(m, src)
}
func (m *PrimaryAddressSpec) XXX_Size() int {
	return xxx_messageInfo_PrimaryAddressSpec.Size(m)
}
func (m *PrimaryAddressSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_PrimaryAddressSpec.DiscardUnknown(m)
}

var xxx_messageInfo_PrimaryAddressSpec proto.InternalMessageInfo

func (m *PrimaryAddressSpec) GetOneToOneNatSpec() *OneToOneNatSpec {
	if m != nil {
		return m.OneToOneNatSpec
	}
	return nil
}

type OneToOneNatSpec struct {
	// IP version for the public IP address.
	IpVersion            IpVersion `protobuf:"varint,1,opt,name=ip_version,json=ipVersion,proto3,enum=yandex.cloud.compute.v1.instancegroup.IpVersion" json:"ip_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *OneToOneNatSpec) Reset()         { *m = OneToOneNatSpec{} }
func (m *OneToOneNatSpec) String() string { return proto.CompactTextString(m) }
func (*OneToOneNatSpec) ProtoMessage()    {}
func (*OneToOneNatSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{12}
}

func (m *OneToOneNatSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OneToOneNatSpec.Unmarshal(m, b)
}
func (m *OneToOneNatSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OneToOneNatSpec.Marshal(b, m, deterministic)
}
func (m *OneToOneNatSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OneToOneNatSpec.Merge(m, src)
}
func (m *OneToOneNatSpec) XXX_Size() int {
	return xxx_messageInfo_OneToOneNatSpec.Size(m)
}
func (m *OneToOneNatSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_OneToOneNatSpec.DiscardUnknown(m)
}

var xxx_messageInfo_OneToOneNatSpec proto.InternalMessageInfo

func (m *OneToOneNatSpec) GetIpVersion() IpVersion {
	if m != nil {
		return m.IpVersion
	}
	return IpVersion_IP_VERSION_UNSPECIFIED
}

type SchedulingPolicy struct {
	// Preemptible instances are stopped at least once every 24 hours, and can be stopped at any time
	// if their resources are needed by Compute.
	// For more information, see [Preemptible Virtual Machines](/docs/compute/concepts/preemptible-vm).
	Preemptible          bool     `protobuf:"varint,1,opt,name=preemptible,proto3" json:"preemptible,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SchedulingPolicy) Reset()         { *m = SchedulingPolicy{} }
func (m *SchedulingPolicy) String() string { return proto.CompactTextString(m) }
func (*SchedulingPolicy) ProtoMessage()    {}
func (*SchedulingPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{13}
}

func (m *SchedulingPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SchedulingPolicy.Unmarshal(m, b)
}
func (m *SchedulingPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SchedulingPolicy.Marshal(b, m, deterministic)
}
func (m *SchedulingPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SchedulingPolicy.Merge(m, src)
}
func (m *SchedulingPolicy) XXX_Size() int {
	return xxx_messageInfo_SchedulingPolicy.Size(m)
}
func (m *SchedulingPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_SchedulingPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_SchedulingPolicy proto.InternalMessageInfo

func (m *SchedulingPolicy) GetPreemptible() bool {
	if m != nil {
		return m.Preemptible
	}
	return false
}

type NetworkSettings struct {
	// Type of instance network.
	Type                 NetworkSettings_Type `protobuf:"varint,1,opt,name=type,proto3,enum=yandex.cloud.compute.v1.instancegroup.NetworkSettings_Type" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *NetworkSettings) Reset()         { *m = NetworkSettings{} }
func (m *NetworkSettings) String() string { return proto.CompactTextString(m) }
func (*NetworkSettings) ProtoMessage()    {}
func (*NetworkSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{14}
}

func (m *NetworkSettings) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NetworkSettings.Unmarshal(m, b)
}
func (m *NetworkSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NetworkSettings.Marshal(b, m, deterministic)
}
func (m *NetworkSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkSettings.Merge(m, src)
}
func (m *NetworkSettings) XXX_Size() int {
	return xxx_messageInfo_NetworkSettings.Size(m)
}
func (m *NetworkSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkSettings.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkSettings proto.InternalMessageInfo

func (m *NetworkSettings) GetType() NetworkSettings_Type {
	if m != nil {
		return m.Type
	}
	return NetworkSettings_TYPE_UNSPECIFIED
}

type LoadBalancerSpec struct {
	// Specification of the target group that the instance group will be added to. For more information, see [Target groups and resources](/docs/load-balancer/target-resources).
	TargetGroupSpec      *TargetGroupSpec `protobuf:"bytes,1,opt,name=target_group_spec,json=targetGroupSpec,proto3" json:"target_group_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *LoadBalancerSpec) Reset()         { *m = LoadBalancerSpec{} }
func (m *LoadBalancerSpec) String() string { return proto.CompactTextString(m) }
func (*LoadBalancerSpec) ProtoMessage()    {}
func (*LoadBalancerSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{15}
}

func (m *LoadBalancerSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LoadBalancerSpec.Unmarshal(m, b)
}
func (m *LoadBalancerSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LoadBalancerSpec.Marshal(b, m, deterministic)
}
func (m *LoadBalancerSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoadBalancerSpec.Merge(m, src)
}
func (m *LoadBalancerSpec) XXX_Size() int {
	return xxx_messageInfo_LoadBalancerSpec.Size(m)
}
func (m *LoadBalancerSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_LoadBalancerSpec.DiscardUnknown(m)
}

var xxx_messageInfo_LoadBalancerSpec proto.InternalMessageInfo

func (m *LoadBalancerSpec) GetTargetGroupSpec() *TargetGroupSpec {
	if m != nil {
		return m.TargetGroupSpec
	}
	return nil
}

type TargetGroupSpec struct {
	// Name of the target group.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the target group.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs.
	Labels               map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *TargetGroupSpec) Reset()         { *m = TargetGroupSpec{} }
func (m *TargetGroupSpec) String() string { return proto.CompactTextString(m) }
func (*TargetGroupSpec) ProtoMessage()    {}
func (*TargetGroupSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{16}
}

func (m *TargetGroupSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TargetGroupSpec.Unmarshal(m, b)
}
func (m *TargetGroupSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TargetGroupSpec.Marshal(b, m, deterministic)
}
func (m *TargetGroupSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TargetGroupSpec.Merge(m, src)
}
func (m *TargetGroupSpec) XXX_Size() int {
	return xxx_messageInfo_TargetGroupSpec.Size(m)
}
func (m *TargetGroupSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_TargetGroupSpec.DiscardUnknown(m)
}

var xxx_messageInfo_TargetGroupSpec proto.InternalMessageInfo

func (m *TargetGroupSpec) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *TargetGroupSpec) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *TargetGroupSpec) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

type HealthChecksSpec struct {
	// Health checking specification. For more information, see [Health check](/docs/load-balancer/concepts/health-check).
	HealthCheckSpecs     []*HealthCheckSpec `protobuf:"bytes,1,rep,name=health_check_specs,json=healthCheckSpecs,proto3" json:"health_check_specs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *HealthChecksSpec) Reset()         { *m = HealthChecksSpec{} }
func (m *HealthChecksSpec) String() string { return proto.CompactTextString(m) }
func (*HealthChecksSpec) ProtoMessage()    {}
func (*HealthChecksSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{17}
}

func (m *HealthChecksSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HealthChecksSpec.Unmarshal(m, b)
}
func (m *HealthChecksSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HealthChecksSpec.Marshal(b, m, deterministic)
}
func (m *HealthChecksSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HealthChecksSpec.Merge(m, src)
}
func (m *HealthChecksSpec) XXX_Size() int {
	return xxx_messageInfo_HealthChecksSpec.Size(m)
}
func (m *HealthChecksSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_HealthChecksSpec.DiscardUnknown(m)
}

var xxx_messageInfo_HealthChecksSpec proto.InternalMessageInfo

func (m *HealthChecksSpec) GetHealthCheckSpecs() []*HealthCheckSpec {
	if m != nil {
		return m.HealthCheckSpecs
	}
	return nil
}

type HealthCheckSpec struct {
	// The interval between health checks. The default is 2 seconds.
	Interval *duration.Duration `protobuf:"bytes,1,opt,name=interval,proto3" json:"interval,omitempty"`
	// Timeout for the managed instance to return a response for the health check. The default is 1 second.
	Timeout *duration.Duration `protobuf:"bytes,2,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// The number of failed health checks for the managed instance to be considered unhealthy. The default (0) is 2.
	UnhealthyThreshold int64 `protobuf:"varint,3,opt,name=unhealthy_threshold,json=unhealthyThreshold,proto3" json:"unhealthy_threshold,omitempty"`
	// The number of successful health checks required in order for the managed instance to be considered healthy. The default (0) is 2.
	HealthyThreshold int64 `protobuf:"varint,4,opt,name=healthy_threshold,json=healthyThreshold,proto3" json:"healthy_threshold,omitempty"`
	// Types that are valid to be assigned to HealthCheckOptions:
	//	*HealthCheckSpec_TcpOptions_
	//	*HealthCheckSpec_HttpOptions_
	HealthCheckOptions   isHealthCheckSpec_HealthCheckOptions `protobuf_oneof:"health_check_options"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *HealthCheckSpec) Reset()         { *m = HealthCheckSpec{} }
func (m *HealthCheckSpec) String() string { return proto.CompactTextString(m) }
func (*HealthCheckSpec) ProtoMessage()    {}
func (*HealthCheckSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{18}
}

func (m *HealthCheckSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HealthCheckSpec.Unmarshal(m, b)
}
func (m *HealthCheckSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HealthCheckSpec.Marshal(b, m, deterministic)
}
func (m *HealthCheckSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HealthCheckSpec.Merge(m, src)
}
func (m *HealthCheckSpec) XXX_Size() int {
	return xxx_messageInfo_HealthCheckSpec.Size(m)
}
func (m *HealthCheckSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_HealthCheckSpec.DiscardUnknown(m)
}

var xxx_messageInfo_HealthCheckSpec proto.InternalMessageInfo

func (m *HealthCheckSpec) GetInterval() *duration.Duration {
	if m != nil {
		return m.Interval
	}
	return nil
}

func (m *HealthCheckSpec) GetTimeout() *duration.Duration {
	if m != nil {
		return m.Timeout
	}
	return nil
}

func (m *HealthCheckSpec) GetUnhealthyThreshold() int64 {
	if m != nil {
		return m.UnhealthyThreshold
	}
	return 0
}

func (m *HealthCheckSpec) GetHealthyThreshold() int64 {
	if m != nil {
		return m.HealthyThreshold
	}
	return 0
}

type isHealthCheckSpec_HealthCheckOptions interface {
	isHealthCheckSpec_HealthCheckOptions()
}

type HealthCheckSpec_TcpOptions_ struct {
	TcpOptions *HealthCheckSpec_TcpOptions `protobuf:"bytes,5,opt,name=tcp_options,json=tcpOptions,proto3,oneof"`
}

type HealthCheckSpec_HttpOptions_ struct {
	HttpOptions *HealthCheckSpec_HttpOptions `protobuf:"bytes,6,opt,name=http_options,json=httpOptions,proto3,oneof"`
}

func (*HealthCheckSpec_TcpOptions_) isHealthCheckSpec_HealthCheckOptions() {}

func (*HealthCheckSpec_HttpOptions_) isHealthCheckSpec_HealthCheckOptions() {}

func (m *HealthCheckSpec) GetHealthCheckOptions() isHealthCheckSpec_HealthCheckOptions {
	if m != nil {
		return m.HealthCheckOptions
	}
	return nil
}

func (m *HealthCheckSpec) GetTcpOptions() *HealthCheckSpec_TcpOptions {
	if x, ok := m.GetHealthCheckOptions().(*HealthCheckSpec_TcpOptions_); ok {
		return x.TcpOptions
	}
	return nil
}

func (m *HealthCheckSpec) GetHttpOptions() *HealthCheckSpec_HttpOptions {
	if x, ok := m.GetHealthCheckOptions().(*HealthCheckSpec_HttpOptions_); ok {
		return x.HttpOptions
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*HealthCheckSpec) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*HealthCheckSpec_TcpOptions_)(nil),
		(*HealthCheckSpec_HttpOptions_)(nil),
	}
}

type HealthCheckSpec_TcpOptions struct {
	// Port to use for TCP health checks.
	Port                 int64    `protobuf:"varint,1,opt,name=port,proto3" json:"port,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HealthCheckSpec_TcpOptions) Reset()         { *m = HealthCheckSpec_TcpOptions{} }
func (m *HealthCheckSpec_TcpOptions) String() string { return proto.CompactTextString(m) }
func (*HealthCheckSpec_TcpOptions) ProtoMessage()    {}
func (*HealthCheckSpec_TcpOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{18, 0}
}

func (m *HealthCheckSpec_TcpOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HealthCheckSpec_TcpOptions.Unmarshal(m, b)
}
func (m *HealthCheckSpec_TcpOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HealthCheckSpec_TcpOptions.Marshal(b, m, deterministic)
}
func (m *HealthCheckSpec_TcpOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HealthCheckSpec_TcpOptions.Merge(m, src)
}
func (m *HealthCheckSpec_TcpOptions) XXX_Size() int {
	return xxx_messageInfo_HealthCheckSpec_TcpOptions.Size(m)
}
func (m *HealthCheckSpec_TcpOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_HealthCheckSpec_TcpOptions.DiscardUnknown(m)
}

var xxx_messageInfo_HealthCheckSpec_TcpOptions proto.InternalMessageInfo

func (m *HealthCheckSpec_TcpOptions) GetPort() int64 {
	if m != nil {
		return m.Port
	}
	return 0
}

type HealthCheckSpec_HttpOptions struct {
	// Port to use for HTTP health checks.
	Port int64 `protobuf:"varint,1,opt,name=port,proto3" json:"port,omitempty"`
	// URL path to set for health checking requests.
	Path                 string   `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HealthCheckSpec_HttpOptions) Reset()         { *m = HealthCheckSpec_HttpOptions{} }
func (m *HealthCheckSpec_HttpOptions) String() string { return proto.CompactTextString(m) }
func (*HealthCheckSpec_HttpOptions) ProtoMessage()    {}
func (*HealthCheckSpec_HttpOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{18, 1}
}

func (m *HealthCheckSpec_HttpOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HealthCheckSpec_HttpOptions.Unmarshal(m, b)
}
func (m *HealthCheckSpec_HttpOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HealthCheckSpec_HttpOptions.Marshal(b, m, deterministic)
}
func (m *HealthCheckSpec_HttpOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HealthCheckSpec_HttpOptions.Merge(m, src)
}
func (m *HealthCheckSpec_HttpOptions) XXX_Size() int {
	return xxx_messageInfo_HealthCheckSpec_HttpOptions.Size(m)
}
func (m *HealthCheckSpec_HttpOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_HealthCheckSpec_HttpOptions.DiscardUnknown(m)
}

var xxx_messageInfo_HealthCheckSpec_HttpOptions proto.InternalMessageInfo

func (m *HealthCheckSpec_HttpOptions) GetPort() int64 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *HealthCheckSpec_HttpOptions) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

// A ManagedInstance resource. For more information, see [Instance Groups Concepts](/docs/compute/concepts/instance-groups/).
type ManagedInstance struct {
	// ID of the managed instance.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Status of the managed instance.
	Status ManagedInstance_Status `protobuf:"varint,2,opt,name=status,proto3,enum=yandex.cloud.compute.v1.instancegroup.ManagedInstance_Status" json:"status,omitempty"`
	// ID of the instance.
	InstanceId string `protobuf:"bytes,3,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Fully Qualified Domain Name.
	Fqdn string `protobuf:"bytes,4,opt,name=fqdn,proto3" json:"fqdn,omitempty"`
	// The name of the managed instance.
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	// Status message for the managed instance.
	StatusMessage string `protobuf:"bytes,6,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// ID of the availability zone where the instance resides.
	ZoneId string `protobuf:"bytes,7,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// Array of network interfaces that are attached to the managed instance.
	NetworkInterfaces []*NetworkInterface `protobuf:"bytes,8,rep,name=network_interfaces,json=networkInterfaces,proto3" json:"network_interfaces,omitempty"`
	// The timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format when the status of the managed instance was last changed.
	StatusChangedAt      *timestamp.Timestamp `protobuf:"bytes,9,opt,name=status_changed_at,json=statusChangedAt,proto3" json:"status_changed_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ManagedInstance) Reset()         { *m = ManagedInstance{} }
func (m *ManagedInstance) String() string { return proto.CompactTextString(m) }
func (*ManagedInstance) ProtoMessage()    {}
func (*ManagedInstance) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{19}
}

func (m *ManagedInstance) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ManagedInstance.Unmarshal(m, b)
}
func (m *ManagedInstance) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ManagedInstance.Marshal(b, m, deterministic)
}
func (m *ManagedInstance) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ManagedInstance.Merge(m, src)
}
func (m *ManagedInstance) XXX_Size() int {
	return xxx_messageInfo_ManagedInstance.Size(m)
}
func (m *ManagedInstance) XXX_DiscardUnknown() {
	xxx_messageInfo_ManagedInstance.DiscardUnknown(m)
}

var xxx_messageInfo_ManagedInstance proto.InternalMessageInfo

func (m *ManagedInstance) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ManagedInstance) GetStatus() ManagedInstance_Status {
	if m != nil {
		return m.Status
	}
	return ManagedInstance_STATUS_UNSPECIFIED
}

func (m *ManagedInstance) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *ManagedInstance) GetFqdn() string {
	if m != nil {
		return m.Fqdn
	}
	return ""
}

func (m *ManagedInstance) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ManagedInstance) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

func (m *ManagedInstance) GetZoneId() string {
	if m != nil {
		return m.ZoneId
	}
	return ""
}

func (m *ManagedInstance) GetNetworkInterfaces() []*NetworkInterface {
	if m != nil {
		return m.NetworkInterfaces
	}
	return nil
}

func (m *ManagedInstance) GetStatusChangedAt() *timestamp.Timestamp {
	if m != nil {
		return m.StatusChangedAt
	}
	return nil
}

type NetworkInterface struct {
	// The index of the network interface, generated by the server, 0,1,2... etc.
	// Currently only one network interface is supported per instance.
	Index string `protobuf:"bytes,1,opt,name=index,proto3" json:"index,omitempty"`
	// MAC address that is assigned to the network interface.
	MacAddress string `protobuf:"bytes,2,opt,name=mac_address,json=macAddress,proto3" json:"mac_address,omitempty"`
	// ID of the subnet.
	SubnetId string `protobuf:"bytes,3,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Primary IPv4 address that is assigned to the instance for this network interface.
	PrimaryV4Address *PrimaryAddress `protobuf:"bytes,4,opt,name=primary_v4_address,json=primaryV4Address,proto3" json:"primary_v4_address,omitempty"`
	// Primary IPv6 address that is assigned to the instance for this network interface. IPv6 is not available yet.
	PrimaryV6Address     *PrimaryAddress `protobuf:"bytes,5,opt,name=primary_v6_address,json=primaryV6Address,proto3" json:"primary_v6_address,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *NetworkInterface) Reset()         { *m = NetworkInterface{} }
func (m *NetworkInterface) String() string { return proto.CompactTextString(m) }
func (*NetworkInterface) ProtoMessage()    {}
func (*NetworkInterface) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{20}
}

func (m *NetworkInterface) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NetworkInterface.Unmarshal(m, b)
}
func (m *NetworkInterface) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NetworkInterface.Marshal(b, m, deterministic)
}
func (m *NetworkInterface) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkInterface.Merge(m, src)
}
func (m *NetworkInterface) XXX_Size() int {
	return xxx_messageInfo_NetworkInterface.Size(m)
}
func (m *NetworkInterface) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkInterface.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkInterface proto.InternalMessageInfo

func (m *NetworkInterface) GetIndex() string {
	if m != nil {
		return m.Index
	}
	return ""
}

func (m *NetworkInterface) GetMacAddress() string {
	if m != nil {
		return m.MacAddress
	}
	return ""
}

func (m *NetworkInterface) GetSubnetId() string {
	if m != nil {
		return m.SubnetId
	}
	return ""
}

func (m *NetworkInterface) GetPrimaryV4Address() *PrimaryAddress {
	if m != nil {
		return m.PrimaryV4Address
	}
	return nil
}

func (m *NetworkInterface) GetPrimaryV6Address() *PrimaryAddress {
	if m != nil {
		return m.PrimaryV6Address
	}
	return nil
}

type PrimaryAddress struct {
	// An IPv4 internal network address that is assigned to the managed instance for this network interface.
	// If not specified by the user, an unused internal IP is assigned by the system.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// One-to-one NAT configuration. If missing, NAT has not been set up.
	OneToOneNat          *OneToOneNat `protobuf:"bytes,2,opt,name=one_to_one_nat,json=oneToOneNat,proto3" json:"one_to_one_nat,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *PrimaryAddress) Reset()         { *m = PrimaryAddress{} }
func (m *PrimaryAddress) String() string { return proto.CompactTextString(m) }
func (*PrimaryAddress) ProtoMessage()    {}
func (*PrimaryAddress) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{21}
}

func (m *PrimaryAddress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PrimaryAddress.Unmarshal(m, b)
}
func (m *PrimaryAddress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PrimaryAddress.Marshal(b, m, deterministic)
}
func (m *PrimaryAddress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrimaryAddress.Merge(m, src)
}
func (m *PrimaryAddress) XXX_Size() int {
	return xxx_messageInfo_PrimaryAddress.Size(m)
}
func (m *PrimaryAddress) XXX_DiscardUnknown() {
	xxx_messageInfo_PrimaryAddress.DiscardUnknown(m)
}

var xxx_messageInfo_PrimaryAddress proto.InternalMessageInfo

func (m *PrimaryAddress) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *PrimaryAddress) GetOneToOneNat() *OneToOneNat {
	if m != nil {
		return m.OneToOneNat
	}
	return nil
}

type OneToOneNat struct {
	// An IPv4 external network address that is assigned to the managed instance for this network interface.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// External IP address version.
	IpVersion            IpVersion `protobuf:"varint,2,opt,name=ip_version,json=ipVersion,proto3,enum=yandex.cloud.compute.v1.instancegroup.IpVersion" json:"ip_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *OneToOneNat) Reset()         { *m = OneToOneNat{} }
func (m *OneToOneNat) String() string { return proto.CompactTextString(m) }
func (*OneToOneNat) ProtoMessage()    {}
func (*OneToOneNat) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{22}
}

func (m *OneToOneNat) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OneToOneNat.Unmarshal(m, b)
}
func (m *OneToOneNat) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OneToOneNat.Marshal(b, m, deterministic)
}
func (m *OneToOneNat) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OneToOneNat.Merge(m, src)
}
func (m *OneToOneNat) XXX_Size() int {
	return xxx_messageInfo_OneToOneNat.Size(m)
}
func (m *OneToOneNat) XXX_DiscardUnknown() {
	xxx_messageInfo_OneToOneNat.DiscardUnknown(m)
}

var xxx_messageInfo_OneToOneNat proto.InternalMessageInfo

func (m *OneToOneNat) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *OneToOneNat) GetIpVersion() IpVersion {
	if m != nil {
		return m.IpVersion
	}
	return IpVersion_IP_VERSION_UNSPECIFIED
}

type LogRecord struct {
	// Log timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	Timestamp *timestamp.Timestamp `protobuf:"bytes,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// The log message.
	Message              string   `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LogRecord) Reset()         { *m = LogRecord{} }
func (m *LogRecord) String() string { return proto.CompactTextString(m) }
func (*LogRecord) ProtoMessage()    {}
func (*LogRecord) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{23}
}

func (m *LogRecord) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogRecord.Unmarshal(m, b)
}
func (m *LogRecord) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogRecord.Marshal(b, m, deterministic)
}
func (m *LogRecord) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogRecord.Merge(m, src)
}
func (m *LogRecord) XXX_Size() int {
	return xxx_messageInfo_LogRecord.Size(m)
}
func (m *LogRecord) XXX_DiscardUnknown() {
	xxx_messageInfo_LogRecord.DiscardUnknown(m)
}

var xxx_messageInfo_LogRecord proto.InternalMessageInfo

func (m *LogRecord) GetTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *LogRecord) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func init() {
	proto.RegisterEnum("yandex.cloud.compute.v1.instancegroup.IpVersion", IpVersion_name, IpVersion_value)
	proto.RegisterEnum("yandex.cloud.compute.v1.instancegroup.InstanceGroup_Status", InstanceGroup_Status_name, InstanceGroup_Status_value)
	proto.RegisterEnum("yandex.cloud.compute.v1.instancegroup.ScalePolicy_CustomRule_RuleType", ScalePolicy_CustomRule_RuleType_name, ScalePolicy_CustomRule_RuleType_value)
	proto.RegisterEnum("yandex.cloud.compute.v1.instancegroup.ScalePolicy_CustomRule_MetricType", ScalePolicy_CustomRule_MetricType_name, ScalePolicy_CustomRule_MetricType_value)
	proto.RegisterEnum("yandex.cloud.compute.v1.instancegroup.AttachedDiskSpec_Mode", AttachedDiskSpec_Mode_name, AttachedDiskSpec_Mode_value)
	proto.RegisterEnum("yandex.cloud.compute.v1.instancegroup.NetworkSettings_Type", NetworkSettings_Type_name, NetworkSettings_Type_value)
	proto.RegisterEnum("yandex.cloud.compute.v1.instancegroup.ManagedInstance_Status", ManagedInstance_Status_name, ManagedInstance_Status_value)
	proto.RegisterType((*InstanceGroup)(nil), "yandex.cloud.compute.v1.instancegroup.InstanceGroup")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.compute.v1.instancegroup.InstanceGroup.LabelsEntry")
	proto.RegisterType((*Variable)(nil), "yandex.cloud.compute.v1.instancegroup.Variable")
	proto.RegisterType((*LoadBalancerState)(nil), "yandex.cloud.compute.v1.instancegroup.LoadBalancerState")
	proto.RegisterType((*ManagedInstancesState)(nil), "yandex.cloud.compute.v1.instancegroup.ManagedInstancesState")
	proto.RegisterType((*ManagedInstancesState_Statuses)(nil), "yandex.cloud.compute.v1.instancegroup.ManagedInstancesState.Statuses")
	proto.RegisterType((*ScalePolicy)(nil), "yandex.cloud.compute.v1.instancegroup.ScalePolicy")
	proto.RegisterType((*ScalePolicy_AutoScale)(nil), "yandex.cloud.compute.v1.instancegroup.ScalePolicy.AutoScale")
	proto.RegisterType((*ScalePolicy_CpuUtilizationRule)(nil), "yandex.cloud.compute.v1.instancegroup.ScalePolicy.CpuUtilizationRule")
	proto.RegisterType((*ScalePolicy_CustomRule)(nil), "yandex.cloud.compute.v1.instancegroup.ScalePolicy.CustomRule")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.compute.v1.instancegroup.ScalePolicy.CustomRule.LabelsEntry")
	proto.RegisterType((*ScalePolicy_FixedScale)(nil), "yandex.cloud.compute.v1.instancegroup.ScalePolicy.FixedScale")
	proto.RegisterType((*DeployPolicy)(nil), "yandex.cloud.compute.v1.instancegroup.DeployPolicy")
	proto.RegisterType((*AllocationPolicy)(nil), "yandex.cloud.compute.v1.instancegroup.AllocationPolicy")
	proto.RegisterType((*AllocationPolicy_Zone)(nil), "yandex.cloud.compute.v1.instancegroup.AllocationPolicy.Zone")
	proto.RegisterType((*InstanceTemplate)(nil), "yandex.cloud.compute.v1.instancegroup.InstanceTemplate")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.compute.v1.instancegroup.InstanceTemplate.LabelsEntry")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.compute.v1.instancegroup.InstanceTemplate.MetadataEntry")
	proto.RegisterType((*ResourcesSpec)(nil), "yandex.cloud.compute.v1.instancegroup.ResourcesSpec")
	proto.RegisterType((*AttachedDiskSpec)(nil), "yandex.cloud.compute.v1.instancegroup.AttachedDiskSpec")
	proto.RegisterType((*AttachedDiskSpec_DiskSpec)(nil), "yandex.cloud.compute.v1.instancegroup.AttachedDiskSpec.DiskSpec")
	proto.RegisterType((*NetworkInterfaceSpec)(nil), "yandex.cloud.compute.v1.instancegroup.NetworkInterfaceSpec")
	proto.RegisterType((*PrimaryAddressSpec)(nil), "yandex.cloud.compute.v1.instancegroup.PrimaryAddressSpec")
	proto.RegisterType((*OneToOneNatSpec)(nil), "yandex.cloud.compute.v1.instancegroup.OneToOneNatSpec")
	proto.RegisterType((*SchedulingPolicy)(nil), "yandex.cloud.compute.v1.instancegroup.SchedulingPolicy")
	proto.RegisterType((*NetworkSettings)(nil), "yandex.cloud.compute.v1.instancegroup.NetworkSettings")
	proto.RegisterType((*LoadBalancerSpec)(nil), "yandex.cloud.compute.v1.instancegroup.LoadBalancerSpec")
	proto.RegisterType((*TargetGroupSpec)(nil), "yandex.cloud.compute.v1.instancegroup.TargetGroupSpec")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.compute.v1.instancegroup.TargetGroupSpec.LabelsEntry")
	proto.RegisterType((*HealthChecksSpec)(nil), "yandex.cloud.compute.v1.instancegroup.HealthChecksSpec")
	proto.RegisterType((*HealthCheckSpec)(nil), "yandex.cloud.compute.v1.instancegroup.HealthCheckSpec")
	proto.RegisterType((*HealthCheckSpec_TcpOptions)(nil), "yandex.cloud.compute.v1.instancegroup.HealthCheckSpec.TcpOptions")
	proto.RegisterType((*HealthCheckSpec_HttpOptions)(nil), "yandex.cloud.compute.v1.instancegroup.HealthCheckSpec.HttpOptions")
	proto.RegisterType((*ManagedInstance)(nil), "yandex.cloud.compute.v1.instancegroup.ManagedInstance")
	proto.RegisterType((*NetworkInterface)(nil), "yandex.cloud.compute.v1.instancegroup.NetworkInterface")
	proto.RegisterType((*PrimaryAddress)(nil), "yandex.cloud.compute.v1.instancegroup.PrimaryAddress")
	proto.RegisterType((*OneToOneNat)(nil), "yandex.cloud.compute.v1.instancegroup.OneToOneNat")
	proto.RegisterType((*LogRecord)(nil), "yandex.cloud.compute.v1.instancegroup.LogRecord")
}

func init() {
	proto.RegisterFile("yandex/cloud/compute/v1/instancegroup/instance_group.proto", fileDescriptor_993454707bf70b9b)
}

var fileDescriptor_993454707bf70b9b = []byte{
	// 3702 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x3a, 0x4b, 0x70, 0xdb, 0x66,
	0x7a, 0xe1, 0x43, 0x14, 0xf9, 0x51, 0x22, 0xa1, 0xdf, 0xb2, 0xcd, 0x30, 0x71, 0xec, 0xe1, 0xc4,
	0x1d, 0xc7, 0x0b, 0x52, 0x04, 0x49, 0xd1, 0x52, 0x2c, 0x67, 0xc3, 0x97, 0x2d, 0xce, 0x4a, 0xa2,
	0x06, 0xa2, 0xec, 0x6c, 0x64, 0x2f, 0x0a, 0x01, 0xbf, 0x24, 0x8c, 0x49, 0x80, 0x05, 0x40, 0xc5,
	0xf2, 0xd6, 0x87, 0x66, 0x3b, 0xd3, 0x4e, 0x8e, 0x3d, 0xec, 0xf4, 0xd6, 0x43, 0xef, 0x9d, 0x4e,
	0xae, 0xbd, 0xb4, 0xbd, 0xc8, 0xf7, 0x4e, 0x0f, 0xbd, 0x77, 0xfa, 0xb8, 0xf4, 0xe0, 0x53, 0x47,
	0xbd, 0x74, 0xfe, 0x07, 0x40, 0x90, 0x72, 0x62, 0x89, 0xda, 0x8b, 0xc4, 0xef, 0xfd, 0x3f, 0xbf,
	0xd7, 0x0f, 0xf8, 0xf2, 0x44, 0x35, 0x75, 0xfc, 0x6a, 0x49, 0xeb, 0x59, 0x43, 0x7d, 0x49, 0xb3,
	0xfa, 0x83, 0xa1, 0x8b, 0x97, 0x8e, 0xa5, 0x25, 0xc3, 0x74, 0x5c, 0xd5, 0xd4, 0xf0, 0xa1, 0x6d,
	0x0d, 0x07, 0x3e, 0xa4, 0x50, 0xb0, 0x30, 0xb0, 0x2d, 0xd7, 0x42, 0x77, 0x99, 0x6c, 0x81, 0xca,
	0x16, 0xb8, 0x6c, 0xe1, 0x58, 0x2a, 0x8c, 0xc9, 0x66, 0x6f, 0x8d, 0x99, 0x38, 0x56, 0x7b, 0x86,
	0xae, 0xba, 0x86, 0x65, 0x32, 0x2d, 0xd9, 0xdb, 0x87, 0x96, 0x75, 0xd8, 0xc3, 0x4b, 0x14, 0xda,
	0x1f, 0x1e, 0x2c, 0xb9, 0x46, 0x1f, 0x3b, 0xae, 0xda, 0xe7, 0x66, 0xb2, 0x9f, 0x4d, 0x32, 0xe8,
	0x43, 0x3b, 0xa0, 0x20, 0xf7, 0xaf, 0x49, 0x98, 0x6f, 0x73, 0x8b, 0x4f, 0x88, 0x45, 0x94, 0x82,
	0xb0, 0xa1, 0x67, 0x42, 0x77, 0x42, 0xf7, 0x12, 0x72, 0xd8, 0xd0, 0xd1, 0x27, 0x90, 0x38, 0xb0,
	0x7a, 0x3a, 0xb6, 0x15, 0x43, 0xcf, 0x84, 0x29, 0x3a, 0xce, 0x10, 0x6d, 0x1d, 0xad, 0x02, 0x68,
	0x36, 0x56, 0x5d, 0xac, 0x2b, 0xaa, 0x9b, 0x89, 0xdc, 0x09, 0xdd, 0x4b, 0x96, 0xb2, 0x05, 0x66,
	0xb3, 0xe0, 0xd9, 0x2c, 0x74, 0xbd, 0x41, 0xc9, 0x09, 0xce, 0x5d, 0x73, 0x11, 0x82, 0xa8, 0xa9,
	0xf6, 0x71, 0x26, 0x4a, 0x55, 0xd2, 0xdf, 0xe8, 0x0e, 0x24, 0x75, 0xec, 0x68, 0xb6, 0x31, 0x20,
	0x43, 0xcc, 0xcc, 0x50, 0x52, 0x10, 0x85, 0xbe, 0x81, 0x58, 0x4f, 0xdd, 0xc7, 0x3d, 0x27, 0x13,
	0xbb, 0x13, 0xb9, 0x97, 0x2c, 0x7d, 0x5d, 0xb8, 0xd0, 0x3a, 0x16, 0xc6, 0xe6, 0x58, 0xd8, 0xa0,
	0x2a, 0x5a, 0xa6, 0x6b, 0x9f, 0xc8, 0x5c, 0x1f, 0xd2, 0x61, 0xc1, 0xdf, 0x28, 0x17, 0xf7, 0x07,
	0x3d, 0xd5, 0xc5, 0x99, 0x59, 0x3a, 0xa3, 0x07, 0x97, 0x34, 0xd2, 0xe5, 0xe2, 0xb2, 0x60, 0x4c,
	0x60, 0xd0, 0x2e, 0xcc, 0x39, 0x9a, 0xda, 0xc3, 0xca, 0xc0, 0xea, 0x19, 0xda, 0x49, 0x26, 0x4e,
	0x0d, 0x94, 0x2e, 0x68, 0x60, 0x87, 0x88, 0x6e, 0x53, 0x49, 0x39, 0xe9, 0x8c, 0x00, 0xf4, 0x0d,
	0xcc, 0xeb, 0x78, 0xd0, 0xb3, 0x4e, 0x3c, 0xbd, 0x09, 0xaa, 0xb7, 0x7c, 0x41, 0xbd, 0x4d, 0x2a,
	0xcb, 0x15, 0xcf, 0xe9, 0x01, 0x88, 0x2c, 0x8b, 0xda, 0xeb, 0x59, 0x1a, 0x3d, 0x34, 0x9e, 0x76,
	0xb8, 0xd4, 0xb2, 0xd4, 0x7c, 0x79, 0x6e, 0x41, 0x50, 0x27, 0x30, 0xe8, 0x08, 0xae, 0xf5, 0x2c,
	0x55, 0x57, 0xf6, 0xd5, 0x1e, 0x91, 0xb3, 0x15, 0xc7, 0x25, 0xcb, 0x9f, 0xa4, 0x76, 0x56, 0x2e,
	0x68, 0x67, 0xc3, 0x52, 0xf5, 0x3a, 0x57, 0xb0, 0x43, 0xe4, 0xe5, 0x85, 0xde, 0x24, 0x0a, 0xb9,
	0x70, 0xb3, 0xaf, 0x9a, 0xea, 0x21, 0xd6, 0x15, 0x4f, 0xda, 0xe1, 0xd6, 0xe6, 0xa8, 0xb5, 0xb5,
	0x0b, 0x5a, 0xdb, 0x64, 0x5a, 0xbc, 0x3d, 0x77, 0x98, 0xc5, 0xeb, 0xfd, 0xf7, 0xa1, 0x11, 0x06,
	0x34, 0x31, 0xbf, 0x01, 0xd6, 0x32, 0xa9, 0x4b, 0x2d, 0xe3, 0xd8, 0xf4, 0x06, 0x58, 0x93, 0x85,
	0xde, 0x04, 0x86, 0x98, 0x39, 0xc2, 0x6a, 0xcf, 0x3d, 0x52, 0xb4, 0x23, 0xac, 0xbd, 0x74, 0x98,
	0x99, 0xf4, 0xa5, 0xcc, 0xac, 0x53, 0x05, 0x0d, 0x2a, 0xcf, 0xcc, 0x1c, 0x4d, 0x60, 0x90, 0x08,
	0xc8, 0xc1, 0xf6, 0xb1, 0xa1, 0x61, 0x45, 0xd5, 0x34, 0x6b, 0x68, 0xba, 0xc4, 0x37, 0x08, 0xf4,
	0xb6, 0x0a, 0x9c, 0x52, 0x63, 0x84, 0xb6, 0x8e, 0x76, 0x20, 0x46, 0xd6, 0x77, 0xe8, 0x64, 0x16,
	0xee, 0x84, 0xee, 0xa5, 0x4a, 0x0f, 0xa7, 0xba, 0xb2, 0x3b, 0x54, 0x85, 0xcc, 0x55, 0xa1, 0x4d,
	0x48, 0x1c, 0xab, 0xb6, 0xa1, 0xee, 0xf7, 0xb0, 0x93, 0x41, 0xd4, 0x15, 0x2c, 0x5d, 0x50, 0xef,
	0x53, 0x2e, 0x27, 0x8f, 0x34, 0xa0, 0x25, 0xb8, 0xa6, 0xe3, 0x1e, 0x66, 0x67, 0xdc, 0xb6, 0x5c,
	0xac, 0x51, 0x07, 0x74, 0xed, 0x4e, 0xe8, 0x5e, 0x5c, 0x46, 0x1e, 0x69, 0xdb, 0xa7, 0x64, 0x57,
	0x21, 0x19, 0x70, 0x22, 0x48, 0x80, 0xc8, 0x4b, 0x7c, 0xc2, 0xbd, 0x26, 0xf9, 0x89, 0x16, 0x61,
	0xe6, 0x58, 0xed, 0x0d, 0x31, 0x77, 0x99, 0x0c, 0xf8, 0x32, 0xbc, 0x12, 0xca, 0x69, 0x10, 0x63,
	0x93, 0x41, 0x37, 0x00, 0xed, 0x74, 0x6b, 0xdd, 0xdd, 0x1d, 0x65, 0x77, 0x6b, 0x67, 0xbb, 0xd5,
	0x68, 0x3f, 0x6e, 0xb7, 0x9a, 0xc2, 0x47, 0x68, 0x0e, 0xe2, 0x3b, 0xdd, 0x9a, 0xdc, 0x6d, 0x6f,
	0x3d, 0x11, 0x42, 0x08, 0x20, 0x56, 0x6b, 0x74, 0xdb, 0x4f, 0x5b, 0x42, 0x98, 0x51, 0x3a, 0xdb,
	0xdb, 0x84, 0x12, 0x41, 0x49, 0x98, 0xa5, 0x50, 0xab, 0x29, 0x44, 0x09, 0xa9, 0xd9, 0xda, 0x68,
	0x51, 0xa1, 0x99, 0xdc, 0x1e, 0xc4, 0xbd, 0x79, 0xa2, 0x42, 0x60, 0x70, 0xf5, 0x4f, 0xdf, 0x9d,
	0x4a, 0xe9, 0x3d, 0x35, 0xff, 0xba, 0x96, 0xff, 0xb6, 0x98, 0x5f, 0x2d, 0x28, 0xf9, 0x17, 0xf7,
	0x7f, 0x78, 0x2b, 0xcd, 0x48, 0x79, 0xa9, 0xb4, 0xc2, 0x86, 0x7e, 0x7b, 0x6c, 0xe8, 0xf5, 0x04,
	0x21, 0xaf, 0x3d, 0x22, 0x64, 0x86, 0xcf, 0xed, 0xc3, 0xc2, 0xb9, 0xbb, 0x86, 0xfe, 0x08, 0xd2,
	0xae, 0x6a, 0x1f, 0x62, 0x97, 0x85, 0x39, 0xc5, 0x0f, 0x22, 0xf3, 0x0c, 0x4d, 0xb7, 0xb1, 0xad,
	0xa3, 0xbb, 0x90, 0x62, 0x7b, 0xa8, 0xf4, 0xb1, 0xe3, 0xa8, 0x87, 0xde, 0x0a, 0xcd, 0x33, 0xec,
	0x26, 0x43, 0xe6, 0xfe, 0x3d, 0x02, 0xd7, 0xdf, 0x7b, 0xc5, 0xd0, 0x6d, 0x48, 0x72, 0x43, 0x8e,
	0xf1, 0x1a, 0x53, 0x23, 0x11, 0x19, 0x18, 0x6a, 0xc7, 0x78, 0x8d, 0x51, 0x11, 0x16, 0xed, 0xa1,
	0x69, 0x1a, 0xe6, 0xa1, 0xa2, 0x6a, 0xee, 0x50, 0xed, 0x29, 0xf4, 0x28, 0xd2, 0x48, 0x13, 0x91,
	0x11, 0xa7, 0xd5, 0x28, 0xa9, 0x41, 0x28, 0xa8, 0x02, 0x37, 0x3c, 0x09, 0x6b, 0xe8, 0xea, 0x34,
	0x9e, 0x31, 0x99, 0x19, 0x2a, 0xe3, 0xe9, 0xeb, 0x70, 0x22, 0x93, 0xfa, 0x02, 0x84, 0x81, 0x6d,
	0x69, 0xd8, 0x71, 0x88, 0x20, 0xe3, 0x8f, 0x51, 0xfe, 0xf4, 0x08, 0x4f, 0x59, 0xb3, 0xbf, 0x0f,
	0x43, 0x9c, 0x6d, 0x3a, 0x76, 0x50, 0x16, 0xe2, 0x34, 0x0c, 0x1a, 0xe6, 0x21, 0x1f, 0xbd, 0x0f,
	0x13, 0x9a, 0xe3, 0xaa, 0x36, 0xa5, 0x85, 0x19, 0xcd, 0x83, 0x51, 0x06, 0x66, 0xad, 0x01, 0x26,
	0xe3, 0xa0, 0x91, 0x36, 0x22, 0x7b, 0x20, 0xa1, 0x7c, 0xa7, 0xda, 0x7d, 0x42, 0x61, 0x93, 0xf4,
	0x40, 0x42, 0xe1, 0x63, 0xe7, 0x53, 0xf1, 0x40, 0x42, 0xd1, 0x7a, 0x16, 0x19, 0x22, 0x1f, 0xb4,
	0x07, 0xb2, 0x31, 0x58, 0x83, 0x01, 0x21, 0xcd, 0x7a, 0x63, 0x60, 0x30, 0xa1, 0x0d, 0x07, 0x3a,
	0x1b, 0x7b, 0x9c, 0xd1, 0x3c, 0x98, 0xd0, 0xd8, 0x4d, 0x31, 0x0f, 0x69, 0xfc, 0x89, 0xc8, 0x3e,
	0x8c, 0x6e, 0x40, 0xec, 0x40, 0x35, 0x7a, 0x58, 0xa7, 0xb1, 0x23, 0x22, 0x73, 0x28, 0xf7, 0x77,
	0x29, 0x48, 0x06, 0xa2, 0x1a, 0xfa, 0x63, 0x48, 0x1e, 0x18, 0xaf, 0xb0, 0xae, 0xd0, 0xe8, 0x46,
	0x97, 0x27, 0x59, 0x7a, 0x74, 0xf9, 0xf0, 0x58, 0x78, 0x4c, 0xb4, 0x50, 0xc4, 0xfa, 0x47, 0x32,
	0x1c, 0xf8, 0x10, 0x7a, 0x01, 0xa0, 0x0e, 0x5d, 0x8b, 0x1b, 0x08, 0x5f, 0xca, 0xe7, 0x07, 0x0d,
	0xd4, 0x86, 0xae, 0xe5, 0xe9, 0x4f, 0xa8, 0x1e, 0x80, 0x74, 0x48, 0xbb, 0xd8, 0x71, 0x95, 0x80,
	0x8d, 0xc8, 0xd5, 0x6d, 0xc8, 0xf3, 0x44, 0xa9, 0x0f, 0x66, 0xff, 0x2f, 0x0a, 0x09, 0x1f, 0x42,
	0x79, 0x98, 0xef, 0x1b, 0xa6, 0xf2, 0xda, 0x32, 0x71, 0xe0, 0x4e, 0xd4, 0x13, 0x67, 0xa7, 0xd2,
	0x4c, 0x31, 0x2f, 0x15, 0x8b, 0x72, 0xb2, 0x6f, 0x98, 0xdf, 0x5a, 0x26, 0xa6, 0xf7, 0xe3, 0x73,
	0x88, 0xf7, 0xd5, 0x57, 0x8c, 0x33, 0x3c, 0xc9, 0x39, 0xdb, 0x57, 0x5f, 0x51, 0xae, 0xe7, 0xb0,
	0xd8, 0xc7, 0xaa, 0x33, 0xb4, 0x71, 0x1f, 0x9b, 0xae, 0xe2, 0xe5, 0x8d, 0x7c, 0x36, 0x1f, 0x9f,
	0x4b, 0xf2, 0x9a, 0x9c, 0xa1, 0x9e, 0xfa, 0xaf, 0x53, 0x29, 0x74, 0x76, 0x2a, 0xc5, 0xa4, 0x7e,
	0x5e, 0x2a, 0xf6, 0xe5, 0x6b, 0x01, 0x35, 0x1e, 0x13, 0xda, 0x84, 0x34, 0x39, 0xa2, 0xc3, 0xc1,
	0x48, 0x71, 0xf4, 0x43, 0x8a, 0xe9, 0x28, 0xd7, 0x1e, 0x11, 0x9d, 0x29, 0x26, 0xec, 0xab, 0x7b,
	0x0e, 0x37, 0x1c, 0x57, 0xdd, 0x37, 0x7a, 0xc6, 0x6b, 0x96, 0xa8, 0xf8, 0x5a, 0x67, 0x3e, 0xa4,
	0x15, 0xf8, 0x50, 0xcb, 0xc5, 0xbe, 0x7c, 0x7d, 0x4c, 0x89, 0xaf, 0xfd, 0x3e, 0xcc, 0x19, 0xa6,
	0xe1, 0x1a, 0x6a, 0x8f, 0x2d, 0x1a, 0xbd, 0x2f, 0xf5, 0xd9, 0xb3, 0x53, 0x29, 0xf2, 0xd5, 0x23,
	0x49, 0x4e, 0x72, 0x22, 0x5d, 0xb6, 0xef, 0x60, 0x51, 0x1b, 0x0c, 0x95, 0xa1, 0x3b, 0x1a, 0x8b,
	0x3d, 0xec, 0x79, 0x99, 0x64, 0x6b, 0x8a, 0x43, 0xd0, 0x18, 0x0c, 0x77, 0x47, 0xda, 0xe4, 0x61,
	0x0f, 0xcb, 0x48, 0x3b, 0x87, 0x43, 0x06, 0xcc, 0x69, 0x43, 0xc7, 0xb5, 0xfa, 0xd4, 0x9e, 0x93,
	0x89, 0xd3, 0xa0, 0x38, 0xcd, 0xd5, 0x69, 0x50, 0x35, 0x44, 0x69, 0x7d, 0xf6, 0xfb, 0xb7, 0x52,
	0x64, 0x8d, 0xcc, 0x51, 0xf3, 0x91, 0x4e, 0xb6, 0x03, 0xe8, 0xfc, 0xa0, 0xd0, 0x2a, 0xa0, 0xe0,
	0xac, 0x99, 0x43, 0xa6, 0x47, 0x31, 0xc4, 0x17, 0x99, 0x9d, 0xb0, 0x85, 0x00, 0x57, 0x97, 0x32,
	0x65, 0xff, 0x73, 0x06, 0x60, 0x64, 0x15, 0x19, 0x90, 0x20, 0x73, 0x50, 0xdc, 0x93, 0x01, 0x3b,
	0xcb, 0xa9, 0xd2, 0xe3, 0x2b, 0xcd, 0xa3, 0x40, 0xfe, 0x74, 0x4f, 0x06, 0xb8, 0x1e, 0x25, 0x87,
	0x53, 0x8e, 0xdb, 0x1c, 0x46, 0x16, 0x24, 0xfb, 0xd8, 0xb5, 0x0d, 0x8d, 0x19, 0x0b, 0x53, 0x63,
	0xeb, 0x57, 0x33, 0xb6, 0x49, 0x15, 0x06, 0xcc, 0x41, 0xdf, 0xc7, 0xa0, 0x3d, 0xdf, 0x20, 0xad,
	0x7e, 0x22, 0x34, 0xc4, 0x7e, 0x49, 0xd8, 0xde, 0x9d, 0x4a, 0xa5, 0x40, 0x60, 0x5e, 0xfa, 0x5a,
	0x79, 0xb1, 0x77, 0xa7, 0x98, 0x5f, 0x65, 0x28, 0x02, 0x8b, 0x5f, 0x3e, 0xbc, 0xf7, 0xc5, 0xf3,
	0xbd, 0xe7, 0x2f, 0xd6, 0xbe, 0xca, 0xbf, 0xf8, 0x6d, 0x51, 0x94, 0x56, 0x57, 0xde, 0x78, 0xca,
	0xb7, 0x48, 0xfd, 0xf4, 0x0f, 0x21, 0xbf, 0x3c, 0x9a, 0xa1, 0xdb, 0xdf, 0xbe, 0xda, 0x4c, 0x02,
	0x29, 0x4e, 0xfd, 0x9b, 0xe9, 0xc6, 0xf7, 0xe3, 0x5b, 0xe9, 0x33, 0xf4, 0xe9, 0x6f, 0xb8, 0xe0,
	0x8b, 0x3d, 0x5f, 0x40, 0x21, 0x1c, 0x65, 0xe9, 0xcd, 0xe7, 0x7e, 0x05, 0xf6, 0x19, 0xc4, 0xf8,
	0xa1, 0x89, 0xd2, 0x43, 0x13, 0x3b, 0x3b, 0x95, 0xc2, 0x5f, 0x15, 0x65, 0x8e, 0xbd, 0x4a, 0xce,
	0xd5, 0x84, 0xb8, 0x77, 0x04, 0xd0, 0xc7, 0x70, 0x5d, 0xde, 0xdd, 0x68, 0x29, 0xdd, 0x5f, 0x6f,
	0xb7, 0x26, 0x12, 0xaf, 0x34, 0x24, 0x77, 0xbb, 0xed, 0x8d, 0xf6, 0xb7, 0xb5, 0x6e, 0xbb, 0xb3,
	0x25, 0x84, 0x48, 0x52, 0xf5, 0xac, 0x23, 0xff, 0x6a, 0xa3, 0x53, 0x6b, 0x0a, 0xe1, 0x5c, 0x0d,
	0x60, 0xb4, 0xb7, 0xe8, 0x13, 0xb8, 0xb9, 0xd9, 0xea, 0xca, 0xed, 0xc6, 0xfb, 0x34, 0x25, 0x60,
	0xe6, 0x49, 0x6d, 0xf7, 0x49, 0x4b, 0x08, 0x91, 0x2c, 0xad, 0xd1, 0xd9, 0xdd, 0xea, 0xb6, 0x64,
	0x21, 0x9c, 0xfd, 0x05, 0xc0, 0x28, 0x32, 0xa1, 0x5b, 0x10, 0x9d, 0xf4, 0xd7, 0x12, 0xbd, 0x23,
	0x14, 0x5d, 0x47, 0x00, 0xac, 0x58, 0x24, 0x67, 0x13, 0x45, 0xff, 0xf1, 0x9f, 0xa4, 0x50, 0xee,
	0x6f, 0xc2, 0x30, 0x17, 0x2c, 0xd7, 0x50, 0x09, 0xd2, 0xc4, 0x9b, 0x0f, 0x4d, 0xf5, 0x58, 0x35,
	0x7a, 0x24, 0xe1, 0x3b, 0xef, 0xfe, 0x53, 0x7d, 0xf5, 0xd5, 0xee, 0x88, 0x01, 0x89, 0x30, 0x47,
	0x64, 0xfc, 0x68, 0x1d, 0x3e, 0x1f, 0x2f, 0xd4, 0x57, 0x4d, 0x2f, 0x76, 0x73, 0x6e, 0x3f, 0x67,
	0x89, 0xbc, 0x8f, 0xbb, 0xe1, 0x65, 0x30, 0x05, 0x98, 0x27, 0xdc, 0xf8, 0xd5, 0x40, 0x35, 0x1d,
	0xe2, 0x81, 0x63, 0x93, 0xec, 0x44, 0x5b, 0xcb, 0x23, 0xa3, 0x0e, 0x08, 0x34, 0xc3, 0x09, 0x86,
	0x82, 0xd9, 0x0b, 0x85, 0x82, 0x62, 0x3f, 0x2f, 0x1d, 0xc9, 0x69, 0x2e, 0xed, 0xd1, 0x72, 0xbf,
	0x0f, 0x81, 0x30, 0x59, 0x72, 0xa2, 0x3d, 0x98, 0x21, 0xe1, 0xd1, 0xc9, 0x84, 0xe8, 0xbd, 0x58,
	0x9b, 0xb2, 0x74, 0x2d, 0x90, 0x20, 0xca, 0xbc, 0x22, 0xf1, 0xfc, 0x4c, 0x67, 0xf6, 0x2e, 0x44,
	0x09, 0x1e, 0xdd, 0x82, 0x59, 0x1a, 0x83, 0xbd, 0xd4, 0x97, 0x5f, 0xff, 0x18, 0x41, 0xb6, 0xf5,
	0xdc, 0xef, 0x00, 0x84, 0xc9, 0x16, 0x01, 0xfa, 0xc5, 0x78, 0xcb, 0x23, 0x14, 0x4c, 0xb9, 0x4b,
	0xcb, 0xd5, 0xf1, 0xee, 0xc7, 0x5f, 0x8d, 0xee, 0x77, 0x98, 0xce, 0xa3, 0x31, 0x65, 0x67, 0x62,
	0xec, 0x66, 0x2f, 0x7f, 0xff, 0x56, 0x8a, 0xae, 0x3d, 0xaa, 0x56, 0xfc, 0x44, 0xff, 0xc7, 0xb7,
	0x52, 0x2c, 0x1b, 0x95, 0xf2, 0xd5, 0xf2, 0x8f, 0x6f, 0xa5, 0x1b, 0x68, 0x91, 0xdc, 0xde, 0x17,
	0x7b, 0x79, 0xa5, 0xb0, 0xf4, 0xfc, 0x6b, 0x76, 0x81, 0x5f, 0xdc, 0xf7, 0xaf, 0xed, 0x5d, 0x48,
	0x12, 0x9d, 0x07, 0x96, 0xdd, 0x27, 0x33, 0x8f, 0x04, 0x66, 0x0e, 0x1e, 0xa1, 0xad, 0x23, 0x15,
	0x52, 0x36, 0x76, 0xac, 0xa1, 0x4d, 0x0b, 0x6e, 0x52, 0x97, 0xb2, 0x80, 0x5f, 0xb9, 0xe0, 0x14,
	0x64, 0x4f, 0x98, 0x94, 0xa0, 0x5c, 0xff, 0xbc, 0x1d, 0x44, 0xa2, 0xbf, 0x0e, 0x41, 0xbc, 0x8f,
	0x5d, 0x55, 0x57, 0x5d, 0x95, 0x3b, 0xc0, 0xd6, 0xb4, 0x0b, 0xb4, 0xc9, 0xf5, 0x8c, 0x96, 0x88,
	0x2d, 0xcd, 0x0f, 0x6f, 0xa5, 0xf8, 0xda, 0xa3, 0x52, 0xb5, 0x24, 0x55, 0x2a, 0x63, 0xcb, 0x84,
	0x90, 0xe0, 0x2d, 0x93, 0xbf, 0x44, 0xfe, 0x68, 0x90, 0x06, 0xa9, 0x7d, 0xcb, 0x72, 0x15, 0xdd,
	0x70, 0x5e, 0xb2, 0xd9, 0xc7, 0x2e, 0xd7, 0x43, 0x71, 0x5d, 0x55, 0x3b, 0xc2, 0x7a, 0xd3, 0x70,
	0x5e, 0x06, 0x16, 0x60, 0x8e, 0x28, 0xf5, 0x70, 0xc8, 0x86, 0x45, 0x07, 0x6b, 0x96, 0xa9, 0xab,
	0xf6, 0xc9, 0xc8, 0x92, 0x93, 0x99, 0xa5, 0x4b, 0x31, 0xb5, 0x29, 0x9e, 0x04, 0x94, 0x65, 0xe4,
	0x6b, 0xf7, 0x68, 0x0e, 0x7a, 0x0d, 0x37, 0x4d, 0xec, 0x7e, 0x67, 0xd9, 0x2f, 0x15, 0xc3, 0x74,
	0xb1, 0x7d, 0xa0, 0x6a, 0x98, 0x9b, 0x65, 0x19, 0xc8, 0x45, 0xcb, 0xfd, 0x2d, 0xa6, 0xa5, 0xed,
	0x29, 0xa1, 0xa6, 0x67, 0xbe, 0x7f, 0x2b, 0x85, 0x24, 0xf9, 0xba, 0xf9, 0x1e, 0x22, 0x6d, 0xd9,
	0x39, 0x64, 0xa4, 0xc3, 0x1e, 0x29, 0xc0, 0xc6, 0x3a, 0x5f, 0x0f, 0x2e, 0x1c, 0xf8, 0x3c, 0x79,
	0xaf, 0x37, 0xe5, 0x4c, 0x60, 0x7e, 0xa2, 0xdb, 0x01, 0x3f, 0xd1, 0xed, 0x50, 0x41, 0xf0, 0xd6,
	0xc3, 0xc1, 0x2e, 0xf1, 0x88, 0x0e, 0x6f, 0x63, 0x55, 0x2f, 0xb7, 0x10, 0x3b, 0x5c, 0x5a, 0x4e,
	0x9b, 0xe3, 0x08, 0x12, 0x35, 0x68, 0xee, 0x30, 0x37, 0x59, 0x9e, 0xb3, 0x26, 0xea, 0x5d, 0x88,
	0x1f, 0x59, 0x8e, 0x4b, 0x59, 0xe6, 0x27, 0x59, 0x7c, 0xd2, 0x15, 0xa2, 0x69, 0xf6, 0x21, 0xcc,
	0x8f, 0x5d, 0x8f, 0x4b, 0x85, 0xe2, 0xff, 0x0d, 0xc1, 0xfc, 0xd8, 0x5d, 0x46, 0xf7, 0x21, 0xd6,
	0xc7, 0x7d, 0xcb, 0x3e, 0xe1, 0x81, 0x0b, 0x9d, 0x9d, 0x4a, 0xa9, 0xb5, 0x47, 0x2b, 0xa5, 0x4a,
	0xb5, 0x5c, 0x7e, 0x50, 0x2a, 0xae, 0x94, 0x4b, 0x32, 0xe7, 0x40, 0xfb, 0x30, 0xa3, 0x59, 0x36,
	0x76, 0x78, 0xc8, 0xda, 0x38, 0x3b, 0x95, 0xd6, 0x25, 0xb1, 0x24, 0x56, 0xc4, 0xaa, 0xb8, 0x22,
	0x4a, 0x45, 0x51, 0x2a, 0x89, 0x52, 0x45, 0x94, 0xaa, 0xa2, 0xb4, 0x22, 0x96, 0x8a, 0x62, 0xa9,
	0x24, 0x96, 0x2a, 0x62, 0xa9, 0x2a, 0x96, 0x56, 0xc4, 0x72, 0x51, 0x2c, 0x97, 0xc4, 0x72, 0x45,
	0x2c, 0x57, 0xc5, 0x4a, 0x51, 0xac, 0x54, 0xc4, 0xca, 0x8a, 0xb8, 0x5c, 0x12, 0x97, 0xab, 0x62,
	0xb5, 0x28, 0x56, 0x2b, 0x32, 0x53, 0x8d, 0xaa, 0x30, 0x4f, 0x7e, 0x28, 0x07, 0xb6, 0xaa, 0xf9,
	0x25, 0x4f, 0xa4, 0xbe, 0x70, 0x76, 0x2a, 0xcd, 0x17, 0xc5, 0x65, 0xa2, 0x76, 0xb9, 0x28, 0xd2,
	0x48, 0x46, 0xf8, 0x1e, 0x73, 0x36, 0x74, 0x1b, 0xa2, 0x87, 0x83, 0xa1, 0xc3, 0x4a, 0xf0, 0x7a,
	0xf2, 0xec, 0x54, 0x9a, 0x2d, 0x8a, 0x74, 0x70, 0x32, 0x25, 0xe4, 0xfe, 0x27, 0x0a, 0xc2, 0xe4,
	0xed, 0x42, 0x4f, 0x21, 0xda, 0xb7, 0x74, 0x2f, 0xcf, 0x5d, 0x9b, 0xf2, 0x92, 0x16, 0x36, 0x2d,
	0xdd, 0x4b, 0x37, 0xa9, 0x3e, 0xf4, 0x90, 0x04, 0x16, 0x7a, 0x6a, 0xe9, 0x49, 0x60, 0xbd, 0x9c,
	0xec, 0xbb, 0x53, 0xe9, 0xc6, 0x9f, 0x4e, 0xf8, 0x29, 0x9a, 0xa9, 0xbd, 0x91, 0x81, 0xb1, 0xd3,
	0x44, 0x52, 0x83, 0xc4, 0xc8, 0x53, 0xb1, 0x8a, 0xef, 0xeb, 0x69, 0x47, 0x36, 0xe1, 0xb2, 0xe2,
	0xba, 0x37, 0xf3, 0x07, 0x30, 0x4b, 0x8d, 0x18, 0x3a, 0x7b, 0x04, 0xa8, 0x7f, 0xf6, 0xee, 0x54,
	0x5a, 0xd8, 0xcb, 0x07, 0x9a, 0x53, 0xbf, 0x7d, 0xc3, 0xba, 0x53, 0xec, 0xf0, 0xc6, 0x08, 0x7b,
	0x5b, 0xcf, 0xfe, 0x77, 0x08, 0xe2, 0xfe, 0xfa, 0x5d, 0x2a, 0x80, 0xde, 0x82, 0x59, 0x92, 0x4b,
	0xf9, 0x4f, 0x19, 0x5e, 0x84, 0x26, 0xc8, 0xb6, 0x8e, 0xf2, 0x3c, 0x1f, 0x63, 0x1b, 0xfe, 0xf1,
	0xd9, 0xa9, 0x74, 0xbd, 0x22, 0xad, 0x56, 0xca, 0xc5, 0x4a, 0xbe, 0x52, 0x5e, 0x5d, 0x29, 0x56,
	0xaa, 0xcb, 0x92, 0x24, 0x15, 0x2b, 0x2c, 0x3f, 0x23, 0x37, 0xcd, 0xe8, 0xab, 0x87, 0x78, 0x34,
	0x83, 0xf8, 0x0f, 0x34, 0x94, 0x2e, 0x17, 0xd7, 0x3f, 0x92, 0x67, 0x29, 0xad, 0xad, 0x93, 0x11,
	0x3a, 0xa6, 0x3a, 0x70, 0x8e, 0x2c, 0xea, 0x39, 0x66, 0xce, 0x71, 0x82, 0x47, 0x6e, 0xeb, 0xf5,
	0x14, 0xcc, 0xb1, 0xbb, 0xa1, 0x58, 0x26, 0xb6, 0x0e, 0x72, 0x0f, 0x21, 0x4a, 0xb6, 0x16, 0x2d,
	0x82, 0xb0, 0xd9, 0x69, 0x4e, 0xa6, 0x99, 0xf3, 0x90, 0x90, 0x5b, 0xb5, 0xa6, 0xd2, 0xd9, 0xda,
	0xf8, 0xb5, 0x10, 0x42, 0x29, 0x00, 0x0a, 0x3e, 0x93, 0xdb, 0xdd, 0x96, 0x10, 0xce, 0xfd, 0x47,
	0x18, 0x16, 0xdf, 0xe7, 0x57, 0xd1, 0x2d, 0x00, 0xdf, 0x6b, 0x7b, 0x7d, 0xba, 0x84, 0xe7, 0x64,
	0x75, 0x42, 0x76, 0x86, 0xfb, 0x26, 0x26, 0xe3, 0x65, 0xa9, 0x46, 0x42, 0x4e, 0x30, 0x4c, 0x5b,
	0x77, 0xd0, 0x00, 0x6e, 0x0e, 0x6c, 0xa3, 0x4f, 0xa2, 0xcc, 0x71, 0x45, 0x51, 0x75, 0xdd, 0xc6,
	0x8e, 0x13, 0x3c, 0x2b, 0xab, 0x17, 0x3c, 0x2b, 0xdb, 0x4c, 0x4b, 0x8d, 0x69, 0xa0, 0xdd, 0xe6,
	0x45, 0xae, 0xf9, 0x69, 0x25, 0x80, 0x1d, 0xb3, 0x58, 0x1d, 0xb7, 0x18, 0xfd, 0x83, 0x59, 0xac,
	0x06, 0x2d, 0x52, 0xaf, 0xaf, 0x0d, 0x6d, 0xc3, 0x3d, 0xf1, 0x1b, 0x9a, 0xac, 0xaa, 0xa2, 0x5e,
	0x9f, 0x51, 0x78, 0x4f, 0xd3, 0xc9, 0xbd, 0x06, 0x74, 0x5e, 0x33, 0xd2, 0xe1, 0x1a, 0x49, 0x07,
	0x5d, 0x8b, 0xec, 0xa5, 0x62, 0xaa, 0x2e, 0x1b, 0x71, 0xe8, 0x52, 0xe1, 0xa0, 0x63, 0xe2, 0xae,
	0xd5, 0x31, 0xf1, 0x96, 0xea, 0xd2, 0xe1, 0xa6, 0xad, 0x71, 0x44, 0x6e, 0x1f, 0xd2, 0x13, 0x3c,
	0xa8, 0x03, 0x60, 0x0c, 0x94, 0x63, 0x6c, 0x3b, 0xde, 0x95, 0x48, 0x95, 0x8a, 0x17, 0xcd, 0x84,
	0x06, 0x4f, 0x99, 0x9c, 0x9c, 0x30, 0xbc, 0x9f, 0xb9, 0x0a, 0x08, 0x93, 0x91, 0x12, 0xdd, 0x81,
	0xe4, 0xc0, 0xc6, 0xb8, 0x3f, 0x70, 0x0d, 0xaf, 0xe8, 0x88, 0xcb, 0x41, 0x54, 0xee, 0x9f, 0x43,
	0x90, 0x9e, 0x88, 0x66, 0xa8, 0x03, 0xd1, 0x40, 0x59, 0xff, 0x70, 0xba, 0x98, 0x58, 0x20, 0x05,
	0x98, 0x4c, 0x15, 0xe5, 0x7e, 0x03, 0x51, 0x5a, 0x8e, 0x2d, 0x82, 0xf0, 0x9e, 0x3a, 0x8c, 0xb5,
	0xd2, 0xb7, 0x9a, 0x35, 0xb9, 0x29, 0x84, 0x50, 0x06, 0x16, 0x77, 0x3a, 0x8f, 0xbb, 0xcf, 0x6a,
	0x72, 0x4b, 0xa9, 0x35, 0x1a, 0xad, 0x8d, 0x96, 0x5c, 0xeb, 0xb6, 0x9a, 0x42, 0x98, 0x50, 0xd6,
	0x6b, 0x72, 0xf3, 0x1c, 0x25, 0x92, 0x3b, 0x06, 0x61, 0xf2, 0xe5, 0x05, 0xed, 0xc3, 0xc2, 0x58,
	0xaf, 0x7b, 0x8a, 0x6d, 0xed, 0x8e, 0x9a, 0xe2, 0x6c, 0x5b, 0xdd, 0x71, 0x44, 0xee, 0xdf, 0xc2,
	0x90, 0x9e, 0x60, 0x42, 0x2b, 0x3c, 0xf2, 0x33, 0x27, 0xf7, 0xf9, 0xbb, 0x53, 0xe9, 0x0e, 0x73,
	0xe6, 0xf7, 0xa8, 0xd7, 0x2c, 0xe6, 0x57, 0x89, 0x33, 0xaf, 0x4a, 0x6f, 0xf6, 0x38, 0xf4, 0xc5,
	0x2f, 0x79, 0x52, 0x30, 0xe1, 0x25, 0xc3, 0x3f, 0xeb, 0x25, 0xff, 0x76, 0x54, 0x66, 0x44, 0x68,
	0x0e, 0x57, 0x9f, 0x6e, 0x52, 0x63, 0x55, 0xc6, 0x13, 0xfa, 0xf0, 0x30, 0x5e, 0x43, 0x04, 0x0a,
	0x0f, 0xf2, 0xbf, 0x7c, 0x99, 0xba, 0xe3, 0x2a, 0xed, 0x80, 0x3f, 0x0b, 0x81, 0x30, 0xf9, 0xce,
	0x85, 0xfa, 0xe3, 0x8f, 0x67, 0x3c, 0x89, 0x65, 0xf5, 0x62, 0xf5, 0xf2, 0x8f, 0x67, 0xa3, 0xd4,
	0x99, 0x54, 0x8a, 0xc1, 0x47, 0x34, 0x9a, 0xbc, 0xe6, 0xfe, 0x72, 0x06, 0xd2, 0x13, 0xec, 0xa8,
	0x0e, 0x71, 0x9a, 0x44, 0x1f, 0xab, 0x3d, 0x7e, 0x9c, 0x7e, 0xa6, 0x06, 0xa6, 0x09, 0x86, 0xe4,
	0xe4, 0xcb, 0xc5, 0xa2, 0x23, 0xfb, 0x72, 0xe8, 0x97, 0x30, 0xeb, 0x1a, 0x7d, 0x6c, 0x0d, 0x5d,
	0xde, 0xdc, 0xfe, 0x60, 0xef, 0xd3, 0xc9, 0x57, 0x8b, 0x8e, 0xec, 0x49, 0xa1, 0x36, 0x5c, 0x1b,
	0x9a, 0x6c, 0xb8, 0x27, 0x8a, 0x7b, 0x64, 0x63, 0xe7, 0xc8, 0xea, 0xe9, 0x3c, 0x26, 0x66, 0xce,
	0x4e, 0xa5, 0xc5, 0xa2, 0x58, 0x12, 0xcb, 0x62, 0x45, 0x5c, 0x16, 0xab, 0xe2, 0x03, 0x71, 0x45,
	0x5c, 0x15, 0xa5, 0xa2, 0x8c, 0x7c, 0xa1, 0xae, 0x27, 0x83, 0x5a, 0xb0, 0x70, 0x5e, 0x51, 0xf4,
	0x03, 0x8a, 0x84, 0x73, 0x6a, 0x74, 0x48, 0xba, 0xda, 0x40, 0xb1, 0xe8, 0xe9, 0x74, 0x78, 0x4b,
	0xb7, 0x36, 0xdd, 0x96, 0x14, 0xba, 0xda, 0xa0, 0xc3, 0x14, 0x91, 0xc8, 0xeb, 0xfa, 0x10, 0x3a,
	0x84, 0xb9, 0x23, 0xd7, 0x1d, 0x99, 0x61, 0x05, 0x5a, 0x7d, 0x4a, 0x33, 0xeb, 0xae, 0x1b, 0xb0,
	0x93, 0x3c, 0x1a, 0x81, 0xd9, 0x3c, 0xc0, 0x68, 0x10, 0x24, 0x6b, 0x1c, 0x58, 0xb6, 0xcb, 0x73,
	0x5f, 0xb6, 0xa9, 0xf9, 0xea, 0xf2, 0x72, 0x79, 0x59, 0xa6, 0x84, 0x6c, 0x1d, 0x92, 0x01, 0x65,
	0x1f, 0xe4, 0x47, 0x08, 0xa2, 0x03, 0xd5, 0x3d, 0xe2, 0xa7, 0x9e, 0xfe, 0xae, 0x7f, 0x0a, 0x8b,
	0x63, 0x67, 0x9b, 0xcf, 0x91, 0xf7, 0x94, 0xfe, 0x22, 0x06, 0xe9, 0x89, 0xb7, 0xb6, 0x73, 0x9f,
	0x81, 0xec, 0xfa, 0xaf, 0xb8, 0xac, 0x47, 0xfa, 0x68, 0xba, 0x67, 0xf2, 0xc9, 0x77, 0xdc, 0xdb,
	0x90, 0xf4, 0xbf, 0xba, 0xf0, 0x9a, 0x07, 0x32, 0x78, 0xa8, 0xb6, 0x4e, 0x66, 0x73, 0xf0, 0x27,
	0xba, 0xe9, 0x7d, 0x26, 0x42, 0x7e, 0xfb, 0x9f, 0x8e, 0xcc, 0x04, 0x3e, 0x1d, 0x39, 0xff, 0xac,
	0x18, 0x7b, 0xcf, 0xb3, 0x22, 0xba, 0x39, 0x6a, 0xd1, 0xcc, 0x52, 0x3a, 0x6f, 0xce, 0xa0, 0x03,
	0x40, 0xe7, 0xea, 0x58, 0xaf, 0x84, 0x7d, 0x30, 0x65, 0x09, 0x2b, 0x2f, 0x4c, 0xd6, 0xad, 0x0e,
	0x7a, 0x0c, 0x0b, 0x7c, 0x9c, 0xda, 0x91, 0x6a, 0x1e, 0xb2, 0x0f, 0x67, 0x12, 0x1f, 0xfc, 0x70,
	0x26, 0xcd, 0x84, 0x1a, 0x4c, 0xa6, 0xe6, 0xe6, 0xfe, 0x25, 0xfc, 0xc1, 0x67, 0xe4, 0xeb, 0xb0,
	0xd0, 0x90, 0x5b, 0xb5, 0x6e, 0x7b, 0xeb, 0x89, 0xd2, 0xde, 0x22, 0x61, 0xb0, 0xd1, 0x12, 0x92,
	0x04, 0xbd, 0xbb, 0xdd, 0x9c, 0x40, 0xcf, 0x11, 0xb4, 0xf7, 0x7e, 0x3c, 0x42, 0xcf, 0x13, 0xb4,
	0xf7, 0x16, 0x3d, 0x42, 0xa7, 0x18, 0x9a, 0x3d, 0x44, 0x8f, 0xd0, 0x69, 0x74, 0x0b, 0x3e, 0xae,
	0x3d, 0xab, 0xb5, 0x29, 0x37, 0x15, 0xdb, 0xdd, 0x56, 0x9a, 0xbb, 0x32, 0x6b, 0xa7, 0x0a, 0xe8,
	0x1a, 0xa4, 0x1b, 0xeb, 0xad, 0xc6, 0xaf, 0x08, 0x79, 0xbd, 0x55, 0xdb, 0xe8, 0xae, 0x0b, 0x0b,
	0x04, 0xd9, 0xd9, 0x6e, 0x6d, 0x11, 0x5c, 0x57, 0xae, 0x3d, 0x7e, 0xdc, 0x6e, 0x08, 0x08, 0x7d,
	0x0a, 0x19, 0x5f, 0xd1, 0xb3, 0x9a, 0xbc, 0x19, 0xd4, 0x73, 0x8d, 0xea, 0xd9, 0xe8, 0xec, 0x04,
	0x45, 0x16, 0x11, 0x82, 0x94, 0xbc, 0xbb, 0x45, 0xf5, 0xd4, 0x1a, 0xdd, 0xdd, 0xda, 0x86, 0x70,
	0x9d, 0x24, 0x05, 0x1e, 0xae, 0xb3, 0xdb, 0x6d, 0xd2, 0x90, 0x7e, 0x23, 0xf8, 0x6e, 0x7e, 0x93,
	0x00, 0x74, 0xde, 0xad, 0xa6, 0x90, 0xc9, 0xfd, 0x7d, 0x18, 0x84, 0xc9, 0x5d, 0x24, 0x71, 0xc4,
	0x20, 0xdb, 0xcf, 0x6f, 0x03, 0x03, 0xc8, 0xc9, 0xed, 0xab, 0x9a, 0x97, 0x8b, 0xf2, 0xdb, 0x06,
	0x7d, 0x55, 0xe3, 0x19, 0x20, 0xfa, 0x04, 0x12, 0x7e, 0x12, 0xcd, 0x0f, 0x76, 0xdc, 0xcb, 0xa1,
	0x91, 0x06, 0xe8, 0x7c, 0x0a, 0xcd, 0x73, 0xd9, 0xe5, 0xa9, 0x72, 0x59, 0x59, 0x98, 0xcc, 0x9c,
	0xc7, 0x8c, 0xf8, 0x59, 0x33, 0x77, 0x9f, 0x57, 0x35, 0xe2, 0x25, 0xcb, 0xb9, 0xdf, 0x85, 0x20,
	0x35, 0xce, 0x84, 0x32, 0x30, 0xeb, 0x19, 0x63, 0x4b, 0xe6, 0x81, 0xe8, 0x19, 0xa4, 0xc6, 0x33,
	0x62, 0x1e, 0xa3, 0x4a, 0x97, 0x4f, 0x86, 0xe5, 0x64, 0x20, 0x11, 0xce, 0xbd, 0x82, 0x64, 0x80,
	0xf6, 0x33, 0x23, 0x18, 0x4f, 0x8d, 0xc3, 0x57, 0x4f, 0x8d, 0x15, 0x48, 0x6c, 0x58, 0x87, 0x32,
	0xd6, 0x2c, 0x5b, 0x47, 0x2b, 0x90, 0xf0, 0xbf, 0xc0, 0xe3, 0x11, 0xfc, 0x67, 0x3f, 0x87, 0xf3,
	0x99, 0xc9, 0x88, 0xc7, 0xbf, 0x87, 0xf0, 0xc0, 0xfb, 0x0f, 0x21, 0xe1, 0x1b, 0x46, 0x59, 0xb8,
	0xd1, 0xde, 0x56, 0x9e, 0xb6, 0xe4, 0x9d, 0x76, 0x67, 0x6b, 0xe2, 0xbe, 0xc7, 0x21, 0xda, 0xde,
	0x7e, 0x5a, 0x11, 0x42, 0xfc, 0x57, 0x55, 0x08, 0xd7, 0xff, 0x3c, 0x04, 0x5f, 0x8c, 0x4d, 0x4e,
	0x1d, 0x18, 0x3f, 0x39, 0xc1, 0x6f, 0x9f, 0x1d, 0x1a, 0xee, 0xd1, 0x70, 0x9f, 0x30, 0x2c, 0x31,
	0xa9, 0x3c, 0xfb, 0xf0, 0xf0, 0xd0, 0xca, 0x1f, 0x62, 0x93, 0xce, 0x60, 0xe9, 0x42, 0x1f, 0x3d,
	0x3e, 0x1c, 0x83, 0xf6, 0x63, 0x54, 0xb4, 0xfc, 0xff, 0x01, 0x00, 0x00, 0xff, 0xff, 0x88, 0xf4,
	0xa1, 0xe4, 0x32, 0x29, 0x00, 0x00,
}
