// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/dataproc/v1/cluster_service.proto

package dataproc

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type GetClusterRequest struct {
	// ID of the Data Proc cluster.
	//
	// To get a cluster ID make a [ClusterService.List] request.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetClusterRequest) Reset()         { *m = GetClusterRequest{} }
func (m *GetClusterRequest) String() string { return proto.CompactTextString(m) }
func (*GetClusterRequest) ProtoMessage()    {}
func (*GetClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ad91aa83e9eb1c4, []int{0}
}

func (m *GetClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetClusterRequest.Unmarshal(m, b)
}
func (m *GetClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetClusterRequest.Marshal(b, m, deterministic)
}
func (m *GetClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetClusterRequest.Merge(m, src)
}
func (m *GetClusterRequest) XXX_Size() int {
	return xxx_messageInfo_GetClusterRequest.Size(m)
}
func (m *GetClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetClusterRequest proto.InternalMessageInfo

func (m *GetClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type ListClustersRequest struct {
	// ID of the folder to list clusters in.
	//
	// To get the folder ID make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListClustersResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set `page_token` to the
	// [ListClustersResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters clusters listed in the response.
	//
	// The expression must specify:
	// 1. The field name. Currently you can use filtering only on [Cluster.name] field.
	// 2. An operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.
	// 3. The value. Must be 3-63 characters long and match the regular expression `^[a-z][-a-z0-9]{1,61}[a-z0-9].
	// Example of a filter: `name=my-cluster`.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClustersRequest) Reset()         { *m = ListClustersRequest{} }
func (m *ListClustersRequest) String() string { return proto.CompactTextString(m) }
func (*ListClustersRequest) ProtoMessage()    {}
func (*ListClustersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ad91aa83e9eb1c4, []int{1}
}

func (m *ListClustersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClustersRequest.Unmarshal(m, b)
}
func (m *ListClustersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClustersRequest.Marshal(b, m, deterministic)
}
func (m *ListClustersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClustersRequest.Merge(m, src)
}
func (m *ListClustersRequest) XXX_Size() int {
	return xxx_messageInfo_ListClustersRequest.Size(m)
}
func (m *ListClustersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClustersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClustersRequest proto.InternalMessageInfo

func (m *ListClustersRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *ListClustersRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClustersRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListClustersRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListClustersResponse struct {
	// List of clusters in the specified folder.
	Clusters []*Cluster `protobuf:"bytes,1,rep,name=clusters,proto3" json:"clusters,omitempty"`
	// Token for getting the next page of the list. If the number of results is greater than
	// the specified [ListClustersRequest.page_size], use `next_page_token` as the value
	// for the [ListClustersRequest.page_token] parameter in the next list request.
	//
	// Each subsequent page will have its own `next_page_token` to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClustersResponse) Reset()         { *m = ListClustersResponse{} }
func (m *ListClustersResponse) String() string { return proto.CompactTextString(m) }
func (*ListClustersResponse) ProtoMessage()    {}
func (*ListClustersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ad91aa83e9eb1c4, []int{2}
}

func (m *ListClustersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClustersResponse.Unmarshal(m, b)
}
func (m *ListClustersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClustersResponse.Marshal(b, m, deterministic)
}
func (m *ListClustersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClustersResponse.Merge(m, src)
}
func (m *ListClustersResponse) XXX_Size() int {
	return xxx_messageInfo_ListClustersResponse.Size(m)
}
func (m *ListClustersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClustersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClustersResponse proto.InternalMessageInfo

func (m *ListClustersResponse) GetClusters() []*Cluster {
	if m != nil {
		return m.Clusters
	}
	return nil
}

func (m *ListClustersResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateSubclusterConfigSpec struct {
	// Name of the subcluster.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Role of the subcluster in the Data Proc cluster.
	Role Role `protobuf:"varint,2,opt,name=role,proto3,enum=yandex.cloud.dataproc.v1.Role" json:"role,omitempty"`
	// Resource configuration for hosts in the subcluster.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
	// ID of the VPC subnet used for hosts in the subcluster.
	SubnetId string `protobuf:"bytes,4,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Number of hosts in the subcluster.
	HostsCount           int64    `protobuf:"varint,5,opt,name=hosts_count,json=hostsCount,proto3" json:"hosts_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateSubclusterConfigSpec) Reset()         { *m = CreateSubclusterConfigSpec{} }
func (m *CreateSubclusterConfigSpec) String() string { return proto.CompactTextString(m) }
func (*CreateSubclusterConfigSpec) ProtoMessage()    {}
func (*CreateSubclusterConfigSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ad91aa83e9eb1c4, []int{3}
}

func (m *CreateSubclusterConfigSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateSubclusterConfigSpec.Unmarshal(m, b)
}
func (m *CreateSubclusterConfigSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateSubclusterConfigSpec.Marshal(b, m, deterministic)
}
func (m *CreateSubclusterConfigSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateSubclusterConfigSpec.Merge(m, src)
}
func (m *CreateSubclusterConfigSpec) XXX_Size() int {
	return xxx_messageInfo_CreateSubclusterConfigSpec.Size(m)
}
func (m *CreateSubclusterConfigSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateSubclusterConfigSpec.DiscardUnknown(m)
}

var xxx_messageInfo_CreateSubclusterConfigSpec proto.InternalMessageInfo

func (m *CreateSubclusterConfigSpec) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateSubclusterConfigSpec) GetRole() Role {
	if m != nil {
		return m.Role
	}
	return Role_ROLE_UNSPECIFIED
}

func (m *CreateSubclusterConfigSpec) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *CreateSubclusterConfigSpec) GetSubnetId() string {
	if m != nil {
		return m.SubnetId
	}
	return ""
}

func (m *CreateSubclusterConfigSpec) GetHostsCount() int64 {
	if m != nil {
		return m.HostsCount
	}
	return 0
}

type UpdateSubclusterConfigSpec struct {
	// ID of the subcluster to update.
	//
	// To get the subcluster ID make a [SubclusterService.List] request.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the subcluster.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Resource configuration for each host in the subcluster.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
	// Number of hosts in the subcluster.
	HostsCount           int64    `protobuf:"varint,4,opt,name=hosts_count,json=hostsCount,proto3" json:"hosts_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateSubclusterConfigSpec) Reset()         { *m = UpdateSubclusterConfigSpec{} }
func (m *UpdateSubclusterConfigSpec) String() string { return proto.CompactTextString(m) }
func (*UpdateSubclusterConfigSpec) ProtoMessage()    {}
func (*UpdateSubclusterConfigSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ad91aa83e9eb1c4, []int{4}
}

func (m *UpdateSubclusterConfigSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateSubclusterConfigSpec.Unmarshal(m, b)
}
func (m *UpdateSubclusterConfigSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateSubclusterConfigSpec.Marshal(b, m, deterministic)
}
func (m *UpdateSubclusterConfigSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateSubclusterConfigSpec.Merge(m, src)
}
func (m *UpdateSubclusterConfigSpec) XXX_Size() int {
	return xxx_messageInfo_UpdateSubclusterConfigSpec.Size(m)
}
func (m *UpdateSubclusterConfigSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateSubclusterConfigSpec.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateSubclusterConfigSpec proto.InternalMessageInfo

func (m *UpdateSubclusterConfigSpec) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *UpdateSubclusterConfigSpec) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateSubclusterConfigSpec) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *UpdateSubclusterConfigSpec) GetHostsCount() int64 {
	if m != nil {
		return m.HostsCount
	}
	return 0
}

type CreateClusterConfigSpec struct {
	// Version of the image for cluster provisioning.
	//
	// All available versions are listed in the [documentation](/docs/data-proc/concepts/image-versions).
	VersionId string `protobuf:"bytes,1,opt,name=version_id,json=versionId,proto3" json:"version_id,omitempty"`
	// Data Proc specific options.
	Hadoop *HadoopConfig `protobuf:"bytes,2,opt,name=hadoop,proto3" json:"hadoop,omitempty"`
	// Specification for creating subclusters.
	SubclustersSpec      []*CreateSubclusterConfigSpec `protobuf:"bytes,3,rep,name=subclusters_spec,json=subclustersSpec,proto3" json:"subclusters_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *CreateClusterConfigSpec) Reset()         { *m = CreateClusterConfigSpec{} }
func (m *CreateClusterConfigSpec) String() string { return proto.CompactTextString(m) }
func (*CreateClusterConfigSpec) ProtoMessage()    {}
func (*CreateClusterConfigSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ad91aa83e9eb1c4, []int{5}
}

func (m *CreateClusterConfigSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateClusterConfigSpec.Unmarshal(m, b)
}
func (m *CreateClusterConfigSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateClusterConfigSpec.Marshal(b, m, deterministic)
}
func (m *CreateClusterConfigSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateClusterConfigSpec.Merge(m, src)
}
func (m *CreateClusterConfigSpec) XXX_Size() int {
	return xxx_messageInfo_CreateClusterConfigSpec.Size(m)
}
func (m *CreateClusterConfigSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateClusterConfigSpec.DiscardUnknown(m)
}

var xxx_messageInfo_CreateClusterConfigSpec proto.InternalMessageInfo

func (m *CreateClusterConfigSpec) GetVersionId() string {
	if m != nil {
		return m.VersionId
	}
	return ""
}

func (m *CreateClusterConfigSpec) GetHadoop() *HadoopConfig {
	if m != nil {
		return m.Hadoop
	}
	return nil
}

func (m *CreateClusterConfigSpec) GetSubclustersSpec() []*CreateSubclusterConfigSpec {
	if m != nil {
		return m.SubclustersSpec
	}
	return nil
}

type UpdateClusterConfigSpec struct {
	// New configuration for subclusters in a cluster.
	SubclustersSpec      []*UpdateSubclusterConfigSpec `protobuf:"bytes,1,rep,name=subclusters_spec,json=subclustersSpec,proto3" json:"subclusters_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *UpdateClusterConfigSpec) Reset()         { *m = UpdateClusterConfigSpec{} }
func (m *UpdateClusterConfigSpec) String() string { return proto.CompactTextString(m) }
func (*UpdateClusterConfigSpec) ProtoMessage()    {}
func (*UpdateClusterConfigSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ad91aa83e9eb1c4, []int{6}
}

func (m *UpdateClusterConfigSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateClusterConfigSpec.Unmarshal(m, b)
}
func (m *UpdateClusterConfigSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateClusterConfigSpec.Marshal(b, m, deterministic)
}
func (m *UpdateClusterConfigSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateClusterConfigSpec.Merge(m, src)
}
func (m *UpdateClusterConfigSpec) XXX_Size() int {
	return xxx_messageInfo_UpdateClusterConfigSpec.Size(m)
}
func (m *UpdateClusterConfigSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateClusterConfigSpec.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateClusterConfigSpec proto.InternalMessageInfo

func (m *UpdateClusterConfigSpec) GetSubclustersSpec() []*UpdateSubclusterConfigSpec {
	if m != nil {
		return m.SubclustersSpec
	}
	return nil
}

type CreateClusterRequest struct {
	// ID of the folder to create a cluster in.
	//
	// To get a folder ID make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the cluster. The name must be unique within the folder.
	// The name can’t be changed after the Data Proc cluster is created.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the cluster.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Cluster labels as `key:value` pairs.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Configuration and resources for hosts that should be created with the cluster.
	ConfigSpec *CreateClusterConfigSpec `protobuf:"bytes,6,opt,name=config_spec,json=configSpec,proto3" json:"config_spec,omitempty"`
	// ID of the availability zone where the cluster should be placed.
	//
	// To get the list of available zones make a [yandex.cloud.compute.v1.ZoneService.List] request.
	ZoneId string `protobuf:"bytes,7,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// ID of the service account to be used by the Data Proc manager agent.
	ServiceAccountId string `protobuf:"bytes,8,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// Name of the Object Storage bucket to use for Data Proc jobs.
	Bucket               string   `protobuf:"bytes,9,opt,name=bucket,proto3" json:"bucket,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateClusterRequest) Reset()         { *m = CreateClusterRequest{} }
func (m *CreateClusterRequest) String() string { return proto.CompactTextString(m) }
func (*CreateClusterRequest) ProtoMessage()    {}
func (*CreateClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ad91aa83e9eb1c4, []int{7}
}

func (m *CreateClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateClusterRequest.Unmarshal(m, b)
}
func (m *CreateClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateClusterRequest.Marshal(b, m, deterministic)
}
func (m *CreateClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateClusterRequest.Merge(m, src)
}
func (m *CreateClusterRequest) XXX_Size() int {
	return xxx_messageInfo_CreateClusterRequest.Size(m)
}
func (m *CreateClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateClusterRequest proto.InternalMessageInfo

func (m *CreateClusterRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *CreateClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateClusterRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *CreateClusterRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *CreateClusterRequest) GetConfigSpec() *CreateClusterConfigSpec {
	if m != nil {
		return m.ConfigSpec
	}
	return nil
}

func (m *CreateClusterRequest) GetZoneId() string {
	if m != nil {
		return m.ZoneId
	}
	return ""
}

func (m *CreateClusterRequest) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

func (m *CreateClusterRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

type CreateClusterMetadata struct {
	// ID of the cluster that is being created.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateClusterMetadata) Reset()         { *m = CreateClusterMetadata{} }
func (m *CreateClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateClusterMetadata) ProtoMessage()    {}
func (*CreateClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ad91aa83e9eb1c4, []int{8}
}

func (m *CreateClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateClusterMetadata.Unmarshal(m, b)
}
func (m *CreateClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateClusterMetadata.Marshal(b, m, deterministic)
}
func (m *CreateClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateClusterMetadata.Merge(m, src)
}
func (m *CreateClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateClusterMetadata.Size(m)
}
func (m *CreateClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateClusterMetadata proto.InternalMessageInfo

func (m *CreateClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type UpdateClusterRequest struct {
	// ID of the cluster to update.
	//
	// To get the cluster ID, make a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Field mask that specifies which attributes of the cluster should be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// New description for the cluster.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// A new set of cluster labels as `key:value` pairs.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Configuration and resources for hosts that should be created with the Data Proc cluster.
	ConfigSpec *UpdateClusterConfigSpec `protobuf:"bytes,5,opt,name=config_spec,json=configSpec,proto3" json:"config_spec,omitempty"`
	// New name for the Data Proc cluster. The name must be unique within the folder.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the new service account to be used by the Data Proc manager agent.
	ServiceAccountId string `protobuf:"bytes,7,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// Name of the new Object Storage bucket to use for Data Proc jobs.
	Bucket string `protobuf:"bytes,8,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Timeout to gracefully decommission nodes. In seconds. Default value: 0
	DecommissionTimeout  int64    `protobuf:"varint,9,opt,name=decommission_timeout,json=decommissionTimeout,proto3" json:"decommission_timeout,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateClusterRequest) Reset()         { *m = UpdateClusterRequest{} }
func (m *UpdateClusterRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateClusterRequest) ProtoMessage()    {}
func (*UpdateClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ad91aa83e9eb1c4, []int{9}
}

func (m *UpdateClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateClusterRequest.Unmarshal(m, b)
}
func (m *UpdateClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateClusterRequest.Marshal(b, m, deterministic)
}
func (m *UpdateClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateClusterRequest.Merge(m, src)
}
func (m *UpdateClusterRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateClusterRequest.Size(m)
}
func (m *UpdateClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateClusterRequest proto.InternalMessageInfo

func (m *UpdateClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *UpdateClusterRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateClusterRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *UpdateClusterRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *UpdateClusterRequest) GetConfigSpec() *UpdateClusterConfigSpec {
	if m != nil {
		return m.ConfigSpec
	}
	return nil
}

func (m *UpdateClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateClusterRequest) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

func (m *UpdateClusterRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *UpdateClusterRequest) GetDecommissionTimeout() int64 {
	if m != nil {
		return m.DecommissionTimeout
	}
	return 0
}

type UpdateClusterMetadata struct {
	// ID of the cluster that is being updated.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateClusterMetadata) Reset()         { *m = UpdateClusterMetadata{} }
func (m *UpdateClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateClusterMetadata) ProtoMessage()    {}
func (*UpdateClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ad91aa83e9eb1c4, []int{10}
}

func (m *UpdateClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateClusterMetadata.Unmarshal(m, b)
}
func (m *UpdateClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateClusterMetadata.Marshal(b, m, deterministic)
}
func (m *UpdateClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateClusterMetadata.Merge(m, src)
}
func (m *UpdateClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateClusterMetadata.Size(m)
}
func (m *UpdateClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateClusterMetadata proto.InternalMessageInfo

func (m *UpdateClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type DeleteClusterRequest struct {
	// ID of the cluster to delete.
	//
	// To get a cluster ID, make a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Timeout to gracefully decommission nodes. In seconds. Default value: 0
	DecommissionTimeout  int64    `protobuf:"varint,2,opt,name=decommission_timeout,json=decommissionTimeout,proto3" json:"decommission_timeout,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClusterRequest) Reset()         { *m = DeleteClusterRequest{} }
func (m *DeleteClusterRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteClusterRequest) ProtoMessage()    {}
func (*DeleteClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ad91aa83e9eb1c4, []int{11}
}

func (m *DeleteClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClusterRequest.Unmarshal(m, b)
}
func (m *DeleteClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClusterRequest.Marshal(b, m, deterministic)
}
func (m *DeleteClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClusterRequest.Merge(m, src)
}
func (m *DeleteClusterRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteClusterRequest.Size(m)
}
func (m *DeleteClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClusterRequest proto.InternalMessageInfo

func (m *DeleteClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *DeleteClusterRequest) GetDecommissionTimeout() int64 {
	if m != nil {
		return m.DecommissionTimeout
	}
	return 0
}

type DeleteClusterMetadata struct {
	// ID of the Data Proc cluster that is being deleted.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClusterMetadata) Reset()         { *m = DeleteClusterMetadata{} }
func (m *DeleteClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteClusterMetadata) ProtoMessage()    {}
func (*DeleteClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ad91aa83e9eb1c4, []int{12}
}

func (m *DeleteClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClusterMetadata.Unmarshal(m, b)
}
func (m *DeleteClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClusterMetadata.Marshal(b, m, deterministic)
}
func (m *DeleteClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClusterMetadata.Merge(m, src)
}
func (m *DeleteClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteClusterMetadata.Size(m)
}
func (m *DeleteClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClusterMetadata proto.InternalMessageInfo

func (m *DeleteClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type StartClusterRequest struct {
	// ID of the cluster to start.
	//
	// To get a cluster ID, make a [ClusterService.List] request.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartClusterRequest) Reset()         { *m = StartClusterRequest{} }
func (m *StartClusterRequest) String() string { return proto.CompactTextString(m) }
func (*StartClusterRequest) ProtoMessage()    {}
func (*StartClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ad91aa83e9eb1c4, []int{13}
}

func (m *StartClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartClusterRequest.Unmarshal(m, b)
}
func (m *StartClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartClusterRequest.Marshal(b, m, deterministic)
}
func (m *StartClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartClusterRequest.Merge(m, src)
}
func (m *StartClusterRequest) XXX_Size() int {
	return xxx_messageInfo_StartClusterRequest.Size(m)
}
func (m *StartClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StartClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StartClusterRequest proto.InternalMessageInfo

func (m *StartClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type StartClusterMetadata struct {
	// ID of the Data Proc cluster that is being started.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartClusterMetadata) Reset()         { *m = StartClusterMetadata{} }
func (m *StartClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*StartClusterMetadata) ProtoMessage()    {}
func (*StartClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ad91aa83e9eb1c4, []int{14}
}

func (m *StartClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartClusterMetadata.Unmarshal(m, b)
}
func (m *StartClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartClusterMetadata.Marshal(b, m, deterministic)
}
func (m *StartClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartClusterMetadata.Merge(m, src)
}
func (m *StartClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_StartClusterMetadata.Size(m)
}
func (m *StartClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_StartClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_StartClusterMetadata proto.InternalMessageInfo

func (m *StartClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type StopClusterRequest struct {
	// ID of the cluster to stop.
	//
	// To get a cluster ID, make a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Timeout to gracefully decommission nodes. In seconds. Default value: 0
	DecommissionTimeout  int64    `protobuf:"varint,2,opt,name=decommission_timeout,json=decommissionTimeout,proto3" json:"decommission_timeout,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StopClusterRequest) Reset()         { *m = StopClusterRequest{} }
func (m *StopClusterRequest) String() string { return proto.CompactTextString(m) }
func (*StopClusterRequest) ProtoMessage()    {}
func (*StopClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ad91aa83e9eb1c4, []int{15}
}

func (m *StopClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StopClusterRequest.Unmarshal(m, b)
}
func (m *StopClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StopClusterRequest.Marshal(b, m, deterministic)
}
func (m *StopClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StopClusterRequest.Merge(m, src)
}
func (m *StopClusterRequest) XXX_Size() int {
	return xxx_messageInfo_StopClusterRequest.Size(m)
}
func (m *StopClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StopClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StopClusterRequest proto.InternalMessageInfo

func (m *StopClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *StopClusterRequest) GetDecommissionTimeout() int64 {
	if m != nil {
		return m.DecommissionTimeout
	}
	return 0
}

type StopClusterMetadata struct {
	// ID of the Data Proc cluster that is being stopped.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StopClusterMetadata) Reset()         { *m = StopClusterMetadata{} }
func (m *StopClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*StopClusterMetadata) ProtoMessage()    {}
func (*StopClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ad91aa83e9eb1c4, []int{16}
}

func (m *StopClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StopClusterMetadata.Unmarshal(m, b)
}
func (m *StopClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StopClusterMetadata.Marshal(b, m, deterministic)
}
func (m *StopClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StopClusterMetadata.Merge(m, src)
}
func (m *StopClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_StopClusterMetadata.Size(m)
}
func (m *StopClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_StopClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_StopClusterMetadata proto.InternalMessageInfo

func (m *StopClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type ListClusterOperationsRequest struct {
	// ID of the cluster to list operations for.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListClusterOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListClusterOperationsResponse.next_page_token] returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterOperationsRequest) Reset()         { *m = ListClusterOperationsRequest{} }
func (m *ListClusterOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListClusterOperationsRequest) ProtoMessage()    {}
func (*ListClusterOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ad91aa83e9eb1c4, []int{17}
}

func (m *ListClusterOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterOperationsRequest.Unmarshal(m, b)
}
func (m *ListClusterOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterOperationsRequest.Marshal(b, m, deterministic)
}
func (m *ListClusterOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterOperationsRequest.Merge(m, src)
}
func (m *ListClusterOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListClusterOperationsRequest.Size(m)
}
func (m *ListClusterOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterOperationsRequest proto.InternalMessageInfo

func (m *ListClusterOperationsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListClusterOperationsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClusterOperationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListClusterOperationsResponse struct {
	// List of operations for the specified cluster.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// Token for getting the next page of the list. If the number of results is greater than
	// the specified [ListClusterOperationsRequest.page_size], use `next_page_token` as the value
	// for the [ListClusterOperationsRequest.page_token] parameter in the next list request.
	//
	// Each subsequent page will have its own `next_page_token` to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterOperationsResponse) Reset()         { *m = ListClusterOperationsResponse{} }
func (m *ListClusterOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListClusterOperationsResponse) ProtoMessage()    {}
func (*ListClusterOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ad91aa83e9eb1c4, []int{18}
}

func (m *ListClusterOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterOperationsResponse.Unmarshal(m, b)
}
func (m *ListClusterOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterOperationsResponse.Marshal(b, m, deterministic)
}
func (m *ListClusterOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterOperationsResponse.Merge(m, src)
}
func (m *ListClusterOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListClusterOperationsResponse.Size(m)
}
func (m *ListClusterOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterOperationsResponse proto.InternalMessageInfo

func (m *ListClusterOperationsResponse) GetOperations() []*operation.Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListClusterOperationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type ListClusterHostsRequest struct {
	// ID of the cluster to list hosts for.
	//
	// To get a cluster ID, make a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListClusterHostsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListClusterHostsResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters hosts listed in the response.
	//
	// The expression must specify:
	// 1. The field name. Currently you can use filtering only on [Cluster.name] field.
	// 2. An operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.
	// 3. The value. Must be 3-63 characters long and match the regular expression `^[a-z][-a-z0-9]{1,61}[a-z0-9].
	// Example of a filter: `name=my-host`
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterHostsRequest) Reset()         { *m = ListClusterHostsRequest{} }
func (m *ListClusterHostsRequest) String() string { return proto.CompactTextString(m) }
func (*ListClusterHostsRequest) ProtoMessage()    {}
func (*ListClusterHostsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ad91aa83e9eb1c4, []int{19}
}

func (m *ListClusterHostsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterHostsRequest.Unmarshal(m, b)
}
func (m *ListClusterHostsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterHostsRequest.Marshal(b, m, deterministic)
}
func (m *ListClusterHostsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterHostsRequest.Merge(m, src)
}
func (m *ListClusterHostsRequest) XXX_Size() int {
	return xxx_messageInfo_ListClusterHostsRequest.Size(m)
}
func (m *ListClusterHostsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterHostsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterHostsRequest proto.InternalMessageInfo

func (m *ListClusterHostsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListClusterHostsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClusterHostsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListClusterHostsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListClusterHostsResponse struct {
	// Requested list of hosts.
	Hosts []*Host `protobuf:"bytes,1,rep,name=hosts,proto3" json:"hosts,omitempty"`
	// Token for getting the next page of the list. If the number of results is greater than
	// the specified [ListClusterHostsRequest.page_size], use `next_page_token` as the value
	// for the [ListClusterHostsRequest.page_token] parameter in the next list request.
	//
	// Each subsequent page will have its own `next_page_token` to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterHostsResponse) Reset()         { *m = ListClusterHostsResponse{} }
func (m *ListClusterHostsResponse) String() string { return proto.CompactTextString(m) }
func (*ListClusterHostsResponse) ProtoMessage()    {}
func (*ListClusterHostsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4ad91aa83e9eb1c4, []int{20}
}

func (m *ListClusterHostsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterHostsResponse.Unmarshal(m, b)
}
func (m *ListClusterHostsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterHostsResponse.Marshal(b, m, deterministic)
}
func (m *ListClusterHostsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterHostsResponse.Merge(m, src)
}
func (m *ListClusterHostsResponse) XXX_Size() int {
	return xxx_messageInfo_ListClusterHostsResponse.Size(m)
}
func (m *ListClusterHostsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterHostsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterHostsResponse proto.InternalMessageInfo

func (m *ListClusterHostsResponse) GetHosts() []*Host {
	if m != nil {
		return m.Hosts
	}
	return nil
}

func (m *ListClusterHostsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*GetClusterRequest)(nil), "yandex.cloud.dataproc.v1.GetClusterRequest")
	proto.RegisterType((*ListClustersRequest)(nil), "yandex.cloud.dataproc.v1.ListClustersRequest")
	proto.RegisterType((*ListClustersResponse)(nil), "yandex.cloud.dataproc.v1.ListClustersResponse")
	proto.RegisterType((*CreateSubclusterConfigSpec)(nil), "yandex.cloud.dataproc.v1.CreateSubclusterConfigSpec")
	proto.RegisterType((*UpdateSubclusterConfigSpec)(nil), "yandex.cloud.dataproc.v1.UpdateSubclusterConfigSpec")
	proto.RegisterType((*CreateClusterConfigSpec)(nil), "yandex.cloud.dataproc.v1.CreateClusterConfigSpec")
	proto.RegisterType((*UpdateClusterConfigSpec)(nil), "yandex.cloud.dataproc.v1.UpdateClusterConfigSpec")
	proto.RegisterType((*CreateClusterRequest)(nil), "yandex.cloud.dataproc.v1.CreateClusterRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.dataproc.v1.CreateClusterRequest.LabelsEntry")
	proto.RegisterType((*CreateClusterMetadata)(nil), "yandex.cloud.dataproc.v1.CreateClusterMetadata")
	proto.RegisterType((*UpdateClusterRequest)(nil), "yandex.cloud.dataproc.v1.UpdateClusterRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.dataproc.v1.UpdateClusterRequest.LabelsEntry")
	proto.RegisterType((*UpdateClusterMetadata)(nil), "yandex.cloud.dataproc.v1.UpdateClusterMetadata")
	proto.RegisterType((*DeleteClusterRequest)(nil), "yandex.cloud.dataproc.v1.DeleteClusterRequest")
	proto.RegisterType((*DeleteClusterMetadata)(nil), "yandex.cloud.dataproc.v1.DeleteClusterMetadata")
	proto.RegisterType((*StartClusterRequest)(nil), "yandex.cloud.dataproc.v1.StartClusterRequest")
	proto.RegisterType((*StartClusterMetadata)(nil), "yandex.cloud.dataproc.v1.StartClusterMetadata")
	proto.RegisterType((*StopClusterRequest)(nil), "yandex.cloud.dataproc.v1.StopClusterRequest")
	proto.RegisterType((*StopClusterMetadata)(nil), "yandex.cloud.dataproc.v1.StopClusterMetadata")
	proto.RegisterType((*ListClusterOperationsRequest)(nil), "yandex.cloud.dataproc.v1.ListClusterOperationsRequest")
	proto.RegisterType((*ListClusterOperationsResponse)(nil), "yandex.cloud.dataproc.v1.ListClusterOperationsResponse")
	proto.RegisterType((*ListClusterHostsRequest)(nil), "yandex.cloud.dataproc.v1.ListClusterHostsRequest")
	proto.RegisterType((*ListClusterHostsResponse)(nil), "yandex.cloud.dataproc.v1.ListClusterHostsResponse")
}

func init() {
	proto.RegisterFile("yandex/cloud/dataproc/v1/cluster_service.proto", fileDescriptor_4ad91aa83e9eb1c4)
}

var fileDescriptor_4ad91aa83e9eb1c4 = []byte{
	// 1549 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x58, 0x4d, 0x4c, 0xdc, 0xd6,
	0x16, 0x96, 0x67, 0x86, 0x81, 0x39, 0xf3, 0x1e, 0xe1, 0xdd, 0x90, 0xc7, 0x68, 0x14, 0xf2, 0x88,
	0x5f, 0x13, 0xc8, 0x84, 0xf1, 0x8c, 0x27, 0x40, 0xf3, 0x47, 0xda, 0x40, 0xd2, 0x04, 0x29, 0x51,
	0x5b, 0x93, 0x4a, 0x55, 0x69, 0x34, 0x32, 0xf6, 0x85, 0x58, 0x0c, 0xbe, 0xae, 0xed, 0x41, 0x81,
	0x34, 0x8b, 0xa4, 0x5d, 0xd1, 0x65, 0xf6, 0x95, 0x2a, 0x75, 0xdb, 0x54, 0x62, 0xd3, 0x66, 0xdd,
	0x05, 0x2c, 0x2b, 0xba, 0xea, 0xbe, 0x8b, 0xee, 0x2a, 0x65, 0x99, 0x55, 0x75, 0x7f, 0x66, 0xc6,
	0x06, 0x7b, 0x30, 0xa4, 0x51, 0x76, 0xb6, 0xcf, 0xcf, 0xfd, 0xce, 0x39, 0xdf, 0xbd, 0xe7, 0x5c,
	0x83, 0xb2, 0xae, 0xdb, 0x26, 0x7e, 0x58, 0x31, 0x1a, 0xa4, 0x69, 0x56, 0x4c, 0xdd, 0xd7, 0x1d,
	0x97, 0x18, 0x95, 0x35, 0xb5, 0x62, 0x34, 0x9a, 0x9e, 0x8f, 0xdd, 0xba, 0x87, 0xdd, 0x35, 0xcb,
	0xc0, 0x8a, 0xe3, 0x12, 0x9f, 0xa0, 0x02, 0xd7, 0x57, 0x98, 0xbe, 0xd2, 0xd2, 0x57, 0xd6, 0xd4,
	0xe2, 0xc9, 0x65, 0x42, 0x96, 0x1b, 0xb8, 0xa2, 0x3b, 0x56, 0x45, 0xb7, 0x6d, 0xe2, 0xeb, 0xbe,
	0x45, 0x6c, 0x8f, 0xdb, 0x15, 0x47, 0x84, 0x94, 0xbd, 0x2d, 0x36, 0x97, 0x2a, 0x4b, 0x16, 0x6e,
	0x98, 0xf5, 0x55, 0xdd, 0x5b, 0x11, 0x1a, 0x67, 0xe2, 0x91, 0x90, 0xd5, 0x55, 0x62, 0x0b, 0xb5,
	0xb3, 0x07, 0x01, 0x16, 0x7a, 0xe7, 0x62, 0xf5, 0xbc, 0xe6, 0x62, 0x58, 0x35, 0xec, 0x92, 0x38,
	0xd8, 0x65, 0xd0, 0x3b, 0x4f, 0x42, 0x6f, 0x38, 0xa4, 0xb7, 0xa6, 0x37, 0x2c, 0x33, 0x28, 0x1e,
	0x09, 0x89, 0x69, 0x1a, 0xf6, 0x38, 0x90, 0xdf, 0x87, 0xff, 0xdc, 0xc2, 0xfe, 0x2c, 0x5f, 0x5c,
	0xc3, 0x5f, 0x34, 0xb1, 0xe7, 0xa3, 0xf3, 0x00, 0xad, 0x54, 0x5b, 0x66, 0x41, 0x1a, 0x91, 0xc6,
	0x72, 0x33, 0xff, 0xfa, 0x73, 0x5b, 0x95, 0x36, 0x77, 0xd4, 0xcc, 0xd5, 0xe9, 0xc9, 0xaa, 0x96,
	0x13, 0xf2, 0x39, 0x53, 0xfe, 0x49, 0x82, 0xe3, 0x77, 0x2c, 0xaf, 0xe5, 0xc3, 0x6b, 0x39, 0x39,
	0x07, 0xb9, 0x25, 0xd2, 0x30, 0xe3, 0x7d, 0xf4, 0x71, 0xf1, 0x9c, 0x89, 0x46, 0x21, 0xe7, 0xe8,
	0xcb, 0xb8, 0xee, 0x59, 0x1b, 0xb8, 0x90, 0x1a, 0x91, 0xc6, 0xd2, 0x33, 0xf0, 0x6a, 0x5b, 0xcd,
	0x5e, 0x9d, 0x56, 0xab, 0xd5, 0xaa, 0xd6, 0x47, 0x85, 0xf3, 0xd6, 0x06, 0x46, 0x63, 0x00, 0x4c,
	0xd1, 0x27, 0x2b, 0xd8, 0x2e, 0xa4, 0x99, 0xd3, 0xdc, 0xe6, 0x8e, 0xda, 0xc3, 0x34, 0x35, 0xe6,
	0xe5, 0x1e, 0x95, 0x21, 0x19, 0xb2, 0x4b, 0x56, 0xc3, 0xc7, 0x6e, 0x21, 0xc3, 0xb4, 0x60, 0x73,
	0xa7, 0xed, 0x4f, 0x48, 0xe4, 0xc7, 0x30, 0x18, 0x06, 0xee, 0x39, 0xc4, 0xf6, 0x30, 0x9a, 0x86,
	0x3e, 0x11, 0x9e, 0x57, 0x90, 0x46, 0xd2, 0x63, 0xf9, 0xda, 0x69, 0x25, 0x8e, 0x63, 0x4a, 0x2b,
	0x75, 0x6d, 0x13, 0x74, 0x16, 0x8e, 0xd9, 0xf8, 0xa1, 0x5f, 0x0f, 0x20, 0xa5, 0x31, 0xe5, 0xb4,
	0x7f, 0xd3, 0xcf, 0x1f, 0xb5, 0x20, 0xca, 0x3f, 0xa6, 0xa0, 0x38, 0xeb, 0x62, 0xdd, 0xc7, 0xf3,
	0xed, 0xf2, 0xcf, 0x12, 0x7b, 0xc9, 0x5a, 0x9e, 0x77, 0xb0, 0x81, 0x26, 0x21, 0x63, 0xeb, 0xab,
	0x58, 0xa4, 0xee, 0xf4, 0xcb, 0x6d, 0x75, 0xf8, 0xcb, 0x05, 0xbd, 0xbc, 0x71, 0x7f, 0xa1, 0xac,
	0x97, 0x37, 0xaa, 0xe5, 0x4b, 0xf7, 0x1f, 0xa9, 0xe3, 0x53, 0xea, 0xe3, 0x05, 0xf1, 0xa6, 0x31,
	0x75, 0x74, 0x11, 0x32, 0x2e, 0x69, 0xf0, 0x34, 0xf6, 0xd7, 0x4e, 0xc5, 0x03, 0xd7, 0x48, 0x03,
	0xcf, 0x64, 0x68, 0x45, 0x34, 0x66, 0x81, 0x6e, 0x41, 0xce, 0xc5, 0x1e, 0x69, 0xba, 0x06, 0xf6,
	0x58, 0x6e, 0xf3, 0xb5, 0xff, 0x77, 0x31, 0x6f, 0xa9, 0x0a, 0x1f, 0x1d, 0x5b, 0x5a, 0x79, 0xaf,
	0xb9, 0x68, 0x63, 0x9f, 0x56, 0x3e, 0x13, 0x55, 0x79, 0x2e, 0x9e, 0x33, 0xd1, 0x38, 0xe4, 0x1f,
	0x10, 0xcf, 0xf7, 0xea, 0x06, 0x69, 0xda, 0x7e, 0xa1, 0x87, 0xd5, 0x3e, 0x4f, 0x95, 0x5f, 0x6d,
	0xab, 0xe9, 0x6b, 0xd3, 0xaa, 0x06, 0x4c, 0x3e, 0x4b, 0xc5, 0xf2, 0xaf, 0x12, 0x14, 0x3f, 0x71,
	0xcc, 0xb8, 0x8c, 0xf5, 0x43, 0xaa, 0x45, 0x35, 0x2d, 0x65, 0x99, 0xed, 0x0c, 0xa6, 0x0e, 0x97,
	0xc1, 0xeb, 0x47, 0xcb, 0x43, 0x30, 0x03, 0x63, 0xe1, 0xb0, 0x32, 0x2c, 0xac, 0xde, 0xa8, 0x90,
	0x7e, 0x97, 0x60, 0x88, 0x93, 0x60, 0x76, 0x5f, 0x3c, 0xc3, 0x00, 0x6b, 0xd8, 0xf5, 0x2c, 0x62,
	0xb7, 0xb7, 0x90, 0x96, 0x13, 0x5f, 0xe6, 0x4c, 0x74, 0x0d, 0xb2, 0x0f, 0x74, 0x93, 0x10, 0x87,
	0x05, 0x98, 0xaf, 0x9d, 0x8d, 0x07, 0x79, 0x9b, 0xe9, 0x71, 0xd7, 0x9a, 0xb0, 0x42, 0x75, 0x18,
	0xe8, 0x9c, 0x3b, 0x5e, 0xdd, 0x73, 0xb0, 0x51, 0x48, 0x33, 0xba, 0x4f, 0x74, 0xa1, 0x7b, 0x2c,
	0x61, 0xb5, 0x63, 0x01, 0x6f, 0xf4, 0x83, 0xbc, 0x01, 0x43, 0xbc, 0x5a, 0xfb, 0x43, 0x8b, 0x5a,
	0x5b, 0x3a, 0x68, 0xed, 0xf8, 0xd2, 0xef, 0x5f, 0xfb, 0x97, 0x0c, 0x0c, 0x86, 0xf2, 0x7a, 0x84,
	0x63, 0xe9, 0x88, 0xfc, 0x39, 0x0f, 0x79, 0x13, 0x7b, 0x86, 0x6b, 0x39, 0xf4, 0x9c, 0x0d, 0x9f,
	0x52, 0xb5, 0xc9, 0x29, 0x2d, 0x28, 0x45, 0xcf, 0x24, 0xc8, 0x36, 0xf4, 0x45, 0xdc, 0xf0, 0x0a,
	0x19, 0x16, 0xff, 0xe5, 0x83, 0x72, 0x1f, 0x8e, 0x47, 0xb9, 0xc3, 0x8c, 0x6f, 0xda, 0xbe, 0xbb,
	0x3e, 0xf3, 0xde, 0xcb, 0x6d, 0x35, 0xbf, 0x50, 0xae, 0x57, 0xcb, 0x97, 0x28, 0xcc, 0xd2, 0x53,
	0x16, 0xd3, 0xd4, 0x04, 0x8f, 0x6d, 0xea, 0xc2, 0xd6, 0x8e, 0x9a, 0x2d, 0x66, 0xd4, 0x32, 0x7b,
	0x42, 0x68, 0x40, 0x04, 0xd3, 0xd6, 0xd7, 0x04, 0x14, 0xf4, 0x29, 0xe4, 0x0d, 0x96, 0x5c, 0x5e,
	0x99, 0x2c, 0xe3, 0x97, 0x9a, 0x10, 0x59, 0xa7, 0x2c, 0xe2, 0x68, 0x00, 0xa3, 0x53, 0xf8, 0x33,
	0xd0, 0xbb, 0x41, 0x6c, 0x4c, 0x93, 0xdf, 0x1b, 0x91, 0xfc, 0x2c, 0x15, 0xce, 0x99, 0xa8, 0x06,
	0x48, 0x34, 0xf9, 0xba, 0x6e, 0xb0, 0x4d, 0x44, 0x2d, 0xfa, 0x98, 0x05, 0x77, 0x3a, 0x20, 0xe4,
	0xd7, 0xb9, 0x78, 0xce, 0x44, 0xff, 0x85, 0xec, 0x62, 0xd3, 0x58, 0xc1, 0x7e, 0x21, 0xc7, 0xb6,
	0x8a, 0x78, 0x2b, 0x5e, 0x82, 0x7c, 0x20, 0x49, 0x68, 0x00, 0xd2, 0x2b, 0x78, 0x5d, 0x6c, 0x27,
	0xfa, 0x88, 0x06, 0xa1, 0x67, 0x4d, 0x6f, 0x34, 0x45, 0xa1, 0x35, 0xfe, 0x72, 0x39, 0x75, 0x51,
	0x92, 0xa7, 0xe0, 0x44, 0x28, 0xb4, 0xbb, 0xd8, 0xd7, 0x69, 0xdc, 0x74, 0x6b, 0xee, 0xed, 0x90,
	0xc1, 0x9e, 0xf8, 0x4d, 0x0f, 0x0c, 0x86, 0xa8, 0xdf, 0x62, 0xdf, 0x68, 0x44, 0x67, 0xed, 0x8b,
	0xe8, 0xaa, 0xe8, 0x0a, 0xe4, 0x9b, 0xcc, 0x01, 0x9b, 0x47, 0xc4, 0x0e, 0x2f, 0x2a, 0x7c, 0x64,
	0x51, 0x5a, 0x23, 0x8b, 0xf2, 0x01, 0x1d, 0x59, 0xee, 0xea, 0xde, 0x8a, 0x06, 0x5c, 0x9d, 0x3e,
	0xbf, 0x39, 0x06, 0x46, 0xc5, 0xf4, 0x66, 0x18, 0xa8, 0x85, 0x19, 0xd8, 0x73, 0x10, 0x03, 0x63,
	0x0e, 0x9a, 0x10, 0xf7, 0x5a, 0xfb, 0x39, 0x7b, 0xb8, 0xfd, 0x3c, 0x1e, 0xc9, 0x45, 0xc6, 0xde,
	0xae, 0x2c, 0xec, 0x0b, 0xb2, 0x10, 0x5d, 0x83, 0x41, 0x13, 0xd3, 0xb1, 0xd1, 0xf2, 0xd8, 0x89,
	0xee, 0x5b, 0xab, 0x98, 0x34, 0x39, 0x57, 0xd3, 0x33, 0xf9, 0x57, 0xdb, 0x6a, 0x6f, 0xb5, 0x7c,
	0x71, 0x6a, 0xa2, 0x5a, 0xd5, 0x8e, 0x07, 0x15, 0xef, 0x71, 0xbd, 0xd7, 0x64, 0x71, 0x28, 0x3d,
	0x49, 0x59, 0xfc, 0x95, 0x04, 0x83, 0x37, 0x70, 0x03, 0xef, 0x63, 0xf1, 0x61, 0xe6, 0xc3, 0xd8,
	0xc0, 0x53, 0xc9, 0x02, 0xa7, 0xe8, 0x43, 0x20, 0x92, 0xa2, 0x9f, 0x81, 0xe3, 0xf3, 0xbe, 0xee,
	0xbe, 0xd6, 0x6c, 0x3b, 0x09, 0x83, 0x41, 0x1f, 0x49, 0x97, 0x7e, 0x22, 0x01, 0x9a, 0xf7, 0x89,
	0xf3, 0x36, 0xd3, 0x36, 0x41, 0xc3, 0x6f, 0x43, 0x48, 0x8a, 0xfc, 0x5b, 0x09, 0x4e, 0x06, 0x66,
	0xe2, 0x0f, 0x5b, 0xb7, 0x05, 0xef, 0x48, 0x31, 0xfc, 0xf3, 0x73, 0xbd, 0xbc, 0x29, 0xc1, 0x70,
	0x0c, 0x40, 0x31, 0xbd, 0x5f, 0x07, 0x68, 0x5f, 0x72, 0x62, 0xe6, 0xf7, 0xce, 0x25, 0xa8, 0x6d,
	0xaf, 0x05, 0x8c, 0x12, 0x4f, 0xf0, 0x2f, 0x24, 0x18, 0x0a, 0x80, 0xb9, 0x4d, 0xc7, 0xba, 0x43,
	0x9f, 0xf4, 0x6f, 0xe9, 0xf2, 0xf3, 0x10, 0x0a, 0xfb, 0xa1, 0x8b, 0x14, 0x4e, 0x40, 0x0f, 0x1b,
	0x51, 0x45, 0xf6, 0xba, 0x5c, 0x22, 0xa8, 0x9d, 0xc6, 0x95, 0x93, 0x66, 0xad, 0xf6, 0x57, 0x1e,
	0xfa, 0xc5, 0xb2, 0xf3, 0xfc, 0xf4, 0x44, 0x4f, 0x24, 0x48, 0xdf, 0xc2, 0x3e, 0x3a, 0x1f, 0xbf,
	0xd2, 0xbe, 0x5b, 0x6a, 0xf1, 0xe0, 0x4b, 0x99, 0x5c, 0x7a, 0xfa, 0xdb, 0x1f, 0xcf, 0x52, 0xef,
	0x20, 0x39, 0xea, 0x56, 0xee, 0x55, 0x1e, 0x75, 0x2a, 0xf4, 0x18, 0x7d, 0x2d, 0x41, 0x86, 0x66,
	0x04, 0x95, 0xe3, 0xfd, 0x46, 0xdc, 0x73, 0x8b, 0x4a, 0x52, 0x75, 0x9e, 0x5c, 0x79, 0x98, 0x61,
	0x1a, 0x42, 0x27, 0x22, 0x31, 0xa1, 0xef, 0x24, 0xc8, 0xf2, 0x99, 0x03, 0x29, 0x87, 0x1b, 0x05,
	0x8b, 0x07, 0xb3, 0x5c, 0xbe, 0xb1, 0xb5, 0x5b, 0x1a, 0x89, 0x1b, 0x6a, 0x7a, 0xc5, 0x07, 0x06,
	0xb0, 0x28, 0x47, 0x03, 0xbc, 0x2c, 0x95, 0xd0, 0x73, 0x09, 0xb2, 0xbc, 0xa3, 0x74, 0xc3, 0x18,
	0x35, 0x2c, 0x24, 0xc1, 0xf8, 0x31, 0xc7, 0x18, 0xdd, 0xb2, 0x42, 0x18, 0x47, 0x6b, 0x09, 0x0a,
	0x4b, 0x01, 0xbf, 0x90, 0x20, 0xcb, 0x9b, 0x48, 0x37, 0xc0, 0x51, 0xbd, 0x2e, 0x09, 0xe0, 0xcf,
	0xb7, 0x76, 0x4b, 0x4a, 0x5c, 0x97, 0x3a, 0xb1, 0x77, 0x64, 0xbb, 0xb9, 0xea, 0xf8, 0xeb, 0x9c,
	0x97, 0xa5, 0x24, 0xbc, 0x7c, 0x2e, 0x41, 0x0f, 0x6b, 0x42, 0xdd, 0x88, 0x19, 0xd1, 0xe9, 0x92,
	0x20, 0x9f, 0xdf, 0xda, 0x2d, 0xfd, 0x2f, 0xa6, 0xc7, 0x85, 0x32, 0x5d, 0x92, 0xc7, 0x12, 0x64,
	0xda, 0x63, 0x30, 0x7f, 0x90, 0x20, 0x43, 0x5b, 0x0f, 0x1a, 0xef, 0x86, 0x77, 0x6f, 0x77, 0x4c,
	0x02, 0xf7, 0xde, 0xd6, 0x6e, 0xe9, 0x54, 0x74, 0x5f, 0x0b, 0xa1, 0x1d, 0x97, 0x47, 0x13, 0xa1,
	0x25, 0x0e, 0x25, 0xc7, 0xcf, 0x12, 0xf4, 0xd3, 0x9d, 0xda, 0xe9, 0x25, 0x68, 0x2a, 0xd1, 0x9e,
	0xde, 0xd7, 0x1d, 0x8b, 0xef, 0x1e, 0xda, 0x4e, 0x1c, 0x0a, 0x93, 0x0c, 0x77, 0x05, 0x95, 0x0f,
	0xc6, 0x5d, 0x09, 0x34, 0xaa, 0xef, 0x25, 0xc8, 0x51, 0xc7, 0xec, 0xf8, 0x46, 0x6a, 0xa2, 0xd5,
	0x83, 0x5d, 0xaa, 0x58, 0x3b, 0x8c, 0x89, 0xc0, 0x5a, 0xe5, 0x8c, 0x40, 0x09, 0x18, 0x51, 0x61,
	0x9d, 0x61, 0x06, 0xc3, 0xc9, 0xd0, 0x32, 0xba, 0x63, 0x05, 0x97, 0xfa, 0xec, 0xe6, 0xb2, 0xe5,
	0x3f, 0x68, 0x2e, 0x2a, 0x06, 0x59, 0xad, 0x70, 0xc5, 0x32, 0xff, 0x63, 0xb9, 0x4c, 0xca, 0xcb,
	0xd8, 0x66, 0x5b, 0xa7, 0x12, 0xf7, 0xf3, 0xf4, 0x4a, 0xeb, 0x79, 0x31, 0xcb, 0x14, 0x2f, 0xfc,
	0x1d, 0x00, 0x00, 0xff, 0xff, 0x4c, 0x43, 0x10, 0x6f, 0x41, 0x16, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ClusterServiceClient is the client API for ClusterService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ClusterServiceClient interface {
	// Returns the specified cluster.
	//
	// To get the list of all available clusters, make a [ClusterService.List] request.
	Get(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Retrieves the list of clusters in the specified folder.
	List(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Creates a cluster in the specified folder.
	Create(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the configuration of the specified cluster.
	Update(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified cluster.
	Delete(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Starts the specified cluster.
	Start(ctx context.Context, in *StartClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Stops the specified cluster.
	Stop(ctx context.Context, in *StopClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists operations for the specified cluster.
	ListOperations(ctx context.Context, in *ListClusterOperationsRequest, opts ...grpc.CallOption) (*ListClusterOperationsResponse, error)
	// Retrieves the list of hosts in the specified cluster.
	ListHosts(ctx context.Context, in *ListClusterHostsRequest, opts ...grpc.CallOption) (*ListClusterHostsResponse, error)
}

type clusterServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewClusterServiceClient(cc grpc.ClientConnInterface) ClusterServiceClient {
	return &clusterServiceClient{cc}
}

func (c *clusterServiceClient) Get(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := c.cc.Invoke(ctx, "/yandex.cloud.dataproc.v1.ClusterService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) List(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.dataproc.v1.ClusterService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Create(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.dataproc.v1.ClusterService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Update(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.dataproc.v1.ClusterService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Delete(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.dataproc.v1.ClusterService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Start(ctx context.Context, in *StartClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.dataproc.v1.ClusterService/Start", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Stop(ctx context.Context, in *StopClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.dataproc.v1.ClusterService/Stop", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) ListOperations(ctx context.Context, in *ListClusterOperationsRequest, opts ...grpc.CallOption) (*ListClusterOperationsResponse, error) {
	out := new(ListClusterOperationsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.dataproc.v1.ClusterService/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) ListHosts(ctx context.Context, in *ListClusterHostsRequest, opts ...grpc.CallOption) (*ListClusterHostsResponse, error) {
	out := new(ListClusterHostsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.dataproc.v1.ClusterService/ListHosts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ClusterServiceServer is the server API for ClusterService service.
type ClusterServiceServer interface {
	// Returns the specified cluster.
	//
	// To get the list of all available clusters, make a [ClusterService.List] request.
	Get(context.Context, *GetClusterRequest) (*Cluster, error)
	// Retrieves the list of clusters in the specified folder.
	List(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Creates a cluster in the specified folder.
	Create(context.Context, *CreateClusterRequest) (*operation.Operation, error)
	// Updates the configuration of the specified cluster.
	Update(context.Context, *UpdateClusterRequest) (*operation.Operation, error)
	// Deletes the specified cluster.
	Delete(context.Context, *DeleteClusterRequest) (*operation.Operation, error)
	// Starts the specified cluster.
	Start(context.Context, *StartClusterRequest) (*operation.Operation, error)
	// Stops the specified cluster.
	Stop(context.Context, *StopClusterRequest) (*operation.Operation, error)
	// Lists operations for the specified cluster.
	ListOperations(context.Context, *ListClusterOperationsRequest) (*ListClusterOperationsResponse, error)
	// Retrieves the list of hosts in the specified cluster.
	ListHosts(context.Context, *ListClusterHostsRequest) (*ListClusterHostsResponse, error)
}

// UnimplementedClusterServiceServer can be embedded to have forward compatible implementations.
type UnimplementedClusterServiceServer struct {
}

func (*UnimplementedClusterServiceServer) Get(ctx context.Context, req *GetClusterRequest) (*Cluster, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedClusterServiceServer) List(ctx context.Context, req *ListClustersRequest) (*ListClustersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedClusterServiceServer) Create(ctx context.Context, req *CreateClusterRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (*UnimplementedClusterServiceServer) Update(ctx context.Context, req *UpdateClusterRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (*UnimplementedClusterServiceServer) Delete(ctx context.Context, req *DeleteClusterRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedClusterServiceServer) Start(ctx context.Context, req *StartClusterRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Start not implemented")
}
func (*UnimplementedClusterServiceServer) Stop(ctx context.Context, req *StopClusterRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Stop not implemented")
}
func (*UnimplementedClusterServiceServer) ListOperations(ctx context.Context, req *ListClusterOperationsRequest) (*ListClusterOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOperations not implemented")
}
func (*UnimplementedClusterServiceServer) ListHosts(ctx context.Context, req *ListClusterHostsRequest) (*ListClusterHostsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListHosts not implemented")
}

func RegisterClusterServiceServer(s *grpc.Server, srv ClusterServiceServer) {
	s.RegisterService(&_ClusterService_serviceDesc, srv)
}

func _ClusterService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.dataproc.v1.ClusterService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Get(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.dataproc.v1.ClusterService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).List(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.dataproc.v1.ClusterService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Create(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.dataproc.v1.ClusterService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Update(ctx, req.(*UpdateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.dataproc.v1.ClusterService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Delete(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Start_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Start(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.dataproc.v1.ClusterService/Start",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Start(ctx, req.(*StartClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Stop_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Stop(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.dataproc.v1.ClusterService/Stop",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Stop(ctx, req.(*StopClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClusterOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.dataproc.v1.ClusterService/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).ListOperations(ctx, req.(*ListClusterOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_ListHosts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClusterHostsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).ListHosts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.dataproc.v1.ClusterService/ListHosts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).ListHosts(ctx, req.(*ListClusterHostsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ClusterService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.dataproc.v1.ClusterService",
	HandlerType: (*ClusterServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _ClusterService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _ClusterService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _ClusterService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _ClusterService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _ClusterService_Delete_Handler,
		},
		{
			MethodName: "Start",
			Handler:    _ClusterService_Start_Handler,
		},
		{
			MethodName: "Stop",
			Handler:    _ClusterService_Stop_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _ClusterService_ListOperations_Handler,
		},
		{
			MethodName: "ListHosts",
			Handler:    _ClusterService_ListHosts_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/dataproc/v1/cluster_service.proto",
}
