// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/dataproc/v1/job.proto

package dataproc

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type Job_Status int32

const (
	Job_STATUS_UNSPECIFIED Job_Status = 0
	// Job is logged in the database and is waiting for the agent to run it.
	Job_PROVISIONING Job_Status = 1
	// Job is acquired by the agent and is in the queue for execution.
	Job_PENDING Job_Status = 2
	// Job is being run in the cluster.
	Job_RUNNING Job_Status = 3
	// Job failed to finish the run properly.
	Job_ERROR Job_Status = 4
	// Job is finished.
	Job_DONE Job_Status = 5
)

var Job_Status_name = map[int32]string{
	0: "STATUS_UNSPECIFIED",
	1: "PROVISIONING",
	2: "PENDING",
	3: "RUNNING",
	4: "ERROR",
	5: "DONE",
}

var Job_Status_value = map[string]int32{
	"STATUS_UNSPECIFIED": 0,
	"PROVISIONING":       1,
	"PENDING":            2,
	"RUNNING":            3,
	"ERROR":              4,
	"DONE":               5,
}

func (x Job_Status) String() string {
	return proto.EnumName(Job_Status_name, int32(x))
}

func (Job_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_2e94b92233e6cd71, []int{0, 0}
}

// A Data Proc job. For details about the concept, see [documentation](/docs/dataproc/concepts/jobs).
type Job struct {
	// ID of the job. Generated at creation time.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the Data Proc cluster that the job belongs to.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Creation timestamp.
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The time when the job was started.
	StartedAt *timestamp.Timestamp `protobuf:"bytes,4,opt,name=started_at,json=startedAt,proto3" json:"started_at,omitempty"`
	// The time when the job was finished.
	FinishedAt *timestamp.Timestamp `protobuf:"bytes,5,opt,name=finished_at,json=finishedAt,proto3" json:"finished_at,omitempty"`
	// Name of the job, specified in the [JobService.Create] request.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	// The id of the user who created the job
	CreatedBy string `protobuf:"bytes,12,opt,name=created_by,json=createdBy,proto3" json:"created_by,omitempty"`
	// Job status.
	Status Job_Status `protobuf:"varint,7,opt,name=status,proto3,enum=yandex.cloud.dataproc.v1.Job_Status" json:"status,omitempty"`
	// Specification for the job.
	//
	// Types that are valid to be assigned to JobSpec:
	//	*Job_MapreduceJob
	//	*Job_SparkJob
	//	*Job_PysparkJob
	//	*Job_HiveJob
	JobSpec              isJob_JobSpec `protobuf_oneof:"job_spec"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *Job) Reset()         { *m = Job{} }
func (m *Job) String() string { return proto.CompactTextString(m) }
func (*Job) ProtoMessage()    {}
func (*Job) Descriptor() ([]byte, []int) {
	return fileDescriptor_2e94b92233e6cd71, []int{0}
}

func (m *Job) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Job.Unmarshal(m, b)
}
func (m *Job) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Job.Marshal(b, m, deterministic)
}
func (m *Job) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Job.Merge(m, src)
}
func (m *Job) XXX_Size() int {
	return xxx_messageInfo_Job.Size(m)
}
func (m *Job) XXX_DiscardUnknown() {
	xxx_messageInfo_Job.DiscardUnknown(m)
}

var xxx_messageInfo_Job proto.InternalMessageInfo

func (m *Job) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Job) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *Job) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Job) GetStartedAt() *timestamp.Timestamp {
	if m != nil {
		return m.StartedAt
	}
	return nil
}

func (m *Job) GetFinishedAt() *timestamp.Timestamp {
	if m != nil {
		return m.FinishedAt
	}
	return nil
}

func (m *Job) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Job) GetCreatedBy() string {
	if m != nil {
		return m.CreatedBy
	}
	return ""
}

func (m *Job) GetStatus() Job_Status {
	if m != nil {
		return m.Status
	}
	return Job_STATUS_UNSPECIFIED
}

type isJob_JobSpec interface {
	isJob_JobSpec()
}

type Job_MapreduceJob struct {
	MapreduceJob *MapreduceJob `protobuf:"bytes,8,opt,name=mapreduce_job,json=mapreduceJob,proto3,oneof"`
}

type Job_SparkJob struct {
	SparkJob *SparkJob `protobuf:"bytes,9,opt,name=spark_job,json=sparkJob,proto3,oneof"`
}

type Job_PysparkJob struct {
	PysparkJob *PysparkJob `protobuf:"bytes,10,opt,name=pyspark_job,json=pysparkJob,proto3,oneof"`
}

type Job_HiveJob struct {
	HiveJob *HiveJob `protobuf:"bytes,11,opt,name=hive_job,json=hiveJob,proto3,oneof"`
}

func (*Job_MapreduceJob) isJob_JobSpec() {}

func (*Job_SparkJob) isJob_JobSpec() {}

func (*Job_PysparkJob) isJob_JobSpec() {}

func (*Job_HiveJob) isJob_JobSpec() {}

func (m *Job) GetJobSpec() isJob_JobSpec {
	if m != nil {
		return m.JobSpec
	}
	return nil
}

func (m *Job) GetMapreduceJob() *MapreduceJob {
	if x, ok := m.GetJobSpec().(*Job_MapreduceJob); ok {
		return x.MapreduceJob
	}
	return nil
}

func (m *Job) GetSparkJob() *SparkJob {
	if x, ok := m.GetJobSpec().(*Job_SparkJob); ok {
		return x.SparkJob
	}
	return nil
}

func (m *Job) GetPysparkJob() *PysparkJob {
	if x, ok := m.GetJobSpec().(*Job_PysparkJob); ok {
		return x.PysparkJob
	}
	return nil
}

func (m *Job) GetHiveJob() *HiveJob {
	if x, ok := m.GetJobSpec().(*Job_HiveJob); ok {
		return x.HiveJob
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Job) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Job_MapreduceJob)(nil),
		(*Job_SparkJob)(nil),
		(*Job_PysparkJob)(nil),
		(*Job_HiveJob)(nil),
	}
}

type MapreduceJob struct {
	// Optional arguments to pass to the driver.
	Args []string `protobuf:"bytes,1,rep,name=args,proto3" json:"args,omitempty"`
	// JAR file URIs to add to CLASSPATH of the Data Proc driver and each task.
	JarFileUris []string `protobuf:"bytes,2,rep,name=jar_file_uris,json=jarFileUris,proto3" json:"jar_file_uris,omitempty"`
	// URIs of resource files to be copied to the working directory of Data Proc drivers
	// and distributed Hadoop tasks.
	FileUris []string `protobuf:"bytes,3,rep,name=file_uris,json=fileUris,proto3" json:"file_uris,omitempty"`
	// URIs of archives to be extracted to the working directory of Data Proc drivers and tasks.
	ArchiveUris []string `protobuf:"bytes,4,rep,name=archive_uris,json=archiveUris,proto3" json:"archive_uris,omitempty"`
	// Property names and values, used to configure Data Proc and MapReduce.
	Properties map[string]string `protobuf:"bytes,5,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Types that are valid to be assigned to Driver:
	//	*MapreduceJob_MainJarFileUri
	//	*MapreduceJob_MainClass
	Driver               isMapreduceJob_Driver `protobuf_oneof:"driver"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *MapreduceJob) Reset()         { *m = MapreduceJob{} }
func (m *MapreduceJob) String() string { return proto.CompactTextString(m) }
func (*MapreduceJob) ProtoMessage()    {}
func (*MapreduceJob) Descriptor() ([]byte, []int) {
	return fileDescriptor_2e94b92233e6cd71, []int{1}
}

func (m *MapreduceJob) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MapreduceJob.Unmarshal(m, b)
}
func (m *MapreduceJob) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MapreduceJob.Marshal(b, m, deterministic)
}
func (m *MapreduceJob) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MapreduceJob.Merge(m, src)
}
func (m *MapreduceJob) XXX_Size() int {
	return xxx_messageInfo_MapreduceJob.Size(m)
}
func (m *MapreduceJob) XXX_DiscardUnknown() {
	xxx_messageInfo_MapreduceJob.DiscardUnknown(m)
}

var xxx_messageInfo_MapreduceJob proto.InternalMessageInfo

func (m *MapreduceJob) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *MapreduceJob) GetJarFileUris() []string {
	if m != nil {
		return m.JarFileUris
	}
	return nil
}

func (m *MapreduceJob) GetFileUris() []string {
	if m != nil {
		return m.FileUris
	}
	return nil
}

func (m *MapreduceJob) GetArchiveUris() []string {
	if m != nil {
		return m.ArchiveUris
	}
	return nil
}

func (m *MapreduceJob) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

type isMapreduceJob_Driver interface {
	isMapreduceJob_Driver()
}

type MapreduceJob_MainJarFileUri struct {
	MainJarFileUri string `protobuf:"bytes,6,opt,name=main_jar_file_uri,json=mainJarFileUri,proto3,oneof"`
}

type MapreduceJob_MainClass struct {
	MainClass string `protobuf:"bytes,7,opt,name=main_class,json=mainClass,proto3,oneof"`
}

func (*MapreduceJob_MainJarFileUri) isMapreduceJob_Driver() {}

func (*MapreduceJob_MainClass) isMapreduceJob_Driver() {}

func (m *MapreduceJob) GetDriver() isMapreduceJob_Driver {
	if m != nil {
		return m.Driver
	}
	return nil
}

func (m *MapreduceJob) GetMainJarFileUri() string {
	if x, ok := m.GetDriver().(*MapreduceJob_MainJarFileUri); ok {
		return x.MainJarFileUri
	}
	return ""
}

func (m *MapreduceJob) GetMainClass() string {
	if x, ok := m.GetDriver().(*MapreduceJob_MainClass); ok {
		return x.MainClass
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*MapreduceJob) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*MapreduceJob_MainJarFileUri)(nil),
		(*MapreduceJob_MainClass)(nil),
	}
}

type SparkJob struct {
	// Optional arguments to pass to the driver.
	Args []string `protobuf:"bytes,1,rep,name=args,proto3" json:"args,omitempty"`
	// JAR file URIs to add to CLASSPATH of the Data Proc driver and each task.
	JarFileUris []string `protobuf:"bytes,2,rep,name=jar_file_uris,json=jarFileUris,proto3" json:"jar_file_uris,omitempty"`
	// URIs of resource files to be copied to the working directory of Data Proc drivers
	// and distributed Hadoop tasks.
	FileUris []string `protobuf:"bytes,3,rep,name=file_uris,json=fileUris,proto3" json:"file_uris,omitempty"`
	// URIs of archives to be extracted to the working directory of Data Proc drivers and tasks.
	ArchiveUris []string `protobuf:"bytes,4,rep,name=archive_uris,json=archiveUris,proto3" json:"archive_uris,omitempty"`
	// Property names and values, used to configure Data Proc and Spark.
	Properties map[string]string `protobuf:"bytes,5,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The HCFS URI of the JAR file containing the `main` class for the job.
	MainJarFileUri string `protobuf:"bytes,6,opt,name=main_jar_file_uri,json=mainJarFileUri,proto3" json:"main_jar_file_uri,omitempty"`
	// The name of the driver class.
	MainClass            string   `protobuf:"bytes,7,opt,name=main_class,json=mainClass,proto3" json:"main_class,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SparkJob) Reset()         { *m = SparkJob{} }
func (m *SparkJob) String() string { return proto.CompactTextString(m) }
func (*SparkJob) ProtoMessage()    {}
func (*SparkJob) Descriptor() ([]byte, []int) {
	return fileDescriptor_2e94b92233e6cd71, []int{2}
}

func (m *SparkJob) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SparkJob.Unmarshal(m, b)
}
func (m *SparkJob) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SparkJob.Marshal(b, m, deterministic)
}
func (m *SparkJob) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SparkJob.Merge(m, src)
}
func (m *SparkJob) XXX_Size() int {
	return xxx_messageInfo_SparkJob.Size(m)
}
func (m *SparkJob) XXX_DiscardUnknown() {
	xxx_messageInfo_SparkJob.DiscardUnknown(m)
}

var xxx_messageInfo_SparkJob proto.InternalMessageInfo

func (m *SparkJob) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *SparkJob) GetJarFileUris() []string {
	if m != nil {
		return m.JarFileUris
	}
	return nil
}

func (m *SparkJob) GetFileUris() []string {
	if m != nil {
		return m.FileUris
	}
	return nil
}

func (m *SparkJob) GetArchiveUris() []string {
	if m != nil {
		return m.ArchiveUris
	}
	return nil
}

func (m *SparkJob) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *SparkJob) GetMainJarFileUri() string {
	if m != nil {
		return m.MainJarFileUri
	}
	return ""
}

func (m *SparkJob) GetMainClass() string {
	if m != nil {
		return m.MainClass
	}
	return ""
}

type PysparkJob struct {
	// Optional arguments to pass to the driver.
	Args []string `protobuf:"bytes,1,rep,name=args,proto3" json:"args,omitempty"`
	// JAR file URIs to add to CLASSPATH of the Data Proc driver and each task.
	JarFileUris []string `protobuf:"bytes,2,rep,name=jar_file_uris,json=jarFileUris,proto3" json:"jar_file_uris,omitempty"`
	// URIs of resource files to be copied to the working directory of Data Proc drivers
	// and distributed Hadoop tasks.
	FileUris []string `protobuf:"bytes,3,rep,name=file_uris,json=fileUris,proto3" json:"file_uris,omitempty"`
	// URIs of archives to be extracted to the working directory of Data Proc drivers and tasks.
	ArchiveUris []string `protobuf:"bytes,4,rep,name=archive_uris,json=archiveUris,proto3" json:"archive_uris,omitempty"`
	// Property names and values, used to configure Data Proc and PySpark.
	Properties map[string]string `protobuf:"bytes,5,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// URI of the file with the driver code. Must be a .py file.
	MainPythonFileUri string `protobuf:"bytes,6,opt,name=main_python_file_uri,json=mainPythonFileUri,proto3" json:"main_python_file_uri,omitempty"`
	// URIs of Python files to pass to the PySpark framework.
	PythonFileUris       []string `protobuf:"bytes,7,rep,name=python_file_uris,json=pythonFileUris,proto3" json:"python_file_uris,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PysparkJob) Reset()         { *m = PysparkJob{} }
func (m *PysparkJob) String() string { return proto.CompactTextString(m) }
func (*PysparkJob) ProtoMessage()    {}
func (*PysparkJob) Descriptor() ([]byte, []int) {
	return fileDescriptor_2e94b92233e6cd71, []int{3}
}

func (m *PysparkJob) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PysparkJob.Unmarshal(m, b)
}
func (m *PysparkJob) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PysparkJob.Marshal(b, m, deterministic)
}
func (m *PysparkJob) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PysparkJob.Merge(m, src)
}
func (m *PysparkJob) XXX_Size() int {
	return xxx_messageInfo_PysparkJob.Size(m)
}
func (m *PysparkJob) XXX_DiscardUnknown() {
	xxx_messageInfo_PysparkJob.DiscardUnknown(m)
}

var xxx_messageInfo_PysparkJob proto.InternalMessageInfo

func (m *PysparkJob) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *PysparkJob) GetJarFileUris() []string {
	if m != nil {
		return m.JarFileUris
	}
	return nil
}

func (m *PysparkJob) GetFileUris() []string {
	if m != nil {
		return m.FileUris
	}
	return nil
}

func (m *PysparkJob) GetArchiveUris() []string {
	if m != nil {
		return m.ArchiveUris
	}
	return nil
}

func (m *PysparkJob) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *PysparkJob) GetMainPythonFileUri() string {
	if m != nil {
		return m.MainPythonFileUri
	}
	return ""
}

func (m *PysparkJob) GetPythonFileUris() []string {
	if m != nil {
		return m.PythonFileUris
	}
	return nil
}

type QueryList struct {
	// List of Hive queries.
	Queries              []string `protobuf:"bytes,1,rep,name=queries,proto3" json:"queries,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *QueryList) Reset()         { *m = QueryList{} }
func (m *QueryList) String() string { return proto.CompactTextString(m) }
func (*QueryList) ProtoMessage()    {}
func (*QueryList) Descriptor() ([]byte, []int) {
	return fileDescriptor_2e94b92233e6cd71, []int{4}
}

func (m *QueryList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryList.Unmarshal(m, b)
}
func (m *QueryList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryList.Marshal(b, m, deterministic)
}
func (m *QueryList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryList.Merge(m, src)
}
func (m *QueryList) XXX_Size() int {
	return xxx_messageInfo_QueryList.Size(m)
}
func (m *QueryList) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryList.DiscardUnknown(m)
}

var xxx_messageInfo_QueryList proto.InternalMessageInfo

func (m *QueryList) GetQueries() []string {
	if m != nil {
		return m.Queries
	}
	return nil
}

type HiveJob struct {
	// Property names and values, used to configure Data Proc and Hive.
	Properties map[string]string `protobuf:"bytes,1,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Flag indicating whether a job should continue to run if a query fails.
	ContinueOnFailure bool `protobuf:"varint,2,opt,name=continue_on_failure,json=continueOnFailure,proto3" json:"continue_on_failure,omitempty"`
	// Query variables and their values.
	ScriptVariables map[string]string `protobuf:"bytes,3,rep,name=script_variables,json=scriptVariables,proto3" json:"script_variables,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// JAR file URIs to add to CLASSPATH of the Hive driver and each task.
	JarFileUris []string `protobuf:"bytes,4,rep,name=jar_file_uris,json=jarFileUris,proto3" json:"jar_file_uris,omitempty"`
	// Types that are valid to be assigned to QueryType:
	//	*HiveJob_QueryFileUri
	//	*HiveJob_QueryList
	QueryType            isHiveJob_QueryType `protobuf_oneof:"query_type"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *HiveJob) Reset()         { *m = HiveJob{} }
func (m *HiveJob) String() string { return proto.CompactTextString(m) }
func (*HiveJob) ProtoMessage()    {}
func (*HiveJob) Descriptor() ([]byte, []int) {
	return fileDescriptor_2e94b92233e6cd71, []int{5}
}

func (m *HiveJob) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HiveJob.Unmarshal(m, b)
}
func (m *HiveJob) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HiveJob.Marshal(b, m, deterministic)
}
func (m *HiveJob) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HiveJob.Merge(m, src)
}
func (m *HiveJob) XXX_Size() int {
	return xxx_messageInfo_HiveJob.Size(m)
}
func (m *HiveJob) XXX_DiscardUnknown() {
	xxx_messageInfo_HiveJob.DiscardUnknown(m)
}

var xxx_messageInfo_HiveJob proto.InternalMessageInfo

func (m *HiveJob) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *HiveJob) GetContinueOnFailure() bool {
	if m != nil {
		return m.ContinueOnFailure
	}
	return false
}

func (m *HiveJob) GetScriptVariables() map[string]string {
	if m != nil {
		return m.ScriptVariables
	}
	return nil
}

func (m *HiveJob) GetJarFileUris() []string {
	if m != nil {
		return m.JarFileUris
	}
	return nil
}

type isHiveJob_QueryType interface {
	isHiveJob_QueryType()
}

type HiveJob_QueryFileUri struct {
	QueryFileUri string `protobuf:"bytes,5,opt,name=query_file_uri,json=queryFileUri,proto3,oneof"`
}

type HiveJob_QueryList struct {
	QueryList *QueryList `protobuf:"bytes,6,opt,name=query_list,json=queryList,proto3,oneof"`
}

func (*HiveJob_QueryFileUri) isHiveJob_QueryType() {}

func (*HiveJob_QueryList) isHiveJob_QueryType() {}

func (m *HiveJob) GetQueryType() isHiveJob_QueryType {
	if m != nil {
		return m.QueryType
	}
	return nil
}

func (m *HiveJob) GetQueryFileUri() string {
	if x, ok := m.GetQueryType().(*HiveJob_QueryFileUri); ok {
		return x.QueryFileUri
	}
	return ""
}

func (m *HiveJob) GetQueryList() *QueryList {
	if x, ok := m.GetQueryType().(*HiveJob_QueryList); ok {
		return x.QueryList
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*HiveJob) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*HiveJob_QueryFileUri)(nil),
		(*HiveJob_QueryList)(nil),
	}
}

func init() {
	proto.RegisterEnum("yandex.cloud.dataproc.v1.Job_Status", Job_Status_name, Job_Status_value)
	proto.RegisterType((*Job)(nil), "yandex.cloud.dataproc.v1.Job")
	proto.RegisterType((*MapreduceJob)(nil), "yandex.cloud.dataproc.v1.MapreduceJob")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.dataproc.v1.MapreduceJob.PropertiesEntry")
	proto.RegisterType((*SparkJob)(nil), "yandex.cloud.dataproc.v1.SparkJob")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.dataproc.v1.SparkJob.PropertiesEntry")
	proto.RegisterType((*PysparkJob)(nil), "yandex.cloud.dataproc.v1.PysparkJob")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.dataproc.v1.PysparkJob.PropertiesEntry")
	proto.RegisterType((*QueryList)(nil), "yandex.cloud.dataproc.v1.QueryList")
	proto.RegisterType((*HiveJob)(nil), "yandex.cloud.dataproc.v1.HiveJob")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.dataproc.v1.HiveJob.PropertiesEntry")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.dataproc.v1.HiveJob.ScriptVariablesEntry")
}

func init() {
	proto.RegisterFile("yandex/cloud/dataproc/v1/job.proto", fileDescriptor_2e94b92233e6cd71)
}

var fileDescriptor_2e94b92233e6cd71 = []byte{
	// 939 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x56, 0x6f, 0x8f, 0xda, 0xc6,
	0x13, 0x3e, 0xfe, 0x1d, 0x30, 0x10, 0x42, 0xf6, 0x77, 0xfa, 0xc9, 0xba, 0x36, 0x0a, 0xa1, 0x6d,
	0x44, 0x55, 0xc5, 0xe8, 0x68, 0x55, 0xb5, 0x4d, 0x5b, 0x09, 0x72, 0x5c, 0x0e, 0xd4, 0x00, 0x31,
	0x77, 0xf7, 0xa2, 0x6f, 0xac, 0xb5, 0xbd, 0x07, 0x4b, 0x8c, 0xed, 0xec, 0xae, 0x51, 0xfd, 0x35,
	0xfa, 0x05, 0x2b, 0xf5, 0x33, 0xb4, 0xef, 0x2b, 0xef, 0xda, 0x07, 0xf7, 0x07, 0x2e, 0x55, 0x2a,
	0xe5, 0xdd, 0xce, 0xcc, 0x33, 0xb3, 0xfb, 0x3c, 0x33, 0x1e, 0x19, 0x9a, 0x11, 0xf6, 0x1c, 0xf2,
	0x5b, 0xdb, 0x76, 0xfd, 0xd0, 0x69, 0x3b, 0x58, 0xe0, 0x80, 0xf9, 0x76, 0x7b, 0x75, 0xd4, 0x5e,
	0xf8, 0x96, 0x1e, 0x30, 0x5f, 0xf8, 0x48, 0x53, 0x18, 0x5d, 0x62, 0xf4, 0x14, 0xa3, 0xaf, 0x8e,
	0x0e, 0x9f, 0xcc, 0x7c, 0x7f, 0xe6, 0x92, 0xb6, 0xc4, 0x59, 0xe1, 0x65, 0x5b, 0xd0, 0x25, 0xe1,
	0x02, 0x2f, 0x03, 0x95, 0xda, 0xfc, 0xb3, 0x00, 0xb9, 0xa1, 0x6f, 0xa1, 0x1a, 0x64, 0xa9, 0xa3,
	0x65, 0x1a, 0x99, 0x56, 0xd9, 0xc8, 0x52, 0x07, 0x3d, 0x06, 0xb0, 0xdd, 0x90, 0x0b, 0xc2, 0x4c,
	0xea, 0x68, 0x59, 0xe9, 0x2f, 0x27, 0x9e, 0x81, 0x83, 0xbe, 0x07, 0xb0, 0x19, 0xc1, 0x82, 0x38,
	0x26, 0x16, 0x5a, 0xae, 0x91, 0x69, 0x55, 0x3a, 0x87, 0xba, 0xba, 0x4c, 0x4f, 0x2f, 0xd3, 0xcf,
	0xd2, 0xcb, 0x8c, 0x72, 0x82, 0xee, 0x8a, 0x38, 0x95, 0x0b, 0xcc, 0x92, 0xd4, 0xfc, 0xfd, 0xa9,
	0x09, 0xba, 0x2b, 0xd0, 0x0b, 0xa8, 0x5c, 0x52, 0x8f, 0xf2, 0xb9, 0xca, 0x2d, 0xdc, 0x9b, 0x0b,
	0x29, 0xbc, 0x2b, 0x10, 0x82, 0xbc, 0x87, 0x97, 0x44, 0xdb, 0x97, 0x5c, 0xe4, 0x59, 0xb2, 0x4c,
	0x68, 0x58, 0x91, 0x56, 0x4d, 0x58, 0x2a, 0x4f, 0x2f, 0x42, 0x3f, 0xc2, 0x3e, 0x17, 0x58, 0x84,
	0x5c, 0x2b, 0x36, 0x32, 0xad, 0x5a, 0xe7, 0x73, 0x7d, 0x9b, 0xd0, 0xfa, 0xd0, 0xb7, 0xf4, 0xa9,
	0xc4, 0x1a, 0x49, 0x0e, 0x7a, 0x0d, 0x0f, 0x96, 0x38, 0x60, 0xc4, 0x09, 0x6d, 0x62, 0x2e, 0x7c,
	0x4b, 0x2b, 0xc9, 0xf7, 0x3e, 0xdb, 0x5e, 0xe4, 0x75, 0x0a, 0x1f, 0xfa, 0xd6, 0xe9, 0x9e, 0x51,
	0x5d, 0x6e, 0xd8, 0xa8, 0x0b, 0x65, 0x1e, 0x60, 0xf6, 0x56, 0x96, 0x2a, 0xcb, 0x52, 0xcd, 0xed,
	0xa5, 0xa6, 0x31, 0x54, 0x95, 0x29, 0xf1, 0xe4, 0x8c, 0x5e, 0x41, 0x25, 0x88, 0xd6, 0x45, 0x40,
	0x16, 0xd9, 0x41, 0x6a, 0x12, 0xf1, 0x75, 0x19, 0x08, 0xae, 0x2c, 0xf4, 0x33, 0x94, 0xe6, 0x74,
	0xa5, 0x58, 0x55, 0x64, 0x95, 0xa7, 0xdb, 0xab, 0x9c, 0xd2, 0x55, 0x42, 0xa8, 0x38, 0x57, 0xc7,
	0x26, 0x86, 0x7d, 0x25, 0x16, 0xfa, 0x3f, 0xa0, 0xe9, 0x59, 0xf7, 0xec, 0x7c, 0x6a, 0x9e, 0x8f,
	0xa6, 0x93, 0xfe, 0xcb, 0xc1, 0xc9, 0xa0, 0x7f, 0x5c, 0xdf, 0x43, 0x75, 0xa8, 0x4e, 0x8c, 0xf1,
	0xc5, 0x60, 0x3a, 0x18, 0x8f, 0x06, 0xa3, 0x57, 0xf5, 0x0c, 0xaa, 0x40, 0x71, 0xd2, 0x1f, 0x1d,
	0xc7, 0x46, 0x36, 0x36, 0x8c, 0xf3, 0x91, 0x8c, 0xe4, 0x50, 0x19, 0x0a, 0x7d, 0xc3, 0x18, 0x1b,
	0xf5, 0x3c, 0x2a, 0x41, 0xfe, 0x78, 0x3c, 0xea, 0xd7, 0x0b, 0x3d, 0x80, 0xd2, 0xc2, 0xb7, 0x4c,
	0x1e, 0x10, 0xbb, 0xf9, 0x77, 0x16, 0xaa, 0x9b, 0xda, 0xc6, 0xb3, 0x80, 0xd9, 0x8c, 0x6b, 0x99,
	0x46, 0x2e, 0x9e, 0x85, 0xf8, 0x8c, 0x9a, 0xf0, 0x60, 0x81, 0x99, 0x79, 0x49, 0x5d, 0x62, 0x86,
	0x8c, 0x72, 0x2d, 0x2b, 0x83, 0x95, 0x05, 0x66, 0x27, 0xd4, 0x25, 0xe7, 0x8c, 0x72, 0xf4, 0x09,
	0x94, 0xd7, 0xf1, 0x9c, 0x8c, 0x97, 0x2e, 0xd3, 0xe0, 0x53, 0xa8, 0x62, 0x66, 0x4b, 0x5d, 0x64,
	0x3c, 0xaf, 0xf2, 0x13, 0x9f, 0x84, 0x5c, 0x00, 0x04, 0xcc, 0x0f, 0x08, 0x13, 0x94, 0x70, 0xad,
	0xd0, 0xc8, 0xb5, 0x2a, 0x9d, 0x6f, 0xdf, 0x6f, 0x1e, 0xf4, 0xc9, 0x55, 0x62, 0xdf, 0x13, 0x2c,
	0x32, 0x36, 0x2a, 0xa1, 0xaf, 0xe0, 0xd1, 0x12, 0x53, 0xcf, 0xdc, 0x24, 0xa0, 0x06, 0xfd, 0x74,
	0xcf, 0xa8, 0xc5, 0xa1, 0xe1, 0x15, 0x0b, 0xf4, 0x04, 0x40, 0x82, 0x6d, 0x17, 0x73, 0x35, 0xd9,
	0x31, 0xaa, 0x1c, 0xfb, 0x5e, 0xc6, 0xae, 0xc3, 0x9f, 0xe0, 0xe1, 0x8d, 0xcb, 0x50, 0x1d, 0x72,
	0x6f, 0x49, 0x94, 0xec, 0x87, 0xf8, 0x88, 0x0e, 0xa0, 0xb0, 0xc2, 0x6e, 0x48, 0x92, 0xdd, 0xa0,
	0x8c, 0x1f, 0xb2, 0xdf, 0x65, 0x7a, 0x25, 0xd8, 0x77, 0x18, 0x5d, 0x11, 0xd6, 0xfc, 0x23, 0x0b,
	0xa5, 0x74, 0x10, 0x3f, 0x9a, 0xe6, 0xc6, 0x1d, 0x9a, 0x77, 0xee, 0xff, 0x70, 0x76, 0xea, 0xfd,
	0xe5, 0x56, 0xbd, 0x6f, 0xa9, 0xfd, 0xf8, 0xb6, 0xda, 0xff, 0x9d, 0xd6, 0xcd, 0xbf, 0xb2, 0x00,
	0xeb, 0xaf, 0xf4, 0xa3, 0x69, 0x7c, 0x76, 0x87, 0xc6, 0xdf, 0xbc, 0xcf, 0x5e, 0xd9, 0xa9, 0x72,
	0x1b, 0x0e, 0xa4, 0x74, 0x41, 0x24, 0xe6, 0xbe, 0x77, 0x53, 0x68, 0xd9, 0x81, 0x89, 0x0c, 0xa5,
	0x5a, 0xb7, 0xa0, 0x7e, 0x03, 0x1b, 0x2b, 0x1e, 0xbf, 0xb6, 0x16, 0x6c, 0x02, 0x3f, 0x58, 0xf6,
	0x2f, 0xa0, 0xfc, 0x26, 0x24, 0x2c, 0xfa, 0x85, 0x72, 0x81, 0x34, 0x28, 0xbe, 0x0b, 0x09, 0x8b,
	0x99, 0x2b, 0xdd, 0x53, 0xb3, 0xf9, 0x7b, 0x1e, 0x8a, 0xc9, 0xf6, 0x43, 0x6f, 0xae, 0x49, 0x94,
	0x91, 0x12, 0x1d, 0xdd, 0xbb, 0x34, 0x77, 0xea, 0xa3, 0xc3, 0xff, 0x6c, 0xdf, 0x13, 0xd4, 0x0b,
	0x89, 0x19, 0x73, 0xc6, 0xd4, 0x0d, 0x99, 0x7a, 0x6d, 0xc9, 0x78, 0x94, 0x86, 0xc6, 0xde, 0x89,
	0x0a, 0x20, 0x0c, 0x75, 0x6e, 0x33, 0x1a, 0x08, 0x73, 0x85, 0x19, 0xc5, 0x96, 0x4b, 0x54, 0xb3,
	0x77, 0xee, 0xa0, 0xf4, 0x21, 0x53, 0x99, 0x79, 0x91, 0x26, 0xaa, 0xd7, 0x3c, 0xe4, 0xd7, 0xbd,
	0xb7, 0x87, 0x2d, 0x7f, 0x7b, 0xd8, 0x9e, 0x41, 0x2d, 0x16, 0x28, 0x5a, 0x37, 0xb4, 0x90, 0xec,
	0xa0, 0xaa, 0xf4, 0xa7, 0xdd, 0x3c, 0x06, 0x50, 0x38, 0x97, 0x72, 0x21, 0x9b, 0x5e, 0xe9, 0x7c,
	0xb6, 0xfd, 0xa1, 0x57, 0x0d, 0x89, 0x97, 0xd9, 0xbb, 0xd4, 0xf8, 0xc0, 0x4e, 0x1f, 0xf6, 0xe0,
	0xe0, 0x2e, 0xe6, 0xff, 0x6a, 0x21, 0x56, 0x53, 0x22, 0x22, 0x0a, 0x48, 0x6f, 0x01, 0x9f, 0x5e,
	0xe3, 0x80, 0x03, 0xba, 0xc9, 0xa3, 0x97, 0x9b, 0x9c, 0x0e, 0x7f, 0xed, 0xcf, 0xa8, 0x98, 0x87,
	0x96, 0x6e, 0xfb, 0xcb, 0xb6, 0x42, 0x3f, 0x57, 0x3f, 0x80, 0x33, 0xff, 0xf9, 0x8c, 0x78, 0xf2,
	0x57, 0xa7, 0xbd, 0xed, 0xcf, 0xf0, 0x45, 0x7a, 0xb6, 0xf6, 0x25, 0xf0, 0xeb, 0x7f, 0x02, 0x00,
	0x00, 0xff, 0xff, 0x8f, 0x45, 0x22, 0x2f, 0x45, 0x0a, 0x00, 0x00,
}
