// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/iam/v1/awscompatibility/access_key_service.proto

package awscompatibility

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type GetAccessKeyRequest struct {
	// ID of the AccessKey resource to return.
	// To get the access key ID, use a [AccessKeyService.List] request.
	AccessKeyId          string   `protobuf:"bytes,1,opt,name=access_key_id,json=accessKeyId,proto3" json:"access_key_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetAccessKeyRequest) Reset()         { *m = GetAccessKeyRequest{} }
func (m *GetAccessKeyRequest) String() string { return proto.CompactTextString(m) }
func (*GetAccessKeyRequest) ProtoMessage()    {}
func (*GetAccessKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_82e7adea57f560ab, []int{0}
}

func (m *GetAccessKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetAccessKeyRequest.Unmarshal(m, b)
}
func (m *GetAccessKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetAccessKeyRequest.Marshal(b, m, deterministic)
}
func (m *GetAccessKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAccessKeyRequest.Merge(m, src)
}
func (m *GetAccessKeyRequest) XXX_Size() int {
	return xxx_messageInfo_GetAccessKeyRequest.Size(m)
}
func (m *GetAccessKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAccessKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetAccessKeyRequest proto.InternalMessageInfo

func (m *GetAccessKeyRequest) GetAccessKeyId() string {
	if m != nil {
		return m.AccessKeyId
	}
	return ""
}

type ListAccessKeysRequest struct {
	// ID of the service account to list access keys for.
	// To get the service account ID, use a [yandex.cloud.iam.v1.ServiceAccountService.List] request.
	// If not specified, it defaults to the subject that made the request.
	ServiceAccountId string `protobuf:"bytes,1,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListAccessKeysResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token]
	// to the [ListAccessKeysResponse.next_page_token]
	// returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAccessKeysRequest) Reset()         { *m = ListAccessKeysRequest{} }
func (m *ListAccessKeysRequest) String() string { return proto.CompactTextString(m) }
func (*ListAccessKeysRequest) ProtoMessage()    {}
func (*ListAccessKeysRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_82e7adea57f560ab, []int{1}
}

func (m *ListAccessKeysRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAccessKeysRequest.Unmarshal(m, b)
}
func (m *ListAccessKeysRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAccessKeysRequest.Marshal(b, m, deterministic)
}
func (m *ListAccessKeysRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAccessKeysRequest.Merge(m, src)
}
func (m *ListAccessKeysRequest) XXX_Size() int {
	return xxx_messageInfo_ListAccessKeysRequest.Size(m)
}
func (m *ListAccessKeysRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAccessKeysRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListAccessKeysRequest proto.InternalMessageInfo

func (m *ListAccessKeysRequest) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

func (m *ListAccessKeysRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListAccessKeysRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListAccessKeysResponse struct {
	// List of access keys.
	AccessKeys []*AccessKey `protobuf:"bytes,1,rep,name=access_keys,json=accessKeys,proto3" json:"access_keys,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListAccessKeysRequest.page_size], use
	// the [next_page_token] as the value
	// for the [ListAccessKeysRequest.page_token] query parameter
	// in the next list request. Each subsequent list request will have its own
	// [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAccessKeysResponse) Reset()         { *m = ListAccessKeysResponse{} }
func (m *ListAccessKeysResponse) String() string { return proto.CompactTextString(m) }
func (*ListAccessKeysResponse) ProtoMessage()    {}
func (*ListAccessKeysResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_82e7adea57f560ab, []int{2}
}

func (m *ListAccessKeysResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAccessKeysResponse.Unmarshal(m, b)
}
func (m *ListAccessKeysResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAccessKeysResponse.Marshal(b, m, deterministic)
}
func (m *ListAccessKeysResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAccessKeysResponse.Merge(m, src)
}
func (m *ListAccessKeysResponse) XXX_Size() int {
	return xxx_messageInfo_ListAccessKeysResponse.Size(m)
}
func (m *ListAccessKeysResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAccessKeysResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListAccessKeysResponse proto.InternalMessageInfo

func (m *ListAccessKeysResponse) GetAccessKeys() []*AccessKey {
	if m != nil {
		return m.AccessKeys
	}
	return nil
}

func (m *ListAccessKeysResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateAccessKeyRequest struct {
	// ID of the service account to create an access key for.
	// To get the service account ID, use a [yandex.cloud.iam.v1.ServiceAccountService.List] request.
	// If not specified, it defaults to the subject that made the request.
	ServiceAccountId string `protobuf:"bytes,1,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// Description of the access key.
	Description          string   `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateAccessKeyRequest) Reset()         { *m = CreateAccessKeyRequest{} }
func (m *CreateAccessKeyRequest) String() string { return proto.CompactTextString(m) }
func (*CreateAccessKeyRequest) ProtoMessage()    {}
func (*CreateAccessKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_82e7adea57f560ab, []int{3}
}

func (m *CreateAccessKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateAccessKeyRequest.Unmarshal(m, b)
}
func (m *CreateAccessKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateAccessKeyRequest.Marshal(b, m, deterministic)
}
func (m *CreateAccessKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateAccessKeyRequest.Merge(m, src)
}
func (m *CreateAccessKeyRequest) XXX_Size() int {
	return xxx_messageInfo_CreateAccessKeyRequest.Size(m)
}
func (m *CreateAccessKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateAccessKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateAccessKeyRequest proto.InternalMessageInfo

func (m *CreateAccessKeyRequest) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

func (m *CreateAccessKeyRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

type CreateAccessKeyResponse struct {
	// AccessKey resource.
	AccessKey *AccessKey `protobuf:"bytes,1,opt,name=access_key,json=accessKey,proto3" json:"access_key,omitempty"`
	// Secret access key.
	// The key is AWS compatible.
	Secret               string   `protobuf:"bytes,2,opt,name=secret,proto3" json:"secret,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateAccessKeyResponse) Reset()         { *m = CreateAccessKeyResponse{} }
func (m *CreateAccessKeyResponse) String() string { return proto.CompactTextString(m) }
func (*CreateAccessKeyResponse) ProtoMessage()    {}
func (*CreateAccessKeyResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_82e7adea57f560ab, []int{4}
}

func (m *CreateAccessKeyResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateAccessKeyResponse.Unmarshal(m, b)
}
func (m *CreateAccessKeyResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateAccessKeyResponse.Marshal(b, m, deterministic)
}
func (m *CreateAccessKeyResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateAccessKeyResponse.Merge(m, src)
}
func (m *CreateAccessKeyResponse) XXX_Size() int {
	return xxx_messageInfo_CreateAccessKeyResponse.Size(m)
}
func (m *CreateAccessKeyResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateAccessKeyResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CreateAccessKeyResponse proto.InternalMessageInfo

func (m *CreateAccessKeyResponse) GetAccessKey() *AccessKey {
	if m != nil {
		return m.AccessKey
	}
	return nil
}

func (m *CreateAccessKeyResponse) GetSecret() string {
	if m != nil {
		return m.Secret
	}
	return ""
}

type UpdateAccessKeyRequest struct {
	// ID of the AccessKey resource to update.
	// To get the access key ID, use a [AccessKeyService.List] request.
	AccessKeyId string `protobuf:"bytes,1,opt,name=access_key_id,json=accessKeyId,proto3" json:"access_key_id,omitempty"`
	// Field mask that specifies which fields of the Accesskey resource are going to be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Description of the access key.
	Description          string   `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateAccessKeyRequest) Reset()         { *m = UpdateAccessKeyRequest{} }
func (m *UpdateAccessKeyRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateAccessKeyRequest) ProtoMessage()    {}
func (*UpdateAccessKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_82e7adea57f560ab, []int{5}
}

func (m *UpdateAccessKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateAccessKeyRequest.Unmarshal(m, b)
}
func (m *UpdateAccessKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateAccessKeyRequest.Marshal(b, m, deterministic)
}
func (m *UpdateAccessKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateAccessKeyRequest.Merge(m, src)
}
func (m *UpdateAccessKeyRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateAccessKeyRequest.Size(m)
}
func (m *UpdateAccessKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateAccessKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateAccessKeyRequest proto.InternalMessageInfo

func (m *UpdateAccessKeyRequest) GetAccessKeyId() string {
	if m != nil {
		return m.AccessKeyId
	}
	return ""
}

func (m *UpdateAccessKeyRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateAccessKeyRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

type UpdateAccessKeyMetadata struct {
	// ID of the AccessKey resource that is being updated.
	AccessKeyId          string   `protobuf:"bytes,1,opt,name=access_key_id,json=accessKeyId,proto3" json:"access_key_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateAccessKeyMetadata) Reset()         { *m = UpdateAccessKeyMetadata{} }
func (m *UpdateAccessKeyMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateAccessKeyMetadata) ProtoMessage()    {}
func (*UpdateAccessKeyMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_82e7adea57f560ab, []int{6}
}

func (m *UpdateAccessKeyMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateAccessKeyMetadata.Unmarshal(m, b)
}
func (m *UpdateAccessKeyMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateAccessKeyMetadata.Marshal(b, m, deterministic)
}
func (m *UpdateAccessKeyMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateAccessKeyMetadata.Merge(m, src)
}
func (m *UpdateAccessKeyMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateAccessKeyMetadata.Size(m)
}
func (m *UpdateAccessKeyMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateAccessKeyMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateAccessKeyMetadata proto.InternalMessageInfo

func (m *UpdateAccessKeyMetadata) GetAccessKeyId() string {
	if m != nil {
		return m.AccessKeyId
	}
	return ""
}

type DeleteAccessKeyRequest struct {
	// ID of the access key to delete.
	// To get the access key ID, use a [AccessKeyService.List] request.
	AccessKeyId          string   `protobuf:"bytes,1,opt,name=access_key_id,json=accessKeyId,proto3" json:"access_key_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteAccessKeyRequest) Reset()         { *m = DeleteAccessKeyRequest{} }
func (m *DeleteAccessKeyRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteAccessKeyRequest) ProtoMessage()    {}
func (*DeleteAccessKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_82e7adea57f560ab, []int{7}
}

func (m *DeleteAccessKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteAccessKeyRequest.Unmarshal(m, b)
}
func (m *DeleteAccessKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteAccessKeyRequest.Marshal(b, m, deterministic)
}
func (m *DeleteAccessKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteAccessKeyRequest.Merge(m, src)
}
func (m *DeleteAccessKeyRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteAccessKeyRequest.Size(m)
}
func (m *DeleteAccessKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteAccessKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteAccessKeyRequest proto.InternalMessageInfo

func (m *DeleteAccessKeyRequest) GetAccessKeyId() string {
	if m != nil {
		return m.AccessKeyId
	}
	return ""
}

type DeleteAccessKeyMetadata struct {
	// ID of the access key that is being deleted.
	AccessKeyId          string   `protobuf:"bytes,1,opt,name=access_key_id,json=accessKeyId,proto3" json:"access_key_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteAccessKeyMetadata) Reset()         { *m = DeleteAccessKeyMetadata{} }
func (m *DeleteAccessKeyMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteAccessKeyMetadata) ProtoMessage()    {}
func (*DeleteAccessKeyMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_82e7adea57f560ab, []int{8}
}

func (m *DeleteAccessKeyMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteAccessKeyMetadata.Unmarshal(m, b)
}
func (m *DeleteAccessKeyMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteAccessKeyMetadata.Marshal(b, m, deterministic)
}
func (m *DeleteAccessKeyMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteAccessKeyMetadata.Merge(m, src)
}
func (m *DeleteAccessKeyMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteAccessKeyMetadata.Size(m)
}
func (m *DeleteAccessKeyMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteAccessKeyMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteAccessKeyMetadata proto.InternalMessageInfo

func (m *DeleteAccessKeyMetadata) GetAccessKeyId() string {
	if m != nil {
		return m.AccessKeyId
	}
	return ""
}

type ListAccessKeyOperationsRequest struct {
	// ID of the key to list operations for.
	AccessKeyId string `protobuf:"bytes,1,opt,name=access_key_id,json=accessKeyId,proto3" json:"access_key_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListAccessKeyOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListAccessKeyOperationsResponse.next_page_token] returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAccessKeyOperationsRequest) Reset()         { *m = ListAccessKeyOperationsRequest{} }
func (m *ListAccessKeyOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListAccessKeyOperationsRequest) ProtoMessage()    {}
func (*ListAccessKeyOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_82e7adea57f560ab, []int{9}
}

func (m *ListAccessKeyOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAccessKeyOperationsRequest.Unmarshal(m, b)
}
func (m *ListAccessKeyOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAccessKeyOperationsRequest.Marshal(b, m, deterministic)
}
func (m *ListAccessKeyOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAccessKeyOperationsRequest.Merge(m, src)
}
func (m *ListAccessKeyOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListAccessKeyOperationsRequest.Size(m)
}
func (m *ListAccessKeyOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAccessKeyOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListAccessKeyOperationsRequest proto.InternalMessageInfo

func (m *ListAccessKeyOperationsRequest) GetAccessKeyId() string {
	if m != nil {
		return m.AccessKeyId
	}
	return ""
}

func (m *ListAccessKeyOperationsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListAccessKeyOperationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListAccessKeyOperationsResponse struct {
	// List of operations for the specified access key.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListAccessKeyOperationsRequest.page_size], use the [next_page_token] as the value
	// for the [ListAccessKeyOperationsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAccessKeyOperationsResponse) Reset()         { *m = ListAccessKeyOperationsResponse{} }
func (m *ListAccessKeyOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListAccessKeyOperationsResponse) ProtoMessage()    {}
func (*ListAccessKeyOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_82e7adea57f560ab, []int{10}
}

func (m *ListAccessKeyOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAccessKeyOperationsResponse.Unmarshal(m, b)
}
func (m *ListAccessKeyOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAccessKeyOperationsResponse.Marshal(b, m, deterministic)
}
func (m *ListAccessKeyOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAccessKeyOperationsResponse.Merge(m, src)
}
func (m *ListAccessKeyOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListAccessKeyOperationsResponse.Size(m)
}
func (m *ListAccessKeyOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAccessKeyOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListAccessKeyOperationsResponse proto.InternalMessageInfo

func (m *ListAccessKeyOperationsResponse) GetOperations() []*operation.Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListAccessKeyOperationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*GetAccessKeyRequest)(nil), "yandex.cloud.iam.v1.awscompatibility.GetAccessKeyRequest")
	proto.RegisterType((*ListAccessKeysRequest)(nil), "yandex.cloud.iam.v1.awscompatibility.ListAccessKeysRequest")
	proto.RegisterType((*ListAccessKeysResponse)(nil), "yandex.cloud.iam.v1.awscompatibility.ListAccessKeysResponse")
	proto.RegisterType((*CreateAccessKeyRequest)(nil), "yandex.cloud.iam.v1.awscompatibility.CreateAccessKeyRequest")
	proto.RegisterType((*CreateAccessKeyResponse)(nil), "yandex.cloud.iam.v1.awscompatibility.CreateAccessKeyResponse")
	proto.RegisterType((*UpdateAccessKeyRequest)(nil), "yandex.cloud.iam.v1.awscompatibility.UpdateAccessKeyRequest")
	proto.RegisterType((*UpdateAccessKeyMetadata)(nil), "yandex.cloud.iam.v1.awscompatibility.UpdateAccessKeyMetadata")
	proto.RegisterType((*DeleteAccessKeyRequest)(nil), "yandex.cloud.iam.v1.awscompatibility.DeleteAccessKeyRequest")
	proto.RegisterType((*DeleteAccessKeyMetadata)(nil), "yandex.cloud.iam.v1.awscompatibility.DeleteAccessKeyMetadata")
	proto.RegisterType((*ListAccessKeyOperationsRequest)(nil), "yandex.cloud.iam.v1.awscompatibility.ListAccessKeyOperationsRequest")
	proto.RegisterType((*ListAccessKeyOperationsResponse)(nil), "yandex.cloud.iam.v1.awscompatibility.ListAccessKeyOperationsResponse")
}

func init() {
	proto.RegisterFile("yandex/cloud/iam/v1/awscompatibility/access_key_service.proto", fileDescriptor_82e7adea57f560ab)
}

var fileDescriptor_82e7adea57f560ab = []byte{
	// 880 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0xcf, 0x8f, 0xdb, 0x44,
	0x14, 0xd6, 0x34, 0x25, 0x6a, 0x5e, 0x28, 0x54, 0x83, 0x9a, 0x46, 0x16, 0x3f, 0x82, 0xb5, 0x5a,
	0x42, 0x20, 0x76, 0x12, 0xd8, 0x48, 0x65, 0x13, 0xa1, 0x2c, 0x2d, 0x51, 0x81, 0x42, 0xe5, 0xc2,
	0x01, 0x2e, 0xd1, 0xc4, 0x9e, 0x86, 0x51, 0x12, 0xdb, 0x64, 0x26, 0x69, 0x53, 0xd4, 0x03, 0x48,
	0x5c, 0x56, 0x9c, 0xe0, 0x3f, 0x40, 0xe2, 0xbc, 0xd2, 0x0a, 0xf1, 0x2f, 0xec, 0x4a, 0xdc, 0x96,
	0x23, 0x57, 0x84, 0xf8, 0x1b, 0x38, 0x21, 0x8f, 0x1d, 0x3b, 0xce, 0x0f, 0x70, 0x0c, 0xb7, 0xc4,
	0xf3, 0xde, 0x37, 0xdf, 0xfb, 0xe6, 0xbd, 0x6f, 0x06, 0xda, 0x73, 0x62, 0x5b, 0xf4, 0x91, 0x6e,
	0x8e, 0x9c, 0xa9, 0xa5, 0x33, 0x32, 0xd6, 0x67, 0x75, 0x9d, 0x3c, 0xe4, 0xa6, 0x33, 0x76, 0x89,
	0x60, 0x7d, 0x36, 0x62, 0x62, 0xae, 0x13, 0xd3, 0xa4, 0x9c, 0xf7, 0x86, 0x74, 0xde, 0xe3, 0x74,
	0x32, 0x63, 0x26, 0xd5, 0xdc, 0x89, 0x23, 0x1c, 0xbc, 0xe7, 0xa7, 0x6b, 0x32, 0x5d, 0x63, 0x64,
	0xac, 0xcd, 0xea, 0xda, 0x6a, 0xba, 0xf2, 0xfc, 0xc0, 0x71, 0x06, 0x23, 0xaa, 0x13, 0x97, 0xe9,
	0xc4, 0xb6, 0x1d, 0x41, 0x04, 0x73, 0x6c, 0xee, 0x63, 0x28, 0xa5, 0x60, 0x55, 0xfe, 0xeb, 0x4f,
	0x1f, 0xe8, 0x0f, 0x18, 0x1d, 0x59, 0xbd, 0x31, 0xe1, 0xc3, 0x45, 0x44, 0x8c, 0xa4, 0x87, 0xe2,
	0xb8, 0x74, 0x22, 0x41, 0x82, 0x88, 0x83, 0x1d, 0xcb, 0x08, 0xd2, 0xf6, 0x63, 0x69, 0x21, 0xe8,
	0x1a, 0xfc, 0x0b, 0xb1, 0xb8, 0x19, 0x19, 0x31, 0x6b, 0x69, 0x59, 0xed, 0xc2, 0x73, 0x5d, 0x2a,
	0x3a, 0x12, 0xfd, 0x7d, 0x3a, 0x37, 0xe8, 0x17, 0x53, 0xca, 0x05, 0xae, 0xc1, 0xd5, 0x25, 0xe1,
	0x98, 0x55, 0x44, 0x25, 0x54, 0xce, 0x1d, 0x3d, 0xfd, 0xe7, 0x59, 0x1d, 0x1d, 0x9f, 0xd7, 0x2f,
	0xb7, 0xda, 0x07, 0x35, 0x23, 0x4f, 0x16, 0x69, 0x77, 0x2c, 0xf5, 0x07, 0x04, 0xd7, 0x3f, 0x60,
	0x3c, 0x82, 0xe2, 0x0b, 0xac, 0x26, 0xe0, 0x40, 0xf9, 0x1e, 0x31, 0x4d, 0x67, 0x6a, 0x8b, 0x08,
	0xf0, 0x4a, 0x08, 0x76, 0x2d, 0x88, 0xe9, 0xf8, 0x21, 0x77, 0x2c, 0xfc, 0x0a, 0xe4, 0x5c, 0x32,
	0xa0, 0x3d, 0xce, 0x1e, 0xd3, 0xe2, 0xa5, 0x12, 0x2a, 0x67, 0x8e, 0xe0, 0xaf, 0xb3, 0x7a, 0xb6,
	0xd5, 0xae, 0xd7, 0x6a, 0x35, 0xe3, 0x8a, 0xb7, 0x78, 0x9f, 0x3d, 0xa6, 0xb8, 0x0c, 0x20, 0x03,
	0x85, 0x33, 0xa4, 0x76, 0x31, 0x23, 0x81, 0x73, 0xc7, 0xe7, 0xf5, 0xa7, 0x64, 0xa4, 0x21, 0x51,
	0x3e, 0xf6, 0xd6, 0xd4, 0xef, 0x10, 0x14, 0x56, 0x49, 0x72, 0xd7, 0xb1, 0x39, 0xc5, 0xf7, 0x20,
	0x1f, 0x55, 0xcc, 0x8b, 0xa8, 0x94, 0x29, 0xe7, 0x1b, 0xba, 0x96, 0xa4, 0x49, 0xb4, 0x48, 0x3e,
	0x08, 0x25, 0xe1, 0x78, 0x1f, 0x9e, 0xb5, 0xe9, 0x23, 0xd1, 0x5b, 0xe2, 0xe6, 0x55, 0x91, 0x33,
	0xae, 0x7a, 0x9f, 0xef, 0x85, 0xa4, 0x9e, 0x40, 0xe1, 0x9d, 0x09, 0x25, 0x82, 0xae, 0x9d, 0x42,
	0x5a, 0xe5, 0x5e, 0x83, 0xbc, 0x45, 0xb9, 0x39, 0x61, 0xae, 0x77, 0xd2, 0xfe, 0xae, 0x0b, 0x45,
	0x1a, 0x07, 0x4d, 0x63, 0x79, 0x55, 0xfd, 0x0a, 0xc1, 0x8d, 0xb5, 0xfd, 0x03, 0x51, 0x3e, 0x04,
	0x88, 0x44, 0x91, 0x1b, 0xa7, 0xd0, 0x24, 0x17, 0x6a, 0x82, 0x0b, 0x90, 0xe5, 0xd4, 0x9c, 0x50,
	0x11, 0x28, 0x11, 0xfc, 0x53, 0x7f, 0x42, 0x50, 0xf8, 0xc4, 0xb5, 0x36, 0x69, 0xb0, 0x73, 0x27,
	0xe2, 0x43, 0xc8, 0x4f, 0x25, 0x96, 0x9c, 0x43, 0xb9, 0x53, 0xbe, 0xa1, 0x68, 0xfe, 0xa8, 0x6a,
	0x8b, 0x51, 0xd5, 0xde, 0xf5, 0x46, 0xf5, 0x2e, 0xe1, 0x43, 0x03, 0xfc, 0x70, 0xef, 0xf7, 0xaa,
	0x74, 0x99, 0x7f, 0x94, 0xae, 0x0d, 0x37, 0x56, 0x58, 0xdf, 0xa5, 0x82, 0x58, 0x44, 0x10, 0xac,
	0x6e, 0xa4, 0x1d, 0x1f, 0x99, 0xf7, 0xa0, 0x70, 0x8b, 0x8e, 0xe8, 0xff, 0x51, 0xb4, 0x47, 0x65,
	0x05, 0x6b, 0x27, 0x2a, 0x3f, 0x22, 0x78, 0x31, 0x36, 0x18, 0x1f, 0x2d, 0x6c, 0x84, 0xa7, 0x3f,
	0x88, 0x6d, 0x03, 0x5c, 0xab, 0xa6, 0x1e, 0xe0, 0x6f, 0x11, 0xbc, 0xb4, 0x95, 0x67, 0xd0, 0xb4,
	0x1d, 0x80, 0xd0, 0x04, 0x17, 0x83, 0xfc, 0x72, 0xbc, 0x69, 0x23, 0x93, 0x0c, 0xf3, 0x8d, 0xa5,
	0xa4, 0xa4, 0xa3, 0xdb, 0xf8, 0x25, 0x07, 0xd7, 0x42, 0x2a, 0xf7, 0xfd, 0x31, 0xc4, 0x27, 0x08,
	0x2e, 0x7b, 0x1c, 0xf1, 0x61, 0xb2, 0x49, 0xd9, 0xe8, 0x9a, 0x4a, 0x2b, 0x5d, 0xb2, 0xaf, 0x81,
	0xfa, 0xfa, 0xd7, 0xbf, 0xfe, 0xfe, 0xfd, 0xa5, 0x7d, 0xbc, 0x27, 0x2f, 0x14, 0xf2, 0x90, 0x57,
	0xe3, 0xd7, 0x89, 0x77, 0xc5, 0x44, 0x4e, 0x75, 0x82, 0x20, 0xd3, 0xa5, 0x02, 0xdf, 0x4c, 0xb6,
	0xe7, 0x86, 0x0b, 0x43, 0xd9, 0xd5, 0x15, 0xd4, 0x96, 0x64, 0xd8, 0xc4, 0x6f, 0x26, 0x61, 0xa8,
	0x7f, 0x19, 0x6b, 0xbd, 0x27, 0xf8, 0x67, 0x04, 0x59, 0xdf, 0xb4, 0x70, 0x42, 0xa1, 0x36, 0x5b,
	0xac, 0xd2, 0x4e, 0x99, 0x1d, 0xe8, 0xac, 0xcb, 0x2a, 0x5e, 0x55, 0x13, 0xe9, 0xfc, 0x16, 0xaa,
	0xe0, 0x0b, 0x04, 0x59, 0xdf, 0x33, 0x92, 0x12, 0xdf, 0xec, 0x8b, 0xca, 0xbf, 0x77, 0xb4, 0x3a,
	0x38, 0xbd, 0xa8, 0xec, 0x6d, 0xb7, 0xa8, 0x5c, 0xf8, 0x49, 0x16, 0x71, 0xb3, 0x91, 0xea, 0x28,
	0xbc, 0xa2, 0x7e, 0x43, 0x90, 0xf5, 0xdd, 0x27, 0x69, 0x51, 0x9b, 0x7d, 0x2f, 0x49, 0x51, 0xee,
	0xe9, 0x45, 0xa5, 0xb6, 0xdd, 0xec, 0xae, 0xaf, 0xda, 0xfc, 0xed, 0xb1, 0x2b, 0xfc, 0x02, 0x9b,
	0x95, 0x74, 0xbd, 0xf6, 0x07, 0x82, 0x67, 0xbc, 0x31, 0x8b, 0xac, 0x06, 0xdf, 0x4a, 0x31, 0x9c,
	0x6b, 0x8e, 0xaa, 0xdc, 0xfe, 0x8f, 0x28, 0x41, 0x0f, 0x76, 0x65, 0x75, 0x1d, 0xfc, 0x76, 0x9a,
	0xea, 0xa2, 0xf7, 0x22, 0x3f, 0xfa, 0x06, 0x41, 0x39, 0xc6, 0x88, 0xb8, 0x6c, 0x1b, 0xab, 0xcf,
	0x3e, 0x1d, 0x30, 0xf1, 0xf9, 0xb4, 0xaf, 0x99, 0xce, 0x58, 0xf7, 0x93, 0xaa, 0xfe, 0x13, 0x73,
	0xe0, 0x54, 0x07, 0xd4, 0x96, 0xfa, 0xeb, 0x49, 0x9e, 0xb6, 0x87, 0xab, 0x1f, 0xfa, 0x59, 0x99,
	0xfc, 0xc6, 0xdf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x7a, 0x75, 0xbb, 0x58, 0xe1, 0x0b, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AccessKeyServiceClient is the client API for AccessKeyService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AccessKeyServiceClient interface {
	// Retrieves the list of access keys for the specified service account.
	List(ctx context.Context, in *ListAccessKeysRequest, opts ...grpc.CallOption) (*ListAccessKeysResponse, error)
	// Returns the specified access key.
	//
	// To get the list of available access keys, make a [List] request.
	Get(ctx context.Context, in *GetAccessKeyRequest, opts ...grpc.CallOption) (*AccessKey, error)
	// Creates an access key for the specified service account.
	Create(ctx context.Context, in *CreateAccessKeyRequest, opts ...grpc.CallOption) (*CreateAccessKeyResponse, error)
	// Updates the specified access key.
	Update(ctx context.Context, in *UpdateAccessKeyRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified access key.
	Delete(ctx context.Context, in *DeleteAccessKeyRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Retrieves the list of operations for the specified access key.
	ListOperations(ctx context.Context, in *ListAccessKeyOperationsRequest, opts ...grpc.CallOption) (*ListAccessKeyOperationsResponse, error)
}

type accessKeyServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAccessKeyServiceClient(cc grpc.ClientConnInterface) AccessKeyServiceClient {
	return &accessKeyServiceClient{cc}
}

func (c *accessKeyServiceClient) List(ctx context.Context, in *ListAccessKeysRequest, opts ...grpc.CallOption) (*ListAccessKeysResponse, error) {
	out := new(ListAccessKeysResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.awscompatibility.AccessKeyService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessKeyServiceClient) Get(ctx context.Context, in *GetAccessKeyRequest, opts ...grpc.CallOption) (*AccessKey, error) {
	out := new(AccessKey)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.awscompatibility.AccessKeyService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessKeyServiceClient) Create(ctx context.Context, in *CreateAccessKeyRequest, opts ...grpc.CallOption) (*CreateAccessKeyResponse, error) {
	out := new(CreateAccessKeyResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.awscompatibility.AccessKeyService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessKeyServiceClient) Update(ctx context.Context, in *UpdateAccessKeyRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.awscompatibility.AccessKeyService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessKeyServiceClient) Delete(ctx context.Context, in *DeleteAccessKeyRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.awscompatibility.AccessKeyService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessKeyServiceClient) ListOperations(ctx context.Context, in *ListAccessKeyOperationsRequest, opts ...grpc.CallOption) (*ListAccessKeyOperationsResponse, error) {
	out := new(ListAccessKeyOperationsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.awscompatibility.AccessKeyService/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AccessKeyServiceServer is the server API for AccessKeyService service.
type AccessKeyServiceServer interface {
	// Retrieves the list of access keys for the specified service account.
	List(context.Context, *ListAccessKeysRequest) (*ListAccessKeysResponse, error)
	// Returns the specified access key.
	//
	// To get the list of available access keys, make a [List] request.
	Get(context.Context, *GetAccessKeyRequest) (*AccessKey, error)
	// Creates an access key for the specified service account.
	Create(context.Context, *CreateAccessKeyRequest) (*CreateAccessKeyResponse, error)
	// Updates the specified access key.
	Update(context.Context, *UpdateAccessKeyRequest) (*operation.Operation, error)
	// Deletes the specified access key.
	Delete(context.Context, *DeleteAccessKeyRequest) (*operation.Operation, error)
	// Retrieves the list of operations for the specified access key.
	ListOperations(context.Context, *ListAccessKeyOperationsRequest) (*ListAccessKeyOperationsResponse, error)
}

// UnimplementedAccessKeyServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAccessKeyServiceServer struct {
}

func (*UnimplementedAccessKeyServiceServer) List(ctx context.Context, req *ListAccessKeysRequest) (*ListAccessKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedAccessKeyServiceServer) Get(ctx context.Context, req *GetAccessKeyRequest) (*AccessKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedAccessKeyServiceServer) Create(ctx context.Context, req *CreateAccessKeyRequest) (*CreateAccessKeyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (*UnimplementedAccessKeyServiceServer) Update(ctx context.Context, req *UpdateAccessKeyRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (*UnimplementedAccessKeyServiceServer) Delete(ctx context.Context, req *DeleteAccessKeyRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedAccessKeyServiceServer) ListOperations(ctx context.Context, req *ListAccessKeyOperationsRequest) (*ListAccessKeyOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOperations not implemented")
}

func RegisterAccessKeyServiceServer(s *grpc.Server, srv AccessKeyServiceServer) {
	s.RegisterService(&_AccessKeyService_serviceDesc, srv)
}

func _AccessKeyService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAccessKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessKeyServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.awscompatibility.AccessKeyService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessKeyServiceServer).List(ctx, req.(*ListAccessKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessKeyService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAccessKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessKeyServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.awscompatibility.AccessKeyService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessKeyServiceServer).Get(ctx, req.(*GetAccessKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessKeyService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAccessKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessKeyServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.awscompatibility.AccessKeyService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessKeyServiceServer).Create(ctx, req.(*CreateAccessKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessKeyService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAccessKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessKeyServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.awscompatibility.AccessKeyService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessKeyServiceServer).Update(ctx, req.(*UpdateAccessKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessKeyService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAccessKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessKeyServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.awscompatibility.AccessKeyService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessKeyServiceServer).Delete(ctx, req.(*DeleteAccessKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessKeyService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAccessKeyOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessKeyServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.awscompatibility.AccessKeyService/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessKeyServiceServer).ListOperations(ctx, req.(*ListAccessKeyOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AccessKeyService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.iam.v1.awscompatibility.AccessKeyService",
	HandlerType: (*AccessKeyServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "List",
			Handler:    _AccessKeyService_List_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _AccessKeyService_Get_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _AccessKeyService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _AccessKeyService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _AccessKeyService_Delete_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _AccessKeyService_ListOperations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/iam/v1/awscompatibility/access_key_service.proto",
}
