// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/iam/v1/service_account_service.proto

package iam

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	access "github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type GetServiceAccountRequest struct {
	// ID of the ServiceAccount resource to return.
	// To get the service account ID, use a [ServiceAccountService.List] request.
	ServiceAccountId     string   `protobuf:"bytes,1,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetServiceAccountRequest) Reset()         { *m = GetServiceAccountRequest{} }
func (m *GetServiceAccountRequest) String() string { return proto.CompactTextString(m) }
func (*GetServiceAccountRequest) ProtoMessage()    {}
func (*GetServiceAccountRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b44ea8947de11d22, []int{0}
}

func (m *GetServiceAccountRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetServiceAccountRequest.Unmarshal(m, b)
}
func (m *GetServiceAccountRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetServiceAccountRequest.Marshal(b, m, deterministic)
}
func (m *GetServiceAccountRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetServiceAccountRequest.Merge(m, src)
}
func (m *GetServiceAccountRequest) XXX_Size() int {
	return xxx_messageInfo_GetServiceAccountRequest.Size(m)
}
func (m *GetServiceAccountRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetServiceAccountRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetServiceAccountRequest proto.InternalMessageInfo

func (m *GetServiceAccountRequest) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

type ListServiceAccountsRequest struct {
	// ID of the folder to list service accounts in.
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListServiceAccountsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token]
	// to the [ListServiceAccountsResponse.next_page_token]
	// returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// The expression must specify:
	// 1. The field name. Currently you can use filtering only on the [ServiceAccount.name] field.
	// 2. An operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.
	// 3. The value. Must be 3-63 characters long and match the regular expression `^[a-z][-a-z0-9]{1,61}[a-z0-9]$`.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListServiceAccountsRequest) Reset()         { *m = ListServiceAccountsRequest{} }
func (m *ListServiceAccountsRequest) String() string { return proto.CompactTextString(m) }
func (*ListServiceAccountsRequest) ProtoMessage()    {}
func (*ListServiceAccountsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b44ea8947de11d22, []int{1}
}

func (m *ListServiceAccountsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListServiceAccountsRequest.Unmarshal(m, b)
}
func (m *ListServiceAccountsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListServiceAccountsRequest.Marshal(b, m, deterministic)
}
func (m *ListServiceAccountsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListServiceAccountsRequest.Merge(m, src)
}
func (m *ListServiceAccountsRequest) XXX_Size() int {
	return xxx_messageInfo_ListServiceAccountsRequest.Size(m)
}
func (m *ListServiceAccountsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListServiceAccountsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListServiceAccountsRequest proto.InternalMessageInfo

func (m *ListServiceAccountsRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *ListServiceAccountsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListServiceAccountsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListServiceAccountsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListServiceAccountsResponse struct {
	// List of ServiceAccount resources.
	ServiceAccounts []*ServiceAccount `protobuf:"bytes,1,rep,name=service_accounts,json=serviceAccounts,proto3" json:"service_accounts,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListServiceAccountsRequest.page_size], use
	// the [next_page_token] as the value
	// for the [ListServiceAccountsRequest.page_token] query parameter
	// in the next list request. Each subsequent list request will have its own
	// [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListServiceAccountsResponse) Reset()         { *m = ListServiceAccountsResponse{} }
func (m *ListServiceAccountsResponse) String() string { return proto.CompactTextString(m) }
func (*ListServiceAccountsResponse) ProtoMessage()    {}
func (*ListServiceAccountsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b44ea8947de11d22, []int{2}
}

func (m *ListServiceAccountsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListServiceAccountsResponse.Unmarshal(m, b)
}
func (m *ListServiceAccountsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListServiceAccountsResponse.Marshal(b, m, deterministic)
}
func (m *ListServiceAccountsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListServiceAccountsResponse.Merge(m, src)
}
func (m *ListServiceAccountsResponse) XXX_Size() int {
	return xxx_messageInfo_ListServiceAccountsResponse.Size(m)
}
func (m *ListServiceAccountsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListServiceAccountsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListServiceAccountsResponse proto.InternalMessageInfo

func (m *ListServiceAccountsResponse) GetServiceAccounts() []*ServiceAccount {
	if m != nil {
		return m.ServiceAccounts
	}
	return nil
}

func (m *ListServiceAccountsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateServiceAccountRequest struct {
	// ID of the folder to create a service account in.
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the service account.
	// The name must be unique within the cloud.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the service account.
	Description          string   `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateServiceAccountRequest) Reset()         { *m = CreateServiceAccountRequest{} }
func (m *CreateServiceAccountRequest) String() string { return proto.CompactTextString(m) }
func (*CreateServiceAccountRequest) ProtoMessage()    {}
func (*CreateServiceAccountRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b44ea8947de11d22, []int{3}
}

func (m *CreateServiceAccountRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateServiceAccountRequest.Unmarshal(m, b)
}
func (m *CreateServiceAccountRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateServiceAccountRequest.Marshal(b, m, deterministic)
}
func (m *CreateServiceAccountRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateServiceAccountRequest.Merge(m, src)
}
func (m *CreateServiceAccountRequest) XXX_Size() int {
	return xxx_messageInfo_CreateServiceAccountRequest.Size(m)
}
func (m *CreateServiceAccountRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateServiceAccountRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateServiceAccountRequest proto.InternalMessageInfo

func (m *CreateServiceAccountRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *CreateServiceAccountRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateServiceAccountRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

type CreateServiceAccountMetadata struct {
	// ID of the service account that is being created.
	ServiceAccountId     string   `protobuf:"bytes,1,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateServiceAccountMetadata) Reset()         { *m = CreateServiceAccountMetadata{} }
func (m *CreateServiceAccountMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateServiceAccountMetadata) ProtoMessage()    {}
func (*CreateServiceAccountMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_b44ea8947de11d22, []int{4}
}

func (m *CreateServiceAccountMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateServiceAccountMetadata.Unmarshal(m, b)
}
func (m *CreateServiceAccountMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateServiceAccountMetadata.Marshal(b, m, deterministic)
}
func (m *CreateServiceAccountMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateServiceAccountMetadata.Merge(m, src)
}
func (m *CreateServiceAccountMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateServiceAccountMetadata.Size(m)
}
func (m *CreateServiceAccountMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateServiceAccountMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateServiceAccountMetadata proto.InternalMessageInfo

func (m *CreateServiceAccountMetadata) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

type UpdateServiceAccountRequest struct {
	// ID of the ServiceAccount resource to update.
	// To get the service account ID, use a [ServiceAccountService.List] request.
	ServiceAccountId string `protobuf:"bytes,1,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// Field mask that specifies which fields of the ServiceAccount resource are going to be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Name of the service account.
	// The name must be unique within the cloud.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the service account.
	Description          string   `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateServiceAccountRequest) Reset()         { *m = UpdateServiceAccountRequest{} }
func (m *UpdateServiceAccountRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateServiceAccountRequest) ProtoMessage()    {}
func (*UpdateServiceAccountRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b44ea8947de11d22, []int{5}
}

func (m *UpdateServiceAccountRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateServiceAccountRequest.Unmarshal(m, b)
}
func (m *UpdateServiceAccountRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateServiceAccountRequest.Marshal(b, m, deterministic)
}
func (m *UpdateServiceAccountRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateServiceAccountRequest.Merge(m, src)
}
func (m *UpdateServiceAccountRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateServiceAccountRequest.Size(m)
}
func (m *UpdateServiceAccountRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateServiceAccountRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateServiceAccountRequest proto.InternalMessageInfo

func (m *UpdateServiceAccountRequest) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

func (m *UpdateServiceAccountRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateServiceAccountRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateServiceAccountRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

type UpdateServiceAccountMetadata struct {
	// ID of the ServiceAccount resource that is being updated.
	ServiceAccountId     string   `protobuf:"bytes,1,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateServiceAccountMetadata) Reset()         { *m = UpdateServiceAccountMetadata{} }
func (m *UpdateServiceAccountMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateServiceAccountMetadata) ProtoMessage()    {}
func (*UpdateServiceAccountMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_b44ea8947de11d22, []int{6}
}

func (m *UpdateServiceAccountMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateServiceAccountMetadata.Unmarshal(m, b)
}
func (m *UpdateServiceAccountMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateServiceAccountMetadata.Marshal(b, m, deterministic)
}
func (m *UpdateServiceAccountMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateServiceAccountMetadata.Merge(m, src)
}
func (m *UpdateServiceAccountMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateServiceAccountMetadata.Size(m)
}
func (m *UpdateServiceAccountMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateServiceAccountMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateServiceAccountMetadata proto.InternalMessageInfo

func (m *UpdateServiceAccountMetadata) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

type DeleteServiceAccountRequest struct {
	// ID of the service account to delete.
	// To get the service account ID, use a [ServiceAccountService.List] request.
	ServiceAccountId     string   `protobuf:"bytes,1,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteServiceAccountRequest) Reset()         { *m = DeleteServiceAccountRequest{} }
func (m *DeleteServiceAccountRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteServiceAccountRequest) ProtoMessage()    {}
func (*DeleteServiceAccountRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b44ea8947de11d22, []int{7}
}

func (m *DeleteServiceAccountRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteServiceAccountRequest.Unmarshal(m, b)
}
func (m *DeleteServiceAccountRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteServiceAccountRequest.Marshal(b, m, deterministic)
}
func (m *DeleteServiceAccountRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteServiceAccountRequest.Merge(m, src)
}
func (m *DeleteServiceAccountRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteServiceAccountRequest.Size(m)
}
func (m *DeleteServiceAccountRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteServiceAccountRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteServiceAccountRequest proto.InternalMessageInfo

func (m *DeleteServiceAccountRequest) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

type DeleteServiceAccountMetadata struct {
	// ID of the service account that is being deleted.
	ServiceAccountId     string   `protobuf:"bytes,1,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteServiceAccountMetadata) Reset()         { *m = DeleteServiceAccountMetadata{} }
func (m *DeleteServiceAccountMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteServiceAccountMetadata) ProtoMessage()    {}
func (*DeleteServiceAccountMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_b44ea8947de11d22, []int{8}
}

func (m *DeleteServiceAccountMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteServiceAccountMetadata.Unmarshal(m, b)
}
func (m *DeleteServiceAccountMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteServiceAccountMetadata.Marshal(b, m, deterministic)
}
func (m *DeleteServiceAccountMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteServiceAccountMetadata.Merge(m, src)
}
func (m *DeleteServiceAccountMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteServiceAccountMetadata.Size(m)
}
func (m *DeleteServiceAccountMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteServiceAccountMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteServiceAccountMetadata proto.InternalMessageInfo

func (m *DeleteServiceAccountMetadata) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

type ListServiceAccountOperationsRequest struct {
	// ID of the ServiceAccount resource to list operations for.
	ServiceAccountId string `protobuf:"bytes,1,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListServiceAccountOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token]
	// to the [ListServiceAccountOperationsResponse.next_page_token]
	// returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListServiceAccountOperationsRequest) Reset()         { *m = ListServiceAccountOperationsRequest{} }
func (m *ListServiceAccountOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListServiceAccountOperationsRequest) ProtoMessage()    {}
func (*ListServiceAccountOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b44ea8947de11d22, []int{9}
}

func (m *ListServiceAccountOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListServiceAccountOperationsRequest.Unmarshal(m, b)
}
func (m *ListServiceAccountOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListServiceAccountOperationsRequest.Marshal(b, m, deterministic)
}
func (m *ListServiceAccountOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListServiceAccountOperationsRequest.Merge(m, src)
}
func (m *ListServiceAccountOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListServiceAccountOperationsRequest.Size(m)
}
func (m *ListServiceAccountOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListServiceAccountOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListServiceAccountOperationsRequest proto.InternalMessageInfo

func (m *ListServiceAccountOperationsRequest) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

func (m *ListServiceAccountOperationsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListServiceAccountOperationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListServiceAccountOperationsResponse struct {
	// List of operations for the specified service account.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListServiceAccountOperationsRequest.page_size], use the [next_page_token] as the value
	// for the [ListServiceAccountOperationsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListServiceAccountOperationsResponse) Reset()         { *m = ListServiceAccountOperationsResponse{} }
func (m *ListServiceAccountOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListServiceAccountOperationsResponse) ProtoMessage()    {}
func (*ListServiceAccountOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b44ea8947de11d22, []int{10}
}

func (m *ListServiceAccountOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListServiceAccountOperationsResponse.Unmarshal(m, b)
}
func (m *ListServiceAccountOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListServiceAccountOperationsResponse.Marshal(b, m, deterministic)
}
func (m *ListServiceAccountOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListServiceAccountOperationsResponse.Merge(m, src)
}
func (m *ListServiceAccountOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListServiceAccountOperationsResponse.Size(m)
}
func (m *ListServiceAccountOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListServiceAccountOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListServiceAccountOperationsResponse proto.InternalMessageInfo

func (m *ListServiceAccountOperationsResponse) GetOperations() []*operation.Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListServiceAccountOperationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*GetServiceAccountRequest)(nil), "yandex.cloud.iam.v1.GetServiceAccountRequest")
	proto.RegisterType((*ListServiceAccountsRequest)(nil), "yandex.cloud.iam.v1.ListServiceAccountsRequest")
	proto.RegisterType((*ListServiceAccountsResponse)(nil), "yandex.cloud.iam.v1.ListServiceAccountsResponse")
	proto.RegisterType((*CreateServiceAccountRequest)(nil), "yandex.cloud.iam.v1.CreateServiceAccountRequest")
	proto.RegisterType((*CreateServiceAccountMetadata)(nil), "yandex.cloud.iam.v1.CreateServiceAccountMetadata")
	proto.RegisterType((*UpdateServiceAccountRequest)(nil), "yandex.cloud.iam.v1.UpdateServiceAccountRequest")
	proto.RegisterType((*UpdateServiceAccountMetadata)(nil), "yandex.cloud.iam.v1.UpdateServiceAccountMetadata")
	proto.RegisterType((*DeleteServiceAccountRequest)(nil), "yandex.cloud.iam.v1.DeleteServiceAccountRequest")
	proto.RegisterType((*DeleteServiceAccountMetadata)(nil), "yandex.cloud.iam.v1.DeleteServiceAccountMetadata")
	proto.RegisterType((*ListServiceAccountOperationsRequest)(nil), "yandex.cloud.iam.v1.ListServiceAccountOperationsRequest")
	proto.RegisterType((*ListServiceAccountOperationsResponse)(nil), "yandex.cloud.iam.v1.ListServiceAccountOperationsResponse")
}

func init() {
	proto.RegisterFile("yandex/cloud/iam/v1/service_account_service.proto", fileDescriptor_b44ea8947de11d22)
}

var fileDescriptor_b44ea8947de11d22 = []byte{
	// 1022 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x57, 0xcf, 0x6f, 0x1b, 0x45,
	0x18, 0xd5, 0x34, 0xc6, 0xaa, 0xbf, 0xd0, 0x1f, 0x0c, 0x54, 0x35, 0x4e, 0x2a, 0xcc, 0x06, 0x4a,
	0x6a, 0xe2, 0x5d, 0xaf, 0x21, 0x6d, 0x9d, 0xa4, 0x2a, 0x31, 0x3f, 0xaa, 0x4a, 0x2d, 0xa0, 0x4d,
	0xa9, 0x04, 0x51, 0x65, 0x4d, 0x76, 0x27, 0x66, 0x14, 0x7b, 0x77, 0xd9, 0x59, 0x47, 0x6d, 0x4a,
	0x85, 0x84, 0xc4, 0x25, 0x17, 0x84, 0x10, 0xff, 0x07, 0x0a, 0x48, 0xdc, 0x38, 0x92, 0x1c, 0x38,
	0x85, 0x7f, 0x01, 0xa1, 0x9e, 0xe1, 0xc6, 0x01, 0xa1, 0x9d, 0x5d, 0x3b, 0xd9, 0xf5, 0xac, 0xb3,
	0x4e, 0xdb, 0x53, 0xb2, 0x3b, 0xdf, 0xbc, 0x79, 0xef, 0xcd, 0x37, 0x6f, 0xbc, 0xa0, 0x3f, 0x20,
	0xb6, 0x45, 0xef, 0x6b, 0x66, 0xc7, 0xe9, 0x59, 0x1a, 0x23, 0x5d, 0x6d, 0x53, 0xd7, 0x38, 0xf5,
	0x36, 0x99, 0x49, 0x5b, 0xc4, 0x34, 0x9d, 0x9e, 0xed, 0xb7, 0xa2, 0x67, 0xd5, 0xf5, 0x1c, 0xdf,
	0xc1, 0x2f, 0x86, 0x53, 0x54, 0x31, 0x45, 0x65, 0xa4, 0xab, 0x6e, 0xea, 0xa5, 0xe9, 0xb6, 0xe3,
	0xb4, 0x3b, 0x54, 0x23, 0x2e, 0xd3, 0x88, 0x6d, 0x3b, 0x3e, 0xf1, 0x99, 0x63, 0xf3, 0x70, 0x4a,
	0xa9, 0x1c, 0x8d, 0x8a, 0xa7, 0xb5, 0xde, 0xba, 0xb6, 0xce, 0x68, 0xc7, 0x6a, 0x75, 0x09, 0xdf,
	0xe8, 0x57, 0xc4, 0x78, 0x04, 0x28, 0x8e, 0x4b, 0x3d, 0x01, 0x12, 0x55, 0x5c, 0xca, 0xc0, 0x54,
	0x0e, 0x66, 0x9a, 0x94, 0xf3, 0xe8, 0x4f, 0x54, 0x71, 0x31, 0x56, 0x31, 0x58, 0x6a, 0x68, 0xd1,
	0x0b, 0xb1, 0xba, 0x4d, 0xd2, 0x61, 0xd6, 0xa1, 0x61, 0xe5, 0x2e, 0x14, 0x6f, 0x50, 0x7f, 0x25,
	0x24, 0xb1, 0x1c, 0x72, 0x30, 0xe8, 0x17, 0x3d, 0xca, 0x7d, 0xbc, 0x00, 0x38, 0xe9, 0x23, 0xb3,
	0x8a, 0xa8, 0x8c, 0x66, 0x0b, 0xcd, 0xe7, 0x1f, 0xef, 0xea, 0x68, 0x7b, 0x4f, 0xcf, 0x2d, 0x5d,
	0x9b, 0xaf, 0x19, 0x67, 0x79, 0x0c, 0xe0, 0xa6, 0xa5, 0xfc, 0x8a, 0xa0, 0x74, 0x8b, 0xf1, 0x04,
	0x32, 0xef, 0x43, 0x5f, 0x82, 0xc2, 0xba, 0xd3, 0xb1, 0xa8, 0x97, 0x86, 0x78, 0x32, 0x1c, 0xbe,
	0x69, 0xe1, 0x37, 0xa0, 0xe0, 0x92, 0x36, 0x6d, 0x71, 0xb6, 0x45, 0x8b, 0x27, 0xca, 0x68, 0x76,
	0xa2, 0x09, 0xff, 0xee, 0xea, 0xf9, 0xa5, 0x6b, 0x7a, 0xad, 0x56, 0x33, 0x4e, 0x06, 0x83, 0x2b,
	0x6c, 0x8b, 0xe2, 0x59, 0x00, 0x51, 0xe8, 0x3b, 0x1b, 0xd4, 0x2e, 0x4e, 0x08, 0xd0, 0xc2, 0xf6,
	0x9e, 0xfe, 0x9c, 0xa8, 0x34, 0x04, 0xca, 0x9d, 0x60, 0x0c, 0x2b, 0x90, 0x5f, 0x67, 0x1d, 0x9f,
	0x7a, 0xc5, 0x9c, 0xa8, 0x82, 0xed, 0xbd, 0x01, 0x5e, 0x34, 0xa2, 0xfc, 0x80, 0x60, 0x4a, 0x2a,
	0x80, 0xbb, 0x8e, 0xcd, 0x29, 0xfe, 0x10, 0xce, 0x26, 0xcc, 0xe1, 0x45, 0x54, 0x9e, 0x98, 0x9d,
	0xac, 0xcf, 0xa8, 0x92, 0xf6, 0x52, 0x13, 0x16, 0x9f, 0x89, 0x3b, 0xc6, 0xf1, 0x45, 0x38, 0x63,
	0xd3, 0xfb, 0x7e, 0xeb, 0x90, 0x84, 0x40, 0x6c, 0xc1, 0x38, 0x15, 0xbc, 0xfe, 0xb8, 0xcf, 0x5d,
	0xf9, 0x11, 0xc1, 0xd4, 0xbb, 0x1e, 0x25, 0x3e, 0x95, 0x6f, 0xda, 0x18, 0xce, 0x36, 0x20, 0x67,
	0x93, 0x6e, 0x68, 0x6a, 0xa1, 0xf9, 0x7a, 0x50, 0xf5, 0xf7, 0xae, 0x7e, 0xe1, 0xcb, 0x55, 0x52,
	0xdd, 0xba, 0xb7, 0x5a, 0x25, 0xd5, 0xad, 0x5a, 0xb5, 0x71, 0xef, 0xa1, 0x3e, 0x77, 0x59, 0x7f,
	0xb4, 0x1a, 0x3d, 0x19, 0x62, 0x0a, 0x7e, 0x13, 0x26, 0x2d, 0xca, 0x4d, 0x8f, 0xb9, 0x41, 0x2f,
	0xc5, 0xcd, 0xae, 0xcf, 0x5f, 0x36, 0x0e, 0x8f, 0x2a, 0xb7, 0x60, 0x5a, 0xc6, 0xf8, 0x36, 0xf5,
	0x89, 0x45, 0x7c, 0x82, 0xe7, 0xd2, 0xfb, 0x4c, 0xd2, 0x59, 0xff, 0x21, 0x98, 0xfa, 0xc4, 0xb5,
	0x52, 0x0d, 0x78, 0x82, 0xae, 0xc5, 0x8b, 0x30, 0xd9, 0x13, 0xd0, 0xe2, 0x60, 0x0b, 0x63, 0x26,
	0xeb, 0x25, 0x35, 0x3c, 0xfb, 0x6a, 0xff, 0xec, 0xab, 0x1f, 0x04, 0x67, 0xff, 0x36, 0xe1, 0x1b,
	0x06, 0x84, 0xe5, 0xc1, 0xff, 0x03, 0x3b, 0x27, 0x9e, 0xd8, 0xce, 0xdc, 0x51, 0x76, 0xca, 0xf4,
	0x1f, 0xd3, 0xce, 0x4f, 0x61, 0xea, 0x3d, 0xda, 0xa1, 0xcf, 0xc0, 0xcd, 0x80, 0xa8, 0x0c, 0xfa,
	0x98, 0x44, 0x7f, 0x46, 0x30, 0x33, 0x7c, 0x20, 0x3f, 0xea, 0xc7, 0x1d, 0x7f, 0x1a, 0xfb, 0xff,
	0xf4, 0xb3, 0x46, 0xf9, 0x0e, 0xc1, 0x6b, 0xa3, 0x69, 0x47, 0x81, 0xb2, 0x0c, 0x30, 0xc8, 0xee,
	0x7e, 0x94, 0xbc, 0x1a, 0x8f, 0x92, 0x83, 0x6c, 0x1f, 0xcc, 0x37, 0x0e, 0x4d, 0xca, 0x9a, 0x21,
	0xf5, 0xc7, 0xa7, 0xe0, 0x5c, 0x9c, 0x4f, 0xf4, 0x84, 0xbf, 0x45, 0x30, 0x71, 0x83, 0xfa, 0xb8,
	0x2a, 0xcd, 0xb0, 0xb4, 0x9b, 0xa2, 0x94, 0x25, 0xf2, 0x94, 0xb7, 0xbf, 0xfe, 0xe3, 0xcf, 0xef,
	0x4f, 0xa8, 0x78, 0x2e, 0x71, 0xf5, 0xf5, 0x23, 0x50, 0x7b, 0x38, 0xbc, 0x6f, 0x8f, 0xf0, 0x36,
	0x82, 0x5c, 0xe0, 0x1f, 0xd6, 0xa4, 0x6b, 0xa4, 0xdf, 0x31, 0xa5, 0x5a, 0xf6, 0x09, 0xe1, 0x16,
	0x28, 0xaf, 0x08, 0x86, 0x2f, 0xe3, 0xf3, 0x29, 0x0c, 0xf1, 0x4f, 0x08, 0xf2, 0x61, 0x94, 0x61,
	0x39, 0xfa, 0x88, 0x64, 0x2e, 0x1d, 0xbd, 0x99, 0xca, 0x9d, 0x9d, 0xfd, 0x8a, 0x7a, 0x44, 0x5a,
	0x9e, 0x8e, 0xbf, 0x17, 0x94, 0xa7, 0x95, 0x34, 0xca, 0x0b, 0xa8, 0x82, 0xf7, 0x10, 0xe4, 0xc3,
	0xc4, 0x48, 0x61, 0x3d, 0x22, 0x4e, 0xb3, 0xb0, 0x66, 0x21, 0xeb, 0x91, 0xa1, 0x24, 0x63, 0xad,
	0xd7, 0xc7, 0x6a, 0x85, 0x40, 0xca, 0xef, 0x08, 0xf2, 0x61, 0xa6, 0xa4, 0x48, 0x19, 0x91, 0x65,
	0x59, 0xa4, 0x74, 0x77, 0xf6, 0x2b, 0xf3, 0x47, 0xc4, 0xd6, 0xb9, 0xe4, 0x75, 0xf0, 0x7e, 0xd7,
	0xf5, 0x1f, 0x84, 0xcd, 0x5d, 0x19, 0xaf, 0xb9, 0x7f, 0x41, 0x80, 0x83, 0x86, 0x5c, 0x16, 0xbf,
	0xec, 0x9a, 0xcc, 0xb6, 0x98, 0xdd, 0xe6, 0x58, 0x8d, 0x13, 0x8d, 0x7e, 0xf7, 0x0d, 0x17, 0xf6,
	0x85, 0x69, 0x99, 0xeb, 0xa3, 0x46, 0x7f, 0x47, 0xb0, 0x5d, 0xc0, 0x57, 0x53, 0xd9, 0x7a, 0x94,
	0x3b, 0x3d, 0xcf, 0xa4, 0xc2, 0xf8, 0xce, 0x30, 0xc5, 0xbf, 0x10, 0xbc, 0xb0, 0x42, 0x93, 0x6f,
	0xab, 0x52, 0x22, 0x43, 0x75, 0x63, 0x6c, 0xc8, 0x57, 0x3b, 0xfb, 0x95, 0x06, 0x94, 0xd3, 0x90,
	0xb2, 0x6c, 0xca, 0x92, 0x72, 0x25, 0x9b, 0x4c, 0x9e, 0x44, 0x0f, 0x3a, 0xee, 0x1f, 0x04, 0x2f,
	0x85, 0x9d, 0x9d, 0xd0, 0x5a, 0x93, 0x6a, 0x95, 0x95, 0x8e, 0x21, 0xf7, 0x1b, 0xb4, 0xb3, 0x5f,
	0x59, 0x82, 0x99, 0x11, 0x68, 0x59, 0x24, 0x5f, 0x57, 0x16, 0xb2, 0x49, 0xee, 0x49, 0x16, 0x08,
	0x54, 0xff, 0x86, 0xe0, 0x74, 0xd0, 0x3f, 0x07, 0xf7, 0x14, 0xbe, 0x9a, 0x31, 0x4e, 0x87, 0x6e,
	0xe4, 0x52, 0xe3, 0x18, 0x33, 0xa3, 0x46, 0xbd, 0x2e, 0xe4, 0x34, 0xf0, 0x95, 0x71, 0x8e, 0xd5,
	0xc1, 0x37, 0x10, 0x6f, 0xde, 0x85, 0xf3, 0xf1, 0x6d, 0x72, 0x59, 0x44, 0xe0, 0xb3, 0xc5, 0x36,
	0xf3, 0x3f, 0xef, 0xad, 0xa9, 0xa6, 0xd3, 0xd5, 0xc2, 0x9a, 0x6a, 0xf8, 0x91, 0xd4, 0x76, 0xaa,
	0x6d, 0x6a, 0x0b, 0x5b, 0x35, 0xc9, 0x27, 0xdb, 0x22, 0x23, 0xdd, 0xb5, 0xbc, 0x18, 0x7e, 0xeb,
	0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x36, 0xed, 0xc8, 0x60, 0x7e, 0x0e, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ServiceAccountServiceClient is the client API for ServiceAccountService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ServiceAccountServiceClient interface {
	// Returns the specified ServiceAccount resource.
	//
	// To get the list of available ServiceAccount resources, make a [List] request.
	Get(ctx context.Context, in *GetServiceAccountRequest, opts ...grpc.CallOption) (*ServiceAccount, error)
	// Retrieves the list of ServiceAccount resources in the specified folder.
	List(ctx context.Context, in *ListServiceAccountsRequest, opts ...grpc.CallOption) (*ListServiceAccountsResponse, error)
	// Creates a service account in the specified folder.
	Create(ctx context.Context, in *CreateServiceAccountRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified service account.
	Update(ctx context.Context, in *UpdateServiceAccountRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified service account.
	Delete(ctx context.Context, in *DeleteServiceAccountRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists access bindings for the specified service account.
	ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error)
	// Sets access bindings for the service account.
	SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates access bindings for the specified service account.
	UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists operations for the specified service account.
	ListOperations(ctx context.Context, in *ListServiceAccountOperationsRequest, opts ...grpc.CallOption) (*ListServiceAccountOperationsResponse, error)
}

type serviceAccountServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewServiceAccountServiceClient(cc grpc.ClientConnInterface) ServiceAccountServiceClient {
	return &serviceAccountServiceClient{cc}
}

func (c *serviceAccountServiceClient) Get(ctx context.Context, in *GetServiceAccountRequest, opts ...grpc.CallOption) (*ServiceAccount, error) {
	out := new(ServiceAccount)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.ServiceAccountService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceAccountServiceClient) List(ctx context.Context, in *ListServiceAccountsRequest, opts ...grpc.CallOption) (*ListServiceAccountsResponse, error) {
	out := new(ListServiceAccountsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.ServiceAccountService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceAccountServiceClient) Create(ctx context.Context, in *CreateServiceAccountRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.ServiceAccountService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceAccountServiceClient) Update(ctx context.Context, in *UpdateServiceAccountRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.ServiceAccountService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceAccountServiceClient) Delete(ctx context.Context, in *DeleteServiceAccountRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.ServiceAccountService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceAccountServiceClient) ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error) {
	out := new(access.ListAccessBindingsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.ServiceAccountService/ListAccessBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceAccountServiceClient) SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.ServiceAccountService/SetAccessBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceAccountServiceClient) UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.ServiceAccountService/UpdateAccessBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceAccountServiceClient) ListOperations(ctx context.Context, in *ListServiceAccountOperationsRequest, opts ...grpc.CallOption) (*ListServiceAccountOperationsResponse, error) {
	out := new(ListServiceAccountOperationsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.ServiceAccountService/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ServiceAccountServiceServer is the server API for ServiceAccountService service.
type ServiceAccountServiceServer interface {
	// Returns the specified ServiceAccount resource.
	//
	// To get the list of available ServiceAccount resources, make a [List] request.
	Get(context.Context, *GetServiceAccountRequest) (*ServiceAccount, error)
	// Retrieves the list of ServiceAccount resources in the specified folder.
	List(context.Context, *ListServiceAccountsRequest) (*ListServiceAccountsResponse, error)
	// Creates a service account in the specified folder.
	Create(context.Context, *CreateServiceAccountRequest) (*operation.Operation, error)
	// Updates the specified service account.
	Update(context.Context, *UpdateServiceAccountRequest) (*operation.Operation, error)
	// Deletes the specified service account.
	Delete(context.Context, *DeleteServiceAccountRequest) (*operation.Operation, error)
	// Lists access bindings for the specified service account.
	ListAccessBindings(context.Context, *access.ListAccessBindingsRequest) (*access.ListAccessBindingsResponse, error)
	// Sets access bindings for the service account.
	SetAccessBindings(context.Context, *access.SetAccessBindingsRequest) (*operation.Operation, error)
	// Updates access bindings for the specified service account.
	UpdateAccessBindings(context.Context, *access.UpdateAccessBindingsRequest) (*operation.Operation, error)
	// Lists operations for the specified service account.
	ListOperations(context.Context, *ListServiceAccountOperationsRequest) (*ListServiceAccountOperationsResponse, error)
}

// UnimplementedServiceAccountServiceServer can be embedded to have forward compatible implementations.
type UnimplementedServiceAccountServiceServer struct {
}

func (*UnimplementedServiceAccountServiceServer) Get(ctx context.Context, req *GetServiceAccountRequest) (*ServiceAccount, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedServiceAccountServiceServer) List(ctx context.Context, req *ListServiceAccountsRequest) (*ListServiceAccountsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedServiceAccountServiceServer) Create(ctx context.Context, req *CreateServiceAccountRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (*UnimplementedServiceAccountServiceServer) Update(ctx context.Context, req *UpdateServiceAccountRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (*UnimplementedServiceAccountServiceServer) Delete(ctx context.Context, req *DeleteServiceAccountRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedServiceAccountServiceServer) ListAccessBindings(ctx context.Context, req *access.ListAccessBindingsRequest) (*access.ListAccessBindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAccessBindings not implemented")
}
func (*UnimplementedServiceAccountServiceServer) SetAccessBindings(ctx context.Context, req *access.SetAccessBindingsRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetAccessBindings not implemented")
}
func (*UnimplementedServiceAccountServiceServer) UpdateAccessBindings(ctx context.Context, req *access.UpdateAccessBindingsRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAccessBindings not implemented")
}
func (*UnimplementedServiceAccountServiceServer) ListOperations(ctx context.Context, req *ListServiceAccountOperationsRequest) (*ListServiceAccountOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOperations not implemented")
}

func RegisterServiceAccountServiceServer(s *grpc.Server, srv ServiceAccountServiceServer) {
	s.RegisterService(&_ServiceAccountService_serviceDesc, srv)
}

func _ServiceAccountService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceAccountServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.ServiceAccountService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceAccountServiceServer).Get(ctx, req.(*GetServiceAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceAccountService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServiceAccountsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceAccountServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.ServiceAccountService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceAccountServiceServer).List(ctx, req.(*ListServiceAccountsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceAccountService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceAccountServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.ServiceAccountService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceAccountServiceServer).Create(ctx, req.(*CreateServiceAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceAccountService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateServiceAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceAccountServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.ServiceAccountService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceAccountServiceServer).Update(ctx, req.(*UpdateServiceAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceAccountService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceAccountServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.ServiceAccountService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceAccountServiceServer).Delete(ctx, req.(*DeleteServiceAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceAccountService_ListAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.ListAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceAccountServiceServer).ListAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.ServiceAccountService/ListAccessBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceAccountServiceServer).ListAccessBindings(ctx, req.(*access.ListAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceAccountService_SetAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.SetAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceAccountServiceServer).SetAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.ServiceAccountService/SetAccessBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceAccountServiceServer).SetAccessBindings(ctx, req.(*access.SetAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceAccountService_UpdateAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.UpdateAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceAccountServiceServer).UpdateAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.ServiceAccountService/UpdateAccessBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceAccountServiceServer).UpdateAccessBindings(ctx, req.(*access.UpdateAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceAccountService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServiceAccountOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceAccountServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.ServiceAccountService/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceAccountServiceServer).ListOperations(ctx, req.(*ListServiceAccountOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ServiceAccountService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.iam.v1.ServiceAccountService",
	HandlerType: (*ServiceAccountServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _ServiceAccountService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _ServiceAccountService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _ServiceAccountService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _ServiceAccountService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _ServiceAccountService_Delete_Handler,
		},
		{
			MethodName: "ListAccessBindings",
			Handler:    _ServiceAccountService_ListAccessBindings_Handler,
		},
		{
			MethodName: "SetAccessBindings",
			Handler:    _ServiceAccountService_SetAccessBindings_Handler,
		},
		{
			MethodName: "UpdateAccessBindings",
			Handler:    _ServiceAccountService_UpdateAccessBindings_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _ServiceAccountService_ListOperations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/iam/v1/service_account_service.proto",
}
