// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/k8s/v1/node.proto

package k8s

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type IpVersion int32

const (
	IpVersion_IP_VERSION_UNSPECIFIED IpVersion = 0
	// IPv4 address, for example 192.168.0.0.
	IpVersion_IPV4 IpVersion = 1
	// IPv6 address, not available yet.
	IpVersion_IPV6 IpVersion = 2
)

var IpVersion_name = map[int32]string{
	0: "IP_VERSION_UNSPECIFIED",
	1: "IPV4",
	2: "IPV6",
}

var IpVersion_value = map[string]int32{
	"IP_VERSION_UNSPECIFIED": 0,
	"IPV4":                   1,
	"IPV6":                   2,
}

func (x IpVersion) String() string {
	return proto.EnumName(IpVersion_name, int32(x))
}

func (IpVersion) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_0caaa97cecfcad1b, []int{0}
}

// Computed node status.
type Node_Status int32

const (
	Node_STATUS_UNSPECIFIED Node_Status = 0
	// Node instance is not yet created (e.g. in progress).
	Node_PROVISIONING Node_Status = 1
	// Node instance is created but not registered
	// (e.g. is still initializing).
	Node_NOT_CONNECTED Node_Status = 2
	// Node has connected but is not ready for
	// workload (see conditions for details).
	Node_NOT_READY Node_Status = 3
	// Node has connected and ready for workload.
	Node_READY Node_Status = 4
	// Node is still registered but its instance
	// is deleted (this is our bug).
	Node_MISSING Node_Status = 5
)

var Node_Status_name = map[int32]string{
	0: "STATUS_UNSPECIFIED",
	1: "PROVISIONING",
	2: "NOT_CONNECTED",
	3: "NOT_READY",
	4: "READY",
	5: "MISSING",
}

var Node_Status_value = map[string]int32{
	"STATUS_UNSPECIFIED": 0,
	"PROVISIONING":       1,
	"NOT_CONNECTED":      2,
	"NOT_READY":          3,
	"READY":              4,
	"MISSING":            5,
}

func (x Node_Status) String() string {
	return proto.EnumName(Node_Status_name, int32(x))
}

func (Node_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_0caaa97cecfcad1b, []int{0, 0}
}

type Taint_Effect int32

const (
	Taint_EFFECT_UNSPECIFIED Taint_Effect = 0
	// Do not allow new pods to schedule onto the node unless they tolerate the taint,
	// but allow all pods submitted to Kubelet without going through the scheduler
	// to start, and allow all already-running pods to continue running.
	Taint_NO_SCHEDULE Taint_Effect = 1
	// Like NO_SCHEDULE, but the scheduler tries not to schedule
	// new pods onto the node, rather than prohibiting new pods from scheduling
	// onto the node entirely. Enforced by the scheduler.
	Taint_PREFER_NO_SCHEDULE Taint_Effect = 2
	// Evict any already-running pods that do not tolerate the taint.
	Taint_NO_EXECUTE Taint_Effect = 3
)

var Taint_Effect_name = map[int32]string{
	0: "EFFECT_UNSPECIFIED",
	1: "NO_SCHEDULE",
	2: "PREFER_NO_SCHEDULE",
	3: "NO_EXECUTE",
}

var Taint_Effect_value = map[string]int32{
	"EFFECT_UNSPECIFIED": 0,
	"NO_SCHEDULE":        1,
	"PREFER_NO_SCHEDULE": 2,
	"NO_EXECUTE":         3,
}

func (x Taint_Effect) String() string {
	return proto.EnumName(Taint_Effect_name, int32(x))
}

func (Taint_Effect) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_0caaa97cecfcad1b, []int{2, 0}
}

type Node struct {
	// Computed node status.
	Status Node_Status `protobuf:"varint,1,opt,name=status,proto3,enum=yandex.cloud.k8s.v1.Node_Status" json:"status,omitempty"`
	// Node specificaion.
	Spec *Node_Spec `protobuf:"bytes,2,opt,name=spec,proto3" json:"spec,omitempty"`
	// Cloud instance status.
	// Not available in `MISSING` status.
	CloudStatus *Node_CloudStatus `protobuf:"bytes,3,opt,name=cloud_status,json=cloudStatus,proto3" json:"cloud_status,omitempty"`
	// Kubernetes node status.
	// Not available in `PROVISIONING` and `NOT_CONNECTED` states.
	KubernetesStatus     *Node_KubernetesStatus `protobuf:"bytes,4,opt,name=kubernetes_status,json=kubernetesStatus,proto3" json:"kubernetes_status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *Node) Reset()         { *m = Node{} }
func (m *Node) String() string { return proto.CompactTextString(m) }
func (*Node) ProtoMessage()    {}
func (*Node) Descriptor() ([]byte, []int) {
	return fileDescriptor_0caaa97cecfcad1b, []int{0}
}

func (m *Node) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Node.Unmarshal(m, b)
}
func (m *Node) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Node.Marshal(b, m, deterministic)
}
func (m *Node) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Node.Merge(m, src)
}
func (m *Node) XXX_Size() int {
	return xxx_messageInfo_Node.Size(m)
}
func (m *Node) XXX_DiscardUnknown() {
	xxx_messageInfo_Node.DiscardUnknown(m)
}

var xxx_messageInfo_Node proto.InternalMessageInfo

func (m *Node) GetStatus() Node_Status {
	if m != nil {
		return m.Status
	}
	return Node_STATUS_UNSPECIFIED
}

func (m *Node) GetSpec() *Node_Spec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *Node) GetCloudStatus() *Node_CloudStatus {
	if m != nil {
		return m.CloudStatus
	}
	return nil
}

func (m *Node) GetKubernetesStatus() *Node_KubernetesStatus {
	if m != nil {
		return m.KubernetesStatus
	}
	return nil
}

// Kubernetes node info
type Node_KubernetesStatus struct {
	// Node id (and instance name)
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Conditions is an array of current observed node conditions.
	// More info: https://kubernetes.io/docs/concepts/nodes/node/#condition
	Conditions []*Condition `protobuf:"bytes,2,rep,name=conditions,proto3" json:"conditions,omitempty"`
	// If specified, the node's taints.
	Taints []*Taint `protobuf:"bytes,3,rep,name=taints,proto3" json:"taints,omitempty"`
	// List of volumes that are attached to the node.
	AttachedVolumes      []*AttachedVolume `protobuf:"bytes,4,rep,name=attached_volumes,json=attachedVolumes,proto3" json:"attached_volumes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Node_KubernetesStatus) Reset()         { *m = Node_KubernetesStatus{} }
func (m *Node_KubernetesStatus) String() string { return proto.CompactTextString(m) }
func (*Node_KubernetesStatus) ProtoMessage()    {}
func (*Node_KubernetesStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_0caaa97cecfcad1b, []int{0, 0}
}

func (m *Node_KubernetesStatus) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Node_KubernetesStatus.Unmarshal(m, b)
}
func (m *Node_KubernetesStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Node_KubernetesStatus.Marshal(b, m, deterministic)
}
func (m *Node_KubernetesStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Node_KubernetesStatus.Merge(m, src)
}
func (m *Node_KubernetesStatus) XXX_Size() int {
	return xxx_messageInfo_Node_KubernetesStatus.Size(m)
}
func (m *Node_KubernetesStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_Node_KubernetesStatus.DiscardUnknown(m)
}

var xxx_messageInfo_Node_KubernetesStatus proto.InternalMessageInfo

func (m *Node_KubernetesStatus) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Node_KubernetesStatus) GetConditions() []*Condition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

func (m *Node_KubernetesStatus) GetTaints() []*Taint {
	if m != nil {
		return m.Taints
	}
	return nil
}

func (m *Node_KubernetesStatus) GetAttachedVolumes() []*AttachedVolume {
	if m != nil {
		return m.AttachedVolumes
	}
	return nil
}

// Cloud instance info
type Node_CloudStatus struct {
	// Compute instance id
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// IG instance status
	Status string `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	// IG instance status message
	StatusMessage        string   `protobuf:"bytes,3,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Node_CloudStatus) Reset()         { *m = Node_CloudStatus{} }
func (m *Node_CloudStatus) String() string { return proto.CompactTextString(m) }
func (*Node_CloudStatus) ProtoMessage()    {}
func (*Node_CloudStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_0caaa97cecfcad1b, []int{0, 1}
}

func (m *Node_CloudStatus) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Node_CloudStatus.Unmarshal(m, b)
}
func (m *Node_CloudStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Node_CloudStatus.Marshal(b, m, deterministic)
}
func (m *Node_CloudStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Node_CloudStatus.Merge(m, src)
}
func (m *Node_CloudStatus) XXX_Size() int {
	return xxx_messageInfo_Node_CloudStatus.Size(m)
}
func (m *Node_CloudStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_Node_CloudStatus.DiscardUnknown(m)
}

var xxx_messageInfo_Node_CloudStatus proto.InternalMessageInfo

func (m *Node_CloudStatus) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Node_CloudStatus) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *Node_CloudStatus) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

// Node specification.
type Node_Spec struct {
	// Node group specified resources.
	Resources *ResourcesSpec `protobuf:"bytes,1,opt,name=resources,proto3" json:"resources,omitempty"`
	// Node group specified disk.
	Disk                 *DiskSpec `protobuf:"bytes,2,opt,name=disk,proto3" json:"disk,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *Node_Spec) Reset()         { *m = Node_Spec{} }
func (m *Node_Spec) String() string { return proto.CompactTextString(m) }
func (*Node_Spec) ProtoMessage()    {}
func (*Node_Spec) Descriptor() ([]byte, []int) {
	return fileDescriptor_0caaa97cecfcad1b, []int{0, 2}
}

func (m *Node_Spec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Node_Spec.Unmarshal(m, b)
}
func (m *Node_Spec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Node_Spec.Marshal(b, m, deterministic)
}
func (m *Node_Spec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Node_Spec.Merge(m, src)
}
func (m *Node_Spec) XXX_Size() int {
	return xxx_messageInfo_Node_Spec.Size(m)
}
func (m *Node_Spec) XXX_DiscardUnknown() {
	xxx_messageInfo_Node_Spec.DiscardUnknown(m)
}

var xxx_messageInfo_Node_Spec proto.InternalMessageInfo

func (m *Node_Spec) GetResources() *ResourcesSpec {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *Node_Spec) GetDisk() *DiskSpec {
	if m != nil {
		return m.Disk
	}
	return nil
}

type Condition struct {
	// Type of node condition.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Status is the status of the condition.
	Status string `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	// Human-readable message indicating details about last transition.
	Message string `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
	// Last time we got an update on a given condition.
	LastHeartbeatTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=last_heartbeat_time,json=lastHeartbeatTime,proto3" json:"last_heartbeat_time,omitempty"`
	// Last time the condition transit from one status to another.
	LastTransitionTime   *timestamp.Timestamp `protobuf:"bytes,5,opt,name=last_transition_time,json=lastTransitionTime,proto3" json:"last_transition_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Condition) Reset()         { *m = Condition{} }
func (m *Condition) String() string { return proto.CompactTextString(m) }
func (*Condition) ProtoMessage()    {}
func (*Condition) Descriptor() ([]byte, []int) {
	return fileDescriptor_0caaa97cecfcad1b, []int{1}
}

func (m *Condition) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Condition.Unmarshal(m, b)
}
func (m *Condition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Condition.Marshal(b, m, deterministic)
}
func (m *Condition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Condition.Merge(m, src)
}
func (m *Condition) XXX_Size() int {
	return xxx_messageInfo_Condition.Size(m)
}
func (m *Condition) XXX_DiscardUnknown() {
	xxx_messageInfo_Condition.DiscardUnknown(m)
}

var xxx_messageInfo_Condition proto.InternalMessageInfo

func (m *Condition) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Condition) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *Condition) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *Condition) GetLastHeartbeatTime() *timestamp.Timestamp {
	if m != nil {
		return m.LastHeartbeatTime
	}
	return nil
}

func (m *Condition) GetLastTransitionTime() *timestamp.Timestamp {
	if m != nil {
		return m.LastTransitionTime
	}
	return nil
}

type Taint struct {
	// The taint key to be applied to a node.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The taint value corresponding to the taint key.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// The effect of the taint on pods that do not tolerate the taint.
	Effect               Taint_Effect `protobuf:"varint,3,opt,name=effect,proto3,enum=yandex.cloud.k8s.v1.Taint_Effect" json:"effect,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Taint) Reset()         { *m = Taint{} }
func (m *Taint) String() string { return proto.CompactTextString(m) }
func (*Taint) ProtoMessage()    {}
func (*Taint) Descriptor() ([]byte, []int) {
	return fileDescriptor_0caaa97cecfcad1b, []int{2}
}

func (m *Taint) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Taint.Unmarshal(m, b)
}
func (m *Taint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Taint.Marshal(b, m, deterministic)
}
func (m *Taint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Taint.Merge(m, src)
}
func (m *Taint) XXX_Size() int {
	return xxx_messageInfo_Taint.Size(m)
}
func (m *Taint) XXX_DiscardUnknown() {
	xxx_messageInfo_Taint.DiscardUnknown(m)
}

var xxx_messageInfo_Taint proto.InternalMessageInfo

func (m *Taint) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *Taint) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *Taint) GetEffect() Taint_Effect {
	if m != nil {
		return m.Effect
	}
	return Taint_EFFECT_UNSPECIFIED
}

// AttachedVolume describes a volume attached to a node
type AttachedVolume struct {
	// Name of the driver which has attached the volume
	DriverName string `protobuf:"bytes,1,opt,name=driver_name,json=driverName,proto3" json:"driver_name,omitempty"`
	// Volume handle (cloud disk id)
	VolumeHandle         string   `protobuf:"bytes,2,opt,name=volume_handle,json=volumeHandle,proto3" json:"volume_handle,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AttachedVolume) Reset()         { *m = AttachedVolume{} }
func (m *AttachedVolume) String() string { return proto.CompactTextString(m) }
func (*AttachedVolume) ProtoMessage()    {}
func (*AttachedVolume) Descriptor() ([]byte, []int) {
	return fileDescriptor_0caaa97cecfcad1b, []int{3}
}

func (m *AttachedVolume) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AttachedVolume.Unmarshal(m, b)
}
func (m *AttachedVolume) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AttachedVolume.Marshal(b, m, deterministic)
}
func (m *AttachedVolume) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttachedVolume.Merge(m, src)
}
func (m *AttachedVolume) XXX_Size() int {
	return xxx_messageInfo_AttachedVolume.Size(m)
}
func (m *AttachedVolume) XXX_DiscardUnknown() {
	xxx_messageInfo_AttachedVolume.DiscardUnknown(m)
}

var xxx_messageInfo_AttachedVolume proto.InternalMessageInfo

func (m *AttachedVolume) GetDriverName() string {
	if m != nil {
		return m.DriverName
	}
	return ""
}

func (m *AttachedVolume) GetVolumeHandle() string {
	if m != nil {
		return m.VolumeHandle
	}
	return ""
}

type NodeTemplate struct {
	// ID of the hardware platform configuration for the node.
	PlatformId string `protobuf:"bytes,1,opt,name=platform_id,json=platformId,proto3" json:"platform_id,omitempty"`
	// Computing resources of the node such as the amount of memory and number of cores.
	ResourcesSpec *ResourcesSpec `protobuf:"bytes,2,opt,name=resources_spec,json=resourcesSpec,proto3" json:"resources_spec,omitempty"`
	// Specification for the boot disk that will be attached to the node.
	BootDiskSpec *DiskSpec `protobuf:"bytes,3,opt,name=boot_disk_spec,json=bootDiskSpec,proto3" json:"boot_disk_spec,omitempty"`
	// The metadata as `key:value` pairs assigned to this instance template. This includes custom metadata and predefined keys.
	//
	// For example, you may use the metadata in order to provide your public SSH key to the node.
	// For more information, see [Metadata](/docs/compute/concepts/vm-metadata).
	Metadata map[string]string `protobuf:"bytes,4,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Specification for the create network interfaces for the node group compute instances.
	V4AddressSpec *NodeAddressSpec `protobuf:"bytes,5,opt,name=v4_address_spec,json=v4AddressSpec,proto3" json:"v4_address_spec,omitempty"`
	// Scheduling policy configuration.
	SchedulingPolicy     *SchedulingPolicy `protobuf:"bytes,6,opt,name=scheduling_policy,json=schedulingPolicy,proto3" json:"scheduling_policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *NodeTemplate) Reset()         { *m = NodeTemplate{} }
func (m *NodeTemplate) String() string { return proto.CompactTextString(m) }
func (*NodeTemplate) ProtoMessage()    {}
func (*NodeTemplate) Descriptor() ([]byte, []int) {
	return fileDescriptor_0caaa97cecfcad1b, []int{4}
}

func (m *NodeTemplate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeTemplate.Unmarshal(m, b)
}
func (m *NodeTemplate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeTemplate.Marshal(b, m, deterministic)
}
func (m *NodeTemplate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeTemplate.Merge(m, src)
}
func (m *NodeTemplate) XXX_Size() int {
	return xxx_messageInfo_NodeTemplate.Size(m)
}
func (m *NodeTemplate) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeTemplate.DiscardUnknown(m)
}

var xxx_messageInfo_NodeTemplate proto.InternalMessageInfo

func (m *NodeTemplate) GetPlatformId() string {
	if m != nil {
		return m.PlatformId
	}
	return ""
}

func (m *NodeTemplate) GetResourcesSpec() *ResourcesSpec {
	if m != nil {
		return m.ResourcesSpec
	}
	return nil
}

func (m *NodeTemplate) GetBootDiskSpec() *DiskSpec {
	if m != nil {
		return m.BootDiskSpec
	}
	return nil
}

func (m *NodeTemplate) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *NodeTemplate) GetV4AddressSpec() *NodeAddressSpec {
	if m != nil {
		return m.V4AddressSpec
	}
	return nil
}

func (m *NodeTemplate) GetSchedulingPolicy() *SchedulingPolicy {
	if m != nil {
		return m.SchedulingPolicy
	}
	return nil
}

type NodeAddressSpec struct {
	// One-to-one NAT configuration. Setting up one-to-one NAT ensures that public IP addresses are assigned to nodes, and therefore internet is accessible for all nodes of the node group. If the field is not set, NAT will not be set up.
	OneToOneNatSpec      *OneToOneNatSpec `protobuf:"bytes,1,opt,name=one_to_one_nat_spec,json=oneToOneNatSpec,proto3" json:"one_to_one_nat_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *NodeAddressSpec) Reset()         { *m = NodeAddressSpec{} }
func (m *NodeAddressSpec) String() string { return proto.CompactTextString(m) }
func (*NodeAddressSpec) ProtoMessage()    {}
func (*NodeAddressSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_0caaa97cecfcad1b, []int{5}
}

func (m *NodeAddressSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeAddressSpec.Unmarshal(m, b)
}
func (m *NodeAddressSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeAddressSpec.Marshal(b, m, deterministic)
}
func (m *NodeAddressSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeAddressSpec.Merge(m, src)
}
func (m *NodeAddressSpec) XXX_Size() int {
	return xxx_messageInfo_NodeAddressSpec.Size(m)
}
func (m *NodeAddressSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeAddressSpec.DiscardUnknown(m)
}

var xxx_messageInfo_NodeAddressSpec proto.InternalMessageInfo

func (m *NodeAddressSpec) GetOneToOneNatSpec() *OneToOneNatSpec {
	if m != nil {
		return m.OneToOneNatSpec
	}
	return nil
}

type OneToOneNatSpec struct {
	// IP version for the public IP address.
	IpVersion            IpVersion `protobuf:"varint,1,opt,name=ip_version,json=ipVersion,proto3,enum=yandex.cloud.k8s.v1.IpVersion" json:"ip_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *OneToOneNatSpec) Reset()         { *m = OneToOneNatSpec{} }
func (m *OneToOneNatSpec) String() string { return proto.CompactTextString(m) }
func (*OneToOneNatSpec) ProtoMessage()    {}
func (*OneToOneNatSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_0caaa97cecfcad1b, []int{6}
}

func (m *OneToOneNatSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OneToOneNatSpec.Unmarshal(m, b)
}
func (m *OneToOneNatSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OneToOneNatSpec.Marshal(b, m, deterministic)
}
func (m *OneToOneNatSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OneToOneNatSpec.Merge(m, src)
}
func (m *OneToOneNatSpec) XXX_Size() int {
	return xxx_messageInfo_OneToOneNatSpec.Size(m)
}
func (m *OneToOneNatSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_OneToOneNatSpec.DiscardUnknown(m)
}

var xxx_messageInfo_OneToOneNatSpec proto.InternalMessageInfo

func (m *OneToOneNatSpec) GetIpVersion() IpVersion {
	if m != nil {
		return m.IpVersion
	}
	return IpVersion_IP_VERSION_UNSPECIFIED
}

type ResourcesSpec struct {
	// Amount of memory available to the node, specified in bytes.
	Memory int64 `protobuf:"varint,1,opt,name=memory,proto3" json:"memory,omitempty"`
	// Number of cores available to the node.
	Cores int64 `protobuf:"varint,2,opt,name=cores,proto3" json:"cores,omitempty"`
	// Baseline level of CPU performance with the possibility to burst performance above that baseline level.
	// This field sets baseline performance for each core.
	CoreFraction int64 `protobuf:"varint,3,opt,name=core_fraction,json=coreFraction,proto3" json:"core_fraction,omitempty"`
	// Number of GPUs available to the node.
	Gpus                 int64    `protobuf:"varint,4,opt,name=gpus,proto3" json:"gpus,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResourcesSpec) Reset()         { *m = ResourcesSpec{} }
func (m *ResourcesSpec) String() string { return proto.CompactTextString(m) }
func (*ResourcesSpec) ProtoMessage()    {}
func (*ResourcesSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_0caaa97cecfcad1b, []int{7}
}

func (m *ResourcesSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResourcesSpec.Unmarshal(m, b)
}
func (m *ResourcesSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResourcesSpec.Marshal(b, m, deterministic)
}
func (m *ResourcesSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourcesSpec.Merge(m, src)
}
func (m *ResourcesSpec) XXX_Size() int {
	return xxx_messageInfo_ResourcesSpec.Size(m)
}
func (m *ResourcesSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourcesSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ResourcesSpec proto.InternalMessageInfo

func (m *ResourcesSpec) GetMemory() int64 {
	if m != nil {
		return m.Memory
	}
	return 0
}

func (m *ResourcesSpec) GetCores() int64 {
	if m != nil {
		return m.Cores
	}
	return 0
}

func (m *ResourcesSpec) GetCoreFraction() int64 {
	if m != nil {
		return m.CoreFraction
	}
	return 0
}

func (m *ResourcesSpec) GetGpus() int64 {
	if m != nil {
		return m.Gpus
	}
	return 0
}

type DiskSpec struct {
	// ID of the disk type.
	DiskTypeId string `protobuf:"bytes,1,opt,name=disk_type_id,json=diskTypeId,proto3" json:"disk_type_id,omitempty"`
	// Size of the disk, specified in bytes.
	DiskSize             int64    `protobuf:"varint,2,opt,name=disk_size,json=diskSize,proto3" json:"disk_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DiskSpec) Reset()         { *m = DiskSpec{} }
func (m *DiskSpec) String() string { return proto.CompactTextString(m) }
func (*DiskSpec) ProtoMessage()    {}
func (*DiskSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_0caaa97cecfcad1b, []int{8}
}

func (m *DiskSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DiskSpec.Unmarshal(m, b)
}
func (m *DiskSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DiskSpec.Marshal(b, m, deterministic)
}
func (m *DiskSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DiskSpec.Merge(m, src)
}
func (m *DiskSpec) XXX_Size() int {
	return xxx_messageInfo_DiskSpec.Size(m)
}
func (m *DiskSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_DiskSpec.DiscardUnknown(m)
}

var xxx_messageInfo_DiskSpec proto.InternalMessageInfo

func (m *DiskSpec) GetDiskTypeId() string {
	if m != nil {
		return m.DiskTypeId
	}
	return ""
}

func (m *DiskSpec) GetDiskSize() int64 {
	if m != nil {
		return m.DiskSize
	}
	return 0
}

type SchedulingPolicy struct {
	// True for preemptible compute instances. Default value is false. Preemptible compute instances are stopped at least once every 24 hours, and can be stopped at any time
	// if their resources are needed by Compute.
	// For more information, see [Preemptible Virtual Machines](/docs/compute/concepts/preemptible-vm).
	Preemptible          bool     `protobuf:"varint,1,opt,name=preemptible,proto3" json:"preemptible,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SchedulingPolicy) Reset()         { *m = SchedulingPolicy{} }
func (m *SchedulingPolicy) String() string { return proto.CompactTextString(m) }
func (*SchedulingPolicy) ProtoMessage()    {}
func (*SchedulingPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_0caaa97cecfcad1b, []int{9}
}

func (m *SchedulingPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SchedulingPolicy.Unmarshal(m, b)
}
func (m *SchedulingPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SchedulingPolicy.Marshal(b, m, deterministic)
}
func (m *SchedulingPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SchedulingPolicy.Merge(m, src)
}
func (m *SchedulingPolicy) XXX_Size() int {
	return xxx_messageInfo_SchedulingPolicy.Size(m)
}
func (m *SchedulingPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_SchedulingPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_SchedulingPolicy proto.InternalMessageInfo

func (m *SchedulingPolicy) GetPreemptible() bool {
	if m != nil {
		return m.Preemptible
	}
	return false
}

func init() {
	proto.RegisterEnum("yandex.cloud.k8s.v1.IpVersion", IpVersion_name, IpVersion_value)
	proto.RegisterEnum("yandex.cloud.k8s.v1.Node_Status", Node_Status_name, Node_Status_value)
	proto.RegisterEnum("yandex.cloud.k8s.v1.Taint_Effect", Taint_Effect_name, Taint_Effect_value)
	proto.RegisterType((*Node)(nil), "yandex.cloud.k8s.v1.Node")
	proto.RegisterType((*Node_KubernetesStatus)(nil), "yandex.cloud.k8s.v1.Node.KubernetesStatus")
	proto.RegisterType((*Node_CloudStatus)(nil), "yandex.cloud.k8s.v1.Node.CloudStatus")
	proto.RegisterType((*Node_Spec)(nil), "yandex.cloud.k8s.v1.Node.Spec")
	proto.RegisterType((*Condition)(nil), "yandex.cloud.k8s.v1.Condition")
	proto.RegisterType((*Taint)(nil), "yandex.cloud.k8s.v1.Taint")
	proto.RegisterType((*AttachedVolume)(nil), "yandex.cloud.k8s.v1.AttachedVolume")
	proto.RegisterType((*NodeTemplate)(nil), "yandex.cloud.k8s.v1.NodeTemplate")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.k8s.v1.NodeTemplate.MetadataEntry")
	proto.RegisterType((*NodeAddressSpec)(nil), "yandex.cloud.k8s.v1.NodeAddressSpec")
	proto.RegisterType((*OneToOneNatSpec)(nil), "yandex.cloud.k8s.v1.OneToOneNatSpec")
	proto.RegisterType((*ResourcesSpec)(nil), "yandex.cloud.k8s.v1.ResourcesSpec")
	proto.RegisterType((*DiskSpec)(nil), "yandex.cloud.k8s.v1.DiskSpec")
	proto.RegisterType((*SchedulingPolicy)(nil), "yandex.cloud.k8s.v1.SchedulingPolicy")
}

func init() {
	proto.RegisterFile("yandex/cloud/k8s/v1/node.proto", fileDescriptor_0caaa97cecfcad1b)
}

var fileDescriptor_0caaa97cecfcad1b = []byte{
	// 1367 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x56, 0xdd, 0x72, 0xda, 0xc6,
	0x17, 0xff, 0xf3, 0x61, 0x62, 0x0e, 0x06, 0xcb, 0xeb, 0x4c, 0xfe, 0x1e, 0xa6, 0x49, 0x5c, 0xd2,
	0xcc, 0x64, 0x3c, 0x0b, 0x48, 0x42, 0x26, 0xa4, 0x8e, 0x33, 0xb5, 0xb1, 0x5c, 0x93, 0x26, 0xe0,
	0x11, 0xd8, 0x6d, 0x9a, 0x76, 0x34, 0x6b, 0xb4, 0xc6, 0x1a, 0x40, 0x62, 0xa4, 0x85, 0xd6, 0x69,
	0x6e, 0xda, 0xcb, 0x3e, 0x46, 0x1f, 0x21, 0xef, 0xd0, 0xb1, 0xfb, 0x22, 0xbd, 0xe9, 0x5d, 0x2f,
	0x7d, 0xd5, 0x59, 0xad, 0x20, 0x86, 0x9a, 0x34, 0x57, 0x3a, 0x7b, 0xf6, 0xf7, 0x3b, 0xbb, 0xe7,
	0x73, 0x05, 0xf7, 0xce, 0x89, 0x63, 0xd1, 0x1f, 0x8b, 0xed, 0x9e, 0x3b, 0xb4, 0x8a, 0xdd, 0x8a,
	0x5f, 0x1c, 0x29, 0x45, 0xc7, 0xb5, 0x68, 0x61, 0xe0, 0xb9, 0xcc, 0x45, 0xab, 0x62, 0xbf, 0x10,
	0xec, 0x17, 0xba, 0x15, 0xbf, 0x30, 0x52, 0xb2, 0xf7, 0x3b, 0xae, 0xdb, 0xe9, 0xd1, 0x62, 0x00,
	0x39, 0x19, 0x9e, 0x16, 0x99, 0xdd, 0xa7, 0x3e, 0x23, 0xfd, 0x81, 0x60, 0x65, 0xef, 0x4e, 0x59,
	0x1d, 0x91, 0x9e, 0x6d, 0x11, 0x66, 0xbb, 0x8e, 0xd8, 0xce, 0xfd, 0x91, 0x80, 0x78, 0xdd, 0xb5,
	0x28, 0xaa, 0x40, 0xc2, 0x67, 0x84, 0x0d, 0xfd, 0xb5, 0xc8, 0x7a, 0xe4, 0x51, 0x46, 0x5d, 0x2f,
	0xdc, 0x70, 0x5c, 0x81, 0x43, 0x0b, 0xcd, 0x00, 0x67, 0x84, 0x78, 0xa4, 0x42, 0xdc, 0x1f, 0xd0,
	0xf6, 0x5a, 0x74, 0x3d, 0xf2, 0x28, 0xa5, 0xde, 0xfb, 0x00, 0x6f, 0x40, 0xdb, 0x46, 0x80, 0x45,
	0x07, 0xb0, 0x14, 0xec, 0x9b, 0xe1, 0x99, 0xb1, 0x80, 0xfb, 0x70, 0x3e, 0xb7, 0xca, 0x35, 0xe1,
	0xc1, 0xa9, 0xf6, 0xfb, 0x05, 0xfa, 0x1a, 0x56, 0xba, 0xc3, 0x13, 0xea, 0x39, 0x94, 0x51, 0x7f,
	0x6c, 0x2e, 0x1e, 0x98, 0xdb, 0x98, 0x6f, 0xee, 0xab, 0x09, 0x25, 0xb4, 0x29, 0x75, 0x67, 0x34,
	0xd9, 0x3f, 0x23, 0x20, 0xcd, 0xc2, 0x50, 0x06, 0xa2, 0xb6, 0x15, 0x44, 0x28, 0x69, 0x44, 0x6d,
	0x0b, 0x3d, 0x03, 0x68, 0xbb, 0x8e, 0x65, 0xf3, 0x88, 0xfa, 0x6b, 0xd1, 0xf5, 0xd8, 0xdc, 0x08,
	0x54, 0xc7, 0x30, 0xe3, 0x1a, 0x03, 0xa9, 0x90, 0x60, 0xc4, 0x76, 0x18, 0x8f, 0x00, 0xe7, 0x66,
	0x6f, 0xe4, 0xb6, 0x38, 0xc4, 0x08, 0x91, 0xa8, 0x0e, 0x12, 0x61, 0x8c, 0xb4, 0xcf, 0xa8, 0x65,
	0x8e, 0xdc, 0xde, 0xb0, 0x4f, 0xb9, 0xc3, 0x9c, 0xfd, 0xe0, 0x46, 0xf6, 0x4e, 0x08, 0x3e, 0x0e,
	0xb0, 0xc6, 0x32, 0x99, 0x5a, 0xfb, 0xd9, 0xef, 0x20, 0x75, 0x2d, 0xba, 0xff, 0x72, 0xf1, 0xce,
	0xa4, 0x30, 0xa2, 0x81, 0x6e, 0x9c, 0xf6, 0x87, 0x90, 0x11, 0x92, 0xd9, 0xa7, 0xbe, 0x4f, 0x3a,
	0x34, 0x48, 0x62, 0xd2, 0x48, 0x0b, 0xed, 0x4b, 0xa1, 0xcc, 0xfe, 0x04, 0x71, 0x9e, 0x77, 0xf4,
	0x05, 0x24, 0x3d, 0xea, 0xbb, 0x43, 0xaf, 0x4d, 0x45, 0x89, 0xa5, 0xd4, 0xdc, 0x8d, 0xd7, 0x35,
	0xc6, 0xa8, 0xa0, 0x5c, 0xde, 0x93, 0x90, 0x02, 0x71, 0xcb, 0xf6, 0xbb, 0x61, 0x9d, 0xdd, 0xbd,
	0x91, 0xbc, 0x67, 0xfb, 0x5d, 0x51, 0x66, 0x1c, 0x9a, 0xeb, 0x41, 0x22, 0xf4, 0xea, 0x0e, 0xa0,
	0x66, 0x6b, 0xa7, 0x75, 0xd4, 0x34, 0x8f, 0xea, 0xcd, 0x43, 0xbd, 0x5a, 0xdb, 0xaf, 0xe9, 0x7b,
	0xd2, 0xff, 0x90, 0x04, 0x4b, 0x87, 0x46, 0xe3, 0xb8, 0xd6, 0xac, 0x35, 0xea, 0xb5, 0xfa, 0x97,
	0x52, 0x04, 0xad, 0x40, 0xba, 0xde, 0x68, 0x99, 0xd5, 0x46, 0xbd, 0xae, 0x57, 0x5b, 0xfa, 0x9e,
	0x14, 0x45, 0x69, 0x48, 0x72, 0x95, 0xa1, 0xef, 0xec, 0xbd, 0x92, 0x62, 0x28, 0x09, 0x0b, 0x42,
	0x8c, 0xa3, 0x14, 0xdc, 0x7a, 0x59, 0x6b, 0x36, 0x39, 0x73, 0x21, 0xf7, 0x57, 0x04, 0x92, 0x93,
	0x34, 0x23, 0x04, 0x71, 0x76, 0x3e, 0xa0, 0x61, 0x24, 0x03, 0x79, 0x6e, 0x2c, 0xd7, 0xe0, 0xd6,
	0x74, 0x10, 0xc7, 0x4b, 0xf4, 0x1c, 0x56, 0x7b, 0xc4, 0x67, 0xe6, 0x19, 0x25, 0x1e, 0x3b, 0xa1,
	0x84, 0x99, 0xbc, 0xc1, 0xc3, 0x02, 0xcf, 0x16, 0x44, 0xf7, 0x17, 0xc6, 0xdd, 0x5f, 0x68, 0x8d,
	0xbb, 0xdf, 0x58, 0xe1, 0xb4, 0x83, 0x31, 0x8b, 0xeb, 0xd1, 0x0b, 0xb8, 0x1d, 0xd8, 0x62, 0x1e,
	0x71, 0xfc, 0xe0, 0x92, 0xc2, 0xd8, 0xc2, 0x7f, 0x1a, 0x43, 0x9c, 0xd7, 0x9a, 0xd0, 0xf8, 0x46,
	0xee, 0xf7, 0x08, 0x2c, 0x04, 0x85, 0x89, 0x24, 0x88, 0x75, 0xe9, 0x79, 0xe8, 0x28, 0x17, 0xd1,
	0x6d, 0x58, 0x18, 0x91, 0xde, 0x90, 0x86, 0x6e, 0x8a, 0x05, 0x7a, 0x02, 0x09, 0x7a, 0x7a, 0x4a,
	0xdb, 0x2c, 0x70, 0x32, 0xa3, 0x7e, 0x3a, 0xbf, 0xd8, 0x0b, 0x7a, 0x00, 0x34, 0x42, 0x42, 0xee,
	0x15, 0x24, 0x84, 0x86, 0x27, 0x52, 0xdf, 0xdf, 0xd7, 0xab, 0xad, 0x99, 0x44, 0x2e, 0x43, 0xaa,
	0xde, 0x30, 0x9b, 0xd5, 0x03, 0x7d, 0xef, 0xe8, 0x85, 0x2e, 0x45, 0x38, 0xf0, 0xd0, 0xd0, 0xf7,
	0x75, 0xc3, 0xbc, 0xae, 0x8f, 0xa2, 0x0c, 0x40, 0xbd, 0x61, 0xea, 0xdf, 0xe8, 0xd5, 0xa3, 0x96,
	0x2e, 0xc5, 0x72, 0xc7, 0x90, 0x99, 0xee, 0x10, 0x74, 0x1f, 0x52, 0x96, 0x67, 0x8f, 0xa8, 0x67,
	0x3a, 0xa4, 0x3f, 0x4e, 0x20, 0x08, 0x55, 0x9d, 0xf4, 0x29, 0x7a, 0x00, 0x69, 0xd1, 0x78, 0xe6,
	0x19, 0x71, 0xac, 0xde, 0xd8, 0xcd, 0x25, 0xa1, 0x3c, 0x08, 0x74, 0xb9, 0xdf, 0xe2, 0xb0, 0xc4,
	0x67, 0x4d, 0x8b, 0xf6, 0x07, 0x3d, 0xc2, 0x02, 0xb3, 0x5c, 0x38, 0x75, 0xbd, 0xbe, 0x39, 0xe9,
	0x30, 0x18, 0xab, 0x6a, 0x16, 0xaa, 0x41, 0x66, 0x52, 0xed, 0xe6, 0xb5, 0x91, 0xfa, 0x31, 0x7d,
	0x92, 0xf6, 0xae, 0x2f, 0x51, 0x15, 0x32, 0x27, 0xae, 0xcb, 0x4c, 0xde, 0x05, 0xc2, 0x54, 0xec,
	0x63, 0xba, 0x66, 0x89, 0x93, 0xc6, 0x2b, 0xf4, 0x73, 0x04, 0x16, 0xfb, 0x94, 0x11, 0x8b, 0x30,
	0x12, 0x4e, 0x98, 0xe2, 0xdc, 0x91, 0x3a, 0x76, 0xb3, 0xf0, 0x32, 0x64, 0xe8, 0x0e, 0xf3, 0xce,
	0x77, 0xb5, 0x5f, 0x2e, 0x95, 0xf8, 0xd3, 0xed, 0xb2, 0xf6, 0xeb, 0xa5, 0xb2, 0xf8, 0x74, 0x5b,
	0x29, 0x29, 0xf2, 0x63, 0xf5, 0xdd, 0xa5, 0x92, 0xc8, 0xc6, 0x95, 0x7c, 0xb9, 0xf4, 0xee, 0x52,
	0x41, 0x48, 0x7a, 0x4d, 0xf2, 0x6f, 0xbe, 0x7f, 0x9d, 0x37, 0xe5, 0xfc, 0x13, 0x2e, 0x6d, 0x18,
	0x93, 0x63, 0xd1, 0x0b, 0x58, 0x1e, 0x69, 0x26, 0xb1, 0x2c, 0x8f, 0xfa, 0x61, 0x50, 0x44, 0xb9,
	0x7e, 0x36, 0xf7, 0x26, 0x3b, 0x02, 0x2c, 0xc2, 0x32, 0xd2, 0xae, 0x2d, 0x91, 0x01, 0x2b, 0x3e,
	0x4f, 0xf4, 0xb0, 0x67, 0x3b, 0x1d, 0x73, 0xe0, 0xf6, 0xec, 0xf6, 0xf9, 0x5a, 0xe2, 0x03, 0x6f,
	0x4f, 0x73, 0x82, 0x3e, 0x0c, 0xc0, 0x86, 0xe4, 0xcf, 0x68, 0xb2, 0x5b, 0x90, 0x9e, 0x72, 0xf9,
	0x63, 0xdb, 0xe1, 0xf3, 0x68, 0x25, 0x92, 0xa3, 0xb0, 0x3c, 0x73, 0x65, 0x64, 0xc0, 0xaa, 0xeb,
	0x50, 0x93, 0xb9, 0x26, 0xff, 0x38, 0x84, 0x09, 0xaf, 0x23, 0x1f, 0xf0, 0xba, 0xe1, 0xd0, 0x96,
	0xdb, 0x70, 0x68, 0x9d, 0xb0, 0xc0, 0xeb, 0x65, 0x77, 0x5a, 0x91, 0x3b, 0x84, 0xe5, 0x19, 0x0c,
	0xda, 0x06, 0xb0, 0x07, 0xe6, 0x88, 0x7a, 0xbe, 0xed, 0x3a, 0xe1, 0x9b, 0x7f, 0xf3, 0xcb, 0x55,
	0x1b, 0x1c, 0x0b, 0x94, 0x91, 0xb4, 0xc7, 0x62, 0xee, 0x2a, 0x02, 0xe9, 0xa9, 0x0a, 0x44, 0x1b,
	0x90, 0xe8, 0xd3, 0xbe, 0xeb, 0x09, 0xcf, 0x63, 0xbb, 0xe8, 0xea, 0x42, 0xc9, 0x3c, 0xdd, 0xae,
	0xa8, 0x5a, 0xb9, 0x54, 0x7a, 0xac, 0xca, 0x95, 0x92, 0x6a, 0x84, 0x08, 0x64, 0xc1, 0x42, 0xdb,
	0xf5, 0xa8, 0x18, 0x83, 0xb1, 0xdd, 0xfa, 0xd5, 0x85, 0xf2, 0x5c, 0xc6, 0x0a, 0x56, 0xb1, 0x86,
	0xcb, 0xb8, 0x82, 0x15, 0x19, 0x2b, 0x2a, 0x56, 0x34, 0xac, 0x94, 0xb1, 0x52, 0xc1, 0xaa, 0x8c,
	0x55, 0x15, 0xab, 0x1a, 0x56, 0xcb, 0x58, 0xad, 0xe0, 0x92, 0x8c, 0x4b, 0x2a, 0x2e, 0x69, 0xb8,
	0x54, 0xc6, 0x9a, 0x8c, 0x35, 0x0d, 0x6b, 0x15, 0xbc, 0xa9, 0xe2, 0xcd, 0x32, 0x2e, 0xcb, 0xb8,
	0xac, 0x19, 0xc2, 0x38, 0x2a, 0x43, 0x9a, 0x0b, 0xe6, 0xa9, 0x47, 0xda, 0x7c, 0x6c, 0x05, 0x3d,
	0x10, 0xdb, 0x5d, 0xb9, 0xba, 0x50, 0xd2, 0x32, 0xde, 0xe4, 0x66, 0x37, 0x65, 0xac, 0xc8, 0xb2,
	0xb1, 0xc4, 0x71, 0xfb, 0x21, 0x0c, 0xdd, 0x87, 0x78, 0x67, 0x10, 0xfe, 0x45, 0xc4, 0x76, 0x53,
	0x57, 0x17, 0xca, 0xad, 0xf0, 0x72, 0x46, 0xb0, 0x91, 0x7b, 0x0b, 0x8b, 0x93, 0x26, 0x79, 0x06,
	0x4b, 0x41, 0x93, 0xf1, 0xf9, 0x3e, 0x69, 0xeb, 0xdd, 0x4f, 0xfe, 0xbe, 0x50, 0xd6, 0xde, 0x3a,
	0x94, 0xfd, 0xe0, 0x7a, 0xdd, 0xbc, 0xef, 0x5b, 0x13, 0xf9, 0xcc, 0xb2, 0x0c, 0xe0, 0x8c, 0xd6,
	0xf9, 0x80, 0xd6, 0x2c, 0x24, 0x43, 0x52, 0x34, 0xa9, 0xfd, 0x86, 0x86, 0xe1, 0x58, 0xbd, 0xba,
	0x50, 0x96, 0xe5, 0xbc, 0x56, 0x7a, 0x52, 0x91, 0xb5, 0xf2, 0xa6, 0xa2, 0x28, 0xb2, 0x66, 0x2c,
	0x72, 0x54, 0xd3, 0x7e, 0x43, 0x73, 0x1a, 0x48, 0xb3, 0x65, 0x89, 0xd6, 0x21, 0x35, 0xf0, 0x28,
	0xed, 0x0f, 0x98, 0x7d, 0xd2, 0x13, 0x23, 0x6b, 0xd1, 0xb8, 0xae, 0xda, 0xd8, 0x82, 0xe4, 0x24,
	0x91, 0x28, 0x0b, 0x77, 0x6a, 0x87, 0xe6, 0xb1, 0x6e, 0xf0, 0x67, 0x6f, 0x66, 0x90, 0x2e, 0x42,
	0xbc, 0x76, 0x78, 0xac, 0x49, 0x91, 0x50, 0x2a, 0x4b, 0xd1, 0xdd, 0x63, 0xf8, 0xff, 0x54, 0x65,
	0x90, 0x81, 0x1d, 0x56, 0xc7, 0xb7, 0x5b, 0x1d, 0x9b, 0x9d, 0x0d, 0x4f, 0x0a, 0x6d, 0xb7, 0x5f,
	0x14, 0x98, 0xbc, 0xf8, 0xd5, 0xec, 0xb8, 0xf9, 0x0e, 0x75, 0x82, 0xc7, 0xa4, 0x78, 0xc3, 0x9f,
	0xed, 0x56, 0xb7, 0xe2, 0x9f, 0x24, 0x82, 0xed, 0xd2, 0x3f, 0x01, 0x00, 0x00, 0xff, 0xff, 0xda,
	0x98, 0x33, 0xc0, 0xfb, 0x0a, 0x00, 0x00,
}
