// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/mdb/mongodb/v1/cluster_service.proto

package mongodb

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	config "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/mongodb/v1/config"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	timeofday "google.golang.org/genproto/googleapis/type/timeofday"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type ListClusterLogsRequest_ServiceType int32

const (
	ListClusterLogsRequest_SERVICE_TYPE_UNSPECIFIED ListClusterLogsRequest_ServiceType = 0
	// Logs of MongoDB activity.
	ListClusterLogsRequest_MONGOD ListClusterLogsRequest_ServiceType = 1
)

var ListClusterLogsRequest_ServiceType_name = map[int32]string{
	0: "SERVICE_TYPE_UNSPECIFIED",
	1: "MONGOD",
}

var ListClusterLogsRequest_ServiceType_value = map[string]int32{
	"SERVICE_TYPE_UNSPECIFIED": 0,
	"MONGOD":                   1,
}

func (x ListClusterLogsRequest_ServiceType) String() string {
	return proto.EnumName(ListClusterLogsRequest_ServiceType_name, int32(x))
}

func (ListClusterLogsRequest_ServiceType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{20, 0}
}

type StreamClusterLogsRequest_ServiceType int32

const (
	StreamClusterLogsRequest_SERVICE_TYPE_UNSPECIFIED StreamClusterLogsRequest_ServiceType = 0
	// Logs of MongoDB activity.
	StreamClusterLogsRequest_MONGOD StreamClusterLogsRequest_ServiceType = 1
)

var StreamClusterLogsRequest_ServiceType_name = map[int32]string{
	0: "SERVICE_TYPE_UNSPECIFIED",
	1: "MONGOD",
}

var StreamClusterLogsRequest_ServiceType_value = map[string]int32{
	"SERVICE_TYPE_UNSPECIFIED": 0,
	"MONGOD":                   1,
}

func (x StreamClusterLogsRequest_ServiceType) String() string {
	return proto.EnumName(StreamClusterLogsRequest_ServiceType_name, int32(x))
}

func (StreamClusterLogsRequest_ServiceType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{22, 0}
}

type GetClusterRequest struct {
	// ID of the MongoDB Cluster resource to return.
	// To get the cluster ID, use a [ClusterService.List] request.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetClusterRequest) Reset()         { *m = GetClusterRequest{} }
func (m *GetClusterRequest) String() string { return proto.CompactTextString(m) }
func (*GetClusterRequest) ProtoMessage()    {}
func (*GetClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{0}
}

func (m *GetClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetClusterRequest.Unmarshal(m, b)
}
func (m *GetClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetClusterRequest.Marshal(b, m, deterministic)
}
func (m *GetClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetClusterRequest.Merge(m, src)
}
func (m *GetClusterRequest) XXX_Size() int {
	return xxx_messageInfo_GetClusterRequest.Size(m)
}
func (m *GetClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetClusterRequest proto.InternalMessageInfo

func (m *GetClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type ListClustersRequest struct {
	// ID of the folder to list MongoDB clusters in.
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	PageSize int64  `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token]
	// to the [ListClustersResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// The expression must specify:
	// 1. The field name. Currently you can only use filtering with the [Cluster.name] field.
	// 2. An operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.
	// 3. The value. Мust be 1-63 characters long and match the regular expression `^[a-zA-Z0-9_-]+$`.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClustersRequest) Reset()         { *m = ListClustersRequest{} }
func (m *ListClustersRequest) String() string { return proto.CompactTextString(m) }
func (*ListClustersRequest) ProtoMessage()    {}
func (*ListClustersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{1}
}

func (m *ListClustersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClustersRequest.Unmarshal(m, b)
}
func (m *ListClustersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClustersRequest.Marshal(b, m, deterministic)
}
func (m *ListClustersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClustersRequest.Merge(m, src)
}
func (m *ListClustersRequest) XXX_Size() int {
	return xxx_messageInfo_ListClustersRequest.Size(m)
}
func (m *ListClustersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClustersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClustersRequest proto.InternalMessageInfo

func (m *ListClustersRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *ListClustersRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClustersRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListClustersRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListClustersResponse struct {
	// List of MongoDB Cluster resources.
	Clusters []*Cluster `protobuf:"bytes,1,rep,name=clusters,proto3" json:"clusters,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListClustersRequest.page_size], use the [next_page_token] as the value
	// for the [ListClustersRequest.page_token] parameter in the next list request. Each subsequent
	// list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClustersResponse) Reset()         { *m = ListClustersResponse{} }
func (m *ListClustersResponse) String() string { return proto.CompactTextString(m) }
func (*ListClustersResponse) ProtoMessage()    {}
func (*ListClustersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{2}
}

func (m *ListClustersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClustersResponse.Unmarshal(m, b)
}
func (m *ListClustersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClustersResponse.Marshal(b, m, deterministic)
}
func (m *ListClustersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClustersResponse.Merge(m, src)
}
func (m *ListClustersResponse) XXX_Size() int {
	return xxx_messageInfo_ListClustersResponse.Size(m)
}
func (m *ListClustersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClustersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClustersResponse proto.InternalMessageInfo

func (m *ListClustersResponse) GetClusters() []*Cluster {
	if m != nil {
		return m.Clusters
	}
	return nil
}

func (m *ListClustersResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateClusterRequest struct {
	// ID of the folder to create MongoDB cluster in.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the MongoDB cluster. The name must be unique within the folder.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the MongoDB cluster.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the MongoDB cluster as `` key:value `` pairs. Maximum 64 per resource.
	// For example, "project": "mvp" or "source": "dictionary".
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Deployment environment of the MongoDB cluster.
	Environment Cluster_Environment `protobuf:"varint,5,opt,name=environment,proto3,enum=yandex.cloud.mdb.mongodb.v1.Cluster_Environment" json:"environment,omitempty"`
	// Configuration and resources for hosts that should be created for the MongoDB cluster.
	ConfigSpec *ConfigSpec `protobuf:"bytes,6,opt,name=config_spec,json=configSpec,proto3" json:"config_spec,omitempty"`
	// Descriptions of databases to be created in the MongoDB cluster.
	DatabaseSpecs []*DatabaseSpec `protobuf:"bytes,7,rep,name=database_specs,json=databaseSpecs,proto3" json:"database_specs,omitempty"`
	// Descriptions of database users to be created in the MongoDB cluster.
	UserSpecs []*UserSpec `protobuf:"bytes,8,rep,name=user_specs,json=userSpecs,proto3" json:"user_specs,omitempty"`
	// Individual configurations for hosts that should be created for the MongoDB cluster.
	HostSpecs []*HostSpec `protobuf:"bytes,9,rep,name=host_specs,json=hostSpecs,proto3" json:"host_specs,omitempty"`
	// ID of the network to create the cluster in.
	NetworkId            string   `protobuf:"bytes,10,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateClusterRequest) Reset()         { *m = CreateClusterRequest{} }
func (m *CreateClusterRequest) String() string { return proto.CompactTextString(m) }
func (*CreateClusterRequest) ProtoMessage()    {}
func (*CreateClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{3}
}

func (m *CreateClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateClusterRequest.Unmarshal(m, b)
}
func (m *CreateClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateClusterRequest.Marshal(b, m, deterministic)
}
func (m *CreateClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateClusterRequest.Merge(m, src)
}
func (m *CreateClusterRequest) XXX_Size() int {
	return xxx_messageInfo_CreateClusterRequest.Size(m)
}
func (m *CreateClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateClusterRequest proto.InternalMessageInfo

func (m *CreateClusterRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *CreateClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateClusterRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *CreateClusterRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *CreateClusterRequest) GetEnvironment() Cluster_Environment {
	if m != nil {
		return m.Environment
	}
	return Cluster_ENVIRONMENT_UNSPECIFIED
}

func (m *CreateClusterRequest) GetConfigSpec() *ConfigSpec {
	if m != nil {
		return m.ConfigSpec
	}
	return nil
}

func (m *CreateClusterRequest) GetDatabaseSpecs() []*DatabaseSpec {
	if m != nil {
		return m.DatabaseSpecs
	}
	return nil
}

func (m *CreateClusterRequest) GetUserSpecs() []*UserSpec {
	if m != nil {
		return m.UserSpecs
	}
	return nil
}

func (m *CreateClusterRequest) GetHostSpecs() []*HostSpec {
	if m != nil {
		return m.HostSpecs
	}
	return nil
}

func (m *CreateClusterRequest) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

type CreateClusterMetadata struct {
	// ID of the MongoDB cluster that is being created.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateClusterMetadata) Reset()         { *m = CreateClusterMetadata{} }
func (m *CreateClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateClusterMetadata) ProtoMessage()    {}
func (*CreateClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{4}
}

func (m *CreateClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateClusterMetadata.Unmarshal(m, b)
}
func (m *CreateClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateClusterMetadata.Marshal(b, m, deterministic)
}
func (m *CreateClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateClusterMetadata.Merge(m, src)
}
func (m *CreateClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateClusterMetadata.Size(m)
}
func (m *CreateClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateClusterMetadata proto.InternalMessageInfo

func (m *CreateClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type UpdateClusterRequest struct {
	// ID of the MongoDB Cluster resource to update.
	// To get the MongoDB cluster ID use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Field mask that specifies which fields of the MongoDB Cluster resource should be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// New description of the MongoDB cluster.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the MongoDB cluster as `` key:value `` pairs. Maximum 64 per resource.
	// For example, "project": "mvp" or "source": "dictionary".
	//
	// The new set of labels will completely replace the old ones. To add a label, request the current
	// set with the [ClusterService.Get] method, then send an [ClusterService.Update] request with the new label added to the set.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// New configuration and resources for hosts in the cluster.
	ConfigSpec *ConfigSpec `protobuf:"bytes,5,opt,name=config_spec,json=configSpec,proto3" json:"config_spec,omitempty"`
	// New name for the cluster.
	Name                 string   `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateClusterRequest) Reset()         { *m = UpdateClusterRequest{} }
func (m *UpdateClusterRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateClusterRequest) ProtoMessage()    {}
func (*UpdateClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{5}
}

func (m *UpdateClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateClusterRequest.Unmarshal(m, b)
}
func (m *UpdateClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateClusterRequest.Marshal(b, m, deterministic)
}
func (m *UpdateClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateClusterRequest.Merge(m, src)
}
func (m *UpdateClusterRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateClusterRequest.Size(m)
}
func (m *UpdateClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateClusterRequest proto.InternalMessageInfo

func (m *UpdateClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *UpdateClusterRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateClusterRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *UpdateClusterRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *UpdateClusterRequest) GetConfigSpec() *ConfigSpec {
	if m != nil {
		return m.ConfigSpec
	}
	return nil
}

func (m *UpdateClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type UpdateClusterMetadata struct {
	// ID of the MongoDB Cluster resource that is being updated.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateClusterMetadata) Reset()         { *m = UpdateClusterMetadata{} }
func (m *UpdateClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateClusterMetadata) ProtoMessage()    {}
func (*UpdateClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{6}
}

func (m *UpdateClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateClusterMetadata.Unmarshal(m, b)
}
func (m *UpdateClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateClusterMetadata.Marshal(b, m, deterministic)
}
func (m *UpdateClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateClusterMetadata.Merge(m, src)
}
func (m *UpdateClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateClusterMetadata.Size(m)
}
func (m *UpdateClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateClusterMetadata proto.InternalMessageInfo

func (m *UpdateClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type DeleteClusterRequest struct {
	// ID of the MongoDB cluster to delete.
	// To get the MongoDB cluster ID, use a [ClusterService.List] request.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClusterRequest) Reset()         { *m = DeleteClusterRequest{} }
func (m *DeleteClusterRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteClusterRequest) ProtoMessage()    {}
func (*DeleteClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{7}
}

func (m *DeleteClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClusterRequest.Unmarshal(m, b)
}
func (m *DeleteClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClusterRequest.Marshal(b, m, deterministic)
}
func (m *DeleteClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClusterRequest.Merge(m, src)
}
func (m *DeleteClusterRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteClusterRequest.Size(m)
}
func (m *DeleteClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClusterRequest proto.InternalMessageInfo

func (m *DeleteClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type DeleteClusterMetadata struct {
	// ID of the MongoDB cluster that is being deleted.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClusterMetadata) Reset()         { *m = DeleteClusterMetadata{} }
func (m *DeleteClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteClusterMetadata) ProtoMessage()    {}
func (*DeleteClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{8}
}

func (m *DeleteClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClusterMetadata.Unmarshal(m, b)
}
func (m *DeleteClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClusterMetadata.Marshal(b, m, deterministic)
}
func (m *DeleteClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClusterMetadata.Merge(m, src)
}
func (m *DeleteClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteClusterMetadata.Size(m)
}
func (m *DeleteClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClusterMetadata proto.InternalMessageInfo

func (m *DeleteClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type StartClusterRequest struct {
	// ID of the MongoDB cluster to start.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartClusterRequest) Reset()         { *m = StartClusterRequest{} }
func (m *StartClusterRequest) String() string { return proto.CompactTextString(m) }
func (*StartClusterRequest) ProtoMessage()    {}
func (*StartClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{9}
}

func (m *StartClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartClusterRequest.Unmarshal(m, b)
}
func (m *StartClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartClusterRequest.Marshal(b, m, deterministic)
}
func (m *StartClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartClusterRequest.Merge(m, src)
}
func (m *StartClusterRequest) XXX_Size() int {
	return xxx_messageInfo_StartClusterRequest.Size(m)
}
func (m *StartClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StartClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StartClusterRequest proto.InternalMessageInfo

func (m *StartClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type StartClusterMetadata struct {
	// ID of the MongoDB cluster.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartClusterMetadata) Reset()         { *m = StartClusterMetadata{} }
func (m *StartClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*StartClusterMetadata) ProtoMessage()    {}
func (*StartClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{10}
}

func (m *StartClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartClusterMetadata.Unmarshal(m, b)
}
func (m *StartClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartClusterMetadata.Marshal(b, m, deterministic)
}
func (m *StartClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartClusterMetadata.Merge(m, src)
}
func (m *StartClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_StartClusterMetadata.Size(m)
}
func (m *StartClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_StartClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_StartClusterMetadata proto.InternalMessageInfo

func (m *StartClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type StopClusterRequest struct {
	// ID of the MongoDB cluster to stop.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StopClusterRequest) Reset()         { *m = StopClusterRequest{} }
func (m *StopClusterRequest) String() string { return proto.CompactTextString(m) }
func (*StopClusterRequest) ProtoMessage()    {}
func (*StopClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{11}
}

func (m *StopClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StopClusterRequest.Unmarshal(m, b)
}
func (m *StopClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StopClusterRequest.Marshal(b, m, deterministic)
}
func (m *StopClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StopClusterRequest.Merge(m, src)
}
func (m *StopClusterRequest) XXX_Size() int {
	return xxx_messageInfo_StopClusterRequest.Size(m)
}
func (m *StopClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StopClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StopClusterRequest proto.InternalMessageInfo

func (m *StopClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type StopClusterMetadata struct {
	// ID of the MongoDB cluster.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StopClusterMetadata) Reset()         { *m = StopClusterMetadata{} }
func (m *StopClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*StopClusterMetadata) ProtoMessage()    {}
func (*StopClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{12}
}

func (m *StopClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StopClusterMetadata.Unmarshal(m, b)
}
func (m *StopClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StopClusterMetadata.Marshal(b, m, deterministic)
}
func (m *StopClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StopClusterMetadata.Merge(m, src)
}
func (m *StopClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_StopClusterMetadata.Size(m)
}
func (m *StopClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_StopClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_StopClusterMetadata proto.InternalMessageInfo

func (m *StopClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type MoveClusterRequest struct {
	// ID of the MongoDB cluster to move.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the destination folder.
	DestinationFolderId  string   `protobuf:"bytes,2,opt,name=destination_folder_id,json=destinationFolderId,proto3" json:"destination_folder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MoveClusterRequest) Reset()         { *m = MoveClusterRequest{} }
func (m *MoveClusterRequest) String() string { return proto.CompactTextString(m) }
func (*MoveClusterRequest) ProtoMessage()    {}
func (*MoveClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{13}
}

func (m *MoveClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MoveClusterRequest.Unmarshal(m, b)
}
func (m *MoveClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MoveClusterRequest.Marshal(b, m, deterministic)
}
func (m *MoveClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MoveClusterRequest.Merge(m, src)
}
func (m *MoveClusterRequest) XXX_Size() int {
	return xxx_messageInfo_MoveClusterRequest.Size(m)
}
func (m *MoveClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MoveClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MoveClusterRequest proto.InternalMessageInfo

func (m *MoveClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *MoveClusterRequest) GetDestinationFolderId() string {
	if m != nil {
		return m.DestinationFolderId
	}
	return ""
}

type MoveClusterMetadata struct {
	// ID of the MongoDB cluster being moved.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the source folder.
	SourceFolderId string `protobuf:"bytes,2,opt,name=source_folder_id,json=sourceFolderId,proto3" json:"source_folder_id,omitempty"`
	// ID of the destnation folder.
	DestinationFolderId  string   `protobuf:"bytes,3,opt,name=destination_folder_id,json=destinationFolderId,proto3" json:"destination_folder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MoveClusterMetadata) Reset()         { *m = MoveClusterMetadata{} }
func (m *MoveClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*MoveClusterMetadata) ProtoMessage()    {}
func (*MoveClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{14}
}

func (m *MoveClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MoveClusterMetadata.Unmarshal(m, b)
}
func (m *MoveClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MoveClusterMetadata.Marshal(b, m, deterministic)
}
func (m *MoveClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MoveClusterMetadata.Merge(m, src)
}
func (m *MoveClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_MoveClusterMetadata.Size(m)
}
func (m *MoveClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_MoveClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_MoveClusterMetadata proto.InternalMessageInfo

func (m *MoveClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *MoveClusterMetadata) GetSourceFolderId() string {
	if m != nil {
		return m.SourceFolderId
	}
	return ""
}

func (m *MoveClusterMetadata) GetDestinationFolderId() string {
	if m != nil {
		return m.DestinationFolderId
	}
	return ""
}

type BackupClusterRequest struct {
	// ID of the MongoDB cluster to back up.
	// To get the MongoDB cluster ID, use a [ClusterService.List] request.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BackupClusterRequest) Reset()         { *m = BackupClusterRequest{} }
func (m *BackupClusterRequest) String() string { return proto.CompactTextString(m) }
func (*BackupClusterRequest) ProtoMessage()    {}
func (*BackupClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{15}
}

func (m *BackupClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BackupClusterRequest.Unmarshal(m, b)
}
func (m *BackupClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BackupClusterRequest.Marshal(b, m, deterministic)
}
func (m *BackupClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BackupClusterRequest.Merge(m, src)
}
func (m *BackupClusterRequest) XXX_Size() int {
	return xxx_messageInfo_BackupClusterRequest.Size(m)
}
func (m *BackupClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BackupClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BackupClusterRequest proto.InternalMessageInfo

func (m *BackupClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type BackupClusterMetadata struct {
	// ID of the MongoDB cluster that is being backed up.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BackupClusterMetadata) Reset()         { *m = BackupClusterMetadata{} }
func (m *BackupClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*BackupClusterMetadata) ProtoMessage()    {}
func (*BackupClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{16}
}

func (m *BackupClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BackupClusterMetadata.Unmarshal(m, b)
}
func (m *BackupClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BackupClusterMetadata.Marshal(b, m, deterministic)
}
func (m *BackupClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BackupClusterMetadata.Merge(m, src)
}
func (m *BackupClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_BackupClusterMetadata.Size(m)
}
func (m *BackupClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_BackupClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_BackupClusterMetadata proto.InternalMessageInfo

func (m *BackupClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type RestoreClusterRequest struct {
	// ID of the backup to create a cluster from.
	// To get the backup ID, use a [ClusterService.ListBackups] request.
	BackupId string `protobuf:"bytes,1,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
	// Name of the new MongoDB cluster. The name must be unique within the folder.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the new MongoDB cluster.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the MongoDB cluster as `` key:value `` pairs. Maximum 64 per resource.
	// For example, "project": "mvp" or "source": "dictionary".
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Deployment environment of the new MongoDB cluster.
	Environment Cluster_Environment `protobuf:"varint,5,opt,name=environment,proto3,enum=yandex.cloud.mdb.mongodb.v1.Cluster_Environment" json:"environment,omitempty"`
	// Configuration for the MongoDB cluster to be created.
	ConfigSpec *ConfigSpec `protobuf:"bytes,6,opt,name=config_spec,json=configSpec,proto3" json:"config_spec,omitempty"`
	// Configurations for MongoDB hosts that should be created for
	// the cluster that is being created from the backup.
	HostSpecs []*HostSpec `protobuf:"bytes,7,rep,name=host_specs,json=hostSpecs,proto3" json:"host_specs,omitempty"`
	// ID of the network to create the MongoDB cluster in.
	NetworkId string `protobuf:"bytes,8,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// Required. ID of the folder to create the MongoDB cluster in.
	FolderId string `protobuf:"bytes,9,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Specification of the moment to which the MongoDB cluster should be restored.
	RecoveryTargetSpec   *RestoreClusterRequest_RecoveryTargetSpec `protobuf:"bytes,10,opt,name=recovery_target_spec,json=recoveryTargetSpec,proto3" json:"recovery_target_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                  `json:"-"`
	XXX_unrecognized     []byte                                    `json:"-"`
	XXX_sizecache        int32                                     `json:"-"`
}

func (m *RestoreClusterRequest) Reset()         { *m = RestoreClusterRequest{} }
func (m *RestoreClusterRequest) String() string { return proto.CompactTextString(m) }
func (*RestoreClusterRequest) ProtoMessage()    {}
func (*RestoreClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{17}
}

func (m *RestoreClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RestoreClusterRequest.Unmarshal(m, b)
}
func (m *RestoreClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RestoreClusterRequest.Marshal(b, m, deterministic)
}
func (m *RestoreClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RestoreClusterRequest.Merge(m, src)
}
func (m *RestoreClusterRequest) XXX_Size() int {
	return xxx_messageInfo_RestoreClusterRequest.Size(m)
}
func (m *RestoreClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RestoreClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RestoreClusterRequest proto.InternalMessageInfo

func (m *RestoreClusterRequest) GetBackupId() string {
	if m != nil {
		return m.BackupId
	}
	return ""
}

func (m *RestoreClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *RestoreClusterRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *RestoreClusterRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *RestoreClusterRequest) GetEnvironment() Cluster_Environment {
	if m != nil {
		return m.Environment
	}
	return Cluster_ENVIRONMENT_UNSPECIFIED
}

func (m *RestoreClusterRequest) GetConfigSpec() *ConfigSpec {
	if m != nil {
		return m.ConfigSpec
	}
	return nil
}

func (m *RestoreClusterRequest) GetHostSpecs() []*HostSpec {
	if m != nil {
		return m.HostSpecs
	}
	return nil
}

func (m *RestoreClusterRequest) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

func (m *RestoreClusterRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *RestoreClusterRequest) GetRecoveryTargetSpec() *RestoreClusterRequest_RecoveryTargetSpec {
	if m != nil {
		return m.RecoveryTargetSpec
	}
	return nil
}

type RestoreClusterRequest_RecoveryTargetSpec struct {
	// Timestamp of the recovery target
	Timestamp            int64    `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RestoreClusterRequest_RecoveryTargetSpec) Reset() {
	*m = RestoreClusterRequest_RecoveryTargetSpec{}
}
func (m *RestoreClusterRequest_RecoveryTargetSpec) String() string { return proto.CompactTextString(m) }
func (*RestoreClusterRequest_RecoveryTargetSpec) ProtoMessage()    {}
func (*RestoreClusterRequest_RecoveryTargetSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{17, 1}
}

func (m *RestoreClusterRequest_RecoveryTargetSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RestoreClusterRequest_RecoveryTargetSpec.Unmarshal(m, b)
}
func (m *RestoreClusterRequest_RecoveryTargetSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RestoreClusterRequest_RecoveryTargetSpec.Marshal(b, m, deterministic)
}
func (m *RestoreClusterRequest_RecoveryTargetSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RestoreClusterRequest_RecoveryTargetSpec.Merge(m, src)
}
func (m *RestoreClusterRequest_RecoveryTargetSpec) XXX_Size() int {
	return xxx_messageInfo_RestoreClusterRequest_RecoveryTargetSpec.Size(m)
}
func (m *RestoreClusterRequest_RecoveryTargetSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_RestoreClusterRequest_RecoveryTargetSpec.DiscardUnknown(m)
}

var xxx_messageInfo_RestoreClusterRequest_RecoveryTargetSpec proto.InternalMessageInfo

func (m *RestoreClusterRequest_RecoveryTargetSpec) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

type RestoreClusterMetadata struct {
	// ID of the new MongoDB cluster that is being created from a backup.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the backup that is being used for creating a cluster.
	BackupId             string   `protobuf:"bytes,2,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RestoreClusterMetadata) Reset()         { *m = RestoreClusterMetadata{} }
func (m *RestoreClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*RestoreClusterMetadata) ProtoMessage()    {}
func (*RestoreClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{18}
}

func (m *RestoreClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RestoreClusterMetadata.Unmarshal(m, b)
}
func (m *RestoreClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RestoreClusterMetadata.Marshal(b, m, deterministic)
}
func (m *RestoreClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RestoreClusterMetadata.Merge(m, src)
}
func (m *RestoreClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_RestoreClusterMetadata.Size(m)
}
func (m *RestoreClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_RestoreClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_RestoreClusterMetadata proto.InternalMessageInfo

func (m *RestoreClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *RestoreClusterMetadata) GetBackupId() string {
	if m != nil {
		return m.BackupId
	}
	return ""
}

type LogRecord struct {
	// Log record timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	Timestamp *timestamp.Timestamp `protobuf:"bytes,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Contents of the log record.
	Message              map[string]string `protobuf:"bytes,2,rep,name=message,proto3" json:"message,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *LogRecord) Reset()         { *m = LogRecord{} }
func (m *LogRecord) String() string { return proto.CompactTextString(m) }
func (*LogRecord) ProtoMessage()    {}
func (*LogRecord) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{19}
}

func (m *LogRecord) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogRecord.Unmarshal(m, b)
}
func (m *LogRecord) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogRecord.Marshal(b, m, deterministic)
}
func (m *LogRecord) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogRecord.Merge(m, src)
}
func (m *LogRecord) XXX_Size() int {
	return xxx_messageInfo_LogRecord.Size(m)
}
func (m *LogRecord) XXX_DiscardUnknown() {
	xxx_messageInfo_LogRecord.DiscardUnknown(m)
}

var xxx_messageInfo_LogRecord proto.InternalMessageInfo

func (m *LogRecord) GetTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *LogRecord) GetMessage() map[string]string {
	if m != nil {
		return m.Message
	}
	return nil
}

type ListClusterLogsRequest struct {
	// ID of the MongoDB cluster to request logs for.
	// To get the MongoDB cluster ID use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Columns from the logs table to request.
	// If no columns are specified, entire log records are returned.
	ColumnFilter []string `protobuf:"bytes,2,rep,name=column_filter,json=columnFilter,proto3" json:"column_filter,omitempty"`
	// Type of the service to request logs about.
	ServiceType ListClusterLogsRequest_ServiceType `protobuf:"varint,3,opt,name=service_type,json=serviceType,proto3,enum=yandex.cloud.mdb.mongodb.v1.ListClusterLogsRequest_ServiceType" json:"service_type,omitempty"`
	// Start timestamp for the logs request, in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	FromTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=from_time,json=fromTime,proto3" json:"from_time,omitempty"`
	// End timestamp for the logs request, in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	ToTime   *timestamp.Timestamp `protobuf:"bytes,5,opt,name=to_time,json=toTime,proto3" json:"to_time,omitempty"`
	PageSize int64                `protobuf:"varint,6,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListClusterLogsResponse.next_page_token] returned by a previous list request.
	PageToken            string   `protobuf:"bytes,7,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterLogsRequest) Reset()         { *m = ListClusterLogsRequest{} }
func (m *ListClusterLogsRequest) String() string { return proto.CompactTextString(m) }
func (*ListClusterLogsRequest) ProtoMessage()    {}
func (*ListClusterLogsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{20}
}

func (m *ListClusterLogsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterLogsRequest.Unmarshal(m, b)
}
func (m *ListClusterLogsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterLogsRequest.Marshal(b, m, deterministic)
}
func (m *ListClusterLogsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterLogsRequest.Merge(m, src)
}
func (m *ListClusterLogsRequest) XXX_Size() int {
	return xxx_messageInfo_ListClusterLogsRequest.Size(m)
}
func (m *ListClusterLogsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterLogsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterLogsRequest proto.InternalMessageInfo

func (m *ListClusterLogsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListClusterLogsRequest) GetColumnFilter() []string {
	if m != nil {
		return m.ColumnFilter
	}
	return nil
}

func (m *ListClusterLogsRequest) GetServiceType() ListClusterLogsRequest_ServiceType {
	if m != nil {
		return m.ServiceType
	}
	return ListClusterLogsRequest_SERVICE_TYPE_UNSPECIFIED
}

func (m *ListClusterLogsRequest) GetFromTime() *timestamp.Timestamp {
	if m != nil {
		return m.FromTime
	}
	return nil
}

func (m *ListClusterLogsRequest) GetToTime() *timestamp.Timestamp {
	if m != nil {
		return m.ToTime
	}
	return nil
}

func (m *ListClusterLogsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClusterLogsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListClusterLogsResponse struct {
	// Requested log records.
	Logs []*LogRecord `protobuf:"bytes,1,rep,name=logs,proto3" json:"logs,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListClusterLogsRequest.page_size], use the [next_page_token] as the value
	// for the [ListClusterLogsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterLogsResponse) Reset()         { *m = ListClusterLogsResponse{} }
func (m *ListClusterLogsResponse) String() string { return proto.CompactTextString(m) }
func (*ListClusterLogsResponse) ProtoMessage()    {}
func (*ListClusterLogsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{21}
}

func (m *ListClusterLogsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterLogsResponse.Unmarshal(m, b)
}
func (m *ListClusterLogsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterLogsResponse.Marshal(b, m, deterministic)
}
func (m *ListClusterLogsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterLogsResponse.Merge(m, src)
}
func (m *ListClusterLogsResponse) XXX_Size() int {
	return xxx_messageInfo_ListClusterLogsResponse.Size(m)
}
func (m *ListClusterLogsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterLogsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterLogsResponse proto.InternalMessageInfo

func (m *ListClusterLogsResponse) GetLogs() []*LogRecord {
	if m != nil {
		return m.Logs
	}
	return nil
}

func (m *ListClusterLogsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type StreamClusterLogsRequest struct {
	// Required. ID of the MongoDB cluster.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Columns from logs table to get in the response.
	ColumnFilter []string                             `protobuf:"bytes,2,rep,name=column_filter,json=columnFilter,proto3" json:"column_filter,omitempty"`
	ServiceType  StreamClusterLogsRequest_ServiceType `protobuf:"varint,3,opt,name=service_type,json=serviceType,proto3,enum=yandex.cloud.mdb.mongodb.v1.StreamClusterLogsRequest_ServiceType" json:"service_type,omitempty"`
	// Start timestamp for the logs request.
	FromTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=from_time,json=fromTime,proto3" json:"from_time,omitempty"`
	// End timestamp for the logs request.
	// If this field is not set, all existing logs will be sent and then the new ones as
	// they appear. In essence it has 'tail -f' semantics.
	ToTime               *timestamp.Timestamp `protobuf:"bytes,5,opt,name=to_time,json=toTime,proto3" json:"to_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *StreamClusterLogsRequest) Reset()         { *m = StreamClusterLogsRequest{} }
func (m *StreamClusterLogsRequest) String() string { return proto.CompactTextString(m) }
func (*StreamClusterLogsRequest) ProtoMessage()    {}
func (*StreamClusterLogsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{22}
}

func (m *StreamClusterLogsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamClusterLogsRequest.Unmarshal(m, b)
}
func (m *StreamClusterLogsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamClusterLogsRequest.Marshal(b, m, deterministic)
}
func (m *StreamClusterLogsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamClusterLogsRequest.Merge(m, src)
}
func (m *StreamClusterLogsRequest) XXX_Size() int {
	return xxx_messageInfo_StreamClusterLogsRequest.Size(m)
}
func (m *StreamClusterLogsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamClusterLogsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamClusterLogsRequest proto.InternalMessageInfo

func (m *StreamClusterLogsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *StreamClusterLogsRequest) GetColumnFilter() []string {
	if m != nil {
		return m.ColumnFilter
	}
	return nil
}

func (m *StreamClusterLogsRequest) GetServiceType() StreamClusterLogsRequest_ServiceType {
	if m != nil {
		return m.ServiceType
	}
	return StreamClusterLogsRequest_SERVICE_TYPE_UNSPECIFIED
}

func (m *StreamClusterLogsRequest) GetFromTime() *timestamp.Timestamp {
	if m != nil {
		return m.FromTime
	}
	return nil
}

func (m *StreamClusterLogsRequest) GetToTime() *timestamp.Timestamp {
	if m != nil {
		return m.ToTime
	}
	return nil
}

type ListClusterOperationsRequest struct {
	// ID of the MongoDB Cluster resource to list operations for.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	PageSize  int64  `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListClusterOperationsResponse.next_page_token] returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterOperationsRequest) Reset()         { *m = ListClusterOperationsRequest{} }
func (m *ListClusterOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListClusterOperationsRequest) ProtoMessage()    {}
func (*ListClusterOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{23}
}

func (m *ListClusterOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterOperationsRequest.Unmarshal(m, b)
}
func (m *ListClusterOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterOperationsRequest.Marshal(b, m, deterministic)
}
func (m *ListClusterOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterOperationsRequest.Merge(m, src)
}
func (m *ListClusterOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListClusterOperationsRequest.Size(m)
}
func (m *ListClusterOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterOperationsRequest proto.InternalMessageInfo

func (m *ListClusterOperationsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListClusterOperationsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClusterOperationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListClusterOperationsResponse struct {
	// List of Operation resources for the specified MongoDB cluster.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListClusterOperationsRequest.page_size], use the [next_page_token] as the value
	// for the [ListClusterOperationsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterOperationsResponse) Reset()         { *m = ListClusterOperationsResponse{} }
func (m *ListClusterOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListClusterOperationsResponse) ProtoMessage()    {}
func (*ListClusterOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{24}
}

func (m *ListClusterOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterOperationsResponse.Unmarshal(m, b)
}
func (m *ListClusterOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterOperationsResponse.Marshal(b, m, deterministic)
}
func (m *ListClusterOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterOperationsResponse.Merge(m, src)
}
func (m *ListClusterOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListClusterOperationsResponse.Size(m)
}
func (m *ListClusterOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterOperationsResponse proto.InternalMessageInfo

func (m *ListClusterOperationsResponse) GetOperations() []*operation.Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListClusterOperationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type ListClusterBackupsRequest struct {
	// ID of the MongoDB cluster.
	// To get the MongoDB cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	PageSize  int64  `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token.  To get the next page of results, set [page_token] to the
	// [ListClusterBackupsResponse.next_page_token] returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterBackupsRequest) Reset()         { *m = ListClusterBackupsRequest{} }
func (m *ListClusterBackupsRequest) String() string { return proto.CompactTextString(m) }
func (*ListClusterBackupsRequest) ProtoMessage()    {}
func (*ListClusterBackupsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{25}
}

func (m *ListClusterBackupsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterBackupsRequest.Unmarshal(m, b)
}
func (m *ListClusterBackupsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterBackupsRequest.Marshal(b, m, deterministic)
}
func (m *ListClusterBackupsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterBackupsRequest.Merge(m, src)
}
func (m *ListClusterBackupsRequest) XXX_Size() int {
	return xxx_messageInfo_ListClusterBackupsRequest.Size(m)
}
func (m *ListClusterBackupsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterBackupsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterBackupsRequest proto.InternalMessageInfo

func (m *ListClusterBackupsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListClusterBackupsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClusterBackupsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListClusterBackupsResponse struct {
	// List of MongoDB Backup resources.
	Backups []*Backup `protobuf:"bytes,1,rep,name=backups,proto3" json:"backups,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListClusterBackupsRequest.page_size], use the [next_page_token] as the value
	// for the [ListClusterBackupsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterBackupsResponse) Reset()         { *m = ListClusterBackupsResponse{} }
func (m *ListClusterBackupsResponse) String() string { return proto.CompactTextString(m) }
func (*ListClusterBackupsResponse) ProtoMessage()    {}
func (*ListClusterBackupsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{26}
}

func (m *ListClusterBackupsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterBackupsResponse.Unmarshal(m, b)
}
func (m *ListClusterBackupsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterBackupsResponse.Marshal(b, m, deterministic)
}
func (m *ListClusterBackupsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterBackupsResponse.Merge(m, src)
}
func (m *ListClusterBackupsResponse) XXX_Size() int {
	return xxx_messageInfo_ListClusterBackupsResponse.Size(m)
}
func (m *ListClusterBackupsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterBackupsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterBackupsResponse proto.InternalMessageInfo

func (m *ListClusterBackupsResponse) GetBackups() []*Backup {
	if m != nil {
		return m.Backups
	}
	return nil
}

func (m *ListClusterBackupsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type ListClusterHostsRequest struct {
	// ID of the MongoDB cluster.
	// To get the MongoDB cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	PageSize  int64  `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListClusterHostsResponse.next_page_token] returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterHostsRequest) Reset()         { *m = ListClusterHostsRequest{} }
func (m *ListClusterHostsRequest) String() string { return proto.CompactTextString(m) }
func (*ListClusterHostsRequest) ProtoMessage()    {}
func (*ListClusterHostsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{27}
}

func (m *ListClusterHostsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterHostsRequest.Unmarshal(m, b)
}
func (m *ListClusterHostsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterHostsRequest.Marshal(b, m, deterministic)
}
func (m *ListClusterHostsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterHostsRequest.Merge(m, src)
}
func (m *ListClusterHostsRequest) XXX_Size() int {
	return xxx_messageInfo_ListClusterHostsRequest.Size(m)
}
func (m *ListClusterHostsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterHostsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterHostsRequest proto.InternalMessageInfo

func (m *ListClusterHostsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListClusterHostsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClusterHostsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListClusterHostsResponse struct {
	// List of Host resources.
	Hosts []*Host `protobuf:"bytes,1,rep,name=hosts,proto3" json:"hosts,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListClusterHostsRequest.page_size], use the [next_page_token] as the value
	// for the [ListClusterHostsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterHostsResponse) Reset()         { *m = ListClusterHostsResponse{} }
func (m *ListClusterHostsResponse) String() string { return proto.CompactTextString(m) }
func (*ListClusterHostsResponse) ProtoMessage()    {}
func (*ListClusterHostsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{28}
}

func (m *ListClusterHostsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterHostsResponse.Unmarshal(m, b)
}
func (m *ListClusterHostsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterHostsResponse.Marshal(b, m, deterministic)
}
func (m *ListClusterHostsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterHostsResponse.Merge(m, src)
}
func (m *ListClusterHostsResponse) XXX_Size() int {
	return xxx_messageInfo_ListClusterHostsResponse.Size(m)
}
func (m *ListClusterHostsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterHostsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterHostsResponse proto.InternalMessageInfo

func (m *ListClusterHostsResponse) GetHosts() []*Host {
	if m != nil {
		return m.Hosts
	}
	return nil
}

func (m *ListClusterHostsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type AddClusterHostsRequest struct {
	// ID of the MongoDB cluster to add hosts to.
	// To get the MongoDB cluster ID use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Configurations for MongoDB hosts that should be added to the cluster.
	HostSpecs            []*HostSpec `protobuf:"bytes,2,rep,name=host_specs,json=hostSpecs,proto3" json:"host_specs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *AddClusterHostsRequest) Reset()         { *m = AddClusterHostsRequest{} }
func (m *AddClusterHostsRequest) String() string { return proto.CompactTextString(m) }
func (*AddClusterHostsRequest) ProtoMessage()    {}
func (*AddClusterHostsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{29}
}

func (m *AddClusterHostsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddClusterHostsRequest.Unmarshal(m, b)
}
func (m *AddClusterHostsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddClusterHostsRequest.Marshal(b, m, deterministic)
}
func (m *AddClusterHostsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddClusterHostsRequest.Merge(m, src)
}
func (m *AddClusterHostsRequest) XXX_Size() int {
	return xxx_messageInfo_AddClusterHostsRequest.Size(m)
}
func (m *AddClusterHostsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddClusterHostsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddClusterHostsRequest proto.InternalMessageInfo

func (m *AddClusterHostsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *AddClusterHostsRequest) GetHostSpecs() []*HostSpec {
	if m != nil {
		return m.HostSpecs
	}
	return nil
}

type AddClusterHostsMetadata struct {
	// ID of the MongoDB cluster to which the hosts are being added.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Names of hosts that are being added to the cluster.
	HostNames            []string `protobuf:"bytes,2,rep,name=host_names,json=hostNames,proto3" json:"host_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AddClusterHostsMetadata) Reset()         { *m = AddClusterHostsMetadata{} }
func (m *AddClusterHostsMetadata) String() string { return proto.CompactTextString(m) }
func (*AddClusterHostsMetadata) ProtoMessage()    {}
func (*AddClusterHostsMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{30}
}

func (m *AddClusterHostsMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddClusterHostsMetadata.Unmarshal(m, b)
}
func (m *AddClusterHostsMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddClusterHostsMetadata.Marshal(b, m, deterministic)
}
func (m *AddClusterHostsMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddClusterHostsMetadata.Merge(m, src)
}
func (m *AddClusterHostsMetadata) XXX_Size() int {
	return xxx_messageInfo_AddClusterHostsMetadata.Size(m)
}
func (m *AddClusterHostsMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_AddClusterHostsMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_AddClusterHostsMetadata proto.InternalMessageInfo

func (m *AddClusterHostsMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *AddClusterHostsMetadata) GetHostNames() []string {
	if m != nil {
		return m.HostNames
	}
	return nil
}

type DeleteClusterHostsRequest struct {
	// ID of the MongoDB cluster to remove hosts from.
	// To get the MongoDB cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Names of hosts to delete.
	HostNames            []string `protobuf:"bytes,2,rep,name=host_names,json=hostNames,proto3" json:"host_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClusterHostsRequest) Reset()         { *m = DeleteClusterHostsRequest{} }
func (m *DeleteClusterHostsRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteClusterHostsRequest) ProtoMessage()    {}
func (*DeleteClusterHostsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{31}
}

func (m *DeleteClusterHostsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClusterHostsRequest.Unmarshal(m, b)
}
func (m *DeleteClusterHostsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClusterHostsRequest.Marshal(b, m, deterministic)
}
func (m *DeleteClusterHostsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClusterHostsRequest.Merge(m, src)
}
func (m *DeleteClusterHostsRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteClusterHostsRequest.Size(m)
}
func (m *DeleteClusterHostsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClusterHostsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClusterHostsRequest proto.InternalMessageInfo

func (m *DeleteClusterHostsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *DeleteClusterHostsRequest) GetHostNames() []string {
	if m != nil {
		return m.HostNames
	}
	return nil
}

type DeleteClusterHostsMetadata struct {
	// ID of the MongoDB cluster to remove hosts from.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Names of hosts that are being deleted.
	HostNames            []string `protobuf:"bytes,2,rep,name=host_names,json=hostNames,proto3" json:"host_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClusterHostsMetadata) Reset()         { *m = DeleteClusterHostsMetadata{} }
func (m *DeleteClusterHostsMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteClusterHostsMetadata) ProtoMessage()    {}
func (*DeleteClusterHostsMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{32}
}

func (m *DeleteClusterHostsMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClusterHostsMetadata.Unmarshal(m, b)
}
func (m *DeleteClusterHostsMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClusterHostsMetadata.Marshal(b, m, deterministic)
}
func (m *DeleteClusterHostsMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClusterHostsMetadata.Merge(m, src)
}
func (m *DeleteClusterHostsMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteClusterHostsMetadata.Size(m)
}
func (m *DeleteClusterHostsMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClusterHostsMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClusterHostsMetadata proto.InternalMessageInfo

func (m *DeleteClusterHostsMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *DeleteClusterHostsMetadata) GetHostNames() []string {
	if m != nil {
		return m.HostNames
	}
	return nil
}

type EnableClusterShardingRequest struct {
	// ID of the MongoDB cluster to enable sharding for.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// mongocfg specification for sharding.
	Mongocfg *EnableClusterShardingRequest_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// mongos specification for sharding.
	Mongos *EnableClusterShardingRequest_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	// Configurations for mongos and mongocfg hosts.
	HostSpecs            []*HostSpec `protobuf:"bytes,4,rep,name=host_specs,json=hostSpecs,proto3" json:"host_specs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *EnableClusterShardingRequest) Reset()         { *m = EnableClusterShardingRequest{} }
func (m *EnableClusterShardingRequest) String() string { return proto.CompactTextString(m) }
func (*EnableClusterShardingRequest) ProtoMessage()    {}
func (*EnableClusterShardingRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{33}
}

func (m *EnableClusterShardingRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EnableClusterShardingRequest.Unmarshal(m, b)
}
func (m *EnableClusterShardingRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EnableClusterShardingRequest.Marshal(b, m, deterministic)
}
func (m *EnableClusterShardingRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnableClusterShardingRequest.Merge(m, src)
}
func (m *EnableClusterShardingRequest) XXX_Size() int {
	return xxx_messageInfo_EnableClusterShardingRequest.Size(m)
}
func (m *EnableClusterShardingRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_EnableClusterShardingRequest.DiscardUnknown(m)
}

var xxx_messageInfo_EnableClusterShardingRequest proto.InternalMessageInfo

func (m *EnableClusterShardingRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *EnableClusterShardingRequest) GetMongocfg() *EnableClusterShardingRequest_MongoCfg {
	if m != nil {
		return m.Mongocfg
	}
	return nil
}

func (m *EnableClusterShardingRequest) GetMongos() *EnableClusterShardingRequest_Mongos {
	if m != nil {
		return m.Mongos
	}
	return nil
}

func (m *EnableClusterShardingRequest) GetHostSpecs() []*HostSpec {
	if m != nil {
		return m.HostSpecs
	}
	return nil
}

type EnableClusterShardingRequest_MongoCfg struct {
	// Resources for mongocfg hosts.
	Resources            *Resources `protobuf:"bytes,1,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *EnableClusterShardingRequest_MongoCfg) Reset()         { *m = EnableClusterShardingRequest_MongoCfg{} }
func (m *EnableClusterShardingRequest_MongoCfg) String() string { return proto.CompactTextString(m) }
func (*EnableClusterShardingRequest_MongoCfg) ProtoMessage()    {}
func (*EnableClusterShardingRequest_MongoCfg) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{33, 0}
}

func (m *EnableClusterShardingRequest_MongoCfg) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EnableClusterShardingRequest_MongoCfg.Unmarshal(m, b)
}
func (m *EnableClusterShardingRequest_MongoCfg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EnableClusterShardingRequest_MongoCfg.Marshal(b, m, deterministic)
}
func (m *EnableClusterShardingRequest_MongoCfg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnableClusterShardingRequest_MongoCfg.Merge(m, src)
}
func (m *EnableClusterShardingRequest_MongoCfg) XXX_Size() int {
	return xxx_messageInfo_EnableClusterShardingRequest_MongoCfg.Size(m)
}
func (m *EnableClusterShardingRequest_MongoCfg) XXX_DiscardUnknown() {
	xxx_messageInfo_EnableClusterShardingRequest_MongoCfg.DiscardUnknown(m)
}

var xxx_messageInfo_EnableClusterShardingRequest_MongoCfg proto.InternalMessageInfo

func (m *EnableClusterShardingRequest_MongoCfg) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type EnableClusterShardingRequest_Mongos struct {
	// Resources for mongos hosts.
	Resources            *Resources `protobuf:"bytes,1,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *EnableClusterShardingRequest_Mongos) Reset()         { *m = EnableClusterShardingRequest_Mongos{} }
func (m *EnableClusterShardingRequest_Mongos) String() string { return proto.CompactTextString(m) }
func (*EnableClusterShardingRequest_Mongos) ProtoMessage()    {}
func (*EnableClusterShardingRequest_Mongos) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{33, 1}
}

func (m *EnableClusterShardingRequest_Mongos) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EnableClusterShardingRequest_Mongos.Unmarshal(m, b)
}
func (m *EnableClusterShardingRequest_Mongos) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EnableClusterShardingRequest_Mongos.Marshal(b, m, deterministic)
}
func (m *EnableClusterShardingRequest_Mongos) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnableClusterShardingRequest_Mongos.Merge(m, src)
}
func (m *EnableClusterShardingRequest_Mongos) XXX_Size() int {
	return xxx_messageInfo_EnableClusterShardingRequest_Mongos.Size(m)
}
func (m *EnableClusterShardingRequest_Mongos) XXX_DiscardUnknown() {
	xxx_messageInfo_EnableClusterShardingRequest_Mongos.DiscardUnknown(m)
}

var xxx_messageInfo_EnableClusterShardingRequest_Mongos proto.InternalMessageInfo

func (m *EnableClusterShardingRequest_Mongos) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type EnableClusterShardingMetadata struct {
	// ID of the MongoDB cluster that sharding is being enabled for.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EnableClusterShardingMetadata) Reset()         { *m = EnableClusterShardingMetadata{} }
func (m *EnableClusterShardingMetadata) String() string { return proto.CompactTextString(m) }
func (*EnableClusterShardingMetadata) ProtoMessage()    {}
func (*EnableClusterShardingMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{34}
}

func (m *EnableClusterShardingMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EnableClusterShardingMetadata.Unmarshal(m, b)
}
func (m *EnableClusterShardingMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EnableClusterShardingMetadata.Marshal(b, m, deterministic)
}
func (m *EnableClusterShardingMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnableClusterShardingMetadata.Merge(m, src)
}
func (m *EnableClusterShardingMetadata) XXX_Size() int {
	return xxx_messageInfo_EnableClusterShardingMetadata.Size(m)
}
func (m *EnableClusterShardingMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_EnableClusterShardingMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_EnableClusterShardingMetadata proto.InternalMessageInfo

func (m *EnableClusterShardingMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type GetClusterShardRequest struct {
	// ID of the MongoDB cluster that the shard belongs to.
	// To get the cluster ID use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the MongoDB shard to return.
	// To get the name of the shard use a [ClusterService.ListShards] request.
	ShardName            string   `protobuf:"bytes,2,opt,name=shard_name,json=shardName,proto3" json:"shard_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetClusterShardRequest) Reset()         { *m = GetClusterShardRequest{} }
func (m *GetClusterShardRequest) String() string { return proto.CompactTextString(m) }
func (*GetClusterShardRequest) ProtoMessage()    {}
func (*GetClusterShardRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{35}
}

func (m *GetClusterShardRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetClusterShardRequest.Unmarshal(m, b)
}
func (m *GetClusterShardRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetClusterShardRequest.Marshal(b, m, deterministic)
}
func (m *GetClusterShardRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetClusterShardRequest.Merge(m, src)
}
func (m *GetClusterShardRequest) XXX_Size() int {
	return xxx_messageInfo_GetClusterShardRequest.Size(m)
}
func (m *GetClusterShardRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetClusterShardRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetClusterShardRequest proto.InternalMessageInfo

func (m *GetClusterShardRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *GetClusterShardRequest) GetShardName() string {
	if m != nil {
		return m.ShardName
	}
	return ""
}

type ListClusterShardsRequest struct {
	// ID of the MongoDB cluster to list databases in.
	// To get the cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListClusterShardsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListClusterShardsResponse.next_page_token] returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterShardsRequest) Reset()         { *m = ListClusterShardsRequest{} }
func (m *ListClusterShardsRequest) String() string { return proto.CompactTextString(m) }
func (*ListClusterShardsRequest) ProtoMessage()    {}
func (*ListClusterShardsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{36}
}

func (m *ListClusterShardsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterShardsRequest.Unmarshal(m, b)
}
func (m *ListClusterShardsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterShardsRequest.Marshal(b, m, deterministic)
}
func (m *ListClusterShardsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterShardsRequest.Merge(m, src)
}
func (m *ListClusterShardsRequest) XXX_Size() int {
	return xxx_messageInfo_ListClusterShardsRequest.Size(m)
}
func (m *ListClusterShardsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterShardsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterShardsRequest proto.InternalMessageInfo

func (m *ListClusterShardsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListClusterShardsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClusterShardsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListClusterShardsResponse struct {
	// List of MongoDB shards.
	Shards []*Shard `protobuf:"bytes,1,rep,name=shards,proto3" json:"shards,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListClusterShardsRequest.page_size], use the [next_page_token] as the value
	// for the [ListClusterShardsRequest.page_token] parameter in the next list request. Each subsequent
	// list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterShardsResponse) Reset()         { *m = ListClusterShardsResponse{} }
func (m *ListClusterShardsResponse) String() string { return proto.CompactTextString(m) }
func (*ListClusterShardsResponse) ProtoMessage()    {}
func (*ListClusterShardsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{37}
}

func (m *ListClusterShardsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterShardsResponse.Unmarshal(m, b)
}
func (m *ListClusterShardsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterShardsResponse.Marshal(b, m, deterministic)
}
func (m *ListClusterShardsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterShardsResponse.Merge(m, src)
}
func (m *ListClusterShardsResponse) XXX_Size() int {
	return xxx_messageInfo_ListClusterShardsResponse.Size(m)
}
func (m *ListClusterShardsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterShardsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterShardsResponse proto.InternalMessageInfo

func (m *ListClusterShardsResponse) GetShards() []*Shard {
	if m != nil {
		return m.Shards
	}
	return nil
}

func (m *ListClusterShardsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type AddClusterShardRequest struct {
	// ID of the MongoDB cluster to add a shard to.
	// To get the cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the MongoDB shard to create.
	ShardName string `protobuf:"bytes,2,opt,name=shard_name,json=shardName,proto3" json:"shard_name,omitempty"`
	// Configurations for mongod hosts to be created with the shard.
	HostSpecs            []*HostSpec `protobuf:"bytes,3,rep,name=host_specs,json=hostSpecs,proto3" json:"host_specs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *AddClusterShardRequest) Reset()         { *m = AddClusterShardRequest{} }
func (m *AddClusterShardRequest) String() string { return proto.CompactTextString(m) }
func (*AddClusterShardRequest) ProtoMessage()    {}
func (*AddClusterShardRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{38}
}

func (m *AddClusterShardRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddClusterShardRequest.Unmarshal(m, b)
}
func (m *AddClusterShardRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddClusterShardRequest.Marshal(b, m, deterministic)
}
func (m *AddClusterShardRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddClusterShardRequest.Merge(m, src)
}
func (m *AddClusterShardRequest) XXX_Size() int {
	return xxx_messageInfo_AddClusterShardRequest.Size(m)
}
func (m *AddClusterShardRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddClusterShardRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddClusterShardRequest proto.InternalMessageInfo

func (m *AddClusterShardRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *AddClusterShardRequest) GetShardName() string {
	if m != nil {
		return m.ShardName
	}
	return ""
}

func (m *AddClusterShardRequest) GetHostSpecs() []*HostSpec {
	if m != nil {
		return m.HostSpecs
	}
	return nil
}

type AddClusterShardMetadata struct {
	// ID of the MongoDB cluster that a shard is being added to.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the shard being added.
	ShardName            string   `protobuf:"bytes,2,opt,name=shard_name,json=shardName,proto3" json:"shard_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AddClusterShardMetadata) Reset()         { *m = AddClusterShardMetadata{} }
func (m *AddClusterShardMetadata) String() string { return proto.CompactTextString(m) }
func (*AddClusterShardMetadata) ProtoMessage()    {}
func (*AddClusterShardMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{39}
}

func (m *AddClusterShardMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddClusterShardMetadata.Unmarshal(m, b)
}
func (m *AddClusterShardMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddClusterShardMetadata.Marshal(b, m, deterministic)
}
func (m *AddClusterShardMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddClusterShardMetadata.Merge(m, src)
}
func (m *AddClusterShardMetadata) XXX_Size() int {
	return xxx_messageInfo_AddClusterShardMetadata.Size(m)
}
func (m *AddClusterShardMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_AddClusterShardMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_AddClusterShardMetadata proto.InternalMessageInfo

func (m *AddClusterShardMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *AddClusterShardMetadata) GetShardName() string {
	if m != nil {
		return m.ShardName
	}
	return ""
}

type DeleteClusterShardRequest struct {
	// ID of the MongoDB cluster to delete a shard in.
	// To get the cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the MongoDB shard to delete.
	// To get the name of the shard use a [ClusterService.ListShards] request.
	ShardName            string   `protobuf:"bytes,2,opt,name=shard_name,json=shardName,proto3" json:"shard_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClusterShardRequest) Reset()         { *m = DeleteClusterShardRequest{} }
func (m *DeleteClusterShardRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteClusterShardRequest) ProtoMessage()    {}
func (*DeleteClusterShardRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{40}
}

func (m *DeleteClusterShardRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClusterShardRequest.Unmarshal(m, b)
}
func (m *DeleteClusterShardRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClusterShardRequest.Marshal(b, m, deterministic)
}
func (m *DeleteClusterShardRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClusterShardRequest.Merge(m, src)
}
func (m *DeleteClusterShardRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteClusterShardRequest.Size(m)
}
func (m *DeleteClusterShardRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClusterShardRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClusterShardRequest proto.InternalMessageInfo

func (m *DeleteClusterShardRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *DeleteClusterShardRequest) GetShardName() string {
	if m != nil {
		return m.ShardName
	}
	return ""
}

type DeleteClusterShardMetadata struct {
	// ID of the MongoDB cluster that a shard is being deleted in.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the shard being deleted.
	ShardName            string   `protobuf:"bytes,2,opt,name=shard_name,json=shardName,proto3" json:"shard_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClusterShardMetadata) Reset()         { *m = DeleteClusterShardMetadata{} }
func (m *DeleteClusterShardMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteClusterShardMetadata) ProtoMessage()    {}
func (*DeleteClusterShardMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{41}
}

func (m *DeleteClusterShardMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClusterShardMetadata.Unmarshal(m, b)
}
func (m *DeleteClusterShardMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClusterShardMetadata.Marshal(b, m, deterministic)
}
func (m *DeleteClusterShardMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClusterShardMetadata.Merge(m, src)
}
func (m *DeleteClusterShardMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteClusterShardMetadata.Size(m)
}
func (m *DeleteClusterShardMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClusterShardMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClusterShardMetadata proto.InternalMessageInfo

func (m *DeleteClusterShardMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *DeleteClusterShardMetadata) GetShardName() string {
	if m != nil {
		return m.ShardName
	}
	return ""
}

type ResetupHostsRequest struct {
	// Required. ID of the MongoDB cluster.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. Name of the hosts to resetup.
	HostNames            []string `protobuf:"bytes,2,rep,name=host_names,json=hostNames,proto3" json:"host_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResetupHostsRequest) Reset()         { *m = ResetupHostsRequest{} }
func (m *ResetupHostsRequest) String() string { return proto.CompactTextString(m) }
func (*ResetupHostsRequest) ProtoMessage()    {}
func (*ResetupHostsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{42}
}

func (m *ResetupHostsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResetupHostsRequest.Unmarshal(m, b)
}
func (m *ResetupHostsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResetupHostsRequest.Marshal(b, m, deterministic)
}
func (m *ResetupHostsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResetupHostsRequest.Merge(m, src)
}
func (m *ResetupHostsRequest) XXX_Size() int {
	return xxx_messageInfo_ResetupHostsRequest.Size(m)
}
func (m *ResetupHostsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ResetupHostsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ResetupHostsRequest proto.InternalMessageInfo

func (m *ResetupHostsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ResetupHostsRequest) GetHostNames() []string {
	if m != nil {
		return m.HostNames
	}
	return nil
}

type ResetupHostsMetadata struct {
	// Required. ID of the MongoDB cluster.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The name of hosts to resetup.
	HostNames            []string `protobuf:"bytes,2,rep,name=host_names,json=hostNames,proto3" json:"host_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResetupHostsMetadata) Reset()         { *m = ResetupHostsMetadata{} }
func (m *ResetupHostsMetadata) String() string { return proto.CompactTextString(m) }
func (*ResetupHostsMetadata) ProtoMessage()    {}
func (*ResetupHostsMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{43}
}

func (m *ResetupHostsMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResetupHostsMetadata.Unmarshal(m, b)
}
func (m *ResetupHostsMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResetupHostsMetadata.Marshal(b, m, deterministic)
}
func (m *ResetupHostsMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResetupHostsMetadata.Merge(m, src)
}
func (m *ResetupHostsMetadata) XXX_Size() int {
	return xxx_messageInfo_ResetupHostsMetadata.Size(m)
}
func (m *ResetupHostsMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ResetupHostsMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ResetupHostsMetadata proto.InternalMessageInfo

func (m *ResetupHostsMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ResetupHostsMetadata) GetHostNames() []string {
	if m != nil {
		return m.HostNames
	}
	return nil
}

type RestartHostsRequest struct {
	// Required. ID of the MongoDB cluster.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. Name of the hosts to restart.
	HostNames            []string `protobuf:"bytes,2,rep,name=host_names,json=hostNames,proto3" json:"host_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RestartHostsRequest) Reset()         { *m = RestartHostsRequest{} }
func (m *RestartHostsRequest) String() string { return proto.CompactTextString(m) }
func (*RestartHostsRequest) ProtoMessage()    {}
func (*RestartHostsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{44}
}

func (m *RestartHostsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RestartHostsRequest.Unmarshal(m, b)
}
func (m *RestartHostsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RestartHostsRequest.Marshal(b, m, deterministic)
}
func (m *RestartHostsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RestartHostsRequest.Merge(m, src)
}
func (m *RestartHostsRequest) XXX_Size() int {
	return xxx_messageInfo_RestartHostsRequest.Size(m)
}
func (m *RestartHostsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RestartHostsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RestartHostsRequest proto.InternalMessageInfo

func (m *RestartHostsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *RestartHostsRequest) GetHostNames() []string {
	if m != nil {
		return m.HostNames
	}
	return nil
}

type RestartHostsMetadata struct {
	// Required. ID of the MongoDB cluster.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The name of hosts to restart.
	HostNames            []string `protobuf:"bytes,2,rep,name=host_names,json=hostNames,proto3" json:"host_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RestartHostsMetadata) Reset()         { *m = RestartHostsMetadata{} }
func (m *RestartHostsMetadata) String() string { return proto.CompactTextString(m) }
func (*RestartHostsMetadata) ProtoMessage()    {}
func (*RestartHostsMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{45}
}

func (m *RestartHostsMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RestartHostsMetadata.Unmarshal(m, b)
}
func (m *RestartHostsMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RestartHostsMetadata.Marshal(b, m, deterministic)
}
func (m *RestartHostsMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RestartHostsMetadata.Merge(m, src)
}
func (m *RestartHostsMetadata) XXX_Size() int {
	return xxx_messageInfo_RestartHostsMetadata.Size(m)
}
func (m *RestartHostsMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_RestartHostsMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_RestartHostsMetadata proto.InternalMessageInfo

func (m *RestartHostsMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *RestartHostsMetadata) GetHostNames() []string {
	if m != nil {
		return m.HostNames
	}
	return nil
}

type HostSpec struct {
	// ID of the availability zone where the host resides.
	// To get a list of available zones, use the [yandex.cloud.compute.v1.ZoneService.List] request.
	ZoneId string `protobuf:"bytes,1,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// ID of the subnet that the host should belong to. This subnet should be a part
	// of the network that the cluster belongs to.
	// The network ID is set in the [Cluster.network_id] field.
	SubnetId string `protobuf:"bytes,2,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Whether the host should get a public IP address on creation.
	//
	// After a host has been created, this setting cannot be changed. To remove an assigned public IP, or to assign
	// a public IP to a host without one, recreate the host with [assign_public_ip] set as needed.
	//
	// Possible values:
	// * false — don't assign a public IP to the host.
	// * true — the host should have a public IP address.
	AssignPublicIp bool `protobuf:"varint,3,opt,name=assign_public_ip,json=assignPublicIp,proto3" json:"assign_public_ip,omitempty"`
	// Type of the host to be deployed.
	Type Host_Type `protobuf:"varint,4,opt,name=type,proto3,enum=yandex.cloud.mdb.mongodb.v1.Host_Type" json:"type,omitempty"`
	// Name of the shard that the host belongs to.
	ShardName            string   `protobuf:"bytes,5,opt,name=shard_name,json=shardName,proto3" json:"shard_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HostSpec) Reset()         { *m = HostSpec{} }
func (m *HostSpec) String() string { return proto.CompactTextString(m) }
func (*HostSpec) ProtoMessage()    {}
func (*HostSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{46}
}

func (m *HostSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HostSpec.Unmarshal(m, b)
}
func (m *HostSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HostSpec.Marshal(b, m, deterministic)
}
func (m *HostSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HostSpec.Merge(m, src)
}
func (m *HostSpec) XXX_Size() int {
	return xxx_messageInfo_HostSpec.Size(m)
}
func (m *HostSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_HostSpec.DiscardUnknown(m)
}

var xxx_messageInfo_HostSpec proto.InternalMessageInfo

func (m *HostSpec) GetZoneId() string {
	if m != nil {
		return m.ZoneId
	}
	return ""
}

func (m *HostSpec) GetSubnetId() string {
	if m != nil {
		return m.SubnetId
	}
	return ""
}

func (m *HostSpec) GetAssignPublicIp() bool {
	if m != nil {
		return m.AssignPublicIp
	}
	return false
}

func (m *HostSpec) GetType() Host_Type {
	if m != nil {
		return m.Type
	}
	return Host_TYPE_UNSPECIFIED
}

func (m *HostSpec) GetShardName() string {
	if m != nil {
		return m.ShardName
	}
	return ""
}

type MongodbSpec3_6 struct {
	// Configuration and resource allocation for mongod 3.6 hosts.
	Mongod *MongodbSpec3_6_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg 3.6 hosts.
	Mongocfg *MongodbSpec3_6_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos 3.6 hosts.
	Mongos               *MongodbSpec3_6_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *MongodbSpec3_6) Reset()         { *m = MongodbSpec3_6{} }
func (m *MongodbSpec3_6) String() string { return proto.CompactTextString(m) }
func (*MongodbSpec3_6) ProtoMessage()    {}
func (*MongodbSpec3_6) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{47}
}

func (m *MongodbSpec3_6) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MongodbSpec3_6.Unmarshal(m, b)
}
func (m *MongodbSpec3_6) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MongodbSpec3_6.Marshal(b, m, deterministic)
}
func (m *MongodbSpec3_6) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MongodbSpec3_6.Merge(m, src)
}
func (m *MongodbSpec3_6) XXX_Size() int {
	return xxx_messageInfo_MongodbSpec3_6.Size(m)
}
func (m *MongodbSpec3_6) XXX_DiscardUnknown() {
	xxx_messageInfo_MongodbSpec3_6.DiscardUnknown(m)
}

var xxx_messageInfo_MongodbSpec3_6 proto.InternalMessageInfo

func (m *MongodbSpec3_6) GetMongod() *MongodbSpec3_6_Mongod {
	if m != nil {
		return m.Mongod
	}
	return nil
}

func (m *MongodbSpec3_6) GetMongocfg() *MongodbSpec3_6_MongoCfg {
	if m != nil {
		return m.Mongocfg
	}
	return nil
}

func (m *MongodbSpec3_6) GetMongos() *MongodbSpec3_6_Mongos {
	if m != nil {
		return m.Mongos
	}
	return nil
}

type MongodbSpec3_6_Mongod struct {
	// Configuration for mongod 3.6 hosts.
	Config *config.MongodConfig3_6 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to each mongod host.
	Resources            *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *MongodbSpec3_6_Mongod) Reset()         { *m = MongodbSpec3_6_Mongod{} }
func (m *MongodbSpec3_6_Mongod) String() string { return proto.CompactTextString(m) }
func (*MongodbSpec3_6_Mongod) ProtoMessage()    {}
func (*MongodbSpec3_6_Mongod) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{47, 0}
}

func (m *MongodbSpec3_6_Mongod) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MongodbSpec3_6_Mongod.Unmarshal(m, b)
}
func (m *MongodbSpec3_6_Mongod) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MongodbSpec3_6_Mongod.Marshal(b, m, deterministic)
}
func (m *MongodbSpec3_6_Mongod) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MongodbSpec3_6_Mongod.Merge(m, src)
}
func (m *MongodbSpec3_6_Mongod) XXX_Size() int {
	return xxx_messageInfo_MongodbSpec3_6_Mongod.Size(m)
}
func (m *MongodbSpec3_6_Mongod) XXX_DiscardUnknown() {
	xxx_messageInfo_MongodbSpec3_6_Mongod.DiscardUnknown(m)
}

var xxx_messageInfo_MongodbSpec3_6_Mongod proto.InternalMessageInfo

func (m *MongodbSpec3_6_Mongod) GetConfig() *config.MongodConfig3_6 {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *MongodbSpec3_6_Mongod) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type MongodbSpec3_6_MongoCfg struct {
	// Configuration for mongocfg 3.6 hosts.
	Config *config.MongoCfgConfig3_6 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to each mongocfg host.
	Resources            *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *MongodbSpec3_6_MongoCfg) Reset()         { *m = MongodbSpec3_6_MongoCfg{} }
func (m *MongodbSpec3_6_MongoCfg) String() string { return proto.CompactTextString(m) }
func (*MongodbSpec3_6_MongoCfg) ProtoMessage()    {}
func (*MongodbSpec3_6_MongoCfg) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{47, 1}
}

func (m *MongodbSpec3_6_MongoCfg) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MongodbSpec3_6_MongoCfg.Unmarshal(m, b)
}
func (m *MongodbSpec3_6_MongoCfg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MongodbSpec3_6_MongoCfg.Marshal(b, m, deterministic)
}
func (m *MongodbSpec3_6_MongoCfg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MongodbSpec3_6_MongoCfg.Merge(m, src)
}
func (m *MongodbSpec3_6_MongoCfg) XXX_Size() int {
	return xxx_messageInfo_MongodbSpec3_6_MongoCfg.Size(m)
}
func (m *MongodbSpec3_6_MongoCfg) XXX_DiscardUnknown() {
	xxx_messageInfo_MongodbSpec3_6_MongoCfg.DiscardUnknown(m)
}

var xxx_messageInfo_MongodbSpec3_6_MongoCfg proto.InternalMessageInfo

func (m *MongodbSpec3_6_MongoCfg) GetConfig() *config.MongoCfgConfig3_6 {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *MongodbSpec3_6_MongoCfg) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type MongodbSpec3_6_Mongos struct {
	// Configuration for mongos 3.6 hosts.
	Config *config.MongosConfig3_6 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to each mongos host.
	Resources            *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *MongodbSpec3_6_Mongos) Reset()         { *m = MongodbSpec3_6_Mongos{} }
func (m *MongodbSpec3_6_Mongos) String() string { return proto.CompactTextString(m) }
func (*MongodbSpec3_6_Mongos) ProtoMessage()    {}
func (*MongodbSpec3_6_Mongos) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{47, 2}
}

func (m *MongodbSpec3_6_Mongos) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MongodbSpec3_6_Mongos.Unmarshal(m, b)
}
func (m *MongodbSpec3_6_Mongos) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MongodbSpec3_6_Mongos.Marshal(b, m, deterministic)
}
func (m *MongodbSpec3_6_Mongos) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MongodbSpec3_6_Mongos.Merge(m, src)
}
func (m *MongodbSpec3_6_Mongos) XXX_Size() int {
	return xxx_messageInfo_MongodbSpec3_6_Mongos.Size(m)
}
func (m *MongodbSpec3_6_Mongos) XXX_DiscardUnknown() {
	xxx_messageInfo_MongodbSpec3_6_Mongos.DiscardUnknown(m)
}

var xxx_messageInfo_MongodbSpec3_6_Mongos proto.InternalMessageInfo

func (m *MongodbSpec3_6_Mongos) GetConfig() *config.MongosConfig3_6 {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *MongodbSpec3_6_Mongos) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type MongodbSpec4_0 struct {
	// Configuration and resource allocation for mongod 4.0 hosts.
	Mongod *MongodbSpec4_0_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg 4.0 hosts.
	Mongocfg *MongodbSpec4_0_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos 4.0 hosts.
	Mongos               *MongodbSpec4_0_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *MongodbSpec4_0) Reset()         { *m = MongodbSpec4_0{} }
func (m *MongodbSpec4_0) String() string { return proto.CompactTextString(m) }
func (*MongodbSpec4_0) ProtoMessage()    {}
func (*MongodbSpec4_0) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{48}
}

func (m *MongodbSpec4_0) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MongodbSpec4_0.Unmarshal(m, b)
}
func (m *MongodbSpec4_0) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MongodbSpec4_0.Marshal(b, m, deterministic)
}
func (m *MongodbSpec4_0) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MongodbSpec4_0.Merge(m, src)
}
func (m *MongodbSpec4_0) XXX_Size() int {
	return xxx_messageInfo_MongodbSpec4_0.Size(m)
}
func (m *MongodbSpec4_0) XXX_DiscardUnknown() {
	xxx_messageInfo_MongodbSpec4_0.DiscardUnknown(m)
}

var xxx_messageInfo_MongodbSpec4_0 proto.InternalMessageInfo

func (m *MongodbSpec4_0) GetMongod() *MongodbSpec4_0_Mongod {
	if m != nil {
		return m.Mongod
	}
	return nil
}

func (m *MongodbSpec4_0) GetMongocfg() *MongodbSpec4_0_MongoCfg {
	if m != nil {
		return m.Mongocfg
	}
	return nil
}

func (m *MongodbSpec4_0) GetMongos() *MongodbSpec4_0_Mongos {
	if m != nil {
		return m.Mongos
	}
	return nil
}

type MongodbSpec4_0_Mongod struct {
	// Configuration for mongod 4.0 hosts.
	Config *config.MongodConfig4_0 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to each mongod host.
	Resources            *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *MongodbSpec4_0_Mongod) Reset()         { *m = MongodbSpec4_0_Mongod{} }
func (m *MongodbSpec4_0_Mongod) String() string { return proto.CompactTextString(m) }
func (*MongodbSpec4_0_Mongod) ProtoMessage()    {}
func (*MongodbSpec4_0_Mongod) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{48, 0}
}

func (m *MongodbSpec4_0_Mongod) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MongodbSpec4_0_Mongod.Unmarshal(m, b)
}
func (m *MongodbSpec4_0_Mongod) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MongodbSpec4_0_Mongod.Marshal(b, m, deterministic)
}
func (m *MongodbSpec4_0_Mongod) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MongodbSpec4_0_Mongod.Merge(m, src)
}
func (m *MongodbSpec4_0_Mongod) XXX_Size() int {
	return xxx_messageInfo_MongodbSpec4_0_Mongod.Size(m)
}
func (m *MongodbSpec4_0_Mongod) XXX_DiscardUnknown() {
	xxx_messageInfo_MongodbSpec4_0_Mongod.DiscardUnknown(m)
}

var xxx_messageInfo_MongodbSpec4_0_Mongod proto.InternalMessageInfo

func (m *MongodbSpec4_0_Mongod) GetConfig() *config.MongodConfig4_0 {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *MongodbSpec4_0_Mongod) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type MongodbSpec4_0_MongoCfg struct {
	// Configuration for mongocfg 4.0 hosts.
	Config *config.MongoCfgConfig4_0 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to each mongocfg host.
	Resources            *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *MongodbSpec4_0_MongoCfg) Reset()         { *m = MongodbSpec4_0_MongoCfg{} }
func (m *MongodbSpec4_0_MongoCfg) String() string { return proto.CompactTextString(m) }
func (*MongodbSpec4_0_MongoCfg) ProtoMessage()    {}
func (*MongodbSpec4_0_MongoCfg) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{48, 1}
}

func (m *MongodbSpec4_0_MongoCfg) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MongodbSpec4_0_MongoCfg.Unmarshal(m, b)
}
func (m *MongodbSpec4_0_MongoCfg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MongodbSpec4_0_MongoCfg.Marshal(b, m, deterministic)
}
func (m *MongodbSpec4_0_MongoCfg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MongodbSpec4_0_MongoCfg.Merge(m, src)
}
func (m *MongodbSpec4_0_MongoCfg) XXX_Size() int {
	return xxx_messageInfo_MongodbSpec4_0_MongoCfg.Size(m)
}
func (m *MongodbSpec4_0_MongoCfg) XXX_DiscardUnknown() {
	xxx_messageInfo_MongodbSpec4_0_MongoCfg.DiscardUnknown(m)
}

var xxx_messageInfo_MongodbSpec4_0_MongoCfg proto.InternalMessageInfo

func (m *MongodbSpec4_0_MongoCfg) GetConfig() *config.MongoCfgConfig4_0 {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *MongodbSpec4_0_MongoCfg) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type MongodbSpec4_0_Mongos struct {
	// Configuration for mongos 4.0 hosts.
	Config *config.MongosConfig4_0 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to each mongos host.
	Resources            *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *MongodbSpec4_0_Mongos) Reset()         { *m = MongodbSpec4_0_Mongos{} }
func (m *MongodbSpec4_0_Mongos) String() string { return proto.CompactTextString(m) }
func (*MongodbSpec4_0_Mongos) ProtoMessage()    {}
func (*MongodbSpec4_0_Mongos) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{48, 2}
}

func (m *MongodbSpec4_0_Mongos) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MongodbSpec4_0_Mongos.Unmarshal(m, b)
}
func (m *MongodbSpec4_0_Mongos) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MongodbSpec4_0_Mongos.Marshal(b, m, deterministic)
}
func (m *MongodbSpec4_0_Mongos) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MongodbSpec4_0_Mongos.Merge(m, src)
}
func (m *MongodbSpec4_0_Mongos) XXX_Size() int {
	return xxx_messageInfo_MongodbSpec4_0_Mongos.Size(m)
}
func (m *MongodbSpec4_0_Mongos) XXX_DiscardUnknown() {
	xxx_messageInfo_MongodbSpec4_0_Mongos.DiscardUnknown(m)
}

var xxx_messageInfo_MongodbSpec4_0_Mongos proto.InternalMessageInfo

func (m *MongodbSpec4_0_Mongos) GetConfig() *config.MongosConfig4_0 {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *MongodbSpec4_0_Mongos) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type MongodbSpec4_2 struct {
	// Configuration and resource allocation for mongod 4.2 hosts.
	Mongod *MongodbSpec4_2_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg 4.2 hosts.
	Mongocfg *MongodbSpec4_2_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos 4.2 hosts.
	Mongos               *MongodbSpec4_2_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *MongodbSpec4_2) Reset()         { *m = MongodbSpec4_2{} }
func (m *MongodbSpec4_2) String() string { return proto.CompactTextString(m) }
func (*MongodbSpec4_2) ProtoMessage()    {}
func (*MongodbSpec4_2) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{49}
}

func (m *MongodbSpec4_2) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MongodbSpec4_2.Unmarshal(m, b)
}
func (m *MongodbSpec4_2) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MongodbSpec4_2.Marshal(b, m, deterministic)
}
func (m *MongodbSpec4_2) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MongodbSpec4_2.Merge(m, src)
}
func (m *MongodbSpec4_2) XXX_Size() int {
	return xxx_messageInfo_MongodbSpec4_2.Size(m)
}
func (m *MongodbSpec4_2) XXX_DiscardUnknown() {
	xxx_messageInfo_MongodbSpec4_2.DiscardUnknown(m)
}

var xxx_messageInfo_MongodbSpec4_2 proto.InternalMessageInfo

func (m *MongodbSpec4_2) GetMongod() *MongodbSpec4_2_Mongod {
	if m != nil {
		return m.Mongod
	}
	return nil
}

func (m *MongodbSpec4_2) GetMongocfg() *MongodbSpec4_2_MongoCfg {
	if m != nil {
		return m.Mongocfg
	}
	return nil
}

func (m *MongodbSpec4_2) GetMongos() *MongodbSpec4_2_Mongos {
	if m != nil {
		return m.Mongos
	}
	return nil
}

type MongodbSpec4_2_Mongod struct {
	// Configuration for mongod 4.2 hosts.
	Config *config.MongodConfig4_2 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to each mongod host.
	Resources            *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *MongodbSpec4_2_Mongod) Reset()         { *m = MongodbSpec4_2_Mongod{} }
func (m *MongodbSpec4_2_Mongod) String() string { return proto.CompactTextString(m) }
func (*MongodbSpec4_2_Mongod) ProtoMessage()    {}
func (*MongodbSpec4_2_Mongod) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{49, 0}
}

func (m *MongodbSpec4_2_Mongod) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MongodbSpec4_2_Mongod.Unmarshal(m, b)
}
func (m *MongodbSpec4_2_Mongod) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MongodbSpec4_2_Mongod.Marshal(b, m, deterministic)
}
func (m *MongodbSpec4_2_Mongod) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MongodbSpec4_2_Mongod.Merge(m, src)
}
func (m *MongodbSpec4_2_Mongod) XXX_Size() int {
	return xxx_messageInfo_MongodbSpec4_2_Mongod.Size(m)
}
func (m *MongodbSpec4_2_Mongod) XXX_DiscardUnknown() {
	xxx_messageInfo_MongodbSpec4_2_Mongod.DiscardUnknown(m)
}

var xxx_messageInfo_MongodbSpec4_2_Mongod proto.InternalMessageInfo

func (m *MongodbSpec4_2_Mongod) GetConfig() *config.MongodConfig4_2 {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *MongodbSpec4_2_Mongod) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type MongodbSpec4_2_MongoCfg struct {
	// Configuration for mongocfg 4.2 hosts.
	Config *config.MongoCfgConfig4_2 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to each mongocfg host.
	Resources            *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *MongodbSpec4_2_MongoCfg) Reset()         { *m = MongodbSpec4_2_MongoCfg{} }
func (m *MongodbSpec4_2_MongoCfg) String() string { return proto.CompactTextString(m) }
func (*MongodbSpec4_2_MongoCfg) ProtoMessage()    {}
func (*MongodbSpec4_2_MongoCfg) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{49, 1}
}

func (m *MongodbSpec4_2_MongoCfg) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MongodbSpec4_2_MongoCfg.Unmarshal(m, b)
}
func (m *MongodbSpec4_2_MongoCfg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MongodbSpec4_2_MongoCfg.Marshal(b, m, deterministic)
}
func (m *MongodbSpec4_2_MongoCfg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MongodbSpec4_2_MongoCfg.Merge(m, src)
}
func (m *MongodbSpec4_2_MongoCfg) XXX_Size() int {
	return xxx_messageInfo_MongodbSpec4_2_MongoCfg.Size(m)
}
func (m *MongodbSpec4_2_MongoCfg) XXX_DiscardUnknown() {
	xxx_messageInfo_MongodbSpec4_2_MongoCfg.DiscardUnknown(m)
}

var xxx_messageInfo_MongodbSpec4_2_MongoCfg proto.InternalMessageInfo

func (m *MongodbSpec4_2_MongoCfg) GetConfig() *config.MongoCfgConfig4_2 {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *MongodbSpec4_2_MongoCfg) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type MongodbSpec4_2_Mongos struct {
	// Configuration for mongos 4.2 hosts.
	Config *config.MongosConfig4_2 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to each mongos host.
	Resources            *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *MongodbSpec4_2_Mongos) Reset()         { *m = MongodbSpec4_2_Mongos{} }
func (m *MongodbSpec4_2_Mongos) String() string { return proto.CompactTextString(m) }
func (*MongodbSpec4_2_Mongos) ProtoMessage()    {}
func (*MongodbSpec4_2_Mongos) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{49, 2}
}

func (m *MongodbSpec4_2_Mongos) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MongodbSpec4_2_Mongos.Unmarshal(m, b)
}
func (m *MongodbSpec4_2_Mongos) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MongodbSpec4_2_Mongos.Marshal(b, m, deterministic)
}
func (m *MongodbSpec4_2_Mongos) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MongodbSpec4_2_Mongos.Merge(m, src)
}
func (m *MongodbSpec4_2_Mongos) XXX_Size() int {
	return xxx_messageInfo_MongodbSpec4_2_Mongos.Size(m)
}
func (m *MongodbSpec4_2_Mongos) XXX_DiscardUnknown() {
	xxx_messageInfo_MongodbSpec4_2_Mongos.DiscardUnknown(m)
}

var xxx_messageInfo_MongodbSpec4_2_Mongos proto.InternalMessageInfo

func (m *MongodbSpec4_2_Mongos) GetConfig() *config.MongosConfig4_2 {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *MongodbSpec4_2_Mongos) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type ConfigSpec struct {
	// Version of MongoDB used in the cluster. Possible values: `3.6`, `4.0`, `4.2`.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// MongoDB feature compatibility version. See usage details in [MongoDB documentation](https://docs.mongodb.com/manual/reference/command/setFeatureCompatibilityVersion/).
	//
	// Possible values:
	// * `3.6` — persist data compatibility for version 3.6. After setting this option the data will not be compatible with 3.4 or older.
	// * `4.0` — persist data compatibility for version 4.0. After setting this option the data will not be compatible with 3.6 or older.
	// * `4.2` — persist data compatibility for version 4.2. After setting this option the data will not be compatible with 4.0 or older.
	FeatureCompatibilityVersion string `protobuf:"bytes,5,opt,name=feature_compatibility_version,json=featureCompatibilityVersion,proto3" json:"feature_compatibility_version,omitempty"`
	// Types that are valid to be assigned to MongodbSpec:
	//	*ConfigSpec_MongodbSpec_3_6
	//	*ConfigSpec_MongodbSpec_4_0
	//	*ConfigSpec_MongodbSpec_4_2
	MongodbSpec isConfigSpec_MongodbSpec `protobuf_oneof:"mongodb_spec"`
	// Time to start the daily backup, in the UTC timezone.
	BackupWindowStart *timeofday.TimeOfDay `protobuf:"bytes,3,opt,name=backup_window_start,json=backupWindowStart,proto3" json:"backup_window_start,omitempty"`
	// Access policy to DB
	Access               *Access  `protobuf:"bytes,6,opt,name=access,proto3" json:"access,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ConfigSpec) Reset()         { *m = ConfigSpec{} }
func (m *ConfigSpec) String() string { return proto.CompactTextString(m) }
func (*ConfigSpec) ProtoMessage()    {}
func (*ConfigSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_fdf7200f72aab6ae, []int{50}
}

func (m *ConfigSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConfigSpec.Unmarshal(m, b)
}
func (m *ConfigSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConfigSpec.Marshal(b, m, deterministic)
}
func (m *ConfigSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigSpec.Merge(m, src)
}
func (m *ConfigSpec) XXX_Size() int {
	return xxx_messageInfo_ConfigSpec.Size(m)
}
func (m *ConfigSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigSpec proto.InternalMessageInfo

func (m *ConfigSpec) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *ConfigSpec) GetFeatureCompatibilityVersion() string {
	if m != nil {
		return m.FeatureCompatibilityVersion
	}
	return ""
}

type isConfigSpec_MongodbSpec interface {
	isConfigSpec_MongodbSpec()
}

type ConfigSpec_MongodbSpec_3_6 struct {
	MongodbSpec_3_6 *MongodbSpec3_6 `protobuf:"bytes,2,opt,name=mongodb_spec_3_6,json=mongodbSpec_3_6,proto3,oneof"`
}

type ConfigSpec_MongodbSpec_4_0 struct {
	MongodbSpec_4_0 *MongodbSpec4_0 `protobuf:"bytes,4,opt,name=mongodb_spec_4_0,json=mongodbSpec_4_0,proto3,oneof"`
}

type ConfigSpec_MongodbSpec_4_2 struct {
	MongodbSpec_4_2 *MongodbSpec4_2 `protobuf:"bytes,7,opt,name=mongodb_spec_4_2,json=mongodbSpec_4_2,proto3,oneof"`
}

func (*ConfigSpec_MongodbSpec_3_6) isConfigSpec_MongodbSpec() {}

func (*ConfigSpec_MongodbSpec_4_0) isConfigSpec_MongodbSpec() {}

func (*ConfigSpec_MongodbSpec_4_2) isConfigSpec_MongodbSpec() {}

func (m *ConfigSpec) GetMongodbSpec() isConfigSpec_MongodbSpec {
	if m != nil {
		return m.MongodbSpec
	}
	return nil
}

func (m *ConfigSpec) GetMongodbSpec_3_6() *MongodbSpec3_6 {
	if x, ok := m.GetMongodbSpec().(*ConfigSpec_MongodbSpec_3_6); ok {
		return x.MongodbSpec_3_6
	}
	return nil
}

func (m *ConfigSpec) GetMongodbSpec_4_0() *MongodbSpec4_0 {
	if x, ok := m.GetMongodbSpec().(*ConfigSpec_MongodbSpec_4_0); ok {
		return x.MongodbSpec_4_0
	}
	return nil
}

func (m *ConfigSpec) GetMongodbSpec_4_2() *MongodbSpec4_2 {
	if x, ok := m.GetMongodbSpec().(*ConfigSpec_MongodbSpec_4_2); ok {
		return x.MongodbSpec_4_2
	}
	return nil
}

func (m *ConfigSpec) GetBackupWindowStart() *timeofday.TimeOfDay {
	if m != nil {
		return m.BackupWindowStart
	}
	return nil
}

func (m *ConfigSpec) GetAccess() *Access {
	if m != nil {
		return m.Access
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ConfigSpec) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ConfigSpec_MongodbSpec_3_6)(nil),
		(*ConfigSpec_MongodbSpec_4_0)(nil),
		(*ConfigSpec_MongodbSpec_4_2)(nil),
	}
}

func init() {
	proto.RegisterEnum("yandex.cloud.mdb.mongodb.v1.ListClusterLogsRequest_ServiceType", ListClusterLogsRequest_ServiceType_name, ListClusterLogsRequest_ServiceType_value)
	proto.RegisterEnum("yandex.cloud.mdb.mongodb.v1.StreamClusterLogsRequest_ServiceType", StreamClusterLogsRequest_ServiceType_name, StreamClusterLogsRequest_ServiceType_value)
	proto.RegisterType((*GetClusterRequest)(nil), "yandex.cloud.mdb.mongodb.v1.GetClusterRequest")
	proto.RegisterType((*ListClustersRequest)(nil), "yandex.cloud.mdb.mongodb.v1.ListClustersRequest")
	proto.RegisterType((*ListClustersResponse)(nil), "yandex.cloud.mdb.mongodb.v1.ListClustersResponse")
	proto.RegisterType((*CreateClusterRequest)(nil), "yandex.cloud.mdb.mongodb.v1.CreateClusterRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.mdb.mongodb.v1.CreateClusterRequest.LabelsEntry")
	proto.RegisterType((*CreateClusterMetadata)(nil), "yandex.cloud.mdb.mongodb.v1.CreateClusterMetadata")
	proto.RegisterType((*UpdateClusterRequest)(nil), "yandex.cloud.mdb.mongodb.v1.UpdateClusterRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.mdb.mongodb.v1.UpdateClusterRequest.LabelsEntry")
	proto.RegisterType((*UpdateClusterMetadata)(nil), "yandex.cloud.mdb.mongodb.v1.UpdateClusterMetadata")
	proto.RegisterType((*DeleteClusterRequest)(nil), "yandex.cloud.mdb.mongodb.v1.DeleteClusterRequest")
	proto.RegisterType((*DeleteClusterMetadata)(nil), "yandex.cloud.mdb.mongodb.v1.DeleteClusterMetadata")
	proto.RegisterType((*StartClusterRequest)(nil), "yandex.cloud.mdb.mongodb.v1.StartClusterRequest")
	proto.RegisterType((*StartClusterMetadata)(nil), "yandex.cloud.mdb.mongodb.v1.StartClusterMetadata")
	proto.RegisterType((*StopClusterRequest)(nil), "yandex.cloud.mdb.mongodb.v1.StopClusterRequest")
	proto.RegisterType((*StopClusterMetadata)(nil), "yandex.cloud.mdb.mongodb.v1.StopClusterMetadata")
	proto.RegisterType((*MoveClusterRequest)(nil), "yandex.cloud.mdb.mongodb.v1.MoveClusterRequest")
	proto.RegisterType((*MoveClusterMetadata)(nil), "yandex.cloud.mdb.mongodb.v1.MoveClusterMetadata")
	proto.RegisterType((*BackupClusterRequest)(nil), "yandex.cloud.mdb.mongodb.v1.BackupClusterRequest")
	proto.RegisterType((*BackupClusterMetadata)(nil), "yandex.cloud.mdb.mongodb.v1.BackupClusterMetadata")
	proto.RegisterType((*RestoreClusterRequest)(nil), "yandex.cloud.mdb.mongodb.v1.RestoreClusterRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.mdb.mongodb.v1.RestoreClusterRequest.LabelsEntry")
	proto.RegisterType((*RestoreClusterRequest_RecoveryTargetSpec)(nil), "yandex.cloud.mdb.mongodb.v1.RestoreClusterRequest.RecoveryTargetSpec")
	proto.RegisterType((*RestoreClusterMetadata)(nil), "yandex.cloud.mdb.mongodb.v1.RestoreClusterMetadata")
	proto.RegisterType((*LogRecord)(nil), "yandex.cloud.mdb.mongodb.v1.LogRecord")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.mdb.mongodb.v1.LogRecord.MessageEntry")
	proto.RegisterType((*ListClusterLogsRequest)(nil), "yandex.cloud.mdb.mongodb.v1.ListClusterLogsRequest")
	proto.RegisterType((*ListClusterLogsResponse)(nil), "yandex.cloud.mdb.mongodb.v1.ListClusterLogsResponse")
	proto.RegisterType((*StreamClusterLogsRequest)(nil), "yandex.cloud.mdb.mongodb.v1.StreamClusterLogsRequest")
	proto.RegisterType((*ListClusterOperationsRequest)(nil), "yandex.cloud.mdb.mongodb.v1.ListClusterOperationsRequest")
	proto.RegisterType((*ListClusterOperationsResponse)(nil), "yandex.cloud.mdb.mongodb.v1.ListClusterOperationsResponse")
	proto.RegisterType((*ListClusterBackupsRequest)(nil), "yandex.cloud.mdb.mongodb.v1.ListClusterBackupsRequest")
	proto.RegisterType((*ListClusterBackupsResponse)(nil), "yandex.cloud.mdb.mongodb.v1.ListClusterBackupsResponse")
	proto.RegisterType((*ListClusterHostsRequest)(nil), "yandex.cloud.mdb.mongodb.v1.ListClusterHostsRequest")
	proto.RegisterType((*ListClusterHostsResponse)(nil), "yandex.cloud.mdb.mongodb.v1.ListClusterHostsResponse")
	proto.RegisterType((*AddClusterHostsRequest)(nil), "yandex.cloud.mdb.mongodb.v1.AddClusterHostsRequest")
	proto.RegisterType((*AddClusterHostsMetadata)(nil), "yandex.cloud.mdb.mongodb.v1.AddClusterHostsMetadata")
	proto.RegisterType((*DeleteClusterHostsRequest)(nil), "yandex.cloud.mdb.mongodb.v1.DeleteClusterHostsRequest")
	proto.RegisterType((*DeleteClusterHostsMetadata)(nil), "yandex.cloud.mdb.mongodb.v1.DeleteClusterHostsMetadata")
	proto.RegisterType((*EnableClusterShardingRequest)(nil), "yandex.cloud.mdb.mongodb.v1.EnableClusterShardingRequest")
	proto.RegisterType((*EnableClusterShardingRequest_MongoCfg)(nil), "yandex.cloud.mdb.mongodb.v1.EnableClusterShardingRequest.MongoCfg")
	proto.RegisterType((*EnableClusterShardingRequest_Mongos)(nil), "yandex.cloud.mdb.mongodb.v1.EnableClusterShardingRequest.Mongos")
	proto.RegisterType((*EnableClusterShardingMetadata)(nil), "yandex.cloud.mdb.mongodb.v1.EnableClusterShardingMetadata")
	proto.RegisterType((*GetClusterShardRequest)(nil), "yandex.cloud.mdb.mongodb.v1.GetClusterShardRequest")
	proto.RegisterType((*ListClusterShardsRequest)(nil), "yandex.cloud.mdb.mongodb.v1.ListClusterShardsRequest")
	proto.RegisterType((*ListClusterShardsResponse)(nil), "yandex.cloud.mdb.mongodb.v1.ListClusterShardsResponse")
	proto.RegisterType((*AddClusterShardRequest)(nil), "yandex.cloud.mdb.mongodb.v1.AddClusterShardRequest")
	proto.RegisterType((*AddClusterShardMetadata)(nil), "yandex.cloud.mdb.mongodb.v1.AddClusterShardMetadata")
	proto.RegisterType((*DeleteClusterShardRequest)(nil), "yandex.cloud.mdb.mongodb.v1.DeleteClusterShardRequest")
	proto.RegisterType((*DeleteClusterShardMetadata)(nil), "yandex.cloud.mdb.mongodb.v1.DeleteClusterShardMetadata")
	proto.RegisterType((*ResetupHostsRequest)(nil), "yandex.cloud.mdb.mongodb.v1.ResetupHostsRequest")
	proto.RegisterType((*ResetupHostsMetadata)(nil), "yandex.cloud.mdb.mongodb.v1.ResetupHostsMetadata")
	proto.RegisterType((*RestartHostsRequest)(nil), "yandex.cloud.mdb.mongodb.v1.RestartHostsRequest")
	proto.RegisterType((*RestartHostsMetadata)(nil), "yandex.cloud.mdb.mongodb.v1.RestartHostsMetadata")
	proto.RegisterType((*HostSpec)(nil), "yandex.cloud.mdb.mongodb.v1.HostSpec")
	proto.RegisterType((*MongodbSpec3_6)(nil), "yandex.cloud.mdb.mongodb.v1.MongodbSpec3_6")
	proto.RegisterType((*MongodbSpec3_6_Mongod)(nil), "yandex.cloud.mdb.mongodb.v1.MongodbSpec3_6.Mongod")
	proto.RegisterType((*MongodbSpec3_6_MongoCfg)(nil), "yandex.cloud.mdb.mongodb.v1.MongodbSpec3_6.MongoCfg")
	proto.RegisterType((*MongodbSpec3_6_Mongos)(nil), "yandex.cloud.mdb.mongodb.v1.MongodbSpec3_6.Mongos")
	proto.RegisterType((*MongodbSpec4_0)(nil), "yandex.cloud.mdb.mongodb.v1.MongodbSpec4_0")
	proto.RegisterType((*MongodbSpec4_0_Mongod)(nil), "yandex.cloud.mdb.mongodb.v1.MongodbSpec4_0.Mongod")
	proto.RegisterType((*MongodbSpec4_0_MongoCfg)(nil), "yandex.cloud.mdb.mongodb.v1.MongodbSpec4_0.MongoCfg")
	proto.RegisterType((*MongodbSpec4_0_Mongos)(nil), "yandex.cloud.mdb.mongodb.v1.MongodbSpec4_0.Mongos")
	proto.RegisterType((*MongodbSpec4_2)(nil), "yandex.cloud.mdb.mongodb.v1.MongodbSpec4_2")
	proto.RegisterType((*MongodbSpec4_2_Mongod)(nil), "yandex.cloud.mdb.mongodb.v1.MongodbSpec4_2.Mongod")
	proto.RegisterType((*MongodbSpec4_2_MongoCfg)(nil), "yandex.cloud.mdb.mongodb.v1.MongodbSpec4_2.MongoCfg")
	proto.RegisterType((*MongodbSpec4_2_Mongos)(nil), "yandex.cloud.mdb.mongodb.v1.MongodbSpec4_2.Mongos")
	proto.RegisterType((*ConfigSpec)(nil), "yandex.cloud.mdb.mongodb.v1.ConfigSpec")
}

func init() {
	proto.RegisterFile("yandex/cloud/mdb/mongodb/v1/cluster_service.proto", fileDescriptor_fdf7200f72aab6ae)
}

var fileDescriptor_fdf7200f72aab6ae = []byte{
	// 3176 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0x5b, 0x4d, 0x6c, 0x1b, 0xd7,
	0xf1, 0xcf, 0xea, 0x83, 0x22, 0x87, 0xb6, 0xe2, 0x3c, 0xcb, 0x8e, 0x42, 0x5b, 0x89, 0xbc, 0x71,
	0x1c, 0x99, 0x86, 0xf8, 0x25, 0x89, 0xb6, 0xe5, 0x28, 0xb6, 0x24, 0xcb, 0x8e, 0x12, 0xc9, 0x36,
	0x56, 0x4a, 0xe2, 0xbf, 0xf3, 0x4f, 0x17, 0x4b, 0xee, 0x13, 0xbd, 0x35, 0xc9, 0x65, 0x77, 0x97,
	0x72, 0xe4, 0xd4, 0x68, 0x91, 0x14, 0x28, 0x60, 0x20, 0x05, 0xda, 0x00, 0x2d, 0xda, 0x00, 0x2d,
	0xd0, 0x63, 0x3f, 0x0e, 0x15, 0xda, 0x26, 0x05, 0x7a, 0x6a, 0x51, 0xd8, 0xc7, 0x42, 0x3d, 0xb4,
	0xa7, 0x9e, 0x8a, 0xb6, 0x97, 0x1e, 0x1a, 0xa0, 0x87, 0xa6, 0x97, 0xe2, 0x7d, 0x2c, 0xb9, 0xcb,
	0x8f, 0xe5, 0xae, 0x48, 0x39, 0x02, 0x7a, 0x13, 0xdf, 0xce, 0xcc, 0xfb, 0xcd, 0xbc, 0x79, 0xf3,
	0xe6, 0xbd, 0x19, 0x41, 0x7a, 0x4b, 0x29, 0xab, 0xf8, 0x9d, 0x64, 0xbe, 0xa8, 0x57, 0xd5, 0x64,
	0x49, 0xcd, 0x25, 0x4b, 0x7a, 0xb9, 0xa0, 0xab, 0xb9, 0xe4, 0x66, 0x3a, 0x99, 0x2f, 0x56, 0x4d,
	0x0b, 0x1b, 0xb2, 0x89, 0x8d, 0x4d, 0x2d, 0x8f, 0x13, 0x15, 0x43, 0xb7, 0x74, 0x74, 0x8c, 0xb1,
	0x24, 0x28, 0x4b, 0xa2, 0xa4, 0xe6, 0x12, 0x9c, 0x25, 0xb1, 0x99, 0x8e, 0x1d, 0x2f, 0xe8, 0x7a,
	0xa1, 0x88, 0x93, 0x4a, 0x45, 0x4b, 0x2a, 0xe5, 0xb2, 0x6e, 0x29, 0x96, 0xa6, 0x97, 0x4d, 0xc6,
	0x1a, 0x1b, 0xe7, 0x5f, 0xe9, 0xaf, 0x5c, 0x75, 0x23, 0xb9, 0xa1, 0xe1, 0xa2, 0x2a, 0x97, 0x14,
	0xf3, 0x0e, 0xa7, 0x78, 0xae, 0x91, 0xc2, 0xd2, 0x4a, 0xd8, 0xb4, 0x94, 0x52, 0x85, 0x13, 0x1c,
	0xe3, 0x04, 0xd6, 0x56, 0x05, 0xd3, 0x8f, 0xfa, 0x86, 0xaa, 0x6c, 0xd9, 0xf2, 0x5d, 0xda, 0x10,
	0x0c, 0x7a, 0x05, 0x1b, 0x14, 0x02, 0xa7, 0x38, 0xe5, 0xa2, 0xa8, 0x7d, 0x6d, 0xa2, 0x1b, 0x73,
	0xd1, 0x6d, 0x2a, 0x45, 0x4d, 0x75, 0x7e, 0x9e, 0xf0, 0x32, 0x5b, 0x4e, 0xc9, 0xdf, 0xa9, 0xda,
	0x78, 0x4f, 0xfb, 0x30, 0x30, 0x27, 0x8d, 0x7b, 0x91, 0xaa, 0x8a, 0xa5, 0xe4, 0x14, 0x13, 0xb7,
	0xd4, 0xa3, 0x81, 0xb6, 0x6a, 0xd6, 0x64, 0x4e, 0x79, 0x4e, 0xaf, 0x97, 0x37, 0xb4, 0x82, 0x3d,
	0x32, 0x25, 0x67, 0x83, 0x33, 0x4d, 0xcb, 0xa9, 0xdd, 0x30, 0x65, 0x18, 0x93, 0x78, 0x09, 0x9e,
	0xba, 0x8a, 0xad, 0x45, 0x66, 0x06, 0x09, 0x7f, 0xa9, 0x8a, 0x4d, 0x0b, 0x9d, 0x01, 0xb0, 0x3d,
	0x4f, 0x53, 0x47, 0x85, 0x71, 0x61, 0x22, 0xb2, 0x70, 0xe0, 0xef, 0x0f, 0xd3, 0xc2, 0x83, 0x47,
	0xe9, 0x81, 0x97, 0xe6, 0x66, 0x52, 0x52, 0x84, 0x7f, 0x5f, 0x56, 0xc5, 0x8f, 0x05, 0x38, 0xbc,
	0xa2, 0x99, 0xb6, 0x0c, 0xd3, 0x16, 0x72, 0x1a, 0x22, 0x1b, 0x7a, 0x51, 0x6d, 0x2f, 0x23, 0xcc,
	0x3e, 0x2f, 0xab, 0xe8, 0x45, 0x88, 0x54, 0x94, 0x02, 0x96, 0x4d, 0xed, 0x1e, 0x1e, 0xed, 0x1b,
	0x17, 0x26, 0xfa, 0x17, 0xe0, 0xb3, 0x87, 0xe9, 0xd0, 0x4b, 0x73, 0xe9, 0x54, 0x2a, 0x25, 0x85,
	0xc9, 0xc7, 0x35, 0xed, 0x1e, 0x46, 0x13, 0x00, 0x94, 0xd0, 0xd2, 0xef, 0xe0, 0xf2, 0x68, 0x3f,
	0x15, 0x1a, 0x79, 0xf0, 0x28, 0x3d, 0x48, 0x29, 0x25, 0x2a, 0x65, 0x9d, 0x7c, 0x43, 0x22, 0x84,
	0x36, 0xb4, 0xa2, 0x85, 0x8d, 0xd1, 0x01, 0x4a, 0x05, 0x0f, 0x1e, 0xd5, 0xe4, 0xf1, 0x2f, 0xe2,
	0x57, 0x05, 0x18, 0x71, 0x23, 0x37, 0x2b, 0x7a, 0xd9, 0xc4, 0xe8, 0x12, 0x84, 0xb9, 0x7e, 0xe6,
	0xa8, 0x30, 0xde, 0x3f, 0x11, 0xcd, 0x9c, 0x4c, 0x78, 0xec, 0xb9, 0x84, 0x6d, 0xbe, 0x1a, 0x17,
	0x3a, 0x05, 0x4f, 0x96, 0xf1, 0x3b, 0x96, 0xec, 0x40, 0x4b, 0xf4, 0x8a, 0x48, 0x07, 0xc9, 0xf0,
	0x0d, 0x1b, 0xa6, 0xf8, 0x9b, 0x10, 0x8c, 0x2c, 0x1a, 0x58, 0xb1, 0x70, 0xc3, 0x12, 0x04, 0xb0,
	0x5e, 0x1a, 0x06, 0xca, 0x4a, 0x89, 0x19, 0x2e, 0xb2, 0x30, 0x46, 0xa8, 0x3e, 0x7d, 0x98, 0x3e,
	0xf8, 0x96, 0x32, 0x79, 0x6f, 0x7e, 0xf2, 0x56, 0x6a, 0xf2, 0xbc, 0xfc, 0x76, 0x9c, 0xb1, 0x65,
	0xa7, 0x24, 0x4a, 0x8a, 0xce, 0x40, 0x54, 0xc5, 0x66, 0xde, 0xd0, 0x2a, 0x64, 0x4b, 0xb9, 0x0d,
	0x99, 0x99, 0xc9, 0x4a, 0xce, 0xaf, 0xe8, 0xdb, 0x02, 0x84, 0x8a, 0x4a, 0x0e, 0x17, 0xcd, 0xd1,
	0x01, 0x6a, 0x8c, 0x39, 0x6f, 0x63, 0xb4, 0x50, 0x27, 0xb1, 0x42, 0xf9, 0x97, 0xca, 0x96, 0xb1,
	0xb5, 0x70, 0xf1, 0xd3, 0x87, 0xe9, 0xe8, 0x5b, 0x93, 0x72, 0x6a, 0xf2, 0xbc, 0x32, 0x79, 0xef,
	0xed, 0xf8, 0x7b, 0x0c, 0xdb, 0xb4, 0x8d, 0x71, 0xfb, 0x51, 0x3a, 0x14, 0xb3, 0xff, 0x42, 0xe8,
	0x10, 0x51, 0xe4, 0x6d, 0x07, 0xbd, 0xc4, 0xd1, 0xa0, 0x9b, 0x10, 0xc5, 0xe5, 0x4d, 0xcd, 0xd0,
	0xcb, 0x25, 0x5c, 0xb6, 0x46, 0x07, 0xc7, 0x85, 0x89, 0xe1, 0x4c, 0xca, 0xcf, 0x4a, 0x25, 0x96,
	0xea, 0x7c, 0x0b, 0x03, 0xc4, 0x62, 0x92, 0x53, 0x14, 0xba, 0x06, 0x51, 0xb6, 0x61, 0x64, 0xb3,
	0x82, 0xf3, 0xa3, 0xa1, 0x71, 0x61, 0x22, 0x9a, 0x79, 0xd1, 0x5b, 0x32, 0xa5, 0x5f, 0xab, 0xe0,
	0x3c, 0x17, 0x08, 0xf9, 0xda, 0x08, 0xba, 0x09, 0xc3, 0x76, 0xf8, 0xa0, 0x12, 0xcd, 0xd1, 0x21,
	0x6a, 0xc9, 0xd3, 0x9e, 0x22, 0x2f, 0x73, 0x16, 0x2a, 0x34, 0xf4, 0xde, 0xa3, 0x74, 0xdf, 0xcb,
	0x29, 0xe9, 0xa0, 0xea, 0x18, 0x35, 0xd1, 0x0a, 0x00, 0x09, 0x36, 0x5c, 0x6a, 0x98, 0x4a, 0x7d,
	0xc1, 0x53, 0xea, 0xeb, 0x26, 0x36, 0x5c, 0x12, 0x23, 0x55, 0x3e, 0x42, 0xa5, 0xdd, 0xd6, 0x4d,
	0x8b, 0x4b, 0x8b, 0xf8, 0x90, 0xf6, 0x8a, 0x6e, 0x5a, 0x6e, 0x69, 0xb7, 0xf9, 0x88, 0x49, 0xc2,
	0x48, 0x19, 0x5b, 0x77, 0x75, 0xe3, 0x0e, 0x71, 0x62, 0x68, 0x15, 0x46, 0xf8, 0xf7, 0x65, 0x35,
	0x76, 0x1e, 0xa2, 0x0e, 0x27, 0x41, 0x87, 0xa0, 0xff, 0x0e, 0xde, 0x62, 0x9e, 0x2f, 0x91, 0x3f,
	0xd1, 0x08, 0x0c, 0x6e, 0x2a, 0xc5, 0x2a, 0xf7, 0x73, 0x89, 0xfd, 0x98, 0xed, 0x3b, 0x27, 0x88,
	0x59, 0x38, 0xe2, 0x72, 0xba, 0x55, 0x6c, 0x29, 0xc4, 0x4a, 0x68, 0xac, 0x39, 0x8e, 0x39, 0x23,
	0xd7, 0x7f, 0xfa, 0x61, 0xe4, 0xf5, 0x8a, 0xda, 0xbc, 0xf9, 0x82, 0xc4, 0x3f, 0x74, 0x01, 0xa2,
	0x55, 0x2a, 0x84, 0x9e, 0xa2, 0x14, 0x5d, 0x34, 0x13, 0x4b, 0xb0, 0x53, 0x32, 0x61, 0x1f, 0xa3,
	0x89, 0x2b, 0xe4, 0xa0, 0x5d, 0x55, 0xcc, 0x3b, 0x12, 0x30, 0x72, 0xf2, 0xf7, 0x9e, 0x6e, 0xc4,
	0x56, 0xaa, 0xed, 0xcd, 0x46, 0x7c, 0xc5, 0xbd, 0x5d, 0x06, 0x03, 0x6d, 0x17, 0xd7, 0x46, 0x49,
	0xf0, 0x58, 0x16, 0xa2, 0x86, 0x88, 0x7d, 0xfa, 0x30, 0x3d, 0xec, 0x88, 0x63, 0x93, 0x8d, 0x81,
	0xac, 0x4b, 0xaf, 0x71, 0x59, 0xc8, 0xaf, 0xd7, 0x2c, 0xc2, 0xc8, 0x65, 0x5c, 0xc4, 0x5d, 0x39,
	0x0d, 0x99, 0xdc, 0x25, 0xc4, 0xef, 0xe4, 0x0b, 0x70, 0x78, 0xcd, 0x52, 0x8c, 0xae, 0x0e, 0xec,
	0x19, 0x18, 0x71, 0xca, 0xf0, 0x3b, 0xf5, 0x3c, 0xa0, 0x35, 0x4b, 0xaf, 0x74, 0x33, 0xf3, 0x34,
	0x41, 0x5f, 0x13, 0xe1, 0x77, 0xe2, 0xf7, 0x05, 0x40, 0xab, 0xfa, 0x66, 0x57, 0x9b, 0xf4, 0x12,
	0x1c, 0x51, 0xb1, 0x69, 0x69, 0x65, 0x9a, 0x43, 0xca, 0xf5, 0xa3, 0xb5, 0xaf, 0x05, 0xdf, 0x61,
	0x07, 0xe9, 0x15, 0x7e, 0xca, 0x8a, 0xdf, 0x12, 0xe0, 0xb0, 0x03, 0x85, 0x4f, 0xf0, 0x68, 0x02,
	0x0e, 0x99, 0x7a, 0xd5, 0xc8, 0xe3, 0xc6, 0x39, 0xa5, 0x61, 0x36, 0x6e, 0x4f, 0x80, 0x32, 0xed,
	0x20, 0xd2, 0xa0, 0xd0, 0x1a, 0xd4, 0x22, 0x8c, 0x2c, 0xd0, 0x5c, 0xb7, 0x4b, 0x5f, 0x74, 0x09,
	0xf1, 0xbb, 0x2e, 0xff, 0x0c, 0xc1, 0x11, 0x09, 0x9b, 0x96, 0x6e, 0x34, 0x2e, 0xcd, 0x09, 0x88,
	0xb0, 0x14, 0xbc, 0x3e, 0x3b, 0x3b, 0x13, 0xc3, 0x6c, 0x98, 0x6a, 0xeb, 0x4c, 0x5a, 0x9e, 0xe5,
	0x49, 0x8b, 0xe7, 0x66, 0x0f, 0x16, 0x2c, 0xbf, 0xd3, 0x18, 0x2c, 0x5f, 0xf6, 0x8c, 0x47, 0x2d,
	0x15, 0xf9, 0x5f, 0x4f, 0x5b, 0xdc, 0xe9, 0xc0, 0x50, 0x4f, 0xd3, 0x81, 0xb0, 0x67, 0x3a, 0x80,
	0x5e, 0x70, 0xe6, 0xbf, 0x11, 0x4a, 0x1b, 0x6e, 0x91, 0xfb, 0xde, 0x85, 0x11, 0x03, 0xe7, 0xf5,
	0x4d, 0x6c, 0x6c, 0xc9, 0x96, 0x62, 0x14, 0x30, 0x03, 0x4b, 0x93, 0x8d, 0x68, 0x66, 0x69, 0x17,
	0x4b, 0x2e, 0x71, 0x71, 0xeb, 0x54, 0x1a, 0x3d, 0xa0, 0x90, 0xd1, 0x34, 0xd6, 0xc5, 0xc1, 0x13,
	0x9b, 0x05, 0xd4, 0x3c, 0x09, 0x3a, 0x09, 0x91, 0xda, 0x4d, 0x9b, 0xca, 0xe9, 0x5f, 0x08, 0x7d,
	0xf6, 0x90, 0xd9, 0xb0, 0xf6, 0x41, 0x5c, 0x87, 0xa3, 0x6e, 0xd8, 0x7e, 0xe3, 0xd0, 0x31, 0xe7,
	0x96, 0x64, 0x90, 0x6a, 0x9b, 0x51, 0xfc, 0xbd, 0x00, 0x91, 0x15, 0xbd, 0x40, 0x50, 0x19, 0x2a,
	0x3a, 0xd7, 0x88, 0xa4, 0x55, 0x3a, 0xb3, 0x6e, 0x53, 0x38, 0xd0, 0xa1, 0x55, 0x18, 0x2a, 0x61,
	0xd3, 0x54, 0x0a, 0x44, 0x6b, 0xe2, 0x2c, 0x53, 0x9e, 0x0b, 0x50, 0x9b, 0x32, 0xb1, 0xca, 0xb8,
	0xa8, 0x2d, 0x25, 0x5b, 0x46, 0x6c, 0x16, 0x0e, 0x38, 0x3f, 0x04, 0x3a, 0xdd, 0x1f, 0xf5, 0xc3,
	0x51, 0xc7, 0xdd, 0x6e, 0x45, 0x2f, 0x98, 0xbb, 0x3a, 0x38, 0x9e, 0x87, 0x83, 0x79, 0xbd, 0x58,
	0x2d, 0x95, 0x65, 0x7e, 0x9d, 0x24, 0x8a, 0x45, 0xa4, 0x03, 0x6c, 0xf0, 0x0a, 0x1d, 0x43, 0x39,
	0x38, 0xc0, 0x5f, 0x68, 0x64, 0x6b, 0xab, 0x82, 0x69, 0x64, 0x1a, 0xce, 0x5c, 0xf4, 0x56, 0xbe,
	0x25, 0xb8, 0xc4, 0x1a, 0x93, 0xb3, 0xbe, 0x55, 0xc1, 0x52, 0xd4, 0xac, 0xff, 0x40, 0x67, 0x21,
	0xb2, 0x61, 0xe8, 0x25, 0x99, 0x58, 0x9b, 0xde, 0x69, 0xbd, 0x57, 0x25, 0x4c, 0x88, 0xc9, 0x4f,
	0x34, 0x05, 0x43, 0x96, 0xce, 0xd8, 0x06, 0x3b, 0xb2, 0x85, 0x2c, 0x9d, 0x32, 0xb9, 0x6e, 0xe4,
	0x21, 0xdf, 0x37, 0xf2, 0xa1, 0xf6, 0x37, 0x72, 0xf1, 0x2c, 0x44, 0x1d, 0xca, 0xa1, 0xe3, 0x30,
	0xba, 0xb6, 0x24, 0xbd, 0xb1, 0xbc, 0xb8, 0x24, 0xaf, 0xff, 0xdf, 0x8d, 0x25, 0xf9, 0xf5, 0x6b,
	0x6b, 0x37, 0x96, 0x16, 0x97, 0xaf, 0x2c, 0x2f, 0x5d, 0x3e, 0xf4, 0x04, 0x02, 0x08, 0xad, 0x5e,
	0xbf, 0x76, 0xf5, 0xfa, 0xe5, 0x43, 0x82, 0x78, 0x1f, 0x9e, 0x6e, 0x32, 0x16, 0xbf, 0xa8, 0xcf,
	0xc2, 0x40, 0x51, 0x2f, 0xd8, 0x97, 0xf4, 0x53, 0xfe, 0xbc, 0x4d, 0xa2, 0x3c, 0xbe, 0xaf, 0xe8,
	0xff, 0xee, 0x83, 0xd1, 0x35, 0xcb, 0xc0, 0x4a, 0xe9, 0xb1, 0xf8, 0x92, 0xda, 0xd2, 0x97, 0xe6,
	0x3d, 0x55, 0x6b, 0x07, 0x6f, 0x9f, 0x78, 0xd3, 0xee, 0x97, 0xfe, 0xfb, 0x02, 0x1c, 0x77, 0xac,
	0xfd, 0x75, 0xfb, 0x8d, 0x70, 0x77, 0xf6, 0xef, 0xfd, 0x33, 0x93, 0xf8, 0x40, 0x80, 0xb1, 0x36,
	0x00, 0xb9, 0x8b, 0xce, 0x03, 0xd4, 0x9e, 0x36, 0x6d, 0x47, 0x3d, 0xe1, 0x5e, 0xcd, 0xfa, 0xd3,
	0x67, 0x8d, 0x5f, 0x72, 0x30, 0xf9, 0xf6, 0xd4, 0x8f, 0x04, 0x78, 0xc6, 0x01, 0x86, 0x25, 0x75,
	0xfb, 0xc6, 0x54, 0xef, 0x0b, 0x10, 0x6b, 0x85, 0x8e, 0xdb, 0x69, 0x0e, 0x86, 0xd8, 0x79, 0x64,
	0x1b, 0xe9, 0x79, 0x4f, 0x97, 0x67, 0xec, 0x92, 0xcd, 0xe3, 0xdb, 0x46, 0xdf, 0x15, 0x5c, 0xd1,
	0x84, 0xe4, 0x2b, 0xfb, 0xc6, 0x42, 0xef, 0xc2, 0x68, 0x33, 0x34, 0x6e, 0x9e, 0xb3, 0x30, 0x48,
	0x32, 0xa9, 0x36, 0x1e, 0xd4, 0x22, 0x0b, 0x93, 0x18, 0xbd, 0x6f, 0xc3, 0x7c, 0x28, 0xc0, 0xd1,
	0x79, 0x55, 0xed, 0xda, 0x2e, 0xee, 0x9c, 0xb1, 0xaf, 0xbb, 0x9c, 0x51, 0x7c, 0x13, 0x9e, 0x6e,
	0x00, 0xe5, 0x37, 0xe1, 0x19, 0xe3, 0x38, 0xc8, 0xcd, 0xc1, 0xe4, 0x91, 0x96, 0x0a, 0xbe, 0x46,
	0x06, 0xc4, 0x77, 0xe0, 0x19, 0xd7, 0x05, 0x7c, 0xf7, 0x0a, 0x27, 0x9a, 0x27, 0x5a, 0x78, 0x92,
	0x69, 0x62, 0x5f, 0x4d, 0xa6, 0x9c, 0x33, 0xdf, 0x82, 0x58, 0xf3, 0xcc, 0x3d, 0xd2, 0xea, 0x83,
	0x01, 0x38, 0xbe, 0x54, 0x56, 0x72, 0x45, 0x5b, 0xf8, 0xda, 0x6d, 0xc5, 0x50, 0xb5, 0x72, 0x61,
	0x57, 0x9a, 0xa9, 0x10, 0xa6, 0xcb, 0x94, 0xdf, 0x28, 0xf0, 0x67, 0xad, 0x05, 0xcf, 0x85, 0xf4,
	0x9a, 0x39, 0xb1, 0x4a, 0xe8, 0x16, 0x37, 0x0a, 0xf6, 0x4d, 0xd0, 0x96, 0x8c, 0xbe, 0x00, 0x21,
	0xfa, 0xb7, 0x49, 0xf7, 0x46, 0x34, 0x73, 0xa9, 0xcb, 0x39, 0x4c, 0x3e, 0x03, 0x97, 0xda, 0xe0,
	0x90, 0x03, 0xdd, 0x39, 0x64, 0xec, 0x0d, 0x08, 0xdb, 0x9a, 0xa0, 0x57, 0x21, 0x62, 0x60, 0x76,
	0x8b, 0x37, 0x79, 0xa2, 0x7c, 0xaa, 0xd3, 0x8d, 0x83, 0x51, 0x73, 0x88, 0x75, 0xf6, 0xd8, 0x3a,
	0x84, 0x18, 0xfa, 0x5e, 0x4a, 0x15, 0x5f, 0x86, 0xb1, 0x96, 0x06, 0xf3, 0x7b, 0xc5, 0xff, 0x9a,
	0x00, 0x47, 0xeb, 0xe5, 0x21, 0xca, 0xbd, 0x2b, 0x4f, 0x9a, 0x03, 0x30, 0x09, 0xb3, 0x1c, 0xe0,
	0xce, 0x1f, 0xa1, 0x1c, 0xc4, 0xaf, 0xc5, 0xef, 0x09, 0xae, 0xc8, 0x48, 0x71, 0xec, 0x9b, 0xa8,
	0xfd, 0x15, 0xd7, 0xa1, 0x6b, 0x63, 0xab, 0x25, 0xa8, 0x21, 0xaa, 0x86, 0x1d, 0xb7, 0x45, 0xef,
	0x3c, 0x8e, 0x1a, 0x98, 0x73, 0xf8, 0x8e, 0xdc, 0x3b, 0xae, 0xc8, 0xfd, 0x79, 0x2d, 0x52, 0xc3,
	0x3e, 0xeb, 0xef, 0x65, 0xe0, 0xa7, 0x3a, 0x05, 0x08, 0x91, 0x8d, 0x6a, 0x38, 0x7d, 0xe9, 0xeb,
	0x42, 0x43, 0xe4, 0xff, 0xdc, 0xbc, 0xba, 0xf1, 0x20, 0xe8, 0xa5, 0x96, 0x06, 0x1c, 0x96, 0xb0,
	0x89, 0xad, 0x6a, 0xe5, 0xf1, 0x1d, 0x6c, 0xeb, 0x30, 0xe2, 0x9c, 0xb3, 0x47, 0x47, 0x1a, 0xd3,
	0xc4, 0x52, 0x0c, 0xeb, 0x71, 0x6b, 0x52, 0x9b, 0xb3, 0x47, 0x9a, 0xfc, 0x4b, 0x80, 0xb0, 0xed,
	0xf2, 0xe8, 0x04, 0x0c, 0xdd, 0xd3, 0xcb, 0xb8, 0x0e, 0xbe, 0xfe, 0xba, 0x15, 0x22, 0x1f, 0xd8,
	0x13, 0x98, 0x59, 0xcd, 0x95, 0xb1, 0x55, 0x7f, 0xa7, 0x76, 0x3c, 0x81, 0xb1, 0x4f, 0xec, 0x85,
	0x59, 0x31, 0x4d, 0xad, 0x50, 0x96, 0x2b, 0xd5, 0x5c, 0x51, 0xcb, 0xcb, 0x5a, 0x85, 0xc6, 0xab,
	0xb0, 0x34, 0xcc, 0xc6, 0x6f, 0xd0, 0xe1, 0xe5, 0x0a, 0xb9, 0x2d, 0xd3, 0x2b, 0xe5, 0x00, 0xbd,
	0x52, 0x9e, 0xea, 0xb8, 0x37, 0x13, 0xf4, 0xde, 0x48, 0x79, 0xd0, 0x79, 0x97, 0xbf, 0x0d, 0x76,
	0x2c, 0xcf, 0x38, 0x7c, 0xf1, 0x4f, 0x83, 0x30, 0xbc, 0xca, 0x24, 0x13, 0xd5, 0xa7, 0xe4, 0x2c,
	0x7a, 0x95, 0x9f, 0xf9, 0x2a, 0x3f, 0xe0, 0x32, 0x9e, 0x58, 0xdc, 0xcc, 0xfc, 0x27, 0x3f, 0xdf,
	0x55, 0x74, 0xa3, 0x29, 0x4b, 0x99, 0x0e, 0x2c, 0x6d, 0x71, 0xa3, 0xe0, 0xc8, 0x48, 0x5e, 0x6d,
	0xc8, 0x48, 0x82, 0xa3, 0x33, 0xed, 0xec, 0x23, 0xf6, 0x91, 0xc0, 0x0f, 0x76, 0x15, 0xbd, 0x06,
	0x21, 0xf6, 0xb6, 0xca, 0x95, 0xf6, 0x7e, 0x1c, 0x63, 0xa4, 0x5c, 0x3a, 0x7b, 0xa5, 0x9d, 0x92,
	0xb3, 0x12, 0x17, 0x81, 0x2e, 0x3b, 0xb3, 0x84, 0xbe, 0x20, 0x59, 0x82, 0x33, 0xeb, 0xf8, 0x81,
	0xe0, 0x48, 0x67, 0x56, 0x1b, 0xf0, 0xcd, 0xf8, 0xc6, 0xb7, 0xb8, 0x51, 0xd8, 0x2b, 0x84, 0x35,
	0xfb, 0x99, 0x5d, 0xd8, 0xcf, 0xdc, 0x23, 0x74, 0x8d, 0xae, 0x3d, 0x2d, 0xa7, 0x76, 0xef, 0xda,
	0xd3, 0x72, 0xaa, 0x87, 0xae, 0x5d, 0x93, 0xd6, 0x23, 0xd7, 0xae, 0xc9, 0xdb, 0x1b, 0xd7, 0x9e,
	0x96, 0x53, 0xfb, 0xdc, 0xb5, 0x7b, 0x8f, 0xb0, 0x97, 0xae, 0xdd, 0x73, 0x74, 0xcd, 0xae, 0x9d,
	0xe9, 0xc6, 0xb5, 0x33, 0x3d, 0x75, 0xed, 0x4c, 0x8f, 0x5d, 0x3b, 0xb3, 0xb7, 0xae, 0x9d, 0xd9,
	0xf7, 0xae, 0x9d, 0xd9, 0xd7, 0xae, 0xdd, 0x63, 0x74, 0xe2, 0x07, 0x03, 0x00, 0xf5, 0xba, 0x27,
	0x1a, 0x85, 0xa1, 0x4d, 0x6c, 0x98, 0x9a, 0x5e, 0xe6, 0x29, 0x9d, 0xfd, 0x13, 0x2d, 0xc0, 0xd8,
	0x06, 0x56, 0xac, 0xaa, 0x81, 0xe5, 0xbc, 0x5e, 0xaa, 0x28, 0x96, 0x96, 0xd3, 0x8a, 0x9a, 0xb5,
	0x25, 0xdb, 0xf4, 0x34, 0x0f, 0x92, 0x8e, 0x71, 0xa2, 0x45, 0x27, 0xcd, 0x1b, 0x5c, 0xc6, 0x4d,
	0x38, 0xc4, 0xf1, 0xd0, 0x9b, 0x91, 0x3c, 0x25, 0x67, 0x39, 0xf2, 0x33, 0x01, 0xd2, 0x8a, 0x57,
	0x9e, 0x90, 0x9e, 0x2c, 0xd5, 0x47, 0x88, 0x94, 0x26, 0xc9, 0xd3, 0x72, 0x8a, 0x3f, 0xe5, 0x9f,
	0x09, 0x10, 0xd5, 0x1b, 0x25, 0x93, 0x33, 0xac, 0x59, 0x72, 0x86, 0x96, 0x76, 0x02, 0x49, 0xce,
	0x34, 0x4b, 0xce, 0xa0, 0x2b, 0x70, 0x98, 0x97, 0x21, 0xef, 0x6a, 0x65, 0x55, 0xbf, 0x2b, 0xd3,
	0x2c, 0x9b, 0xef, 0xd8, 0xa3, 0x76, 0x29, 0x81, 0x64, 0x9c, 0xb4, 0x8c, 0x70, 0x7d, 0xe3, 0xb2,
	0xb2, 0x25, 0x3d, 0xc5, 0x58, 0xde, 0xa4, 0x1c, 0xb4, 0x75, 0x05, 0x5d, 0x80, 0x90, 0x92, 0xcf,
	0x63, 0xd3, 0xe4, 0x45, 0x6e, 0xef, 0xc7, 0xe2, 0x79, 0x4a, 0x2a, 0x71, 0x96, 0x85, 0x61, 0x38,
	0xe0, 0x54, 0x2f, 0xf3, 0xc3, 0x93, 0x30, 0x6c, 0xdf, 0xc1, 0x58, 0x99, 0x02, 0x7d, 0x43, 0x80,
	0xfe, 0xab, 0xd8, 0x42, 0x09, 0x4f, 0xb9, 0x4d, 0x9d, 0xb3, 0x31, 0x5f, 0x7d, 0xa2, 0x62, 0xfa,
	0xbd, 0x3f, 0xfc, 0xe5, 0xc3, 0xbe, 0x33, 0xe8, 0x74, 0xb2, 0xa4, 0x94, 0x95, 0x02, 0x56, 0x27,
	0x9b, 0x5b, 0x92, 0xcd, 0xe4, 0xbb, 0xf5, 0xbb, 0xc6, 0x7d, 0xf4, 0x4d, 0x01, 0x06, 0x56, 0x34,
	0xd3, 0x42, 0x29, 0xbf, 0x55, 0x45, 0xfb, 0xaa, 0x14, 0x4b, 0x07, 0xe0, 0x60, 0xcf, 0x16, 0xe2,
	0x49, 0x0a, 0xf0, 0x59, 0x74, 0xdc, 0x0b, 0x20, 0xfa, 0xb1, 0x00, 0x21, 0xd6, 0x78, 0x87, 0xd2,
	0x81, 0x5b, 0x42, 0x63, 0x9d, 0x8b, 0x20, 0xe2, 0x6b, 0xdb, 0x3b, 0xf1, 0xf1, 0x76, 0xcd, 0x7d,
	0x43, 0x7c, 0x80, 0x42, 0x3d, 0x21, 0x7a, 0x42, 0x9d, 0x15, 0xe2, 0xe8, 0x13, 0x01, 0x42, 0xac,
	0xe1, 0xab, 0x03, 0xda, 0x56, 0x7d, 0x73, 0x7e, 0xd0, 0xde, 0x64, 0x68, 0x5b, 0x37, 0x95, 0xb9,
	0xd0, 0x26, 0x32, 0xfe, 0x57, 0x9e, 0x40, 0xff, 0xad, 0x00, 0x21, 0xf6, 0x54, 0xd0, 0x01, 0x7a,
	0xab, 0xc6, 0x34, 0x3f, 0xd0, 0xf3, 0xdb, 0x3b, 0xf1, 0x44, 0xbb, 0x96, 0xb4, 0x23, 0x8d, 0x05,
	0xbe, 0xa5, 0x52, 0xc5, 0xda, 0x62, 0x2e, 0x1c, 0x0f, 0xe0, 0xc2, 0x9f, 0x08, 0x30, 0xc8, 0x76,
	0x6f, 0xaa, 0x43, 0x35, 0xb3, 0xa9, 0xc1, 0xcd, 0x8f, 0x0e, 0xb7, 0xb6, 0x77, 0xe2, 0xcf, 0xb5,
	0x69, 0x6d, 0x73, 0x59, 0x3f, 0x2d, 0x26, 0xfd, 0x5b, 0x9f, 0xc6, 0x27, 0xf4, 0x73, 0x01, 0x06,
	0xd6, 0x2c, 0xbd, 0x82, 0x92, 0x1d, 0x90, 0x37, 0xf6, 0xc7, 0xf9, 0xf5, 0x9b, 0x67, 0x5b, 0x77,
	0xc6, 0xb9, 0x70, 0xa7, 0xc4, 0x44, 0x10, 0xdc, 0x7a, 0x05, 0x7d, 0x2c, 0xc0, 0xc0, 0xaa, 0xbe,
	0x89, 0x3b, 0xc0, 0x6e, 0x6e, 0xae, 0xf3, 0x03, 0xfb, 0x2d, 0x06, 0xbb, 0x55, 0x4f, 0x9c, 0x0b,
	0xf6, 0x54, 0x10, 0xd8, 0x25, 0x7d, 0x13, 0x13, 0x8f, 0xff, 0xb5, 0x00, 0x21, 0x56, 0xe2, 0xeb,
	0xe0, 0xf1, 0xad, 0xda, 0xdf, 0xfc, 0xa0, 0xff, 0x7f, 0xb6, 0x59, 0x5b, 0x37, 0xbe, 0xb9, 0xf0,
	0x67, 0xc4, 0x94, 0x7f, 0xfc, 0xec, 0xa4, 0x42, 0xbf, 0x14, 0x60, 0x88, 0xf7, 0xe9, 0xa0, 0x4c,
	0xf0, 0x26, 0x24, 0x3f, 0x0a, 0xac, 0x6f, 0xef, 0xc4, 0x4f, 0xb4, 0xed, 0x06, 0x72, 0x69, 0x70,
	0x5a, 0x3c, 0xe9, 0x19, 0x1c, 0x0d, 0x26, 0x83, 0xd8, 0xfd, 0xa7, 0x02, 0x84, 0xc9, 0x89, 0xb0,
	0xa2, 0x17, 0x4c, 0x34, 0xb5, 0x8b, 0x06, 0x96, 0xd8, 0x74, 0x30, 0x26, 0x7e, 0xe0, 0x64, 0x99,
	0x87, 0xa3, 0x00, 0xae, 0x42, 0x9b, 0x38, 0x7e, 0x22, 0x00, 0xb0, 0xee, 0x07, 0x8a, 0x78, 0x66,
	0x57, 0x6d, 0x12, 0x31, 0x9f, 0x8d, 0x23, 0xe2, 0x1c, 0x45, 0x79, 0x16, 0xcd, 0x04, 0xd9, 0x87,
	0x64, 0x4e, 0x99, 0x80, 0x4d, 0x09, 0xe8, 0x77, 0x02, 0x0c, 0x13, 0x13, 0xd4, 0xfb, 0x04, 0xd0,
	0x79, 0xbf, 0xf6, 0x6a, 0x6a, 0x7e, 0x88, 0xcd, 0xee, 0x86, 0x95, 0x1b, 0xfc, 0x25, 0xaa, 0x4a,
	0x16, 0x4d, 0xfb, 0x56, 0x25, 0xe9, 0xe8, 0x48, 0xf8, 0x95, 0x00, 0x51, 0x22, 0x9f, 0x17, 0xf1,
	0x51, 0xd6, 0x2f, 0x12, 0x77, 0x4f, 0x42, 0xec, 0x6c, 0x60, 0x3e, 0x0e, 0xff, 0x3c, 0x0b, 0x2d,
	0x28, 0xed, 0x1f, 0xbe, 0xdd, 0x29, 0xf0, 0x33, 0x01, 0x22, 0x44, 0x32, 0x7d, 0xda, 0x45, 0xbe,
	0xdd, 0xd5, 0xf9, 0xfa, 0x1c, 0x9b, 0x09, 0xc8, 0xc5, 0x51, 0x9f, 0x65, 0xe7, 0x0f, 0xf2, 0x7f,
	0xfe, 0x24, 0x59, 0x11, 0xff, 0xcf, 0x02, 0x84, 0xe7, 0x55, 0x95, 0x41, 0xf6, 0xde, 0x96, 0xad,
	0x6b, 0xf8, 0x7e, 0x22, 0xca, 0xbd, 0xed, 0x9d, 0x78, 0xaa, 0x7d, 0xbd, 0xdd, 0x23, 0x0d, 0xb8,
	0x24, 0x5e, 0x08, 0xa8, 0xd1, 0x6c, 0x4e, 0xb1, 0xf2, 0xb7, 0x59, 0x62, 0x47, 0xe2, 0xce, 0xdf,
	0x04, 0x88, 0xb2, 0xec, 0x83, 0xe9, 0x98, 0xf5, 0x9f, 0xe6, 0x04, 0x55, 0xf3, 0xfe, 0xf6, 0x4e,
	0x7c, 0xca, 0xb3, 0x06, 0xbf, 0x07, 0x9a, 0xb2, 0xd9, 0x88, 0xa6, 0xff, 0x10, 0x60, 0x98, 0xd5,
	0x64, 0xed, 0x62, 0x6c, 0x87, 0x10, 0xe0, 0x55, 0xf1, 0xf6, 0xab, 0x6f, 0xb6, 0x53, 0x1d, 0xd8,
	0x43, 0xe5, 0x39, 0xf1, 0x9c, 0xff, 0x70, 0x87, 0x5d, 0x9a, 0x11, 0x7d, 0x7f, 0x24, 0x40, 0xf8,
	0x2a, 0xb6, 0xe8, 0x50, 0x07, 0xd7, 0x6d, 0x5d, 0x69, 0x8e, 0xf9, 0xa8, 0x99, 0x8a, 0x4b, 0x14,
	0xea, 0x45, 0x34, 0xe7, 0x7f, 0x75, 0x58, 0x95, 0x35, 0xf9, 0x6e, 0xbd, 0xac, 0x71, 0x1f, 0xfd,
	0x42, 0x00, 0x20, 0xbb, 0x97, 0x55, 0x71, 0x91, 0xef, 0x6d, 0xee, 0xaa, 0x48, 0xc7, 0xb2, 0x41,
	0xd9, 0x78, 0x78, 0x38, 0xc7, 0xf2, 0x0d, 0x94, 0x0a, 0xaa, 0x04, 0xb9, 0x20, 0x90, 0xf8, 0xe0,
	0xc7, 0xc8, 0xad, 0x2b, 0xc5, 0x7e, 0x1c, 0x49, 0xa6, 0x29, 0x53, 0xdb, 0xb2, 0xec, 0x20, 0xfd,
	0x49, 0x55, 0x98, 0x11, 0x03, 0xab, 0x40, 0x5c, 0xe5, 0xaf, 0xb5, 0x20, 0xc0, 0x14, 0x09, 0x10,
	0x04, 0x82, 0xea, 0xf2, 0xe5, 0x16, 0x41, 0xc0, 0xad, 0x8e, 0xc7, 0x8e, 0xb8, 0x18, 0xef, 0xd2,
	0xcd, 0xfe, 0x28, 0xc0, 0x01, 0x67, 0xa9, 0xb4, 0xc3, 0x85, 0xa8, 0x45, 0x25, 0xd7, 0x8f, 0x8e,
	0xc6, 0xf6, 0x4e, 0x7c, 0xb2, 0x4d, 0x4d, 0xd6, 0x43, 0xbb, 0x0b, 0x62, 0xd6, 0xff, 0x7e, 0x37,
	0x1c, 0xc2, 0xc9, 0x12, 0x72, 0xcd, 0x6a, 0xa5, 0xd3, 0xce, 0x9a, 0x35, 0x56, 0x76, 0x83, 0x69,
	0xd6, 0x5c, 0xa3, 0xed, 0xa1, 0x66, 0x35, 0xe1, 0xb3, 0x42, 0x7c, 0xe1, 0x8b, 0xf0, 0x9c, 0x0b,
	0x97, 0x52, 0xd1, 0x1a, 0xb4, 0xb9, 0x75, 0xb5, 0xa0, 0x59, 0xb7, 0xab, 0xb9, 0x44, 0x5e, 0x2f,
	0x25, 0x19, 0xed, 0x24, 0xfb, 0x5f, 0xec, 0x82, 0x3e, 0x59, 0xc0, 0x65, 0x8a, 0x28, 0xe9, 0xf1,
	0x4f, 0xda, 0x17, 0xf8, 0x9f, 0xb9, 0x10, 0x25, 0x9d, 0xfa, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff,
	0x50, 0xb3, 0xb9, 0x29, 0x1c, 0x40, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ClusterServiceClient is the client API for ClusterService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ClusterServiceClient interface {
	// Returns the specified MongoDB Cluster resource.
	//
	// To get the list of available MongoDB Cluster resources, make a [List] request.
	Get(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Retrieves the list of MongoDB Cluster resources that belong
	// to the specified folder.
	List(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Creates a MongoDB cluster in the specified folder.
	Create(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified MongoDB cluster.
	Update(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified MongoDB cluster.
	Delete(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Start the specified MongoDB cluster.
	Start(ctx context.Context, in *StartClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Stop the specified MongoDB cluster.
	Stop(ctx context.Context, in *StopClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Moves the specified MongoDB cluster to the specified folder.
	Move(ctx context.Context, in *MoveClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Creates a backup for the specified MongoDB cluster.
	Backup(ctx context.Context, in *BackupClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Creates a new MongoDB cluster using the specified backup.
	Restore(ctx context.Context, in *RestoreClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Retrieves logs for the specified MongoDB cluster.
	ListLogs(ctx context.Context, in *ListClusterLogsRequest, opts ...grpc.CallOption) (*ListClusterLogsResponse, error)
	// Same as ListLogs but using server-side streaming. Also allows for 'tail -f' semantics.
	StreamLogs(ctx context.Context, in *StreamClusterLogsRequest, opts ...grpc.CallOption) (ClusterService_StreamLogsClient, error)
	// Retrieves the list of Operation resources for the specified cluster.
	ListOperations(ctx context.Context, in *ListClusterOperationsRequest, opts ...grpc.CallOption) (*ListClusterOperationsResponse, error)
	// Retrieves the list of available backups for the specified MongoDB cluster.
	ListBackups(ctx context.Context, in *ListClusterBackupsRequest, opts ...grpc.CallOption) (*ListClusterBackupsResponse, error)
	// Retrieves a list of hosts for the specified cluster.
	ListHosts(ctx context.Context, in *ListClusterHostsRequest, opts ...grpc.CallOption) (*ListClusterHostsResponse, error)
	// Creates new hosts for a cluster.
	AddHosts(ctx context.Context, in *AddClusterHostsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified hosts for a cluster.
	DeleteHosts(ctx context.Context, in *DeleteClusterHostsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Enables sharding for the cluster: creates 3 mongocfg and 2 mongos hosts
	// that would support adding and using shards in the cluster.
	EnableSharding(ctx context.Context, in *EnableClusterShardingRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Returns the specified shard.
	GetShard(ctx context.Context, in *GetClusterShardRequest, opts ...grpc.CallOption) (*Shard, error)
	// Retrieves a list of shards.
	ListShards(ctx context.Context, in *ListClusterShardsRequest, opts ...grpc.CallOption) (*ListClusterShardsResponse, error)
	// Creates a new shard.
	AddShard(ctx context.Context, in *AddClusterShardRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified shard.
	DeleteShard(ctx context.Context, in *DeleteClusterShardRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Resetup hosts.
	ResetupHosts(ctx context.Context, in *ResetupHostsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Restart hosts.
	RestartHosts(ctx context.Context, in *RestartHostsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
}

type clusterServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewClusterServiceClient(cc grpc.ClientConnInterface) ClusterServiceClient {
	return &clusterServiceClient{cc}
}

func (c *clusterServiceClient) Get(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mongodb.v1.ClusterService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) List(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mongodb.v1.ClusterService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Create(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mongodb.v1.ClusterService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Update(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mongodb.v1.ClusterService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Delete(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mongodb.v1.ClusterService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Start(ctx context.Context, in *StartClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mongodb.v1.ClusterService/Start", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Stop(ctx context.Context, in *StopClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mongodb.v1.ClusterService/Stop", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Move(ctx context.Context, in *MoveClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mongodb.v1.ClusterService/Move", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Backup(ctx context.Context, in *BackupClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mongodb.v1.ClusterService/Backup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Restore(ctx context.Context, in *RestoreClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mongodb.v1.ClusterService/Restore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) ListLogs(ctx context.Context, in *ListClusterLogsRequest, opts ...grpc.CallOption) (*ListClusterLogsResponse, error) {
	out := new(ListClusterLogsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mongodb.v1.ClusterService/ListLogs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) StreamLogs(ctx context.Context, in *StreamClusterLogsRequest, opts ...grpc.CallOption) (ClusterService_StreamLogsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ClusterService_serviceDesc.Streams[0], "/yandex.cloud.mdb.mongodb.v1.ClusterService/StreamLogs", opts...)
	if err != nil {
		return nil, err
	}
	x := &clusterServiceStreamLogsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ClusterService_StreamLogsClient interface {
	Recv() (*LogRecord, error)
	grpc.ClientStream
}

type clusterServiceStreamLogsClient struct {
	grpc.ClientStream
}

func (x *clusterServiceStreamLogsClient) Recv() (*LogRecord, error) {
	m := new(LogRecord)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *clusterServiceClient) ListOperations(ctx context.Context, in *ListClusterOperationsRequest, opts ...grpc.CallOption) (*ListClusterOperationsResponse, error) {
	out := new(ListClusterOperationsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mongodb.v1.ClusterService/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) ListBackups(ctx context.Context, in *ListClusterBackupsRequest, opts ...grpc.CallOption) (*ListClusterBackupsResponse, error) {
	out := new(ListClusterBackupsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mongodb.v1.ClusterService/ListBackups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) ListHosts(ctx context.Context, in *ListClusterHostsRequest, opts ...grpc.CallOption) (*ListClusterHostsResponse, error) {
	out := new(ListClusterHostsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mongodb.v1.ClusterService/ListHosts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) AddHosts(ctx context.Context, in *AddClusterHostsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mongodb.v1.ClusterService/AddHosts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) DeleteHosts(ctx context.Context, in *DeleteClusterHostsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mongodb.v1.ClusterService/DeleteHosts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) EnableSharding(ctx context.Context, in *EnableClusterShardingRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mongodb.v1.ClusterService/EnableSharding", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) GetShard(ctx context.Context, in *GetClusterShardRequest, opts ...grpc.CallOption) (*Shard, error) {
	out := new(Shard)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mongodb.v1.ClusterService/GetShard", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) ListShards(ctx context.Context, in *ListClusterShardsRequest, opts ...grpc.CallOption) (*ListClusterShardsResponse, error) {
	out := new(ListClusterShardsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mongodb.v1.ClusterService/ListShards", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) AddShard(ctx context.Context, in *AddClusterShardRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mongodb.v1.ClusterService/AddShard", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) DeleteShard(ctx context.Context, in *DeleteClusterShardRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mongodb.v1.ClusterService/DeleteShard", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) ResetupHosts(ctx context.Context, in *ResetupHostsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mongodb.v1.ClusterService/ResetupHosts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) RestartHosts(ctx context.Context, in *RestartHostsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mongodb.v1.ClusterService/RestartHosts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ClusterServiceServer is the server API for ClusterService service.
type ClusterServiceServer interface {
	// Returns the specified MongoDB Cluster resource.
	//
	// To get the list of available MongoDB Cluster resources, make a [List] request.
	Get(context.Context, *GetClusterRequest) (*Cluster, error)
	// Retrieves the list of MongoDB Cluster resources that belong
	// to the specified folder.
	List(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Creates a MongoDB cluster in the specified folder.
	Create(context.Context, *CreateClusterRequest) (*operation.Operation, error)
	// Updates the specified MongoDB cluster.
	Update(context.Context, *UpdateClusterRequest) (*operation.Operation, error)
	// Deletes the specified MongoDB cluster.
	Delete(context.Context, *DeleteClusterRequest) (*operation.Operation, error)
	// Start the specified MongoDB cluster.
	Start(context.Context, *StartClusterRequest) (*operation.Operation, error)
	// Stop the specified MongoDB cluster.
	Stop(context.Context, *StopClusterRequest) (*operation.Operation, error)
	// Moves the specified MongoDB cluster to the specified folder.
	Move(context.Context, *MoveClusterRequest) (*operation.Operation, error)
	// Creates a backup for the specified MongoDB cluster.
	Backup(context.Context, *BackupClusterRequest) (*operation.Operation, error)
	// Creates a new MongoDB cluster using the specified backup.
	Restore(context.Context, *RestoreClusterRequest) (*operation.Operation, error)
	// Retrieves logs for the specified MongoDB cluster.
	ListLogs(context.Context, *ListClusterLogsRequest) (*ListClusterLogsResponse, error)
	// Same as ListLogs but using server-side streaming. Also allows for 'tail -f' semantics.
	StreamLogs(*StreamClusterLogsRequest, ClusterService_StreamLogsServer) error
	// Retrieves the list of Operation resources for the specified cluster.
	ListOperations(context.Context, *ListClusterOperationsRequest) (*ListClusterOperationsResponse, error)
	// Retrieves the list of available backups for the specified MongoDB cluster.
	ListBackups(context.Context, *ListClusterBackupsRequest) (*ListClusterBackupsResponse, error)
	// Retrieves a list of hosts for the specified cluster.
	ListHosts(context.Context, *ListClusterHostsRequest) (*ListClusterHostsResponse, error)
	// Creates new hosts for a cluster.
	AddHosts(context.Context, *AddClusterHostsRequest) (*operation.Operation, error)
	// Deletes the specified hosts for a cluster.
	DeleteHosts(context.Context, *DeleteClusterHostsRequest) (*operation.Operation, error)
	// Enables sharding for the cluster: creates 3 mongocfg and 2 mongos hosts
	// that would support adding and using shards in the cluster.
	EnableSharding(context.Context, *EnableClusterShardingRequest) (*operation.Operation, error)
	// Returns the specified shard.
	GetShard(context.Context, *GetClusterShardRequest) (*Shard, error)
	// Retrieves a list of shards.
	ListShards(context.Context, *ListClusterShardsRequest) (*ListClusterShardsResponse, error)
	// Creates a new shard.
	AddShard(context.Context, *AddClusterShardRequest) (*operation.Operation, error)
	// Deletes the specified shard.
	DeleteShard(context.Context, *DeleteClusterShardRequest) (*operation.Operation, error)
	// Resetup hosts.
	ResetupHosts(context.Context, *ResetupHostsRequest) (*operation.Operation, error)
	// Restart hosts.
	RestartHosts(context.Context, *RestartHostsRequest) (*operation.Operation, error)
}

// UnimplementedClusterServiceServer can be embedded to have forward compatible implementations.
type UnimplementedClusterServiceServer struct {
}

func (*UnimplementedClusterServiceServer) Get(ctx context.Context, req *GetClusterRequest) (*Cluster, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedClusterServiceServer) List(ctx context.Context, req *ListClustersRequest) (*ListClustersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedClusterServiceServer) Create(ctx context.Context, req *CreateClusterRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (*UnimplementedClusterServiceServer) Update(ctx context.Context, req *UpdateClusterRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (*UnimplementedClusterServiceServer) Delete(ctx context.Context, req *DeleteClusterRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedClusterServiceServer) Start(ctx context.Context, req *StartClusterRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Start not implemented")
}
func (*UnimplementedClusterServiceServer) Stop(ctx context.Context, req *StopClusterRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Stop not implemented")
}
func (*UnimplementedClusterServiceServer) Move(ctx context.Context, req *MoveClusterRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Move not implemented")
}
func (*UnimplementedClusterServiceServer) Backup(ctx context.Context, req *BackupClusterRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Backup not implemented")
}
func (*UnimplementedClusterServiceServer) Restore(ctx context.Context, req *RestoreClusterRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Restore not implemented")
}
func (*UnimplementedClusterServiceServer) ListLogs(ctx context.Context, req *ListClusterLogsRequest) (*ListClusterLogsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLogs not implemented")
}
func (*UnimplementedClusterServiceServer) StreamLogs(req *StreamClusterLogsRequest, srv ClusterService_StreamLogsServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamLogs not implemented")
}
func (*UnimplementedClusterServiceServer) ListOperations(ctx context.Context, req *ListClusterOperationsRequest) (*ListClusterOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOperations not implemented")
}
func (*UnimplementedClusterServiceServer) ListBackups(ctx context.Context, req *ListClusterBackupsRequest) (*ListClusterBackupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBackups not implemented")
}
func (*UnimplementedClusterServiceServer) ListHosts(ctx context.Context, req *ListClusterHostsRequest) (*ListClusterHostsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListHosts not implemented")
}
func (*UnimplementedClusterServiceServer) AddHosts(ctx context.Context, req *AddClusterHostsRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddHosts not implemented")
}
func (*UnimplementedClusterServiceServer) DeleteHosts(ctx context.Context, req *DeleteClusterHostsRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteHosts not implemented")
}
func (*UnimplementedClusterServiceServer) EnableSharding(ctx context.Context, req *EnableClusterShardingRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EnableSharding not implemented")
}
func (*UnimplementedClusterServiceServer) GetShard(ctx context.Context, req *GetClusterShardRequest) (*Shard, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetShard not implemented")
}
func (*UnimplementedClusterServiceServer) ListShards(ctx context.Context, req *ListClusterShardsRequest) (*ListClusterShardsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListShards not implemented")
}
func (*UnimplementedClusterServiceServer) AddShard(ctx context.Context, req *AddClusterShardRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddShard not implemented")
}
func (*UnimplementedClusterServiceServer) DeleteShard(ctx context.Context, req *DeleteClusterShardRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteShard not implemented")
}
func (*UnimplementedClusterServiceServer) ResetupHosts(ctx context.Context, req *ResetupHostsRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetupHosts not implemented")
}
func (*UnimplementedClusterServiceServer) RestartHosts(ctx context.Context, req *RestartHostsRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestartHosts not implemented")
}

func RegisterClusterServiceServer(s *grpc.Server, srv ClusterServiceServer) {
	s.RegisterService(&_ClusterService_serviceDesc, srv)
}

func _ClusterService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mongodb.v1.ClusterService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Get(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mongodb.v1.ClusterService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).List(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mongodb.v1.ClusterService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Create(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mongodb.v1.ClusterService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Update(ctx, req.(*UpdateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mongodb.v1.ClusterService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Delete(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Start_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Start(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mongodb.v1.ClusterService/Start",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Start(ctx, req.(*StartClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Stop_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Stop(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mongodb.v1.ClusterService/Stop",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Stop(ctx, req.(*StopClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Move_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Move(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mongodb.v1.ClusterService/Move",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Move(ctx, req.(*MoveClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Backup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BackupClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Backup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mongodb.v1.ClusterService/Backup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Backup(ctx, req.(*BackupClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Restore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Restore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mongodb.v1.ClusterService/Restore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Restore(ctx, req.(*RestoreClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_ListLogs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClusterLogsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).ListLogs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mongodb.v1.ClusterService/ListLogs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).ListLogs(ctx, req.(*ListClusterLogsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_StreamLogs_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(StreamClusterLogsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ClusterServiceServer).StreamLogs(m, &clusterServiceStreamLogsServer{stream})
}

type ClusterService_StreamLogsServer interface {
	Send(*LogRecord) error
	grpc.ServerStream
}

type clusterServiceStreamLogsServer struct {
	grpc.ServerStream
}

func (x *clusterServiceStreamLogsServer) Send(m *LogRecord) error {
	return x.ServerStream.SendMsg(m)
}

func _ClusterService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClusterOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mongodb.v1.ClusterService/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).ListOperations(ctx, req.(*ListClusterOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_ListBackups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClusterBackupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).ListBackups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mongodb.v1.ClusterService/ListBackups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).ListBackups(ctx, req.(*ListClusterBackupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_ListHosts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClusterHostsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).ListHosts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mongodb.v1.ClusterService/ListHosts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).ListHosts(ctx, req.(*ListClusterHostsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_AddHosts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddClusterHostsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).AddHosts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mongodb.v1.ClusterService/AddHosts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).AddHosts(ctx, req.(*AddClusterHostsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_DeleteHosts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterHostsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).DeleteHosts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mongodb.v1.ClusterService/DeleteHosts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).DeleteHosts(ctx, req.(*DeleteClusterHostsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_EnableSharding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EnableClusterShardingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).EnableSharding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mongodb.v1.ClusterService/EnableSharding",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).EnableSharding(ctx, req.(*EnableClusterShardingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_GetShard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterShardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).GetShard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mongodb.v1.ClusterService/GetShard",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).GetShard(ctx, req.(*GetClusterShardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_ListShards_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClusterShardsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).ListShards(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mongodb.v1.ClusterService/ListShards",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).ListShards(ctx, req.(*ListClusterShardsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_AddShard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddClusterShardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).AddShard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mongodb.v1.ClusterService/AddShard",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).AddShard(ctx, req.(*AddClusterShardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_DeleteShard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterShardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).DeleteShard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mongodb.v1.ClusterService/DeleteShard",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).DeleteShard(ctx, req.(*DeleteClusterShardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_ResetupHosts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetupHostsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).ResetupHosts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mongodb.v1.ClusterService/ResetupHosts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).ResetupHosts(ctx, req.(*ResetupHostsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_RestartHosts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestartHostsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).RestartHosts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mongodb.v1.ClusterService/RestartHosts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).RestartHosts(ctx, req.(*RestartHostsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ClusterService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.mdb.mongodb.v1.ClusterService",
	HandlerType: (*ClusterServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _ClusterService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _ClusterService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _ClusterService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _ClusterService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _ClusterService_Delete_Handler,
		},
		{
			MethodName: "Start",
			Handler:    _ClusterService_Start_Handler,
		},
		{
			MethodName: "Stop",
			Handler:    _ClusterService_Stop_Handler,
		},
		{
			MethodName: "Move",
			Handler:    _ClusterService_Move_Handler,
		},
		{
			MethodName: "Backup",
			Handler:    _ClusterService_Backup_Handler,
		},
		{
			MethodName: "Restore",
			Handler:    _ClusterService_Restore_Handler,
		},
		{
			MethodName: "ListLogs",
			Handler:    _ClusterService_ListLogs_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _ClusterService_ListOperations_Handler,
		},
		{
			MethodName: "ListBackups",
			Handler:    _ClusterService_ListBackups_Handler,
		},
		{
			MethodName: "ListHosts",
			Handler:    _ClusterService_ListHosts_Handler,
		},
		{
			MethodName: "AddHosts",
			Handler:    _ClusterService_AddHosts_Handler,
		},
		{
			MethodName: "DeleteHosts",
			Handler:    _ClusterService_DeleteHosts_Handler,
		},
		{
			MethodName: "EnableSharding",
			Handler:    _ClusterService_EnableSharding_Handler,
		},
		{
			MethodName: "GetShard",
			Handler:    _ClusterService_GetShard_Handler,
		},
		{
			MethodName: "ListShards",
			Handler:    _ClusterService_ListShards_Handler,
		},
		{
			MethodName: "AddShard",
			Handler:    _ClusterService_AddShard_Handler,
		},
		{
			MethodName: "DeleteShard",
			Handler:    _ClusterService_DeleteShard_Handler,
		},
		{
			MethodName: "ResetupHosts",
			Handler:    _ClusterService_ResetupHosts_Handler,
		},
		{
			MethodName: "RestartHosts",
			Handler:    _ClusterService_RestartHosts_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamLogs",
			Handler:       _ClusterService_StreamLogs_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "yandex/cloud/mdb/mongodb/v1/cluster_service.proto",
}
