// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/mdb/mysql/v1/cluster_service.proto

package mysql

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	config "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/mysql/v1/config"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	timeofday "google.golang.org/genproto/googleapis/type/timeofday"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type ListClusterLogsRequest_ServiceType int32

const (
	ListClusterLogsRequest_SERVICE_TYPE_UNSPECIFIED ListClusterLogsRequest_ServiceType = 0
	// MySQL error log.
	ListClusterLogsRequest_MYSQL_ERROR ListClusterLogsRequest_ServiceType = 1
	// MySQL general query log.
	ListClusterLogsRequest_MYSQL_GENERAL ListClusterLogsRequest_ServiceType = 2
	// MySQL slow query log.
	ListClusterLogsRequest_MYSQL_SLOW_QUERY ListClusterLogsRequest_ServiceType = 3
	// MySQL audit log.
	ListClusterLogsRequest_MYSQL_AUDIT ListClusterLogsRequest_ServiceType = 4
)

var ListClusterLogsRequest_ServiceType_name = map[int32]string{
	0: "SERVICE_TYPE_UNSPECIFIED",
	1: "MYSQL_ERROR",
	2: "MYSQL_GENERAL",
	3: "MYSQL_SLOW_QUERY",
	4: "MYSQL_AUDIT",
}

var ListClusterLogsRequest_ServiceType_value = map[string]int32{
	"SERVICE_TYPE_UNSPECIFIED": 0,
	"MYSQL_ERROR":              1,
	"MYSQL_GENERAL":            2,
	"MYSQL_SLOW_QUERY":         3,
	"MYSQL_AUDIT":              4,
}

func (x ListClusterLogsRequest_ServiceType) String() string {
	return proto.EnumName(ListClusterLogsRequest_ServiceType_name, int32(x))
}

func (ListClusterLogsRequest_ServiceType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{16, 0}
}

type StreamClusterLogsRequest_ServiceType int32

const (
	StreamClusterLogsRequest_SERVICE_TYPE_UNSPECIFIED StreamClusterLogsRequest_ServiceType = 0
	// MySQL error log.
	StreamClusterLogsRequest_MYSQL_ERROR StreamClusterLogsRequest_ServiceType = 1
	// MySQL general query log.
	StreamClusterLogsRequest_MYSQL_GENERAL StreamClusterLogsRequest_ServiceType = 2
	// MySQL slow query log.
	StreamClusterLogsRequest_MYSQL_SLOW_QUERY StreamClusterLogsRequest_ServiceType = 3
	// MySQL audit log.
	StreamClusterLogsRequest_MYSQL_AUDIT StreamClusterLogsRequest_ServiceType = 4
)

var StreamClusterLogsRequest_ServiceType_name = map[int32]string{
	0: "SERVICE_TYPE_UNSPECIFIED",
	1: "MYSQL_ERROR",
	2: "MYSQL_GENERAL",
	3: "MYSQL_SLOW_QUERY",
	4: "MYSQL_AUDIT",
}

var StreamClusterLogsRequest_ServiceType_value = map[string]int32{
	"SERVICE_TYPE_UNSPECIFIED": 0,
	"MYSQL_ERROR":              1,
	"MYSQL_GENERAL":            2,
	"MYSQL_SLOW_QUERY":         3,
	"MYSQL_AUDIT":              4,
}

func (x StreamClusterLogsRequest_ServiceType) String() string {
	return proto.EnumName(StreamClusterLogsRequest_ServiceType_name, int32(x))
}

func (StreamClusterLogsRequest_ServiceType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{18, 0}
}

type GetClusterRequest struct {
	// ID of the MySQL cluster to return.
	// To get the cluster ID use a [ClusterService.List] request.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetClusterRequest) Reset()         { *m = GetClusterRequest{} }
func (m *GetClusterRequest) String() string { return proto.CompactTextString(m) }
func (*GetClusterRequest) ProtoMessage()    {}
func (*GetClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{0}
}

func (m *GetClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetClusterRequest.Unmarshal(m, b)
}
func (m *GetClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetClusterRequest.Marshal(b, m, deterministic)
}
func (m *GetClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetClusterRequest.Merge(m, src)
}
func (m *GetClusterRequest) XXX_Size() int {
	return xxx_messageInfo_GetClusterRequest.Size(m)
}
func (m *GetClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetClusterRequest proto.InternalMessageInfo

func (m *GetClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type ListClustersRequest struct {
	// ID of the folder to list MySQL clusters in.
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListClustersResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the [ListClustersResponse.next_page_token]
	// returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// The expression must specify:
	// 1. The field name. Currently you can only use filtering with the [Cluster.name] field.
	// 2. An operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.
	// 3. The value. Мust be 1-63 characters long and match the regular expression `^[a-zA-Z0-9_-]+$`.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClustersRequest) Reset()         { *m = ListClustersRequest{} }
func (m *ListClustersRequest) String() string { return proto.CompactTextString(m) }
func (*ListClustersRequest) ProtoMessage()    {}
func (*ListClustersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{1}
}

func (m *ListClustersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClustersRequest.Unmarshal(m, b)
}
func (m *ListClustersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClustersRequest.Marshal(b, m, deterministic)
}
func (m *ListClustersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClustersRequest.Merge(m, src)
}
func (m *ListClustersRequest) XXX_Size() int {
	return xxx_messageInfo_ListClustersRequest.Size(m)
}
func (m *ListClustersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClustersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClustersRequest proto.InternalMessageInfo

func (m *ListClustersRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *ListClustersRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClustersRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListClustersRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListClustersResponse struct {
	// List of MySQL clusters.
	Clusters []*Cluster `protobuf:"bytes,1,rep,name=clusters,proto3" json:"clusters,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListClustersRequest.page_size], use the [next_page_token] as the value
	// for the [ListClustersRequest.page_token] parameter in the next list request. Each subsequent
	// list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClustersResponse) Reset()         { *m = ListClustersResponse{} }
func (m *ListClustersResponse) String() string { return proto.CompactTextString(m) }
func (*ListClustersResponse) ProtoMessage()    {}
func (*ListClustersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{2}
}

func (m *ListClustersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClustersResponse.Unmarshal(m, b)
}
func (m *ListClustersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClustersResponse.Marshal(b, m, deterministic)
}
func (m *ListClustersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClustersResponse.Merge(m, src)
}
func (m *ListClustersResponse) XXX_Size() int {
	return xxx_messageInfo_ListClustersResponse.Size(m)
}
func (m *ListClustersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClustersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClustersResponse proto.InternalMessageInfo

func (m *ListClustersResponse) GetClusters() []*Cluster {
	if m != nil {
		return m.Clusters
	}
	return nil
}

func (m *ListClustersResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateClusterRequest struct {
	// ID of the folder to create the MySQL cluster in.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the MySQL cluster. The name must be unique within the folder.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the MySQL cluster.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the MySQL cluster as `key:value` pairs. Maximum 64 per resource.
	// For example, "project": "mvp" or "source": "dictionary".
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Deployment environment of the MySQL cluster.
	Environment Cluster_Environment `protobuf:"varint,5,opt,name=environment,proto3,enum=yandex.cloud.mdb.mysql.v1.Cluster_Environment" json:"environment,omitempty"`
	// Configuration and resources for hosts that should be created for the MySQL cluster.
	ConfigSpec *ConfigSpec `protobuf:"bytes,6,opt,name=config_spec,json=configSpec,proto3" json:"config_spec,omitempty"`
	// Descriptions of databases to be created in the MySQL cluster.
	DatabaseSpecs []*DatabaseSpec `protobuf:"bytes,7,rep,name=database_specs,json=databaseSpecs,proto3" json:"database_specs,omitempty"`
	// Descriptions of database users to be created in the MySQL cluster.
	UserSpecs []*UserSpec `protobuf:"bytes,8,rep,name=user_specs,json=userSpecs,proto3" json:"user_specs,omitempty"`
	// Individual configurations for hosts that should be created for the MySQL cluster.
	HostSpecs []*HostSpec `protobuf:"bytes,9,rep,name=host_specs,json=hostSpecs,proto3" json:"host_specs,omitempty"`
	// ID of the network to create the cluster in.
	NetworkId            string   `protobuf:"bytes,10,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateClusterRequest) Reset()         { *m = CreateClusterRequest{} }
func (m *CreateClusterRequest) String() string { return proto.CompactTextString(m) }
func (*CreateClusterRequest) ProtoMessage()    {}
func (*CreateClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{3}
}

func (m *CreateClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateClusterRequest.Unmarshal(m, b)
}
func (m *CreateClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateClusterRequest.Marshal(b, m, deterministic)
}
func (m *CreateClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateClusterRequest.Merge(m, src)
}
func (m *CreateClusterRequest) XXX_Size() int {
	return xxx_messageInfo_CreateClusterRequest.Size(m)
}
func (m *CreateClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateClusterRequest proto.InternalMessageInfo

func (m *CreateClusterRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *CreateClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateClusterRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *CreateClusterRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *CreateClusterRequest) GetEnvironment() Cluster_Environment {
	if m != nil {
		return m.Environment
	}
	return Cluster_ENVIRONMENT_UNSPECIFIED
}

func (m *CreateClusterRequest) GetConfigSpec() *ConfigSpec {
	if m != nil {
		return m.ConfigSpec
	}
	return nil
}

func (m *CreateClusterRequest) GetDatabaseSpecs() []*DatabaseSpec {
	if m != nil {
		return m.DatabaseSpecs
	}
	return nil
}

func (m *CreateClusterRequest) GetUserSpecs() []*UserSpec {
	if m != nil {
		return m.UserSpecs
	}
	return nil
}

func (m *CreateClusterRequest) GetHostSpecs() []*HostSpec {
	if m != nil {
		return m.HostSpecs
	}
	return nil
}

func (m *CreateClusterRequest) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

type CreateClusterMetadata struct {
	// ID of the MySQL cluster that is being created.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateClusterMetadata) Reset()         { *m = CreateClusterMetadata{} }
func (m *CreateClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateClusterMetadata) ProtoMessage()    {}
func (*CreateClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{4}
}

func (m *CreateClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateClusterMetadata.Unmarshal(m, b)
}
func (m *CreateClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateClusterMetadata.Marshal(b, m, deterministic)
}
func (m *CreateClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateClusterMetadata.Merge(m, src)
}
func (m *CreateClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateClusterMetadata.Size(m)
}
func (m *CreateClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateClusterMetadata proto.InternalMessageInfo

func (m *CreateClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type UpdateClusterRequest struct {
	// ID of the MySQL cluster to update.
	// To get the MySQL cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Field mask that specifies which fields of the MySQL cluster should be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// New description of the MySQL cluster.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the MySQL cluster as `key:value` pairs. Maximum 64 per resource.
	// For example, "project": "mvp" or "source": "dictionary".
	//
	// The new set of labels will completely replace the old ones. To add a label, request the current
	// set with the [ClusterService.Get] method, then send an [ClusterService.Update] request with the new label added to the set.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// New configuration and resources for hosts in the cluster.
	ConfigSpec *ConfigSpec `protobuf:"bytes,5,opt,name=config_spec,json=configSpec,proto3" json:"config_spec,omitempty"`
	// New name for the cluster.
	Name                 string   `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateClusterRequest) Reset()         { *m = UpdateClusterRequest{} }
func (m *UpdateClusterRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateClusterRequest) ProtoMessage()    {}
func (*UpdateClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{5}
}

func (m *UpdateClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateClusterRequest.Unmarshal(m, b)
}
func (m *UpdateClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateClusterRequest.Marshal(b, m, deterministic)
}
func (m *UpdateClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateClusterRequest.Merge(m, src)
}
func (m *UpdateClusterRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateClusterRequest.Size(m)
}
func (m *UpdateClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateClusterRequest proto.InternalMessageInfo

func (m *UpdateClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *UpdateClusterRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateClusterRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *UpdateClusterRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *UpdateClusterRequest) GetConfigSpec() *ConfigSpec {
	if m != nil {
		return m.ConfigSpec
	}
	return nil
}

func (m *UpdateClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type UpdateClusterMetadata struct {
	// ID of the MySQL cluster that is being modified.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateClusterMetadata) Reset()         { *m = UpdateClusterMetadata{} }
func (m *UpdateClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateClusterMetadata) ProtoMessage()    {}
func (*UpdateClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{6}
}

func (m *UpdateClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateClusterMetadata.Unmarshal(m, b)
}
func (m *UpdateClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateClusterMetadata.Marshal(b, m, deterministic)
}
func (m *UpdateClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateClusterMetadata.Merge(m, src)
}
func (m *UpdateClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateClusterMetadata.Size(m)
}
func (m *UpdateClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateClusterMetadata proto.InternalMessageInfo

func (m *UpdateClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type DeleteClusterRequest struct {
	// ID of the MySQL cluster to delete.
	// To get the MySQL cluster ID, use a [ClusterService.List] request.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClusterRequest) Reset()         { *m = DeleteClusterRequest{} }
func (m *DeleteClusterRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteClusterRequest) ProtoMessage()    {}
func (*DeleteClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{7}
}

func (m *DeleteClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClusterRequest.Unmarshal(m, b)
}
func (m *DeleteClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClusterRequest.Marshal(b, m, deterministic)
}
func (m *DeleteClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClusterRequest.Merge(m, src)
}
func (m *DeleteClusterRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteClusterRequest.Size(m)
}
func (m *DeleteClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClusterRequest proto.InternalMessageInfo

func (m *DeleteClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type DeleteClusterMetadata struct {
	// ID of the MySQL cluster that is being deleted.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClusterMetadata) Reset()         { *m = DeleteClusterMetadata{} }
func (m *DeleteClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteClusterMetadata) ProtoMessage()    {}
func (*DeleteClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{8}
}

func (m *DeleteClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClusterMetadata.Unmarshal(m, b)
}
func (m *DeleteClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClusterMetadata.Marshal(b, m, deterministic)
}
func (m *DeleteClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClusterMetadata.Merge(m, src)
}
func (m *DeleteClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteClusterMetadata.Size(m)
}
func (m *DeleteClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClusterMetadata proto.InternalMessageInfo

func (m *DeleteClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type BackupClusterRequest struct {
	// ID of the MySQL cluster to back up.
	// To get the MySQL cluster ID, use a [ClusterService.List] request.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BackupClusterRequest) Reset()         { *m = BackupClusterRequest{} }
func (m *BackupClusterRequest) String() string { return proto.CompactTextString(m) }
func (*BackupClusterRequest) ProtoMessage()    {}
func (*BackupClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{9}
}

func (m *BackupClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BackupClusterRequest.Unmarshal(m, b)
}
func (m *BackupClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BackupClusterRequest.Marshal(b, m, deterministic)
}
func (m *BackupClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BackupClusterRequest.Merge(m, src)
}
func (m *BackupClusterRequest) XXX_Size() int {
	return xxx_messageInfo_BackupClusterRequest.Size(m)
}
func (m *BackupClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BackupClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BackupClusterRequest proto.InternalMessageInfo

func (m *BackupClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type BackupClusterMetadata struct {
	// ID of the MySQL cluster that is being backed up.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BackupClusterMetadata) Reset()         { *m = BackupClusterMetadata{} }
func (m *BackupClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*BackupClusterMetadata) ProtoMessage()    {}
func (*BackupClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{10}
}

func (m *BackupClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BackupClusterMetadata.Unmarshal(m, b)
}
func (m *BackupClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BackupClusterMetadata.Marshal(b, m, deterministic)
}
func (m *BackupClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BackupClusterMetadata.Merge(m, src)
}
func (m *BackupClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_BackupClusterMetadata.Size(m)
}
func (m *BackupClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_BackupClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_BackupClusterMetadata proto.InternalMessageInfo

func (m *BackupClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type RestoreClusterRequest struct {
	// ID of the backup to create a cluster from.
	// To get the backup ID, use a [ClusterService.ListBackups] request.
	BackupId string `protobuf:"bytes,1,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
	// Timestamp of the moment to which the MySQL cluster should be restored.
	Time *timestamp.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	// Name of the new MySQL cluster. The name must be unique within the folder.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the new MySQL cluster.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the MySQL cluster as `key:value` pairs. Maximum 64 per resource.
	// For example, "project": "mvp" or "source": "dictionary".
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Deployment environment of the new MySQL cluster.
	Environment Cluster_Environment `protobuf:"varint,7,opt,name=environment,proto3,enum=yandex.cloud.mdb.mysql.v1.Cluster_Environment" json:"environment,omitempty"`
	// Configuration for the MySQL cluster to be created.
	ConfigSpec *ConfigSpec `protobuf:"bytes,8,opt,name=config_spec,json=configSpec,proto3" json:"config_spec,omitempty"`
	// Configurations for MySQL hosts that should be added
	// to the cluster that is being created from the backup.
	HostSpecs []*HostSpec `protobuf:"bytes,9,rep,name=host_specs,json=hostSpecs,proto3" json:"host_specs,omitempty"`
	// ID of the network to create the MySQL cluster in.
	NetworkId string `protobuf:"bytes,10,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// ID of the folder to create the MySQL cluster in.
	FolderId             string   `protobuf:"bytes,11,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RestoreClusterRequest) Reset()         { *m = RestoreClusterRequest{} }
func (m *RestoreClusterRequest) String() string { return proto.CompactTextString(m) }
func (*RestoreClusterRequest) ProtoMessage()    {}
func (*RestoreClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{11}
}

func (m *RestoreClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RestoreClusterRequest.Unmarshal(m, b)
}
func (m *RestoreClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RestoreClusterRequest.Marshal(b, m, deterministic)
}
func (m *RestoreClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RestoreClusterRequest.Merge(m, src)
}
func (m *RestoreClusterRequest) XXX_Size() int {
	return xxx_messageInfo_RestoreClusterRequest.Size(m)
}
func (m *RestoreClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RestoreClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RestoreClusterRequest proto.InternalMessageInfo

func (m *RestoreClusterRequest) GetBackupId() string {
	if m != nil {
		return m.BackupId
	}
	return ""
}

func (m *RestoreClusterRequest) GetTime() *timestamp.Timestamp {
	if m != nil {
		return m.Time
	}
	return nil
}

func (m *RestoreClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *RestoreClusterRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *RestoreClusterRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *RestoreClusterRequest) GetEnvironment() Cluster_Environment {
	if m != nil {
		return m.Environment
	}
	return Cluster_ENVIRONMENT_UNSPECIFIED
}

func (m *RestoreClusterRequest) GetConfigSpec() *ConfigSpec {
	if m != nil {
		return m.ConfigSpec
	}
	return nil
}

func (m *RestoreClusterRequest) GetHostSpecs() []*HostSpec {
	if m != nil {
		return m.HostSpecs
	}
	return nil
}

func (m *RestoreClusterRequest) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

func (m *RestoreClusterRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

type RestoreClusterMetadata struct {
	// ID of the new MySQL cluster that is being created from a backup.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the backup that is being used for creating a cluster.
	BackupId             string   `protobuf:"bytes,2,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RestoreClusterMetadata) Reset()         { *m = RestoreClusterMetadata{} }
func (m *RestoreClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*RestoreClusterMetadata) ProtoMessage()    {}
func (*RestoreClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{12}
}

func (m *RestoreClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RestoreClusterMetadata.Unmarshal(m, b)
}
func (m *RestoreClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RestoreClusterMetadata.Marshal(b, m, deterministic)
}
func (m *RestoreClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RestoreClusterMetadata.Merge(m, src)
}
func (m *RestoreClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_RestoreClusterMetadata.Size(m)
}
func (m *RestoreClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_RestoreClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_RestoreClusterMetadata proto.InternalMessageInfo

func (m *RestoreClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *RestoreClusterMetadata) GetBackupId() string {
	if m != nil {
		return m.BackupId
	}
	return ""
}

type StartClusterFailoverRequest struct {
	// ID of MySQL cluster.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// New master host. Switch to the most up-to-date replica if not provided.
	HostName             string   `protobuf:"bytes,2,opt,name=host_name,json=hostName,proto3" json:"host_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartClusterFailoverRequest) Reset()         { *m = StartClusterFailoverRequest{} }
func (m *StartClusterFailoverRequest) String() string { return proto.CompactTextString(m) }
func (*StartClusterFailoverRequest) ProtoMessage()    {}
func (*StartClusterFailoverRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{13}
}

func (m *StartClusterFailoverRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartClusterFailoverRequest.Unmarshal(m, b)
}
func (m *StartClusterFailoverRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartClusterFailoverRequest.Marshal(b, m, deterministic)
}
func (m *StartClusterFailoverRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartClusterFailoverRequest.Merge(m, src)
}
func (m *StartClusterFailoverRequest) XXX_Size() int {
	return xxx_messageInfo_StartClusterFailoverRequest.Size(m)
}
func (m *StartClusterFailoverRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StartClusterFailoverRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StartClusterFailoverRequest proto.InternalMessageInfo

func (m *StartClusterFailoverRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *StartClusterFailoverRequest) GetHostName() string {
	if m != nil {
		return m.HostName
	}
	return ""
}

type StartClusterFailoverMetadata struct {
	// ID of the MySQL cluster being failovered.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartClusterFailoverMetadata) Reset()         { *m = StartClusterFailoverMetadata{} }
func (m *StartClusterFailoverMetadata) String() string { return proto.CompactTextString(m) }
func (*StartClusterFailoverMetadata) ProtoMessage()    {}
func (*StartClusterFailoverMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{14}
}

func (m *StartClusterFailoverMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartClusterFailoverMetadata.Unmarshal(m, b)
}
func (m *StartClusterFailoverMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartClusterFailoverMetadata.Marshal(b, m, deterministic)
}
func (m *StartClusterFailoverMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartClusterFailoverMetadata.Merge(m, src)
}
func (m *StartClusterFailoverMetadata) XXX_Size() int {
	return xxx_messageInfo_StartClusterFailoverMetadata.Size(m)
}
func (m *StartClusterFailoverMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_StartClusterFailoverMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_StartClusterFailoverMetadata proto.InternalMessageInfo

func (m *StartClusterFailoverMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type LogRecord struct {
	// Log record timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	Timestamp *timestamp.Timestamp `protobuf:"bytes,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Contents of the log record.
	Message              map[string]string `protobuf:"bytes,2,rep,name=message,proto3" json:"message,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *LogRecord) Reset()         { *m = LogRecord{} }
func (m *LogRecord) String() string { return proto.CompactTextString(m) }
func (*LogRecord) ProtoMessage()    {}
func (*LogRecord) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{15}
}

func (m *LogRecord) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogRecord.Unmarshal(m, b)
}
func (m *LogRecord) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogRecord.Marshal(b, m, deterministic)
}
func (m *LogRecord) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogRecord.Merge(m, src)
}
func (m *LogRecord) XXX_Size() int {
	return xxx_messageInfo_LogRecord.Size(m)
}
func (m *LogRecord) XXX_DiscardUnknown() {
	xxx_messageInfo_LogRecord.DiscardUnknown(m)
}

var xxx_messageInfo_LogRecord proto.InternalMessageInfo

func (m *LogRecord) GetTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *LogRecord) GetMessage() map[string]string {
	if m != nil {
		return m.Message
	}
	return nil
}

type ListClusterLogsRequest struct {
	// ID of the MySQL cluster to request logs for.
	// To get the MySQL cluster ID use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Columns from the logs table to request.
	// If no columns are specified, entire log records are returned.
	ColumnFilter []string `protobuf:"bytes,2,rep,name=column_filter,json=columnFilter,proto3" json:"column_filter,omitempty"`
	// Type of the service to request logs about.
	ServiceType ListClusterLogsRequest_ServiceType `protobuf:"varint,3,opt,name=service_type,json=serviceType,proto3,enum=yandex.cloud.mdb.mysql.v1.ListClusterLogsRequest_ServiceType" json:"service_type,omitempty"`
	// Start timestamp for the logs request.
	FromTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=from_time,json=fromTime,proto3" json:"from_time,omitempty"`
	// End timestamp for the logs request.
	ToTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=to_time,json=toTime,proto3" json:"to_time,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListClusterLogsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,6,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListClusterLogsResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,7,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Always return `next_page_token`, even if current page is empty.
	AlwaysNextPageToken  bool     `protobuf:"varint,8,opt,name=always_next_page_token,json=alwaysNextPageToken,proto3" json:"always_next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterLogsRequest) Reset()         { *m = ListClusterLogsRequest{} }
func (m *ListClusterLogsRequest) String() string { return proto.CompactTextString(m) }
func (*ListClusterLogsRequest) ProtoMessage()    {}
func (*ListClusterLogsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{16}
}

func (m *ListClusterLogsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterLogsRequest.Unmarshal(m, b)
}
func (m *ListClusterLogsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterLogsRequest.Marshal(b, m, deterministic)
}
func (m *ListClusterLogsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterLogsRequest.Merge(m, src)
}
func (m *ListClusterLogsRequest) XXX_Size() int {
	return xxx_messageInfo_ListClusterLogsRequest.Size(m)
}
func (m *ListClusterLogsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterLogsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterLogsRequest proto.InternalMessageInfo

func (m *ListClusterLogsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListClusterLogsRequest) GetColumnFilter() []string {
	if m != nil {
		return m.ColumnFilter
	}
	return nil
}

func (m *ListClusterLogsRequest) GetServiceType() ListClusterLogsRequest_ServiceType {
	if m != nil {
		return m.ServiceType
	}
	return ListClusterLogsRequest_SERVICE_TYPE_UNSPECIFIED
}

func (m *ListClusterLogsRequest) GetFromTime() *timestamp.Timestamp {
	if m != nil {
		return m.FromTime
	}
	return nil
}

func (m *ListClusterLogsRequest) GetToTime() *timestamp.Timestamp {
	if m != nil {
		return m.ToTime
	}
	return nil
}

func (m *ListClusterLogsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClusterLogsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListClusterLogsRequest) GetAlwaysNextPageToken() bool {
	if m != nil {
		return m.AlwaysNextPageToken
	}
	return false
}

type ListClusterLogsResponse struct {
	// Requested log records.
	Logs []*LogRecord `protobuf:"bytes,1,rep,name=logs,proto3" json:"logs,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListClusterLogsRequest.page_size], use the [next_page_token] as the value
	// for the [ListClusterLogsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterLogsResponse) Reset()         { *m = ListClusterLogsResponse{} }
func (m *ListClusterLogsResponse) String() string { return proto.CompactTextString(m) }
func (*ListClusterLogsResponse) ProtoMessage()    {}
func (*ListClusterLogsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{17}
}

func (m *ListClusterLogsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterLogsResponse.Unmarshal(m, b)
}
func (m *ListClusterLogsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterLogsResponse.Marshal(b, m, deterministic)
}
func (m *ListClusterLogsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterLogsResponse.Merge(m, src)
}
func (m *ListClusterLogsResponse) XXX_Size() int {
	return xxx_messageInfo_ListClusterLogsResponse.Size(m)
}
func (m *ListClusterLogsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterLogsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterLogsResponse proto.InternalMessageInfo

func (m *ListClusterLogsResponse) GetLogs() []*LogRecord {
	if m != nil {
		return m.Logs
	}
	return nil
}

func (m *ListClusterLogsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type StreamClusterLogsRequest struct {
	// Required. ID of the MySQL cluster.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Columns from logs table to get in the response.
	ColumnFilter []string                             `protobuf:"bytes,2,rep,name=column_filter,json=columnFilter,proto3" json:"column_filter,omitempty"`
	ServiceType  StreamClusterLogsRequest_ServiceType `protobuf:"varint,3,opt,name=service_type,json=serviceType,proto3,enum=yandex.cloud.mdb.mysql.v1.StreamClusterLogsRequest_ServiceType" json:"service_type,omitempty"`
	// Start timestamp for the logs request.
	FromTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=from_time,json=fromTime,proto3" json:"from_time,omitempty"`
	// End timestamp for the logs request.
	// If this field is not set, all existing logs will be sent and then the new ones as
	// they appear. In essence it has 'tail -f' semantics.
	ToTime               *timestamp.Timestamp `protobuf:"bytes,5,opt,name=to_time,json=toTime,proto3" json:"to_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *StreamClusterLogsRequest) Reset()         { *m = StreamClusterLogsRequest{} }
func (m *StreamClusterLogsRequest) String() string { return proto.CompactTextString(m) }
func (*StreamClusterLogsRequest) ProtoMessage()    {}
func (*StreamClusterLogsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{18}
}

func (m *StreamClusterLogsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamClusterLogsRequest.Unmarshal(m, b)
}
func (m *StreamClusterLogsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamClusterLogsRequest.Marshal(b, m, deterministic)
}
func (m *StreamClusterLogsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamClusterLogsRequest.Merge(m, src)
}
func (m *StreamClusterLogsRequest) XXX_Size() int {
	return xxx_messageInfo_StreamClusterLogsRequest.Size(m)
}
func (m *StreamClusterLogsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamClusterLogsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamClusterLogsRequest proto.InternalMessageInfo

func (m *StreamClusterLogsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *StreamClusterLogsRequest) GetColumnFilter() []string {
	if m != nil {
		return m.ColumnFilter
	}
	return nil
}

func (m *StreamClusterLogsRequest) GetServiceType() StreamClusterLogsRequest_ServiceType {
	if m != nil {
		return m.ServiceType
	}
	return StreamClusterLogsRequest_SERVICE_TYPE_UNSPECIFIED
}

func (m *StreamClusterLogsRequest) GetFromTime() *timestamp.Timestamp {
	if m != nil {
		return m.FromTime
	}
	return nil
}

func (m *StreamClusterLogsRequest) GetToTime() *timestamp.Timestamp {
	if m != nil {
		return m.ToTime
	}
	return nil
}

type ListClusterOperationsRequest struct {
	// ID of the MySQL cluster to list operations for.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListClusterOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token.  To get the next page of results, set [page_token] to the [ListClusterOperationsResponse.next_page_token]
	// returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterOperationsRequest) Reset()         { *m = ListClusterOperationsRequest{} }
func (m *ListClusterOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListClusterOperationsRequest) ProtoMessage()    {}
func (*ListClusterOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{19}
}

func (m *ListClusterOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterOperationsRequest.Unmarshal(m, b)
}
func (m *ListClusterOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterOperationsRequest.Marshal(b, m, deterministic)
}
func (m *ListClusterOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterOperationsRequest.Merge(m, src)
}
func (m *ListClusterOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListClusterOperationsRequest.Size(m)
}
func (m *ListClusterOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterOperationsRequest proto.InternalMessageInfo

func (m *ListClusterOperationsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListClusterOperationsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClusterOperationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListClusterOperationsResponse struct {
	// List of operations for the specified MySQL cluster.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListClusterOperationsRequest.page_size], use the [next_page_token] as the value
	// for the [ListClusterOperationsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterOperationsResponse) Reset()         { *m = ListClusterOperationsResponse{} }
func (m *ListClusterOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListClusterOperationsResponse) ProtoMessage()    {}
func (*ListClusterOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{20}
}

func (m *ListClusterOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterOperationsResponse.Unmarshal(m, b)
}
func (m *ListClusterOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterOperationsResponse.Marshal(b, m, deterministic)
}
func (m *ListClusterOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterOperationsResponse.Merge(m, src)
}
func (m *ListClusterOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListClusterOperationsResponse.Size(m)
}
func (m *ListClusterOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterOperationsResponse proto.InternalMessageInfo

func (m *ListClusterOperationsResponse) GetOperations() []*operation.Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListClusterOperationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type ListClusterBackupsRequest struct {
	// ID of the MySQL cluster.
	// To get the MySQL cluster ID use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListClusterBackupsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token.  To get the next page of results, set [page_token] to the [ListClusterBackupsResponse.next_page_token]
	// returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterBackupsRequest) Reset()         { *m = ListClusterBackupsRequest{} }
func (m *ListClusterBackupsRequest) String() string { return proto.CompactTextString(m) }
func (*ListClusterBackupsRequest) ProtoMessage()    {}
func (*ListClusterBackupsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{21}
}

func (m *ListClusterBackupsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterBackupsRequest.Unmarshal(m, b)
}
func (m *ListClusterBackupsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterBackupsRequest.Marshal(b, m, deterministic)
}
func (m *ListClusterBackupsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterBackupsRequest.Merge(m, src)
}
func (m *ListClusterBackupsRequest) XXX_Size() int {
	return xxx_messageInfo_ListClusterBackupsRequest.Size(m)
}
func (m *ListClusterBackupsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterBackupsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterBackupsRequest proto.InternalMessageInfo

func (m *ListClusterBackupsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListClusterBackupsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClusterBackupsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListClusterBackupsResponse struct {
	// List of MySQL backups.
	Backups []*Backup `protobuf:"bytes,1,rep,name=backups,proto3" json:"backups,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListClusterBackupsRequest.page_size], use the [next_page_token] as the value
	// for the [ListClusterBackupsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterBackupsResponse) Reset()         { *m = ListClusterBackupsResponse{} }
func (m *ListClusterBackupsResponse) String() string { return proto.CompactTextString(m) }
func (*ListClusterBackupsResponse) ProtoMessage()    {}
func (*ListClusterBackupsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{22}
}

func (m *ListClusterBackupsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterBackupsResponse.Unmarshal(m, b)
}
func (m *ListClusterBackupsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterBackupsResponse.Marshal(b, m, deterministic)
}
func (m *ListClusterBackupsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterBackupsResponse.Merge(m, src)
}
func (m *ListClusterBackupsResponse) XXX_Size() int {
	return xxx_messageInfo_ListClusterBackupsResponse.Size(m)
}
func (m *ListClusterBackupsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterBackupsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterBackupsResponse proto.InternalMessageInfo

func (m *ListClusterBackupsResponse) GetBackups() []*Backup {
	if m != nil {
		return m.Backups
	}
	return nil
}

func (m *ListClusterBackupsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type ListClusterHostsRequest struct {
	// ID of the MySQL cluster.
	// To get the MySQL cluster ID use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListClusterHostsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token.  To get the next page of results, set [page_token] to the [ListClusterHostsResponse.next_page_token]
	// returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterHostsRequest) Reset()         { *m = ListClusterHostsRequest{} }
func (m *ListClusterHostsRequest) String() string { return proto.CompactTextString(m) }
func (*ListClusterHostsRequest) ProtoMessage()    {}
func (*ListClusterHostsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{23}
}

func (m *ListClusterHostsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterHostsRequest.Unmarshal(m, b)
}
func (m *ListClusterHostsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterHostsRequest.Marshal(b, m, deterministic)
}
func (m *ListClusterHostsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterHostsRequest.Merge(m, src)
}
func (m *ListClusterHostsRequest) XXX_Size() int {
	return xxx_messageInfo_ListClusterHostsRequest.Size(m)
}
func (m *ListClusterHostsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterHostsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterHostsRequest proto.InternalMessageInfo

func (m *ListClusterHostsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListClusterHostsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClusterHostsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListClusterHostsResponse struct {
	// List of MySQL hosts.
	Hosts []*Host `protobuf:"bytes,1,rep,name=hosts,proto3" json:"hosts,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListClusterHostsRequest.page_size], use the [next_page_token] as the value
	// for the [ListClusterHostsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterHostsResponse) Reset()         { *m = ListClusterHostsResponse{} }
func (m *ListClusterHostsResponse) String() string { return proto.CompactTextString(m) }
func (*ListClusterHostsResponse) ProtoMessage()    {}
func (*ListClusterHostsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{24}
}

func (m *ListClusterHostsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterHostsResponse.Unmarshal(m, b)
}
func (m *ListClusterHostsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterHostsResponse.Marshal(b, m, deterministic)
}
func (m *ListClusterHostsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterHostsResponse.Merge(m, src)
}
func (m *ListClusterHostsResponse) XXX_Size() int {
	return xxx_messageInfo_ListClusterHostsResponse.Size(m)
}
func (m *ListClusterHostsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterHostsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterHostsResponse proto.InternalMessageInfo

func (m *ListClusterHostsResponse) GetHosts() []*Host {
	if m != nil {
		return m.Hosts
	}
	return nil
}

func (m *ListClusterHostsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type AddClusterHostsRequest struct {
	// ID of the MySQL cluster to add hosts to.
	// To get the MySQL cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Configurations for MySQL hosts that should be added to the cluster.
	HostSpecs            []*HostSpec `protobuf:"bytes,2,rep,name=host_specs,json=hostSpecs,proto3" json:"host_specs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *AddClusterHostsRequest) Reset()         { *m = AddClusterHostsRequest{} }
func (m *AddClusterHostsRequest) String() string { return proto.CompactTextString(m) }
func (*AddClusterHostsRequest) ProtoMessage()    {}
func (*AddClusterHostsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{25}
}

func (m *AddClusterHostsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddClusterHostsRequest.Unmarshal(m, b)
}
func (m *AddClusterHostsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddClusterHostsRequest.Marshal(b, m, deterministic)
}
func (m *AddClusterHostsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddClusterHostsRequest.Merge(m, src)
}
func (m *AddClusterHostsRequest) XXX_Size() int {
	return xxx_messageInfo_AddClusterHostsRequest.Size(m)
}
func (m *AddClusterHostsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddClusterHostsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddClusterHostsRequest proto.InternalMessageInfo

func (m *AddClusterHostsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *AddClusterHostsRequest) GetHostSpecs() []*HostSpec {
	if m != nil {
		return m.HostSpecs
	}
	return nil
}

type AddClusterHostsMetadata struct {
	// ID of the MySQL cluster to which the hosts are being added.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Names of hosts that are being added to the cluster.
	HostNames            []string `protobuf:"bytes,2,rep,name=host_names,json=hostNames,proto3" json:"host_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AddClusterHostsMetadata) Reset()         { *m = AddClusterHostsMetadata{} }
func (m *AddClusterHostsMetadata) String() string { return proto.CompactTextString(m) }
func (*AddClusterHostsMetadata) ProtoMessage()    {}
func (*AddClusterHostsMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{26}
}

func (m *AddClusterHostsMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddClusterHostsMetadata.Unmarshal(m, b)
}
func (m *AddClusterHostsMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddClusterHostsMetadata.Marshal(b, m, deterministic)
}
func (m *AddClusterHostsMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddClusterHostsMetadata.Merge(m, src)
}
func (m *AddClusterHostsMetadata) XXX_Size() int {
	return xxx_messageInfo_AddClusterHostsMetadata.Size(m)
}
func (m *AddClusterHostsMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_AddClusterHostsMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_AddClusterHostsMetadata proto.InternalMessageInfo

func (m *AddClusterHostsMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *AddClusterHostsMetadata) GetHostNames() []string {
	if m != nil {
		return m.HostNames
	}
	return nil
}

type DeleteClusterHostsRequest struct {
	// ID of the MySQL cluster to remove hosts from.
	// To get the MySQL cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Names of hosts to delete.
	HostNames            []string `protobuf:"bytes,2,rep,name=host_names,json=hostNames,proto3" json:"host_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClusterHostsRequest) Reset()         { *m = DeleteClusterHostsRequest{} }
func (m *DeleteClusterHostsRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteClusterHostsRequest) ProtoMessage()    {}
func (*DeleteClusterHostsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{27}
}

func (m *DeleteClusterHostsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClusterHostsRequest.Unmarshal(m, b)
}
func (m *DeleteClusterHostsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClusterHostsRequest.Marshal(b, m, deterministic)
}
func (m *DeleteClusterHostsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClusterHostsRequest.Merge(m, src)
}
func (m *DeleteClusterHostsRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteClusterHostsRequest.Size(m)
}
func (m *DeleteClusterHostsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClusterHostsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClusterHostsRequest proto.InternalMessageInfo

func (m *DeleteClusterHostsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *DeleteClusterHostsRequest) GetHostNames() []string {
	if m != nil {
		return m.HostNames
	}
	return nil
}

type DeleteClusterHostsMetadata struct {
	// ID of the MySQL cluster to remove hosts from.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Names of hosts that are being deleted.
	HostNames            []string `protobuf:"bytes,2,rep,name=host_names,json=hostNames,proto3" json:"host_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClusterHostsMetadata) Reset()         { *m = DeleteClusterHostsMetadata{} }
func (m *DeleteClusterHostsMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteClusterHostsMetadata) ProtoMessage()    {}
func (*DeleteClusterHostsMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{28}
}

func (m *DeleteClusterHostsMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClusterHostsMetadata.Unmarshal(m, b)
}
func (m *DeleteClusterHostsMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClusterHostsMetadata.Marshal(b, m, deterministic)
}
func (m *DeleteClusterHostsMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClusterHostsMetadata.Merge(m, src)
}
func (m *DeleteClusterHostsMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteClusterHostsMetadata.Size(m)
}
func (m *DeleteClusterHostsMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClusterHostsMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClusterHostsMetadata proto.InternalMessageInfo

func (m *DeleteClusterHostsMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *DeleteClusterHostsMetadata) GetHostNames() []string {
	if m != nil {
		return m.HostNames
	}
	return nil
}

type StartClusterRequest struct {
	// ID of the MySQL cluster to start.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartClusterRequest) Reset()         { *m = StartClusterRequest{} }
func (m *StartClusterRequest) String() string { return proto.CompactTextString(m) }
func (*StartClusterRequest) ProtoMessage()    {}
func (*StartClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{29}
}

func (m *StartClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartClusterRequest.Unmarshal(m, b)
}
func (m *StartClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartClusterRequest.Marshal(b, m, deterministic)
}
func (m *StartClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartClusterRequest.Merge(m, src)
}
func (m *StartClusterRequest) XXX_Size() int {
	return xxx_messageInfo_StartClusterRequest.Size(m)
}
func (m *StartClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StartClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StartClusterRequest proto.InternalMessageInfo

func (m *StartClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type StartClusterMetadata struct {
	// ID of the MySQL cluster being started.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartClusterMetadata) Reset()         { *m = StartClusterMetadata{} }
func (m *StartClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*StartClusterMetadata) ProtoMessage()    {}
func (*StartClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{30}
}

func (m *StartClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartClusterMetadata.Unmarshal(m, b)
}
func (m *StartClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartClusterMetadata.Marshal(b, m, deterministic)
}
func (m *StartClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartClusterMetadata.Merge(m, src)
}
func (m *StartClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_StartClusterMetadata.Size(m)
}
func (m *StartClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_StartClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_StartClusterMetadata proto.InternalMessageInfo

func (m *StartClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type StopClusterRequest struct {
	// ID of the MySQL cluster to stop.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StopClusterRequest) Reset()         { *m = StopClusterRequest{} }
func (m *StopClusterRequest) String() string { return proto.CompactTextString(m) }
func (*StopClusterRequest) ProtoMessage()    {}
func (*StopClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{31}
}

func (m *StopClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StopClusterRequest.Unmarshal(m, b)
}
func (m *StopClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StopClusterRequest.Marshal(b, m, deterministic)
}
func (m *StopClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StopClusterRequest.Merge(m, src)
}
func (m *StopClusterRequest) XXX_Size() int {
	return xxx_messageInfo_StopClusterRequest.Size(m)
}
func (m *StopClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StopClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StopClusterRequest proto.InternalMessageInfo

func (m *StopClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type StopClusterMetadata struct {
	// ID of the MySQL cluster being stopped.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StopClusterMetadata) Reset()         { *m = StopClusterMetadata{} }
func (m *StopClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*StopClusterMetadata) ProtoMessage()    {}
func (*StopClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{32}
}

func (m *StopClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StopClusterMetadata.Unmarshal(m, b)
}
func (m *StopClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StopClusterMetadata.Marshal(b, m, deterministic)
}
func (m *StopClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StopClusterMetadata.Merge(m, src)
}
func (m *StopClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_StopClusterMetadata.Size(m)
}
func (m *StopClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_StopClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_StopClusterMetadata proto.InternalMessageInfo

func (m *StopClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type MoveClusterRequest struct {
	// ID of the MySQL cluster to move.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the destination folder.
	DestinationFolderId  string   `protobuf:"bytes,2,opt,name=destination_folder_id,json=destinationFolderId,proto3" json:"destination_folder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MoveClusterRequest) Reset()         { *m = MoveClusterRequest{} }
func (m *MoveClusterRequest) String() string { return proto.CompactTextString(m) }
func (*MoveClusterRequest) ProtoMessage()    {}
func (*MoveClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{33}
}

func (m *MoveClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MoveClusterRequest.Unmarshal(m, b)
}
func (m *MoveClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MoveClusterRequest.Marshal(b, m, deterministic)
}
func (m *MoveClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MoveClusterRequest.Merge(m, src)
}
func (m *MoveClusterRequest) XXX_Size() int {
	return xxx_messageInfo_MoveClusterRequest.Size(m)
}
func (m *MoveClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MoveClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MoveClusterRequest proto.InternalMessageInfo

func (m *MoveClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *MoveClusterRequest) GetDestinationFolderId() string {
	if m != nil {
		return m.DestinationFolderId
	}
	return ""
}

type MoveClusterMetadata struct {
	// ID of the MySQL cluster being moved.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the source folder.
	SourceFolderId string `protobuf:"bytes,2,opt,name=source_folder_id,json=sourceFolderId,proto3" json:"source_folder_id,omitempty"`
	// ID of the destnation folder.
	DestinationFolderId  string   `protobuf:"bytes,3,opt,name=destination_folder_id,json=destinationFolderId,proto3" json:"destination_folder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MoveClusterMetadata) Reset()         { *m = MoveClusterMetadata{} }
func (m *MoveClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*MoveClusterMetadata) ProtoMessage()    {}
func (*MoveClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{34}
}

func (m *MoveClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MoveClusterMetadata.Unmarshal(m, b)
}
func (m *MoveClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MoveClusterMetadata.Marshal(b, m, deterministic)
}
func (m *MoveClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MoveClusterMetadata.Merge(m, src)
}
func (m *MoveClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_MoveClusterMetadata.Size(m)
}
func (m *MoveClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_MoveClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_MoveClusterMetadata proto.InternalMessageInfo

func (m *MoveClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *MoveClusterMetadata) GetSourceFolderId() string {
	if m != nil {
		return m.SourceFolderId
	}
	return ""
}

func (m *MoveClusterMetadata) GetDestinationFolderId() string {
	if m != nil {
		return m.DestinationFolderId
	}
	return ""
}

type UpdateClusterHostsMetadata struct {
	// ID of the MySQL cluster to modify hosts in.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Names of hosts that are being modified.
	HostNames            []string `protobuf:"bytes,2,rep,name=host_names,json=hostNames,proto3" json:"host_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateClusterHostsMetadata) Reset()         { *m = UpdateClusterHostsMetadata{} }
func (m *UpdateClusterHostsMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateClusterHostsMetadata) ProtoMessage()    {}
func (*UpdateClusterHostsMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{35}
}

func (m *UpdateClusterHostsMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateClusterHostsMetadata.Unmarshal(m, b)
}
func (m *UpdateClusterHostsMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateClusterHostsMetadata.Marshal(b, m, deterministic)
}
func (m *UpdateClusterHostsMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateClusterHostsMetadata.Merge(m, src)
}
func (m *UpdateClusterHostsMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateClusterHostsMetadata.Size(m)
}
func (m *UpdateClusterHostsMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateClusterHostsMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateClusterHostsMetadata proto.InternalMessageInfo

func (m *UpdateClusterHostsMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *UpdateClusterHostsMetadata) GetHostNames() []string {
	if m != nil {
		return m.HostNames
	}
	return nil
}

type HostSpec struct {
	// ID of the availability zone where the host resides.
	// To get a list of available zones, use the [yandex.cloud.compute.v1.ZoneService.List] request.
	ZoneId string `protobuf:"bytes,1,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// ID of the subnet that the host should belong to. This subnet should be a part
	// of the network that the cluster belongs to.
	// The ID of the network is set in the field [Cluster.network_id].
	SubnetId string `protobuf:"bytes,2,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Whether the host should get a public IP address on creation.
	//
	// After a host has been created, this setting cannot be changed. To remove an assigned public IP, or to assign
	// a public IP to a host without one, recreate the host with [assign_public_ip] set as needed.
	//
	// Possible values:
	// * false — don't assign a public IP to the host.
	// * true — the host should have a public IP address.
	AssignPublicIp       bool     `protobuf:"varint,3,opt,name=assign_public_ip,json=assignPublicIp,proto3" json:"assign_public_ip,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HostSpec) Reset()         { *m = HostSpec{} }
func (m *HostSpec) String() string { return proto.CompactTextString(m) }
func (*HostSpec) ProtoMessage()    {}
func (*HostSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{36}
}

func (m *HostSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HostSpec.Unmarshal(m, b)
}
func (m *HostSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HostSpec.Marshal(b, m, deterministic)
}
func (m *HostSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HostSpec.Merge(m, src)
}
func (m *HostSpec) XXX_Size() int {
	return xxx_messageInfo_HostSpec.Size(m)
}
func (m *HostSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_HostSpec.DiscardUnknown(m)
}

var xxx_messageInfo_HostSpec proto.InternalMessageInfo

func (m *HostSpec) GetZoneId() string {
	if m != nil {
		return m.ZoneId
	}
	return ""
}

func (m *HostSpec) GetSubnetId() string {
	if m != nil {
		return m.SubnetId
	}
	return ""
}

func (m *HostSpec) GetAssignPublicIp() bool {
	if m != nil {
		return m.AssignPublicIp
	}
	return false
}

type ConfigSpec struct {
	// Version of MySQL used in the cluster.
	// Possible values:
	// * 5.7
	// * 8.0
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Configuration of a MySQL cluster.
	//
	// Types that are valid to be assigned to MysqlConfig:
	//	*ConfigSpec_MysqlConfig_5_7
	//	*ConfigSpec_MysqlConfig_8_0
	MysqlConfig isConfigSpec_MysqlConfig `protobuf_oneof:"mysql_config"`
	// Resources allocated to MySQL hosts.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
	// Time to start the daily backup, in the UTC timezone.
	BackupWindowStart *timeofday.TimeOfDay `protobuf:"bytes,4,opt,name=backup_window_start,json=backupWindowStart,proto3" json:"backup_window_start,omitempty"`
	// Access policy to DB
	Access               *Access  `protobuf:"bytes,5,opt,name=access,proto3" json:"access,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ConfigSpec) Reset()         { *m = ConfigSpec{} }
func (m *ConfigSpec) String() string { return proto.CompactTextString(m) }
func (*ConfigSpec) ProtoMessage()    {}
func (*ConfigSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_f04e32aaf9db2926, []int{37}
}

func (m *ConfigSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConfigSpec.Unmarshal(m, b)
}
func (m *ConfigSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConfigSpec.Marshal(b, m, deterministic)
}
func (m *ConfigSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigSpec.Merge(m, src)
}
func (m *ConfigSpec) XXX_Size() int {
	return xxx_messageInfo_ConfigSpec.Size(m)
}
func (m *ConfigSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigSpec proto.InternalMessageInfo

func (m *ConfigSpec) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

type isConfigSpec_MysqlConfig interface {
	isConfigSpec_MysqlConfig()
}

type ConfigSpec_MysqlConfig_5_7 struct {
	MysqlConfig_5_7 *config.MysqlConfig5_7 `protobuf:"bytes,2,opt,name=mysql_config_5_7,json=mysqlConfig57,proto3,oneof"`
}

type ConfigSpec_MysqlConfig_8_0 struct {
	MysqlConfig_8_0 *config.MysqlConfig8_0 `protobuf:"bytes,6,opt,name=mysql_config_8_0,json=mysqlConfig80,proto3,oneof"`
}

func (*ConfigSpec_MysqlConfig_5_7) isConfigSpec_MysqlConfig() {}

func (*ConfigSpec_MysqlConfig_8_0) isConfigSpec_MysqlConfig() {}

func (m *ConfigSpec) GetMysqlConfig() isConfigSpec_MysqlConfig {
	if m != nil {
		return m.MysqlConfig
	}
	return nil
}

func (m *ConfigSpec) GetMysqlConfig_5_7() *config.MysqlConfig5_7 {
	if x, ok := m.GetMysqlConfig().(*ConfigSpec_MysqlConfig_5_7); ok {
		return x.MysqlConfig_5_7
	}
	return nil
}

func (m *ConfigSpec) GetMysqlConfig_8_0() *config.MysqlConfig8_0 {
	if x, ok := m.GetMysqlConfig().(*ConfigSpec_MysqlConfig_8_0); ok {
		return x.MysqlConfig_8_0
	}
	return nil
}

func (m *ConfigSpec) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *ConfigSpec) GetBackupWindowStart() *timeofday.TimeOfDay {
	if m != nil {
		return m.BackupWindowStart
	}
	return nil
}

func (m *ConfigSpec) GetAccess() *Access {
	if m != nil {
		return m.Access
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ConfigSpec) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ConfigSpec_MysqlConfig_5_7)(nil),
		(*ConfigSpec_MysqlConfig_8_0)(nil),
	}
}

func init() {
	proto.RegisterEnum("yandex.cloud.mdb.mysql.v1.ListClusterLogsRequest_ServiceType", ListClusterLogsRequest_ServiceType_name, ListClusterLogsRequest_ServiceType_value)
	proto.RegisterEnum("yandex.cloud.mdb.mysql.v1.StreamClusterLogsRequest_ServiceType", StreamClusterLogsRequest_ServiceType_name, StreamClusterLogsRequest_ServiceType_value)
	proto.RegisterType((*GetClusterRequest)(nil), "yandex.cloud.mdb.mysql.v1.GetClusterRequest")
	proto.RegisterType((*ListClustersRequest)(nil), "yandex.cloud.mdb.mysql.v1.ListClustersRequest")
	proto.RegisterType((*ListClustersResponse)(nil), "yandex.cloud.mdb.mysql.v1.ListClustersResponse")
	proto.RegisterType((*CreateClusterRequest)(nil), "yandex.cloud.mdb.mysql.v1.CreateClusterRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.mdb.mysql.v1.CreateClusterRequest.LabelsEntry")
	proto.RegisterType((*CreateClusterMetadata)(nil), "yandex.cloud.mdb.mysql.v1.CreateClusterMetadata")
	proto.RegisterType((*UpdateClusterRequest)(nil), "yandex.cloud.mdb.mysql.v1.UpdateClusterRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.mdb.mysql.v1.UpdateClusterRequest.LabelsEntry")
	proto.RegisterType((*UpdateClusterMetadata)(nil), "yandex.cloud.mdb.mysql.v1.UpdateClusterMetadata")
	proto.RegisterType((*DeleteClusterRequest)(nil), "yandex.cloud.mdb.mysql.v1.DeleteClusterRequest")
	proto.RegisterType((*DeleteClusterMetadata)(nil), "yandex.cloud.mdb.mysql.v1.DeleteClusterMetadata")
	proto.RegisterType((*BackupClusterRequest)(nil), "yandex.cloud.mdb.mysql.v1.BackupClusterRequest")
	proto.RegisterType((*BackupClusterMetadata)(nil), "yandex.cloud.mdb.mysql.v1.BackupClusterMetadata")
	proto.RegisterType((*RestoreClusterRequest)(nil), "yandex.cloud.mdb.mysql.v1.RestoreClusterRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.mdb.mysql.v1.RestoreClusterRequest.LabelsEntry")
	proto.RegisterType((*RestoreClusterMetadata)(nil), "yandex.cloud.mdb.mysql.v1.RestoreClusterMetadata")
	proto.RegisterType((*StartClusterFailoverRequest)(nil), "yandex.cloud.mdb.mysql.v1.StartClusterFailoverRequest")
	proto.RegisterType((*StartClusterFailoverMetadata)(nil), "yandex.cloud.mdb.mysql.v1.StartClusterFailoverMetadata")
	proto.RegisterType((*LogRecord)(nil), "yandex.cloud.mdb.mysql.v1.LogRecord")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.mdb.mysql.v1.LogRecord.MessageEntry")
	proto.RegisterType((*ListClusterLogsRequest)(nil), "yandex.cloud.mdb.mysql.v1.ListClusterLogsRequest")
	proto.RegisterType((*ListClusterLogsResponse)(nil), "yandex.cloud.mdb.mysql.v1.ListClusterLogsResponse")
	proto.RegisterType((*StreamClusterLogsRequest)(nil), "yandex.cloud.mdb.mysql.v1.StreamClusterLogsRequest")
	proto.RegisterType((*ListClusterOperationsRequest)(nil), "yandex.cloud.mdb.mysql.v1.ListClusterOperationsRequest")
	proto.RegisterType((*ListClusterOperationsResponse)(nil), "yandex.cloud.mdb.mysql.v1.ListClusterOperationsResponse")
	proto.RegisterType((*ListClusterBackupsRequest)(nil), "yandex.cloud.mdb.mysql.v1.ListClusterBackupsRequest")
	proto.RegisterType((*ListClusterBackupsResponse)(nil), "yandex.cloud.mdb.mysql.v1.ListClusterBackupsResponse")
	proto.RegisterType((*ListClusterHostsRequest)(nil), "yandex.cloud.mdb.mysql.v1.ListClusterHostsRequest")
	proto.RegisterType((*ListClusterHostsResponse)(nil), "yandex.cloud.mdb.mysql.v1.ListClusterHostsResponse")
	proto.RegisterType((*AddClusterHostsRequest)(nil), "yandex.cloud.mdb.mysql.v1.AddClusterHostsRequest")
	proto.RegisterType((*AddClusterHostsMetadata)(nil), "yandex.cloud.mdb.mysql.v1.AddClusterHostsMetadata")
	proto.RegisterType((*DeleteClusterHostsRequest)(nil), "yandex.cloud.mdb.mysql.v1.DeleteClusterHostsRequest")
	proto.RegisterType((*DeleteClusterHostsMetadata)(nil), "yandex.cloud.mdb.mysql.v1.DeleteClusterHostsMetadata")
	proto.RegisterType((*StartClusterRequest)(nil), "yandex.cloud.mdb.mysql.v1.StartClusterRequest")
	proto.RegisterType((*StartClusterMetadata)(nil), "yandex.cloud.mdb.mysql.v1.StartClusterMetadata")
	proto.RegisterType((*StopClusterRequest)(nil), "yandex.cloud.mdb.mysql.v1.StopClusterRequest")
	proto.RegisterType((*StopClusterMetadata)(nil), "yandex.cloud.mdb.mysql.v1.StopClusterMetadata")
	proto.RegisterType((*MoveClusterRequest)(nil), "yandex.cloud.mdb.mysql.v1.MoveClusterRequest")
	proto.RegisterType((*MoveClusterMetadata)(nil), "yandex.cloud.mdb.mysql.v1.MoveClusterMetadata")
	proto.RegisterType((*UpdateClusterHostsMetadata)(nil), "yandex.cloud.mdb.mysql.v1.UpdateClusterHostsMetadata")
	proto.RegisterType((*HostSpec)(nil), "yandex.cloud.mdb.mysql.v1.HostSpec")
	proto.RegisterType((*ConfigSpec)(nil), "yandex.cloud.mdb.mysql.v1.ConfigSpec")
}

func init() {
	proto.RegisterFile("yandex/cloud/mdb/mysql/v1/cluster_service.proto", fileDescriptor_f04e32aaf9db2926)
}

var fileDescriptor_f04e32aaf9db2926 = []byte{
	// 2581 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x5a, 0x4d, 0x70, 0xdb, 0xd6,
	0xf1, 0x0f, 0x24, 0x8a, 0x22, 0x97, 0x96, 0xa2, 0x3c, 0xc9, 0x0a, 0xcd, 0xd8, 0xb1, 0x8c, 0x24,
	0x96, 0xc2, 0x98, 0x20, 0xa9, 0x0f, 0x4b, 0x96, 0x3f, 0x12, 0x51, 0xa6, 0x1c, 0xfd, 0xff, 0x92,
	0xed, 0x40, 0x72, 0x5c, 0xdb, 0xe3, 0x41, 0x41, 0xe2, 0x89, 0xc6, 0x88, 0x04, 0x18, 0x02, 0x94,
	0x2d, 0x7b, 0x9a, 0x99, 0xba, 0x97, 0x8e, 0x7b, 0xe8, 0xf4, 0xeb, 0xd0, 0xe9, 0x4c, 0x8f, 0xcd,
	0xa1, 0x97, 0x8e, 0x92, 0x69, 0x3a, 0xbd, 0xf4, 0x68, 0x4f, 0x0f, 0x3d, 0xa8, 0x87, 0xce, 0xf4,
	0xda, 0x1e, 0x7a, 0xf6, 0xa5, 0x33, 0x3d, 0x75, 0xde, 0x07, 0x44, 0x80, 0x1f, 0x10, 0x28, 0x29,
	0x6e, 0x6e, 0x04, 0xde, 0xee, 0xbe, 0xdf, 0xee, 0xdb, 0x7d, 0xfb, 0x01, 0x42, 0x7a, 0x5b, 0x35,
	0x34, 0xfc, 0x28, 0x5d, 0x2c, 0x9b, 0x75, 0x2d, 0x5d, 0xd1, 0x0a, 0xe9, 0xca, 0xb6, 0xf5, 0x59,
	0x39, 0xbd, 0x95, 0x4d, 0x17, 0xcb, 0x75, 0xcb, 0xc6, 0x35, 0xc5, 0xc2, 0xb5, 0x2d, 0xbd, 0x88,
	0xa5, 0x6a, 0xcd, 0xb4, 0x4d, 0x74, 0x82, 0x31, 0x48, 0x94, 0x41, 0xaa, 0x68, 0x05, 0x89, 0x32,
	0x48, 0x5b, 0xd9, 0xc4, 0xc9, 0x92, 0x69, 0x96, 0xca, 0x38, 0xad, 0x56, 0xf5, 0xb4, 0x6a, 0x18,
	0xa6, 0xad, 0xda, 0xba, 0x69, 0x58, 0x8c, 0x31, 0x31, 0xc6, 0x57, 0xe9, 0x53, 0xa1, 0xbe, 0x91,
	0xde, 0xd0, 0x71, 0x59, 0x53, 0x2a, 0xaa, 0xb5, 0xc9, 0x29, 0x4e, 0x37, 0x53, 0xd8, 0x7a, 0x05,
	0x5b, 0xb6, 0x5a, 0xa9, 0x72, 0x82, 0xb7, 0x38, 0x81, 0xbd, 0x5d, 0xc5, 0x74, 0xd1, 0xdc, 0xd0,
	0xd4, 0x6d, 0x47, 0xbe, 0x47, 0x13, 0x82, 0xc1, 0xac, 0xe2, 0x1a, 0x85, 0xc0, 0x29, 0xce, 0x7a,
	0x28, 0xf6, 0x56, 0x5b, 0xe8, 0x4e, 0x79, 0xe8, 0xb6, 0xd4, 0xb2, 0xae, 0x75, 0x16, 0xe3, 0x31,
	0x59, 0x41, 0x2d, 0x6e, 0xd6, 0x1d, 0xb4, 0xe3, 0xfb, 0x9a, 0x96, 0x13, 0x4e, 0x74, 0x26, 0xd4,
	0x54, 0x5b, 0x2d, 0xa8, 0x16, 0x37, 0x7e, 0xe2, 0xdd, 0xce, 0x94, 0x75, 0x6b, 0x4f, 0x9e, 0xdf,
	0x99, 0x9a, 0xc6, 0x86, 0x5e, 0x62, 0xcf, 0x33, 0xca, 0x6c, 0x77, 0x0c, 0x73, 0x4a, 0x86, 0x31,
	0x88, 0x1f, 0xc1, 0x1b, 0xd7, 0xb0, 0xbd, 0xc8, 0xb4, 0x90, 0xf1, 0x67, 0x75, 0x6c, 0xd9, 0xe8,
	0x03, 0x00, 0xc7, 0x65, 0x74, 0x2d, 0x2e, 0x8c, 0x09, 0x13, 0xd1, 0xdc, 0xb1, 0x7f, 0x3d, 0xcf,
	0x0a, 0xcf, 0x5e, 0x64, 0x43, 0x97, 0x2e, 0xcf, 0x64, 0xe4, 0x28, 0x5f, 0x5f, 0xd6, 0xc4, 0xaf,
	0x05, 0x18, 0x5e, 0xd1, 0x2d, 0x47, 0x86, 0xe5, 0x08, 0x79, 0x1f, 0xa2, 0x1b, 0x66, 0x59, 0xeb,
	0x2c, 0x23, 0xc2, 0x96, 0x97, 0x35, 0x34, 0x0e, 0xd1, 0xaa, 0x5a, 0xc2, 0x8a, 0xa5, 0x3f, 0xc6,
	0xf1, 0x9e, 0x31, 0x61, 0xa2, 0x37, 0x07, 0xff, 0x79, 0x9e, 0x0d, 0x67, 0x52, 0xd9, 0x4c, 0x26,
	0x23, 0x47, 0xc8, 0xe2, 0x9a, 0xfe, 0x18, 0xa3, 0x09, 0x00, 0x4a, 0x68, 0x9b, 0x9b, 0xd8, 0x88,
	0xf7, 0x52, 0xa1, 0xd1, 0x67, 0x2f, 0xb2, 0x7d, 0x97, 0x2e, 0x67, 0x33, 0x19, 0x99, 0x4a, 0x59,
	0x27, 0x6b, 0x48, 0x84, 0xf0, 0x86, 0x5e, 0xb6, 0x71, 0x2d, 0x1e, 0xa2, 0x54, 0xf0, 0xec, 0x45,
	0x36, 0x4c, 0xa9, 0x32, 0x32, 0x5f, 0x11, 0x3f, 0x87, 0x11, 0x2f, 0x70, 0xab, 0x6a, 0x1a, 0x16,
	0x46, 0x57, 0x20, 0xc2, 0xd5, 0xb3, 0xe2, 0xc2, 0x58, 0xef, 0x44, 0x6c, 0x52, 0x94, 0x3a, 0xc6,
	0x8a, 0xe4, 0xd8, 0x6e, 0x8f, 0x07, 0x9d, 0x85, 0xd7, 0x0d, 0xfc, 0xc8, 0x56, 0x5c, 0x50, 0x89,
	0x52, 0x51, 0x79, 0x80, 0xbc, 0xbe, 0xe9, 0x60, 0x14, 0x7f, 0x1c, 0x86, 0x91, 0xc5, 0x1a, 0x56,
	0x6d, 0xdc, 0x64, 0xff, 0x2e, 0x4c, 0x37, 0x09, 0x21, 0x43, 0xad, 0x30, 0xab, 0x45, 0x73, 0x6f,
	0x13, 0xaa, 0x97, 0xcf, 0xb3, 0x83, 0xf7, 0xd4, 0xd4, 0xe3, 0x85, 0xd4, 0xdd, 0x4c, 0xea, 0x82,
	0x92, 0xba, 0x9f, 0x64, 0x7c, 0xe7, 0xa7, 0x64, 0x4a, 0x8b, 0x3e, 0x80, 0x98, 0x86, 0xad, 0x62,
	0x4d, 0xaf, 0x92, 0x58, 0xf0, 0x9a, 0x71, 0x72, 0xe6, 0xbc, 0xec, 0x5e, 0x45, 0x3f, 0x17, 0x20,
	0x5c, 0x56, 0x0b, 0xb8, 0x6c, 0xc5, 0x43, 0xd4, 0x16, 0x17, 0xfd, 0x6c, 0xd1, 0x46, 0x1b, 0x69,
	0x85, 0x72, 0xe7, 0x0d, 0xbb, 0xb6, 0x9d, 0xfb, 0xf0, 0xe5, 0xf3, 0x6c, 0xec, 0x5e, 0x4a, 0xc9,
	0xa4, 0x2e, 0xa8, 0xa9, 0xc7, 0xf7, 0x93, 0x4f, 0x19, 0xb2, 0x69, 0x07, 0xe1, 0xce, 0x8b, 0x6c,
	0x38, 0x11, 0xca, 0xa6, 0xe8, 0x2f, 0x84, 0x86, 0x88, 0x1e, 0xf7, 0x5d, 0xf4, 0x32, 0xc7, 0x82,
	0x6e, 0x42, 0x0c, 0x1b, 0x5b, 0x7a, 0xcd, 0x34, 0x2a, 0xd8, 0xb0, 0xe3, 0x7d, 0x63, 0xc2, 0xc4,
	0xe0, 0xa4, 0xb4, 0xff, 0x31, 0x49, 0xf9, 0x06, 0x97, 0xec, 0x16, 0x81, 0x96, 0x20, 0xc6, 0x42,
	0x44, 0xb1, 0xaa, 0xb8, 0x18, 0x0f, 0x8f, 0x09, 0x13, 0xb1, 0xc9, 0xf7, 0xfc, 0x24, 0x52, 0xea,
	0xb5, 0x2a, 0x2e, 0xca, 0x50, 0xdc, 0xfb, 0x8d, 0xae, 0xc3, 0xa0, 0x13, 0xeb, 0x54, 0x92, 0x15,
	0xef, 0xa7, 0x76, 0x1b, 0xf7, 0x11, 0x75, 0x95, 0x33, 0x50, 0x61, 0x03, 0x9a, 0xeb, 0xc9, 0x42,
	0x39, 0x00, 0x72, 0x23, 0x70, 0x59, 0x11, 0x2a, 0xeb, 0x1d, 0x1f, 0x59, 0xb7, 0x2c, 0x5c, 0xa3,
	0x72, 0xa2, 0x75, 0xfe, 0x8b, 0xca, 0x78, 0x60, 0x5a, 0x36, 0x97, 0x11, 0xdd, 0x57, 0xc6, 0xc7,
	0xa6, 0x65, 0x33, 0x19, 0x0f, 0xf8, 0x2f, 0x0b, 0x8d, 0x03, 0x18, 0xd8, 0x7e, 0x68, 0xd6, 0x36,
	0x89, 0x57, 0x02, 0x75, 0x9a, 0x48, 0xe3, 0x42, 0xe0, 0x6b, 0xcb, 0x5a, 0xe2, 0x02, 0xc4, 0x5c,
	0x47, 0x8e, 0x86, 0xa0, 0x77, 0x13, 0x6f, 0x33, 0x37, 0x96, 0xc9, 0x4f, 0x34, 0x02, 0x7d, 0x5b,
	0x6a, 0xb9, 0xce, 0x9d, 0x56, 0x66, 0x0f, 0xf3, 0x3d, 0x73, 0x82, 0x78, 0x1e, 0x8e, 0x7b, 0x5c,
	0x68, 0x15, 0xdb, 0x2a, 0xb1, 0x06, 0x3a, 0xd5, 0x7a, 0x23, 0xb9, 0xef, 0xa0, 0x7f, 0xf7, 0xc2,
	0xc8, 0xad, 0xaa, 0xd6, 0x1a, 0x49, 0xdd, 0xdc, 0x64, 0xe8, 0x22, 0xc4, 0xea, 0x54, 0x08, 0x4d,
	0x65, 0x14, 0x5d, 0x6c, 0x32, 0x21, 0xb1, 0x54, 0x25, 0x39, 0xb9, 0x4c, 0x5a, 0x22, 0xd9, 0x6e,
	0x55, 0xb5, 0x36, 0x65, 0x60, 0xe4, 0xe4, 0xf7, 0x37, 0x18, 0x54, 0xed, 0x14, 0xfb, 0x66, 0x82,
	0xaa, 0x29, 0x04, 0xfa, 0x0e, 0x1a, 0x02, 0x12, 0xbf, 0x94, 0xc2, 0xd4, 0x08, 0x89, 0xfd, 0x2e,
	0xa4, 0x43, 0x7a, 0x8c, 0xc7, 0x3e, 0x41, 0x3d, 0x66, 0x11, 0x46, 0xae, 0xe2, 0x32, 0x3e, 0x94,
	0xc3, 0x90, 0xcd, 0x3d, 0x42, 0xba, 0xd8, 0x3c, 0x47, 0xeb, 0x8b, 0x43, 0x6e, 0xee, 0x11, 0x12,
	0x74, 0xf3, 0x3f, 0xf7, 0xc1, 0x71, 0x19, 0x5b, 0xb6, 0x59, 0x6b, 0xd6, 0xfd, 0x0c, 0x44, 0x59,
	0xd9, 0xd3, 0xd8, 0x3d, 0x44, 0x76, 0x97, 0x23, 0xec, 0xf5, 0xb2, 0x86, 0xa6, 0x21, 0x44, 0xaa,
	0xb5, 0x8e, 0xb1, 0xb1, 0xee, 0xd4, 0x79, 0x9c, 0x93, 0x52, 0xa3, 0x24, 0xf7, 0x07, 0x96, 0x8a,
	0x47, 0xdb, 0x27, 0xa9, 0xf6, 0xc9, 0xa9, 0xcf, 0x37, 0x8e, 0x7e, 0xd1, 0x88, 0xa3, 0x30, 0x8d,
	0xa3, 0x4b, 0x3e, 0xce, 0xda, 0x56, 0xe9, 0x57, 0x92, 0x9d, 0xfa, 0x8f, 0x3c, 0x3b, 0x45, 0x0e,
	0x1a, 0x9a, 0xaf, 0x32, 0x13, 0xa0, 0xf7, 0xdc, 0x75, 0x4c, 0xac, 0x89, 0x6e, 0xaf, 0x86, 0x39,
	0x4c, 0xf8, 0xaf, 0xc3, 0xa8, 0xf7, 0x58, 0x03, 0x46, 0x01, 0x7a, 0xcb, 0xed, 0xeb, 0x4c, 0xec,
	0x9e, 0x97, 0x8b, 0x35, 0x78, 0x6b, 0xcd, 0x56, 0x6b, 0x4e, 0x65, 0xb8, 0xa4, 0xea, 0x65, 0x73,
	0xeb, 0x80, 0x49, 0xe5, 0x2c, 0x50, 0xcb, 0x29, 0xae, 0x2a, 0x6d, 0xcf, 0x9b, 0xa7, 0xe4, 0x08,
	0x59, 0xbb, 0xae, 0x56, 0xb0, 0x78, 0x19, 0x4e, 0xb6, 0xdb, 0x33, 0x68, 0x54, 0xff, 0x45, 0x80,
	0xe8, 0x8a, 0x59, 0x92, 0x71, 0xd1, 0xac, 0x69, 0x68, 0x0e, 0xa2, 0x7b, 0x1d, 0x17, 0xa5, 0xf5,
	0x8d, 0x55, 0xb9, 0x41, 0x8c, 0xfe, 0x1f, 0xfa, 0x2b, 0xd8, 0xb2, 0xd4, 0x12, 0x01, 0x4b, 0x9c,
	0x23, 0xeb, 0xe3, 0x1c, 0x7b, 0x1b, 0x4a, 0xab, 0x8c, 0x87, 0x1e, 0xa0, 0xec, 0x48, 0x48, 0xcc,
	0xc3, 0x31, 0xf7, 0x42, 0x57, 0x27, 0xfb, 0xc7, 0x10, 0x8c, 0xba, 0xaa, 0xf3, 0x15, 0xb3, 0x64,
	0x1d, 0xc8, 0xfe, 0xef, 0xc0, 0x40, 0xd1, 0x2c, 0xd7, 0x2b, 0x86, 0xc2, 0xfb, 0x01, 0xa2, 0x56,
	0x54, 0x3e, 0xc6, 0x5e, 0x2e, 0xd1, 0x77, 0xe8, 0xbb, 0x70, 0x8c, 0xf7, 0xc6, 0x0a, 0xe9, 0x48,
	0x69, 0xf6, 0x1e, 0x9c, 0xbc, 0xec, 0xa7, 0x7a, 0x5b, 0x68, 0xd2, 0x1a, 0x93, 0xb2, 0xbe, 0x5d,
	0xc5, 0x72, 0xcc, 0x6a, 0x3c, 0xa0, 0x59, 0x88, 0x6e, 0xd4, 0xcc, 0x8a, 0x42, 0x6f, 0xcf, 0xd0,
	0xbe, 0x27, 0x12, 0x21, 0xc4, 0xe4, 0x11, 0x4d, 0x41, 0xbf, 0x6d, 0x32, 0xb6, 0xbe, 0x7d, 0xd9,
	0xc2, 0xb6, 0x49, 0x99, 0x3c, 0x0d, 0x55, 0x38, 0x70, 0x43, 0xd5, 0xef, 0xd3, 0x50, 0x4d, 0xc1,
	0xa8, 0x5a, 0x7e, 0xa8, 0x6e, 0x5b, 0x4a, 0x73, 0x6f, 0x43, 0xee, 0xa2, 0x88, 0x3c, 0xcc, 0x56,
	0xaf, 0x7b, 0x3a, 0x9c, 0x2d, 0x88, 0xb9, 0x2c, 0x82, 0x4e, 0x42, 0x7c, 0x2d, 0x2f, 0x7f, 0xba,
	0xbc, 0x98, 0x57, 0xd6, 0xef, 0xdc, 0xcc, 0x2b, 0xb7, 0xae, 0xaf, 0xdd, 0xcc, 0x2f, 0x2e, 0x2f,
	0x2d, 0xe7, 0xaf, 0x0e, 0xbd, 0x86, 0x5e, 0x87, 0xd8, 0xea, 0x9d, 0xb5, 0x4f, 0x56, 0x94, 0xbc,
	0x2c, 0xdf, 0x90, 0x87, 0x04, 0xf4, 0x06, 0x0c, 0xb0, 0x17, 0xd7, 0xf2, 0xd7, 0xf3, 0xf2, 0xc2,
	0xca, 0x50, 0x0f, 0x1a, 0x81, 0x21, 0xf6, 0x6a, 0x6d, 0xe5, 0xc6, 0x6d, 0xe5, 0x93, 0x5b, 0x79,
	0xf9, 0xce, 0x50, 0x6f, 0x83, 0x73, 0xe1, 0xd6, 0xd5, 0xe5, 0xf5, 0xa1, 0x90, 0xf8, 0x04, 0xde,
	0x6c, 0x39, 0x20, 0xde, 0xdc, 0xcd, 0x41, 0xa8, 0x6c, 0x96, 0x9c, 0xc6, 0xee, 0xdd, 0x20, 0xde,
	0x2d, 0x53, 0x8e, 0xc0, 0x6d, 0xdd, 0xef, 0x7b, 0x21, 0xbe, 0x66, 0xd7, 0xb0, 0x5a, 0x79, 0x25,
	0xbe, 0x5b, 0x68, 0xeb, 0xbb, 0x1f, 0xfa, 0x28, 0xd6, 0x09, 0xdc, 0xb7, 0xc4, 0x7b, 0xff, 0x67,
	0x5e, 0xf3, 0x6b, 0x01, 0x4e, 0xba, 0xdc, 0xe6, 0x86, 0x33, 0x4c, 0x3a, 0xd8, 0xe1, 0x1d, 0xfd,
	0x50, 0x43, 0x7c, 0x26, 0xc0, 0xa9, 0x0e, 0x00, 0xb9, 0x77, 0x2f, 0x00, 0xec, 0xcd, 0xc0, 0x1c,
	0x1f, 0x3f, 0xe3, 0x75, 0x85, 0xc6, 0x8c, 0x6c, 0x8f, 0x5f, 0x76, 0x31, 0x05, 0x76, 0xf3, 0x5f,
	0x09, 0x70, 0xc2, 0x05, 0x86, 0xd5, 0xa2, 0x47, 0x6b, 0x2a, 0x3e, 0xaf, 0x39, 0x88, 0xa9, 0xbe,
	0x2f, 0x40, 0xa2, 0x1d, 0x3a, 0x6e, 0xa7, 0x8b, 0xd0, 0xcf, 0xb2, 0x7d, 0x07, 0x23, 0x79, 0xe2,
	0x85, 0x31, 0xcb, 0x0e, 0x47, 0x60, 0x0b, 0xfd, 0x52, 0xf0, 0x5c, 0x43, 0xa4, 0x94, 0xfa, 0xd6,
	0xb8, 0xd2, 0x36, 0xc4, 0x5b, 0xa1, 0x71, 0xe3, 0xcc, 0x40, 0x1f, 0x29, 0x4b, 0x1c, 0xd3, 0x9c,
	0xde, 0xa7, 0x3c, 0x94, 0x19, 0x75, 0x60, 0xb3, 0xfc, 0x44, 0x80, 0xd1, 0x05, 0x4d, 0x3b, 0xb4,
	0x55, 0xfe, 0xcf, 0x53, 0xca, 0xf6, 0x04, 0x2e, 0x65, 0x73, 0xe1, 0xa7, 0x2f, 0xb2, 0x3d, 0x57,
	0x32, 0xae, 0x92, 0x56, 0xbc, 0x0d, 0x6f, 0x36, 0x41, 0x0a, 0x5a, 0x48, 0x9e, 0xe2, 0x28, 0x48,
	0x7d, 0x67, 0xf1, 0x0b, 0x3a, 0xea, 0x54, 0x75, 0x96, 0xf8, 0x08, 0x4e, 0x78, 0x5a, 0xc4, 0x83,
	0xab, 0x2b, 0xb5, 0x6e, 0x94, 0x7b, 0x9d, 0x69, 0xd2, 0xa8, 0x27, 0x5d, 0x3b, 0xdf, 0x85, 0x44,
	0xeb, 0xce, 0x47, 0xa4, 0x55, 0x0e, 0x86, 0xdd, 0xc5, 0xea, 0x81, 0xfa, 0xd7, 0x19, 0x18, 0x71,
	0xcb, 0x08, 0x5a, 0xe8, 0x2e, 0x00, 0x5a, 0xb3, 0xcd, 0x43, 0x75, 0xce, 0xd3, 0x04, 0xbd, 0xd9,
	0x6d, 0xdf, 0xfc, 0x03, 0x01, 0xd0, 0xaa, 0xb9, 0x75, 0xa8, 0x09, 0xd3, 0x47, 0x70, 0x5c, 0xc3,
	0x96, 0xad, 0x1b, 0xf4, 0xae, 0x55, 0x1a, 0xcd, 0x51, 0x4f, 0x1b, 0xbe, 0x61, 0x17, 0xe9, 0x12,
	0xef, 0x95, 0xc4, 0x9f, 0x0a, 0x30, 0xec, 0x42, 0x11, 0xf4, 0x3c, 0x27, 0x60, 0xc8, 0x32, 0xeb,
	0xb5, 0x22, 0x6e, 0xde, 0x53, 0x1e, 0x64, 0xef, 0x97, 0x1a, 0x03, 0xe5, 0x0e, 0x10, 0xe9, 0x6d,
	0xd2, 0x1e, 0xd4, 0x5d, 0x48, 0x78, 0x86, 0x30, 0x47, 0xe9, 0x6a, 0x9f, 0x43, 0xc4, 0x09, 0x5c,
	0x74, 0x06, 0xfa, 0x1f, 0x9b, 0x06, 0x6e, 0x18, 0xba, 0xd1, 0x4d, 0x86, 0xc9, 0x02, 0x6b, 0x39,
	0xad, 0x7a, 0xc1, 0xc0, 0x76, 0xc3, 0xaa, 0xae, 0x96, 0x93, 0x2d, 0x31, 0x7b, 0xa8, 0x96, 0xa5,
	0x97, 0x0c, 0xa5, 0x5a, 0x2f, 0x94, 0xf5, 0xa2, 0xa2, 0x57, 0xa9, 0x82, 0x11, 0x79, 0x90, 0xbd,
	0xbf, 0x49, 0x5f, 0x2f, 0x57, 0xc5, 0xaf, 0x7b, 0x01, 0x1a, 0xbd, 0x34, 0x8a, 0x43, 0xff, 0x16,
	0xae, 0x59, 0xba, 0x69, 0x70, 0x4d, 0x9c, 0x47, 0x74, 0x0f, 0x86, 0xe8, 0x55, 0xa3, 0xf0, 0x3e,
	0x7d, 0x46, 0x99, 0xe5, 0x63, 0x92, 0x8c, 0xcf, 0xa5, 0xc4, 0x88, 0xa5, 0x55, 0xf2, 0xcc, 0xb6,
	0x99, 0x51, 0x66, 0x3f, 0x7e, 0x4d, 0x1e, 0xa8, 0xb8, 0xde, 0xcc, 0xb6, 0x08, 0x9f, 0x53, 0x32,
	0x7c, 0x42, 0xdd, 0x9d, 0xf0, 0x39, 0x25, 0xd3, 0x24, 0x7c, 0x2e, 0x83, 0x72, 0x10, 0xad, 0x61,
	0xe6, 0x06, 0x16, 0xb5, 0x82, 0x7f, 0x5d, 0x2c, 0x3b, 0xb4, 0x72, 0x83, 0x0d, 0x2d, 0xc1, 0x30,
	0xef, 0xa7, 0x1f, 0xea, 0x86, 0x66, 0x3e, 0x54, 0x2c, 0x12, 0xdb, 0xbc, 0x56, 0x1c, 0x75, 0x8a,
	0x3e, 0x52, 0xa0, 0xd2, 0x82, 0xef, 0xc6, 0xc6, 0x55, 0x75, 0x5b, 0x7e, 0x83, 0xb1, 0xdc, 0xa6,
	0x1c, 0xf4, 0x32, 0x40, 0x17, 0x20, 0xac, 0x16, 0x8b, 0xd8, 0xb2, 0x78, 0xbd, 0xe8, 0x97, 0x97,
	0x17, 0x28, 0xa1, 0xcc, 0x19, 0x72, 0x83, 0x70, 0xcc, 0x6d, 0xa3, 0xc9, 0x97, 0x27, 0x60, 0x90,
	0x3b, 0x24, 0x2f, 0x27, 0xd1, 0x0f, 0x05, 0xe8, 0xbd, 0x86, 0x6d, 0x74, 0xce, 0x47, 0x6a, 0xcb,
	0xe7, 0xb0, 0x44, 0x80, 0xaf, 0x3f, 0x62, 0xfa, 0xe9, 0x5f, 0xff, 0xf9, 0xb3, 0x9e, 0xf7, 0xd1,
	0x78, 0xba, 0xa2, 0x1a, 0x6a, 0x09, 0x6b, 0xa9, 0xe6, 0x4f, 0x84, 0x56, 0xfa, 0x49, 0x23, 0x0c,
	0xbe, 0x87, 0x7e, 0x24, 0x40, 0x88, 0x64, 0x60, 0x24, 0x05, 0xeb, 0x32, 0x9d, 0xa4, 0x91, 0x48,
	0x07, 0xa6, 0x67, 0xe9, 0x5c, 0x14, 0x29, 0xb4, 0x93, 0x28, 0xd1, 0x19, 0x1a, 0xfa, 0x42, 0x80,
	0x30, 0x9b, 0xbc, 0xa3, 0x74, 0x97, 0xdf, 0x77, 0x12, 0xfb, 0xd7, 0x97, 0xe2, 0xf2, 0xce, 0x6e,
	0x72, 0xac, 0xd3, 0x6c, 0xbf, 0x9f, 0xbf, 0xa0, 0x30, 0x4f, 0x8b, 0x3e, 0x30, 0xe7, 0x85, 0x24,
	0xfa, 0x4a, 0x80, 0x30, 0xbb, 0x6c, 0x7c, 0x91, 0xb6, 0x1b, 0x9a, 0x07, 0x41, 0xfa, 0x29, 0x43,
	0xda, 0x7e, 0xa6, 0xec, 0x41, 0x7a, 0x6e, 0x32, 0xe8, 0x59, 0x13, 0xd8, 0x7f, 0x12, 0x20, 0xcc,
	0xd2, 0xb1, 0x2f, 0xec, 0x76, 0x33, 0xe9, 0x20, 0xb0, 0xd5, 0x9d, 0xdd, 0xa4, 0xd4, 0x69, 0x1a,
	0x7d, 0xbc, 0xb9, 0xe5, 0xca, 0x57, 0xaa, 0xf6, 0x36, 0x73, 0xd8, 0x64, 0x60, 0x87, 0xfd, 0x4a,
	0x80, 0x3e, 0x16, 0xa3, 0x92, 0x6f, 0x6f, 0xd9, 0x52, 0x16, 0x04, 0xc1, 0xff, 0x9d, 0x9d, 0xdd,
	0xe4, 0xe9, 0x0e, 0x05, 0x81, 0xc7, 0xea, 0x69, 0x31, 0x15, 0xd4, 0xea, 0xf4, 0x06, 0x42, 0xbf,
	0x13, 0x20, 0x44, 0xb2, 0x3d, 0x4a, 0xf9, 0xa2, 0x6e, 0xae, 0x28, 0x82, 0xfa, 0xca, 0xdb, 0xed,
	0x6b, 0x09, 0x0f, 0x66, 0x49, 0x3c, 0x17, 0x1c, 0xb3, 0x59, 0x45, 0x5f, 0x0a, 0x10, 0x22, 0x39,
	0xde, 0x17, 0x72, 0x6b, 0x29, 0x12, 0x04, 0xf2, 0x1d, 0x06, 0xb9, 0x5d, 0x05, 0xe1, 0x81, 0x9c,
	0x0d, 0x0e, 0xb9, 0x62, 0x6e, 0x61, 0xe2, 0xe1, 0x7f, 0x10, 0x20, 0xcc, 0x3a, 0x25, 0x5f, 0x0f,
	0x6f, 0xf7, 0xe1, 0x23, 0x08, 0xf2, 0xbb, 0x2c, 0x30, 0xdb, 0x7f, 0xf2, 0xf0, 0x60, 0xcf, 0x88,
	0x52, 0x50, 0xec, 0x2c, 0xff, 0xa0, 0x1d, 0x01, 0xfa, 0xf9, 0x18, 0x19, 0x65, 0xba, 0xfd, 0x82,
	0x10, 0x04, 0xbc, 0xbc, 0xb3, 0x9b, 0x3c, 0xd3, 0x71, 0x54, 0xed, 0x41, 0x3f, 0x2e, 0x8a, 0x3e,
	0x17, 0x60, 0x8d, 0x49, 0x20, 0xf6, 0xfe, 0x9b, 0x00, 0x03, 0x34, 0x5e, 0x9c, 0x51, 0x31, 0x3a,
	0x1f, 0x30, 0x2e, 0x9b, 0xe6, 0xd9, 0x41, 0x14, 0xd8, 0xdc, 0xd9, 0x4d, 0x8e, 0xef, 0x33, 0xa1,
	0xf6, 0xa8, 0x31, 0x2f, 0xce, 0x74, 0x15, 0xa7, 0x8e, 0x34, 0xa2, 0xd9, 0x17, 0x02, 0x44, 0x48,
	0x26, 0x5b, 0x31, 0x4b, 0x16, 0xca, 0x76, 0x3d, 0x84, 0x4d, 0x4c, 0x76, 0xc3, 0xc2, 0x93, 0xe4,
	0x34, 0x8b, 0x54, 0x14, 0xd8, 0xed, 0xe9, 0x48, 0xf0, 0x37, 0x02, 0x00, 0x9b, 0xa6, 0x51, 0xac,
	0x53, 0x07, 0x18, 0xba, 0x25, 0x02, 0x8d, 0x20, 0xc5, 0x8b, 0x14, 0xdf, 0x0c, 0x9a, 0x0a, 0x6e,
	0x55, 0xb2, 0x9f, 0x42, 0x60, 0x66, 0x04, 0x92, 0x7e, 0x06, 0x89, 0xea, 0x8d, 0x91, 0x11, 0x9a,
	0x0d, 0x66, 0xa5, 0x96, 0x29, 0x58, 0x62, 0xae, 0x7b, 0x46, 0x6e, 0xe4, 0x79, 0xaa, 0xc4, 0x34,
	0x9a, 0x0c, 0xa8, 0x44, 0xda, 0x35, 0x96, 0xfa, 0x52, 0x80, 0x18, 0x91, 0xce, 0x27, 0x39, 0x68,
	0x3a, 0x18, 0x0a, 0xef, 0x58, 0x2a, 0x31, 0xd3, 0x25, 0x17, 0x07, 0x3e, 0xcb, 0x2e, 0x45, 0x94,
	0x0e, 0x0a, 0xdc, 0x19, 0x15, 0xfd, 0x56, 0x80, 0x28, 0x91, 0x4b, 0x3b, 0x22, 0x14, 0xd0, 0x31,
	0xdd, 0x33, 0x82, 0xc4, 0x54, 0x57, 0x3c, 0x1c, 0xef, 0x0c, 0xcb, 0x95, 0x28, 0x68, 0xae, 0x4c,
	0xb3, 0x09, 0xce, 0xdf, 0x05, 0x88, 0x2c, 0x68, 0x1a, 0x03, 0xeb, 0x17, 0x78, 0xed, 0xc7, 0x37,
	0x41, 0x2e, 0x92, 0x47, 0x3b, 0xbb, 0xc9, 0x4c, 0xe7, 0x61, 0x8b, 0x4f, 0xa9, 0x72, 0x45, 0xbc,
	0xd0, 0x95, 0x36, 0xf3, 0x05, 0xd5, 0x2e, 0x3e, 0x60, 0x25, 0x27, 0xb9, 0x55, 0xfe, 0x21, 0x40,
	0x8c, 0xd5, 0x47, 0x4c, 0xbf, 0xe9, 0xa0, 0x65, 0x58, 0xb7, 0x2a, 0x3e, 0xd9, 0xd9, 0x4d, 0x4e,
	0xf9, 0x0e, 0x5f, 0x8e, 0x5c, 0x4b, 0xb6, 0xd7, 0xbc, 0x90, 0xcc, 0x69, 0x70, 0xca, 0x03, 0x50,
	0xad, 0xea, 0x1e, 0xd5, 0xee, 0x2e, 0x96, 0x74, 0xfb, 0x41, 0xbd, 0x20, 0x15, 0xcd, 0x0a, 0xff,
	0xb3, 0x60, 0x8a, 0xfd, 0x59, 0xb0, 0x64, 0xa6, 0x4a, 0xd8, 0xa0, 0x90, 0x3a, 0xff, 0x8b, 0xf0,
	0x22, 0xfd, 0x51, 0x08, 0x53, 0xb2, 0xa9, 0xff, 0x06, 0x00, 0x00, 0xff, 0xff, 0x71, 0xbb, 0xee,
	0x7b, 0x74, 0x2a, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ClusterServiceClient is the client API for ClusterService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ClusterServiceClient interface {
	// Returns the specified MySQL cluster.
	//
	// To get the list of available MySQL clusters, make a [List] request.
	Get(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Retrieves the list of MySQL clusters that belong to the specified folder.
	List(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Creates a MySQL cluster in the specified folder.
	Create(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Modifies the specified MySQL cluster.
	Update(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified MySQL cluster.
	Delete(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Starts the specified MySQL cluster.
	Start(ctx context.Context, in *StartClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Stops the specified MySQL cluster.
	Stop(ctx context.Context, in *StopClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Moves the specified MySQL cluster to the specified folder.
	Move(ctx context.Context, in *MoveClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Creates a backup for the specified MySQL cluster.
	Backup(ctx context.Context, in *BackupClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Creates a new MySQL cluster using the specified backup.
	Restore(ctx context.Context, in *RestoreClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Start a manual failover on the specified MySQL cluster.
	StartFailover(ctx context.Context, in *StartClusterFailoverRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Retrieves logs for the specified MySQL cluster.
	ListLogs(ctx context.Context, in *ListClusterLogsRequest, opts ...grpc.CallOption) (*ListClusterLogsResponse, error)
	// Same as ListLogs but using server-side streaming. Also allows for 'tail -f' semantics.
	StreamLogs(ctx context.Context, in *StreamClusterLogsRequest, opts ...grpc.CallOption) (ClusterService_StreamLogsClient, error)
	// Retrieves the list of operations for the specified MySQL cluster.
	ListOperations(ctx context.Context, in *ListClusterOperationsRequest, opts ...grpc.CallOption) (*ListClusterOperationsResponse, error)
	// Retrieves the list of available backups for the specified MySQL cluster.
	ListBackups(ctx context.Context, in *ListClusterBackupsRequest, opts ...grpc.CallOption) (*ListClusterBackupsResponse, error)
	// Retrieves a list of hosts for the specified MySQL cluster.
	ListHosts(ctx context.Context, in *ListClusterHostsRequest, opts ...grpc.CallOption) (*ListClusterHostsResponse, error)
	// Creates new hosts for a cluster.
	AddHosts(ctx context.Context, in *AddClusterHostsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified hosts for a cluster.
	DeleteHosts(ctx context.Context, in *DeleteClusterHostsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
}

type clusterServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewClusterServiceClient(cc grpc.ClientConnInterface) ClusterServiceClient {
	return &clusterServiceClient{cc}
}

func (c *clusterServiceClient) Get(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mysql.v1.ClusterService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) List(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mysql.v1.ClusterService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Create(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mysql.v1.ClusterService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Update(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mysql.v1.ClusterService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Delete(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mysql.v1.ClusterService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Start(ctx context.Context, in *StartClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mysql.v1.ClusterService/Start", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Stop(ctx context.Context, in *StopClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mysql.v1.ClusterService/Stop", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Move(ctx context.Context, in *MoveClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mysql.v1.ClusterService/Move", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Backup(ctx context.Context, in *BackupClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mysql.v1.ClusterService/Backup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Restore(ctx context.Context, in *RestoreClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mysql.v1.ClusterService/Restore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) StartFailover(ctx context.Context, in *StartClusterFailoverRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mysql.v1.ClusterService/StartFailover", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) ListLogs(ctx context.Context, in *ListClusterLogsRequest, opts ...grpc.CallOption) (*ListClusterLogsResponse, error) {
	out := new(ListClusterLogsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mysql.v1.ClusterService/ListLogs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) StreamLogs(ctx context.Context, in *StreamClusterLogsRequest, opts ...grpc.CallOption) (ClusterService_StreamLogsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ClusterService_serviceDesc.Streams[0], "/yandex.cloud.mdb.mysql.v1.ClusterService/StreamLogs", opts...)
	if err != nil {
		return nil, err
	}
	x := &clusterServiceStreamLogsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ClusterService_StreamLogsClient interface {
	Recv() (*LogRecord, error)
	grpc.ClientStream
}

type clusterServiceStreamLogsClient struct {
	grpc.ClientStream
}

func (x *clusterServiceStreamLogsClient) Recv() (*LogRecord, error) {
	m := new(LogRecord)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *clusterServiceClient) ListOperations(ctx context.Context, in *ListClusterOperationsRequest, opts ...grpc.CallOption) (*ListClusterOperationsResponse, error) {
	out := new(ListClusterOperationsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mysql.v1.ClusterService/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) ListBackups(ctx context.Context, in *ListClusterBackupsRequest, opts ...grpc.CallOption) (*ListClusterBackupsResponse, error) {
	out := new(ListClusterBackupsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mysql.v1.ClusterService/ListBackups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) ListHosts(ctx context.Context, in *ListClusterHostsRequest, opts ...grpc.CallOption) (*ListClusterHostsResponse, error) {
	out := new(ListClusterHostsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mysql.v1.ClusterService/ListHosts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) AddHosts(ctx context.Context, in *AddClusterHostsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mysql.v1.ClusterService/AddHosts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) DeleteHosts(ctx context.Context, in *DeleteClusterHostsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mysql.v1.ClusterService/DeleteHosts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ClusterServiceServer is the server API for ClusterService service.
type ClusterServiceServer interface {
	// Returns the specified MySQL cluster.
	//
	// To get the list of available MySQL clusters, make a [List] request.
	Get(context.Context, *GetClusterRequest) (*Cluster, error)
	// Retrieves the list of MySQL clusters that belong to the specified folder.
	List(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Creates a MySQL cluster in the specified folder.
	Create(context.Context, *CreateClusterRequest) (*operation.Operation, error)
	// Modifies the specified MySQL cluster.
	Update(context.Context, *UpdateClusterRequest) (*operation.Operation, error)
	// Deletes the specified MySQL cluster.
	Delete(context.Context, *DeleteClusterRequest) (*operation.Operation, error)
	// Starts the specified MySQL cluster.
	Start(context.Context, *StartClusterRequest) (*operation.Operation, error)
	// Stops the specified MySQL cluster.
	Stop(context.Context, *StopClusterRequest) (*operation.Operation, error)
	// Moves the specified MySQL cluster to the specified folder.
	Move(context.Context, *MoveClusterRequest) (*operation.Operation, error)
	// Creates a backup for the specified MySQL cluster.
	Backup(context.Context, *BackupClusterRequest) (*operation.Operation, error)
	// Creates a new MySQL cluster using the specified backup.
	Restore(context.Context, *RestoreClusterRequest) (*operation.Operation, error)
	// Start a manual failover on the specified MySQL cluster.
	StartFailover(context.Context, *StartClusterFailoverRequest) (*operation.Operation, error)
	// Retrieves logs for the specified MySQL cluster.
	ListLogs(context.Context, *ListClusterLogsRequest) (*ListClusterLogsResponse, error)
	// Same as ListLogs but using server-side streaming. Also allows for 'tail -f' semantics.
	StreamLogs(*StreamClusterLogsRequest, ClusterService_StreamLogsServer) error
	// Retrieves the list of operations for the specified MySQL cluster.
	ListOperations(context.Context, *ListClusterOperationsRequest) (*ListClusterOperationsResponse, error)
	// Retrieves the list of available backups for the specified MySQL cluster.
	ListBackups(context.Context, *ListClusterBackupsRequest) (*ListClusterBackupsResponse, error)
	// Retrieves a list of hosts for the specified MySQL cluster.
	ListHosts(context.Context, *ListClusterHostsRequest) (*ListClusterHostsResponse, error)
	// Creates new hosts for a cluster.
	AddHosts(context.Context, *AddClusterHostsRequest) (*operation.Operation, error)
	// Deletes the specified hosts for a cluster.
	DeleteHosts(context.Context, *DeleteClusterHostsRequest) (*operation.Operation, error)
}

// UnimplementedClusterServiceServer can be embedded to have forward compatible implementations.
type UnimplementedClusterServiceServer struct {
}

func (*UnimplementedClusterServiceServer) Get(ctx context.Context, req *GetClusterRequest) (*Cluster, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedClusterServiceServer) List(ctx context.Context, req *ListClustersRequest) (*ListClustersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedClusterServiceServer) Create(ctx context.Context, req *CreateClusterRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (*UnimplementedClusterServiceServer) Update(ctx context.Context, req *UpdateClusterRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (*UnimplementedClusterServiceServer) Delete(ctx context.Context, req *DeleteClusterRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedClusterServiceServer) Start(ctx context.Context, req *StartClusterRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Start not implemented")
}
func (*UnimplementedClusterServiceServer) Stop(ctx context.Context, req *StopClusterRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Stop not implemented")
}
func (*UnimplementedClusterServiceServer) Move(ctx context.Context, req *MoveClusterRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Move not implemented")
}
func (*UnimplementedClusterServiceServer) Backup(ctx context.Context, req *BackupClusterRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Backup not implemented")
}
func (*UnimplementedClusterServiceServer) Restore(ctx context.Context, req *RestoreClusterRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Restore not implemented")
}
func (*UnimplementedClusterServiceServer) StartFailover(ctx context.Context, req *StartClusterFailoverRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartFailover not implemented")
}
func (*UnimplementedClusterServiceServer) ListLogs(ctx context.Context, req *ListClusterLogsRequest) (*ListClusterLogsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLogs not implemented")
}
func (*UnimplementedClusterServiceServer) StreamLogs(req *StreamClusterLogsRequest, srv ClusterService_StreamLogsServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamLogs not implemented")
}
func (*UnimplementedClusterServiceServer) ListOperations(ctx context.Context, req *ListClusterOperationsRequest) (*ListClusterOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOperations not implemented")
}
func (*UnimplementedClusterServiceServer) ListBackups(ctx context.Context, req *ListClusterBackupsRequest) (*ListClusterBackupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBackups not implemented")
}
func (*UnimplementedClusterServiceServer) ListHosts(ctx context.Context, req *ListClusterHostsRequest) (*ListClusterHostsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListHosts not implemented")
}
func (*UnimplementedClusterServiceServer) AddHosts(ctx context.Context, req *AddClusterHostsRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddHosts not implemented")
}
func (*UnimplementedClusterServiceServer) DeleteHosts(ctx context.Context, req *DeleteClusterHostsRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteHosts not implemented")
}

func RegisterClusterServiceServer(s *grpc.Server, srv ClusterServiceServer) {
	s.RegisterService(&_ClusterService_serviceDesc, srv)
}

func _ClusterService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mysql.v1.ClusterService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Get(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mysql.v1.ClusterService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).List(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mysql.v1.ClusterService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Create(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mysql.v1.ClusterService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Update(ctx, req.(*UpdateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mysql.v1.ClusterService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Delete(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Start_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Start(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mysql.v1.ClusterService/Start",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Start(ctx, req.(*StartClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Stop_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Stop(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mysql.v1.ClusterService/Stop",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Stop(ctx, req.(*StopClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Move_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Move(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mysql.v1.ClusterService/Move",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Move(ctx, req.(*MoveClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Backup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BackupClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Backup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mysql.v1.ClusterService/Backup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Backup(ctx, req.(*BackupClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Restore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Restore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mysql.v1.ClusterService/Restore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Restore(ctx, req.(*RestoreClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_StartFailover_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartClusterFailoverRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).StartFailover(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mysql.v1.ClusterService/StartFailover",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).StartFailover(ctx, req.(*StartClusterFailoverRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_ListLogs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClusterLogsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).ListLogs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mysql.v1.ClusterService/ListLogs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).ListLogs(ctx, req.(*ListClusterLogsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_StreamLogs_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(StreamClusterLogsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ClusterServiceServer).StreamLogs(m, &clusterServiceStreamLogsServer{stream})
}

type ClusterService_StreamLogsServer interface {
	Send(*LogRecord) error
	grpc.ServerStream
}

type clusterServiceStreamLogsServer struct {
	grpc.ServerStream
}

func (x *clusterServiceStreamLogsServer) Send(m *LogRecord) error {
	return x.ServerStream.SendMsg(m)
}

func _ClusterService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClusterOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mysql.v1.ClusterService/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).ListOperations(ctx, req.(*ListClusterOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_ListBackups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClusterBackupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).ListBackups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mysql.v1.ClusterService/ListBackups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).ListBackups(ctx, req.(*ListClusterBackupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_ListHosts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClusterHostsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).ListHosts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mysql.v1.ClusterService/ListHosts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).ListHosts(ctx, req.(*ListClusterHostsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_AddHosts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddClusterHostsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).AddHosts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mysql.v1.ClusterService/AddHosts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).AddHosts(ctx, req.(*AddClusterHostsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_DeleteHosts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterHostsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).DeleteHosts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mysql.v1.ClusterService/DeleteHosts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).DeleteHosts(ctx, req.(*DeleteClusterHostsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ClusterService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.mdb.mysql.v1.ClusterService",
	HandlerType: (*ClusterServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _ClusterService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _ClusterService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _ClusterService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _ClusterService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _ClusterService_Delete_Handler,
		},
		{
			MethodName: "Start",
			Handler:    _ClusterService_Start_Handler,
		},
		{
			MethodName: "Stop",
			Handler:    _ClusterService_Stop_Handler,
		},
		{
			MethodName: "Move",
			Handler:    _ClusterService_Move_Handler,
		},
		{
			MethodName: "Backup",
			Handler:    _ClusterService_Backup_Handler,
		},
		{
			MethodName: "Restore",
			Handler:    _ClusterService_Restore_Handler,
		},
		{
			MethodName: "StartFailover",
			Handler:    _ClusterService_StartFailover_Handler,
		},
		{
			MethodName: "ListLogs",
			Handler:    _ClusterService_ListLogs_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _ClusterService_ListOperations_Handler,
		},
		{
			MethodName: "ListBackups",
			Handler:    _ClusterService_ListBackups_Handler,
		},
		{
			MethodName: "ListHosts",
			Handler:    _ClusterService_ListHosts_Handler,
		},
		{
			MethodName: "AddHosts",
			Handler:    _ClusterService_AddHosts_Handler,
		},
		{
			MethodName: "DeleteHosts",
			Handler:    _ClusterService_DeleteHosts_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamLogs",
			Handler:       _ClusterService_StreamLogs_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "yandex/cloud/mdb/mysql/v1/cluster_service.proto",
}
