// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/resourcemanager/v1/folder_service.proto

package resourcemanager

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	access "github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type GetFolderRequest struct {
	// ID of the Folder resource to return.
	// To get the folder ID, use a [FolderService.List] request.
	FolderId             string   `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetFolderRequest) Reset()         { *m = GetFolderRequest{} }
func (m *GetFolderRequest) String() string { return proto.CompactTextString(m) }
func (*GetFolderRequest) ProtoMessage()    {}
func (*GetFolderRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ee014449f956281, []int{0}
}

func (m *GetFolderRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetFolderRequest.Unmarshal(m, b)
}
func (m *GetFolderRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetFolderRequest.Marshal(b, m, deterministic)
}
func (m *GetFolderRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetFolderRequest.Merge(m, src)
}
func (m *GetFolderRequest) XXX_Size() int {
	return xxx_messageInfo_GetFolderRequest.Size(m)
}
func (m *GetFolderRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetFolderRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetFolderRequest proto.InternalMessageInfo

func (m *GetFolderRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

type ListFoldersRequest struct {
	// ID of the cloud to list folders in.
	// To get the cloud ID, use a [yandex.cloud.resourcemanager.v1.CloudService.List] request.
	CloudId string `protobuf:"bytes,1,opt,name=cloud_id,json=cloudId,proto3" json:"cloud_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListFoldersResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. Set [page_token]
	// to the [ListFoldersResponse.next_page_token]
	// returned by a previous list request to get the next page of results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// The expression must specify:
	// 1. The field name. Currently you can use filtering only on the [Folder.name] field.
	// 2. An operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.
	// 3. The value. Must be 3-63 characters long and match the regular expression `^[a-z][-a-z0-9]{1,61}[a-z0-9]$`.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFoldersRequest) Reset()         { *m = ListFoldersRequest{} }
func (m *ListFoldersRequest) String() string { return proto.CompactTextString(m) }
func (*ListFoldersRequest) ProtoMessage()    {}
func (*ListFoldersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ee014449f956281, []int{1}
}

func (m *ListFoldersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFoldersRequest.Unmarshal(m, b)
}
func (m *ListFoldersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFoldersRequest.Marshal(b, m, deterministic)
}
func (m *ListFoldersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFoldersRequest.Merge(m, src)
}
func (m *ListFoldersRequest) XXX_Size() int {
	return xxx_messageInfo_ListFoldersRequest.Size(m)
}
func (m *ListFoldersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFoldersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListFoldersRequest proto.InternalMessageInfo

func (m *ListFoldersRequest) GetCloudId() string {
	if m != nil {
		return m.CloudId
	}
	return ""
}

func (m *ListFoldersRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListFoldersRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListFoldersRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListFoldersResponse struct {
	// List of Folder resources.
	Folders []*Folder `protobuf:"bytes,1,rep,name=folders,proto3" json:"folders,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListFoldersRequest.page_size], use
	// the [next_page_token] as the value
	// for the [ListFoldersRequest.page_token] query parameter
	// in the next list request. Each subsequent list request will have its own
	// [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFoldersResponse) Reset()         { *m = ListFoldersResponse{} }
func (m *ListFoldersResponse) String() string { return proto.CompactTextString(m) }
func (*ListFoldersResponse) ProtoMessage()    {}
func (*ListFoldersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ee014449f956281, []int{2}
}

func (m *ListFoldersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFoldersResponse.Unmarshal(m, b)
}
func (m *ListFoldersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFoldersResponse.Marshal(b, m, deterministic)
}
func (m *ListFoldersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFoldersResponse.Merge(m, src)
}
func (m *ListFoldersResponse) XXX_Size() int {
	return xxx_messageInfo_ListFoldersResponse.Size(m)
}
func (m *ListFoldersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFoldersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListFoldersResponse proto.InternalMessageInfo

func (m *ListFoldersResponse) GetFolders() []*Folder {
	if m != nil {
		return m.Folders
	}
	return nil
}

func (m *ListFoldersResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateFolderRequest struct {
	// ID of the cloud to create a folder in.
	// To get the cloud ID, use a [yandex.cloud.resourcemanager.v1.CloudService.List] request.
	CloudId string `protobuf:"bytes,1,opt,name=cloud_id,json=cloudId,proto3" json:"cloud_id,omitempty"`
	// Name of the folder.
	// The name must be unique within the cloud.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the folder.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `` key:value `` pairs.
	Labels               map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CreateFolderRequest) Reset()         { *m = CreateFolderRequest{} }
func (m *CreateFolderRequest) String() string { return proto.CompactTextString(m) }
func (*CreateFolderRequest) ProtoMessage()    {}
func (*CreateFolderRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ee014449f956281, []int{3}
}

func (m *CreateFolderRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateFolderRequest.Unmarshal(m, b)
}
func (m *CreateFolderRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateFolderRequest.Marshal(b, m, deterministic)
}
func (m *CreateFolderRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateFolderRequest.Merge(m, src)
}
func (m *CreateFolderRequest) XXX_Size() int {
	return xxx_messageInfo_CreateFolderRequest.Size(m)
}
func (m *CreateFolderRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateFolderRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateFolderRequest proto.InternalMessageInfo

func (m *CreateFolderRequest) GetCloudId() string {
	if m != nil {
		return m.CloudId
	}
	return ""
}

func (m *CreateFolderRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateFolderRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *CreateFolderRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

type CreateFolderMetadata struct {
	// ID of the folder that is being created.
	FolderId             string   `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateFolderMetadata) Reset()         { *m = CreateFolderMetadata{} }
func (m *CreateFolderMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateFolderMetadata) ProtoMessage()    {}
func (*CreateFolderMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ee014449f956281, []int{4}
}

func (m *CreateFolderMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateFolderMetadata.Unmarshal(m, b)
}
func (m *CreateFolderMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateFolderMetadata.Marshal(b, m, deterministic)
}
func (m *CreateFolderMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateFolderMetadata.Merge(m, src)
}
func (m *CreateFolderMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateFolderMetadata.Size(m)
}
func (m *CreateFolderMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateFolderMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateFolderMetadata proto.InternalMessageInfo

func (m *CreateFolderMetadata) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

type UpdateFolderRequest struct {
	// ID of the Folder resource to update.
	// To get the folder ID, use a [FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Field mask that specifies which fields of the Folder resource are going to be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Name of the folder.
	// The name must be unique within the cloud.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the folder.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `` key:value `` pairs.
	Labels               map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UpdateFolderRequest) Reset()         { *m = UpdateFolderRequest{} }
func (m *UpdateFolderRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateFolderRequest) ProtoMessage()    {}
func (*UpdateFolderRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ee014449f956281, []int{5}
}

func (m *UpdateFolderRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateFolderRequest.Unmarshal(m, b)
}
func (m *UpdateFolderRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateFolderRequest.Marshal(b, m, deterministic)
}
func (m *UpdateFolderRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateFolderRequest.Merge(m, src)
}
func (m *UpdateFolderRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateFolderRequest.Size(m)
}
func (m *UpdateFolderRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateFolderRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateFolderRequest proto.InternalMessageInfo

func (m *UpdateFolderRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *UpdateFolderRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateFolderRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateFolderRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *UpdateFolderRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

type UpdateFolderMetadata struct {
	// ID of the Folder resource that is being updated.
	FolderId             string   `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateFolderMetadata) Reset()         { *m = UpdateFolderMetadata{} }
func (m *UpdateFolderMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateFolderMetadata) ProtoMessage()    {}
func (*UpdateFolderMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ee014449f956281, []int{6}
}

func (m *UpdateFolderMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateFolderMetadata.Unmarshal(m, b)
}
func (m *UpdateFolderMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateFolderMetadata.Marshal(b, m, deterministic)
}
func (m *UpdateFolderMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateFolderMetadata.Merge(m, src)
}
func (m *UpdateFolderMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateFolderMetadata.Size(m)
}
func (m *UpdateFolderMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateFolderMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateFolderMetadata proto.InternalMessageInfo

func (m *UpdateFolderMetadata) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

type DeleteFolderRequest struct {
	// ID of the folder to delete.
	// To get the folder ID, use a [FolderService.List] request.
	FolderId             string   `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteFolderRequest) Reset()         { *m = DeleteFolderRequest{} }
func (m *DeleteFolderRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteFolderRequest) ProtoMessage()    {}
func (*DeleteFolderRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ee014449f956281, []int{7}
}

func (m *DeleteFolderRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteFolderRequest.Unmarshal(m, b)
}
func (m *DeleteFolderRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteFolderRequest.Marshal(b, m, deterministic)
}
func (m *DeleteFolderRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteFolderRequest.Merge(m, src)
}
func (m *DeleteFolderRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteFolderRequest.Size(m)
}
func (m *DeleteFolderRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteFolderRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteFolderRequest proto.InternalMessageInfo

func (m *DeleteFolderRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

type DeleteFolderMetadata struct {
	// ID of the folder that is being deleted.
	FolderId             string   `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteFolderMetadata) Reset()         { *m = DeleteFolderMetadata{} }
func (m *DeleteFolderMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteFolderMetadata) ProtoMessage()    {}
func (*DeleteFolderMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ee014449f956281, []int{8}
}

func (m *DeleteFolderMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteFolderMetadata.Unmarshal(m, b)
}
func (m *DeleteFolderMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteFolderMetadata.Marshal(b, m, deterministic)
}
func (m *DeleteFolderMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteFolderMetadata.Merge(m, src)
}
func (m *DeleteFolderMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteFolderMetadata.Size(m)
}
func (m *DeleteFolderMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteFolderMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteFolderMetadata proto.InternalMessageInfo

func (m *DeleteFolderMetadata) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

type ListFolderOperationsRequest struct {
	// ID of the Folder resource to list operations for.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListFolderOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. Set [page_token]
	// to the [ListFolderOperationsResponse.next_page_token]
	// returned by a previous list request to get the next page of results.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFolderOperationsRequest) Reset()         { *m = ListFolderOperationsRequest{} }
func (m *ListFolderOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListFolderOperationsRequest) ProtoMessage()    {}
func (*ListFolderOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ee014449f956281, []int{9}
}

func (m *ListFolderOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFolderOperationsRequest.Unmarshal(m, b)
}
func (m *ListFolderOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFolderOperationsRequest.Marshal(b, m, deterministic)
}
func (m *ListFolderOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFolderOperationsRequest.Merge(m, src)
}
func (m *ListFolderOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListFolderOperationsRequest.Size(m)
}
func (m *ListFolderOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFolderOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListFolderOperationsRequest proto.InternalMessageInfo

func (m *ListFolderOperationsRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *ListFolderOperationsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListFolderOperationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListFolderOperationsResponse struct {
	// List of operations for the specified folder.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListFolderOperationsRequest.page_size], use the [next_page_token] as the value
	// for the [ListFolderOperationsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFolderOperationsResponse) Reset()         { *m = ListFolderOperationsResponse{} }
func (m *ListFolderOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListFolderOperationsResponse) ProtoMessage()    {}
func (*ListFolderOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ee014449f956281, []int{10}
}

func (m *ListFolderOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFolderOperationsResponse.Unmarshal(m, b)
}
func (m *ListFolderOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFolderOperationsResponse.Marshal(b, m, deterministic)
}
func (m *ListFolderOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFolderOperationsResponse.Merge(m, src)
}
func (m *ListFolderOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListFolderOperationsResponse.Size(m)
}
func (m *ListFolderOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFolderOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListFolderOperationsResponse proto.InternalMessageInfo

func (m *ListFolderOperationsResponse) GetOperations() []*operation.Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListFolderOperationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*GetFolderRequest)(nil), "yandex.cloud.resourcemanager.v1.GetFolderRequest")
	proto.RegisterType((*ListFoldersRequest)(nil), "yandex.cloud.resourcemanager.v1.ListFoldersRequest")
	proto.RegisterType((*ListFoldersResponse)(nil), "yandex.cloud.resourcemanager.v1.ListFoldersResponse")
	proto.RegisterType((*CreateFolderRequest)(nil), "yandex.cloud.resourcemanager.v1.CreateFolderRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.resourcemanager.v1.CreateFolderRequest.LabelsEntry")
	proto.RegisterType((*CreateFolderMetadata)(nil), "yandex.cloud.resourcemanager.v1.CreateFolderMetadata")
	proto.RegisterType((*UpdateFolderRequest)(nil), "yandex.cloud.resourcemanager.v1.UpdateFolderRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.resourcemanager.v1.UpdateFolderRequest.LabelsEntry")
	proto.RegisterType((*UpdateFolderMetadata)(nil), "yandex.cloud.resourcemanager.v1.UpdateFolderMetadata")
	proto.RegisterType((*DeleteFolderRequest)(nil), "yandex.cloud.resourcemanager.v1.DeleteFolderRequest")
	proto.RegisterType((*DeleteFolderMetadata)(nil), "yandex.cloud.resourcemanager.v1.DeleteFolderMetadata")
	proto.RegisterType((*ListFolderOperationsRequest)(nil), "yandex.cloud.resourcemanager.v1.ListFolderOperationsRequest")
	proto.RegisterType((*ListFolderOperationsResponse)(nil), "yandex.cloud.resourcemanager.v1.ListFolderOperationsResponse")
}

func init() {
	proto.RegisterFile("yandex/cloud/resourcemanager/v1/folder_service.proto", fileDescriptor_7ee014449f956281)
}

var fileDescriptor_7ee014449f956281 = []byte{
	// 1116 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x57, 0xcd, 0x6f, 0x1b, 0x45,
	0x14, 0xd7, 0xc4, 0xae, 0x1b, 0x3f, 0x13, 0x08, 0x93, 0x22, 0x59, 0x6e, 0x5a, 0xd2, 0x2d, 0x34,
	0xc1, 0x74, 0x77, 0xbd, 0xf9, 0x12, 0xf9, 0x52, 0x1a, 0xd3, 0xb4, 0x8a, 0xd4, 0x0a, 0xb4, 0xa1,
	0x17, 0xa2, 0x2a, 0x9a, 0x78, 0x27, 0x66, 0x95, 0xf5, 0xae, 0xd9, 0x59, 0x5b, 0x8d, 0x4b, 0x25,
	0x54, 0x71, 0x21, 0xd7, 0x1e, 0x10, 0xe2, 0x5f, 0xe0, 0x14, 0x71, 0xe0, 0xd0, 0x23, 0x52, 0x22,
	0x8e, 0xe1, 0x5f, 0x40, 0x88, 0x03, 0xa7, 0x9e, 0x10, 0x12, 0x12, 0xda, 0x99, 0x5d, 0x67, 0x6d,
	0x6f, 0xe2, 0x75, 0xe0, 0xc0, 0xc9, 0x3b, 0x3b, 0xef, 0xe3, 0xf7, 0x7b, 0xef, 0xcd, 0x6f, 0xd6,
	0x30, 0xbb, 0x4f, 0x6c, 0x83, 0x3e, 0x51, 0x2b, 0x96, 0xd3, 0x30, 0x54, 0x97, 0x32, 0xa7, 0xe1,
	0x56, 0x68, 0x8d, 0xd8, 0xa4, 0x4a, 0x5d, 0xb5, 0xa9, 0xa9, 0xbb, 0x8e, 0x65, 0x50, 0x77, 0x9b,
	0x51, 0xb7, 0x69, 0x56, 0xa8, 0x52, 0x77, 0x1d, 0xcf, 0xc1, 0x6f, 0x0b, 0x2f, 0x85, 0x7b, 0x29,
	0x5d, 0x5e, 0x4a, 0x53, 0x2b, 0x8c, 0x57, 0x1d, 0xa7, 0x6a, 0x51, 0x95, 0xd4, 0x4d, 0x95, 0xd8,
	0xb6, 0xe3, 0x11, 0xcf, 0x74, 0x6c, 0x26, 0xdc, 0x0b, 0x13, 0xc1, 0x2e, 0x5f, 0xed, 0x34, 0x76,
	0xd5, 0x5d, 0x93, 0x5a, 0xc6, 0x76, 0x8d, 0xb0, 0xbd, 0xd0, 0xa2, 0x03, 0x96, 0x1f, 0xc5, 0xa9,
	0x53, 0x97, 0x07, 0x09, 0x2c, 0x6e, 0x27, 0x03, 0x1e, 0x1f, 0xaf, 0x52, 0xa1, 0x8c, 0x05, 0x3f,
	0x81, 0xc5, 0xad, 0x0e, 0x8b, 0x76, 0xb6, 0x9e, 0xbc, 0xd7, 0x3a, 0xec, 0x9a, 0xc4, 0x32, 0x8d,
	0xc8, 0xb6, 0xb4, 0x02, 0xa3, 0xf7, 0xa9, 0x77, 0x8f, 0xe7, 0xd6, 0xe9, 0xe7, 0x0d, 0xca, 0x3c,
	0xfc, 0x1e, 0x64, 0x83, 0x2a, 0x9a, 0x46, 0x1e, 0x4d, 0xa0, 0xa9, 0x6c, 0xf9, 0xb5, 0xdf, 0x8f,
	0x34, 0x74, 0x70, 0xac, 0xa5, 0x97, 0x57, 0xe6, 0x4a, 0xfa, 0xb0, 0xd8, 0xde, 0x30, 0xa4, 0x1f,
	0x10, 0xe0, 0x07, 0x26, 0x0b, 0x02, 0xb0, 0x30, 0xc2, 0x24, 0x0c, 0xf3, 0x7c, 0x67, 0x05, 0xb8,
	0xcc, 0x77, 0x37, 0x0c, 0x3c, 0x09, 0xd9, 0x3a, 0xa9, 0xd2, 0x6d, 0x66, 0xb6, 0x68, 0x7e, 0x68,
	0x02, 0x4d, 0xa5, 0xca, 0xf0, 0xd7, 0x91, 0x96, 0x59, 0x5e, 0xd1, 0x4a, 0xa5, 0x92, 0x3e, 0xec,
	0x6f, 0x6e, 0x9a, 0x2d, 0x8a, 0xa7, 0x00, 0xb8, 0xa1, 0xe7, 0xec, 0x51, 0x3b, 0x9f, 0xe2, 0x31,
	0xb3, 0x07, 0xc7, 0xda, 0x25, 0x6e, 0xa9, 0xf3, 0x28, 0x9f, 0xf8, 0x7b, 0x58, 0x82, 0xcc, 0xae,
	0x69, 0x79, 0xd4, 0xcd, 0xa7, 0xb9, 0x15, 0x1c, 0x1c, 0xb7, 0xe3, 0x05, 0x3b, 0xd2, 0x97, 0x08,
	0xc6, 0x3a, 0x60, 0xb3, 0xba, 0x63, 0x33, 0x8a, 0xd7, 0xe0, 0xb2, 0xa0, 0xc6, 0xf2, 0x68, 0x22,
	0x35, 0x95, 0x9b, 0x9e, 0x54, 0xfa, 0x4c, 0x8e, 0x12, 0x94, 0x2e, 0xf4, 0xc3, 0xb7, 0xe0, 0x0d,
	0x9b, 0x3e, 0xf1, 0xb6, 0x23, 0x68, 0x7d, 0x5e, 0x59, 0x7d, 0xc4, 0x7f, 0xfd, 0x71, 0x08, 0x53,
	0xfa, 0x7b, 0x08, 0xc6, 0x3e, 0x74, 0x29, 0xf1, 0x68, 0x67, 0xf1, 0x13, 0x97, 0x6e, 0x01, 0xd2,
	0x36, 0xa9, 0x89, 0xaa, 0x65, 0xcb, 0xef, 0xfa, 0x46, 0xaf, 0x8e, 0xb4, 0x6b, 0x5f, 0x6c, 0x11,
	0xb9, 0xf5, 0x78, 0x4b, 0x26, 0x72, 0xab, 0x24, 0x2f, 0x3c, 0x7e, 0xaa, 0xdd, 0x9e, 0xd7, 0x9e,
	0x6d, 0x05, 0x2b, 0x9d, 0xbb, 0xe0, 0xf7, 0x21, 0x67, 0x50, 0x56, 0x71, 0xcd, 0xba, 0x3f, 0x09,
	0x9d, 0xd5, 0x9c, 0x9e, 0x9b, 0xd7, 0xa3, 0xbb, 0xf8, 0x5b, 0x04, 0x19, 0x8b, 0xec, 0x50, 0x8b,
	0xe5, 0xd3, 0xbc, 0x26, 0x77, 0xfa, 0xd6, 0x24, 0x86, 0x97, 0xf2, 0x80, 0x87, 0x58, 0xb7, 0x3d,
	0x77, 0xbf, 0xbc, 0xfa, 0xea, 0x48, 0xcb, 0x6d, 0xc9, 0xdb, 0x25, 0x79, 0xc1, 0x07, 0x5b, 0x7c,
	0xce, 0xc9, 0xcd, 0xcf, 0x0a, 0x92, 0xf3, 0x33, 0x87, 0xc7, 0x5a, 0xa6, 0x90, 0xd6, 0x64, 0xfe,
	0x84, 0xf1, 0x68, 0x40, 0xa9, 0x6d, 0xaf, 0x07, 0x80, 0x0a, 0x0b, 0x90, 0x8b, 0xc4, 0xc5, 0xa3,
	0x90, 0xda, 0xa3, 0xfb, 0xa2, 0x6c, 0xba, 0xff, 0x88, 0xaf, 0xc0, 0xa5, 0x26, 0xb1, 0x1a, 0x41,
	0x95, 0x74, 0xb1, 0x58, 0x1c, 0xfa, 0x00, 0x49, 0x33, 0x70, 0x25, 0x0a, 0xf3, 0x21, 0xf5, 0x88,
	0x41, 0x3c, 0x82, 0xaf, 0xf6, 0x0c, 0x7f, 0x64, 0xdc, 0x5f, 0xa6, 0x60, 0xec, 0x51, 0xdd, 0xe8,
	0x69, 0x5a, 0xf2, 0x13, 0x83, 0x97, 0x20, 0xd7, 0xe0, 0x11, 0xb8, 0x7c, 0x70, 0x5c, 0xb9, 0xe9,
	0x82, 0x22, 0x14, 0x46, 0x09, 0x15, 0x46, 0xb9, 0xe7, 0x2b, 0xcc, 0x43, 0xc2, 0xf6, 0x74, 0x10,
	0xe6, 0xfe, 0x73, 0xbb, 0xe7, 0xa9, 0x7f, 0xdd, 0xf3, 0x74, 0xd2, 0x9e, 0x5f, 0x4a, 0xd8, 0xf3,
	0x98, 0xb2, 0xfc, 0x1f, 0x7b, 0x1e, 0x85, 0x99, 0xac, 0xe7, 0x77, 0x60, 0xec, 0x2e, 0xb5, 0xe8,
	0xc5, 0x5b, 0xee, 0xa7, 0x8d, 0x46, 0x48, 0x96, 0xf6, 0x3b, 0x04, 0x57, 0x4f, 0x25, 0xea, 0xa3,
	0x50, 0xd5, 0xd9, 0x05, 0x46, 0xee, 0xbf, 0x17, 0x59, 0xe9, 0x6b, 0x04, 0xe3, 0xf1, 0xe8, 0xda,
	0x4a, 0x0a, 0xed, 0x9b, 0x28, 0x14, 0xd3, 0x1b, 0x9d, 0x43, 0x74, 0x7a, 0x53, 0xb5, 0xfd, 0xf5,
	0x88, 0x53, 0x52, 0x25, 0x9d, 0xfe, 0x6d, 0x04, 0x46, 0x04, 0x8e, 0x4d, 0x71, 0xe9, 0xe3, 0x17,
	0x08, 0x52, 0xf7, 0xa9, 0x87, 0xb5, 0xbe, 0x53, 0xdb, 0x7d, 0xf7, 0x15, 0x92, 0x0a, 0xbe, 0x54,
	0x7a, 0xfe, 0xcb, 0xaf, 0x2f, 0x86, 0x8a, 0x78, 0xaa, 0x7d, 0x97, 0xcb, 0x3d, 0x97, 0x39, 0x53,
	0x9f, 0xb6, 0x7b, 0xf4, 0x0c, 0x7f, 0x83, 0x20, 0xed, 0xd7, 0x0c, 0xcf, 0xf4, 0xcd, 0xd1, 0x7b,
	0xa5, 0x16, 0x66, 0x07, 0x73, 0x12, 0x6d, 0x90, 0xde, 0xe1, 0x28, 0xaf, 0xe3, 0xf1, 0xf3, 0x50,
	0xe2, 0xef, 0x11, 0x64, 0x84, 0x18, 0xe2, 0xd9, 0x8b, 0x88, 0x7b, 0xa1, 0x7f, 0x67, 0xa5, 0x8d,
	0xc3, 0x93, 0xe2, 0xf5, 0x33, 0x34, 0x37, 0x23, 0xd6, 0x1c, 0xeb, 0x0d, 0xe9, 0x5c, 0xac, 0x8b,
	0xa8, 0x88, 0x7f, 0x44, 0x90, 0x11, 0xe7, 0x38, 0x01, 0xdc, 0x18, 0x5d, 0x4a, 0x02, 0xf7, 0x91,
	0x80, 0x1b, 0x2b, 0x17, 0x51, 0xb8, 0xf2, 0x74, 0xe2, 0x01, 0xf0, 0xa1, 0xff, 0x84, 0x20, 0x23,
	0xb4, 0x20, 0x01, 0xf4, 0x18, 0xd9, 0x49, 0x02, 0x9d, 0x1c, 0x9e, 0x14, 0xe5, 0x33, 0x24, 0xe7,
	0xad, 0xee, 0x7b, 0x66, 0xbd, 0x56, 0xf7, 0xf6, 0xc5, 0x28, 0x17, 0x93, 0x8f, 0xf2, 0xcf, 0x08,
	0x5e, 0xf7, 0xc7, 0xed, 0xf4, 0xe0, 0xe3, 0xe5, 0x01, 0xe6, 0xb3, 0x47, 0xcd, 0x0a, 0x2b, 0x17,
	0xf4, 0x0e, 0xc6, 0x7c, 0x89, 0x33, 0x98, 0xc3, 0x33, 0x49, 0x19, 0xa8, 0x11, 0x9d, 0x79, 0x19,
	0x7c, 0xc3, 0xae, 0xf1, 0xcf, 0xeb, 0xb2, 0x69, 0x1b, 0xa6, 0x5d, 0x65, 0x58, 0xe9, 0x84, 0x14,
	0x7c, 0x7c, 0xf7, 0x1a, 0x86, 0x14, 0xd4, 0xc4, 0xf6, 0x01, 0xe8, 0x75, 0x0e, 0x7a, 0x15, 0xaf,
	0x9c, 0x0f, 0x3a, 0xdc, 0xe4, 0x23, 0x64, 0xf5, 0xe2, 0xfc, 0x03, 0xc1, 0x9b, 0x9b, 0xb4, 0xfb,
	0xad, 0x1c, 0x8b, 0xa6, 0xc7, 0x6e, 0x80, 0xb1, 0xfa, 0x0a, 0x1d, 0x9e, 0x14, 0x17, 0x60, 0xe2,
	0xac, 0x50, 0x49, 0x66, 0x6c, 0x4d, 0x5a, 0x1e, 0x80, 0x2c, 0xeb, 0x4e, 0xe1, 0x9f, 0xa0, 0x3f,
	0x51, 0x78, 0x2a, 0xbb, 0x18, 0x97, 0x62, 0x19, 0xc7, 0x99, 0x0e, 0x40, 0xfa, 0xc0, 0x27, 0xbd,
	0x0c, 0x37, 0xcf, 0x89, 0x96, 0x84, 0xf7, 0x5d, 0x69, 0x75, 0x00, 0xde, 0x8d, 0x98, 0x2c, 0x8b,
	0xa8, 0x58, 0x6e, 0xc1, 0xcd, 0x4e, 0x8a, 0x75, 0x33, 0xe6, 0xa4, 0x7c, 0xba, 0x59, 0x35, 0xbd,
	0xcf, 0x1a, 0x3b, 0x4a, 0xc5, 0xa9, 0xa9, 0xc2, 0x5e, 0x16, 0x7f, 0xfe, 0xaa, 0x8e, 0x5c, 0xa5,
	0x36, 0x87, 0xa7, 0xf6, 0xf9, 0x37, 0xba, 0xd4, 0xf5, 0x6a, 0x27, 0xc3, 0xdd, 0x66, 0xfe, 0x09,
	0x00, 0x00, 0xff, 0xff, 0xb3, 0x28, 0x77, 0x5f, 0x80, 0x0f, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// FolderServiceClient is the client API for FolderService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type FolderServiceClient interface {
	// Returns the specified Folder resource.
	//
	// To get the list of available Folder resources, make a [List] request.
	Get(ctx context.Context, in *GetFolderRequest, opts ...grpc.CallOption) (*Folder, error)
	// Retrieves the list of Folder resources in the specified cloud.
	List(ctx context.Context, in *ListFoldersRequest, opts ...grpc.CallOption) (*ListFoldersResponse, error)
	// Creates a folder in the specified cloud.
	Create(ctx context.Context, in *CreateFolderRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified folder.
	Update(ctx context.Context, in *UpdateFolderRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified folder.
	//
	// The method is temporarily unavailable.
	Delete(ctx context.Context, in *DeleteFolderRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists operations for the specified folder.
	ListOperations(ctx context.Context, in *ListFolderOperationsRequest, opts ...grpc.CallOption) (*ListFolderOperationsResponse, error)
	// Lists access bindings for the specified folder.
	ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error)
	// Sets access bindings for the specified folder.
	SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates access bindings for the specified folder.
	UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
}

type folderServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewFolderServiceClient(cc grpc.ClientConnInterface) FolderServiceClient {
	return &folderServiceClient{cc}
}

func (c *folderServiceClient) Get(ctx context.Context, in *GetFolderRequest, opts ...grpc.CallOption) (*Folder, error) {
	out := new(Folder)
	err := c.cc.Invoke(ctx, "/yandex.cloud.resourcemanager.v1.FolderService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *folderServiceClient) List(ctx context.Context, in *ListFoldersRequest, opts ...grpc.CallOption) (*ListFoldersResponse, error) {
	out := new(ListFoldersResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.resourcemanager.v1.FolderService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *folderServiceClient) Create(ctx context.Context, in *CreateFolderRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.resourcemanager.v1.FolderService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *folderServiceClient) Update(ctx context.Context, in *UpdateFolderRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.resourcemanager.v1.FolderService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *folderServiceClient) Delete(ctx context.Context, in *DeleteFolderRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.resourcemanager.v1.FolderService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *folderServiceClient) ListOperations(ctx context.Context, in *ListFolderOperationsRequest, opts ...grpc.CallOption) (*ListFolderOperationsResponse, error) {
	out := new(ListFolderOperationsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.resourcemanager.v1.FolderService/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *folderServiceClient) ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error) {
	out := new(access.ListAccessBindingsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.resourcemanager.v1.FolderService/ListAccessBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *folderServiceClient) SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.resourcemanager.v1.FolderService/SetAccessBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *folderServiceClient) UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.resourcemanager.v1.FolderService/UpdateAccessBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FolderServiceServer is the server API for FolderService service.
type FolderServiceServer interface {
	// Returns the specified Folder resource.
	//
	// To get the list of available Folder resources, make a [List] request.
	Get(context.Context, *GetFolderRequest) (*Folder, error)
	// Retrieves the list of Folder resources in the specified cloud.
	List(context.Context, *ListFoldersRequest) (*ListFoldersResponse, error)
	// Creates a folder in the specified cloud.
	Create(context.Context, *CreateFolderRequest) (*operation.Operation, error)
	// Updates the specified folder.
	Update(context.Context, *UpdateFolderRequest) (*operation.Operation, error)
	// Deletes the specified folder.
	//
	// The method is temporarily unavailable.
	Delete(context.Context, *DeleteFolderRequest) (*operation.Operation, error)
	// Lists operations for the specified folder.
	ListOperations(context.Context, *ListFolderOperationsRequest) (*ListFolderOperationsResponse, error)
	// Lists access bindings for the specified folder.
	ListAccessBindings(context.Context, *access.ListAccessBindingsRequest) (*access.ListAccessBindingsResponse, error)
	// Sets access bindings for the specified folder.
	SetAccessBindings(context.Context, *access.SetAccessBindingsRequest) (*operation.Operation, error)
	// Updates access bindings for the specified folder.
	UpdateAccessBindings(context.Context, *access.UpdateAccessBindingsRequest) (*operation.Operation, error)
}

// UnimplementedFolderServiceServer can be embedded to have forward compatible implementations.
type UnimplementedFolderServiceServer struct {
}

func (*UnimplementedFolderServiceServer) Get(ctx context.Context, req *GetFolderRequest) (*Folder, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedFolderServiceServer) List(ctx context.Context, req *ListFoldersRequest) (*ListFoldersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedFolderServiceServer) Create(ctx context.Context, req *CreateFolderRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (*UnimplementedFolderServiceServer) Update(ctx context.Context, req *UpdateFolderRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (*UnimplementedFolderServiceServer) Delete(ctx context.Context, req *DeleteFolderRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedFolderServiceServer) ListOperations(ctx context.Context, req *ListFolderOperationsRequest) (*ListFolderOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOperations not implemented")
}
func (*UnimplementedFolderServiceServer) ListAccessBindings(ctx context.Context, req *access.ListAccessBindingsRequest) (*access.ListAccessBindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAccessBindings not implemented")
}
func (*UnimplementedFolderServiceServer) SetAccessBindings(ctx context.Context, req *access.SetAccessBindingsRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetAccessBindings not implemented")
}
func (*UnimplementedFolderServiceServer) UpdateAccessBindings(ctx context.Context, req *access.UpdateAccessBindingsRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAccessBindings not implemented")
}

func RegisterFolderServiceServer(s *grpc.Server, srv FolderServiceServer) {
	s.RegisterService(&_FolderService_serviceDesc, srv)
}

func _FolderService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FolderServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.resourcemanager.v1.FolderService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FolderServiceServer).Get(ctx, req.(*GetFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FolderService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFoldersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FolderServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.resourcemanager.v1.FolderService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FolderServiceServer).List(ctx, req.(*ListFoldersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FolderService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FolderServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.resourcemanager.v1.FolderService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FolderServiceServer).Create(ctx, req.(*CreateFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FolderService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FolderServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.resourcemanager.v1.FolderService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FolderServiceServer).Update(ctx, req.(*UpdateFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FolderService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FolderServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.resourcemanager.v1.FolderService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FolderServiceServer).Delete(ctx, req.(*DeleteFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FolderService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFolderOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FolderServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.resourcemanager.v1.FolderService/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FolderServiceServer).ListOperations(ctx, req.(*ListFolderOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FolderService_ListAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.ListAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FolderServiceServer).ListAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.resourcemanager.v1.FolderService/ListAccessBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FolderServiceServer).ListAccessBindings(ctx, req.(*access.ListAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FolderService_SetAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.SetAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FolderServiceServer).SetAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.resourcemanager.v1.FolderService/SetAccessBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FolderServiceServer).SetAccessBindings(ctx, req.(*access.SetAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FolderService_UpdateAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.UpdateAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FolderServiceServer).UpdateAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.resourcemanager.v1.FolderService/UpdateAccessBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FolderServiceServer).UpdateAccessBindings(ctx, req.(*access.UpdateAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _FolderService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.resourcemanager.v1.FolderService",
	HandlerType: (*FolderServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _FolderService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _FolderService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _FolderService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _FolderService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _FolderService_Delete_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _FolderService_ListOperations_Handler,
		},
		{
			MethodName: "ListAccessBindings",
			Handler:    _FolderService_ListAccessBindings_Handler,
		},
		{
			MethodName: "SetAccessBindings",
			Handler:    _FolderService_SetAccessBindings_Handler,
		},
		{
			MethodName: "UpdateAccessBindings",
			Handler:    _FolderService_UpdateAccessBindings_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/resourcemanager/v1/folder_service.proto",
}
