// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/serverless/functions/v1/function_service.proto

package functions

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	access "github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type GetFunctionRequest struct {
	// ID of the function to return.
	//
	// To get a function ID make a [FunctionService.List] request.
	FunctionId           string   `protobuf:"bytes,1,opt,name=function_id,json=functionId,proto3" json:"function_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetFunctionRequest) Reset()         { *m = GetFunctionRequest{} }
func (m *GetFunctionRequest) String() string { return proto.CompactTextString(m) }
func (*GetFunctionRequest) ProtoMessage()    {}
func (*GetFunctionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a91c4c30ec2c5ca, []int{0}
}

func (m *GetFunctionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetFunctionRequest.Unmarshal(m, b)
}
func (m *GetFunctionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetFunctionRequest.Marshal(b, m, deterministic)
}
func (m *GetFunctionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetFunctionRequest.Merge(m, src)
}
func (m *GetFunctionRequest) XXX_Size() int {
	return xxx_messageInfo_GetFunctionRequest.Size(m)
}
func (m *GetFunctionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetFunctionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetFunctionRequest proto.InternalMessageInfo

func (m *GetFunctionRequest) GetFunctionId() string {
	if m != nil {
		return m.FunctionId
	}
	return ""
}

type GetFunctionVersionRequest struct {
	// ID of the version to return.
	//
	// To get a version ID make a [FunctionService.ListVersions] request.
	FunctionVersionId    string   `protobuf:"bytes,1,opt,name=function_version_id,json=functionVersionId,proto3" json:"function_version_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetFunctionVersionRequest) Reset()         { *m = GetFunctionVersionRequest{} }
func (m *GetFunctionVersionRequest) String() string { return proto.CompactTextString(m) }
func (*GetFunctionVersionRequest) ProtoMessage()    {}
func (*GetFunctionVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a91c4c30ec2c5ca, []int{1}
}

func (m *GetFunctionVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetFunctionVersionRequest.Unmarshal(m, b)
}
func (m *GetFunctionVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetFunctionVersionRequest.Marshal(b, m, deterministic)
}
func (m *GetFunctionVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetFunctionVersionRequest.Merge(m, src)
}
func (m *GetFunctionVersionRequest) XXX_Size() int {
	return xxx_messageInfo_GetFunctionVersionRequest.Size(m)
}
func (m *GetFunctionVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetFunctionVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetFunctionVersionRequest proto.InternalMessageInfo

func (m *GetFunctionVersionRequest) GetFunctionVersionId() string {
	if m != nil {
		return m.FunctionVersionId
	}
	return ""
}

type GetFunctionVersionByTagRequest struct {
	// ID of the function whose versions should be listed.
	//
	// To get a function ID use a [FunctionService.List] request.
	FunctionId string `protobuf:"bytes,1,opt,name=function_id,json=functionId,proto3" json:"function_id,omitempty"`
	// Version tag.
	//
	// To get the history of version tags make a [FunctionService.ListTagHistory] request.
	Tag                  string   `protobuf:"bytes,2,opt,name=tag,proto3" json:"tag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetFunctionVersionByTagRequest) Reset()         { *m = GetFunctionVersionByTagRequest{} }
func (m *GetFunctionVersionByTagRequest) String() string { return proto.CompactTextString(m) }
func (*GetFunctionVersionByTagRequest) ProtoMessage()    {}
func (*GetFunctionVersionByTagRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a91c4c30ec2c5ca, []int{2}
}

func (m *GetFunctionVersionByTagRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetFunctionVersionByTagRequest.Unmarshal(m, b)
}
func (m *GetFunctionVersionByTagRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetFunctionVersionByTagRequest.Marshal(b, m, deterministic)
}
func (m *GetFunctionVersionByTagRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetFunctionVersionByTagRequest.Merge(m, src)
}
func (m *GetFunctionVersionByTagRequest) XXX_Size() int {
	return xxx_messageInfo_GetFunctionVersionByTagRequest.Size(m)
}
func (m *GetFunctionVersionByTagRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetFunctionVersionByTagRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetFunctionVersionByTagRequest proto.InternalMessageInfo

func (m *GetFunctionVersionByTagRequest) GetFunctionId() string {
	if m != nil {
		return m.FunctionId
	}
	return ""
}

func (m *GetFunctionVersionByTagRequest) GetTag() string {
	if m != nil {
		return m.Tag
	}
	return ""
}

type ListFunctionsRequest struct {
	// ID of the folder to list functions in.
	//
	// To get a folder ID make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than `pageSize`, the service returns a [ListFunctionsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	//
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set `pageToken` to the
	// [ListFunctionsResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters functions listed in the response.
	//
	// The expression must specify:
	// 1. The field name. Currently filtering can only be applied to the [Function.name] field.
	// 2. A conditional operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN`
	// for lists of values.
	// 3. The value. Must be 3-63 characters long and match the regular expression `^[a-z][-a-z0-9]{1,61}[a-z0-9]$`.
	// Example of a filter: `name=my-function`.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFunctionsRequest) Reset()         { *m = ListFunctionsRequest{} }
func (m *ListFunctionsRequest) String() string { return proto.CompactTextString(m) }
func (*ListFunctionsRequest) ProtoMessage()    {}
func (*ListFunctionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a91c4c30ec2c5ca, []int{3}
}

func (m *ListFunctionsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFunctionsRequest.Unmarshal(m, b)
}
func (m *ListFunctionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFunctionsRequest.Marshal(b, m, deterministic)
}
func (m *ListFunctionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFunctionsRequest.Merge(m, src)
}
func (m *ListFunctionsRequest) XXX_Size() int {
	return xxx_messageInfo_ListFunctionsRequest.Size(m)
}
func (m *ListFunctionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFunctionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListFunctionsRequest proto.InternalMessageInfo

func (m *ListFunctionsRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *ListFunctionsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListFunctionsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListFunctionsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListFunctionsResponse struct {
	// List of functions in the specified folder.
	Functions []*Function `protobuf:"bytes,1,rep,name=functions,proto3" json:"functions,omitempty"`
	// Token for getting the next page of the list. If the number of results is greater than
	// the specified [ListFunctionsRequest.page_size], use `nextPageToken` as the value
	// for the [ListFunctionsRequest.page_token] parameter in the next list request.
	//
	// Each subsequent page will have its own `nextPageToken` to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFunctionsResponse) Reset()         { *m = ListFunctionsResponse{} }
func (m *ListFunctionsResponse) String() string { return proto.CompactTextString(m) }
func (*ListFunctionsResponse) ProtoMessage()    {}
func (*ListFunctionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a91c4c30ec2c5ca, []int{4}
}

func (m *ListFunctionsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFunctionsResponse.Unmarshal(m, b)
}
func (m *ListFunctionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFunctionsResponse.Marshal(b, m, deterministic)
}
func (m *ListFunctionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFunctionsResponse.Merge(m, src)
}
func (m *ListFunctionsResponse) XXX_Size() int {
	return xxx_messageInfo_ListFunctionsResponse.Size(m)
}
func (m *ListFunctionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFunctionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListFunctionsResponse proto.InternalMessageInfo

func (m *ListFunctionsResponse) GetFunctions() []*Function {
	if m != nil {
		return m.Functions
	}
	return nil
}

func (m *ListFunctionsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateFunctionRequest struct {
	// ID of the folder to create a function in.
	//
	// To get a folder ID make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the function.
	// The name must be unique within the folder.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the function.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs.
	Labels               map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CreateFunctionRequest) Reset()         { *m = CreateFunctionRequest{} }
func (m *CreateFunctionRequest) String() string { return proto.CompactTextString(m) }
func (*CreateFunctionRequest) ProtoMessage()    {}
func (*CreateFunctionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a91c4c30ec2c5ca, []int{5}
}

func (m *CreateFunctionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateFunctionRequest.Unmarshal(m, b)
}
func (m *CreateFunctionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateFunctionRequest.Marshal(b, m, deterministic)
}
func (m *CreateFunctionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateFunctionRequest.Merge(m, src)
}
func (m *CreateFunctionRequest) XXX_Size() int {
	return xxx_messageInfo_CreateFunctionRequest.Size(m)
}
func (m *CreateFunctionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateFunctionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateFunctionRequest proto.InternalMessageInfo

func (m *CreateFunctionRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *CreateFunctionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateFunctionRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *CreateFunctionRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

type CreateFunctionMetadata struct {
	// ID of the function that is being created.
	FunctionId           string   `protobuf:"bytes,1,opt,name=function_id,json=functionId,proto3" json:"function_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateFunctionMetadata) Reset()         { *m = CreateFunctionMetadata{} }
func (m *CreateFunctionMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateFunctionMetadata) ProtoMessage()    {}
func (*CreateFunctionMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a91c4c30ec2c5ca, []int{6}
}

func (m *CreateFunctionMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateFunctionMetadata.Unmarshal(m, b)
}
func (m *CreateFunctionMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateFunctionMetadata.Marshal(b, m, deterministic)
}
func (m *CreateFunctionMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateFunctionMetadata.Merge(m, src)
}
func (m *CreateFunctionMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateFunctionMetadata.Size(m)
}
func (m *CreateFunctionMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateFunctionMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateFunctionMetadata proto.InternalMessageInfo

func (m *CreateFunctionMetadata) GetFunctionId() string {
	if m != nil {
		return m.FunctionId
	}
	return ""
}

type UpdateFunctionRequest struct {
	// ID of the function to update.
	//
	// To get a function ID make a [FunctionService.List] request.
	FunctionId string `protobuf:"bytes,1,opt,name=function_id,json=functionId,proto3" json:"function_id,omitempty"`
	// Field mask that specifies which attributes of the function should be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// New name for the function.
	// The name must be unique within the folder.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// New description for the function.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Function labels as `key:value` pairs.
	//
	// Existing set of labels is completely replaced by the provided set, so if you just want
	// to add or remove a label, request the current set of labels with a [FunctionService.Get] request.
	Labels               map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UpdateFunctionRequest) Reset()         { *m = UpdateFunctionRequest{} }
func (m *UpdateFunctionRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateFunctionRequest) ProtoMessage()    {}
func (*UpdateFunctionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a91c4c30ec2c5ca, []int{7}
}

func (m *UpdateFunctionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateFunctionRequest.Unmarshal(m, b)
}
func (m *UpdateFunctionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateFunctionRequest.Marshal(b, m, deterministic)
}
func (m *UpdateFunctionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateFunctionRequest.Merge(m, src)
}
func (m *UpdateFunctionRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateFunctionRequest.Size(m)
}
func (m *UpdateFunctionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateFunctionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateFunctionRequest proto.InternalMessageInfo

func (m *UpdateFunctionRequest) GetFunctionId() string {
	if m != nil {
		return m.FunctionId
	}
	return ""
}

func (m *UpdateFunctionRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateFunctionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateFunctionRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *UpdateFunctionRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

type UpdateFunctionMetadata struct {
	// ID of the function that is being updated.
	FunctionId           string   `protobuf:"bytes,1,opt,name=function_id,json=functionId,proto3" json:"function_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateFunctionMetadata) Reset()         { *m = UpdateFunctionMetadata{} }
func (m *UpdateFunctionMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateFunctionMetadata) ProtoMessage()    {}
func (*UpdateFunctionMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a91c4c30ec2c5ca, []int{8}
}

func (m *UpdateFunctionMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateFunctionMetadata.Unmarshal(m, b)
}
func (m *UpdateFunctionMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateFunctionMetadata.Marshal(b, m, deterministic)
}
func (m *UpdateFunctionMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateFunctionMetadata.Merge(m, src)
}
func (m *UpdateFunctionMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateFunctionMetadata.Size(m)
}
func (m *UpdateFunctionMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateFunctionMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateFunctionMetadata proto.InternalMessageInfo

func (m *UpdateFunctionMetadata) GetFunctionId() string {
	if m != nil {
		return m.FunctionId
	}
	return ""
}

type DeleteFunctionRequest struct {
	// ID of the function to delete.
	// To get a function ID make a [FunctionService.List] request.
	FunctionId           string   `protobuf:"bytes,1,opt,name=function_id,json=functionId,proto3" json:"function_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteFunctionRequest) Reset()         { *m = DeleteFunctionRequest{} }
func (m *DeleteFunctionRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteFunctionRequest) ProtoMessage()    {}
func (*DeleteFunctionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a91c4c30ec2c5ca, []int{9}
}

func (m *DeleteFunctionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteFunctionRequest.Unmarshal(m, b)
}
func (m *DeleteFunctionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteFunctionRequest.Marshal(b, m, deterministic)
}
func (m *DeleteFunctionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteFunctionRequest.Merge(m, src)
}
func (m *DeleteFunctionRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteFunctionRequest.Size(m)
}
func (m *DeleteFunctionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteFunctionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteFunctionRequest proto.InternalMessageInfo

func (m *DeleteFunctionRequest) GetFunctionId() string {
	if m != nil {
		return m.FunctionId
	}
	return ""
}

type DeleteFunctionMetadata struct {
	// ID of the function that is being deleted.
	FunctionId           string   `protobuf:"bytes,1,opt,name=function_id,json=functionId,proto3" json:"function_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteFunctionMetadata) Reset()         { *m = DeleteFunctionMetadata{} }
func (m *DeleteFunctionMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteFunctionMetadata) ProtoMessage()    {}
func (*DeleteFunctionMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a91c4c30ec2c5ca, []int{10}
}

func (m *DeleteFunctionMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteFunctionMetadata.Unmarshal(m, b)
}
func (m *DeleteFunctionMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteFunctionMetadata.Marshal(b, m, deterministic)
}
func (m *DeleteFunctionMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteFunctionMetadata.Merge(m, src)
}
func (m *DeleteFunctionMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteFunctionMetadata.Size(m)
}
func (m *DeleteFunctionMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteFunctionMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteFunctionMetadata proto.InternalMessageInfo

func (m *DeleteFunctionMetadata) GetFunctionId() string {
	if m != nil {
		return m.FunctionId
	}
	return ""
}

type ListRuntimesRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListRuntimesRequest) Reset()         { *m = ListRuntimesRequest{} }
func (m *ListRuntimesRequest) String() string { return proto.CompactTextString(m) }
func (*ListRuntimesRequest) ProtoMessage()    {}
func (*ListRuntimesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a91c4c30ec2c5ca, []int{11}
}

func (m *ListRuntimesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListRuntimesRequest.Unmarshal(m, b)
}
func (m *ListRuntimesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListRuntimesRequest.Marshal(b, m, deterministic)
}
func (m *ListRuntimesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListRuntimesRequest.Merge(m, src)
}
func (m *ListRuntimesRequest) XXX_Size() int {
	return xxx_messageInfo_ListRuntimesRequest.Size(m)
}
func (m *ListRuntimesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListRuntimesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListRuntimesRequest proto.InternalMessageInfo

type ListRuntimesResponse struct {
	// Runtime environments available for the specified function.
	Runtimes             []string `protobuf:"bytes,1,rep,name=runtimes,proto3" json:"runtimes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListRuntimesResponse) Reset()         { *m = ListRuntimesResponse{} }
func (m *ListRuntimesResponse) String() string { return proto.CompactTextString(m) }
func (*ListRuntimesResponse) ProtoMessage()    {}
func (*ListRuntimesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a91c4c30ec2c5ca, []int{12}
}

func (m *ListRuntimesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListRuntimesResponse.Unmarshal(m, b)
}
func (m *ListRuntimesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListRuntimesResponse.Marshal(b, m, deterministic)
}
func (m *ListRuntimesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListRuntimesResponse.Merge(m, src)
}
func (m *ListRuntimesResponse) XXX_Size() int {
	return xxx_messageInfo_ListRuntimesResponse.Size(m)
}
func (m *ListRuntimesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListRuntimesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListRuntimesResponse proto.InternalMessageInfo

func (m *ListRuntimesResponse) GetRuntimes() []string {
	if m != nil {
		return m.Runtimes
	}
	return nil
}

type ListFunctionsVersionsRequest struct {
	// Types that are valid to be assigned to Id:
	//	*ListFunctionsVersionsRequest_FolderId
	//	*ListFunctionsVersionsRequest_FunctionId
	Id isListFunctionsVersionsRequest_Id `protobuf_oneof:"id"`
	// The maximum number of results per page to return. If the number of available results
	// is larger than `pageSize`, the service returns a [ListFunctionsVersionsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	//
	// Default value: 100.
	PageSize int64 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set `pageToken` to the
	// [ListFunctionsVersionsResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	//
	// The expression must specify:
	// 1. The field name. Currently filtering can only be applied to the [Function.name] field.
	// 2. A conditional operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN`
	// for lists of values.
	// 3. The value. Must be 3-63 characters long and match the regular expression `^[a-z][-a-z0-9]{1,61}[a-z0-9]$`.
	// Example of a filter: `name=my-function`.
	Filter               string   `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFunctionsVersionsRequest) Reset()         { *m = ListFunctionsVersionsRequest{} }
func (m *ListFunctionsVersionsRequest) String() string { return proto.CompactTextString(m) }
func (*ListFunctionsVersionsRequest) ProtoMessage()    {}
func (*ListFunctionsVersionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a91c4c30ec2c5ca, []int{13}
}

func (m *ListFunctionsVersionsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFunctionsVersionsRequest.Unmarshal(m, b)
}
func (m *ListFunctionsVersionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFunctionsVersionsRequest.Marshal(b, m, deterministic)
}
func (m *ListFunctionsVersionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFunctionsVersionsRequest.Merge(m, src)
}
func (m *ListFunctionsVersionsRequest) XXX_Size() int {
	return xxx_messageInfo_ListFunctionsVersionsRequest.Size(m)
}
func (m *ListFunctionsVersionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFunctionsVersionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListFunctionsVersionsRequest proto.InternalMessageInfo

type isListFunctionsVersionsRequest_Id interface {
	isListFunctionsVersionsRequest_Id()
}

type ListFunctionsVersionsRequest_FolderId struct {
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3,oneof"`
}

type ListFunctionsVersionsRequest_FunctionId struct {
	FunctionId string `protobuf:"bytes,2,opt,name=function_id,json=functionId,proto3,oneof"`
}

func (*ListFunctionsVersionsRequest_FolderId) isListFunctionsVersionsRequest_Id() {}

func (*ListFunctionsVersionsRequest_FunctionId) isListFunctionsVersionsRequest_Id() {}

func (m *ListFunctionsVersionsRequest) GetId() isListFunctionsVersionsRequest_Id {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *ListFunctionsVersionsRequest) GetFolderId() string {
	if x, ok := m.GetId().(*ListFunctionsVersionsRequest_FolderId); ok {
		return x.FolderId
	}
	return ""
}

func (m *ListFunctionsVersionsRequest) GetFunctionId() string {
	if x, ok := m.GetId().(*ListFunctionsVersionsRequest_FunctionId); ok {
		return x.FunctionId
	}
	return ""
}

func (m *ListFunctionsVersionsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListFunctionsVersionsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListFunctionsVersionsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ListFunctionsVersionsRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ListFunctionsVersionsRequest_FolderId)(nil),
		(*ListFunctionsVersionsRequest_FunctionId)(nil),
	}
}

type ListFunctionsVersionsResponse struct {
	// List of versions for the specified folder or function.
	Versions []*Version `protobuf:"bytes,1,rep,name=versions,proto3" json:"versions,omitempty"`
	// Token for getting the next page of the list. If the number of results is greater than
	// the specified [ListFunctionsVersionsRequest.page_size], use `nextPageToken` as the value
	// for the [ListFunctionsVersionsRequest.page_token] parameter in the next list request.
	//
	// Each subsequent page will have its own `nextPageToken` to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFunctionsVersionsResponse) Reset()         { *m = ListFunctionsVersionsResponse{} }
func (m *ListFunctionsVersionsResponse) String() string { return proto.CompactTextString(m) }
func (*ListFunctionsVersionsResponse) ProtoMessage()    {}
func (*ListFunctionsVersionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a91c4c30ec2c5ca, []int{14}
}

func (m *ListFunctionsVersionsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFunctionsVersionsResponse.Unmarshal(m, b)
}
func (m *ListFunctionsVersionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFunctionsVersionsResponse.Marshal(b, m, deterministic)
}
func (m *ListFunctionsVersionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFunctionsVersionsResponse.Merge(m, src)
}
func (m *ListFunctionsVersionsResponse) XXX_Size() int {
	return xxx_messageInfo_ListFunctionsVersionsResponse.Size(m)
}
func (m *ListFunctionsVersionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFunctionsVersionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListFunctionsVersionsResponse proto.InternalMessageInfo

func (m *ListFunctionsVersionsResponse) GetVersions() []*Version {
	if m != nil {
		return m.Versions
	}
	return nil
}

func (m *ListFunctionsVersionsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type ListFunctionOperationsRequest struct {
	// ID of the function to list operations for.
	FunctionId string `protobuf:"bytes,1,opt,name=function_id,json=functionId,proto3" json:"function_id,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available
	// results is larger than `pageSize`, the service returns a [ListFunctionOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	//
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set `pageToken` to the
	// [ListFunctionOperationsResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	//
	// The expression must specify:
	// 1. The field name. Currently filtering can be applied to the [operation.Operation.done], [operation.Operation.created_by] field.
	// 2. A conditional operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN`
	// for lists of values.
	// 3. The value. Must be 3-63 characters long and match the regular expression `^[a-z][-a-z0-9]{1,61}[a-z0-9]$`.
	// Examples of a filter: `done=false`, `created_by='John.Doe'`.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFunctionOperationsRequest) Reset()         { *m = ListFunctionOperationsRequest{} }
func (m *ListFunctionOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListFunctionOperationsRequest) ProtoMessage()    {}
func (*ListFunctionOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a91c4c30ec2c5ca, []int{15}
}

func (m *ListFunctionOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFunctionOperationsRequest.Unmarshal(m, b)
}
func (m *ListFunctionOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFunctionOperationsRequest.Marshal(b, m, deterministic)
}
func (m *ListFunctionOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFunctionOperationsRequest.Merge(m, src)
}
func (m *ListFunctionOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListFunctionOperationsRequest.Size(m)
}
func (m *ListFunctionOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFunctionOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListFunctionOperationsRequest proto.InternalMessageInfo

func (m *ListFunctionOperationsRequest) GetFunctionId() string {
	if m != nil {
		return m.FunctionId
	}
	return ""
}

func (m *ListFunctionOperationsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListFunctionOperationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListFunctionOperationsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListFunctionOperationsResponse struct {
	// List of operations for the specified function.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// Token for getting the next page of the list. If the number of results is greater than
	// the specified [ListFunctionOperationsRequest.page_size], use `nextPageToken` as the value
	// for the [ListFunctionOperationsRequest.page_token] parameter in the next list request.
	//
	// Each subsequent page will have its own `nextPageToken` to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFunctionOperationsResponse) Reset()         { *m = ListFunctionOperationsResponse{} }
func (m *ListFunctionOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListFunctionOperationsResponse) ProtoMessage()    {}
func (*ListFunctionOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a91c4c30ec2c5ca, []int{16}
}

func (m *ListFunctionOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFunctionOperationsResponse.Unmarshal(m, b)
}
func (m *ListFunctionOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFunctionOperationsResponse.Marshal(b, m, deterministic)
}
func (m *ListFunctionOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFunctionOperationsResponse.Merge(m, src)
}
func (m *ListFunctionOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListFunctionOperationsResponse.Size(m)
}
func (m *ListFunctionOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFunctionOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListFunctionOperationsResponse proto.InternalMessageInfo

func (m *ListFunctionOperationsResponse) GetOperations() []*operation.Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListFunctionOperationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateFunctionVersionRequest struct {
	// ID of the function to create a version for.
	//
	// To get a function ID, make a [FunctionService.List] request.
	FunctionId string `protobuf:"bytes,1,opt,name=function_id,json=functionId,proto3" json:"function_id,omitempty"`
	// Runtime environment for the version.
	Runtime string `protobuf:"bytes,2,opt,name=runtime,proto3" json:"runtime,omitempty"`
	// Description of the version
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Entrypoint of the version.
	Entrypoint string `protobuf:"bytes,4,opt,name=entrypoint,proto3" json:"entrypoint,omitempty"`
	// Resources allocated to the version.
	Resources *Resources `protobuf:"bytes,5,opt,name=resources,proto3" json:"resources,omitempty"`
	// Timeout for the execution of the version.
	//
	// If the timeout is exceeded, Cloud Functions responds with a 504 HTTP code.
	ExecutionTimeout *duration.Duration `protobuf:"bytes,6,opt,name=execution_timeout,json=executionTimeout,proto3" json:"execution_timeout,omitempty"`
	// ID of the service account to associate with the version.
	ServiceAccountId string `protobuf:"bytes,7,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// Source of the deployment package for the version.
	//
	// Types that are valid to be assigned to PackageSource:
	//	*CreateFunctionVersionRequest_Package
	//	*CreateFunctionVersionRequest_Content
	PackageSource isCreateFunctionVersionRequest_PackageSource `protobuf_oneof:"package_source"`
	// Environment settings for the version.
	Environment map[string]string `protobuf:"bytes,12,rep,name=environment,proto3" json:"environment,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Function version tags. For details, see [Version tag](/docs/functions/concepts/function#tag).
	Tag []string `protobuf:"bytes,13,rep,name=tag,proto3" json:"tag,omitempty"`
	// Function version connectivity. If specified the version will be attached to specified network/subnet(s).
	Connectivity         *Connectivity `protobuf:"bytes,17,opt,name=connectivity,proto3" json:"connectivity,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *CreateFunctionVersionRequest) Reset()         { *m = CreateFunctionVersionRequest{} }
func (m *CreateFunctionVersionRequest) String() string { return proto.CompactTextString(m) }
func (*CreateFunctionVersionRequest) ProtoMessage()    {}
func (*CreateFunctionVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a91c4c30ec2c5ca, []int{17}
}

func (m *CreateFunctionVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateFunctionVersionRequest.Unmarshal(m, b)
}
func (m *CreateFunctionVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateFunctionVersionRequest.Marshal(b, m, deterministic)
}
func (m *CreateFunctionVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateFunctionVersionRequest.Merge(m, src)
}
func (m *CreateFunctionVersionRequest) XXX_Size() int {
	return xxx_messageInfo_CreateFunctionVersionRequest.Size(m)
}
func (m *CreateFunctionVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateFunctionVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateFunctionVersionRequest proto.InternalMessageInfo

func (m *CreateFunctionVersionRequest) GetFunctionId() string {
	if m != nil {
		return m.FunctionId
	}
	return ""
}

func (m *CreateFunctionVersionRequest) GetRuntime() string {
	if m != nil {
		return m.Runtime
	}
	return ""
}

func (m *CreateFunctionVersionRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *CreateFunctionVersionRequest) GetEntrypoint() string {
	if m != nil {
		return m.Entrypoint
	}
	return ""
}

func (m *CreateFunctionVersionRequest) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *CreateFunctionVersionRequest) GetExecutionTimeout() *duration.Duration {
	if m != nil {
		return m.ExecutionTimeout
	}
	return nil
}

func (m *CreateFunctionVersionRequest) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

type isCreateFunctionVersionRequest_PackageSource interface {
	isCreateFunctionVersionRequest_PackageSource()
}

type CreateFunctionVersionRequest_Package struct {
	Package *Package `protobuf:"bytes,9,opt,name=package,proto3,oneof"`
}

type CreateFunctionVersionRequest_Content struct {
	Content []byte `protobuf:"bytes,10,opt,name=content,proto3,oneof"`
}

func (*CreateFunctionVersionRequest_Package) isCreateFunctionVersionRequest_PackageSource() {}

func (*CreateFunctionVersionRequest_Content) isCreateFunctionVersionRequest_PackageSource() {}

func (m *CreateFunctionVersionRequest) GetPackageSource() isCreateFunctionVersionRequest_PackageSource {
	if m != nil {
		return m.PackageSource
	}
	return nil
}

func (m *CreateFunctionVersionRequest) GetPackage() *Package {
	if x, ok := m.GetPackageSource().(*CreateFunctionVersionRequest_Package); ok {
		return x.Package
	}
	return nil
}

func (m *CreateFunctionVersionRequest) GetContent() []byte {
	if x, ok := m.GetPackageSource().(*CreateFunctionVersionRequest_Content); ok {
		return x.Content
	}
	return nil
}

func (m *CreateFunctionVersionRequest) GetEnvironment() map[string]string {
	if m != nil {
		return m.Environment
	}
	return nil
}

func (m *CreateFunctionVersionRequest) GetTag() []string {
	if m != nil {
		return m.Tag
	}
	return nil
}

func (m *CreateFunctionVersionRequest) GetConnectivity() *Connectivity {
	if m != nil {
		return m.Connectivity
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*CreateFunctionVersionRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*CreateFunctionVersionRequest_Package)(nil),
		(*CreateFunctionVersionRequest_Content)(nil),
	}
}

type CreateFunctionVersionMetadata struct {
	// ID of the version that is being created.
	FunctionVersionId    string   `protobuf:"bytes,1,opt,name=function_version_id,json=functionVersionId,proto3" json:"function_version_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateFunctionVersionMetadata) Reset()         { *m = CreateFunctionVersionMetadata{} }
func (m *CreateFunctionVersionMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateFunctionVersionMetadata) ProtoMessage()    {}
func (*CreateFunctionVersionMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a91c4c30ec2c5ca, []int{18}
}

func (m *CreateFunctionVersionMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateFunctionVersionMetadata.Unmarshal(m, b)
}
func (m *CreateFunctionVersionMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateFunctionVersionMetadata.Marshal(b, m, deterministic)
}
func (m *CreateFunctionVersionMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateFunctionVersionMetadata.Merge(m, src)
}
func (m *CreateFunctionVersionMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateFunctionVersionMetadata.Size(m)
}
func (m *CreateFunctionVersionMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateFunctionVersionMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateFunctionVersionMetadata proto.InternalMessageInfo

func (m *CreateFunctionVersionMetadata) GetFunctionVersionId() string {
	if m != nil {
		return m.FunctionVersionId
	}
	return ""
}

type SetFunctionTagRequest struct {
	// ID of the version to set the tag for.
	//
	// To get a version ID make a [FunctionService.ListVersions] request.
	FunctionVersionId string `protobuf:"bytes,1,opt,name=function_version_id,json=functionVersionId,proto3" json:"function_version_id,omitempty"`
	// Tag to set for the version.
	Tag                  string   `protobuf:"bytes,2,opt,name=tag,proto3" json:"tag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetFunctionTagRequest) Reset()         { *m = SetFunctionTagRequest{} }
func (m *SetFunctionTagRequest) String() string { return proto.CompactTextString(m) }
func (*SetFunctionTagRequest) ProtoMessage()    {}
func (*SetFunctionTagRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a91c4c30ec2c5ca, []int{19}
}

func (m *SetFunctionTagRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetFunctionTagRequest.Unmarshal(m, b)
}
func (m *SetFunctionTagRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetFunctionTagRequest.Marshal(b, m, deterministic)
}
func (m *SetFunctionTagRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetFunctionTagRequest.Merge(m, src)
}
func (m *SetFunctionTagRequest) XXX_Size() int {
	return xxx_messageInfo_SetFunctionTagRequest.Size(m)
}
func (m *SetFunctionTagRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetFunctionTagRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetFunctionTagRequest proto.InternalMessageInfo

func (m *SetFunctionTagRequest) GetFunctionVersionId() string {
	if m != nil {
		return m.FunctionVersionId
	}
	return ""
}

func (m *SetFunctionTagRequest) GetTag() string {
	if m != nil {
		return m.Tag
	}
	return ""
}

type RemoveFunctionTagRequest struct {
	// ID of the version to remove a tag from.
	//
	// To get the a version ID make a [FunctionService.ListVersions] request.
	FunctionVersionId string `protobuf:"bytes,1,opt,name=function_version_id,json=functionVersionId,proto3" json:"function_version_id,omitempty"`
	// Tag to remove from the specified version.
	Tag                  string   `protobuf:"bytes,2,opt,name=tag,proto3" json:"tag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RemoveFunctionTagRequest) Reset()         { *m = RemoveFunctionTagRequest{} }
func (m *RemoveFunctionTagRequest) String() string { return proto.CompactTextString(m) }
func (*RemoveFunctionTagRequest) ProtoMessage()    {}
func (*RemoveFunctionTagRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a91c4c30ec2c5ca, []int{20}
}

func (m *RemoveFunctionTagRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RemoveFunctionTagRequest.Unmarshal(m, b)
}
func (m *RemoveFunctionTagRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RemoveFunctionTagRequest.Marshal(b, m, deterministic)
}
func (m *RemoveFunctionTagRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveFunctionTagRequest.Merge(m, src)
}
func (m *RemoveFunctionTagRequest) XXX_Size() int {
	return xxx_messageInfo_RemoveFunctionTagRequest.Size(m)
}
func (m *RemoveFunctionTagRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveFunctionTagRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveFunctionTagRequest proto.InternalMessageInfo

func (m *RemoveFunctionTagRequest) GetFunctionVersionId() string {
	if m != nil {
		return m.FunctionVersionId
	}
	return ""
}

func (m *RemoveFunctionTagRequest) GetTag() string {
	if m != nil {
		return m.Tag
	}
	return ""
}

type SetFunctionTagMetadata struct {
	// ID of the function versions that is being tagged.
	FunctionVersionId    string   `protobuf:"bytes,1,opt,name=function_version_id,json=functionVersionId,proto3" json:"function_version_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetFunctionTagMetadata) Reset()         { *m = SetFunctionTagMetadata{} }
func (m *SetFunctionTagMetadata) String() string { return proto.CompactTextString(m) }
func (*SetFunctionTagMetadata) ProtoMessage()    {}
func (*SetFunctionTagMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a91c4c30ec2c5ca, []int{21}
}

func (m *SetFunctionTagMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetFunctionTagMetadata.Unmarshal(m, b)
}
func (m *SetFunctionTagMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetFunctionTagMetadata.Marshal(b, m, deterministic)
}
func (m *SetFunctionTagMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetFunctionTagMetadata.Merge(m, src)
}
func (m *SetFunctionTagMetadata) XXX_Size() int {
	return xxx_messageInfo_SetFunctionTagMetadata.Size(m)
}
func (m *SetFunctionTagMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_SetFunctionTagMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_SetFunctionTagMetadata proto.InternalMessageInfo

func (m *SetFunctionTagMetadata) GetFunctionVersionId() string {
	if m != nil {
		return m.FunctionVersionId
	}
	return ""
}

type RemoveFunctionTagMetadata struct {
	// ID of the function versions that is being untagged.
	FunctionVersionId    string   `protobuf:"bytes,1,opt,name=function_version_id,json=functionVersionId,proto3" json:"function_version_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RemoveFunctionTagMetadata) Reset()         { *m = RemoveFunctionTagMetadata{} }
func (m *RemoveFunctionTagMetadata) String() string { return proto.CompactTextString(m) }
func (*RemoveFunctionTagMetadata) ProtoMessage()    {}
func (*RemoveFunctionTagMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a91c4c30ec2c5ca, []int{22}
}

func (m *RemoveFunctionTagMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RemoveFunctionTagMetadata.Unmarshal(m, b)
}
func (m *RemoveFunctionTagMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RemoveFunctionTagMetadata.Marshal(b, m, deterministic)
}
func (m *RemoveFunctionTagMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveFunctionTagMetadata.Merge(m, src)
}
func (m *RemoveFunctionTagMetadata) XXX_Size() int {
	return xxx_messageInfo_RemoveFunctionTagMetadata.Size(m)
}
func (m *RemoveFunctionTagMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveFunctionTagMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveFunctionTagMetadata proto.InternalMessageInfo

func (m *RemoveFunctionTagMetadata) GetFunctionVersionId() string {
	if m != nil {
		return m.FunctionVersionId
	}
	return ""
}

type ListFunctionTagHistoryRequest struct {
	// ID of the function to retrieve tag history for.
	//
	// To get a function ID, make a [FunctionService.List] request.
	FunctionId string `protobuf:"bytes,1,opt,name=function_id,json=functionId,proto3" json:"function_id,omitempty"`
	// Specific tag that history should be limited to.
	Tag string `protobuf:"bytes,2,opt,name=tag,proto3" json:"tag,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available
	// results is larger than `pageSize`, the service returns a [ListFunctionOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set `pageToken` to the
	// [ListFunctionOperationsResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	//
	// The expression must specify:
	// 1. The field name. Currently filtering can only be applied to the [Function.name] field.
	// 2. A conditional operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN`
	// for lists of values.
	// 3. The value. Must be 3-63 characters long and match the regular expression `^[a-z][-a-z0-9]{1,61}[a-z0-9]$`.
	// For example, `name=my-function`.
	Filter               string   `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFunctionTagHistoryRequest) Reset()         { *m = ListFunctionTagHistoryRequest{} }
func (m *ListFunctionTagHistoryRequest) String() string { return proto.CompactTextString(m) }
func (*ListFunctionTagHistoryRequest) ProtoMessage()    {}
func (*ListFunctionTagHistoryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a91c4c30ec2c5ca, []int{23}
}

func (m *ListFunctionTagHistoryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFunctionTagHistoryRequest.Unmarshal(m, b)
}
func (m *ListFunctionTagHistoryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFunctionTagHistoryRequest.Marshal(b, m, deterministic)
}
func (m *ListFunctionTagHistoryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFunctionTagHistoryRequest.Merge(m, src)
}
func (m *ListFunctionTagHistoryRequest) XXX_Size() int {
	return xxx_messageInfo_ListFunctionTagHistoryRequest.Size(m)
}
func (m *ListFunctionTagHistoryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFunctionTagHistoryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListFunctionTagHistoryRequest proto.InternalMessageInfo

func (m *ListFunctionTagHistoryRequest) GetFunctionId() string {
	if m != nil {
		return m.FunctionId
	}
	return ""
}

func (m *ListFunctionTagHistoryRequest) GetTag() string {
	if m != nil {
		return m.Tag
	}
	return ""
}

func (m *ListFunctionTagHistoryRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListFunctionTagHistoryRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListFunctionTagHistoryRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListFunctionTagHistoryResponse struct {
	// Set of relevant tag history records.
	FunctionTagHistoryRecord []*ListFunctionTagHistoryResponse_FunctionTagHistoryRecord `protobuf:"bytes,1,rep,name=function_tag_history_record,json=functionTagHistoryRecord,proto3" json:"function_tag_history_record,omitempty"`
	// Token for getting the next page of the list. If the number of results is greater than
	// the specified [ListFunctionTagHistoryRequest.page_size], use `nextPageToken` as the value
	// for the [ListFunctionTagHistoryRequest.page_token] parameter in the next list request.
	//
	// Each subsequent page will have its own `nextPageToken` to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFunctionTagHistoryResponse) Reset()         { *m = ListFunctionTagHistoryResponse{} }
func (m *ListFunctionTagHistoryResponse) String() string { return proto.CompactTextString(m) }
func (*ListFunctionTagHistoryResponse) ProtoMessage()    {}
func (*ListFunctionTagHistoryResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a91c4c30ec2c5ca, []int{24}
}

func (m *ListFunctionTagHistoryResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFunctionTagHistoryResponse.Unmarshal(m, b)
}
func (m *ListFunctionTagHistoryResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFunctionTagHistoryResponse.Marshal(b, m, deterministic)
}
func (m *ListFunctionTagHistoryResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFunctionTagHistoryResponse.Merge(m, src)
}
func (m *ListFunctionTagHistoryResponse) XXX_Size() int {
	return xxx_messageInfo_ListFunctionTagHistoryResponse.Size(m)
}
func (m *ListFunctionTagHistoryResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFunctionTagHistoryResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListFunctionTagHistoryResponse proto.InternalMessageInfo

func (m *ListFunctionTagHistoryResponse) GetFunctionTagHistoryRecord() []*ListFunctionTagHistoryResponse_FunctionTagHistoryRecord {
	if m != nil {
		return m.FunctionTagHistoryRecord
	}
	return nil
}

func (m *ListFunctionTagHistoryResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// A record in the tag history.
type ListFunctionTagHistoryResponse_FunctionTagHistoryRecord struct {
	// ID of the function that the record is about.
	FunctionId string `protobuf:"bytes,1,opt,name=function_id,json=functionId,proto3" json:"function_id,omitempty"`
	// ID of the function version that the record is about.
	FunctionVersionId string `protobuf:"bytes,3,opt,name=function_version_id,json=functionVersionId,proto3" json:"function_version_id,omitempty"`
	// Tag that was set for the version at some point.
	Tag string `protobuf:"bytes,2,opt,name=tag,proto3" json:"tag,omitempty"`
	// Timestamp when the tag started being active for the function.
	EffectiveFrom *timestamp.Timestamp `protobuf:"bytes,4,opt,name=effective_from,json=effectiveFrom,proto3" json:"effective_from,omitempty"`
	// Timestamp when the tag stopped being active for the function.
	EffectiveTo          *timestamp.Timestamp `protobuf:"bytes,5,opt,name=effective_to,json=effectiveTo,proto3" json:"effective_to,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ListFunctionTagHistoryResponse_FunctionTagHistoryRecord) Reset() {
	*m = ListFunctionTagHistoryResponse_FunctionTagHistoryRecord{}
}
func (m *ListFunctionTagHistoryResponse_FunctionTagHistoryRecord) String() string {
	return proto.CompactTextString(m)
}
func (*ListFunctionTagHistoryResponse_FunctionTagHistoryRecord) ProtoMessage() {}
func (*ListFunctionTagHistoryResponse_FunctionTagHistoryRecord) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a91c4c30ec2c5ca, []int{24, 0}
}

func (m *ListFunctionTagHistoryResponse_FunctionTagHistoryRecord) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFunctionTagHistoryResponse_FunctionTagHistoryRecord.Unmarshal(m, b)
}
func (m *ListFunctionTagHistoryResponse_FunctionTagHistoryRecord) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFunctionTagHistoryResponse_FunctionTagHistoryRecord.Marshal(b, m, deterministic)
}
func (m *ListFunctionTagHistoryResponse_FunctionTagHistoryRecord) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFunctionTagHistoryResponse_FunctionTagHistoryRecord.Merge(m, src)
}
func (m *ListFunctionTagHistoryResponse_FunctionTagHistoryRecord) XXX_Size() int {
	return xxx_messageInfo_ListFunctionTagHistoryResponse_FunctionTagHistoryRecord.Size(m)
}
func (m *ListFunctionTagHistoryResponse_FunctionTagHistoryRecord) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFunctionTagHistoryResponse_FunctionTagHistoryRecord.DiscardUnknown(m)
}

var xxx_messageInfo_ListFunctionTagHistoryResponse_FunctionTagHistoryRecord proto.InternalMessageInfo

func (m *ListFunctionTagHistoryResponse_FunctionTagHistoryRecord) GetFunctionId() string {
	if m != nil {
		return m.FunctionId
	}
	return ""
}

func (m *ListFunctionTagHistoryResponse_FunctionTagHistoryRecord) GetFunctionVersionId() string {
	if m != nil {
		return m.FunctionVersionId
	}
	return ""
}

func (m *ListFunctionTagHistoryResponse_FunctionTagHistoryRecord) GetTag() string {
	if m != nil {
		return m.Tag
	}
	return ""
}

func (m *ListFunctionTagHistoryResponse_FunctionTagHistoryRecord) GetEffectiveFrom() *timestamp.Timestamp {
	if m != nil {
		return m.EffectiveFrom
	}
	return nil
}

func (m *ListFunctionTagHistoryResponse_FunctionTagHistoryRecord) GetEffectiveTo() *timestamp.Timestamp {
	if m != nil {
		return m.EffectiveTo
	}
	return nil
}

func init() {
	proto.RegisterType((*GetFunctionRequest)(nil), "yandex.cloud.serverless.functions.v1.GetFunctionRequest")
	proto.RegisterType((*GetFunctionVersionRequest)(nil), "yandex.cloud.serverless.functions.v1.GetFunctionVersionRequest")
	proto.RegisterType((*GetFunctionVersionByTagRequest)(nil), "yandex.cloud.serverless.functions.v1.GetFunctionVersionByTagRequest")
	proto.RegisterType((*ListFunctionsRequest)(nil), "yandex.cloud.serverless.functions.v1.ListFunctionsRequest")
	proto.RegisterType((*ListFunctionsResponse)(nil), "yandex.cloud.serverless.functions.v1.ListFunctionsResponse")
	proto.RegisterType((*CreateFunctionRequest)(nil), "yandex.cloud.serverless.functions.v1.CreateFunctionRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.serverless.functions.v1.CreateFunctionRequest.LabelsEntry")
	proto.RegisterType((*CreateFunctionMetadata)(nil), "yandex.cloud.serverless.functions.v1.CreateFunctionMetadata")
	proto.RegisterType((*UpdateFunctionRequest)(nil), "yandex.cloud.serverless.functions.v1.UpdateFunctionRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.serverless.functions.v1.UpdateFunctionRequest.LabelsEntry")
	proto.RegisterType((*UpdateFunctionMetadata)(nil), "yandex.cloud.serverless.functions.v1.UpdateFunctionMetadata")
	proto.RegisterType((*DeleteFunctionRequest)(nil), "yandex.cloud.serverless.functions.v1.DeleteFunctionRequest")
	proto.RegisterType((*DeleteFunctionMetadata)(nil), "yandex.cloud.serverless.functions.v1.DeleteFunctionMetadata")
	proto.RegisterType((*ListRuntimesRequest)(nil), "yandex.cloud.serverless.functions.v1.ListRuntimesRequest")
	proto.RegisterType((*ListRuntimesResponse)(nil), "yandex.cloud.serverless.functions.v1.ListRuntimesResponse")
	proto.RegisterType((*ListFunctionsVersionsRequest)(nil), "yandex.cloud.serverless.functions.v1.ListFunctionsVersionsRequest")
	proto.RegisterType((*ListFunctionsVersionsResponse)(nil), "yandex.cloud.serverless.functions.v1.ListFunctionsVersionsResponse")
	proto.RegisterType((*ListFunctionOperationsRequest)(nil), "yandex.cloud.serverless.functions.v1.ListFunctionOperationsRequest")
	proto.RegisterType((*ListFunctionOperationsResponse)(nil), "yandex.cloud.serverless.functions.v1.ListFunctionOperationsResponse")
	proto.RegisterType((*CreateFunctionVersionRequest)(nil), "yandex.cloud.serverless.functions.v1.CreateFunctionVersionRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.serverless.functions.v1.CreateFunctionVersionRequest.EnvironmentEntry")
	proto.RegisterType((*CreateFunctionVersionMetadata)(nil), "yandex.cloud.serverless.functions.v1.CreateFunctionVersionMetadata")
	proto.RegisterType((*SetFunctionTagRequest)(nil), "yandex.cloud.serverless.functions.v1.SetFunctionTagRequest")
	proto.RegisterType((*RemoveFunctionTagRequest)(nil), "yandex.cloud.serverless.functions.v1.RemoveFunctionTagRequest")
	proto.RegisterType((*SetFunctionTagMetadata)(nil), "yandex.cloud.serverless.functions.v1.SetFunctionTagMetadata")
	proto.RegisterType((*RemoveFunctionTagMetadata)(nil), "yandex.cloud.serverless.functions.v1.RemoveFunctionTagMetadata")
	proto.RegisterType((*ListFunctionTagHistoryRequest)(nil), "yandex.cloud.serverless.functions.v1.ListFunctionTagHistoryRequest")
	proto.RegisterType((*ListFunctionTagHistoryResponse)(nil), "yandex.cloud.serverless.functions.v1.ListFunctionTagHistoryResponse")
	proto.RegisterType((*ListFunctionTagHistoryResponse_FunctionTagHistoryRecord)(nil), "yandex.cloud.serverless.functions.v1.ListFunctionTagHistoryResponse.FunctionTagHistoryRecord")
}

func init() {
	proto.RegisterFile("yandex/cloud/serverless/functions/v1/function_service.proto", fileDescriptor_4a91c4c30ec2c5ca)
}

var fileDescriptor_4a91c4c30ec2c5ca = []byte{
	// 2087 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x59, 0x4b, 0x6c, 0xdb, 0xc8,
	0x19, 0x5e, 0x5a, 0x8a, 0x6c, 0xff, 0x72, 0x12, 0x67, 0x36, 0xf6, 0x2a, 0x8a, 0xed, 0xd8, 0xac,
	0x93, 0x18, 0x6a, 0xf4, 0xa0, 0xe2, 0xb8, 0x7e, 0x25, 0xa9, 0x95, 0x97, 0x8d, 0x26, 0xd8, 0x2d,
	0xed, 0xe6, 0xb0, 0x81, 0xa1, 0xd2, 0xd2, 0x48, 0x4b, 0x58, 0x22, 0x55, 0x92, 0x12, 0xe2, 0xec,
	0xa6, 0x05, 0x16, 0xe8, 0x25, 0x45, 0x2f, 0xed, 0x75, 0x5b, 0xf4, 0xd2, 0x5b, 0x4f, 0xba, 0xec,
	0x69, 0x81, 0xf4, 0x50, 0xd8, 0x28, 0xd0, 0x8b, 0x8b, 0x1e, 0x7a, 0x6e, 0x51, 0xb4, 0xa7, 0x02,
	0xe9, 0xa1, 0x40, 0x51, 0xa0, 0xc5, 0x0c, 0x87, 0x14, 0x49, 0x51, 0xce, 0x48, 0xee, 0x63, 0x4f,
	0x12, 0x39, 0xff, 0xff, 0xcf, 0xf7, 0x3f, 0xe6, 0x7f, 0x0c, 0x61, 0xed, 0x40, 0xd1, 0xca, 0xf8,
	0x79, 0xb6, 0x54, 0xd3, 0x9b, 0xe5, 0xac, 0x89, 0x8d, 0x16, 0x36, 0x6a, 0xd8, 0x34, 0xb3, 0x95,
	0xa6, 0x56, 0xb2, 0x54, 0x5d, 0x33, 0xb3, 0x2d, 0xc9, 0x7d, 0x28, 0x12, 0x02, 0xb5, 0x84, 0x33,
	0x0d, 0x43, 0xb7, 0x74, 0x34, 0x6f, 0x33, 0x67, 0x28, 0x73, 0xa6, 0xc3, 0x9c, 0x71, 0x99, 0x33,
	0x2d, 0x29, 0x39, 0x55, 0xd5, 0xf5, 0x6a, 0x0d, 0x67, 0x95, 0x86, 0x9a, 0x55, 0x34, 0x4d, 0xb7,
	0x14, 0x7b, 0x89, 0xca, 0x48, 0xce, 0xb2, 0x55, 0xfa, 0xb4, 0xd7, 0xac, 0x64, 0x2b, 0x2a, 0xae,
	0x95, 0x8b, 0x75, 0xc5, 0xdc, 0x67, 0x14, 0x33, 0x41, 0x8a, 0x72, 0xd3, 0xa0, 0x22, 0xd8, 0xfa,
	0x95, 0xe0, 0xba, 0xa5, 0xd6, 0xb1, 0x69, 0x29, 0xf5, 0x86, 0xb3, 0x85, 0x4f, 0x47, 0x02, 0x43,
	0x6f, 0x60, 0x9f, 0x88, 0x00, 0x45, 0xa9, 0x44, 0x2c, 0x60, 0xff, 0x30, 0x8a, 0x9b, 0x7d, 0xd9,
	0x89, 0x31, 0x5d, 0xf3, 0x31, 0xb9, 0x9b, 0x76, 0x6d, 0x3f, 0xed, 0xa3, 0x6b, 0x29, 0x35, 0xb5,
	0xec, 0x59, 0x16, 0xd7, 0x00, 0x3d, 0xc2, 0xd6, 0x43, 0x26, 0x5b, 0xc6, 0xdf, 0x69, 0x62, 0xd3,
	0x42, 0x57, 0x21, 0xee, 0xba, 0x45, 0x2d, 0x27, 0x84, 0x59, 0x61, 0x61, 0xb4, 0x10, 0xfd, 0xf3,
	0xa1, 0x24, 0xc8, 0xe0, 0x2c, 0x6c, 0x95, 0xc5, 0x6f, 0xc2, 0x25, 0x0f, 0xf3, 0x53, 0x6c, 0x98,
	0x1e, 0x19, 0x8b, 0xf0, 0xae, 0x2b, 0xa3, 0x65, 0x2f, 0x05, 0x65, 0x5d, 0xa8, 0xf8, 0x59, 0xb7,
	0xca, 0xe2, 0x01, 0xcc, 0x74, 0x8b, 0x2c, 0x1c, 0xec, 0x28, 0xd5, 0xfe, 0xb0, 0xa1, 0x1c, 0x44,
	0x2c, 0xa5, 0x9a, 0x18, 0xa2, 0xcb, 0x33, 0x6f, 0x0e, 0xa5, 0xe4, 0x33, 0x25, 0xfd, 0x62, 0xf7,
	0x59, 0xba, 0x98, 0x4b, 0xaf, 0x90, 0x7f, 0xa9, 0x4f, 0x9e, 0xcd, 0xef, 0xd6, 0x14, 0x0b, 0x9b,
	0x96, 0x4c, 0x48, 0xc5, 0x1f, 0x0a, 0x70, 0xf1, 0xb1, 0x6a, 0xba, 0x9b, 0x9b, 0xce, 0x8e, 0x73,
	0x30, 0x5a, 0xd1, 0x6b, 0x65, 0x6c, 0x04, 0xf7, 0x1b, 0xb1, 0x5f, 0x6f, 0x95, 0xd1, 0x65, 0x18,
	0x6d, 0x28, 0x55, 0x5c, 0x34, 0xd5, 0x17, 0x98, 0xee, 0x19, 0x91, 0x47, 0xc8, 0x8b, 0x6d, 0xf5,
	0x05, 0x46, 0xd3, 0x00, 0x74, 0xd1, 0xd2, 0xf7, 0xb1, 0x96, 0x88, 0x10, 0x01, 0x32, 0x25, 0xdf,
	0x21, 0x2f, 0xd0, 0x24, 0xc4, 0x2a, 0x6a, 0xcd, 0xc2, 0x46, 0x22, 0x4a, 0x97, 0xd8, 0x13, 0xc1,
	0x33, 0x11, 0xc0, 0x63, 0x36, 0x74, 0xcd, 0xc4, 0xe8, 0x31, 0x8c, 0xba, 0xa1, 0x91, 0x10, 0x66,
	0x23, 0x0b, 0xf1, 0x7c, 0x26, 0xc3, 0x73, 0x5e, 0x32, 0xae, 0xa3, 0x3b, 0x02, 0xd0, 0x35, 0x38,
	0xaf, 0xe1, 0xe7, 0x56, 0xd1, 0x83, 0x91, 0x5a, 0x4d, 0x3e, 0x4b, 0x5e, 0x7f, 0xe0, 0xe0, 0x14,
	0xff, 0x39, 0x04, 0x13, 0xf7, 0x0c, 0xac, 0x58, 0x38, 0x18, 0x2e, 0x1c, 0x06, 0xba, 0x05, 0x51,
	0x4d, 0xa9, 0x63, 0xe6, 0x8f, 0xb9, 0x37, 0x87, 0xd2, 0xf4, 0x27, 0xcc, 0x21, 0x4a, 0xfa, 0x45,
	0x2e, 0xbd, 0xb2, 0xfb, 0xb1, 0x74, 0x63, 0x49, 0x7a, 0xf9, 0x8c, 0x3d, 0xc9, 0x94, 0x1c, 0x7d,
	0x15, 0xe2, 0x65, 0x6c, 0x96, 0x0c, 0xb5, 0x41, 0xf6, 0xb3, 0x6d, 0x57, 0x18, 0x7d, 0x75, 0x24,
	0x9d, 0x59, 0xbf, 0x9d, 0xbf, 0xb5, 0x24, 0x7b, 0x57, 0xd1, 0xcf, 0x04, 0x88, 0xd5, 0x94, 0x3d,
	0x5c, 0x33, 0x13, 0x51, 0x6a, 0x94, 0x47, 0x7c, 0x46, 0x09, 0x55, 0x2a, 0xf3, 0x98, 0x4a, 0x7a,
	0xa0, 0x59, 0xc6, 0x41, 0xe1, 0xee, 0x9b, 0x43, 0x29, 0xee, 0x09, 0x9d, 0x4f, 0x8f, 0xa4, 0xe8,
	0xfa, 0xed, 0xa5, 0xc5, 0x57, 0xf6, 0xef, 0xcd, 0xf6, 0x91, 0x14, 0x4b, 0x46, 0xa5, 0x34, 0xfd,
	0x87, 0xd0, 0x78, 0x30, 0xd4, 0x64, 0x86, 0x2b, 0xb9, 0x02, 0x71, 0x8f, 0x5c, 0x34, 0x0e, 0x91,
	0x7d, 0x7c, 0x60, 0x9b, 0x4c, 0x26, 0x7f, 0xd1, 0x45, 0x38, 0xd3, 0x52, 0x6a, 0x4d, 0x66, 0x28,
	0xd9, 0x7e, 0x58, 0x1d, 0x5a, 0x16, 0xc4, 0x15, 0x98, 0xf4, 0x03, 0x7d, 0x82, 0x2d, 0xa5, 0xac,
	0x58, 0x0a, 0xba, 0x12, 0x72, 0x22, 0x7c, 0xe7, 0xf4, 0x8b, 0x08, 0x4c, 0x7c, 0xab, 0x51, 0x0e,
	0xf1, 0x1c, 0xe7, 0x61, 0x5a, 0x83, 0x78, 0x93, 0xf2, 0xd3, 0xdc, 0x49, 0xb1, 0xc5, 0xf3, 0xc9,
	0x8c, 0x9d, 0x1c, 0x33, 0x4e, 0x72, 0xcc, 0x3c, 0x24, 0xe9, 0xf5, 0x89, 0x62, 0xee, 0xcb, 0x60,
	0x93, 0x93, 0xff, 0xae, 0xeb, 0x23, 0xa7, 0x72, 0x7d, 0x94, 0xd7, 0xf5, 0x67, 0xfa, 0x71, 0x7d,
	0xa8, 0x55, 0xbe, 0x8c, 0xae, 0xf7, 0x03, 0xe5, 0x77, 0xfd, 0x1d, 0x98, 0xb8, 0x8f, 0x6b, 0x78,
	0x50, 0xcf, 0x93, 0xad, 0xfd, 0xfc, 0xfc, 0x5b, 0x4f, 0xc0, 0xbb, 0x24, 0x7d, 0xc9, 0x4d, 0x8d,
	0x16, 0x4d, 0xb6, 0xb1, 0x98, 0xb7, 0xb3, 0x6c, 0xe7, 0x35, 0x4b, 0x6a, 0x49, 0x18, 0x31, 0xd8,
	0x3b, 0x9a, 0xd3, 0x46, 0x65, 0xf7, 0x59, 0xfc, 0x83, 0x00, 0x53, 0xbe, 0x54, 0xc8, 0x0a, 0x83,
	0x9b, 0xa2, 0xa7, 0xbb, 0x32, 0xd0, 0xe6, 0x3b, 0x9e, 0xec, 0x33, 0xe7, 0xc7, 0x3a, 0xc4, 0x08,
	0xbc, 0x21, 0x7e, 0xdd, 0x9b, 0xc1, 0x49, 0xa8, 0x46, 0x0a, 0xf0, 0x8f, 0x43, 0x29, 0x96, 0x4b,
	0x4b, 0xb9, 0x5c, 0xce, 0x93, 0xcd, 0x17, 0x7c, 0xd9, 0xdc, 0x17, 0x96, 0x52, 0x2e, 0xe7, 0x4d,
	0xec, 0xa2, 0x9b, 0xd8, 0xcf, 0x50, 0x2a, 0x78, 0x75, 0x24, 0xc5, 0x28, 0x55, 0xce, 0x49, 0xf2,
	0x05, 0x80, 0x21, 0xb5, 0x8c, 0xa2, 0xaf, 0x7f, 0x29, 0x09, 0xe2, 0x8f, 0x04, 0x98, 0xee, 0xa1,
	0x25, 0xb3, 0xd1, 0x16, 0x8c, 0xb0, 0x52, 0xea, 0xe4, 0xfd, 0x34, 0x5f, 0x9c, 0x3b, 0xb5, 0xd9,
	0x65, 0xe7, 0xce, 0xfa, 0x5f, 0x04, 0x40, 0xbd, 0xef, 0xf4, 0x17, 0x66, 0x9f, 0x39, 0xe4, 0x7a,
	0x57, 0x89, 0xe4, 0x32, 0x70, 0x84, 0xcb, 0xc0, 0xd1, 0x5e, 0x06, 0x16, 0x7f, 0x20, 0xc0, 0x4c,
	0x2f, 0xfc, 0xcc, 0xaa, 0x1b, 0x00, 0x6e, 0xd7, 0xe4, 0xd8, 0x75, 0xce, 0x6f, 0xd7, 0x4e, 0x57,
	0xe5, 0xf2, 0xcb, 0x1e, 0x26, 0x6e, 0x6b, 0xfe, 0x3d, 0x06, 0x53, 0xfe, 0x2c, 0x1e, 0xe8, 0x9a,
	0x38, 0x8d, 0x39, 0x03, 0xc3, 0xec, 0x70, 0xb0, 0x8a, 0x6a, 0x93, 0x38, 0x2f, 0x4f, 0xa8, 0x9b,
	0xb9, 0x74, 0x57, 0xf2, 0x9c, 0x07, 0xc0, 0x24, 0x27, 0x35, 0x74, 0x55, 0xb3, 0x98, 0x29, 0xd9,
	0x96, 0x9d, 0xf7, 0x68, 0x1b, 0x46, 0x0d, 0x6c, 0xea, 0x4d, 0xa3, 0x84, 0x4d, 0x1a, 0xd0, 0xf1,
	0x7c, 0x96, 0x2f, 0xf8, 0x64, 0x87, 0x8d, 0x49, 0xed, 0xc8, 0x41, 0x8f, 0xe1, 0x02, 0x7e, 0x8e,
	0x4b, 0x4d, 0xaa, 0x2f, 0x41, 0xae, 0x37, 0xad, 0x44, 0x8c, 0x0a, 0xbf, 0xd4, 0x55, 0x5e, 0xee,
	0xb3, 0xde, 0x9c, 0x89, 0x19, 0x77, 0x39, 0x77, 0x6c, 0x46, 0x74, 0x03, 0x10, 0x1b, 0x22, 0x8a,
	0x4a, 0xa9, 0xa4, 0x37, 0x35, 0x8b, 0xd8, 0x70, 0x98, 0x3a, 0x62, 0x9c, 0xad, 0x6c, 0xd8, 0x0b,
	0x5b, 0x65, 0xb4, 0x05, 0xc3, 0x0d, 0xa5, 0xb4, 0xaf, 0x54, 0x71, 0x62, 0x94, 0xee, 0xc8, 0x79,
	0x96, 0x3e, 0xb0, 0x99, 0x36, 0xdf, 0x91, 0x1d, 0x7e, 0x94, 0x82, 0xe1, 0x92, 0xae, 0x59, 0x58,
	0xb3, 0x12, 0x30, 0x2b, 0x2c, 0x8c, 0x15, 0xce, 0xbd, 0x3a, 0x92, 0x60, 0xfd, 0xf6, 0xad, 0xfc,
	0x62, 0x7e, 0x79, 0x39, 0x97, 0x23, 0xb4, 0x8c, 0x00, 0x7d, 0x26, 0x40, 0x1c, 0x6b, 0x2d, 0xd5,
	0xd0, 0xb5, 0x3a, 0x61, 0x18, 0xa3, 0xf1, 0xb6, 0x3d, 0x48, 0xab, 0xe2, 0x8f, 0x9d, 0xcc, 0x83,
	0x8e, 0x54, 0xbb, 0x76, 0x5d, 0xb5, 0xcf, 0xc3, 0x62, 0x6e, 0x65, 0xa9, 0x7d, 0x24, 0xbd, 0x87,
	0x26, 0x48, 0x71, 0xda, 0x48, 0x7f, 0xb8, 0xcb, 0x7e, 0x73, 0xe9, 0x95, 0xe2, 0x6e, 0x4a, 0xf6,
	0xc2, 0x41, 0xd7, 0xec, 0xbe, 0xf9, 0x2c, 0xc9, 0xc0, 0x85, 0x8b, 0x6f, 0x0e, 0xa5, 0xee, 0x8a,
	0x46, 0x08, 0xd0, 0x53, 0x18, 0x2b, 0xe9, 0x9a, 0x86, 0x4b, 0x96, 0xda, 0x52, 0xad, 0x83, 0xc4,
	0x05, 0x6a, 0xc2, 0x3c, 0xa7, 0x1a, 0x1e, 0x4e, 0xd9, 0x27, 0x27, 0x79, 0x07, 0xc6, 0x83, 0x7a,
	0xf4, 0x53, 0x2b, 0x0b, 0x93, 0x70, 0x8e, 0x79, 0xa5, 0x68, 0x07, 0x19, 0x4b, 0xae, 0xef, 0xc3,
	0x74, 0xa8, 0xf1, 0xdc, 0x7a, 0x96, 0x39, 0x61, 0x5e, 0x09, 0x9b, 0x54, 0x9a, 0x30, 0xb1, 0xdd,
	0x99, 0x54, 0x3c, 0x03, 0xca, 0x40, 0x83, 0x8f, 0x63, 0x77, 0xfb, 0x34, 0xf7, 0xb6, 0xbb, 0xf8,
	0x1c, 0x12, 0x32, 0xae, 0xeb, 0x2d, 0xfc, 0x3f, 0xdf, 0x79, 0x13, 0x26, 0xfd, 0x0a, 0x0f, 0x6c,
	0xba, 0x6f, 0xc0, 0xa5, 0x2e, 0x1d, 0x06, 0x16, 0xf6, 0xd7, 0x40, 0x81, 0xda, 0x51, 0xaa, 0x9b,
	0xaa, 0x69, 0xe9, 0xc6, 0xc1, 0x7f, 0x7b, 0x62, 0xfc, 0x3f, 0xf5, 0x0c, 0xe2, 0x5f, 0x22, 0xfe,
	0x92, 0xe6, 0xd5, 0x98, 0x95, 0xb4, 0xcf, 0x04, 0xb8, 0xec, 0xea, 0x6c, 0x29, 0xd5, 0xe2, 0x47,
	0x36, 0x41, 0xd1, 0xc0, 0x25, 0xdd, 0x28, 0xb3, 0x22, 0xb7, 0xcb, 0x77, 0x5a, 0x4f, 0xde, 0x2b,
	0x13, 0xb6, 0x44, 0x36, 0x91, 0x13, 0x95, 0x1e, 0x2b, 0xbc, 0xe5, 0x32, 0xf9, 0x2f, 0x01, 0x12,
	0xbd, 0xc4, 0xbf, 0xb5, 0x01, 0xed, 0x15, 0x49, 0x91, 0x1e, 0x91, 0x44, 0xd2, 0x8c, 0x1b, 0x00,
	0xb6, 0x83, 0x37, 0xe0, 0x1c, 0xae, 0x54, 0x68, 0x6e, 0xc2, 0xc5, 0x8a, 0xa1, 0xd7, 0xa9, 0xef,
	0xc2, 0x46, 0x9f, 0x1d, 0xe7, 0x5e, 0x48, 0x3e, 0xeb, 0x72, 0x3c, 0x34, 0xf4, 0x3a, 0xba, 0x0d,
	0x63, 0x1d, 0x11, 0x96, 0xce, 0x2a, 0xe7, 0x49, 0x02, 0xe2, 0x2e, 0xfd, 0x8e, 0x9e, 0xff, 0x49,
	0x12, 0xce, 0x3b, 0x16, 0xd8, 0xb6, 0x2b, 0x18, 0xfa, 0xa9, 0x00, 0x91, 0x47, 0xd8, 0x42, 0xcb,
	0x7c, 0xee, 0xeb, 0xbe, 0xdf, 0x49, 0xf6, 0x79, 0x5b, 0x20, 0xa6, 0x3f, 0xfd, 0xed, 0x1f, 0x7f,
	0x3c, 0x74, 0x1d, 0x5d, 0x0d, 0xbf, 0x92, 0x32, 0xb3, 0x1f, 0x7b, 0x3c, 0xf1, 0x92, 0x4c, 0x63,
	0x51, 0x12, 0x34, 0x68, 0xb5, 0xff, 0x00, 0x73, 0xda, 0xca, 0xe4, 0xda, 0x40, 0xbc, 0x76, 0x4c,
	0x8a, 0x57, 0x28, 0xe0, 0x4b, 0xe8, 0xbd, 0x1e, 0x80, 0x51, 0x5b, 0x80, 0x98, 0x5d, 0x0f, 0xd0,
	0xda, 0x29, 0x6e, 0x09, 0x92, 0x6f, 0xef, 0x13, 0xc5, 0xcd, 0xf6, 0x71, 0x4a, 0xec, 0x39, 0xbc,
	0x8f, 0x38, 0x6f, 0x28, 0xe2, 0x29, 0xb1, 0x17, 0xe2, 0x55, 0x21, 0x85, 0x5e, 0x0b, 0x10, 0xb3,
	0x07, 0x41, 0x5e, 0xd0, 0xa1, 0xf3, 0x2d, 0x0f, 0xe8, 0xa7, 0x36, 0xe8, 0x1e, 0x63, 0xa7, 0x1f,
	0x74, 0x2a, 0xcf, 0x17, 0x17, 0x44, 0x85, 0x5f, 0x0b, 0x10, 0xb3, 0x07, 0x4a, 0x5e, 0x15, 0x42,
	0xc7, 0x57, 0x1e, 0x15, 0xbe, 0xdd, 0x3e, 0x4e, 0x65, 0x7b, 0x8e, 0xaf, 0x13, 0xc1, 0x03, 0xf8,
	0xa0, 0xde, 0xb0, 0x0e, 0xec, 0x38, 0x4f, 0x71, 0xc6, 0x79, 0x5b, 0x00, 0x78, 0x84, 0x2d, 0x96,
	0x41, 0xd0, 0xdd, 0xbe, 0xcf, 0xa3, 0xbf, 0x81, 0x4b, 0xf6, 0x37, 0xcc, 0x89, 0x8b, 0x14, 0x6d,
	0x06, 0xdd, 0xf0, 0xa3, 0x75, 0x46, 0x3c, 0x0f, 0xd8, 0x4e, 0xf6, 0x7b, 0x89, 0x7e, 0x21, 0xc0,
	0xf9, 0x0e, 0x68, 0x7a, 0xb5, 0x8a, 0xee, 0x0f, 0x8a, 0xdc, 0x7b, 0x33, 0xdb, 0x2f, 0xfc, 0x79,
	0x0a, 0x7f, 0x06, 0x4d, 0x85, 0xc3, 0x5f, 0xdd, 0xa3, 0xd0, 0x3e, 0x17, 0x60, 0x8c, 0x9c, 0x71,
	0x67, 0x16, 0x46, 0x85, 0x01, 0xf2, 0x42, 0xe0, 0xba, 0x20, 0x79, 0xef, 0x54, 0x32, 0x58, 0x8e,
	0x99, 0xa1, 0xf8, 0x13, 0x68, 0x32, 0x1c, 0x3f, 0xfa, 0x8d, 0x00, 0xb1, 0x6d, 0x6c, 0x11, 0x25,
	0x38, 0x43, 0x3d, 0xb4, 0x9f, 0xe4, 0x09, 0xf5, 0x52, 0xfb, 0x38, 0x35, 0xd7, 0xb3, 0x3d, 0x1b,
	0x66, 0xd0, 0x29, 0xde, 0x65, 0xf1, 0x66, 0x3f, 0xe1, 0xb2, 0x6a, 0x52, 0x0d, 0xc8, 0xd1, 0xfd,
	0xbd, 0x00, 0xa3, 0x76, 0xdb, 0x46, 0x54, 0xba, 0xc3, 0x3b, 0xfb, 0x85, 0xf7, 0xaa, 0x3c, 0x5a,
	0xa9, 0xed, 0xe3, 0xd4, 0xfc, 0x49, 0xad, 0xa2, 0x4f, 0xb1, 0x35, 0x71, 0xa9, 0x2f, 0xc5, 0x0c,
	0x47, 0x15, 0xa2, 0xdb, 0xef, 0x04, 0x38, 0x47, 0xbc, 0xdd, 0x69, 0x32, 0xd0, 0xbd, 0xd3, 0x35,
	0x47, 0xb6, 0x96, 0xf7, 0xff, 0x13, 0x1d, 0x96, 0xb8, 0x4c, 0x15, 0xcc, 0xa3, 0x1c, 0x5f, 0x9a,
	0xb5, 0x3a, 0x4a, 0xfc, 0x4a, 0x80, 0xb3, 0x76, 0xe1, 0x71, 0x92, 0x54, 0xe1, 0xf4, 0x83, 0x26,
	0x8f, 0xef, 0x9e, 0xb4, 0x8f, 0x53, 0x0b, 0x6f, 0x1b, 0xb9, 0x7c, 0xfe, 0xbb, 0x2c, 0xf6, 0x38,
	0x48, 0xc4, 0x3f, 0x3f, 0x67, 0x59, 0xc0, 0xb9, 0x35, 0x44, 0x2b, 0xfc, 0x86, 0x0d, 0x5c, 0x40,
	0x26, 0x57, 0x07, 0x61, 0x3d, 0xf9, 0xcc, 0x3b, 0x17, 0x95, 0x6e, 0x1c, 0x75, 0x6e, 0x99, 0x06,
	0x89, 0xa3, 0xae, 0x3b, 0xb6, 0x41, 0xe2, 0xa8, 0xfb, 0xa2, 0xab, 0xcf, 0x38, 0xca, 0x7a, 0xee,
	0xb7, 0x3e, 0x17, 0x00, 0x11, 0xe1, 0x1b, 0xf4, 0xbb, 0x65, 0x41, 0xd5, 0xca, 0xaa, 0x56, 0x35,
	0x51, 0xa0, 0x8f, 0x64, 0x5f, 0x35, 0xbb, 0x09, 0x1d, 0x35, 0xb2, 0xdc, 0xf4, 0x0c, 0xf1, 0xd7,
	0x29, 0xe2, 0x55, 0xb4, 0xdc, 0x13, 0xb1, 0x73, 0x97, 0x44, 0x23, 0xbf, 0xd6, 0x0d, 0xf1, 0x4f,
	0x02, 0x5c, 0xd8, 0xc6, 0xc1, 0xb7, 0xe9, 0x50, 0x20, 0x5d, 0x74, 0x7d, 0x04, 0xfc, 0xf7, 0xda,
	0xc7, 0xa9, 0x15, 0x98, 0xed, 0x25, 0x89, 0xa7, 0xef, 0x58, 0x17, 0xbf, 0xc6, 0xa7, 0xa6, 0x19,
	0x94, 0x4e, 0x8e, 0xc8, 0xdf, 0x04, 0xb8, 0x68, 0xb7, 0x6b, 0x01, 0x5d, 0x73, 0xa1, 0xba, 0x86,
	0x91, 0xf6, 0xa1, 0xee, 0xf7, 0x85, 0xf6, 0x71, 0x6a, 0x1d, 0xbe, 0x72, 0x82, 0x34, 0x1e, 0x95,
	0xef, 0x8a, 0xab, 0x7c, 0x2a, 0x37, 0x43, 0x36, 0x58, 0x15, 0x52, 0x85, 0xef, 0xc2, 0x82, 0x5f,
	0xbb, 0x86, 0xda, 0xeb, 0x74, 0x7c, 0x28, 0x57, 0x55, 0xeb, 0xa3, 0xe6, 0x5e, 0xa6, 0xa4, 0xd7,
	0xb3, 0x36, 0x53, 0xda, 0xfe, 0x2a, 0x5e, 0xd5, 0xd3, 0x55, 0xac, 0x51, 0x78, 0x59, 0x9e, 0x6f,
	0xf1, 0x6b, 0xee, 0xc3, 0x5e, 0x8c, 0x72, 0xdd, 0xfc, 0x77, 0x00, 0x00, 0x00, 0xff, 0xff, 0xab,
	0x59, 0x70, 0x32, 0xec, 0x20, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// FunctionServiceClient is the client API for FunctionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type FunctionServiceClient interface {
	// Returns the specified function.
	//
	// To get the list of all available functions, make a [List] request.
	Get(ctx context.Context, in *GetFunctionRequest, opts ...grpc.CallOption) (*Function, error)
	// Retrieves the list of functions in the specified folder.
	List(ctx context.Context, in *ListFunctionsRequest, opts ...grpc.CallOption) (*ListFunctionsResponse, error)
	// Creates a function in the specified folder.
	Create(ctx context.Context, in *CreateFunctionRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified function.
	Update(ctx context.Context, in *UpdateFunctionRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified function.
	Delete(ctx context.Context, in *DeleteFunctionRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Returns the specified version of a function.
	//
	// To get the list of available version, make a [ListVersions] request.
	GetVersion(ctx context.Context, in *GetFunctionVersionRequest, opts ...grpc.CallOption) (*Version, error)
	// Returns all versions with the specified tag.
	//
	// To get the list of all available versions, make a [ListVersions] request.
	GetVersionByTag(ctx context.Context, in *GetFunctionVersionByTagRequest, opts ...grpc.CallOption) (*Version, error)
	// Retrieves the list of versions for the specified function, or of all function versions
	// in the specified folder.
	ListVersions(ctx context.Context, in *ListFunctionsVersionsRequest, opts ...grpc.CallOption) (*ListFunctionsVersionsResponse, error)
	// Set a tag for the specified version of a function.
	SetTag(ctx context.Context, in *SetFunctionTagRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Remove a tag from the specified version of a function.
	RemoveTag(ctx context.Context, in *RemoveFunctionTagRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Returns the log of tags assigned to versions of the specified function.
	ListTagHistory(ctx context.Context, in *ListFunctionTagHistoryRequest, opts ...grpc.CallOption) (*ListFunctionTagHistoryResponse, error)
	// Creates a version for the specified function.
	CreateVersion(ctx context.Context, in *CreateFunctionVersionRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists available runtime environments for the specified function.
	ListRuntimes(ctx context.Context, in *ListRuntimesRequest, opts ...grpc.CallOption) (*ListRuntimesResponse, error)
	// Lists operations for the specified function.
	ListOperations(ctx context.Context, in *ListFunctionOperationsRequest, opts ...grpc.CallOption) (*ListFunctionOperationsResponse, error)
	// Lists existing access bindings for the specified function.
	ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error)
	// Sets access bindings for the function.
	SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates access bindings for the specified function.
	UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
}

type functionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewFunctionServiceClient(cc grpc.ClientConnInterface) FunctionServiceClient {
	return &functionServiceClient{cc}
}

func (c *functionServiceClient) Get(ctx context.Context, in *GetFunctionRequest, opts ...grpc.CallOption) (*Function, error) {
	out := new(Function)
	err := c.cc.Invoke(ctx, "/yandex.cloud.serverless.functions.v1.FunctionService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) List(ctx context.Context, in *ListFunctionsRequest, opts ...grpc.CallOption) (*ListFunctionsResponse, error) {
	out := new(ListFunctionsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.serverless.functions.v1.FunctionService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) Create(ctx context.Context, in *CreateFunctionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.serverless.functions.v1.FunctionService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) Update(ctx context.Context, in *UpdateFunctionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.serverless.functions.v1.FunctionService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) Delete(ctx context.Context, in *DeleteFunctionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.serverless.functions.v1.FunctionService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) GetVersion(ctx context.Context, in *GetFunctionVersionRequest, opts ...grpc.CallOption) (*Version, error) {
	out := new(Version)
	err := c.cc.Invoke(ctx, "/yandex.cloud.serverless.functions.v1.FunctionService/GetVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) GetVersionByTag(ctx context.Context, in *GetFunctionVersionByTagRequest, opts ...grpc.CallOption) (*Version, error) {
	out := new(Version)
	err := c.cc.Invoke(ctx, "/yandex.cloud.serverless.functions.v1.FunctionService/GetVersionByTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) ListVersions(ctx context.Context, in *ListFunctionsVersionsRequest, opts ...grpc.CallOption) (*ListFunctionsVersionsResponse, error) {
	out := new(ListFunctionsVersionsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.serverless.functions.v1.FunctionService/ListVersions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) SetTag(ctx context.Context, in *SetFunctionTagRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.serverless.functions.v1.FunctionService/SetTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) RemoveTag(ctx context.Context, in *RemoveFunctionTagRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.serverless.functions.v1.FunctionService/RemoveTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) ListTagHistory(ctx context.Context, in *ListFunctionTagHistoryRequest, opts ...grpc.CallOption) (*ListFunctionTagHistoryResponse, error) {
	out := new(ListFunctionTagHistoryResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.serverless.functions.v1.FunctionService/ListTagHistory", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) CreateVersion(ctx context.Context, in *CreateFunctionVersionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.serverless.functions.v1.FunctionService/CreateVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) ListRuntimes(ctx context.Context, in *ListRuntimesRequest, opts ...grpc.CallOption) (*ListRuntimesResponse, error) {
	out := new(ListRuntimesResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.serverless.functions.v1.FunctionService/ListRuntimes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) ListOperations(ctx context.Context, in *ListFunctionOperationsRequest, opts ...grpc.CallOption) (*ListFunctionOperationsResponse, error) {
	out := new(ListFunctionOperationsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.serverless.functions.v1.FunctionService/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error) {
	out := new(access.ListAccessBindingsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.serverless.functions.v1.FunctionService/ListAccessBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.serverless.functions.v1.FunctionService/SetAccessBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.serverless.functions.v1.FunctionService/UpdateAccessBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FunctionServiceServer is the server API for FunctionService service.
type FunctionServiceServer interface {
	// Returns the specified function.
	//
	// To get the list of all available functions, make a [List] request.
	Get(context.Context, *GetFunctionRequest) (*Function, error)
	// Retrieves the list of functions in the specified folder.
	List(context.Context, *ListFunctionsRequest) (*ListFunctionsResponse, error)
	// Creates a function in the specified folder.
	Create(context.Context, *CreateFunctionRequest) (*operation.Operation, error)
	// Updates the specified function.
	Update(context.Context, *UpdateFunctionRequest) (*operation.Operation, error)
	// Deletes the specified function.
	Delete(context.Context, *DeleteFunctionRequest) (*operation.Operation, error)
	// Returns the specified version of a function.
	//
	// To get the list of available version, make a [ListVersions] request.
	GetVersion(context.Context, *GetFunctionVersionRequest) (*Version, error)
	// Returns all versions with the specified tag.
	//
	// To get the list of all available versions, make a [ListVersions] request.
	GetVersionByTag(context.Context, *GetFunctionVersionByTagRequest) (*Version, error)
	// Retrieves the list of versions for the specified function, or of all function versions
	// in the specified folder.
	ListVersions(context.Context, *ListFunctionsVersionsRequest) (*ListFunctionsVersionsResponse, error)
	// Set a tag for the specified version of a function.
	SetTag(context.Context, *SetFunctionTagRequest) (*operation.Operation, error)
	// Remove a tag from the specified version of a function.
	RemoveTag(context.Context, *RemoveFunctionTagRequest) (*operation.Operation, error)
	// Returns the log of tags assigned to versions of the specified function.
	ListTagHistory(context.Context, *ListFunctionTagHistoryRequest) (*ListFunctionTagHistoryResponse, error)
	// Creates a version for the specified function.
	CreateVersion(context.Context, *CreateFunctionVersionRequest) (*operation.Operation, error)
	// Lists available runtime environments for the specified function.
	ListRuntimes(context.Context, *ListRuntimesRequest) (*ListRuntimesResponse, error)
	// Lists operations for the specified function.
	ListOperations(context.Context, *ListFunctionOperationsRequest) (*ListFunctionOperationsResponse, error)
	// Lists existing access bindings for the specified function.
	ListAccessBindings(context.Context, *access.ListAccessBindingsRequest) (*access.ListAccessBindingsResponse, error)
	// Sets access bindings for the function.
	SetAccessBindings(context.Context, *access.SetAccessBindingsRequest) (*operation.Operation, error)
	// Updates access bindings for the specified function.
	UpdateAccessBindings(context.Context, *access.UpdateAccessBindingsRequest) (*operation.Operation, error)
}

// UnimplementedFunctionServiceServer can be embedded to have forward compatible implementations.
type UnimplementedFunctionServiceServer struct {
}

func (*UnimplementedFunctionServiceServer) Get(ctx context.Context, req *GetFunctionRequest) (*Function, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedFunctionServiceServer) List(ctx context.Context, req *ListFunctionsRequest) (*ListFunctionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedFunctionServiceServer) Create(ctx context.Context, req *CreateFunctionRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (*UnimplementedFunctionServiceServer) Update(ctx context.Context, req *UpdateFunctionRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (*UnimplementedFunctionServiceServer) Delete(ctx context.Context, req *DeleteFunctionRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedFunctionServiceServer) GetVersion(ctx context.Context, req *GetFunctionVersionRequest) (*Version, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVersion not implemented")
}
func (*UnimplementedFunctionServiceServer) GetVersionByTag(ctx context.Context, req *GetFunctionVersionByTagRequest) (*Version, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVersionByTag not implemented")
}
func (*UnimplementedFunctionServiceServer) ListVersions(ctx context.Context, req *ListFunctionsVersionsRequest) (*ListFunctionsVersionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVersions not implemented")
}
func (*UnimplementedFunctionServiceServer) SetTag(ctx context.Context, req *SetFunctionTagRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetTag not implemented")
}
func (*UnimplementedFunctionServiceServer) RemoveTag(ctx context.Context, req *RemoveFunctionTagRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveTag not implemented")
}
func (*UnimplementedFunctionServiceServer) ListTagHistory(ctx context.Context, req *ListFunctionTagHistoryRequest) (*ListFunctionTagHistoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTagHistory not implemented")
}
func (*UnimplementedFunctionServiceServer) CreateVersion(ctx context.Context, req *CreateFunctionVersionRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateVersion not implemented")
}
func (*UnimplementedFunctionServiceServer) ListRuntimes(ctx context.Context, req *ListRuntimesRequest) (*ListRuntimesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRuntimes not implemented")
}
func (*UnimplementedFunctionServiceServer) ListOperations(ctx context.Context, req *ListFunctionOperationsRequest) (*ListFunctionOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOperations not implemented")
}
func (*UnimplementedFunctionServiceServer) ListAccessBindings(ctx context.Context, req *access.ListAccessBindingsRequest) (*access.ListAccessBindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAccessBindings not implemented")
}
func (*UnimplementedFunctionServiceServer) SetAccessBindings(ctx context.Context, req *access.SetAccessBindingsRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetAccessBindings not implemented")
}
func (*UnimplementedFunctionServiceServer) UpdateAccessBindings(ctx context.Context, req *access.UpdateAccessBindingsRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAccessBindings not implemented")
}

func RegisterFunctionServiceServer(s *grpc.Server, srv FunctionServiceServer) {
	s.RegisterService(&_FunctionService_serviceDesc, srv)
}

func _FunctionService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.serverless.functions.v1.FunctionService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).Get(ctx, req.(*GetFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFunctionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.serverless.functions.v1.FunctionService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).List(ctx, req.(*ListFunctionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.serverless.functions.v1.FunctionService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).Create(ctx, req.(*CreateFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.serverless.functions.v1.FunctionService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).Update(ctx, req.(*UpdateFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.serverless.functions.v1.FunctionService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).Delete(ctx, req.(*DeleteFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_GetVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFunctionVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).GetVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.serverless.functions.v1.FunctionService/GetVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).GetVersion(ctx, req.(*GetFunctionVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_GetVersionByTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFunctionVersionByTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).GetVersionByTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.serverless.functions.v1.FunctionService/GetVersionByTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).GetVersionByTag(ctx, req.(*GetFunctionVersionByTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_ListVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFunctionsVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).ListVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.serverless.functions.v1.FunctionService/ListVersions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).ListVersions(ctx, req.(*ListFunctionsVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_SetTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetFunctionTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).SetTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.serverless.functions.v1.FunctionService/SetTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).SetTag(ctx, req.(*SetFunctionTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_RemoveTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveFunctionTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).RemoveTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.serverless.functions.v1.FunctionService/RemoveTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).RemoveTag(ctx, req.(*RemoveFunctionTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_ListTagHistory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFunctionTagHistoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).ListTagHistory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.serverless.functions.v1.FunctionService/ListTagHistory",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).ListTagHistory(ctx, req.(*ListFunctionTagHistoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_CreateVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFunctionVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).CreateVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.serverless.functions.v1.FunctionService/CreateVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).CreateVersion(ctx, req.(*CreateFunctionVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_ListRuntimes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRuntimesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).ListRuntimes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.serverless.functions.v1.FunctionService/ListRuntimes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).ListRuntimes(ctx, req.(*ListRuntimesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFunctionOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.serverless.functions.v1.FunctionService/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).ListOperations(ctx, req.(*ListFunctionOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_ListAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.ListAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).ListAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.serverless.functions.v1.FunctionService/ListAccessBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).ListAccessBindings(ctx, req.(*access.ListAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_SetAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.SetAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).SetAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.serverless.functions.v1.FunctionService/SetAccessBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).SetAccessBindings(ctx, req.(*access.SetAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_UpdateAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.UpdateAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).UpdateAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.serverless.functions.v1.FunctionService/UpdateAccessBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).UpdateAccessBindings(ctx, req.(*access.UpdateAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _FunctionService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.serverless.functions.v1.FunctionService",
	HandlerType: (*FunctionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _FunctionService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _FunctionService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _FunctionService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _FunctionService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _FunctionService_Delete_Handler,
		},
		{
			MethodName: "GetVersion",
			Handler:    _FunctionService_GetVersion_Handler,
		},
		{
			MethodName: "GetVersionByTag",
			Handler:    _FunctionService_GetVersionByTag_Handler,
		},
		{
			MethodName: "ListVersions",
			Handler:    _FunctionService_ListVersions_Handler,
		},
		{
			MethodName: "SetTag",
			Handler:    _FunctionService_SetTag_Handler,
		},
		{
			MethodName: "RemoveTag",
			Handler:    _FunctionService_RemoveTag_Handler,
		},
		{
			MethodName: "ListTagHistory",
			Handler:    _FunctionService_ListTagHistory_Handler,
		},
		{
			MethodName: "CreateVersion",
			Handler:    _FunctionService_CreateVersion_Handler,
		},
		{
			MethodName: "ListRuntimes",
			Handler:    _FunctionService_ListRuntimes_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _FunctionService_ListOperations_Handler,
		},
		{
			MethodName: "ListAccessBindings",
			Handler:    _FunctionService_ListAccessBindings_Handler,
		},
		{
			MethodName: "SetAccessBindings",
			Handler:    _FunctionService_SetAccessBindings_Handler,
		},
		{
			MethodName: "UpdateAccessBindings",
			Handler:    _FunctionService_UpdateAccessBindings_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/serverless/functions/v1/function_service.proto",
}
