// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/serverless/triggers/v1/trigger_service.proto

package triggers

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type GetTriggerRequest struct {
	// ID of the trigger to return.
	//
	// To get a trigger ID make a [TriggerService.List] request.
	TriggerId            string   `protobuf:"bytes,1,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetTriggerRequest) Reset()         { *m = GetTriggerRequest{} }
func (m *GetTriggerRequest) String() string { return proto.CompactTextString(m) }
func (*GetTriggerRequest) ProtoMessage()    {}
func (*GetTriggerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5bad950ea438470, []int{0}
}

func (m *GetTriggerRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetTriggerRequest.Unmarshal(m, b)
}
func (m *GetTriggerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetTriggerRequest.Marshal(b, m, deterministic)
}
func (m *GetTriggerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTriggerRequest.Merge(m, src)
}
func (m *GetTriggerRequest) XXX_Size() int {
	return xxx_messageInfo_GetTriggerRequest.Size(m)
}
func (m *GetTriggerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTriggerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetTriggerRequest proto.InternalMessageInfo

func (m *GetTriggerRequest) GetTriggerId() string {
	if m != nil {
		return m.TriggerId
	}
	return ""
}

type ListTriggersRequest struct {
	// ID of the folder to list triggers in.
	//
	// To get a folder ID use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than `pageSize`, the service returns a [ListTriggersResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	//
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set `pageToken` to the
	// [ListTriggersResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters triggers listed in the response.
	//
	// The expression must specify:
	// 1. The field name. Currently filtering can only be applied to the [Trigger.name] field.
	// 2. A conditional operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN`
	// for lists of values.
	// 3. The value. Must be 3-63 characters long and match the regular expression `^[a-z][-a-z0-9]{1,61}[a-z0-9]$`.
	// Example of a filter: `name=my-trigger`.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTriggersRequest) Reset()         { *m = ListTriggersRequest{} }
func (m *ListTriggersRequest) String() string { return proto.CompactTextString(m) }
func (*ListTriggersRequest) ProtoMessage()    {}
func (*ListTriggersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5bad950ea438470, []int{1}
}

func (m *ListTriggersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTriggersRequest.Unmarshal(m, b)
}
func (m *ListTriggersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTriggersRequest.Marshal(b, m, deterministic)
}
func (m *ListTriggersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTriggersRequest.Merge(m, src)
}
func (m *ListTriggersRequest) XXX_Size() int {
	return xxx_messageInfo_ListTriggersRequest.Size(m)
}
func (m *ListTriggersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTriggersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTriggersRequest proto.InternalMessageInfo

func (m *ListTriggersRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *ListTriggersRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListTriggersRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListTriggersRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListTriggersResponse struct {
	// List of triggers in the specified folder.
	Triggers []*Trigger `protobuf:"bytes,1,rep,name=triggers,proto3" json:"triggers,omitempty"`
	// Token for getting the next page of the list. If the number of results is greater than
	// the specified [ListTriggersRequest.page_size], use `nextPageToken` as the value
	// for the [ListTriggersRequest.page_token] parameter in the next list request.
	//
	// Each subsequent page will have its own `nextPageToken` to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTriggersResponse) Reset()         { *m = ListTriggersResponse{} }
func (m *ListTriggersResponse) String() string { return proto.CompactTextString(m) }
func (*ListTriggersResponse) ProtoMessage()    {}
func (*ListTriggersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5bad950ea438470, []int{2}
}

func (m *ListTriggersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTriggersResponse.Unmarshal(m, b)
}
func (m *ListTriggersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTriggersResponse.Marshal(b, m, deterministic)
}
func (m *ListTriggersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTriggersResponse.Merge(m, src)
}
func (m *ListTriggersResponse) XXX_Size() int {
	return xxx_messageInfo_ListTriggersResponse.Size(m)
}
func (m *ListTriggersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTriggersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTriggersResponse proto.InternalMessageInfo

func (m *ListTriggersResponse) GetTriggers() []*Trigger {
	if m != nil {
		return m.Triggers
	}
	return nil
}

func (m *ListTriggersResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateTriggerRequest struct {
	// ID of the folder to create a trigger in.
	//
	// To get a folder ID make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the trigger.
	// The name must be unique within the folder.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the trigger.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Trigger type.
	Rule                 *Trigger_Rule `protobuf:"bytes,5,opt,name=rule,proto3" json:"rule,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *CreateTriggerRequest) Reset()         { *m = CreateTriggerRequest{} }
func (m *CreateTriggerRequest) String() string { return proto.CompactTextString(m) }
func (*CreateTriggerRequest) ProtoMessage()    {}
func (*CreateTriggerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5bad950ea438470, []int{3}
}

func (m *CreateTriggerRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTriggerRequest.Unmarshal(m, b)
}
func (m *CreateTriggerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTriggerRequest.Marshal(b, m, deterministic)
}
func (m *CreateTriggerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTriggerRequest.Merge(m, src)
}
func (m *CreateTriggerRequest) XXX_Size() int {
	return xxx_messageInfo_CreateTriggerRequest.Size(m)
}
func (m *CreateTriggerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTriggerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTriggerRequest proto.InternalMessageInfo

func (m *CreateTriggerRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *CreateTriggerRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateTriggerRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *CreateTriggerRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *CreateTriggerRequest) GetRule() *Trigger_Rule {
	if m != nil {
		return m.Rule
	}
	return nil
}

type CreateTriggerMetadata struct {
	// ID of the trigger that is being created.
	TriggerId            string   `protobuf:"bytes,1,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateTriggerMetadata) Reset()         { *m = CreateTriggerMetadata{} }
func (m *CreateTriggerMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateTriggerMetadata) ProtoMessage()    {}
func (*CreateTriggerMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5bad950ea438470, []int{4}
}

func (m *CreateTriggerMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTriggerMetadata.Unmarshal(m, b)
}
func (m *CreateTriggerMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTriggerMetadata.Marshal(b, m, deterministic)
}
func (m *CreateTriggerMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTriggerMetadata.Merge(m, src)
}
func (m *CreateTriggerMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateTriggerMetadata.Size(m)
}
func (m *CreateTriggerMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTriggerMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTriggerMetadata proto.InternalMessageInfo

func (m *CreateTriggerMetadata) GetTriggerId() string {
	if m != nil {
		return m.TriggerId
	}
	return ""
}

type UpdateTriggerRequest struct {
	// ID of the trigger to update.
	//
	// To get a trigger ID make a [TriggerService.List] request.
	TriggerId string `protobuf:"bytes,1,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	// Field mask that specifies which attributes of the trigger should be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// New name for the trigger.
	// The name must be unique within the folder.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// New description of the trigger.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Trigger labels as `key:value` pairs.
	//
	// Existing set of labels is completely replaced by the provided set, so if you just want
	// to add or remove a label, request the current set of labels with a [TriggerService.Get] request.
	Labels               map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UpdateTriggerRequest) Reset()         { *m = UpdateTriggerRequest{} }
func (m *UpdateTriggerRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateTriggerRequest) ProtoMessage()    {}
func (*UpdateTriggerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5bad950ea438470, []int{5}
}

func (m *UpdateTriggerRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateTriggerRequest.Unmarshal(m, b)
}
func (m *UpdateTriggerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateTriggerRequest.Marshal(b, m, deterministic)
}
func (m *UpdateTriggerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateTriggerRequest.Merge(m, src)
}
func (m *UpdateTriggerRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateTriggerRequest.Size(m)
}
func (m *UpdateTriggerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateTriggerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateTriggerRequest proto.InternalMessageInfo

func (m *UpdateTriggerRequest) GetTriggerId() string {
	if m != nil {
		return m.TriggerId
	}
	return ""
}

func (m *UpdateTriggerRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateTriggerRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateTriggerRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *UpdateTriggerRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

type UpdateTriggerMetadata struct {
	// ID of the trigger that is being updated.
	TriggerId            string   `protobuf:"bytes,1,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateTriggerMetadata) Reset()         { *m = UpdateTriggerMetadata{} }
func (m *UpdateTriggerMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateTriggerMetadata) ProtoMessage()    {}
func (*UpdateTriggerMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5bad950ea438470, []int{6}
}

func (m *UpdateTriggerMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateTriggerMetadata.Unmarshal(m, b)
}
func (m *UpdateTriggerMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateTriggerMetadata.Marshal(b, m, deterministic)
}
func (m *UpdateTriggerMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateTriggerMetadata.Merge(m, src)
}
func (m *UpdateTriggerMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateTriggerMetadata.Size(m)
}
func (m *UpdateTriggerMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateTriggerMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateTriggerMetadata proto.InternalMessageInfo

func (m *UpdateTriggerMetadata) GetTriggerId() string {
	if m != nil {
		return m.TriggerId
	}
	return ""
}

type DeleteTriggerRequest struct {
	// ID of the trigger to delete.
	//
	// To get a trigger ID make a [TriggerService.List] request.
	TriggerId            string   `protobuf:"bytes,1,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteTriggerRequest) Reset()         { *m = DeleteTriggerRequest{} }
func (m *DeleteTriggerRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteTriggerRequest) ProtoMessage()    {}
func (*DeleteTriggerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5bad950ea438470, []int{7}
}

func (m *DeleteTriggerRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteTriggerRequest.Unmarshal(m, b)
}
func (m *DeleteTriggerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteTriggerRequest.Marshal(b, m, deterministic)
}
func (m *DeleteTriggerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteTriggerRequest.Merge(m, src)
}
func (m *DeleteTriggerRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteTriggerRequest.Size(m)
}
func (m *DeleteTriggerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteTriggerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteTriggerRequest proto.InternalMessageInfo

func (m *DeleteTriggerRequest) GetTriggerId() string {
	if m != nil {
		return m.TriggerId
	}
	return ""
}

type DeleteTriggerMetadata struct {
	// ID of the trigger that is being deleted.
	TriggerId            string   `protobuf:"bytes,1,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteTriggerMetadata) Reset()         { *m = DeleteTriggerMetadata{} }
func (m *DeleteTriggerMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteTriggerMetadata) ProtoMessage()    {}
func (*DeleteTriggerMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5bad950ea438470, []int{8}
}

func (m *DeleteTriggerMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteTriggerMetadata.Unmarshal(m, b)
}
func (m *DeleteTriggerMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteTriggerMetadata.Marshal(b, m, deterministic)
}
func (m *DeleteTriggerMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteTriggerMetadata.Merge(m, src)
}
func (m *DeleteTriggerMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteTriggerMetadata.Size(m)
}
func (m *DeleteTriggerMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteTriggerMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteTriggerMetadata proto.InternalMessageInfo

func (m *DeleteTriggerMetadata) GetTriggerId() string {
	if m != nil {
		return m.TriggerId
	}
	return ""
}

type PauseTriggerRequest struct {
	// ID of the trigger to pause
	//
	// To get a trigger ID make a [TriggerService.List] request.
	TriggerId            string   `protobuf:"bytes,1,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PauseTriggerRequest) Reset()         { *m = PauseTriggerRequest{} }
func (m *PauseTriggerRequest) String() string { return proto.CompactTextString(m) }
func (*PauseTriggerRequest) ProtoMessage()    {}
func (*PauseTriggerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5bad950ea438470, []int{9}
}

func (m *PauseTriggerRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PauseTriggerRequest.Unmarshal(m, b)
}
func (m *PauseTriggerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PauseTriggerRequest.Marshal(b, m, deterministic)
}
func (m *PauseTriggerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PauseTriggerRequest.Merge(m, src)
}
func (m *PauseTriggerRequest) XXX_Size() int {
	return xxx_messageInfo_PauseTriggerRequest.Size(m)
}
func (m *PauseTriggerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PauseTriggerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PauseTriggerRequest proto.InternalMessageInfo

func (m *PauseTriggerRequest) GetTriggerId() string {
	if m != nil {
		return m.TriggerId
	}
	return ""
}

type PauseTriggerMetadata struct {
	// ID of the trigger that is being paused.
	TriggerId            string   `protobuf:"bytes,1,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PauseTriggerMetadata) Reset()         { *m = PauseTriggerMetadata{} }
func (m *PauseTriggerMetadata) String() string { return proto.CompactTextString(m) }
func (*PauseTriggerMetadata) ProtoMessage()    {}
func (*PauseTriggerMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5bad950ea438470, []int{10}
}

func (m *PauseTriggerMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PauseTriggerMetadata.Unmarshal(m, b)
}
func (m *PauseTriggerMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PauseTriggerMetadata.Marshal(b, m, deterministic)
}
func (m *PauseTriggerMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PauseTriggerMetadata.Merge(m, src)
}
func (m *PauseTriggerMetadata) XXX_Size() int {
	return xxx_messageInfo_PauseTriggerMetadata.Size(m)
}
func (m *PauseTriggerMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_PauseTriggerMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_PauseTriggerMetadata proto.InternalMessageInfo

func (m *PauseTriggerMetadata) GetTriggerId() string {
	if m != nil {
		return m.TriggerId
	}
	return ""
}

type ResumeTriggerRequest struct {
	// ID of the trigger to pause
	//
	// To get a trigger ID make a [TriggerService.List] request.
	TriggerId            string   `protobuf:"bytes,1,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResumeTriggerRequest) Reset()         { *m = ResumeTriggerRequest{} }
func (m *ResumeTriggerRequest) String() string { return proto.CompactTextString(m) }
func (*ResumeTriggerRequest) ProtoMessage()    {}
func (*ResumeTriggerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5bad950ea438470, []int{11}
}

func (m *ResumeTriggerRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResumeTriggerRequest.Unmarshal(m, b)
}
func (m *ResumeTriggerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResumeTriggerRequest.Marshal(b, m, deterministic)
}
func (m *ResumeTriggerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResumeTriggerRequest.Merge(m, src)
}
func (m *ResumeTriggerRequest) XXX_Size() int {
	return xxx_messageInfo_ResumeTriggerRequest.Size(m)
}
func (m *ResumeTriggerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ResumeTriggerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ResumeTriggerRequest proto.InternalMessageInfo

func (m *ResumeTriggerRequest) GetTriggerId() string {
	if m != nil {
		return m.TriggerId
	}
	return ""
}

type ResumeTriggerMetadata struct {
	// ID of the trigger that is being paused.
	TriggerId            string   `protobuf:"bytes,1,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResumeTriggerMetadata) Reset()         { *m = ResumeTriggerMetadata{} }
func (m *ResumeTriggerMetadata) String() string { return proto.CompactTextString(m) }
func (*ResumeTriggerMetadata) ProtoMessage()    {}
func (*ResumeTriggerMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5bad950ea438470, []int{12}
}

func (m *ResumeTriggerMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResumeTriggerMetadata.Unmarshal(m, b)
}
func (m *ResumeTriggerMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResumeTriggerMetadata.Marshal(b, m, deterministic)
}
func (m *ResumeTriggerMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResumeTriggerMetadata.Merge(m, src)
}
func (m *ResumeTriggerMetadata) XXX_Size() int {
	return xxx_messageInfo_ResumeTriggerMetadata.Size(m)
}
func (m *ResumeTriggerMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ResumeTriggerMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ResumeTriggerMetadata proto.InternalMessageInfo

func (m *ResumeTriggerMetadata) GetTriggerId() string {
	if m != nil {
		return m.TriggerId
	}
	return ""
}

type ListTriggerOperationsRequest struct {
	// ID of the trigger to list operations for.
	TriggerId string `protobuf:"bytes,1,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available
	// results is larger than `pageSize`, the service returns a [ListTriggerOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	//
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set `pageToken` to the
	// [ListTriggerOperationsResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	//
	// The expression must specify:
	// 1. The field name. Currently filtering can only be applied to the [Trigger.name] field.
	// 2. A conditional operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN`
	// for lists of values.
	// 3. The value. Must be 3-63 characters long and match the regular expression `^[a-z][-a-z0-9]{1,61}[a-z0-9]$`.
	// Example of a filter: `name=my-function`.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTriggerOperationsRequest) Reset()         { *m = ListTriggerOperationsRequest{} }
func (m *ListTriggerOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListTriggerOperationsRequest) ProtoMessage()    {}
func (*ListTriggerOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5bad950ea438470, []int{13}
}

func (m *ListTriggerOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTriggerOperationsRequest.Unmarshal(m, b)
}
func (m *ListTriggerOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTriggerOperationsRequest.Marshal(b, m, deterministic)
}
func (m *ListTriggerOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTriggerOperationsRequest.Merge(m, src)
}
func (m *ListTriggerOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListTriggerOperationsRequest.Size(m)
}
func (m *ListTriggerOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTriggerOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTriggerOperationsRequest proto.InternalMessageInfo

func (m *ListTriggerOperationsRequest) GetTriggerId() string {
	if m != nil {
		return m.TriggerId
	}
	return ""
}

func (m *ListTriggerOperationsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListTriggerOperationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListTriggerOperationsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListTriggerOperationsResponse struct {
	// List of operations for the specified trigger.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// Token for getting the next page of the list. If the number of results is greater than
	// the specified [ListTriggerOperationsRequest.page_size], use `nextPageToken` as the value
	// for the [ListTriggerOperationsRequest.page_token] parameter in the next list request.
	//
	// Each subsequent page will have its own `nextPageToken` to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTriggerOperationsResponse) Reset()         { *m = ListTriggerOperationsResponse{} }
func (m *ListTriggerOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListTriggerOperationsResponse) ProtoMessage()    {}
func (*ListTriggerOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5bad950ea438470, []int{14}
}

func (m *ListTriggerOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTriggerOperationsResponse.Unmarshal(m, b)
}
func (m *ListTriggerOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTriggerOperationsResponse.Marshal(b, m, deterministic)
}
func (m *ListTriggerOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTriggerOperationsResponse.Merge(m, src)
}
func (m *ListTriggerOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListTriggerOperationsResponse.Size(m)
}
func (m *ListTriggerOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTriggerOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTriggerOperationsResponse proto.InternalMessageInfo

func (m *ListTriggerOperationsResponse) GetOperations() []*operation.Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListTriggerOperationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*GetTriggerRequest)(nil), "yandex.cloud.serverless.triggers.v1.GetTriggerRequest")
	proto.RegisterType((*ListTriggersRequest)(nil), "yandex.cloud.serverless.triggers.v1.ListTriggersRequest")
	proto.RegisterType((*ListTriggersResponse)(nil), "yandex.cloud.serverless.triggers.v1.ListTriggersResponse")
	proto.RegisterType((*CreateTriggerRequest)(nil), "yandex.cloud.serverless.triggers.v1.CreateTriggerRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.serverless.triggers.v1.CreateTriggerRequest.LabelsEntry")
	proto.RegisterType((*CreateTriggerMetadata)(nil), "yandex.cloud.serverless.triggers.v1.CreateTriggerMetadata")
	proto.RegisterType((*UpdateTriggerRequest)(nil), "yandex.cloud.serverless.triggers.v1.UpdateTriggerRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.serverless.triggers.v1.UpdateTriggerRequest.LabelsEntry")
	proto.RegisterType((*UpdateTriggerMetadata)(nil), "yandex.cloud.serverless.triggers.v1.UpdateTriggerMetadata")
	proto.RegisterType((*DeleteTriggerRequest)(nil), "yandex.cloud.serverless.triggers.v1.DeleteTriggerRequest")
	proto.RegisterType((*DeleteTriggerMetadata)(nil), "yandex.cloud.serverless.triggers.v1.DeleteTriggerMetadata")
	proto.RegisterType((*PauseTriggerRequest)(nil), "yandex.cloud.serverless.triggers.v1.PauseTriggerRequest")
	proto.RegisterType((*PauseTriggerMetadata)(nil), "yandex.cloud.serverless.triggers.v1.PauseTriggerMetadata")
	proto.RegisterType((*ResumeTriggerRequest)(nil), "yandex.cloud.serverless.triggers.v1.ResumeTriggerRequest")
	proto.RegisterType((*ResumeTriggerMetadata)(nil), "yandex.cloud.serverless.triggers.v1.ResumeTriggerMetadata")
	proto.RegisterType((*ListTriggerOperationsRequest)(nil), "yandex.cloud.serverless.triggers.v1.ListTriggerOperationsRequest")
	proto.RegisterType((*ListTriggerOperationsResponse)(nil), "yandex.cloud.serverless.triggers.v1.ListTriggerOperationsResponse")
}

func init() {
	proto.RegisterFile("yandex/cloud/serverless/triggers/v1/trigger_service.proto", fileDescriptor_b5bad950ea438470)
}

var fileDescriptor_b5bad950ea438470 = []byte{
	// 1130 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x57, 0xcf, 0x6f, 0xdc, 0x44,
	0x14, 0xd6, 0x64, 0x37, 0x4b, 0xf6, 0xad, 0x28, 0x65, 0xba, 0x81, 0xd5, 0xd2, 0x88, 0x8d, 0x8b,
	0x9a, 0x65, 0xa9, 0xed, 0xf5, 0x96, 0x44, 0xd9, 0x24, 0x15, 0xea, 0xd2, 0x50, 0x2a, 0x5a, 0x11,
	0xdc, 0x82, 0x10, 0xa1, 0x8a, 0x9c, 0x78, 0xb2, 0x58, 0x71, 0xd6, 0xc6, 0x63, 0x47, 0x4d, 0x42,
	0x2f, 0x3d, 0xa1, 0x88, 0x1b, 0x07, 0x24, 0x0e, 0xfc, 0x05, 0x9c, 0x72, 0x02, 0xc4, 0x81, 0x03,
	0x22, 0x39, 0x20, 0x0e, 0xe1, 0x5f, 0xe0, 0xc0, 0xb9, 0x47, 0x4e, 0xc8, 0x33, 0xf6, 0xc6, 0xce,
	0x3a, 0xea, 0x6c, 0xa2, 0x9e, 0xd6, 0x3b, 0xf3, 0xbe, 0x37, 0xdf, 0xfb, 0x31, 0xef, 0xb3, 0xa1,
	0xbd, 0x6d, 0xf4, 0x4c, 0xf2, 0x48, 0x5d, 0xb3, 0x9d, 0xc0, 0x54, 0x29, 0xf1, 0xb6, 0x88, 0x67,
	0x13, 0x4a, 0x55, 0xdf, 0xb3, 0xba, 0x5d, 0xe2, 0x51, 0x75, 0x4b, 0x8b, 0x9f, 0x57, 0xc2, 0x6d,
	0x6b, 0x8d, 0x28, 0xae, 0xe7, 0xf8, 0x0e, 0xbe, 0xc2, 0xa1, 0x0a, 0x83, 0x2a, 0xc7, 0x50, 0x25,
	0x86, 0x2a, 0x5b, 0x5a, 0xb5, 0xd6, 0x75, 0x9c, 0xae, 0x4d, 0x54, 0x06, 0x59, 0x0d, 0xd6, 0xd5,
	0x75, 0x8b, 0xd8, 0xe6, 0xca, 0xa6, 0x41, 0x37, 0xb8, 0x9b, 0xea, 0xe5, 0xc8, 0xc2, 0x70, 0x2d,
	0xd5, 0xe8, 0xf5, 0x1c, 0xdf, 0xf0, 0x2d, 0xa7, 0x47, 0xa3, 0xdd, 0x5a, 0x8a, 0x5f, 0x68, 0xe3,
	0xb8, 0xc4, 0x63, 0x26, 0x91, 0x85, 0x36, 0x44, 0x04, 0x11, 0xe4, 0x6a, 0x0a, 0xd2, 0x77, 0x38,
	0xe0, 0x7a, 0x22, 0x65, 0xb7, 0x65, 0xd8, 0x96, 0x99, 0xd8, 0x96, 0x66, 0xe1, 0xe5, 0xdb, 0xc4,
	0x7f, 0xc0, 0x5d, 0xeb, 0xe4, 0xcb, 0x80, 0x50, 0x1f, 0x5f, 0x01, 0x88, 0xd3, 0x65, 0x99, 0x15,
	0x54, 0x43, 0xf5, 0x62, 0x27, 0xff, 0xef, 0x81, 0x86, 0xf4, 0x62, 0xb4, 0x7e, 0xc7, 0x94, 0xbe,
	0x41, 0x70, 0xe9, 0xae, 0x45, 0x63, 0x2c, 0x8d, 0xc1, 0x93, 0x50, 0x5c, 0x77, 0x6c, 0x73, 0x10,
	0x3b, 0xc6, 0x97, 0xef, 0x98, 0xf8, 0x35, 0x28, 0xba, 0x46, 0x97, 0xac, 0x50, 0x6b, 0x87, 0x54,
	0x46, 0x6a, 0xa8, 0x9e, 0xd3, 0xc7, 0xc2, 0x85, 0xfb, 0xd6, 0x0e, 0xc1, 0x13, 0x00, 0x6c, 0xd3,
	0x77, 0x36, 0x48, 0xaf, 0x92, 0x0b, 0x1d, 0xe8, 0xcc, 0xfc, 0x41, 0xb8, 0x80, 0x5f, 0x81, 0xc2,
	0xba, 0x65, 0xfb, 0xc4, 0xab, 0xe4, 0xd9, 0x56, 0xf4, 0x4f, 0xfa, 0x1a, 0x41, 0x39, 0x4d, 0x87,
	0xba, 0x4e, 0x8f, 0x12, 0xfc, 0x3e, 0x8c, 0xc5, 0x59, 0xac, 0xa0, 0x5a, 0xae, 0x5e, 0x6a, 0x5d,
	0x53, 0x04, 0xaa, 0xae, 0xc4, 0x39, 0xe9, 0xa3, 0xf1, 0x55, 0x78, 0xa9, 0x47, 0x1e, 0xf9, 0x2b,
	0x09, 0x7a, 0x23, 0x8c, 0xc3, 0x8b, 0xe1, 0xf2, 0x52, 0x4c, 0x51, 0xfa, 0x23, 0x07, 0xe5, 0x77,
	0x3d, 0x62, 0xf8, 0xe4, 0x44, 0x5e, 0x05, 0x52, 0x33, 0x0d, 0xf9, 0x9e, 0xb1, 0xc9, 0xb3, 0x52,
	0xec, 0x4c, 0x3e, 0x3d, 0xd0, 0x26, 0xbe, 0x5a, 0x36, 0xe4, 0x9d, 0x87, 0xcb, 0xb2, 0x21, 0xef,
	0x34, 0xe5, 0xf6, 0xc3, 0x5d, 0xed, 0xda, 0x8c, 0xf6, 0x78, 0x39, 0xfa, 0xa7, 0x33, 0x73, 0xfc,
	0x16, 0x94, 0x4c, 0x42, 0xd7, 0x3c, 0xcb, 0x0d, 0x6b, 0xcb, 0xb3, 0xd6, 0x29, 0xee, 0x1d, 0x6a,
	0xa3, 0x0b, 0x37, 0x5a, 0xd3, 0x33, 0x7a, 0x72, 0x17, 0xff, 0x80, 0xa0, 0x60, 0x1b, 0xab, 0xc4,
	0xa6, 0x95, 0x3c, 0x4b, 0xc8, 0xa2, 0x50, 0x42, 0xb2, 0x42, 0x52, 0xee, 0x32, 0x3f, 0x8b, 0x3d,
	0xdf, 0xdb, 0xee, 0xbc, 0xf3, 0xf4, 0x40, 0x2b, 0x2d, 0xcb, 0x2b, 0x4d, 0xb9, 0x1d, 0x32, 0x6e,
	0x3c, 0x39, 0xd4, 0xf2, 0x0b, 0x37, 0x66, 0xde, 0xde, 0xe3, 0xbf, 0xd7, 0xf7, 0x0f, 0xb5, 0x42,
	0x35, 0xaf, 0xc9, 0xec, 0x09, 0xe3, 0x8b, 0x51, 0x5c, 0x7d, 0x7b, 0x3d, 0x62, 0x85, 0x3f, 0x80,
	0xbc, 0x17, 0xd8, 0xa4, 0x32, 0x5a, 0x43, 0xf5, 0x52, 0x4b, 0x1b, 0xa6, 0x5c, 0x8a, 0x1e, 0xd8,
	0x24, 0xca, 0x2a, 0x73, 0x52, 0x6d, 0x43, 0x29, 0x41, 0x12, 0x5f, 0x84, 0xdc, 0x06, 0xd9, 0xe6,
	0xd9, 0xd7, 0xc3, 0x47, 0x5c, 0x86, 0xd1, 0x2d, 0xc3, 0x0e, 0xa2, 0x9c, 0xeb, 0xfc, 0xcf, 0xdc,
	0xc8, 0x2c, 0x92, 0x66, 0x60, 0x3c, 0x15, 0xf4, 0x3d, 0xe2, 0x1b, 0xa6, 0xe1, 0x1b, 0x61, 0x8f,
	0x9e, 0xbc, 0x20, 0xc9, 0xab, 0xf1, 0x53, 0x0e, 0xca, 0x1f, 0xbb, 0xe6, 0x60, 0x03, 0x88, 0x5c,
	0x2c, 0x3c, 0x0f, 0xa5, 0x80, 0x81, 0xd9, 0x84, 0x61, 0xac, 0x4a, 0xad, 0xaa, 0xc2, 0x47, 0x8c,
	0x12, 0x0f, 0x21, 0xe5, 0xbd, 0x70, 0x08, 0xdd, 0x33, 0xe8, 0x86, 0x0e, 0xdc, 0x3c, 0x7c, 0xee,
	0xf7, 0x4f, 0xee, 0x5c, 0xfd, 0x93, 0x17, 0xed, 0x9f, 0xd1, 0x21, 0xfa, 0x27, 0x2b, 0x23, 0xcf,
	0xa5, 0x7f, 0xce, 0x53, 0xf2, 0x05, 0x18, 0x4f, 0xf1, 0xec, 0x97, 0x5c, 0x68, 0x26, 0xce, 0x43,
	0xf9, 0x16, 0xb1, 0xc9, 0x99, 0xea, 0x1e, 0x1e, 0x9d, 0x02, 0x0f, 0x77, 0xf4, 0x1c, 0x5c, 0x5a,
	0x32, 0x02, 0x7a, 0xa6, 0x93, 0xe7, 0xa1, 0x9c, 0xc4, 0x0e, 0x1d, 0xb3, 0x4e, 0x68, 0xb0, 0x79,
	0xd6, 0x98, 0x53, 0xe0, 0xe1, 0x8e, 0xfe, 0x05, 0xc1, 0xe5, 0xc4, 0xcc, 0xff, 0x30, 0x96, 0x3e,
	0x3a, 0xd4, 0x7d, 0x9b, 0x1a, 0x50, 0xa3, 0x0e, 0xfc, 0x77, 0xa0, 0x15, 0x9a, 0xb2, 0xd6, 0x6c,
	0x36, 0x13, 0xca, 0x54, 0x1f, 0x54, 0xa6, 0xf8, 0x8e, 0x68, 0xcd, 0x66, 0x52, 0xa4, 0xa4, 0xb4,
	0x48, 0x75, 0x60, 0xef, 0x50, 0x2b, 0x30, 0xab, 0x66, 0x5f, 0xb0, 0xf6, 0x10, 0x4c, 0x9c, 0x42,
	0x3e, 0x52, 0xae, 0x9b, 0x00, 0x7d, 0x35, 0x8f, 0xb5, 0x6b, 0x32, 0x7d, 0xd5, 0x8e, 0xd5, 0xbe,
	0x8f, 0xd7, 0x13, 0x20, 0x51, 0xc9, 0x6a, 0xfd, 0x59, 0x82, 0x0b, 0x11, 0x91, 0xfb, 0xfc, 0x05,
	0x09, 0x7f, 0x87, 0x20, 0x77, 0x9b, 0xf8, 0x78, 0x46, 0xe8, 0x72, 0x0f, 0xbc, 0x44, 0x54, 0x87,
	0x52, 0x59, 0xa9, 0xf1, 0xe4, 0xef, 0x7f, 0xbe, 0x1d, 0x79, 0x03, 0x4b, 0x59, 0xaf, 0x3c, 0x54,
	0xdd, 0x3d, 0x2e, 0xe3, 0x63, 0xfc, 0x3d, 0x82, 0x7c, 0x98, 0x39, 0x3c, 0x2b, 0x74, 0x44, 0xc6,
	0x4b, 0x4a, 0xb5, 0x7d, 0x06, 0x24, 0xaf, 0x8a, 0x34, 0xc1, 0x98, 0xbe, 0x8a, 0xc7, 0x33, 0x99,
	0xe2, 0x1f, 0x11, 0x14, 0xb8, 0x68, 0xe0, 0xf6, 0x99, 0x65, 0xb5, 0xfa, 0xec, 0x32, 0x4b, 0xb7,
	0xf6, 0x8f, 0x1a, 0xb5, 0xd3, 0x04, 0xea, 0x85, 0x68, 0x81, 0x71, 0xad, 0x4a, 0xd9, 0x5c, 0xe7,
	0x50, 0x03, 0xff, 0x8c, 0xa0, 0xc0, 0x07, 0x9e, 0x20, 0xdd, 0xac, 0x29, 0x2e, 0x42, 0xf7, 0x23,
	0x4e, 0x37, 0x7b, 0xb8, 0xa6, 0xe8, 0x4e, 0xb5, 0x04, 0x9a, 0x20, 0xe4, 0xfe, 0x3b, 0x82, 0x02,
	0x9f, 0x98, 0x82, 0xdc, 0xb3, 0x66, 0xb3, 0x08, 0xf7, 0xcf, 0xf7, 0x8f, 0x1a, 0xca, 0x69, 0xd3,
	0x79, 0xfc, 0xa4, 0x30, 0x2f, 0x6e, 0xba, 0xfe, 0x36, 0x6f, 0xe7, 0x86, 0x48, 0x3b, 0xff, 0x8a,
	0x60, 0x94, 0x8d, 0x5f, 0xc1, 0x7e, 0xce, 0x18, 0xf3, 0x22, 0x41, 0x7c, 0xb2, 0x7f, 0xd4, 0x78,
	0xfd, 0x94, 0x41, 0x9f, 0xca, 0xbf, 0x2c, 0xd5, 0x05, 0xf2, 0xef, 0x86, 0x7e, 0xc2, 0x2a, 0xfc,
	0x86, 0xa0, 0xc0, 0x67, 0xb8, 0x60, 0x15, 0xb2, 0xd4, 0x42, 0x24, 0x80, 0x4f, 0x79, 0x07, 0x65,
	0xeb, 0x45, 0x2a, 0x02, 0x45, 0x7a, 0x53, 0x20, 0x02, 0x8f, 0x39, 0x0a, 0x43, 0xf8, 0x0b, 0xc1,
	0x85, 0xf0, 0xae, 0x1f, 0xcf, 0x60, 0x7c, 0x73, 0xd8, 0x01, 0x31, 0x20, 0x3e, 0xd5, 0xce, 0x79,
	0x5c, 0x44, 0xc3, 0x66, 0x9a, 0xc5, 0xa3, 0x62, 0xf9, 0xd9, 0xf1, 0x1c, 0x7f, 0xf9, 0xd1, 0xce,
	0x2e, 0x4c, 0xa5, 0xce, 0x36, 0x5c, 0xeb, 0x94, 0xf3, 0x3f, 0x5b, 0xea, 0x5a, 0xfe, 0x17, 0xc1,
	0xaa, 0xb2, 0xe6, 0x6c, 0xaa, 0x1c, 0x23, 0xf3, 0x4f, 0xc5, 0xae, 0x23, 0x77, 0x49, 0x8f, 0x75,
	0xb5, 0x2a, 0xf0, 0x79, 0x3a, 0x1f, 0x3f, 0xaf, 0x16, 0x18, 0xe6, 0xfa, 0xff, 0x01, 0x00, 0x00,
	0xff, 0xff, 0xd4, 0xbc, 0x01, 0x93, 0x97, 0x0f, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// TriggerServiceClient is the client API for TriggerService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TriggerServiceClient interface {
	// Returns the specified trigger.
	//
	// To get the list of all available triggers, make a [List] request.
	Get(ctx context.Context, in *GetTriggerRequest, opts ...grpc.CallOption) (*Trigger, error)
	// Retrieves the list of triggers in the specified folder.
	List(ctx context.Context, in *ListTriggersRequest, opts ...grpc.CallOption) (*ListTriggersResponse, error)
	// Creates a trigger in the specified folder.
	Create(ctx context.Context, in *CreateTriggerRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified trigger.
	Update(ctx context.Context, in *UpdateTriggerRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified trigger.
	Delete(ctx context.Context, in *DeleteTriggerRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Pauses the specified trigger.
	Pause(ctx context.Context, in *PauseTriggerRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Restarts the specified trigger.
	Resume(ctx context.Context, in *ResumeTriggerRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists operations for the specified trigger.
	ListOperations(ctx context.Context, in *ListTriggerOperationsRequest, opts ...grpc.CallOption) (*ListTriggerOperationsResponse, error)
}

type triggerServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewTriggerServiceClient(cc grpc.ClientConnInterface) TriggerServiceClient {
	return &triggerServiceClient{cc}
}

func (c *triggerServiceClient) Get(ctx context.Context, in *GetTriggerRequest, opts ...grpc.CallOption) (*Trigger, error) {
	out := new(Trigger)
	err := c.cc.Invoke(ctx, "/yandex.cloud.serverless.triggers.v1.TriggerService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *triggerServiceClient) List(ctx context.Context, in *ListTriggersRequest, opts ...grpc.CallOption) (*ListTriggersResponse, error) {
	out := new(ListTriggersResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.serverless.triggers.v1.TriggerService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *triggerServiceClient) Create(ctx context.Context, in *CreateTriggerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.serverless.triggers.v1.TriggerService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *triggerServiceClient) Update(ctx context.Context, in *UpdateTriggerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.serverless.triggers.v1.TriggerService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *triggerServiceClient) Delete(ctx context.Context, in *DeleteTriggerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.serverless.triggers.v1.TriggerService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *triggerServiceClient) Pause(ctx context.Context, in *PauseTriggerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.serverless.triggers.v1.TriggerService/Pause", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *triggerServiceClient) Resume(ctx context.Context, in *ResumeTriggerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.serverless.triggers.v1.TriggerService/Resume", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *triggerServiceClient) ListOperations(ctx context.Context, in *ListTriggerOperationsRequest, opts ...grpc.CallOption) (*ListTriggerOperationsResponse, error) {
	out := new(ListTriggerOperationsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.serverless.triggers.v1.TriggerService/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TriggerServiceServer is the server API for TriggerService service.
type TriggerServiceServer interface {
	// Returns the specified trigger.
	//
	// To get the list of all available triggers, make a [List] request.
	Get(context.Context, *GetTriggerRequest) (*Trigger, error)
	// Retrieves the list of triggers in the specified folder.
	List(context.Context, *ListTriggersRequest) (*ListTriggersResponse, error)
	// Creates a trigger in the specified folder.
	Create(context.Context, *CreateTriggerRequest) (*operation.Operation, error)
	// Updates the specified trigger.
	Update(context.Context, *UpdateTriggerRequest) (*operation.Operation, error)
	// Deletes the specified trigger.
	Delete(context.Context, *DeleteTriggerRequest) (*operation.Operation, error)
	// Pauses the specified trigger.
	Pause(context.Context, *PauseTriggerRequest) (*operation.Operation, error)
	// Restarts the specified trigger.
	Resume(context.Context, *ResumeTriggerRequest) (*operation.Operation, error)
	// Lists operations for the specified trigger.
	ListOperations(context.Context, *ListTriggerOperationsRequest) (*ListTriggerOperationsResponse, error)
}

// UnimplementedTriggerServiceServer can be embedded to have forward compatible implementations.
type UnimplementedTriggerServiceServer struct {
}

func (*UnimplementedTriggerServiceServer) Get(ctx context.Context, req *GetTriggerRequest) (*Trigger, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedTriggerServiceServer) List(ctx context.Context, req *ListTriggersRequest) (*ListTriggersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedTriggerServiceServer) Create(ctx context.Context, req *CreateTriggerRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (*UnimplementedTriggerServiceServer) Update(ctx context.Context, req *UpdateTriggerRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (*UnimplementedTriggerServiceServer) Delete(ctx context.Context, req *DeleteTriggerRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedTriggerServiceServer) Pause(ctx context.Context, req *PauseTriggerRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Pause not implemented")
}
func (*UnimplementedTriggerServiceServer) Resume(ctx context.Context, req *ResumeTriggerRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Resume not implemented")
}
func (*UnimplementedTriggerServiceServer) ListOperations(ctx context.Context, req *ListTriggerOperationsRequest) (*ListTriggerOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOperations not implemented")
}

func RegisterTriggerServiceServer(s *grpc.Server, srv TriggerServiceServer) {
	s.RegisterService(&_TriggerService_serviceDesc, srv)
}

func _TriggerService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TriggerServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.serverless.triggers.v1.TriggerService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TriggerServiceServer).Get(ctx, req.(*GetTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TriggerService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTriggersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TriggerServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.serverless.triggers.v1.TriggerService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TriggerServiceServer).List(ctx, req.(*ListTriggersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TriggerService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TriggerServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.serverless.triggers.v1.TriggerService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TriggerServiceServer).Create(ctx, req.(*CreateTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TriggerService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TriggerServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.serverless.triggers.v1.TriggerService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TriggerServiceServer).Update(ctx, req.(*UpdateTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TriggerService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TriggerServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.serverless.triggers.v1.TriggerService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TriggerServiceServer).Delete(ctx, req.(*DeleteTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TriggerService_Pause_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PauseTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TriggerServiceServer).Pause(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.serverless.triggers.v1.TriggerService/Pause",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TriggerServiceServer).Pause(ctx, req.(*PauseTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TriggerService_Resume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResumeTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TriggerServiceServer).Resume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.serverless.triggers.v1.TriggerService/Resume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TriggerServiceServer).Resume(ctx, req.(*ResumeTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TriggerService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTriggerOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TriggerServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.serverless.triggers.v1.TriggerService/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TriggerServiceServer).ListOperations(ctx, req.(*ListTriggerOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _TriggerService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.serverless.triggers.v1.TriggerService",
	HandlerType: (*TriggerServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _TriggerService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _TriggerService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _TriggerService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _TriggerService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _TriggerService_Delete_Handler,
		},
		{
			MethodName: "Pause",
			Handler:    _TriggerService_Pause_Handler,
		},
		{
			MethodName: "Resume",
			Handler:    _TriggerService_Resume_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _TriggerService_ListOperations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/serverless/triggers/v1/trigger_service.proto",
}
