# Contributing to Jolie

Thank you for your interest in contributing to Jolie! :+1: :tada:

Jolie is a [community effort](https://github.com/jolie/jolie/graphs/contributors). Contributions and constructive discussions are welcome.

# How can I contribute?

There are many ways in which you can contribute, of which we point out a few below. If you have an idea that does not fall into any of the categories below, do not be discouraged: quite simply, we have probably not thought of it, and we would like to hear from you. See [how to get in touch](https://github.com/jolie/jolie#get-in-touch-wave) and our [list of maintainers](MAINTAINERS.md).

## Code

You can contribute to one of [our code repositories](https://github.com/jolie), or develop a tool or modification in a repository of your own and tell us.

If you want to contribute to the main [Jolie project repository](https://github.com/jolie/jolie), you can find some useful information in [our wiki](https://github.com/jolie/jolie/wiki). See, for example, [how to make a pull request](https://github.com/jolie/jolie/wiki/Pull-requests) and [documentation of the Jolie interpreter](https://github.com/jolie/jolie/wiki/Interpreter-documentation). Make sure to read our [git workflow](https://github.com/jolie/jolie/wiki/Git-Workflow).

We expect pull requests with new code that requires updating the documentation (see below) to come with a link to a corresponding pull request to the documentation repository that provides the appropriate update. If you do not have documentation yet but want to make a pull request anyway to discuss your code before writing documentation, please explicitly state so in the pull request.

## Documentation

You can contribute to the [documentation of Jolie](https://docs.jolie-lang.org) through the related [GitHub repository of our docs](https://github.com/jolie/docs). Possibilities include adding new tutorials (even small ones are rather useful!), improving existing text, or adding new  explanations.

You can also help by writing javadoc in the [source code of our interpreter and its libraries](https://github.com/jolie/jolie).

## Communication and events

Interested in spreading the word or organising an event that includes Jolie? We would be thrilled to help you!

We support the [code of conduct for events of the Microservices Community](https://www.microservices.community/events/coc/). Please have a look, and get in touch with us!

## Teaching

Jolie is taught in a few courses, both in academia and industry. We are happy to share material, and you can contribute by offering yours.

## Website

You can help improve our [website](https://www.jolie-lang.org). You can find its source code at <https://github.com/jolie/website>.

# Get in touch

Discussions can take place over different media.

- Our [GitHub repository](https://github.com/jolie/jolie), in the forms of [issues](https://github.com/jolie/jolie/issues) and [pull requests](https://github.com/jolie/jolie/pulls).
- E-mail, by sending an e-mail to `jolie-devel@googlegroups.com`. Anybody can send to the group. You can also register to the e-mail group at this link: https://groups.google.com/g/jolie-devel.
- Chat or Audio/Video calls. See below for links to our Discord and Slack channels.

### Discord
<p align="center">
	<a href="https://discord.gg/yQRTMNX"><img src="https://www.jolie-lang.org/imgs/discord_logo.png" height="90" alt="Join our Discord server"/></a>
</p>

[Join our Discord server](https://discord.gg/yQRTMNX).
