extern navigator

var Imba = require("../imba")

# 1 - static shape - unknown content
# 2 - static shape and static children
# 3 - single item
# 4 - optimized array - only length will change

def removeNested root, node, caret
	# if node/nodes isa String
	# 	we need to use the caret to remove elements
	# 	for now we will simply not support this
	if node isa Array
		removeNested(root,member,caret) for member in node
	elif node and node.@dom
		root.removeChild(node)
	elif node != null
		# what if this is not null?!?!?
		# take a chance and remove a text-elementng
		let next = caret ? caret:nextSibling : root.@dom:firstChild
		if next isa Text and next:textContent == node
			root.removeChild(next)
		else
			throw 'cannot remove string'

	return caret

def appendNested root, node
	if node isa Array
		let i = 0
		let c = node:taglen
		let k = c != null ? (node:domlen = c) : node:length
		appendNested(root,node[i++]) while i < k
	elif node and node.@dom
		root.appendChild(node)
	elif node != null and node !== false
		root.appendChild Imba.createTextNode(node)

	return


# insert nodes before a certain node
# does not need to return any tail, as before
# will still be correct there
# before must be an actual domnode
def insertNestedBefore root, node, before
	if node isa Array
		let i = 0
		let c = node:taglen
		let k = c != null ? (node:domlen = c) : node:length
		insertNestedBefore(root,node[i++],before) while i < k

	elif node and node.@dom
		root.insertBefore(node,before)
	elif node != null and node !== false
		root.insertBefore(Imba.createTextNode(node),before)

	return before

# after must be an actual domnode
def insertNestedAfter root, node, after
	var before = after ? after:nextSibling : root.@dom:firstChild

	if before
		insertNestedBefore(root,node,before)
		return before:previousSibling
	else
		appendNested(root,node)
		return root.@dom:lastChild

def reconcileCollectionChanges root, new, old, caret

	var newLen = new:length
	var lastNew = new[newLen - 1]

	# This re-order algorithm is based on the following principle:
	# 
	# We build a "chain" which shows which items are already sorted.
	# If we're going from [1, 2, 3] -> [2, 1, 3], the tree looks like:
	#
	# 	3 ->  0 (idx)
	# 	2 -> -1 (idx)
	# 	1 -> -1 (idx)
	#
	# This tells us that we have two chains of ordered items:
	# 
	# 	(1, 3) and (2)
	# 
	# The optimal re-ordering then becomes to keep the longest chain intact,
	# and move all the other items.

	var newPosition = []

	# The tree/graph itself
	var prevChain = []
	# The length of the chain
	var lengthChain = []

	# Keep track of the longest chain
	var maxChainLength = 0
	var maxChainEnd = 0

	var hasTextNodes = no
	var newPos

	for node, idx in old
		# special case for Text nodes
		if node and node:nodeType == 3
			newPos = new.indexOf(node:textContent)
			new[newPos] = node if newPos >= 0
			hasTextNodes = yes
		else
			newPos = new.indexOf(node)

		newPosition.push(newPos)

		if newPos == -1
			root.removeChild(node)
			prevChain.push(-1)
			lengthChain.push(-1)
			continue

		var prevIdx = newPosition:length - 2

		# Build the chain:
		while prevIdx >= 0
			if newPosition[prevIdx] == -1
				prevIdx--
			elif newPos > newPosition[prevIdx]
				# Yay, we're bigger than the previous!
				break
			else
				# Nope, let's walk back the chain
				prevIdx = prevChain[prevIdx]

		prevChain.push(prevIdx)

		var currLength = (prevIdx == -1) ? 0 : lengthChain[prevIdx]+1

		if currLength > maxChainLength
			maxChainLength = currLength
			maxChainEnd = idx

		lengthChain.push(currLength)

	var stickyNodes = []

	# Now we can walk the longest chain backwards and mark them as "sticky",
	# which implies that they should not be moved
	var cursor = newPosition:length - 1
	while cursor >= 0
		if cursor == maxChainEnd and newPosition[cursor] != -1
			stickyNodes[newPosition[cursor]] = true
			maxChainEnd = prevChain[maxChainEnd]

		cursor -= 1

	# possible to do this in reversed order instead?
	for node, idx in new
		if !stickyNodes[idx]
			# create textnode for string, and update the array
			unless node and node.@dom
				node = new[idx] = Imba.createTextNode(node)

			var after = new[idx - 1]
			insertNestedAfter(root, node, (after and after.@dom or after or caret))

		caret = node.@dom or (caret and caret:nextSibling or root.@dom:firstChild)

	# should trust that the last item in new list is the caret
	return lastNew and lastNew.@dom or caret


# expects a flat non-sparse array of nodes in both new and old, always
def reconcileCollection root, new, old, caret
	var k = new:length
	var i = k
	var last = new[k - 1]


	if k == old:length and new[0] === old[0]
		# running through to compare
		while i--
			break if new[i] !== old[i]

	if i == -1
		return last and last.@dom or last or caret
	else
		return reconcileCollectionChanges(root,new,old,caret)

# expects a flat non-sparse array of nodes in both new and old, always
def reconcileIndexedArray root, array, old, caret
	var newLen = array:taglen
	var prevLen = array:domlen or 0
	var last = newLen ? array[newLen - 1] : null
	# console.log "reconcile optimized array(!)",caret,newLen,prevLen,array

	if prevLen > newLen
		while prevLen > newLen
			var item = array[--prevLen]
			root.removeChild(item.@dom)

	elif newLen > prevLen
		# find the item to insert before
		let prevLast = prevLen ? array[prevLen - 1].@dom : caret
		let before = prevLast ? prevLast:nextSibling : root.@dom:firstChild
		
		while prevLen < newLen
			let node = array[prevLen++]
			before ? root.insertBefore(node.@dom,before) : root.appendChild(node.@dom)
			
	array:domlen = newLen
	return last ? last.@dom : caret


# the general reconciler that respects conditions etc
# caret is the current node we want to insert things after
def reconcileNested root, new, old, caret

	# var skipnew = new == null or new === false or new === true
	var newIsNull = new == null or new === false
	var oldIsNull = old == null or old === false


	if new === old
		# remember that the caret must be an actual dom element
		# we should instead move the actual caret? - trust
		if newIsNull
			return caret
		elif new.@dom
			return new.@dom
		elif new isa Array and new:taglen != null
			return reconcileIndexedArray(root,new,old,caret)
		else
			return caret ? caret:nextSibling : root.@dom:firstChild

	elif new isa Array
		if old isa Array
			if new:static or old:static
				# if the static is not nested - we could get a hint from compiler
				# and just skip it
				if new:static == old:static
					for item,i in new
						# this is where we could do the triple equal directly
						caret = reconcileNested(root,item,old[i],caret)
					return caret
				else
					removeNested(root,old,caret)
					
				# if they are not the same we continue through to the default
			else
				return reconcileCollection(root,new,old,caret)
		elif !oldIsNull
			if old.@dom
				root.removeChild(old)
			else
				# old was a string-like object?
				root.removeChild(caret ? caret:nextSibling : root.@dom:firstChild)

		return insertNestedAfter(root,new,caret)
		# remove old

	elif !newIsNull and new.@dom
		removeNested(root,old,caret) unless oldIsNull
		return insertNestedAfter(root,new,caret)

	elif newIsNull
		removeNested(root,old,caret) unless oldIsNull
		return caret
	else
		# if old did not exist we need to add a new directly
		let nextNode
		# if old was array or imbatag we need to remove it and then add
		if old isa Array
			removeNested(root,old,caret)
		elif old and old.@dom
			root.removeChild(old)
		elif !oldIsNull
			# ...
			nextNode = caret ? caret:nextSibling : root.@dom:firstChild
			if nextNode isa Text and nextNode:textContent != new
				nextNode:textContent = new
				return nextNode

		# now add the textnode
		return insertNestedAfter(root,new,caret)


extend tag element

	def setChildren new, typ
		var old = @tree_

		if new === old and new and new:taglen == undefined
			return self

		if !old and typ != 3
			empty
			appendNested(self,new)

		elif typ == 1
			# here we _know _that it is an array with the same shape
			# every time
			let caret = null
			for item,i in new
				# prev = old[i]
				caret = reconcileNested(self,item,old[i],caret)
		
		elif typ == 2
			return self

		elif typ == 3
			# this is possibly fully dynamic. It often is
			# but the old or new could be static while the other is not
			# this is not handled now
			# what if it was previously a static array? edgecase - but must work
			# could we simply do replace-child?
			if new and new.@dom
				empty
				appendChild(new)

			# check if old and new isa array
			elif new isa Array
				if old isa Array
					reconcileNested(self,new,old,null)
				else
					empty
					appendNested(self,new)
				
			else
				text = new
				return self
				
		elif typ == 4
			reconcileIndexedArray(self,new,old,null)

		elif new isa Array and old isa Array
			reconcileNested(self,new,old,null)
		else
			empty
			appendNested(self,new)

		@tree_ = new
		return self

	def content
		@content or children.toArray
	
	def setText text
		if text != @tree_
			var val = text === null or text === false ? '' : text
			(@text_ or @dom):textContent = val
			@text_ ||= @dom:firstChild
			@tree_ = text
		self

# if $web$
# optimization for setText
var proto = Imba.Tag:prototype
var apple = typeof navigator != 'undefined' and (navigator:vendor or '').indexOf('Apple') == 0
if apple
	def proto.setText text
		if text != @tree_
			@dom:textContent = (text === null or text === false ? '' : text)
			@tree_ = text
		return self
# optimization
