<?php
/**
 * BEdita, API-first content management framework
 * Copyright 2020 ChannelWeb Srl, Chialab Srl
 *
 * This file is part of BEdita: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * See LICENSE.LGPL or <http://gnu.org/licenses/lgpl-3.0.html> for more details.
 */

namespace App\Form;

use Cake\Utility\Inflector;

/**
 * Form class provides utilities for \App\Form classes.
 */
class Form
{
    /**
     * Form null value
     */
    public const NULL_VALUE = ':::null:::';

    /**
     * Return method [$className, $methodName], if it's callable.
     * Otherwise, throw \InvalidArgumentException
     *
     * @param string $className The class name
     * @param string $name The method name
     * @param string|null $format The format
     * @return array
     */
    public static function getMethod(string $className, string $name, $format = ''): array
    {
        $methodName = !empty($format) ? $format : Inflector::variable(str_replace('-', '_', $name));
        $method = [$className, $methodName];
        if (is_callable($method)) {
            return $method;
        }

        throw new \InvalidArgumentException(sprintf('Method "%s" is not callable', $methodName));
    }
}
