/**
 * Templates that uses this component (directly or indirectly):
 *  Template/Elements/Form/other_properties.twig
 *  Template/Elements/Form/core_properties.twig
 *  Template/Elements/Form/meta.twig
 *
 * <property-view> component used for ModulesPage -> View
 *
 * Component that wraps group of properties in the object View
 *
 * @prop {Boolean} tabOpen determines whether the property content is visible or not
 * @prop {String} label label of the property view
 *
 */
const API_URL = new URL(BEDITA.base).pathname;
const API_OPTIONS = {
    credentials: 'same-origin',
    headers: {
        'accept': 'application/json',
    }
};

const STORAGE_TABS_KEY = 'tabs_open_' + BEDITA.currentModule.name;
let debouncedSearchPosition = null;

export default {
    components: {
        TreeView: () => import(/* webpackChunkName: "tree-view" */'app/components/tree-view/tree-view'),
        RelationView: () => import(/* webpackChunkName: "relation-view" */'app/components/relation-view/relation-view'),
        ResourceRelationView: () => import(/* webpackChunkName: "resource-relation-view" */'app/components/relation-view/resource-relation-view'),
        MapView: () => import(/* webpackChunkName: "map-view" */'app/components/map-view'),
        DateRange: () => import(/* webpackChunkName: "date-range" */'app/components/date-range/date-range'),
        DateRangesView: () => import(/* webpackChunkName: "date-ranges-view" */'app/components/date-ranges-view/date-ranges-view'),
        HistoryChanges: () => import(/* webpackChunkName: "history-changes" */'app/components/history/history-changes'),
        CoordinatesView: () => import(/* webpackChunkName: "coordinates-view" */'app/components/coordinates-view'),
        TagPicker: () => import(/* webpackChunkName: "tag-picker" */'app/components/tag-picker/tag-picker'),
        KeyValueList: () => import(/* webpackChunkName: "key-value-list" */'app/components/json-fields/key-value-list'),
        StringList: () => import(/* webpackChunkName: "string-list" */'app/components/json-fields/string-list'),
        ObjectProperties: () => import(/* webpackChunkName: "string-list" */'app/components/object-property/object-properties'),
        ObjectPropertyAdd: () => import(/* webpackChunkName: "object-property-add" */'app/components/object-property/object-property-add'),
        Thumbnail:() => import(/* webpackChunkName: "thumbnail" */'app/components/thumbnail/thumbnail'),
        Permission:() => import(/* webpackChunkName: "permission" */'app/components/permission/permission'),
        Permissions:() => import(/* webpackChunkName: "permissions" */'app/components/permissions/permissions'),
        PermissionToggle: () => import(/* webpackChunkName: "permission-toggle" */'app/components/permission-toggle/permission-toggle'),
        LanguageSelector:() => import(/* webpackChunkName: "language-selector" */'app/components/language-selector/language-selector'),
        ClipboardItem: () => import(/* webpackChunkName: "clipboard-item" */'app/components/clipboard-item/clipboard-item'),
        ObjectCategories: () => import(/* webpackChunkName: "object-categories" */'app/components/object-categories/object-categories'),
        PlaceholderList: () => import(/* webpackChunkName: "placeholder-list" */'app/components/placeholder-list/placeholder-list'),
    },

    props: {
        tabOpen: {
            type: Boolean,
            default: false,
        },
        tabName: {
            type: String,
            default: null,
        },
        tabOpenAtStart: {
            type: Boolean,
            default: null,
        },
        isDefaultOpen: {
            type: Boolean,
            default: false,
        },
        preCount: {
            type: Number,
            default: -1,
        },
        uploadableNum: {
            type: String,
            default: '0',
        },
        object: {
            type: Object,
            default: function() {
                return {};
            },
        }
    },

    data() {
        return {
            file: null,
            isOpen: this.isDefaultOpen,
            isLoading: false,
            totalObjects: 0,
            dataList: parseInt(this.uploadableNum) == 0,
            userInfoLoaded: false,
            fileChanged: false,
            searchInPosition: '',
        }
    },

    async mounted() {
        if (this.tabOpenAtStart !== null) {
            this.isOpen = this.tabOpenAtStart;
            return;
        }
        this.isOpen = this.checkTabOpen();
        if (this.preCount >= 0) {
            this.totalObjects = this.preCount;
        }
        // load user info in meta fields (created_by and modified_by )
        if (this.tabName === 'meta' && this.isOpen) {
            await this.loadInfoUsers();
        }
    },

    watch: {
        tabOpen() {
            this.isOpen = this.tabOpen;
        },
        isOpen() {
            if (this.tabName === 'meta' && this.isOpen && !this.userInfoLoaded) {
                this.loadInfoUsers();
            }
        }
    },

    methods: {
        toggleVisibility() {
            this.isOpen = !this.isOpen;
            this.searchInPosition = '';
            this.checkLoadRelated();
            this.updateStorage();
        },
        onToggleLoading(status) {
            this.isLoading = status;
        },
        onCount(n, force = false) {
            if (this.totalObjects === 0 || force) {
                this.totalObjects = n;
            }
        },
        switchBlockView() {
            this.dataList = false;
        },
        switchListView() {
            this.dataList = true;
        },
        checkTabOpen() {
            if (!this.tabName) {
                return false;
            }
            let tabs = this.readTabsOpen();
            return (tabs.indexOf(this.tabName) >= 0);
        },
        readTabsOpen() {
            if (localStorage.getItem(STORAGE_TABS_KEY)) {
                return JSON.parse(localStorage.getItem(STORAGE_TABS_KEY));
            }
            // if `isDefaultOpen` is true, on the first access, this tab is saved as open
            // Note: there can be only one tab having `tabName` and `isDefaultOpen` set as true
            if (this.isDefaultOpen) {
                localStorage.setItem(STORAGE_TABS_KEY, JSON.stringify([this.tabName]));
                return [this.tabName];
            };

            return [];
        },
        updateStorage() {
            if (!this.tabName) {
                return;
            }
            let tabs = this.readTabsOpen();
            const pos = tabs.indexOf(this.tabName);
            if (this.isOpen && pos < 0) {
                tabs.push(this.tabName);
            } else if (!this.isOpen && pos >= 0) {
                tabs.splice(pos, 1);
            }
            localStorage.setItem(STORAGE_TABS_KEY, JSON.stringify(tabs));
        },
        checkLoadRelated() {
            if (this.isOpen && this.$refs.relation) {
                this.$refs.relation.loadRelatedObjects();
            }
        },
        async loadInfoUsers() {
            this.isLoading = true;

            if (BEDITA.canReadUsers) {
                const creatorId = this.object?.meta?.created_by;
                const modifierId = this.object?.meta?.modified_by;
                const usersId = [creatorId, modifierId];
                const userRes = await fetch(`${API_URL}api/users?filter[id]=${usersId.join(',')}&fields[users]=name,surname,username`, API_OPTIONS);
                const userJson = await userRes.json();
                const users = userJson.data;

                users.map((user) => {
                    const href = `${BEDITA.base}/view/${user.id}`;
                    const userInfo = (user.attributes.name  != undefined || user.attributes.surname != undefined)
                        ? user.attributes.name + ' ' + user.attributes.surname
                        : user.attributes.username;

                    // using == because user.id String and creatorById Number
                    if(user.id == creatorId && userInfo!= undefined) {
                        document.querySelector('td[name=\'created_by\']').innerHTML = `<a href="${href}">${userInfo}</a>`;
                    }

                    if (user.id == modifierId && userInfo!= undefined) {
                        document.querySelector('td[name=\'modified_by\']').innerHTML = `<a href="${href}">${userInfo}</a>`;
                    }
                });
            }

            this.isLoading = false;
            this.userInfoLoaded = true;
        },
        previewImage(thumb) {
            return this.$helpers.updatePreviewImage(this.file, 'title', thumb);
        },
        fileAcceptMimeTypes(type) {
            return this.$helpers.acceptMimeTypes(type);
        },
        async onFileChange(e, type) {
            const files = e.target.files || e.dataTransfer.files;
            if (this.$helpers.checkMimeForUpload(files[0], type) === false) {
                return;
            }
            if (type === 'images') {
                this.$helpers.checkImageResolution(e.target.files[0]);
            }
            if (this.$helpers.checkMaxFileSize(files[0]) === false) {
                return;
            }
            this.file = files[0];
            this.fileChanged = true;
        },
        resetFile(thumb) {
            document.getElementById('fileUpload').value = '';
            this.file = null;
            this.fileChanged = false;
            if (thumb && document.getElementById('imageThumb')) {
                document.getElementById('imageThumb').src = thumb;
            }
        },

        onSearchPosition(e) {
            if (!debouncedSearchPosition) {
                debouncedSearchPosition = this.$helpers.debounce((val) => {
                    this.searchInPosition = val.length < 3 ? '' : val;
                }, 300);
            }

            return debouncedSearchPosition(e.target.value);
        },
    }
}
