/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.platform.comapi.map;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Parcelable;
import com.baidu.platform.comapi.map.InnerOverlay;
import com.baidu.platform.comapi.map.OverlayLocationData;
import com.baidu.platform.comjni.map.basemap.AppBaseMap;
import com.baidu.platform.comjni.tools.ParcelItem;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class LocationOverlay
extends InnerOverlay {
    private AppBaseMap a;

    public LocationOverlay() {
        super(7);
    }

    public LocationOverlay(AppBaseMap appBaseMap) {
        super(7, appBaseMap);
        this.a = appBaseMap;
    }

    @Override
    public String getLayerTag() {
        return "location";
    }

    @Override
    public boolean getDefaultShowStatus() {
        return true;
    }

    public void setLocationLayerData(List<OverlayLocationData> list) {
        if (list == null || list.size() <= 0 || this.mLayerID == 0L) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("locationaddr", this.mLayerID);
        ArrayList<ParcelItem> arrayList = new ArrayList<ParcelItem>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            OverlayLocationData overlayLocationData = list.get(i2);
            if (overlayLocationData.getImage() == null) {
                return;
            }
            ParcelItem parcelItem = new ParcelItem();
            Bitmap bitmap = overlayLocationData.getImage();
            Bundle bundle2 = new Bundle();
            ByteBuffer byteBuffer = ByteBuffer.allocate(bitmap.getWidth() * bitmap.getHeight() * 4);
            bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
            byte[] byArray = byteBuffer.array();
            bundle2.putByteArray("imgbin", byArray);
            bundle2.putInt("w", overlayLocationData.getImgWidth());
            bundle2.putInt("h", overlayLocationData.getImgHeight());
            bundle2.putInt("rotation", overlayLocationData.isRotation());
            bundle2.putString("name", overlayLocationData.getImgName());
            parcelItem.setBundle(bundle2);
            arrayList.add(parcelItem);
        }
        if (arrayList.size() > 0) {
            Parcelable[] parcelableArray = new ParcelItem[arrayList.size()];
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                parcelableArray[i3] = (ParcelItem)arrayList.get(i3);
            }
            bundle.putParcelableArray("imagedata", parcelableArray);
        }
        this.a.SetLocationLayerData(bundle);
    }

    public void clearLocationLayerData(Bundle bundle) {
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putLong("locationaddr", this.mLayerID);
        this.a.ClearLocationLayerData(bundle);
    }

    public void beginLocationLayerAnimation() {
        this.a.BeginLocationLayerAnimation();
    }
}

