/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.baidu.mapsdkplatform.comapi.util.SysUpdateObservable;

public class NetworkUtil {
    public static void updateNetworkProxy(Context context) {
        SysUpdateObservable.getInstance().updateNetworkProxy(context);
    }

    public static boolean isWifiConnected(NetworkInfo networkInfo) {
        boolean bl = false;
        try {
            if (networkInfo != null) {
                bl = 1 == networkInfo.getType() && networkInfo.isConnected();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public static boolean initConnectState() {
        return true;
    }

    public static NetworkInfo getActiveNetworkInfo(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        try {
            networkInfo = connectivityManager.getActiveNetworkInfo();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return networkInfo;
    }

    public static String getCurrentNetMode(Context context) {
        int n2 = 0;
        NetworkInfo networkInfo = NetworkUtil.getActiveNetworkInfo(context);
        if (null != networkInfo) {
            if (networkInfo.getType() == 1) {
                n2 = 1;
            } else {
                if (Build.VERSION.SDK_INT > 29) {
                    String string = "mobile";
                    ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                    if (connectivityManager == null) {
                        return string;
                    }
                    Network network = connectivityManager.getActiveNetwork();
                    NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(network);
                    if (networkCapabilities != null) {
                        boolean bl = networkCapabilities.hasTransport(1);
                        boolean bl2 = networkCapabilities.hasTransport(0);
                        boolean bl3 = networkCapabilities.hasTransport(3);
                        boolean bl4 = networkCapabilities.hasTransport(6);
                        boolean bl5 = networkCapabilities.hasTransport(4);
                        boolean bl6 = networkCapabilities.hasTransport(5);
                        if (bl) {
                            string = "WIFI";
                        } else if (bl2) {
                            string = "CELLULAR";
                        } else if (bl3) {
                            string = "ETHERNET";
                        } else if (bl4) {
                            string = "LoWPAN";
                        } else if (bl5) {
                            string = "VPN";
                        } else if (bl6) {
                            string = "WifiAware";
                        }
                    }
                    return string;
                }
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                if (null == telephonyManager) {
                    return Integer.toString(n2);
                }
                int n3 = telephonyManager.getNetworkType();
                switch (n3) {
                    case 11: {
                        n2 = 2;
                        break;
                    }
                    case 13: {
                        n2 = 4;
                        break;
                    }
                    case 4: {
                        n2 = 5;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 6;
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 12: {
                        n2 = 7;
                        break;
                    }
                    case 8: {
                        n2 = 8;
                        break;
                    }
                    case 3: 
                    case 9: 
                    case 10: 
                    case 15: {
                        n2 = 9;
                        break;
                    }
                    case 14: {
                        n2 = 10;
                        break;
                    }
                }
            }
        }
        return Integer.toString(n2);
    }

    public static boolean isNetworkAvailable(Context context) {
        try {
            if (NetworkUtil.isWifiConnected(context)) {
                return true;
            }
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnectedOrConnecting();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isWifiConnected(Context context) {
        if (context == null) {
            return false;
        }
        boolean bl = false;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager != null) {
            try {
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                if (networkInfo != null) {
                    bl = 1 == networkInfo.getType() && networkInfo.isConnected();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }
}

